<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Main login page.
 *
 * @package    core
 * @subpackage auth
 * @copyright  1999 onwards Martin Dougiamas  http://dougiamas.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');
GLOBAL $USER,$DB;
$name = 'categories List';
$url = new moodle_url("/local/managecoursecategories/index.php");

$PAGE->set_title($name);
$PAGE->set_heading($name);

$result=$DB->get_records_sql("SELECT * FROM {course_categories}"); 
$course_select=''; 
foreach($result as $record) {

    $course_select .= '<tbody><tr class="" >
<td class="cell " style=""><div style="margin-left:0px"><i class="fa"></i><a href="#">'.$record->name.'</a><p style="font-weight:bold"></p><p></p></div></td>
<td class="cell c2 lastcol" style=""><a href="./add_course.php?id='.$record->id.'" title="assign course"><img src="./images/edit.png" height="20" width="20"></a>&nbsp;&nbsp;
<a href="./assign_categories.php?id='.$record->id.'" title="assign  categories"><img src="./images/manage_users.png" height="20" width="20"></a>
</td>

</tr>

</tbody>';
}


if($course_select=='') { //if no course found 
    $course_select = "<option disabled='disabled'> No course found </option>";
}



echo $OUTPUT->header();
?>
<section id="region-main" class="has-blocks mb-3" aria-label="Content">

                    <span class="notifications" id="user-notifications"></span>
                   <div class="singlebutton">
    <form method="get" action="#">
 
        <button type="button" class="btn btn-secondary" id="" title="">Add new categories</button>
    </form>
</div><table class="table table-striped table-hover">
<thead>
<tr>
<th class="header c0" style="" scope="col">Name</th>
    
<th class="header c2 lastcol" style="" scope="col">Actions</th>
</tr>
</thead>
<tbody>
    <?php echo $course_select ?>

</tbody>
</table>
</div>
                    
                    

                </section>



<?php
echo $OUTPUT->footer();