<?php
/**
 * Test table class to be put in test_table.php of root of Moodle installation.
 *  for defining some custom column names and proccessing
 * Username and Password feilds using custom and other column methods.
 */
class test_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
  

    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('loginid','title', 'attempts', 'lastattempt','totalseat','avgseat','maxscore','lessonstatus');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('Login ID.','Title','Attempts', 'Last Attempt Time', 'Total Seat Time(in minutes)','Avg Seat Time(in minutes)','Max Score','Lesson Status');
        $this->define_headers($headers);
    }


 
    function col_loginid($values) {
         global $DB,$CFG;
         $useremail = $DB->get_record_sql("SELECT email from {user} where id=$values->userid");
        if ($this->is_downloading()) {
          

            return $useremail->email;
        } else {
            return $useremail->email;
        }
        
    } 

    
    function col_lastattempt($values) {
        if ($this->is_downloading()) {
            return date('d/m/y h:i',$values->timemodified);
        } else {
            return date('d/m/y h:i',$values->timemodified);
        }
    }


    function col_totalseat($values) {
        global $DB,$CFG;
    

        $totaluser = $DB->get_record_sql("SELECT SUM(TIME_TO_SEC(value))/60 as total  from {scorm_scoes_track} where scormid=$values->scormid and element='cmi.core.total_time'");
        $totaltime = $totaluser->total;
        
                if ($this->is_downloading()) {
                    return $totaluser->total;
                } else {
                    return $totaluser->total;
                }
    }
    function col_avgseat($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->email;
        } else {
            return $values->email;
        }
    }
    function col_maxscore($values) {
        global $DB,$CFG;
    

        $totaluser = $DB->get_record_sql("SELECT value as total  from {scorm_scoes_track} where scormid=$values->scormid and element='cmi.core.score.raw'");
        $totaltime = $totaluser->total;
        
        
                if ($this->is_downloading()) {
                    if($totaltime==''){
                        return '-';
                    }else{

                    return $totaluser->total;
                    }
                } else {
                    if($totaltime==''){
                        return '-';
                    }else{

                    return $totaluser->total;
                    }
                }
    }
    function col_lessonstatus($values) {
        global $DB,$CFG;
       
        if ($this->is_downloading()) {
            return $values->value;
        } else {
            return $values->value;
        }
    }



    /**
     * This function is called for each data row to allow processing of
     * columns which do not have a *_cols function.
     * @return string return processed value. Return NULL if no change has
     *     been made.
     */
    function col_title($values) {
     global $DB,$CFG;
     $title = $DB->get_record_sql("SELECT name from {scorm}  where id=$values->scormid");
        if ($this->is_downloading()) {
            
            return $title->name;
        } else {
            return $title->name;
        }
    }
    function col_attempts($values) {
        global $DB,$CFG;
        $attempts = $DB->get_record_sql("SELECT sum(attempt) as total from {scorm_scoes_track} where scormid=$values->scormid and userid=$values->userid");
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $attempts->total;
        } else {
            return $attempts->total;
        }
    }
}