<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * agreement.php - Displays Ouriginal agreement to student
 *
 * @package    plagiarism_similarity
 * @author     Dan Marsden
 * @copyright  2021 Catalyst IT
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

 require_once(dirname(dirname(__FILE__)) . '/../config.php');
 require_once($CFG->libdir.'/adminlib.php');
 require_once($CFG->libdir.'/tablelib.php');
 require_once($CFG->dirroot.'/plagiarism/similarity/lib.php');

global $CFG, $OUTPUT, $PAGE;
echo $OUTPUT->header();


require_login();
$currenttab = 'similarityallfiles';

require_once('similarity_tabs.php');
plagiarism_similarity_checkcronhealth();

$url = new moodle_url('/plagiarism/similarity/allfiles.php');
admin_externalpage_setup('plagiarismsimilarity', '', array(), $url);

$PAGE->set_title('allfiles');
$PAGE->set_heading('allfiles');
$c = new curl(array('proxy' => true));
$c->setopt(array('CURLOPT_RETURNTRANSFER' => 1,
    'CURLOPT_TIMEOUT' => 60, // Set to 60seconds just in case.
    'CURLOPT_HTTPAUTH' => CURLAUTH_BASIC
));
$api = get_config('plagiarism_similarity', 'api');
$header = array();
$header[] = "Content-Type: application/json";
$header[] = "x-doco-apikey: $api";
$c->setHeader($header);
$baseurl = 'https://www.docoloc.de/rv1';
$html = $c->get($baseurl .'/jobs');
$data = json_decode($html);
$content = [];
foreach($data->jobs as $jobs) {
    $linedata = array('id' => $jobs->id, 'name' => $jobs->name, 'url' => $jobs->url, 'email' => $jobs->email, 'type' => $jobs->type, 'size' => $jobs->size, 'time' => $jobs->time, 'pages' => $jobs->pages, 'rate' => $jobs->rate, 'progress' => $jobs->progress, 'status' => $jobs->status);
    $content[] = $linedata;
}
echo $OUTPUT->render_from_template('plagiarism_similarity/allfiles', array('content' => $content));
echo $OUTPUT->footer();
