<?php
/**
 * Test table class to be put in test_table.php of root of Moodle installation.
 *  for defining some custom column names and proccessing
 * Username and Password feilds using custom and other column methods.
 */
class test_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('Loginid', 'Registrationdate', 'Region','name');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('Login ID', 'Registration Date', 'Region','Name');
        $this->define_headers($headers);
    }

    /**
     * This function is called for each data row to allow processing of the
     * username value.
     *
     * @param object $values Contains object with all the values of record.
     * @return $string Return username with link to profile or username only
     *     when downloading.
     */
    function col_Loginid($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->email;
        } else {
            return $values->email;
        }
    }

    /**
     * This function is called for each data row to allow processing of
     * columns which do not have a *_cols function.
     * @return string return processed value. Return NULL if no change has
     *     been made.
     */
    function col_Region($values) {
        $countries = get_string_manager()->get_list_of_countries();

            $user_region = $values->country;
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            
            return $countries[$user_region];
        } else {
            return $countries[$user_region];
        }
    }
    function col_Registrationdate($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return date('m/d/y',$values->timecreated);
        } else {
            return date('m/d/y',$values->timecreated);
        }
    }

    function col_name($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $values->firstname;
        } else {
            return $values->firstname;
        }
    }

}
