<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Admin Bookmarks Block page.
 *
 * @package    block_admin_bookmarks
 * @copyright  2011 Moodle
 * @author     2006 vinkmar
 *             2011 Rossiani Wijaya (updated)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * The admin bookmarks block class
 */
require_once($CFG->dirroot . '/blocks/moodleblock.class.php');
class block_simplehtml extends block_base {

    /** @var string */
    public $blockname = null;

    /** @var bool */
    protected $contentgenerated = false;

    /** @var bool|null */
    protected $docked = null;

    /**
     * Set the initial properties for the block
     */
    function init() {
        $this->blockname = get_class($this);
        $this->title = 'Enrolled Courses';
    }

    /**
     * All multiple instances of this block
     * @return bool Returns false
     */
    function instance_allow_multiple() {
        return false;
    }

    /**
     * Set the applicable formats for this block to all
     * @return array
     */
    function applicable_formats() {
        return array('all' => true);
    }

    /**
     * Gets the content for this block
     */
    public function get_content() {
		global $CFG,$DB,$USER;
		if ($this->content !== null) {
		  return $this->content;
		}
	 
		$this->content         =  new stdClass;
		// $this->content->footer = 'Footer here...';
	 
		
		$this->content->text = "<div class='row'>

										<div class='col-md-12 text-right' style='border-top:7px solid #3fcbda;'>
                                        <h5 id='instance-18-header' class='card-title d-inline' style='float:left; margin-top:20px;'>Enroll courses </h5>
                                  
                                        <select name='cars' onchange='changedata(this)' id='cars' style='    margin: 1%;
                                        padding: 0px 10px;'><i class='arrow right'></i>
                                        <option class='rad' value='All'>All</option>
                                        <option class='rad' value='In Progress'>In Progress</option>
                                        <option class='rad' value='Not Started'>Not Started</option>
                                        <option class='rad' value='Started'>Started</option>
                                      </select>
                                     
                                        
											<button id='list-toggle' class='btn btn-secondary'>
												<i class='fa fa-list' aria-hidden='true'></i>
											</button>
										</div>
									</div>
                                    <style>
                                    .rad
                                    {
                                        border-radius:0px;
                                    }
                                    </style>
                                    <script>
                                    function changedata(val)
                                    {
                                        
                                        alert(val.value);
                                    }
                                    </script>
                                    ";
		// $this->content->text = "";


$courses=enrol_get_all_users_courses($USER->id);
$courseid_array=array();
$catid_array=array();

foreach($courses as $course) {
    $courseid_array[]=$course->id; //get arrays of ids of courses and categories the user is enrolled in
    $catid_array[]=$course->category;
}

$catid_array = array_unique($catid_array); //remove duplicate entries








////////////////////////


$result1 = $DB->get_records('course_categories',array('depth'=>1)); //get all top level categories

$printable_categories=array(); //array to store records of all categories to be printed

foreach($result1 as $record1) { //for each level 1 category

    $params = array($record1->path,        //path of the category itself
        "$record1->path/%"       //path pattern of descendents
        );

    $sql = "SELECT * from {course_categories}
        WHERE path = ? || path LIKE ?";

    $result2=$DB->get_records_sql($sql, $params);  //get the category itself and its decendents

    $flag=0;

    foreach($result2 as $record2) { //for each of them

        if(in_array($record2->id, $catid_array)) {
            $flag=1; //if the category itself or any of its descendents is in list
        }

    }

    if($flag==1) {
        $printable_categories[]= clone $record1; //category is to be printed, append to array
    }

}


///////////////////////







if(count($printable_categories) > 0) {
    
    foreach($printable_categories as $category) {       

        $this->content->text .= "<div>

            <div class='category-block' style='margin-top:10px;'>

                <span class='accordion unfetched triangle-right' id='$category->id' data-depth='0' style='cursor: pointer;'> 
                    <img src='../blocks/simplehtml/images/righttriangle.png' style='width: 12px; height: 12px; margin-bottom: 5px;margin-right: 3px;'>
                </span>

                <span>
                    <h3 class='categoryname' style='display:inline;'>
                        <span class='accordion' id='$category->id' style='cursor:pointer;'>$category->name</span>
                    </h3>
                </span>

                <span>
                    <img id='" . $category->id . "_loader' src='../blocks/simplehtml/images/loader.gif' style='display: none; width: 17px; margin-bottom: 8px;'>
                </span>

                <div id='" . $category->id . "_child'></div>
                
            </div>
            
        </div>

        <input type='hidden' id='extra_classes' class='courseparent'>

        ";

    }

}

  $this->content->text .= "

<script src='https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js'></script>
<script>
	$('document').ready(function(){
		$('#list-toggle').click(function(){
			$('.courseparent').toggleClass('newintro');
		});
	});
</script>
  <script>
$(document).ready(function() {

    $(document).on('click', '.accordion', function() { //click() function doesn't work on dynamic html created later 
        
        var catid = $(this).attr('id');
    
        animateHierarchy(catid);
        catid=true;
        
    });
function change(cat)
{
    animateHierarchy(cat);
    catid=true;
}
    function animateHierarchy(catid) {  
      
        if($('#'+catid).hasClass('closed')) {
            console.log('ook');
            $('#'+catid + '_child').slideDown('fast'); //slide the div containing children down
            $('#'+catid).removeClass('closed'); //toggle class
            $('#'+catid).addClass('opened');


            $('#'+catid).children('img').attr('src', '../blocks/simplehtml/images/downtriangle.png');

        
        } else if($('#'+catid).hasClass('opened')) {
            console.log('ook2');
            $('#'+catid + '_child').slideUp('fast'); //slide the div containing children up
            $('#'+catid).removeClass('opened'); //toggle class
            $('#'+catid).addClass('closed');
        
            $('#'+catid).children('img').attr('src', '../blocks/simplehtml/images/righttriangle.png');

        } else if($('#'+catid).hasClass('unfetched')) {  
            console.log('ook3');
            $('#' + catid + '_loader').show(); //show the loader

            var depth = $('#'+catid).attr('data-depth');

            var extra_classes = $('#extra_classes').attr('class');

            var request = $.ajax({  //get data through ajax 
                
                url: '../blocks/simplehtml/fetch.php',
                type: 'GET',
                data: { catid: catid, depth: depth, extra_classes: extra_classes }
                
            });

            request.done(function(data) { 
                $('#' + catid + '_child').html(data); 
                $('#' + catid + '_loader').hide(); 
                $('#'+catid).children('img').attr('src', '../blocks/simplehtml/images/downtriangle.png'); 
                console.log('ook4');
                $('#'+catid + '_child').slideDown('fast'); 
                $('#'+catid).addClass('opened'); 
            });

            request.fail(function(xhr, textStatus) { //on failure 
                alert('Something went wrong.Error => '
                     + xhr.responseText); //alert the error 
            });
            
        } //else if
        
    } //animateHierarchy function()   
    
});
</script>

<style>
.newintro{
	display:block;
}
.accordion,.categoryname
{
    font-size: 20px;

}
</style>
";




		
		return $this->content;
	}

    /**
     * Returns the role that best describes the admin bookmarks block.
     *
     * @return string
     */
    public function get_aria_role() {
        return 'navigation';
    }
}


