<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Main login page.
 *
 * @package    core
 * @subpackage auth
 * @copyright  1999 onwards Martin Dougiamas  http://dougiamas.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');
require_once(__DIR__ . '/form_process_catergories.php');
GLOBAL $USER,$DB;
$name = 'Categorie assign';
$url = new moodle_url("/local/managecoursecategories/index.php");



$categories_id = required_param('id', PARAM_INT);



$PAGE->set_context(context_system::instance());
$PAGE->set_url('/local/managecoursecategories/assign_categories.php', array('id'=>$categories_id));
$PAGE->set_title($name);
$PAGE->set_heading($name);
 
//get all course
$result=$DB->get_records_sql("SELECT * FROM {user} u where u.id not in(select user_id from {categories_assgin} cc where cc.categorie_id=$categories_id)"); //get records of all course
$user_select=''; 
foreach($result as $record) {
	$user_select .= "<option value='$record->id'> $record->firstname ($record->username) </option>";
}
if($user_select=='') { //if no user found 
	$user_select = "<option disabled='disabled'> No user found </option>";
}

//get all categories selected user
$user_result=$DB->get_records_sql("SELECT * FROM {user} u where u.id  in(select user_id from {categories_assgin} cc where cc.categorie_id=$categories_id)"); //get records of all course
$users_selected=''; 
foreach($user_result as $record) {
	$users_selected .= "<option value='$record->id'> $record->firstname ($record->username) </option>";
}
if($users_selected=='') { //if no course found 
	$users_selected = "<option disabled='disabled'> No categories found </option>";
}



echo $OUTPUT->header();
?>
<form method="get" action="./index.php">
 
        <button type="submit" class="btn btn-secondary" id="" title="">Home</button>
    </form>

<form id="assignform" method="post" action="./assign_categories.php?id=<?php echo $categories_id?>"><div>

  <input type="hidden" name="catid" value="<?php echo $categories_id; ?>">
  <!-- hidden element to store deptid -->

  <table summary="" class="roleassigntable generaltable generalbox boxaligncenter" cellspacing="0">
    <tbody><tr>
      <td id="existingcell">
          <p><label for="removeselect">Existing user</label></p>
          

	<div class="userselector" id="id_existing_wrapper">
		
		<div class="positioned">

			<select name="existing_select[]" id="id_existing_select" multiple="multiple" size="10" class="form-control no-overflow">
			   
				<optgroup id="id_existing_optgroup" label="Existing user">
					
				<?php echo $users_selected ?>
				</optgroup>

			</select>

			<div class="load" id="id_existing_load" style="display:none"></div>

		</div>
	
		
	</div>	

	      </td>
      <td id="buttonscell">
          <div id="addcontrols">
              <input name="add" id="add" type="submit" value="◄&nbsp;Add" title="Add"><br>
			  <!----------------------- central selects -->
          </div>

          <div id="removecontrols">
              <input name="remove" id="remove" type="submit" value="Remove&nbsp;►" title="Remove">
          </div>
      </td>
      <td id="potentialcell">
          <p><label for="addselect">User list</label></p>
          

	<div class="userselector" id="id_potential_wrapper">
		
		<div class="positioned">

			<select name="potential_select[]" id="id_potential_select" multiple="multiple" size="10" class="form-control no-overflow">
			   
				<optgroup id="id_potential_optgroup" label="User list">
				<?php echo $user_select ?>
				</optgroup>

			</select>

			<div class="load" id="id_potential_load" style="display:none"></div>

		</div>
		
		
		
	</div>	

	      </td>
    </tr>
  </tbody></table>
</div></form>

<?php
echo $OUTPUT->footer();

?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

<script src="search.js"></script> <!-- echo time to prevent caching --> 

<link rel="stylesheet" type="text/css" href="custom.css">