<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Main login page.
 *
 * @package    core
 * @subpackage auth
 * @copyright  1999 onwards Martin Dougiamas  http://dougiamas.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');
require_once(__DIR__ . '/form_process.php');
GLOBAL $USER,$DB;
$name = 'Categorie';
$url = new moodle_url("/local/managecoursecategories/index.php");



$categories_id = required_param('id', PARAM_INT);



$PAGE->set_context(context_system::instance());
$PAGE->set_url('/local/managecoursecategories/index.php', array('id'=>$categories_id));
$PAGE->set_title($name);
$PAGE->set_heading($name);

//$result_not=$DB->get_record_sql("SELECT group_concat(courseid) FROM {course_categories} cc where cc.id=$categories_id"); 
//get all course
$result=$DB->get_records_sql("SELECT * FROM {course} c where c.id not in(select course_id from {course_categories_copy} cc where cc.categorie_id=$categories_id) and c.visible=1 and c.category!=$categories_id"); //get records of all course
$course_select=''; 
foreach($result as $record) {
	$course_select .= "<option value='$record->id'> $record->fullname ($record->shortname) </option>";
}
if($course_select=='') { //if no course found 
	$course_select = "<option disabled='disabled'> No course found </option>";
}

//get all course selected
$result=$DB->get_records_sql("SELECT * FROM {course} c where c.id  in(select course_id from {course_categories_copy} cc where cc.categorie_id=$categories_id) and c.visible=1"); //get records of all course
$course_selected=''; 
foreach($result as $record) {
	$course_selected .= "<option value='$record->id'> $record->fullname ($record->shortname) </option>";
}
if($course_select=='') { //if no course found 
	$course_selected = "<option disabled='disabled'> No course found </option>";
}



echo $OUTPUT->header();
?>
<form method="get" action="./index.php">
 
        <button type="submit" class="btn btn-secondary" id="" title="">Home</button>
    </form>


<form id="assignform" method="post" action="./add_course.php?id=<?php echo $categories_id?>"><div>

  <input type="hidden" name="catid" value="<?php echo $categories_id; ?>">
  <!-- hidden element to store deptid -->

  <table summary="" class="roleassigntable generaltable generalbox boxaligncenter" cellspacing="0">
    <tbody><tr>
      <td id="existingcell">
          <p><label for="removeselect">Existing course</label></p>
          

	<div class="userselector" id="id_existing_wrapper">
		
		<div class="positioned">

			<select name="existing_select[]" id="id_existing_select" multiple="multiple" size="10" class="form-control no-overflow">
			   
				<optgroup id="id_existing_optgroup" label="Existing course">
					
				<?php echo $course_selected ?>
				</optgroup>

			</select>

			<div class="load" id="id_existing_load" style="display:none"></div>

		</div>
	
		
	</div>	

	      </td>
      <td id="buttonscell">
          <div id="addcontrols">
              <input name="add" id="add" type="submit" value="◄&nbsp;Add" title="Add"><br>
			  <!----------------------- central selects -->
          </div>

          <div id="removecontrols">
              <input name="remove" id="remove" type="submit" value="Remove&nbsp;►" title="Remove">
          </div>
      </td>
      <td id="potentialcell">
          <p><label for="addselect">Course list</label></p>
          

	<div class="userselector" id="id_potential_wrapper">
		
		<div class="positioned">

			<select name="potential_select[]" id="id_potential_select" multiple="multiple" size="10" class="form-control no-overflow course-items-mai">
			   
				<optgroup id="id_potential_optgroup" label="course list">
				<?php echo $course_select ?>
				</optgroup>

			</select>

			<div class="load" id="id_potential_load" style="display:none"></div>

		</div>
		
		<div class="form-inline" id="yui_3_17_2_1_1678876634515_21">
		
			<label>search</label>

			<input type="text" id="input-search" class="sa-search__input" placeholder="Search"
              autocomplete="off">
			
			<div class="form-inline">
		
				<input type="submit" name="potential_clearbutton" id="id_potential_clearbutton" value="clear" class="btn btn-secondary">
		
			</div>
		
		</div>
		
	</div>	

	      </td>
    </tr>
  </tbody></table>
</div></form>

<?php
echo $OUTPUT->footer();

?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>

<script >
	$(document).ready(function(){
  $("#input-search").on("keyup", function() {
  
    var value = $(this).val().toLowerCase();
    $("#id_potential_optgroup option").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });

});


</script> <!-- echo time to prevent caching --> 

<link rel="stylesheet" type="text/css" href="custom.css">