<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package   local_awsplugin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require('../../config.php');
require('aws/aws-autoloader.php');

require_login();
use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;

// AWS Info.
$bucketname = 'manohartest2401';
$iamkey = 'AKIAQQ6EI6BT57K4KVVT';
$iamsecret = '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';


global $DB;

if (isset($_GET['url'])) {
    $filename = $_GET['name'];
    $filepath = $_GET['url'];
    $contextid = $_GET['contextid'];
    $moduleid = $_GET['module_id'];
    $objectid = $_GET['objectid'];
}
// Connect to AWS.
try {
    // You may need to change the region. It will say in the URL when the bucket is open
    // and on creation. us-east-2 is Ohio, us-east-1 is North Virgina.
    $s3 = S3Client::factory(
        array(
            'credentials' => array(
                'key' => $iamkey,
                'secret' => $iamsecret
            ),
            'version' => 'latest',
            'region'  => 'ap-south-1'
        )
    );
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}

// For this, I would generate a unqiue random string for the key name. But you can do whatever.
$keyname = 'test_example/'.$filename;   // Ftp is file name at index.php.
$pathins = 'https://s3.ap-south-1.amazonaws.com/' . $bucketname . '/' . $keyname;

// Add it to S3.
try {
    if (!file_exists('/tmp/tmpfile')) {
        echo 3;
        mkdir('/tmp/tmpfile');
    }
    $tempfilepath = '/tmp/tmpfile/index.php';
    $tempfile = fopen($tempfilepath, "w") || die("Error: Unable to open file.");
    $filecontents = file_get_contents($filepath);
    $tempfile = file_put_contents($tempfilepath, $filecontents);
    $s3->putObject(
        array(
        'Bucket' => $bucketname,
            'Key' => $keyname,
            'SourceFile' => $tempfilepath,
            'StorageClass' => 'REDUCED_REDUNDANCY',
            'ACL' => 'public-read'
        )
    );
} catch (S3Exception $e) {
    die('Error:' . $e->getMessage());
} catch (Exception $e) {
    die('Error:' . $e->getMessage());
}

$table = 'file_detail';
$dataobject = new StdClass();
$dataobject->file_name = $filename;
$dataobject->file_url = $filepath;
$dataobject->aws_url = 'https://'.$bucketname.'.s3.ap-south-1.amazonaws.com/'.$keyname;
$dataobject->contextid = $contextid;
$dataobject->moduleid = $moduleid;
$dataobject->objectid = $objectid;

$status = $DB->insert_record($table, $dataobject);
