<?php
require_once('../../config.php');
require_once('lib.php');
require_once("$CFG->dirroot/enrol/externallib.php");

require_login();
global $USER, $DB, $OUTPUT, $CFG;

$title = 'Player';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->set_pagelayout('standard');


$is_tenant = false;


$tenant_role = $DB->get_record('role', ['shortname' => 'admin_tenant']);
if (user_has_role_assignment($USER->id, $tenant_role->id)) {
   $is_tenant = true;
   $tenant = $DB->get_record('tenent', ['user_id' => $USER->id]);
}

$time = time();
$one_week_ago = strtotime("-1 week");
if ($is_tenant) {
   $total_users = $DB->get_records_SQL("SELECT id FROM {user} WHERE tenant_id='$tenant->sno'");
   $count_users = count($total_users);
   $new_users_count = count($DB->get_records_sql("SELECT * from {user} WHERE timecreated>$one_week_ago AND timecreated<$time AND tenant_id='$tenant->sno'"));
   $courses = $tenant->courseid;
   $course_arr = explode(',', $courses);
   foreach ($course_arr as $key => $val) {
      if (empty($val))
         unset($course_arr[$key]);
   }
   $course_str = implode(',', $course_arr);
   $new_courses_count = count($DB->get_records_sql("SELECT * from {course} WHERE timecreated>$one_week_ago AND timecreated<$time AND id IN ($course_str)"));

   $all_courses = $DB->get_records_sql("SELECT mc.id, mc.fullname FROM {course} mc JOIN {course_categories} mcc ON mc.category=mcc.id AND mc.id IN ($course_str)");

   $teachers = $DB->get_records_sql("SELECT mra.userid, mu.id, mu.firstname, mu.lastname, mu.picture from {user} mu join {role_assignments} mra on mu.id=mra.userid join {role} mr on mra.roleid =mr.id where mr.shortname = 'teacher' or mr.shortname='editingteacher' AND mu.tenant_id='$tenant->sno'");
} else {
   $total_users = $DB->get_records('user');
   $count_users = count($total_users);
   $new_users_count = count($DB->get_records_sql("SELECT * from {user} WHERE timecreated>$one_week_ago AND timecreated<$time"));
   $new_courses_count = count($DB->get_records_sql("SELECT * from {course} WHERE timecreated>$one_week_ago AND timecreated<$time"));

   $all_courses = $DB->get_records_sql("SELECT mc.id, mc.fullname FROM {course} mc JOIN {course_categories} mcc ON mc.category=mcc.id");

   $teachers = $DB->get_records_sql("SELECT mra.userid, mu.id, mu.firstname, mu.lastname, mu.picture from {user} mu join {role_assignments} mra on mu.id=mra.userid join {role} mr on mra.roleid =mr.id where mr.shortname = 'teacher' or mr.shortname='editingteacher'");
}
$course_list = "";
$select_course = "
   <select id='select_course' class='form-select form-select-sm scrollbar'>
      <option>Select a course</option>  ";
$select_course_pie = "
   <select id='select_course_pie' class='form-select form-select-sm scrollbar'>
      <option>Select a course</option>  ";
foreach ($all_courses as $course) {
   $context = context_course::instance($course->id);
   $users = count(get_enrolled_users($context));
   // $image = core_course\external\course_summary_exporter::get_course_image($course);
   $image = $DB->get_record_sql("SELECT * FROM {files} WHERE contextid=$context->id AND source IS NOT NULL");
   $url = moodle_url::make_pluginfile_url($image->contextid, $image->component, $image->filearea, $image->itemid, $image->filepath, $image->filename);
   $course_list .= "
   
      <div class='d-flex position-relative align-items-center mb-2'>
         <img class='d-flex align-self-center me-2 rounded-3' src='$url' alt='' width='50'>
         <div class='flex-1'>
            <h6 class='fs-0 mb-0'><a class='stretched-link' href='$CFG->wwwroot/course/view.php?id=$course->id'>$course->fullname</a></h6>
            <p class='mb-1'>$users users</p>
         </div>
      </div>

   ";

   $select_course .= "<option>$course->fullname</option>";
   $select_course_pie .= "<option>$course->fullname</option>";
}
$select_course .= "</select>";
$select_course_pie .= "</select>";

$teach_details = "";
foreach ($teachers as $teach) {
   $teacher_course = array();
   $teach_course = "";
   $courses = core_enrol_external::get_users_courses($teach->userid, true);
   $course_users = 0;
   foreach ($courses as $course) {
      array_push($teacher_course, $course['fullname']);
      $context = context_course::instance($course['id']);
      $course_users += count(get_enrolled_users($context));
   }
   $teach_course = $teacher_course ? implode(",", $teacher_course) : "";
   $context = context_user::instance($teach->userid);
   $file_path = $teach->picture;
   $teach_picture_url = moodle_url::make_pluginfile_url(
      $context->id,
      'user',
      'icon',
      null,
      '/',
      $file_path
   );
   if ($file_path > 0) {
      $teach_image = '<img class="rounded-circle" src="' . $teach_picture_url . '" alt="">';
   } else {
      $initials = strtoupper(implode("", array($teach->firstname[0], $teach->lastname[0])));
      $teach_image = '<div class="avatar-name rounded-circle"><span>' . $initials . '</span></div>';
   }
   $teach_details .= '
   <tr>
      <td class="align-middle fs-0 py-3">
         <div class="form-check mb-0"><input class="form-check-input" type="checkbox" id="table-view-tickets-0" data-bulk-select-row="data-bulk-select-row"></div>
      </td>
      <td class="align-middle client white-space-nowrap pe-3 pe-xxl-4 ps-2">
         <div class="d-flex align-items-center gap-2 position-relative">
            <div class="avatar avatar-xl">
               ' . $teach_image . '
            </div>
            <h6 class="mb-0"><a class="stretched-link text-900" href="' . $CFG->wwwroot . '/user/profile.php?id=' . $teach->id . '">' . $teach->firstname . ' ' . $teach->lastname . '</a></h6>
         </div>
      </td>
      <td class="align-middle subject py-2 pe-4"><a class="fw-semi-bold" style="text-decoration:none">' . $teach_course . '</a></td>
      <td class="align-middle status fs-0 pe-4"><small class="badge rounded badge-soft-warning false">Recent</small></td>
      <td class="align-middle priority pe-4">
         <div class="d-flex align-items-center gap-2">
            
            <h6 class="mb-0 text-700">' . $course_users . '</h6>
         </div>
      </td>
     
   </tr>
   ';
}
echo $OUTPUT->header();

$templatecontext = [
   'select_course' => $select_course,
   'select_course_pie' => $select_course_pie,
   'course_list' => $course_list,
   'teach_details' => $teach_details,
   'count_users' => $count_users,
   'new_users_count' => $new_users_count,
   'new_courses_count' => $new_courses_count,
];
echo $OUTPUT->render_from_template('local_tenat_form/test', $templatecontext);
echo $OUTPUT->footer();
