<?php
require_once('../../config.php');
global $USER, $DB, $OUTPUT, $CFG;
require_once('lib.php');
require_once($CFG->dirroot . '/course/lib.php');
require_once($CFG->dirroot . '/calendar/lib.php');
require_once("$CFG->dirroot/enrol/externallib.php");
require_once("$CFG->dirroot/course/classes/external/course_summary_exporter.php");
require_once("$CFG->libdir/filelib.php");
require_login();
$categoryid = optional_param('category', null, PARAM_INT);
$courseid = optional_param('course', SITEID, PARAM_INT);
$title = 'Player';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->set_pagelayout('standard');
$is_tenant = false;
$tenant_role = $DB->get_record('role', ['shortname' => 'admin_tenant']);
if (user_has_role_assignment($USER->id, $tenant_role->id)) {
   $is_tenant = true;
   $tenant = $DB->get_record('tenent', ['user_id' => $USER->id]);
}
$time = time();
$one_week_ago = strtotime("-1 week");
if ($is_tenant) {
   $total_users = $DB->get_records_sql("SELECT id FROM {user} WHERE tenant_id='$tenant->sno' AND deleted=0");
   $count_users = count($total_users);
   $new_users_count = count($DB->get_records_sql("SELECT * from {user} WHERE timecreated>$one_week_ago AND timecreated<$time AND tenant_id='$tenant->sno' AND deleted=0"));
   $courses = $tenant->courseid;
   if($courses)
   {
      $course_arr = explode(',', $courses);
      foreach ($course_arr as $key => $val) {
         if (empty($val))
            unset($course_arr[$key]);
      }
      $course_str = implode(',', $course_arr);
   }
   else
   {
      $course_str=0;
   }
   $new_courses_count = count($DB->get_records_sql("SELECT * from {course} WHERE timecreated>$one_week_ago AND timecreated<$time AND id IN ($course_str) AND tenant_id='$tenant->sno'"));
   $all_courses = $DB->get_records_sql("SELECT mc.id, mc.fullname FROM {course} mc JOIN {course_categories} mcc ON mc.category=mcc.id AND mc.id IN ($course_str)");
   $teachers = $DB->get_records_sql("SELECT mra.userid, mu.id, mu.firstname, mu.lastname, mu.picture from {user} mu join {role_assignments} mra on mu.id=mra.userid join {role} mr on mra.roleid =mr.id where mr.shortname = 'teacher' or mr.shortname='editingteacher' AND mu.tenant_id='$tenant->sno'");
} else {
   $total_users = $DB->get_records_SQL("SELECT id FROM {user} WHERE deleted=0");
   $count_users = count($total_users);
   $new_users_count = count($DB->get_records_sql("SELECT * from {user} WHERE timecreated>$one_week_ago AND timecreated<$time AND deleted=0"));
   $new_courses = $DB->get_records_sql("SELECT * from {course} WHERE timecreated>$one_week_ago AND timecreated<$time");
   $new_courses_count2 = [];
   $new_courses_count = [];
   foreach ($new_courses as $new_course) {
      $new_courses_count2[] = $new_course->id;
   }
   $new_courses_count = count($new_courses_count2);
   $copy_course=$DB->get_records_sql_menu("SELECT ccc.id, ccc.course_id FROM {course} mc JOIN {course_categories} mcc ON mc.category=mcc.id join {course_categories_copy} ccc ON ccc.categorie_id=mcc.id WHERE mc.tenant_id = $USER->id");
   $copy_course_string=implode(",",array_filter(array_unique(array_values($copy_course))));
   // var_dump($copy_course_string);
   // die;

   $all_courses = $DB->get_records_sql("SELECT mc.id, mc.fullname FROM {course} mc JOIN {course_categories} mcc ON mc.category=mcc.id AND (mc.tenant_id = $USER->id OR mc.id IN ($copy_course_string))");
   $teachers = $DB->get_records_sql("SELECT mra.userid, mu.id, mu.firstname, mu.lastname, mu.picture from {user} mu join {role_assignments} mra on mu.id=mra.userid join {role} mr on mra.roleid =mr.id where mr.shortname = 'teacher' or mr.shortname='editingteacher'");
}
$course_list = "";
$select_course = "
   <select id='select_course' class='form-select form-select-sm scrollbar'>
      <option>Select a course</option>  ";
$select_course_pie = "
   <select id='select_course_pie' class='form-select form-select-sm scrollbar'>
      <option>Select a course</option>  ";

foreach ($all_courses as $course) {
   $context = context_course::instance($course->id);
   $users = count(get_enrolled_users($context));
   // // $image = core_course\external\course_summary_exporter::get_course_image($course);
   // $image = $DB->get_record_sql("SELECT * FROM {files} WHERE contextid=$context->id ");

   // $context = context_course::instance($COURSE->id);
   $course_img =   \core_course\external\course_summary_exporter::get_course_image($course);
   if ($course_img) {
      $url = $course_img;
   } else {
      $url = $CFG->wwwroot . '/local/tenant_form/pix/images.png';
   }


   $course_list .= "
      <div class='d-flex position-relative align-items-center mb-2'>
         <img class='d-flex align-self-center me-2 rounded-3' src=" . $url . " alt='' width='50'>
         <div class='flex-1'>
            <h6 class='fs-0 mb-0'><a class='stretched-link' href='$CFG->wwwroot/course/view.php?id=$course->id'>$course->fullname</a></h6>
            <p class='mb-1'>$users users</p>
         </div>
      </div>

   ";

   $select_course .= "<option>$course->fullname</option>";
   $select_course_pie .= "<option>$course->fullname</option>";
}

$select_course .= "</select>";
$select_course_pie .= "</select>";

$teach_details = "";
foreach ($teachers as $teach) {
   $teacher_course = array();
   $teach_course = "";
   // $courses = core_enrol_external::get_users_courses($teach->userid, true);
   $courses = enrol_get_users_courses($teach->userid, $onlyactive = false, $fields = null, $sort = null);

   $course_users = 0;
   foreach ($courses as $course) {
      array_push($teacher_course, $course->fullname);
      $context = context_course::instance($course->id);
      $course_users += count(get_enrolled_users($context));
   }
   $teach_course2 = $teacher_course ? implode(",", $teacher_course) : "";
   $word_count = str_word_count($teach_course2);

   if ($word_count <= 40) {
      $teach_course = $teach_course2;
   } else {
      $teach_course = substr($teach_course2, 0, 50);;
   }
   $context = context_user::instance($teach->userid);
   $file_path = $teach->picture;
   $teach_picture_url = moodle_url::make_pluginfile_url(
      $context->id,
      'user',
      'icon',
      null,
      '/',
      $file_path
   );
   if ($file_path > 0) {
      $teach_image = '<img class="rounded-circle" src="' . $teach_picture_url . '" alt="">';
   } else {
      $initials = strtoupper(implode("", array($teach->firstname[0], $teach->lastname[0])));
      $teach_image = '<div class="avatar-name rounded-circle"><span>' . $initials . '</span></div>';
   }
   $teach_details .= '
   <tr>
      <td class="align-middle client white-space-nowrap pe-3 pe-xxl-4 ps-2">
         <div class="d-flex align-items-center gap-2 position-relative">
            <div class="avatar avatar-xl">
               ' . $teach_image . '
            </div>
            <h6 class="mb-0"><a class="stretched-link text-900" href="' . $CFG->wwwroot . '/user/profile.php?id=' . $teach->id . '">' . $teach->firstname . ' ' . $teach->lastname . '</a></h6>
         </div>
      </td>
      <td class="align-middle subject py-2 pe-4"><a class="fw-semi-bold" style="text-decoration:none">' . $teach_course . '</a></td>
      <td class="align-middle status fs-0 pe-4"><small class="badge rounded badge-soft-warning false">Recent</small></td>
      <td class="align-middle priority pe-4">
         <div class="d-flex align-items-center gap-2">
            
            <h6 class="mb-0 text-700">' . $course_users . '</h6>
         </div>
      </td>
     
   </tr>
   ';
}

$event_name = [];
$events = $DB->get_records_sql("SELECT * from {event} where userid=$USER->id");
foreach ($events as $event) {
   $event_date = date('d/m/y', $event->timestart);
   $today = (date('d/m/y'));
   $days_ago = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") - 2, date("Y")));
   $daysago2 = strtotime($days_ago);
   if (($daysago2 == $event->timestart) || ($event->timestart > $daysago2)) {
      $event_name[] = ['name' => $event->name, 'date' => $event_date];
   }
}
$tenant_management = [];
if (!$is_tenant) {
   $data = $DB->get_records_sql("SELECT * FROM {tenent}");
   $y = 0;
   foreach ($data as $dataval) {
      $sno = $y += 1;
      $sd = date("d/m/y", $dataval->start_date);
      $ed = date("d/m/y", $dataval->end_date);
      $rd = date("d/m/y", $dataval->reminder_date);
      if ($sd == "01/01/70") {
         $sd = "-";
      }
      if ($ed == "01/01/70") {
         $ed = "-";
      }
      if ($rd == "01/01/70") {
         $rd = "-";
      }
      $t = new DateTime();
      if ($t->getTimestamp() <= $dataval->reminder_date) {
         $status = "Active";
         $tenant_management[] = ['sno' => $sno, 'username' => $dataval->username, 'startdate' => $sd, 'enddate' => $ed, 'renewaldate' => $rd, 'active' => $status];
      } else {
         $status = "Inactive";
         $tenant_management[] = ['sno' => $sno, 'username' => $dataval->username, 'startdate' => $sd, 'enddate' => $ed, 'renewaldate' => $rd, 'active' => $status];
      }
   }
}

// Calendar
$view = 'month';
$course = get_course($courseid);
if ($iscoursecalendar && !empty($courseid)) {
   navigation_node::override_active_url(new moodle_url('/course/view.php', array('id' => $course->id)));
} else if (!empty($categoryid)) {
   core_course_category::get($categoryid); // Check that category exists and can be accessed.
   $PAGE->set_category_by_id($categoryid);
   navigation_node::override_active_url(new moodle_url('/course/index.php', array('categoryid' => $categoryid)));
} else {
   $PAGE->set_context(context_system::instance());
}
$calendar = calendar_information::create($time, $courseid, $categoryid);
$PAGE->set_pagelayout('standard');
$renderer = $PAGE->get_renderer('core_calendar');

echo $OUTPUT->header();

$templatecontext = [
   'select_course' => $select_course,
   'select_course_pie' => $select_course_pie,
   'course_list' => $course_list,
   'teach_details' => $teach_details,
   'count_users' => $count_users,
   'new_users_count' => $new_users_count,
   'new_courses_count' => $new_courses_count,
   'event_name' => $event_name,
   'tenant_management' => $tenant_management,
   'cfg' => $CFG->wwwroot,
   'is_tenant' => $is_tenant
];
echo $OUTPUT->render_from_template('local_tenat_form/test', $templatecontext);
echo html_writer::start_tag('div', array('class' => 'heightcontainer card p-4'));
echo $renderer->start_layout();

list($data, $template) = calendar_get_view($calendar, $view, true, false, $lookahead);
echo $renderer->render_from_template($template, $data);
echo html_writer::end_tag('div');
echo $renderer->complete_layout();
echo $OUTPUT->footer();
