-- MySQL dump 10.13  Distrib 5.7.35, for Linux (x86_64)
--
-- Host: localhost    Database: m2_moodle
-- ------------------------------------------------------
-- Server version	5.7.35

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `mdl_analytics_indicator_calc`
--

DROP TABLE IF EXISTS `mdl_analytics_indicator_calc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_indicator_calc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `starttime` bigint(10) NOT NULL,
  `endtime` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleorigin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sampleid` bigint(10) NOT NULL,
  `indicator` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analindicalc_staendcon_ix` (`starttime`,`endtime`,`contextid`),
  KEY `mdl_analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stored indicator calculations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_indicator_calc`
--

LOCK TABLES `mdl_analytics_indicator_calc` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_indicator_calc` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_indicator_calc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_models`
--

DROP TABLE IF EXISTS `mdl_analytics_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_models` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(1333) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `indicators` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `predictionsprocessor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` bigint(10) NOT NULL,
  `contextids` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analmode_enatra_ix` (`enabled`,`trained`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_models`
--

LOCK TABLES `mdl_analytics_models` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_models` DISABLE KEYS */;
INSERT INTO `mdl_analytics_models` VALUES (1,0,0,NULL,'\\core_course\\analytics\\target\\course_dropout','[\"\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end\",\"\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start\",\"\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course\",\"\\\\core\\\\analytics\\\\indicator\\\\read_actions\",\"\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled\",\"\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth\",\"\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth\",\"\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth\",\"\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth\",\"\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth\"]',NULL,NULL,1663307062,NULL,1663307062,1663307062,0),(2,1,1,NULL,'\\core_course\\analytics\\target\\no_teaching','[\"\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher\",\"\\\\core_course\\\\analytics\\\\indicator\\\\no_student\"]','\\core\\analytics\\time_splitting\\single_range',NULL,1663307062,NULL,1663307062,1663307062,0),(3,1,1,NULL,'\\core_user\\analytics\\target\\upcoming_activities_due','[\"\\\\core_course\\\\analytics\\\\indicator\\\\activities_due\"]','\\core\\analytics\\time_splitting\\upcoming_week',NULL,1663307062,NULL,1663307062,1663307062,0),(4,1,1,NULL,'\\core_course\\analytics\\target\\no_access_since_course_start','[\"\\\\core\\\\analytics\\\\indicator\\\\any_course_access\"]','\\core\\analytics\\time_splitting\\one_month_after_start',NULL,1663307062,NULL,1663307062,1663307062,0),(5,1,1,NULL,'\\core_course\\analytics\\target\\no_recent_accesses','[\"\\\\core\\\\analytics\\\\indicator\\\\any_course_access\"]','\\core\\analytics\\time_splitting\\past_month',NULL,1663307062,NULL,1663307062,1663307062,0);
/*!40000 ALTER TABLE `mdl_analytics_models` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_models_log`
--

DROP TABLE IF EXISTS `mdl_analytics_models_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_models_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `version` bigint(10) NOT NULL,
  `evaluationmode` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `target` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `indicators` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext COLLATE utf8mb4_unicode_ci,
  `dir` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analmodelog_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Analytic models changes during evaluation.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_models_log`
--

LOCK TABLES `mdl_analytics_models_log` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_models_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_models_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_predict_samples`
--

DROP TABLE IF EXISTS `mdl_analytics_predict_samples`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_predict_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rangeindex` bigint(10) NOT NULL,
  `sampleids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analpredsamp_modanatimr_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `mdl_analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Samples already used for predictions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_predict_samples`
--

LOCK TABLES `mdl_analytics_predict_samples` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_predict_samples` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_predict_samples` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_prediction_actions`
--

DROP TABLE IF EXISTS `mdl_analytics_prediction_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_prediction_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `predictionid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `actionname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analpredacti_preuseact_ix` (`predictionid`,`userid`,`actionname`),
  KEY `mdl_analpredacti_pre_ix` (`predictionid`),
  KEY `mdl_analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Register of user actions over predictions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_prediction_actions`
--

LOCK TABLES `mdl_analytics_prediction_actions` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_prediction_actions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_prediction_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_predictions`
--

DROP TABLE IF EXISTS `mdl_analytics_predictions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_predictions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleid` bigint(10) NOT NULL,
  `rangeindex` mediumint(5) NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `mdl_analpred_mod_ix` (`modelid`),
  KEY `mdl_analpred_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Predictions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_predictions`
--

LOCK TABLES `mdl_analytics_predictions` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_predictions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_predictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_train_samples`
--

DROP TABLE IF EXISTS `mdl_analytics_train_samples`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_train_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sampleids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analtraisamp_modanatim_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `mdl_analtraisamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Samples used for training';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_train_samples`
--

LOCK TABLES `mdl_analytics_train_samples` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_train_samples` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_train_samples` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_used_analysables`
--

DROP TABLE IF EXISTS `mdl_analytics_used_analysables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_used_analysables` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `analysableid` bigint(10) NOT NULL,
  `firstanalysis` bigint(10) NOT NULL,
  `timeanalysed` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_analusedanal_modact_ix` (`modelid`,`action`),
  KEY `mdl_analusedanal_ana_ix` (`analysableid`),
  KEY `mdl_analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of analysables used by each model';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_used_analysables`
--

LOCK TABLES `mdl_analytics_used_analysables` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_used_analysables` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_used_analysables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_analytics_used_files`
--

DROP TABLE IF EXISTS `mdl_analytics_used_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_analytics_used_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL DEFAULT '0',
  `fileid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `time` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_analusedfile_modactfil_ix` (`modelid`,`action`,`fileid`),
  KEY `mdl_analusedfile_mod_ix` (`modelid`),
  KEY `mdl_analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Files that have already been used for training and predictio';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_analytics_used_files`
--

LOCK TABLES `mdl_analytics_used_files` WRITE;
/*!40000 ALTER TABLE `mdl_analytics_used_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_analytics_used_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign`
--

DROP TABLE IF EXISTS `mdl_assign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint(2) NOT NULL DEFAULT '0',
  `nosubmissions` tinyint(2) NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint(2) NOT NULL DEFAULT '0',
  `sendnotifications` tinyint(2) NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint(2) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint(2) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(2) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `gradingduedate` bigint(10) NOT NULL DEFAULT '0',
  `teamsubmission` tinyint(2) NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint(2) NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint(10) NOT NULL DEFAULT '0',
  `blindmarking` tinyint(2) NOT NULL DEFAULT '0',
  `hidegrader` tinyint(2) NOT NULL DEFAULT '0',
  `revealidentities` tinyint(2) NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `maxattempts` mediumint(6) NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint(2) NOT NULL DEFAULT '0',
  `markingallocation` tinyint(2) NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint(2) NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou_ix` (`course`),
  KEY `mdl_assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table saves information about an instance of mod_assign';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign`
--

LOCK TABLES `mdl_assign` WRITE;
/*!40000 ALTER TABLE `mdl_assign` DISABLE KEYS */;
INSERT INTO `mdl_assign` VALUES (1,73,'demo assignment','',1,1,0,0,0,0,1666652400,1666047600,100,1666076168,0,1,0,1667257200,0,0,0,0,0,0,'none',-1,0,0,1,0),(2,2,'a1','',1,1,0,0,0,0,1666652400,1666047600,100,1666076622,0,1,0,1667257200,0,0,0,0,0,0,'none',-1,0,0,1,0),(3,2,'a1 (copy)','',1,1,0,0,0,0,1666652400,1666047600,100,1666076622,0,1,0,1667257200,0,0,0,0,0,0,'none',-1,0,0,1,0);
/*!40000 ALTER TABLE `mdl_assign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_grades`
--

DROP TABLE IF EXISTS `mdl_assign_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `grader` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `mdl_assigrad_use_ix` (`userid`),
  KEY `mdl_assigrad_att_ix` (`attemptnumber`),
  KEY `mdl_assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Grading information about a single assignment submission.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_grades`
--

LOCK TABLES `mdl_assign_grades` WRITE;
/*!40000 ALTER TABLE `mdl_assign_grades` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_overrides`
--

DROP TABLE IF EXISTS `mdl_assign_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `allowsubmissionsfromdate` bigint(10) DEFAULT NULL,
  `duedate` bigint(10) DEFAULT NULL,
  `cutoffdate` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_assiover_ass_ix` (`assignid`),
  KEY `mdl_assiover_gro_ix` (`groupid`),
  KEY `mdl_assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The overrides to assign settings.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_overrides`
--

LOCK TABLES `mdl_assign_overrides` WRITE;
/*!40000 ALTER TABLE `mdl_assign_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_plugin_config`
--

DROP TABLE IF EXISTS `mdl_assign_plugin_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_plugin_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `plugin` varchar(28) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subtype` varchar(28) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(28) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_assiplugconf_plu_ix` (`plugin`),
  KEY `mdl_assiplugconf_sub_ix` (`subtype`),
  KEY `mdl_assiplugconf_nam_ix` (`name`),
  KEY `mdl_assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Config data for an instance of a plugin in an assignment.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_plugin_config`
--

LOCK TABLES `mdl_assign_plugin_config` WRITE;
/*!40000 ALTER TABLE `mdl_assign_plugin_config` DISABLE KEYS */;
INSERT INTO `mdl_assign_plugin_config` VALUES (1,1,'onlinetext','assignsubmission','enabled','0'),(2,1,'file','assignsubmission','enabled','1'),(3,1,'file','assignsubmission','maxfilesubmissions','20'),(4,1,'file','assignsubmission','maxsubmissionsizebytes','0'),(5,1,'file','assignsubmission','filetypeslist',''),(6,1,'comments','assignsubmission','enabled','1'),(7,1,'comments','assignfeedback','enabled','1'),(8,1,'comments','assignfeedback','commentinline','0'),(9,1,'editpdf','assignfeedback','enabled','0'),(10,1,'offline','assignfeedback','enabled','0'),(11,1,'file','assignfeedback','enabled','0'),(12,2,'onlinetext','assignsubmission','enabled','0'),(13,2,'file','assignsubmission','enabled','1'),(14,2,'file','assignsubmission','maxfilesubmissions','20'),(15,2,'file','assignsubmission','maxsubmissionsizebytes','0'),(16,2,'file','assignsubmission','filetypeslist',''),(17,2,'comments','assignsubmission','enabled','1'),(18,2,'comments','assignfeedback','enabled','1'),(19,2,'comments','assignfeedback','commentinline','0'),(20,2,'editpdf','assignfeedback','enabled','0'),(21,2,'offline','assignfeedback','enabled','0'),(22,2,'file','assignfeedback','enabled','0'),(23,3,'onlinetext','assignsubmission','enabled','0'),(24,3,'file','assignsubmission','enabled','1'),(25,3,'file','assignsubmission','maxfilesubmissions','20'),(26,3,'file','assignsubmission','maxsubmissionsizebytes','0'),(27,3,'file','assignsubmission','filetypeslist',''),(28,3,'comments','assignsubmission','enabled','1'),(29,3,'comments','assignfeedback','enabled','1'),(30,3,'comments','assignfeedback','commentinline','0'),(31,3,'editpdf','assignfeedback','enabled','0'),(32,3,'offline','assignfeedback','enabled','0'),(33,3,'file','assignfeedback','enabled','0');
/*!40000 ALTER TABLE `mdl_assign_plugin_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_submission`
--

DROP TABLE IF EXISTS `mdl_assign_submission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  `latest` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assisubm_assusegroatt_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `mdl_assisubm_use_ix` (`userid`),
  KEY `mdl_assisubm_att_ix` (`attemptnumber`),
  KEY `mdl_assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `mdl_assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about student interactions with';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_submission`
--

LOCK TABLES `mdl_assign_submission` WRITE;
/*!40000 ALTER TABLE `mdl_assign_submission` DISABLE KEYS */;
INSERT INTO `mdl_assign_submission` VALUES (1,2,151,1666078511,1666078544,'submitted',0,0,1);
/*!40000 ALTER TABLE `mdl_assign_submission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_flags`
--

DROP TABLE IF EXISTS `mdl_assign_user_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_user_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` smallint(4) NOT NULL DEFAULT '0',
  `extensionduedate` bigint(10) NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allocatedmarker` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiuserflag_mai_ix` (`mailed`),
  KEY `mdl_assiuserflag_use_ix` (`userid`),
  KEY `mdl_assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of flags that can be set for a single user in a single ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_flags`
--

LOCK TABLES `mdl_assign_user_flags` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_flags` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assign_user_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assign_user_mapping`
--

DROP TABLE IF EXISTS `mdl_assign_user_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assign_user_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiusermapp_ass_ix` (`assignment`),
  KEY `mdl_assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Map an assignment specific id number to a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assign_user_mapping`
--

LOCK TABLES `mdl_assign_user_mapping` WRITE;
/*!40000 ALTER TABLE `mdl_assign_user_mapping` DISABLE KEYS */;
INSERT INTO `mdl_assign_user_mapping` VALUES (1,2,80),(2,2,64),(3,2,71),(4,2,46),(5,2,49),(6,2,50),(7,2,56),(8,2,131),(9,2,122),(10,2,135),(11,2,77),(12,2,91),(13,2,36),(14,2,70),(15,2,123),(16,2,68),(17,2,148),(18,2,144),(19,2,81),(20,2,127),(21,2,78),(22,2,44),(23,2,79),(24,2,151),(25,2,139),(26,2,132),(27,2,133),(28,2,150),(29,2,75),(30,2,60),(31,2,137),(32,2,58),(33,2,2),(34,2,129),(35,2,53),(36,2,147),(37,2,128),(38,2,146),(39,2,61),(40,2,125),(41,2,130),(42,2,42),(43,2,145),(44,2,62),(45,2,45),(46,2,48),(47,2,69),(48,2,126),(49,2,51),(50,2,134),(51,2,63),(52,2,136),(53,2,59),(54,2,57),(55,2,124);
/*!40000 ALTER TABLE `mdl_assign_user_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_comments`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `commenttext` longtext COLLATE utf8mb4_unicode_ci,
  `commentformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assicomm_ass_ix` (`assignment`),
  KEY `mdl_assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Text feedback for submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_comments`
--

LOCK TABLES `mdl_assignfeedback_comments` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_annot`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_annot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_annot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `endx` bigint(10) DEFAULT '0',
  `endy` bigint(10) DEFAULT '0',
  `path` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'line',
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='stores annotations added to pdfs submitted by students';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_annot`
--

LOCK TABLES `mdl_assignfeedback_editpdf_annot` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_annot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_cmnt`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_cmnt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_cmnt` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `width` bigint(10) DEFAULT '120',
  `rawtext` longtext COLLATE utf8mb4_unicode_ci,
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `mdl_assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores comments added to pdfs';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_cmnt`
--

LOCK TABLES `mdl_assignfeedback_editpdf_cmnt` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_cmnt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_queue`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `submissionid` bigint(10) NOT NULL,
  `submissionattempt` bigint(10) NOT NULL,
  `attemptedconversions` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assieditqueu_subsub_uix` (`submissionid`,`submissionattempt`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Queue for processing.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_queue`
--

LOCK TABLES `mdl_assignfeedback_editpdf_queue` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_queue` DISABLE KEYS */;
INSERT INTO `mdl_assignfeedback_editpdf_queue` VALUES (1,1,0,0);
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_quick`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_quick`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_quick` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `rawtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` bigint(10) NOT NULL DEFAULT '120',
  `colour` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `mdl_assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores teacher specified quicklist comments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_quick`
--

LOCK TABLES `mdl_assignfeedback_editpdf_quick` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_quick` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_editpdf_rot`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_editpdf_rot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_editpdf_rot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `pathnamehash` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `isrotated` tinyint(1) NOT NULL DEFAULT '0',
  `degree` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_assieditrot_grapag_uix` (`gradeid`,`pageno`),
  KEY `mdl_assieditrot_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores rotation information of a page.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_editpdf_rot`
--

LOCK TABLES `mdl_assignfeedback_editpdf_rot` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_rot` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_editpdf_rot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignfeedback_file`
--

DROP TABLE IF EXISTS `mdl_assignfeedback_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignfeedback_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass2_ix` (`assignment`),
  KEY `mdl_assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores info about the number of files submitted by a student';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignfeedback_file`
--

LOCK TABLES `mdl_assignfeedback_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignfeedback_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment`
--

DROP TABLE IF EXISTS `mdl_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `resubmit` tinyint(2) NOT NULL DEFAULT '0',
  `preventlate` tinyint(2) NOT NULL DEFAULT '0',
  `emailteachers` tinyint(2) NOT NULL DEFAULT '0',
  `var1` bigint(10) DEFAULT '0',
  `var2` bigint(10) DEFAULT '0',
  `var3` bigint(10) DEFAULT '0',
  `var4` bigint(10) DEFAULT '0',
  `var5` bigint(10) DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '100000',
  `timedue` bigint(10) NOT NULL DEFAULT '0',
  `timeavailable` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assi_cou2_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment`
--

LOCK TABLES `mdl_assignment` WRITE;
/*!40000 ALTER TABLE `mdl_assignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_submissions`
--

DROP TABLE IF EXISTS `mdl_assignment_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment_submissions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  `data1` longtext COLLATE utf8mb4_unicode_ci,
  `data2` longtext COLLATE utf8mb4_unicode_ci,
  `grade` bigint(11) NOT NULL DEFAULT '0',
  `submissioncomment` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `teacher` bigint(10) NOT NULL DEFAULT '0',
  `timemarked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assisubm_use2_ix` (`userid`),
  KEY `mdl_assisubm_mai_ix` (`mailed`),
  KEY `mdl_assisubm_tim_ix` (`timemarked`),
  KEY `mdl_assisubm_ass2_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about submitted assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_submissions`
--

LOCK TABLES `mdl_assignment_submissions` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignment_upgrade`
--

DROP TABLE IF EXISTS `mdl_assignment_upgrade`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignment_upgrade` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `oldcmid` bigint(10) NOT NULL DEFAULT '0',
  `oldinstance` bigint(10) NOT NULL DEFAULT '0',
  `newcmid` bigint(10) NOT NULL DEFAULT '0',
  `newinstance` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assiupgr_old_ix` (`oldcmid`),
  KEY `mdl_assiupgr_old2_ix` (`oldinstance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about upgraded assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignment_upgrade`
--

LOCK TABLES `mdl_assignment_upgrade` WRITE;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignment_upgrade` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_file`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignsubmission_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assifile_ass_ix` (`assignment`),
  KEY `mdl_assifile_sub_ix` (`submission`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about file submissions for assignments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_file`
--

LOCK TABLES `mdl_assignsubmission_file` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_file` DISABLE KEYS */;
INSERT INTO `mdl_assignsubmission_file` VALUES (1,2,1,1);
/*!40000 ALTER TABLE `mdl_assignsubmission_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_assignsubmission_onlinetext`
--

DROP TABLE IF EXISTS `mdl_assignsubmission_onlinetext`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_assignsubmission_onlinetext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `onlinetext` longtext COLLATE utf8mb4_unicode_ci,
  `onlineformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_assionli_ass_ix` (`assignment`),
  KEY `mdl_assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Info about onlinetext submission';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_assignsubmission_onlinetext`
--

LOCK TABLES `mdl_assignsubmission_onlinetext` WRITE;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_assignsubmission_onlinetext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_auth_oauth2_linked_login`
--

DROP TABLE IF EXISTS `mdl_auth_oauth2_linked_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_auth_oauth2_linked_login` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `confirmtoken` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_authoautlinklogi_useis_uix` (`userid`,`issuerid`,`username`),
  KEY `mdl_authoautlinklogi_issuse_ix` (`issuerid`,`username`),
  KEY `mdl_authoautlinklogi_use_ix` (`usermodified`),
  KEY `mdl_authoautlinklogi_use2_ix` (`userid`),
  KEY `mdl_authoautlinklogi_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Accounts linked to a users Moodle account.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_auth_oauth2_linked_login`
--

LOCK TABLES `mdl_auth_oauth2_linked_login` WRITE;
/*!40000 ALTER TABLE `mdl_auth_oauth2_linked_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_auth_oauth2_linked_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_autocategory`
--

DROP TABLE IF EXISTS `mdl_autocategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_autocategory` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `categories` text COLLATE utf8mb4_unicode_ci,
  `courses` text COLLATE utf8mb4_unicode_ci,
  `userid` int(10) DEFAULT NULL,
  `maincategory` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_autocategory`
--

LOCK TABLES `mdl_autocategory` WRITE;
/*!40000 ALTER TABLE `mdl_autocategory` DISABLE KEYS */;
INSERT INTO `mdl_autocategory` VALUES (1,'12,18,13,20,14,15,83,84,85,86,89,90,91','10,5,6,7,13,22,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',89,'11'),(2,'17,23,32,83,84,85,86,89,90,91','11,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',92,'16'),(3,'12,18,13,20,14,15,83,84,85,86,89,90,91','10,5,6,7,13,22,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',93,'11'),(4,'12,18,13,20,14,15,83,84,85,86,89,90,91','10,5,6,7,13,22,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',94,'11'),(5,'17,23,32,83,84,85,86,89,90,91','11,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',95,'16'),(6,'17,23,32,83,84,85,86,89,90,91','11,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',96,'16'),(7,'12,18,13,20,14,15,83,84,85,86,89,90,91','10,5,6,7,13,22,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',97,'11'),(8,'3,4,5,6,7,21,22,8,9,12,18,13,20,14,17,23,32,60,63,62,64,65,67,83,84,85,86,89,90,91','16,17,18,12,2,3,4,24,15,14,10,5,6,7,22,11,29,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',131,',2,11,16,58'),(9,'3,4,5,6,7,21,22,8,9,12,18,13,20,14,17,23,32,60,63,62,64,65,67,83,84,85,86,89,90,91','16,17,18,12,2,3,4,24,15,14,10,5,6,7,22,11,29,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',132,',2,11,16,58'),(10,'3,4,5,6,7,21,22,8,9,70,12,18,13,20,14,17,23,32,83,84,85,86,89,90,91','16,17,18,12,2,3,4,24,15,14,10,5,6,7,22,11,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',133,',2,11,16'),(11,'3,4,5,6,7,21,22,8,9,70,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,15,14,61,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',134,',2'),(12,'3,4,5,6,7,21,22,8,9,70,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,15,14,61,62,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',137,',2'),(13,'60,63,62,64,65,67,83,84,85,86,89,90,91','29,72,73,74,75,76,77,78,81,82,83,84,85',140,',58'),(14,'17,23,32,83,84,85,86,89,90,91','11,48,49,50,54,57,58,60,72,73,74,75,76,77,78,81,82,83,84,85',143,',16'),(15,'3,4,5,6,7,21,22,8,9,70,12,18,13,20,14,17,23,32,60,63,62,64,65,67,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,68,15,66,14,61,62,64,65,67,69,70,71,10,5,6,7,59,22,11,48,49,50,54,57,58,60,29,72,73,74,75,76,77,78,81,82,83,84,85',144,',2,11,16,58'),(16,'3,4,5,6,7,21,22,8,9,70,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,68,15,66,14,61,62,64,65,67,69,70,71,72,73,74,75,76,77,78,81,82,83,84,85',145,',2'),(17,'3,4,5,6,7,21,22,8,9,70,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,68,72,66,73,74,14,61,62,64,65,67,69,70,71,75,76,77,78,81,82,83,84,85',148,',2'),(18,'3,4,5,6,7,21,22,8,9,70,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,68,72,66,73,74,14,61,62,64,65,67,69,70,71,75,76,77,78,81,82,83,84,85',152,',2'),(19,'3,4,5,6,7,21,22,8,71,9,70,83,84,85,86,89,90,91','16,17,18,56,12,2,3,4,24,68,75,76,77,72,66,73,74,14,61,62,64,65,67,69,70,71,78,81,82,83,84,85',155,',2'),(20,NULL,',85',175,NULL),(21,',3,4,5,6,7,21,22,8,71,81,82,83,9,70,79,80,3,4,5,6,7,21,22,8,71,81,82,83,9,70,79,80,12,18,13,20,14','16,17,18,56,12,2,3,4,24,68,75,76,77,82,84,72,66,73,74,14,61,62,64,65,67,69,70,71,78,10,5,6,7,59,22,85',176,',2,11');
/*!40000 ALTER TABLE `mdl_autocategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_controllers`
--

DROP TABLE IF EXISTS `mdl_backup_controllers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_controllers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `operation` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backup',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `format` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `interactive` smallint(4) NOT NULL,
  `purpose` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` smallint(4) NOT NULL,
  `execution` smallint(4) NOT NULL,
  `executiontime` bigint(10) NOT NULL,
  `checksum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `progress` decimal(15,14) NOT NULL DEFAULT '0.00000000000000',
  `controller` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcont_bac_uix` (`backupid`),
  KEY `mdl_backcont_typite_ix` (`type`,`itemid`),
  KEY `mdl_backcont_useite_ix` (`userid`,`itemid`),
  KEY `mdl_backcont_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store the backup_controllers as they are used';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_controllers`
--

LOCK TABLES `mdl_backup_controllers` WRITE;
/*!40000 ALTER TABLE `mdl_backup_controllers` DISABLE KEYS */;
INSERT INTO `mdl_backup_controllers` VALUES (1,'ca6c0af4a03b9deb20fef6603f218cff','backup','course',9,'moodle2',0,50,2,1000,1,0,'83c8018d9565598268f96e7578d05ef5',1663413569,1663413570,0.00000000000000,''),(2,'e20714bbcea1f719f6dd542293c88824','backup','course',8,'moodle2',0,50,2,1000,1,0,'18d818c206f14c391843bb4c72c6be71',1663413577,1663413577,0.00000000000000,''),(3,'2d6c008bd7a8b82518501d80a5957e5b','backup','course',21,'moodle2',0,50,2,1000,1,0,'ce2eae602849b49311a55ec2de7c115e',1664634291,1664634291,0.00000000000000,''),(4,'dc91f11259034bf55b42f0c3632fbf2b','backup','course',26,'moodle2',0,50,2,1000,1,0,'0fff1630a4eb433ae27e058e85c61f21',1665392056,1665392057,0.00000000000000,''),(5,'ca8b35f186392bbae4e5901ed8157f2f','backup','course',25,'moodle2',0,50,2,1000,1,0,'1b0e559dd6265686c3f5bbaf45c11c55',1665392057,1665392057,0.00000000000000,''),(6,'4e19049d096cb28adb5b7e7747a104cc','backup','course',23,'moodle2',0,50,2,1000,1,0,'7de53e1a71fa42030621730a17b875d3',1665392082,1665392082,0.00000000000000,''),(7,'3cae7dc7667feccd2e8f318015b6333d','backup','course',19,'moodle2',0,50,2,1000,1,0,'3729171a35bbd11d08e82910d575016f',1665392148,1665392148,0.00000000000000,''),(8,'b7d20fdff54ea1258c14cd3995e25816','backup','course',20,'moodle2',0,50,2,1000,1,0,'1ab592ad3f3442871969e55b5b043543',1665392148,1665392149,0.00000000000000,''),(9,'774ea026b05ef3d8ade8636b13c13b1d','backup','course',41,'moodle2',0,50,2,1000,1,0,'55b4d6ac8ef4940bdcfe2f2775cc2d17',1665398421,1665398421,0.00000000000000,''),(10,'97c34b23a3c4da9d73b98f5f3315142a','backup','course',44,'moodle2',0,50,2,1000,1,0,'37cb230e5c575e58858d4bba2cabddb6',1665828981,1665828981,0.00000000000000,''),(11,'4a70e92d7d1fba9ae2ad8d2f82067a17','backup','course',31,'moodle2',0,50,2,1000,1,0,'2b1a35caac82dad695d13457e81705e4',1665829381,1665829381,0.00000000000000,''),(12,'a9a601fd61e98d111477e4f451c40bed','backup','course',32,'moodle2',0,50,2,1000,1,0,'582ef9392f229cae9cd67577bc179ede',1665829449,1665829450,0.00000000000000,''),(13,'8a46bf98a2b1bae3b436c32fbff65d9e','backup','course',42,'moodle2',0,50,2,1000,1,0,'781f1a555467046b5cb95814081b4bd2',1665829550,1665829550,0.00000000000000,''),(14,'bb03e35741dc91556eb9014cde972ee9','backup','course',39,'moodle2',0,50,2,1000,1,0,'b40c3a8fd152229ad1df5c8c7bed75da',1665829550,1665829550,0.00000000000000,''),(15,'5c614d16a71eb798d599e472755fd84b','backup','course',38,'moodle2',0,50,2,1000,1,0,'517902773516735eec91ffc939ff2323',1665829550,1665829550,0.00000000000000,''),(16,'3aef20b76b49e34d10662cb9132ba91a','backup','course',37,'moodle2',0,50,2,1000,1,0,'d747e28ff76c4506f76748d7b03dce46',1665829550,1665829550,0.00000000000000,''),(17,'68c7556f26e0b6cce7336938c02b8fd4','backup','course',36,'moodle2',0,50,2,1000,1,0,'961fa8c37b9704fe7241f5ca76bddacc',1665829550,1665829551,0.00000000000000,''),(18,'a8740089ad0b7fc12ee5713b9a453865','backup','course',35,'moodle2',0,50,2,1000,1,0,'08d20b20c0cdce27a6cc7fb4d8276c7c',1665829551,1665829551,0.00000000000000,''),(19,'65f39c262e67cac33fe070c4d7d89246','backup','course',34,'moodle2',0,50,2,1000,1,0,'b15e954dfa46874af6c1b34172613f38',1665829551,1665829551,0.00000000000000,''),(20,'bb8fae0ec1a4eda1ac14c761e3619e57','backup','course',30,'moodle2',0,50,2,1000,1,0,'1c97bccab93e09a4c4399d613d3605ae',1665829551,1665829551,0.00000000000000,''),(21,'08d0834bba7c0d49567db7b96294fe87','backup','course',13,'moodle2',0,50,2,1000,1,0,'bafd4439c88a93d6f25a25d660ae5460',1665829551,1665829551,0.00000000000000,''),(22,'f8a13327ae043b18e896ce847cf45480','backup','course',33,'moodle2',0,50,2,1000,1,0,'1cdc1fbf03cb690e92b5630d81a45e28',1665831456,1665831456,0.00000000000000,''),(23,'64c4b4f875b50db38df0eb44fb98f9eb','backup','course',28,'moodle2',0,50,2,1000,1,0,'e521dcd5a163dfd100c5b0a1ce553559',1665831457,1665831457,0.00000000000000,''),(24,'ce6bcaf6f27564db6d8935a385f0d46c','backup','course',27,'moodle2',0,50,2,1000,1,0,'af853d7cdd7ee8155a967a42e351757d',1665831457,1665831457,0.00000000000000,''),(25,'32e8ec9e7b5ba614dd7e6972185c7865','backup','course',43,'moodle2',0,50,2,1000,1,0,'a2913cc45924de09ecebe933fa086616',1665831855,1665831855,0.00000000000000,''),(26,'de3ef7af0828a8d2e98fb98daaa30a6f','backup','course',40,'moodle2',0,50,2,1000,1,0,'5db122e9e4b554570e0502057755ebb5',1665831855,1665831855,0.00000000000000,''),(27,'89f255ac5a852add5d6db61eb97fd161','backup','course',47,'moodle2',0,50,2,1000,1,0,'bea28b5a4cfe098fb10ed409629e5f0b',1665987543,1665987543,0.00000000000000,''),(28,'175eb986841cb5da479a937688500695','backup','course',53,'moodle2',0,50,2,1000,1,0,'713624379460997144d480a8cdf93a59',1665989035,1665989035,0.00000000000000,''),(29,'78f0fa625eb38026c5eaefc519b2e0e5','backup','course',52,'moodle2',0,50,2,1000,1,0,'005caef09f7429aceeac50c7a04cf99b',1665989044,1665989044,0.00000000000000,''),(30,'3163b0a44836466b259045e0d86cb46a','backup','course',51,'moodle2',0,50,2,1000,1,0,'0527e28d38f8dc22cd6ea09be3dc8b91',1665989054,1665989054,0.00000000000000,''),(31,'10046a43cc7d2aff18fc40e0c343cabe','backup','course',63,'moodle2',0,50,2,1000,1,0,'6e86fe1bd36b0663bf29f81148257680',1666010117,1666010117,0.00000000000000,''),(32,'0c8e1a1aaba9605070518fb4a93f5a25','backup','course',55,'moodle2',0,50,2,1000,1,0,'5a8734d4f96ea8ea1863d706f3e6319b',1666020873,1666020873,0.00000000000000,''),(33,'095bdbe04b548aed996cfb179bea596b','backup','course',46,'moodle2',0,50,2,1000,1,0,'13a2939b6cd9253f48d7b0401c86e9df',1666020964,1666020964,0.00000000000000,''),(34,'30264b5dbc7393e355753bb104e8322b','backup','course',15,'moodle2',0,50,2,1000,1,0,'f7250d0a40a573a7cf25457c678a89db',1666067412,1666067413,0.00000000000000,''),(35,'4aebea948100adb2d29cb26b7995aa7a','backup','activity',56,'moodle2',0,20,2,1000,1,0,'52a69c0d182b883c5bf7ee72fd330ea4',1666156208,1666156208,0.00000000000000,''),(36,'ffe8429bd14778bfb6c7f5ef653b475d','restore','activity',2,'moodle2',0,20,2,1000,1,0,'f40cb33d5510114dbe94d6b41c8f3c22',1666156208,1666156208,0.00000000000000,'');
/*!40000 ALTER TABLE `mdl_backup_controllers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_courses`
--

DROP TABLE IF EXISTS `mdl_backup_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) NOT NULL DEFAULT '0',
  `lastendtime` bigint(10) NOT NULL DEFAULT '0',
  `laststatus` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5',
  `nextstarttime` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store every course backup status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_courses`
--

LOCK TABLES `mdl_backup_courses` WRITE;
/*!40000 ALTER TABLE `mdl_backup_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_backup_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_backup_logs`
--

DROP TABLE IF EXISTS `mdl_backup_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_backup_logs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `loglevel` smallint(4) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_backlogs_bacid_uix` (`backupid`,`id`),
  KEY `mdl_backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB AUTO_INCREMENT=656 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='To store all the logs from backup and restore operations (by';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_backup_logs`
--

LOCK TABLES `mdl_backup_logs` WRITE;
/*!40000 ALTER TABLE `mdl_backup_logs` DISABLE KEYS */;
INSERT INTO `mdl_backup_logs` VALUES (1,'2d6c008bd7a8b82518501d80a5957e5b',40,'instantiating backup controller 2d6c008bd7a8b82518501d80a5957e5b',1664634291),(2,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting controller status to 100',1664634291),(3,'2d6c008bd7a8b82518501d80a5957e5b',50,'loading controller plan',1664634291),(4,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting controller status to 300',1664634291),(5,'2d6c008bd7a8b82518501d80a5957e5b',50,'applying plan defaults',1664634291),(6,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting controller status to 400',1664634291),(7,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting file inclusion to ',1664634291),(8,'2d6c008bd7a8b82518501d80a5957e5b',40,'checking plan security',1664634291),(9,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting controller status to 700',1664634291),(10,'2d6c008bd7a8b82518501d80a5957e5b',50,'saving controller to db',1664634291),(11,'2d6c008bd7a8b82518501d80a5957e5b',50,'calculating controller checksum d6f465ef1f7234405436b4e4fc969b7a',1664634291),(12,'2d6c008bd7a8b82518501d80a5957e5b',50,'loading controller from db',1664634291),(13,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting file inclusion to 1',1664634291),(14,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting controller status to 800',1664634291),(15,'2d6c008bd7a8b82518501d80a5957e5b',50,'saving controller to db',1664634291),(16,'2d6c008bd7a8b82518501d80a5957e5b',50,'calculating controller checksum ce2eae602849b49311a55ec2de7c115e',1664634291),(17,'2d6c008bd7a8b82518501d80a5957e5b',50,'loading controller from db',1664634291),(18,'2d6c008bd7a8b82518501d80a5957e5b',50,'setting controller status to 1000',1664634291),(19,'2d6c008bd7a8b82518501d80a5957e5b',50,'saving controller to db',1664634291),(20,'dc91f11259034bf55b42f0c3632fbf2b',40,'instantiating backup controller dc91f11259034bf55b42f0c3632fbf2b',1665392056),(21,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting controller status to 100',1665392056),(22,'dc91f11259034bf55b42f0c3632fbf2b',50,'loading controller plan',1665392056),(23,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting controller status to 300',1665392056),(24,'dc91f11259034bf55b42f0c3632fbf2b',50,'applying plan defaults',1665392056),(25,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting controller status to 400',1665392056),(26,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting file inclusion to ',1665392056),(27,'dc91f11259034bf55b42f0c3632fbf2b',40,'checking plan security',1665392056),(28,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting controller status to 700',1665392056),(29,'dc91f11259034bf55b42f0c3632fbf2b',50,'saving controller to db',1665392056),(30,'dc91f11259034bf55b42f0c3632fbf2b',50,'calculating controller checksum 80f6448d09481b377716ef645ecb741e',1665392056),(31,'dc91f11259034bf55b42f0c3632fbf2b',50,'loading controller from db',1665392056),(32,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting file inclusion to 1',1665392057),(33,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting controller status to 800',1665392057),(34,'dc91f11259034bf55b42f0c3632fbf2b',50,'saving controller to db',1665392057),(35,'dc91f11259034bf55b42f0c3632fbf2b',50,'calculating controller checksum 0fff1630a4eb433ae27e058e85c61f21',1665392057),(36,'dc91f11259034bf55b42f0c3632fbf2b',50,'loading controller from db',1665392057),(37,'dc91f11259034bf55b42f0c3632fbf2b',50,'setting controller status to 1000',1665392057),(38,'dc91f11259034bf55b42f0c3632fbf2b',50,'saving controller to db',1665392057),(39,'ca8b35f186392bbae4e5901ed8157f2f',40,'instantiating backup controller ca8b35f186392bbae4e5901ed8157f2f',1665392057),(40,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting controller status to 100',1665392057),(41,'ca8b35f186392bbae4e5901ed8157f2f',50,'loading controller plan',1665392057),(42,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting controller status to 300',1665392057),(43,'ca8b35f186392bbae4e5901ed8157f2f',50,'applying plan defaults',1665392057),(44,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting controller status to 400',1665392057),(45,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting file inclusion to ',1665392057),(46,'ca8b35f186392bbae4e5901ed8157f2f',40,'checking plan security',1665392057),(47,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting controller status to 700',1665392057),(48,'ca8b35f186392bbae4e5901ed8157f2f',50,'saving controller to db',1665392057),(49,'ca8b35f186392bbae4e5901ed8157f2f',50,'calculating controller checksum 046231f7455dac0fdc4d5f6ad2b12098',1665392057),(50,'ca8b35f186392bbae4e5901ed8157f2f',50,'loading controller from db',1665392057),(51,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting file inclusion to 1',1665392057),(52,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting controller status to 800',1665392057),(53,'ca8b35f186392bbae4e5901ed8157f2f',50,'saving controller to db',1665392057),(54,'ca8b35f186392bbae4e5901ed8157f2f',50,'calculating controller checksum 1b0e559dd6265686c3f5bbaf45c11c55',1665392057),(55,'ca8b35f186392bbae4e5901ed8157f2f',50,'loading controller from db',1665392057),(56,'ca8b35f186392bbae4e5901ed8157f2f',50,'setting controller status to 1000',1665392057),(57,'ca8b35f186392bbae4e5901ed8157f2f',50,'saving controller to db',1665392057),(58,'4e19049d096cb28adb5b7e7747a104cc',40,'instantiating backup controller 4e19049d096cb28adb5b7e7747a104cc',1665392082),(59,'4e19049d096cb28adb5b7e7747a104cc',50,'setting controller status to 100',1665392082),(60,'4e19049d096cb28adb5b7e7747a104cc',50,'loading controller plan',1665392082),(61,'4e19049d096cb28adb5b7e7747a104cc',50,'setting controller status to 300',1665392082),(62,'4e19049d096cb28adb5b7e7747a104cc',50,'applying plan defaults',1665392082),(63,'4e19049d096cb28adb5b7e7747a104cc',50,'setting controller status to 400',1665392082),(64,'4e19049d096cb28adb5b7e7747a104cc',50,'setting file inclusion to ',1665392082),(65,'4e19049d096cb28adb5b7e7747a104cc',40,'checking plan security',1665392082),(66,'4e19049d096cb28adb5b7e7747a104cc',50,'setting controller status to 700',1665392082),(67,'4e19049d096cb28adb5b7e7747a104cc',50,'saving controller to db',1665392082),(68,'4e19049d096cb28adb5b7e7747a104cc',50,'calculating controller checksum 057e913e986b3984e936cd654a0485c5',1665392082),(69,'4e19049d096cb28adb5b7e7747a104cc',50,'loading controller from db',1665392082),(70,'4e19049d096cb28adb5b7e7747a104cc',50,'setting file inclusion to 1',1665392082),(71,'4e19049d096cb28adb5b7e7747a104cc',50,'setting controller status to 800',1665392082),(72,'4e19049d096cb28adb5b7e7747a104cc',50,'saving controller to db',1665392082),(73,'4e19049d096cb28adb5b7e7747a104cc',50,'calculating controller checksum 7de53e1a71fa42030621730a17b875d3',1665392082),(74,'4e19049d096cb28adb5b7e7747a104cc',50,'loading controller from db',1665392082),(75,'4e19049d096cb28adb5b7e7747a104cc',50,'setting controller status to 1000',1665392082),(76,'4e19049d096cb28adb5b7e7747a104cc',50,'saving controller to db',1665392082),(77,'3cae7dc7667feccd2e8f318015b6333d',40,'instantiating backup controller 3cae7dc7667feccd2e8f318015b6333d',1665392148),(78,'3cae7dc7667feccd2e8f318015b6333d',50,'setting controller status to 100',1665392148),(79,'3cae7dc7667feccd2e8f318015b6333d',50,'loading controller plan',1665392148),(80,'3cae7dc7667feccd2e8f318015b6333d',50,'setting controller status to 300',1665392148),(81,'3cae7dc7667feccd2e8f318015b6333d',50,'applying plan defaults',1665392148),(82,'3cae7dc7667feccd2e8f318015b6333d',50,'setting controller status to 400',1665392148),(83,'3cae7dc7667feccd2e8f318015b6333d',50,'setting file inclusion to ',1665392148),(84,'3cae7dc7667feccd2e8f318015b6333d',40,'checking plan security',1665392148),(85,'3cae7dc7667feccd2e8f318015b6333d',50,'setting controller status to 700',1665392148),(86,'3cae7dc7667feccd2e8f318015b6333d',50,'saving controller to db',1665392148),(87,'3cae7dc7667feccd2e8f318015b6333d',50,'calculating controller checksum 45d224c96e380da8533cbb652fd9b649',1665392148),(88,'3cae7dc7667feccd2e8f318015b6333d',50,'loading controller from db',1665392148),(89,'3cae7dc7667feccd2e8f318015b6333d',50,'setting file inclusion to 1',1665392148),(90,'3cae7dc7667feccd2e8f318015b6333d',50,'setting controller status to 800',1665392148),(91,'3cae7dc7667feccd2e8f318015b6333d',50,'saving controller to db',1665392148),(92,'3cae7dc7667feccd2e8f318015b6333d',50,'calculating controller checksum 3729171a35bbd11d08e82910d575016f',1665392148),(93,'3cae7dc7667feccd2e8f318015b6333d',50,'loading controller from db',1665392148),(94,'3cae7dc7667feccd2e8f318015b6333d',50,'setting controller status to 1000',1665392148),(95,'3cae7dc7667feccd2e8f318015b6333d',50,'saving controller to db',1665392148),(96,'b7d20fdff54ea1258c14cd3995e25816',40,'instantiating backup controller b7d20fdff54ea1258c14cd3995e25816',1665392148),(97,'b7d20fdff54ea1258c14cd3995e25816',50,'setting controller status to 100',1665392148),(98,'b7d20fdff54ea1258c14cd3995e25816',50,'loading controller plan',1665392148),(99,'b7d20fdff54ea1258c14cd3995e25816',50,'setting controller status to 300',1665392148),(100,'b7d20fdff54ea1258c14cd3995e25816',50,'applying plan defaults',1665392148),(101,'b7d20fdff54ea1258c14cd3995e25816',50,'setting controller status to 400',1665392148),(102,'b7d20fdff54ea1258c14cd3995e25816',50,'setting file inclusion to ',1665392148),(103,'b7d20fdff54ea1258c14cd3995e25816',40,'checking plan security',1665392148),(104,'b7d20fdff54ea1258c14cd3995e25816',50,'setting controller status to 700',1665392148),(105,'b7d20fdff54ea1258c14cd3995e25816',50,'saving controller to db',1665392148),(106,'b7d20fdff54ea1258c14cd3995e25816',50,'calculating controller checksum 5669715b3ec111276fe82c6486354678',1665392148),(107,'b7d20fdff54ea1258c14cd3995e25816',50,'loading controller from db',1665392148),(108,'b7d20fdff54ea1258c14cd3995e25816',50,'setting file inclusion to 1',1665392148),(109,'b7d20fdff54ea1258c14cd3995e25816',50,'setting controller status to 800',1665392148),(110,'b7d20fdff54ea1258c14cd3995e25816',50,'saving controller to db',1665392148),(111,'b7d20fdff54ea1258c14cd3995e25816',50,'calculating controller checksum 1ab592ad3f3442871969e55b5b043543',1665392148),(112,'b7d20fdff54ea1258c14cd3995e25816',50,'loading controller from db',1665392148),(113,'b7d20fdff54ea1258c14cd3995e25816',50,'setting controller status to 1000',1665392149),(114,'b7d20fdff54ea1258c14cd3995e25816',50,'saving controller to db',1665392149),(115,'774ea026b05ef3d8ade8636b13c13b1d',40,'instantiating backup controller 774ea026b05ef3d8ade8636b13c13b1d',1665398421),(116,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting controller status to 100',1665398421),(117,'774ea026b05ef3d8ade8636b13c13b1d',50,'loading controller plan',1665398421),(118,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting controller status to 300',1665398421),(119,'774ea026b05ef3d8ade8636b13c13b1d',50,'applying plan defaults',1665398421),(120,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting controller status to 400',1665398421),(121,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting file inclusion to ',1665398421),(122,'774ea026b05ef3d8ade8636b13c13b1d',40,'checking plan security',1665398421),(123,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting controller status to 700',1665398421),(124,'774ea026b05ef3d8ade8636b13c13b1d',50,'saving controller to db',1665398421),(125,'774ea026b05ef3d8ade8636b13c13b1d',50,'calculating controller checksum 3b981ebf61a385cb1c1f4ad020c8f833',1665398421),(126,'774ea026b05ef3d8ade8636b13c13b1d',50,'loading controller from db',1665398421),(127,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting file inclusion to 1',1665398421),(128,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting controller status to 800',1665398421),(129,'774ea026b05ef3d8ade8636b13c13b1d',50,'saving controller to db',1665398421),(130,'774ea026b05ef3d8ade8636b13c13b1d',50,'calculating controller checksum 55b4d6ac8ef4940bdcfe2f2775cc2d17',1665398421),(131,'774ea026b05ef3d8ade8636b13c13b1d',50,'loading controller from db',1665398421),(132,'774ea026b05ef3d8ade8636b13c13b1d',50,'setting controller status to 1000',1665398421),(133,'774ea026b05ef3d8ade8636b13c13b1d',50,'saving controller to db',1665398421),(134,'97c34b23a3c4da9d73b98f5f3315142a',40,'instantiating backup controller 97c34b23a3c4da9d73b98f5f3315142a',1665828981),(135,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting controller status to 100',1665828981),(136,'97c34b23a3c4da9d73b98f5f3315142a',50,'loading controller plan',1665828981),(137,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting controller status to 300',1665828981),(138,'97c34b23a3c4da9d73b98f5f3315142a',50,'applying plan defaults',1665828981),(139,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting controller status to 400',1665828981),(140,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting file inclusion to ',1665828981),(141,'97c34b23a3c4da9d73b98f5f3315142a',40,'checking plan security',1665828981),(142,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting controller status to 700',1665828981),(143,'97c34b23a3c4da9d73b98f5f3315142a',50,'saving controller to db',1665828981),(144,'97c34b23a3c4da9d73b98f5f3315142a',50,'calculating controller checksum da5309f2c9cefba44c73ea82d1416952',1665828981),(145,'97c34b23a3c4da9d73b98f5f3315142a',50,'loading controller from db',1665828981),(146,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting file inclusion to 1',1665828981),(147,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting controller status to 800',1665828981),(148,'97c34b23a3c4da9d73b98f5f3315142a',50,'saving controller to db',1665828981),(149,'97c34b23a3c4da9d73b98f5f3315142a',50,'calculating controller checksum 37cb230e5c575e58858d4bba2cabddb6',1665828981),(150,'97c34b23a3c4da9d73b98f5f3315142a',50,'loading controller from db',1665828981),(151,'97c34b23a3c4da9d73b98f5f3315142a',50,'setting controller status to 1000',1665828981),(152,'97c34b23a3c4da9d73b98f5f3315142a',50,'saving controller to db',1665828981),(153,'4a70e92d7d1fba9ae2ad8d2f82067a17',40,'instantiating backup controller 4a70e92d7d1fba9ae2ad8d2f82067a17',1665829381),(154,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting controller status to 100',1665829381),(155,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'loading controller plan',1665829381),(156,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting controller status to 300',1665829381),(157,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'applying plan defaults',1665829381),(158,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting controller status to 400',1665829381),(159,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting file inclusion to ',1665829381),(160,'4a70e92d7d1fba9ae2ad8d2f82067a17',40,'checking plan security',1665829381),(161,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting controller status to 700',1665829381),(162,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'saving controller to db',1665829381),(163,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'calculating controller checksum 7108fabff639c014ac560f8e9b978bdd',1665829381),(164,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'loading controller from db',1665829381),(165,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting file inclusion to 1',1665829381),(166,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting controller status to 800',1665829381),(167,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'saving controller to db',1665829381),(168,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'calculating controller checksum 2b1a35caac82dad695d13457e81705e4',1665829381),(169,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'loading controller from db',1665829381),(170,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'setting controller status to 1000',1665829381),(171,'4a70e92d7d1fba9ae2ad8d2f82067a17',50,'saving controller to db',1665829381),(172,'a9a601fd61e98d111477e4f451c40bed',40,'instantiating backup controller a9a601fd61e98d111477e4f451c40bed',1665829449),(173,'a9a601fd61e98d111477e4f451c40bed',50,'setting controller status to 100',1665829449),(174,'a9a601fd61e98d111477e4f451c40bed',50,'loading controller plan',1665829449),(175,'a9a601fd61e98d111477e4f451c40bed',50,'setting controller status to 300',1665829449),(176,'a9a601fd61e98d111477e4f451c40bed',50,'applying plan defaults',1665829449),(177,'a9a601fd61e98d111477e4f451c40bed',50,'setting controller status to 400',1665829449),(178,'a9a601fd61e98d111477e4f451c40bed',50,'setting file inclusion to ',1665829449),(179,'a9a601fd61e98d111477e4f451c40bed',40,'checking plan security',1665829449),(180,'a9a601fd61e98d111477e4f451c40bed',50,'setting controller status to 700',1665829449),(181,'a9a601fd61e98d111477e4f451c40bed',50,'saving controller to db',1665829449),(182,'a9a601fd61e98d111477e4f451c40bed',50,'calculating controller checksum ef9911308223abe6f8500d59beb273db',1665829449),(183,'a9a601fd61e98d111477e4f451c40bed',50,'loading controller from db',1665829449),(184,'a9a601fd61e98d111477e4f451c40bed',50,'setting file inclusion to 1',1665829449),(185,'a9a601fd61e98d111477e4f451c40bed',50,'setting controller status to 800',1665829449),(186,'a9a601fd61e98d111477e4f451c40bed',50,'saving controller to db',1665829449),(187,'a9a601fd61e98d111477e4f451c40bed',50,'calculating controller checksum 582ef9392f229cae9cd67577bc179ede',1665829450),(188,'a9a601fd61e98d111477e4f451c40bed',50,'loading controller from db',1665829450),(189,'a9a601fd61e98d111477e4f451c40bed',50,'setting controller status to 1000',1665829450),(190,'a9a601fd61e98d111477e4f451c40bed',50,'saving controller to db',1665829450),(191,'8a46bf98a2b1bae3b436c32fbff65d9e',40,'instantiating backup controller 8a46bf98a2b1bae3b436c32fbff65d9e',1665829550),(192,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting controller status to 100',1665829550),(193,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'loading controller plan',1665829550),(194,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting controller status to 300',1665829550),(195,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'applying plan defaults',1665829550),(196,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting controller status to 400',1665829550),(197,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting file inclusion to ',1665829550),(198,'8a46bf98a2b1bae3b436c32fbff65d9e',40,'checking plan security',1665829550),(199,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting controller status to 700',1665829550),(200,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'saving controller to db',1665829550),(201,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'calculating controller checksum c0b41d0a5c578482a89cab4549fa7841',1665829550),(202,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'loading controller from db',1665829550),(203,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting file inclusion to 1',1665829550),(204,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting controller status to 800',1665829550),(205,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'saving controller to db',1665829550),(206,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'calculating controller checksum 781f1a555467046b5cb95814081b4bd2',1665829550),(207,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'loading controller from db',1665829550),(208,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'setting controller status to 1000',1665829550),(209,'8a46bf98a2b1bae3b436c32fbff65d9e',50,'saving controller to db',1665829550),(210,'bb03e35741dc91556eb9014cde972ee9',40,'instantiating backup controller bb03e35741dc91556eb9014cde972ee9',1665829550),(211,'bb03e35741dc91556eb9014cde972ee9',50,'setting controller status to 100',1665829550),(212,'bb03e35741dc91556eb9014cde972ee9',50,'loading controller plan',1665829550),(213,'bb03e35741dc91556eb9014cde972ee9',50,'setting controller status to 300',1665829550),(214,'bb03e35741dc91556eb9014cde972ee9',50,'applying plan defaults',1665829550),(215,'bb03e35741dc91556eb9014cde972ee9',50,'setting controller status to 400',1665829550),(216,'bb03e35741dc91556eb9014cde972ee9',50,'setting file inclusion to ',1665829550),(217,'bb03e35741dc91556eb9014cde972ee9',40,'checking plan security',1665829550),(218,'bb03e35741dc91556eb9014cde972ee9',50,'setting controller status to 700',1665829550),(219,'bb03e35741dc91556eb9014cde972ee9',50,'saving controller to db',1665829550),(220,'bb03e35741dc91556eb9014cde972ee9',50,'calculating controller checksum 8300dcdaa8f62755836b2cc315cfa4a0',1665829550),(221,'bb03e35741dc91556eb9014cde972ee9',50,'loading controller from db',1665829550),(222,'bb03e35741dc91556eb9014cde972ee9',50,'setting file inclusion to 1',1665829550),(223,'bb03e35741dc91556eb9014cde972ee9',50,'setting controller status to 800',1665829550),(224,'bb03e35741dc91556eb9014cde972ee9',50,'saving controller to db',1665829550),(225,'bb03e35741dc91556eb9014cde972ee9',50,'calculating controller checksum b40c3a8fd152229ad1df5c8c7bed75da',1665829550),(226,'bb03e35741dc91556eb9014cde972ee9',50,'loading controller from db',1665829550),(227,'bb03e35741dc91556eb9014cde972ee9',50,'setting controller status to 1000',1665829550),(228,'bb03e35741dc91556eb9014cde972ee9',50,'saving controller to db',1665829550),(229,'5c614d16a71eb798d599e472755fd84b',40,'instantiating backup controller 5c614d16a71eb798d599e472755fd84b',1665829550),(230,'5c614d16a71eb798d599e472755fd84b',50,'setting controller status to 100',1665829550),(231,'5c614d16a71eb798d599e472755fd84b',50,'loading controller plan',1665829550),(232,'5c614d16a71eb798d599e472755fd84b',50,'setting controller status to 300',1665829550),(233,'5c614d16a71eb798d599e472755fd84b',50,'applying plan defaults',1665829550),(234,'5c614d16a71eb798d599e472755fd84b',50,'setting controller status to 400',1665829550),(235,'5c614d16a71eb798d599e472755fd84b',50,'setting file inclusion to ',1665829550),(236,'5c614d16a71eb798d599e472755fd84b',40,'checking plan security',1665829550),(237,'5c614d16a71eb798d599e472755fd84b',50,'setting controller status to 700',1665829550),(238,'5c614d16a71eb798d599e472755fd84b',50,'saving controller to db',1665829550),(239,'5c614d16a71eb798d599e472755fd84b',50,'calculating controller checksum 031b99dfe6bd7e60a0ead31e9bcad507',1665829550),(240,'5c614d16a71eb798d599e472755fd84b',50,'loading controller from db',1665829550),(241,'5c614d16a71eb798d599e472755fd84b',50,'setting file inclusion to 1',1665829550),(242,'5c614d16a71eb798d599e472755fd84b',50,'setting controller status to 800',1665829550),(243,'5c614d16a71eb798d599e472755fd84b',50,'saving controller to db',1665829550),(244,'5c614d16a71eb798d599e472755fd84b',50,'calculating controller checksum 517902773516735eec91ffc939ff2323',1665829550),(245,'5c614d16a71eb798d599e472755fd84b',50,'loading controller from db',1665829550),(246,'5c614d16a71eb798d599e472755fd84b',50,'setting controller status to 1000',1665829550),(247,'5c614d16a71eb798d599e472755fd84b',50,'saving controller to db',1665829550),(248,'3aef20b76b49e34d10662cb9132ba91a',40,'instantiating backup controller 3aef20b76b49e34d10662cb9132ba91a',1665829550),(249,'3aef20b76b49e34d10662cb9132ba91a',50,'setting controller status to 100',1665829550),(250,'3aef20b76b49e34d10662cb9132ba91a',50,'loading controller plan',1665829550),(251,'3aef20b76b49e34d10662cb9132ba91a',50,'setting controller status to 300',1665829550),(252,'3aef20b76b49e34d10662cb9132ba91a',50,'applying plan defaults',1665829550),(253,'3aef20b76b49e34d10662cb9132ba91a',50,'setting controller status to 400',1665829550),(254,'3aef20b76b49e34d10662cb9132ba91a',50,'setting file inclusion to ',1665829550),(255,'3aef20b76b49e34d10662cb9132ba91a',40,'checking plan security',1665829550),(256,'3aef20b76b49e34d10662cb9132ba91a',50,'setting controller status to 700',1665829550),(257,'3aef20b76b49e34d10662cb9132ba91a',50,'saving controller to db',1665829550),(258,'3aef20b76b49e34d10662cb9132ba91a',50,'calculating controller checksum 42cc1ba3331ab096fbc81f84492c6ec0',1665829550),(259,'3aef20b76b49e34d10662cb9132ba91a',50,'loading controller from db',1665829550),(260,'3aef20b76b49e34d10662cb9132ba91a',50,'setting file inclusion to 1',1665829550),(261,'3aef20b76b49e34d10662cb9132ba91a',50,'setting controller status to 800',1665829550),(262,'3aef20b76b49e34d10662cb9132ba91a',50,'saving controller to db',1665829550),(263,'3aef20b76b49e34d10662cb9132ba91a',50,'calculating controller checksum d747e28ff76c4506f76748d7b03dce46',1665829550),(264,'3aef20b76b49e34d10662cb9132ba91a',50,'loading controller from db',1665829550),(265,'3aef20b76b49e34d10662cb9132ba91a',50,'setting controller status to 1000',1665829550),(266,'3aef20b76b49e34d10662cb9132ba91a',50,'saving controller to db',1665829550),(267,'68c7556f26e0b6cce7336938c02b8fd4',40,'instantiating backup controller 68c7556f26e0b6cce7336938c02b8fd4',1665829550),(268,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting controller status to 100',1665829550),(269,'68c7556f26e0b6cce7336938c02b8fd4',50,'loading controller plan',1665829550),(270,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting controller status to 300',1665829550),(271,'68c7556f26e0b6cce7336938c02b8fd4',50,'applying plan defaults',1665829550),(272,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting controller status to 400',1665829550),(273,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting file inclusion to ',1665829550),(274,'68c7556f26e0b6cce7336938c02b8fd4',40,'checking plan security',1665829550),(275,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting controller status to 700',1665829550),(276,'68c7556f26e0b6cce7336938c02b8fd4',50,'saving controller to db',1665829550),(277,'68c7556f26e0b6cce7336938c02b8fd4',50,'calculating controller checksum 8475ef7d06ce90f07b2ce59294f19876',1665829550),(278,'68c7556f26e0b6cce7336938c02b8fd4',50,'loading controller from db',1665829550),(279,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting file inclusion to 1',1665829550),(280,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting controller status to 800',1665829551),(281,'68c7556f26e0b6cce7336938c02b8fd4',50,'saving controller to db',1665829551),(282,'68c7556f26e0b6cce7336938c02b8fd4',50,'calculating controller checksum 961fa8c37b9704fe7241f5ca76bddacc',1665829551),(283,'68c7556f26e0b6cce7336938c02b8fd4',50,'loading controller from db',1665829551),(284,'68c7556f26e0b6cce7336938c02b8fd4',50,'setting controller status to 1000',1665829551),(285,'68c7556f26e0b6cce7336938c02b8fd4',50,'saving controller to db',1665829551),(286,'a8740089ad0b7fc12ee5713b9a453865',40,'instantiating backup controller a8740089ad0b7fc12ee5713b9a453865',1665829551),(287,'a8740089ad0b7fc12ee5713b9a453865',50,'setting controller status to 100',1665829551),(288,'a8740089ad0b7fc12ee5713b9a453865',50,'loading controller plan',1665829551),(289,'a8740089ad0b7fc12ee5713b9a453865',50,'setting controller status to 300',1665829551),(290,'a8740089ad0b7fc12ee5713b9a453865',50,'applying plan defaults',1665829551),(291,'a8740089ad0b7fc12ee5713b9a453865',50,'setting controller status to 400',1665829551),(292,'a8740089ad0b7fc12ee5713b9a453865',50,'setting file inclusion to ',1665829551),(293,'a8740089ad0b7fc12ee5713b9a453865',40,'checking plan security',1665829551),(294,'a8740089ad0b7fc12ee5713b9a453865',50,'setting controller status to 700',1665829551),(295,'a8740089ad0b7fc12ee5713b9a453865',50,'saving controller to db',1665829551),(296,'a8740089ad0b7fc12ee5713b9a453865',50,'calculating controller checksum 51645dbecbda2cd76fc16b428e0db20a',1665829551),(297,'a8740089ad0b7fc12ee5713b9a453865',50,'loading controller from db',1665829551),(298,'a8740089ad0b7fc12ee5713b9a453865',50,'setting file inclusion to 1',1665829551),(299,'a8740089ad0b7fc12ee5713b9a453865',50,'setting controller status to 800',1665829551),(300,'a8740089ad0b7fc12ee5713b9a453865',50,'saving controller to db',1665829551),(301,'a8740089ad0b7fc12ee5713b9a453865',50,'calculating controller checksum 08d20b20c0cdce27a6cc7fb4d8276c7c',1665829551),(302,'a8740089ad0b7fc12ee5713b9a453865',50,'loading controller from db',1665829551),(303,'a8740089ad0b7fc12ee5713b9a453865',50,'setting controller status to 1000',1665829551),(304,'a8740089ad0b7fc12ee5713b9a453865',50,'saving controller to db',1665829551),(305,'65f39c262e67cac33fe070c4d7d89246',40,'instantiating backup controller 65f39c262e67cac33fe070c4d7d89246',1665829551),(306,'65f39c262e67cac33fe070c4d7d89246',50,'setting controller status to 100',1665829551),(307,'65f39c262e67cac33fe070c4d7d89246',50,'loading controller plan',1665829551),(308,'65f39c262e67cac33fe070c4d7d89246',50,'setting controller status to 300',1665829551),(309,'65f39c262e67cac33fe070c4d7d89246',50,'applying plan defaults',1665829551),(310,'65f39c262e67cac33fe070c4d7d89246',50,'setting controller status to 400',1665829551),(311,'65f39c262e67cac33fe070c4d7d89246',50,'setting file inclusion to ',1665829551),(312,'65f39c262e67cac33fe070c4d7d89246',40,'checking plan security',1665829551),(313,'65f39c262e67cac33fe070c4d7d89246',50,'setting controller status to 700',1665829551),(314,'65f39c262e67cac33fe070c4d7d89246',50,'saving controller to db',1665829551),(315,'65f39c262e67cac33fe070c4d7d89246',50,'calculating controller checksum edaf818c8f8488028bd6dacab2a3a38e',1665829551),(316,'65f39c262e67cac33fe070c4d7d89246',50,'loading controller from db',1665829551),(317,'65f39c262e67cac33fe070c4d7d89246',50,'setting file inclusion to 1',1665829551),(318,'65f39c262e67cac33fe070c4d7d89246',50,'setting controller status to 800',1665829551),(319,'65f39c262e67cac33fe070c4d7d89246',50,'saving controller to db',1665829551),(320,'65f39c262e67cac33fe070c4d7d89246',50,'calculating controller checksum b15e954dfa46874af6c1b34172613f38',1665829551),(321,'65f39c262e67cac33fe070c4d7d89246',50,'loading controller from db',1665829551),(322,'65f39c262e67cac33fe070c4d7d89246',50,'setting controller status to 1000',1665829551),(323,'65f39c262e67cac33fe070c4d7d89246',50,'saving controller to db',1665829551),(324,'bb8fae0ec1a4eda1ac14c761e3619e57',40,'instantiating backup controller bb8fae0ec1a4eda1ac14c761e3619e57',1665829551),(325,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting controller status to 100',1665829551),(326,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'loading controller plan',1665829551),(327,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting controller status to 300',1665829551),(328,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'applying plan defaults',1665829551),(329,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting controller status to 400',1665829551),(330,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting file inclusion to ',1665829551),(331,'bb8fae0ec1a4eda1ac14c761e3619e57',40,'checking plan security',1665829551),(332,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting controller status to 700',1665829551),(333,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'saving controller to db',1665829551),(334,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'calculating controller checksum 9c8dd57fa5ec3210f2581bbc46891887',1665829551),(335,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'loading controller from db',1665829551),(336,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting file inclusion to 1',1665829551),(337,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting controller status to 800',1665829551),(338,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'saving controller to db',1665829551),(339,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'calculating controller checksum 1c97bccab93e09a4c4399d613d3605ae',1665829551),(340,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'loading controller from db',1665829551),(341,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'setting controller status to 1000',1665829551),(342,'bb8fae0ec1a4eda1ac14c761e3619e57',50,'saving controller to db',1665829551),(343,'08d0834bba7c0d49567db7b96294fe87',40,'instantiating backup controller 08d0834bba7c0d49567db7b96294fe87',1665829551),(344,'08d0834bba7c0d49567db7b96294fe87',50,'setting controller status to 100',1665829551),(345,'08d0834bba7c0d49567db7b96294fe87',50,'loading controller plan',1665829551),(346,'08d0834bba7c0d49567db7b96294fe87',50,'setting controller status to 300',1665829551),(347,'08d0834bba7c0d49567db7b96294fe87',50,'applying plan defaults',1665829551),(348,'08d0834bba7c0d49567db7b96294fe87',50,'setting controller status to 400',1665829551),(349,'08d0834bba7c0d49567db7b96294fe87',50,'setting file inclusion to ',1665829551),(350,'08d0834bba7c0d49567db7b96294fe87',40,'checking plan security',1665829551),(351,'08d0834bba7c0d49567db7b96294fe87',50,'setting controller status to 700',1665829551),(352,'08d0834bba7c0d49567db7b96294fe87',50,'saving controller to db',1665829551),(353,'08d0834bba7c0d49567db7b96294fe87',50,'calculating controller checksum e4d991a0daa7083d5d2b4158b437cd0a',1665829551),(354,'08d0834bba7c0d49567db7b96294fe87',50,'loading controller from db',1665829551),(355,'08d0834bba7c0d49567db7b96294fe87',50,'setting file inclusion to 1',1665829551),(356,'08d0834bba7c0d49567db7b96294fe87',50,'setting controller status to 800',1665829551),(357,'08d0834bba7c0d49567db7b96294fe87',50,'saving controller to db',1665829551),(358,'08d0834bba7c0d49567db7b96294fe87',50,'calculating controller checksum bafd4439c88a93d6f25a25d660ae5460',1665829551),(359,'08d0834bba7c0d49567db7b96294fe87',50,'loading controller from db',1665829551),(360,'08d0834bba7c0d49567db7b96294fe87',50,'setting controller status to 1000',1665829551),(361,'08d0834bba7c0d49567db7b96294fe87',50,'saving controller to db',1665829551),(362,'f8a13327ae043b18e896ce847cf45480',40,'instantiating backup controller f8a13327ae043b18e896ce847cf45480',1665831456),(363,'f8a13327ae043b18e896ce847cf45480',50,'setting controller status to 100',1665831456),(364,'f8a13327ae043b18e896ce847cf45480',50,'loading controller plan',1665831456),(365,'f8a13327ae043b18e896ce847cf45480',50,'setting controller status to 300',1665831456),(366,'f8a13327ae043b18e896ce847cf45480',50,'applying plan defaults',1665831456),(367,'f8a13327ae043b18e896ce847cf45480',50,'setting controller status to 400',1665831456),(368,'f8a13327ae043b18e896ce847cf45480',50,'setting file inclusion to ',1665831456),(369,'f8a13327ae043b18e896ce847cf45480',40,'checking plan security',1665831456),(370,'f8a13327ae043b18e896ce847cf45480',50,'setting controller status to 700',1665831456),(371,'f8a13327ae043b18e896ce847cf45480',50,'saving controller to db',1665831456),(372,'f8a13327ae043b18e896ce847cf45480',50,'calculating controller checksum ee0a29eff7836201aec1b4b94d691870',1665831456),(373,'f8a13327ae043b18e896ce847cf45480',50,'loading controller from db',1665831456),(374,'f8a13327ae043b18e896ce847cf45480',50,'setting file inclusion to 1',1665831456),(375,'f8a13327ae043b18e896ce847cf45480',50,'setting controller status to 800',1665831456),(376,'f8a13327ae043b18e896ce847cf45480',50,'saving controller to db',1665831456),(377,'f8a13327ae043b18e896ce847cf45480',50,'calculating controller checksum 1cdc1fbf03cb690e92b5630d81a45e28',1665831456),(378,'f8a13327ae043b18e896ce847cf45480',50,'loading controller from db',1665831456),(379,'f8a13327ae043b18e896ce847cf45480',50,'setting controller status to 1000',1665831456),(380,'f8a13327ae043b18e896ce847cf45480',50,'saving controller to db',1665831456),(381,'64c4b4f875b50db38df0eb44fb98f9eb',40,'instantiating backup controller 64c4b4f875b50db38df0eb44fb98f9eb',1665831457),(382,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting controller status to 100',1665831457),(383,'64c4b4f875b50db38df0eb44fb98f9eb',50,'loading controller plan',1665831457),(384,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting controller status to 300',1665831457),(385,'64c4b4f875b50db38df0eb44fb98f9eb',50,'applying plan defaults',1665831457),(386,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting controller status to 400',1665831457),(387,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting file inclusion to ',1665831457),(388,'64c4b4f875b50db38df0eb44fb98f9eb',40,'checking plan security',1665831457),(389,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting controller status to 700',1665831457),(390,'64c4b4f875b50db38df0eb44fb98f9eb',50,'saving controller to db',1665831457),(391,'64c4b4f875b50db38df0eb44fb98f9eb',50,'calculating controller checksum ad5c3547ff33a993bfce4fe2396aab23',1665831457),(392,'64c4b4f875b50db38df0eb44fb98f9eb',50,'loading controller from db',1665831457),(393,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting file inclusion to 1',1665831457),(394,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting controller status to 800',1665831457),(395,'64c4b4f875b50db38df0eb44fb98f9eb',50,'saving controller to db',1665831457),(396,'64c4b4f875b50db38df0eb44fb98f9eb',50,'calculating controller checksum e521dcd5a163dfd100c5b0a1ce553559',1665831457),(397,'64c4b4f875b50db38df0eb44fb98f9eb',50,'loading controller from db',1665831457),(398,'64c4b4f875b50db38df0eb44fb98f9eb',50,'setting controller status to 1000',1665831457),(399,'64c4b4f875b50db38df0eb44fb98f9eb',50,'saving controller to db',1665831457),(400,'ce6bcaf6f27564db6d8935a385f0d46c',40,'instantiating backup controller ce6bcaf6f27564db6d8935a385f0d46c',1665831457),(401,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting controller status to 100',1665831457),(402,'ce6bcaf6f27564db6d8935a385f0d46c',50,'loading controller plan',1665831457),(403,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting controller status to 300',1665831457),(404,'ce6bcaf6f27564db6d8935a385f0d46c',50,'applying plan defaults',1665831457),(405,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting controller status to 400',1665831457),(406,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting file inclusion to ',1665831457),(407,'ce6bcaf6f27564db6d8935a385f0d46c',40,'checking plan security',1665831457),(408,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting controller status to 700',1665831457),(409,'ce6bcaf6f27564db6d8935a385f0d46c',50,'saving controller to db',1665831457),(410,'ce6bcaf6f27564db6d8935a385f0d46c',50,'calculating controller checksum d1e4a22ecc0791ee3e6203886fdfb014',1665831457),(411,'ce6bcaf6f27564db6d8935a385f0d46c',50,'loading controller from db',1665831457),(412,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting file inclusion to 1',1665831457),(413,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting controller status to 800',1665831457),(414,'ce6bcaf6f27564db6d8935a385f0d46c',50,'saving controller to db',1665831457),(415,'ce6bcaf6f27564db6d8935a385f0d46c',50,'calculating controller checksum af853d7cdd7ee8155a967a42e351757d',1665831457),(416,'ce6bcaf6f27564db6d8935a385f0d46c',50,'loading controller from db',1665831457),(417,'ce6bcaf6f27564db6d8935a385f0d46c',50,'setting controller status to 1000',1665831457),(418,'ce6bcaf6f27564db6d8935a385f0d46c',50,'saving controller to db',1665831457),(419,'32e8ec9e7b5ba614dd7e6972185c7865',40,'instantiating backup controller 32e8ec9e7b5ba614dd7e6972185c7865',1665831855),(420,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting controller status to 100',1665831855),(421,'32e8ec9e7b5ba614dd7e6972185c7865',50,'loading controller plan',1665831855),(422,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting controller status to 300',1665831855),(423,'32e8ec9e7b5ba614dd7e6972185c7865',50,'applying plan defaults',1665831855),(424,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting controller status to 400',1665831855),(425,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting file inclusion to ',1665831855),(426,'32e8ec9e7b5ba614dd7e6972185c7865',40,'checking plan security',1665831855),(427,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting controller status to 700',1665831855),(428,'32e8ec9e7b5ba614dd7e6972185c7865',50,'saving controller to db',1665831855),(429,'32e8ec9e7b5ba614dd7e6972185c7865',50,'calculating controller checksum 05f2ab6fc44a9790d8f22a1f85f1eef0',1665831855),(430,'32e8ec9e7b5ba614dd7e6972185c7865',50,'loading controller from db',1665831855),(431,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting file inclusion to 1',1665831855),(432,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting controller status to 800',1665831855),(433,'32e8ec9e7b5ba614dd7e6972185c7865',50,'saving controller to db',1665831855),(434,'32e8ec9e7b5ba614dd7e6972185c7865',50,'calculating controller checksum a2913cc45924de09ecebe933fa086616',1665831855),(435,'32e8ec9e7b5ba614dd7e6972185c7865',50,'loading controller from db',1665831855),(436,'32e8ec9e7b5ba614dd7e6972185c7865',50,'setting controller status to 1000',1665831855),(437,'32e8ec9e7b5ba614dd7e6972185c7865',50,'saving controller to db',1665831855),(438,'de3ef7af0828a8d2e98fb98daaa30a6f',40,'instantiating backup controller de3ef7af0828a8d2e98fb98daaa30a6f',1665831855),(439,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting controller status to 100',1665831855),(440,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'loading controller plan',1665831855),(441,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting controller status to 300',1665831855),(442,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'applying plan defaults',1665831855),(443,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting controller status to 400',1665831855),(444,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting file inclusion to ',1665831855),(445,'de3ef7af0828a8d2e98fb98daaa30a6f',40,'checking plan security',1665831855),(446,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting controller status to 700',1665831855),(447,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'saving controller to db',1665831855),(448,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'calculating controller checksum 8e8be99c14593ae327825dbe6d36c319',1665831855),(449,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'loading controller from db',1665831855),(450,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting file inclusion to 1',1665831855),(451,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting controller status to 800',1665831855),(452,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'saving controller to db',1665831855),(453,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'calculating controller checksum 5db122e9e4b554570e0502057755ebb5',1665831855),(454,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'loading controller from db',1665831855),(455,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'setting controller status to 1000',1665831855),(456,'de3ef7af0828a8d2e98fb98daaa30a6f',50,'saving controller to db',1665831855),(457,'89f255ac5a852add5d6db61eb97fd161',40,'instantiating backup controller 89f255ac5a852add5d6db61eb97fd161',1665987543),(458,'89f255ac5a852add5d6db61eb97fd161',50,'setting controller status to 100',1665987543),(459,'89f255ac5a852add5d6db61eb97fd161',50,'loading controller plan',1665987543),(460,'89f255ac5a852add5d6db61eb97fd161',50,'setting controller status to 300',1665987543),(461,'89f255ac5a852add5d6db61eb97fd161',50,'applying plan defaults',1665987543),(462,'89f255ac5a852add5d6db61eb97fd161',50,'setting controller status to 400',1665987543),(463,'89f255ac5a852add5d6db61eb97fd161',50,'setting file inclusion to ',1665987543),(464,'89f255ac5a852add5d6db61eb97fd161',40,'checking plan security',1665987543),(465,'89f255ac5a852add5d6db61eb97fd161',50,'setting controller status to 700',1665987543),(466,'89f255ac5a852add5d6db61eb97fd161',50,'saving controller to db',1665987543),(467,'89f255ac5a852add5d6db61eb97fd161',50,'calculating controller checksum 2f3e1da50648083e7680978cc9ffe363',1665987543),(468,'89f255ac5a852add5d6db61eb97fd161',50,'loading controller from db',1665987543),(469,'89f255ac5a852add5d6db61eb97fd161',50,'setting file inclusion to 1',1665987543),(470,'89f255ac5a852add5d6db61eb97fd161',50,'setting controller status to 800',1665987543),(471,'89f255ac5a852add5d6db61eb97fd161',50,'saving controller to db',1665987543),(472,'89f255ac5a852add5d6db61eb97fd161',50,'calculating controller checksum bea28b5a4cfe098fb10ed409629e5f0b',1665987543),(473,'89f255ac5a852add5d6db61eb97fd161',50,'loading controller from db',1665987543),(474,'89f255ac5a852add5d6db61eb97fd161',50,'setting controller status to 1000',1665987543),(475,'89f255ac5a852add5d6db61eb97fd161',50,'saving controller to db',1665987543),(476,'175eb986841cb5da479a937688500695',40,'instantiating backup controller 175eb986841cb5da479a937688500695',1665989035),(477,'175eb986841cb5da479a937688500695',50,'setting controller status to 100',1665989035),(478,'175eb986841cb5da479a937688500695',50,'loading controller plan',1665989035),(479,'175eb986841cb5da479a937688500695',50,'setting controller status to 300',1665989035),(480,'175eb986841cb5da479a937688500695',50,'applying plan defaults',1665989035),(481,'175eb986841cb5da479a937688500695',50,'setting controller status to 400',1665989035),(482,'175eb986841cb5da479a937688500695',50,'setting file inclusion to ',1665989035),(483,'175eb986841cb5da479a937688500695',40,'checking plan security',1665989035),(484,'175eb986841cb5da479a937688500695',50,'setting controller status to 700',1665989035),(485,'175eb986841cb5da479a937688500695',50,'saving controller to db',1665989035),(486,'175eb986841cb5da479a937688500695',50,'calculating controller checksum ceb28f6ef42de2e84b9374ea2d4fc0af',1665989035),(487,'175eb986841cb5da479a937688500695',50,'loading controller from db',1665989035),(488,'175eb986841cb5da479a937688500695',50,'setting file inclusion to 1',1665989035),(489,'175eb986841cb5da479a937688500695',50,'setting controller status to 800',1665989035),(490,'175eb986841cb5da479a937688500695',50,'saving controller to db',1665989035),(491,'175eb986841cb5da479a937688500695',50,'calculating controller checksum 713624379460997144d480a8cdf93a59',1665989035),(492,'175eb986841cb5da479a937688500695',50,'loading controller from db',1665989035),(493,'175eb986841cb5da479a937688500695',50,'setting controller status to 1000',1665989035),(494,'175eb986841cb5da479a937688500695',50,'saving controller to db',1665989035),(495,'78f0fa625eb38026c5eaefc519b2e0e5',40,'instantiating backup controller 78f0fa625eb38026c5eaefc519b2e0e5',1665989044),(496,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting controller status to 100',1665989044),(497,'78f0fa625eb38026c5eaefc519b2e0e5',50,'loading controller plan',1665989044),(498,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting controller status to 300',1665989044),(499,'78f0fa625eb38026c5eaefc519b2e0e5',50,'applying plan defaults',1665989044),(500,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting controller status to 400',1665989044),(501,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting file inclusion to ',1665989044),(502,'78f0fa625eb38026c5eaefc519b2e0e5',40,'checking plan security',1665989044),(503,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting controller status to 700',1665989044),(504,'78f0fa625eb38026c5eaefc519b2e0e5',50,'saving controller to db',1665989044),(505,'78f0fa625eb38026c5eaefc519b2e0e5',50,'calculating controller checksum 6b0b6d9dc09b28fb72b930942eabdbd6',1665989044),(506,'78f0fa625eb38026c5eaefc519b2e0e5',50,'loading controller from db',1665989044),(507,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting file inclusion to 1',1665989044),(508,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting controller status to 800',1665989044),(509,'78f0fa625eb38026c5eaefc519b2e0e5',50,'saving controller to db',1665989044),(510,'78f0fa625eb38026c5eaefc519b2e0e5',50,'calculating controller checksum 005caef09f7429aceeac50c7a04cf99b',1665989044),(511,'78f0fa625eb38026c5eaefc519b2e0e5',50,'loading controller from db',1665989044),(512,'78f0fa625eb38026c5eaefc519b2e0e5',50,'setting controller status to 1000',1665989044),(513,'78f0fa625eb38026c5eaefc519b2e0e5',50,'saving controller to db',1665989044),(514,'3163b0a44836466b259045e0d86cb46a',40,'instantiating backup controller 3163b0a44836466b259045e0d86cb46a',1665989054),(515,'3163b0a44836466b259045e0d86cb46a',50,'setting controller status to 100',1665989054),(516,'3163b0a44836466b259045e0d86cb46a',50,'loading controller plan',1665989054),(517,'3163b0a44836466b259045e0d86cb46a',50,'setting controller status to 300',1665989054),(518,'3163b0a44836466b259045e0d86cb46a',50,'applying plan defaults',1665989054),(519,'3163b0a44836466b259045e0d86cb46a',50,'setting controller status to 400',1665989054),(520,'3163b0a44836466b259045e0d86cb46a',50,'setting file inclusion to ',1665989054),(521,'3163b0a44836466b259045e0d86cb46a',40,'checking plan security',1665989054),(522,'3163b0a44836466b259045e0d86cb46a',50,'setting controller status to 700',1665989054),(523,'3163b0a44836466b259045e0d86cb46a',50,'saving controller to db',1665989054),(524,'3163b0a44836466b259045e0d86cb46a',50,'calculating controller checksum 5baa9bc2d31787e2f703d5661f95b12e',1665989054),(525,'3163b0a44836466b259045e0d86cb46a',50,'loading controller from db',1665989054),(526,'3163b0a44836466b259045e0d86cb46a',50,'setting file inclusion to 1',1665989054),(527,'3163b0a44836466b259045e0d86cb46a',50,'setting controller status to 800',1665989054),(528,'3163b0a44836466b259045e0d86cb46a',50,'saving controller to db',1665989054),(529,'3163b0a44836466b259045e0d86cb46a',50,'calculating controller checksum 0527e28d38f8dc22cd6ea09be3dc8b91',1665989054),(530,'3163b0a44836466b259045e0d86cb46a',50,'loading controller from db',1665989054),(531,'3163b0a44836466b259045e0d86cb46a',50,'setting controller status to 1000',1665989054),(532,'3163b0a44836466b259045e0d86cb46a',50,'saving controller to db',1665989054),(533,'10046a43cc7d2aff18fc40e0c343cabe',40,'instantiating backup controller 10046a43cc7d2aff18fc40e0c343cabe',1666010117),(534,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting controller status to 100',1666010117),(535,'10046a43cc7d2aff18fc40e0c343cabe',50,'loading controller plan',1666010117),(536,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting controller status to 300',1666010117),(537,'10046a43cc7d2aff18fc40e0c343cabe',50,'applying plan defaults',1666010117),(538,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting controller status to 400',1666010117),(539,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting file inclusion to ',1666010117),(540,'10046a43cc7d2aff18fc40e0c343cabe',40,'checking plan security',1666010117),(541,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting controller status to 700',1666010117),(542,'10046a43cc7d2aff18fc40e0c343cabe',50,'saving controller to db',1666010117),(543,'10046a43cc7d2aff18fc40e0c343cabe',50,'calculating controller checksum 0b46f427b23c031f7e418ff79e8cfdb0',1666010117),(544,'10046a43cc7d2aff18fc40e0c343cabe',50,'loading controller from db',1666010117),(545,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting file inclusion to 1',1666010117),(546,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting controller status to 800',1666010117),(547,'10046a43cc7d2aff18fc40e0c343cabe',50,'saving controller to db',1666010117),(548,'10046a43cc7d2aff18fc40e0c343cabe',50,'calculating controller checksum 6e86fe1bd36b0663bf29f81148257680',1666010117),(549,'10046a43cc7d2aff18fc40e0c343cabe',50,'loading controller from db',1666010117),(550,'10046a43cc7d2aff18fc40e0c343cabe',50,'setting controller status to 1000',1666010117),(551,'10046a43cc7d2aff18fc40e0c343cabe',50,'saving controller to db',1666010117),(552,'0c8e1a1aaba9605070518fb4a93f5a25',40,'instantiating backup controller 0c8e1a1aaba9605070518fb4a93f5a25',1666020873),(553,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting controller status to 100',1666020873),(554,'0c8e1a1aaba9605070518fb4a93f5a25',50,'loading controller plan',1666020873),(555,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting controller status to 300',1666020873),(556,'0c8e1a1aaba9605070518fb4a93f5a25',50,'applying plan defaults',1666020873),(557,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting controller status to 400',1666020873),(558,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting file inclusion to ',1666020873),(559,'0c8e1a1aaba9605070518fb4a93f5a25',40,'checking plan security',1666020873),(560,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting controller status to 700',1666020873),(561,'0c8e1a1aaba9605070518fb4a93f5a25',50,'saving controller to db',1666020873),(562,'0c8e1a1aaba9605070518fb4a93f5a25',50,'calculating controller checksum f9a509b41a9d89000b0ff04f51619b5d',1666020873),(563,'0c8e1a1aaba9605070518fb4a93f5a25',50,'loading controller from db',1666020873),(564,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting file inclusion to 1',1666020873),(565,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting controller status to 800',1666020873),(566,'0c8e1a1aaba9605070518fb4a93f5a25',50,'saving controller to db',1666020873),(567,'0c8e1a1aaba9605070518fb4a93f5a25',50,'calculating controller checksum 5a8734d4f96ea8ea1863d706f3e6319b',1666020873),(568,'0c8e1a1aaba9605070518fb4a93f5a25',50,'loading controller from db',1666020873),(569,'0c8e1a1aaba9605070518fb4a93f5a25',50,'setting controller status to 1000',1666020873),(570,'0c8e1a1aaba9605070518fb4a93f5a25',50,'saving controller to db',1666020873),(571,'095bdbe04b548aed996cfb179bea596b',40,'instantiating backup controller 095bdbe04b548aed996cfb179bea596b',1666020964),(572,'095bdbe04b548aed996cfb179bea596b',50,'setting controller status to 100',1666020964),(573,'095bdbe04b548aed996cfb179bea596b',50,'loading controller plan',1666020964),(574,'095bdbe04b548aed996cfb179bea596b',50,'setting controller status to 300',1666020964),(575,'095bdbe04b548aed996cfb179bea596b',50,'applying plan defaults',1666020964),(576,'095bdbe04b548aed996cfb179bea596b',50,'setting controller status to 400',1666020964),(577,'095bdbe04b548aed996cfb179bea596b',50,'setting file inclusion to ',1666020964),(578,'095bdbe04b548aed996cfb179bea596b',40,'checking plan security',1666020964),(579,'095bdbe04b548aed996cfb179bea596b',50,'setting controller status to 700',1666020964),(580,'095bdbe04b548aed996cfb179bea596b',50,'saving controller to db',1666020964),(581,'095bdbe04b548aed996cfb179bea596b',50,'calculating controller checksum fc87683f61552b4f225a49271815071c',1666020964),(582,'095bdbe04b548aed996cfb179bea596b',50,'loading controller from db',1666020964),(583,'095bdbe04b548aed996cfb179bea596b',50,'setting file inclusion to 1',1666020964),(584,'095bdbe04b548aed996cfb179bea596b',50,'setting controller status to 800',1666020964),(585,'095bdbe04b548aed996cfb179bea596b',50,'saving controller to db',1666020964),(586,'095bdbe04b548aed996cfb179bea596b',50,'calculating controller checksum 13a2939b6cd9253f48d7b0401c86e9df',1666020964),(587,'095bdbe04b548aed996cfb179bea596b',50,'loading controller from db',1666020964),(588,'095bdbe04b548aed996cfb179bea596b',50,'setting controller status to 1000',1666020964),(589,'095bdbe04b548aed996cfb179bea596b',50,'saving controller to db',1666020964),(590,'30264b5dbc7393e355753bb104e8322b',40,'instantiating backup controller 30264b5dbc7393e355753bb104e8322b',1666067412),(591,'30264b5dbc7393e355753bb104e8322b',50,'setting controller status to 100',1666067412),(592,'30264b5dbc7393e355753bb104e8322b',50,'loading controller plan',1666067412),(593,'30264b5dbc7393e355753bb104e8322b',50,'setting controller status to 300',1666067412),(594,'30264b5dbc7393e355753bb104e8322b',50,'applying plan defaults',1666067412),(595,'30264b5dbc7393e355753bb104e8322b',50,'setting controller status to 400',1666067412),(596,'30264b5dbc7393e355753bb104e8322b',50,'setting file inclusion to ',1666067412),(597,'30264b5dbc7393e355753bb104e8322b',40,'checking plan security',1666067412),(598,'30264b5dbc7393e355753bb104e8322b',50,'setting controller status to 700',1666067412),(599,'30264b5dbc7393e355753bb104e8322b',50,'saving controller to db',1666067412),(600,'30264b5dbc7393e355753bb104e8322b',50,'calculating controller checksum 4d9670c1022c523cd10a1765a1ab50e7',1666067412),(601,'30264b5dbc7393e355753bb104e8322b',50,'loading controller from db',1666067412),(602,'30264b5dbc7393e355753bb104e8322b',50,'setting file inclusion to 1',1666067412),(603,'30264b5dbc7393e355753bb104e8322b',50,'setting controller status to 800',1666067412),(604,'30264b5dbc7393e355753bb104e8322b',50,'saving controller to db',1666067412),(605,'30264b5dbc7393e355753bb104e8322b',50,'calculating controller checksum f7250d0a40a573a7cf25457c678a89db',1666067412),(606,'30264b5dbc7393e355753bb104e8322b',50,'loading controller from db',1666067412),(607,'30264b5dbc7393e355753bb104e8322b',50,'setting controller status to 1000',1666067413),(608,'30264b5dbc7393e355753bb104e8322b',50,'saving controller to db',1666067413),(609,'4aebea948100adb2d29cb26b7995aa7a',40,'instantiating backup controller 4aebea948100adb2d29cb26b7995aa7a',1666156208),(610,'4aebea948100adb2d29cb26b7995aa7a',50,'setting controller status to 100',1666156208),(611,'4aebea948100adb2d29cb26b7995aa7a',50,'loading controller plan',1666156208),(612,'4aebea948100adb2d29cb26b7995aa7a',50,'setting controller status to 300',1666156208),(613,'4aebea948100adb2d29cb26b7995aa7a',50,'applying plan defaults',1666156208),(614,'4aebea948100adb2d29cb26b7995aa7a',50,'setting controller status to 400',1666156208),(615,'4aebea948100adb2d29cb26b7995aa7a',50,'setting file inclusion to ',1666156208),(616,'4aebea948100adb2d29cb26b7995aa7a',40,'checking plan security',1666156208),(617,'4aebea948100adb2d29cb26b7995aa7a',50,'setting controller status to 700',1666156208),(618,'4aebea948100adb2d29cb26b7995aa7a',50,'saving controller to db',1666156208),(619,'4aebea948100adb2d29cb26b7995aa7a',50,'calculating controller checksum 4e68929b52ed4e9b99ce26f7f7c676db',1666156208),(620,'4aebea948100adb2d29cb26b7995aa7a',50,'loading controller from db',1666156208),(621,'4aebea948100adb2d29cb26b7995aa7a',50,'setting controller status to 800',1666156208),(622,'4aebea948100adb2d29cb26b7995aa7a',50,'saving controller to db',1666156208),(623,'4aebea948100adb2d29cb26b7995aa7a',50,'calculating controller checksum 52a69c0d182b883c5bf7ee72fd330ea4',1666156208),(624,'4aebea948100adb2d29cb26b7995aa7a',50,'loading controller from db',1666156208),(625,'4aebea948100adb2d29cb26b7995aa7a',50,'setting controller status to 1000',1666156208),(626,'4aebea948100adb2d29cb26b7995aa7a',50,'saving controller to db',1666156208),(627,'ffe8429bd14778bfb6c7f5ef653b475d',40,'instantiating restore controller ffe8429bd14778bfb6c7f5ef653b475d',1666156208),(628,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 100',1666156208),(629,'ffe8429bd14778bfb6c7f5ef653b475d',50,'loading backup info',1666156208),(630,'ffe8429bd14778bfb6c7f5ef653b475d',50,'loading controller plan',1666156208),(631,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 300',1666156208),(632,'ffe8429bd14778bfb6c7f5ef653b475d',50,'applying restore defaults',1666156208),(633,'ffe8429bd14778bfb6c7f5ef653b475d',50,'Unknown setting: questionbank',1666156208),(634,'ffe8429bd14778bfb6c7f5ef653b475d',50,'Unknown setting: overwrite_conf',1666156208),(635,'ffe8429bd14778bfb6c7f5ef653b475d',50,'Unknown setting: course_fullname',1666156208),(636,'ffe8429bd14778bfb6c7f5ef653b475d',50,'Unknown setting: course_shortname',1666156208),(637,'ffe8429bd14778bfb6c7f5ef653b475d',50,'Unknown setting: course_startdate',1666156208),(638,'ffe8429bd14778bfb6c7f5ef653b475d',50,'Unknown setting: questionbank',1666156208),(639,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 400',1666156208),(640,'ffe8429bd14778bfb6c7f5ef653b475d',40,'checking plan security',1666156208),(641,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 600',1666156208),(642,'ffe8429bd14778bfb6c7f5ef653b475d',50,'saving controller to db',1666156208),(643,'ffe8429bd14778bfb6c7f5ef653b475d',50,'calculating controller checksum 68f71a1024bfe5dae0989b9b1504d844',1666156208),(644,'ffe8429bd14778bfb6c7f5ef653b475d',50,'loading controller from db',1666156208),(645,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 700',1666156208),(646,'ffe8429bd14778bfb6c7f5ef653b475d',50,'saving controller to db',1666156208),(647,'ffe8429bd14778bfb6c7f5ef653b475d',50,'calculating controller checksum ad8efdfbcfb68a805ecc7a1c5bdd918d',1666156208),(648,'ffe8429bd14778bfb6c7f5ef653b475d',50,'loading controller from db',1666156208),(649,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 800',1666156208),(650,'ffe8429bd14778bfb6c7f5ef653b475d',50,'saving controller to db',1666156208),(651,'ffe8429bd14778bfb6c7f5ef653b475d',50,'calculating controller checksum f40cb33d5510114dbe94d6b41c8f3c22',1666156208),(652,'ffe8429bd14778bfb6c7f5ef653b475d',50,'loading controller from db',1666156208),(653,'ffe8429bd14778bfb6c7f5ef653b475d',50,'processing file aliases queue',1666156208),(654,'ffe8429bd14778bfb6c7f5ef653b475d',50,'setting controller status to 1000',1666156208),(655,'ffe8429bd14778bfb6c7f5ef653b475d',50,'saving controller to db',1666156208);
/*!40000 ALTER TABLE `mdl_backup_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge`
--

DROP TABLE IF EXISTS `mdl_badge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuername` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuercontact` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiredate` bigint(10) DEFAULT NULL,
  `expireperiod` bigint(10) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint(10) DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `messagesubject` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint(10) DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthorname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthoremail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageauthorurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imagecaption` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badg_typ_ix` (`type`),
  KEY `mdl_badg_cou_ix` (`courseid`),
  KEY `mdl_badg_use_ix` (`usermodified`),
  KEY `mdl_badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge`
--

LOCK TABLES `mdl_badge` WRITE;
/*!40000 ALTER TABLE `mdl_badge` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_alignment`
--

DROP TABLE IF EXISTS `mdl_badge_alignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_alignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `targetname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `targeturl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `targetdescription` longtext COLLATE utf8mb4_unicode_ci,
  `targetframework` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgalig_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines alignment for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_alignment`
--

LOCK TABLES `mdl_badge_alignment` WRITE;
/*!40000 ALTER TABLE `mdl_badge_alignment` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_alignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_backpack`
--

DROP TABLE IF EXISTS `mdl_badge_backpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backpackuid` bigint(10) NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `externalbackpackid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgback_useext_uix` (`userid`,`externalbackpackid`),
  KEY `mdl_badgback_use_ix` (`userid`),
  KEY `mdl_badgback_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for connecting external backpack';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_backpack`
--

LOCK TABLES `mdl_badge_backpack` WRITE;
/*!40000 ALTER TABLE `mdl_badge_backpack` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_backpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_backpack_oauth2`
--

DROP TABLE IF EXISTS `mdl_badge_backpack_oauth2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_backpack_oauth2` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `externalbackpackid` bigint(10) NOT NULL,
  `token` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `refreshtoken` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires` bigint(10) DEFAULT NULL,
  `scope` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badgbackoaut_use_ix` (`usermodified`),
  KEY `mdl_badgbackoaut_use2_ix` (`userid`),
  KEY `mdl_badgbackoaut_iss_ix` (`issuerid`),
  KEY `mdl_badgbackoaut_ext_ix` (`externalbackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_backpack_oauth2`
--

LOCK TABLES `mdl_badge_backpack_oauth2` WRITE;
/*!40000 ALTER TABLE `mdl_badge_backpack_oauth2` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_backpack_oauth2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria`
--

DROP TABLE IF EXISTS `mdl_badge_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `mdl_badgcrit_cri_ix` (`criteriatype`),
  KEY `mdl_badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria for issuing badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria`
--

LOCK TABLES `mdl_badge_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_met`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_met`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria_met` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `issuedid` bigint(10) DEFAULT NULL,
  `critid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritmet_cri_ix` (`critid`),
  KEY `mdl_badgcritmet_use_ix` (`userid`),
  KEY `mdl_badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines criteria that were met for an issued badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_met`
--

LOCK TABLES `mdl_badge_criteria_met` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_met` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_criteria_param`
--

DROP TABLE IF EXISTS `mdl_badge_criteria_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_criteria_param` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `critid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines parameters for badges criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_criteria_param`
--

LOCK TABLES `mdl_badge_criteria_param` WRITE;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_criteria_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_endorsement`
--

DROP TABLE IF EXISTS `mdl_badge_endorsement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_endorsement` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `issuername` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issuerurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `issueremail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `claimid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `claimcomment` longtext COLLATE utf8mb4_unicode_ci,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_badgendo_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines endorsement for badge';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_endorsement`
--

LOCK TABLES `mdl_badge_endorsement` WRITE;
/*!40000 ALTER TABLE `mdl_badge_endorsement` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_endorsement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external`
--

DROP TABLE IF EXISTS `mdl_badge_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackid` bigint(10) NOT NULL,
  `collectionid` bigint(10) NOT NULL,
  `entityid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assertion` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges display';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external`
--

LOCK TABLES `mdl_badge_external` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external_backpack`
--

DROP TABLE IF EXISTS `mdl_badge_external_backpack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_external_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackapiurl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backpackweburl` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `apiversion` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `oauth2_issuerid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgexteback_bac_uix` (`backpackapiurl`),
  UNIQUE KEY `mdl_badgexteback_bac2_uix` (`backpackweburl`),
  KEY `mdl_badgexteback_oau_ix` (`oauth2_issuerid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines settings for site level backpacks that a user can co';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external_backpack`
--

LOCK TABLES `mdl_badge_external_backpack` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external_backpack` DISABLE KEYS */;
INSERT INTO `mdl_badge_external_backpack` VALUES (1,'https://api.badgr.io/v2','https://badgr.io','2',1,NULL);
/*!40000 ALTER TABLE `mdl_badge_external_backpack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_external_identifier`
--

DROP TABLE IF EXISTS `mdl_badge_external_identifier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_external_identifier` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `sitebackpackid` bigint(10) NOT NULL,
  `internalid` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `externalid` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgexteiden_sitintext_uix` (`sitebackpackid`,`internalid`,`externalid`,`type`),
  KEY `mdl_badgexteiden_sit_ix` (`sitebackpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting for external badges mappings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_external_identifier`
--

LOCK TABLES `mdl_badge_external_identifier` WRITE;
/*!40000 ALTER TABLE `mdl_badge_external_identifier` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_external_identifier` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_issued`
--

DROP TABLE IF EXISTS `mdl_badge_issued`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_issued` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `uniquehash` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  `dateexpire` bigint(10) DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `mdl_badgissu_bad_ix` (`badgeid`),
  KEY `mdl_badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines issued badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_issued`
--

LOCK TABLES `mdl_badge_issued` WRITE;
/*!40000 ALTER TABLE `mdl_badge_issued` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_issued` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_manual_award`
--

DROP TABLE IF EXISTS `mdl_badge_manual_award`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_manual_award` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL,
  `recipientid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `issuerrole` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_badgmanuawar_bad_ix` (`badgeid`),
  KEY `mdl_badgmanuawar_rec_ix` (`recipientid`),
  KEY `mdl_badgmanuawar_iss_ix` (`issuerid`),
  KEY `mdl_badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Track manual award criteria for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_manual_award`
--

LOCK TABLES `mdl_badge_manual_award` WRITE;
/*!40000 ALTER TABLE `mdl_badge_manual_award` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_manual_award` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_badge_related`
--

DROP TABLE IF EXISTS `mdl_badge_related`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_badge_related` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `relatedbadgeid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_badgrela_badrel_uix` (`badgeid`,`relatedbadgeid`),
  KEY `mdl_badgrela_bad_ix` (`badgeid`),
  KEY `mdl_badgrela_rel_ix` (`relatedbadgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines badge related for badges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_badge_related`
--

LOCK TABLES `mdl_badge_related` WRITE;
/*!40000 ALTER TABLE `mdl_badge_related` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_badge_related` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block`
--

DROP TABLE IF EXISTS `mdl_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_bloc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='contains all installed blocks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block`
--

LOCK TABLES `mdl_block` WRITE;
/*!40000 ALTER TABLE `mdl_block` DISABLE KEYS */;
INSERT INTO `mdl_block` VALUES (1,'accessreview',0,0,1),(2,'activity_modules',0,0,1),(3,'activity_results',0,0,1),(4,'admin_bookmarks',0,0,1),(5,'badges',0,0,1),(6,'blog_menu',0,0,1),(7,'blog_recent',0,0,1),(8,'blog_tags',0,0,1),(9,'calendar_month',0,0,1),(10,'calendar_upcoming',0,0,1),(11,'comments',0,0,1),(12,'completionstatus',0,0,1),(13,'course_list',0,0,1),(14,'course_summary',0,0,1),(15,'feedback',0,0,1),(16,'globalsearch',0,0,1),(17,'glossary_random',0,0,1),(18,'html',0,0,1),(19,'login',0,0,1),(20,'lp',0,0,1),(21,'mentees',0,0,1),(22,'mnet_hosts',0,0,1),(23,'myoverview',0,0,1),(24,'myprofile',0,0,1),(25,'navigation',0,0,1),(26,'news_items',0,0,1),(27,'online_users',0,0,1),(28,'private_files',0,0,1),(29,'quiz_results',0,0,0),(30,'recent_activity',0,0,1),(31,'recentlyaccessedcourses',0,0,1),(32,'recentlyaccesseditems',0,0,1),(33,'rss_client',0,0,1),(34,'search_forums',0,0,1),(35,'section_links',0,0,1),(36,'selfcompletion',0,0,1),(37,'settings',0,0,1),(38,'site_main_menu',0,0,1),(39,'social_activities',0,0,1),(40,'starredcourses',0,0,1),(41,'tag_flickr',0,0,1),(42,'tag_youtube',0,0,0),(43,'tags',0,0,1),(44,'timeline',0,0,1),(45,'course_list_advanced',0,0,1),(46,'catalogue',0,0,1),(47,'course_overview',0,0,1);
/*!40000 ALTER TABLE `mdl_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_catalogue`
--

DROP TABLE IF EXISTS `mdl_block_catalogue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_catalogue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for block_catalogue, please edit me';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_catalogue`
--

LOCK TABLES `mdl_block_catalogue` WRITE;
/*!40000 ALTER TABLE `mdl_block_catalogue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_catalogue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_catalogue_data`
--

DROP TABLE IF EXISTS `mdl_block_catalogue_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_catalogue_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `listname` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `elementname` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nature` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Descriptions, links, pictures...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_catalogue_data`
--

LOCK TABLES `mdl_block_catalogue_data` WRITE;
/*!40000 ALTER TABLE `mdl_block_catalogue_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_catalogue_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_catalogue_element`
--

DROP TABLE IF EXISTS `mdl_block_catalogue_element`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_catalogue_element` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `listname` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_catalogue_element`
--

LOCK TABLES `mdl_block_catalogue_element` WRITE;
/*!40000 ALTER TABLE `mdl_block_catalogue_element` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_catalogue_element` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_catalogue_fav`
--

DROP TABLE IF EXISTS `mdl_block_catalogue_fav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_catalogue_fav` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(11) NOT NULL,
  `listname` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `elementname` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_catalogue_fav`
--

LOCK TABLES `mdl_block_catalogue_fav` WRITE;
/*!40000 ALTER TABLE `mdl_block_catalogue_fav` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_catalogue_fav` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_catalogue_hide`
--

DROP TABLE IF EXISTS `mdl_block_catalogue_hide`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_catalogue_hide` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `listname` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `elementname` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Elements not shown to teachers';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_catalogue_hide`
--

LOCK TABLES `mdl_block_catalogue_hide` WRITE;
/*!40000 ALTER TABLE `mdl_block_catalogue_hide` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_catalogue_hide` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_catalogue_type`
--

DROP TABLE IF EXISTS `mdl_block_catalogue_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_catalogue_type` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `listid` bigint(11) NOT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='importance des éléments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_catalogue_type`
--

LOCK TABLES `mdl_block_catalogue_type` WRITE;
/*!40000 ALTER TABLE `mdl_block_catalogue_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_catalogue_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_instances`
--

DROP TABLE IF EXISTS `mdl_block_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parentcontextid` bigint(10) NOT NULL,
  `showinsubcontexts` smallint(4) NOT NULL,
  `requiredbytheme` smallint(4) NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `defaultregion` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `defaultweight` bigint(10) NOT NULL,
  `configdata` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `mdl_blocinst_tim_ix` (`timemodified`),
  KEY `mdl_blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB AUTO_INCREMENT=600 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores block instances. The type of block this is';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_instances`
--

LOCK TABLES `mdl_block_instances` WRITE;
/*!40000 ALTER TABLE `mdl_block_instances` DISABLE KEYS */;
INSERT INTO `mdl_block_instances` VALUES (1,'admin_bookmarks',1,0,0,'admin-*',NULL,'side-pre',2,'',1663307085,1663307085),(2,'timeline',1,0,0,'my-index','2','side-post',0,'',1663307085,1663307085),(3,'private_files',1,0,0,'my-index','2','side-post',1,'',1663307085,1663307085),(4,'online_users',1,0,0,'my-index','2','side-post',2,'',1663307085,1663307085),(5,'badges',1,0,0,'my-index','2','side-post',3,'',1663307085,1663307085),(6,'calendar_month',1,0,0,'my-index','2','side-post',4,'',1663307085,1663307085),(7,'calendar_upcoming',1,0,0,'my-index','2','side-post',5,'',1663307085,1663307085),(8,'lp',1,0,0,'my-index','2','content',0,'',1663307085,1663307085),(9,'recentlyaccessedcourses',1,0,0,'my-index','2','content',1,'',1663307085,1663307085),(10,'myoverview',1,0,0,'my-index','2','content',2,'',1663307085,1663307085),(11,'timeline',5,0,0,'my-index','3','side-post',0,'',1663307151,1663307151),(12,'private_files',5,0,0,'my-index','3','side-post',1,'',1663307151,1663307151),(13,'online_users',5,0,0,'my-index','3','side-post',2,'',1663307151,1663307151),(14,'badges',5,0,0,'my-index','3','side-post',3,'',1663307151,1663307151),(15,'calendar_month',5,0,0,'my-index','3','side-post',4,'',1663307151,1663307151),(16,'calendar_upcoming',5,0,0,'my-index','3','side-post',5,'',1663307151,1663307151),(17,'lp',5,0,0,'my-index','3','content',0,'',1663307151,1663307151),(18,'recentlyaccessedcourses',5,0,0,'my-index','3','content',1,'',1663307151,1663307151),(19,'myoverview',5,0,0,'my-index','3','content',2,'',1663307151,1663307151),(47,'timeline',38,0,0,'my-index','7','side-post',0,'',1663310844,1663310844),(48,'private_files',38,0,0,'my-index','7','side-post',1,'',1663310844,1663310844),(49,'online_users',38,0,0,'my-index','7','side-post',2,'',1663310844,1663310844),(50,'badges',38,0,0,'my-index','7','side-post',3,'',1663310844,1663310844),(51,'calendar_month',38,0,0,'my-index','7','side-post',4,'',1663310844,1663310844),(52,'calendar_upcoming',38,0,0,'my-index','7','side-post',5,'',1663310844,1663310844),(53,'lp',38,0,0,'my-index','7','content',0,'',1663310844,1663310844),(54,'recentlyaccessedcourses',38,0,0,'my-index','7','content',1,'',1663310844,1663310844),(55,'myoverview',38,0,0,'my-index','7','content',2,'',1663310844,1663310844),(56,'timeline',101,0,0,'my-index','8','side-post',0,'',1663322733,1663322733),(57,'private_files',101,0,0,'my-index','8','side-post',1,'',1663322733,1663322733),(58,'online_users',101,0,0,'my-index','8','side-post',2,'',1663322733,1663322733),(59,'badges',101,0,0,'my-index','8','side-post',3,'',1663322733,1663322733),(60,'calendar_month',101,0,0,'my-index','8','side-post',4,'',1663322733,1663322733),(61,'calendar_upcoming',101,0,0,'my-index','8','side-post',5,'',1663322733,1663322733),(62,'lp',101,0,0,'my-index','8','content',0,'',1663322733,1663322733),(63,'recentlyaccessedcourses',101,0,0,'my-index','8','content',1,'',1663322733,1663322733),(64,'myoverview',101,0,0,'my-index','8','content',2,'',1663322733,1663322733),(65,'timeline',136,0,0,'my-index','11','side-post',0,'',1663418085,1663418085),(66,'private_files',136,0,0,'my-index','11','side-post',1,'',1663418085,1663418085),(67,'online_users',136,0,0,'my-index','11','side-post',2,'',1663418085,1663418085),(68,'badges',136,0,0,'my-index','11','side-post',3,'',1663418085,1663418085),(69,'calendar_month',136,0,0,'my-index','11','side-post',4,'',1663418085,1663418085),(70,'calendar_upcoming',136,0,0,'my-index','11','side-post',5,'',1663418085,1663418085),(71,'lp',136,0,0,'my-index','11','content',0,'',1663418085,1663418085),(72,'recentlyaccessedcourses',136,0,0,'my-index','11','content',1,'',1663418085,1663418085),(73,'myoverview',136,0,0,'my-index','11','content',2,'',1663418085,1663418085),(74,'navigation',1,1,1,'*',NULL,'side-pre',0,'',1663490683,1663490683),(75,'settings',1,1,1,'*',NULL,'side-pre',0,'',1663490683,1663490683),(76,'timeline',160,0,0,'my-index','12','side-post',0,'',1663519333,1663519333),(77,'private_files',160,0,0,'my-index','12','side-post',1,'',1663519333,1663519333),(78,'online_users',160,0,0,'my-index','12','side-post',2,'',1663519333,1663519333),(79,'badges',160,0,0,'my-index','12','side-post',3,'',1663519333,1663519333),(80,'calendar_month',160,0,0,'my-index','12','side-post',4,'',1663519333,1663519333),(81,'calendar_upcoming',160,0,0,'my-index','12','side-post',5,'',1663519333,1663519333),(82,'lp',160,0,0,'my-index','12','content',0,'',1663519333,1663519333),(83,'recentlyaccessedcourses',160,0,0,'my-index','12','content',1,'',1663519333,1663519333),(84,'myoverview',160,0,0,'my-index','12','content',2,'',1663519333,1663519333),(85,'timeline',157,0,0,'my-index','13','side-post',0,'',1663519523,1663519523),(86,'private_files',157,0,0,'my-index','13','side-post',1,'',1663519523,1663519523),(87,'online_users',157,0,0,'my-index','13','side-post',2,'',1663519523,1663519523),(88,'badges',157,0,0,'my-index','13','side-post',3,'',1663519523,1663519523),(89,'calendar_month',157,0,0,'my-index','13','side-post',4,'',1663519523,1663519523),(90,'calendar_upcoming',157,0,0,'my-index','13','side-post',5,'',1663519523,1663519523),(91,'lp',157,0,0,'my-index','13','content',0,'',1663519523,1663519523),(92,'recentlyaccessedcourses',157,0,0,'my-index','13','content',1,'',1663519523,1663519523),(93,'myoverview',157,0,0,'my-index','13','content',2,'',1663519523,1663519523),(94,'timeline',189,0,0,'my-index','17','side-post',0,'',1663669181,1663669181),(95,'private_files',189,0,0,'my-index','17','side-post',1,'',1663669181,1663669181),(96,'online_users',189,0,0,'my-index','17','side-post',2,'',1663669181,1663669181),(97,'badges',189,0,0,'my-index','17','side-post',3,'',1663669181,1663669181),(98,'calendar_month',189,0,0,'my-index','17','side-post',4,'',1663669181,1663669181),(99,'calendar_upcoming',189,0,0,'my-index','17','side-post',5,'',1663669181,1663669181),(100,'lp',189,0,0,'my-index','17','content',0,'',1663669181,1663669181),(101,'recentlyaccessedcourses',189,0,0,'my-index','17','content',1,'',1663669181,1663669181),(102,'myoverview',189,0,0,'my-index','17','content',2,'',1663669181,1663669181),(103,'timeline',200,0,0,'my-index','18','side-post',0,'',1663672142,1663672142),(104,'private_files',200,0,0,'my-index','18','side-post',1,'',1663672142,1663672142),(105,'online_users',200,0,0,'my-index','18','side-post',2,'',1663672142,1663672142),(106,'badges',200,0,0,'my-index','18','side-post',3,'',1663672142,1663672142),(107,'calendar_month',200,0,0,'my-index','18','side-post',4,'',1663672142,1663672142),(108,'calendar_upcoming',200,0,0,'my-index','18','side-post',5,'',1663672142,1663672142),(109,'lp',200,0,0,'my-index','18','content',0,'',1663672142,1663672142),(110,'recentlyaccessedcourses',200,0,0,'my-index','18','content',1,'',1663672142,1663672142),(111,'myoverview',200,0,0,'my-index','18','content',2,'',1663672142,1663672142),(112,'timeline',212,0,0,'my-index','19','side-post',0,'',1663673419,1663673419),(113,'private_files',212,0,0,'my-index','19','side-post',1,'',1663673419,1663673419),(114,'online_users',212,0,0,'my-index','19','side-post',2,'',1663673419,1663673419),(115,'badges',212,0,0,'my-index','19','side-post',3,'',1663673419,1663673419),(116,'calendar_month',212,0,0,'my-index','19','side-post',4,'',1663673419,1663673419),(117,'calendar_upcoming',212,0,0,'my-index','19','side-post',5,'',1663673419,1663673419),(118,'lp',212,0,0,'my-index','19','content',0,'',1663673419,1663673419),(119,'recentlyaccessedcourses',212,0,0,'my-index','19','content',1,'',1663673419,1663673419),(120,'myoverview',212,0,0,'my-index','19','content',2,'',1663673419,1663673419),(121,'timeline',222,0,0,'my-index','20','side-post',0,'',1663686326,1663686326),(122,'private_files',222,0,0,'my-index','20','side-post',1,'',1663686326,1663686326),(123,'online_users',222,0,0,'my-index','20','side-post',2,'',1663686326,1663686326),(124,'badges',222,0,0,'my-index','20','side-post',3,'',1663686326,1663686326),(125,'calendar_month',222,0,0,'my-index','20','side-post',4,'',1663686326,1663686326),(126,'calendar_upcoming',222,0,0,'my-index','20','side-post',5,'',1663686326,1663686326),(127,'lp',222,0,0,'my-index','20','content',0,'',1663686326,1663686326),(128,'recentlyaccessedcourses',222,0,0,'my-index','20','content',1,'',1663686326,1663686326),(129,'myoverview',222,0,0,'my-index','20','content',2,'',1663686326,1663686326),(130,'timeline',188,0,0,'my-index','21','side-post',0,'',1663690620,1663690620),(131,'private_files',188,0,0,'my-index','21','side-post',1,'',1663690620,1663690620),(132,'online_users',188,0,0,'my-index','21','side-post',2,'',1663690620,1663690620),(133,'badges',188,0,0,'my-index','21','side-post',3,'',1663690620,1663690620),(134,'calendar_month',188,0,0,'my-index','21','side-post',4,'',1663690620,1663690620),(135,'calendar_upcoming',188,0,0,'my-index','21','side-post',5,'',1663690620,1663690620),(136,'lp',188,0,0,'my-index','21','content',0,'',1663690620,1663690620),(137,'recentlyaccessedcourses',188,0,0,'my-index','21','content',1,'',1663690620,1663690620),(138,'myoverview',188,0,0,'my-index','21','content',2,'',1663690620,1663690620),(139,'timeline',242,0,0,'my-index','22','side-post',0,'',1663693089,1663693089),(140,'private_files',242,0,0,'my-index','22','side-post',1,'',1663693089,1663693089),(141,'online_users',242,0,0,'my-index','22','side-post',2,'',1663693089,1663693089),(142,'badges',242,0,0,'my-index','22','side-post',3,'',1663693089,1663693089),(143,'calendar_month',242,0,0,'my-index','22','side-post',4,'',1663693089,1663693089),(144,'calendar_upcoming',242,0,0,'my-index','22','side-post',5,'',1663693089,1663693089),(145,'lp',242,0,0,'my-index','22','content',0,'',1663693089,1663693089),(146,'recentlyaccessedcourses',242,0,0,'my-index','22','content',1,'',1663693089,1663693089),(147,'myoverview',242,0,0,'my-index','22','content',2,'',1663693089,1663693089),(148,'timeline',252,0,0,'my-index','23','side-post',0,'',1663924489,1663924489),(149,'private_files',252,0,0,'my-index','23','side-post',1,'',1663924489,1663924489),(150,'online_users',252,0,0,'my-index','23','side-post',2,'',1663924489,1663924489),(151,'badges',252,0,0,'my-index','23','side-post',3,'',1663924489,1663924489),(152,'calendar_month',252,0,0,'my-index','23','side-post',4,'',1663924489,1663924489),(153,'calendar_upcoming',252,0,0,'my-index','23','side-post',5,'',1663924489,1663924489),(154,'lp',252,0,0,'my-index','23','content',0,'',1663924489,1663924489),(155,'recentlyaccessedcourses',252,0,0,'my-index','23','content',1,'',1663924489,1663924489),(156,'myoverview',252,0,0,'my-index','23','content',2,'',1663924489,1663924489),(157,'timeline',263,0,0,'my-index','24','side-post',0,'',1663924992,1663924992),(158,'private_files',263,0,0,'my-index','24','side-post',1,'',1663924992,1663924992),(159,'online_users',263,0,0,'my-index','24','side-post',2,'',1663924992,1663924992),(160,'badges',263,0,0,'my-index','24','side-post',3,'',1663924992,1663924992),(161,'calendar_month',263,0,0,'my-index','24','side-post',4,'',1663924992,1663924992),(162,'calendar_upcoming',263,0,0,'my-index','24','side-post',5,'',1663924992,1663924992),(163,'lp',263,0,0,'my-index','24','content',0,'',1663924992,1663924992),(164,'recentlyaccessedcourses',263,0,0,'my-index','24','content',1,'',1663924992,1663924992),(165,'myoverview',263,0,0,'my-index','24','content',2,'',1663924992,1663924992),(166,'timeline',273,0,0,'my-index','25','side-post',0,'',1663926496,1663926496),(167,'private_files',273,0,0,'my-index','25','side-post',1,'',1663926496,1663926496),(168,'online_users',273,0,0,'my-index','25','side-post',2,'',1663926496,1663926496),(169,'badges',273,0,0,'my-index','25','side-post',3,'',1663926496,1663926496),(170,'calendar_month',273,0,0,'my-index','25','side-post',4,'',1663926496,1663926496),(171,'calendar_upcoming',273,0,0,'my-index','25','side-post',5,'',1663926496,1663926496),(172,'lp',273,0,0,'my-index','25','content',0,'',1663926496,1663926496),(173,'recentlyaccessedcourses',273,0,0,'my-index','25','content',1,'',1663926496,1663926496),(174,'myoverview',273,0,0,'my-index','25','content',2,'',1663926496,1663926496),(175,'timeline',283,0,0,'my-index','26','side-post',0,'',1663999891,1663999891),(176,'private_files',283,0,0,'my-index','26','side-post',1,'',1663999891,1663999891),(177,'online_users',283,0,0,'my-index','26','side-post',2,'',1663999891,1663999891),(178,'badges',283,0,0,'my-index','26','side-post',3,'',1663999891,1663999891),(179,'calendar_month',283,0,0,'my-index','26','side-post',4,'',1663999891,1663999891),(180,'calendar_upcoming',283,0,0,'my-index','26','side-post',5,'',1663999891,1663999891),(181,'lp',283,0,0,'my-index','26','content',0,'',1663999891,1663999891),(182,'recentlyaccessedcourses',283,0,0,'my-index','26','content',1,'',1663999891,1663999891),(183,'myoverview',283,0,0,'my-index','26','content',2,'',1663999891,1663999891),(184,'timeline',294,0,0,'my-index','29','side-post',0,'',1664001903,1664001903),(185,'private_files',294,0,0,'my-index','29','side-post',1,'',1664001903,1664001903),(186,'online_users',294,0,0,'my-index','29','side-post',2,'',1664001903,1664001903),(187,'badges',294,0,0,'my-index','29','side-post',3,'',1664001903,1664001903),(188,'calendar_month',294,0,0,'my-index','29','side-post',4,'',1664001903,1664001903),(189,'calendar_upcoming',294,0,0,'my-index','29','side-post',5,'',1664001903,1664001903),(190,'lp',294,0,0,'my-index','29','content',0,'',1664001903,1664001903),(191,'recentlyaccessedcourses',294,0,0,'my-index','29','content',1,'',1664001903,1664001903),(192,'myoverview',294,0,0,'my-index','29','content',2,'',1664001903,1664001903),(193,'timeline',315,0,0,'my-index','30','side-post',0,'',1664449702,1664449702),(194,'private_files',315,0,0,'my-index','30','side-post',1,'',1664449702,1664449702),(195,'online_users',315,0,0,'my-index','30','side-post',2,'',1664449702,1664449702),(196,'badges',315,0,0,'my-index','30','side-post',3,'',1664449702,1664449702),(197,'calendar_month',315,0,0,'my-index','30','side-post',4,'',1664449702,1664449702),(198,'calendar_upcoming',315,0,0,'my-index','30','side-post',5,'',1664449702,1664449702),(199,'lp',315,0,0,'my-index','30','content',0,'',1664449702,1664449702),(200,'recentlyaccessedcourses',315,0,0,'my-index','30','content',1,'',1664449702,1664449702),(201,'myoverview',315,0,0,'my-index','30','content',2,'',1664449702,1664449702),(202,'timeline',333,0,0,'my-index','31','side-post',0,'',1664451885,1664451885),(203,'private_files',333,0,0,'my-index','31','side-post',1,'',1664451885,1664451885),(204,'online_users',333,0,0,'my-index','31','side-post',2,'',1664451885,1664451885),(205,'badges',333,0,0,'my-index','31','side-post',3,'',1664451885,1664451885),(206,'calendar_month',333,0,0,'my-index','31','side-post',4,'',1664451885,1664451885),(207,'calendar_upcoming',333,0,0,'my-index','31','side-post',5,'',1664451885,1664451885),(208,'lp',333,0,0,'my-index','31','content',0,'',1664451885,1664451885),(209,'recentlyaccessedcourses',333,0,0,'my-index','31','content',1,'',1664451885,1664451885),(210,'myoverview',333,0,0,'my-index','31','content',2,'',1664451885,1664451885),(211,'timeline',344,0,0,'my-index','32','side-post',0,'',1664514818,1664514818),(212,'private_files',344,0,0,'my-index','32','side-post',1,'',1664514818,1664514818),(213,'online_users',344,0,0,'my-index','32','side-post',2,'',1664514818,1664514818),(214,'badges',344,0,0,'my-index','32','side-post',3,'',1664514818,1664514818),(215,'calendar_month',344,0,0,'my-index','32','side-post',4,'',1664514818,1664514818),(216,'calendar_upcoming',344,0,0,'my-index','32','side-post',5,'',1664514818,1664514818),(217,'lp',344,0,0,'my-index','32','content',0,'',1664514818,1664514818),(218,'recentlyaccessedcourses',344,0,0,'my-index','32','content',1,'',1664514818,1664514818),(219,'myoverview',344,0,0,'my-index','32','content',2,'',1664514818,1664514818),(220,'timeline',354,0,0,'my-index','33','side-post',0,'',1664522256,1664522256),(221,'private_files',354,0,0,'my-index','33','side-post',1,'',1664522256,1664522256),(222,'online_users',354,0,0,'my-index','33','side-post',2,'',1664522256,1664522256),(223,'badges',354,0,0,'my-index','33','side-post',3,'',1664522256,1664522256),(224,'calendar_month',354,0,0,'my-index','33','side-post',4,'',1664522256,1664522256),(225,'calendar_upcoming',354,0,0,'my-index','33','side-post',5,'',1664522256,1664522256),(226,'lp',354,0,0,'my-index','33','content',0,'',1664522256,1664522256),(227,'recentlyaccessedcourses',354,0,0,'my-index','33','content',1,'',1664522256,1664522256),(228,'myoverview',354,0,0,'my-index','33','content',2,'',1664522256,1664522256),(229,'timeline',343,0,0,'my-index','34','side-post',0,'',1664524323,1664524323),(230,'private_files',343,0,0,'my-index','34','side-post',1,'',1664524323,1664524323),(231,'online_users',343,0,0,'my-index','34','side-post',2,'',1664524323,1664524323),(232,'badges',343,0,0,'my-index','34','side-post',3,'',1664524323,1664524323),(233,'calendar_month',343,0,0,'my-index','34','side-post',4,'',1664524323,1664524323),(234,'calendar_upcoming',343,0,0,'my-index','34','side-post',5,'',1664524323,1664524323),(235,'lp',343,0,0,'my-index','34','content',0,'',1664524323,1664524323),(236,'recentlyaccessedcourses',343,0,0,'my-index','34','content',1,'',1664524323,1664524323),(237,'myoverview',343,0,0,'my-index','34','content',2,'',1664524323,1664524323),(238,'timeline',379,0,0,'my-index','36','side-post',0,'',1664630711,1664630711),(239,'private_files',379,0,0,'my-index','36','side-post',1,'',1664630711,1664630711),(240,'online_users',379,0,0,'my-index','36','side-post',2,'',1664630711,1664630711),(241,'badges',379,0,0,'my-index','36','side-post',3,'',1664630711,1664630711),(242,'calendar_month',379,0,0,'my-index','36','side-post',4,'',1664630711,1664630711),(243,'calendar_upcoming',379,0,0,'my-index','36','side-post',5,'',1664630711,1664630711),(244,'lp',379,0,0,'my-index','36','content',0,'',1664630711,1664630711),(245,'recentlyaccessedcourses',379,0,0,'my-index','36','content',1,'',1664630711,1664630711),(246,'myoverview',379,0,0,'my-index','36','content',2,'',1664630711,1664630711),(247,'timeline',390,0,0,'my-index','37','side-post',0,'',1664632888,1664632888),(248,'private_files',390,0,0,'my-index','37','side-post',1,'',1664632888,1664632888),(249,'online_users',390,0,0,'my-index','37','side-post',2,'',1664632888,1664632888),(250,'badges',390,0,0,'my-index','37','side-post',3,'',1664632888,1664632888),(251,'calendar_month',390,0,0,'my-index','37','side-post',4,'',1664632888,1664632888),(252,'calendar_upcoming',390,0,0,'my-index','37','side-post',5,'',1664632888,1664632888),(253,'lp',390,0,0,'my-index','37','content',0,'',1664632888,1664632888),(254,'recentlyaccessedcourses',390,0,0,'my-index','37','content',1,'',1664632888,1664632888),(255,'myoverview',390,0,0,'my-index','37','content',2,'',1664632888,1664632888),(256,'timeline',403,0,0,'my-index','39','side-post',0,'',1664645121,1664645121),(257,'private_files',403,0,0,'my-index','39','side-post',1,'',1664645121,1664645121),(258,'online_users',403,0,0,'my-index','39','side-post',2,'',1664645121,1664645121),(259,'badges',403,0,0,'my-index','39','side-post',3,'',1664645121,1664645121),(260,'calendar_month',403,0,0,'my-index','39','side-post',4,'',1664645121,1664645121),(261,'calendar_upcoming',403,0,0,'my-index','39','side-post',5,'',1664645121,1664645121),(262,'lp',403,0,0,'my-index','39','content',0,'',1664645121,1664645121),(263,'recentlyaccessedcourses',403,0,0,'my-index','39','content',1,'',1664645121,1664645121),(264,'myoverview',403,0,0,'my-index','39','content',2,'',1664645121,1664645121),(265,'timeline',413,0,0,'my-index','40','side-post',0,'',1664734390,1664734390),(266,'private_files',413,0,0,'my-index','40','side-post',1,'',1664734390,1664734390),(267,'online_users',413,0,0,'my-index','40','side-post',2,'',1664734390,1664734390),(268,'badges',413,0,0,'my-index','40','side-post',3,'',1664734390,1664734390),(269,'calendar_month',413,0,0,'my-index','40','side-post',4,'',1664734390,1664734390),(270,'calendar_upcoming',413,0,0,'my-index','40','side-post',5,'',1664734390,1664734390),(271,'lp',413,0,0,'my-index','40','content',0,'',1664734390,1664734390),(272,'recentlyaccessedcourses',413,0,0,'my-index','40','content',1,'',1664734390,1664734390),(273,'myoverview',413,0,0,'my-index','40','content',2,'',1664734390,1664734390),(274,'timeline',425,0,0,'my-index','41','side-post',0,'',1664734996,1664734996),(275,'private_files',425,0,0,'my-index','41','side-post',1,'',1664734996,1664734996),(276,'online_users',425,0,0,'my-index','41','side-post',2,'',1664734996,1664734996),(277,'badges',425,0,0,'my-index','41','side-post',3,'',1664734996,1664734996),(278,'calendar_month',425,0,0,'my-index','41','side-post',4,'',1664734996,1664734996),(279,'calendar_upcoming',425,0,0,'my-index','41','side-post',5,'',1664734996,1664734996),(280,'lp',425,0,0,'my-index','41','content',0,'',1664734996,1664734996),(281,'recentlyaccessedcourses',425,0,0,'my-index','41','content',1,'',1664734996,1664734996),(282,'myoverview',425,0,0,'my-index','41','content',2,'',1664734996,1664734996),(283,'timeline',435,0,0,'my-index','42','side-post',0,'',1664774420,1664774420),(284,'private_files',435,0,0,'my-index','42','side-post',1,'',1664774420,1664774420),(285,'online_users',435,0,0,'my-index','42','side-post',2,'',1664774420,1664774420),(286,'badges',435,0,0,'my-index','42','side-post',3,'',1664774420,1664774420),(287,'calendar_month',435,0,0,'my-index','42','side-post',4,'',1664774420,1664774420),(288,'calendar_upcoming',435,0,0,'my-index','42','side-post',5,'',1664774420,1664774420),(289,'lp',435,0,0,'my-index','42','content',0,'',1664774420,1664774420),(290,'recentlyaccessedcourses',435,0,0,'my-index','42','content',1,'',1664774420,1664774420),(291,'myoverview',435,0,0,'my-index','42','content',2,'',1664774420,1664774420),(292,'timeline',447,0,0,'my-index','43','side-post',0,'',1664796477,1664796477),(293,'private_files',447,0,0,'my-index','43','side-post',1,'',1664796477,1664796477),(294,'online_users',447,0,0,'my-index','43','side-post',2,'',1664796477,1664796477),(295,'badges',447,0,0,'my-index','43','side-post',3,'',1664796477,1664796477),(296,'calendar_month',447,0,0,'my-index','43','side-post',4,'',1664796477,1664796477),(297,'calendar_upcoming',447,0,0,'my-index','43','side-post',5,'',1664796477,1664796477),(298,'lp',447,0,0,'my-index','43','content',0,'',1664796477,1664796477),(299,'recentlyaccessedcourses',447,0,0,'my-index','43','content',1,'',1664796477,1664796477),(300,'myoverview',447,0,0,'my-index','43','content',2,'',1664796477,1664796477),(301,'timeline',457,0,0,'my-index','44','side-post',0,'',1664799206,1664799206),(302,'private_files',457,0,0,'my-index','44','side-post',1,'',1664799206,1664799206),(303,'online_users',457,0,0,'my-index','44','side-post',2,'',1664799206,1664799206),(304,'badges',457,0,0,'my-index','44','side-post',3,'',1664799206,1664799206),(305,'calendar_month',457,0,0,'my-index','44','side-post',4,'',1664799206,1664799206),(306,'calendar_upcoming',457,0,0,'my-index','44','side-post',5,'',1664799206,1664799206),(307,'lp',457,0,0,'my-index','44','content',0,'',1664799206,1664799206),(308,'recentlyaccessedcourses',457,0,0,'my-index','44','content',1,'',1664799206,1664799206),(309,'myoverview',457,0,0,'my-index','44','content',2,'',1664799206,1664799206),(310,'timeline',470,0,0,'my-index','45','side-post',0,'',1664818409,1664818409),(311,'private_files',470,0,0,'my-index','45','side-post',1,'',1664818409,1664818409),(312,'online_users',470,0,0,'my-index','45','side-post',2,'',1664818409,1664818409),(313,'badges',470,0,0,'my-index','45','side-post',3,'',1664818409,1664818409),(314,'calendar_month',470,0,0,'my-index','45','side-post',4,'',1664818409,1664818409),(315,'calendar_upcoming',470,0,0,'my-index','45','side-post',5,'',1664818409,1664818409),(316,'lp',470,0,0,'my-index','45','content',0,'',1664818409,1664818409),(317,'recentlyaccessedcourses',470,0,0,'my-index','45','content',1,'',1664818409,1664818409),(318,'myoverview',470,0,0,'my-index','45','content',2,'',1664818409,1664818409),(319,'timeline',480,0,0,'my-index','46','side-post',0,'',1664861424,1664861424),(320,'private_files',480,0,0,'my-index','46','side-post',1,'',1664861424,1664861424),(321,'online_users',480,0,0,'my-index','46','side-post',2,'',1664861424,1664861424),(322,'badges',480,0,0,'my-index','46','side-post',3,'',1664861424,1664861424),(323,'calendar_month',480,0,0,'my-index','46','side-post',4,'',1664861424,1664861424),(324,'calendar_upcoming',480,0,0,'my-index','46','side-post',5,'',1664861424,1664861424),(325,'lp',480,0,0,'my-index','46','content',0,'',1664861424,1664861424),(326,'recentlyaccessedcourses',480,0,0,'my-index','46','content',1,'',1664861424,1664861424),(327,'myoverview',480,0,0,'my-index','46','content',2,'',1664861424,1664861424),(328,'timeline',499,0,0,'my-index','48','side-post',0,'',1665055540,1665055540),(329,'private_files',499,0,0,'my-index','48','side-post',1,'',1665055540,1665055540),(330,'online_users',499,0,0,'my-index','48','side-post',2,'',1665055540,1665055540),(331,'badges',499,0,0,'my-index','48','side-post',3,'',1665055540,1665055540),(332,'calendar_month',499,0,0,'my-index','48','side-post',4,'',1665055540,1665055540),(333,'calendar_upcoming',499,0,0,'my-index','48','side-post',5,'',1665055540,1665055540),(334,'lp',499,0,0,'my-index','48','content',0,'',1665055540,1665055540),(335,'recentlyaccessedcourses',499,0,0,'my-index','48','content',1,'',1665055540,1665055540),(336,'myoverview',499,0,0,'my-index','48','content',2,'',1665055540,1665055540),(337,'timeline',509,0,0,'my-index','49','side-post',0,'',1665117478,1665117478),(338,'private_files',509,0,0,'my-index','49','side-post',1,'',1665117478,1665117478),(339,'online_users',509,0,0,'my-index','49','side-post',2,'',1665117478,1665117478),(340,'badges',509,0,0,'my-index','49','side-post',3,'',1665117478,1665117478),(341,'calendar_month',509,0,0,'my-index','49','side-post',4,'',1665117478,1665117478),(342,'calendar_upcoming',509,0,0,'my-index','49','side-post',5,'',1665117478,1665117478),(343,'lp',509,0,0,'my-index','49','content',0,'',1665117478,1665117478),(344,'recentlyaccessedcourses',509,0,0,'my-index','49','content',1,'',1665117478,1665117478),(345,'myoverview',509,0,0,'my-index','49','content',2,'',1665117478,1665117478),(346,'timeline',525,0,0,'my-index','50','side-post',0,'',1665234113,1665234113),(347,'private_files',525,0,0,'my-index','50','side-post',1,'',1665234113,1665234113),(348,'online_users',525,0,0,'my-index','50','side-post',2,'',1665234113,1665234113),(349,'badges',525,0,0,'my-index','50','side-post',3,'',1665234113,1665234113),(350,'calendar_month',525,0,0,'my-index','50','side-post',4,'',1665234113,1665234113),(351,'calendar_upcoming',525,0,0,'my-index','50','side-post',5,'',1665234113,1665234113),(352,'lp',525,0,0,'my-index','50','content',0,'',1665234113,1665234113),(353,'recentlyaccessedcourses',525,0,0,'my-index','50','content',1,'',1665234113,1665234113),(354,'myoverview',525,0,0,'my-index','50','content',2,'',1665234113,1665234113),(355,'timeline',521,0,0,'my-index','51','side-post',0,'',1665388199,1665388199),(356,'private_files',521,0,0,'my-index','51','side-post',1,'',1665388199,1665388199),(357,'online_users',521,0,0,'my-index','51','side-post',2,'',1665388199,1665388199),(358,'badges',521,0,0,'my-index','51','side-post',3,'',1665388199,1665388199),(359,'calendar_month',521,0,0,'my-index','51','side-post',4,'',1665388199,1665388199),(360,'calendar_upcoming',521,0,0,'my-index','51','side-post',5,'',1665388199,1665388199),(361,'lp',521,0,0,'my-index','51','content',0,'',1665388199,1665388199),(362,'recentlyaccessedcourses',521,0,0,'my-index','51','content',1,'',1665388199,1665388199),(363,'myoverview',521,0,0,'my-index','51','content',2,'',1665388199,1665388199),(364,'timeline',579,0,0,'my-index','52','side-post',0,'',1665394056,1665394056),(365,'private_files',579,0,0,'my-index','52','side-post',1,'',1665394056,1665394056),(366,'online_users',579,0,0,'my-index','52','side-post',2,'',1665394056,1665394056),(367,'badges',579,0,0,'my-index','52','side-post',3,'',1665394056,1665394056),(368,'calendar_month',579,0,0,'my-index','52','side-post',4,'',1665394056,1665394056),(369,'calendar_upcoming',579,0,0,'my-index','52','side-post',5,'',1665394056,1665394056),(370,'lp',579,0,0,'my-index','52','content',0,'',1665394056,1665394056),(371,'recentlyaccessedcourses',579,0,0,'my-index','52','content',1,'',1665394056,1665394056),(372,'myoverview',579,0,0,'my-index','52','content',2,'',1665394056,1665394056),(373,'timeline',592,0,0,'my-index','53','side-post',0,'',1665395208,1665395208),(374,'private_files',592,0,0,'my-index','53','side-post',1,'',1665395208,1665395208),(375,'online_users',592,0,0,'my-index','53','side-post',2,'',1665395208,1665395208),(376,'badges',592,0,0,'my-index','53','side-post',3,'',1665395208,1665395208),(377,'calendar_month',592,0,0,'my-index','53','side-post',4,'',1665395208,1665395208),(378,'calendar_upcoming',592,0,0,'my-index','53','side-post',5,'',1665395208,1665395208),(379,'lp',592,0,0,'my-index','53','content',0,'',1665395208,1665395208),(380,'recentlyaccessedcourses',592,0,0,'my-index','53','content',1,'',1665395208,1665395208),(381,'myoverview',592,0,0,'my-index','53','content',2,'',1665395208,1665395208),(382,'timeline',603,0,0,'my-index','56','side-post',0,'',1665395727,1665395727),(383,'private_files',603,0,0,'my-index','56','side-post',1,'',1665395727,1665395727),(384,'online_users',603,0,0,'my-index','56','side-post',2,'',1665395727,1665395727),(385,'badges',603,0,0,'my-index','56','side-post',3,'',1665395727,1665395727),(386,'calendar_month',603,0,0,'my-index','56','side-post',4,'',1665395727,1665395727),(387,'calendar_upcoming',603,0,0,'my-index','56','side-post',5,'',1665395727,1665395727),(388,'lp',603,0,0,'my-index','56','content',0,'',1665395727,1665395727),(389,'recentlyaccessedcourses',603,0,0,'my-index','56','content',1,'',1665395727,1665395727),(390,'myoverview',603,0,0,'my-index','56','content',2,'',1665395727,1665395727),(391,'timeline',665,0,0,'my-index','57','side-post',0,'',1665832233,1665832233),(392,'private_files',665,0,0,'my-index','57','side-post',1,'',1665832233,1665832233),(393,'online_users',665,0,0,'my-index','57','side-post',2,'',1665832233,1665832233),(394,'badges',665,0,0,'my-index','57','side-post',3,'',1665832233,1665832233),(395,'calendar_month',665,0,0,'my-index','57','side-post',4,'',1665832233,1665832233),(396,'calendar_upcoming',665,0,0,'my-index','57','side-post',5,'',1665832233,1665832233),(397,'lp',665,0,0,'my-index','57','content',0,'',1665832233,1665832233),(398,'recentlyaccessedcourses',665,0,0,'my-index','57','content',1,'',1665832233,1665832233),(399,'myoverview',665,0,0,'my-index','57','content',2,'',1665832233,1665832233),(400,'timeline',676,0,0,'my-index','58','side-post',0,'',1665986662,1665986662),(401,'private_files',676,0,0,'my-index','58','side-post',1,'',1665986662,1665986662),(402,'online_users',676,0,0,'my-index','58','side-post',2,'',1665986662,1665986662),(403,'badges',676,0,0,'my-index','58','side-post',3,'',1665986662,1665986662),(404,'calendar_month',676,0,0,'my-index','58','side-post',4,'',1665986662,1665986662),(405,'calendar_upcoming',676,0,0,'my-index','58','side-post',5,'',1665986662,1665986662),(406,'lp',676,0,0,'my-index','58','content',0,'',1665986662,1665986662),(407,'recentlyaccessedcourses',676,0,0,'my-index','58','content',1,'',1665986662,1665986662),(408,'myoverview',676,0,0,'my-index','58','content',2,'',1665986662,1665986662),(409,'timeline',704,0,0,'my-index','59','side-post',0,'',1666000249,1666000249),(410,'private_files',704,0,0,'my-index','59','side-post',1,'',1666000249,1666000249),(411,'online_users',704,0,0,'my-index','59','side-post',2,'',1666000249,1666000249),(412,'badges',704,0,0,'my-index','59','side-post',3,'',1666000249,1666000249),(413,'calendar_month',704,0,0,'my-index','59','side-post',4,'',1666000249,1666000249),(414,'calendar_upcoming',704,0,0,'my-index','59','side-post',5,'',1666000249,1666000249),(415,'lp',704,0,0,'my-index','59','content',0,'',1666000249,1666000249),(416,'recentlyaccessedcourses',704,0,0,'my-index','59','content',1,'',1666000249,1666000249),(417,'myoverview',704,0,0,'my-index','59','content',2,'',1666000249,1666000249),(418,'timeline',721,0,0,'my-index','60','side-post',0,'',1666010270,1666010270),(419,'private_files',721,0,0,'my-index','60','side-post',1,'',1666010270,1666010270),(420,'online_users',721,0,0,'my-index','60','side-post',2,'',1666010270,1666010270),(421,'badges',721,0,0,'my-index','60','side-post',3,'',1666010270,1666010270),(422,'calendar_month',721,0,0,'my-index','60','side-post',4,'',1666010270,1666010270),(423,'calendar_upcoming',721,0,0,'my-index','60','side-post',5,'',1666010270,1666010270),(424,'lp',721,0,0,'my-index','60','content',0,'',1666010270,1666010270),(425,'recentlyaccessedcourses',721,0,0,'my-index','60','content',1,'',1666010270,1666010270),(426,'myoverview',721,0,0,'my-index','60','content',2,'',1666010270,1666010270),(427,'timeline',738,0,0,'my-index','61','side-post',0,'',1666019586,1666019586),(428,'private_files',738,0,0,'my-index','61','side-post',1,'',1666019586,1666019586),(429,'online_users',738,0,0,'my-index','61','side-post',2,'',1666019586,1666019586),(430,'badges',738,0,0,'my-index','61','side-post',3,'',1666019586,1666019586),(431,'calendar_month',738,0,0,'my-index','61','side-post',4,'',1666019586,1666019586),(432,'calendar_upcoming',738,0,0,'my-index','61','side-post',5,'',1666019586,1666019586),(433,'lp',738,0,0,'my-index','61','content',0,'',1666019586,1666019586),(434,'recentlyaccessedcourses',738,0,0,'my-index','61','content',1,'',1666019586,1666019586),(435,'myoverview',738,0,0,'my-index','61','content',2,'',1666019586,1666019586),(436,'timeline',753,0,0,'my-index','62','side-post',0,'',1666067235,1666067235),(437,'private_files',753,0,0,'my-index','62','side-post',1,'',1666067235,1666067235),(438,'online_users',753,0,0,'my-index','62','side-post',2,'',1666067235,1666067235),(439,'badges',753,0,0,'my-index','62','side-post',3,'',1666067235,1666067235),(440,'calendar_month',753,0,0,'my-index','62','side-post',4,'',1666067235,1666067235),(441,'calendar_upcoming',753,0,0,'my-index','62','side-post',5,'',1666067235,1666067235),(442,'lp',753,0,0,'my-index','62','content',0,'',1666067235,1666067235),(443,'recentlyaccessedcourses',753,0,0,'my-index','62','content',1,'',1666067235,1666067235),(444,'myoverview',753,0,0,'my-index','62','content',2,'',1666067235,1666067235),(445,'timeline',764,0,0,'my-index','63','side-post',0,'',1666067814,1666067814),(446,'private_files',764,0,0,'my-index','63','side-post',1,'',1666067814,1666067814),(447,'online_users',764,0,0,'my-index','63','side-post',2,'',1666067814,1666067814),(448,'badges',764,0,0,'my-index','63','side-post',3,'',1666067814,1666067814),(449,'calendar_month',764,0,0,'my-index','63','side-post',4,'',1666067814,1666067814),(450,'calendar_upcoming',764,0,0,'my-index','63','side-post',5,'',1666067814,1666067814),(451,'lp',764,0,0,'my-index','63','content',0,'',1666067814,1666067814),(452,'recentlyaccessedcourses',764,0,0,'my-index','63','content',1,'',1666067814,1666067814),(453,'myoverview',764,0,0,'my-index','63','content',2,'',1666067814,1666067814),(454,'timeline',777,0,0,'my-index','64','side-post',0,'',1666070197,1666070197),(455,'private_files',777,0,0,'my-index','64','side-post',1,'',1666070197,1666070197),(456,'online_users',777,0,0,'my-index','64','side-post',2,'',1666070197,1666070197),(457,'badges',777,0,0,'my-index','64','side-post',3,'',1666070197,1666070197),(458,'calendar_month',777,0,0,'my-index','64','side-post',4,'',1666070197,1666070197),(459,'calendar_upcoming',777,0,0,'my-index','64','side-post',5,'',1666070197,1666070197),(460,'lp',777,0,0,'my-index','64','content',0,'',1666070197,1666070197),(461,'recentlyaccessedcourses',777,0,0,'my-index','64','content',1,'',1666070197,1666070197),(462,'myoverview',777,0,0,'my-index','64','content',2,'',1666070197,1666070197),(463,'timeline',787,0,0,'my-index','65','side-post',0,'',1666070417,1666070417),(464,'private_files',787,0,0,'my-index','65','side-post',1,'',1666070417,1666070417),(465,'online_users',787,0,0,'my-index','65','side-post',2,'',1666070417,1666070417),(466,'badges',787,0,0,'my-index','65','side-post',3,'',1666070417,1666070417),(467,'calendar_month',787,0,0,'my-index','65','side-post',4,'',1666070417,1666070417),(468,'calendar_upcoming',787,0,0,'my-index','65','side-post',5,'',1666070417,1666070417),(469,'lp',787,0,0,'my-index','65','content',0,'',1666070417,1666070417),(470,'recentlyaccessedcourses',787,0,0,'my-index','65','content',1,'',1666070417,1666070417),(471,'myoverview',787,0,0,'my-index','65','content',2,'',1666070417,1666070417),(472,'timeline',797,0,0,'my-index','66','side-post',0,'',1666076090,1666076090),(473,'private_files',797,0,0,'my-index','66','side-post',1,'',1666076090,1666076090),(474,'online_users',797,0,0,'my-index','66','side-post',2,'',1666076090,1666076090),(475,'badges',797,0,0,'my-index','66','side-post',3,'',1666076090,1666076090),(476,'calendar_month',797,0,0,'my-index','66','side-post',4,'',1666076090,1666076090),(477,'calendar_upcoming',797,0,0,'my-index','66','side-post',5,'',1666076090,1666076090),(478,'lp',797,0,0,'my-index','66','content',0,'',1666076090,1666076090),(479,'recentlyaccessedcourses',797,0,0,'my-index','66','content',1,'',1666076090,1666076090),(480,'myoverview',797,0,0,'my-index','66','content',2,'',1666076090,1666076090),(481,'timeline',809,0,0,'my-index','68','side-post',0,'',1666077694,1666077694),(482,'private_files',809,0,0,'my-index','68','side-post',1,'',1666077694,1666077694),(483,'online_users',809,0,0,'my-index','68','side-post',2,'',1666077694,1666077694),(484,'badges',809,0,0,'my-index','68','side-post',3,'',1666077694,1666077694),(485,'calendar_month',809,0,0,'my-index','68','side-post',4,'',1666077694,1666077694),(486,'calendar_upcoming',809,0,0,'my-index','68','side-post',5,'',1666077694,1666077694),(487,'lp',809,0,0,'my-index','68','content',0,'',1666077694,1666077694),(488,'recentlyaccessedcourses',809,0,0,'my-index','68','content',1,'',1666077694,1666077694),(489,'myoverview',809,0,0,'my-index','68','content',2,'',1666077694,1666077694),(490,'timeline',820,0,0,'my-index','69','side-post',0,'',1666078326,1666078326),(491,'private_files',820,0,0,'my-index','69','side-post',1,'',1666078326,1666078326),(492,'online_users',820,0,0,'my-index','69','side-post',2,'',1666078326,1666078326),(493,'badges',820,0,0,'my-index','69','side-post',3,'',1666078326,1666078326),(494,'calendar_month',820,0,0,'my-index','69','side-post',4,'',1666078326,1666078326),(495,'calendar_upcoming',820,0,0,'my-index','69','side-post',5,'',1666078326,1666078326),(496,'lp',820,0,0,'my-index','69','content',0,'',1666078326,1666078326),(497,'recentlyaccessedcourses',820,0,0,'my-index','69','content',1,'',1666078326,1666078326),(498,'myoverview',820,0,0,'my-index','69','content',2,'',1666078326,1666078326),(499,'timeline',830,0,0,'my-index','70','side-post',0,'',1666078794,1666078794),(500,'private_files',830,0,0,'my-index','70','side-post',1,'',1666078794,1666078794),(501,'online_users',830,0,0,'my-index','70','side-post',2,'',1666078794,1666078794),(502,'badges',830,0,0,'my-index','70','side-post',3,'',1666078794,1666078794),(503,'calendar_month',830,0,0,'my-index','70','side-post',4,'',1666078794,1666078794),(504,'calendar_upcoming',830,0,0,'my-index','70','side-post',5,'',1666078794,1666078794),(505,'lp',830,0,0,'my-index','70','content',0,'',1666078794,1666078794),(506,'recentlyaccessedcourses',830,0,0,'my-index','70','content',1,'',1666078794,1666078794),(507,'myoverview',830,0,0,'my-index','70','content',2,'',1666078794,1666078794),(508,'timeline',846,0,0,'my-index','71','side-post',0,'',1666086851,1666086851),(509,'private_files',846,0,0,'my-index','71','side-post',1,'',1666086851,1666086851),(510,'online_users',846,0,0,'my-index','71','side-post',2,'',1666086851,1666086851),(511,'badges',846,0,0,'my-index','71','side-post',3,'',1666086851,1666086851),(512,'calendar_month',846,0,0,'my-index','71','side-post',4,'',1666086851,1666086851),(513,'calendar_upcoming',846,0,0,'my-index','71','side-post',5,'',1666086851,1666086851),(514,'lp',846,0,0,'my-index','71','content',0,'',1666086851,1666086851),(515,'recentlyaccessedcourses',846,0,0,'my-index','71','content',1,'',1666086851,1666086851),(516,'myoverview',846,0,0,'my-index','71','content',2,'',1666086851,1666086851),(517,'timeline',862,0,0,'my-index','72','side-post',0,'',1666088174,1666088174),(518,'private_files',862,0,0,'my-index','72','side-post',1,'',1666088174,1666088174),(519,'online_users',862,0,0,'my-index','72','side-post',2,'',1666088174,1666088174),(520,'badges',862,0,0,'my-index','72','side-post',3,'',1666088174,1666088174),(521,'calendar_month',862,0,0,'my-index','72','side-post',4,'',1666088174,1666088174),(522,'calendar_upcoming',862,0,0,'my-index','72','side-post',5,'',1666088174,1666088174),(523,'lp',862,0,0,'my-index','72','content',0,'',1666088174,1666088174),(524,'recentlyaccessedcourses',862,0,0,'my-index','72','content',1,'',1666088175,1666088175),(525,'myoverview',862,0,0,'my-index','72','content',2,'',1666088175,1666088175),(526,'globalsearch',5,0,0,'my-index','3','side-pre',6,'',1666156407,1666156407),(527,'globalsearch',5,0,0,'my-index','3','side-pre',6,'',1666156424,1666156424),(528,'timeline',492,0,0,'my-index','73','side-post',0,'',1666184184,1666184184),(529,'private_files',492,0,0,'my-index','73','side-post',1,'',1666184184,1666184184),(530,'online_users',492,0,0,'my-index','73','side-post',2,'',1666184184,1666184184),(531,'badges',492,0,0,'my-index','73','side-post',3,'',1666184184,1666184184),(532,'calendar_month',492,0,0,'my-index','73','side-post',4,'',1666184184,1666184184),(533,'calendar_upcoming',492,0,0,'my-index','73','side-post',5,'',1666184184,1666184184),(534,'lp',492,0,0,'my-index','73','content',0,'',1666184184,1666184184),(535,'recentlyaccessedcourses',492,0,0,'my-index','73','content',1,'',1666184184,1666184184),(536,'myoverview',492,0,0,'my-index','73','content',2,'',1666184184,1666184184),(537,'timeline',900,0,0,'my-index','74','side-post',0,'',1666242672,1666242672),(538,'private_files',900,0,0,'my-index','74','side-post',1,'',1666242672,1666242672),(539,'online_users',900,0,0,'my-index','74','side-post',2,'',1666242672,1666242672),(540,'badges',900,0,0,'my-index','74','side-post',3,'',1666242672,1666242672),(541,'calendar_month',900,0,0,'my-index','74','side-post',4,'',1666242672,1666242672),(542,'calendar_upcoming',900,0,0,'my-index','74','side-post',5,'',1666242672,1666242672),(543,'lp',900,0,0,'my-index','74','content',0,'',1666242672,1666242672),(544,'recentlyaccessedcourses',900,0,0,'my-index','74','content',1,'',1666242672,1666242672),(545,'myoverview',900,0,0,'my-index','74','content',2,'',1666242672,1666242672),(546,'timeline',914,0,0,'my-index','75','side-post',0,'',1666247617,1666247617),(547,'private_files',914,0,0,'my-index','75','side-post',1,'',1666247617,1666247617),(548,'online_users',914,0,0,'my-index','75','side-post',2,'',1666247617,1666247617),(549,'badges',914,0,0,'my-index','75','side-post',3,'',1666247617,1666247617),(550,'calendar_month',914,0,0,'my-index','75','side-post',4,'',1666247617,1666247617),(551,'calendar_upcoming',914,0,0,'my-index','75','side-post',5,'',1666247617,1666247617),(552,'lp',914,0,0,'my-index','75','content',0,'',1666247617,1666247617),(553,'recentlyaccessedcourses',914,0,0,'my-index','75','content',1,'',1666247617,1666247617),(554,'myoverview',914,0,0,'my-index','75','content',2,'',1666247617,1666247617),(555,'timeline',941,0,0,'my-index','76','side-post',0,'',1666263776,1666263776),(556,'private_files',941,0,0,'my-index','76','side-post',1,'',1666263776,1666263776),(557,'online_users',941,0,0,'my-index','76','side-post',2,'',1666263776,1666263776),(558,'badges',941,0,0,'my-index','76','side-post',3,'',1666263776,1666263776),(559,'calendar_month',941,0,0,'my-index','76','side-post',4,'',1666263776,1666263776),(560,'calendar_upcoming',941,0,0,'my-index','76','side-post',5,'',1666263776,1666263776),(561,'lp',941,0,0,'my-index','76','content',0,'',1666263776,1666263776),(562,'recentlyaccessedcourses',941,0,0,'my-index','76','content',1,'',1666263776,1666263776),(563,'myoverview',941,0,0,'my-index','76','content',2,'',1666263776,1666263776),(564,'timeline',719,0,0,'my-index','77','side-post',0,'',1666266280,1666266280),(565,'private_files',719,0,0,'my-index','77','side-post',1,'',1666266280,1666266280),(566,'online_users',719,0,0,'my-index','77','side-post',2,'',1666266280,1666266280),(567,'badges',719,0,0,'my-index','77','side-post',3,'',1666266280,1666266280),(568,'calendar_month',719,0,0,'my-index','77','side-post',4,'',1666266280,1666266280),(569,'calendar_upcoming',719,0,0,'my-index','77','side-post',5,'',1666266280,1666266280),(570,'lp',719,0,0,'my-index','77','content',0,'',1666266280,1666266280),(571,'recentlyaccessedcourses',719,0,0,'my-index','77','content',1,'',1666266280,1666266280),(572,'myoverview',719,0,0,'my-index','77','content',2,'',1666266280,1666266280),(573,'timeline',962,0,0,'my-index','79','side-post',0,'',1666269881,1666269881),(574,'private_files',962,0,0,'my-index','79','side-post',1,'',1666269881,1666269881),(575,'online_users',962,0,0,'my-index','79','side-post',2,'',1666269881,1666269881),(576,'badges',962,0,0,'my-index','79','side-post',3,'',1666269881,1666269881),(577,'calendar_month',962,0,0,'my-index','79','side-post',4,'',1666269881,1666269881),(578,'calendar_upcoming',962,0,0,'my-index','79','side-post',5,'',1666269881,1666269881),(579,'lp',962,0,0,'my-index','79','content',0,'',1666269881,1666269881),(580,'recentlyaccessedcourses',962,0,0,'my-index','79','content',1,'',1666269881,1666269881),(581,'myoverview',962,0,0,'my-index','79','content',2,'',1666269881,1666269881),(582,'timeline',972,0,0,'my-index','80','side-post',0,'',1666278859,1666278859),(583,'private_files',972,0,0,'my-index','80','side-post',1,'',1666278859,1666278859),(584,'online_users',972,0,0,'my-index','80','side-post',2,'',1666278859,1666278859),(585,'badges',972,0,0,'my-index','80','side-post',3,'',1666278859,1666278859),(586,'calendar_month',972,0,0,'my-index','80','side-post',4,'',1666278859,1666278859),(587,'calendar_upcoming',972,0,0,'my-index','80','side-post',5,'',1666278859,1666278859),(588,'lp',972,0,0,'my-index','80','content',0,'',1666278859,1666278859),(589,'recentlyaccessedcourses',972,0,0,'my-index','80','content',1,'',1666278859,1666278859),(590,'myoverview',972,0,0,'my-index','80','content',2,'',1666278859,1666278859),(591,'timeline',983,0,0,'my-index','81','side-post',0,'',1666286447,1666286447),(592,'private_files',983,0,0,'my-index','81','side-post',1,'',1666286447,1666286447),(593,'online_users',983,0,0,'my-index','81','side-post',2,'',1666286447,1666286447),(594,'badges',983,0,0,'my-index','81','side-post',3,'',1666286447,1666286447),(595,'calendar_month',983,0,0,'my-index','81','side-post',4,'',1666286447,1666286447),(596,'calendar_upcoming',983,0,0,'my-index','81','side-post',5,'',1666286447,1666286447),(597,'lp',983,0,0,'my-index','81','content',0,'',1666286447,1666286447),(598,'recentlyaccessedcourses',983,0,0,'my-index','81','content',1,'',1666286447,1666286447),(599,'myoverview',983,0,0,'my-index','81','content',2,'',1666286447,1666286447);
/*!40000 ALTER TABLE `mdl_block_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_positions`
--

DROP TABLE IF EXISTS `mdl_block_positions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_positions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `pagetype` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subpage` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visible` smallint(4) NOT NULL,
  `region` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocposi_bloconpagsub_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `mdl_blocposi_blo_ix` (`blockinstanceid`),
  KEY `mdl_blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the position of a sticky block_instance on a another ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_positions`
--

LOCK TABLES `mdl_block_positions` WRITE;
/*!40000 ALTER TABLE `mdl_block_positions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_positions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recent_activity`
--

DROP TABLE IF EXISTS `mdl_block_recent_activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_recent_activity` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Recent activity block';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recent_activity`
--

LOCK TABLES `mdl_block_recent_activity` WRITE;
/*!40000 ALTER TABLE `mdl_block_recent_activity` DISABLE KEYS */;
INSERT INTO `mdl_block_recent_activity` VALUES (1,18,17,1663745763,2,1,NULL),(2,12,18,1664260060,47,0,NULL),(3,12,19,1664260297,47,0,NULL),(4,12,19,1665135583,2,1,NULL),(5,44,32,1665827132,2,0,NULL),(6,73,55,1666076168,2,0,NULL),(7,2,56,1666076622,2,0,NULL),(8,2,63,1666156208,2,0,NULL),(9,2,63,1666156212,2,1,NULL),(10,2,63,1666156216,2,1,NULL);
/*!40000 ALTER TABLE `mdl_block_recent_activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_recentlyaccesseditems`
--

DROP TABLE IF EXISTS `mdl_block_recentlyaccesseditems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_recentlyaccesseditems` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timeaccess` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_blocrece_usecoucmi_uix` (`userid`,`courseid`,`cmid`),
  KEY `mdl_blocrece_use_ix` (`userid`),
  KEY `mdl_blocrece_cou_ix` (`courseid`),
  KEY `mdl_blocrece_cmi_ix` (`cmid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Most recently accessed items accessed by a user';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_recentlyaccesseditems`
--

LOCK TABLES `mdl_block_recentlyaccesseditems` WRITE;
/*!40000 ALTER TABLE `mdl_block_recentlyaccesseditems` DISABLE KEYS */;
INSERT INTO `mdl_block_recentlyaccesseditems` VALUES (1,18,17,2,1663745763),(2,12,11,2,1663755203),(3,12,18,47,1664260274),(4,12,19,47,1664260317),(5,2,56,151,1666078544);
/*!40000 ALTER TABLE `mdl_block_recentlyaccesseditems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_block_rss_client`
--

DROP TABLE IF EXISTS `mdl_block_rss_client`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_block_rss_client` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `preferredtitle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `shared` tinyint(2) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `skiptime` bigint(10) NOT NULL DEFAULT '0',
  `skipuntil` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Remote news feed information. Contains the news feed id, the';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_block_rss_client`
--

LOCK TABLES `mdl_block_rss_client` WRITE;
/*!40000 ALTER TABLE `mdl_block_rss_client` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_block_rss_client` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_association`
--

DROP TABLE IF EXISTS `mdl_blog_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_blog_association` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `blogid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_blogasso_con_ix` (`contextid`),
  KEY `mdl_blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Associations of blog entries with courses and module instanc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_association`
--

LOCK TABLES `mdl_blog_association` WRITE;
/*!40000 ALTER TABLE `mdl_blog_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_blog_external`
--

DROP TABLE IF EXISTS `mdl_blog_external`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_blog_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `filtertags` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  `timefetched` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='External blog links used for RSS copying of blog entries to ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_blog_external`
--

LOCK TABLES `mdl_blog_external` WRITE;
/*!40000 ALTER TABLE `mdl_blog_external` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_blog_external` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book`
--

DROP TABLE IF EXISTS `mdl_book`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_book` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `numbering` smallint(4) NOT NULL DEFAULT '0',
  `navstyle` smallint(4) NOT NULL DEFAULT '1',
  `customtitles` tinyint(2) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book`
--

LOCK TABLES `mdl_book` WRITE;
/*!40000 ALTER TABLE `mdl_book` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_book_chapters`
--

DROP TABLE IF EXISTS `mdl_book_chapters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_book_chapters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `bookid` bigint(10) NOT NULL DEFAULT '0',
  `pagenum` bigint(10) NOT NULL DEFAULT '0',
  `subchapter` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `importsrc` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_bookchap_boo_ix` (`bookid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Defines book_chapters';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_book_chapters`
--

LOCK TABLES `mdl_book_chapters` WRITE;
/*!40000 ALTER TABLE `mdl_book_chapters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_book_chapters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_filters`
--

DROP TABLE IF EXISTS `mdl_cache_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cache_filters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `md5key` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rawtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For keeping information about cached data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_filters`
--

LOCK TABLES `mdl_cache_filters` WRITE;
/*!40000 ALTER TABLE `mdl_cache_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cache_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cache_flags`
--

DROP TABLE IF EXISTS `mdl_cache_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cache_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_cachflag_fla_ix` (`flagtype`),
  KEY `mdl_cachflag_nam_ix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Cache of time-sensitive flags';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cache_flags`
--

LOCK TABLES `mdl_cache_flags` WRITE;
/*!40000 ALTER TABLE `mdl_cache_flags` DISABLE KEYS */;
INSERT INTO `mdl_cache_flags` VALUES (1,'userpreferenceschanged','2',1666278509,'1',1666307309),(2,'userpreferenceschanged','6',1663307687,'1',1663336487),(3,'userpreferenceschanged','18',1663308362,'1',1663337162),(4,'userpreferenceschanged','19',1663308386,'1',1663337186),(5,'userpreferenceschanged','7',1666176992,'1',1666205792),(6,'userpreferenceschanged','21',1663322732,'1',1663351532),(7,'accesslib/dirtycontexts','/1/79/113',1663332019,'1',1663360819),(8,'userpreferenceschanged','22',1663409118,'1',1663437918),(9,'userpreferenceschanged','23',1663409748,'1',1663438548),(10,'userpreferenceschanged','24',1663679269,'1',1663708069),(11,'userpreferenceschanged','25',1663411140,'1',1663439940),(12,'userpreferenceschanged','26',1663412496,'1',1663441296),(13,'accesslib/dirtycontexts','/1/79/116',1663413570,'1',1663442370),(14,'accesslib/dirtycontexts','/1/79/114',1663413577,'1',1663442377),(15,'accesslib/dirtyusers','24',1663679892,'1',1663708692),(16,'accesslib/dirtyusers','2',1666076797,'1',1666105597),(17,'accesslib/dirtyusers','25',1663490214,'1',1663519014),(18,'userpreferenceschanged','27',1663523466,'1',1663552266),(19,'userpreferenceschanged','28',1663519209,'1',1663548009),(20,'userpreferenceschanged','29',1663519328,'1',1663548128),(21,'userpreferenceschanged','30',1663519461,'1',1663548261),(22,'userpreferenceschanged','31',1663523792,'1',1663552592),(23,'accesslib/dirtyusers','26',1664776525,'1',1664805325),(24,'userpreferenceschanged','32',1663590211,'1',1663619011),(25,'accesslib/dirtyusers','32',1664776530,'1',1664805330),(26,'accesslib/dirtyusers','34',1663669160,'1',1663697960),(27,'userpreferenceschanged','34',1663669180,'1',1663697980),(28,'accesslib/dirtyusers','36',1663672106,'1',1663700906),(29,'userpreferenceschanged','36',1663674104,'1',1663702904),(30,'userpreferenceschanged','37',1663673116,'1',1663701916),(31,'accesslib/dirtyusers','38',1663673396,'1',1663702196),(32,'userpreferenceschanged','38',1663673418,'1',1663702218),(33,'userpreferenceschanged','39',1663687386,'1',1663716186),(34,'userpreferenceschanged','33',1663690619,'1',1663719419),(35,'userpreferenceschanged','40',1663690894,'1',1663719694),(36,'userpreferenceschanged','41',1663693089,'1',1663721889),(37,'accesslib/dirtyusers','42',1666075669,'1',1666104469),(38,'userpreferenceschanged','42',1666072611,'1',1666101411),(39,'accesslib/dirtyusers','44',1666067413,'1',1666096213),(40,'userpreferenceschanged','44',1663924991,'1',1663953791),(41,'accesslib/dirtyusers','45',1666067413,'1',1666096213),(42,'userpreferenceschanged','45',1663926495,'1',1663955295),(43,'accesslib/dirtyusers','46',1666067413,'1',1666096213),(44,'userpreferenceschanged','46',1664001078,'1',1664029878),(45,'accesslib/dirtyusers','27',1664001400,'1',1664030200),(46,'userpreferenceschanged','47',1664260511,'1',1664289311),(47,'accesslib/dirtyusers','47',1664256105,'1',1664284905),(48,'accesslib/dirtyusers','48',1666067413,'1',1666096213),(49,'accesslib/dirtyusers','49',1666067413,'1',1666096213),(50,'accesslib/dirtyusers','50',1666067413,'1',1666096213),(51,'accesslib/dirtyusers','51',1666067413,'1',1666096213),(52,'accesslib/dirtyusers','52',1665829552,'1',1665858352),(53,'accesslib/dirtyusers','53',1666067413,'1',1666096213),(54,'accesslib/dirtyusers','55',1665829552,'1',1665858352),(55,'accesslib/dirtyusers','56',1666067413,'1',1666096213),(56,'accesslib/dirtyusers','57',1666067413,'1',1666096213),(57,'accesslib/dirtyusers','58',1666067413,'1',1666096213),(58,'accesslib/dirtyusers','59',1666067413,'1',1666096213),(59,'accesslib/dirtyusers','60',1666067413,'1',1666096213),(60,'accesslib/dirtyusers','61',1666067413,'1',1666096213),(61,'accesslib/dirtyusers','62',1666067413,'1',1666096213),(62,'userpreferenceschanged','58',1664449701,'1',1664478501),(63,'accesslib/dirtyusers','63',1666067413,'1',1666096213),(64,'userpreferenceschanged','63',1664451884,'1',1664480684),(65,'accesslib/dirtyusers','64',1666067413,'1',1666096213),(66,'accesslib/dirtyusers','65',1666086004,'1',1666114804),(67,'userpreferenceschanged','65',1666093052,'1',1666121852),(68,'accesslib/dirtyusers','66',1665831457,'1',1665860257),(69,'userpreferenceschanged','66',1665393373,'1',1665422173),(70,'userpreferenceschanged','64',1664524322,'1',1664553122),(71,'accesslib/dirtyusers','7',1664624237,'1',1664653037),(72,'accesslib/dirtyusers','67',1665829552,'1',1665858352),(73,'userpreferenceschanged','67',1664630711,'1',1664659511),(74,'accesslib/dirtyusers','68',1666067413,'1',1666096213),(75,'userpreferenceschanged','68',1664632065,'1',1664660865),(76,'accesslib/dirtyusers','69',1666067413,'1',1666096213),(77,'userpreferenceschanged','69',1664644720,'1',1664673520),(78,'accesslib/dirtycontexts','/1/400/401',1664634291,'1',1664663091),(79,'accesslib/dirtyusers','70',1666086112,'1',1666114912),(80,'userpreferenceschanged','70',1664645120,'1',1664673920),(81,'accesslib/dirtyusers','71',1664734325,'1',1664763125),(82,'userpreferenceschanged','71',1666070652,'1',1666099452),(83,'accesslib/dirtyusers','72',1664734947,'1',1664763747),(84,'userpreferenceschanged','72',1664775377,'1',1664804177),(85,'accesslib/dirtyusers','73',1665660738,'1',1665689538),(86,'userpreferenceschanged','73',1664774700,'1',1664803500),(87,'userpreferenceschanged','74',1664775843,'1',1664804643),(88,'accesslib/dirtyusers','74',1664775899,'1',1664804699),(89,'accesslib/dirtyusers','75',1666067413,'1',1666096213),(90,'userpreferenceschanged','75',1664796476,'1',1664825276),(91,'accesslib/dirtyusers','76',1666067413,'1',1666096213),(92,'userpreferenceschanged','76',1665579110,'1',1665607910),(93,'accesslib/dirtyusers','77',1664818364,'1',1664847164),(94,'userpreferenceschanged','77',1664818394,'1',1664847194),(95,'accesslib/dirtyusers','78',1666067413,'1',1666096213),(96,'userpreferenceschanged','78',1664895663,'1',1664924463),(97,'accesslib/dirtyusers','79',1666067413,'1',1666096213),(98,'accesslib/dirtyusers','80',1666067413,'1',1666096213),(99,'userpreferenceschanged','80',1665060647,'1',1665089447),(100,'accesslib/dirtyusers','81',1666067413,'1',1666096213),(101,'userpreferenceschanged','81',1665246654,'1',1665275454),(102,'accesslib/dirtyusers','84',1665829552,'1',1665858352),(103,'accesslib/dirtyusers','85',1665829552,'1',1665858352),(104,'accesslib/dirtyusers','86',1665829552,'1',1665858352),(105,'userpreferenceschanged','86',1665232829,'1',1665261629),(106,'accesslib/dirtyusers','87',1665829552,'1',1665858352),(107,'accesslib/dirtyusers','88',1665829552,'1',1665858352),(108,'accesslib/dirtyusers','89',1665988966,'1',1666017766),(109,'userpreferenceschanged','88',1665234112,'1',1665262912),(110,'userpreferenceschanged','84',1665388199,'1',1665416999),(111,'accesslib/dirtyusers','91',1666067413,'1',1666096213),(112,'accesslib/dirtyusers','92',1665391643,'1',1665420443),(113,'accesslib/dirtyusers','93',1665829552,'1',1665858352),(114,'accesslib/dirtyusers','94',1665829552,'1',1665858352),(115,'accesslib/dirtyusers','95',1665392044,'1',1665420844),(116,'accesslib/dirtycontexts','/1/293/548',1665392057,'1',1665420857),(117,'accesslib/dirtycontexts','/1/495/496/497',1665392082,'1',1665420882),(118,'accesslib/dirtycontexts','/1/373/375',1665392148,'1',1665420948),(119,'accesslib/dirtycontexts','/1/373/377',1665392149,'1',1665420949),(120,'accesslib/dirtycontexts','/1/79/152',1665392195,'1',1665420995),(121,'accesslib/dirtyusers','96',1665393952,'1',1665422752),(122,'accesslib/dirtyusers','97',1665829552,'1',1665858352),(123,'userpreferenceschanged','97',1666093071,'1',1666121871),(124,'accesslib/dirtyusers','98',1665396955,'1',1665425755),(125,'userpreferenceschanged','98',1665395207,'1',1665424007),(126,'userpreferenceschanged','99',1665395726,'1',1665424526),(127,'accesslib/dirtyusers','99',1665831457,'1',1665860257),(128,'accesslib/dirtyusers','100',1665820535,'1',1665849335),(129,'accesslib/dirtyusers','102',1665820823,'1',1665849623),(130,'accesslib/dirtyusers','113',1665824832,'1',1665853632),(131,'accesslib/dirtyusers','114',1665825355,'1',1665854155),(132,'accesslib/dirtyusers','115',1665825398,'1',1665854198),(133,'accesslib/dirtyusers','116',1665825435,'1',1665854235),(134,'accesslib/dirtyusers','117',1665825649,'1',1665854449),(135,'accesslib/dirtyusers','118',1665829552,'1',1665858352),(136,'accesslib/dirtyusers','119',1665825949,'1',1665854749),(137,'accesslib/dirtyusers','120',1665826889,'1',1665855689),(138,'userpreferenceschanged','121',1665827227,'1',1665856027),(139,'accesslib/dirtyusers','122',1666067413,'1',1666096213),(140,'accesslib/dirtyusers','123',1666067413,'1',1666096213),(141,'accesslib/dirtyusers','124',1666067413,'1',1666096213),(142,'accesslib/dirtyusers','125',1666067413,'1',1666096213),(143,'accesslib/dirtyusers','126',1666067413,'1',1666096213),(144,'accesslib/dirtycontexts','/1/91/98/613',1665829551,'1',1665858351),(145,'accesslib/dirtycontexts','/1/91/98/589',1665829551,'1',1665858351),(146,'accesslib/dirtycontexts','/1/91/98/124',1665829552,'1',1665858352),(147,'accesslib/dirtyusers','127',1666067413,'1',1666096213),(148,'accesslib/dirtycontexts','/1/566/568/569/572',1665831457,'1',1665860257),(149,'accesslib/dirtycontexts','/1/566/568/569/570',1665831457,'1',1665860257),(150,'accesslib/dirtyusers','128',1666067413,'1',1666096213),(151,'accesslib/dirtyusers','129',1666067413,'1',1666096213),(152,'accesslib/dirtyusers','130',1666067413,'1',1666096213),(153,'accesslib/dirtyusers','131',1666067413,'1',1666096213),(154,'accesslib/dirtyusers','132',1666067413,'1',1666096213),(155,'userpreferenceschanged','132',1665835499,'1',1665864299),(156,'accesslib/dirtyusers','133',1666067413,'1',1666096213),(157,'userpreferenceschanged','133',1665986661,'1',1666015461),(158,'accesslib/dirtyusers','134',1666067413,'1',1666096213),(159,'userpreferenceschanged','134',1666008164,'1',1666036964),(160,'accesslib/dirtyusers','135',1666266241,'1',1666295041),(161,'accesslib/dirtyusers','136',1666067413,'1',1666096213),(162,'accesslib/dirtyusers','137',1666067413,'1',1666096213),(163,'userpreferenceschanged','137',1666155606,'1',1666184406),(164,'accesslib/dirtyusers','139',1666067413,'1',1666096213),(165,'userpreferenceschanged','139',1666019585,'1',1666048385),(166,'accesslib/dirtyusers','140',1666020786,'1',1666049586),(167,'accesslib/dirtyusers','141',1666020802,'1',1666049602),(168,'accesslib/dirtyusers','142',1666020927,'1',1666049727),(169,'accesslib/dirtyusers','143',1666021098,'1',1666049898),(170,'accesslib/dirtyusers','144',1666067413,'1',1666096213),(171,'accesslib/dirtyusers','145',1666083745,'1',1666112545),(172,'userpreferenceschanged','145',1666067234,'1',1666096034),(173,'accesslib/dirtycontexts','/1/79/80/85/132',1666067413,'1',1666096213),(174,'accesslib/dirtyusers','146',1666083841,'1',1666112641),(175,'userpreferenceschanged','146',1666070282,'1',1666099082),(176,'accesslib/dirtyusers','147',1666070176,'1',1666098976),(177,'userpreferenceschanged','147',1666070197,'1',1666098997),(178,'accesslib/dirtyusers','148',1666070351,'1',1666099151),(179,'userpreferenceschanged','148',1666070416,'1',1666099216),(180,'userpreferenceschanged','149',1666076192,'1',1666104992),(181,'accesslib/dirtyusers','149',1666075684,'1',1666104484),(182,'accesslib/dirtyusers','150',1666086487,'1',1666115287),(183,'userpreferenceschanged','150',1666084596,'1',1666113396),(184,'userpreferenceschanged','151',1666079143,'1',1666107943),(185,'accesslib/dirtyusers','151',1666078477,'1',1666107277),(186,'accesslib/dirtyusers','152',1666078696,'1',1666107496),(187,'userpreferenceschanged','152',1666086667,'1',1666115467),(188,'accesslib/dirtyusers','153',1666091146,'1',1666119946),(189,'userpreferenceschanged','153',1666091660,'1',1666120460),(190,'userpreferenceschanged','154',1666087775,'1',1666116575),(191,'accesslib/dirtyusers','155',1666087877,'1',1666116677),(192,'userpreferenceschanged','155',1666244043,'1',1666272843),(193,'accesslib/dirtyusers','154',1666089157,'1',1666117957),(194,'userpreferenceschanged','79',1666184184,'1',1666212984),(195,'accesslib/dirtyusers','157',1666246113,'1',1666274913),(196,'userpreferenceschanged','157',1666242671,'1',1666271471),(197,'accesslib/dirtyusers','158',1666247891,'1',1666276691),(198,'userpreferenceschanged','158',1666269789,'1',1666298589),(199,'userpreferenceschanged','159',1666248198,'1',1666276998),(200,'accesslib/dirtyusers','159',1666248240,'1',1666277040),(201,'accesslib/dirtyusers','171',1666272887,'1',1666301687),(202,'accesslib/dirtyusers','172',1666273092,'1',1666301892),(203,'userpreferenceschanged','172',1666263775,'1',1666292575),(204,'userpreferenceschanged','135',1666266279,'1',1666295079),(205,'accesslib/dirtyusers','173',1666269854,'1',1666298654),(206,'userpreferenceschanged','173',1666272885,'1',1666301685),(207,'accesslib/dirtyusers','174',1666280636,'1',1666309436),(208,'userpreferenceschanged','174',1666278858,'1',1666307658),(209,'accesslib/dirtyusers','176',1666286406,'1',1666315206),(210,'userpreferenceschanged','176',1666286446,'1',1666315246);
/*!40000 ALTER TABLE `mdl_cache_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_capabilities`
--

DROP TABLE IF EXISTS `mdl_capabilities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `captype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `riskbitmask` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_capa_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=825 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='this defines all capabilities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_capabilities`
--

LOCK TABLES `mdl_capabilities` WRITE;
/*!40000 ALTER TABLE `mdl_capabilities` DISABLE KEYS */;
INSERT INTO `mdl_capabilities` VALUES (1,'moodle/site:config','write',10,'moodle',62),(2,'moodle/site:configview','read',10,'moodle',0),(3,'moodle/site:readallmessages','read',10,'moodle',8),(4,'moodle/site:manageallmessaging','write',10,'moodle',8),(5,'moodle/site:deleteanymessage','write',10,'moodle',32),(6,'moodle/site:sendmessage','write',10,'moodle',16),(7,'moodle/site:senderrormessage','write',10,'moodle',16),(8,'moodle/site:deleteownmessage','write',10,'moodle',0),(9,'moodle/site:approvecourse','write',40,'moodle',4),(10,'moodle/backup:backupcourse','write',50,'moodle',28),(11,'moodle/backup:backupsection','write',50,'moodle',28),(12,'moodle/backup:backupactivity','write',70,'moodle',28),(13,'moodle/backup:backuptargetimport','read',50,'moodle',28),(14,'moodle/backup:downloadfile','write',50,'moodle',28),(15,'moodle/backup:configure','write',50,'moodle',28),(16,'moodle/backup:userinfo','read',50,'moodle',8),(17,'moodle/backup:anonymise','read',50,'moodle',8),(18,'moodle/restore:restorecourse','write',50,'moodle',28),(19,'moodle/restore:restoresection','write',50,'moodle',28),(20,'moodle/restore:restoreactivity','write',50,'moodle',28),(21,'moodle/restore:viewautomatedfilearea','write',50,'moodle',28),(22,'moodle/restore:restoretargetimport','write',50,'moodle',28),(23,'moodle/restore:uploadfile','write',50,'moodle',28),(24,'moodle/restore:configure','write',50,'moodle',28),(25,'moodle/restore:rolldates','write',50,'moodle',0),(26,'moodle/restore:userinfo','write',50,'moodle',30),(27,'moodle/restore:createuser','write',10,'moodle',24),(28,'moodle/site:manageblocks','write',80,'moodle',20),(29,'moodle/site:accessallgroups','read',70,'moodle',0),(30,'moodle/site:viewanonymousevents','read',70,'moodle',8),(31,'moodle/site:viewfullnames','read',70,'moodle',0),(32,'moodle/site:viewuseridentity','read',70,'moodle',0),(33,'moodle/site:viewreports','read',50,'moodle',8),(34,'moodle/site:trustcontent','write',70,'moodle',4),(35,'moodle/site:uploadusers','write',10,'moodle',24),(36,'moodle/filter:manage','write',50,'moodle',0),(37,'moodle/user:create','write',10,'moodle',24),(38,'moodle/user:delete','write',10,'moodle',40),(39,'moodle/user:update','write',10,'moodle',24),(40,'moodle/user:viewdetails','read',50,'moodle',0),(41,'moodle/user:viewalldetails','read',30,'moodle',8),(42,'moodle/user:viewlastip','read',30,'moodle',8),(43,'moodle/user:viewhiddendetails','read',50,'moodle',8),(44,'moodle/user:loginas','write',50,'moodle',30),(45,'moodle/user:managesyspages','write',10,'moodle',0),(46,'moodle/user:manageblocks','write',30,'moodle',0),(47,'moodle/user:manageownblocks','write',10,'moodle',0),(48,'moodle/user:manageownfiles','write',10,'moodle',0),(49,'moodle/user:ignoreuserquota','write',10,'moodle',0),(50,'moodle/my:configsyspages','write',10,'moodle',0),(51,'moodle/role:assign','write',50,'moodle',28),(52,'moodle/role:review','read',50,'moodle',8),(53,'moodle/role:override','write',50,'moodle',28),(54,'moodle/role:safeoverride','write',50,'moodle',16),(55,'moodle/role:manage','write',10,'moodle',28),(56,'moodle/role:switchroles','read',50,'moodle',12),(57,'moodle/category:manage','write',40,'moodle',4),(58,'moodle/category:viewcourselist','read',40,'moodle',0),(59,'moodle/category:viewhiddencategories','read',40,'moodle',0),(60,'moodle/cohort:manage','write',40,'moodle',0),(61,'moodle/cohort:assign','write',40,'moodle',0),(62,'moodle/cohort:view','read',50,'moodle',0),(63,'moodle/course:create','write',40,'moodle',4),(64,'moodle/course:creategroupconversations','write',50,'moodle',4),(65,'moodle/course:request','write',40,'moodle',0),(66,'moodle/course:delete','write',50,'moodle',32),(67,'moodle/course:update','write',50,'moodle',4),(68,'moodle/course:view','read',50,'moodle',0),(69,'moodle/course:enrolreview','read',50,'moodle',8),(70,'moodle/course:enrolconfig','write',50,'moodle',8),(71,'moodle/course:reviewotherusers','read',50,'moodle',0),(72,'moodle/course:bulkmessaging','write',50,'moodle',16),(73,'moodle/course:viewhiddenuserfields','read',50,'moodle',8),(74,'moodle/course:viewhiddencourses','read',50,'moodle',0),(75,'moodle/course:visibility','write',50,'moodle',0),(76,'moodle/course:managefiles','write',50,'moodle',4),(77,'moodle/course:ignoreavailabilityrestrictions','read',70,'moodle',0),(78,'moodle/course:ignorefilesizelimits','write',50,'moodle',0),(79,'moodle/course:manageactivities','write',70,'moodle',4),(80,'moodle/course:activityvisibility','write',70,'moodle',0),(81,'moodle/course:viewhiddenactivities','read',70,'moodle',0),(82,'moodle/course:viewparticipants','read',50,'moodle',0),(83,'moodle/course:changefullname','write',50,'moodle',4),(84,'moodle/course:changeshortname','write',50,'moodle',4),(85,'moodle/course:changelockedcustomfields','write',50,'moodle',16),(86,'moodle/course:configurecustomfields','write',10,'moodle',16),(87,'moodle/course:renameroles','write',50,'moodle',0),(88,'moodle/course:changeidnumber','write',50,'moodle',4),(89,'moodle/course:changecategory','write',50,'moodle',4),(90,'moodle/course:changesummary','write',50,'moodle',4),(91,'moodle/course:setforcedlanguage','write',50,'moodle',0),(92,'moodle/site:viewparticipants','read',10,'moodle',0),(93,'moodle/course:isincompletionreports','read',50,'moodle',0),(94,'moodle/course:viewscales','read',50,'moodle',0),(95,'moodle/course:managescales','write',50,'moodle',0),(96,'moodle/course:managegroups','write',50,'moodle',4),(97,'moodle/course:reset','write',50,'moodle',32),(98,'moodle/course:viewsuspendedusers','read',50,'moodle',0),(99,'moodle/course:tag','write',50,'moodle',16),(100,'moodle/blog:view','read',10,'moodle',0),(101,'moodle/blog:search','read',10,'moodle',0),(102,'moodle/blog:viewdrafts','read',10,'moodle',8),(103,'moodle/blog:create','write',10,'moodle',16),(104,'moodle/blog:manageentries','write',10,'moodle',16),(105,'moodle/blog:manageexternal','write',10,'moodle',16),(106,'moodle/calendar:manageownentries','write',50,'moodle',16),(107,'moodle/calendar:managegroupentries','write',50,'moodle',16),(108,'moodle/calendar:manageentries','write',50,'moodle',16),(109,'moodle/user:editprofile','write',30,'moodle',24),(110,'moodle/user:editownprofile','write',10,'moodle',16),(111,'moodle/user:changeownpassword','write',10,'moodle',0),(112,'moodle/user:readuserposts','read',30,'moodle',0),(113,'moodle/user:readuserblogs','read',30,'moodle',0),(114,'moodle/user:viewuseractivitiesreport','read',30,'moodle',8),(115,'moodle/user:editmessageprofile','write',30,'moodle',16),(116,'moodle/user:editownmessageprofile','write',10,'moodle',0),(117,'moodle/question:managecategory','write',50,'moodle',20),(118,'moodle/question:add','write',50,'moodle',20),(119,'moodle/question:editmine','write',50,'moodle',20),(120,'moodle/question:editall','write',50,'moodle',20),(121,'moodle/question:viewmine','read',50,'moodle',0),(122,'moodle/question:viewall','read',50,'moodle',0),(123,'moodle/question:usemine','read',50,'moodle',0),(124,'moodle/question:useall','read',50,'moodle',0),(125,'moodle/question:movemine','write',50,'moodle',0),(126,'moodle/question:moveall','write',50,'moodle',0),(127,'moodle/question:config','write',10,'moodle',2),(128,'moodle/question:flag','write',50,'moodle',0),(129,'moodle/question:tagmine','write',50,'moodle',0),(130,'moodle/question:tagall','write',50,'moodle',0),(131,'moodle/site:doclinks','read',10,'moodle',0),(132,'moodle/course:sectionvisibility','write',50,'moodle',0),(133,'moodle/course:useremail','write',50,'moodle',0),(134,'moodle/course:viewhiddensections','read',50,'moodle',0),(135,'moodle/course:setcurrentsection','write',50,'moodle',0),(136,'moodle/course:movesections','write',50,'moodle',0),(137,'moodle/site:mnetlogintoremote','read',10,'moodle',0),(138,'moodle/grade:viewall','read',50,'moodle',8),(139,'moodle/grade:view','read',50,'moodle',0),(140,'moodle/grade:viewhidden','read',50,'moodle',8),(141,'moodle/grade:import','write',50,'moodle',12),(142,'moodle/grade:export','read',50,'moodle',8),(143,'moodle/grade:manage','write',50,'moodle',12),(144,'moodle/grade:edit','write',50,'moodle',12),(145,'moodle/grade:managegradingforms','write',50,'moodle',12),(146,'moodle/grade:sharegradingforms','write',10,'moodle',4),(147,'moodle/grade:managesharedforms','write',10,'moodle',4),(148,'moodle/grade:manageoutcomes','write',50,'moodle',0),(149,'moodle/grade:manageletters','write',50,'moodle',0),(150,'moodle/grade:hide','write',50,'moodle',0),(151,'moodle/grade:lock','write',50,'moodle',0),(152,'moodle/grade:unlock','write',50,'moodle',0),(153,'moodle/my:manageblocks','write',10,'moodle',0),(154,'moodle/notes:view','read',50,'moodle',0),(155,'moodle/notes:manage','write',50,'moodle',16),(156,'moodle/tag:manage','write',10,'moodle',16),(157,'moodle/tag:edit','write',10,'moodle',16),(158,'moodle/tag:flag','write',10,'moodle',16),(159,'moodle/tag:editblocks','write',10,'moodle',0),(160,'moodle/block:view','read',80,'moodle',0),(161,'moodle/block:edit','write',80,'moodle',20),(162,'moodle/portfolio:export','read',10,'moodle',0),(163,'moodle/comment:view','read',50,'moodle',0),(164,'moodle/comment:post','write',50,'moodle',24),(165,'moodle/comment:delete','write',50,'moodle',32),(166,'moodle/webservice:createtoken','write',10,'moodle',62),(167,'moodle/webservice:managealltokens','write',10,'moodle',42),(168,'moodle/webservice:createmobiletoken','write',10,'moodle',24),(169,'moodle/rating:view','read',50,'moodle',0),(170,'moodle/rating:viewany','read',50,'moodle',8),(171,'moodle/rating:viewall','read',50,'moodle',8),(172,'moodle/rating:rate','write',50,'moodle',0),(173,'moodle/course:markcomplete','write',50,'moodle',0),(174,'moodle/course:overridecompletion','write',50,'moodle',0),(175,'moodle/badges:manageglobalsettings','write',10,'moodle',34),(176,'moodle/badges:viewbadges','read',50,'moodle',0),(177,'moodle/badges:manageownbadges','write',30,'moodle',0),(178,'moodle/badges:viewotherbadges','read',30,'moodle',0),(179,'moodle/badges:earnbadge','write',50,'moodle',0),(180,'moodle/badges:createbadge','write',50,'moodle',16),(181,'moodle/badges:deletebadge','write',50,'moodle',32),(182,'moodle/badges:configuredetails','write',50,'moodle',16),(183,'moodle/badges:configurecriteria','write',50,'moodle',4),(184,'moodle/badges:configuremessages','write',50,'moodle',16),(185,'moodle/badges:awardbadge','write',50,'moodle',16),(186,'moodle/badges:revokebadge','write',50,'moodle',16),(187,'moodle/badges:viewawarded','read',50,'moodle',8),(188,'moodle/site:forcelanguage','read',10,'moodle',0),(189,'moodle/search:query','read',10,'moodle',0),(190,'moodle/competency:competencymanage','write',40,'moodle',0),(191,'moodle/competency:competencyview','read',40,'moodle',0),(192,'moodle/competency:competencygrade','write',50,'moodle',0),(193,'moodle/competency:coursecompetencymanage','write',50,'moodle',0),(194,'moodle/competency:coursecompetencyconfigure','write',70,'moodle',0),(195,'moodle/competency:coursecompetencygradable','read',50,'moodle',0),(196,'moodle/competency:coursecompetencyview','read',50,'moodle',0),(197,'moodle/competency:evidencedelete','write',30,'moodle',0),(198,'moodle/competency:planmanage','write',30,'moodle',0),(199,'moodle/competency:planmanagedraft','write',30,'moodle',0),(200,'moodle/competency:planmanageown','write',30,'moodle',0),(201,'moodle/competency:planmanageowndraft','write',30,'moodle',0),(202,'moodle/competency:planview','read',30,'moodle',0),(203,'moodle/competency:planviewdraft','read',30,'moodle',0),(204,'moodle/competency:planviewown','read',30,'moodle',0),(205,'moodle/competency:planviewowndraft','read',30,'moodle',0),(206,'moodle/competency:planrequestreview','write',30,'moodle',0),(207,'moodle/competency:planrequestreviewown','write',30,'moodle',0),(208,'moodle/competency:planreview','write',30,'moodle',0),(209,'moodle/competency:plancomment','write',30,'moodle',0),(210,'moodle/competency:plancommentown','write',30,'moodle',0),(211,'moodle/competency:usercompetencyview','read',30,'moodle',0),(212,'moodle/competency:usercompetencyrequestreview','write',30,'moodle',0),(213,'moodle/competency:usercompetencyrequestreviewown','write',30,'moodle',0),(214,'moodle/competency:usercompetencyreview','write',30,'moodle',0),(215,'moodle/competency:usercompetencycomment','write',30,'moodle',0),(216,'moodle/competency:usercompetencycommentown','write',30,'moodle',0),(217,'moodle/competency:templatemanage','write',40,'moodle',0),(218,'moodle/analytics:listinsights','read',50,'moodle',8),(219,'moodle/analytics:managemodels','write',10,'moodle',2),(220,'moodle/competency:templateview','read',40,'moodle',0),(221,'moodle/competency:userevidencemanage','write',30,'moodle',0),(222,'moodle/competency:userevidencemanageown','write',30,'moodle',0),(223,'moodle/competency:userevidenceview','read',30,'moodle',0),(224,'moodle/site:maintenanceaccess','write',10,'moodle',0),(225,'moodle/site:messageanyuser','write',10,'moodle',16),(226,'moodle/site:managecontextlocks','write',70,'moodle',0),(227,'moodle/course:togglecompletion','write',70,'moodle',0),(228,'moodle/analytics:listowninsights','read',10,'moodle',0),(229,'moodle/h5p:setdisplayoptions','write',70,'moodle',0),(230,'moodle/h5p:deploy','write',70,'moodle',4),(231,'moodle/h5p:updatelibraries','write',70,'moodle',4),(232,'moodle/course:recommendactivity','write',10,'moodle',0),(233,'moodle/contentbank:access','read',50,'moodle',0),(234,'moodle/contentbank:upload','write',50,'moodle',16),(235,'moodle/contentbank:deleteanycontent','write',50,'moodle',32),(236,'moodle/contentbank:deleteowncontent','write',50,'moodle',0),(237,'moodle/contentbank:manageanycontent','write',50,'moodle',32),(238,'moodle/contentbank:manageowncontent','write',50,'moodle',0),(239,'moodle/contentbank:useeditor','write',50,'moodle',16),(240,'moodle/contentbank:downloadcontent','read',50,'moodle',0),(241,'moodle/course:downloadcoursecontent','read',50,'moodle',0),(242,'moodle/course:configuredownloadcontent','write',50,'moodle',0),(243,'moodle/payment:manageaccounts','write',50,'moodle',42),(244,'moodle/payment:viewpayments','read',50,'moodle',8),(245,'moodle/contentbank:viewunlistedcontent','read',50,'moodle',0),(246,'mod/assign:view','read',70,'mod_assign',0),(247,'mod/assign:submit','write',70,'mod_assign',0),(248,'mod/assign:grade','write',70,'mod_assign',4),(249,'mod/assign:exportownsubmission','read',70,'mod_assign',0),(250,'mod/assign:addinstance','write',50,'mod_assign',4),(251,'mod/assign:editothersubmission','write',70,'mod_assign',41),(252,'mod/assign:grantextension','write',70,'mod_assign',0),(253,'mod/assign:revealidentities','write',70,'mod_assign',0),(254,'mod/assign:reviewgrades','write',70,'mod_assign',0),(255,'mod/assign:releasegrades','write',70,'mod_assign',0),(256,'mod/assign:managegrades','write',70,'mod_assign',0),(257,'mod/assign:manageallocations','write',70,'mod_assign',0),(258,'mod/assign:viewgrades','read',70,'mod_assign',0),(259,'mod/assign:viewblinddetails','write',70,'mod_assign',8),(260,'mod/assign:receivegradernotifications','read',70,'mod_assign',0),(261,'mod/assign:manageoverrides','write',70,'mod_assign',0),(262,'mod/assign:showhiddengrader','read',70,'mod_assign',0),(263,'mod/assign:viewownsubmissionsummary','read',70,'mod_assign',0),(264,'mod/assignment:view','read',70,'mod_assignment',0),(265,'mod/assignment:addinstance','write',50,'mod_assignment',4),(266,'mod/assignment:submit','write',70,'mod_assignment',0),(267,'mod/assignment:grade','write',70,'mod_assignment',4),(268,'mod/assignment:exportownsubmission','read',70,'mod_assignment',0),(269,'mod/book:addinstance','write',50,'mod_book',4),(270,'mod/book:read','read',70,'mod_book',0),(271,'mod/book:viewhiddenchapters','read',70,'mod_book',0),(272,'mod/book:edit','write',70,'mod_book',4),(273,'mod/chat:addinstance','write',50,'mod_chat',4),(274,'mod/chat:chat','write',70,'mod_chat',16),(275,'mod/chat:readlog','read',70,'mod_chat',0),(276,'mod/chat:deletelog','write',70,'mod_chat',0),(277,'mod/chat:exportparticipatedsession','read',70,'mod_chat',8),(278,'mod/chat:exportsession','read',70,'mod_chat',8),(279,'mod/chat:view','read',70,'mod_chat',0),(280,'mod/choice:addinstance','write',50,'mod_choice',4),(281,'mod/choice:choose','write',70,'mod_choice',0),(282,'mod/choice:readresponses','read',70,'mod_choice',0),(283,'mod/choice:deleteresponses','write',70,'mod_choice',0),(284,'mod/choice:downloadresponses','read',70,'mod_choice',0),(285,'mod/choice:view','read',70,'mod_choice',0),(286,'mod/data:addinstance','write',50,'mod_data',4),(287,'mod/data:viewentry','read',70,'mod_data',0),(288,'mod/data:writeentry','write',70,'mod_data',16),(289,'mod/data:comment','write',70,'mod_data',16),(290,'mod/data:rate','write',70,'mod_data',0),(291,'mod/data:viewrating','read',70,'mod_data',0),(292,'mod/data:viewanyrating','read',70,'mod_data',8),(293,'mod/data:viewallratings','read',70,'mod_data',8),(294,'mod/data:approve','write',70,'mod_data',16),(295,'mod/data:manageentries','write',70,'mod_data',16),(296,'mod/data:managecomments','write',70,'mod_data',16),(297,'mod/data:managetemplates','write',70,'mod_data',20),(298,'mod/data:viewalluserpresets','read',70,'mod_data',0),(299,'mod/data:manageuserpresets','write',70,'mod_data',20),(300,'mod/data:exportentry','read',70,'mod_data',8),(301,'mod/data:exportownentry','read',70,'mod_data',0),(302,'mod/data:exportallentries','read',70,'mod_data',8),(303,'mod/data:exportuserinfo','read',70,'mod_data',8),(304,'mod/data:view','read',70,'mod_data',0),(305,'mod/feedback:addinstance','write',50,'mod_feedback',4),(306,'mod/feedback:view','read',70,'mod_feedback',0),(307,'mod/feedback:complete','write',70,'mod_feedback',16),(308,'mod/feedback:viewanalysepage','read',70,'mod_feedback',8),(309,'mod/feedback:deletesubmissions','write',70,'mod_feedback',0),(310,'mod/feedback:mapcourse','write',70,'mod_feedback',0),(311,'mod/feedback:edititems','write',70,'mod_feedback',20),(312,'mod/feedback:createprivatetemplate','write',70,'mod_feedback',16),(313,'mod/feedback:createpublictemplate','write',70,'mod_feedback',16),(314,'mod/feedback:deletetemplate','write',70,'mod_feedback',0),(315,'mod/feedback:viewreports','read',70,'mod_feedback',8),(316,'mod/feedback:receivemail','read',70,'mod_feedback',8),(317,'mod/folder:addinstance','write',50,'mod_folder',4),(318,'mod/folder:view','read',70,'mod_folder',0),(319,'mod/folder:managefiles','write',70,'mod_folder',20),(320,'mod/forum:addinstance','write',50,'mod_forum',4),(321,'mod/forum:viewdiscussion','read',70,'mod_forum',0),(322,'mod/forum:viewhiddentimedposts','read',70,'mod_forum',0),(323,'mod/forum:startdiscussion','write',70,'mod_forum',16),(324,'mod/forum:replypost','write',70,'mod_forum',16),(325,'mod/forum:addnews','write',70,'mod_forum',16),(326,'mod/forum:replynews','write',70,'mod_forum',16),(327,'mod/forum:viewrating','read',70,'mod_forum',0),(328,'mod/forum:viewanyrating','read',70,'mod_forum',8),(329,'mod/forum:viewallratings','read',70,'mod_forum',8),(330,'mod/forum:rate','write',70,'mod_forum',0),(331,'mod/forum:postprivatereply','write',70,'mod_forum',0),(332,'mod/forum:readprivatereplies','read',70,'mod_forum',0),(333,'mod/forum:createattachment','write',70,'mod_forum',16),(334,'mod/forum:deleteownpost','write',70,'mod_forum',0),(335,'mod/forum:deleteanypost','write',70,'mod_forum',0),(336,'mod/forum:splitdiscussions','write',70,'mod_forum',0),(337,'mod/forum:movediscussions','write',70,'mod_forum',0),(338,'mod/forum:pindiscussions','write',70,'mod_forum',0),(339,'mod/forum:editanypost','write',70,'mod_forum',16),(340,'mod/forum:viewqandawithoutposting','read',70,'mod_forum',0),(341,'mod/forum:viewsubscribers','read',70,'mod_forum',0),(342,'mod/forum:managesubscriptions','write',70,'mod_forum',16),(343,'mod/forum:postwithoutthrottling','write',70,'mod_forum',16),(344,'mod/forum:exportdiscussion','read',70,'mod_forum',8),(345,'mod/forum:exportforum','read',70,'mod_forum',8),(346,'mod/forum:exportpost','read',70,'mod_forum',8),(347,'mod/forum:exportownpost','read',70,'mod_forum',8),(348,'mod/forum:addquestion','write',70,'mod_forum',16),(349,'mod/forum:allowforcesubscribe','read',70,'mod_forum',0),(350,'mod/forum:canposttomygroups','write',70,'mod_forum',0),(351,'mod/forum:canoverridediscussionlock','write',70,'mod_forum',0),(352,'mod/forum:canoverridecutoff','write',70,'mod_forum',0),(353,'mod/forum:cantogglefavourite','write',70,'mod_forum',0),(354,'mod/forum:grade','write',70,'mod_forum',0),(355,'mod/glossary:addinstance','write',50,'mod_glossary',4),(356,'mod/glossary:view','read',70,'mod_glossary',0),(357,'mod/glossary:write','write',70,'mod_glossary',16),(358,'mod/glossary:manageentries','write',70,'mod_glossary',16),(359,'mod/glossary:managecategories','write',70,'mod_glossary',16),(360,'mod/glossary:comment','write',70,'mod_glossary',16),(361,'mod/glossary:managecomments','write',70,'mod_glossary',16),(362,'mod/glossary:import','write',70,'mod_glossary',16),(363,'mod/glossary:export','read',70,'mod_glossary',0),(364,'mod/glossary:approve','write',70,'mod_glossary',16),(365,'mod/glossary:rate','write',70,'mod_glossary',0),(366,'mod/glossary:viewrating','read',70,'mod_glossary',0),(367,'mod/glossary:viewanyrating','read',70,'mod_glossary',8),(368,'mod/glossary:viewallratings','read',70,'mod_glossary',8),(369,'mod/glossary:exportentry','read',70,'mod_glossary',8),(370,'mod/glossary:exportownentry','read',70,'mod_glossary',0),(371,'mod/h5pactivity:view','read',70,'mod_h5pactivity',0),(372,'mod/h5pactivity:addinstance','write',50,'mod_h5pactivity',0),(373,'mod/h5pactivity:submit','write',70,'mod_h5pactivity',0),(374,'mod/h5pactivity:reviewattempts','read',70,'mod_h5pactivity',0),(375,'mod/imscp:view','read',70,'mod_imscp',0),(376,'mod/imscp:addinstance','write',50,'mod_imscp',4),(377,'mod/label:addinstance','write',50,'mod_label',4),(378,'mod/label:view','read',70,'mod_label',0),(379,'mod/lesson:addinstance','write',50,'mod_lesson',4),(380,'mod/lesson:edit','write',70,'mod_lesson',4),(381,'mod/lesson:grade','write',70,'mod_lesson',20),(382,'mod/lesson:viewreports','read',70,'mod_lesson',8),(383,'mod/lesson:manage','write',70,'mod_lesson',0),(384,'mod/lesson:manageoverrides','write',70,'mod_lesson',0),(385,'mod/lesson:view','read',70,'mod_lesson',0),(386,'mod/lti:view','read',70,'mod_lti',0),(387,'mod/lti:addinstance','write',50,'mod_lti',4),(388,'mod/lti:manage','write',70,'mod_lti',8),(389,'mod/lti:admin','write',70,'mod_lti',8),(390,'mod/lti:addcoursetool','write',50,'mod_lti',0),(391,'mod/lti:addpreconfiguredinstance','write',50,'mod_lti',0),(392,'mod/lti:addmanualinstance','write',50,'mod_lti',0),(393,'mod/lti:requesttooladd','write',50,'mod_lti',0),(394,'mod/page:view','read',70,'mod_page',0),(395,'mod/page:addinstance','write',50,'mod_page',4),(396,'mod/quiz:view','read',70,'mod_quiz',0),(397,'mod/quiz:addinstance','write',50,'mod_quiz',4),(398,'mod/quiz:attempt','write',70,'mod_quiz',16),(399,'mod/quiz:reviewmyattempts','read',70,'mod_quiz',0),(400,'mod/quiz:manage','write',70,'mod_quiz',16),(401,'mod/quiz:manageoverrides','write',70,'mod_quiz',0),(402,'mod/quiz:viewoverrides','read',70,'mod_quiz',0),(403,'mod/quiz:preview','write',70,'mod_quiz',0),(404,'mod/quiz:grade','write',70,'mod_quiz',20),(405,'mod/quiz:regrade','write',70,'mod_quiz',16),(406,'mod/quiz:viewreports','read',70,'mod_quiz',8),(407,'mod/quiz:deleteattempts','write',70,'mod_quiz',32),(408,'mod/quiz:ignoretimelimits','read',70,'mod_quiz',0),(409,'mod/quiz:emailconfirmsubmission','read',70,'mod_quiz',0),(410,'mod/quiz:emailnotifysubmission','read',70,'mod_quiz',0),(411,'mod/quiz:emailwarnoverdue','read',70,'mod_quiz',0),(412,'mod/resource:view','read',70,'mod_resource',0),(413,'mod/resource:addinstance','write',50,'mod_resource',4),(414,'mod/scorm:addinstance','write',50,'mod_scorm',4),(415,'mod/scorm:viewreport','read',70,'mod_scorm',0),(416,'mod/scorm:skipview','read',70,'mod_scorm',0),(417,'mod/scorm:savetrack','write',70,'mod_scorm',0),(418,'mod/scorm:viewscores','read',70,'mod_scorm',0),(419,'mod/scorm:deleteresponses','write',70,'mod_scorm',0),(420,'mod/scorm:deleteownresponses','write',70,'mod_scorm',0),(421,'mod/survey:addinstance','write',50,'mod_survey',4),(422,'mod/survey:participate','read',70,'mod_survey',0),(423,'mod/survey:readresponses','read',70,'mod_survey',0),(424,'mod/survey:download','read',70,'mod_survey',0),(425,'mod/url:view','read',70,'mod_url',0),(426,'mod/url:addinstance','write',50,'mod_url',4),(427,'mod/wiki:addinstance','write',50,'mod_wiki',4),(428,'mod/wiki:viewpage','read',70,'mod_wiki',0),(429,'mod/wiki:editpage','write',70,'mod_wiki',16),(430,'mod/wiki:createpage','write',70,'mod_wiki',16),(431,'mod/wiki:viewcomment','read',70,'mod_wiki',0),(432,'mod/wiki:editcomment','write',70,'mod_wiki',16),(433,'mod/wiki:managecomment','write',70,'mod_wiki',0),(434,'mod/wiki:managefiles','write',70,'mod_wiki',0),(435,'mod/wiki:overridelock','write',70,'mod_wiki',0),(436,'mod/wiki:managewiki','write',70,'mod_wiki',0),(437,'mod/workshop:view','read',70,'mod_workshop',0),(438,'mod/workshop:addinstance','write',50,'mod_workshop',4),(439,'mod/workshop:switchphase','write',70,'mod_workshop',0),(440,'mod/workshop:editdimensions','write',70,'mod_workshop',4),(441,'mod/workshop:submit','write',70,'mod_workshop',0),(442,'mod/workshop:peerassess','write',70,'mod_workshop',0),(443,'mod/workshop:manageexamples','write',70,'mod_workshop',0),(444,'mod/workshop:allocate','write',70,'mod_workshop',0),(445,'mod/workshop:publishsubmissions','write',70,'mod_workshop',0),(446,'mod/workshop:viewauthornames','read',70,'mod_workshop',0),(447,'mod/workshop:viewreviewernames','read',70,'mod_workshop',0),(448,'mod/workshop:viewallsubmissions','read',70,'mod_workshop',0),(449,'mod/workshop:viewpublishedsubmissions','read',70,'mod_workshop',0),(450,'mod/workshop:viewauthorpublished','read',70,'mod_workshop',0),(451,'mod/workshop:viewallassessments','read',70,'mod_workshop',0),(452,'mod/workshop:overridegrades','write',70,'mod_workshop',0),(453,'mod/workshop:ignoredeadlines','write',70,'mod_workshop',0),(454,'mod/workshop:deletesubmissions','write',70,'mod_workshop',0),(455,'mod/workshop:exportsubmissions','read',70,'mod_workshop',0),(456,'auth/oauth2:managelinkedlogins','write',30,'auth_oauth2',0),(457,'enrol/category:synchronised','write',10,'enrol_category',0),(458,'enrol/category:config','write',50,'enrol_category',0),(459,'enrol/cohort:config','write',50,'enrol_cohort',0),(460,'enrol/cohort:unenrol','write',50,'enrol_cohort',0),(461,'enrol/database:unenrol','write',50,'enrol_database',0),(462,'enrol/database:config','write',50,'enrol_database',0),(463,'enrol/fee:config','write',50,'enrol_fee',0),(464,'enrol/fee:manage','write',50,'enrol_fee',0),(465,'enrol/fee:unenrol','write',50,'enrol_fee',0),(466,'enrol/fee:unenrolself','write',50,'enrol_fee',0),(467,'enrol/flatfile:manage','write',50,'enrol_flatfile',0),(468,'enrol/flatfile:unenrol','write',50,'enrol_flatfile',0),(469,'enrol/guest:config','write',50,'enrol_guest',0),(470,'enrol/imsenterprise:config','write',50,'enrol_imsenterprise',0),(471,'enrol/ldap:manage','write',50,'enrol_ldap',0),(472,'enrol/lti:config','write',50,'enrol_lti',0),(473,'enrol/lti:unenrol','write',50,'enrol_lti',0),(474,'enrol/manual:config','write',50,'enrol_manual',0),(475,'enrol/manual:enrol','write',50,'enrol_manual',0),(476,'enrol/manual:manage','write',50,'enrol_manual',0),(477,'enrol/manual:unenrol','write',50,'enrol_manual',0),(478,'enrol/manual:unenrolself','write',50,'enrol_manual',0),(479,'enrol/meta:config','write',50,'enrol_meta',0),(480,'enrol/meta:selectaslinked','read',50,'enrol_meta',0),(481,'enrol/meta:unenrol','write',50,'enrol_meta',0),(482,'enrol/mnet:config','write',50,'enrol_mnet',0),(483,'enrol/paypal:config','write',50,'enrol_paypal',0),(484,'enrol/paypal:manage','write',50,'enrol_paypal',0),(485,'enrol/paypal:unenrol','write',50,'enrol_paypal',0),(486,'enrol/paypal:unenrolself','write',50,'enrol_paypal',0),(487,'enrol/self:config','write',50,'enrol_self',0),(488,'enrol/self:manage','write',50,'enrol_self',0),(489,'enrol/self:holdkey','write',50,'enrol_self',0),(490,'enrol/self:unenrolself','write',50,'enrol_self',0),(491,'enrol/self:unenrol','write',50,'enrol_self',0),(492,'enrol/self:enrolself','write',50,'enrol_self',0),(493,'message/airnotifier:managedevice','write',10,'message_airnotifier',0),(494,'block/accessreview:addinstance','write',80,'block_accessreview',0),(495,'block/accessreview:view','read',80,'block_accessreview',0),(496,'block/activity_modules:addinstance','write',80,'block_activity_modules',20),(497,'block/activity_results:addinstance','write',80,'block_activity_results',20),(498,'block/admin_bookmarks:myaddinstance','write',10,'block_admin_bookmarks',0),(499,'block/admin_bookmarks:addinstance','write',80,'block_admin_bookmarks',20),(500,'block/badges:addinstance','read',80,'block_badges',0),(501,'block/badges:myaddinstance','read',10,'block_badges',8),(502,'block/blog_menu:addinstance','write',80,'block_blog_menu',20),(503,'block/blog_recent:addinstance','write',80,'block_blog_recent',20),(504,'block/blog_tags:addinstance','write',80,'block_blog_tags',20),(505,'block/calendar_month:myaddinstance','write',10,'block_calendar_month',0),(506,'block/calendar_month:addinstance','write',80,'block_calendar_month',20),(507,'block/calendar_upcoming:myaddinstance','write',10,'block_calendar_upcoming',0),(508,'block/calendar_upcoming:addinstance','write',80,'block_calendar_upcoming',20),(509,'block/comments:myaddinstance','write',10,'block_comments',0),(510,'block/comments:addinstance','write',80,'block_comments',20),(511,'block/completionstatus:addinstance','write',80,'block_completionstatus',20),(512,'block/course_list:myaddinstance','write',10,'block_course_list',0),(513,'block/course_list:addinstance','write',80,'block_course_list',20),(514,'block/course_summary:addinstance','write',80,'block_course_summary',20),(515,'block/feedback:addinstance','write',80,'block_feedback',20),(516,'block/globalsearch:myaddinstance','write',10,'block_globalsearch',0),(517,'block/globalsearch:addinstance','write',80,'block_globalsearch',0),(518,'block/glossary_random:myaddinstance','write',10,'block_glossary_random',0),(519,'block/glossary_random:addinstance','write',80,'block_glossary_random',20),(520,'block/html:myaddinstance','write',10,'block_html',0),(521,'block/html:addinstance','write',80,'block_html',20),(522,'block/login:addinstance','write',80,'block_login',20),(523,'block/lp:addinstance','write',10,'block_lp',0),(524,'block/lp:myaddinstance','write',10,'block_lp',0),(525,'block/mentees:myaddinstance','write',10,'block_mentees',0),(526,'block/mentees:addinstance','write',80,'block_mentees',20),(527,'block/mnet_hosts:myaddinstance','write',10,'block_mnet_hosts',0),(528,'block/mnet_hosts:addinstance','write',80,'block_mnet_hosts',20),(529,'block/myoverview:myaddinstance','write',10,'block_myoverview',0),(530,'block/myprofile:myaddinstance','write',10,'block_myprofile',0),(531,'block/myprofile:addinstance','write',80,'block_myprofile',20),(532,'block/navigation:myaddinstance','write',10,'block_navigation',0),(533,'block/navigation:addinstance','write',80,'block_navigation',20),(534,'block/news_items:myaddinstance','write',10,'block_news_items',0),(535,'block/news_items:addinstance','write',80,'block_news_items',20),(536,'block/online_users:myaddinstance','write',10,'block_online_users',0),(537,'block/online_users:addinstance','write',80,'block_online_users',20),(538,'block/online_users:viewlist','read',80,'block_online_users',0),(539,'block/private_files:myaddinstance','write',10,'block_private_files',0),(540,'block/private_files:addinstance','write',80,'block_private_files',20),(541,'block/quiz_results:addinstance','write',80,'block_quiz_results',20),(542,'block/recent_activity:addinstance','write',80,'block_recent_activity',20),(543,'block/recent_activity:viewaddupdatemodule','read',50,'block_recent_activity',0),(544,'block/recent_activity:viewdeletemodule','read',50,'block_recent_activity',0),(545,'block/recentlyaccessedcourses:myaddinstance','write',10,'block_recentlyaccessedcourses',0),(546,'block/recentlyaccesseditems:myaddinstance','write',10,'block_recentlyaccesseditems',0),(547,'block/rss_client:myaddinstance','write',10,'block_rss_client',0),(548,'block/rss_client:addinstance','write',80,'block_rss_client',20),(549,'block/rss_client:manageownfeeds','write',80,'block_rss_client',0),(550,'block/rss_client:manageanyfeeds','write',80,'block_rss_client',16),(551,'block/search_forums:addinstance','write',80,'block_search_forums',20),(552,'block/section_links:addinstance','write',80,'block_section_links',20),(553,'block/selfcompletion:addinstance','write',80,'block_selfcompletion',20),(554,'block/settings:myaddinstance','write',10,'block_settings',0),(555,'block/settings:addinstance','write',80,'block_settings',20),(556,'block/site_main_menu:addinstance','write',80,'block_site_main_menu',20),(557,'block/social_activities:addinstance','write',80,'block_social_activities',20),(558,'block/starredcourses:myaddinstance','write',10,'block_starredcourses',0),(559,'block/tag_flickr:addinstance','write',80,'block_tag_flickr',20),(560,'block/tag_youtube:addinstance','write',80,'block_tag_youtube',20),(561,'block/tags:myaddinstance','write',10,'block_tags',0),(562,'block/tags:addinstance','write',80,'block_tags',20),(563,'block/timeline:myaddinstance','write',10,'block_timeline',0),(564,'report/completion:view','read',50,'report_completion',8),(565,'report/courseoverview:view','read',10,'report_courseoverview',8),(566,'report/log:view','read',50,'report_log',8),(567,'report/log:viewtoday','read',50,'report_log',8),(568,'report/loglive:view','read',50,'report_loglive',8),(569,'report/outline:view','read',50,'report_outline',8),(570,'report/outline:viewuserreport','read',50,'report_outline',8),(571,'report/participation:view','read',50,'report_participation',8),(572,'report/performance:view','read',10,'report_performance',2),(573,'report/progress:view','read',50,'report_progress',8),(574,'report/questioninstances:view','read',10,'report_questioninstances',0),(575,'report/security:view','read',10,'report_security',2),(576,'report/stats:view','read',50,'report_stats',8),(577,'report/status:view','read',10,'report_status',2),(578,'report/usersessions:manageownsessions','write',30,'report_usersessions',0),(579,'gradeexport/ods:view','read',50,'gradeexport_ods',8),(580,'gradeexport/ods:publish','read',50,'gradeexport_ods',8),(581,'gradeexport/txt:view','read',50,'gradeexport_txt',8),(582,'gradeexport/txt:publish','read',50,'gradeexport_txt',8),(583,'gradeexport/xls:view','read',50,'gradeexport_xls',8),(584,'gradeexport/xls:publish','read',50,'gradeexport_xls',8),(585,'gradeexport/xml:view','read',50,'gradeexport_xml',8),(586,'gradeexport/xml:publish','read',50,'gradeexport_xml',8),(587,'gradeimport/csv:view','write',50,'gradeimport_csv',0),(588,'gradeimport/direct:view','write',50,'gradeimport_direct',0),(589,'gradeimport/xml:view','write',50,'gradeimport_xml',0),(590,'gradeimport/xml:publish','write',50,'gradeimport_xml',0),(591,'gradereport/grader:view','read',50,'gradereport_grader',8),(592,'gradereport/history:view','read',50,'gradereport_history',8),(593,'gradereport/outcomes:view','read',50,'gradereport_outcomes',8),(594,'gradereport/overview:view','read',50,'gradereport_overview',8),(595,'gradereport/singleview:view','read',50,'gradereport_singleview',8),(596,'gradereport/user:view','read',50,'gradereport_user',8),(597,'webservice/rest:use','read',50,'webservice_rest',0),(598,'webservice/soap:use','read',50,'webservice_soap',0),(599,'webservice/xmlrpc:use','read',50,'webservice_xmlrpc',0),(600,'repository/areafiles:view','read',70,'repository_areafiles',0),(601,'repository/boxnet:view','read',70,'repository_boxnet',0),(602,'repository/contentbank:view','read',70,'repository_contentbank',0),(603,'repository/contentbank:accesscoursecontent','read',50,'repository_contentbank',0),(604,'repository/contentbank:accesscoursecategorycontent','read',40,'repository_contentbank',0),(605,'repository/contentbank:accessgeneralcontent','read',40,'repository_contentbank',0),(606,'repository/coursefiles:view','read',70,'repository_coursefiles',0),(607,'repository/dropbox:view','read',70,'repository_dropbox',0),(608,'repository/equella:view','read',70,'repository_equella',0),(609,'repository/filesystem:view','read',70,'repository_filesystem',0),(610,'repository/flickr:view','read',70,'repository_flickr',0),(611,'repository/flickr_public:view','read',70,'repository_flickr_public',0),(612,'repository/googledocs:view','read',70,'repository_googledocs',0),(613,'repository/local:view','read',70,'repository_local',0),(614,'repository/merlot:view','read',70,'repository_merlot',0),(615,'repository/nextcloud:view','read',70,'repository_nextcloud',0),(616,'repository/onedrive:view','read',70,'repository_onedrive',0),(617,'repository/picasa:view','read',70,'repository_picasa',0),(618,'repository/recent:view','read',70,'repository_recent',0),(619,'repository/s3:view','read',70,'repository_s3',0),(620,'repository/skydrive:view','read',70,'repository_skydrive',0),(621,'repository/upload:view','read',70,'repository_upload',0),(622,'repository/url:view','read',70,'repository_url',0),(623,'repository/user:view','read',70,'repository_user',0),(624,'repository/webdav:view','read',70,'repository_webdav',0),(625,'repository/wikimedia:view','read',70,'repository_wikimedia',0),(626,'repository/youtube:view','read',70,'repository_youtube',0),(627,'tool/brickfield:viewcoursetools','read',50,'tool_brickfield',8),(628,'tool/brickfield:viewsystemtools','read',10,'tool_brickfield',2),(629,'tool/customlang:view','read',10,'tool_customlang',2),(630,'tool/customlang:edit','write',10,'tool_customlang',6),(631,'tool/customlang:export','read',10,'tool_customlang',2),(632,'tool/dataprivacy:managedatarequests','write',10,'tool_dataprivacy',60),(633,'tool/dataprivacy:requestdeleteforotheruser','write',10,'tool_dataprivacy',60),(634,'tool/dataprivacy:managedataregistry','write',10,'tool_dataprivacy',60),(635,'tool/dataprivacy:makedatarequestsforchildren','write',30,'tool_dataprivacy',24),(636,'tool/dataprivacy:makedatadeletionrequestsforchildren','write',30,'tool_dataprivacy',24),(637,'tool/dataprivacy:downloadownrequest','read',30,'tool_dataprivacy',0),(638,'tool/dataprivacy:downloadallrequests','read',30,'tool_dataprivacy',8),(639,'tool/dataprivacy:requestdelete','write',30,'tool_dataprivacy',32),(640,'tool/lpmigrate:frameworksmigrate','write',10,'tool_lpmigrate',0),(641,'tool/monitor:subscribe','read',50,'tool_monitor',8),(642,'tool/monitor:managerules','write',50,'tool_monitor',4),(643,'tool/monitor:managetool','write',10,'tool_monitor',4),(644,'tool/policy:accept','write',10,'tool_policy',0),(645,'tool/policy:acceptbehalf','write',30,'tool_policy',8),(646,'tool/policy:managedocs','write',10,'tool_policy',0),(647,'tool/policy:viewacceptances','read',10,'tool_policy',0),(648,'tool/recyclebin:deleteitems','write',50,'tool_recyclebin',32),(649,'tool/recyclebin:restoreitems','write',50,'tool_recyclebin',0),(650,'tool/recyclebin:viewitems','read',50,'tool_recyclebin',0),(651,'tool/uploaduser:uploaduserpictures','write',10,'tool_uploaduser',16),(652,'tool/usertours:managetours','write',10,'tool_usertours',4),(653,'contenttype/h5p:access','read',50,'contenttype_h5p',0),(654,'contenttype/h5p:upload','write',50,'contenttype_h5p',16),(655,'contenttype/h5p:useeditor','write',50,'contenttype_h5p',16),(656,'booktool/exportimscp:export','read',70,'booktool_exportimscp',0),(657,'booktool/importhtml:import','write',70,'booktool_importhtml',4),(658,'booktool/print:print','read',70,'booktool_print',0),(659,'forumreport/summary:view','read',70,'forumreport_summary',0),(660,'forumreport/summary:viewall','read',70,'forumreport_summary',8),(661,'quiz/grading:viewstudentnames','read',70,'quiz_grading',0),(662,'quiz/grading:viewidnumber','read',70,'quiz_grading',0),(663,'quiz/statistics:view','read',70,'quiz_statistics',0),(664,'quizaccess/seb:managetemplates','write',10,'quizaccess_seb',0),(665,'quizaccess/seb:bypassseb','read',70,'quizaccess_seb',0),(666,'quizaccess/seb:manage_seb_requiresafeexambrowser','write',70,'quizaccess_seb',0),(667,'quizaccess/seb:manage_seb_templateid','read',70,'quizaccess_seb',0),(668,'quizaccess/seb:manage_filemanager_sebconfigfile','write',70,'quizaccess_seb',0),(669,'quizaccess/seb:manage_seb_showsebdownloadlink','write',70,'quizaccess_seb',0),(670,'quizaccess/seb:manage_seb_allowedbrowserexamkeys','write',70,'quizaccess_seb',0),(671,'quizaccess/seb:manage_seb_linkquitseb','write',70,'quizaccess_seb',0),(672,'quizaccess/seb:manage_seb_userconfirmquit','write',70,'quizaccess_seb',0),(673,'quizaccess/seb:manage_seb_allowuserquitseb','write',70,'quizaccess_seb',0),(674,'quizaccess/seb:manage_seb_quitpassword','write',70,'quizaccess_seb',0),(675,'quizaccess/seb:manage_seb_allowreloadinexam','write',70,'quizaccess_seb',0),(676,'quizaccess/seb:manage_seb_showsebtaskbar','write',70,'quizaccess_seb',0),(677,'quizaccess/seb:manage_seb_showreloadbutton','write',70,'quizaccess_seb',0),(678,'quizaccess/seb:manage_seb_showtime','write',70,'quizaccess_seb',0),(679,'quizaccess/seb:manage_seb_showkeyboardlayout','write',70,'quizaccess_seb',0),(680,'quizaccess/seb:manage_seb_showwificontrol','write',70,'quizaccess_seb',0),(681,'quizaccess/seb:manage_seb_enableaudiocontrol','write',70,'quizaccess_seb',0),(682,'quizaccess/seb:manage_seb_muteonstartup','write',70,'quizaccess_seb',0),(683,'quizaccess/seb:manage_seb_allowspellchecking','write',70,'quizaccess_seb',0),(684,'quizaccess/seb:manage_seb_activateurlfiltering','write',70,'quizaccess_seb',0),(685,'quizaccess/seb:manage_seb_filterembeddedcontent','write',70,'quizaccess_seb',0),(686,'quizaccess/seb:manage_seb_expressionsallowed','write',70,'quizaccess_seb',0),(687,'quizaccess/seb:manage_seb_regexallowed','write',70,'quizaccess_seb',0),(688,'quizaccess/seb:manage_seb_expressionsblocked','write',70,'quizaccess_seb',0),(689,'quizaccess/seb:manage_seb_regexblocked','write',70,'quizaccess_seb',0),(690,'atto/h5p:addembed','write',70,'atto_h5p',0),(691,'atto/recordrtc:recordaudio','write',70,'atto_recordrtc',0),(692,'atto/recordrtc:recordvideo','write',70,'atto_recordrtc',0),(713,'block/course_list_advanced:myaddinstance','write',10,'block_course_list_advanced',0),(714,'block/course_list_advanced:addinstance','write',80,'block_course_list_advanced',20),(715,'block/course_list_advanced:view','write',80,'block_course_list_advanced',20),(716,'block/course_list_advanced:viewblockcontent','write',80,'block_course_list_advanced',20),(717,'block/catalogue:addinstance','write',50,'block_catalogue',20),(718,'block/catalogue:edit','write',50,'block_catalogue',2),(719,'block/catalogue:togglefav','write',50,'block_catalogue',0),(720,'block/catalogue:view','read',50,'block_catalogue',0),(721,'block/catalogue:viewlists','write',50,'block_catalogue',0),(722,'block/catalogue:togglehide','write',50,'block_catalogue',2),(723,'block/course_overview:myaddinstance','write',10,'block_course_overview',0),(724,'block/course_overview:addinstance','write',80,'block_course_overview',20),(805,'local/hierarchy:manage','write',10,'local_hierarchy',36),(806,'local/hierarchy:roles_manage','write',10,'local_hierarchy',0),(807,'local/hierarchy:course_report_access','read',10,'local_hierarchy',0),(808,'local/hierarchy:course_report_filter','read',10,'local_hierarchy',0),(809,'local/hierarchy:course_report_download','read',10,'local_hierarchy',0),(810,'local/hierarchy:user_report_access','read',10,'local_hierarchy',0),(811,'local/hierarchy:user_report_filter','read',10,'local_hierarchy',0),(812,'local/hierarchy:user_report_download','read',10,'local_hierarchy',0),(813,'local/hierarchy:branch_view','read',10,'local_hierarchy',0),(814,'local/hierarchy:branch_add','write',10,'local_hierarchy',0),(815,'local/hierarchy:branch_delete','write',10,'local_hierarchy',0),(816,'local/hierarchy:branch_edit','write',10,'local_hierarchy',0),(817,'local/hierarchy:dept_view','read',10,'local_hierarchy',0),(818,'local/hierarchy:dept_add','write',10,'local_hierarchy',0),(819,'local/hierarchy:dept_delete','write',10,'local_hierarchy',0),(820,'local/hierarchy:dept_edit','write',10,'local_hierarchy',0),(821,'local/hierarchy:dept_assign','write',10,'local_hierarchy',0),(822,'local/hierarchy:dept_user_manage','write',10,'local_hierarchy',0),(823,'local/hierarchy:dept_user_view','read',10,'local_hierarchy',0),(824,'local/hierarchy:dept_user_individual_report_download','read',10,'local_hierarchy',0);
/*!40000 ALTER TABLE `mdl_capabilities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat`
--

DROP TABLE IF EXISTS `mdl_chat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `keepdays` bigint(11) NOT NULL DEFAULT '0',
  `studentlogs` smallint(4) NOT NULL DEFAULT '0',
  `chattime` bigint(10) NOT NULL DEFAULT '0',
  `schedule` smallint(4) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each of these is a chat room';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat`
--

LOCK TABLES `mdl_chat` WRITE;
/*!40000 ALTER TABLE `mdl_chat` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages`
--

DROP TABLE IF EXISTS `mdl_chat_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmess_use_ix` (`userid`),
  KEY `mdl_chatmess_gro_ix` (`groupid`),
  KEY `mdl_chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores all the actual chat messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages`
--

LOCK TABLES `mdl_chat_messages` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_messages_current`
--

DROP TABLE IF EXISTS `mdl_chat_messages_current`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_messages_current` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_chatmesscurr_use_ix` (`userid`),
  KEY `mdl_chatmesscurr_gro_ix` (`groupid`),
  KEY `mdl_chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `mdl_chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores current session';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_messages_current`
--

LOCK TABLES `mdl_chat_messages_current` WRITE;
/*!40000 ALTER TABLE `mdl_chat_messages_current` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_messages_current` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_chat_users`
--

DROP TABLE IF EXISTS `mdl_chat_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_chat_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(11) NOT NULL DEFAULT '0',
  `userid` bigint(11) NOT NULL DEFAULT '0',
  `groupid` bigint(11) NOT NULL DEFAULT '0',
  `version` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `firstping` bigint(10) NOT NULL DEFAULT '0',
  `lastping` bigint(10) NOT NULL DEFAULT '0',
  `lastmessageping` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_chatuser_use_ix` (`userid`),
  KEY `mdl_chatuser_las_ix` (`lastping`),
  KEY `mdl_chatuser_gro_ix` (`groupid`),
  KEY `mdl_chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of which users are in which chat rooms';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_chat_users`
--

LOCK TABLES `mdl_chat_users` WRITE;
/*!40000 ALTER TABLE `mdl_chat_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_chat_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice`
--

DROP TABLE IF EXISTS `mdl_choice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `publish` tinyint(2) NOT NULL DEFAULT '0',
  `showresults` tinyint(2) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `allowupdate` tinyint(2) NOT NULL DEFAULT '0',
  `allowmultiple` tinyint(2) NOT NULL DEFAULT '0',
  `showunanswered` tinyint(2) NOT NULL DEFAULT '0',
  `includeinactive` tinyint(2) NOT NULL DEFAULT '1',
  `limitanswers` tinyint(2) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `showpreview` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  `showavailable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Available choices are stored here';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice`
--

LOCK TABLES `mdl_choice` WRITE;
/*!40000 ALTER TABLE `mdl_choice` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_answers`
--

DROP TABLE IF EXISTS `mdl_choice_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `optionid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiansw_use_ix` (`userid`),
  KEY `mdl_choiansw_cho_ix` (`choiceid`),
  KEY `mdl_choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='choices performed by users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_answers`
--

LOCK TABLES `mdl_choice_answers` WRITE;
/*!40000 ALTER TABLE `mdl_choice_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_choice_options`
--

DROP TABLE IF EXISTS `mdl_choice_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_choice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `text` longtext COLLATE utf8mb4_unicode_ci,
  `maxanswers` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='available options to choice';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_choice_options`
--

LOCK TABLES `mdl_choice_options` WRITE;
/*!40000 ALTER TABLE `mdl_choice_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_choice_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort`
--

DROP TABLE IF EXISTS `mdl_cohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `name` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `theme` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Each record represents one cohort (aka site-wide group).';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort`
--

LOCK TABLES `mdl_cohort` WRITE;
/*!40000 ALTER TABLE `mdl_cohort` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_cohort_members`
--

DROP TABLE IF EXISTS `mdl_cohort_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_cohort_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `mdl_cohomemb_coh_ix` (`cohortid`),
  KEY `mdl_cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a user to a cohort.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_cohort_members`
--

LOCK TABLES `mdl_cohort_members` WRITE;
/*!40000 ALTER TABLE `mdl_cohort_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_cohort_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_comments`
--

DROP TABLE IF EXISTS `mdl_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentarea` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `mdl_comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='moodle comments module';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_comments`
--

LOCK TABLES `mdl_comments` WRITE;
/*!40000 ALTER TABLE `mdl_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency`
--

DROP TABLE IF EXISTS `mdl_competency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `competencyframeworkid` bigint(10) NOT NULL,
  `parentid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL,
  `ruletype` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ruleoutcome` tinyint(2) NOT NULL DEFAULT '0',
  `ruleconfig` longtext COLLATE utf8mb4_unicode_ci,
  `scaleid` bigint(10) DEFAULT NULL,
  `scaleconfiguration` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `mdl_comp_rul_ix` (`ruleoutcome`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the master record of each competency in ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency`
--

LOCK TABLES `mdl_competency` WRITE;
/*!40000 ALTER TABLE `mdl_competency` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_coursecomp`
--

DROP TABLE IF EXISTS `mdl_competency_coursecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_coursecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `mdl_compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `mdl_compcour_cou2_ix` (`courseid`),
  KEY `mdl_compcour_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a course.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_coursecomp`
--

LOCK TABLES `mdl_competency_coursecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_coursecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_coursecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_coursecompsetting`
--

DROP TABLE IF EXISTS `mdl_competency_coursecompsetting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_coursecompsetting` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `pushratingstouserplans` tinyint(2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table contains the course specific settings for compete';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_coursecompsetting`
--

LOCK TABLES `mdl_competency_coursecompsetting` WRITE;
/*!40000 ALTER TABLE `mdl_competency_coursecompsetting` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_coursecompsetting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_evidence`
--

DROP TABLE IF EXISTS `mdl_competency_evidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_evidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `action` tinyint(2) NOT NULL,
  `actionuserid` bigint(10) DEFAULT NULL,
  `descidentifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `desccomponent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `desca` longtext COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `note` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compevid_use_ix` (`usercompetencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence linked to a user competency';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_evidence`
--

LOCK TABLES `mdl_competency_evidence` WRITE;
/*!40000 ALTER TABLE `mdl_competency_evidence` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_evidence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_framework`
--

DROP TABLE IF EXISTS `mdl_competency_framework`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_framework` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `scaleid` bigint(11) DEFAULT NULL,
  `scaleconfiguration` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compfram_idn_uix` (`idnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of competency frameworks.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_framework`
--

LOCK TABLES `mdl_competency_framework` WRITE;
/*!40000 ALTER TABLE `mdl_competency_framework` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_framework` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_modulecomp`
--

DROP TABLE IF EXISTS `mdl_competency_modulecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_modulecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `mdl_compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `mdl_compmodu_cmi_ix` (`cmid`),
  KEY `mdl_compmodu_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a module.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_modulecomp`
--

LOCK TABLES `mdl_competency_modulecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_modulecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_modulecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_plan`
--

DROP TABLE IF EXISTS `mdl_competency_plan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_plan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `templateid` bigint(10) DEFAULT NULL,
  `origtemplateid` bigint(10) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint(10) DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compplan_usesta_ix` (`userid`,`status`),
  KEY `mdl_compplan_tem_ix` (`templateid`),
  KEY `mdl_compplan_stadue_ix` (`status`,`duedate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plans';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_plan`
--

LOCK TABLES `mdl_competency_plan` WRITE;
/*!40000 ALTER TABLE `mdl_competency_plan` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_plan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_plancomp`
--

DROP TABLE IF EXISTS `mdl_competency_plancomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_plancomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `planid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compplan_placom_uix` (`planid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Plan competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_plancomp`
--

LOCK TABLES `mdl_competency_plancomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_plancomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_plancomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_relatedcomp`
--

DROP TABLE IF EXISTS `mdl_competency_relatedcomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_relatedcomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `competencyid` bigint(10) NOT NULL,
  `relatedcompetencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Related competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_relatedcomp`
--

LOCK TABLES `mdl_competency_relatedcomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_relatedcomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_relatedcomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_template`
--

DROP TABLE IF EXISTS `mdl_competency_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `duedate` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Learning plan templates.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_template`
--

LOCK TABLES `mdl_competency_template` WRITE;
/*!40000 ALTER TABLE `mdl_competency_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_templatecohort`
--

DROP TABLE IF EXISTS `mdl_competency_templatecohort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_templatecohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `cohortid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `mdl_comptemp_tem2_ix` (`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default comment for the table, please edit me';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_templatecohort`
--

LOCK TABLES `mdl_competency_templatecohort` WRITE;
/*!40000 ALTER TABLE `mdl_competency_templatecohort` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_templatecohort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_templatecomp`
--

DROP TABLE IF EXISTS `mdl_competency_templatecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_templatecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_comptemp_tem_ix` (`templateid`),
  KEY `mdl_comptemp_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link a competency to a learning plan template.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_templatecomp`
--

LOCK TABLES `mdl_competency_templatecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_templatecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_templatecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercomp`
--

DROP TABLE IF EXISTS `mdl_competency_usercomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_usercomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecom_uix` (`userid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercomp`
--

LOCK TABLES `mdl_competency_usercomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercompcourse`
--

DROP TABLE IF EXISTS `mdl_competency_usercompcourse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_usercompcourse` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies in a course';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercompcourse`
--

LOCK TABLES `mdl_competency_usercompcourse` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercompcourse` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercompcourse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_usercompplan`
--

DROP TABLE IF EXISTS `mdl_competency_usercompplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_usercompplan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `planid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecompla_uix` (`userid`,`competencyid`,`planid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User competencies plans';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_usercompplan`
--

LOCK TABLES `mdl_competency_usercompplan` WRITE;
/*!40000 ALTER TABLE `mdl_competency_usercompplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_usercompplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_userevidence`
--

DROP TABLE IF EXISTS `mdl_competency_userevidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_userevidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_compuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='The evidence of prior learning';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_userevidence`
--

LOCK TABLES `mdl_competency_userevidence` WRITE;
/*!40000 ALTER TABLE `mdl_competency_userevidence` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_userevidence` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_competency_userevidencecomp`
--

DROP TABLE IF EXISTS `mdl_competency_userevidencecomp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_competency_userevidencecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `mdl_compuser_use2_ix` (`userevidenceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Relationship between user evidence and competencies';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_competency_userevidencecomp`
--

LOCK TABLES `mdl_competency_userevidencecomp` WRITE;
/*!40000 ALTER TABLE `mdl_competency_userevidencecomp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_competency_userevidencecomp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config`
--

DROP TABLE IF EXISTS `mdl_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_conf_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=554 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config`
--

LOCK TABLES `mdl_config` WRITE;
/*!40000 ALTER TABLE `mdl_config` DISABLE KEYS */;
INSERT INTO `mdl_config` VALUES (2,'rolesactive','1'),(3,'auth','email'),(4,'enrol_plugins_enabled','manual,guest,self,cohort'),(5,'theme','boost'),(6,'filter_multilang_converted','1'),(7,'siteidentifier','9P5b7IXBFHMexyoVi2xxIBfJyTRuRrZW148.72.245.159'),(8,'backup_version','2021051700'),(9,'backup_release','3.11'),(10,'mnet_dispatcher_mode','off'),(11,'sessiontimeout','28800'),(12,'stringfilters',''),(13,'filterall','0'),(14,'texteditors','atto,tinymce,textarea'),(15,'antiviruses',''),(16,'media_plugins_sortorder','videojs,youtube,swf'),(17,'upgrade_extracreditweightsstepignored','1'),(18,'upgrade_calculatedgradeitemsignored','1'),(19,'upgrade_letterboundarycourses','1'),(20,'mnet_localhost_id','1'),(21,'mnet_all_hosts_id','2'),(22,'siteguest','1'),(24,'themerev','1666286542'),(25,'jsrev','1666286542'),(26,'templaterev','1666286542'),(27,'gdversion','2'),(28,'licenses','unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),(29,'sitedefaultlicense','unknown'),(30,'version','2021051702.02'),(31,'enableuserfeedback','0'),(32,'userfeedback_nextreminder','1'),(33,'userfeedback_remindafter','90'),(34,'enableoutcomes','0'),(35,'usecomments','1'),(36,'usetags','1'),(37,'enablenotes','1'),(38,'enableportfolios','0'),(39,'enablewebservices','0'),(40,'enablestats','0'),(41,'enablerssfeeds','0'),(42,'enableblogs','1'),(43,'enablecompletion','1'),(44,'completiondefault','1'),(45,'enableavailability','1'),(46,'enableplagiarism','0'),(47,'enablebadges','1'),(48,'enableglobalsearch','0'),(49,'allowstealth','0'),(50,'enableanalytics','1'),(51,'allowemojipicker','1'),(52,'userfiltersdefault','realname'),(53,'defaultpreference_maildisplay','2'),(54,'defaultpreference_mailformat','1'),(55,'defaultpreference_maildigest','0'),(56,'defaultpreference_autosubscribe','1'),(57,'defaultpreference_trackforums','0'),(58,'defaultpreference_core_contentbank_visibility','1'),(59,'autologinguests','0'),(60,'hiddenuserfields',''),(61,'showuseridentity','email'),(62,'fullnamedisplay','language'),(63,'alternativefullnameformat','language'),(64,'maxusersperpage','100'),(65,'enablegravatar','0'),(66,'gravatardefaulturl','mm'),(67,'agedigitalconsentverification','0'),(68,'agedigitalconsentmap','*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13'),(69,'sitepolicy',''),(70,'sitepolicyguest',''),(71,'downloadcoursecontentallowed','0'),(72,'maxsizeperdownloadcoursefile','52428800'),(73,'enablecourserequests','1'),(74,'defaultrequestcategory','2'),(75,'lockrequestcategory','0'),(76,'courserequestnotify',''),(77,'activitychoosertabmode','0'),(78,'activitychooseractivefooter','hidden'),(79,'enableasyncbackup','0'),(80,'grade_profilereport','user'),(81,'grade_aggregationposition','1'),(82,'grade_includescalesinaggregation','1'),(83,'grade_hiddenasdate','0'),(84,'gradepublishing','0'),(85,'grade_export_exportfeedback','0'),(86,'grade_export_displaytype','1'),(87,'grade_export_decimalpoints','2'),(88,'grade_navmethod','1'),(89,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email'),(90,'grade_export_customprofilefields',''),(91,'recovergradesdefault','0'),(92,'gradeexport',''),(93,'unlimitedgrades','0'),(94,'grade_report_showmin','1'),(95,'gradepointmax','100'),(96,'gradepointdefault','100'),(97,'grade_minmaxtouse','1'),(98,'grade_mygrades_report','overview'),(99,'gradereport_mygradeurl',''),(100,'grade_hideforcedsettings','1'),(101,'grade_aggregation','13'),(102,'grade_aggregation_flag','0'),(103,'grade_aggregations_visible','13'),(104,'grade_aggregateonlygraded','1'),(105,'grade_aggregateonlygraded_flag','2'),(106,'grade_aggregateoutcomes','0'),(107,'grade_aggregateoutcomes_flag','2'),(108,'grade_keephigh','0'),(109,'grade_keephigh_flag','3'),(110,'grade_droplow','0'),(111,'grade_droplow_flag','2'),(112,'grade_overridecat','1'),(113,'grade_displaytype','1'),(114,'grade_decimalpoints','2'),(115,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),(116,'grade_report_studentsperpage','100'),(117,'grade_report_showonlyactiveenrol','1'),(118,'grade_report_quickgrading','1'),(119,'grade_report_showquickfeedback','0'),(120,'grade_report_meanselection','1'),(121,'grade_report_enableajax','0'),(122,'grade_report_showcalculations','1'),(123,'grade_report_showeyecons','0'),(124,'grade_report_showaverages','1'),(125,'grade_report_showlocks','0'),(126,'grade_report_showranges','0'),(127,'grade_report_showanalysisicon','1'),(128,'grade_report_showuserimage','1'),(129,'grade_report_showactivityicons','1'),(130,'grade_report_shownumberofgrades','0'),(131,'grade_report_averagesdisplaytype','inherit'),(132,'grade_report_rangesdisplaytype','inherit'),(133,'grade_report_averagesdecimalpoints','inherit'),(134,'grade_report_rangesdecimalpoints','inherit'),(135,'grade_report_historyperpage','50'),(136,'grade_report_overview_showrank','0'),(137,'grade_report_overview_showtotalsifcontainhidden','0'),(138,'grade_report_user_showrank','0'),(139,'grade_report_user_showpercentage','1'),(140,'grade_report_user_showgrade','1'),(141,'grade_report_user_showfeedback','1'),(142,'grade_report_user_showrange','1'),(143,'grade_report_user_showweight','1'),(144,'grade_report_user_showaverage','0'),(145,'grade_report_user_showlettergrade','0'),(146,'grade_report_user_rangedecimals','0'),(147,'grade_report_user_showhiddenitems','1'),(148,'grade_report_user_showtotalsifcontainhidden','0'),(149,'grade_report_user_showcontributiontocoursetotal','1'),(150,'badges_defaultissuername',''),(151,'badges_defaultissuercontact',''),(152,'badges_badgesalt','badges1663307057'),(153,'badges_allowcoursebadges','1'),(154,'badges_allowexternalbackpack','1'),(155,'rememberuserlicensepref','1'),(157,'forcetimezone','99'),(158,'country','0'),(159,'defaultcity',''),(160,'geoip2file','/var/www/m2/m2_moodle/geoip/GeoLite2-City.mmdb'),(161,'googlemapkey3',''),(162,'allcountrycodes',''),(163,'autolang','1'),(164,'lang','en'),(165,'autolangusercreation','1'),(166,'langmenu','1'),(167,'langlist',''),(168,'langrev','1666286542'),(169,'langcache','1'),(170,'langstringcache','1'),(171,'locale',''),(172,'latinexcelexport','0'),(173,'messaging','1'),(174,'messagingallusers','0'),(175,'messagingdefaultpressenter','1'),(176,'messagingdeletereadnotificationsdelay','604800'),(177,'messagingdeleteallnotificationsdelay','2620800'),(178,'messagingallowemailoverride','0'),(179,'requiremodintro','0'),(181,'authloginviaemail','0'),(182,'allowaccountssameemail','0'),(183,'authpreventaccountcreation','0'),(184,'loginpageautofocus','0'),(185,'guestloginbutton','1'),(186,'limitconcurrentlogins','0'),(187,'alternateloginurl',''),(188,'forgottenpasswordurl',''),(189,'auth_instructions',''),(190,'allowemailaddresses',''),(191,'denyemailaddresses',''),(192,'verifychangedemail','1'),(193,'recaptchapublickey',''),(194,'recaptchaprivatekey',''),(195,'filteruploadedfiles','0'),(196,'filtermatchoneperpage','0'),(197,'filtermatchonepertext','0'),(198,'media_default_width','400'),(199,'media_default_height','300'),(200,'portfolio_moderate_filesize_threshold','1048576'),(201,'portfolio_high_filesize_threshold','5242880'),(202,'portfolio_moderate_db_threshold','20'),(203,'portfolio_high_db_threshold','50'),(204,'repositorycacheexpire','120'),(205,'repositorygetfiletimeout','30'),(206,'repositorysyncfiletimeout','1'),(207,'repositorysyncimagetimeout','3'),(208,'repositoryallowexternallinks','1'),(209,'legacyfilesinnewcourses','0'),(210,'legacyfilesaddallowed','1'),(211,'searchengine','simpledb'),(212,'searchindexwhendisabled','0'),(213,'searchindextime','600'),(214,'searchallavailablecourses','0'),(215,'searchincludeallcourses','0'),(216,'searchenablecategories','0'),(217,'searchdefaultcategory','core-all'),(218,'searchhideallcategory','0'),(219,'searchenginequeryonly',''),(220,'searchbannerenable','0'),(221,'searchbanner',''),(222,'allowbeforeblock','0'),(223,'allowedip',''),(224,'blockedip',''),(225,'protectusernames','1'),(226,'forcelogin','0'),(227,'forceloginforprofiles','1'),(228,'forceloginforprofileimage','0'),(229,'opentowebcrawlers','0'),(230,'allowindexing','0'),(231,'maxbytes','0'),(232,'userquota','104857600'),(233,'allowobjectembed','0'),(234,'enabletrusttext','0'),(235,'maxeditingtime','1800'),(236,'extendedusernamechars','0'),(237,'keeptagnamecase','1'),(238,'profilesforenrolledusersonly','1'),(239,'cronclionly','1'),(240,'cronremotepassword',''),(241,'lockoutthreshold','0'),(242,'lockoutwindow','1800'),(243,'lockoutduration','1800'),(244,'passwordpolicy','1'),(245,'minpasswordlength','8'),(246,'minpassworddigits','1'),(247,'minpasswordlower','1'),(248,'minpasswordupper','1'),(249,'minpasswordnonalphanum','1'),(250,'maxconsecutiveidentchars','0'),(251,'passwordpolicycheckonlogin','0'),(252,'passwordreuselimit','0'),(253,'pwresettime','1800'),(254,'passwordchangelogout','0'),(255,'passwordchangetokendeletion','0'),(256,'tokenduration','7257600'),(257,'groupenrolmentkeypolicy','1'),(258,'disableuserimages','0'),(259,'emailchangeconfirmation','1'),(260,'rememberusername','2'),(261,'strictformsrequired','0'),(262,'cookiesecure','1'),(263,'cookiehttponly','0'),(264,'allowframembedding','0'),(265,'curlsecurityblockedhosts',''),(266,'curlsecurityallowedport',''),(267,'referrerpolicy','default'),(268,'displayloginfailures','0'),(269,'notifyloginfailures',''),(270,'notifyloginthreshold','10'),(271,'themelist',''),(272,'themedesignermode','0'),(273,'allowuserthemes','0'),(274,'allowcoursethemes','0'),(275,'allowcategorythemes','0'),(276,'allowcohortthemes','0'),(277,'allowthemechangeonurl','0'),(278,'allowuserblockhiding','1'),(279,'langmenuinsecurelayout','0'),(280,'logininfoinsecurelayout','0'),(281,'custommenuitems',''),(282,'customusermenuitems','grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences'),(283,'enabledevicedetection','1'),(284,'devicedetectregex','[]'),(285,'calendartype','gregorian'),(286,'calendar_adminseesall','0'),(287,'calendar_site_timeformat','0'),(288,'calendar_startwday','1'),(289,'calendar_weekend','65'),(290,'calendar_lookahead','21'),(291,'calendar_maxevents','10'),(292,'enablecalendarexport','1'),(293,'calendar_customexport','1'),(294,'calendar_exportlookahead','365'),(295,'calendar_exportlookback','5'),(296,'calendar_exportsalt','OeOqveHewIErl85w6ZXqZZuef6TKXZAB0qAwLhWaA5BY3NCFtdnZe2fYYuvO'),(297,'calendar_showicalsource','1'),(298,'useblogassociations','1'),(299,'bloglevel','4'),(300,'useexternalblogs','1'),(301,'externalblogcrontime','86400'),(302,'maxexternalblogsperuser','1'),(303,'blogusecomments','1'),(304,'blogshowcommentscount','1'),(305,'defaulthomepage','1'),(306,'allowguestmymoodle','1'),(307,'navshowfullcoursenames','0'),(308,'navshowcategories','1'),(309,'navshowmycoursecategories','0'),(310,'navshowallcourses','0'),(311,'navsortmycoursessort','sortorder'),(312,'navsortmycourseshiddenlast','1'),(313,'navcourselimit','10'),(314,'usesitenameforsitepages','0'),(315,'linkadmincategories','1'),(316,'linkcoursesections','1'),(317,'navshowfrontpagemods','1'),(318,'navadduserpostslinks','1'),(319,'formatstringstriptags','1'),(320,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]'),(321,'docroot','https://docs.moodle.org'),(322,'doclang',''),(323,'doctonewwindow','0'),(324,'coursecontactduplicates','0'),(325,'courselistshortnames','0'),(326,'coursesperpage','20'),(327,'courseswithsummarieslimit','10'),(328,'courseoverviewfileslimit','1'),(329,'courseoverviewfilesext','.jpg,.gif,.png'),(330,'coursegraceperiodbefore','0'),(331,'coursegraceperiodafter','0'),(332,'useexternalyui','0'),(333,'yuicomboloading','1'),(334,'cachejs','1'),(335,'additionalhtmlhead',''),(336,'additionalhtmltopofbody',''),(337,'additionalhtmlfooter',''),(338,'cachetemplates','1'),(339,'pathtophp',''),(340,'pathtodu',''),(341,'aspellpath',''),(342,'pathtodot',''),(343,'pathtogs','/usr/bin/gs'),(344,'pathtopdftoppm',''),(345,'pathtopython',''),(346,'supportname','Admin User'),(347,'supportemail',''),(348,'supportpage',''),(349,'dbsessions','0'),(350,'sessiontimeoutwarning','1200'),(351,'sessioncookie',''),(352,'sessioncookiepath',''),(353,'sessioncookiedomain',''),(354,'statsfirstrun','none'),(355,'statsmaxruntime','0'),(356,'statsruntimedays','31'),(357,'statsuserthreshold','0'),(358,'slasharguments','1'),(359,'getremoteaddrconf','3'),(360,'reverseproxyignore',''),(361,'proxyhost',''),(362,'proxyport','0'),(363,'proxytype','HTTP'),(364,'proxyuser',''),(365,'proxypassword',''),(366,'proxybypass','localhost, 127.0.0.1'),(367,'maintenance_enabled','0'),(368,'maintenance_message',''),(369,'deleteunconfirmed','168'),(370,'deleteincompleteusers','0'),(371,'disablegradehistory','0'),(372,'gradehistorylifetime','0'),(373,'tempdatafoldercleanup','168'),(374,'filescleanupperiod','86400'),(375,'extramemorylimit','512M'),(376,'maxtimelimit','0'),(377,'curlcache','120'),(378,'curltimeoutkbitrate','56'),(379,'cron_enabled','1'),(380,'task_scheduled_concurrency_limit','3'),(381,'task_scheduled_max_runtime','1800'),(382,'task_adhoc_concurrency_limit','3'),(383,'task_adhoc_max_runtime','1800'),(384,'task_logmode','1'),(385,'task_logtostdout','1'),(386,'task_logretention','2419200'),(387,'task_logretainruns','20'),(388,'smtphosts',''),(389,'smtpsecure',''),(390,'smtpauthtype','LOGIN'),(391,'smtpuser',''),(392,'smtppass',''),(393,'smtpmaxbulk','1'),(394,'allowedemaildomains',''),(395,'divertallemailsto',''),(396,'divertallemailsexcept',''),(397,'emaildkimselector',''),(398,'sitemailcharset','0'),(399,'allowusermailcharset','0'),(400,'allowattachments','1'),(401,'mailnewline','LF'),(402,'emailfromvia','1'),(403,'emailsubjectprefix',''),(404,'emailheaders',''),(405,'updateautocheck','1'),(406,'updateminmaturity','200'),(407,'updatenotifybuilds','0'),(408,'enablewsdocumentation','0'),(409,'dndallowtextandlinks','0'),(410,'pathtosassc',''),(411,'contextlocking','0'),(412,'contextlockappliestoadmin','1'),(413,'forceclean','0'),(414,'enablecourserelativedates','0'),(415,'debug','32767'),(416,'debugdisplay','0'),(417,'perfdebug','7'),(418,'debugstringids','0'),(419,'debugsqltrace','0'),(420,'debugvalidators','0'),(421,'debugpageinfo','0'),(422,'profilingenabled','0'),(423,'profilingincluded',''),(424,'profilingexcluded',''),(425,'profilingautofrec','0'),(426,'profilingallowme','0'),(427,'profilingallowall','0'),(428,'profilingslow','0'),(429,'profilinglifetime','1440'),(430,'profilingimportprefix','(I)'),(431,'release','3.11.2+ (Build: 20210812)'),(432,'localcachedirpurged','1666286521'),(433,'scheduledtaskreset','1666286521'),(434,'paygw_plugins_sortorder','paypal'),(435,'allversionshash','37e5f5abe2dae04cc27abad6f13cbed008cde0a7'),(437,'registrationpending','0'),(438,'branch','311'),(439,'enableaccessibilitytools','1'),(440,'notloggedinroleid','6'),(441,'guestroleid','6'),(442,'defaultuserroleid','7'),(443,'creatornewroleid','3'),(444,'restorernewroleid','3'),(445,'sitepolicyhandler',''),(446,'gradebookroles','5'),(447,'h5plibraryhandler','h5plib_v124'),(448,'jabberhost',''),(449,'jabberserver',''),(450,'jabberusername',''),(451,'jabberpassword',''),(452,'jabberport','5222'),(453,'airnotifierurl','https://messages.moodle.net'),(454,'airnotifierport','443'),(455,'airnotifiermobileappname','com.moodle.moodlemobile'),(456,'airnotifierappname','commoodlemoodlemobile'),(457,'airnotifieraccesskey',''),(458,'chat_method','ajax'),(459,'chat_refresh_userlist','10'),(460,'chat_old_ping','35'),(461,'chat_refresh_room','5'),(462,'chat_normal_updatemode','jsupdate'),(463,'chat_serverhost','148.72.245.159'),(464,'chat_serverip','127.0.0.1'),(465,'chat_serverport','9111'),(466,'chat_servermax','100'),(467,'data_enablerssfeeds','0'),(468,'feedback_allowfullanonymous','0'),(469,'forum_displaymode','3'),(470,'forum_shortpost','300'),(471,'forum_longpost','600'),(472,'forum_manydiscussions','100'),(473,'forum_maxbytes','512000'),(474,'forum_maxattachments','9'),(475,'forum_subscription','0'),(476,'forum_trackingtype','1'),(477,'forum_trackreadposts','1'),(478,'forum_allowforcedreadtracking','0'),(479,'forum_oldpostdays','14'),(480,'forum_usermarksread','0'),(481,'forum_cleanreadtime','2'),(482,'digestmailtime','17'),(483,'forum_enablerssfeeds','0'),(484,'forum_enabletimedposts','1'),(485,'glossary_entbypage','10'),(486,'glossary_dupentries','0'),(487,'glossary_allowcomments','0'),(488,'glossary_linkbydefault','1'),(489,'glossary_defaultapproval','1'),(490,'glossary_enablerssfeeds','0'),(491,'glossary_linkentries','0'),(492,'glossary_casesensitive','0'),(493,'glossary_fullmatch','0'),(494,'block_course_list_adminview','all'),(495,'block_course_list_hideallcourseslink','1'),(496,'block_html_allowcssclasses','0'),(497,'block_online_users_timetosee','5'),(498,'block_online_users_onlinestatushiding','1'),(499,'block_rss_client_num_entries','5'),(500,'block_rss_client_timeout','30'),(501,'pathtounoconv','/usr/bin/unoconv'),(502,'filter_multilang_force_old','0'),(503,'filter_censor_badwords',''),(504,'logguests','1'),(505,'loglifetime','0'),(506,'profileroles','5,4,3'),(507,'coursecontact','3'),(508,'frontpage',''),(509,'frontpageloggedin','6'),(510,'maxcategorydepth','2'),(511,'frontpagecourselimit','200'),(512,'commentsperpage','15'),(513,'defaultfrontpageroleid','8'),(514,'messageinbound_enabled','0'),(515,'messageinbound_mailbox',''),(516,'messageinbound_domain',''),(517,'messageinbound_host',''),(518,'messageinbound_hostssl','ssl'),(519,'messageinbound_hostuser',''),(520,'messageinbound_hostpass',''),(521,'enablemobilewebservice','0'),(522,'mobilecssurl',''),(523,'timezone','Europe/London'),(524,'registerauth','email'),(525,'noreplyaddress',''),(530,'block_course_list_advanced_adminview','own'),(531,'block_course_list_advanced_hideallcourseslink','1'),(532,'block_course_list_advanced_showdeleteicon','1'),(533,'block_course_list_advanced_usesphorphanedfiles','1'),(534,'block_course_list_advanced_isallowedonfrontpage','1'),(535,'block_course_list_advanced_isallowedonmypage','1'),(536,'block_course_list_advanced_maxforsiteadmin','30'),(537,'block_course_list_advanced_showcourseswithguestrole','1'),(540,'themelegacy','classic'),(542,'siteadmins','2,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,150,152,153,155,156,157,158,160,161,171,172,173,174,175,176');
/*!40000 ALTER TABLE `mdl_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_log`
--

DROP TABLE IF EXISTS `mdl_config_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  `oldvalue` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_conflog_tim_ix` (`timemodified`),
  KEY `mdl_conflog_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=1976 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Changes done in server configuration through admin UI';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_log`
--

LOCK TABLES `mdl_config_log` WRITE;
/*!40000 ALTER TABLE `mdl_config_log` DISABLE KEYS */;
INSERT INTO `mdl_config_log` VALUES (1,0,1663307063,NULL,'enableuserfeedback','0',NULL),(2,0,1663307063,NULL,'userfeedback_nextreminder','1',NULL),(3,0,1663307063,NULL,'userfeedback_remindafter','90',NULL),(4,0,1663307063,NULL,'enableoutcomes','0',NULL),(5,0,1663307063,NULL,'usecomments','1',NULL),(6,0,1663307063,NULL,'usetags','1',NULL),(7,0,1663307063,NULL,'enablenotes','1',NULL),(8,0,1663307063,NULL,'enableportfolios','0',NULL),(9,0,1663307063,NULL,'enablewebservices','0',NULL),(10,0,1663307063,NULL,'enablestats','0',NULL),(11,0,1663307063,NULL,'enablerssfeeds','0',NULL),(12,0,1663307063,NULL,'enableblogs','1',NULL),(13,0,1663307063,NULL,'enablecompletion','1',NULL),(14,0,1663307063,NULL,'completiondefault','1',NULL),(15,0,1663307063,NULL,'enableavailability','1',NULL),(16,0,1663307063,NULL,'enableplagiarism','0',NULL),(17,0,1663307063,NULL,'enablebadges','1',NULL),(18,0,1663307063,NULL,'enableglobalsearch','0',NULL),(19,0,1663307063,NULL,'allowstealth','0',NULL),(20,0,1663307063,NULL,'enableanalytics','1',NULL),(21,0,1663307063,NULL,'allowemojipicker','1',NULL),(22,0,1663307063,NULL,'userfiltersdefault','realname',NULL),(23,0,1663307063,NULL,'defaultpreference_maildisplay','2',NULL),(24,0,1663307063,NULL,'defaultpreference_mailformat','1',NULL),(25,0,1663307063,NULL,'defaultpreference_maildigest','0',NULL),(26,0,1663307063,NULL,'defaultpreference_autosubscribe','1',NULL),(27,0,1663307063,NULL,'defaultpreference_trackforums','0',NULL),(28,0,1663307063,NULL,'defaultpreference_core_contentbank_visibility','1',NULL),(29,0,1663307064,NULL,'autologinguests','0',NULL),(30,0,1663307064,NULL,'hiddenuserfields','',NULL),(31,0,1663307064,NULL,'showuseridentity','email',NULL),(32,0,1663307064,NULL,'fullnamedisplay','language',NULL),(33,0,1663307064,NULL,'alternativefullnameformat','language',NULL),(34,0,1663307064,NULL,'maxusersperpage','100',NULL),(35,0,1663307064,NULL,'enablegravatar','0',NULL),(36,0,1663307064,NULL,'gravatardefaulturl','mm',NULL),(37,0,1663307064,NULL,'agedigitalconsentverification','0',NULL),(38,0,1663307064,NULL,'agedigitalconsentmap','*, 16\nAT, 14\nBE, 13\nBG, 14\nCY, 14\nCZ, 15\nDK, 13\nEE, 13\nES, 14\nFI, 13\nFR, 15\nGB, 13\nGR, 15\nIT, 14\nLT, 14\nLV, 13\nMT, 13\nNO, 13\nPT, 13\nSE, 13\nUS, 13',NULL),(39,0,1663307064,NULL,'sitepolicy','',NULL),(40,0,1663307064,NULL,'sitepolicyguest','',NULL),(41,0,1663307064,'moodlecourse','visible','1',NULL),(42,0,1663307064,'moodlecourse','downloadcontentsitedefault','0',NULL),(43,0,1663307064,'moodlecourse','format','topics',NULL),(44,0,1663307064,'moodlecourse','maxsections','52',NULL),(45,0,1663307064,'moodlecourse','numsections','4',NULL),(46,0,1663307064,'moodlecourse','hiddensections','0',NULL),(47,0,1663307064,'moodlecourse','coursedisplay','0',NULL),(48,0,1663307064,'moodlecourse','courseenddateenabled','1',NULL),(49,0,1663307064,'moodlecourse','courseduration','31536000',NULL),(50,0,1663307064,'moodlecourse','lang','',NULL),(51,0,1663307064,'moodlecourse','newsitems','5',NULL),(52,0,1663307064,'moodlecourse','showgrades','1',NULL),(53,0,1663307064,'moodlecourse','showreports','0',NULL),(54,0,1663307064,'moodlecourse','showactivitydates','1',NULL),(55,0,1663307064,'moodlecourse','maxbytes','0',NULL),(56,0,1663307064,'moodlecourse','enablecompletion','1',NULL),(57,0,1663307064,'moodlecourse','showcompletionconditions','1',NULL),(58,0,1663307064,'moodlecourse','groupmode','0',NULL),(59,0,1663307064,'moodlecourse','groupmodeforce','0',NULL),(60,0,1663307064,NULL,'downloadcoursecontentallowed','0',NULL),(61,0,1663307064,NULL,'maxsizeperdownloadcoursefile','52428800',NULL),(62,0,1663307064,NULL,'enablecourserequests','1',NULL),(63,0,1663307064,NULL,'defaultrequestcategory','1',NULL),(64,0,1663307064,NULL,'lockrequestcategory','0',NULL),(65,0,1663307064,NULL,'courserequestnotify','',NULL),(66,0,1663307064,NULL,'activitychoosertabmode','0',NULL),(67,0,1663307064,NULL,'activitychooseractivefooter','hidden',NULL),(68,0,1663307064,'backup','loglifetime','30',NULL),(69,0,1663307064,'backup','backup_general_users','1',NULL),(70,0,1663307064,'backup','backup_general_users_locked','',NULL),(71,0,1663307064,'backup','backup_general_anonymize','0',NULL),(72,0,1663307064,'backup','backup_general_anonymize_locked','',NULL),(73,0,1663307064,'backup','backup_general_role_assignments','1',NULL),(74,0,1663307064,'backup','backup_general_role_assignments_locked','',NULL),(75,0,1663307064,'backup','backup_general_activities','1',NULL),(76,0,1663307064,'backup','backup_general_activities_locked','',NULL),(77,0,1663307064,'backup','backup_general_blocks','1',NULL),(78,0,1663307064,'backup','backup_general_blocks_locked','',NULL),(79,0,1663307064,'backup','backup_general_files','1',NULL),(80,0,1663307064,'backup','backup_general_files_locked','',NULL),(81,0,1663307064,'backup','backup_general_filters','1',NULL),(82,0,1663307064,'backup','backup_general_filters_locked','',NULL),(83,0,1663307064,'backup','backup_general_comments','1',NULL),(84,0,1663307064,'backup','backup_general_comments_locked','',NULL),(85,0,1663307064,'backup','backup_general_badges','1',NULL),(86,0,1663307064,'backup','backup_general_badges_locked','',NULL),(87,0,1663307064,'backup','backup_general_calendarevents','1',NULL),(88,0,1663307064,'backup','backup_general_calendarevents_locked','',NULL),(89,0,1663307064,'backup','backup_general_userscompletion','1',NULL),(90,0,1663307064,'backup','backup_general_userscompletion_locked','',NULL),(91,0,1663307064,'backup','backup_general_logs','0',NULL),(92,0,1663307064,'backup','backup_general_logs_locked','',NULL),(93,0,1663307064,'backup','backup_general_histories','0',NULL),(94,0,1663307064,'backup','backup_general_histories_locked','',NULL),(95,0,1663307064,'backup','backup_general_questionbank','1',NULL),(96,0,1663307064,'backup','backup_general_questionbank_locked','',NULL),(97,0,1663307064,'backup','backup_general_groups','1',NULL),(98,0,1663307064,'backup','backup_general_groups_locked','',NULL),(99,0,1663307064,'backup','backup_general_competencies','1',NULL),(100,0,1663307064,'backup','backup_general_competencies_locked','',NULL),(101,0,1663307064,'backup','backup_general_contentbankcontent','1',NULL),(102,0,1663307064,'backup','backup_general_contentbankcontent_locked','',NULL),(103,0,1663307064,'backup','backup_general_legacyfiles','1',NULL),(104,0,1663307064,'backup','backup_general_legacyfiles_locked','',NULL),(105,0,1663307064,'backup','import_general_maxresults','10',NULL),(106,0,1663307064,'backup','import_general_duplicate_admin_allowed','0',NULL),(107,0,1663307064,'backup','backup_import_permissions','0',NULL),(108,0,1663307064,'backup','backup_import_permissions_locked','',NULL),(109,0,1663307064,'backup','backup_import_activities','1',NULL),(110,0,1663307064,'backup','backup_import_activities_locked','',NULL),(111,0,1663307064,'backup','backup_import_blocks','1',NULL),(112,0,1663307064,'backup','backup_import_blocks_locked','',NULL),(113,0,1663307064,'backup','backup_import_filters','1',NULL),(114,0,1663307064,'backup','backup_import_filters_locked','',NULL),(115,0,1663307064,'backup','backup_import_calendarevents','1',NULL),(116,0,1663307064,'backup','backup_import_calendarevents_locked','',NULL),(117,0,1663307064,'backup','backup_import_questionbank','1',NULL),(118,0,1663307064,'backup','backup_import_questionbank_locked','',NULL),(119,0,1663307064,'backup','backup_import_groups','1',NULL),(120,0,1663307064,'backup','backup_import_groups_locked','',NULL),(121,0,1663307064,'backup','backup_import_competencies','1',NULL),(122,0,1663307064,'backup','backup_import_competencies_locked','',NULL),(123,0,1663307064,'backup','backup_import_contentbankcontent','1',NULL),(124,0,1663307064,'backup','backup_import_contentbankcontent_locked','',NULL),(125,0,1663307064,'backup','backup_import_legacyfiles','1',NULL),(126,0,1663307064,'backup','backup_import_legacyfiles_locked','',NULL),(127,0,1663307064,'backup','backup_auto_active','0',NULL),(128,0,1663307064,'backup','backup_auto_weekdays','0000000',NULL),(129,0,1663307064,'backup','backup_auto_hour','0',NULL),(130,0,1663307064,'backup','backup_auto_minute','0',NULL),(131,0,1663307064,'backup','backup_auto_storage','0',NULL),(132,0,1663307064,'backup','backup_auto_destination','',NULL),(133,0,1663307064,'backup','backup_auto_max_kept','1',NULL),(134,0,1663307064,'backup','backup_auto_delete_days','0',NULL),(135,0,1663307064,'backup','backup_auto_min_kept','0',NULL),(136,0,1663307064,'backup','backup_shortname','0',NULL),(137,0,1663307064,'backup','backup_auto_skip_hidden','1',NULL),(138,0,1663307064,'backup','backup_auto_skip_modif_days','30',NULL),(139,0,1663307064,'backup','backup_auto_skip_modif_prev','0',NULL),(140,0,1663307064,'backup','backup_auto_users','1',NULL),(141,0,1663307064,'backup','backup_auto_role_assignments','1',NULL),(142,0,1663307064,'backup','backup_auto_activities','1',NULL),(143,0,1663307064,'backup','backup_auto_blocks','1',NULL),(144,0,1663307064,'backup','backup_auto_files','1',NULL),(145,0,1663307064,'backup','backup_auto_filters','1',NULL),(146,0,1663307064,'backup','backup_auto_comments','1',NULL),(147,0,1663307064,'backup','backup_auto_badges','1',NULL),(148,0,1663307064,'backup','backup_auto_calendarevents','1',NULL),(149,0,1663307064,'backup','backup_auto_userscompletion','1',NULL),(150,0,1663307064,'backup','backup_auto_logs','0',NULL),(151,0,1663307064,'backup','backup_auto_histories','0',NULL),(152,0,1663307064,'backup','backup_auto_questionbank','1',NULL),(153,0,1663307064,'backup','backup_auto_groups','1',NULL),(154,0,1663307064,'backup','backup_auto_competencies','1',NULL),(155,0,1663307064,'backup','backup_auto_contentbankcontent','1',NULL),(156,0,1663307064,'backup','backup_auto_legacyfiles','1',NULL),(157,0,1663307064,'restore','restore_general_users','1',NULL),(158,0,1663307064,'restore','restore_general_users_locked','',NULL),(159,0,1663307064,'restore','restore_general_enrolments','1',NULL),(160,0,1663307064,'restore','restore_general_enrolments_locked','',NULL),(161,0,1663307064,'restore','restore_general_role_assignments','1',NULL),(162,0,1663307064,'restore','restore_general_role_assignments_locked','',NULL),(163,0,1663307064,'restore','restore_general_permissions','1',NULL),(164,0,1663307064,'restore','restore_general_permissions_locked','',NULL),(165,0,1663307064,'restore','restore_general_activities','1',NULL),(166,0,1663307064,'restore','restore_general_activities_locked','',NULL),(167,0,1663307064,'restore','restore_general_blocks','1',NULL),(168,0,1663307064,'restore','restore_general_blocks_locked','',NULL),(169,0,1663307064,'restore','restore_general_filters','1',NULL),(170,0,1663307064,'restore','restore_general_filters_locked','',NULL),(171,0,1663307064,'restore','restore_general_comments','1',NULL),(172,0,1663307064,'restore','restore_general_comments_locked','',NULL),(173,0,1663307064,'restore','restore_general_badges','1',NULL),(174,0,1663307064,'restore','restore_general_badges_locked','',NULL),(175,0,1663307064,'restore','restore_general_calendarevents','1',NULL),(176,0,1663307064,'restore','restore_general_calendarevents_locked','',NULL),(177,0,1663307064,'restore','restore_general_userscompletion','1',NULL),(178,0,1663307064,'restore','restore_general_userscompletion_locked','',NULL),(179,0,1663307064,'restore','restore_general_logs','1',NULL),(180,0,1663307064,'restore','restore_general_logs_locked','',NULL),(181,0,1663307064,'restore','restore_general_histories','1',NULL),(182,0,1663307064,'restore','restore_general_histories_locked','',NULL),(183,0,1663307064,'restore','restore_general_groups','1',NULL),(184,0,1663307064,'restore','restore_general_groups_locked','',NULL),(185,0,1663307064,'restore','restore_general_competencies','1',NULL),(186,0,1663307064,'restore','restore_general_competencies_locked','',NULL),(187,0,1663307064,'restore','restore_general_contentbankcontent','1',NULL),(188,0,1663307064,'restore','restore_general_contentbankcontent_locked','',NULL),(189,0,1663307064,'restore','restore_general_legacyfiles','1',NULL),(190,0,1663307064,'restore','restore_general_legacyfiles_locked','',NULL),(191,0,1663307064,'restore','restore_merge_overwrite_conf','0',NULL),(192,0,1663307064,'restore','restore_merge_overwrite_conf_locked','',NULL),(193,0,1663307064,'restore','restore_merge_course_fullname','1',NULL),(194,0,1663307064,'restore','restore_merge_course_fullname_locked','',NULL),(195,0,1663307064,'restore','restore_merge_course_shortname','1',NULL),(196,0,1663307064,'restore','restore_merge_course_shortname_locked','',NULL),(197,0,1663307064,'restore','restore_merge_course_startdate','1',NULL),(198,0,1663307064,'restore','restore_merge_course_startdate_locked','',NULL),(199,0,1663307064,'restore','restore_replace_overwrite_conf','0',NULL),(200,0,1663307064,'restore','restore_replace_overwrite_conf_locked','',NULL),(201,0,1663307064,'restore','restore_replace_course_fullname','1',NULL),(202,0,1663307064,'restore','restore_replace_course_fullname_locked','',NULL),(203,0,1663307064,'restore','restore_replace_course_shortname','1',NULL),(204,0,1663307064,'restore','restore_replace_course_shortname_locked','',NULL),(205,0,1663307064,'restore','restore_replace_course_startdate','1',NULL),(206,0,1663307064,'restore','restore_replace_course_startdate_locked','',NULL),(207,0,1663307064,'restore','restore_replace_keep_roles_and_enrolments','0',NULL),(208,0,1663307064,'restore','restore_replace_keep_roles_and_enrolments_locked','',NULL),(209,0,1663307064,'restore','restore_replace_keep_groups_and_groupings','0',NULL),(210,0,1663307064,'restore','restore_replace_keep_groups_and_groupings_locked','',NULL),(211,0,1663307064,NULL,'enableasyncbackup','0',NULL),(212,0,1663307064,'backup','backup_async_message_users','0',NULL),(213,0,1663307064,'backup','backup_async_message_subject','Moodle {operation} completed successfully',NULL),(214,0,1663307064,'backup','backup_async_message','Hi {user_firstname},<br/> Your {operation} (ID: {backupid}) has completed successfully. <br/><br/>You can access it here: {link}.',NULL),(215,0,1663307064,NULL,'grade_profilereport','user',NULL),(216,0,1663307064,NULL,'grade_aggregationposition','1',NULL),(217,0,1663307064,NULL,'grade_includescalesinaggregation','1',NULL),(218,0,1663307064,NULL,'grade_hiddenasdate','0',NULL),(219,0,1663307064,NULL,'gradepublishing','0',NULL),(220,0,1663307064,NULL,'grade_export_exportfeedback','0',NULL),(221,0,1663307064,NULL,'grade_export_displaytype','1',NULL),(222,0,1663307064,NULL,'grade_export_decimalpoints','2',NULL),(223,0,1663307064,NULL,'grade_navmethod','1',NULL),(224,0,1663307064,NULL,'grade_export_userprofilefields','firstname,lastname,idnumber,institution,department,email',NULL),(225,0,1663307064,NULL,'grade_export_customprofilefields','',NULL),(226,0,1663307064,NULL,'recovergradesdefault','0',NULL),(227,0,1663307064,NULL,'gradeexport','',NULL),(228,0,1663307064,NULL,'unlimitedgrades','0',NULL),(229,0,1663307064,NULL,'grade_report_showmin','1',NULL),(230,0,1663307064,NULL,'gradepointmax','100',NULL),(231,0,1663307064,NULL,'gradepointdefault','100',NULL),(232,0,1663307064,NULL,'grade_minmaxtouse','1',NULL),(233,0,1663307064,NULL,'grade_mygrades_report','overview',NULL),(234,0,1663307064,NULL,'gradereport_mygradeurl','',NULL),(235,0,1663307064,NULL,'grade_hideforcedsettings','1',NULL),(236,0,1663307064,NULL,'grade_aggregation','13',NULL),(237,0,1663307064,NULL,'grade_aggregation_flag','0',NULL),(238,0,1663307064,NULL,'grade_aggregations_visible','13',NULL),(239,0,1663307064,NULL,'grade_aggregateonlygraded','1',NULL),(240,0,1663307064,NULL,'grade_aggregateonlygraded_flag','2',NULL),(241,0,1663307064,NULL,'grade_aggregateoutcomes','0',NULL),(242,0,1663307064,NULL,'grade_aggregateoutcomes_flag','2',NULL),(243,0,1663307064,NULL,'grade_keephigh','0',NULL),(244,0,1663307064,NULL,'grade_keephigh_flag','3',NULL),(245,0,1663307064,NULL,'grade_droplow','0',NULL),(246,0,1663307064,NULL,'grade_droplow_flag','2',NULL),(247,0,1663307064,NULL,'grade_overridecat','1',NULL),(248,0,1663307064,NULL,'grade_displaytype','1',NULL),(249,0,1663307064,NULL,'grade_decimalpoints','2',NULL),(250,0,1663307064,NULL,'grade_item_advanced','iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime',NULL),(251,0,1663307064,NULL,'grade_report_studentsperpage','100',NULL),(252,0,1663307064,NULL,'grade_report_showonlyactiveenrol','1',NULL),(253,0,1663307064,NULL,'grade_report_quickgrading','1',NULL),(254,0,1663307064,NULL,'grade_report_showquickfeedback','0',NULL),(255,0,1663307064,NULL,'grade_report_meanselection','1',NULL),(256,0,1663307064,NULL,'grade_report_enableajax','0',NULL),(257,0,1663307064,NULL,'grade_report_showcalculations','1',NULL),(258,0,1663307064,NULL,'grade_report_showeyecons','0',NULL),(259,0,1663307064,NULL,'grade_report_showaverages','1',NULL),(260,0,1663307064,NULL,'grade_report_showlocks','0',NULL),(261,0,1663307064,NULL,'grade_report_showranges','0',NULL),(262,0,1663307064,NULL,'grade_report_showanalysisicon','1',NULL),(263,0,1663307064,NULL,'grade_report_showuserimage','1',NULL),(264,0,1663307064,NULL,'grade_report_showactivityicons','1',NULL),(265,0,1663307064,NULL,'grade_report_shownumberofgrades','0',NULL),(266,0,1663307064,NULL,'grade_report_averagesdisplaytype','inherit',NULL),(267,0,1663307065,NULL,'grade_report_rangesdisplaytype','inherit',NULL),(268,0,1663307065,NULL,'grade_report_averagesdecimalpoints','inherit',NULL),(269,0,1663307065,NULL,'grade_report_rangesdecimalpoints','inherit',NULL),(270,0,1663307065,NULL,'grade_report_historyperpage','50',NULL),(271,0,1663307065,NULL,'grade_report_overview_showrank','0',NULL),(272,0,1663307065,NULL,'grade_report_overview_showtotalsifcontainhidden','0',NULL),(273,0,1663307065,NULL,'grade_report_user_showrank','0',NULL),(274,0,1663307065,NULL,'grade_report_user_showpercentage','1',NULL),(275,0,1663307065,NULL,'grade_report_user_showgrade','1',NULL),(276,0,1663307065,NULL,'grade_report_user_showfeedback','1',NULL),(277,0,1663307065,NULL,'grade_report_user_showrange','1',NULL),(278,0,1663307065,NULL,'grade_report_user_showweight','1',NULL),(279,0,1663307065,NULL,'grade_report_user_showaverage','0',NULL),(280,0,1663307065,NULL,'grade_report_user_showlettergrade','0',NULL),(281,0,1663307065,NULL,'grade_report_user_rangedecimals','0',NULL),(282,0,1663307065,NULL,'grade_report_user_showhiddenitems','1',NULL),(283,0,1663307065,NULL,'grade_report_user_showtotalsifcontainhidden','0',NULL),(284,0,1663307065,NULL,'grade_report_user_showcontributiontocoursetotal','1',NULL),(285,0,1663307065,'analytics','modeinstruction','',NULL),(286,0,1663307065,'analytics','percentonline','0',NULL),(287,0,1663307065,'analytics','typeinstitution','',NULL),(288,0,1663307065,'analytics','levelinstitution','',NULL),(289,0,1663307065,'analytics','predictionsprocessor','\\mlbackend_php\\processor',NULL),(290,0,1663307065,'analytics','defaulttimesplittingsevaluation','\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range',NULL),(291,0,1663307065,'analytics','modeloutputdir','',NULL),(292,0,1663307065,'analytics','onlycli','1',NULL),(293,0,1663307065,'analytics','modeltimelimit','1200',NULL),(294,0,1663307065,'analytics','calclifetime','35',NULL),(295,0,1663307065,'core_competency','enabled','1',NULL),(296,0,1663307065,'core_competency','pushcourseratingstouserplans','1',NULL),(297,0,1663307065,NULL,'badges_defaultissuername','',NULL),(298,0,1663307065,NULL,'badges_defaultissuercontact','',NULL),(299,0,1663307065,NULL,'badges_badgesalt','badges1663307057',NULL),(300,0,1663307065,NULL,'badges_allowcoursebadges','1',NULL),(301,0,1663307065,NULL,'badges_allowexternalbackpack','1',NULL),(302,0,1663307065,NULL,'rememberuserlicensepref','1',NULL),(303,0,1663307065,NULL,'timezone','Europe/London',NULL),(304,0,1663307066,NULL,'forcetimezone','99',NULL),(305,0,1663307066,NULL,'country','0',NULL),(306,0,1663307066,NULL,'defaultcity','',NULL),(307,0,1663307066,NULL,'geoip2file','/var/www/m2/m2_moodle/geoip/GeoLite2-City.mmdb',NULL),(308,0,1663307066,NULL,'googlemapkey3','',NULL),(309,0,1663307066,NULL,'allcountrycodes','',NULL),(310,0,1663307066,NULL,'autolang','1',NULL),(311,0,1663307066,NULL,'lang','en',NULL),(312,0,1663307066,NULL,'autolangusercreation','1',NULL),(313,0,1663307066,NULL,'langmenu','1',NULL),(314,0,1663307066,NULL,'langlist','',NULL),(315,0,1663307066,NULL,'langcache','1',NULL),(316,0,1663307066,NULL,'langstringcache','1',NULL),(317,0,1663307066,NULL,'locale','',NULL),(318,0,1663307066,NULL,'latinexcelexport','0',NULL),(319,0,1663307066,NULL,'messaging','1',NULL),(320,0,1663307066,NULL,'messagingallusers','0',NULL),(321,0,1663307066,NULL,'messagingdefaultpressenter','1',NULL),(322,0,1663307066,NULL,'messagingdeletereadnotificationsdelay','604800',NULL),(323,0,1663307066,NULL,'messagingdeleteallnotificationsdelay','2620800',NULL),(324,0,1663307066,NULL,'messagingallowemailoverride','0',NULL),(325,0,1663307066,NULL,'requiremodintro','0',NULL),(326,0,1663307066,'antivirus','notifyemail','',NULL),(327,0,1663307066,'antivirus','enablequarantine','0',NULL),(328,0,1663307066,'antivirus','quarantinetime','2419200',NULL),(329,0,1663307066,NULL,'registerauth','',NULL),(330,0,1663307066,NULL,'authloginviaemail','0',NULL),(331,0,1663307066,NULL,'allowaccountssameemail','0',NULL),(332,0,1663307066,NULL,'authpreventaccountcreation','0',NULL),(333,0,1663307066,NULL,'loginpageautofocus','0',NULL),(334,0,1663307066,NULL,'guestloginbutton','1',NULL),(335,0,1663307066,NULL,'limitconcurrentlogins','0',NULL),(336,0,1663307066,NULL,'alternateloginurl','',NULL),(337,0,1663307066,NULL,'forgottenpasswordurl','',NULL),(338,0,1663307066,NULL,'auth_instructions','',NULL),(339,0,1663307066,NULL,'allowemailaddresses','',NULL),(340,0,1663307066,NULL,'denyemailaddresses','',NULL),(341,0,1663307066,NULL,'verifychangedemail','1',NULL),(342,0,1663307066,NULL,'recaptchapublickey','',NULL),(343,0,1663307066,NULL,'recaptchaprivatekey','',NULL),(344,0,1663307066,'cachestore_apcu','testperformance','0',NULL),(345,0,1663307066,'cachestore_memcached','testservers','',NULL),(346,0,1663307066,'cachestore_mongodb','testserver','',NULL),(347,0,1663307066,'cachestore_redis','test_server','',NULL),(348,0,1663307066,'cachestore_redis','test_password','',NULL),(349,0,1663307066,NULL,'filteruploadedfiles','0',NULL),(350,0,1663307066,NULL,'filtermatchoneperpage','0',NULL),(351,0,1663307066,NULL,'filtermatchonepertext','0',NULL),(352,0,1663307066,NULL,'media_default_width','400',NULL),(353,0,1663307066,NULL,'media_default_height','300',NULL),(354,0,1663307066,NULL,'portfolio_moderate_filesize_threshold','1048576',NULL),(355,0,1663307066,NULL,'portfolio_high_filesize_threshold','5242880',NULL),(356,0,1663307066,NULL,'portfolio_moderate_db_threshold','20',NULL),(357,0,1663307066,NULL,'portfolio_high_db_threshold','50',NULL),(358,0,1663307066,'question_preview','behaviour','deferredfeedback',NULL),(359,0,1663307066,'question_preview','correctness','1',NULL),(360,0,1663307066,'question_preview','marks','2',NULL),(361,0,1663307066,'question_preview','markdp','2',NULL),(362,0,1663307066,'question_preview','feedback','1',NULL),(363,0,1663307066,'question_preview','generalfeedback','1',NULL),(364,0,1663307066,'question_preview','rightanswer','1',NULL),(365,0,1663307066,'question_preview','history','0',NULL),(366,0,1663307066,NULL,'repositorycacheexpire','120',NULL),(367,0,1663307066,NULL,'repositorygetfiletimeout','30',NULL),(368,0,1663307066,NULL,'repositorysyncfiletimeout','1',NULL),(369,0,1663307066,NULL,'repositorysyncimagetimeout','3',NULL),(370,0,1663307066,NULL,'repositoryallowexternallinks','1',NULL),(371,0,1663307066,NULL,'legacyfilesinnewcourses','0',NULL),(372,0,1663307066,NULL,'legacyfilesaddallowed','1',NULL),(373,0,1663307066,NULL,'searchengine','simpledb',NULL),(374,0,1663307066,NULL,'searchindexwhendisabled','0',NULL),(375,0,1663307066,NULL,'searchindextime','600',NULL),(376,0,1663307066,NULL,'searchallavailablecourses','0',NULL),(377,0,1663307066,NULL,'searchincludeallcourses','0',NULL),(378,0,1663307066,NULL,'searchenablecategories','0',NULL),(379,0,1663307066,NULL,'searchdefaultcategory','core-all',NULL),(380,0,1663307066,NULL,'searchhideallcategory','0',NULL),(381,0,1663307066,NULL,'searchenginequeryonly','',NULL),(382,0,1663307066,NULL,'searchbannerenable','0',NULL),(383,0,1663307066,NULL,'searchbanner','',NULL),(384,0,1663307066,NULL,'allowbeforeblock','0',NULL),(385,0,1663307066,NULL,'allowedip','',NULL),(386,0,1663307066,NULL,'blockedip','',NULL),(387,0,1663307066,NULL,'protectusernames','1',NULL),(388,0,1663307066,NULL,'forcelogin','0',NULL),(389,0,1663307066,NULL,'forceloginforprofiles','1',NULL),(390,0,1663307066,NULL,'forceloginforprofileimage','0',NULL),(391,0,1663307066,NULL,'opentowebcrawlers','0',NULL),(392,0,1663307066,NULL,'allowindexing','0',NULL),(393,0,1663307066,NULL,'maxbytes','0',NULL),(394,0,1663307066,NULL,'userquota','104857600',NULL),(395,0,1663307066,NULL,'allowobjectembed','0',NULL),(396,0,1663307066,NULL,'enabletrusttext','0',NULL),(397,0,1663307066,NULL,'maxeditingtime','1800',NULL),(398,0,1663307066,NULL,'extendedusernamechars','0',NULL),(399,0,1663307066,NULL,'keeptagnamecase','1',NULL),(400,0,1663307066,NULL,'profilesforenrolledusersonly','1',NULL),(401,0,1663307066,NULL,'cronclionly','1',NULL),(402,0,1663307066,NULL,'cronremotepassword','',NULL),(403,0,1663307066,'tool_task','enablerunnow','1',NULL),(404,0,1663307066,NULL,'lockoutthreshold','0',NULL),(405,0,1663307066,NULL,'lockoutwindow','1800',NULL),(406,0,1663307066,NULL,'lockoutduration','1800',NULL),(407,0,1663307066,NULL,'passwordpolicy','1',NULL),(408,0,1663307066,NULL,'minpasswordlength','8',NULL),(409,0,1663307066,NULL,'minpassworddigits','1',NULL),(410,0,1663307066,NULL,'minpasswordlower','1',NULL),(411,0,1663307066,NULL,'minpasswordupper','1',NULL),(412,0,1663307066,NULL,'minpasswordnonalphanum','1',NULL),(413,0,1663307066,NULL,'maxconsecutiveidentchars','0',NULL),(414,0,1663307066,NULL,'passwordpolicycheckonlogin','0',NULL),(415,0,1663307066,NULL,'passwordreuselimit','0',NULL),(416,0,1663307066,NULL,'pwresettime','1800',NULL),(417,0,1663307066,NULL,'passwordchangelogout','0',NULL),(418,0,1663307066,NULL,'passwordchangetokendeletion','0',NULL),(419,0,1663307066,NULL,'tokenduration','7257600',NULL),(420,0,1663307066,NULL,'groupenrolmentkeypolicy','1',NULL),(421,0,1663307066,NULL,'disableuserimages','0',NULL),(422,0,1663307066,NULL,'emailchangeconfirmation','1',NULL),(423,0,1663307066,NULL,'rememberusername','2',NULL),(424,0,1663307066,NULL,'strictformsrequired','0',NULL),(425,0,1663307066,NULL,'cookiesecure','1',NULL),(426,0,1663307066,NULL,'cookiehttponly','0',NULL),(427,0,1663307066,NULL,'allowframembedding','0',NULL),(428,0,1663307066,NULL,'curlsecurityblockedhosts','',NULL),(429,0,1663307066,NULL,'curlsecurityallowedport','',NULL),(430,0,1663307066,NULL,'referrerpolicy','default',NULL),(431,0,1663307066,NULL,'displayloginfailures','0',NULL),(432,0,1663307066,NULL,'notifyloginfailures','',NULL),(433,0,1663307066,NULL,'notifyloginthreshold','10',NULL),(434,0,1663307066,NULL,'themelist','',NULL),(435,0,1663307066,NULL,'themedesignermode','0',NULL),(436,0,1663307066,NULL,'allowuserthemes','0',NULL),(437,0,1663307066,NULL,'allowcoursethemes','0',NULL),(438,0,1663307066,NULL,'allowcategorythemes','0',NULL),(439,0,1663307066,NULL,'allowcohortthemes','0',NULL),(440,0,1663307066,NULL,'allowthemechangeonurl','0',NULL),(441,0,1663307066,NULL,'allowuserblockhiding','1',NULL),(442,0,1663307066,NULL,'langmenuinsecurelayout','0',NULL),(443,0,1663307066,NULL,'logininfoinsecurelayout','0',NULL),(444,0,1663307066,NULL,'custommenuitems','',NULL),(445,0,1663307066,NULL,'customusermenuitems','grades,grades|/grade/report/mygrades.php|t/grades\nmessages,message|/message/index.php|t/message\npreferences,moodle|/user/preferences.php|t/preferences',NULL),(446,0,1663307066,NULL,'enabledevicedetection','1',NULL),(447,0,1663307066,NULL,'devicedetectregex','[]',NULL),(448,0,1663307066,'theme_boost','preset','default.scss',NULL),(449,0,1663307066,'theme_boost','presetfiles','',NULL),(450,0,1663307066,'theme_boost','backgroundimage','',NULL),(451,0,1663307066,'theme_boost','brandcolor','',NULL),(452,0,1663307066,'theme_boost','scsspre','',NULL),(453,0,1663307066,'theme_boost','scss','',NULL),(454,0,1663307066,'theme_classic','navbardark','0',NULL),(455,0,1663307066,'theme_classic','preset','default.scss',NULL),(456,0,1663307066,'theme_classic','presetfiles','',NULL),(457,0,1663307066,'theme_classic','backgroundimage','',NULL),(458,0,1663307066,'theme_classic','brandcolor','',NULL),(459,0,1663307066,'theme_classic','scsspre','',NULL),(460,0,1663307066,'theme_classic','scss','',NULL),(461,0,1663307066,'core_admin','logo','',NULL),(462,0,1663307066,'core_admin','logocompact','',NULL),(463,0,1663307066,'core_admin','coursecolor1','#81ecec',NULL),(464,0,1663307066,'core_admin','coursecolor2','#74b9ff',NULL),(465,0,1663307066,'core_admin','coursecolor3','#a29bfe',NULL),(466,0,1663307066,'core_admin','coursecolor4','#dfe6e9',NULL),(467,0,1663307066,'core_admin','coursecolor5','#00b894',NULL),(468,0,1663307066,'core_admin','coursecolor6','#0984e3',NULL),(469,0,1663307066,'core_admin','coursecolor7','#b2bec3',NULL),(470,0,1663307066,'core_admin','coursecolor8','#fdcb6e',NULL),(471,0,1663307066,'core_admin','coursecolor9','#fd79a8',NULL),(472,0,1663307066,'core_admin','coursecolor10','#6c5ce7',NULL),(473,0,1663307066,NULL,'calendartype','gregorian',NULL),(474,0,1663307066,NULL,'calendar_adminseesall','0',NULL),(475,0,1663307066,NULL,'calendar_site_timeformat','0',NULL),(476,0,1663307066,NULL,'calendar_startwday','1',NULL),(477,0,1663307067,NULL,'calendar_weekend','65',NULL),(478,0,1663307067,NULL,'calendar_lookahead','21',NULL),(479,0,1663307067,NULL,'calendar_maxevents','10',NULL),(480,0,1663307067,NULL,'enablecalendarexport','1',NULL),(481,0,1663307067,NULL,'calendar_customexport','1',NULL),(482,0,1663307067,NULL,'calendar_exportlookahead','365',NULL),(483,0,1663307067,NULL,'calendar_exportlookback','5',NULL),(484,0,1663307067,NULL,'calendar_exportsalt','MelIt6RcsY7w2LZv9y6T3vLny5QUuBmEveYlxqe5yLefhrZ7pdoP2YlLiaT5',NULL),(485,0,1663307067,NULL,'calendar_showicalsource','1',NULL),(486,0,1663307067,NULL,'useblogassociations','1',NULL),(487,0,1663307067,NULL,'bloglevel','4',NULL),(488,0,1663307067,NULL,'useexternalblogs','1',NULL),(489,0,1663307067,NULL,'externalblogcrontime','86400',NULL),(490,0,1663307067,NULL,'maxexternalblogsperuser','1',NULL),(491,0,1663307067,NULL,'blogusecomments','1',NULL),(492,0,1663307067,NULL,'blogshowcommentscount','1',NULL),(493,0,1663307067,NULL,'defaulthomepage','1',NULL),(494,0,1663307067,NULL,'allowguestmymoodle','1',NULL),(495,0,1663307067,NULL,'navshowfullcoursenames','0',NULL),(496,0,1663307067,NULL,'navshowcategories','1',NULL),(497,0,1663307067,NULL,'navshowmycoursecategories','0',NULL),(498,0,1663307067,NULL,'navshowallcourses','0',NULL),(499,0,1663307067,NULL,'navsortmycoursessort','sortorder',NULL),(500,0,1663307067,NULL,'navsortmycourseshiddenlast','1',NULL),(501,0,1663307067,NULL,'navcourselimit','10',NULL),(502,0,1663307067,NULL,'usesitenameforsitepages','0',NULL),(503,0,1663307067,NULL,'linkadmincategories','1',NULL),(504,0,1663307067,NULL,'linkcoursesections','1',NULL),(505,0,1663307067,NULL,'navshowfrontpagemods','1',NULL),(506,0,1663307067,NULL,'navadduserpostslinks','1',NULL),(507,0,1663307067,NULL,'formatstringstriptags','1',NULL),(508,0,1663307067,NULL,'emoticons','[{\"text\":\":-)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":)\",\"imagename\":\"s\\/smiley\",\"imagecomponent\":\"core\",\"altidentifier\":\"smiley\",\"altcomponent\":\"core_pix\"},{\"text\":\":-D\",\"imagename\":\"s\\/biggrin\",\"imagecomponent\":\"core\",\"altidentifier\":\"biggrin\",\"altcomponent\":\"core_pix\"},{\"text\":\";-)\",\"imagename\":\"s\\/wink\",\"imagecomponent\":\"core\",\"altidentifier\":\"wink\",\"altcomponent\":\"core_pix\"},{\"text\":\":-\\/\",\"imagename\":\"s\\/mixed\",\"imagecomponent\":\"core\",\"altidentifier\":\"mixed\",\"altcomponent\":\"core_pix\"},{\"text\":\"V-.\",\"imagename\":\"s\\/thoughtful\",\"imagecomponent\":\"core\",\"altidentifier\":\"thoughtful\",\"altcomponent\":\"core_pix\"},{\"text\":\":-P\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\":-p\",\"imagename\":\"s\\/tongueout\",\"imagecomponent\":\"core\",\"altidentifier\":\"tongueout\",\"altcomponent\":\"core_pix\"},{\"text\":\"B-)\",\"imagename\":\"s\\/cool\",\"imagecomponent\":\"core\",\"altidentifier\":\"cool\",\"altcomponent\":\"core_pix\"},{\"text\":\"^-)\",\"imagename\":\"s\\/approve\",\"imagecomponent\":\"core\",\"altidentifier\":\"approve\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-)\",\"imagename\":\"s\\/wideeyes\",\"imagecomponent\":\"core\",\"altidentifier\":\"wideeyes\",\"altcomponent\":\"core_pix\"},{\"text\":\":o)\",\"imagename\":\"s\\/clown\",\"imagecomponent\":\"core\",\"altidentifier\":\"clown\",\"altcomponent\":\"core_pix\"},{\"text\":\":-(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\":(\",\"imagename\":\"s\\/sad\",\"imagecomponent\":\"core\",\"altidentifier\":\"sad\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-.\",\"imagename\":\"s\\/shy\",\"imagecomponent\":\"core\",\"altidentifier\":\"shy\",\"altcomponent\":\"core_pix\"},{\"text\":\":-I\",\"imagename\":\"s\\/blush\",\"imagecomponent\":\"core\",\"altidentifier\":\"blush\",\"altcomponent\":\"core_pix\"},{\"text\":\":-X\",\"imagename\":\"s\\/kiss\",\"imagecomponent\":\"core\",\"altidentifier\":\"kiss\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-o\",\"imagename\":\"s\\/surprise\",\"imagecomponent\":\"core\",\"altidentifier\":\"surprise\",\"altcomponent\":\"core_pix\"},{\"text\":\"P-|\",\"imagename\":\"s\\/blackeye\",\"imagecomponent\":\"core\",\"altidentifier\":\"blackeye\",\"altcomponent\":\"core_pix\"},{\"text\":\"8-[\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"(grr)\",\"imagename\":\"s\\/angry\",\"imagecomponent\":\"core\",\"altidentifier\":\"angry\",\"altcomponent\":\"core_pix\"},{\"text\":\"xx-P\",\"imagename\":\"s\\/dead\",\"imagecomponent\":\"core\",\"altidentifier\":\"dead\",\"altcomponent\":\"core_pix\"},{\"text\":\"|-.\",\"imagename\":\"s\\/sleepy\",\"imagecomponent\":\"core\",\"altidentifier\":\"sleepy\",\"altcomponent\":\"core_pix\"},{\"text\":\"}-]\",\"imagename\":\"s\\/evil\",\"imagecomponent\":\"core\",\"altidentifier\":\"evil\",\"altcomponent\":\"core_pix\"},{\"text\":\"(h)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(heart)\",\"imagename\":\"s\\/heart\",\"imagecomponent\":\"core\",\"altidentifier\":\"heart\",\"altcomponent\":\"core_pix\"},{\"text\":\"(y)\",\"imagename\":\"s\\/yes\",\"imagecomponent\":\"core\",\"altidentifier\":\"yes\",\"altcomponent\":\"core\"},{\"text\":\"(n)\",\"imagename\":\"s\\/no\",\"imagecomponent\":\"core\",\"altidentifier\":\"no\",\"altcomponent\":\"core\"},{\"text\":\"(martin)\",\"imagename\":\"s\\/martin\",\"imagecomponent\":\"core\",\"altidentifier\":\"martin\",\"altcomponent\":\"core_pix\"},{\"text\":\"( )\",\"imagename\":\"s\\/egg\",\"imagecomponent\":\"core\",\"altidentifier\":\"egg\",\"altcomponent\":\"core_pix\"}]',NULL),(509,0,1663307067,NULL,'docroot','https://docs.moodle.org',NULL),(510,0,1663307067,NULL,'doclang','',NULL),(511,0,1663307067,NULL,'doctonewwindow','0',NULL),(512,0,1663307067,NULL,'coursecontactduplicates','0',NULL),(513,0,1663307067,NULL,'courselistshortnames','0',NULL),(514,0,1663307067,NULL,'coursesperpage','20',NULL),(515,0,1663307067,NULL,'courseswithsummarieslimit','10',NULL),(516,0,1663307067,NULL,'courseoverviewfileslimit','1',NULL),(517,0,1663307067,NULL,'courseoverviewfilesext','.jpg,.gif,.png',NULL),(518,0,1663307067,NULL,'coursegraceperiodbefore','0',NULL),(519,0,1663307067,NULL,'coursegraceperiodafter','0',NULL),(520,0,1663307067,NULL,'useexternalyui','0',NULL),(521,0,1663307067,NULL,'yuicomboloading','1',NULL),(522,0,1663307067,NULL,'cachejs','1',NULL),(523,0,1663307067,NULL,'additionalhtmlhead','',NULL),(524,0,1663307067,NULL,'additionalhtmltopofbody','',NULL),(525,0,1663307067,NULL,'additionalhtmlfooter','',NULL),(526,0,1663307067,NULL,'cachetemplates','1',NULL),(527,0,1663307067,NULL,'pathtophp','',NULL),(528,0,1663307067,NULL,'pathtodu','',NULL),(529,0,1663307067,NULL,'aspellpath','',NULL),(530,0,1663307067,NULL,'pathtodot','',NULL),(531,0,1663307067,NULL,'pathtogs','/usr/bin/gs',NULL),(532,0,1663307067,NULL,'pathtopdftoppm','',NULL),(533,0,1663307067,NULL,'pathtopython','',NULL),(534,0,1663307067,NULL,'supportname','Admin User',NULL),(535,0,1663307067,NULL,'supportemail','',NULL),(536,0,1663307067,NULL,'supportpage','',NULL),(537,0,1663307067,NULL,'dbsessions','0',NULL),(538,0,1663307067,NULL,'sessiontimeoutwarning','1200',NULL),(539,0,1663307067,NULL,'sessioncookie','',NULL),(540,0,1663307067,NULL,'sessioncookiepath','',NULL),(541,0,1663307067,NULL,'sessioncookiedomain','',NULL),(542,0,1663307067,NULL,'statsfirstrun','none',NULL),(543,0,1663307067,NULL,'statsmaxruntime','0',NULL),(544,0,1663307067,NULL,'statsruntimedays','31',NULL),(545,0,1663307067,NULL,'statsuserthreshold','0',NULL),(546,0,1663307067,NULL,'slasharguments','1',NULL),(547,0,1663307067,NULL,'getremoteaddrconf','3',NULL),(548,0,1663307067,NULL,'reverseproxyignore','',NULL),(549,0,1663307067,NULL,'proxyhost','',NULL),(550,0,1663307067,NULL,'proxyport','0',NULL),(551,0,1663307067,NULL,'proxytype','HTTP',NULL),(552,0,1663307067,NULL,'proxyuser','',NULL),(553,0,1663307067,NULL,'proxypassword','',NULL),(554,0,1663307067,NULL,'proxybypass','localhost, 127.0.0.1',NULL),(555,0,1663307067,NULL,'maintenance_enabled','0',NULL),(556,0,1663307067,NULL,'maintenance_message','',NULL),(557,0,1663307067,NULL,'deleteunconfirmed','168',NULL),(558,0,1663307067,NULL,'deleteincompleteusers','0',NULL),(559,0,1663307067,NULL,'disablegradehistory','0',NULL),(560,0,1663307067,NULL,'gradehistorylifetime','0',NULL),(561,0,1663307067,NULL,'tempdatafoldercleanup','168',NULL),(562,0,1663307067,NULL,'filescleanupperiod','86400',NULL),(563,0,1663307067,NULL,'extramemorylimit','512M',NULL),(564,0,1663307067,NULL,'maxtimelimit','0',NULL),(565,0,1663307067,NULL,'curlcache','120',NULL),(566,0,1663307067,NULL,'curltimeoutkbitrate','56',NULL),(567,0,1663307067,NULL,'cron_enabled','1',NULL),(568,0,1663307067,NULL,'task_scheduled_concurrency_limit','3',NULL),(569,0,1663307067,NULL,'task_scheduled_max_runtime','1800',NULL),(570,0,1663307067,NULL,'task_adhoc_concurrency_limit','3',NULL),(571,0,1663307067,NULL,'task_adhoc_max_runtime','1800',NULL),(572,0,1663307067,NULL,'task_logmode','1',NULL),(573,0,1663307067,NULL,'task_logtostdout','1',NULL),(574,0,1663307067,NULL,'task_logretention','2419200',NULL),(575,0,1663307067,NULL,'task_logretainruns','20',NULL),(576,0,1663307067,NULL,'smtphosts','',NULL),(577,0,1663307067,NULL,'smtpsecure','',NULL),(578,0,1663307067,NULL,'smtpauthtype','LOGIN',NULL),(579,0,1663307067,NULL,'smtpuser','',NULL),(580,0,1663307067,NULL,'smtppass','',NULL),(581,0,1663307067,NULL,'smtpmaxbulk','1',NULL),(582,0,1663307067,NULL,'allowedemaildomains','',NULL),(583,0,1663307067,NULL,'divertallemailsto','',NULL),(584,0,1663307067,NULL,'divertallemailsexcept','',NULL),(585,0,1663307067,NULL,'emaildkimselector','',NULL),(586,0,1663307067,NULL,'sitemailcharset','0',NULL),(587,0,1663307067,NULL,'allowusermailcharset','0',NULL),(588,0,1663307067,NULL,'allowattachments','1',NULL),(589,0,1663307067,NULL,'mailnewline','LF',NULL),(590,0,1663307067,NULL,'emailfromvia','1',NULL),(591,0,1663307067,NULL,'emailsubjectprefix','',NULL),(592,0,1663307067,NULL,'emailheaders','',NULL),(593,0,1663307067,NULL,'updateautocheck','1',NULL),(594,0,1663307067,NULL,'updateminmaturity','200',NULL),(595,0,1663307067,NULL,'updatenotifybuilds','0',NULL),(596,0,1663307067,NULL,'enablewsdocumentation','0',NULL),(597,0,1663307067,NULL,'dndallowtextandlinks','0',NULL),(598,0,1663307067,NULL,'pathtosassc','',NULL),(599,0,1663307067,NULL,'contextlocking','0',NULL),(600,0,1663307067,NULL,'contextlockappliestoadmin','1',NULL),(601,0,1663307067,NULL,'forceclean','0',NULL),(602,0,1663307067,NULL,'enablecourserelativedates','0',NULL),(603,0,1663307067,NULL,'debug','0',NULL),(604,0,1663307067,NULL,'debugdisplay','0',NULL),(605,0,1663307067,NULL,'perfdebug','7',NULL),(606,0,1663307067,NULL,'debugstringids','0',NULL),(607,0,1663307067,NULL,'debugsqltrace','0',NULL),(608,0,1663307067,NULL,'debugvalidators','0',NULL),(609,0,1663307067,NULL,'debugpageinfo','0',NULL),(610,0,1663307067,NULL,'profilingenabled','0',NULL),(611,0,1663307067,NULL,'profilingincluded','',NULL),(612,0,1663307067,NULL,'profilingexcluded','',NULL),(613,0,1663307067,NULL,'profilingautofrec','0',NULL),(614,0,1663307067,NULL,'profilingallowme','0',NULL),(615,0,1663307067,NULL,'profilingallowall','0',NULL),(616,0,1663307067,NULL,'profilingslow','0',NULL),(617,0,1663307067,NULL,'profilinglifetime','1440',NULL),(618,0,1663307067,NULL,'profilingimportprefix','(I)',NULL),(619,0,1663307070,NULL,'calendar_exportsalt','OeOqveHewIErl85w6ZXqZZuef6TKXZAB0qAwLhWaA5BY3NCFtdnZe2fYYuvO','MelIt6RcsY7w2LZv9y6T3vLny5QUuBmEveYlxqe5yLefhrZ7pdoP2YlLiaT5'),(620,0,1663307086,'activitynames','filter_active','1',''),(621,0,1663307086,'displayh5p','filter_active','1',''),(622,0,1663307086,'emoticon','filter_active','1',''),(623,0,1663307086,'mathjaxloader','filter_active','1',''),(624,0,1663307086,'mediaplugin','filter_active','1',''),(625,0,1663307086,'urltolink','filter_active','1',''),(626,2,1663307126,NULL,'enableaccessibilitytools','1',NULL),(627,2,1663307126,NULL,'notloggedinroleid','6',NULL),(628,2,1663307126,NULL,'guestroleid','6',NULL),(629,2,1663307126,NULL,'defaultuserroleid','7',NULL),(630,2,1663307126,NULL,'creatornewroleid','3',NULL),(631,2,1663307126,NULL,'restorernewroleid','3',NULL),(632,2,1663307126,'tool_dataprivacy','contactdataprotectionofficer','0',NULL),(633,2,1663307126,'tool_dataprivacy','automaticdataexportapproval','0',NULL),(634,2,1663307126,'tool_dataprivacy','automaticdatadeletionapproval','0',NULL),(635,2,1663307126,'tool_dataprivacy','automaticdeletionrequests','1',NULL),(636,2,1663307126,'tool_dataprivacy','privacyrequestexpiry','604800',NULL),(637,2,1663307126,'tool_dataprivacy','requireallenddatesforuserdeletion','1',NULL),(638,2,1663307126,'tool_dataprivacy','showdataretentionsummary','1',NULL),(639,2,1663307126,'tool_log','exportlog','1',NULL),(640,2,1663307126,NULL,'sitepolicyhandler','',NULL),(641,2,1663307126,NULL,'gradebookroles','5',NULL),(642,2,1663307126,'analytics','logstore','logstore_standard',NULL),(643,2,1663307126,NULL,'h5plibraryhandler','h5plib_v124',NULL),(644,2,1663307126,NULL,'jabberhost','',NULL),(645,2,1663307126,NULL,'jabberserver','',NULL),(646,2,1663307126,NULL,'jabberusername','',NULL),(647,2,1663307126,NULL,'jabberpassword','',NULL),(648,2,1663307126,NULL,'jabberport','5222',NULL),(649,2,1663307126,NULL,'airnotifierurl','https://messages.moodle.net',NULL),(650,2,1663307126,NULL,'airnotifierport','443',NULL),(651,2,1663307126,NULL,'airnotifiermobileappname','com.moodle.moodlemobile',NULL),(652,2,1663307126,NULL,'airnotifierappname','commoodlemoodlemobile',NULL),(653,2,1663307126,NULL,'airnotifieraccesskey','',NULL),(654,2,1663307126,'assign','feedback_plugin_for_gradebook','assignfeedback_comments',NULL),(655,2,1663307126,'assign','showrecentsubmissions','0',NULL),(656,2,1663307126,'assign','submissionreceipts','1',NULL),(657,2,1663307126,'assign','submissionstatement','This submission is my own work, except where I have acknowledged the use of the works of other people.',NULL),(658,2,1663307126,'assign','submissionstatementteamsubmission','This submission is the work of my group, except where we have acknowledged the use of the works of other people.',NULL),(659,2,1663307126,'assign','submissionstatementteamsubmissionallsubmit','This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.',NULL),(660,2,1663307126,'assign','maxperpage','-1',NULL),(661,2,1663307126,'assign','alwaysshowdescription','1',NULL),(662,2,1663307126,'assign','alwaysshowdescription_adv','',NULL),(663,2,1663307126,'assign','alwaysshowdescription_locked','',NULL),(664,2,1663307126,'assign','allowsubmissionsfromdate','0',NULL),(665,2,1663307126,'assign','allowsubmissionsfromdate_enabled','1',NULL),(666,2,1663307126,'assign','allowsubmissionsfromdate_adv','',NULL),(667,2,1663307126,'assign','duedate','604800',NULL),(668,2,1663307126,'assign','duedate_enabled','1',NULL),(669,2,1663307126,'assign','duedate_adv','',NULL),(670,2,1663307126,'assign','cutoffdate','1209600',NULL),(671,2,1663307126,'assign','cutoffdate_enabled','',NULL),(672,2,1663307126,'assign','cutoffdate_adv','',NULL),(673,2,1663307126,'assign','gradingduedate','1209600',NULL),(674,2,1663307126,'assign','gradingduedate_enabled','1',NULL),(675,2,1663307126,'assign','gradingduedate_adv','',NULL),(676,2,1663307126,'assign','submissiondrafts','0',NULL),(677,2,1663307126,'assign','submissiondrafts_adv','',NULL),(678,2,1663307126,'assign','submissiondrafts_locked','',NULL),(679,2,1663307126,'assign','requiresubmissionstatement','0',NULL),(680,2,1663307126,'assign','requiresubmissionstatement_adv','',NULL),(681,2,1663307126,'assign','requiresubmissionstatement_locked','',NULL),(682,2,1663307126,'assign','attemptreopenmethod','none',NULL),(683,2,1663307126,'assign','attemptreopenmethod_adv','',NULL),(684,2,1663307126,'assign','attemptreopenmethod_locked','',NULL),(685,2,1663307126,'assign','maxattempts','-1',NULL),(686,2,1663307126,'assign','maxattempts_adv','',NULL),(687,2,1663307126,'assign','maxattempts_locked','',NULL),(688,2,1663307127,'assign','teamsubmission','0',NULL),(689,2,1663307127,'assign','teamsubmission_adv','',NULL),(690,2,1663307127,'assign','teamsubmission_locked','',NULL),(691,2,1663307127,'assign','preventsubmissionnotingroup','0',NULL),(692,2,1663307127,'assign','preventsubmissionnotingroup_adv','',NULL),(693,2,1663307127,'assign','preventsubmissionnotingroup_locked','',NULL),(694,2,1663307127,'assign','requireallteammemberssubmit','0',NULL),(695,2,1663307127,'assign','requireallteammemberssubmit_adv','',NULL),(696,2,1663307127,'assign','requireallteammemberssubmit_locked','',NULL),(697,2,1663307127,'assign','teamsubmissiongroupingid','',NULL),(698,2,1663307127,'assign','teamsubmissiongroupingid_adv','',NULL),(699,2,1663307127,'assign','sendnotifications','0',NULL),(700,2,1663307127,'assign','sendnotifications_adv','',NULL),(701,2,1663307127,'assign','sendnotifications_locked','',NULL),(702,2,1663307127,'assign','sendlatenotifications','0',NULL),(703,2,1663307127,'assign','sendlatenotifications_adv','',NULL),(704,2,1663307127,'assign','sendlatenotifications_locked','',NULL),(705,2,1663307127,'assign','sendstudentnotifications','1',NULL),(706,2,1663307127,'assign','sendstudentnotifications_adv','',NULL),(707,2,1663307127,'assign','sendstudentnotifications_locked','',NULL),(708,2,1663307127,'assign','blindmarking','0',NULL),(709,2,1663307127,'assign','blindmarking_adv','',NULL),(710,2,1663307127,'assign','blindmarking_locked','',NULL),(711,2,1663307127,'assign','hidegrader','0',NULL),(712,2,1663307127,'assign','hidegrader_adv','',NULL),(713,2,1663307127,'assign','hidegrader_locked','',NULL),(714,2,1663307127,'assign','markingworkflow','0',NULL),(715,2,1663307127,'assign','markingworkflow_adv','',NULL),(716,2,1663307127,'assign','markingworkflow_locked','',NULL),(717,2,1663307127,'assign','markingallocation','0',NULL),(718,2,1663307127,'assign','markingallocation_adv','',NULL),(719,2,1663307127,'assign','markingallocation_locked','',NULL),(720,2,1663307127,'assignsubmission_file','default','1',NULL),(721,2,1663307127,'assignsubmission_file','maxfiles','20',NULL),(722,2,1663307127,'assignsubmission_file','filetypes','',NULL),(723,2,1663307127,'assignsubmission_file','maxbytes','0',NULL),(724,2,1663307127,'assignsubmission_onlinetext','default','0',NULL),(725,2,1663307127,'assignfeedback_comments','default','1',NULL),(726,2,1663307127,'assignfeedback_comments','inline','0',NULL),(727,2,1663307127,'assignfeedback_comments','inline_adv','',NULL),(728,2,1663307127,'assignfeedback_comments','inline_locked','',NULL),(729,2,1663307127,'assignfeedback_editpdf','default','1',NULL),(730,2,1663307127,'assignfeedback_editpdf','stamps','',NULL),(731,2,1663307127,'assignfeedback_file','default','0',NULL),(732,2,1663307127,'assignfeedback_offline','default','0',NULL),(733,2,1663307127,'book','numberingoptions','0,1,2,3',NULL),(734,2,1663307127,'book','navoptions','0,1,2',NULL),(735,2,1663307127,'book','numbering','1',NULL),(736,2,1663307127,'book','navstyle','1',NULL),(737,2,1663307127,NULL,'chat_method','ajax',NULL),(738,2,1663307127,NULL,'chat_refresh_userlist','10',NULL),(739,2,1663307127,NULL,'chat_old_ping','35',NULL),(740,2,1663307127,NULL,'chat_refresh_room','5',NULL),(741,2,1663307127,NULL,'chat_normal_updatemode','jsupdate',NULL),(742,2,1663307127,NULL,'chat_serverhost','148.72.245.159',NULL),(743,2,1663307127,NULL,'chat_serverip','127.0.0.1',NULL),(744,2,1663307127,NULL,'chat_serverport','9111',NULL),(745,2,1663307127,NULL,'chat_servermax','100',NULL),(746,2,1663307127,NULL,'data_enablerssfeeds','0',NULL),(747,2,1663307127,NULL,'feedback_allowfullanonymous','0',NULL),(748,2,1663307127,'resource','framesize','130',NULL),(749,2,1663307127,'resource','displayoptions','0,1,4,5,6',NULL),(750,2,1663307127,'resource','printintro','1',NULL),(751,2,1663307127,'resource','display','0',NULL),(752,2,1663307127,'resource','showsize','0',NULL),(753,2,1663307127,'resource','showtype','0',NULL),(754,2,1663307127,'resource','showdate','0',NULL),(755,2,1663307127,'resource','popupwidth','620',NULL),(756,2,1663307127,'resource','popupheight','450',NULL),(757,2,1663307127,'resource','filterfiles','0',NULL),(758,2,1663307127,'folder','showexpanded','1',NULL),(759,2,1663307127,'folder','maxsizetodownload','0',NULL),(760,2,1663307127,NULL,'forum_displaymode','3',NULL),(761,2,1663307127,NULL,'forum_shortpost','300',NULL),(762,2,1663307127,NULL,'forum_longpost','600',NULL),(763,2,1663307127,NULL,'forum_manydiscussions','100',NULL),(764,2,1663307127,NULL,'forum_maxbytes','512000',NULL),(765,2,1663307127,NULL,'forum_maxattachments','9',NULL),(766,2,1663307127,NULL,'forum_subscription','0',NULL),(767,2,1663307127,NULL,'forum_trackingtype','1',NULL),(768,2,1663307127,NULL,'forum_trackreadposts','1',NULL),(769,2,1663307127,NULL,'forum_allowforcedreadtracking','0',NULL),(770,2,1663307127,NULL,'forum_oldpostdays','14',NULL),(771,2,1663307127,NULL,'forum_usermarksread','0',NULL),(772,2,1663307127,NULL,'forum_cleanreadtime','2',NULL),(773,2,1663307127,NULL,'digestmailtime','17',NULL),(774,2,1663307127,NULL,'forum_enablerssfeeds','0',NULL),(775,2,1663307127,NULL,'forum_enabletimedposts','1',NULL),(776,2,1663307127,NULL,'glossary_entbypage','10',NULL),(777,2,1663307127,NULL,'glossary_dupentries','0',NULL),(778,2,1663307127,NULL,'glossary_allowcomments','0',NULL),(779,2,1663307127,NULL,'glossary_linkbydefault','1',NULL),(780,2,1663307127,NULL,'glossary_defaultapproval','1',NULL),(781,2,1663307127,NULL,'glossary_enablerssfeeds','0',NULL),(782,2,1663307127,NULL,'glossary_linkentries','0',NULL),(783,2,1663307127,NULL,'glossary_casesensitive','0',NULL),(784,2,1663307127,NULL,'glossary_fullmatch','0',NULL),(785,2,1663307127,'imscp','keepold','1',NULL),(786,2,1663307127,'imscp','keepold_adv','',NULL),(787,2,1663307127,'label','dndmedia','1',NULL),(788,2,1663307127,'label','dndresizewidth','400',NULL),(789,2,1663307127,'label','dndresizeheight','400',NULL),(790,2,1663307127,'mod_lesson','mediafile','',NULL),(791,2,1663307127,'mod_lesson','mediafile_adv','1',NULL),(792,2,1663307127,'mod_lesson','mediawidth','640',NULL),(793,2,1663307127,'mod_lesson','mediaheight','480',NULL),(794,2,1663307127,'mod_lesson','mediaclose','0',NULL),(795,2,1663307127,'mod_lesson','progressbar','0',NULL),(796,2,1663307127,'mod_lesson','progressbar_adv','',NULL),(797,2,1663307127,'mod_lesson','ongoing','0',NULL),(798,2,1663307127,'mod_lesson','ongoing_adv','1',NULL),(799,2,1663307127,'mod_lesson','displayleftmenu','0',NULL),(800,2,1663307127,'mod_lesson','displayleftmenu_adv','',NULL),(801,2,1663307127,'mod_lesson','displayleftif','0',NULL),(802,2,1663307127,'mod_lesson','displayleftif_adv','1',NULL),(803,2,1663307127,'mod_lesson','slideshow','0',NULL),(804,2,1663307127,'mod_lesson','slideshow_adv','1',NULL),(805,2,1663307127,'mod_lesson','slideshowwidth','640',NULL),(806,2,1663307127,'mod_lesson','slideshowheight','480',NULL),(807,2,1663307127,'mod_lesson','slideshowbgcolor','#FFFFFF',NULL),(808,2,1663307127,'mod_lesson','maxanswers','5',NULL),(809,2,1663307127,'mod_lesson','maxanswers_adv','1',NULL),(810,2,1663307127,'mod_lesson','defaultfeedback','0',NULL),(811,2,1663307127,'mod_lesson','defaultfeedback_adv','1',NULL),(812,2,1663307127,'mod_lesson','activitylink','',NULL),(813,2,1663307127,'mod_lesson','activitylink_adv','1',NULL),(814,2,1663307127,'mod_lesson','timelimit','0',NULL),(815,2,1663307127,'mod_lesson','timelimit_adv','',NULL),(816,2,1663307127,'mod_lesson','password','0',NULL),(817,2,1663307127,'mod_lesson','password_adv','1',NULL),(818,2,1663307127,'mod_lesson','modattempts','0',NULL),(819,2,1663307127,'mod_lesson','modattempts_adv','',NULL),(820,2,1663307127,'mod_lesson','displayreview','0',NULL),(821,2,1663307127,'mod_lesson','displayreview_adv','',NULL),(822,2,1663307127,'mod_lesson','maximumnumberofattempts','1',NULL),(823,2,1663307127,'mod_lesson','maximumnumberofattempts_adv','',NULL),(824,2,1663307127,'mod_lesson','defaultnextpage','0',NULL),(825,2,1663307127,'mod_lesson','defaultnextpage_adv','1',NULL),(826,2,1663307127,'mod_lesson','numberofpagestoshow','1',NULL),(827,2,1663307127,'mod_lesson','numberofpagestoshow_adv','1',NULL),(828,2,1663307127,'mod_lesson','practice','0',NULL),(829,2,1663307127,'mod_lesson','practice_adv','',NULL),(830,2,1663307127,'mod_lesson','customscoring','1',NULL),(831,2,1663307127,'mod_lesson','customscoring_adv','1',NULL),(832,2,1663307127,'mod_lesson','retakesallowed','0',NULL),(833,2,1663307127,'mod_lesson','retakesallowed_adv','',NULL),(834,2,1663307127,'mod_lesson','handlingofretakes','0',NULL),(835,2,1663307127,'mod_lesson','handlingofretakes_adv','1',NULL),(836,2,1663307127,'mod_lesson','minimumnumberofquestions','0',NULL),(837,2,1663307127,'mod_lesson','minimumnumberofquestions_adv','1',NULL),(838,2,1663307127,'page','displayoptions','5',NULL),(839,2,1663307127,'page','printheading','1',NULL),(840,2,1663307127,'page','printintro','0',NULL),(841,2,1663307127,'page','printlastmodified','1',NULL),(842,2,1663307127,'page','display','5',NULL),(843,2,1663307127,'page','popupwidth','620',NULL),(844,2,1663307127,'page','popupheight','450',NULL),(845,2,1663307127,'quiz','timelimit','0',NULL),(846,2,1663307127,'quiz','timelimit_adv','',NULL),(847,2,1663307127,'quiz','overduehandling','autosubmit',NULL),(848,2,1663307127,'quiz','overduehandling_adv','',NULL),(849,2,1663307127,'quiz','graceperiod','86400',NULL),(850,2,1663307127,'quiz','graceperiod_adv','',NULL),(851,2,1663307127,'quiz','graceperiodmin','60',NULL),(852,2,1663307127,'quiz','attempts','0',NULL),(853,2,1663307127,'quiz','attempts_adv','',NULL),(854,2,1663307127,'quiz','grademethod','1',NULL),(855,2,1663307127,'quiz','grademethod_adv','',NULL),(856,2,1663307127,'quiz','maximumgrade','10',NULL),(857,2,1663307127,'quiz','questionsperpage','1',NULL),(858,2,1663307127,'quiz','questionsperpage_adv','',NULL),(859,2,1663307127,'quiz','navmethod','free',NULL),(860,2,1663307127,'quiz','navmethod_adv','1',NULL),(861,2,1663307127,'quiz','shuffleanswers','1',NULL),(862,2,1663307127,'quiz','shuffleanswers_adv','',NULL),(863,2,1663307127,'quiz','preferredbehaviour','deferredfeedback',NULL),(864,2,1663307127,'quiz','canredoquestions','0',NULL),(865,2,1663307127,'quiz','canredoquestions_adv','1',NULL),(866,2,1663307127,'quiz','attemptonlast','0',NULL),(867,2,1663307127,'quiz','attemptonlast_adv','1',NULL),(868,2,1663307127,'quiz','reviewattempt','69904',NULL),(869,2,1663307127,'quiz','reviewcorrectness','69904',NULL),(870,2,1663307127,'quiz','reviewmarks','69904',NULL),(871,2,1663307127,'quiz','reviewspecificfeedback','69904',NULL),(872,2,1663307127,'quiz','reviewgeneralfeedback','69904',NULL),(873,2,1663307127,'quiz','reviewrightanswer','69904',NULL),(874,2,1663307127,'quiz','reviewoverallfeedback','4368',NULL),(875,2,1663307127,'quiz','showuserpicture','0',NULL),(876,2,1663307127,'quiz','showuserpicture_adv','',NULL),(877,2,1663307127,'quiz','decimalpoints','2',NULL),(878,2,1663307127,'quiz','decimalpoints_adv','',NULL),(879,2,1663307127,'quiz','questiondecimalpoints','-1',NULL),(880,2,1663307127,'quiz','questiondecimalpoints_adv','',NULL),(881,2,1663307127,'quiz','showblocks','0',NULL),(882,2,1663307127,'quiz','showblocks_adv','1',NULL),(883,2,1663307127,'quiz','quizpassword','',NULL),(884,2,1663307127,'quiz','quizpassword_adv','',NULL),(885,2,1663307127,'quiz','quizpassword_required','',NULL),(886,2,1663307127,'quiz','subnet','',NULL),(887,2,1663307127,'quiz','subnet_adv','1',NULL),(888,2,1663307127,'quiz','delay1','0',NULL),(889,2,1663307127,'quiz','delay1_adv','1',NULL),(890,2,1663307127,'quiz','delay2','0',NULL),(891,2,1663307127,'quiz','delay2_adv','1',NULL),(892,2,1663307127,'quiz','browsersecurity','-',NULL),(893,2,1663307127,'quiz','browsersecurity_adv','1',NULL),(894,2,1663307127,'quiz','initialnumfeedbacks','2',NULL),(895,2,1663307127,'quiz','autosaveperiod','60',NULL),(896,2,1663307127,'quizaccess_seb','autoreconfigureseb','1',NULL),(897,2,1663307127,'quizaccess_seb','showseblinks','seb,http',NULL),(898,2,1663307127,'quizaccess_seb','downloadlink','https://safeexambrowser.org/download_en.html',NULL),(899,2,1663307127,'quizaccess_seb','quizpasswordrequired','0',NULL),(900,2,1663307127,'quizaccess_seb','displayblocksbeforestart','0',NULL),(901,2,1663307127,'quizaccess_seb','displayblockswhenfinished','1',NULL),(902,2,1663307127,'scorm','displaycoursestructure','0',NULL),(903,2,1663307127,'scorm','displaycoursestructure_adv','',NULL),(904,2,1663307127,'scorm','popup','0',NULL),(905,2,1663307127,'scorm','popup_adv','',NULL),(906,2,1663307127,'scorm','displayactivityname','1',NULL),(907,2,1663307127,'scorm','framewidth','100',NULL),(908,2,1663307127,'scorm','framewidth_adv','1',NULL),(909,2,1663307127,'scorm','frameheight','500',NULL),(910,2,1663307127,'scorm','frameheight_adv','1',NULL),(911,2,1663307127,'scorm','winoptgrp_adv','1',NULL),(912,2,1663307127,'scorm','scrollbars','0',NULL),(913,2,1663307127,'scorm','directories','0',NULL),(914,2,1663307127,'scorm','location','0',NULL),(915,2,1663307127,'scorm','menubar','0',NULL),(916,2,1663307127,'scorm','toolbar','0',NULL),(917,2,1663307127,'scorm','status','0',NULL),(918,2,1663307127,'scorm','skipview','0',NULL),(919,2,1663307127,'scorm','skipview_adv','1',NULL),(920,2,1663307127,'scorm','hidebrowse','0',NULL),(921,2,1663307127,'scorm','hidebrowse_adv','1',NULL),(922,2,1663307127,'scorm','hidetoc','0',NULL),(923,2,1663307127,'scorm','hidetoc_adv','1',NULL),(924,2,1663307127,'scorm','nav','1',NULL),(925,2,1663307127,'scorm','nav_adv','1',NULL),(926,2,1663307128,'scorm','navpositionleft','-100',NULL),(927,2,1663307128,'scorm','navpositionleft_adv','1',NULL),(928,2,1663307128,'scorm','navpositiontop','-100',NULL),(929,2,1663307128,'scorm','navpositiontop_adv','1',NULL),(930,2,1663307128,'scorm','collapsetocwinsize','767',NULL),(931,2,1663307128,'scorm','collapsetocwinsize_adv','1',NULL),(932,2,1663307128,'scorm','displayattemptstatus','1',NULL),(933,2,1663307128,'scorm','displayattemptstatus_adv','',NULL),(934,2,1663307128,'scorm','grademethod','1',NULL),(935,2,1663307128,'scorm','maxgrade','100',NULL),(936,2,1663307128,'scorm','maxattempt','0',NULL),(937,2,1663307128,'scorm','whatgrade','0',NULL),(938,2,1663307128,'scorm','forcecompleted','0',NULL),(939,2,1663307128,'scorm','forcenewattempt','0',NULL),(940,2,1663307128,'scorm','autocommit','0',NULL),(941,2,1663307128,'scorm','masteryoverride','1',NULL),(942,2,1663307128,'scorm','lastattemptlock','0',NULL),(943,2,1663307128,'scorm','auto','0',NULL),(944,2,1663307128,'scorm','updatefreq','0',NULL),(945,2,1663307128,'scorm','scormstandard','0',NULL),(946,2,1663307128,'scorm','allowtypeexternal','0',NULL),(947,2,1663307128,'scorm','allowtypelocalsync','0',NULL),(948,2,1663307128,'scorm','allowtypeexternalaicc','0',NULL),(949,2,1663307128,'scorm','allowaicchacp','0',NULL),(950,2,1663307128,'scorm','aicchacptimeout','30',NULL),(951,2,1663307128,'scorm','aicchacpkeepsessiondata','1',NULL),(952,2,1663307128,'scorm','aiccuserid','1',NULL),(953,2,1663307128,'scorm','forcejavascript','1',NULL),(954,2,1663307128,'scorm','allowapidebug','0',NULL),(955,2,1663307128,'scorm','apidebugmask','.*',NULL),(956,2,1663307128,'scorm','protectpackagedownloads','0',NULL),(957,2,1663307128,'url','framesize','130',NULL),(958,2,1663307128,'url','secretphrase','',NULL),(959,2,1663307128,'url','rolesinparams','0',NULL),(960,2,1663307128,'url','displayoptions','0,1,5,6',NULL),(961,2,1663307128,'url','printintro','1',NULL),(962,2,1663307128,'url','display','0',NULL),(963,2,1663307128,'url','popupwidth','620',NULL),(964,2,1663307128,'url','popupheight','450',NULL),(965,2,1663307128,'workshop','grade','80',NULL),(966,2,1663307128,'workshop','gradinggrade','20',NULL),(967,2,1663307128,'workshop','gradedecimals','0',NULL),(968,2,1663307128,'workshop','maxbytes','0',NULL),(969,2,1663307128,'workshop','strategy','accumulative',NULL),(970,2,1663307128,'workshop','examplesmode','0',NULL),(971,2,1663307128,'workshopallocation_random','numofreviews','5',NULL),(972,2,1663307128,'workshopform_numerrors','grade0','No',NULL),(973,2,1663307128,'workshopform_numerrors','grade1','Yes',NULL),(974,2,1663307128,'workshopeval_best','comparison','5',NULL),(975,2,1663307128,'tool_brickfield','analysistype','0',NULL),(976,2,1663307128,'tool_brickfield','deletehistoricaldata','1',NULL),(977,2,1663307128,'tool_brickfield','batch','1000',NULL),(978,2,1663307128,'tool_brickfield','perpage','50',NULL),(979,2,1663307128,'tool_recyclebin','coursebinenable','1',NULL),(980,2,1663307128,'tool_recyclebin','coursebinexpiry','604800',NULL),(981,2,1663307128,'tool_recyclebin','categorybinenable','1',NULL),(982,2,1663307128,'tool_recyclebin','categorybinexpiry','604800',NULL),(983,2,1663307128,'tool_recyclebin','autohide','1',NULL),(984,2,1663307128,'antivirus_clamav','runningmethod','commandline',NULL),(985,2,1663307128,'antivirus_clamav','pathtoclam','',NULL),(986,2,1663307128,'antivirus_clamav','pathtounixsocket','',NULL),(987,2,1663307128,'antivirus_clamav','tcpsockethost','',NULL),(988,2,1663307128,'antivirus_clamav','tcpsocketport','3310',NULL),(989,2,1663307128,'antivirus_clamav','clamfailureonupload','tryagain',NULL),(990,2,1663307128,'antivirus_clamav','tries','1',NULL),(991,2,1663307128,'auth_cas','auth_name','CAS',NULL),(992,2,1663307128,'auth_cas','auth_logo','',NULL),(993,2,1663307128,'auth_cas','hostname','',NULL),(994,2,1663307128,'auth_cas','baseuri','',NULL),(995,2,1663307128,'auth_cas','port','0',NULL),(996,2,1663307128,'auth_cas','casversion','2.0',NULL),(997,2,1663307128,'auth_cas','language','CAS_Languages_English',NULL),(998,2,1663307128,'auth_cas','proxycas','0',NULL),(999,2,1663307128,'auth_cas','logoutcas','0',NULL),(1000,2,1663307128,'auth_cas','multiauth','0',NULL),(1001,2,1663307128,'auth_cas','certificate_check','0',NULL),(1002,2,1663307128,'auth_cas','certificate_path','',NULL),(1003,2,1663307128,'auth_cas','curl_ssl_version','',NULL),(1004,2,1663307128,'auth_cas','logout_return_url','',NULL),(1005,2,1663307128,'auth_cas','host_url','',NULL),(1006,2,1663307128,'auth_cas','ldap_version','3',NULL),(1007,2,1663307128,'auth_cas','start_tls','0',NULL),(1008,2,1663307128,'auth_cas','ldapencoding','utf-8',NULL),(1009,2,1663307128,'auth_cas','pagesize','250',NULL),(1010,2,1663307128,'auth_cas','bind_dn','',NULL),(1011,2,1663307128,'auth_cas','bind_pw','',NULL),(1012,2,1663307128,'auth_cas','user_type','default',NULL),(1013,2,1663307128,'auth_cas','contexts','',NULL),(1014,2,1663307128,'auth_cas','search_sub','0',NULL),(1015,2,1663307128,'auth_cas','opt_deref','0',NULL),(1016,2,1663307128,'auth_cas','user_attribute','',NULL),(1017,2,1663307128,'auth_cas','memberattribute','',NULL),(1018,2,1663307128,'auth_cas','memberattribute_isdn','0',NULL),(1019,2,1663307128,'auth_cas','objectclass','',NULL),(1020,2,1663307128,'auth_cas','attrcreators','',NULL),(1021,2,1663307128,'auth_cas','groupecreators','',NULL),(1022,2,1663307128,'auth_cas','removeuser','0',NULL),(1023,2,1663307128,'auth_cas','field_map_firstname','',NULL),(1024,2,1663307128,'auth_cas','field_updatelocal_firstname','oncreate',NULL),(1025,2,1663307128,'auth_cas','field_updateremote_firstname','0',NULL),(1026,2,1663307128,'auth_cas','field_lock_firstname','unlocked',NULL),(1027,2,1663307128,'auth_cas','field_map_lastname','',NULL),(1028,2,1663307128,'auth_cas','field_updatelocal_lastname','oncreate',NULL),(1029,2,1663307128,'auth_cas','field_updateremote_lastname','0',NULL),(1030,2,1663307128,'auth_cas','field_lock_lastname','unlocked',NULL),(1031,2,1663307128,'auth_cas','field_map_email','',NULL),(1032,2,1663307128,'auth_cas','field_updatelocal_email','oncreate',NULL),(1033,2,1663307128,'auth_cas','field_updateremote_email','0',NULL),(1034,2,1663307128,'auth_cas','field_lock_email','unlocked',NULL),(1035,2,1663307128,'auth_cas','field_map_city','',NULL),(1036,2,1663307128,'auth_cas','field_updatelocal_city','oncreate',NULL),(1037,2,1663307128,'auth_cas','field_updateremote_city','0',NULL),(1038,2,1663307128,'auth_cas','field_lock_city','unlocked',NULL),(1039,2,1663307128,'auth_cas','field_map_country','',NULL),(1040,2,1663307128,'auth_cas','field_updatelocal_country','oncreate',NULL),(1041,2,1663307128,'auth_cas','field_updateremote_country','0',NULL),(1042,2,1663307128,'auth_cas','field_lock_country','unlocked',NULL),(1043,2,1663307128,'auth_cas','field_map_lang','',NULL),(1044,2,1663307128,'auth_cas','field_updatelocal_lang','oncreate',NULL),(1045,2,1663307128,'auth_cas','field_updateremote_lang','0',NULL),(1046,2,1663307128,'auth_cas','field_lock_lang','unlocked',NULL),(1047,2,1663307128,'auth_cas','field_map_description','',NULL),(1048,2,1663307128,'auth_cas','field_updatelocal_description','oncreate',NULL),(1049,2,1663307128,'auth_cas','field_updateremote_description','0',NULL),(1050,2,1663307128,'auth_cas','field_lock_description','unlocked',NULL),(1051,2,1663307128,'auth_cas','field_map_idnumber','',NULL),(1052,2,1663307128,'auth_cas','field_updatelocal_idnumber','oncreate',NULL),(1053,2,1663307128,'auth_cas','field_updateremote_idnumber','0',NULL),(1054,2,1663307128,'auth_cas','field_lock_idnumber','unlocked',NULL),(1055,2,1663307128,'auth_cas','field_map_institution','',NULL),(1056,2,1663307128,'auth_cas','field_updatelocal_institution','oncreate',NULL),(1057,2,1663307128,'auth_cas','field_updateremote_institution','0',NULL),(1058,2,1663307128,'auth_cas','field_lock_institution','unlocked',NULL),(1059,2,1663307128,'auth_cas','field_map_department','',NULL),(1060,2,1663307128,'auth_cas','field_updatelocal_department','oncreate',NULL),(1061,2,1663307128,'auth_cas','field_updateremote_department','0',NULL),(1062,2,1663307128,'auth_cas','field_lock_department','unlocked',NULL),(1063,2,1663307128,'auth_cas','field_map_phone1','',NULL),(1064,2,1663307128,'auth_cas','field_updatelocal_phone1','oncreate',NULL),(1065,2,1663307128,'auth_cas','field_updateremote_phone1','0',NULL),(1066,2,1663307128,'auth_cas','field_lock_phone1','unlocked',NULL),(1067,2,1663307128,'auth_cas','field_map_phone2','',NULL),(1068,2,1663307128,'auth_cas','field_updatelocal_phone2','oncreate',NULL),(1069,2,1663307128,'auth_cas','field_updateremote_phone2','0',NULL),(1070,2,1663307128,'auth_cas','field_lock_phone2','unlocked',NULL),(1071,2,1663307128,'auth_cas','field_map_address','',NULL),(1072,2,1663307128,'auth_cas','field_updatelocal_address','oncreate',NULL),(1073,2,1663307128,'auth_cas','field_updateremote_address','0',NULL),(1074,2,1663307128,'auth_cas','field_lock_address','unlocked',NULL),(1075,2,1663307128,'auth_cas','field_map_firstnamephonetic','',NULL),(1076,2,1663307128,'auth_cas','field_updatelocal_firstnamephonetic','oncreate',NULL),(1077,2,1663307128,'auth_cas','field_updateremote_firstnamephonetic','0',NULL),(1078,2,1663307128,'auth_cas','field_lock_firstnamephonetic','unlocked',NULL),(1079,2,1663307128,'auth_cas','field_map_lastnamephonetic','',NULL),(1080,2,1663307128,'auth_cas','field_updatelocal_lastnamephonetic','oncreate',NULL),(1081,2,1663307128,'auth_cas','field_updateremote_lastnamephonetic','0',NULL),(1082,2,1663307128,'auth_cas','field_lock_lastnamephonetic','unlocked',NULL),(1083,2,1663307128,'auth_cas','field_map_middlename','',NULL),(1084,2,1663307128,'auth_cas','field_updatelocal_middlename','oncreate',NULL),(1085,2,1663307128,'auth_cas','field_updateremote_middlename','0',NULL),(1086,2,1663307128,'auth_cas','field_lock_middlename','unlocked',NULL),(1087,2,1663307128,'auth_cas','field_map_alternatename','',NULL),(1088,2,1663307128,'auth_cas','field_updatelocal_alternatename','oncreate',NULL),(1089,2,1663307128,'auth_cas','field_updateremote_alternatename','0',NULL),(1090,2,1663307128,'auth_cas','field_lock_alternatename','unlocked',NULL),(1091,2,1663307128,'auth_email','recaptcha','0',NULL),(1092,2,1663307128,'auth_email','field_lock_firstname','unlocked',NULL),(1093,2,1663307128,'auth_email','field_lock_lastname','unlocked',NULL),(1094,2,1663307128,'auth_email','field_lock_email','unlocked',NULL),(1095,2,1663307128,'auth_email','field_lock_city','unlocked',NULL),(1096,2,1663307128,'auth_email','field_lock_country','unlocked',NULL),(1097,2,1663307128,'auth_email','field_lock_lang','unlocked',NULL),(1098,2,1663307128,'auth_email','field_lock_description','unlocked',NULL),(1099,2,1663307128,'auth_email','field_lock_idnumber','unlocked',NULL),(1100,2,1663307128,'auth_email','field_lock_institution','unlocked',NULL),(1101,2,1663307128,'auth_email','field_lock_department','unlocked',NULL),(1102,2,1663307128,'auth_email','field_lock_phone1','unlocked',NULL),(1103,2,1663307128,'auth_email','field_lock_phone2','unlocked',NULL),(1104,2,1663307128,'auth_email','field_lock_address','unlocked',NULL),(1105,2,1663307128,'auth_email','field_lock_firstnamephonetic','unlocked',NULL),(1106,2,1663307128,'auth_email','field_lock_lastnamephonetic','unlocked',NULL),(1107,2,1663307128,'auth_email','field_lock_middlename','unlocked',NULL),(1108,2,1663307128,'auth_email','field_lock_alternatename','unlocked',NULL),(1109,2,1663307128,'auth_db','host','127.0.0.1',NULL),(1110,2,1663307128,'auth_db','type','mysqli',NULL),(1111,2,1663307128,'auth_db','sybasequoting','0',NULL),(1112,2,1663307128,'auth_db','name','',NULL),(1113,2,1663307128,'auth_db','user','',NULL),(1114,2,1663307128,'auth_db','pass','',NULL),(1115,2,1663307128,'auth_db','table','',NULL),(1116,2,1663307128,'auth_db','fielduser','',NULL),(1117,2,1663307128,'auth_db','fieldpass','',NULL),(1118,2,1663307128,'auth_db','passtype','plaintext',NULL),(1119,2,1663307128,'auth_db','extencoding','utf-8',NULL),(1120,2,1663307128,'auth_db','setupsql','',NULL),(1121,2,1663307128,'auth_db','debugauthdb','0',NULL),(1122,2,1663307128,'auth_db','changepasswordurl','',NULL),(1123,2,1663307128,'auth_db','removeuser','0',NULL),(1124,2,1663307128,'auth_db','updateusers','0',NULL),(1125,2,1663307128,'auth_db','field_map_firstname','',NULL),(1126,2,1663307128,'auth_db','field_updatelocal_firstname','oncreate',NULL),(1127,2,1663307128,'auth_db','field_updateremote_firstname','0',NULL),(1128,2,1663307128,'auth_db','field_lock_firstname','unlocked',NULL),(1129,2,1663307128,'auth_db','field_map_lastname','',NULL),(1130,2,1663307128,'auth_db','field_updatelocal_lastname','oncreate',NULL),(1131,2,1663307128,'auth_db','field_updateremote_lastname','0',NULL),(1132,2,1663307128,'auth_db','field_lock_lastname','unlocked',NULL),(1133,2,1663307128,'auth_db','field_map_email','',NULL),(1134,2,1663307128,'auth_db','field_updatelocal_email','oncreate',NULL),(1135,2,1663307128,'auth_db','field_updateremote_email','0',NULL),(1136,2,1663307128,'auth_db','field_lock_email','unlocked',NULL),(1137,2,1663307128,'auth_db','field_map_city','',NULL),(1138,2,1663307128,'auth_db','field_updatelocal_city','oncreate',NULL),(1139,2,1663307128,'auth_db','field_updateremote_city','0',NULL),(1140,2,1663307128,'auth_db','field_lock_city','unlocked',NULL),(1141,2,1663307128,'auth_db','field_map_country','',NULL),(1142,2,1663307128,'auth_db','field_updatelocal_country','oncreate',NULL),(1143,2,1663307128,'auth_db','field_updateremote_country','0',NULL),(1144,2,1663307128,'auth_db','field_lock_country','unlocked',NULL),(1145,2,1663307128,'auth_db','field_map_lang','',NULL),(1146,2,1663307128,'auth_db','field_updatelocal_lang','oncreate',NULL),(1147,2,1663307128,'auth_db','field_updateremote_lang','0',NULL),(1148,2,1663307128,'auth_db','field_lock_lang','unlocked',NULL),(1149,2,1663307128,'auth_db','field_map_description','',NULL),(1150,2,1663307128,'auth_db','field_updatelocal_description','oncreate',NULL),(1151,2,1663307128,'auth_db','field_updateremote_description','0',NULL),(1152,2,1663307128,'auth_db','field_lock_description','unlocked',NULL),(1153,2,1663307128,'auth_db','field_map_idnumber','',NULL),(1154,2,1663307128,'auth_db','field_updatelocal_idnumber','oncreate',NULL),(1155,2,1663307128,'auth_db','field_updateremote_idnumber','0',NULL),(1156,2,1663307128,'auth_db','field_lock_idnumber','unlocked',NULL),(1157,2,1663307128,'auth_db','field_map_institution','',NULL),(1158,2,1663307128,'auth_db','field_updatelocal_institution','oncreate',NULL),(1159,2,1663307128,'auth_db','field_updateremote_institution','0',NULL),(1160,2,1663307128,'auth_db','field_lock_institution','unlocked',NULL),(1161,2,1663307128,'auth_db','field_map_department','',NULL),(1162,2,1663307128,'auth_db','field_updatelocal_department','oncreate',NULL),(1163,2,1663307128,'auth_db','field_updateremote_department','0',NULL),(1164,2,1663307128,'auth_db','field_lock_department','unlocked',NULL),(1165,2,1663307128,'auth_db','field_map_phone1','',NULL),(1166,2,1663307128,'auth_db','field_updatelocal_phone1','oncreate',NULL),(1167,2,1663307128,'auth_db','field_updateremote_phone1','0',NULL),(1168,2,1663307128,'auth_db','field_lock_phone1','unlocked',NULL),(1169,2,1663307128,'auth_db','field_map_phone2','',NULL),(1170,2,1663307128,'auth_db','field_updatelocal_phone2','oncreate',NULL),(1171,2,1663307128,'auth_db','field_updateremote_phone2','0',NULL),(1172,2,1663307128,'auth_db','field_lock_phone2','unlocked',NULL),(1173,2,1663307128,'auth_db','field_map_address','',NULL),(1174,2,1663307128,'auth_db','field_updatelocal_address','oncreate',NULL),(1175,2,1663307128,'auth_db','field_updateremote_address','0',NULL),(1176,2,1663307128,'auth_db','field_lock_address','unlocked',NULL),(1177,2,1663307128,'auth_db','field_map_firstnamephonetic','',NULL),(1178,2,1663307128,'auth_db','field_updatelocal_firstnamephonetic','oncreate',NULL),(1179,2,1663307128,'auth_db','field_updateremote_firstnamephonetic','0',NULL),(1180,2,1663307128,'auth_db','field_lock_firstnamephonetic','unlocked',NULL),(1181,2,1663307128,'auth_db','field_map_lastnamephonetic','',NULL),(1182,2,1663307128,'auth_db','field_updatelocal_lastnamephonetic','oncreate',NULL),(1183,2,1663307128,'auth_db','field_updateremote_lastnamephonetic','0',NULL),(1184,2,1663307128,'auth_db','field_lock_lastnamephonetic','unlocked',NULL),(1185,2,1663307128,'auth_db','field_map_middlename','',NULL),(1186,2,1663307128,'auth_db','field_updatelocal_middlename','oncreate',NULL),(1187,2,1663307128,'auth_db','field_updateremote_middlename','0',NULL),(1188,2,1663307128,'auth_db','field_lock_middlename','unlocked',NULL),(1189,2,1663307128,'auth_db','field_map_alternatename','',NULL),(1190,2,1663307128,'auth_db','field_updatelocal_alternatename','oncreate',NULL),(1191,2,1663307128,'auth_db','field_updateremote_alternatename','0',NULL),(1192,2,1663307128,'auth_db','field_lock_alternatename','unlocked',NULL),(1193,2,1663307128,'auth_ldap','host_url','',NULL),(1194,2,1663307128,'auth_ldap','ldap_version','3',NULL),(1195,2,1663307128,'auth_ldap','start_tls','0',NULL),(1196,2,1663307128,'auth_ldap','ldapencoding','utf-8',NULL),(1197,2,1663307128,'auth_ldap','pagesize','250',NULL),(1198,2,1663307128,'auth_ldap','preventpassindb','0',NULL),(1199,2,1663307128,'auth_ldap','bind_dn','',NULL),(1200,2,1663307128,'auth_ldap','bind_pw','',NULL),(1201,2,1663307128,'auth_ldap','user_type','default',NULL),(1202,2,1663307128,'auth_ldap','contexts','',NULL),(1203,2,1663307128,'auth_ldap','search_sub','0',NULL),(1204,2,1663307128,'auth_ldap','opt_deref','0',NULL),(1205,2,1663307128,'auth_ldap','user_attribute','',NULL),(1206,2,1663307128,'auth_ldap','suspended_attribute','',NULL),(1207,2,1663307128,'auth_ldap','memberattribute','',NULL),(1208,2,1663307128,'auth_ldap','memberattribute_isdn','0',NULL),(1209,2,1663307128,'auth_ldap','objectclass','',NULL),(1210,2,1663307128,'auth_ldap','forcechangepassword','0',NULL),(1211,2,1663307128,'auth_ldap','stdchangepassword','0',NULL),(1212,2,1663307128,'auth_ldap','passtype','plaintext',NULL),(1213,2,1663307128,'auth_ldap','changepasswordurl','',NULL),(1214,2,1663307128,'auth_ldap','expiration','0',NULL),(1215,2,1663307128,'auth_ldap','expiration_warning','',NULL),(1216,2,1663307128,'auth_ldap','expireattr','',NULL),(1217,2,1663307128,'auth_ldap','gracelogins','0',NULL),(1218,2,1663307128,'auth_ldap','graceattr','',NULL),(1219,2,1663307128,'auth_ldap','auth_user_create','0',NULL),(1220,2,1663307128,'auth_ldap','create_context','',NULL),(1221,2,1663307128,'auth_ldap','managercontext','',NULL),(1222,2,1663307128,'auth_ldap','coursecreatorcontext','',NULL),(1223,2,1663307128,'auth_ldap','removeuser','0',NULL),(1224,2,1663307128,'auth_ldap','sync_suspended','0',NULL),(1225,2,1663307128,'auth_ldap','ntlmsso_enabled','0',NULL),(1226,2,1663307128,'auth_ldap','ntlmsso_subnet','',NULL),(1227,2,1663307128,'auth_ldap','ntlmsso_ie_fastpath','0',NULL),(1228,2,1663307128,'auth_ldap','ntlmsso_type','ntlm',NULL),(1229,2,1663307128,'auth_ldap','ntlmsso_remoteuserformat','',NULL),(1230,2,1663307128,'auth_ldap','field_map_firstname','',NULL),(1231,2,1663307128,'auth_ldap','field_updatelocal_firstname','oncreate',NULL),(1232,2,1663307128,'auth_ldap','field_updateremote_firstname','0',NULL),(1233,2,1663307128,'auth_ldap','field_lock_firstname','unlocked',NULL),(1234,2,1663307128,'auth_ldap','field_map_lastname','',NULL),(1235,2,1663307128,'auth_ldap','field_updatelocal_lastname','oncreate',NULL),(1236,2,1663307128,'auth_ldap','field_updateremote_lastname','0',NULL),(1237,2,1663307128,'auth_ldap','field_lock_lastname','unlocked',NULL),(1238,2,1663307128,'auth_ldap','field_map_email','',NULL),(1239,2,1663307128,'auth_ldap','field_updatelocal_email','oncreate',NULL),(1240,2,1663307128,'auth_ldap','field_updateremote_email','0',NULL),(1241,2,1663307128,'auth_ldap','field_lock_email','unlocked',NULL),(1242,2,1663307128,'auth_ldap','field_map_city','',NULL),(1243,2,1663307128,'auth_ldap','field_updatelocal_city','oncreate',NULL),(1244,2,1663307128,'auth_ldap','field_updateremote_city','0',NULL),(1245,2,1663307128,'auth_ldap','field_lock_city','unlocked',NULL),(1246,2,1663307128,'auth_ldap','field_map_country','',NULL),(1247,2,1663307128,'auth_ldap','field_updatelocal_country','oncreate',NULL),(1248,2,1663307128,'auth_ldap','field_updateremote_country','0',NULL),(1249,2,1663307128,'auth_ldap','field_lock_country','unlocked',NULL),(1250,2,1663307129,'auth_ldap','field_map_lang','',NULL),(1251,2,1663307129,'auth_ldap','field_updatelocal_lang','oncreate',NULL),(1252,2,1663307129,'auth_ldap','field_updateremote_lang','0',NULL),(1253,2,1663307129,'auth_ldap','field_lock_lang','unlocked',NULL),(1254,2,1663307129,'auth_ldap','field_map_description','',NULL),(1255,2,1663307129,'auth_ldap','field_updatelocal_description','oncreate',NULL),(1256,2,1663307129,'auth_ldap','field_updateremote_description','0',NULL),(1257,2,1663307129,'auth_ldap','field_lock_description','unlocked',NULL),(1258,2,1663307129,'auth_ldap','field_map_idnumber','',NULL),(1259,2,1663307129,'auth_ldap','field_updatelocal_idnumber','oncreate',NULL),(1260,2,1663307129,'auth_ldap','field_updateremote_idnumber','0',NULL),(1261,2,1663307129,'auth_ldap','field_lock_idnumber','unlocked',NULL),(1262,2,1663307129,'auth_ldap','field_map_institution','',NULL),(1263,2,1663307129,'auth_ldap','field_updatelocal_institution','oncreate',NULL),(1264,2,1663307129,'auth_ldap','field_updateremote_institution','0',NULL),(1265,2,1663307129,'auth_ldap','field_lock_institution','unlocked',NULL),(1266,2,1663307129,'auth_ldap','field_map_department','',NULL),(1267,2,1663307129,'auth_ldap','field_updatelocal_department','oncreate',NULL),(1268,2,1663307129,'auth_ldap','field_updateremote_department','0',NULL),(1269,2,1663307129,'auth_ldap','field_lock_department','unlocked',NULL),(1270,2,1663307129,'auth_ldap','field_map_phone1','',NULL),(1271,2,1663307129,'auth_ldap','field_updatelocal_phone1','oncreate',NULL),(1272,2,1663307129,'auth_ldap','field_updateremote_phone1','0',NULL),(1273,2,1663307129,'auth_ldap','field_lock_phone1','unlocked',NULL),(1274,2,1663307129,'auth_ldap','field_map_phone2','',NULL),(1275,2,1663307129,'auth_ldap','field_updatelocal_phone2','oncreate',NULL),(1276,2,1663307129,'auth_ldap','field_updateremote_phone2','0',NULL),(1277,2,1663307129,'auth_ldap','field_lock_phone2','unlocked',NULL),(1278,2,1663307129,'auth_ldap','field_map_address','',NULL),(1279,2,1663307129,'auth_ldap','field_updatelocal_address','oncreate',NULL),(1280,2,1663307129,'auth_ldap','field_updateremote_address','0',NULL),(1281,2,1663307129,'auth_ldap','field_lock_address','unlocked',NULL),(1282,2,1663307129,'auth_ldap','field_map_firstnamephonetic','',NULL),(1283,2,1663307129,'auth_ldap','field_updatelocal_firstnamephonetic','oncreate',NULL),(1284,2,1663307129,'auth_ldap','field_updateremote_firstnamephonetic','0',NULL),(1285,2,1663307129,'auth_ldap','field_lock_firstnamephonetic','unlocked',NULL),(1286,2,1663307129,'auth_ldap','field_map_lastnamephonetic','',NULL),(1287,2,1663307129,'auth_ldap','field_updatelocal_lastnamephonetic','oncreate',NULL),(1288,2,1663307129,'auth_ldap','field_updateremote_lastnamephonetic','0',NULL),(1289,2,1663307129,'auth_ldap','field_lock_lastnamephonetic','unlocked',NULL),(1290,2,1663307129,'auth_ldap','field_map_middlename','',NULL),(1291,2,1663307129,'auth_ldap','field_updatelocal_middlename','oncreate',NULL),(1292,2,1663307129,'auth_ldap','field_updateremote_middlename','0',NULL),(1293,2,1663307129,'auth_ldap','field_lock_middlename','unlocked',NULL),(1294,2,1663307129,'auth_ldap','field_map_alternatename','',NULL),(1295,2,1663307129,'auth_ldap','field_updatelocal_alternatename','oncreate',NULL),(1296,2,1663307129,'auth_ldap','field_updateremote_alternatename','0',NULL),(1297,2,1663307129,'auth_ldap','field_lock_alternatename','unlocked',NULL),(1298,2,1663307129,'auth_manual','expiration','0',NULL),(1299,2,1663307129,'auth_manual','expirationtime','30',NULL),(1300,2,1663307129,'auth_manual','expiration_warning','0',NULL),(1301,2,1663307129,'auth_manual','field_lock_firstname','unlocked',NULL),(1302,2,1663307129,'auth_manual','field_lock_lastname','unlocked',NULL),(1303,2,1663307129,'auth_manual','field_lock_email','unlocked',NULL),(1304,2,1663307129,'auth_manual','field_lock_city','unlocked',NULL),(1305,2,1663307129,'auth_manual','field_lock_country','unlocked',NULL),(1306,2,1663307129,'auth_manual','field_lock_lang','unlocked',NULL),(1307,2,1663307129,'auth_manual','field_lock_description','unlocked',NULL),(1308,2,1663307129,'auth_manual','field_lock_idnumber','unlocked',NULL),(1309,2,1663307129,'auth_manual','field_lock_institution','unlocked',NULL),(1310,2,1663307129,'auth_manual','field_lock_department','unlocked',NULL),(1311,2,1663307129,'auth_manual','field_lock_phone1','unlocked',NULL),(1312,2,1663307129,'auth_manual','field_lock_phone2','unlocked',NULL),(1313,2,1663307129,'auth_manual','field_lock_address','unlocked',NULL),(1314,2,1663307129,'auth_manual','field_lock_firstnamephonetic','unlocked',NULL),(1315,2,1663307129,'auth_manual','field_lock_lastnamephonetic','unlocked',NULL),(1316,2,1663307129,'auth_manual','field_lock_middlename','unlocked',NULL),(1317,2,1663307129,'auth_manual','field_lock_alternatename','unlocked',NULL),(1318,2,1663307129,'auth_mnet','rpc_negotiation_timeout','30',NULL),(1319,2,1663307129,'auth_none','field_lock_firstname','unlocked',NULL),(1320,2,1663307129,'auth_none','field_lock_lastname','unlocked',NULL),(1321,2,1663307129,'auth_none','field_lock_email','unlocked',NULL),(1322,2,1663307129,'auth_none','field_lock_city','unlocked',NULL),(1323,2,1663307129,'auth_none','field_lock_country','unlocked',NULL),(1324,2,1663307129,'auth_none','field_lock_lang','unlocked',NULL),(1325,2,1663307129,'auth_none','field_lock_description','unlocked',NULL),(1326,2,1663307129,'auth_none','field_lock_idnumber','unlocked',NULL),(1327,2,1663307129,'auth_none','field_lock_institution','unlocked',NULL),(1328,2,1663307129,'auth_none','field_lock_department','unlocked',NULL),(1329,2,1663307129,'auth_none','field_lock_phone1','unlocked',NULL),(1330,2,1663307129,'auth_none','field_lock_phone2','unlocked',NULL),(1331,2,1663307129,'auth_none','field_lock_address','unlocked',NULL),(1332,2,1663307129,'auth_none','field_lock_firstnamephonetic','unlocked',NULL),(1333,2,1663307129,'auth_none','field_lock_lastnamephonetic','unlocked',NULL),(1334,2,1663307129,'auth_none','field_lock_middlename','unlocked',NULL),(1335,2,1663307129,'auth_none','field_lock_alternatename','unlocked',NULL),(1336,2,1663307129,'auth_oauth2','field_lock_firstname','unlocked',NULL),(1337,2,1663307129,'auth_oauth2','field_lock_lastname','unlocked',NULL),(1338,2,1663307129,'auth_oauth2','field_lock_email','unlocked',NULL),(1339,2,1663307129,'auth_oauth2','field_lock_city','unlocked',NULL),(1340,2,1663307129,'auth_oauth2','field_lock_country','unlocked',NULL),(1341,2,1663307129,'auth_oauth2','field_lock_lang','unlocked',NULL),(1342,2,1663307129,'auth_oauth2','field_lock_description','unlocked',NULL),(1343,2,1663307129,'auth_oauth2','field_lock_idnumber','unlocked',NULL),(1344,2,1663307129,'auth_oauth2','field_lock_institution','unlocked',NULL),(1345,2,1663307129,'auth_oauth2','field_lock_department','unlocked',NULL),(1346,2,1663307129,'auth_oauth2','field_lock_phone1','unlocked',NULL),(1347,2,1663307129,'auth_oauth2','field_lock_phone2','unlocked',NULL),(1348,2,1663307129,'auth_oauth2','field_lock_address','unlocked',NULL),(1349,2,1663307129,'auth_oauth2','field_lock_firstnamephonetic','unlocked',NULL),(1350,2,1663307129,'auth_oauth2','field_lock_lastnamephonetic','unlocked',NULL),(1351,2,1663307129,'auth_oauth2','field_lock_middlename','unlocked',NULL),(1352,2,1663307129,'auth_oauth2','field_lock_alternatename','unlocked',NULL),(1353,2,1663307129,'auth_shibboleth','user_attribute','',NULL),(1354,2,1663307129,'auth_shibboleth','convert_data','',NULL),(1355,2,1663307129,'auth_shibboleth','alt_login','off',NULL),(1356,2,1663307129,'auth_shibboleth','organization_selection','urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai',NULL),(1357,2,1663307129,'auth_shibboleth','logout_handler','',NULL),(1358,2,1663307129,'auth_shibboleth','logout_return_url','',NULL),(1359,2,1663307129,'auth_shibboleth','login_name','Shibboleth Login',NULL),(1360,2,1663307129,'auth_shibboleth','auth_logo','',NULL),(1361,2,1663307129,'auth_shibboleth','auth_instructions','Use the <a href=\"http://148.72.245.159/m2/moodle/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.',NULL),(1362,2,1663307129,'auth_shibboleth','changepasswordurl','',NULL),(1363,2,1663307129,'auth_shibboleth','field_map_firstname','',NULL),(1364,2,1663307129,'auth_shibboleth','field_updatelocal_firstname','oncreate',NULL),(1365,2,1663307129,'auth_shibboleth','field_lock_firstname','unlocked',NULL),(1366,2,1663307129,'auth_shibboleth','field_map_lastname','',NULL),(1367,2,1663307129,'auth_shibboleth','field_updatelocal_lastname','oncreate',NULL),(1368,2,1663307129,'auth_shibboleth','field_lock_lastname','unlocked',NULL),(1369,2,1663307129,'auth_shibboleth','field_map_email','',NULL),(1370,2,1663307129,'auth_shibboleth','field_updatelocal_email','oncreate',NULL),(1371,2,1663307129,'auth_shibboleth','field_lock_email','unlocked',NULL),(1372,2,1663307129,'auth_shibboleth','field_map_city','',NULL),(1373,2,1663307129,'auth_shibboleth','field_updatelocal_city','oncreate',NULL),(1374,2,1663307129,'auth_shibboleth','field_lock_city','unlocked',NULL),(1375,2,1663307129,'auth_shibboleth','field_map_country','',NULL),(1376,2,1663307129,'auth_shibboleth','field_updatelocal_country','oncreate',NULL),(1377,2,1663307129,'auth_shibboleth','field_lock_country','unlocked',NULL),(1378,2,1663307129,'auth_shibboleth','field_map_lang','',NULL),(1379,2,1663307129,'auth_shibboleth','field_updatelocal_lang','oncreate',NULL),(1380,2,1663307129,'auth_shibboleth','field_lock_lang','unlocked',NULL),(1381,2,1663307129,'auth_shibboleth','field_map_description','',NULL),(1382,2,1663307129,'auth_shibboleth','field_updatelocal_description','oncreate',NULL),(1383,2,1663307129,'auth_shibboleth','field_lock_description','unlocked',NULL),(1384,2,1663307129,'auth_shibboleth','field_map_idnumber','',NULL),(1385,2,1663307129,'auth_shibboleth','field_updatelocal_idnumber','oncreate',NULL),(1386,2,1663307129,'auth_shibboleth','field_lock_idnumber','unlocked',NULL),(1387,2,1663307129,'auth_shibboleth','field_map_institution','',NULL),(1388,2,1663307129,'auth_shibboleth','field_updatelocal_institution','oncreate',NULL),(1389,2,1663307129,'auth_shibboleth','field_lock_institution','unlocked',NULL),(1390,2,1663307129,'auth_shibboleth','field_map_department','',NULL),(1391,2,1663307129,'auth_shibboleth','field_updatelocal_department','oncreate',NULL),(1392,2,1663307129,'auth_shibboleth','field_lock_department','unlocked',NULL),(1393,2,1663307129,'auth_shibboleth','field_map_phone1','',NULL),(1394,2,1663307129,'auth_shibboleth','field_updatelocal_phone1','oncreate',NULL),(1395,2,1663307129,'auth_shibboleth','field_lock_phone1','unlocked',NULL),(1396,2,1663307129,'auth_shibboleth','field_map_phone2','',NULL),(1397,2,1663307129,'auth_shibboleth','field_updatelocal_phone2','oncreate',NULL),(1398,2,1663307129,'auth_shibboleth','field_lock_phone2','unlocked',NULL),(1399,2,1663307129,'auth_shibboleth','field_map_address','',NULL),(1400,2,1663307129,'auth_shibboleth','field_updatelocal_address','oncreate',NULL),(1401,2,1663307129,'auth_shibboleth','field_lock_address','unlocked',NULL),(1402,2,1663307129,'auth_shibboleth','field_map_firstnamephonetic','',NULL),(1403,2,1663307129,'auth_shibboleth','field_updatelocal_firstnamephonetic','oncreate',NULL),(1404,2,1663307129,'auth_shibboleth','field_lock_firstnamephonetic','unlocked',NULL),(1405,2,1663307129,'auth_shibboleth','field_map_lastnamephonetic','',NULL),(1406,2,1663307129,'auth_shibboleth','field_updatelocal_lastnamephonetic','oncreate',NULL),(1407,2,1663307129,'auth_shibboleth','field_lock_lastnamephonetic','unlocked',NULL),(1408,2,1663307129,'auth_shibboleth','field_map_middlename','',NULL),(1409,2,1663307129,'auth_shibboleth','field_updatelocal_middlename','oncreate',NULL),(1410,2,1663307129,'auth_shibboleth','field_lock_middlename','unlocked',NULL),(1411,2,1663307129,'auth_shibboleth','field_map_alternatename','',NULL),(1412,2,1663307129,'auth_shibboleth','field_updatelocal_alternatename','oncreate',NULL),(1413,2,1663307129,'auth_shibboleth','field_lock_alternatename','unlocked',NULL),(1414,2,1663307129,'block_accessreview','whattoshow','showboth',NULL),(1415,2,1663307129,'block_accessreview','errordisplay','showint',NULL),(1416,2,1663307129,'block_accessreview','toolpage','errors',NULL),(1417,2,1663307129,'block_activity_results','config_showbest','3',NULL),(1418,2,1663307129,'block_activity_results','config_showbest_locked','',NULL),(1419,2,1663307129,'block_activity_results','config_showworst','0',NULL),(1420,2,1663307129,'block_activity_results','config_showworst_locked','',NULL),(1421,2,1663307129,'block_activity_results','config_usegroups','0',NULL),(1422,2,1663307129,'block_activity_results','config_usegroups_locked','',NULL),(1423,2,1663307129,'block_activity_results','config_nameformat','1',NULL),(1424,2,1663307129,'block_activity_results','config_nameformat_locked','',NULL),(1425,2,1663307129,'block_activity_results','config_gradeformat','1',NULL),(1426,2,1663307129,'block_activity_results','config_gradeformat_locked','',NULL),(1427,2,1663307129,'block_activity_results','config_decimalpoints','2',NULL),(1428,2,1663307129,'block_activity_results','config_decimalpoints_locked','',NULL),(1429,2,1663307129,'block_myoverview','displaycategories','1',NULL),(1430,2,1663307129,'block_myoverview','layouts','card,list,summary',NULL),(1431,2,1663307129,'block_myoverview','displaygroupingallincludinghidden','0',NULL),(1432,2,1663307129,'block_myoverview','displaygroupingall','1',NULL),(1433,2,1663307129,'block_myoverview','displaygroupinginprogress','1',NULL),(1434,2,1663307129,'block_myoverview','displaygroupingpast','1',NULL),(1435,2,1663307129,'block_myoverview','displaygroupingfuture','1',NULL),(1436,2,1663307129,'block_myoverview','displaygroupingcustomfield','0',NULL),(1437,2,1663307129,'block_myoverview','customfiltergrouping','',NULL),(1438,2,1663307129,'block_myoverview','displaygroupingfavourites','1',NULL),(1439,2,1663307129,'block_myoverview','displaygroupinghidden','1',NULL),(1440,2,1663307129,NULL,'block_course_list_adminview','all',NULL),(1441,2,1663307129,NULL,'block_course_list_hideallcourseslink','0',NULL),(1442,2,1663307129,NULL,'block_html_allowcssclasses','0',NULL),(1443,2,1663307129,NULL,'block_online_users_timetosee','5',NULL),(1444,2,1663307129,NULL,'block_online_users_onlinestatushiding','1',NULL),(1445,2,1663307129,'block_recentlyaccessedcourses','displaycategories','1',NULL),(1446,2,1663307129,NULL,'block_rss_client_num_entries','5',NULL),(1447,2,1663307129,NULL,'block_rss_client_timeout','30',NULL),(1448,2,1663307129,'block_section_links','numsections1','22',NULL),(1449,2,1663307129,'block_section_links','incby1','2',NULL),(1450,2,1663307129,'block_section_links','numsections2','40',NULL),(1451,2,1663307129,'block_section_links','incby2','5',NULL),(1452,2,1663307129,'block_section_links','showsectionname','0',NULL),(1453,2,1663307129,'block_starredcourses','displaycategories','1',NULL),(1454,2,1663307129,'block_tag_youtube','apikey','',NULL),(1455,2,1663307129,'format_singleactivity','activitytype','forum',NULL),(1456,2,1663307129,'fileconverter_googledrive','issuerid','',NULL),(1457,2,1663307129,NULL,'pathtounoconv','/usr/bin/unoconv',NULL),(1458,2,1663307129,'enrol_cohort','roleid','5',NULL),(1459,2,1663307129,'enrol_cohort','unenrolaction','0',NULL),(1460,2,1663307129,'enrol_meta','nosyncroleids','',NULL),(1461,2,1663307129,'enrol_meta','syncall','1',NULL),(1462,2,1663307129,'enrol_meta','unenrolaction','3',NULL),(1463,2,1663307129,'enrol_meta','coursesort','sortorder',NULL),(1464,2,1663307129,'enrol_fee','expiredaction','3',NULL),(1465,2,1663307129,'enrol_fee','status','1',NULL),(1466,2,1663307129,'enrol_fee','cost','0',NULL),(1467,2,1663307129,'enrol_fee','currency','USD',NULL),(1468,2,1663307129,'enrol_fee','roleid','5',NULL),(1469,2,1663307129,'enrol_fee','enrolperiod','0',NULL),(1470,2,1663307129,'enrol_database','dbtype','',NULL),(1471,2,1663307129,'enrol_database','dbhost','localhost',NULL),(1472,2,1663307129,'enrol_database','dbuser','',NULL),(1473,2,1663307129,'enrol_database','dbpass','',NULL),(1474,2,1663307129,'enrol_database','dbname','',NULL),(1475,2,1663307129,'enrol_database','dbencoding','utf-8',NULL),(1476,2,1663307129,'enrol_database','dbsetupsql','',NULL),(1477,2,1663307129,'enrol_database','dbsybasequoting','0',NULL),(1478,2,1663307129,'enrol_database','debugdb','0',NULL),(1479,2,1663307129,'enrol_database','localcoursefield','idnumber',NULL),(1480,2,1663307129,'enrol_database','localuserfield','idnumber',NULL),(1481,2,1663307129,'enrol_database','localrolefield','shortname',NULL),(1482,2,1663307129,'enrol_database','localcategoryfield','id',NULL),(1483,2,1663307129,'enrol_database','remoteenroltable','',NULL),(1484,2,1663307129,'enrol_database','remotecoursefield','',NULL),(1485,2,1663307129,'enrol_database','remoteuserfield','',NULL),(1486,2,1663307129,'enrol_database','remoterolefield','',NULL),(1487,2,1663307129,'enrol_database','remoteotheruserfield','',NULL),(1488,2,1663307129,'enrol_database','defaultrole','5',NULL),(1489,2,1663307129,'enrol_database','ignorehiddencourses','0',NULL),(1490,2,1663307129,'enrol_database','unenrolaction','0',NULL),(1491,2,1663307129,'enrol_database','newcoursetable','',NULL),(1492,2,1663307129,'enrol_database','newcoursefullname','fullname',NULL),(1493,2,1663307129,'enrol_database','newcourseshortname','shortname',NULL),(1494,2,1663307129,'enrol_database','newcourseidnumber','idnumber',NULL),(1495,2,1663307129,'enrol_database','newcoursecategory','',NULL),(1496,2,1663307129,'enrol_database','defaultcategory','1',NULL),(1497,2,1663307129,'enrol_database','templatecourse','',NULL),(1498,2,1663307129,'enrol_flatfile','location','',NULL),(1499,2,1663307129,'enrol_flatfile','encoding','UTF-8',NULL),(1500,2,1663307129,'enrol_flatfile','mailstudents','0',NULL),(1501,2,1663307129,'enrol_flatfile','mailteachers','0',NULL),(1502,2,1663307129,'enrol_flatfile','mailadmins','0',NULL),(1503,2,1663307129,'enrol_flatfile','unenrolaction','3',NULL),(1504,2,1663307129,'enrol_flatfile','expiredaction','3',NULL),(1505,2,1663307130,'enrol_guest','requirepassword','0',NULL),(1506,2,1663307130,'enrol_guest','usepasswordpolicy','0',NULL),(1507,2,1663307130,'enrol_guest','showhint','0',NULL),(1508,2,1663307130,'enrol_guest','defaultenrol','1',NULL),(1509,2,1663307130,'enrol_guest','status','1',NULL),(1510,2,1663307130,'enrol_guest','status_adv','',NULL),(1511,2,1663307130,'enrol_imsenterprise','imsfilelocation','',NULL),(1512,2,1663307130,'enrol_imsenterprise','logtolocation','',NULL),(1513,2,1663307130,'enrol_imsenterprise','mailadmins','0',NULL),(1514,2,1663307130,'enrol_imsenterprise','createnewusers','0',NULL),(1515,2,1663307130,'enrol_imsenterprise','imsupdateusers','0',NULL),(1516,2,1663307130,'enrol_imsenterprise','imsdeleteusers','0',NULL),(1517,2,1663307130,'enrol_imsenterprise','fixcaseusernames','0',NULL),(1518,2,1663307130,'enrol_imsenterprise','fixcasepersonalnames','0',NULL),(1519,2,1663307130,'enrol_imsenterprise','imssourcedidfallback','0',NULL),(1520,2,1663307130,'enrol_imsenterprise','imsrolemap01','5',NULL),(1521,2,1663307130,'enrol_imsenterprise','imsrolemap02','3',NULL),(1522,2,1663307130,'enrol_imsenterprise','imsrolemap03','3',NULL),(1523,2,1663307130,'enrol_imsenterprise','imsrolemap04','5',NULL),(1524,2,1663307130,'enrol_imsenterprise','imsrolemap05','0',NULL),(1525,2,1663307130,'enrol_imsenterprise','imsrolemap06','4',NULL),(1526,2,1663307130,'enrol_imsenterprise','imsrolemap07','0',NULL),(1527,2,1663307130,'enrol_imsenterprise','imsrolemap08','4',NULL),(1528,2,1663307130,'enrol_imsenterprise','truncatecoursecodes','0',NULL),(1529,2,1663307130,'enrol_imsenterprise','createnewcourses','0',NULL),(1530,2,1663307130,'enrol_imsenterprise','updatecourses','0',NULL),(1531,2,1663307130,'enrol_imsenterprise','createnewcategories','0',NULL),(1532,2,1663307130,'enrol_imsenterprise','nestedcategories','0',NULL),(1533,2,1663307130,'enrol_imsenterprise','categoryidnumber','0',NULL),(1534,2,1663307130,'enrol_imsenterprise','categoryseparator','',NULL),(1535,2,1663307130,'enrol_imsenterprise','imsunenrol','0',NULL),(1536,2,1663307130,'enrol_imsenterprise','imscoursemapshortname','coursecode',NULL),(1537,2,1663307130,'enrol_imsenterprise','imscoursemapfullname','short',NULL),(1538,2,1663307130,'enrol_imsenterprise','imscoursemapsummary','ignore',NULL),(1539,2,1663307130,'enrol_imsenterprise','imsrestricttarget','',NULL),(1540,2,1663307130,'enrol_imsenterprise','imscapitafix','0',NULL),(1541,2,1663307130,'enrol_ldap','host_url','',NULL),(1542,2,1663307130,'enrol_ldap','start_tls','0',NULL),(1543,2,1663307130,'enrol_ldap','ldap_version','3',NULL),(1544,2,1663307130,'enrol_ldap','ldapencoding','utf-8',NULL),(1545,2,1663307130,'enrol_ldap','pagesize','250',NULL),(1546,2,1663307130,'enrol_ldap','bind_dn','',NULL),(1547,2,1663307130,'enrol_ldap','bind_pw','',NULL),(1548,2,1663307130,'enrol_ldap','course_search_sub','0',NULL),(1549,2,1663307130,'enrol_ldap','memberattribute_isdn','0',NULL),(1550,2,1663307130,'enrol_ldap','user_contexts','',NULL),(1551,2,1663307130,'enrol_ldap','user_search_sub','0',NULL),(1552,2,1663307130,'enrol_ldap','user_type','default',NULL),(1553,2,1663307130,'enrol_ldap','opt_deref','0',NULL),(1554,2,1663307130,'enrol_ldap','idnumber_attribute','',NULL),(1555,2,1663307130,'enrol_ldap','objectclass','',NULL),(1556,2,1663307130,'enrol_ldap','course_idnumber','',NULL),(1557,2,1663307130,'enrol_ldap','course_shortname','',NULL),(1558,2,1663307130,'enrol_ldap','course_fullname','',NULL),(1559,2,1663307130,'enrol_ldap','course_summary','',NULL),(1560,2,1663307130,'enrol_ldap','ignorehiddencourses','0',NULL),(1561,2,1663307130,'enrol_ldap','unenrolaction','0',NULL),(1562,2,1663307130,'enrol_ldap','autocreate','0',NULL),(1563,2,1663307130,'enrol_ldap','category','1',NULL),(1564,2,1663307130,'enrol_ldap','template','',NULL),(1565,2,1663307130,'enrol_ldap','course_shortname_updateonsync','0',NULL),(1566,2,1663307130,'enrol_ldap','course_fullname_updateonsync','0',NULL),(1567,2,1663307130,'enrol_ldap','course_summary_updateonsync','0',NULL),(1568,2,1663307130,'enrol_ldap','nested_groups','0',NULL),(1569,2,1663307130,'enrol_ldap','group_memberofattribute','',NULL),(1570,2,1663307130,'enrol_manual','expiredaction','1',NULL),(1571,2,1663307130,'enrol_manual','expirynotifyhour','6',NULL),(1572,2,1663307130,'enrol_manual','defaultenrol','1',NULL),(1573,2,1663307130,'enrol_manual','status','0',NULL),(1574,2,1663307130,'enrol_manual','roleid','5',NULL),(1575,2,1663307130,'enrol_manual','enrolstart','4',NULL),(1576,2,1663307130,'enrol_manual','enrolperiod','0',NULL),(1577,2,1663307130,'enrol_manual','expirynotify','0',NULL),(1578,2,1663307130,'enrol_manual','expirythreshold','86400',NULL),(1579,2,1663307130,'enrol_mnet','roleid','5',NULL),(1580,2,1663307130,'enrol_mnet','roleid_adv','1',NULL),(1581,2,1663307130,'enrol_paypal','paypalbusiness','',NULL),(1582,2,1663307130,'enrol_paypal','mailstudents','0',NULL),(1583,2,1663307130,'enrol_paypal','mailteachers','0',NULL),(1584,2,1663307130,'enrol_paypal','mailadmins','0',NULL),(1585,2,1663307130,'enrol_paypal','expiredaction','3',NULL),(1586,2,1663307130,'enrol_paypal','status','1',NULL),(1587,2,1663307130,'enrol_paypal','cost','0',NULL),(1588,2,1663307130,'enrol_paypal','currency','USD',NULL),(1589,2,1663307130,'enrol_paypal','roleid','5',NULL),(1590,2,1663307130,'enrol_paypal','enrolperiod','0',NULL),(1591,2,1663307130,'enrol_lti','emaildisplay','2',NULL),(1592,2,1663307130,'enrol_lti','city','',NULL),(1593,2,1663307130,'enrol_lti','country','',NULL),(1594,2,1663307130,'enrol_lti','timezone','99',NULL),(1595,2,1663307130,'enrol_lti','lang','en',NULL),(1596,2,1663307130,'enrol_lti','institution','',NULL),(1597,2,1663307130,'enrol_self','requirepassword','0',NULL),(1598,2,1663307130,'enrol_self','usepasswordpolicy','0',NULL),(1599,2,1663307130,'enrol_self','showhint','0',NULL),(1600,2,1663307130,'enrol_self','expiredaction','1',NULL),(1601,2,1663307130,'enrol_self','expirynotifyhour','6',NULL),(1602,2,1663307130,'enrol_self','defaultenrol','1',NULL),(1603,2,1663307130,'enrol_self','status','1',NULL),(1604,2,1663307130,'enrol_self','newenrols','1',NULL),(1605,2,1663307130,'enrol_self','groupkey','0',NULL),(1606,2,1663307130,'enrol_self','roleid','5',NULL),(1607,2,1663307130,'enrol_self','enrolperiod','0',NULL),(1608,2,1663307130,'enrol_self','expirynotify','0',NULL),(1609,2,1663307130,'enrol_self','expirythreshold','86400',NULL),(1610,2,1663307130,'enrol_self','longtimenosee','0',NULL),(1611,2,1663307130,'enrol_self','maxenrolled','0',NULL),(1612,2,1663307130,'enrol_self','sendcoursewelcomemessage','1',NULL),(1613,2,1663307130,'filter_urltolink','formats','1,4,0',NULL),(1614,2,1663307130,'filter_urltolink','embedimages','1',NULL),(1615,2,1663307130,'filter_emoticon','formats','1,4,0',NULL),(1616,2,1663307130,'filter_displayh5p','allowedsources','',NULL),(1617,2,1663307130,'filter_mathjaxloader','httpsurl','https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js',NULL),(1618,2,1663307130,'filter_mathjaxloader','texfiltercompatibility','0',NULL),(1619,2,1663307130,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n',NULL),(1620,2,1663307130,'filter_mathjaxloader','additionaldelimiters','',NULL),(1621,2,1663307130,NULL,'filter_multilang_force_old','0',NULL),(1622,2,1663307130,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n',NULL),(1623,2,1663307130,'filter_tex','latexbackground','#FFFFFF',NULL),(1624,2,1663307130,'filter_tex','density','120',NULL),(1625,2,1663307130,'filter_tex','pathlatex','/usr/bin/latex',NULL),(1626,2,1663307130,'filter_tex','pathdvips','/usr/bin/dvips',NULL),(1627,2,1663307130,'filter_tex','pathconvert','/usr/bin/convert',NULL),(1628,2,1663307130,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm',NULL),(1629,2,1663307130,'filter_tex','pathmimetex','',NULL),(1630,2,1663307130,'filter_tex','convertformat','gif',NULL),(1631,2,1663307130,NULL,'filter_censor_badwords','',NULL),(1632,2,1663307130,'logstore_database','dbdriver','',NULL),(1633,2,1663307130,'logstore_database','dbhost','',NULL),(1634,2,1663307130,'logstore_database','dbuser','',NULL),(1635,2,1663307130,'logstore_database','dbpass','',NULL),(1636,2,1663307130,'logstore_database','dbname','',NULL),(1637,2,1663307130,'logstore_database','dbtable','',NULL),(1638,2,1663307130,'logstore_database','dbpersist','0',NULL),(1639,2,1663307130,'logstore_database','dbsocket','',NULL),(1640,2,1663307130,'logstore_database','dbport','',NULL),(1641,2,1663307130,'logstore_database','dbschema','',NULL),(1642,2,1663307130,'logstore_database','dbcollation','',NULL),(1643,2,1663307130,'logstore_database','dbhandlesoptions','0',NULL),(1644,2,1663307130,'logstore_database','buffersize','50',NULL),(1645,2,1663307130,'logstore_database','jsonformat','1',NULL),(1646,2,1663307130,'logstore_database','logguests','0',NULL),(1647,2,1663307130,'logstore_database','includelevels','1,2,0',NULL),(1648,2,1663307130,'logstore_database','includeactions','c,r,u,d',NULL),(1649,2,1663307130,'logstore_legacy','loglegacy','0',NULL),(1650,2,1663307130,NULL,'logguests','1',NULL),(1651,2,1663307130,NULL,'loglifetime','0',NULL),(1652,2,1663307130,'logstore_standard','logguests','1',NULL),(1653,2,1663307130,'logstore_standard','jsonformat','1',NULL),(1654,2,1663307130,'logstore_standard','loglifetime','0',NULL),(1655,2,1663307130,'logstore_standard','buffersize','50',NULL),(1656,2,1663307130,'mlbackend_python','useserver','0',NULL),(1657,2,1663307130,'mlbackend_python','host','',NULL),(1658,2,1663307130,'mlbackend_python','port','0',NULL),(1659,2,1663307130,'mlbackend_python','secure','0',NULL),(1660,2,1663307130,'mlbackend_python','username','default',NULL),(1661,2,1663307130,'mlbackend_python','password','',NULL),(1662,2,1663307130,'media_videojs','videoextensions','html_video,media_source,.f4v,.flv',NULL),(1663,2,1663307130,'media_videojs','audioextensions','html_audio',NULL),(1664,2,1663307130,'media_videojs','rtmp','0',NULL),(1665,2,1663307130,'media_videojs','useflash','0',NULL),(1666,2,1663307130,'media_videojs','youtube','1',NULL),(1667,2,1663307130,'media_videojs','videocssclass','video-js',NULL),(1668,2,1663307130,'media_videojs','audiocssclass','video-js',NULL),(1669,2,1663307130,'media_videojs','limitsize','1',NULL),(1670,2,1663307130,'paygw_paypal','surcharge','0',NULL),(1671,2,1663307130,'qtype_multichoice','answerhowmany','1',NULL),(1672,2,1663307130,'qtype_multichoice','shuffleanswers','1',NULL),(1673,2,1663307130,'qtype_multichoice','answernumbering','abc',NULL),(1674,2,1663307130,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html',NULL),(1675,2,1663307130,'editor_atto','autosavefrequency','60',NULL),(1676,2,1663307130,'atto_collapse','showgroups','5',NULL),(1677,2,1663307130,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n',NULL),(1678,2,1663307130,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n',NULL),(1679,2,1663307130,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n',NULL),(1680,2,1663307130,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n',NULL),(1681,2,1663307130,'atto_recordrtc','allowedtypes','both',NULL),(1682,2,1663307130,'atto_recordrtc','audiobitrate','128000',NULL),(1683,2,1663307130,'atto_recordrtc','videobitrate','2500000',NULL),(1684,2,1663307130,'atto_recordrtc','timelimit','120',NULL),(1685,2,1663307130,'atto_table','allowborders','0',NULL),(1686,2,1663307130,'atto_table','allowbackgroundcolour','0',NULL),(1687,2,1663307130,'atto_table','allowwidth','0',NULL),(1688,2,1663307130,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen',NULL),(1689,2,1663307130,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings',NULL),(1690,2,1663307130,'editor_tinymce','customconfig','',NULL),(1691,2,1663307130,'tinymce_moodleemoticon','requireemoticon','1',NULL),(1692,2,1663307130,'tinymce_spellchecker','spellengine','',NULL),(1693,2,1663307130,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv',NULL),(1694,2,1663307130,NULL,'profileroles','5,4,3',NULL),(1695,2,1663307130,NULL,'coursecontact','3',NULL),(1696,2,1663307130,NULL,'frontpage','6',NULL),(1697,2,1663307130,NULL,'frontpageloggedin','6',NULL),(1698,2,1663307130,NULL,'maxcategorydepth','2',NULL),(1699,2,1663307130,NULL,'frontpagecourselimit','200',NULL),(1700,2,1663307130,NULL,'commentsperpage','15',NULL),(1701,2,1663307130,NULL,'defaultfrontpageroleid','8',NULL),(1702,2,1663307130,NULL,'messageinbound_enabled','0',NULL),(1703,2,1663307130,NULL,'messageinbound_mailbox','',NULL),(1704,2,1663307130,NULL,'messageinbound_domain','',NULL),(1705,2,1663307130,NULL,'messageinbound_host','',NULL),(1706,2,1663307130,NULL,'messageinbound_hostssl','ssl',NULL),(1707,2,1663307130,NULL,'messageinbound_hostuser','',NULL),(1708,2,1663307130,NULL,'messageinbound_hostpass','',NULL),(1709,2,1663307130,NULL,'enablemobilewebservice','0',NULL),(1710,2,1663307130,'tool_mobile','apppolicy','',NULL),(1711,2,1663307130,'tool_mobile','typeoflogin','1',NULL),(1712,2,1663307130,'tool_mobile','qrcodetype','1',NULL),(1713,2,1663307130,'tool_mobile','forcedurlscheme','moodlemobile',NULL),(1714,2,1663307130,'tool_mobile','minimumversion','',NULL),(1715,2,1663307130,NULL,'mobilecssurl','',NULL),(1716,2,1663307130,'tool_mobile','enablesmartappbanners','0',NULL),(1717,2,1663307130,'tool_mobile','iosappid','633359593',NULL),(1718,2,1663307130,'tool_mobile','androidappid','com.moodle.moodlemobile',NULL),(1719,2,1663307130,'tool_mobile','setuplink','https://download.moodle.org/mobile',NULL),(1720,2,1663307130,'tool_mobile','forcelogout','0',NULL),(1721,2,1663307130,'tool_mobile','disabledfeatures','',NULL),(1722,2,1663307130,'tool_mobile','custommenuitems','',NULL),(1723,2,1663307130,'tool_mobile','filetypeexclusionlist','',NULL),(1724,2,1663307130,'tool_mobile','customlangstrings','',NULL),(1725,2,1663307130,'tool_moodlenet','enablemoodlenet','0',NULL),(1726,2,1663307130,'tool_moodlenet','defaultmoodlenetname','MoodleNet Central',NULL),(1727,2,1663307130,'tool_moodlenet','defaultmoodlenet','https://moodle.net',NULL),(1728,2,1663307139,NULL,'timezone','Europe/London',NULL),(1729,2,1663307139,NULL,'registerauth','',NULL),(1730,2,1663307145,NULL,'noreplyaddress','',NULL),(1731,7,1663410066,'core','siteadmins','2, 7, 18, 19, 21','2, 7, 18, 19, 20, 21'),(1732,7,1663410073,'core','siteadmins','2, 7, 19, 21','2, 7, 18, 19, 21'),(1733,7,1663410078,'core','siteadmins','2, 7, 21','2, 7, 19, 21'),(1734,2,1663489692,NULL,'block_course_list_advanced_adminview','own',NULL),(1735,2,1663489693,NULL,'block_course_list_advanced_hideallcourseslink','1',NULL),(1736,2,1663489693,NULL,'block_course_list_advanced_showdeleteicon','1',NULL),(1737,2,1663489693,NULL,'block_course_list_advanced_usesphorphanedfiles','1',NULL),(1738,2,1663489693,NULL,'block_course_list_advanced_isallowedonfrontpage','1',NULL),(1739,2,1663489693,NULL,'block_course_list_advanced_isallowedonmypage','1',NULL),(1740,2,1663489693,NULL,'block_course_list_advanced_maxforsiteadmin','30',NULL),(1741,2,1663489693,NULL,'block_course_list_advanced_showcourseswithguestrole','1',NULL),(1742,2,1663490104,'catalogue','maintitle','Catalogue',NULL),(1743,2,1663490104,'catalogue','displayedlists','resources,activities,enrols,grades,reports,blocks',NULL),(1744,2,1663490104,'catalogue','getremotedata','1',NULL),(1745,2,1663490104,'catalogue','bgcolor','#fff',NULL),(1746,2,1663490104,'catalogue','courseviewonly','1',NULL),(1747,2,1663490485,'block_course_overview','showcategories','2',NULL),(1748,2,1663490485,'block_course_overview','keepfavourites','0',NULL),(1749,2,1663490485,'block_course_overview','defaulttab','1',NULL),(1750,2,1663490485,'block_course_overview','setmaxcourses','10',NULL),(1751,2,1663490485,'block_course_overview','setmaxcoursesmax','50',NULL),(1752,2,1663490600,'block_myoverview','displaygroupingallincludinghidden','1','0'),(1753,2,1663490623,NULL,'block_course_list_hideallcourseslink','1','0'),(1754,2,1663673748,NULL,'frontpage','','6'),(1755,2,1663673748,NULL,'frontpageloggedin','','6'),(1756,2,1663673781,NULL,'frontpageloggedin','6',''),(1757,2,1664018734,NULL,'debug','32767','0'),(1758,2,1664018734,NULL,'debugdisplay','1','0'),(1759,2,1664019465,NULL,'debugdisplay','0','1'),(1760,2,1664642372,NULL,'debugdisplay','1','0'),(1761,2,1664642622,NULL,'debugdisplay','0','1'),(1762,2,1665132474,NULL,'debugdisplay','1','0'),(1763,2,1665132694,NULL,'debugdisplay','0','1'),(1764,2,1665211742,NULL,'debugdisplay','1','0'),(1765,2,1665212100,NULL,'debugdisplay','0','1'),(1766,2,1665379204,NULL,'debugdisplay','1','0'),(1767,2,1665379320,NULL,'debugdisplay','0','1'),(1768,2,1665577982,NULL,'registerauth','email',''),(1769,76,1665579162,'auth_ldap','admin_tenantcontext','',NULL),(1770,76,1665579162,'auth_ldap','testrolecontext','',NULL),(1771,2,1665579225,'theme_fordson','preset','0',NULL),(1772,2,1665579225,'theme_fordson','presetfiles','',NULL),(1773,2,1665579225,'theme_fordson','pagelayout','5',NULL),(1774,2,1665579225,'theme_fordson','sectionlayout','6',NULL),(1775,2,1665579225,'theme_fordson','coursetilestyle','1',NULL),(1776,2,1665579225,'theme_fordson','marketingstyle','1',NULL),(1777,2,1665579225,'theme_fordson','blockdisplay','1',NULL),(1778,2,1665579225,'theme_fordson','showloginform','1',NULL),(1779,2,1665579225,'theme_fordson','enhancedmydashboard','1',NULL),(1780,2,1665579225,'theme_fordson','learningcontentpadding','125px',NULL),(1781,2,1665579225,'theme_fordson','headerimagepadding','200px',NULL),(1782,2,1665579225,'theme_fordson','gutterwidth','0rem',NULL),(1783,2,1665579225,'theme_fordson','blockwidthfordson','280px',NULL),(1784,2,1665579225,'theme_fordson','activityiconsize','32px',NULL),(1785,2,1665579225,'theme_fordson','frontpagemycoursessorting','1',NULL),(1786,2,1665579225,'theme_fordson','trimtitle','256',NULL),(1787,2,1665579225,'theme_fordson','titletooltip','0',NULL),(1788,2,1665579225,'theme_fordson','trimsummary','300',NULL),(1789,2,1665579225,'theme_fordson','courseboxheight','250px',NULL),(1790,2,1665579225,'theme_fordson','enablecategoryicon','0',NULL),(1791,2,1665579225,'theme_fordson','catsicon','folder',NULL),(1792,2,1665579225,'theme_fordson','showcourseheaderimage','1',NULL),(1793,2,1665579225,'theme_fordson','favicon','',NULL),(1794,2,1665579225,'theme_fordson','headerlogo','',NULL),(1795,2,1665579225,'theme_fordson','headerdefaultimage','',NULL),(1796,2,1665579225,'theme_fordson','backgroundimage','',NULL),(1797,2,1665579225,'theme_fordson','loginimage','',NULL),(1798,2,1665579225,'theme_fordson','scsspre','',NULL),(1799,2,1665579225,'theme_fordson','brandprimary','',NULL),(1800,2,1665579225,'theme_fordson','brandsuccess','',NULL),(1801,2,1665579225,'theme_fordson','brandwarning','',NULL),(1802,2,1665579225,'theme_fordson','branddanger','',NULL),(1803,2,1665579225,'theme_fordson','brandinfo','',NULL),(1804,2,1665579225,'theme_fordson','bodybackground','',NULL),(1805,2,1665579225,'theme_fordson','topnavbarbg','',NULL),(1806,2,1665579225,'theme_fordson','topnavbarteacherbg','',NULL),(1807,2,1665579225,'theme_fordson','breadcrumbbkg','',NULL),(1808,2,1665579225,'theme_fordson','cardbkg','',NULL),(1809,2,1665579225,'theme_fordson','drawerbkg','',NULL),(1810,2,1665579225,'theme_fordson','footerbkg','',NULL),(1811,2,1665579225,'theme_fordson','markettextbg','',NULL),(1812,2,1665579225,'theme_fordson','scss','',NULL),(1813,2,1665579225,'theme_fordson','fptextbox','',NULL),(1814,2,1665579225,'theme_fordson','fptextboxlogout','',NULL),(1815,2,1665579225,'theme_fordson','alertbox','',NULL),(1816,2,1665579225,'theme_fordson','coursemanagementtoggle','1',NULL),(1817,2,1665579225,'theme_fordson','coursemanagementtextbox','',NULL),(1818,2,1665579225,'theme_fordson','studentdashboardtextbox','',NULL),(1819,2,1665579225,'theme_fordson','navbarcolorswitch','1',NULL),(1820,2,1665579225,'theme_fordson','showactivitynav','1',NULL),(1821,2,1665579225,'theme_fordson','courseeditingcog','0',NULL),(1822,2,1665579225,'theme_fordson','showstudentgrades','1',NULL),(1823,2,1665579225,'theme_fordson','showstudentcompletion','1',NULL),(1824,2,1665579225,'theme_fordson','showcourseadminstudents','1',NULL),(1825,2,1665579225,'theme_fordson','displaymycourses','',NULL),(1826,2,1665579225,'theme_fordson','displaythiscourse','',NULL),(1827,2,1665579225,'theme_fordson','mycoursetitle','course',NULL),(1828,2,1665579225,'theme_fordson','shownavdrawer','1',NULL),(1829,2,1665579225,'theme_fordson','shownavclosed','',NULL),(1830,2,1665579225,'theme_fordson','iconwidth','100px',NULL),(1831,2,1665579225,'theme_fordson','createicon','edit',NULL),(1832,2,1665579225,'theme_fordson','createbuttontext','Create a Course',NULL),(1833,2,1665579225,'theme_fordson','createbuttonurl','http://148.72.245.159/m2/moodle/course/edit.php?category=1',NULL),(1834,2,1665579225,'theme_fordson','slideicon','',NULL),(1835,2,1665579225,'theme_fordson','slideiconbuttontext','',NULL),(1836,2,1665579225,'theme_fordson','slidetextbox','',NULL),(1837,2,1665579225,'theme_fordson','nav1icon','home',NULL),(1838,2,1665579225,'theme_fordson','nav1buttontext','Dashboard',NULL),(1839,2,1665579225,'theme_fordson','nav1buttonurl','http://148.72.245.159/m2/moodle/my/',NULL),(1840,2,1665579225,'theme_fordson','nav2icon','calendar',NULL),(1841,2,1665579225,'theme_fordson','nav2buttontext','Calendar',NULL),(1842,2,1665579225,'theme_fordson','nav2buttonurl','http://148.72.245.159/m2/moodle/calendar/view.php?view=month',NULL),(1843,2,1665579225,'theme_fordson','nav3icon','bookmark',NULL),(1844,2,1665579225,'theme_fordson','nav3buttontext','Badges',NULL),(1845,2,1665579225,'theme_fordson','nav3buttonurl','http://148.72.245.159/m2/moodle/badges/mybadges.php',NULL),(1846,2,1665579225,'theme_fordson','nav4icon','book',NULL),(1847,2,1665579225,'theme_fordson','nav4buttontext','All Courses',NULL),(1848,2,1665579225,'theme_fordson','nav4buttonurl','http://148.72.245.159/m2/moodle/course/',NULL),(1849,2,1665579225,'theme_fordson','nav5icon','',NULL),(1850,2,1665579225,'theme_fordson','nav5buttontext','',NULL),(1851,2,1665579225,'theme_fordson','nav5buttonurl','',NULL),(1852,2,1665579225,'theme_fordson','nav6icon','',NULL),(1853,2,1665579225,'theme_fordson','nav6buttontext','',NULL),(1854,2,1665579225,'theme_fordson','nav6buttonurl','',NULL),(1855,2,1665579225,'theme_fordson','nav7icon','',NULL),(1856,2,1665579225,'theme_fordson','nav7buttontext','',NULL),(1857,2,1665579225,'theme_fordson','nav7buttonurl','',NULL),(1858,2,1665579225,'theme_fordson','nav8icon','',NULL),(1859,2,1665579225,'theme_fordson','nav8buttontext','',NULL),(1860,2,1665579225,'theme_fordson','nav8buttonurl','',NULL),(1861,2,1665579225,'theme_fordson','modchoosercustomlabel','',NULL),(1862,2,1665579225,'theme_fordson','commonlyused','',NULL),(1863,2,1665579225,'theme_fordson','showonlycustomactivities','0',NULL),(1864,2,1665579225,'theme_fordson','showalltomanager','1',NULL),(1865,2,1665579225,'theme_fordson','showslideshow','0',NULL),(1866,2,1665579225,'theme_fordson','slideshowheight','250px',NULL),(1867,2,1665579225,'theme_fordson','slide1title','',NULL),(1868,2,1665579225,'theme_fordson','slide1content','',NULL),(1869,2,1665579225,'theme_fordson','slide1image','',NULL),(1870,2,1665579225,'theme_fordson','slide2title','',NULL),(1871,2,1665579226,'theme_fordson','slide2content','',NULL),(1872,2,1665579226,'theme_fordson','slide2image','',NULL),(1873,2,1665579226,'theme_fordson','slide3title','',NULL),(1874,2,1665579226,'theme_fordson','slide3content','',NULL),(1875,2,1665579226,'theme_fordson','slide3image','',NULL),(1876,2,1665579226,'theme_fordson','togglemarketing','2',NULL),(1877,2,1665579226,'theme_fordson','marketing1','',NULL),(1878,2,1665579226,'theme_fordson','marketing1image','',NULL),(1879,2,1665579226,'theme_fordson','marketing1content','',NULL),(1880,2,1665579226,'theme_fordson','marketing1buttontext','',NULL),(1881,2,1665579226,'theme_fordson','marketing1buttonurl','',NULL),(1882,2,1665579226,'theme_fordson','marketing1target','_self',NULL),(1883,2,1665579226,'theme_fordson','marketing2','',NULL),(1884,2,1665579226,'theme_fordson','marketing2image','',NULL),(1885,2,1665579226,'theme_fordson','marketing2content','',NULL),(1886,2,1665579226,'theme_fordson','marketing2buttontext','',NULL),(1887,2,1665579226,'theme_fordson','marketing2buttonurl','',NULL),(1888,2,1665579226,'theme_fordson','marketing2target','_self',NULL),(1889,2,1665579226,'theme_fordson','marketing3','',NULL),(1890,2,1665579226,'theme_fordson','marketing3image','',NULL),(1891,2,1665579226,'theme_fordson','marketing3content','',NULL),(1892,2,1665579226,'theme_fordson','marketing3buttontext','',NULL),(1893,2,1665579226,'theme_fordson','marketing3buttonurl','',NULL),(1894,2,1665579226,'theme_fordson','marketing3target','_self',NULL),(1895,2,1665579226,'theme_fordson','marketing4','',NULL),(1896,2,1665579226,'theme_fordson','marketing4image','',NULL),(1897,2,1665579226,'theme_fordson','marketing4content','',NULL),(1898,2,1665579226,'theme_fordson','marketing4buttontext','',NULL),(1899,2,1665579226,'theme_fordson','marketing4buttonurl','',NULL),(1900,2,1665579226,'theme_fordson','marketing4target','_self',NULL),(1901,2,1665579226,'theme_fordson','marketing5','',NULL),(1902,2,1665579226,'theme_fordson','marketing5image','',NULL),(1903,2,1665579226,'theme_fordson','marketing5content','',NULL),(1904,2,1665579226,'theme_fordson','marketing5buttontext','',NULL),(1905,2,1665579226,'theme_fordson','marketing5buttonurl','',NULL),(1906,2,1665579226,'theme_fordson','marketing5target','_self',NULL),(1907,2,1665579226,'theme_fordson','marketing6','',NULL),(1908,2,1665579226,'theme_fordson','marketing6image','',NULL),(1909,2,1665579226,'theme_fordson','marketing6content','',NULL),(1910,2,1665579226,'theme_fordson','marketing6buttontext','',NULL),(1911,2,1665579226,'theme_fordson','marketing6buttonurl','',NULL),(1912,2,1665579226,'theme_fordson','marketing6target','_self',NULL),(1913,2,1665579226,'theme_fordson','marketing7','',NULL),(1914,2,1665579226,'theme_fordson','marketing7image','',NULL),(1915,2,1665579226,'theme_fordson','marketing7content','',NULL),(1916,2,1665579226,'theme_fordson','marketing7buttontext','',NULL),(1917,2,1665579226,'theme_fordson','marketing7buttonurl','',NULL),(1918,2,1665579226,'theme_fordson','marketing7target','_self',NULL),(1919,2,1665579226,'theme_fordson','marketing8','',NULL),(1920,2,1665579226,'theme_fordson','marketing8image','',NULL),(1921,2,1665579226,'theme_fordson','marketing8content','',NULL),(1922,2,1665579226,'theme_fordson','marketing8buttontext','',NULL),(1923,2,1665579226,'theme_fordson','marketing8buttonurl','',NULL),(1924,2,1665579226,'theme_fordson','marketing8target','_self',NULL),(1925,2,1665579226,'theme_fordson','marketing9','',NULL),(1926,2,1665579226,'theme_fordson','marketing9image','',NULL),(1927,2,1665579226,'theme_fordson','marketing9content','',NULL),(1928,2,1665579226,'theme_fordson','marketing9buttontext','',NULL),(1929,2,1665579226,'theme_fordson','marketing9buttonurl','',NULL),(1930,2,1665579226,'theme_fordson','marketing9target','_self',NULL),(1931,2,1665579226,'theme_fordson','brandorganization','',NULL),(1932,2,1665579226,'theme_fordson','brandwebsite','',NULL),(1933,2,1665579226,'theme_fordson','brandphone','',NULL),(1934,2,1665579226,'theme_fordson','brandemail','',NULL),(1935,2,1665579226,'theme_fordson','footnote','',NULL),(1936,2,1665579226,'theme_fordson','website','',NULL),(1937,2,1665579226,'theme_fordson','blog','',NULL),(1938,2,1665579226,'theme_fordson','facebook','',NULL),(1939,2,1665579226,'theme_fordson','flickr','',NULL),(1940,2,1665579226,'theme_fordson','twitter','',NULL),(1941,2,1665579226,'theme_fordson','googleplus','',NULL),(1942,2,1665579226,'theme_fordson','linkedin','',NULL),(1943,2,1665579226,'theme_fordson','tumblr','',NULL),(1944,2,1665579226,'theme_fordson','pinterest','',NULL),(1945,2,1665579226,'theme_fordson','instagram','',NULL),(1946,2,1665579226,'theme_fordson','youtube','',NULL),(1947,2,1665579226,'theme_fordson','vimeo','',NULL),(1948,2,1665579226,'theme_fordson','skype','',NULL),(1949,2,1665579226,'theme_fordson','social1','',NULL),(1950,2,1665579226,'theme_fordson','socialicon1','home',NULL),(1951,2,1665579226,'theme_fordson','social2','',NULL),(1952,2,1665579226,'theme_fordson','socialicon2','home',NULL),(1953,2,1665579226,'theme_fordson','social3','',NULL),(1954,2,1665579226,'theme_fordson','socialicon3','home',NULL),(1955,2,1665579226,'theme_fordson','showcustomlogin','0',NULL),(1956,2,1665579226,'theme_fordson','logintopimage','',NULL),(1957,2,1665579226,'theme_fordson','fploginform','',NULL),(1958,2,1665579226,'theme_fordson','loginnav1icon','',NULL),(1959,2,1665579226,'theme_fordson','loginnav1titletext','',NULL),(1960,2,1665579226,'theme_fordson','loginnav1icontext','',NULL),(1961,2,1665579226,'theme_fordson','loginnav2icon','',NULL),(1962,2,1665579226,'theme_fordson','loginnav2titletext','',NULL),(1963,2,1665579226,'theme_fordson','loginnav2icontext','',NULL),(1964,2,1665579226,'theme_fordson','loginnav3icon','',NULL),(1965,2,1665579226,'theme_fordson','loginnav3titletext','',NULL),(1966,2,1665579226,'theme_fordson','loginnav3icontext','',NULL),(1967,2,1665579226,'theme_fordson','loginnav4icon','',NULL),(1968,2,1665579226,'theme_fordson','loginnav4titletext','',NULL),(1969,2,1665579226,'theme_fordson','loginnav4icontext','',NULL),(1970,2,1665579226,'theme_fordson','feature1text','',NULL),(1971,2,1665579226,'theme_fordson','feature1image','',NULL),(1972,2,1665579226,'theme_fordson','feature2text','',NULL),(1973,2,1665579226,'theme_fordson','feature2image','',NULL),(1974,2,1665579226,'theme_fordson','feature3text','',NULL),(1975,2,1665579226,'theme_fordson','feature3image','',NULL);
/*!40000 ALTER TABLE `mdl_config_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_config_plugins`
--

DROP TABLE IF EXISTS `mdl_config_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_config_plugins` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'core',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Moodle modules and plugins configuration variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_config_plugins`
--

LOCK TABLES `mdl_config_plugins` WRITE;
/*!40000 ALTER TABLE `mdl_config_plugins` DISABLE KEYS */;
INSERT INTO `mdl_config_plugins` VALUES (1,'question','multichoice_sortorder','1'),(2,'question','truefalse_sortorder','2'),(3,'question','match_sortorder','3'),(4,'question','shortanswer_sortorder','4'),(5,'question','numerical_sortorder','5'),(6,'question','essay_sortorder','6'),(7,'moodlecourse','visible','1'),(8,'moodlecourse','downloadcontentsitedefault','0'),(9,'moodlecourse','format','topics'),(10,'moodlecourse','maxsections','52'),(11,'moodlecourse','numsections','4'),(12,'moodlecourse','hiddensections','0'),(13,'moodlecourse','coursedisplay','0'),(14,'moodlecourse','courseenddateenabled','1'),(15,'moodlecourse','courseduration','31536000'),(16,'moodlecourse','lang',''),(17,'moodlecourse','newsitems','5'),(18,'moodlecourse','showgrades','1'),(19,'moodlecourse','showreports','0'),(20,'moodlecourse','showactivitydates','1'),(21,'moodlecourse','maxbytes','0'),(22,'moodlecourse','enablecompletion','1'),(23,'moodlecourse','showcompletionconditions','1'),(24,'moodlecourse','groupmode','0'),(25,'moodlecourse','groupmodeforce','0'),(26,'backup','loglifetime','30'),(27,'backup','backup_general_users','1'),(28,'backup','backup_general_users_locked',''),(29,'backup','backup_general_anonymize','0'),(30,'backup','backup_general_anonymize_locked',''),(31,'backup','backup_general_role_assignments','1'),(32,'backup','backup_general_role_assignments_locked',''),(33,'backup','backup_general_activities','1'),(34,'backup','backup_general_activities_locked',''),(35,'backup','backup_general_blocks','1'),(36,'backup','backup_general_blocks_locked',''),(37,'backup','backup_general_files','1'),(38,'backup','backup_general_files_locked',''),(39,'backup','backup_general_filters','1'),(40,'backup','backup_general_filters_locked',''),(41,'backup','backup_general_comments','1'),(42,'backup','backup_general_comments_locked',''),(43,'backup','backup_general_badges','1'),(44,'backup','backup_general_badges_locked',''),(45,'backup','backup_general_calendarevents','1'),(46,'backup','backup_general_calendarevents_locked',''),(47,'backup','backup_general_userscompletion','1'),(48,'backup','backup_general_userscompletion_locked',''),(49,'backup','backup_general_logs','0'),(50,'backup','backup_general_logs_locked',''),(51,'backup','backup_general_histories','0'),(52,'backup','backup_general_histories_locked',''),(53,'backup','backup_general_questionbank','1'),(54,'backup','backup_general_questionbank_locked',''),(55,'backup','backup_general_groups','1'),(56,'backup','backup_general_groups_locked',''),(57,'backup','backup_general_competencies','1'),(58,'backup','backup_general_competencies_locked',''),(59,'backup','backup_general_contentbankcontent','1'),(60,'backup','backup_general_contentbankcontent_locked',''),(61,'backup','backup_general_legacyfiles','1'),(62,'backup','backup_general_legacyfiles_locked',''),(63,'backup','import_general_maxresults','10'),(64,'backup','import_general_duplicate_admin_allowed','0'),(65,'backup','backup_import_permissions','0'),(66,'backup','backup_import_permissions_locked',''),(67,'backup','backup_import_activities','1'),(68,'backup','backup_import_activities_locked',''),(69,'backup','backup_import_blocks','1'),(70,'backup','backup_import_blocks_locked',''),(71,'backup','backup_import_filters','1'),(72,'backup','backup_import_filters_locked',''),(73,'backup','backup_import_calendarevents','1'),(74,'backup','backup_import_calendarevents_locked',''),(75,'backup','backup_import_questionbank','1'),(76,'backup','backup_import_questionbank_locked',''),(77,'backup','backup_import_groups','1'),(78,'backup','backup_import_groups_locked',''),(79,'backup','backup_import_competencies','1'),(80,'backup','backup_import_competencies_locked',''),(81,'backup','backup_import_contentbankcontent','1'),(82,'backup','backup_import_contentbankcontent_locked',''),(83,'backup','backup_import_legacyfiles','1'),(84,'backup','backup_import_legacyfiles_locked',''),(85,'backup','backup_auto_active','0'),(86,'backup','backup_auto_weekdays','0000000'),(87,'backup','backup_auto_hour','0'),(88,'backup','backup_auto_minute','0'),(89,'backup','backup_auto_storage','0'),(90,'backup','backup_auto_destination',''),(91,'backup','backup_auto_max_kept','1'),(92,'backup','backup_auto_delete_days','0'),(93,'backup','backup_auto_min_kept','0'),(94,'backup','backup_shortname','0'),(95,'backup','backup_auto_skip_hidden','1'),(96,'backup','backup_auto_skip_modif_days','30'),(97,'backup','backup_auto_skip_modif_prev','0'),(98,'backup','backup_auto_users','1'),(99,'backup','backup_auto_role_assignments','1'),(100,'backup','backup_auto_activities','1'),(101,'backup','backup_auto_blocks','1'),(102,'backup','backup_auto_files','1'),(103,'backup','backup_auto_filters','1'),(104,'backup','backup_auto_comments','1'),(105,'backup','backup_auto_badges','1'),(106,'backup','backup_auto_calendarevents','1'),(107,'backup','backup_auto_userscompletion','1'),(108,'backup','backup_auto_logs','0'),(109,'backup','backup_auto_histories','0'),(110,'backup','backup_auto_questionbank','1'),(111,'backup','backup_auto_groups','1'),(112,'backup','backup_auto_competencies','1'),(113,'backup','backup_auto_contentbankcontent','1'),(114,'backup','backup_auto_legacyfiles','1'),(115,'restore','restore_general_users','1'),(116,'restore','restore_general_users_locked',''),(117,'restore','restore_general_enrolments','1'),(118,'restore','restore_general_enrolments_locked',''),(119,'restore','restore_general_role_assignments','1'),(120,'restore','restore_general_role_assignments_locked',''),(121,'restore','restore_general_permissions','1'),(122,'restore','restore_general_permissions_locked',''),(123,'restore','restore_general_activities','1'),(124,'restore','restore_general_activities_locked',''),(125,'restore','restore_general_blocks','1'),(126,'restore','restore_general_blocks_locked',''),(127,'restore','restore_general_filters','1'),(128,'restore','restore_general_filters_locked',''),(129,'restore','restore_general_comments','1'),(130,'restore','restore_general_comments_locked',''),(131,'restore','restore_general_badges','1'),(132,'restore','restore_general_badges_locked',''),(133,'restore','restore_general_calendarevents','1'),(134,'restore','restore_general_calendarevents_locked',''),(135,'restore','restore_general_userscompletion','1'),(136,'restore','restore_general_userscompletion_locked',''),(137,'restore','restore_general_logs','1'),(138,'restore','restore_general_logs_locked',''),(139,'restore','restore_general_histories','1'),(140,'restore','restore_general_histories_locked',''),(141,'restore','restore_general_groups','1'),(142,'restore','restore_general_groups_locked',''),(143,'restore','restore_general_competencies','1'),(144,'restore','restore_general_competencies_locked',''),(145,'restore','restore_general_contentbankcontent','1'),(146,'restore','restore_general_contentbankcontent_locked',''),(147,'restore','restore_general_legacyfiles','1'),(148,'restore','restore_general_legacyfiles_locked',''),(149,'restore','restore_merge_overwrite_conf','0'),(150,'restore','restore_merge_overwrite_conf_locked',''),(151,'restore','restore_merge_course_fullname','1'),(152,'restore','restore_merge_course_fullname_locked',''),(153,'restore','restore_merge_course_shortname','1'),(154,'restore','restore_merge_course_shortname_locked',''),(155,'restore','restore_merge_course_startdate','1'),(156,'restore','restore_merge_course_startdate_locked',''),(157,'restore','restore_replace_overwrite_conf','0'),(158,'restore','restore_replace_overwrite_conf_locked',''),(159,'restore','restore_replace_course_fullname','1'),(160,'restore','restore_replace_course_fullname_locked',''),(161,'restore','restore_replace_course_shortname','1'),(162,'restore','restore_replace_course_shortname_locked',''),(163,'restore','restore_replace_course_startdate','1'),(164,'restore','restore_replace_course_startdate_locked',''),(165,'restore','restore_replace_keep_roles_and_enrolments','0'),(166,'restore','restore_replace_keep_roles_and_enrolments_locked',''),(167,'restore','restore_replace_keep_groups_and_groupings','0'),(168,'restore','restore_replace_keep_groups_and_groupings_locked',''),(169,'backup','backup_async_message_users','0'),(170,'backup','backup_async_message_subject','Moodle {operation} completed successfully'),(171,'backup','backup_async_message','Hi {user_firstname},<br/> Your {operation} (ID: {backupid}) has completed successfully. <br/><br/>You can access it here: {link}.'),(172,'analytics','modeinstruction',''),(173,'analytics','percentonline','0'),(174,'analytics','typeinstitution',''),(175,'analytics','levelinstitution',''),(176,'analytics','predictionsprocessor','\\mlbackend_php\\processor'),(177,'analytics','defaulttimesplittingsevaluation','\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),(178,'analytics','modeloutputdir',''),(179,'analytics','onlycli','1'),(180,'analytics','modeltimelimit','1200'),(181,'analytics','calclifetime','35'),(182,'core_competency','enabled','1'),(183,'core_competency','pushcourseratingstouserplans','1'),(184,'antivirus','notifyemail',''),(185,'antivirus','enablequarantine','0'),(186,'antivirus','quarantinetime','2419200'),(187,'cachestore_apcu','testperformance','0'),(188,'cachestore_memcached','testservers',''),(189,'cachestore_mongodb','testserver',''),(190,'cachestore_redis','test_server',''),(191,'cachestore_redis','test_password',''),(192,'question_preview','behaviour','deferredfeedback'),(193,'question_preview','correctness','1'),(194,'question_preview','marks','2'),(195,'question_preview','markdp','2'),(196,'question_preview','feedback','1'),(197,'question_preview','generalfeedback','1'),(198,'question_preview','rightanswer','1'),(199,'question_preview','history','0'),(200,'tool_task','enablerunnow','1'),(201,'theme_boost','preset','default.scss'),(202,'theme_boost','presetfiles',''),(203,'theme_boost','backgroundimage',''),(204,'theme_boost','brandcolor',''),(205,'theme_boost','scsspre',''),(206,'theme_boost','scss',''),(207,'theme_classic','navbardark','0'),(208,'theme_classic','preset','default.scss'),(209,'theme_classic','presetfiles',''),(210,'theme_classic','backgroundimage',''),(211,'theme_classic','brandcolor',''),(212,'theme_classic','scsspre',''),(213,'theme_classic','scss',''),(214,'core_admin','logo',''),(215,'core_admin','logocompact',''),(216,'core_admin','coursecolor1','#81ecec'),(217,'core_admin','coursecolor2','#74b9ff'),(218,'core_admin','coursecolor3','#a29bfe'),(219,'core_admin','coursecolor4','#dfe6e9'),(220,'core_admin','coursecolor5','#00b894'),(221,'core_admin','coursecolor6','#0984e3'),(222,'core_admin','coursecolor7','#b2bec3'),(223,'core_admin','coursecolor8','#fdcb6e'),(224,'core_admin','coursecolor9','#fd79a8'),(225,'core_admin','coursecolor10','#6c5ce7'),(226,'antivirus_clamav','version','2021051700'),(227,'availability_completion','version','2021051700'),(228,'availability_date','version','2021051700'),(229,'availability_grade','version','2021051700'),(230,'availability_group','version','2021051700'),(231,'availability_grouping','version','2021051700'),(232,'availability_profile','version','2021051700'),(233,'qtype_calculated','version','2021051700'),(234,'qtype_calculatedmulti','version','2021051700'),(235,'qtype_calculatedsimple','version','2021051700'),(236,'qtype_ddimageortext','version','2021051700'),(237,'qtype_ddmarker','version','2021051700'),(238,'qtype_ddwtos','version','2021051700'),(239,'qtype_description','version','2021051700'),(240,'qtype_essay','version','2021051700'),(241,'qtype_gapselect','version','2021051700'),(242,'qtype_match','version','2021051700'),(243,'qtype_missingtype','version','2021051700'),(244,'qtype_multianswer','version','2021051700'),(245,'qtype_multichoice','version','2021051700'),(246,'qtype_numerical','version','2021051700'),(247,'qtype_random','version','2021051700'),(248,'qtype_randomsamatch','version','2021051700'),(249,'qtype_shortanswer','version','2021051700'),(250,'qtype_truefalse','version','2021051700'),(251,'mod_assign','version','2021051700'),(252,'mod_assignment','version','2021051700'),(254,'mod_book','version','2021051700'),(255,'mod_chat','version','2021051700'),(256,'mod_choice','version','2021051700'),(257,'mod_data','version','2021051700'),(258,'mod_feedback','version','2021051700'),(260,'mod_folder','version','2021051700'),(262,'mod_forum','version','2021051700'),(263,'mod_glossary','version','2021051700'),(264,'mod_h5pactivity','version','2021051700'),(265,'mod_imscp','version','2021051700'),(267,'mod_label','version','2021051700'),(268,'mod_lesson','version','2021051700'),(269,'mod_lti','version','2021051700'),(271,'mod_lti','kid','de433d82c4655f946011'),(272,'mod_lti','privatekey','-----BEGIN PRIVATE KEY-----\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCpXofiQGbPRmcz\nGKTzlkT6JuvJWgkW46BLlQFeS3PuFqspv95cyjZ83YROhtuZEWN44PulNrzoYMHi\nF28qX0rjGIrloRcSQDbFXtaoHBVUN7yoosVmSQ7NPRVG+hSYMho4PDIktp3diPZl\nIxfHNJc2bkufLuQcZsnv9ACDukRLNDX2GdXsKYJQho4uXVD5vjqA0uQTbEc5c/Lw\nrMOQLoOVn8BQX4v6QJ0ayWVCl1iih5Khf/N15Phfm27/tyXKWd/bfPOVPZz6mUT6\nVJyR25OyqqCdvchU7jI3DN/zel4iSigb5Jo/PUM04n7IAHbFkRTPZW93bJDJzN5I\nL8SL3zntAgMBAAECggEAf0qLp9CtNCT+lNl1x5jtmHA+D6N6Z1iGdae0UpE0vQEO\nfR812NklYGz/7iDO1FjMQOIeXwonqiJmNS1VoCvkVY9xfKm4dEAMqgPgIpKQuS32\nvWswHvLTjA7XefOkHMqzCAa9zPfu57vzKwnX6iCtcPwuG6IbUPkz1gK1jEsm3rlR\n3oyePn7oskUmEhGQFrOFuVLpVV5j0JRqvLruFAbmHDgOrY2HTIyXfMYeLFMs4Tgo\nu5ORL/U1vaLiIF3kcxDXvSm/10JyC9UzZrNRRwcb0k6sKmhOll0BPYz9sWPOWl+z\n4kF7XedVPXAWC/b+KKtzHXv/Vv3a0O3gMZ/aIKMoAQKBgQDghq4AesxMVdktgxKQ\n9+6sbHe29NNXN6UvOhdt5FvWHVWFHr57NnThoIBBSGBPTMSImPLxYZJYgHshGwv0\n9PLUMKvd7WI4HK2Y51Pb8v4A+gcqSe4E5w2achFDy27KEmetAukcN66Njfn/Yzss\nrslFDh/X415cQz7/nHuvAK5SAQKBgQDBHH+rE/B1ZcAk0HH5a/3HYdIbG+LC02tX\nSzdgVNQLOIGO+92hzeJ3O73iwJ14xskFjfkIcYrA1FFFRkrLdSzxw19Ctlc+BQ5Z\nKPKwMeIwciNKdJLkF3YpZMmSrJ/KOpYqXFmIFaY3hDaszwGUP3KEdxU9wEI7ib88\nBkoYES9P7QKBgGWk8v7qmLRyJOiSrwQMCfPrAuNDwK16VoCj1tl8CQtMqluiiG81\nPwKp64YiYt9jjJGeVFVsa5k/SP66xNX3Ujs3cYb9oXpvmTNgfjlTryP4DOhbIbL8\nes8RlrlPTm+Sl3bem3OXzaDtxmCUpsRauGlXtJjCqQQxuUJ0sBWQxFoBAoGAUJMk\njexe640OFA5JUAoINLYTJa6H+kSeyCihLXeXlir4nAFpY4b1VEzAGSnHSsqeu8uW\nOjit7XFpi58dvDDjFOkxCTPtyPnxF7CnOm9F8nLdWMa1N6i2a+Ua2jFe5tF1MK2h\nyc9GsGlhKs+g2At1K+JIIaDjwdXizhfNuKcK960CgYBB6qPvjHMT23NcXX8QaYFY\ndehrw+m17uDXQrVTiakCzHKNPd6GBn2e8AlPSp5jA1ogwQYsG+Q0ks2rE5xkzgAy\nQAG5R/aKvb//AtYNHtGujTEOzGWL9QFHDHs2lvwy8zzf7tAVlSXjpt1xwQ7w7oMM\n3fDd7kqbZzqBJODp7PPvTA==\n-----END PRIVATE KEY-----\n'),(273,'mod_page','version','2021051700'),(275,'mod_quiz','version','2021051700'),(276,'mod_resource','version','2021051700'),(277,'mod_scorm','version','2021051700'),(278,'mod_survey','version','2021051700'),(280,'mod_url','version','2021051700'),(282,'mod_wiki','version','2021051700'),(284,'mod_workshop','version','2021051700'),(285,'auth_cas','version','2021051700'),(287,'auth_db','version','2021051700'),(289,'auth_email','version','2021051700'),(290,'auth_ldap','version','2021051700'),(292,'auth_lti','version','2021051700'),(293,'auth_manual','version','2021051700'),(294,'auth_mnet','version','2021051700'),(296,'auth_nologin','version','2021051700'),(297,'auth_none','version','2021051700'),(298,'auth_oauth2','version','2021051700'),(299,'auth_shibboleth','version','2021051700'),(301,'auth_webservice','version','2021051700'),(302,'calendartype_gregorian','version','2021051700'),(303,'customfield_checkbox','version','2021051700'),(304,'customfield_date','version','2021051700'),(305,'customfield_select','version','2021051700'),(306,'customfield_text','version','2021051700'),(307,'customfield_textarea','version','2021051700'),(308,'enrol_category','version','2021051700'),(310,'enrol_cohort','version','2021051700'),(311,'enrol_database','version','2021051700'),(313,'enrol_fee','version','2021051700'),(314,'enrol_flatfile','version','2021051700'),(316,'enrol_flatfile','map_1','manager'),(317,'enrol_flatfile','map_2','coursecreator'),(318,'enrol_flatfile','map_3','editingteacher'),(319,'enrol_flatfile','map_4','teacher'),(320,'enrol_flatfile','map_5','student'),(321,'enrol_flatfile','map_6','guest'),(322,'enrol_flatfile','map_7','user'),(323,'enrol_flatfile','map_8','frontpage'),(324,'enrol_guest','version','2021051700'),(325,'enrol_imsenterprise','version','2021051700'),(327,'enrol_ldap','version','2021051700'),(329,'enrol_lti','version','2021051700'),(330,'enrol_manual','version','2021051700'),(332,'enrol_meta','version','2021051700'),(334,'enrol_mnet','version','2021051700'),(335,'enrol_paypal','version','2021051700'),(336,'enrol_self','version','2021051700'),(338,'message_airnotifier','version','2021051700'),(340,'message','airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(341,'message','airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(342,'message','airnotifier_provider_enrol_manual_expiry_notification_permitted','permitted'),(343,'message','airnotifier_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(344,'message','airnotifier_provider_enrol_self_expiry_notification_permitted','permitted'),(345,'message','airnotifier_provider_mod_assign_assign_notification_permitted','permitted'),(346,'message','airnotifier_provider_mod_assignment_assignment_updates_permitted','permitted'),(347,'message','airnotifier_provider_mod_feedback_submission_permitted','permitted'),(348,'message','airnotifier_provider_mod_feedback_message_permitted','permitted'),(349,'message','airnotifier_provider_mod_forum_posts_permitted','permitted'),(350,'message','message_provider_mod_forum_posts_loggedin','email,airnotifier'),(351,'message','message_provider_mod_forum_posts_loggedoff','email,airnotifier'),(352,'message','airnotifier_provider_mod_forum_digests_permitted','permitted'),(353,'message','airnotifier_provider_mod_lesson_graded_essay_permitted','permitted'),(354,'message','message_provider_mod_lesson_graded_essay_loggedin','email,airnotifier'),(355,'message','message_provider_mod_lesson_graded_essay_loggedoff','email,airnotifier'),(356,'message','airnotifier_provider_mod_quiz_submission_permitted','permitted'),(357,'message','airnotifier_provider_mod_quiz_confirmation_permitted','permitted'),(358,'message','message_provider_mod_quiz_confirmation_loggedin','email,airnotifier'),(359,'message','message_provider_mod_quiz_confirmation_loggedoff','email,airnotifier'),(360,'message','airnotifier_provider_mod_quiz_attempt_overdue_permitted','permitted'),(361,'message','message_provider_mod_quiz_attempt_overdue_loggedin','email,airnotifier'),(362,'message','message_provider_mod_quiz_attempt_overdue_loggedoff','email,airnotifier'),(363,'message','airnotifier_provider_moodle_notices_permitted','permitted'),(364,'message','airnotifier_provider_moodle_errors_permitted','permitted'),(365,'message','airnotifier_provider_moodle_availableupdate_permitted','permitted'),(366,'message','airnotifier_provider_moodle_instantmessage_permitted','permitted'),(367,'message','airnotifier_provider_moodle_backup_permitted','permitted'),(368,'message','airnotifier_provider_moodle_courserequested_permitted','permitted'),(369,'message','airnotifier_provider_moodle_courserequestapproved_permitted','permitted'),(370,'message','message_provider_moodle_courserequestapproved_loggedin','email,airnotifier'),(371,'message','message_provider_moodle_courserequestapproved_loggedoff','email,airnotifier'),(372,'message','airnotifier_provider_moodle_courserequestrejected_permitted','permitted'),(373,'message','message_provider_moodle_courserequestrejected_loggedin','email,airnotifier'),(374,'message','message_provider_moodle_courserequestrejected_loggedoff','email,airnotifier'),(375,'message','airnotifier_provider_moodle_coursecompleted_permitted','permitted'),(376,'message','airnotifier_provider_moodle_badgerecipientnotice_permitted','permitted'),(377,'message','message_provider_moodle_badgerecipientnotice_loggedin','popup,airnotifier'),(378,'message','message_provider_moodle_badgerecipientnotice_loggedoff','popup,email,airnotifier'),(379,'message','airnotifier_provider_moodle_badgecreatornotice_permitted','permitted'),(380,'message','airnotifier_provider_moodle_competencyplancomment_permitted','permitted'),(381,'message','airnotifier_provider_moodle_competencyusercompcomment_permitted','permitted'),(382,'message','airnotifier_provider_moodle_insights_permitted','permitted'),(383,'message','message_provider_moodle_insights_loggedin','popup,airnotifier'),(384,'message','message_provider_moodle_insights_loggedoff','popup,email,airnotifier'),(385,'message','airnotifier_provider_moodle_messagecontactrequests_permitted','permitted'),(386,'message','message_provider_moodle_messagecontactrequests_loggedin','airnotifier'),(387,'message','message_provider_moodle_messagecontactrequests_loggedoff','email,airnotifier'),(388,'message','airnotifier_provider_moodle_asyncbackupnotification_permitted','permitted'),(389,'message','airnotifier_provider_moodle_gradenotifications_permitted','permitted'),(390,'message','airnotifier_provider_moodle_infected_permitted','permitted'),(391,'message_email','version','2021051700'),(393,'message','email_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(394,'message','message_provider_enrol_flatfile_flatfile_enrolment_loggedin','email'),(395,'message','message_provider_enrol_flatfile_flatfile_enrolment_loggedoff','email'),(396,'message','email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(397,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin','email'),(398,'message','message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff','email'),(399,'message','email_provider_enrol_manual_expiry_notification_permitted','permitted'),(400,'message','message_provider_enrol_manual_expiry_notification_loggedin','email'),(401,'message','message_provider_enrol_manual_expiry_notification_loggedoff','email'),(402,'message','email_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(403,'message','message_provider_enrol_paypal_paypal_enrolment_loggedin','email'),(404,'message','message_provider_enrol_paypal_paypal_enrolment_loggedoff','email'),(405,'message','email_provider_enrol_self_expiry_notification_permitted','permitted'),(406,'message','message_provider_enrol_self_expiry_notification_loggedin','email'),(407,'message','message_provider_enrol_self_expiry_notification_loggedoff','email'),(408,'message','email_provider_mod_assign_assign_notification_permitted','permitted'),(409,'message','message_provider_mod_assign_assign_notification_loggedin','email'),(410,'message','message_provider_mod_assign_assign_notification_loggedoff','email'),(411,'message','email_provider_mod_assignment_assignment_updates_permitted','permitted'),(412,'message','message_provider_mod_assignment_assignment_updates_loggedin','email'),(413,'message','message_provider_mod_assignment_assignment_updates_loggedoff','email'),(414,'message','email_provider_mod_feedback_submission_permitted','permitted'),(415,'message','message_provider_mod_feedback_submission_loggedin','email'),(416,'message','message_provider_mod_feedback_submission_loggedoff','email'),(417,'message','email_provider_mod_feedback_message_permitted','permitted'),(418,'message','message_provider_mod_feedback_message_loggedin','email'),(419,'message','message_provider_mod_feedback_message_loggedoff','email'),(420,'message','email_provider_mod_forum_posts_permitted','permitted'),(421,'message','email_provider_mod_forum_digests_permitted','permitted'),(422,'message','message_provider_mod_forum_digests_loggedin','email'),(423,'message','message_provider_mod_forum_digests_loggedoff','email'),(424,'message','email_provider_mod_lesson_graded_essay_permitted','permitted'),(425,'message','email_provider_mod_quiz_submission_permitted','permitted'),(426,'message','message_provider_mod_quiz_submission_loggedin','email'),(427,'message','message_provider_mod_quiz_submission_loggedoff','email'),(428,'message','email_provider_mod_quiz_confirmation_permitted','permitted'),(429,'message','email_provider_mod_quiz_attempt_overdue_permitted','permitted'),(430,'message','email_provider_moodle_notices_permitted','permitted'),(431,'message','message_provider_moodle_notices_loggedin','email'),(432,'message','message_provider_moodle_notices_loggedoff','email'),(433,'message','email_provider_moodle_errors_permitted','permitted'),(434,'message','message_provider_moodle_errors_loggedin','email'),(435,'message','message_provider_moodle_errors_loggedoff','email'),(436,'message','email_provider_moodle_availableupdate_permitted','permitted'),(437,'message','message_provider_moodle_availableupdate_loggedin','email'),(438,'message','message_provider_moodle_availableupdate_loggedoff','email'),(439,'message','email_provider_moodle_instantmessage_permitted','permitted'),(440,'message','message_provider_moodle_instantmessage_loggedoff','popup,email'),(441,'message','email_provider_moodle_backup_permitted','permitted'),(442,'message','message_provider_moodle_backup_loggedin','email'),(443,'message','message_provider_moodle_backup_loggedoff','email'),(444,'message','email_provider_moodle_courserequested_permitted','permitted'),(445,'message','message_provider_moodle_courserequested_loggedin','email'),(446,'message','message_provider_moodle_courserequested_loggedoff','email'),(447,'message','email_provider_moodle_courserequestapproved_permitted','permitted'),(448,'message','email_provider_moodle_courserequestrejected_permitted','permitted'),(449,'message','email_provider_moodle_coursecompleted_permitted','permitted'),(450,'message','message_provider_moodle_coursecompleted_loggedin','email'),(451,'message','message_provider_moodle_coursecompleted_loggedoff','email'),(452,'message','email_provider_moodle_badgerecipientnotice_permitted','permitted'),(453,'message','email_provider_moodle_badgecreatornotice_permitted','permitted'),(454,'message','message_provider_moodle_badgecreatornotice_loggedoff','email'),(455,'message','email_provider_moodle_competencyplancomment_permitted','permitted'),(456,'message','message_provider_moodle_competencyplancomment_loggedin','email'),(457,'message','message_provider_moodle_competencyplancomment_loggedoff','email'),(458,'message','email_provider_moodle_competencyusercompcomment_permitted','permitted'),(459,'message','message_provider_moodle_competencyusercompcomment_loggedin','email'),(460,'message','message_provider_moodle_competencyusercompcomment_loggedoff','email'),(461,'message','email_provider_moodle_insights_permitted','permitted'),(462,'message','email_provider_moodle_messagecontactrequests_permitted','permitted'),(463,'message','email_provider_moodle_asyncbackupnotification_permitted','permitted'),(464,'message','message_provider_moodle_asyncbackupnotification_loggedoff','popup,email'),(465,'message','email_provider_moodle_gradenotifications_permitted','permitted'),(466,'message','message_provider_moodle_gradenotifications_loggedoff','popup,email'),(467,'message','email_provider_moodle_infected_permitted','permitted'),(468,'message','message_provider_moodle_infected_loggedin','email'),(469,'message','message_provider_moodle_infected_loggedoff','email'),(470,'message_jabber','version','2021051700'),(472,'message','jabber_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(473,'message','jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(474,'message','jabber_provider_enrol_manual_expiry_notification_permitted','permitted'),(475,'message','jabber_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(476,'message','jabber_provider_enrol_self_expiry_notification_permitted','permitted'),(477,'message','jabber_provider_mod_assign_assign_notification_permitted','permitted'),(478,'message','jabber_provider_mod_assignment_assignment_updates_permitted','permitted'),(479,'message','jabber_provider_mod_feedback_submission_permitted','permitted'),(480,'message','jabber_provider_mod_feedback_message_permitted','permitted'),(481,'message','jabber_provider_mod_forum_posts_permitted','permitted'),(482,'message','jabber_provider_mod_forum_digests_permitted','permitted'),(483,'message','jabber_provider_mod_lesson_graded_essay_permitted','permitted'),(484,'message','jabber_provider_mod_quiz_submission_permitted','permitted'),(485,'message','jabber_provider_mod_quiz_confirmation_permitted','permitted'),(486,'message','jabber_provider_mod_quiz_attempt_overdue_permitted','permitted'),(487,'message','jabber_provider_moodle_notices_permitted','permitted'),(488,'message','jabber_provider_moodle_errors_permitted','permitted'),(489,'message','jabber_provider_moodle_availableupdate_permitted','permitted'),(490,'message','jabber_provider_moodle_instantmessage_permitted','permitted'),(491,'message','jabber_provider_moodle_backup_permitted','permitted'),(492,'message','jabber_provider_moodle_courserequested_permitted','permitted'),(493,'message','jabber_provider_moodle_courserequestapproved_permitted','permitted'),(494,'message','jabber_provider_moodle_courserequestrejected_permitted','permitted'),(495,'message','jabber_provider_moodle_coursecompleted_permitted','permitted'),(496,'message','jabber_provider_moodle_badgerecipientnotice_permitted','permitted'),(497,'message','jabber_provider_moodle_badgecreatornotice_permitted','permitted'),(498,'message','jabber_provider_moodle_competencyplancomment_permitted','permitted'),(499,'message','jabber_provider_moodle_competencyusercompcomment_permitted','permitted'),(500,'message','jabber_provider_moodle_insights_permitted','permitted'),(501,'message','jabber_provider_moodle_messagecontactrequests_permitted','permitted'),(502,'message','jabber_provider_moodle_asyncbackupnotification_permitted','permitted'),(503,'message','jabber_provider_moodle_gradenotifications_permitted','permitted'),(504,'message','jabber_provider_moodle_infected_permitted','permitted'),(505,'message_popup','version','2021051700'),(507,'message','popup_provider_enrol_flatfile_flatfile_enrolment_permitted','permitted'),(508,'message','popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted','permitted'),(509,'message','popup_provider_enrol_manual_expiry_notification_permitted','permitted'),(510,'message','popup_provider_enrol_paypal_paypal_enrolment_permitted','permitted'),(511,'message','popup_provider_enrol_self_expiry_notification_permitted','permitted'),(512,'message','popup_provider_mod_assign_assign_notification_permitted','permitted'),(513,'message','popup_provider_mod_assignment_assignment_updates_permitted','permitted'),(514,'message','popup_provider_mod_feedback_submission_permitted','permitted'),(515,'message','popup_provider_mod_feedback_message_permitted','permitted'),(516,'message','popup_provider_mod_forum_posts_permitted','permitted'),(517,'message','popup_provider_mod_forum_digests_permitted','permitted'),(518,'message','popup_provider_mod_lesson_graded_essay_permitted','permitted'),(519,'message','popup_provider_mod_quiz_submission_permitted','permitted'),(520,'message','popup_provider_mod_quiz_confirmation_permitted','permitted'),(521,'message','popup_provider_mod_quiz_attempt_overdue_permitted','permitted'),(522,'message','popup_provider_moodle_notices_permitted','permitted'),(523,'message','popup_provider_moodle_errors_permitted','permitted'),(524,'message','popup_provider_moodle_availableupdate_permitted','permitted'),(525,'message','popup_provider_moodle_instantmessage_permitted','permitted'),(526,'message','message_provider_moodle_instantmessage_loggedin','popup'),(527,'message','popup_provider_moodle_backup_permitted','permitted'),(528,'message','popup_provider_moodle_courserequested_permitted','permitted'),(529,'message','popup_provider_moodle_courserequestapproved_permitted','permitted'),(530,'message','popup_provider_moodle_courserequestrejected_permitted','permitted'),(531,'message','popup_provider_moodle_coursecompleted_permitted','permitted'),(532,'message','popup_provider_moodle_badgerecipientnotice_permitted','permitted'),(533,'message','popup_provider_moodle_badgecreatornotice_permitted','permitted'),(534,'message','popup_provider_moodle_competencyplancomment_permitted','permitted'),(535,'message','popup_provider_moodle_competencyusercompcomment_permitted','permitted'),(536,'message','popup_provider_moodle_insights_permitted','permitted'),(537,'message','popup_provider_moodle_messagecontactrequests_permitted','permitted'),(538,'message','popup_provider_moodle_asyncbackupnotification_permitted','permitted'),(539,'message','message_provider_moodle_asyncbackupnotification_loggedin','popup'),(540,'message','popup_provider_moodle_gradenotifications_permitted','permitted'),(541,'message','message_provider_moodle_gradenotifications_loggedin','popup'),(542,'message','popup_provider_moodle_infected_permitted','permitted'),(543,'block_accessreview','version','2021051700'),(544,'block_activity_modules','version','2021051700'),(545,'block_activity_results','version','2021051700'),(546,'block_admin_bookmarks','version','2021051700'),(547,'block_badges','version','2021051700'),(548,'block_blog_menu','version','2021051700'),(549,'block_blog_recent','version','2021051700'),(550,'block_blog_tags','version','2021051700'),(551,'block_calendar_month','version','2021051700'),(552,'block_calendar_upcoming','version','2021051700'),(553,'block_comments','version','2021051700'),(554,'block_completionstatus','version','2021051700'),(555,'block_course_list','version','2021051700'),(556,'block_course_summary','version','2021051700'),(557,'block_feedback','version','2021051700'),(559,'block_globalsearch','version','2021051700'),(560,'block_glossary_random','version','2021051700'),(561,'block_html','version','2021051700'),(562,'block_login','version','2021051700'),(563,'block_lp','version','2021051700'),(564,'block_mentees','version','2021051700'),(565,'block_mnet_hosts','version','2021051700'),(566,'block_myoverview','version','2021051700'),(567,'block_myprofile','version','2021051700'),(568,'block_navigation','version','2021051700'),(569,'block_news_items','version','2021051700'),(570,'block_online_users','version','2021051700'),(571,'block_private_files','version','2021051700'),(572,'block_quiz_results','version','2021051700'),(574,'block_recent_activity','version','2021051700'),(575,'block_recentlyaccessedcourses','version','2021051700'),(577,'block_recentlyaccesseditems','version','2021051700'),(578,'block_rss_client','version','2021051700'),(579,'block_search_forums','version','2021051700'),(580,'block_section_links','version','2021051700'),(581,'block_selfcompletion','version','2021051700'),(582,'block_settings','version','2021051700'),(583,'block_site_main_menu','version','2021051700'),(584,'block_social_activities','version','2021051700'),(585,'block_starredcourses','version','2021051700'),(586,'block_tag_flickr','version','2021051700'),(587,'block_tag_youtube','version','2021051700'),(589,'block_tags','version','2021051700'),(590,'block_timeline','version','2021051700'),(592,'media_html5audio','version','2021051700'),(593,'media_html5video','version','2021051700'),(594,'media_swf','version','2021051700'),(595,'media_videojs','version','2021051700'),(596,'media_vimeo','version','2021051700'),(597,'media_youtube','version','2021051700'),(598,'filter_activitynames','version','2021051700'),(600,'filter_algebra','version','2021051700'),(601,'filter_censor','version','2021051700'),(602,'filter_data','version','2021051700'),(604,'filter_displayh5p','version','2021051700'),(606,'filter_emailprotect','version','2021051700'),(607,'filter_emoticon','version','2021051700'),(609,'filter_glossary','version','2021051700'),(611,'filter_mathjaxloader','version','2021051700'),(613,'filter_mediaplugin','version','2021051700'),(615,'filter_multilang','version','2021051700'),(616,'filter_tex','version','2021051700'),(618,'filter_tidy','version','2021051700'),(619,'filter_urltolink','version','2021051700'),(621,'editor_atto','version','2021051700'),(623,'editor_textarea','version','2021051700'),(624,'editor_tinymce','version','2021051700'),(625,'format_singleactivity','version','2021051700'),(626,'format_social','version','2021051700'),(627,'format_topics','version','2021051700'),(628,'format_weeks','version','2021051700'),(629,'dataformat_csv','version','2021051700'),(630,'dataformat_excel','version','2021051700'),(631,'dataformat_html','version','2021051700'),(632,'dataformat_json','version','2021051700'),(633,'dataformat_ods','version','2021051700'),(634,'dataformat_pdf','version','2021051700'),(635,'profilefield_checkbox','version','2021051700'),(636,'profilefield_datetime','version','2021051700'),(637,'profilefield_menu','version','2021051700'),(638,'profilefield_social','version','2021051700'),(639,'profilefield_text','version','2021051700'),(640,'profilefield_textarea','version','2021051700'),(641,'report_backups','version','2021051700'),(642,'report_competency','version','2021051700'),(643,'report_completion','version','2021051700'),(645,'report_configlog','version','2021051700'),(646,'report_courseoverview','version','2021051700'),(647,'report_eventlist','version','2021051700'),(648,'report_infectedfiles','version','2021051700'),(649,'report_insights','version','2021051700'),(650,'report_log','version','2021051700'),(652,'report_loglive','version','2021051700'),(653,'report_outline','version','2021051700'),(655,'report_participation','version','2021051700'),(657,'report_performance','version','2021051700'),(658,'report_progress','version','2021051700'),(660,'report_questioninstances','version','2021051700'),(661,'report_security','version','2021051700'),(662,'report_stats','version','2021051700'),(664,'report_status','version','2021051700'),(665,'report_usersessions','version','2021051700'),(666,'gradeexport_ods','version','2021051700'),(667,'gradeexport_txt','version','2021051700'),(668,'gradeexport_xls','version','2021051700'),(669,'gradeexport_xml','version','2021051700'),(670,'gradeimport_csv','version','2021051700'),(671,'gradeimport_direct','version','2021051700'),(672,'gradeimport_xml','version','2021051700'),(673,'gradereport_grader','version','2021051700'),(674,'gradereport_history','version','2021051700'),(675,'gradereport_outcomes','version','2021051700'),(676,'gradereport_overview','version','2021051700'),(677,'gradereport_singleview','version','2021051700'),(678,'gradereport_user','version','2021051700'),(679,'gradingform_guide','version','2021051700'),(680,'gradingform_rubric','version','2021051700'),(681,'mlbackend_php','version','2021051700'),(682,'mlbackend_python','version','2021051700'),(683,'mnetservice_enrol','version','2021051700'),(684,'webservice_rest','version','2021051700'),(685,'webservice_soap','version','2021051700'),(686,'webservice_xmlrpc','version','2021051700'),(687,'repository_areafiles','version','2021051700'),(689,'areafiles','enablecourseinstances','0'),(690,'areafiles','enableuserinstances','0'),(691,'repository_boxnet','version','2021051700'),(692,'repository_contentbank','version','2021051700'),(694,'contentbank','enablecourseinstances','0'),(695,'contentbank','enableuserinstances','0'),(696,'repository_coursefiles','version','2021051700'),(697,'repository_dropbox','version','2021051700'),(698,'repository_equella','version','2021051700'),(699,'repository_filesystem','version','2021051700'),(700,'repository_flickr','version','2021051700'),(701,'repository_flickr_public','version','2021051700'),(702,'repository_googledocs','version','2021051700'),(703,'repository_local','version','2021051700'),(705,'local','enablecourseinstances','0'),(706,'local','enableuserinstances','0'),(707,'repository_merlot','version','2021051700'),(708,'repository_nextcloud','version','2021051700'),(709,'repository_onedrive','version','2021051700'),(710,'repository_picasa','version','2021051700'),(711,'repository_recent','version','2021051700'),(713,'recent','enablecourseinstances','0'),(714,'recent','enableuserinstances','0'),(715,'repository_s3','version','2021051700'),(716,'repository_skydrive','version','2021051700'),(717,'repository_upload','version','2021051700'),(719,'upload','enablecourseinstances','0'),(720,'upload','enableuserinstances','0'),(721,'repository_url','version','2021051700'),(723,'url','enablecourseinstances','0'),(724,'url','enableuserinstances','0'),(725,'repository_user','version','2021051700'),(727,'user','enablecourseinstances','0'),(728,'user','enableuserinstances','0'),(729,'repository_webdav','version','2021051700'),(730,'repository_wikimedia','version','2021051700'),(732,'wikimedia','enablecourseinstances','0'),(733,'wikimedia','enableuserinstances','0'),(734,'repository_youtube','version','2021051700'),(736,'portfolio_boxnet','version','2021051700'),(737,'portfolio_download','version','2021051700'),(738,'portfolio_flickr','version','2021051700'),(739,'portfolio_googledocs','version','2021051700'),(740,'portfolio_mahara','version','2021051700'),(741,'portfolio_picasa','version','2021051700'),(742,'search_simpledb','version','2021051700'),(744,'search_solr','version','2021051700'),(745,'qbehaviour_adaptive','version','2021051700'),(746,'qbehaviour_adaptivenopenalty','version','2021051700'),(747,'qbehaviour_deferredcbm','version','2021051700'),(748,'qbehaviour_deferredfeedback','version','2021051700'),(749,'qbehaviour_immediatecbm','version','2021051700'),(750,'qbehaviour_immediatefeedback','version','2021051700'),(751,'qbehaviour_informationitem','version','2021051700'),(752,'qbehaviour_interactive','version','2021051700'),(753,'qbehaviour_interactivecountback','version','2021051700'),(754,'qbehaviour_manualgraded','version','2021051700'),(756,'question','disabledbehaviours','manualgraded'),(757,'qbehaviour_missing','version','2021051700'),(758,'qformat_aiken','version','2021051700'),(759,'qformat_blackboard_six','version','2021051700'),(760,'qformat_examview','version','2021051700'),(761,'qformat_gift','version','2021051700'),(762,'qformat_missingword','version','2021051700'),(763,'qformat_multianswer','version','2021051700'),(764,'qformat_webct','version','2021051700'),(765,'qformat_xhtml','version','2021051700'),(766,'qformat_xml','version','2021051700'),(767,'tool_analytics','version','2021051700'),(768,'tool_availabilityconditions','version','2021051700'),(769,'tool_behat','version','2021051700'),(770,'tool_brickfield','version','2021051700'),(772,'tool_capability','version','2021051700'),(773,'tool_cohortroles','version','2021051700'),(774,'tool_customlang','version','2021051700'),(776,'tool_dataprivacy','version','2021051700'),(777,'message','airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(778,'message','email_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(779,'message','jabber_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(780,'message','popup_provider_tool_dataprivacy_contactdataprotectionofficer_permitted','permitted'),(781,'message','message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedin','email,popup'),(782,'message','message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedoff','email,popup'),(783,'message','airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(784,'message','email_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(785,'message','jabber_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(786,'message','popup_provider_tool_dataprivacy_datarequestprocessingresults_permitted','permitted'),(787,'message','message_provider_tool_dataprivacy_datarequestprocessingresults_loggedin','email,popup'),(788,'message','message_provider_tool_dataprivacy_datarequestprocessingresults_loggedoff','email,popup'),(789,'message','airnotifier_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(790,'message','email_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(791,'message','jabber_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(792,'message','popup_provider_tool_dataprivacy_notifyexceptions_permitted','permitted'),(793,'message','message_provider_tool_dataprivacy_notifyexceptions_loggedin','email'),(794,'message','message_provider_tool_dataprivacy_notifyexceptions_loggedoff','email'),(795,'tool_dbtransfer','version','2021051700'),(796,'tool_filetypes','version','2021051700'),(797,'tool_generator','version','2021051700'),(798,'tool_health','version','2021051700'),(799,'tool_httpsreplace','version','2021051700'),(800,'tool_innodb','version','2021051700'),(801,'tool_installaddon','version','2021051700'),(802,'tool_langimport','version','2021051700'),(803,'tool_licensemanager','version','2021051700'),(804,'tool_log','version','2021051700'),(806,'tool_log','enabled_stores','logstore_standard'),(807,'tool_lp','version','2021051700'),(808,'tool_lpimportcsv','version','2021051700'),(809,'tool_lpmigrate','version','2021051700'),(810,'tool_messageinbound','version','2021051700'),(811,'message','airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(812,'message','email_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(813,'message','jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(814,'message','popup_provider_tool_messageinbound_invalidrecipienthandler_permitted','permitted'),(815,'message','message_provider_tool_messageinbound_invalidrecipienthandler_loggedin','email'),(816,'message','message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff','email'),(817,'message','airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(818,'message','email_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(819,'message','jabber_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(820,'message','popup_provider_tool_messageinbound_messageprocessingerror_permitted','permitted'),(821,'message','message_provider_tool_messageinbound_messageprocessingerror_loggedin','email'),(822,'message','message_provider_tool_messageinbound_messageprocessingerror_loggedoff','email'),(823,'message','airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(824,'message','email_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(825,'message','jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(826,'message','popup_provider_tool_messageinbound_messageprocessingsuccess_permitted','permitted'),(827,'message','message_provider_tool_messageinbound_messageprocessingsuccess_loggedin','email'),(828,'message','message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff','email'),(829,'tool_mobile','version','2021051700'),(830,'tool_monitor','version','2021051700'),(831,'message','airnotifier_provider_tool_monitor_notification_permitted','permitted'),(832,'message','email_provider_tool_monitor_notification_permitted','permitted'),(833,'message','jabber_provider_tool_monitor_notification_permitted','permitted'),(834,'message','popup_provider_tool_monitor_notification_permitted','permitted'),(835,'message','message_provider_tool_monitor_notification_loggedin','email'),(836,'message','message_provider_tool_monitor_notification_loggedoff','email'),(837,'tool_moodlenet','version','2021051700'),(838,'tool_multilangupgrade','version','2021051700'),(839,'tool_oauth2','version','2021051700'),(840,'tool_phpunit','version','2021051700'),(841,'tool_policy','version','2021051700'),(842,'tool_profiling','version','2021051700'),(843,'tool_recyclebin','version','2021051700'),(844,'tool_replace','version','2021051700'),(845,'tool_spamcleaner','version','2021051700'),(846,'tool_task','version','2021051700'),(847,'tool_templatelibrary','version','2021051700'),(848,'tool_unsuproles','version','2021051700'),(850,'tool_uploadcourse','version','2021051700'),(851,'tool_uploaduser','version','2021051700'),(852,'tool_usertours','version','2021051700'),(854,'tool_xmldb','version','2021051700'),(855,'cachestore_apcu','version','2021051700'),(856,'cachestore_file','version','2021051700'),(857,'cachestore_memcached','version','2021051700'),(858,'cachestore_mongodb','version','2021051700'),(859,'cachestore_redis','version','2021051700'),(860,'cachestore_session','version','2021051700'),(861,'cachestore_static','version','2021051700'),(862,'cachelock_file','version','2021051700'),(863,'fileconverter_googledrive','version','2021051700'),(864,'fileconverter_unoconv','version','2021051700'),(866,'contenttype_h5p','version','2021051700'),(867,'theme_boost','version','2021051700'),(868,'theme_classic','version','2021051700'),(869,'h5plib_v124','version','2021051700'),(870,'paygw_paypal','version','2021051700'),(872,'assignsubmission_comments','version','2021051700'),(874,'assignsubmission_file','sortorder','1'),(875,'assignsubmission_comments','sortorder','2'),(876,'assignsubmission_onlinetext','sortorder','0'),(877,'assignsubmission_file','version','2021051700'),(878,'assignsubmission_onlinetext','version','2021051700'),(880,'assignfeedback_comments','version','2021051700'),(882,'assignfeedback_comments','sortorder','0'),(883,'assignfeedback_editpdf','sortorder','1'),(884,'assignfeedback_file','sortorder','3'),(885,'assignfeedback_offline','sortorder','2'),(886,'assignfeedback_editpdf','version','2021051701'),(888,'assignfeedback_file','version','2021051700'),(890,'assignfeedback_offline','version','2021051700'),(891,'assignment_offline','version','2021051700'),(892,'assignment_online','version','2021051700'),(893,'assignment_upload','version','2021051700'),(894,'assignment_uploadsingle','version','2021051700'),(895,'booktool_exportimscp','version','2021051700'),(896,'booktool_importhtml','version','2021051700'),(897,'booktool_print','version','2021051700'),(898,'datafield_checkbox','version','2021051700'),(899,'datafield_date','version','2021051700'),(900,'datafield_file','version','2021051700'),(901,'datafield_latlong','version','2021051700'),(902,'datafield_menu','version','2021051700'),(903,'datafield_multimenu','version','2021051700'),(904,'datafield_number','version','2021051700'),(905,'datafield_picture','version','2021051700'),(906,'datafield_radiobutton','version','2021051700'),(907,'datafield_text','version','2021051700'),(908,'datafield_textarea','version','2021051700'),(909,'datafield_url','version','2021051700'),(910,'datapreset_imagegallery','version','2021051700'),(911,'forumreport_summary','version','2021051700'),(912,'ltiservice_basicoutcomes','version','2021051700'),(913,'ltiservice_gradebookservices','version','2021051700'),(914,'ltiservice_memberships','version','2021051700'),(915,'ltiservice_profile','version','2021051700'),(916,'ltiservice_toolproxy','version','2021051700'),(917,'ltiservice_toolsettings','version','2021051700'),(918,'quiz_grading','version','2021051700'),(920,'quiz_overview','version','2021051700'),(922,'quiz_responses','version','2021051700'),(924,'quiz_statistics','version','2021051700'),(926,'quizaccess_delaybetweenattempts','version','2021051700'),(927,'quizaccess_ipaddress','version','2021051700'),(928,'quizaccess_numattempts','version','2021051700'),(929,'quizaccess_offlineattempts','version','2021051700'),(930,'quizaccess_openclosedate','version','2021051700'),(931,'quizaccess_password','version','2021051700'),(932,'quizaccess_seb','version','2021051700'),(934,'quizaccess_securewindow','version','2021051700'),(935,'quizaccess_timelimit','version','2021051700'),(936,'scormreport_basic','version','2021051700'),(937,'scormreport_graphs','version','2021051700'),(938,'scormreport_interactions','version','2021051700'),(939,'scormreport_objectives','version','2021051700'),(940,'workshopform_accumulative','version','2021051700'),(942,'workshopform_comments','version','2021051700'),(944,'workshopform_numerrors','version','2021051700'),(946,'workshopform_rubric','version','2021051700'),(948,'workshopallocation_manual','version','2021051700'),(949,'workshopallocation_random','version','2021051700'),(950,'workshopallocation_scheduled','version','2021051700'),(951,'workshopeval_best','version','2021051700'),(952,'atto_accessibilitychecker','version','2021051700'),(953,'atto_accessibilityhelper','version','2021051700'),(954,'atto_align','version','2021051700'),(955,'atto_backcolor','version','2021051700'),(956,'atto_bold','version','2021051700'),(957,'atto_charmap','version','2021051700'),(958,'atto_clear','version','2021051700'),(959,'atto_collapse','version','2021051700'),(960,'atto_emojipicker','version','2021051700'),(961,'atto_emoticon','version','2021051700'),(962,'atto_equation','version','2021051700'),(963,'atto_fontcolor','version','2021051700'),(964,'atto_h5p','version','2021051700'),(965,'atto_html','version','2021051700'),(966,'atto_image','version','2021051700'),(967,'atto_indent','version','2021051700'),(968,'atto_italic','version','2021051700'),(969,'atto_link','version','2021051700'),(970,'atto_managefiles','version','2021051700'),(971,'atto_media','version','2021051700'),(972,'atto_noautolink','version','2021051700'),(973,'atto_orderedlist','version','2021051700'),(974,'atto_recordrtc','version','2021051700'),(975,'atto_rtl','version','2021051700'),(976,'atto_strike','version','2021051700'),(977,'atto_subscript','version','2021051700'),(978,'atto_superscript','version','2021051700'),(979,'atto_table','version','2021051700'),(980,'atto_title','version','2021051700'),(981,'atto_underline','version','2021051700'),(982,'atto_undo','version','2021051700'),(983,'atto_unorderedlist','version','2021051700'),(984,'tinymce_ctrlhelp','version','2021051700'),(985,'tinymce_managefiles','version','2021051700'),(986,'tinymce_moodleemoticon','version','2021051700'),(987,'tinymce_moodleimage','version','2021051700'),(988,'tinymce_moodlemedia','version','2021051700'),(989,'tinymce_moodlenolink','version','2021051700'),(990,'tinymce_pdw','version','2021051700'),(991,'tinymce_spellchecker','version','2021051700'),(993,'tinymce_wrap','version','2021051700'),(994,'logstore_database','version','2021051700'),(995,'logstore_legacy','version','2021051700'),(996,'logstore_standard','version','2021051700'),(997,'tool_dataprivacy','contactdataprotectionofficer','0'),(998,'tool_dataprivacy','automaticdataexportapproval','0'),(999,'tool_dataprivacy','automaticdatadeletionapproval','0'),(1000,'tool_dataprivacy','automaticdeletionrequests','1'),(1001,'tool_dataprivacy','privacyrequestexpiry','604800'),(1002,'tool_dataprivacy','requireallenddatesforuserdeletion','1'),(1003,'tool_dataprivacy','showdataretentionsummary','1'),(1004,'tool_log','exportlog','1'),(1005,'analytics','logstore','logstore_standard'),(1006,'assign','feedback_plugin_for_gradebook','assignfeedback_comments'),(1007,'assign','showrecentsubmissions','0'),(1008,'assign','submissionreceipts','1'),(1009,'assign','submissionstatement','This submission is my own work, except where I have acknowledged the use of the works of other people.'),(1010,'assign','submissionstatementteamsubmission','This submission is the work of my group, except where we have acknowledged the use of the works of other people.'),(1011,'assign','submissionstatementteamsubmissionallsubmit','This submission is my own work as a group member, except where I have acknowledged the use of the works of other people.'),(1012,'assign','maxperpage','-1'),(1013,'assign','alwaysshowdescription','1'),(1014,'assign','alwaysshowdescription_adv',''),(1015,'assign','alwaysshowdescription_locked',''),(1016,'assign','allowsubmissionsfromdate','0'),(1017,'assign','allowsubmissionsfromdate_enabled','1'),(1018,'assign','allowsubmissionsfromdate_adv',''),(1019,'assign','duedate','604800'),(1020,'assign','duedate_enabled','1'),(1021,'assign','duedate_adv',''),(1022,'assign','cutoffdate','1209600'),(1023,'assign','cutoffdate_enabled',''),(1024,'assign','cutoffdate_adv',''),(1025,'assign','gradingduedate','1209600'),(1026,'assign','gradingduedate_enabled','1'),(1027,'assign','gradingduedate_adv',''),(1028,'assign','submissiondrafts','0'),(1029,'assign','submissiondrafts_adv',''),(1030,'assign','submissiondrafts_locked',''),(1031,'assign','requiresubmissionstatement','0'),(1032,'assign','requiresubmissionstatement_adv',''),(1033,'assign','requiresubmissionstatement_locked',''),(1034,'assign','attemptreopenmethod','none'),(1035,'assign','attemptreopenmethod_adv',''),(1036,'assign','attemptreopenmethod_locked',''),(1037,'assign','maxattempts','-1'),(1038,'assign','maxattempts_adv',''),(1039,'assign','maxattempts_locked',''),(1040,'assign','teamsubmission','0'),(1041,'assign','teamsubmission_adv',''),(1042,'assign','teamsubmission_locked',''),(1043,'assign','preventsubmissionnotingroup','0'),(1044,'assign','preventsubmissionnotingroup_adv',''),(1045,'assign','preventsubmissionnotingroup_locked',''),(1046,'assign','requireallteammemberssubmit','0'),(1047,'assign','requireallteammemberssubmit_adv',''),(1048,'assign','requireallteammemberssubmit_locked',''),(1049,'assign','teamsubmissiongroupingid',''),(1050,'assign','teamsubmissiongroupingid_adv',''),(1051,'assign','sendnotifications','0'),(1052,'assign','sendnotifications_adv',''),(1053,'assign','sendnotifications_locked',''),(1054,'assign','sendlatenotifications','0'),(1055,'assign','sendlatenotifications_adv',''),(1056,'assign','sendlatenotifications_locked',''),(1057,'assign','sendstudentnotifications','1'),(1058,'assign','sendstudentnotifications_adv',''),(1059,'assign','sendstudentnotifications_locked',''),(1060,'assign','blindmarking','0'),(1061,'assign','blindmarking_adv',''),(1062,'assign','blindmarking_locked',''),(1063,'assign','hidegrader','0'),(1064,'assign','hidegrader_adv',''),(1065,'assign','hidegrader_locked',''),(1066,'assign','markingworkflow','0'),(1067,'assign','markingworkflow_adv',''),(1068,'assign','markingworkflow_locked',''),(1069,'assign','markingallocation','0'),(1070,'assign','markingallocation_adv',''),(1071,'assign','markingallocation_locked',''),(1072,'assignsubmission_file','default','1'),(1073,'assignsubmission_file','maxfiles','20'),(1074,'assignsubmission_file','filetypes',''),(1075,'assignsubmission_file','maxbytes','0'),(1076,'assignsubmission_onlinetext','default','0'),(1077,'assignfeedback_comments','default','1'),(1078,'assignfeedback_comments','inline','0'),(1079,'assignfeedback_comments','inline_adv',''),(1080,'assignfeedback_comments','inline_locked',''),(1081,'assignfeedback_editpdf','default','1'),(1082,'assignfeedback_editpdf','stamps',''),(1083,'assignfeedback_file','default','0'),(1084,'assignfeedback_offline','default','0'),(1085,'book','numberingoptions','0,1,2,3'),(1086,'book','navoptions','0,1,2'),(1087,'book','numbering','1'),(1088,'book','navstyle','1'),(1089,'resource','framesize','130'),(1090,'resource','displayoptions','0,1,4,5,6'),(1091,'resource','printintro','1'),(1092,'resource','display','0'),(1093,'resource','showsize','0'),(1094,'resource','showtype','0'),(1095,'resource','showdate','0'),(1096,'resource','popupwidth','620'),(1097,'resource','popupheight','450'),(1098,'resource','filterfiles','0'),(1099,'folder','showexpanded','1'),(1100,'folder','maxsizetodownload','0'),(1101,'imscp','keepold','1'),(1102,'imscp','keepold_adv',''),(1103,'label','dndmedia','1'),(1104,'label','dndresizewidth','400'),(1105,'label','dndresizeheight','400'),(1106,'mod_lesson','mediafile',''),(1107,'mod_lesson','mediafile_adv','1'),(1108,'mod_lesson','mediawidth','640'),(1109,'mod_lesson','mediaheight','480'),(1110,'mod_lesson','mediaclose','0'),(1111,'mod_lesson','progressbar','0'),(1112,'mod_lesson','progressbar_adv',''),(1113,'mod_lesson','ongoing','0'),(1114,'mod_lesson','ongoing_adv','1'),(1115,'mod_lesson','displayleftmenu','0'),(1116,'mod_lesson','displayleftmenu_adv',''),(1117,'mod_lesson','displayleftif','0'),(1118,'mod_lesson','displayleftif_adv','1'),(1119,'mod_lesson','slideshow','0'),(1120,'mod_lesson','slideshow_adv','1'),(1121,'mod_lesson','slideshowwidth','640'),(1122,'mod_lesson','slideshowheight','480'),(1123,'mod_lesson','slideshowbgcolor','#FFFFFF'),(1124,'mod_lesson','maxanswers','5'),(1125,'mod_lesson','maxanswers_adv','1'),(1126,'mod_lesson','defaultfeedback','0'),(1127,'mod_lesson','defaultfeedback_adv','1'),(1128,'mod_lesson','activitylink',''),(1129,'mod_lesson','activitylink_adv','1'),(1130,'mod_lesson','timelimit','0'),(1131,'mod_lesson','timelimit_adv',''),(1132,'mod_lesson','password','0'),(1133,'mod_lesson','password_adv','1'),(1134,'mod_lesson','modattempts','0'),(1135,'mod_lesson','modattempts_adv',''),(1136,'mod_lesson','displayreview','0'),(1137,'mod_lesson','displayreview_adv',''),(1138,'mod_lesson','maximumnumberofattempts','1'),(1139,'mod_lesson','maximumnumberofattempts_adv',''),(1140,'mod_lesson','defaultnextpage','0'),(1141,'mod_lesson','defaultnextpage_adv','1'),(1142,'mod_lesson','numberofpagestoshow','1'),(1143,'mod_lesson','numberofpagestoshow_adv','1'),(1144,'mod_lesson','practice','0'),(1145,'mod_lesson','practice_adv',''),(1146,'mod_lesson','customscoring','1'),(1147,'mod_lesson','customscoring_adv','1'),(1148,'mod_lesson','retakesallowed','0'),(1149,'mod_lesson','retakesallowed_adv',''),(1150,'mod_lesson','handlingofretakes','0'),(1151,'mod_lesson','handlingofretakes_adv','1'),(1152,'mod_lesson','minimumnumberofquestions','0'),(1153,'mod_lesson','minimumnumberofquestions_adv','1'),(1154,'page','displayoptions','5'),(1155,'page','printheading','1'),(1156,'page','printintro','0'),(1157,'page','printlastmodified','1'),(1158,'page','display','5'),(1159,'page','popupwidth','620'),(1160,'page','popupheight','450'),(1161,'quiz','timelimit','0'),(1162,'quiz','timelimit_adv',''),(1163,'quiz','overduehandling','autosubmit'),(1164,'quiz','overduehandling_adv',''),(1165,'quiz','graceperiod','86400'),(1166,'quiz','graceperiod_adv',''),(1167,'quiz','graceperiodmin','60'),(1168,'quiz','attempts','0'),(1169,'quiz','attempts_adv',''),(1170,'quiz','grademethod','1'),(1171,'quiz','grademethod_adv',''),(1172,'quiz','maximumgrade','10'),(1173,'quiz','questionsperpage','1'),(1174,'quiz','questionsperpage_adv',''),(1175,'quiz','navmethod','free'),(1176,'quiz','navmethod_adv','1'),(1177,'quiz','shuffleanswers','1'),(1178,'quiz','shuffleanswers_adv',''),(1179,'quiz','preferredbehaviour','deferredfeedback'),(1180,'quiz','canredoquestions','0'),(1181,'quiz','canredoquestions_adv','1'),(1182,'quiz','attemptonlast','0'),(1183,'quiz','attemptonlast_adv','1'),(1184,'quiz','reviewattempt','69904'),(1185,'quiz','reviewcorrectness','69904'),(1186,'quiz','reviewmarks','69904'),(1187,'quiz','reviewspecificfeedback','69904'),(1188,'quiz','reviewgeneralfeedback','69904'),(1189,'quiz','reviewrightanswer','69904'),(1190,'quiz','reviewoverallfeedback','4368'),(1191,'quiz','showuserpicture','0'),(1192,'quiz','showuserpicture_adv',''),(1193,'quiz','decimalpoints','2'),(1194,'quiz','decimalpoints_adv',''),(1195,'quiz','questiondecimalpoints','-1'),(1196,'quiz','questiondecimalpoints_adv',''),(1197,'quiz','showblocks','0'),(1198,'quiz','showblocks_adv','1'),(1199,'quiz','quizpassword',''),(1200,'quiz','quizpassword_adv',''),(1201,'quiz','quizpassword_required',''),(1202,'quiz','subnet',''),(1203,'quiz','subnet_adv','1'),(1204,'quiz','delay1','0'),(1205,'quiz','delay1_adv','1'),(1206,'quiz','delay2','0'),(1207,'quiz','delay2_adv','1'),(1208,'quiz','browsersecurity','-'),(1209,'quiz','browsersecurity_adv','1'),(1210,'quiz','initialnumfeedbacks','2'),(1211,'quiz','autosaveperiod','60'),(1212,'quizaccess_seb','autoreconfigureseb','1'),(1213,'quizaccess_seb','showseblinks','seb,http'),(1214,'quizaccess_seb','downloadlink','https://safeexambrowser.org/download_en.html'),(1215,'quizaccess_seb','quizpasswordrequired','0'),(1216,'quizaccess_seb','displayblocksbeforestart','0'),(1217,'quizaccess_seb','displayblockswhenfinished','1'),(1218,'scorm','displaycoursestructure','0'),(1219,'scorm','displaycoursestructure_adv',''),(1220,'scorm','popup','0'),(1221,'scorm','popup_adv',''),(1222,'scorm','displayactivityname','1'),(1223,'scorm','framewidth','100'),(1224,'scorm','framewidth_adv','1'),(1225,'scorm','frameheight','500'),(1226,'scorm','frameheight_adv','1'),(1227,'scorm','winoptgrp_adv','1'),(1228,'scorm','scrollbars','0'),(1229,'scorm','directories','0'),(1230,'scorm','location','0'),(1231,'scorm','menubar','0'),(1232,'scorm','toolbar','0'),(1233,'scorm','status','0'),(1234,'scorm','skipview','0'),(1235,'scorm','skipview_adv','1'),(1236,'scorm','hidebrowse','0'),(1237,'scorm','hidebrowse_adv','1'),(1238,'scorm','hidetoc','0'),(1239,'scorm','hidetoc_adv','1'),(1240,'scorm','nav','1'),(1241,'scorm','nav_adv','1'),(1242,'scorm','navpositionleft','-100'),(1243,'scorm','navpositionleft_adv','1'),(1244,'scorm','navpositiontop','-100'),(1245,'scorm','navpositiontop_adv','1'),(1246,'scorm','collapsetocwinsize','767'),(1247,'scorm','collapsetocwinsize_adv','1'),(1248,'scorm','displayattemptstatus','1'),(1249,'scorm','displayattemptstatus_adv',''),(1250,'scorm','grademethod','1'),(1251,'scorm','maxgrade','100'),(1252,'scorm','maxattempt','0'),(1253,'scorm','whatgrade','0'),(1254,'scorm','forcecompleted','0'),(1255,'scorm','forcenewattempt','0'),(1256,'scorm','autocommit','0'),(1257,'scorm','masteryoverride','1'),(1258,'scorm','lastattemptlock','0'),(1259,'scorm','auto','0'),(1260,'scorm','updatefreq','0'),(1261,'scorm','scormstandard','0'),(1262,'scorm','allowtypeexternal','0'),(1263,'scorm','allowtypelocalsync','0'),(1264,'scorm','allowtypeexternalaicc','0'),(1265,'scorm','allowaicchacp','0'),(1266,'scorm','aicchacptimeout','30'),(1267,'scorm','aicchacpkeepsessiondata','1'),(1268,'scorm','aiccuserid','1'),(1269,'scorm','forcejavascript','1'),(1270,'scorm','allowapidebug','0'),(1271,'scorm','apidebugmask','.*'),(1272,'scorm','protectpackagedownloads','0'),(1273,'url','framesize','130'),(1274,'url','secretphrase',''),(1275,'url','rolesinparams','0'),(1276,'url','displayoptions','0,1,5,6'),(1277,'url','printintro','1'),(1278,'url','display','0'),(1279,'url','popupwidth','620'),(1280,'url','popupheight','450'),(1281,'workshop','grade','80'),(1282,'workshop','gradinggrade','20'),(1283,'workshop','gradedecimals','0'),(1284,'workshop','maxbytes','0'),(1285,'workshop','strategy','accumulative'),(1286,'workshop','examplesmode','0'),(1287,'workshopallocation_random','numofreviews','5'),(1288,'workshopform_numerrors','grade0','No'),(1289,'workshopform_numerrors','grade1','Yes'),(1290,'workshopeval_best','comparison','5'),(1291,'tool_brickfield','analysistype','0'),(1292,'tool_brickfield','deletehistoricaldata','1'),(1293,'tool_brickfield','batch','1000'),(1294,'tool_brickfield','perpage','50'),(1295,'tool_recyclebin','coursebinenable','1'),(1296,'tool_recyclebin','coursebinexpiry','604800'),(1297,'tool_recyclebin','categorybinenable','1'),(1298,'tool_recyclebin','categorybinexpiry','604800'),(1299,'tool_recyclebin','autohide','1'),(1300,'antivirus_clamav','runningmethod','commandline'),(1301,'antivirus_clamav','pathtoclam',''),(1302,'antivirus_clamav','pathtounixsocket',''),(1303,'antivirus_clamav','tcpsockethost',''),(1304,'antivirus_clamav','tcpsocketport','3310'),(1305,'antivirus_clamav','clamfailureonupload','tryagain'),(1306,'antivirus_clamav','tries','1'),(1307,'auth_cas','auth_name','CAS'),(1308,'auth_cas','auth_logo',''),(1309,'auth_cas','hostname',''),(1310,'auth_cas','baseuri',''),(1311,'auth_cas','port','0'),(1312,'auth_cas','casversion','2.0'),(1313,'auth_cas','language','CAS_Languages_English'),(1314,'auth_cas','proxycas','0'),(1315,'auth_cas','logoutcas','0'),(1316,'auth_cas','multiauth','0'),(1317,'auth_cas','certificate_check','0'),(1318,'auth_cas','certificate_path',''),(1319,'auth_cas','curl_ssl_version',''),(1320,'auth_cas','logout_return_url',''),(1321,'auth_cas','host_url',''),(1322,'auth_cas','ldap_version','3'),(1323,'auth_cas','start_tls','0'),(1324,'auth_cas','ldapencoding','utf-8'),(1325,'auth_cas','pagesize','250'),(1326,'auth_cas','bind_dn',''),(1327,'auth_cas','bind_pw',''),(1328,'auth_cas','user_type','default'),(1329,'auth_cas','contexts',''),(1330,'auth_cas','search_sub','0'),(1331,'auth_cas','opt_deref','0'),(1332,'auth_cas','user_attribute',''),(1333,'auth_cas','memberattribute',''),(1334,'auth_cas','memberattribute_isdn','0'),(1335,'auth_cas','objectclass',''),(1336,'auth_cas','attrcreators',''),(1337,'auth_cas','groupecreators',''),(1338,'auth_cas','removeuser','0'),(1339,'auth_cas','field_map_firstname',''),(1340,'auth_cas','field_updatelocal_firstname','oncreate'),(1341,'auth_cas','field_updateremote_firstname','0'),(1342,'auth_cas','field_lock_firstname','unlocked'),(1343,'auth_cas','field_map_lastname',''),(1344,'auth_cas','field_updatelocal_lastname','oncreate'),(1345,'auth_cas','field_updateremote_lastname','0'),(1346,'auth_cas','field_lock_lastname','unlocked'),(1347,'auth_cas','field_map_email',''),(1348,'auth_cas','field_updatelocal_email','oncreate'),(1349,'auth_cas','field_updateremote_email','0'),(1350,'auth_cas','field_lock_email','unlocked'),(1351,'auth_cas','field_map_city',''),(1352,'auth_cas','field_updatelocal_city','oncreate'),(1353,'auth_cas','field_updateremote_city','0'),(1354,'auth_cas','field_lock_city','unlocked'),(1355,'auth_cas','field_map_country',''),(1356,'auth_cas','field_updatelocal_country','oncreate'),(1357,'auth_cas','field_updateremote_country','0'),(1358,'auth_cas','field_lock_country','unlocked'),(1359,'auth_cas','field_map_lang',''),(1360,'auth_cas','field_updatelocal_lang','oncreate'),(1361,'auth_cas','field_updateremote_lang','0'),(1362,'auth_cas','field_lock_lang','unlocked'),(1363,'auth_cas','field_map_description',''),(1364,'auth_cas','field_updatelocal_description','oncreate'),(1365,'auth_cas','field_updateremote_description','0'),(1366,'auth_cas','field_lock_description','unlocked'),(1367,'auth_cas','field_map_idnumber',''),(1368,'auth_cas','field_updatelocal_idnumber','oncreate'),(1369,'auth_cas','field_updateremote_idnumber','0'),(1370,'auth_cas','field_lock_idnumber','unlocked'),(1371,'auth_cas','field_map_institution',''),(1372,'auth_cas','field_updatelocal_institution','oncreate'),(1373,'auth_cas','field_updateremote_institution','0'),(1374,'auth_cas','field_lock_institution','unlocked'),(1375,'auth_cas','field_map_department',''),(1376,'auth_cas','field_updatelocal_department','oncreate'),(1377,'auth_cas','field_updateremote_department','0'),(1378,'auth_cas','field_lock_department','unlocked'),(1379,'auth_cas','field_map_phone1',''),(1380,'auth_cas','field_updatelocal_phone1','oncreate'),(1381,'auth_cas','field_updateremote_phone1','0'),(1382,'auth_cas','field_lock_phone1','unlocked'),(1383,'auth_cas','field_map_phone2',''),(1384,'auth_cas','field_updatelocal_phone2','oncreate'),(1385,'auth_cas','field_updateremote_phone2','0'),(1386,'auth_cas','field_lock_phone2','unlocked'),(1387,'auth_cas','field_map_address',''),(1388,'auth_cas','field_updatelocal_address','oncreate'),(1389,'auth_cas','field_updateremote_address','0'),(1390,'auth_cas','field_lock_address','unlocked'),(1391,'auth_cas','field_map_firstnamephonetic',''),(1392,'auth_cas','field_updatelocal_firstnamephonetic','oncreate'),(1393,'auth_cas','field_updateremote_firstnamephonetic','0'),(1394,'auth_cas','field_lock_firstnamephonetic','unlocked'),(1395,'auth_cas','field_map_lastnamephonetic',''),(1396,'auth_cas','field_updatelocal_lastnamephonetic','oncreate'),(1397,'auth_cas','field_updateremote_lastnamephonetic','0'),(1398,'auth_cas','field_lock_lastnamephonetic','unlocked'),(1399,'auth_cas','field_map_middlename',''),(1400,'auth_cas','field_updatelocal_middlename','oncreate'),(1401,'auth_cas','field_updateremote_middlename','0'),(1402,'auth_cas','field_lock_middlename','unlocked'),(1403,'auth_cas','field_map_alternatename',''),(1404,'auth_cas','field_updatelocal_alternatename','oncreate'),(1405,'auth_cas','field_updateremote_alternatename','0'),(1406,'auth_cas','field_lock_alternatename','unlocked'),(1407,'auth_email','recaptcha','0'),(1408,'auth_email','field_lock_firstname','unlocked'),(1409,'auth_email','field_lock_lastname','unlocked'),(1410,'auth_email','field_lock_email','unlocked'),(1411,'auth_email','field_lock_city','unlocked'),(1412,'auth_email','field_lock_country','unlocked'),(1413,'auth_email','field_lock_lang','unlocked'),(1414,'auth_email','field_lock_description','unlocked'),(1415,'auth_email','field_lock_idnumber','unlocked'),(1416,'auth_email','field_lock_institution','unlocked'),(1417,'auth_email','field_lock_department','unlocked'),(1418,'auth_email','field_lock_phone1','unlocked'),(1419,'auth_email','field_lock_phone2','unlocked'),(1420,'auth_email','field_lock_address','unlocked'),(1421,'auth_email','field_lock_firstnamephonetic','unlocked'),(1422,'auth_email','field_lock_lastnamephonetic','unlocked'),(1423,'auth_email','field_lock_middlename','unlocked'),(1424,'auth_email','field_lock_alternatename','unlocked'),(1425,'auth_db','host','127.0.0.1'),(1426,'auth_db','type','mysqli'),(1427,'auth_db','sybasequoting','0'),(1428,'auth_db','name',''),(1429,'auth_db','user',''),(1430,'auth_db','pass',''),(1431,'auth_db','table',''),(1432,'auth_db','fielduser',''),(1433,'auth_db','fieldpass',''),(1434,'auth_db','passtype','plaintext'),(1435,'auth_db','extencoding','utf-8'),(1436,'auth_db','setupsql',''),(1437,'auth_db','debugauthdb','0'),(1438,'auth_db','changepasswordurl',''),(1439,'auth_db','removeuser','0'),(1440,'auth_db','updateusers','0'),(1441,'auth_db','field_map_firstname',''),(1442,'auth_db','field_updatelocal_firstname','oncreate'),(1443,'auth_db','field_updateremote_firstname','0'),(1444,'auth_db','field_lock_firstname','unlocked'),(1445,'auth_db','field_map_lastname',''),(1446,'auth_db','field_updatelocal_lastname','oncreate'),(1447,'auth_db','field_updateremote_lastname','0'),(1448,'auth_db','field_lock_lastname','unlocked'),(1449,'auth_db','field_map_email',''),(1450,'auth_db','field_updatelocal_email','oncreate'),(1451,'auth_db','field_updateremote_email','0'),(1452,'auth_db','field_lock_email','unlocked'),(1453,'auth_db','field_map_city',''),(1454,'auth_db','field_updatelocal_city','oncreate'),(1455,'auth_db','field_updateremote_city','0'),(1456,'auth_db','field_lock_city','unlocked'),(1457,'auth_db','field_map_country',''),(1458,'auth_db','field_updatelocal_country','oncreate'),(1459,'auth_db','field_updateremote_country','0'),(1460,'auth_db','field_lock_country','unlocked'),(1461,'auth_db','field_map_lang',''),(1462,'auth_db','field_updatelocal_lang','oncreate'),(1463,'auth_db','field_updateremote_lang','0'),(1464,'auth_db','field_lock_lang','unlocked'),(1465,'auth_db','field_map_description',''),(1466,'auth_db','field_updatelocal_description','oncreate'),(1467,'auth_db','field_updateremote_description','0'),(1468,'auth_db','field_lock_description','unlocked'),(1469,'auth_db','field_map_idnumber',''),(1470,'auth_db','field_updatelocal_idnumber','oncreate'),(1471,'auth_db','field_updateremote_idnumber','0'),(1472,'auth_db','field_lock_idnumber','unlocked'),(1473,'auth_db','field_map_institution',''),(1474,'auth_db','field_updatelocal_institution','oncreate'),(1475,'auth_db','field_updateremote_institution','0'),(1476,'auth_db','field_lock_institution','unlocked'),(1477,'auth_db','field_map_department',''),(1478,'auth_db','field_updatelocal_department','oncreate'),(1479,'auth_db','field_updateremote_department','0'),(1480,'auth_db','field_lock_department','unlocked'),(1481,'auth_db','field_map_phone1',''),(1482,'auth_db','field_updatelocal_phone1','oncreate'),(1483,'auth_db','field_updateremote_phone1','0'),(1484,'auth_db','field_lock_phone1','unlocked'),(1485,'auth_db','field_map_phone2',''),(1486,'auth_db','field_updatelocal_phone2','oncreate'),(1487,'auth_db','field_updateremote_phone2','0'),(1488,'auth_db','field_lock_phone2','unlocked'),(1489,'auth_db','field_map_address',''),(1490,'auth_db','field_updatelocal_address','oncreate'),(1491,'auth_db','field_updateremote_address','0'),(1492,'auth_db','field_lock_address','unlocked'),(1493,'auth_db','field_map_firstnamephonetic',''),(1494,'auth_db','field_updatelocal_firstnamephonetic','oncreate'),(1495,'auth_db','field_updateremote_firstnamephonetic','0'),(1496,'auth_db','field_lock_firstnamephonetic','unlocked'),(1497,'auth_db','field_map_lastnamephonetic',''),(1498,'auth_db','field_updatelocal_lastnamephonetic','oncreate'),(1499,'auth_db','field_updateremote_lastnamephonetic','0'),(1500,'auth_db','field_lock_lastnamephonetic','unlocked'),(1501,'auth_db','field_map_middlename',''),(1502,'auth_db','field_updatelocal_middlename','oncreate'),(1503,'auth_db','field_updateremote_middlename','0'),(1504,'auth_db','field_lock_middlename','unlocked'),(1505,'auth_db','field_map_alternatename',''),(1506,'auth_db','field_updatelocal_alternatename','oncreate'),(1507,'auth_db','field_updateremote_alternatename','0'),(1508,'auth_db','field_lock_alternatename','unlocked'),(1509,'auth_ldap','host_url',''),(1510,'auth_ldap','ldap_version','3'),(1511,'auth_ldap','start_tls','0'),(1512,'auth_ldap','ldapencoding','utf-8'),(1513,'auth_ldap','pagesize','250'),(1514,'auth_ldap','preventpassindb','0'),(1515,'auth_ldap','bind_dn',''),(1516,'auth_ldap','bind_pw',''),(1517,'auth_ldap','user_type','default'),(1518,'auth_ldap','contexts',''),(1519,'auth_ldap','search_sub','0'),(1520,'auth_ldap','opt_deref','0'),(1521,'auth_ldap','user_attribute',''),(1522,'auth_ldap','suspended_attribute',''),(1523,'auth_ldap','memberattribute',''),(1524,'auth_ldap','memberattribute_isdn','0'),(1525,'auth_ldap','objectclass',''),(1526,'auth_ldap','forcechangepassword','0'),(1527,'auth_ldap','stdchangepassword','0'),(1528,'auth_ldap','passtype','plaintext'),(1529,'auth_ldap','changepasswordurl',''),(1530,'auth_ldap','expiration','0'),(1531,'auth_ldap','expiration_warning',''),(1532,'auth_ldap','expireattr',''),(1533,'auth_ldap','gracelogins','0'),(1534,'auth_ldap','graceattr',''),(1535,'auth_ldap','auth_user_create','0'),(1536,'auth_ldap','create_context',''),(1537,'auth_ldap','managercontext',''),(1538,'auth_ldap','coursecreatorcontext',''),(1539,'auth_ldap','removeuser','0'),(1540,'auth_ldap','sync_suspended','0'),(1541,'auth_ldap','ntlmsso_enabled','0'),(1542,'auth_ldap','ntlmsso_subnet',''),(1543,'auth_ldap','ntlmsso_ie_fastpath','0'),(1544,'auth_ldap','ntlmsso_type','ntlm'),(1545,'auth_ldap','ntlmsso_remoteuserformat',''),(1546,'auth_ldap','field_map_firstname',''),(1547,'auth_ldap','field_updatelocal_firstname','oncreate'),(1548,'auth_ldap','field_updateremote_firstname','0'),(1549,'auth_ldap','field_lock_firstname','unlocked'),(1550,'auth_ldap','field_map_lastname',''),(1551,'auth_ldap','field_updatelocal_lastname','oncreate'),(1552,'auth_ldap','field_updateremote_lastname','0'),(1553,'auth_ldap','field_lock_lastname','unlocked'),(1554,'auth_ldap','field_map_email',''),(1555,'auth_ldap','field_updatelocal_email','oncreate'),(1556,'auth_ldap','field_updateremote_email','0'),(1557,'auth_ldap','field_lock_email','unlocked'),(1558,'auth_ldap','field_map_city',''),(1559,'auth_ldap','field_updatelocal_city','oncreate'),(1560,'auth_ldap','field_updateremote_city','0'),(1561,'auth_ldap','field_lock_city','unlocked'),(1562,'auth_ldap','field_map_country',''),(1563,'auth_ldap','field_updatelocal_country','oncreate'),(1564,'auth_ldap','field_updateremote_country','0'),(1565,'auth_ldap','field_lock_country','unlocked'),(1566,'auth_ldap','field_map_lang',''),(1567,'auth_ldap','field_updatelocal_lang','oncreate'),(1568,'auth_ldap','field_updateremote_lang','0'),(1569,'auth_ldap','field_lock_lang','unlocked'),(1570,'auth_ldap','field_map_description',''),(1571,'auth_ldap','field_updatelocal_description','oncreate'),(1572,'auth_ldap','field_updateremote_description','0'),(1573,'auth_ldap','field_lock_description','unlocked'),(1574,'auth_ldap','field_map_idnumber',''),(1575,'auth_ldap','field_updatelocal_idnumber','oncreate'),(1576,'auth_ldap','field_updateremote_idnumber','0'),(1577,'auth_ldap','field_lock_idnumber','unlocked'),(1578,'auth_ldap','field_map_institution',''),(1579,'auth_ldap','field_updatelocal_institution','oncreate'),(1580,'auth_ldap','field_updateremote_institution','0'),(1581,'auth_ldap','field_lock_institution','unlocked'),(1582,'auth_ldap','field_map_department',''),(1583,'auth_ldap','field_updatelocal_department','oncreate'),(1584,'auth_ldap','field_updateremote_department','0'),(1585,'auth_ldap','field_lock_department','unlocked'),(1586,'auth_ldap','field_map_phone1',''),(1587,'auth_ldap','field_updatelocal_phone1','oncreate'),(1588,'auth_ldap','field_updateremote_phone1','0'),(1589,'auth_ldap','field_lock_phone1','unlocked'),(1590,'auth_ldap','field_map_phone2',''),(1591,'auth_ldap','field_updatelocal_phone2','oncreate'),(1592,'auth_ldap','field_updateremote_phone2','0'),(1593,'auth_ldap','field_lock_phone2','unlocked'),(1594,'auth_ldap','field_map_address',''),(1595,'auth_ldap','field_updatelocal_address','oncreate'),(1596,'auth_ldap','field_updateremote_address','0'),(1597,'auth_ldap','field_lock_address','unlocked'),(1598,'auth_ldap','field_map_firstnamephonetic',''),(1599,'auth_ldap','field_updatelocal_firstnamephonetic','oncreate'),(1600,'auth_ldap','field_updateremote_firstnamephonetic','0'),(1601,'auth_ldap','field_lock_firstnamephonetic','unlocked'),(1602,'auth_ldap','field_map_lastnamephonetic',''),(1603,'auth_ldap','field_updatelocal_lastnamephonetic','oncreate'),(1604,'auth_ldap','field_updateremote_lastnamephonetic','0'),(1605,'auth_ldap','field_lock_lastnamephonetic','unlocked'),(1606,'auth_ldap','field_map_middlename',''),(1607,'auth_ldap','field_updatelocal_middlename','oncreate'),(1608,'auth_ldap','field_updateremote_middlename','0'),(1609,'auth_ldap','field_lock_middlename','unlocked'),(1610,'auth_ldap','field_map_alternatename',''),(1611,'auth_ldap','field_updatelocal_alternatename','oncreate'),(1612,'auth_ldap','field_updateremote_alternatename','0'),(1613,'auth_ldap','field_lock_alternatename','unlocked'),(1614,'auth_manual','expiration','0'),(1615,'auth_manual','expirationtime','30'),(1616,'auth_manual','expiration_warning','0'),(1617,'auth_manual','field_lock_firstname','unlocked'),(1618,'auth_manual','field_lock_lastname','unlocked'),(1619,'auth_manual','field_lock_email','unlocked'),(1620,'auth_manual','field_lock_city','unlocked'),(1621,'auth_manual','field_lock_country','unlocked'),(1622,'auth_manual','field_lock_lang','unlocked'),(1623,'auth_manual','field_lock_description','unlocked'),(1624,'auth_manual','field_lock_idnumber','unlocked'),(1625,'auth_manual','field_lock_institution','unlocked'),(1626,'auth_manual','field_lock_department','unlocked'),(1627,'auth_manual','field_lock_phone1','unlocked'),(1628,'auth_manual','field_lock_phone2','unlocked'),(1629,'auth_manual','field_lock_address','unlocked'),(1630,'auth_manual','field_lock_firstnamephonetic','unlocked'),(1631,'auth_manual','field_lock_lastnamephonetic','unlocked'),(1632,'auth_manual','field_lock_middlename','unlocked'),(1633,'auth_manual','field_lock_alternatename','unlocked'),(1634,'auth_mnet','rpc_negotiation_timeout','30'),(1635,'auth_none','field_lock_firstname','unlocked'),(1636,'auth_none','field_lock_lastname','unlocked'),(1637,'auth_none','field_lock_email','unlocked'),(1638,'auth_none','field_lock_city','unlocked'),(1639,'auth_none','field_lock_country','unlocked'),(1640,'auth_none','field_lock_lang','unlocked'),(1641,'auth_none','field_lock_description','unlocked'),(1642,'auth_none','field_lock_idnumber','unlocked'),(1643,'auth_none','field_lock_institution','unlocked'),(1644,'auth_none','field_lock_department','unlocked'),(1645,'auth_none','field_lock_phone1','unlocked'),(1646,'auth_none','field_lock_phone2','unlocked'),(1647,'auth_none','field_lock_address','unlocked'),(1648,'auth_none','field_lock_firstnamephonetic','unlocked'),(1649,'auth_none','field_lock_lastnamephonetic','unlocked'),(1650,'auth_none','field_lock_middlename','unlocked'),(1651,'auth_none','field_lock_alternatename','unlocked'),(1652,'auth_oauth2','field_lock_firstname','unlocked'),(1653,'auth_oauth2','field_lock_lastname','unlocked'),(1654,'auth_oauth2','field_lock_email','unlocked'),(1655,'auth_oauth2','field_lock_city','unlocked'),(1656,'auth_oauth2','field_lock_country','unlocked'),(1657,'auth_oauth2','field_lock_lang','unlocked'),(1658,'auth_oauth2','field_lock_description','unlocked'),(1659,'auth_oauth2','field_lock_idnumber','unlocked'),(1660,'auth_oauth2','field_lock_institution','unlocked'),(1661,'auth_oauth2','field_lock_department','unlocked'),(1662,'auth_oauth2','field_lock_phone1','unlocked'),(1663,'auth_oauth2','field_lock_phone2','unlocked'),(1664,'auth_oauth2','field_lock_address','unlocked'),(1665,'auth_oauth2','field_lock_firstnamephonetic','unlocked'),(1666,'auth_oauth2','field_lock_lastnamephonetic','unlocked'),(1667,'auth_oauth2','field_lock_middlename','unlocked'),(1668,'auth_oauth2','field_lock_alternatename','unlocked'),(1669,'auth_shibboleth','user_attribute',''),(1670,'auth_shibboleth','convert_data',''),(1671,'auth_shibboleth','alt_login','off'),(1672,'auth_shibboleth','organization_selection','urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),(1673,'auth_shibboleth','logout_handler',''),(1674,'auth_shibboleth','logout_return_url',''),(1675,'auth_shibboleth','login_name','Shibboleth Login'),(1676,'auth_shibboleth','auth_logo',''),(1677,'auth_shibboleth','auth_instructions','Use the <a href=\"http://148.72.245.159/m2/moodle/auth/shibboleth/index.php\">Shibboleth login</a> to get access via Shibboleth, if your institution supports it. Otherwise, use the normal login form shown here.'),(1678,'auth_shibboleth','changepasswordurl',''),(1679,'auth_shibboleth','field_map_firstname',''),(1680,'auth_shibboleth','field_updatelocal_firstname','oncreate'),(1681,'auth_shibboleth','field_lock_firstname','unlocked'),(1682,'auth_shibboleth','field_map_lastname',''),(1683,'auth_shibboleth','field_updatelocal_lastname','oncreate'),(1684,'auth_shibboleth','field_lock_lastname','unlocked'),(1685,'auth_shibboleth','field_map_email',''),(1686,'auth_shibboleth','field_updatelocal_email','oncreate'),(1687,'auth_shibboleth','field_lock_email','unlocked'),(1688,'auth_shibboleth','field_map_city',''),(1689,'auth_shibboleth','field_updatelocal_city','oncreate'),(1690,'auth_shibboleth','field_lock_city','unlocked'),(1691,'auth_shibboleth','field_map_country',''),(1692,'auth_shibboleth','field_updatelocal_country','oncreate'),(1693,'auth_shibboleth','field_lock_country','unlocked'),(1694,'auth_shibboleth','field_map_lang',''),(1695,'auth_shibboleth','field_updatelocal_lang','oncreate'),(1696,'auth_shibboleth','field_lock_lang','unlocked'),(1697,'auth_shibboleth','field_map_description',''),(1698,'auth_shibboleth','field_updatelocal_description','oncreate'),(1699,'auth_shibboleth','field_lock_description','unlocked'),(1700,'auth_shibboleth','field_map_idnumber',''),(1701,'auth_shibboleth','field_updatelocal_idnumber','oncreate'),(1702,'auth_shibboleth','field_lock_idnumber','unlocked'),(1703,'auth_shibboleth','field_map_institution',''),(1704,'auth_shibboleth','field_updatelocal_institution','oncreate'),(1705,'auth_shibboleth','field_lock_institution','unlocked'),(1706,'auth_shibboleth','field_map_department',''),(1707,'auth_shibboleth','field_updatelocal_department','oncreate'),(1708,'auth_shibboleth','field_lock_department','unlocked'),(1709,'auth_shibboleth','field_map_phone1',''),(1710,'auth_shibboleth','field_updatelocal_phone1','oncreate'),(1711,'auth_shibboleth','field_lock_phone1','unlocked'),(1712,'auth_shibboleth','field_map_phone2',''),(1713,'auth_shibboleth','field_updatelocal_phone2','oncreate'),(1714,'auth_shibboleth','field_lock_phone2','unlocked'),(1715,'auth_shibboleth','field_map_address',''),(1716,'auth_shibboleth','field_updatelocal_address','oncreate'),(1717,'auth_shibboleth','field_lock_address','unlocked'),(1718,'auth_shibboleth','field_map_firstnamephonetic',''),(1719,'auth_shibboleth','field_updatelocal_firstnamephonetic','oncreate'),(1720,'auth_shibboleth','field_lock_firstnamephonetic','unlocked'),(1721,'auth_shibboleth','field_map_lastnamephonetic',''),(1722,'auth_shibboleth','field_updatelocal_lastnamephonetic','oncreate'),(1723,'auth_shibboleth','field_lock_lastnamephonetic','unlocked'),(1724,'auth_shibboleth','field_map_middlename',''),(1725,'auth_shibboleth','field_updatelocal_middlename','oncreate'),(1726,'auth_shibboleth','field_lock_middlename','unlocked'),(1727,'auth_shibboleth','field_map_alternatename',''),(1728,'auth_shibboleth','field_updatelocal_alternatename','oncreate'),(1729,'auth_shibboleth','field_lock_alternatename','unlocked'),(1730,'block_accessreview','whattoshow','showboth'),(1731,'block_accessreview','errordisplay','showint'),(1732,'block_accessreview','toolpage','errors'),(1733,'block_activity_results','config_showbest','3'),(1734,'block_activity_results','config_showbest_locked',''),(1735,'block_activity_results','config_showworst','0'),(1736,'block_activity_results','config_showworst_locked',''),(1737,'block_activity_results','config_usegroups','0'),(1738,'block_activity_results','config_usegroups_locked',''),(1739,'block_activity_results','config_nameformat','1'),(1740,'block_activity_results','config_nameformat_locked',''),(1741,'block_activity_results','config_gradeformat','1'),(1742,'block_activity_results','config_gradeformat_locked',''),(1743,'block_activity_results','config_decimalpoints','2'),(1744,'block_activity_results','config_decimalpoints_locked',''),(1745,'block_myoverview','displaycategories','1'),(1746,'block_myoverview','layouts','card,list,summary'),(1747,'block_myoverview','displaygroupingallincludinghidden','1'),(1748,'block_myoverview','displaygroupingall','1'),(1749,'block_myoverview','displaygroupinginprogress','1'),(1750,'block_myoverview','displaygroupingpast','1'),(1751,'block_myoverview','displaygroupingfuture','1'),(1752,'block_myoverview','displaygroupingcustomfield','0'),(1753,'block_myoverview','customfiltergrouping',''),(1754,'block_myoverview','displaygroupingfavourites','1'),(1755,'block_myoverview','displaygroupinghidden','1'),(1756,'block_recentlyaccessedcourses','displaycategories','1'),(1757,'block_section_links','numsections1','22'),(1758,'block_section_links','incby1','2'),(1759,'block_section_links','numsections2','40'),(1760,'block_section_links','incby2','5'),(1761,'block_section_links','showsectionname','0'),(1762,'block_starredcourses','displaycategories','1'),(1763,'block_tag_youtube','apikey',''),(1764,'format_singleactivity','activitytype','forum'),(1765,'fileconverter_googledrive','issuerid',''),(1766,'enrol_cohort','roleid','5'),(1767,'enrol_cohort','unenrolaction','0'),(1768,'enrol_meta','nosyncroleids',''),(1769,'enrol_meta','syncall','1'),(1770,'enrol_meta','unenrolaction','3'),(1771,'enrol_meta','coursesort','sortorder'),(1772,'enrol_fee','expiredaction','3'),(1773,'enrol_fee','status','1'),(1774,'enrol_fee','cost','0'),(1775,'enrol_fee','currency','USD'),(1776,'enrol_fee','roleid','5'),(1777,'enrol_fee','enrolperiod','0'),(1778,'enrol_database','dbtype',''),(1779,'enrol_database','dbhost','localhost'),(1780,'enrol_database','dbuser',''),(1781,'enrol_database','dbpass',''),(1782,'enrol_database','dbname',''),(1783,'enrol_database','dbencoding','utf-8'),(1784,'enrol_database','dbsetupsql',''),(1785,'enrol_database','dbsybasequoting','0'),(1786,'enrol_database','debugdb','0'),(1787,'enrol_database','localcoursefield','idnumber'),(1788,'enrol_database','localuserfield','idnumber'),(1789,'enrol_database','localrolefield','shortname'),(1790,'enrol_database','localcategoryfield','id'),(1791,'enrol_database','remoteenroltable',''),(1792,'enrol_database','remotecoursefield',''),(1793,'enrol_database','remoteuserfield',''),(1794,'enrol_database','remoterolefield',''),(1795,'enrol_database','remoteotheruserfield',''),(1796,'enrol_database','defaultrole','5'),(1797,'enrol_database','ignorehiddencourses','0'),(1798,'enrol_database','unenrolaction','0'),(1799,'enrol_database','newcoursetable',''),(1800,'enrol_database','newcoursefullname','fullname'),(1801,'enrol_database','newcourseshortname','shortname'),(1802,'enrol_database','newcourseidnumber','idnumber'),(1803,'enrol_database','newcoursecategory',''),(1804,'enrol_database','defaultcategory','1'),(1805,'enrol_database','templatecourse',''),(1806,'enrol_flatfile','location',''),(1807,'enrol_flatfile','encoding','UTF-8'),(1808,'enrol_flatfile','mailstudents','0'),(1809,'enrol_flatfile','mailteachers','0'),(1810,'enrol_flatfile','mailadmins','0'),(1811,'enrol_flatfile','unenrolaction','3'),(1812,'enrol_flatfile','expiredaction','3'),(1813,'enrol_guest','requirepassword','0'),(1814,'enrol_guest','usepasswordpolicy','0'),(1815,'enrol_guest','showhint','0'),(1816,'enrol_guest','defaultenrol','1'),(1817,'enrol_guest','status','1'),(1818,'enrol_guest','status_adv',''),(1819,'enrol_imsenterprise','imsfilelocation',''),(1820,'enrol_imsenterprise','logtolocation',''),(1821,'enrol_imsenterprise','mailadmins','0'),(1822,'enrol_imsenterprise','createnewusers','0'),(1823,'enrol_imsenterprise','imsupdateusers','0'),(1824,'enrol_imsenterprise','imsdeleteusers','0'),(1825,'enrol_imsenterprise','fixcaseusernames','0'),(1826,'enrol_imsenterprise','fixcasepersonalnames','0'),(1827,'enrol_imsenterprise','imssourcedidfallback','0'),(1828,'enrol_imsenterprise','imsrolemap01','5'),(1829,'enrol_imsenterprise','imsrolemap02','3'),(1830,'enrol_imsenterprise','imsrolemap03','3'),(1831,'enrol_imsenterprise','imsrolemap04','5'),(1832,'enrol_imsenterprise','imsrolemap05','0'),(1833,'enrol_imsenterprise','imsrolemap06','4'),(1834,'enrol_imsenterprise','imsrolemap07','0'),(1835,'enrol_imsenterprise','imsrolemap08','4'),(1836,'enrol_imsenterprise','truncatecoursecodes','0'),(1837,'enrol_imsenterprise','createnewcourses','0'),(1838,'enrol_imsenterprise','updatecourses','0'),(1839,'enrol_imsenterprise','createnewcategories','0'),(1840,'enrol_imsenterprise','nestedcategories','0'),(1841,'enrol_imsenterprise','categoryidnumber','0'),(1842,'enrol_imsenterprise','categoryseparator',''),(1843,'enrol_imsenterprise','imsunenrol','0'),(1844,'enrol_imsenterprise','imscoursemapshortname','coursecode'),(1845,'enrol_imsenterprise','imscoursemapfullname','short'),(1846,'enrol_imsenterprise','imscoursemapsummary','ignore'),(1847,'enrol_imsenterprise','imsrestricttarget',''),(1848,'enrol_imsenterprise','imscapitafix','0'),(1849,'enrol_ldap','host_url',''),(1850,'enrol_ldap','start_tls','0'),(1851,'enrol_ldap','ldap_version','3'),(1852,'enrol_ldap','ldapencoding','utf-8'),(1853,'enrol_ldap','pagesize','250'),(1854,'enrol_ldap','bind_dn',''),(1855,'enrol_ldap','bind_pw',''),(1856,'enrol_ldap','course_search_sub','0'),(1857,'enrol_ldap','memberattribute_isdn','0'),(1858,'enrol_ldap','user_contexts',''),(1859,'enrol_ldap','user_search_sub','0'),(1860,'enrol_ldap','user_type','default'),(1861,'enrol_ldap','opt_deref','0'),(1862,'enrol_ldap','idnumber_attribute',''),(1863,'enrol_ldap','objectclass','(objectClass=*)'),(1864,'enrol_ldap','course_idnumber',''),(1865,'enrol_ldap','course_shortname',''),(1866,'enrol_ldap','course_fullname',''),(1867,'enrol_ldap','course_summary',''),(1868,'enrol_ldap','ignorehiddencourses','0'),(1869,'enrol_ldap','unenrolaction','0'),(1870,'enrol_ldap','autocreate','0'),(1871,'enrol_ldap','category','1'),(1872,'enrol_ldap','template',''),(1873,'enrol_ldap','course_shortname_updateonsync','0'),(1874,'enrol_ldap','course_fullname_updateonsync','0'),(1875,'enrol_ldap','course_summary_updateonsync','0'),(1876,'enrol_ldap','nested_groups','0'),(1877,'enrol_ldap','group_memberofattribute',''),(1878,'enrol_manual','expiredaction','1'),(1879,'enrol_manual','expirynotifyhour','6'),(1880,'enrol_manual','defaultenrol','1'),(1881,'enrol_manual','status','0'),(1882,'enrol_manual','roleid','5'),(1883,'enrol_manual','enrolstart','4'),(1884,'enrol_manual','enrolperiod','0'),(1885,'enrol_manual','expirynotify','0'),(1886,'enrol_manual','expirythreshold','86400'),(1887,'enrol_mnet','roleid','5'),(1888,'enrol_mnet','roleid_adv','1'),(1889,'enrol_paypal','paypalbusiness',''),(1890,'enrol_paypal','mailstudents','0'),(1891,'enrol_paypal','mailteachers','0'),(1892,'enrol_paypal','mailadmins','0'),(1893,'enrol_paypal','expiredaction','3'),(1894,'enrol_paypal','status','1'),(1895,'enrol_paypal','cost','0'),(1896,'enrol_paypal','currency','USD'),(1897,'enrol_paypal','roleid','5'),(1898,'enrol_paypal','enrolperiod','0'),(1899,'enrol_lti','emaildisplay','2'),(1900,'enrol_lti','city',''),(1901,'enrol_lti','country',''),(1902,'enrol_lti','timezone','99'),(1903,'enrol_lti','lang','en'),(1904,'enrol_lti','institution',''),(1905,'enrol_self','requirepassword','0'),(1906,'enrol_self','usepasswordpolicy','0'),(1907,'enrol_self','showhint','0'),(1908,'enrol_self','expiredaction','1'),(1909,'enrol_self','expirynotifyhour','6'),(1910,'enrol_self','defaultenrol','1'),(1911,'enrol_self','status','1'),(1912,'enrol_self','newenrols','1'),(1913,'enrol_self','groupkey','0'),(1914,'enrol_self','roleid','5'),(1915,'enrol_self','enrolperiod','0'),(1916,'enrol_self','expirynotify','0'),(1917,'enrol_self','expirythreshold','86400'),(1918,'enrol_self','longtimenosee','0'),(1919,'enrol_self','maxenrolled','0'),(1920,'enrol_self','sendcoursewelcomemessage','1'),(1921,'filter_urltolink','formats','1,4,0'),(1922,'filter_urltolink','embedimages','1'),(1923,'filter_emoticon','formats','1,4,0'),(1924,'filter_displayh5p','allowedsources',''),(1925,'filter_mathjaxloader','httpsurl','https://cdn.jsdelivr.net/npm/mathjax@2.7.9/MathJax.js'),(1926,'filter_mathjaxloader','texfiltercompatibility','0'),(1927,'filter_mathjaxloader','mathjaxconfig','\nMathJax.Hub.Config({\n    config: [\"Accessible.js\", \"Safe.js\"],\n    errorSettings: { message: [\"!\"] },\n    skipStartupTypeset: true,\n    messageStyle: \"none\"\n});\n'),(1928,'filter_mathjaxloader','additionaldelimiters',''),(1929,'filter_tex','latexpreamble','\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),(1930,'filter_tex','latexbackground','#FFFFFF'),(1931,'filter_tex','density','120'),(1932,'filter_tex','pathlatex','/usr/bin/latex'),(1933,'filter_tex','pathdvips','/usr/bin/dvips'),(1934,'filter_tex','pathconvert','/usr/bin/convert'),(1935,'filter_tex','pathdvisvgm','/usr/bin/dvisvgm'),(1936,'filter_tex','pathmimetex',''),(1937,'filter_tex','convertformat','gif'),(1938,'logstore_database','dbdriver',''),(1939,'logstore_database','dbhost',''),(1940,'logstore_database','dbuser',''),(1941,'logstore_database','dbpass',''),(1942,'logstore_database','dbname',''),(1943,'logstore_database','dbtable',''),(1944,'logstore_database','dbpersist','0'),(1945,'logstore_database','dbsocket',''),(1946,'logstore_database','dbport',''),(1947,'logstore_database','dbschema',''),(1948,'logstore_database','dbcollation',''),(1949,'logstore_database','dbhandlesoptions','0'),(1950,'logstore_database','buffersize','50'),(1951,'logstore_database','jsonformat','1'),(1952,'logstore_database','logguests','0'),(1953,'logstore_database','includelevels','1,2,0'),(1954,'logstore_database','includeactions','c,r,u,d'),(1955,'logstore_legacy','loglegacy','0'),(1956,'logstore_standard','logguests','1'),(1957,'logstore_standard','jsonformat','1'),(1958,'logstore_standard','loglifetime','0'),(1959,'logstore_standard','buffersize','50'),(1960,'mlbackend_python','useserver','0'),(1961,'mlbackend_python','host',''),(1962,'mlbackend_python','port','0'),(1963,'mlbackend_python','secure','0'),(1964,'mlbackend_python','username','default'),(1965,'mlbackend_python','password',''),(1966,'media_videojs','videoextensions','html_video,media_source,.f4v,.flv'),(1967,'media_videojs','audioextensions','html_audio'),(1968,'media_videojs','rtmp','0'),(1969,'media_videojs','useflash','0'),(1970,'media_videojs','youtube','1'),(1971,'media_videojs','videocssclass','video-js'),(1972,'media_videojs','audiocssclass','video-js'),(1973,'media_videojs','limitsize','1'),(1974,'paygw_paypal','surcharge','0'),(1975,'qtype_multichoice','answerhowmany','1'),(1976,'qtype_multichoice','shuffleanswers','1'),(1977,'qtype_multichoice','answernumbering','abc'),(1978,'editor_atto','toolbar','collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist, indent\nlinks = link\nfiles = emojipicker, image, media, recordrtc, managefiles, h5p\nstyle2 = underline, strike, subscript, superscript\nalign = align\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html'),(1979,'editor_atto','autosavefrequency','60'),(1980,'atto_collapse','showgroups','5'),(1981,'atto_equation','librarygroup1','\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),(1982,'atto_equation','librarygroup2','\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),(1983,'atto_equation','librarygroup3','\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),(1984,'atto_equation','librarygroup4','\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),(1985,'atto_recordrtc','allowedtypes','both'),(1986,'atto_recordrtc','audiobitrate','128000'),(1987,'atto_recordrtc','videobitrate','2500000'),(1988,'atto_recordrtc','timelimit','120'),(1989,'atto_table','allowborders','0'),(1990,'atto_table','allowbackgroundcolour','0'),(1991,'atto_table','allowwidth','0'),(1992,'editor_tinymce','customtoolbar','wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen'),(1993,'editor_tinymce','fontselectlist','Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings'),(1994,'editor_tinymce','customconfig',''),(1995,'tinymce_moodleemoticon','requireemoticon','1'),(1996,'tinymce_spellchecker','spellengine',''),(1997,'tinymce_spellchecker','spelllanguagelist','+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv'),(1998,'tool_mobile','apppolicy',''),(1999,'tool_mobile','typeoflogin','1'),(2000,'tool_mobile','qrcodetype','1'),(2001,'tool_mobile','forcedurlscheme','moodlemobile'),(2002,'tool_mobile','minimumversion',''),(2003,'tool_mobile','enablesmartappbanners','0'),(2004,'tool_mobile','iosappid','633359593'),(2005,'tool_mobile','androidappid','com.moodle.moodlemobile'),(2006,'tool_mobile','setuplink','https://download.moodle.org/mobile'),(2007,'tool_mobile','forcelogout','0'),(2008,'tool_mobile','disabledfeatures',''),(2009,'tool_mobile','custommenuitems',''),(2010,'tool_mobile','filetypeexclusionlist',''),(2011,'tool_mobile','customlangstrings',''),(2012,'tool_moodlenet','enablemoodlenet','0'),(2013,'tool_moodlenet','defaultmoodlenetname','MoodleNet Central'),(2014,'tool_moodlenet','defaultmoodlenet','https://moodle.net'),(2016,'local_tenat_form','version','2019012220'),(2018,'tool_brickfield','bfregstatus','0'),(2019,'tool_brickfield','bfregvalidationchecktime','1663418085'),(2020,'tool_brickfield','bfregvalidationtime','1663418085'),(2021,'tool_brickfield','bfsummarytime','1663418085'),(2022,'tool_brickfield','key',''),(2023,'tool_brickfield','hash',''),(2024,'tool_brickfield','id','0'),(2025,'block_course_list_advanced','version','2022051200'),(2026,'block_catalogue','version','2017071900'),(2027,'catalogue','maintitle','Catalogue'),(2028,'catalogue','displayedlists','resources,activities,enrols,grades,reports,blocks'),(2029,'catalogue','getremotedata','1'),(2030,'catalogue','bgcolor','#fff'),(2031,'catalogue','courseviewonly','1'),(2032,'block_course_overview','version','2019021300'),(2033,'block_course_overview','showcategories','2'),(2034,'block_course_overview','keepfavourites','0'),(2035,'block_course_overview','defaulttab','1'),(2036,'block_course_overview','setmaxcourses','10'),(2037,'block_course_overview','setmaxcoursesmax','50'),(2038,'auth_ldap','admin_tenantcontext',''),(2039,'auth_ldap','testrolecontext',''),(2040,'theme_fordson','version','2018121000'),(2041,'theme_fordson','preset','0'),(2042,'theme_fordson','presetfiles',''),(2043,'theme_fordson','pagelayout','5'),(2044,'theme_fordson','sectionlayout','6'),(2045,'theme_fordson','coursetilestyle','1'),(2046,'theme_fordson','marketingstyle','1'),(2047,'theme_fordson','blockdisplay','1'),(2048,'theme_fordson','showloginform','1'),(2049,'theme_fordson','enhancedmydashboard','1'),(2050,'theme_fordson','learningcontentpadding','125px'),(2051,'theme_fordson','headerimagepadding','200px'),(2052,'theme_fordson','gutterwidth','0rem'),(2053,'theme_fordson','blockwidthfordson','280px'),(2054,'theme_fordson','activityiconsize','32px'),(2055,'theme_fordson','frontpagemycoursessorting','1'),(2056,'theme_fordson','trimtitle','256'),(2057,'theme_fordson','titletooltip','0'),(2058,'theme_fordson','trimsummary','300'),(2059,'theme_fordson','courseboxheight','250px'),(2060,'theme_fordson','enablecategoryicon','0'),(2061,'theme_fordson','catsicon','folder'),(2062,'theme_fordson','showcourseheaderimage','1'),(2063,'theme_fordson','favicon',''),(2064,'theme_fordson','headerlogo',''),(2065,'theme_fordson','headerdefaultimage',''),(2066,'theme_fordson','backgroundimage',''),(2067,'theme_fordson','loginimage',''),(2068,'theme_fordson','scsspre',''),(2069,'theme_fordson','brandprimary',''),(2070,'theme_fordson','brandsuccess',''),(2071,'theme_fordson','brandwarning',''),(2072,'theme_fordson','branddanger',''),(2073,'theme_fordson','brandinfo',''),(2074,'theme_fordson','bodybackground',''),(2075,'theme_fordson','topnavbarbg',''),(2076,'theme_fordson','topnavbarteacherbg',''),(2077,'theme_fordson','breadcrumbbkg',''),(2078,'theme_fordson','cardbkg',''),(2079,'theme_fordson','drawerbkg',''),(2080,'theme_fordson','footerbkg',''),(2081,'theme_fordson','markettextbg',''),(2082,'theme_fordson','scss',''),(2083,'theme_fordson','fptextbox',''),(2084,'theme_fordson','fptextboxlogout',''),(2085,'theme_fordson','alertbox',''),(2086,'theme_fordson','coursemanagementtoggle','1'),(2087,'theme_fordson','coursemanagementtextbox',''),(2088,'theme_fordson','studentdashboardtextbox',''),(2089,'theme_fordson','navbarcolorswitch','1'),(2090,'theme_fordson','showactivitynav','1'),(2091,'theme_fordson','courseeditingcog','0'),(2092,'theme_fordson','showstudentgrades','1'),(2093,'theme_fordson','showstudentcompletion','1'),(2094,'theme_fordson','showcourseadminstudents','1'),(2095,'theme_fordson','displaymycourses',''),(2096,'theme_fordson','displaythiscourse',''),(2097,'theme_fordson','mycoursetitle','course'),(2098,'theme_fordson','shownavdrawer','1'),(2099,'theme_fordson','shownavclosed',''),(2100,'theme_fordson','iconwidth','100px'),(2101,'theme_fordson','createicon','edit'),(2102,'theme_fordson','createbuttontext','Create a Course'),(2103,'theme_fordson','createbuttonurl','http://148.72.245.159/m2/moodle/course/edit.php?category=1'),(2104,'theme_fordson','slideicon',''),(2105,'theme_fordson','slideiconbuttontext',''),(2106,'theme_fordson','slidetextbox',''),(2107,'theme_fordson','nav1icon','home'),(2108,'theme_fordson','nav1buttontext','Dashboard'),(2109,'theme_fordson','nav1buttonurl','http://148.72.245.159/m2/moodle/my/'),(2110,'theme_fordson','nav2icon','calendar'),(2111,'theme_fordson','nav2buttontext','Calendar'),(2112,'theme_fordson','nav2buttonurl','http://148.72.245.159/m2/moodle/calendar/view.php?view=month'),(2113,'theme_fordson','nav3icon','bookmark'),(2114,'theme_fordson','nav3buttontext','Badges'),(2115,'theme_fordson','nav3buttonurl','http://148.72.245.159/m2/moodle/badges/mybadges.php'),(2116,'theme_fordson','nav4icon','book'),(2117,'theme_fordson','nav4buttontext','All Courses'),(2118,'theme_fordson','nav4buttonurl','http://148.72.245.159/m2/moodle/course/'),(2119,'theme_fordson','nav5icon',''),(2120,'theme_fordson','nav5buttontext',''),(2121,'theme_fordson','nav5buttonurl',''),(2122,'theme_fordson','nav6icon',''),(2123,'theme_fordson','nav6buttontext',''),(2124,'theme_fordson','nav6buttonurl',''),(2125,'theme_fordson','nav7icon',''),(2126,'theme_fordson','nav7buttontext',''),(2127,'theme_fordson','nav7buttonurl',''),(2128,'theme_fordson','nav8icon',''),(2129,'theme_fordson','nav8buttontext',''),(2130,'theme_fordson','nav8buttonurl',''),(2131,'theme_fordson','modchoosercustomlabel',''),(2132,'theme_fordson','commonlyused',''),(2133,'theme_fordson','showonlycustomactivities','0'),(2134,'theme_fordson','showalltomanager','1'),(2135,'theme_fordson','showslideshow','0'),(2136,'theme_fordson','slideshowheight','250px'),(2137,'theme_fordson','slide1title',''),(2138,'theme_fordson','slide1content',''),(2139,'theme_fordson','slide1image',''),(2140,'theme_fordson','slide2title',''),(2141,'theme_fordson','slide2content',''),(2142,'theme_fordson','slide2image',''),(2143,'theme_fordson','slide3title',''),(2144,'theme_fordson','slide3content',''),(2145,'theme_fordson','slide3image',''),(2146,'theme_fordson','togglemarketing','2'),(2147,'theme_fordson','marketing1',''),(2148,'theme_fordson','marketing1image',''),(2149,'theme_fordson','marketing1content',''),(2150,'theme_fordson','marketing1buttontext',''),(2151,'theme_fordson','marketing1buttonurl',''),(2152,'theme_fordson','marketing1target','_self'),(2153,'theme_fordson','marketing2',''),(2154,'theme_fordson','marketing2image',''),(2155,'theme_fordson','marketing2content',''),(2156,'theme_fordson','marketing2buttontext',''),(2157,'theme_fordson','marketing2buttonurl',''),(2158,'theme_fordson','marketing2target','_self'),(2159,'theme_fordson','marketing3',''),(2160,'theme_fordson','marketing3image',''),(2161,'theme_fordson','marketing3content',''),(2162,'theme_fordson','marketing3buttontext',''),(2163,'theme_fordson','marketing3buttonurl',''),(2164,'theme_fordson','marketing3target','_self'),(2165,'theme_fordson','marketing4',''),(2166,'theme_fordson','marketing4image',''),(2167,'theme_fordson','marketing4content',''),(2168,'theme_fordson','marketing4buttontext',''),(2169,'theme_fordson','marketing4buttonurl',''),(2170,'theme_fordson','marketing4target','_self'),(2171,'theme_fordson','marketing5',''),(2172,'theme_fordson','marketing5image',''),(2173,'theme_fordson','marketing5content',''),(2174,'theme_fordson','marketing5buttontext',''),(2175,'theme_fordson','marketing5buttonurl',''),(2176,'theme_fordson','marketing5target','_self'),(2177,'theme_fordson','marketing6',''),(2178,'theme_fordson','marketing6image',''),(2179,'theme_fordson','marketing6content',''),(2180,'theme_fordson','marketing6buttontext',''),(2181,'theme_fordson','marketing6buttonurl',''),(2182,'theme_fordson','marketing6target','_self'),(2183,'theme_fordson','marketing7',''),(2184,'theme_fordson','marketing7image',''),(2185,'theme_fordson','marketing7content',''),(2186,'theme_fordson','marketing7buttontext',''),(2187,'theme_fordson','marketing7buttonurl',''),(2188,'theme_fordson','marketing7target','_self'),(2189,'theme_fordson','marketing8',''),(2190,'theme_fordson','marketing8image',''),(2191,'theme_fordson','marketing8content',''),(2192,'theme_fordson','marketing8buttontext',''),(2193,'theme_fordson','marketing8buttonurl',''),(2194,'theme_fordson','marketing8target','_self'),(2195,'theme_fordson','marketing9',''),(2196,'theme_fordson','marketing9image',''),(2197,'theme_fordson','marketing9content',''),(2198,'theme_fordson','marketing9buttontext',''),(2199,'theme_fordson','marketing9buttonurl',''),(2200,'theme_fordson','marketing9target','_self'),(2201,'theme_fordson','brandorganization',''),(2202,'theme_fordson','brandwebsite',''),(2203,'theme_fordson','brandphone',''),(2204,'theme_fordson','brandemail',''),(2205,'theme_fordson','footnote',''),(2206,'theme_fordson','website',''),(2207,'theme_fordson','blog',''),(2208,'theme_fordson','facebook',''),(2209,'theme_fordson','flickr',''),(2210,'theme_fordson','twitter',''),(2211,'theme_fordson','googleplus',''),(2212,'theme_fordson','linkedin',''),(2213,'theme_fordson','tumblr',''),(2214,'theme_fordson','pinterest',''),(2215,'theme_fordson','instagram',''),(2216,'theme_fordson','youtube',''),(2217,'theme_fordson','vimeo',''),(2218,'theme_fordson','skype',''),(2219,'theme_fordson','social1',''),(2220,'theme_fordson','socialicon1','home'),(2221,'theme_fordson','social2',''),(2222,'theme_fordson','socialicon2','home'),(2223,'theme_fordson','social3',''),(2224,'theme_fordson','socialicon3','home'),(2225,'theme_fordson','showcustomlogin','0'),(2226,'theme_fordson','logintopimage',''),(2227,'theme_fordson','fploginform',''),(2228,'theme_fordson','loginnav1icon',''),(2229,'theme_fordson','loginnav1titletext',''),(2230,'theme_fordson','loginnav1icontext',''),(2231,'theme_fordson','loginnav2icon',''),(2232,'theme_fordson','loginnav2titletext',''),(2233,'theme_fordson','loginnav2icontext',''),(2234,'theme_fordson','loginnav3icon',''),(2235,'theme_fordson','loginnav3titletext',''),(2236,'theme_fordson','loginnav3icontext',''),(2237,'theme_fordson','loginnav4icon',''),(2238,'theme_fordson','loginnav4titletext',''),(2239,'theme_fordson','loginnav4icontext',''),(2240,'theme_fordson','feature1text',''),(2241,'theme_fordson','feature1image',''),(2242,'theme_fordson','feature2text',''),(2243,'theme_fordson','feature2image',''),(2244,'theme_fordson','feature3text',''),(2245,'theme_fordson','feature3image',''),(2250,'local_hierarchy','version','2019012220');
/*!40000 ALTER TABLE `mdl_config_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_contentbank_content`
--

DROP TABLE IF EXISTS `mdl_contentbank_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_contentbank_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contenttype` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT '1',
  `instanceid` bigint(10) DEFAULT NULL,
  `configdata` longtext COLLATE utf8mb4_unicode_ci,
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_contcont_nam_ix` (`name`),
  KEY `mdl_contcont_conconins_ix` (`contextid`,`contenttype`,`instanceid`),
  KEY `mdl_contcont_con_ix` (`contextid`),
  KEY `mdl_contcont_use_ix` (`usermodified`),
  KEY `mdl_contcont_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table stores content data in the content bank.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_contentbank_content`
--

LOCK TABLES `mdl_contentbank_content` WRITE;
/*!40000 ALTER TABLE `mdl_contentbank_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_contentbank_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context`
--

DROP TABLE IF EXISTS `mdl_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_context` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depth` tinyint(2) NOT NULL DEFAULT '0',
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `mdl_cont_ins_ix` (`instanceid`),
  KEY `mdl_cont_pat_ix` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=994 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='one of these must be set';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context`
--

LOCK TABLES `mdl_context` WRITE;
/*!40000 ALTER TABLE `mdl_context` DISABLE KEYS */;
INSERT INTO `mdl_context` VALUES (1,10,0,'/1',1,0),(2,50,1,'/1/2',2,0),(4,30,1,'/1/4',2,0),(5,30,2,'/1/5',2,0),(6,80,1,'/1/6',2,0),(7,80,2,'/1/7',2,0),(8,80,3,'/1/8',2,0),(9,80,4,'/1/9',2,0),(10,80,5,'/1/10',2,0),(11,80,6,'/1/11',2,0),(12,80,7,'/1/12',2,0),(13,80,8,'/1/13',2,0),(14,80,9,'/1/14',2,0),(15,80,10,'/1/15',2,0),(16,80,11,'/1/5/16',3,0),(17,80,12,'/1/5/17',3,0),(18,80,13,'/1/5/18',3,0),(19,80,14,'/1/5/19',3,0),(20,80,15,'/1/5/20',3,0),(21,80,16,'/1/5/21',3,0),(22,80,17,'/1/5/22',3,0),(23,80,18,'/1/5/23',3,0),(24,80,19,'/1/5/24',3,0),(25,30,3,'/1/25',2,0),(26,30,4,'/1/26',2,0),(27,30,5,'/1/27',2,0),(28,30,6,'/1/28',2,0),(38,30,7,'/1/38',2,0),(39,30,8,'/1/39',2,0),(40,30,9,'/1/40',2,0),(41,30,10,'/1/41',2,0),(42,30,11,'/1/42',2,0),(43,30,12,'/1/43',2,0),(44,30,13,'/1/44',2,0),(45,30,14,'/1/45',2,0),(46,30,15,'/1/46',2,0),(47,30,16,'/1/47',2,0),(48,30,17,'/1/48',2,0),(49,30,18,'/1/49',2,0),(59,30,19,'/1/59',2,0),(69,80,47,'/1/38/69',3,0),(70,80,48,'/1/38/70',3,0),(71,80,49,'/1/38/71',3,0),(72,80,50,'/1/38/72',3,0),(73,80,51,'/1/38/73',3,0),(74,80,52,'/1/38/74',3,0),(75,80,53,'/1/38/75',3,0),(76,80,54,'/1/38/76',3,0),(77,80,55,'/1/38/77',3,0),(78,30,20,'/1/78',2,0),(79,40,2,'/1/79',2,0),(80,40,3,'/1/79/80',3,0),(81,40,4,'/1/79/80/81',4,0),(82,50,2,'/1/79/80/81/82',5,0),(83,50,3,'/1/79/80/81/83',5,0),(84,50,4,'/1/79/80/81/84',5,0),(85,40,5,'/1/79/80/85',4,0),(86,40,6,'/1/79/80/86',4,0),(87,40,7,'/1/79/87',3,0),(88,40,8,'/1/79/88',3,0),(89,40,9,'/1/79/89',3,0),(91,40,11,'/1/91',2,0),(92,40,12,'/1/91/92',3,0),(93,50,5,'/1/91/92/93',4,0),(94,50,6,'/1/91/92/94',4,0),(95,50,7,'/1/91/92/95',4,0),(96,40,13,'/1/91/96',3,0),(97,40,14,'/1/91/97',3,0),(99,40,16,'/1/99',2,0),(100,40,17,'/1/99/100',3,0),(101,30,21,'/1/101',2,0),(102,80,56,'/1/101/102',3,0),(103,80,57,'/1/101/103',3,0),(104,80,58,'/1/101/104',3,0),(105,80,59,'/1/101/105',3,0),(106,80,60,'/1/101/106',3,0),(107,80,61,'/1/101/107',3,0),(108,80,62,'/1/101/108',3,0),(109,80,63,'/1/101/109',3,0),(110,80,64,'/1/101/110',3,0),(111,70,3,'/1/79/80/81/84/111',6,0),(112,40,18,'/1/91/92/112',4,0),(118,50,10,'/1/91/118',3,0),(119,70,9,'/1/91/118/119',4,0),(120,50,11,'/1/99/120',3,0),(121,70,10,'/1/99/120/121',4,0),(122,50,12,'/1/79/80/122',4,0),(123,70,11,'/1/79/80/122/123',5,0),(126,40,20,'/1/91/96/126',4,0),(127,50,14,'/1/79/87/127',4,0),(128,70,13,'/1/79/87/127/128',5,0),(129,40,21,'/1/79/87/129',4,0),(130,40,22,'/1/79/87/130',4,0),(131,40,23,'/1/99/100/131',4,0),(134,30,22,'/1/134',2,0),(135,30,23,'/1/135',2,0),(136,30,24,'/1/136',2,0),(137,30,25,'/1/137',2,0),(138,30,26,'/1/138',2,0),(139,80,65,'/1/136/139',3,0),(140,80,66,'/1/136/140',3,0),(141,80,67,'/1/136/141',3,0),(142,80,68,'/1/136/142',3,0),(143,80,69,'/1/136/143',3,0),(144,80,70,'/1/136/144',3,0),(145,80,71,'/1/136/145',3,0),(146,80,72,'/1/136/146',3,0),(147,80,73,'/1/136/147',3,0),(152,50,16,'/1/79/152',3,0),(153,70,15,'/1/79/152/153',4,0),(155,80,74,'/1/155',2,0),(156,80,75,'/1/156',2,0),(157,30,27,'/1/157',2,0),(158,50,17,'/1/79/158',3,0),(159,30,28,'/1/159',2,0),(160,30,29,'/1/160',2,0),(161,80,76,'/1/160/161',3,0),(162,80,77,'/1/160/162',3,0),(163,80,78,'/1/160/163',3,0),(164,80,79,'/1/160/164',3,0),(165,80,80,'/1/160/165',3,0),(166,80,81,'/1/160/166',3,0),(167,80,82,'/1/160/167',3,0),(168,80,83,'/1/160/168',3,0),(169,80,84,'/1/160/169',3,0),(170,70,1,'/1/79/80/81/82/170',6,0),(171,30,30,'/1/171',2,0),(172,80,85,'/1/157/172',3,0),(173,80,86,'/1/157/173',3,0),(174,80,87,'/1/157/174',3,0),(175,80,88,'/1/157/175',3,0),(176,80,89,'/1/157/176',3,0),(177,80,90,'/1/157/177',3,0),(178,80,91,'/1/157/178',3,0),(179,80,92,'/1/157/179',3,0),(180,80,93,'/1/157/180',3,0),(181,70,16,'/1/79/158/181',4,0),(182,70,2,'/1/79/80/81/83/182',6,0),(184,30,31,'/1/184',2,0),(185,30,32,'/1/185',2,0),(186,50,18,'/1/79/186',3,0),(187,70,17,'/1/79/186/187',4,0),(188,30,33,'/1/188',2,0),(189,30,34,'/1/189',2,0),(190,80,94,'/1/189/190',3,0),(191,80,95,'/1/189/191',3,0),(192,80,96,'/1/189/192',3,0),(193,80,97,'/1/189/193',3,0),(194,80,98,'/1/189/194',3,0),(195,80,99,'/1/189/195',3,0),(196,80,100,'/1/189/196',3,0),(197,80,101,'/1/189/197',3,0),(198,80,102,'/1/189/198',3,0),(199,30,35,'/1/199',2,0),(200,30,36,'/1/200',2,0),(201,80,103,'/1/200/201',3,0),(202,80,104,'/1/200/202',3,0),(203,80,105,'/1/200/203',3,0),(204,80,106,'/1/200/204',3,0),(205,80,107,'/1/200/205',3,0),(206,80,108,'/1/200/206',3,0),(207,80,109,'/1/200/207',3,0),(208,80,110,'/1/200/208',3,0),(209,80,111,'/1/200/209',3,0),(211,30,37,'/1/211',2,0),(212,30,38,'/1/212',2,0),(213,80,112,'/1/212/213',3,0),(214,80,113,'/1/212/214',3,0),(215,80,114,'/1/212/215',3,0),(216,80,115,'/1/212/216',3,0),(217,80,116,'/1/212/217',3,0),(218,80,117,'/1/212/218',3,0),(219,80,118,'/1/212/219',3,0),(220,80,119,'/1/212/220',3,0),(221,80,120,'/1/212/221',3,0),(222,30,39,'/1/222',2,0),(223,80,121,'/1/222/223',3,0),(224,80,122,'/1/222/224',3,0),(225,80,123,'/1/222/225',3,0),(226,80,124,'/1/222/226',3,0),(227,80,125,'/1/222/227',3,0),(228,80,126,'/1/222/228',3,0),(229,80,127,'/1/222/229',3,0),(230,80,128,'/1/222/230',3,0),(231,80,129,'/1/222/231',3,0),(232,80,130,'/1/188/232',3,0),(233,80,131,'/1/188/233',3,0),(234,80,132,'/1/188/234',3,0),(235,80,133,'/1/188/235',3,0),(236,80,134,'/1/188/236',3,0),(237,80,135,'/1/188/237',3,0),(238,80,136,'/1/188/238',3,0),(239,80,137,'/1/188/239',3,0),(240,80,138,'/1/188/240',3,0),(241,30,40,'/1/241',2,0),(242,30,41,'/1/242',2,0),(243,80,139,'/1/242/243',3,0),(244,80,140,'/1/242/244',3,0),(245,80,141,'/1/242/245',3,0),(246,80,142,'/1/242/246',3,0),(247,80,143,'/1/242/247',3,0),(248,80,144,'/1/242/248',3,0),(249,80,145,'/1/242/249',3,0),(250,80,146,'/1/242/250',3,0),(251,80,147,'/1/242/251',3,0),(252,30,42,'/1/252',2,0),(253,80,148,'/1/252/253',3,0),(254,80,149,'/1/252/254',3,0),(255,80,150,'/1/252/255',3,0),(256,80,151,'/1/252/256',3,0),(257,80,152,'/1/252/257',3,0),(258,80,153,'/1/252/258',3,0),(259,80,154,'/1/252/259',3,0),(260,80,155,'/1/252/260',3,0),(261,80,156,'/1/252/261',3,0),(262,30,43,'/1/262',2,0),(263,30,44,'/1/263',2,0),(264,80,157,'/1/263/264',3,0),(265,80,158,'/1/263/265',3,0),(266,80,159,'/1/263/266',3,0),(267,80,160,'/1/263/267',3,0),(268,80,161,'/1/263/268',3,0),(269,80,162,'/1/263/269',3,0),(270,80,163,'/1/263/270',3,0),(271,80,164,'/1/263/271',3,0),(272,80,165,'/1/263/272',3,0),(273,30,45,'/1/273',2,0),(274,80,166,'/1/273/274',3,0),(275,80,167,'/1/273/275',3,0),(276,80,168,'/1/273/276',3,0),(277,80,169,'/1/273/277',3,0),(278,80,170,'/1/273/278',3,0),(279,80,171,'/1/273/279',3,0),(280,80,172,'/1/273/280',3,0),(281,80,173,'/1/273/281',3,0),(282,80,174,'/1/273/282',3,0),(283,30,46,'/1/283',2,0),(284,80,175,'/1/283/284',3,0),(285,80,176,'/1/283/285',3,0),(286,80,177,'/1/283/286',3,0),(287,80,178,'/1/283/287',3,0),(288,80,179,'/1/283/288',3,0),(289,80,180,'/1/283/289',3,0),(290,80,181,'/1/283/290',3,0),(291,80,182,'/1/283/291',3,0),(292,80,183,'/1/283/292',3,0),(294,30,47,'/1/294',2,0),(295,80,184,'/1/294/295',3,0),(296,80,185,'/1/294/296',3,0),(297,80,186,'/1/294/297',3,0),(298,80,187,'/1/294/298',3,0),(299,80,188,'/1/294/299',3,0),(300,80,189,'/1/294/300',3,0),(301,80,190,'/1/294/301',3,0),(302,80,191,'/1/294/302',3,0),(303,80,192,'/1/294/303',3,0),(304,40,32,'/1/99/100/131/304',5,0),(305,30,48,'/1/305',2,0),(306,30,49,'/1/306',2,0),(307,30,50,'/1/307',2,0),(308,30,51,'/1/308',2,0),(309,30,52,'/1/309',2,0),(310,30,53,'/1/310',2,0),(311,30,54,'/1/311',2,0),(312,30,55,'/1/312',2,0),(313,30,56,'/1/313',2,0),(314,30,57,'/1/314',2,0),(315,30,58,'/1/315',2,0),(318,30,59,'/1/318',2,0),(319,30,60,'/1/319',2,0),(320,30,61,'/1/320',2,0),(321,70,18,'/1/79/80/122/321',5,0),(322,70,19,'/1/79/80/122/322',5,0),(323,30,62,'/1/323',2,0),(324,80,193,'/1/315/324',3,0),(325,80,194,'/1/315/325',3,0),(326,80,195,'/1/315/326',3,0),(327,80,196,'/1/315/327',3,0),(328,80,197,'/1/315/328',3,0),(329,80,198,'/1/315/329',3,0),(330,80,199,'/1/315/330',3,0),(331,80,200,'/1/315/331',3,0),(332,80,201,'/1/315/332',3,0),(333,30,63,'/1/333',2,0),(334,80,202,'/1/333/334',3,0),(335,80,203,'/1/333/335',3,0),(336,80,204,'/1/333/336',3,0),(337,80,205,'/1/333/337',3,0),(338,80,206,'/1/333/338',3,0),(339,80,207,'/1/333/339',3,0),(340,80,208,'/1/333/340',3,0),(341,80,209,'/1/333/341',3,0),(342,80,210,'/1/333/342',3,0),(343,30,64,'/1/343',2,0),(344,30,65,'/1/344',2,0),(345,80,211,'/1/344/345',3,0),(346,80,212,'/1/344/346',3,0),(347,80,213,'/1/344/347',3,0),(348,80,214,'/1/344/348',3,0),(349,80,215,'/1/344/349',3,0),(350,80,216,'/1/344/350',3,0),(351,80,217,'/1/344/351',3,0),(352,80,218,'/1/344/352',3,0),(353,80,219,'/1/344/353',3,0),(354,30,66,'/1/354',2,0),(355,80,220,'/1/354/355',3,0),(356,80,221,'/1/354/356',3,0),(357,80,222,'/1/354/357',3,0),(358,80,223,'/1/354/358',3,0),(359,80,224,'/1/354/359',3,0),(360,80,225,'/1/354/360',3,0),(361,80,226,'/1/354/361',3,0),(362,80,227,'/1/354/362',3,0),(363,80,228,'/1/354/363',3,0),(364,80,229,'/1/343/364',3,0),(365,80,230,'/1/343/365',3,0),(366,80,231,'/1/343/366',3,0),(367,80,232,'/1/343/367',3,0),(368,80,233,'/1/343/368',3,0),(369,80,234,'/1/343/369',3,0),(370,80,235,'/1/343/370',3,0),(371,80,236,'/1/343/371',3,0),(372,80,237,'/1/343/372',3,0),(379,30,67,'/1/379',2,0),(380,80,238,'/1/379/380',3,0),(381,80,239,'/1/379/381',3,0),(382,80,240,'/1/379/382',3,0),(383,80,241,'/1/379/383',3,0),(384,80,242,'/1/379/384',3,0),(385,80,243,'/1/379/385',3,0),(386,80,244,'/1/379/386',3,0),(387,80,245,'/1/379/387',3,0),(388,80,246,'/1/379/388',3,0),(389,30,68,'/1/389',2,0),(390,30,69,'/1/390',2,0),(391,80,247,'/1/390/391',3,0),(392,80,248,'/1/390/392',3,0),(393,80,249,'/1/390/393',3,0),(394,80,250,'/1/390/394',3,0),(395,80,251,'/1/390/395',3,0),(396,80,252,'/1/390/396',3,0),(397,80,253,'/1/390/397',3,0),(398,80,254,'/1/390/398',3,0),(399,80,255,'/1/390/399',3,0),(403,30,70,'/1/403',2,0),(404,80,256,'/1/403/404',3,0),(405,80,257,'/1/403/405',3,0),(406,80,258,'/1/403/406',3,0),(407,80,259,'/1/403/407',3,0),(408,80,260,'/1/403/408',3,0),(409,80,261,'/1/403/409',3,0),(410,80,262,'/1/403/410',3,0),(411,80,263,'/1/403/411',3,0),(412,80,264,'/1/403/412',3,0),(413,30,71,'/1/413',2,0),(414,80,265,'/1/413/414',3,0),(415,80,266,'/1/413/415',3,0),(416,80,267,'/1/413/416',3,0),(417,80,268,'/1/413/417',3,0),(418,80,269,'/1/413/418',3,0),(419,80,270,'/1/413/419',3,0),(420,80,271,'/1/413/420',3,0),(421,80,272,'/1/413/421',3,0),(422,80,273,'/1/413/422',3,0),(423,50,22,'/1/91/92/112/423',5,0),(424,70,23,'/1/91/92/112/423/424',6,0),(425,30,72,'/1/425',2,0),(426,80,274,'/1/425/426',3,0),(427,80,275,'/1/425/427',3,0),(428,80,276,'/1/425/428',3,0),(429,80,277,'/1/425/429',3,0),(430,80,278,'/1/425/430',3,0),(431,80,279,'/1/425/431',3,0),(432,80,280,'/1/425/432',3,0),(433,80,281,'/1/425/433',3,0),(434,80,282,'/1/425/434',3,0),(435,30,73,'/1/435',2,0),(436,80,283,'/1/435/436',3,0),(437,80,284,'/1/435/437',3,0),(438,80,285,'/1/435/438',3,0),(439,80,286,'/1/435/439',3,0),(440,80,287,'/1/435/440',3,0),(441,80,288,'/1/435/441',3,0),(442,80,289,'/1/435/442',3,0),(443,80,290,'/1/435/443',3,0),(444,80,291,'/1/435/444',3,0),(446,30,74,'/1/446',2,0),(447,30,75,'/1/447',2,0),(448,80,292,'/1/447/448',3,0),(449,80,293,'/1/447/449',3,0),(450,80,294,'/1/447/450',3,0),(451,80,295,'/1/447/451',3,0),(452,80,296,'/1/447/452',3,0),(453,80,297,'/1/447/453',3,0),(454,80,298,'/1/447/454',3,0),(455,80,299,'/1/447/455',3,0),(456,80,300,'/1/447/456',3,0),(457,30,76,'/1/457',2,0),(458,80,301,'/1/457/458',3,0),(459,80,302,'/1/457/459',3,0),(460,80,303,'/1/457/460',3,0),(461,80,304,'/1/457/461',3,0),(462,80,305,'/1/457/462',3,0),(463,80,306,'/1/457/463',3,0),(464,80,307,'/1/457/464',3,0),(465,80,308,'/1/457/465',3,0),(466,80,309,'/1/457/466',3,0),(470,30,77,'/1/470',2,0),(471,80,310,'/1/470/471',3,0),(472,80,311,'/1/470/472',3,0),(473,80,312,'/1/470/473',3,0),(474,80,313,'/1/470/474',3,0),(475,80,314,'/1/470/475',3,0),(476,80,315,'/1/470/476',3,0),(477,80,316,'/1/470/477',3,0),(478,80,317,'/1/470/478',3,0),(479,80,318,'/1/470/479',3,0),(480,30,78,'/1/480',2,0),(482,80,319,'/1/480/482',3,0),(483,80,320,'/1/480/483',3,0),(484,80,321,'/1/480/484',3,0),(485,80,322,'/1/480/485',3,0),(486,80,323,'/1/480/486',3,0),(487,80,324,'/1/480/487',3,0),(488,80,325,'/1/480/488',3,0),(489,80,326,'/1/480/489',3,0),(490,80,327,'/1/480/490',3,0),(492,30,79,'/1/492',2,0),(499,30,80,'/1/499',2,0),(500,80,328,'/1/499/500',3,0),(501,80,329,'/1/499/501',3,0),(502,80,330,'/1/499/502',3,0),(503,80,331,'/1/499/503',3,0),(504,80,332,'/1/499/504',3,0),(505,80,333,'/1/499/505',3,0),(506,80,334,'/1/499/506',3,0),(507,80,335,'/1/499/507',3,0),(508,80,336,'/1/499/508',3,0),(509,30,81,'/1/509',2,0),(510,80,337,'/1/509/510',3,0),(511,80,338,'/1/509/511',3,0),(512,80,339,'/1/509/512',3,0),(513,80,340,'/1/509/513',3,0),(514,80,341,'/1/509/514',3,0),(515,80,342,'/1/509/515',3,0),(516,80,343,'/1/509/516',3,0),(517,80,344,'/1/509/517',3,0),(518,80,345,'/1/509/518',3,0),(519,30,82,'/1/519',2,0),(520,30,83,'/1/520',2,0),(521,30,84,'/1/521',2,0),(522,30,85,'/1/522',2,0),(523,30,86,'/1/523',2,0),(524,30,87,'/1/524',2,0),(525,30,88,'/1/525',2,0),(526,30,89,'/1/526',2,0),(527,80,346,'/1/525/527',3,0),(528,80,347,'/1/525/528',3,0),(529,80,348,'/1/525/529',3,0),(530,80,349,'/1/525/530',3,0),(531,80,350,'/1/525/531',3,0),(532,80,351,'/1/525/532',3,0),(533,80,352,'/1/525/533',3,0),(534,80,353,'/1/525/534',3,0),(535,80,354,'/1/525/535',3,0),(536,50,24,'/1/79/80/81/536',5,0),(537,70,25,'/1/79/80/81/536/537',6,0),(551,80,355,'/1/521/551',3,0),(552,80,356,'/1/521/552',3,0),(553,80,357,'/1/521/553',3,0),(554,80,358,'/1/521/554',3,0),(555,80,359,'/1/521/555',3,0),(556,80,360,'/1/521/556',3,0),(557,80,361,'/1/521/557',3,0),(558,80,362,'/1/521/558',3,0),(559,80,363,'/1/521/559',3,0),(560,30,90,'/1/560',2,0),(561,30,91,'/1/561',2,0),(562,30,92,'/1/562',2,0),(563,30,93,'/1/563',2,0),(564,30,94,'/1/564',2,0),(565,30,95,'/1/565',2,0),(566,40,58,'/1/566',2,0),(568,40,60,'/1/566/568',3,0),(574,40,62,'/1/566/574',3,0),(575,40,63,'/1/566/568/575',4,0),(576,40,64,'/1/566/574/576',4,0),(577,50,29,'/1/566/574/576/577',5,0),(578,30,96,'/1/578',2,0),(579,30,97,'/1/579',2,0),(580,80,364,'/1/579/580',3,0),(581,80,365,'/1/579/581',3,0),(582,80,366,'/1/579/582',3,0),(583,80,367,'/1/579/583',3,0),(584,80,368,'/1/579/584',3,0),(585,80,369,'/1/579/585',3,0),(586,80,370,'/1/579/586',3,0),(587,80,371,'/1/579/587',3,0),(588,80,372,'/1/579/588',3,0),(592,30,98,'/1/592',2,0),(593,80,373,'/1/592/593',3,0),(594,80,374,'/1/592/594',3,0),(595,80,375,'/1/592/595',3,0),(596,80,376,'/1/592/596',3,0),(597,80,377,'/1/592/597',3,0),(598,80,378,'/1/592/598',3,0),(599,80,379,'/1/592/599',3,0),(600,80,380,'/1/592/600',3,0),(601,80,381,'/1/592/601',3,0),(603,30,99,'/1/603',2,0),(604,80,382,'/1/603/604',3,0),(605,80,383,'/1/603/605',3,0),(606,80,384,'/1/603/606',3,0),(607,80,385,'/1/603/607',3,0),(608,80,386,'/1/603/608',3,0),(609,80,387,'/1/603/609',3,0),(610,80,388,'/1/603/610',3,0),(611,80,389,'/1/603/611',3,0),(612,80,390,'/1/603/612',3,0),(619,40,65,'/1/566/619',3,0),(625,40,67,'/1/566/625',3,0),(627,40,68,'/1/627',2,0),(628,40,69,'/1/628',2,0),(629,50,45,'/1/628/629',3,0),(630,30,100,'/1/630',2,0),(631,30,101,'/1/631',2,0),(632,30,102,'/1/632',2,0),(633,30,103,'/1/633',2,0),(634,30,104,'/1/634',2,0),(635,30,105,'/1/635',2,0),(636,30,106,'/1/636',2,0),(637,30,107,'/1/637',2,0),(638,30,108,'/1/638',2,0),(639,30,109,'/1/639',2,0),(640,30,110,'/1/640',2,0),(641,30,111,'/1/641',2,0),(642,30,112,'/1/642',2,0),(643,30,113,'/1/643',2,0),(644,30,114,'/1/644',2,0),(645,30,115,'/1/645',2,0),(646,30,116,'/1/646',2,0),(647,30,117,'/1/647',2,0),(648,30,118,'/1/648',2,0),(649,30,119,'/1/649',2,0),(650,30,120,'/1/650',2,0),(652,30,121,'/1/652',2,0),(653,30,122,'/1/653',2,0),(654,30,123,'/1/654',2,0),(655,30,124,'/1/655',2,0),(656,30,125,'/1/656',2,0),(658,30,126,'/1/658',2,0),(660,30,127,'/1/660',2,0),(661,30,128,'/1/661',2,0),(662,30,129,'/1/662',2,0),(663,30,130,'/1/663',2,0),(664,30,131,'/1/664',2,0),(665,30,132,'/1/665',2,0),(666,80,391,'/1/665/666',3,0),(667,80,392,'/1/665/667',3,0),(668,80,393,'/1/665/668',3,0),(669,80,394,'/1/665/669',3,0),(670,80,395,'/1/665/670',3,0),(671,80,396,'/1/665/671',3,0),(672,80,397,'/1/665/672',3,0),(673,80,398,'/1/665/673',3,0),(674,80,399,'/1/665/674',3,0),(675,40,70,'/1/79/675',3,0),(676,30,133,'/1/676',2,0),(677,80,400,'/1/676/677',3,0),(678,80,401,'/1/676/678',3,0),(679,80,402,'/1/676/679',3,0),(680,80,403,'/1/676/680',3,0),(681,80,404,'/1/676/681',3,0),(682,80,405,'/1/676/682',3,0),(683,80,406,'/1/676/683',3,0),(684,80,407,'/1/676/684',3,0),(685,80,408,'/1/676/685',3,0),(688,50,48,'/1/99/100/688',4,0),(689,50,49,'/1/99/100/689',4,0),(690,50,50,'/1/99/100/690',4,0),(694,70,35,'/1/99/100/690/694',5,0),(695,50,54,'/1/99/100/695',4,0),(697,50,56,'/1/79/697',3,0),(698,70,37,'/1/79/697/698',4,0),(699,50,57,'/1/99/100/699',4,0),(700,50,58,'/1/99/100/700',4,0),(701,50,59,'/1/91/97/701',4,0),(702,50,60,'/1/99/100/702',4,0),(703,50,61,'/1/79/87/703',4,0),(704,30,134,'/1/704',2,0),(705,80,409,'/1/704/705',3,0),(706,80,410,'/1/704/706',3,0),(707,80,411,'/1/704/707',3,0),(708,80,412,'/1/704/708',3,0),(709,80,413,'/1/704/709',3,0),(710,80,414,'/1/704/710',3,0),(711,80,415,'/1/704/711',3,0),(712,80,416,'/1/704/712',3,0),(713,80,417,'/1/704/713',3,0),(714,50,62,'/1/79/87/714',4,0),(716,50,64,'/1/79/87/716',4,0),(717,50,65,'/1/79/87/717',4,0),(718,70,45,'/1/79/87/717/718',5,0),(719,30,135,'/1/719',2,0),(720,30,136,'/1/720',2,0),(721,30,137,'/1/721',2,0),(722,80,418,'/1/721/722',3,0),(723,80,419,'/1/721/723',3,0),(724,80,420,'/1/721/724',3,0),(725,80,421,'/1/721/725',3,0),(726,80,422,'/1/721/726',3,0),(727,80,423,'/1/721/727',3,0),(728,80,424,'/1/721/728',3,0),(729,80,425,'/1/721/729',3,0),(730,80,426,'/1/721/730',3,0),(731,50,66,'/1/79/80/86/731',5,0),(732,50,67,'/1/79/87/732',4,0),(733,50,68,'/1/79/80/81/733',5,0),(734,30,138,'/1/734',2,0),(735,50,69,'/1/79/675/735',4,0),(736,50,70,'/1/79/675/736',4,0),(737,50,71,'/1/79/675/737',4,0),(738,30,139,'/1/738',2,0),(739,80,427,'/1/738/739',3,0),(740,80,428,'/1/738/740',3,0),(741,80,429,'/1/738/741',3,0),(742,80,430,'/1/738/742',3,0),(743,80,431,'/1/738/743',3,0),(744,80,432,'/1/738/744',3,0),(745,80,433,'/1/738/745',3,0),(746,80,434,'/1/738/746',3,0),(747,80,435,'/1/738/747',3,0),(748,30,140,'/1/748',2,0),(749,30,141,'/1/749',2,0),(750,30,142,'/1/750',2,0),(751,30,143,'/1/751',2,0),(752,30,144,'/1/752',2,0),(753,30,145,'/1/753',2,0),(754,80,436,'/1/753/754',3,0),(755,80,437,'/1/753/755',3,0),(756,80,438,'/1/753/756',3,0),(757,80,439,'/1/753/757',3,0),(758,80,440,'/1/753/758',3,0),(759,80,441,'/1/753/759',3,0),(760,80,442,'/1/753/760',3,0),(761,80,443,'/1/753/761',3,0),(762,80,444,'/1/753/762',3,0),(763,50,72,'/1/79/80/85/763',5,0),(764,30,146,'/1/764',2,0),(765,80,445,'/1/764/765',3,0),(766,80,446,'/1/764/766',3,0),(767,80,447,'/1/764/767',3,0),(768,80,448,'/1/764/768',3,0),(769,80,449,'/1/764/769',3,0),(770,80,450,'/1/764/770',3,0),(771,80,451,'/1/764/771',3,0),(772,80,452,'/1/764/772',3,0),(773,80,453,'/1/764/773',3,0),(774,50,73,'/1/79/80/86/774',5,0),(775,70,53,'/1/79/80/86/774/775',6,0),(776,50,74,'/1/79/80/86/776',5,0),(777,30,147,'/1/777',2,0),(778,80,454,'/1/777/778',3,0),(779,80,455,'/1/777/779',3,0),(780,80,456,'/1/777/780',3,0),(781,80,457,'/1/777/781',3,0),(782,80,458,'/1/777/782',3,0),(783,80,459,'/1/777/783',3,0),(784,80,460,'/1/777/784',3,0),(785,80,461,'/1/777/785',3,0),(786,80,462,'/1/777/786',3,0),(787,30,148,'/1/787',2,0),(788,80,463,'/1/787/788',3,0),(789,80,464,'/1/787/789',3,0),(790,80,465,'/1/787/790',3,0),(791,80,466,'/1/787/791',3,0),(792,80,467,'/1/787/792',3,0),(793,80,468,'/1/787/793',3,0),(794,80,469,'/1/787/794',3,0),(795,80,470,'/1/787/795',3,0),(796,80,471,'/1/787/796',3,0),(797,30,149,'/1/797',2,0),(798,80,472,'/1/797/798',3,0),(799,80,473,'/1/797/799',3,0),(800,80,474,'/1/797/800',3,0),(801,80,475,'/1/797/801',3,0),(802,80,476,'/1/797/802',3,0),(803,80,477,'/1/797/803',3,0),(804,80,478,'/1/797/804',3,0),(805,80,479,'/1/797/805',3,0),(806,80,480,'/1/797/806',3,0),(807,70,55,'/1/79/80/86/774/807',6,0),(808,70,56,'/1/79/80/81/82/808',6,0),(809,30,150,'/1/809',2,0),(810,80,481,'/1/809/810',3,0),(811,80,482,'/1/809/811',3,0),(812,80,483,'/1/809/812',3,0),(813,80,484,'/1/809/813',3,0),(814,80,485,'/1/809/814',3,0),(815,80,486,'/1/809/815',3,0),(816,80,487,'/1/809/816',3,0),(817,80,488,'/1/809/817',3,0),(818,80,489,'/1/809/818',3,0),(819,70,48,'/1/79/80/81/733/819',6,0),(820,30,151,'/1/820',2,0),(821,80,490,'/1/820/821',3,0),(822,80,491,'/1/820/822',3,0),(823,80,492,'/1/820/823',3,0),(824,80,493,'/1/820/824',3,0),(825,80,494,'/1/820/825',3,0),(826,80,495,'/1/820/826',3,0),(827,80,496,'/1/820/827',3,0),(828,80,497,'/1/820/828',3,0),(829,80,498,'/1/820/829',3,0),(830,30,152,'/1/830',2,0),(831,80,499,'/1/830/831',3,0),(832,80,500,'/1/830/832',3,0),(833,80,501,'/1/830/833',3,0),(834,80,502,'/1/830/834',3,0),(835,80,503,'/1/830/835',3,0),(836,80,504,'/1/830/836',3,0),(837,80,505,'/1/830/837',3,0),(838,80,506,'/1/830/838',3,0),(839,80,507,'/1/830/839',3,0),(840,50,75,'/1/79/80/81/840',5,0),(841,70,57,'/1/79/80/81/840/841',6,0),(842,50,76,'/1/79/80/81/842',5,0),(843,50,77,'/1/79/80/81/843',5,0),(844,40,71,'/1/79/88/844',4,0),(845,50,78,'/1/79/88/844/845',5,0),(846,30,153,'/1/846',2,0),(847,80,508,'/1/846/847',3,0),(848,80,509,'/1/846/848',3,0),(849,80,510,'/1/846/849',3,0),(850,80,511,'/1/846/850',3,0),(851,80,512,'/1/846/851',3,0),(852,80,513,'/1/846/852',3,0),(853,80,514,'/1/846/853',3,0),(854,80,515,'/1/846/854',3,0),(855,80,516,'/1/846/855',3,0),(856,70,60,'/1/79/88/844/845/856',6,0),(857,40,72,'/1/857',2,0),(858,40,73,'/1/857/858',3,0),(859,40,74,'/1/857/858/859',4,0),(860,50,79,'/1/857/858/859/860',5,0),(861,30,154,'/1/861',2,0),(862,30,155,'/1/862',2,0),(863,80,517,'/1/862/863',3,0),(864,80,518,'/1/862/864',3,0),(865,80,519,'/1/862/865',3,0),(866,80,520,'/1/862/866',3,0),(867,80,521,'/1/862/867',3,0),(868,80,522,'/1/862/868',3,0),(869,80,523,'/1/862/869',3,0),(870,80,524,'/1/862/870',3,0),(871,80,525,'/1/862/871',3,0),(872,40,75,'/1/872',2,0),(873,40,76,'/1/872/873',3,0),(874,40,77,'/1/872/873/874',4,0),(875,50,80,'/1/872/873/874/875',5,0),(877,70,61,'/1/857/858/859/860/877',6,0),(878,40,79,'/1/79/878',3,0),(879,40,80,'/1/79/879',3,0),(880,40,81,'/1/79/88/880',4,0),(881,40,82,'/1/79/88/881',4,0),(882,40,83,'/1/79/88/882',4,0),(883,70,63,'/1/79/80/81/82/883',6,0),(884,80,526,'/1/5/884',3,0),(885,80,527,'/1/5/885',3,0),(886,30,156,'/1/886',2,0),(887,80,528,'/1/492/887',3,0),(888,80,529,'/1/492/888',3,0),(889,80,530,'/1/492/889',3,0),(890,80,531,'/1/492/890',3,0),(891,80,532,'/1/492/891',3,0),(892,80,533,'/1/492/892',3,0),(893,80,534,'/1/492/893',3,0),(894,80,535,'/1/492/894',3,0),(895,80,536,'/1/492/895',3,0),(896,40,84,'/1/896',2,0),(897,40,85,'/1/896/897',3,0),(898,40,86,'/1/896/897/898',4,0),(899,50,81,'/1/896/897/898/899',5,0),(900,30,157,'/1/900',2,0),(901,80,537,'/1/900/901',3,0),(902,80,538,'/1/900/902',3,0),(903,80,539,'/1/900/903',3,0),(904,80,540,'/1/900/904',3,0),(905,80,541,'/1/900/905',3,0),(906,80,542,'/1/900/906',3,0),(907,80,543,'/1/900/907',3,0),(908,80,544,'/1/900/908',3,0),(909,80,545,'/1/900/909',3,0),(910,40,87,'/1/910',2,0),(911,40,88,'/1/910/911',3,0),(912,50,82,'/1/79/80/81/912',5,0),(913,70,64,'/1/896/897/898/899/913',6,0),(914,30,158,'/1/914',2,0),(915,40,89,'/1/915',2,0),(916,40,90,'/1/915/916',3,0),(917,40,91,'/1/915/916/917',4,0),(918,50,83,'/1/915/916/917/918',5,0),(919,80,546,'/1/914/919',3,0),(920,80,547,'/1/914/920',3,0),(921,80,548,'/1/914/921',3,0),(922,80,549,'/1/914/922',3,0),(923,80,550,'/1/914/923',3,0),(924,80,551,'/1/914/924',3,0),(925,80,552,'/1/914/925',3,0),(926,80,553,'/1/914/926',3,0),(927,80,554,'/1/914/927',3,0),(928,30,159,'/1/928',2,0),(929,30,160,'/1/929',2,0),(930,30,161,'/1/930',2,0),(931,30,162,'/1/931',2,0),(932,30,163,'/1/932',2,0),(933,30,164,'/1/933',2,0),(934,30,165,'/1/934',2,0),(935,30,166,'/1/935',2,0),(936,30,167,'/1/936',2,0),(937,30,168,'/1/937',2,0),(938,30,169,'/1/938',2,0),(939,30,170,'/1/939',2,0),(940,30,171,'/1/940',2,0),(941,30,172,'/1/941',2,0),(942,80,555,'/1/941/942',3,0),(943,80,556,'/1/941/943',3,0),(944,80,557,'/1/941/944',3,0),(945,80,558,'/1/941/945',3,0),(946,80,559,'/1/941/946',3,0),(947,80,560,'/1/941/947',3,0),(948,80,561,'/1/941/948',3,0),(949,80,562,'/1/941/949',3,0),(950,80,563,'/1/941/950',3,0),(951,70,46,'/1/79/80/86/731/951',6,0),(952,50,84,'/1/79/80/81/952',5,0),(953,80,564,'/1/719/953',3,0),(954,80,565,'/1/719/954',3,0),(955,80,566,'/1/719/955',3,0),(956,80,567,'/1/719/956',3,0),(957,80,568,'/1/719/957',3,0),(958,80,569,'/1/719/958',3,0),(959,80,570,'/1/719/959',3,0),(960,80,571,'/1/719/960',3,0),(961,80,572,'/1/719/961',3,0),(962,30,173,'/1/962',2,0),(963,80,573,'/1/962/963',3,0),(964,80,574,'/1/962/964',3,0),(965,80,575,'/1/962/965',3,0),(966,80,576,'/1/962/966',3,0),(967,80,577,'/1/962/967',3,0),(968,80,578,'/1/962/968',3,0),(969,80,579,'/1/962/969',3,0),(970,80,580,'/1/962/970',3,0),(971,80,581,'/1/962/971',3,0),(972,30,174,'/1/972',2,0),(973,80,582,'/1/972/973',3,0),(974,80,583,'/1/972/974',3,0),(975,80,584,'/1/972/975',3,0),(976,80,585,'/1/972/976',3,0),(977,80,586,'/1/972/977',3,0),(978,80,587,'/1/972/978',3,0),(979,80,588,'/1/972/979',3,0),(980,80,589,'/1/972/980',3,0),(981,80,590,'/1/972/981',3,0),(982,30,175,'/1/982',2,0),(983,30,176,'/1/983',2,0),(984,80,591,'/1/983/984',3,0),(985,80,592,'/1/983/985',3,0),(986,80,593,'/1/983/986',3,0),(987,80,594,'/1/983/987',3,0),(988,80,595,'/1/983/988',3,0),(989,80,596,'/1/983/989',3,0),(990,80,597,'/1/983/990',3,0),(991,80,598,'/1/983/991',3,0),(992,80,599,'/1/983/992',3,0),(993,50,85,'/1/79/80/81/993',5,0);
/*!40000 ALTER TABLE `mdl_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_context_temp`
--

DROP TABLE IF EXISTS `mdl_context_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_context_temp` (
  `id` bigint(10) NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `depth` tinyint(2) NOT NULL,
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Used by build_context_path() in upgrade and cron to keep con';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_context_temp`
--

LOCK TABLES `mdl_context_temp` WRITE;
/*!40000 ALTER TABLE `mdl_context_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_context_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course`
--

DROP TABLE IF EXISTS `mdl_course`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext COLLATE utf8mb4_unicode_ci,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `format` varchar(21) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'topics',
  `showgrades` tinyint(2) NOT NULL DEFAULT '1',
  `newsitems` mediumint(5) NOT NULL DEFAULT '1',
  `startdate` bigint(10) NOT NULL DEFAULT '0',
  `enddate` bigint(10) NOT NULL DEFAULT '0',
  `duration` bigint(10) DEFAULT '0',
  `relativedatesmode` tinyint(1) NOT NULL DEFAULT '0',
  `marker` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `showreports` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `downloadcontent` tinyint(1) DEFAULT NULL,
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupmodeforce` smallint(4) NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `calendartype` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint(10) NOT NULL DEFAULT '0',
  `originalcourseid` bigint(10) DEFAULT NULL,
  `showactivitydates` tinyint(1) NOT NULL DEFAULT '0',
  `showcompletionconditions` tinyint(1) DEFAULT NULL,
  `tenant_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_cour_cat_ix` (`category`),
  KEY `mdl_cour_idn_ix` (`idnumber`),
  KEY `mdl_cour_sho_ix` (`shortname`),
  KEY `mdl_cour_sor_ix` (`sortorder`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Central course table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course`
--

LOCK TABLES `mdl_course` WRITE;
/*!40000 ALTER TABLE `mdl_course` DISABLE KEYS */;
INSERT INTO `mdl_course` VALUES (1,0,1,'tenant','tenant','','',0,'site',1,3,0,0,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663307057,1663673781,0,0,0,1666286542,NULL,0,NULL,'2'),(2,4,120011,'Course 1','Course 1','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663313160,1666076604,0,1,0,1666286542,NULL,1,1,'2'),(3,4,120010,'Course 2','Course 2','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663313175,1663313175,0,1,0,1666286542,NULL,1,1,'2'),(4,4,120009,'Course 3','Course 3','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663313192,1664514529,0,1,0,1666286542,NULL,1,1,'2'),(5,12,260003,'Course 1HSS','Course 1HSS','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663313597,1663313597,0,1,0,1666286542,NULL,1,1,'2'),(6,12,260002,'Course 2HSS','Course 2HSS','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663313614,1663313614,0,1,0,1666286542,NULL,1,1,'2'),(7,12,260001,'Course 3HSS','Course 3HSS','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663313643,1663313643,0,1,0,1666286542,NULL,1,1,'2'),(10,11,220001,'coues2','cc','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663333541,1663333541,0,1,0,1666286542,NULL,1,1,'2'),(11,16,180001,'course3','c3','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663336490,1663336490,0,1,0,1666286542,NULL,1,1,'2'),(12,3,110001,'course comunication','c33','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663337245,1664514470,0,1,0,1666286542,NULL,1,1,'2'),(14,7,80006,'course generic','generic','','',1,'topics',1,5,1663369200,1694905200,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663338525,1663338525,0,1,0,1666286542,NULL,1,1,'2'),(16,2,10004,'s12','s22','','',1,'topics',1,5,1663455600,1694991600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663427048,1665392195,0,1,0,1666286542,NULL,1,1,'7'),(17,2,10002,'course1','coursee1','','',1,'topics',1,5,1663542000,1695078000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663519141,1663519141,0,1,0,1666286542,NULL,1,1,'27'),(18,2,10003,'short','short','','',1,'topics',1,5,1663714800,1695250800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1663666153,1663666153,0,1,0,1666286542,NULL,1,1,'2'),(22,18,270001,'Hospital Course','HC123','','',1,'topics',1,5,1664751600,1696287600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1664734735,1664734735,0,1,0,1666286542,NULL,1,1,'2'),(24,4,120008,'course-4','course-4','','',1,'topics',1,5,1665270000,1696806000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665246824,1665246824,0,1,0,1666286542,NULL,1,1,'2'),(29,64,320001,'ENT -Demo','ENT -Demo','','',1,'topics',1,5,1665442800,1696978800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665393318,1665393318,0,1,0,1666286542,NULL,1,1,'2'),(45,69,360001,'tdfdsg','fgsfdg','','',1,'topics',1,5,1665615600,1697151600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665579243,1665579243,0,1,0,1666286542,NULL,1,1,'76'),(48,17,190007,'test3232','test32323','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665987277,1665987277,0,1,0,1666286542,NULL,1,1,'2'),(49,17,190006,'test2401','test2401','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665988039,1665988039,0,1,0,1666286542,NULL,1,1,'2'),(50,17,190005,'tewerew','wrewr','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665988072,1665988072,0,1,0,1666286542,NULL,1,1,'2'),(54,17,190004,'teeee','eeeee','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665989236,1665989236,0,1,0,1666286542,NULL,1,1,'2'),(56,2,10001,'rgeg','rttrhr','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665989545,1665989545,0,1,0,1666286542,NULL,1,1,'2'),(57,17,190003,'czxvc','vcxvg','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665996673,1665996673,0,1,0,1666286542,NULL,1,1,'2'),(58,17,190002,'test32','test32f','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665996712,1665996712,0,1,0,1666286542,NULL,1,1,'2'),(59,14,230001,'trtrtrtre','tretreter','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665997646,1665997646,0,1,0,1666286542,NULL,1,1,'2'),(60,17,190001,'teststss','teststss','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665999621,1665999621,0,1,0,1666286542,NULL,1,1,'2'),(61,7,80005,'test23','test23','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1665999912,1665999912,0,1,0,1666286542,NULL,1,1,'2'),(62,7,80004,'test234','test234','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666000315,1666000315,0,1,0,1666286542,NULL,1,1,'2'),(64,7,80003,'manohart','manohar','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666000590,1666000590,0,1,0,1666286542,NULL,1,1,'2'),(65,7,80002,'testing','testing','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666001199,1666001199,0,1,0,1666286542,NULL,1,1,'2'),(66,6,140003,'Fiction','Fiction','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666010345,1666010345,0,1,0,1666286542,NULL,1,1,'2'),(67,7,80001,'Digital Electronics','Digital Electronics','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666010479,1666010479,0,1,0,1666286542,NULL,1,1,'2'),(68,4,120007,'course 5','course 5','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666010590,1666010590,0,1,0,1666286542,NULL,1,1,'2'),(69,70,150003,'test2332','test2332','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666011949,1666011949,0,1,0,1666286542,NULL,1,1,'2'),(70,70,150002,'manohartestststs','manohartestststs','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666012450,1666012450,0,1,0,1666286542,NULL,1,1,'2'),(71,70,150001,'test3232','test3232','','',1,'topics',1,5,1666047600,1697583600,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666013158,1666013158,0,1,0,1666286542,NULL,1,1,'2'),(72,5,130001,'Rapid course 2','Rapid course 2','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666067360,1666067360,0,1,0,1666286542,NULL,1,1,'2'),(73,6,140002,'Fiction 2','Fiction 2','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666067895,1666067895,0,1,0,1666286542,NULL,1,1,'2'),(74,6,140001,'Fiction 3','Fiction 3','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666068000,1666068000,0,1,0,1666286542,NULL,1,1,'2'),(75,4,120006,'course 6','course 6','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666079282,1666079282,0,1,0,1666286542,NULL,1,1,'2'),(76,4,120005,'course 7','course 7','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666079436,1666079436,0,1,0,1666286542,NULL,1,1,'2'),(77,4,120004,'course 8','course 8','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666079936,1666079936,0,1,0,1666286542,NULL,1,1,'2'),(78,71,40001,'English001','English001','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666086649,1666086649,0,1,0,1666286542,NULL,1,1,'2'),(79,74,390001,'Database management system','DBMS','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666087243,1666087243,0,1,0,1666286542,NULL,1,1,'153'),(80,77,420001,'Sem 1','Sem 1','','',1,'topics',1,5,1666134000,1697670000,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666088385,1666088385,0,1,0,1666286542,NULL,1,1,'155'),(81,86,450001,'All about Literature','All about Literature','','',1,'topics',1,5,1666306800,1697842800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666241669,1666241669,0,1,0,1666286542,NULL,1,1,'2'),(82,4,120003,'course34','course34','','',1,'topics',1,5,1666306800,1697842800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666245645,1666245645,0,1,0,1666286542,NULL,1,1,'2'),(83,91,500001,'New Demo Course','New Demo Course','','',1,'topics',1,5,1666306800,1697842800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666247568,1666247568,0,1,0,1666286542,NULL,1,1,'2'),(84,4,120002,'testmanohart','testmanohart','','',1,'topics',1,5,1666306800,1697842800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666266069,1666266069,0,1,0,1666286542,NULL,1,1,'2'),(85,4,120001,'manohartest','manohartest','','',1,'topics',1,5,1666306800,1697842800,0,0,0,0,0,0,1,1,NULL,0,0,0,'','','',1666286520,1666286520,0,1,0,1666286550,NULL,1,1,'2');
/*!40000 ALTER TABLE `mdl_course` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_categories`
--

DROP TABLE IF EXISTS `mdl_course_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `coursecount` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tenant_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_courcate_par_ix` (`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_categories`
--

LOCK TABLES `mdl_course_categories` WRITE;
/*!40000 ALTER TABLE `mdl_course_categories` DISABLE KEYS */;
INSERT INTO `mdl_course_categories` VALUES (2,'RapidEzy Generic Course Library','','',1,0,10000,4,1,1,1663313012,1,'/2',NULL,'2'),(3,'Communicate & Build Relationships','','',1,2,110000,1,1,1,1663313077,2,'/2/3',NULL,'2'),(4,'Modular Course','','',1,3,120000,11,1,1,1663313113,3,'/2/3/4',NULL,'2'),(5,'Rapid Course','','',1,3,130000,1,1,1,1663313224,3,'/2/3/5',NULL,'2'),(6,'Book Summary','','',1,3,140000,3,1,1,1663313244,3,'/2/3/6',NULL,'2'),(7,'Digital & Information Management','','',1,2,80000,6,1,1,1663313272,2,'/2/7',NULL,'2'),(8,'English at the Workplace','','',1,2,30000,0,1,1,1663313289,2,'/2/8',NULL,'2'),(9,'Ethics, Risk & Compliance','','',1,2,20000,0,1,1,1663313311,2,'/2/9',NULL,'2'),(11,'Hospitality Star Technical Course Library ','','',1,0,220000,1,1,1,1663313530,1,'/11',NULL,'2'),(12,'Hospitality Soft Skills ','','',1,11,260000,3,1,1,1663313550,2,'/11/12',NULL,'2'),(13,'Hotel Front Office ','','',1,11,240000,0,1,1,1663313660,2,'/11/13',NULL,'2'),(14,'Hotel Housekeeping','','',1,11,230000,1,1,1,1663313674,2,'/11/14',NULL,'2'),(16,'RapidEzy Free Generic Course Library ','','',1,0,180000,1,1,1,1663313709,1,'/16',NULL,'2'),(17,'Hospitality Star Free Technical Course Library ','','',1,16,190000,7,1,1,1663313781,2,'/16/17',NULL,'2'),(18,'Hospitality Star sub','','',1,12,270000,1,1,1,1663330721,3,'/11/12/18',NULL,'2'),(20,'hotal sub','','',1,13,250000,0,1,1,1663338445,3,'/11/13/20',NULL,'2'),(21,'digital cat','','',1,7,90000,0,1,1,1663338715,3,'/2/7/21',NULL,'2'),(22,'digital info sub','','',1,7,100000,0,1,1,1663340073,3,'/2/7/22',NULL,'2'),(23,'Hospitality Star Free Technical Course Library   0Courses sub','','',1,17,200000,0,1,1,1663395991,3,'/16/17/23',NULL,'2'),(32,'test','','',1,23,210000,0,1,1,1664010359,4,'/16/17/23/32',NULL,'2'),(58,'Rapid - Demo','','',1,0,280000,0,1,1,1665392362,1,'/58',NULL,'2'),(60,'Build Relation-Demo','','',1,58,290000,0,1,1,1665392861,2,'/58/60',NULL,'2'),(62,'Communicate - Demo','','',1,58,310000,0,1,1,1665393157,2,'/58/62',NULL,'2'),(63,'Health-Demo','','',1,60,300000,0,1,1,1665393187,3,'/58/60/63',NULL,'2'),(64,'Cure and Care -Demo','','',1,62,320000,1,1,1,1665393244,3,'/58/62/64',NULL,'2'),(65,'Digital -Demo','','',1,58,330000,0,1,1,1665396565,2,'/58/65',NULL,'2'),(67,'Health and Happiness','','',1,58,340000,0,1,1,1665399552,2,'/58/67',NULL,'2'),(68,'teststs','','',1,0,350000,0,1,1,1665579181,1,'/68',NULL,'76'),(69,'testststs','','',1,0,360000,1,1,1,1665579228,1,'/69',NULL,'76'),(70,'rtest','','',1,2,150000,3,1,1,1665982871,2,'/2/70',NULL,'2'),(71,'English','','',1,8,40000,1,1,1,1666086610,3,'/2/8/71',NULL,'2'),(72,'Computer Science','','',1,0,370000,0,1,1,1666087092,1,'/72',NULL,'153'),(73,'Year 1','','',1,72,380000,0,1,1,1666087124,2,'/72/73',NULL,'153'),(74,'Semester 1','','',1,73,390000,1,1,1,1666087215,3,'/72/73/74',NULL,'153'),(75,'Electronics','','',1,0,400000,0,1,1,1666088320,1,'/75',NULL,'155'),(76,'Electrical and communication','','',1,75,410000,0,1,1,1666088352,2,'/75/76',NULL,'155'),(77,'Year1','','',1,76,420000,1,1,1,1666088367,3,'/75/76/77',NULL,'155'),(79,'tetsts','','',1,2,160000,0,1,1,1666115825,2,'/2/79',NULL,'2'),(80,'tetsts','','',1,2,170000,0,1,1,1666115843,2,'/2/80',NULL,'2'),(81,'testttt','','',1,8,50000,0,1,1,1666115896,3,'/2/8/81',NULL,'2'),(82,'testttt','','',1,8,60000,0,1,1,1666116889,3,'/2/8/82',NULL,'2'),(83,'testttt','','',1,8,70000,0,1,1,1666116902,3,'/2/8/83',NULL,'2'),(84,'Literature:Demo','','',1,0,430000,0,1,1,1666241593,1,'/84',NULL,'2'),(85,'year1','','',1,84,440000,0,1,1,1666241610,2,'/84/85',NULL,'2'),(86,'Sem 1','','',1,85,450000,1,1,1,1666241635,3,'/84/85/86',NULL,'2'),(87,'cs1','','',1,0,460000,0,1,1,1666243538,1,'/87',NULL,'157'),(88,'cs2','','',1,87,470000,0,1,1,1666243548,2,'/87/88',NULL,'157'),(89,'category1','','',1,0,480000,0,1,1,1666247498,1,'/89',NULL,'2'),(90,'sub-cat1','','',1,89,490000,0,1,1,1666247518,2,'/89/90',NULL,'2'),(91,'Sub-Sub cat 1','','',1,90,500000,1,1,1,1666247537,3,'/89/90/91',NULL,'2');
/*!40000 ALTER TABLE `mdl_course_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_aggr_methd`
--

DROP TABLE IF EXISTS `mdl_course_completion_aggr_methd`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_aggr_methd` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompaggrmeth_coucr_uix` (`course`,`criteriatype`),
  KEY `mdl_courcompaggrmeth_cou_ix` (`course`),
  KEY `mdl_courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion aggregation methods for criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_aggr_methd`
--

LOCK TABLES `mdl_course_completion_aggr_methd` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_aggr_methd` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_aggr_methd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_crit_compl`
--

DROP TABLE IF EXISTS `mdl_course_completion_crit_compl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_crit_compl` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriaid` bigint(10) NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint(10) DEFAULT NULL,
  `timecompleted` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompcritcomp_useco_uix` (`userid`,`course`,`criteriaid`),
  KEY `mdl_courcompcritcomp_use_ix` (`userid`),
  KEY `mdl_courcompcritcomp_cou_ix` (`course`),
  KEY `mdl_courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `mdl_courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion user records';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_crit_compl`
--

LOCK TABLES `mdl_course_completion_crit_compl` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_crit_compl` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_crit_compl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_criteria`
--

DROP TABLE IF EXISTS `mdl_course_completion_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moduleinstance` bigint(10) DEFAULT NULL,
  `courseinstance` bigint(10) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion criteria';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_criteria`
--

LOCK TABLES `mdl_course_completion_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completion_defaults`
--

DROP TABLE IF EXISTS `mdl_course_completion_defaults`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completion_defaults` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL,
  `module` bigint(10) NOT NULL,
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionusegrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `customrules` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcompdefa_coumod_uix` (`course`,`module`),
  KEY `mdl_courcompdefa_mod_ix` (`module`),
  KEY `mdl_courcompdefa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Default settings for activities completion';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completion_defaults`
--

LOCK TABLES `mdl_course_completion_defaults` WRITE;
/*!40000 ALTER TABLE `mdl_course_completion_defaults` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completion_defaults` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_completions`
--

DROP TABLE IF EXISTS `mdl_course_completions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_completions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `timeenrolled` bigint(10) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) NOT NULL DEFAULT '0',
  `timecompleted` bigint(10) DEFAULT NULL,
  `reaggregate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courcomp_usecou_uix` (`userid`,`course`),
  KEY `mdl_courcomp_use_ix` (`userid`),
  KEY `mdl_courcomp_cou_ix` (`course`),
  KEY `mdl_courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Course completion records';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_completions`
--

LOCK TABLES `mdl_course_completions` WRITE;
/*!40000 ALTER TABLE `mdl_course_completions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_completions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_format_options`
--

DROP TABLE IF EXISTS `mdl_course_format_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_format_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `format` varchar(21) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sectionid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courformopti_couforsec_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `mdl_courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB AUTO_INCREMENT=170 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores format-specific options for the course or course sect';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_format_options`
--

LOCK TABLES `mdl_course_format_options` WRITE;
/*!40000 ALTER TABLE `mdl_course_format_options` DISABLE KEYS */;
INSERT INTO `mdl_course_format_options` VALUES (1,1,'site',0,'numsections','1'),(2,2,'topics',0,'hiddensections','0'),(3,2,'topics',0,'coursedisplay','0'),(4,3,'topics',0,'hiddensections','0'),(5,3,'topics',0,'coursedisplay','0'),(6,4,'topics',0,'hiddensections','0'),(7,4,'topics',0,'coursedisplay','0'),(8,5,'topics',0,'hiddensections','0'),(9,5,'topics',0,'coursedisplay','0'),(10,6,'topics',0,'hiddensections','0'),(11,6,'topics',0,'coursedisplay','0'),(12,7,'topics',0,'hiddensections','0'),(13,7,'topics',0,'coursedisplay','0'),(18,10,'topics',0,'hiddensections','0'),(19,10,'topics',0,'coursedisplay','0'),(20,11,'topics',0,'hiddensections','0'),(21,11,'topics',0,'coursedisplay','0'),(22,12,'topics',0,'hiddensections','0'),(23,12,'topics',0,'coursedisplay','0'),(26,14,'topics',0,'hiddensections','0'),(27,14,'topics',0,'coursedisplay','0'),(30,16,'topics',0,'hiddensections','0'),(31,16,'topics',0,'coursedisplay','0'),(32,17,'topics',0,'hiddensections','0'),(33,17,'topics',0,'coursedisplay','0'),(34,18,'topics',0,'hiddensections','0'),(35,18,'topics',0,'coursedisplay','0'),(42,22,'topics',0,'hiddensections','0'),(43,22,'topics',0,'coursedisplay','0'),(46,24,'topics',0,'hiddensections','0'),(47,24,'topics',0,'coursedisplay','0'),(56,29,'topics',0,'hiddensections','0'),(57,29,'topics',0,'coursedisplay','0'),(88,45,'topics',0,'hiddensections','0'),(89,45,'topics',0,'coursedisplay','0'),(94,48,'topics',0,'hiddensections','0'),(95,48,'topics',0,'coursedisplay','0'),(96,49,'topics',0,'hiddensections','0'),(97,49,'topics',0,'coursedisplay','0'),(98,50,'topics',0,'hiddensections','0'),(99,50,'topics',0,'coursedisplay','0'),(106,54,'topics',0,'hiddensections','0'),(107,54,'topics',0,'coursedisplay','0'),(110,56,'topics',0,'hiddensections','0'),(111,56,'topics',0,'coursedisplay','0'),(112,57,'topics',0,'hiddensections','0'),(113,57,'topics',0,'coursedisplay','0'),(114,58,'topics',0,'hiddensections','0'),(115,58,'topics',0,'coursedisplay','0'),(116,59,'topics',0,'hiddensections','0'),(117,59,'topics',0,'coursedisplay','0'),(118,60,'topics',0,'hiddensections','0'),(119,60,'topics',0,'coursedisplay','0'),(120,61,'topics',0,'hiddensections','0'),(121,61,'topics',0,'coursedisplay','0'),(122,62,'topics',0,'hiddensections','0'),(123,62,'topics',0,'coursedisplay','0'),(126,64,'topics',0,'hiddensections','0'),(127,64,'topics',0,'coursedisplay','0'),(128,65,'topics',0,'hiddensections','0'),(129,65,'topics',0,'coursedisplay','0'),(130,66,'topics',0,'hiddensections','0'),(131,66,'topics',0,'coursedisplay','0'),(132,67,'topics',0,'hiddensections','0'),(133,67,'topics',0,'coursedisplay','0'),(134,68,'topics',0,'hiddensections','0'),(135,68,'topics',0,'coursedisplay','0'),(136,69,'topics',0,'hiddensections','0'),(137,69,'topics',0,'coursedisplay','0'),(138,70,'topics',0,'hiddensections','0'),(139,70,'topics',0,'coursedisplay','0'),(140,71,'topics',0,'hiddensections','0'),(141,71,'topics',0,'coursedisplay','0'),(142,72,'topics',0,'hiddensections','0'),(143,72,'topics',0,'coursedisplay','0'),(144,73,'topics',0,'hiddensections','0'),(145,73,'topics',0,'coursedisplay','0'),(146,74,'topics',0,'hiddensections','0'),(147,74,'topics',0,'coursedisplay','0'),(148,75,'topics',0,'hiddensections','0'),(149,75,'topics',0,'coursedisplay','0'),(150,76,'topics',0,'hiddensections','0'),(151,76,'topics',0,'coursedisplay','0'),(152,77,'topics',0,'hiddensections','0'),(153,77,'topics',0,'coursedisplay','0'),(154,78,'topics',0,'hiddensections','0'),(155,78,'topics',0,'coursedisplay','0'),(156,79,'topics',0,'hiddensections','0'),(157,79,'topics',0,'coursedisplay','0'),(158,80,'topics',0,'hiddensections','0'),(159,80,'topics',0,'coursedisplay','0'),(160,81,'topics',0,'hiddensections','0'),(161,81,'topics',0,'coursedisplay','0'),(162,82,'topics',0,'hiddensections','0'),(163,82,'topics',0,'coursedisplay','0'),(164,83,'topics',0,'hiddensections','0'),(165,83,'topics',0,'coursedisplay','0'),(166,84,'topics',0,'hiddensections','0'),(167,84,'topics',0,'coursedisplay','0'),(168,85,'topics',0,'hiddensections','0'),(169,85,'topics',0,'coursedisplay','0');
/*!40000 ALTER TABLE `mdl_course_format_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_modules`
--

DROP TABLE IF EXISTS `mdl_course_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` bigint(10) NOT NULL DEFAULT '0',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added` bigint(10) NOT NULL DEFAULT '0',
  `score` smallint(4) NOT NULL DEFAULT '0',
  `indent` mediumint(5) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleoncoursepage` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint(10) DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext COLLATE utf8mb4_unicode_ci,
  `deletioninprogress` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_courmodu_vis_ix` (`visible`),
  KEY `mdl_courmodu_cou_ix` (`course`),
  KEY `mdl_courmodu_mod_ix` (`module`),
  KEY `mdl_courmodu_ins_ix` (`instance`),
  KEY `mdl_courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `mdl_courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='course_modules table retrofitted from MySQL';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_modules`
--

LOCK TABLES `mdl_course_modules` WRITE;
/*!40000 ALTER TABLE `mdl_course_modules` DISABLE KEYS */;
INSERT INTO `mdl_course_modules` VALUES (1,2,9,1,1,NULL,1663313160,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(2,3,9,2,6,NULL,1663313175,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(3,4,9,3,11,NULL,1663313192,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(4,5,9,4,16,NULL,1663313597,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(5,6,9,5,21,NULL,1663313614,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(6,7,9,6,26,NULL,1663313643,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(9,10,9,9,41,NULL,1663333541,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(10,11,9,10,46,NULL,1663336491,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(11,12,9,11,51,NULL,1663337245,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(13,14,9,13,61,NULL,1663338525,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(15,16,9,15,71,NULL,1663427048,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(16,17,9,16,76,NULL,1663519142,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(17,18,9,17,81,NULL,1663666153,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(18,12,17,1,51,'',1664260060,0,0,1,1,1,0,0,1,NULL,1,0,0,NULL,0),(19,12,17,2,52,'',1664260297,0,0,0,1,1,0,0,1,NULL,0,0,0,NULL,0),(23,22,9,21,102,NULL,1664734735,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(25,24,9,23,112,NULL,1665246824,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(29,29,9,27,132,NULL,1665393318,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(33,48,9,30,158,NULL,1665987277,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(34,49,9,31,163,NULL,1665988040,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(35,50,9,32,168,NULL,1665988072,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(36,54,9,33,173,NULL,1665989236,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(37,56,9,34,179,NULL,1665989545,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(38,57,9,35,184,NULL,1665996674,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(39,58,9,36,189,NULL,1665996712,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(40,59,9,37,194,NULL,1665997648,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(41,60,9,38,199,NULL,1665999621,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(42,61,9,39,204,NULL,1665999912,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(43,62,9,40,209,NULL,1666000315,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(44,64,9,41,214,NULL,1666000591,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(45,65,9,42,219,NULL,1666001199,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(46,66,9,43,224,NULL,1666010345,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(47,67,9,44,229,NULL,1666010480,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(48,68,9,45,234,NULL,1666010590,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(49,69,9,46,239,NULL,1666011949,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(50,70,9,47,244,NULL,1666012450,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(51,71,9,48,249,NULL,1666013158,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(52,72,9,49,254,NULL,1666067361,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(53,73,9,50,259,NULL,1666067895,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(54,74,9,51,264,NULL,1666068000,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(55,73,1,1,260,'',1666076168,0,0,1,1,1,0,0,1,NULL,0,0,0,NULL,0),(56,2,1,2,2,'',1666076622,0,0,1,1,1,0,0,1,NULL,0,0,0,NULL,0),(57,75,9,52,269,NULL,1666079283,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(58,76,9,53,274,NULL,1666079436,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(59,77,9,54,279,NULL,1666079937,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(60,78,9,55,284,NULL,1666086650,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(61,79,9,56,289,NULL,1666087243,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(62,80,9,57,294,NULL,1666088385,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(63,2,1,3,2,'',1666076622,0,0,1,1,1,2,0,1,NULL,0,0,0,NULL,1),(64,81,9,58,299,NULL,1666241670,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(65,82,9,59,304,NULL,1666245646,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(66,83,9,60,309,NULL,1666247569,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(67,84,9,61,314,NULL,1666266070,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0),(68,85,9,62,319,NULL,1666286521,0,0,1,1,1,0,0,0,NULL,0,0,0,NULL,0);
/*!40000 ALTER TABLE `mdl_course_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_modules_completion`
--

DROP TABLE IF EXISTS `mdl_course_modules_completion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_modules_completion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `viewed` tinyint(1) DEFAULT NULL,
  `overrideby` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `mdl_courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the completion state (completed or not completed, etc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_modules_completion`
--

LOCK TABLES `mdl_course_modules_completion` WRITE;
/*!40000 ALTER TABLE `mdl_course_modules_completion` DISABLE KEYS */;
INSERT INTO `mdl_course_modules_completion` VALUES (1,18,47,1,1,NULL,1664260067),(2,18,2,1,0,NULL,1664514112),(3,18,73,1,0,NULL,1664774643),(4,55,149,1,0,NULL,1666076188),(5,56,2,1,0,NULL,1666076677),(6,56,151,1,0,NULL,1666078544);
/*!40000 ALTER TABLE `mdl_course_modules_completion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_published`
--

DROP TABLE IF EXISTS `mdl_course_published`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_published` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `timepublished` bigint(10) NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Information about how and when an local courses were publish';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_published`
--

LOCK TABLES `mdl_course_published` WRITE;
/*!40000 ALTER TABLE `mdl_course_published` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_published` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_request`
--

DROP TABLE IF EXISTS `mdl_course_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `summary` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `category` bigint(10) NOT NULL DEFAULT '0',
  `reason` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `requester` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='course requests';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_request`
--

LOCK TABLES `mdl_course_request` WRITE;
/*!40000 ALTER TABLE `mdl_course_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_course_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_course_sections`
--

DROP TABLE IF EXISTS `mdl_course_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_course_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` longtext COLLATE utf8mb4_unicode_ci,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `sequence` longtext COLLATE utf8mb4_unicode_ci,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext COLLATE utf8mb4_unicode_ci,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_coursect_cousec_uix` (`course`,`section`)
) ENGINE=InnoDB AUTO_INCREMENT=324 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='to define the sections for each course';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_course_sections`
--

LOCK TABLES `mdl_course_sections` WRITE;
/*!40000 ALTER TABLE `mdl_course_sections` DISABLE KEYS */;
INSERT INTO `mdl_course_sections` VALUES (1,2,0,NULL,'',1,'1',1,NULL,1663313160),(2,2,1,NULL,'',1,'56,63',1,NULL,1666156208),(3,2,2,NULL,'',1,'',1,NULL,1663313160),(4,2,3,NULL,'',1,'',1,NULL,1663313160),(5,2,4,NULL,'',1,'',1,NULL,1663313160),(6,3,0,NULL,'',1,'2',1,NULL,1663313175),(7,3,1,NULL,'',1,'',1,NULL,1663313175),(8,3,2,NULL,'',1,'',1,NULL,1663313175),(9,3,3,NULL,'',1,'',1,NULL,1663313175),(10,3,4,NULL,'',1,'',1,NULL,1663313175),(11,4,0,NULL,'',1,'3',1,NULL,1663313192),(12,4,1,NULL,'',1,'',1,NULL,1663313192),(13,4,2,NULL,'',1,'',1,NULL,1663313192),(14,4,3,NULL,'',1,'',1,NULL,1663313192),(15,4,4,NULL,'',1,'',1,NULL,1663313192),(16,5,0,NULL,'',1,'4',1,NULL,1663313597),(17,5,1,NULL,'',1,'',1,NULL,1663313597),(18,5,2,NULL,'',1,'',1,NULL,1663313597),(19,5,3,NULL,'',1,'',1,NULL,1663313597),(20,5,4,NULL,'',1,'',1,NULL,1663313597),(21,6,0,NULL,'',1,'5',1,NULL,1663313614),(22,6,1,NULL,'',1,'',1,NULL,1663313614),(23,6,2,NULL,'',1,'',1,NULL,1663313614),(24,6,3,NULL,'',1,'',1,NULL,1663313615),(25,6,4,NULL,'',1,'',1,NULL,1663313615),(26,7,0,NULL,'',1,'6',1,NULL,1663313643),(27,7,1,NULL,'',1,'',1,NULL,1663313643),(28,7,2,NULL,'',1,'',1,NULL,1663313643),(29,7,3,NULL,'',1,'',1,NULL,1663313643),(30,7,4,NULL,'',1,'',1,NULL,1663313643),(41,10,0,NULL,'',1,'9',1,NULL,1663333541),(42,10,1,NULL,'',1,'',1,NULL,1663333541),(43,10,2,NULL,'',1,'',1,NULL,1663333541),(44,10,3,NULL,'',1,'',1,NULL,1663333541),(45,10,4,NULL,'',1,'',1,NULL,1663333541),(46,11,0,NULL,'',1,'10',1,NULL,1663336491),(47,11,1,NULL,'',1,'',1,NULL,1663336491),(48,11,2,NULL,'',1,'',1,NULL,1663336491),(49,11,3,NULL,'',1,'',1,NULL,1663336491),(50,11,4,NULL,'',1,'',1,NULL,1663336491),(51,12,0,NULL,'',1,'11,18',1,NULL,1663337245),(52,12,1,NULL,'',1,'19',0,NULL,1665135583),(53,12,2,NULL,'',1,'',1,NULL,1663337245),(54,12,3,NULL,'',1,'',1,NULL,1663337245),(55,12,4,NULL,'',1,'',1,NULL,1663337245),(61,14,0,NULL,'',1,'13',1,NULL,1663338525),(62,14,1,NULL,'',1,'',1,NULL,1663338525),(63,14,2,NULL,'',1,'',1,NULL,1663338525),(64,14,3,NULL,'',1,'',1,NULL,1663338525),(65,14,4,NULL,'',1,'',1,NULL,1663338525),(71,16,0,NULL,'',1,'15',1,NULL,1663427048),(72,16,1,NULL,'',1,'',1,NULL,1663427048),(73,16,2,NULL,'',1,'',1,NULL,1663427048),(74,16,3,NULL,'',1,'',1,NULL,1663427048),(75,16,4,NULL,'',1,'',1,NULL,1663427048),(76,17,0,NULL,'',1,'16',1,NULL,1663519142),(77,17,1,NULL,'',1,'',1,NULL,1663519142),(78,17,2,NULL,'',1,'',1,NULL,1663519142),(79,17,3,NULL,'',1,'',1,NULL,1663519142),(80,17,4,NULL,'',1,'',1,NULL,1663519142),(81,18,0,NULL,'',1,'17',1,NULL,1663666153),(82,18,1,NULL,'',1,'',1,NULL,1663666153),(83,18,2,NULL,'',1,'',1,NULL,1663666153),(84,18,3,NULL,'',1,'',1,NULL,1663666153),(85,18,4,NULL,'',1,'',1,NULL,1663666153),(86,1,1,NULL,'',1,'',1,NULL,1663673675),(102,22,0,NULL,'',1,'23',1,NULL,1664734735),(103,22,1,NULL,'',1,'',1,NULL,1664734735),(104,22,2,NULL,'',1,'',1,NULL,1664734735),(105,22,3,NULL,'',1,'',1,NULL,1664734735),(106,22,4,NULL,'',1,'',1,NULL,1664734735),(112,24,0,NULL,'',1,'25',1,NULL,1665246824),(113,24,1,NULL,'',1,'',1,NULL,1665246824),(114,24,2,NULL,'',1,'',1,NULL,1665246824),(115,24,3,NULL,'',1,'',1,NULL,1665246824),(116,24,4,NULL,'',1,'',1,NULL,1665246824),(132,29,0,NULL,'',1,'29',1,NULL,1665393318),(133,29,1,NULL,'',1,'',1,NULL,1665393318),(134,29,2,NULL,'',1,'',1,NULL,1665393318),(135,29,3,NULL,'',1,'',1,NULL,1665393318),(136,29,4,NULL,'',1,'',1,NULL,1665393318),(157,45,0,NULL,'',1,'',1,NULL,1665986912),(158,48,0,NULL,'',1,'33',1,NULL,1665987277),(159,48,1,NULL,'',1,'',1,NULL,1665987277),(160,48,2,NULL,'',1,'',1,NULL,1665987277),(161,48,3,NULL,'',1,'',1,NULL,1665987277),(162,48,4,NULL,'',1,'',1,NULL,1665987277),(163,49,0,NULL,'',1,'34',1,NULL,1665988040),(164,49,1,NULL,'',1,'',1,NULL,1665988040),(165,49,2,NULL,'',1,'',1,NULL,1665988040),(166,49,3,NULL,'',1,'',1,NULL,1665988040),(167,49,4,NULL,'',1,'',1,NULL,1665988040),(168,50,0,NULL,'',1,'35',1,NULL,1665988072),(169,50,1,NULL,'',1,'',1,NULL,1665988072),(170,50,2,NULL,'',1,'',1,NULL,1665988072),(171,50,3,NULL,'',1,'',1,NULL,1665988072),(172,50,4,NULL,'',1,'',1,NULL,1665988072),(173,54,0,NULL,'',1,'36',1,NULL,1665989236),(174,54,1,NULL,'',1,'',1,NULL,1665989236),(175,54,2,NULL,'',1,'',1,NULL,1665989236),(176,54,3,NULL,'',1,'',1,NULL,1665989236),(177,54,4,NULL,'',1,'',1,NULL,1665989236),(179,56,0,NULL,'',1,'37',1,NULL,1665989545),(180,56,1,NULL,'',1,'',1,NULL,1665989545),(181,56,2,NULL,'',1,'',1,NULL,1665989545),(182,56,3,NULL,'',1,'',1,NULL,1665989545),(183,56,4,NULL,'',1,'',1,NULL,1665989545),(184,57,0,NULL,'',1,'38',1,NULL,1665996674),(185,57,1,NULL,'',1,'',1,NULL,1665996674),(186,57,2,NULL,'',1,'',1,NULL,1665996674),(187,57,3,NULL,'',1,'',1,NULL,1665996674),(188,57,4,NULL,'',1,'',1,NULL,1665996674),(189,58,0,NULL,'',1,'39',1,NULL,1665996712),(190,58,1,NULL,'',1,'',1,NULL,1665996712),(191,58,2,NULL,'',1,'',1,NULL,1665996712),(192,58,3,NULL,'',1,'',1,NULL,1665996712),(193,58,4,NULL,'',1,'',1,NULL,1665996712),(194,59,0,NULL,'',1,'40',1,NULL,1665997648),(195,59,1,NULL,'',1,'',1,NULL,1665997648),(196,59,2,NULL,'',1,'',1,NULL,1665997648),(197,59,3,NULL,'',1,'',1,NULL,1665997648),(198,59,4,NULL,'',1,'',1,NULL,1665997648),(199,60,0,NULL,'',1,'41',1,NULL,1665999621),(200,60,1,NULL,'',1,'',1,NULL,1665999621),(201,60,2,NULL,'',1,'',1,NULL,1665999621),(202,60,3,NULL,'',1,'',1,NULL,1665999621),(203,60,4,NULL,'',1,'',1,NULL,1665999621),(204,61,0,NULL,'',1,'42',1,NULL,1665999912),(205,61,1,NULL,'',1,'',1,NULL,1665999912),(206,61,2,NULL,'',1,'',1,NULL,1665999912),(207,61,3,NULL,'',1,'',1,NULL,1665999912),(208,61,4,NULL,'',1,'',1,NULL,1665999912),(209,62,0,NULL,'',1,'43',1,NULL,1666000315),(210,62,1,NULL,'',1,'',1,NULL,1666000315),(211,62,2,NULL,'',1,'',1,NULL,1666000315),(212,62,3,NULL,'',1,'',1,NULL,1666000315),(213,62,4,NULL,'',1,'',1,NULL,1666000315),(214,64,0,NULL,'',1,'44',1,NULL,1666000591),(215,64,1,NULL,'',1,'',1,NULL,1666000591),(216,64,2,NULL,'',1,'',1,NULL,1666000591),(217,64,3,NULL,'',1,'',1,NULL,1666000591),(218,64,4,NULL,'',1,'',1,NULL,1666000591),(219,65,0,NULL,'',1,'45',1,NULL,1666001199),(220,65,1,NULL,'',1,'',1,NULL,1666001199),(221,65,2,NULL,'',1,'',1,NULL,1666001199),(222,65,3,NULL,'',1,'',1,NULL,1666001199),(223,65,4,NULL,'',1,'',1,NULL,1666001199),(224,66,0,NULL,'',1,'46',1,NULL,1666010345),(225,66,1,NULL,'',1,'',1,NULL,1666010345),(226,66,2,NULL,'',1,'',1,NULL,1666010345),(227,66,3,NULL,'',1,'',1,NULL,1666010345),(228,66,4,NULL,'',1,'',1,NULL,1666010345),(229,67,0,NULL,'',1,'47',1,NULL,1666010480),(230,67,1,NULL,'',1,'',1,NULL,1666010480),(231,67,2,NULL,'',1,'',1,NULL,1666010480),(232,67,3,NULL,'',1,'',1,NULL,1666010480),(233,67,4,NULL,'',1,'',1,NULL,1666010480),(234,68,0,NULL,'',1,'48',1,NULL,1666010590),(235,68,1,NULL,'',1,'',1,NULL,1666010590),(236,68,2,NULL,'',1,'',1,NULL,1666010590),(237,68,3,NULL,'',1,'',1,NULL,1666010590),(238,68,4,NULL,'',1,'',1,NULL,1666010590),(239,69,0,NULL,'',1,'49',1,NULL,1666011949),(240,69,1,NULL,'',1,'',1,NULL,1666011949),(241,69,2,NULL,'',1,'',1,NULL,1666011949),(242,69,3,NULL,'',1,'',1,NULL,1666011949),(243,69,4,NULL,'',1,'',1,NULL,1666011949),(244,70,0,NULL,'',1,'50',1,NULL,1666012450),(245,70,1,NULL,'',1,'',1,NULL,1666012450),(246,70,2,NULL,'',1,'',1,NULL,1666012450),(247,70,3,NULL,'',1,'',1,NULL,1666012450),(248,70,4,NULL,'',1,'',1,NULL,1666012450),(249,71,0,NULL,'',1,'51',1,NULL,1666013158),(250,71,1,NULL,'',1,'',1,NULL,1666013158),(251,71,2,NULL,'',1,'',1,NULL,1666013158),(252,71,3,NULL,'',1,'',1,NULL,1666013158),(253,71,4,NULL,'',1,'',1,NULL,1666013158),(254,72,0,NULL,'',1,'52',1,NULL,1666067361),(255,72,1,NULL,'',1,'',1,NULL,1666067361),(256,72,2,NULL,'',1,'',1,NULL,1666067361),(257,72,3,NULL,'',1,'',1,NULL,1666067361),(258,72,4,NULL,'',1,'',1,NULL,1666067361),(259,73,0,NULL,'',1,'53',1,NULL,1666067895),(260,73,1,NULL,'',1,'55',1,NULL,1666067895),(261,73,2,NULL,'',1,'',1,NULL,1666067895),(262,73,3,NULL,'',1,'',1,NULL,1666067895),(263,73,4,NULL,'',1,'',1,NULL,1666067895),(264,74,0,NULL,'',1,'54',1,NULL,1666068000),(265,74,1,NULL,'',1,'',1,NULL,1666068000),(266,74,2,NULL,'',1,'',1,NULL,1666068000),(267,74,3,NULL,'',1,'',1,NULL,1666068000),(268,74,4,NULL,'',1,'',1,NULL,1666068000),(269,75,0,NULL,'',1,'57',1,NULL,1666079283),(270,75,1,NULL,'',1,'',1,NULL,1666079283),(271,75,2,NULL,'',1,'',1,NULL,1666079283),(272,75,3,NULL,'',1,'',1,NULL,1666079283),(273,75,4,NULL,'',1,'',1,NULL,1666079283),(274,76,0,NULL,'',1,'58',1,NULL,1666079436),(275,76,1,NULL,'',1,'',1,NULL,1666079436),(276,76,2,NULL,'',1,'',1,NULL,1666079436),(277,76,3,NULL,'',1,'',1,NULL,1666079436),(278,76,4,NULL,'',1,'',1,NULL,1666079436),(279,77,0,NULL,'',1,'59',1,NULL,1666079937),(280,77,1,NULL,'',1,'',1,NULL,1666079937),(281,77,2,NULL,'',1,'',1,NULL,1666079937),(282,77,3,NULL,'',1,'',1,NULL,1666079937),(283,77,4,NULL,'',1,'',1,NULL,1666079937),(284,78,0,NULL,'',1,'60',1,NULL,1666086650),(285,78,1,NULL,'',1,'',1,NULL,1666086650),(286,78,2,NULL,'',1,'',1,NULL,1666086650),(287,78,3,NULL,'',1,'',1,NULL,1666086650),(288,78,4,NULL,'',1,'',1,NULL,1666086650),(289,79,0,NULL,'',1,'61',1,NULL,1666087243),(290,79,1,NULL,'',1,'',1,NULL,1666087243),(291,79,2,NULL,'',1,'',1,NULL,1666087243),(292,79,3,NULL,'',1,'',1,NULL,1666087243),(293,79,4,NULL,'',1,'',1,NULL,1666087243),(294,80,0,NULL,'',1,'62',1,NULL,1666088385),(295,80,1,NULL,'',1,'',1,NULL,1666088385),(296,80,2,NULL,'',1,'',1,NULL,1666088385),(297,80,3,NULL,'',1,'',1,NULL,1666088385),(298,80,4,NULL,'',1,'',1,NULL,1666088385),(299,81,0,NULL,'',1,'64',1,NULL,1666241670),(300,81,1,NULL,'',1,'',1,NULL,1666241670),(301,81,2,NULL,'',1,'',1,NULL,1666241670),(302,81,3,NULL,'',1,'',1,NULL,1666241670),(303,81,4,NULL,'',1,'',1,NULL,1666241670),(304,82,0,NULL,'',1,'65',1,NULL,1666245646),(305,82,1,NULL,'',1,'',1,NULL,1666245646),(306,82,2,NULL,'',1,'',1,NULL,1666245646),(307,82,3,NULL,'',1,'',1,NULL,1666245646),(308,82,4,NULL,'',1,'',1,NULL,1666245646),(309,83,0,NULL,'',1,'66',1,NULL,1666247569),(310,83,1,NULL,'',1,'',1,NULL,1666247569),(311,83,2,NULL,'',1,'',1,NULL,1666247569),(312,83,3,NULL,'',1,'',1,NULL,1666247569),(313,83,4,NULL,'',1,'',1,NULL,1666247569),(314,84,0,NULL,'',1,'67',1,NULL,1666266070),(315,84,1,NULL,'',1,'',1,NULL,1666266070),(316,84,2,NULL,'',1,'',1,NULL,1666266070),(317,84,3,NULL,'',1,'',1,NULL,1666266070),(318,84,4,NULL,'',1,'',1,NULL,1666266070),(319,85,0,NULL,'',1,'68',1,NULL,1666286521),(320,85,1,NULL,'',1,'',1,NULL,1666286521),(321,85,2,NULL,'',1,'',1,NULL,1666286521),(322,85,3,NULL,'',1,'',1,NULL,1666286521),(323,85,4,NULL,'',1,'',1,NULL,1666286521);
/*!40000 ALTER TABLE `mdl_course_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_customfield_category`
--

DROP TABLE IF EXISTS `mdl_customfield_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_customfield_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `area` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_custcate_comareitesor_ix` (`component`,`area`,`itemid`,`sortorder`),
  KEY `mdl_custcate_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='core_customfield category table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_customfield_category`
--

LOCK TABLES `mdl_customfield_category` WRITE;
/*!40000 ALTER TABLE `mdl_customfield_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_customfield_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_customfield_data`
--

DROP TABLE IF EXISTS `mdl_customfield_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_customfield_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL,
  `instanceid` bigint(10) NOT NULL,
  `intvalue` bigint(10) DEFAULT NULL,
  `decvalue` decimal(10,5) DEFAULT NULL,
  `shortcharvalue` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `charvalue` varchar(1333) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `valueformat` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_custdata_insfie_uix` (`instanceid`,`fieldid`),
  KEY `mdl_custdata_fieint_ix` (`fieldid`,`intvalue`),
  KEY `mdl_custdata_fiesho_ix` (`fieldid`,`shortcharvalue`),
  KEY `mdl_custdata_fiedec_ix` (`fieldid`,`decvalue`),
  KEY `mdl_custdata_fie_ix` (`fieldid`),
  KEY `mdl_custdata_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='core_customfield data table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_customfield_data`
--

LOCK TABLES `mdl_customfield_data` WRITE;
/*!40000 ALTER TABLE `mdl_customfield_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_customfield_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_customfield_field`
--

DROP TABLE IF EXISTS `mdl_customfield_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_customfield_field` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `configdata` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_custfiel_catsor_ix` (`categoryid`,`sortorder`),
  KEY `mdl_custfiel_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='core_customfield field table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_customfield_field`
--

LOCK TABLES `mdl_customfield_field` WRITE;
/*!40000 ALTER TABLE `mdl_customfield_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_customfield_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data`
--

DROP TABLE IF EXISTS `mdl_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `comments` smallint(4) NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint(10) NOT NULL DEFAULT '0',
  `timeavailableto` bigint(10) NOT NULL DEFAULT '0',
  `timeviewfrom` bigint(10) NOT NULL DEFAULT '0',
  `timeviewto` bigint(10) NOT NULL DEFAULT '0',
  `requiredentries` int(8) NOT NULL DEFAULT '0',
  `requiredentriestoview` int(8) NOT NULL DEFAULT '0',
  `maxentries` int(8) NOT NULL DEFAULT '0',
  `rssarticles` smallint(4) NOT NULL DEFAULT '0',
  `singletemplate` longtext COLLATE utf8mb4_unicode_ci,
  `listtemplate` longtext COLLATE utf8mb4_unicode_ci,
  `listtemplateheader` longtext COLLATE utf8mb4_unicode_ci,
  `listtemplatefooter` longtext COLLATE utf8mb4_unicode_ci,
  `addtemplate` longtext COLLATE utf8mb4_unicode_ci,
  `rsstemplate` longtext COLLATE utf8mb4_unicode_ci,
  `rsstitletemplate` longtext COLLATE utf8mb4_unicode_ci,
  `csstemplate` longtext COLLATE utf8mb4_unicode_ci,
  `jstemplate` longtext COLLATE utf8mb4_unicode_ci,
  `asearchtemplate` longtext COLLATE utf8mb4_unicode_ci,
  `approval` smallint(4) NOT NULL DEFAULT '0',
  `manageapproved` smallint(4) NOT NULL DEFAULT '1',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `defaultsort` bigint(10) NOT NULL DEFAULT '0',
  `defaultsortdir` smallint(4) NOT NULL DEFAULT '0',
  `editany` smallint(4) NOT NULL DEFAULT '0',
  `notification` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `config` longtext COLLATE utf8mb4_unicode_ci,
  `completionentries` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all database activities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data`
--

LOCK TABLES `mdl_data` WRITE;
/*!40000 ALTER TABLE `mdl_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_content`
--

DROP TABLE IF EXISTS `mdl_data_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL DEFAULT '0',
  `recordid` bigint(10) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `content1` longtext COLLATE utf8mb4_unicode_ci,
  `content2` longtext COLLATE utf8mb4_unicode_ci,
  `content3` longtext COLLATE utf8mb4_unicode_ci,
  `content4` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_datacont_rec_ix` (`recordid`),
  KEY `mdl_datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='the content introduced in each record/fields';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_content`
--

LOCK TABLES `mdl_data_content` WRITE;
/*!40000 ALTER TABLE `mdl_data_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_fields`
--

DROP TABLE IF EXISTS `mdl_data_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_fields` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext COLLATE utf8mb4_unicode_ci,
  `param2` longtext COLLATE utf8mb4_unicode_ci,
  `param3` longtext COLLATE utf8mb4_unicode_ci,
  `param4` longtext COLLATE utf8mb4_unicode_ci,
  `param5` longtext COLLATE utf8mb4_unicode_ci,
  `param6` longtext COLLATE utf8mb4_unicode_ci,
  `param7` longtext COLLATE utf8mb4_unicode_ci,
  `param8` longtext COLLATE utf8mb4_unicode_ci,
  `param9` longtext COLLATE utf8mb4_unicode_ci,
  `param10` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_datafiel_typdat_ix` (`type`,`dataid`),
  KEY `mdl_datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='every field available';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_fields`
--

LOCK TABLES `mdl_data_fields` WRITE;
/*!40000 ALTER TABLE `mdl_data_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_data_records`
--

DROP TABLE IF EXISTS `mdl_data_records`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_data_records` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `approved` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_datareco_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='every record introduced';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_data_records`
--

LOCK TABLES `mdl_data_records` WRITE;
/*!40000 ALTER TABLE `mdl_data_records` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_data_records` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_dept_category_enrolments`
--

DROP TABLE IF EXISTS `mdl_dept_category_enrolments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_dept_category_enrolments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) DEFAULT NULL,
  `deptid` bigint(10) DEFAULT NULL,
  `roleid` bigint(10) DEFAULT NULL,
  `timestart` bigint(10) DEFAULT '0',
  `timeend` bigint(10) DEFAULT '0',
  `modifierid` bigint(10) DEFAULT '0',
  `timecreated` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_dept_category_enrolments`
--

LOCK TABLES `mdl_dept_category_enrolments` WRITE;
/*!40000 ALTER TABLE `mdl_dept_category_enrolments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_dept_category_enrolments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_dept_enrolments`
--

DROP TABLE IF EXISTS `mdl_dept_enrolments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_dept_enrolments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrolid` bigint(10) DEFAULT NULL,
  `deptid` bigint(10) DEFAULT NULL,
  `roleid` bigint(10) DEFAULT NULL,
  `timestart` bigint(10) DEFAULT '0',
  `timeend` bigint(10) DEFAULT '0',
  `modifierid` bigint(10) DEFAULT '0',
  `timecreated` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_dept_enrolments`
--

LOCK TABLES `mdl_dept_enrolments` WRITE;
/*!40000 ALTER TABLE `mdl_dept_enrolments` DISABLE KEYS */;
INSERT INTO `mdl_dept_enrolments` VALUES (1,249,1,5,1666075669,0,2,1666075669,1666075669);
/*!40000 ALTER TABLE `mdl_dept_enrolments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_editor_atto_autosave`
--

DROP TABLE IF EXISTS `mdl_editor_atto_autosave`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_editor_atto_autosave` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `elementid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `pagehash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `drafttext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `draftid` bigint(10) DEFAULT NULL,
  `pageinstance` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_editattoauto_eleconuse_uix` (`elementid`,`contextid`,`userid`,`pagehash`)
) ENGINE=InnoDB AUTO_INCREMENT=360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Draft text that is auto-saved every 5 seconds while an edito';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_editor_atto_autosave`
--

LOCK TABLES `mdl_editor_atto_autosave` WRITE;
/*!40000 ALTER TABLE `mdl_editor_atto_autosave` DISABLE KEYS */;
INSERT INTO `mdl_editor_atto_autosave` VALUES (25,'id_description_editor',79,'ceab0fe226d361824ef7fe5c40674c8b89e565e2',2,'',858945893,'yui_3_17_2_1_1663327260984_74',1663327262),(26,'id_description_editor',91,'fb327b57b5075b4f807ff7b1bc91b20ed4e0c0b7',2,'',923209370,'yui_3_17_2_1_1663327267481_71',1663327268),(38,'id_summary_editor',80,'da95670cf4ec118b134a4a910c64574086a74150',2,'',755867237,'yui_3_17_2_1_1663337951712_286',1663337961),(50,'id_summary_editor',84,'5c31641eae64c47b6eefb17ad9fc0d3f782216fd',7,'',587088056,'yui_3_17_2_1_1663409570548_286',1663409581),(55,'id_description_editor',101,'84d97aafd72ed81b0549e7ff794a2e30860b2774',2,'',604925078,'yui_3_17_2_1_1663411073707_114',1663411084),(57,'id_description_editor',38,'dcb4908551391475877240bebcfd6c7a73a9e714',2,'',16629727,'yui_3_17_2_1_1663411943240_114',1663411954),(60,'id_summary_editor',79,'5807563b25ddfb53ac6d50858281d841c94cad96',24,'',485920741,'yui_3_17_2_1_1663490252658_289',1663490265),(69,'id_description_editor',150,'79b358ba34c5fb2e2ecab575604cc037421af617',7,'',610382549,'yui_3_17_2_1_1663425610731_70',1663425622),(72,'id_summary_editor',79,'a68554f9190199a3fbc629431e62eadad69c6e32',2,'',479383754,'yui_3_17_2_1_1663488384352_289',1663488397),(73,'id_description_editor',137,'69bc3f699dec85ad921e55a92b702aaada088638',2,'',266522893,'yui_3_17_2_1_1663678190952_122',1663678193),(75,'id_summary_editor',79,'5807563b25ddfb53ac6d50858281d841c94cad96',27,'',862413134,'yui_3_17_2_1_1663519157577_284',1663519154),(80,'id_summary_editor',122,'d9140ea3bcac16bce9d2a1da0dac3d16218ee5eb',2,'',68455571,'yui_3_17_2_1_1663569055332_287',1663569068),(81,'id_description_editor',1,'2e88f12cdca0e971c2ce9b52c305648955c2b423',2,'',639181996,'yui_3_17_2_1_1663589077150_71',1663589078),(84,'id_description_editor',138,'34dfb50b9ed04402240200e470dfe1d02e535111',7,'',516980482,'yui_3_17_2_1_1663590053043_113',1663590054),(89,'id_description_editor',1,'dd4797a3608fe1f93ec2f1654685fdf4d2700af9',36,'',-1,'yui_3_17_2_1_1663673177754_123',1663673181),(93,'id_description_editor',136,'6f1e0697bebf3a8659edf2caefd1fae1239028f4',2,'',134918260,'yui_3_17_2_1_1663678291806_113',1663678293),(95,'id_description_editor',188,'d8822dffdf5cde6050f6d7498c7b2867829e7de5',33,'',230219069,'yui_3_17_2_1_1663691094608_113',1663691108),(97,'id_message',187,'57fc920c13f88e4e942c985e257cec99f3e87e8b',2,'',351398488,'yui_3_17_2_1_1663745764275_48',1663745765),(98,'id_introeditor',187,'a7d71cb58f829ed7b0b951ff4202e8ad33949273',2,'<table>\n    <tbody>\n        <tr>\n            <td><br></td>\n        </tr>\n        <tr>\n            <td><br></td>\n        </tr>\n    </tbody>\n</table>',901267344,'yui_3_17_2_1_1663746092434_146',1663746218),(99,'id_message',123,'3d57974c4d9581be38019dd9409d8bbf23c84fc6',2,'',659278876,'yui_3_17_2_1_1663755204201_48',1663755205),(100,'id_description_editor',79,'5782b627092e61c6ca7b010b800d77f3250fdbde',45,'',552579861,'yui_3_17_2_1_1663926628850_74',1663926644),(101,'id_description_editor',283,'8c422304da0f4e37dcef11c7a0049e257d86d9e5',2,'',833037624,'yui_3_17_2_1_1663999983384_114',1663999976),(105,'id_description_editor',129,'f0a30fc1ac00abca316a3046d13ed74291ee82c9',2,'',123348535,'yui_3_17_2_1_1664010339137_74',1664010339),(109,'id_description_editor',294,'1d722e99e4ac1b22e6471fcfcb346c6f208aaca6',2,'',280459644,'yui_3_17_2_1_1664256021487_115',1664256020),(110,'id_introeditor',122,'e4b63a8c3f102588d957455090f72fb9503d3947',47,'',394514664,'yui_3_17_2_1_1664260057116_164',1664260059),(111,'id_feedbacktext_0',122,'e4b63a8c3f102588d957455090f72fb9503d3947',47,'',312441828,'yui_3_17_2_1_1664260057116_763',1664260060),(112,'id_feedbacktext_1',122,'e4b63a8c3f102588d957455090f72fb9503d3947',47,'',337151842,'yui_3_17_2_1_1664260057116_1147',1664260060),(113,'id_feedbacktext_2',122,'e4b63a8c3f102588d957455090f72fb9503d3947',47,'',492418664,'yui_3_17_2_1_1664260057116_1530',1664260060),(114,'id_feedbacktext_3',122,'e4b63a8c3f102588d957455090f72fb9503d3947',47,'',891907912,'yui_3_17_2_1_1664260057116_1913',1664260060),(115,'id_feedbacktext_4',122,'e4b63a8c3f102588d957455090f72fb9503d3947',47,'',663798414,'yui_3_17_2_1_1664260057116_2296',1664260060),(127,'id_description_editor',1,'dd4797a3608fe1f93ec2f1654685fdf4d2700af9',58,'',-1,'yui_3_17_2_1_1664455289011_115',1664455291),(128,'id_description_editor',79,'5782b627092e61c6ca7b010b800d77f3250fdbde',58,'',684365794,'yui_3_17_2_1_1664456002862_71',1664456006),(129,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',7,'',934406947,'yui_3_17_2_1_1664467969838_71',1664467971),(135,'id_summary_editor',84,'5c31641eae64c47b6eefb17ad9fc0d3f782216fd',2,'',168448281,'yui_3_17_2_1_1664514549123_287',1664514542),(136,'id_description_editor',344,'fe82494aa5677bf8a83c7420fa10d3a5a88c7aa0',65,'',36860930,'yui_3_17_2_1_1664528070551_115',1664528072),(137,'id_description_editor',80,'1b64b8ab489d4c6f2cc585e8be3af871c9541fa0',2,'',240450940,'yui_3_17_2_1_1664603318354_74',1664603320),(140,'id_description_editor',373,'1af12f16d8df79d734001ebd58095053065222f6',7,'',634650023,'yui_3_17_2_1_1664611055307_72',1664611057),(143,'id_summary_editor',373,'51fe0f0682983d24340c0c0e9212e95a14899f52',7,'',851451540,'yui_3_17_2_1_1664625863568_287',1664625865),(145,'id_description_editor',79,'5782b627092e61c6ca7b010b800d77f3250fdbde',67,'',48967458,'yui_3_17_2_1_1664631998498_71',1664632000),(148,'id_summary_editor',83,'cc6a103fbd2a7c50e5a62a558f6a291153b1b6c1',7,'',276322724,'yui_3_17_2_1_1664641351873_290',1664641355),(151,'id_description_editor',112,'719b1a828b6b42b539404ff6e871de8b813eed55',72,'',664386671,'yui_3_17_2_1_1664775605084_112',1664775610),(159,'id_summary_editor',79,'50d4250846c17724c8e21a8ad76600296a0d9380',76,'',676861083,'yui_3_17_2_1_1664817422150_290',1664817424),(161,'id_description_editor',80,'1b64b8ab489d4c6f2cc585e8be3af871c9541fa0',76,'',27752818,'yui_3_17_2_1_1664818521601_75',1664818523),(163,'id_description_editor',85,'e913c144a7ca2d620efad4ae5753280366bbe3fe',76,'',341452298,'yui_3_17_2_1_1664818737360_71',1664818738),(164,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',78,'',227306981,'yui_3_17_2_1_1664888176327_72',1664888178),(166,'id_summary_editor',79,'5807563b25ddfb53ac6d50858281d841c94cad96',78,'',51133100,'yui_3_17_2_1_1664888228349_302',1664888232),(169,'id_description_editor',493,'c7f6d9941fedfc58dd0762147b55f01a9e79fcb3',76,'',649612427,'yui_3_17_2_1_1664985482261_72',1664985483),(170,'id_summary_editor',494,'ae65c9868a550ea920975f50afe4864cb751187d',76,'',761895459,'yui_3_17_2_1_1664985440608_290',1664985442),(176,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',80,'',921899326,'yui_3_17_2_1_1665056176631_72',1665056177),(177,'id_description_editor',5,'4622cc4c5bb73452a7edacad35bd3febcf507167',2,'',838078369,'yui_3_17_2_1_1665057839382_115',1665057840),(179,'id_description_editor',293,'0f528b45f717bda71ffb07cb3e66c7b2a65c226e',81,'',639087279,'yui_3_17_2_1_1665117777939_75',1665117784),(180,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',81,'',691438601,'yui_3_17_2_1_1665132859433_74',1665132860),(188,'id_description_editor',293,'0f528b45f717bda71ffb07cb3e66c7b2a65c226e',2,'',312696896,'yui_3_17_2_1_1665383800542_71',1665383801),(191,'id_summary_editor',293,'649e523870c5a68db2aaad11726dfac7d8beea7a',2,'',880455999,'yui_3_17_2_1_1665388135034_287',1665388137),(201,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',97,'',521695555,'yui_3_17_2_1_1665394099733_75',1665394101),(208,'id_summary_editor',569,'0d753059c6ddc1dfe5e9dc822ddf5f23171a463d',2,'',240716669,'yui_3_17_2_1_1665395302187_290',1665395304),(211,'id_description_editor',592,'007ae9eec0eb1ee8a8a18235fa8d090a00045f37',98,'',490842052,'yui_3_17_2_1_1665397056419_115',1665397059),(223,'id_summary_editor',98,'4b6673446123a2b217523a462d122a0295efdefc',2,'',784968770,'yui_3_17_2_1_1665398915195_291',1665398918),(226,'id_s__auth_instructions',1,'21e44ae2a9261d31bf778c60ec33c47fb3d7a655',2,'',-1,'yui_3_17_2_1_1665577988914_47',1665577984),(257,'id_introeditor',626,'2c152aad1f9c2148a94c75456d183a114e033a0f',2,'',16306879,'yui_3_17_2_1_1665827127819_184',1665827132),(259,'id_summary_editor',602,'c7c1820488c6dc651d674861e649848fac876f3e',2,'',77294620,'yui_3_17_2_1_1665830090022_103',1665830092),(261,'id_summary_editor',304,'c522fb9b629d602c3940770747a18ffbeec1f928',2,'',30105579,'yui_3_17_2_1_1665987111224_290',1665987112),(273,'id_summary_editor',89,'fc32e70e7651f0ae3f02c3bd6517c58aa3fcacf1',2,'',649918645,'yui_3_17_2_1_1665999147586_285',1665999150),(278,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',134,'',577681452,'yui_3_17_2_1_1666007876622_75',1666007878),(285,'id_s_theme_fordson_fptextbox',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_270',1666064129),(286,'id_s_theme_fordson_fptextboxlogout',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_558',1666064129),(287,'id_s_theme_fordson_alertbox',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_836',1666064129),(288,'id_s_theme_fordson_coursemanagementtextbox',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_1114',1666064129),(289,'id_s_theme_fordson_studentdashboardtextbox',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_1392',1666064129),(290,'id_s_theme_fordson_slidetextbox',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_1670',1666064129),(291,'id_s_theme_fordson_slide1content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_1948',1666064129),(292,'id_s_theme_fordson_slide2content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_2226',1666064129),(293,'id_s_theme_fordson_slide3content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_2504',1666064129),(294,'id_s_theme_fordson_marketing1content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_2782',1666064129),(295,'id_s_theme_fordson_marketing2content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_3060',1666064129),(296,'id_s_theme_fordson_marketing3content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_3338',1666064129),(297,'id_s_theme_fordson_marketing4content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_3616',1666064129),(298,'id_s_theme_fordson_marketing5content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_3894',1666064129),(299,'id_s_theme_fordson_marketing6content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_4172',1666064129),(300,'id_s_theme_fordson_marketing7content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_4450',1666064129),(301,'id_s_theme_fordson_marketing8content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_4728',1666064129),(302,'id_s_theme_fordson_marketing9content',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_5006',1666064129),(303,'id_s_theme_fordson_footnote',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_5284',1666064129),(304,'id_s_theme_fordson_loginnav1icontext',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_5575',1666064129),(305,'id_s_theme_fordson_loginnav2icontext',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_5853',1666064129),(306,'id_s_theme_fordson_loginnav3icontext',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_6131',1666064129),(307,'id_s_theme_fordson_loginnav4icontext',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_6409',1666064129),(308,'id_s_theme_fordson_feature1text',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_6687',1666064129),(309,'id_s_theme_fordson_feature2text',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_6965',1666064129),(310,'id_s_theme_fordson_feature3text',1,'ed8b07f71322bbece37dd1e9794d41738ad35b36',2,'',-1,'yui_3_17_2_1_1666064121596_7243',1666064129),(337,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',153,'',658668726,'yui_3_17_2_1_1666091773635_75',1666091774),(340,'id_introeditor',883,'cce22766adc60e77760ed36ce51a5ab6c0a7e286',2,'',180967586,'yui_3_17_2_1_1666156279190_149',1666156282),(341,'id_description',1,'fca8ea69c9c66f49beaa727daeba8a4cc9db3eea',2,'',-1,'yui_3_17_2_1_1666178461221_72',1666178463),(354,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',158,'',431592094,'yui_3_17_2_1_1666248210466_74',1666248205),(357,'id_introeditor',82,'6c47833b286c546c6b57c3f607135cd9d8144124',135,'',563130480,'yui_3_17_2_1_1666266327179_148',1666266323),(358,'id_description_editor',1,'d43348e5820760af9ea5e056b3f59df070bb8bcf',173,'',59094013,'yui_3_17_2_1_1666272895244_71',1666272901);
/*!40000 ALTER TABLE `mdl_editor_atto_autosave` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol`
--

DROP TABLE IF EXISTS `mdl_enrol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT '0',
  `enrolstartdate` bigint(10) DEFAULT '0',
  `enrolenddate` bigint(10) DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint(10) DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `roleid` bigint(10) DEFAULT '0',
  `customint1` bigint(10) DEFAULT NULL,
  `customint2` bigint(10) DEFAULT NULL,
  `customint3` bigint(10) DEFAULT NULL,
  `customint4` bigint(10) DEFAULT NULL,
  `customint5` bigint(10) DEFAULT NULL,
  `customint6` bigint(10) DEFAULT NULL,
  `customint7` bigint(10) DEFAULT NULL,
  `customint8` bigint(10) DEFAULT NULL,
  `customchar1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customchar2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customchar3` varchar(1333) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext COLLATE utf8mb4_unicode_ci,
  `customtext2` longtext COLLATE utf8mb4_unicode_ci,
  `customtext3` longtext COLLATE utf8mb4_unicode_ci,
  `customtext4` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enro_enr_ix` (`enrol`),
  KEY `mdl_enro_cou_ix` (`courseid`)
) ENGINE=InnoDB AUTO_INCREMENT=478 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Instances of enrolment plugins used in courses, fields marke';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol`
--

LOCK TABLES `mdl_enrol` WRITE;
/*!40000 ALTER TABLE `mdl_enrol` DISABLE KEYS */;
INSERT INTO `mdl_enrol` VALUES (1,'manual',0,2,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313160,1663313160),(2,'guest',1,2,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313160,1663313160),(3,'self',1,2,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313160,1663313160),(4,'manual',0,3,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313175,1663313175),(5,'guest',1,3,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313175,1663313175),(6,'self',1,3,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313175,1663313175),(7,'manual',0,4,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313192,1663313192),(8,'guest',1,4,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313192,1663313192),(9,'self',1,4,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313192,1663313192),(10,'manual',0,5,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313597,1663313597),(11,'guest',1,5,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313597,1663313597),(12,'self',1,5,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313597,1663313597),(13,'manual',0,6,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313615,1663313615),(14,'guest',1,6,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313615,1663313615),(15,'self',1,6,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313615,1663313615),(16,'manual',0,7,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313643,1663313643),(17,'guest',1,7,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313643,1663313643),(18,'self',1,7,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663313643,1663313643),(25,'manual',0,10,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663333541,1663333541),(26,'guest',1,10,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663333541,1663333541),(27,'self',1,10,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663333541,1663333541),(28,'manual',0,11,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663336491,1663336491),(29,'guest',1,11,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663336491,1663336491),(30,'self',1,11,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663336491,1663336491),(31,'manual',0,12,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663337245,1663337245),(32,'guest',1,12,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663337245,1663337245),(33,'self',1,12,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663337245,1663337245),(37,'manual',0,14,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663338525,1663338525),(38,'guest',1,14,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663338525,1663338525),(39,'self',1,14,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663338525,1663338525),(43,'manual',0,16,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663427048,1663427048),(44,'guest',1,16,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663427048,1663427048),(45,'self',1,16,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663427048,1663427048),(46,'manual',0,17,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663519142,1663519142),(47,'guest',1,17,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663519142,1663519142),(48,'self',1,17,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663519142,1663519142),(49,'manual',0,18,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663666153,1663666153),(50,'guest',1,18,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663666153,1663666153),(51,'self',1,18,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1663666153,1663666153),(61,'manual',0,22,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1664734735,1664734735),(62,'guest',1,22,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1664734735,1664734735),(63,'self',1,22,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1664734735,1664734735),(67,'manual',0,24,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665246824,1665246824),(68,'guest',1,24,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665246824,1665246824),(69,'self',1,24,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665246824,1665246824),(79,'manual',0,29,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665393318,1665393318),(80,'guest',1,29,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665393318,1665393318),(81,'self',1,29,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665393318,1665393318),(88,'manual',0,48,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665987277,1665987277),(89,'guest',1,48,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665987277,1665987277),(90,'self',1,48,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665987277,1665987277),(91,'manual',0,49,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665988040,1665988040),(92,'guest',1,49,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665988040,1665988040),(93,'self',1,49,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665988040,1665988040),(94,'manual',0,50,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665988072,1665988072),(95,'guest',1,50,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665988072,1665988072),(96,'self',1,50,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665988072,1665988072),(97,'manual',0,54,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665989236,1665989236),(98,'guest',1,54,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665989236,1665989236),(99,'self',1,54,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665989236,1665989236),(100,'manual',0,56,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665989545,1665989545),(101,'guest',1,56,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665989545,1665989545),(102,'self',1,56,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665989545,1665989545),(103,'manual',0,57,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665996674,1665996674),(104,'guest',1,57,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665996674,1665996674),(105,'self',1,57,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665996674,1665996674),(106,'manual',0,58,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665996712,1665996712),(107,'guest',1,58,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665996712,1665996712),(108,'self',1,58,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665996712,1665996712),(109,'manual',0,59,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665997648,1665997648),(110,'guest',1,59,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665997648,1665997648),(111,'self',1,59,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665997648,1665997648),(112,'manual',0,60,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665999621,1665999621),(113,'guest',1,60,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665999621,1665999621),(114,'self',1,60,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665999621,1665999621),(115,'manual',0,61,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665999912,1665999912),(116,'guest',1,61,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665999912,1665999912),(117,'self',1,61,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1665999912,1665999912),(118,'manual',0,62,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000315,1666000315),(119,'guest',1,62,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000315,1666000315),(120,'self',1,62,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000315,1666000315),(121,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(122,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(123,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(124,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(125,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(126,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(127,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(128,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(129,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(130,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(131,'manual',0,64,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(132,'guest',1,64,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(133,'self',1,64,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666000591,1666000591),(134,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(135,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(136,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(137,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(138,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(139,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(140,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(141,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(142,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(143,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(144,'manual',0,65,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(145,'guest',1,65,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(146,'self',1,65,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666001199,1666001199),(147,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(148,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(149,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(150,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(151,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(152,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(153,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(154,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(155,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(156,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(157,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(158,'manual',0,66,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(159,'guest',1,66,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(160,'self',1,66,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010345,1666010345),(161,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(162,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(163,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(164,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(165,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(166,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(167,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(168,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(169,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(170,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(171,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(172,'manual',0,67,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010479,1666010479),(173,'guest',1,67,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010480,1666010480),(174,'self',1,67,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010480,1666010480),(175,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(176,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(177,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(178,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(179,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(180,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(181,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(182,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(183,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(184,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(185,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(186,'manual',0,68,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(187,'guest',1,68,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(188,'self',1,68,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666010590,1666010590),(189,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(190,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(191,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(192,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(193,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(194,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(195,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(196,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(197,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(198,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(199,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(200,'manual',0,69,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(201,'guest',1,69,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(202,'self',1,69,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666011949,1666011949),(203,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(204,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(205,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(206,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(207,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(208,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(209,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(210,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(211,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(212,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(213,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(214,'manual',0,70,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(215,'guest',1,70,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(216,'self',1,70,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666012450,1666012450),(217,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(218,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(219,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(220,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(221,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(222,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(223,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(224,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(225,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(226,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(227,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(228,'manual',0,71,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(229,'guest',1,71,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(230,'self',1,71,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666013158,1666013158),(231,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(232,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(233,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(234,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(235,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(236,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(237,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(238,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(239,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(240,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(241,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(242,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(243,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(244,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(245,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(246,'manual',0,72,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(247,'guest',1,72,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(248,'self',1,72,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067361,1666067361),(249,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(250,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(251,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(252,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(253,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(254,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(255,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(256,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(257,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(258,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(259,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(260,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(261,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(262,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(263,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(264,'manual',0,73,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(265,'guest',1,73,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(266,'self',1,73,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666067895,1666067895),(267,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(268,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(269,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(270,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(271,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(272,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(273,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(274,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(275,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(276,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(277,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(278,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(279,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(280,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(281,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(282,'manual',0,74,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(283,'guest',1,74,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(284,'self',1,74,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666068000,1666068000),(285,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(286,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(287,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(288,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(289,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(290,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(291,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(292,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(293,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(294,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(295,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(296,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(297,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079282,1666079282),(298,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(299,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(300,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(301,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(302,'manual',0,75,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(303,'guest',1,75,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(304,'self',1,75,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079283,1666079283),(305,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(306,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(307,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(308,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(309,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(310,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(311,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(312,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(313,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(314,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(315,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(316,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(317,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(318,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(319,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(320,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(321,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(322,'manual',0,76,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(323,'guest',1,76,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(324,'self',1,76,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079436,1666079436),(325,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(326,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(327,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(328,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(329,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(330,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(331,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(332,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(333,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(334,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(335,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(336,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(337,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(338,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(339,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(340,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(341,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(342,'manual',0,77,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(343,'guest',1,77,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(344,'self',1,77,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666079937,1666079937),(345,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086649,1666086649),(346,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086649,1666086649),(347,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086649,1666086649),(348,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086649,1666086649),(349,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(350,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(351,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(352,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(353,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(354,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(355,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(356,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(357,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(358,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(359,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(360,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(361,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(362,'manual',0,78,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(363,'guest',1,78,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(364,'self',1,78,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666086650,1666086650),(365,'manual',0,79,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666087243,1666087243),(366,'guest',1,79,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666087243,1666087243),(367,'self',1,79,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666087243,1666087243),(368,'manual',0,80,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666088385,1666088385),(369,'guest',1,80,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666088385,1666088385),(370,'self',1,80,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666088385,1666088385),(371,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241669,1666241669),(372,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241669,1666241669),(373,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(374,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(375,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(376,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(377,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(378,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(379,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(380,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(381,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(382,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(383,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(384,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(385,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(386,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(387,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(388,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(389,'manual',0,81,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(390,'guest',1,81,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(391,'self',1,81,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666241670,1666241670),(392,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(393,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(394,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(395,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(396,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(397,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(398,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(399,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(400,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(401,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(402,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(403,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(404,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(405,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(406,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(407,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(408,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(409,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(410,'manual',0,82,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245645,1666245645),(411,'guest',1,82,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245646,1666245646),(412,'self',1,82,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666245646,1666245646),(413,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(414,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(415,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(416,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(417,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(418,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(419,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(420,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(421,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(422,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(423,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(424,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(425,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(426,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(427,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(428,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(429,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(430,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(431,'manual',0,83,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(432,'guest',1,83,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(433,'self',1,83,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666247569,1666247569),(434,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(435,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(436,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(437,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(438,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(439,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(440,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(441,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(442,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(443,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(444,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(445,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(446,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(447,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(448,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(449,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(450,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(451,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(452,'manual',0,84,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266069,1666266069),(453,'guest',1,84,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266070,1666266070),(454,'self',1,84,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666266070,1666266070),(455,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(456,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(457,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(458,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(459,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(460,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(461,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(462,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(463,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(464,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286520,1666286520),(465,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(466,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(467,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(468,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(469,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(470,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(471,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(472,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(473,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(474,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(475,'manual',0,85,0,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(476,'guest',1,85,1,NULL,0,0,0,0,0,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521),(477,'self',1,85,2,NULL,0,0,0,0,86400,0,NULL,NULL,NULL,5,0,0,0,1,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1666286521,1666286521);
/*!40000 ALTER TABLE `mdl_enrol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_flatfile`
--

DROP TABLE IF EXISTS `mdl_enrol_flatfile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_flatfile` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enroflat_cou_ix` (`courseid`),
  KEY `mdl_enroflat_use_ix` (`userid`),
  KEY `mdl_enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='enrol_flatfile table retrofitted from MySQL';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_flatfile`
--

LOCK TABLES `mdl_enrol_flatfile` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_flatfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_flatfile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_consumer`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_consumer` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `consumerkey256` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `consumerkey` longtext COLLATE utf8mb4_unicode_ci,
  `secret` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ltiversion` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumername` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumerversion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `consumerguid` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile` longtext COLLATE utf8mb4_unicode_ci,
  `toolproxy` longtext COLLATE utf8mb4_unicode_ci,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `protected` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `enablefrom` bigint(10) DEFAULT NULL,
  `enableuntil` bigint(10) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_enroltilti2cons_con_uix` (`consumerkey256`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='LTI consumers interacting with moodle';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_consumer`
--

LOCK TABLES `mdl_enrol_lti_lti2_consumer` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_context`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_context` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `lticontextkey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2cont_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Information about a specific LTI contexts from the consumers';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_context`
--

LOCK TABLES `mdl_enrol_lti_lti2_context` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_context` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_context` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_nonce`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_nonce`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_nonce` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `value` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2nonc_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Nonce used for authentication between moodle and a consumer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_nonce`
--

LOCK TABLES `mdl_enrol_lti_lti2_nonce` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_nonce` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_nonce` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_resource_link`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_resource_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_resource_link` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(11) DEFAULT NULL,
  `consumerid` bigint(11) DEFAULT NULL,
  `ltiresourcelinkkey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `primaryresourcelinkid` bigint(11) DEFAULT NULL,
  `shareapproved` tinyint(1) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2resolink_con_ix` (`contextid`),
  KEY `mdl_enroltilti2resolink_pri_ix` (`primaryresourcelinkid`),
  KEY `mdl_enroltilti2resolink_co2_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Link from the consumer to the tool';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_resource_link`
--

LOCK TABLES `mdl_enrol_lti_lti2_resource_link` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_resource_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_resource_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_share_key`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_share_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_share_key` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sharekey` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `resourcelinkid` bigint(11) NOT NULL,
  `autoapprove` tinyint(1) NOT NULL,
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_enroltilti2sharkey_sha_uix` (`sharekey`),
  UNIQUE KEY `mdl_enroltilti2sharkey_res_uix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Resource link share key';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_share_key`
--

LOCK TABLES `mdl_enrol_lti_lti2_share_key` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_share_key` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_share_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_tool_proxy`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_tool_proxy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_tool_proxy` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `toolproxykey` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `consumerid` bigint(11) NOT NULL,
  `toolproxy` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_enroltilti2toolprox_to_uix` (`toolproxykey`),
  KEY `mdl_enroltilti2toolprox_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='A tool proxy between moodle and a consumer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_tool_proxy`
--

LOCK TABLES `mdl_enrol_lti_lti2_tool_proxy` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_tool_proxy` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_tool_proxy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_lti2_user_result`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_lti2_user_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_lti2_user_result` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `resourcelinkid` bigint(11) NOT NULL,
  `ltiuserkey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ltiresultsourcedid` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltilti2userresu_res_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Results for each user for each resource link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_lti2_user_result`
--

LOCK TABLES `mdl_enrol_lti_lti2_user_result` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_user_result` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_lti2_user_result` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_tool_consumer_map`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_tool_consumer_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_tool_consumer_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `toolid` bigint(11) NOT NULL,
  `consumerid` bigint(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltitoolconsmap_too_ix` (`toolid`),
  KEY `mdl_enroltitoolconsmap_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Table that maps the published tool to tool consumers.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_tool_consumer_map`
--

LOCK TABLES `mdl_enrol_lti_tool_consumer_map` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_tool_consumer_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_tool_consumer_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_tools`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_tools`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_tools` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrolid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `institution` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `timezone` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '99',
  `maxenrolled` bigint(10) NOT NULL DEFAULT '0',
  `maildisplay` tinyint(2) NOT NULL DEFAULT '2',
  `city` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `gradesync` tinyint(1) NOT NULL DEFAULT '0',
  `gradesynccompletion` tinyint(1) NOT NULL DEFAULT '0',
  `membersync` tinyint(1) NOT NULL DEFAULT '0',
  `membersyncmode` tinyint(1) NOT NULL DEFAULT '0',
  `roleinstructor` bigint(10) NOT NULL,
  `rolelearner` bigint(10) NOT NULL,
  `secret` longtext COLLATE utf8mb4_unicode_ci,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltitool_enr_ix` (`enrolid`),
  KEY `mdl_enroltitool_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='List of tools provided to the remote system';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_tools`
--

LOCK TABLES `mdl_enrol_lti_tools` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_tools` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_tools` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_lti_users`
--

DROP TABLE IF EXISTS `mdl_enrol_lti_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_lti_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `toolid` bigint(10) NOT NULL,
  `serviceurl` longtext COLLATE utf8mb4_unicode_ci,
  `sourceid` longtext COLLATE utf8mb4_unicode_ci,
  `consumerkey` longtext COLLATE utf8mb4_unicode_ci,
  `consumersecret` longtext COLLATE utf8mb4_unicode_ci,
  `membershipsurl` longtext COLLATE utf8mb4_unicode_ci,
  `membershipsid` longtext COLLATE utf8mb4_unicode_ci,
  `lastgrade` decimal(10,5) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_enroltiuser_use_ix` (`userid`),
  KEY `mdl_enroltiuser_too_ix` (`toolid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='User access log and gradeback data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_lti_users`
--

LOCK TABLES `mdl_enrol_lti_users` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_lti_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_lti_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_enrol_paypal`
--

DROP TABLE IF EXISTS `mdl_enrol_paypal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_enrol_paypal` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `business` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `receiver_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `receiver_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `memo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_name1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_name2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pending_reason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reason_code` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `payment_type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timeupdated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_enropayp_bus_ix` (`business`),
  KEY `mdl_enropayp_rec_ix` (`receiver_email`),
  KEY `mdl_enropayp_cou_ix` (`courseid`),
  KEY `mdl_enropayp_use_ix` (`userid`),
  KEY `mdl_enropayp_ins_ix` (`instanceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Holds all known information about PayPal transactions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_enrol_paypal`
--

LOCK TABLES `mdl_enrol_paypal` WRITE;
/*!40000 ALTER TABLE `mdl_enrol_paypal` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_enrol_paypal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_event`
--

DROP TABLE IF EXISTS `mdl_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_event` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `repeatid` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modulename` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `type` smallint(4) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeduration` bigint(10) NOT NULL DEFAULT '0',
  `timesort` bigint(10) DEFAULT NULL,
  `visible` smallint(4) NOT NULL DEFAULT '1',
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sequence` bigint(10) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `subscriptionid` bigint(10) DEFAULT NULL,
  `priority` bigint(10) DEFAULT NULL,
  `location` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_even_cou_ix` (`courseid`),
  KEY `mdl_even_use_ix` (`userid`),
  KEY `mdl_even_tim_ix` (`timestart`),
  KEY `mdl_even_tim2_ix` (`timeduration`),
  KEY `mdl_even_uui_ix` (`uuid`),
  KEY `mdl_even_typtim_ix` (`type`,`timesort`),
  KEY `mdl_even_grocoucatvisuse_ix` (`groupid`,`courseid`,`categoryid`,`visible`,`userid`),
  KEY `mdl_even_eve_ix` (`eventtype`),
  KEY `mdl_even_comeveins_ix` (`component`,`eventtype`,`instance`),
  KEY `mdl_even_modinseve_ix` (`modulename`,`instance`,`eventtype`),
  KEY `mdl_even_cat_ix` (`categoryid`),
  KEY `mdl_even_sub_ix` (`subscriptionid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For everything with a time associated to it';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_event`
--

LOCK TABLES `mdl_event` WRITE;
/*!40000 ALTER TABLE `mdl_event` DISABLE KEYS */;
INSERT INTO `mdl_event` VALUES (1,'demo assignment is due','',1,0,73,0,2,0,NULL,'assign',1,1,'due',1666652400,0,1666652400,1,'',1,1666076168,NULL,NULL,NULL),(2,'demo assignment is due to be graded','',1,0,73,0,2,0,NULL,'assign',1,1,'gradingdue',1667257200,0,1667257200,1,'',1,1666076168,NULL,NULL,NULL),(3,'a1 is due','',1,0,2,0,2,0,NULL,'assign',2,1,'due',1666652400,0,1666652400,1,'',1,1666076622,NULL,NULL,NULL),(4,'a1 is due to be graded','',1,0,2,0,2,0,NULL,'assign',2,1,'gradingdue',1667257200,0,1667257200,1,'',1,1666076622,NULL,NULL,NULL),(5,'a1 (copy) is due','',1,0,2,0,2,0,NULL,'assign',3,1,'due',1666652400,0,1666652400,1,'',1,1666156208,NULL,NULL,NULL),(6,'a1 (copy) is due to be graded','',1,0,2,0,2,0,NULL,'assign',3,1,'gradingdue',1667257200,0,1667257200,1,'',1,1666156208,NULL,NULL,NULL);
/*!40000 ALTER TABLE `mdl_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_event_subscriptions`
--

DROP TABLE IF EXISTS `mdl_event_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_event_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pollinterval` bigint(10) NOT NULL DEFAULT '0',
  `lastupdated` bigint(10) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks subscriptions to remote calendars.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_event_subscriptions`
--

LOCK TABLES `mdl_event_subscriptions` WRITE;
/*!40000 ALTER TABLE `mdl_event_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_event_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_handlers`
--

DROP TABLE IF EXISTS `mdl_events_handlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `component` varchar(166) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `handlerfile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `handlerfunction` longtext COLLATE utf8mb4_unicode_ci,
  `schedule` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `internal` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table is for storing which components requests what typ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_handlers`
--

LOCK TABLES `mdl_events_handlers` WRITE;
/*!40000 ALTER TABLE `mdl_events_handlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_handlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_queue`
--

DROP TABLE IF EXISTS `mdl_events_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventdata` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `stackdump` longtext COLLATE utf8mb4_unicode_ci,
  `userid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table is for storing queued events. It stores only one ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_queue`
--

LOCK TABLES `mdl_events_queue` WRITE;
/*!40000 ALTER TABLE `mdl_events_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_events_queue_handlers`
--

DROP TABLE IF EXISTS `mdl_events_queue_handlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_events_queue_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint(10) NOT NULL,
  `handlerid` bigint(10) NOT NULL,
  `status` bigint(10) DEFAULT NULL,
  `errormessage` longtext COLLATE utf8mb4_unicode_ci,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_evenqueuhand_que_ix` (`queuedeventid`),
  KEY `mdl_evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This is the list of queued handlers for processing. The even';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_events_queue_handlers`
--

LOCK TABLES `mdl_events_queue_handlers` WRITE;
/*!40000 ALTER TABLE `mdl_events_queue_handlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_events_queue_handlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_functions`
--

DROP TABLE IF EXISTS `mdl_external_functions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `classname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `methodname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `classpath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `capabilities` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `services` varchar(1333) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_extefunc_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=618 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='list of all external functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_functions`
--

LOCK TABLES `mdl_external_functions` WRITE;
/*!40000 ALTER TABLE `mdl_external_functions` DISABLE KEYS */;
INSERT INTO `mdl_external_functions` VALUES (1,'core_auth_confirm_user','core_auth_external','confirm_user',NULL,'moodle','',NULL),(2,'core_auth_request_password_reset','core_auth_external','request_password_reset',NULL,'moodle','',NULL),(3,'core_auth_is_minor','core_auth_external','is_minor',NULL,'moodle','',NULL),(4,'core_auth_is_age_digital_consent_verification_enabled','core_auth_external','is_age_digital_consent_verification_enabled',NULL,'moodle','',NULL),(5,'core_auth_resend_confirmation_email','core_auth_external','resend_confirmation_email',NULL,'moodle','',NULL),(6,'core_backup_get_async_backup_progress','core_backup_external','get_async_backup_progress','backup/externallib.php','moodle','',NULL),(7,'core_backup_get_async_backup_links_backup','core_backup_external','get_async_backup_links_backup','backup/externallib.php','moodle','',NULL),(8,'core_backup_get_async_backup_links_restore','core_backup_external','get_async_backup_links_restore','backup/externallib.php','moodle','',NULL),(9,'core_backup_get_copy_progress','core_backup_external','get_copy_progress','backup/externallib.php','moodle','',NULL),(10,'core_backup_submit_copy_form','core_backup_external','submit_copy_form','backup/externallib.php','moodle','',NULL),(11,'core_badges_get_user_badges','core_badges_external','get_user_badges',NULL,'moodle','moodle/badges:viewotherbadges','moodle_mobile_app'),(12,'core_blog_get_entries','core_blog\\external','get_entries',NULL,'moodle','','moodle_mobile_app'),(13,'core_blog_view_entries','core_blog\\external','view_entries',NULL,'moodle','','moodle_mobile_app'),(14,'core_calendar_get_calendar_monthly_view','core_calendar_external','get_calendar_monthly_view','calendar/externallib.php','moodle','','moodle_mobile_app'),(15,'core_calendar_get_calendar_day_view','core_calendar_external','get_calendar_day_view','calendar/externallib.php','moodle','','moodle_mobile_app'),(16,'core_calendar_get_calendar_upcoming_view','core_calendar_external','get_calendar_upcoming_view','calendar/externallib.php','moodle','','moodle_mobile_app'),(17,'core_calendar_update_event_start_day','core_calendar_external','update_event_start_day','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(18,'core_calendar_create_calendar_events','core_calendar_external','create_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(19,'core_calendar_delete_calendar_events','core_calendar_external','delete_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(20,'core_calendar_get_calendar_events','core_calendar_external','get_calendar_events','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(21,'core_calendar_get_action_events_by_timesort','core_calendar_external','get_calendar_action_events_by_timesort','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(22,'core_calendar_get_action_events_by_course','core_calendar_external','get_calendar_action_events_by_course','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(23,'core_calendar_get_action_events_by_courses','core_calendar_external','get_calendar_action_events_by_courses','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(24,'core_calendar_get_calendar_event_by_id','core_calendar_external','get_calendar_event_by_id','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(25,'core_calendar_submit_create_update_form','core_calendar_external','submit_create_update_form','calendar/externallib.php','moodle','moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries','moodle_mobile_app'),(26,'core_calendar_get_calendar_access_information','core_calendar_external','get_calendar_access_information','calendar/externallib.php','moodle','','moodle_mobile_app'),(27,'core_calendar_get_allowed_event_types','core_calendar_external','get_allowed_event_types','calendar/externallib.php','moodle','','moodle_mobile_app'),(28,'core_calendar_get_timestamps','core_calendar_external','get_timestamps','calendar/externallib.php','moodle','',NULL),(29,'core_calendar_get_calendar_export_token','core_calendar\\external\\export\\token','execute',NULL,'moodle','','moodle_mobile_app'),(30,'core_cohort_add_cohort_members','core_cohort_external','add_cohort_members','cohort/externallib.php','moodle','moodle/cohort:assign',NULL),(31,'core_cohort_create_cohorts','core_cohort_external','create_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage',NULL),(32,'core_cohort_delete_cohort_members','core_cohort_external','delete_cohort_members','cohort/externallib.php','moodle','moodle/cohort:assign',NULL),(33,'core_cohort_delete_cohorts','core_cohort_external','delete_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage',NULL),(34,'core_cohort_get_cohort_members','core_cohort_external','get_cohort_members','cohort/externallib.php','moodle','moodle/cohort:view',NULL),(35,'core_cohort_search_cohorts','core_cohort_external','search_cohorts','cohort/externallib.php','moodle','moodle/cohort:view',NULL),(36,'core_cohort_get_cohorts','core_cohort_external','get_cohorts','cohort/externallib.php','moodle','moodle/cohort:view',NULL),(37,'core_cohort_update_cohorts','core_cohort_external','update_cohorts','cohort/externallib.php','moodle','moodle/cohort:manage',NULL),(38,'core_comment_get_comments','core_comment_external','get_comments',NULL,'moodle','moodle/comment:view','moodle_mobile_app'),(39,'core_comment_add_comments','core_comment_external','add_comments',NULL,'moodle','','moodle_mobile_app'),(40,'core_comment_delete_comments','core_comment_external','delete_comments',NULL,'moodle','','moodle_mobile_app'),(41,'core_completion_get_activities_completion_status','core_completion_external','get_activities_completion_status',NULL,'moodle','','moodle_mobile_app'),(42,'core_completion_get_course_completion_status','core_completion_external','get_course_completion_status',NULL,'moodle','report/completion:view','moodle_mobile_app'),(43,'core_completion_mark_course_self_completed','core_completion_external','mark_course_self_completed',NULL,'moodle','','moodle_mobile_app'),(44,'core_completion_update_activity_completion_status_manually','core_completion_external','update_activity_completion_status_manually',NULL,'moodle','','moodle_mobile_app'),(45,'core_completion_override_activity_completion_status','core_completion_external','override_activity_completion_status',NULL,'moodle','moodle/course:overridecompletion',NULL),(46,'core_course_create_categories','core_course_external','create_categories','course/externallib.php','moodle','moodle/category:manage',NULL),(47,'core_course_create_courses','core_course_external','create_courses','course/externallib.php','moodle','moodle/course:create, moodle/course:visibility',NULL),(48,'core_course_delete_categories','core_course_external','delete_categories','course/externallib.php','moodle','moodle/category:manage',NULL),(49,'core_course_delete_courses','core_course_external','delete_courses','course/externallib.php','moodle','moodle/course:delete',NULL),(50,'core_course_delete_modules','core_course_external','delete_modules','course/externallib.php','moodle','moodle/course:manageactivities',NULL),(51,'core_course_duplicate_course','core_course_external','duplicate_course','course/externallib.php','moodle','moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create',NULL),(52,'core_course_get_categories','core_course_external','get_categories','course/externallib.php','moodle','moodle/category:viewhiddencategories','moodle_mobile_app'),(53,'core_course_get_contents','core_course_external','get_course_contents','course/externallib.php','moodle','moodle/course:update, moodle/course:viewhiddencourses','moodle_mobile_app'),(54,'core_course_get_course_module','core_course_external','get_course_module','course/externallib.php','moodle','','moodle_mobile_app'),(55,'core_course_get_course_module_by_instance','core_course_external','get_course_module_by_instance','course/externallib.php','moodle','','moodle_mobile_app'),(56,'core_course_get_module','core_course_external','get_module','course/externallib.php','moodle','',NULL),(57,'core_course_edit_module','core_course_external','edit_module','course/externallib.php','moodle','',NULL),(58,'core_course_edit_section','core_course_external','edit_section','course/externallib.php','moodle','',NULL),(59,'core_course_get_courses','core_course_external','get_courses','course/externallib.php','moodle','moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses','moodle_mobile_app'),(60,'core_course_import_course','core_course_external','import_course','course/externallib.php','moodle','moodle/backup:backuptargetimport, moodle/restore:restoretargetimport',NULL),(61,'core_course_search_courses','core_course_external','search_courses','course/externallib.php','moodle','','moodle_mobile_app'),(62,'core_course_update_categories','core_course_external','update_categories','course/externallib.php','moodle','moodle/category:manage',NULL),(63,'core_course_update_courses','core_course_external','update_courses','course/externallib.php','moodle','moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility',NULL),(64,'core_course_view_course','core_course_external','view_course','course/externallib.php','moodle','','moodle_mobile_app'),(65,'core_course_get_user_navigation_options','core_course_external','get_user_navigation_options','course/externallib.php','moodle','','moodle_mobile_app'),(66,'core_course_get_user_administration_options','core_course_external','get_user_administration_options','course/externallib.php','moodle','','moodle_mobile_app'),(67,'core_course_get_courses_by_field','core_course_external','get_courses_by_field','course/externallib.php','moodle','','moodle_mobile_app'),(68,'core_course_check_updates','core_course_external','check_updates','course/externallib.php','moodle','','moodle_mobile_app'),(69,'core_course_get_updates_since','core_course_external','get_updates_since','course/externallib.php','moodle','','moodle_mobile_app'),(70,'core_course_get_enrolled_courses_by_timeline_classification','core_course_external','get_enrolled_courses_by_timeline_classification','course/externallib.php','moodle','','moodle_mobile_app'),(71,'core_course_get_recent_courses','core_course_external','get_recent_courses','course/externallib.php','moodle','','moodle_mobile_app'),(72,'core_course_set_favourite_courses','core_course_external','set_favourite_courses','course/externallib.php','moodle','','moodle_mobile_app'),(73,'core_course_get_enrolled_users_by_cmid','core_course_external','get_enrolled_users_by_cmid','course/externallib.php','moodle','',NULL),(74,'core_course_add_content_item_to_user_favourites','core_course_external','add_content_item_to_user_favourites','course/externallib.php','moodle','',NULL),(75,'core_course_remove_content_item_from_user_favourites','core_course_external','remove_content_item_from_user_favourites','course/externallib.php','moodle','',NULL),(76,'core_course_get_course_content_items','core_course_external','get_course_content_items','course/externallib.php','moodle','',NULL),(77,'core_course_get_activity_chooser_footer','core_course_external','get_activity_chooser_footer','course/externallib.php','moodle','',NULL),(78,'core_course_toggle_activity_recommendation','core_course_external','toggle_activity_recommendation','course/externallib.php','moodle','',NULL),(79,'core_enrol_get_course_enrolment_methods','core_enrol_external','get_course_enrolment_methods','enrol/externallib.php','moodle','','moodle_mobile_app'),(80,'core_enrol_get_enrolled_users','core_enrol_external','get_enrolled_users','enrol/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups','moodle_mobile_app'),(81,'core_enrol_get_enrolled_users_with_capability','core_enrol_external','get_enrolled_users_with_capability','enrol/externallib.php','moodle','',NULL),(82,'core_enrol_get_potential_users','core_enrol_external','get_potential_users','enrol/externallib.php','moodle','moodle/course:enrolreview',NULL),(83,'core_enrol_search_users','core_enrol_external','search_users','enrol/externallib.php','moodle','moodle/course:viewparticipants','moodle_mobile_app'),(84,'core_enrol_get_users_courses','core_enrol_external','get_users_courses','enrol/externallib.php','moodle','moodle/course:viewparticipants','moodle_mobile_app'),(85,'core_enrol_edit_user_enrolment','core_enrol_external','edit_user_enrolment','enrol/externallib.php','moodle','',NULL),(86,'core_enrol_submit_user_enrolment_form','core_enrol_external','submit_user_enrolment_form','enrol/externallib.php','moodle','',NULL),(87,'core_enrol_unenrol_user_enrolment','core_enrol_external','unenrol_user_enrolment','enrol/externallib.php','moodle','',NULL),(88,'core_fetch_notifications','core_external','fetch_notifications','lib/external/externallib.php','moodle','',NULL),(89,'core_session_touch','core\\session\\external','touch_session',NULL,'moodle','',NULL),(90,'core_session_time_remaining','core\\session\\external','time_remaining',NULL,'moodle','',NULL),(91,'core_files_get_files','core_files_external','get_files','files/externallib.php','moodle','','moodle_mobile_app'),(92,'core_files_upload','core_files_external','upload','files/externallib.php','moodle','',NULL),(93,'core_files_delete_draft_files','core_files\\external\\delete\\draft','execute',NULL,'moodle','','moodle_mobile_app'),(94,'core_files_get_unused_draft_itemid','core_files\\external\\get\\unused_draft','execute',NULL,'moodle','','moodle_mobile_app'),(95,'core_form_get_filetypes_browser_data','core_form\\external','get_filetypes_browser_data',NULL,'moodle','',NULL),(96,'core_form_dynamic_form','core_form\\external\\dynamic_form','execute',NULL,'moodle','',NULL),(97,'core_get_component_strings','core_external','get_component_strings','lib/external/externallib.php','moodle','','moodle_mobile_app'),(98,'core_get_fragment','core_external','get_fragment','lib/external/externallib.php','moodle','',NULL),(99,'core_get_string','core_external','get_string','lib/external/externallib.php','moodle','',NULL),(100,'core_get_strings','core_external','get_strings','lib/external/externallib.php','moodle','',NULL),(101,'core_get_user_dates','core_external','get_user_dates','lib/external/externallib.php','moodle','',NULL),(102,'core_grades_get_grades','core_grades_external','get_grades',NULL,'moodle','moodle/grade:view, moodle/grade:viewall, moodle/grade:viewhidden',NULL),(103,'core_grades_update_grades','core_grades_external','update_grades',NULL,'moodle','',NULL),(104,'core_grades_grader_gradingpanel_point_fetch','core_grades\\grades\\grader\\gradingpanel\\point\\external\\fetch','execute',NULL,'moodle','','moodle_mobile_app'),(105,'core_grades_grader_gradingpanel_point_store','core_grades\\grades\\grader\\gradingpanel\\point\\external\\store','execute',NULL,'moodle','','moodle_mobile_app'),(106,'core_grades_grader_gradingpanel_scale_fetch','core_grades\\grades\\grader\\gradingpanel\\scale\\external\\fetch','execute',NULL,'moodle','','moodle_mobile_app'),(107,'core_grades_grader_gradingpanel_scale_store','core_grades\\grades\\grader\\gradingpanel\\scale\\external\\store','execute',NULL,'moodle','','moodle_mobile_app'),(108,'core_grades_create_gradecategory','core_grades_external','create_gradecategory',NULL,'moodle','moodle/grade:manage',NULL),(109,'core_grades_create_gradecategories','core_grades\\external\\create_gradecategories','execute',NULL,'moodle','moodle/grade:manage',NULL),(110,'core_grading_get_definitions','core_grading_external','get_definitions',NULL,'moodle','',NULL),(111,'core_grading_get_gradingform_instances','core_grading_external','get_gradingform_instances',NULL,'moodle','',NULL),(112,'core_grading_save_definitions','core_grading_external','save_definitions',NULL,'moodle','',NULL),(113,'core_group_add_group_members','core_group_external','add_group_members','group/externallib.php','moodle','moodle/course:managegroups',NULL),(114,'core_group_assign_grouping','core_group_external','assign_grouping','group/externallib.php','moodle','',NULL),(115,'core_group_create_groupings','core_group_external','create_groupings','group/externallib.php','moodle','',NULL),(116,'core_group_create_groups','core_group_external','create_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(117,'core_group_delete_group_members','core_group_external','delete_group_members','group/externallib.php','moodle','moodle/course:managegroups',NULL),(118,'core_group_delete_groupings','core_group_external','delete_groupings','group/externallib.php','moodle','',NULL),(119,'core_group_delete_groups','core_group_external','delete_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(120,'core_group_get_activity_allowed_groups','core_group_external','get_activity_allowed_groups','group/externallib.php','moodle','','moodle_mobile_app'),(121,'core_group_get_activity_groupmode','core_group_external','get_activity_groupmode','group/externallib.php','moodle','','moodle_mobile_app'),(122,'core_group_get_course_groupings','core_group_external','get_course_groupings','group/externallib.php','moodle','','moodle_mobile_app'),(123,'core_group_get_course_groups','core_group_external','get_course_groups','group/externallib.php','moodle','moodle/course:managegroups','moodle_mobile_app'),(124,'core_group_get_course_user_groups','core_group_external','get_course_user_groups','group/externallib.php','moodle','moodle/course:managegroups','moodle_mobile_app'),(125,'core_group_get_group_members','core_group_external','get_group_members','group/externallib.php','moodle','moodle/course:managegroups',NULL),(126,'core_group_get_groupings','core_group_external','get_groupings','group/externallib.php','moodle','',NULL),(127,'core_group_get_groups','core_group_external','get_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(128,'core_group_unassign_grouping','core_group_external','unassign_grouping','group/externallib.php','moodle','',NULL),(129,'core_group_update_groupings','core_group_external','update_groupings','group/externallib.php','moodle','',NULL),(130,'core_group_update_groups','core_group_external','update_groups','group/externallib.php','moodle','moodle/course:managegroups',NULL),(131,'core_message_mute_conversations','core_message_external','mute_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(132,'core_message_unmute_conversations','core_message_external','unmute_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(133,'core_message_block_user','core_message_external','block_user','message/externallib.php','moodle','','moodle_mobile_app'),(134,'core_message_get_contact_requests','core_message_external','get_contact_requests','message/externallib.php','moodle','','moodle_mobile_app'),(135,'core_message_create_contact_request','core_message_external','create_contact_request','message/externallib.php','moodle','','moodle_mobile_app'),(136,'core_message_confirm_contact_request','core_message_external','confirm_contact_request','message/externallib.php','moodle','','moodle_mobile_app'),(137,'core_message_decline_contact_request','core_message_external','decline_contact_request','message/externallib.php','moodle','','moodle_mobile_app'),(138,'core_message_get_received_contact_requests_count','core_message_external','get_received_contact_requests_count','message/externallib.php','moodle','','moodle_mobile_app'),(139,'core_message_delete_contacts','core_message_external','delete_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(140,'core_message_delete_conversations_by_id','core_message_external','delete_conversations_by_id','message/externallib.php','moodle','moodle/site:deleteownmessage','moodle_mobile_app'),(141,'core_message_delete_message','core_message_external','delete_message','message/externallib.php','moodle','moodle/site:deleteownmessage','moodle_mobile_app'),(142,'core_message_get_blocked_users','core_message_external','get_blocked_users','message/externallib.php','moodle','','moodle_mobile_app'),(143,'core_message_data_for_messagearea_search_messages','core_message_external','data_for_messagearea_search_messages','message/externallib.php','moodle','','moodle_mobile_app'),(144,'core_message_message_search_users','core_message_external','message_search_users','message/externallib.php','moodle','','moodle_mobile_app'),(145,'core_message_get_user_contacts','core_message_external','get_user_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(146,'core_message_get_conversations','core_message_external','get_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(147,'core_message_get_conversation','core_message_external','get_conversation','message/externallib.php','moodle','','moodle_mobile_app'),(148,'core_message_get_conversation_between_users','core_message_external','get_conversation_between_users','message/externallib.php','moodle','','moodle_mobile_app'),(149,'core_message_get_self_conversation','core_message_external','get_self_conversation','message/externallib.php','moodle','','moodle_mobile_app'),(150,'core_message_get_messages','core_message_external','get_messages','message/externallib.php','moodle','','moodle_mobile_app'),(151,'core_message_get_conversation_counts','core_message_external','get_conversation_counts','message/externallib.php','moodle','','moodle_mobile_app'),(152,'core_message_get_unread_conversation_counts','core_message_external','get_unread_conversation_counts','message/externallib.php','moodle','','moodle_mobile_app'),(153,'core_message_get_conversation_members','core_message_external','get_conversation_members','message/externallib.php','moodle','','moodle_mobile_app'),(154,'core_message_get_member_info','core_message_external','get_member_info','message/externallib.php','moodle','','moodle_mobile_app'),(155,'core_message_get_unread_conversations_count','core_message_external','get_unread_conversations_count','message/externallib.php','moodle','','moodle_mobile_app'),(156,'core_message_mark_all_notifications_as_read','core_message_external','mark_all_notifications_as_read','message/externallib.php','moodle','','moodle_mobile_app'),(157,'core_message_mark_all_conversation_messages_as_read','core_message_external','mark_all_conversation_messages_as_read','message/externallib.php','moodle','','moodle_mobile_app'),(158,'core_message_mark_message_read','core_message_external','mark_message_read','message/externallib.php','moodle','','moodle_mobile_app'),(159,'core_message_mark_notification_read','core_message_external','mark_notification_read','message/externallib.php','moodle','','moodle_mobile_app'),(160,'core_message_message_processor_config_form','core_message_external','message_processor_config_form','message/externallib.php','moodle','','moodle_mobile_app'),(161,'core_message_get_message_processor','core_message_external','get_message_processor','message/externallib.php','moodle','',NULL),(162,'core_message_search_contacts','core_message_external','search_contacts','message/externallib.php','moodle','','moodle_mobile_app'),(163,'core_message_send_instant_messages','core_message_external','send_instant_messages','message/externallib.php','moodle','moodle/site:sendmessage','moodle_mobile_app'),(164,'core_message_send_messages_to_conversation','core_message_external','send_messages_to_conversation','message/externallib.php','moodle','moodle/site:sendmessage','moodle_mobile_app'),(165,'core_message_get_conversation_messages','core_message_external','get_conversation_messages','message/externallib.php','moodle','','moodle_mobile_app'),(166,'core_message_unblock_user','core_message_external','unblock_user','message/externallib.php','moodle','','moodle_mobile_app'),(167,'core_message_get_user_notification_preferences','core_message_external','get_user_notification_preferences','message/externallib.php','moodle','moodle/user:editownmessageprofile','moodle_mobile_app'),(168,'core_message_get_user_message_preferences','core_message_external','get_user_message_preferences','message/externallib.php','moodle','moodle/user:editownmessageprofile','moodle_mobile_app'),(169,'core_message_set_favourite_conversations','core_message_external','set_favourite_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(170,'core_message_unset_favourite_conversations','core_message_external','unset_favourite_conversations','message/externallib.php','moodle','','moodle_mobile_app'),(171,'core_message_delete_message_for_all_users','core_message_external','delete_message_for_all_users','message/externallib.php','moodle','moodle/site:deleteanymessage','moodle_mobile_app'),(172,'core_notes_create_notes','core_notes_external','create_notes','notes/externallib.php','moodle','moodle/notes:manage','moodle_mobile_app'),(173,'core_notes_delete_notes','core_notes_external','delete_notes','notes/externallib.php','moodle','moodle/notes:manage','moodle_mobile_app'),(174,'core_notes_get_course_notes','core_notes_external','get_course_notes','notes/externallib.php','moodle','moodle/notes:view','moodle_mobile_app'),(175,'core_notes_get_notes','core_notes_external','get_notes','notes/externallib.php','moodle','moodle/notes:view',NULL),(176,'core_notes_update_notes','core_notes_external','update_notes','notes/externallib.php','moodle','moodle/notes:manage',NULL),(177,'core_notes_view_notes','core_notes_external','view_notes','notes/externallib.php','moodle','moodle/notes:view','moodle_mobile_app'),(178,'core_output_load_template','core\\output\\external','load_template',NULL,'moodle','',NULL),(179,'core_output_load_template_with_dependencies','core\\output\\external','load_template_with_dependencies',NULL,'moodle','',NULL),(180,'core_output_load_fontawesome_icon_map','core\\output\\external','load_fontawesome_icon_map',NULL,'moodle','',NULL),(181,'core_output_load_fontawesome_icon_system_map','core\\external\\output\\icon_system\\load_fontawesome_map','execute',NULL,'moodle','',NULL),(182,'core_question_update_flag','core_question_external','update_flag',NULL,'moodle','moodle/question:flag','moodle_mobile_app'),(183,'core_question_submit_tags_form','core_question_external','submit_tags_form',NULL,'moodle','',NULL),(184,'core_question_get_random_question_summaries','core_question_external','get_random_question_summaries',NULL,'moodle','',NULL),(185,'core_rating_get_item_ratings','core_rating_external','get_item_ratings',NULL,'moodle','moodle/rating:view','moodle_mobile_app'),(186,'core_rating_add_rating','core_rating_external','add_rating',NULL,'moodle','moodle/rating:rate','moodle_mobile_app'),(187,'core_role_assign_roles','core_role_external','assign_roles','enrol/externallib.php','moodle','moodle/role:assign',NULL),(188,'core_role_unassign_roles','core_role_external','unassign_roles','enrol/externallib.php','moodle','moodle/role:assign',NULL),(189,'core_search_get_relevant_users','\\core_search\\external','get_relevant_users',NULL,'moodle','',NULL),(190,'core_tag_get_tagindex','core_tag_external','get_tagindex',NULL,'moodle','','moodle_mobile_app'),(191,'core_tag_get_tags','core_tag_external','get_tags',NULL,'moodle','',NULL),(192,'core_tag_update_tags','core_tag_external','update_tags',NULL,'moodle','',NULL),(193,'core_tag_get_tagindex_per_area','core_tag_external','get_tagindex_per_area',NULL,'moodle','','moodle_mobile_app'),(194,'core_tag_get_tag_areas','core_tag_external','get_tag_areas',NULL,'moodle','','moodle_mobile_app'),(195,'core_tag_get_tag_collections','core_tag_external','get_tag_collections',NULL,'moodle','','moodle_mobile_app'),(196,'core_tag_get_tag_cloud','core_tag_external','get_tag_cloud',NULL,'moodle','','moodle_mobile_app'),(197,'core_update_inplace_editable','core_external','update_inplace_editable','lib/external/externallib.php','moodle','',NULL),(198,'core_user_add_user_device','core_user_external','add_user_device','user/externallib.php','moodle','','moodle_mobile_app'),(199,'core_user_add_user_private_files','core_user_external','add_user_private_files','user/externallib.php','moodle','moodle/user:manageownfiles','moodle_mobile_app'),(200,'core_user_create_users','core_user_external','create_users','user/externallib.php','moodle','moodle/user:create',NULL),(201,'core_user_delete_users','core_user_external','delete_users','user/externallib.php','moodle','moodle/user:delete',NULL),(202,'core_user_get_course_user_profiles','core_user_external','get_course_user_profiles','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups','moodle_mobile_app'),(203,'core_user_get_users','core_user_external','get_users','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update',NULL),(204,'core_user_get_users_by_field','core_user_external','get_users_by_field','user/externallib.php','moodle','moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update','moodle_mobile_app'),(205,'core_user_search_identity','\\core_user\\external\\search_identity','execute',NULL,'moodle','moodle/user:viewalldetails',NULL),(206,'core_user_remove_user_device','core_user_external','remove_user_device','user/externallib.php','moodle','','moodle_mobile_app'),(207,'core_user_update_users','core_user_external','update_users','user/externallib.php','moodle','moodle/user:update',NULL),(208,'core_user_update_user_preferences','core_user_external','update_user_preferences','user/externallib.php','moodle','moodle/user:editownmessageprofile, moodle/user:editmessageprofile','moodle_mobile_app'),(209,'core_user_view_user_list','core_user_external','view_user_list','user/externallib.php','moodle','moodle/course:viewparticipants','moodle_mobile_app'),(210,'core_user_view_user_profile','core_user_external','view_user_profile','user/externallib.php','moodle','moodle/user:viewdetails','moodle_mobile_app'),(211,'core_user_get_user_preferences','core_user_external','get_user_preferences','user/externallib.php','moodle','','moodle_mobile_app'),(212,'core_user_update_picture','core_user_external','update_picture','user/externallib.php','moodle','moodle/user:editownprofile, moodle/user:editprofile','moodle_mobile_app'),(213,'core_user_set_user_preferences','core_user_external','set_user_preferences','user/externallib.php','moodle','moodle/site:config','moodle_mobile_app'),(214,'core_user_agree_site_policy','core_user_external','agree_site_policy','user/externallib.php','moodle','','moodle_mobile_app'),(215,'core_user_get_private_files_info','core_user_external','get_private_files_info','user/externallib.php','moodle','moodle/user:manageownfiles','moodle_mobile_app'),(216,'core_competency_create_competency_framework','core_competency\\external','create_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(217,'core_competency_read_competency_framework','core_competency\\external','read_competency_framework',NULL,'moodle','moodle/competency:competencyview',NULL),(218,'core_competency_duplicate_competency_framework','core_competency\\external','duplicate_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(219,'core_competency_delete_competency_framework','core_competency\\external','delete_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(220,'core_competency_update_competency_framework','core_competency\\external','update_competency_framework',NULL,'moodle','moodle/competency:competencymanage',NULL),(221,'core_competency_list_competency_frameworks','core_competency\\external','list_competency_frameworks',NULL,'moodle','moodle/competency:competencyview',NULL),(222,'core_competency_count_competency_frameworks','core_competency\\external','count_competency_frameworks',NULL,'moodle','moodle/competency:competencyview',NULL),(223,'core_competency_competency_framework_viewed','core_competency\\external','competency_framework_viewed',NULL,'moodle','moodle/competency:competencyview',NULL),(224,'core_competency_create_competency','core_competency\\external','create_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(225,'core_competency_read_competency','core_competency\\external','read_competency',NULL,'moodle','moodle/competency:competencyview',NULL),(226,'core_competency_competency_viewed','core_competency\\external','competency_viewed',NULL,'moodle','moodle/competency:competencyview','moodle_mobile_app'),(227,'core_competency_delete_competency','core_competency\\external','delete_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(228,'core_competency_update_competency','core_competency\\external','update_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(229,'core_competency_list_competencies','core_competency\\external','list_competencies',NULL,'moodle','moodle/competency:competencyview',NULL),(230,'core_competency_list_competencies_in_template','core_competency\\external','list_competencies_in_template',NULL,'moodle','moodle/competency:competencyview',NULL),(231,'core_competency_count_competencies','core_competency\\external','count_competencies',NULL,'moodle','moodle/competency:competencyview',NULL),(232,'core_competency_count_competencies_in_template','core_competency\\external','count_competencies_in_template',NULL,'moodle','moodle/competency:competencyview',NULL),(233,'core_competency_search_competencies','core_competency\\external','search_competencies',NULL,'moodle','moodle/competency:competencyview',NULL),(234,'core_competency_set_parent_competency','core_competency\\external','set_parent_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(235,'core_competency_move_up_competency','core_competency\\external','move_up_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(236,'core_competency_move_down_competency','core_competency\\external','move_down_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(237,'core_competency_list_course_module_competencies','core_competency\\external','list_course_module_competencies',NULL,'moodle','moodle/competency:coursecompetencyview',NULL),(238,'core_competency_count_course_module_competencies','core_competency\\external','count_course_module_competencies',NULL,'moodle','moodle/competency:coursecompetencyview',NULL),(239,'core_competency_list_course_competencies','core_competency\\external','list_course_competencies',NULL,'moodle','moodle/competency:coursecompetencyview','moodle_mobile_app'),(240,'core_competency_count_competencies_in_course','core_competency\\external','count_competencies_in_course',NULL,'moodle','moodle/competency:coursecompetencyview',NULL),(241,'core_competency_count_courses_using_competency','core_competency\\external','count_courses_using_competency',NULL,'moodle','moodle/competency:coursecompetencyview',NULL),(242,'core_competency_add_competency_to_course','core_competency\\external','add_competency_to_course',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(243,'core_competency_add_competency_to_template','core_competency\\external','add_competency_to_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(244,'core_competency_remove_competency_from_course','core_competency\\external','remove_competency_from_course',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(245,'core_competency_set_course_competency_ruleoutcome','core_competency\\external','set_course_competency_ruleoutcome',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(246,'core_competency_remove_competency_from_template','core_competency\\external','remove_competency_from_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(247,'core_competency_reorder_course_competency','core_competency\\external','reorder_course_competency',NULL,'moodle','moodle/competency:coursecompetencymanage',NULL),(248,'core_competency_reorder_template_competency','core_competency\\external','reorder_template_competency',NULL,'moodle','moodle/competency:templatemanage',NULL),(249,'core_competency_create_template','core_competency\\external','create_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(250,'core_competency_duplicate_template','core_competency\\external','duplicate_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(251,'core_competency_read_template','core_competency\\external','read_template',NULL,'moodle','moodle/competency:templateview',NULL),(252,'core_competency_delete_template','core_competency\\external','delete_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(253,'core_competency_update_template','core_competency\\external','update_template',NULL,'moodle','moodle/competency:templatemanage',NULL),(254,'core_competency_list_templates','core_competency\\external','list_templates',NULL,'moodle','moodle/competency:templateview',NULL),(255,'core_competency_list_templates_using_competency','core_competency\\external','list_templates_using_competency',NULL,'moodle','moodle/competency:templateview',NULL),(256,'core_competency_count_templates','core_competency\\external','count_templates',NULL,'moodle','moodle/competency:templateview',NULL),(257,'core_competency_count_templates_using_competency','core_competency\\external','count_templates_using_competency',NULL,'moodle','moodle/competency:templateview',NULL),(258,'core_competency_create_plan','core_competency\\external','create_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(259,'core_competency_update_plan','core_competency\\external','update_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(260,'core_competency_complete_plan','core_competency\\external','complete_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(261,'core_competency_reopen_plan','core_competency\\external','reopen_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(262,'core_competency_read_plan','core_competency\\external','read_plan',NULL,'moodle','moodle/competency:planviewown',NULL),(263,'core_competency_delete_plan','core_competency\\external','delete_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(264,'core_competency_list_user_plans','core_competency\\external','list_user_plans',NULL,'moodle','moodle/competency:planviewown',NULL),(265,'core_competency_list_plan_competencies','core_competency\\external','list_plan_competencies',NULL,'moodle','moodle/competency:planviewown',NULL),(266,'core_competency_add_competency_to_plan','core_competency\\external','add_competency_to_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(267,'core_competency_remove_competency_from_plan','core_competency\\external','remove_competency_from_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(268,'core_competency_reorder_plan_competency','core_competency\\external','reorder_plan_competency',NULL,'moodle','moodle/competency:planmanage',NULL),(269,'core_competency_plan_request_review','core_competency\\external','plan_request_review',NULL,'moodle','moodle/competency:planmanagedraft',NULL),(270,'core_competency_plan_start_review','core_competency\\external','plan_start_review',NULL,'moodle','moodle/competency:planmanage',NULL),(271,'core_competency_plan_stop_review','core_competency\\external','plan_stop_review',NULL,'moodle','moodle/competency:planmanage',NULL),(272,'core_competency_plan_cancel_review_request','core_competency\\external','plan_cancel_review_request',NULL,'moodle','moodle/competency:planmanagedraft',NULL),(273,'core_competency_approve_plan','core_competency\\external','approve_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(274,'core_competency_unapprove_plan','core_competency\\external','unapprove_plan',NULL,'moodle','moodle/competency:planmanage',NULL),(275,'core_competency_template_has_related_data','core_competency\\external','template_has_related_data',NULL,'moodle','moodle/competency:templateview',NULL),(276,'core_competency_get_scale_values','core_competency\\external','get_scale_values',NULL,'moodle','moodle/competency:competencymanage','moodle_mobile_app'),(277,'core_competency_add_related_competency','core_competency\\external','add_related_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(278,'core_competency_remove_related_competency','core_competency\\external','remove_related_competency',NULL,'moodle','moodle/competency:competencymanage',NULL),(279,'core_competency_read_user_evidence','core_competency\\external','read_user_evidence',NULL,'moodle','moodle/competency:userevidenceview',NULL),(280,'core_competency_delete_user_evidence','core_competency\\external','delete_user_evidence',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(281,'core_competency_create_user_evidence_competency','core_competency\\external','create_user_evidence_competency',NULL,'moodle','moodle/competency:userevidencemanageown, moodle/competency:competencyview',NULL),(282,'core_competency_delete_user_evidence_competency','core_competency\\external','delete_user_evidence_competency',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(283,'core_competency_user_competency_cancel_review_request','core_competency\\external','user_competency_cancel_review_request',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(284,'core_competency_user_competency_request_review','core_competency\\external','user_competency_request_review',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(285,'core_competency_user_competency_start_review','core_competency\\external','user_competency_start_review',NULL,'moodle','moodle/competency:competencygrade',NULL),(286,'core_competency_user_competency_stop_review','core_competency\\external','user_competency_stop_review',NULL,'moodle','moodle/competency:competencygrade',NULL),(287,'core_competency_user_competency_viewed','core_competency\\external','user_competency_viewed',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(288,'core_competency_user_competency_viewed_in_plan','core_competency\\external','user_competency_viewed_in_plan',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(289,'core_competency_user_competency_viewed_in_course','core_competency\\external','user_competency_viewed_in_course',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(290,'core_competency_user_competency_plan_viewed','core_competency\\external','user_competency_plan_viewed',NULL,'moodle','moodle/competency:usercompetencyview','moodle_mobile_app'),(291,'core_competency_grade_competency','core_competency\\external','grade_competency',NULL,'moodle','moodle/competency:competencygrade',NULL),(292,'core_competency_grade_competency_in_plan','core_competency\\external','grade_competency_in_plan',NULL,'moodle','moodle/competency:competencygrade',NULL),(293,'core_competency_grade_competency_in_course','core_competency\\external','grade_competency_in_course',NULL,'moodle','moodle/competency:competencygrade','moodle_mobile_app'),(294,'core_competency_unlink_plan_from_template','core_competency\\external','unlink_plan_from_template',NULL,'moodle','moodle/competency:planmanage',NULL),(295,'core_competency_template_viewed','core_competency\\external','template_viewed',NULL,'moodle','moodle/competency:templateview',NULL),(296,'core_competency_request_review_of_user_evidence_linked_competencies','core_competency\\external','request_review_of_user_evidence_linked_competencies',NULL,'moodle','moodle/competency:userevidencemanageown',NULL),(297,'core_competency_update_course_competency_settings','core_competency\\external','update_course_competency_settings',NULL,'moodle','moodle/competency:coursecompetencyconfigure',NULL),(298,'core_competency_delete_evidence','core_competency\\external','delete_evidence',NULL,'moodle','moodle/competency:evidencedelete','moodle_mobile_app'),(299,'core_webservice_get_site_info','core_webservice_external','get_site_info','webservice/externallib.php','moodle','','moodle_mobile_app'),(300,'core_block_get_course_blocks','core_block_external','get_course_blocks',NULL,'moodle','','moodle_mobile_app'),(301,'core_block_get_dashboard_blocks','core_block_external','get_dashboard_blocks',NULL,'moodle','','moodle_mobile_app'),(302,'core_block_fetch_addable_blocks','core_block\\external\\fetch_addable_blocks','execute',NULL,'moodle','moodle/site:manageblocks','moodle_mobile_app'),(303,'core_filters_get_available_in_context','core_filters\\external','get_available_in_context',NULL,'moodle','','moodle_mobile_app'),(304,'core_customfield_delete_field','core_customfield_external','delete_field','customfield/externallib.php','moodle','',NULL),(305,'core_customfield_reload_template','core_customfield_external','reload_template','customfield/externallib.php','moodle','',NULL),(306,'core_customfield_create_category','core_customfield_external','create_category','customfield/externallib.php','moodle','',NULL),(307,'core_customfield_delete_category','core_customfield_external','delete_category','customfield/externallib.php','moodle','',NULL),(308,'core_customfield_move_field','core_customfield_external','move_field','customfield/externallib.php','moodle','',NULL),(309,'core_customfield_move_category','core_customfield_external','move_category','customfield/externallib.php','moodle','',NULL),(310,'core_h5p_get_trusted_h5p_file','core_h5p\\external','get_trusted_h5p_file',NULL,'moodle','','moodle_mobile_app'),(311,'core_table_get_dynamic_table_content','core_table\\external\\dynamic\\get','execute',NULL,'moodle','','moodle_mobile_app'),(312,'core_xapi_statement_post','core_xapi\\external\\post_statement','execute',NULL,'moodle','','moodle_mobile_app'),(313,'core_contentbank_delete_content','core_contentbank\\external\\delete_content','execute',NULL,'moodle','moodle/contentbank:deleteanycontent',NULL),(314,'core_contentbank_rename_content','core_contentbank\\external\\rename_content','execute',NULL,'moodle','moodle/contentbank:manageowncontent',NULL),(315,'core_contentbank_set_content_visibility','core_contentbank\\external\\set_content_visibility','execute',NULL,'moodle','moodle/contentbank:manageowncontent',NULL),(316,'core_create_userfeedback_action_record','core\\external\\record_userfeedback_action','execute',NULL,'moodle','',NULL),(317,'core_payment_get_available_gateways','core_payment\\external\\get_available_gateways','execute',NULL,'moodle','',NULL),(318,'mod_assign_copy_previous_attempt','mod_assign_external','copy_previous_attempt','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:submit',NULL),(319,'mod_assign_get_grades','mod_assign_external','get_grades','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(320,'mod_assign_get_assignments','mod_assign_external','get_assignments','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(321,'mod_assign_get_submissions','mod_assign_external','get_submissions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(322,'mod_assign_get_user_flags','mod_assign_external','get_user_flags','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(323,'mod_assign_set_user_flags','mod_assign_external','set_user_flags','mod/assign/externallib.php','mod_assign','mod/assign:grade','moodle_mobile_app'),(324,'mod_assign_get_user_mappings','mod_assign_external','get_user_mappings','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(325,'mod_assign_revert_submissions_to_draft','mod_assign_external','revert_submissions_to_draft','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(326,'mod_assign_lock_submissions','mod_assign_external','lock_submissions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(327,'mod_assign_unlock_submissions','mod_assign_external','unlock_submissions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(328,'mod_assign_save_submission','mod_assign_external','save_submission','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(329,'mod_assign_submit_for_grading','mod_assign_external','submit_for_grading','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(330,'mod_assign_save_grade','mod_assign_external','save_grade','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(331,'mod_assign_save_grades','mod_assign_external','save_grades','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(332,'mod_assign_save_user_extensions','mod_assign_external','save_user_extensions','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(333,'mod_assign_reveal_identities','mod_assign_external','reveal_identities','mod/assign/externallib.php','mod_assign','','moodle_mobile_app'),(334,'mod_assign_view_grading_table','mod_assign_external','view_grading_table','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades','moodle_mobile_app'),(335,'mod_assign_view_submission_status','mod_assign_external','view_submission_status','mod/assign/externallib.php','mod_assign','mod/assign:view','moodle_mobile_app'),(336,'mod_assign_get_submission_status','mod_assign_external','get_submission_status','mod/assign/externallib.php','mod_assign','mod/assign:view','moodle_mobile_app'),(337,'mod_assign_list_participants','mod_assign_external','list_participants','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades','moodle_mobile_app'),(338,'mod_assign_submit_grading_form','mod_assign_external','submit_grading_form','mod/assign/externallib.php','mod_assign','mod/assign:grade','moodle_mobile_app'),(339,'mod_assign_get_participant','mod_assign_external','get_participant','mod/assign/externallib.php','mod_assign','mod/assign:view, mod/assign:viewgrades','moodle_mobile_app'),(340,'mod_assign_view_assign','mod_assign_external','view_assign','mod/assign/externallib.php','mod_assign','mod/assign:view','moodle_mobile_app'),(341,'mod_book_view_book','mod_book_external','view_book',NULL,'mod_book','mod/book:read','moodle_mobile_app'),(342,'mod_book_get_books_by_courses','mod_book_external','get_books_by_courses',NULL,'mod_book','','moodle_mobile_app'),(343,'mod_chat_login_user','mod_chat_external','login_user',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(344,'mod_chat_get_chat_users','mod_chat_external','get_chat_users',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(345,'mod_chat_send_chat_message','mod_chat_external','send_chat_message',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(346,'mod_chat_get_chat_latest_messages','mod_chat_external','get_chat_latest_messages',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(347,'mod_chat_view_chat','mod_chat_external','view_chat',NULL,'mod_chat','mod/chat:chat','moodle_mobile_app'),(348,'mod_chat_get_chats_by_courses','mod_chat_external','get_chats_by_courses',NULL,'mod_chat','','moodle_mobile_app'),(349,'mod_chat_get_sessions','mod_chat_external','get_sessions',NULL,'mod_chat','','moodle_mobile_app'),(350,'mod_chat_get_session_messages','mod_chat_external','get_session_messages',NULL,'mod_chat','','moodle_mobile_app'),(351,'mod_choice_get_choice_results','mod_choice_external','get_choice_results',NULL,'mod_choice','','moodle_mobile_app'),(352,'mod_choice_get_choice_options','mod_choice_external','get_choice_options',NULL,'mod_choice','mod/choice:choose','moodle_mobile_app'),(353,'mod_choice_submit_choice_response','mod_choice_external','submit_choice_response',NULL,'mod_choice','mod/choice:choose','moodle_mobile_app'),(354,'mod_choice_view_choice','mod_choice_external','view_choice',NULL,'mod_choice','','moodle_mobile_app'),(355,'mod_choice_get_choices_by_courses','mod_choice_external','get_choices_by_courses',NULL,'mod_choice','','moodle_mobile_app'),(356,'mod_choice_delete_choice_responses','mod_choice_external','delete_choice_responses',NULL,'mod_choice','mod/choice:choose','moodle_mobile_app'),(357,'mod_data_get_databases_by_courses','mod_data_external','get_databases_by_courses',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(358,'mod_data_view_database','mod_data_external','view_database',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(359,'mod_data_get_data_access_information','mod_data_external','get_data_access_information',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(360,'mod_data_get_entries','mod_data_external','get_entries',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(361,'mod_data_get_entry','mod_data_external','get_entry',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(362,'mod_data_get_fields','mod_data_external','get_fields',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(363,'mod_data_search_entries','mod_data_external','search_entries',NULL,'mod_data','mod/data:viewentry','moodle_mobile_app'),(364,'mod_data_approve_entry','mod_data_external','approve_entry',NULL,'mod_data','mod/data:approve','moodle_mobile_app'),(365,'mod_data_delete_entry','mod_data_external','delete_entry',NULL,'mod_data','mod/data:manageentries','moodle_mobile_app'),(366,'mod_data_add_entry','mod_data_external','add_entry',NULL,'mod_data','mod/data:writeentry','moodle_mobile_app'),(367,'mod_data_update_entry','mod_data_external','update_entry',NULL,'mod_data','mod/data:writeentry','moodle_mobile_app'),(368,'mod_feedback_get_feedbacks_by_courses','mod_feedback_external','get_feedbacks_by_courses',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(369,'mod_feedback_get_feedback_access_information','mod_feedback_external','get_feedback_access_information',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(370,'mod_feedback_view_feedback','mod_feedback_external','view_feedback',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(371,'mod_feedback_get_current_completed_tmp','mod_feedback_external','get_current_completed_tmp',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(372,'mod_feedback_get_items','mod_feedback_external','get_items',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(373,'mod_feedback_launch_feedback','mod_feedback_external','launch_feedback',NULL,'mod_feedback','mod/feedback:complete','moodle_mobile_app'),(374,'mod_feedback_get_page_items','mod_feedback_external','get_page_items',NULL,'mod_feedback','mod/feedback:complete','moodle_mobile_app'),(375,'mod_feedback_process_page','mod_feedback_external','process_page',NULL,'mod_feedback','mod/feedback:complete','moodle_mobile_app'),(376,'mod_feedback_get_analysis','mod_feedback_external','get_analysis',NULL,'mod_feedback','mod/feedback:viewanalysepage','moodle_mobile_app'),(377,'mod_feedback_get_unfinished_responses','mod_feedback_external','get_unfinished_responses',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(378,'mod_feedback_get_finished_responses','mod_feedback_external','get_finished_responses',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(379,'mod_feedback_get_non_respondents','mod_feedback_external','get_non_respondents',NULL,'mod_feedback','mod/feedback:viewreports','moodle_mobile_app'),(380,'mod_feedback_get_responses_analysis','mod_feedback_external','get_responses_analysis',NULL,'mod_feedback','mod/feedback:viewreports','moodle_mobile_app'),(381,'mod_feedback_get_last_completed','mod_feedback_external','get_last_completed',NULL,'mod_feedback','mod/feedback:view','moodle_mobile_app'),(382,'mod_folder_view_folder','mod_folder_external','view_folder',NULL,'mod_folder','mod/folder:view','moodle_mobile_app'),(383,'mod_folder_get_folders_by_courses','mod_folder_external','get_folders_by_courses',NULL,'mod_folder','mod/folder:view','moodle_mobile_app'),(384,'mod_forum_get_forums_by_courses','mod_forum_external','get_forums_by_courses','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion','moodle_mobile_app'),(385,'mod_forum_get_discussion_posts','mod_forum_external','get_discussion_posts','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting','moodle_mobile_app'),(386,'mod_forum_get_forum_discussion_posts','mod_forum_external','get_forum_discussion_posts','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting','moodle_mobile_app'),(387,'mod_forum_get_forum_discussions_paginated','mod_forum_external','get_forum_discussions_paginated','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting','moodle_mobile_app'),(388,'mod_forum_get_forum_discussions','mod_forum_external','get_forum_discussions','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting','moodle_mobile_app'),(389,'mod_forum_view_forum','mod_forum_external','view_forum','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion','moodle_mobile_app'),(390,'mod_forum_view_forum_discussion','mod_forum_external','view_forum_discussion','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion','moodle_mobile_app'),(391,'mod_forum_add_discussion_post','mod_forum_external','add_discussion_post','mod/forum/externallib.php','mod_forum','mod/forum:replypost','moodle_mobile_app'),(392,'mod_forum_add_discussion','mod_forum_external','add_discussion','mod/forum/externallib.php','mod_forum','mod/forum:startdiscussion','moodle_mobile_app'),(393,'mod_forum_can_add_discussion','mod_forum_external','can_add_discussion','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(394,'mod_forum_get_forum_access_information','mod_forum_external','get_forum_access_information',NULL,'mod_forum','','moodle_mobile_app'),(395,'mod_forum_set_subscription_state','mod_forum_external','set_subscription_state','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(396,'mod_forum_set_lock_state','mod_forum_external','set_lock_state','mod/forum/externallib.php','mod_forum','moodle/course:manageactivities','moodle_mobile_app'),(397,'mod_forum_toggle_favourite_state','mod_forum_external','toggle_favourite_state','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(398,'mod_forum_set_pin_state','mod_forum_external','set_pin_state','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(399,'mod_forum_delete_post','mod_forum_external','delete_post','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(400,'mod_forum_get_discussion_posts_by_userid','mod_forum_external','get_discussion_posts_by_userid','mod/forum/externallib.php','mod_forum','mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting',NULL),(401,'mod_forum_get_discussion_post','mod_forum_external','get_discussion_post','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(402,'mod_forum_prepare_draft_area_for_post','mod_forum_external','prepare_draft_area_for_post','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(403,'mod_forum_update_discussion_post','mod_forum_external','update_discussion_post','mod/forum/externallib.php','mod_forum','','moodle_mobile_app'),(404,'mod_glossary_get_glossaries_by_courses','mod_glossary_external','get_glossaries_by_courses',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(405,'mod_glossary_view_glossary','mod_glossary_external','view_glossary',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(406,'mod_glossary_view_entry','mod_glossary_external','view_entry',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(407,'mod_glossary_get_entries_by_letter','mod_glossary_external','get_entries_by_letter',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(408,'mod_glossary_get_entries_by_date','mod_glossary_external','get_entries_by_date',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(409,'mod_glossary_get_categories','mod_glossary_external','get_categories',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(410,'mod_glossary_get_entries_by_category','mod_glossary_external','get_entries_by_category',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(411,'mod_glossary_get_authors','mod_glossary_external','get_authors',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(412,'mod_glossary_get_entries_by_author','mod_glossary_external','get_entries_by_author',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(413,'mod_glossary_get_entries_by_author_id','mod_glossary_external','get_entries_by_author_id',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(414,'mod_glossary_get_entries_by_search','mod_glossary_external','get_entries_by_search',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(415,'mod_glossary_get_entries_by_term','mod_glossary_external','get_entries_by_term',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(416,'mod_glossary_get_entries_to_approve','mod_glossary_external','get_entries_to_approve',NULL,'mod_glossary','mod/glossary:approve','moodle_mobile_app'),(417,'mod_glossary_get_entry_by_id','mod_glossary_external','get_entry_by_id',NULL,'mod_glossary','mod/glossary:view','moodle_mobile_app'),(418,'mod_glossary_add_entry','mod_glossary_external','add_entry',NULL,'mod_glossary','mod/glossary:write','moodle_mobile_app'),(419,'mod_glossary_delete_entry','mod_glossary\\external\\delete_entry','execute',NULL,'mod_glossary','','moodle_mobile_app'),(420,'mod_glossary_update_entry','mod_glossary\\external\\update_entry','execute',NULL,'mod_glossary','','moodle_mobile_app'),(421,'mod_glossary_prepare_entry_for_edition','mod_glossary\\external\\prepare_entry','execute',NULL,'mod_glossary','','moodle_mobile_app'),(422,'mod_h5pactivity_get_h5pactivity_access_information','mod_h5pactivity\\external\\get_h5pactivity_access_information','execute',NULL,'mod_h5pactivity','mod/h5pactivity:view','moodle_mobile_app'),(423,'mod_h5pactivity_view_h5pactivity','mod_h5pactivity\\external\\view_h5pactivity','execute',NULL,'mod_h5pactivity','mod/h5pactivity:view','moodle_mobile_app'),(424,'mod_h5pactivity_get_attempts','mod_h5pactivity\\external\\get_attempts','execute',NULL,'mod_h5pactivity','mod/h5pactivity:view','moodle_mobile_app'),(425,'mod_h5pactivity_get_results','mod_h5pactivity\\external\\get_results','execute',NULL,'mod_h5pactivity','mod/h5pactivity:view','moodle_mobile_app'),(426,'mod_h5pactivity_get_h5pactivities_by_courses','mod_h5pactivity\\external\\get_h5pactivities_by_courses','execute',NULL,'mod_h5pactivity','mod/h5pactivity:view','moodle_mobile_app'),(427,'mod_h5pactivity_log_report_viewed','mod_h5pactivity\\external\\log_report_viewed','execute',NULL,'mod_h5pactivity','','moodle_mobile_app'),(428,'mod_h5pactivity_get_user_attempts','mod_h5pactivity\\external\\get_user_attempts','execute',NULL,'mod_h5pactivity','mod/h5pactivity:reviewattempts','moodle_mobile_app'),(429,'mod_imscp_view_imscp','mod_imscp_external','view_imscp',NULL,'mod_imscp','mod/imscp:view','moodle_mobile_app'),(430,'mod_imscp_get_imscps_by_courses','mod_imscp_external','get_imscps_by_courses',NULL,'mod_imscp','mod/imscp:view','moodle_mobile_app'),(431,'mod_label_get_labels_by_courses','mod_label_external','get_labels_by_courses',NULL,'mod_label','mod/label:view','moodle_mobile_app'),(432,'mod_lesson_get_lessons_by_courses','mod_lesson_external','get_lessons_by_courses',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(433,'mod_lesson_get_lesson_access_information','mod_lesson_external','get_lesson_access_information',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(434,'mod_lesson_view_lesson','mod_lesson_external','view_lesson',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(435,'mod_lesson_get_questions_attempts','mod_lesson_external','get_questions_attempts',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(436,'mod_lesson_get_user_grade','mod_lesson_external','get_user_grade',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(437,'mod_lesson_get_user_attempt_grade','mod_lesson_external','get_user_attempt_grade',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(438,'mod_lesson_get_content_pages_viewed','mod_lesson_external','get_content_pages_viewed',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(439,'mod_lesson_get_user_timers','mod_lesson_external','get_user_timers',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(440,'mod_lesson_get_pages','mod_lesson_external','get_pages',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(441,'mod_lesson_launch_attempt','mod_lesson_external','launch_attempt',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(442,'mod_lesson_get_page_data','mod_lesson_external','get_page_data',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(443,'mod_lesson_process_page','mod_lesson_external','process_page',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(444,'mod_lesson_finish_attempt','mod_lesson_external','finish_attempt',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(445,'mod_lesson_get_attempts_overview','mod_lesson_external','get_attempts_overview',NULL,'mod_lesson','mod/lesson:viewreports','moodle_mobile_app'),(446,'mod_lesson_get_user_attempt','mod_lesson_external','get_user_attempt',NULL,'mod_lesson','mod/lesson:viewreports','moodle_mobile_app'),(447,'mod_lesson_get_pages_possible_jumps','mod_lesson_external','get_pages_possible_jumps',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(448,'mod_lesson_get_lesson','mod_lesson_external','get_lesson',NULL,'mod_lesson','mod/lesson:view','moodle_mobile_app'),(449,'mod_lti_get_tool_launch_data','mod_lti_external','get_tool_launch_data',NULL,'mod_lti','mod/lti:view','moodle_mobile_app'),(450,'mod_lti_get_ltis_by_courses','mod_lti_external','get_ltis_by_courses',NULL,'mod_lti','mod/lti:view','moodle_mobile_app'),(451,'mod_lti_view_lti','mod_lti_external','view_lti',NULL,'mod_lti','mod/lti:view','moodle_mobile_app'),(452,'mod_lti_get_tool_proxies','mod_lti_external','get_tool_proxies',NULL,'mod_lti','moodle/site:config',NULL),(453,'mod_lti_create_tool_proxy','mod_lti_external','create_tool_proxy',NULL,'mod_lti','moodle/site:config',NULL),(454,'mod_lti_delete_tool_proxy','mod_lti_external','delete_tool_proxy',NULL,'mod_lti','moodle/site:config',NULL),(455,'mod_lti_get_tool_proxy_registration_request','mod_lti_external','get_tool_proxy_registration_request',NULL,'mod_lti','moodle/site:config',NULL),(456,'mod_lti_get_tool_types','mod_lti_external','get_tool_types',NULL,'mod_lti','moodle/site:config',NULL),(457,'mod_lti_create_tool_type','mod_lti_external','create_tool_type',NULL,'mod_lti','moodle/site:config',NULL),(458,'mod_lti_update_tool_type','mod_lti_external','update_tool_type',NULL,'mod_lti','moodle/site:config',NULL),(459,'mod_lti_delete_tool_type','mod_lti_external','delete_tool_type',NULL,'mod_lti','moodle/site:config',NULL),(460,'mod_lti_is_cartridge','mod_lti_external','is_cartridge',NULL,'mod_lti','moodle/site:config',NULL),(461,'mod_page_view_page','mod_page_external','view_page',NULL,'mod_page','mod/page:view','moodle_mobile_app'),(462,'mod_page_get_pages_by_courses','mod_page_external','get_pages_by_courses',NULL,'mod_page','mod/page:view','moodle_mobile_app'),(463,'mod_quiz_get_quizzes_by_courses','mod_quiz_external','get_quizzes_by_courses',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(464,'mod_quiz_view_quiz','mod_quiz_external','view_quiz',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(465,'mod_quiz_get_user_attempts','mod_quiz_external','get_user_attempts',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(466,'mod_quiz_get_user_best_grade','mod_quiz_external','get_user_best_grade',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(467,'mod_quiz_get_combined_review_options','mod_quiz_external','get_combined_review_options',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(468,'mod_quiz_start_attempt','mod_quiz_external','start_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(469,'mod_quiz_get_attempt_data','mod_quiz_external','get_attempt_data',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(470,'mod_quiz_get_attempt_summary','mod_quiz_external','get_attempt_summary',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(471,'mod_quiz_save_attempt','mod_quiz_external','save_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(472,'mod_quiz_process_attempt','mod_quiz_external','process_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(473,'mod_quiz_get_attempt_review','mod_quiz_external','get_attempt_review',NULL,'mod_quiz','mod/quiz:reviewmyattempts','moodle_mobile_app'),(474,'mod_quiz_view_attempt','mod_quiz_external','view_attempt',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(475,'mod_quiz_view_attempt_summary','mod_quiz_external','view_attempt_summary',NULL,'mod_quiz','mod/quiz:attempt','moodle_mobile_app'),(476,'mod_quiz_view_attempt_review','mod_quiz_external','view_attempt_review',NULL,'mod_quiz','mod/quiz:reviewmyattempts','moodle_mobile_app'),(477,'mod_quiz_get_quiz_feedback_for_grade','mod_quiz_external','get_quiz_feedback_for_grade',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(478,'mod_quiz_get_quiz_access_information','mod_quiz_external','get_quiz_access_information',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(479,'mod_quiz_get_attempt_access_information','mod_quiz_external','get_attempt_access_information',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(480,'mod_quiz_get_quiz_required_qtypes','mod_quiz_external','get_quiz_required_qtypes',NULL,'mod_quiz','mod/quiz:view','moodle_mobile_app'),(481,'mod_resource_view_resource','mod_resource_external','view_resource',NULL,'mod_resource','mod/resource:view','moodle_mobile_app'),(482,'mod_resource_get_resources_by_courses','mod_resource_external','get_resources_by_courses',NULL,'mod_resource','mod/resource:view','moodle_mobile_app'),(483,'mod_scorm_view_scorm','mod_scorm_external','view_scorm',NULL,'mod_scorm','','moodle_mobile_app'),(484,'mod_scorm_get_scorm_attempt_count','mod_scorm_external','get_scorm_attempt_count',NULL,'mod_scorm','','moodle_mobile_app'),(485,'mod_scorm_get_scorm_scoes','mod_scorm_external','get_scorm_scoes',NULL,'mod_scorm','','moodle_mobile_app'),(486,'mod_scorm_get_scorm_user_data','mod_scorm_external','get_scorm_user_data',NULL,'mod_scorm','','moodle_mobile_app'),(487,'mod_scorm_insert_scorm_tracks','mod_scorm_external','insert_scorm_tracks',NULL,'mod_scorm','mod/scorm:savetrack','moodle_mobile_app'),(488,'mod_scorm_get_scorm_sco_tracks','mod_scorm_external','get_scorm_sco_tracks',NULL,'mod_scorm','','moodle_mobile_app'),(489,'mod_scorm_get_scorms_by_courses','mod_scorm_external','get_scorms_by_courses',NULL,'mod_scorm','','moodle_mobile_app'),(490,'mod_scorm_launch_sco','mod_scorm_external','launch_sco',NULL,'mod_scorm','','moodle_mobile_app'),(491,'mod_scorm_get_scorm_access_information','mod_scorm_external','get_scorm_access_information',NULL,'mod_scorm','','moodle_mobile_app'),(492,'mod_survey_get_surveys_by_courses','mod_survey_external','get_surveys_by_courses',NULL,'mod_survey','','moodle_mobile_app'),(493,'mod_survey_view_survey','mod_survey_external','view_survey',NULL,'mod_survey','mod/survey:participate','moodle_mobile_app'),(494,'mod_survey_get_questions','mod_survey_external','get_questions',NULL,'mod_survey','mod/survey:participate','moodle_mobile_app'),(495,'mod_survey_submit_answers','mod_survey_external','submit_answers',NULL,'mod_survey','mod/survey:participate','moodle_mobile_app'),(496,'mod_url_view_url','mod_url_external','view_url',NULL,'mod_url','mod/url:view','moodle_mobile_app'),(497,'mod_url_get_urls_by_courses','mod_url_external','get_urls_by_courses',NULL,'mod_url','mod/url:view','moodle_mobile_app'),(498,'mod_wiki_get_wikis_by_courses','mod_wiki_external','get_wikis_by_courses',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(499,'mod_wiki_view_wiki','mod_wiki_external','view_wiki',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(500,'mod_wiki_view_page','mod_wiki_external','view_page',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(501,'mod_wiki_get_subwikis','mod_wiki_external','get_subwikis',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(502,'mod_wiki_get_subwiki_pages','mod_wiki_external','get_subwiki_pages',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(503,'mod_wiki_get_subwiki_files','mod_wiki_external','get_subwiki_files',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(504,'mod_wiki_get_page_contents','mod_wiki_external','get_page_contents',NULL,'mod_wiki','mod/wiki:viewpage','moodle_mobile_app'),(505,'mod_wiki_get_page_for_editing','mod_wiki_external','get_page_for_editing',NULL,'mod_wiki','mod/wiki:editpage','moodle_mobile_app'),(506,'mod_wiki_new_page','mod_wiki_external','new_page',NULL,'mod_wiki','mod/wiki:editpage','moodle_mobile_app'),(507,'mod_wiki_edit_page','mod_wiki_external','edit_page',NULL,'mod_wiki','mod/wiki:editpage','moodle_mobile_app'),(508,'mod_workshop_get_workshops_by_courses','mod_workshop_external','get_workshops_by_courses',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(509,'mod_workshop_get_workshop_access_information','mod_workshop_external','get_workshop_access_information',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(510,'mod_workshop_get_user_plan','mod_workshop_external','get_user_plan',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(511,'mod_workshop_view_workshop','mod_workshop_external','view_workshop',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(512,'mod_workshop_add_submission','mod_workshop_external','add_submission',NULL,'mod_workshop','mod/workshop:submit','moodle_mobile_app'),(513,'mod_workshop_update_submission','mod_workshop_external','update_submission',NULL,'mod_workshop','mod/workshop:submit','moodle_mobile_app'),(514,'mod_workshop_delete_submission','mod_workshop_external','delete_submission',NULL,'mod_workshop','mod/workshop:submit','moodle_mobile_app'),(515,'mod_workshop_get_submissions','mod_workshop_external','get_submissions',NULL,'mod_workshop','','moodle_mobile_app'),(516,'mod_workshop_get_submission','mod_workshop_external','get_submission',NULL,'mod_workshop','','moodle_mobile_app'),(517,'mod_workshop_get_submission_assessments','mod_workshop_external','get_submission_assessments',NULL,'mod_workshop','','moodle_mobile_app'),(518,'mod_workshop_get_assessment','mod_workshop_external','get_assessment',NULL,'mod_workshop','','moodle_mobile_app'),(519,'mod_workshop_get_assessment_form_definition','mod_workshop_external','get_assessment_form_definition',NULL,'mod_workshop','','moodle_mobile_app'),(520,'mod_workshop_get_reviewer_assessments','mod_workshop_external','get_reviewer_assessments',NULL,'mod_workshop','','moodle_mobile_app'),(521,'mod_workshop_update_assessment','mod_workshop_external','update_assessment',NULL,'mod_workshop','','moodle_mobile_app'),(522,'mod_workshop_get_grades','mod_workshop_external','get_grades',NULL,'mod_workshop','','moodle_mobile_app'),(523,'mod_workshop_evaluate_assessment','mod_workshop_external','evaluate_assessment',NULL,'mod_workshop','','moodle_mobile_app'),(524,'mod_workshop_get_grades_report','mod_workshop_external','get_grades_report',NULL,'mod_workshop','','moodle_mobile_app'),(525,'mod_workshop_view_submission','mod_workshop_external','view_submission',NULL,'mod_workshop','mod/workshop:view','moodle_mobile_app'),(526,'mod_workshop_evaluate_submission','mod_workshop_external','evaluate_submission',NULL,'mod_workshop','','moodle_mobile_app'),(527,'auth_email_get_signup_settings','auth_email_external','get_signup_settings',NULL,'auth_email','',NULL),(528,'auth_email_signup_user','auth_email_external','signup_user',NULL,'auth_email','',NULL),(529,'enrol_guest_get_instance_info','enrol_guest_external','get_instance_info',NULL,'enrol_guest','','moodle_mobile_app'),(530,'enrol_manual_enrol_users','enrol_manual_external','enrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:enrol',NULL),(531,'enrol_manual_unenrol_users','enrol_manual_external','unenrol_users','enrol/manual/externallib.php','enrol_manual','enrol/manual:unenrol',NULL),(532,'enrol_self_get_instance_info','enrol_self_external','get_instance_info','enrol/self/externallib.php','enrol_self','','moodle_mobile_app'),(533,'enrol_self_enrol_user','enrol_self_external','enrol_user','enrol/self/externallib.php','enrol_self','','moodle_mobile_app'),(534,'message_airnotifier_is_system_configured','message_airnotifier_external','is_system_configured','message/output/airnotifier/externallib.php','message_airnotifier','','moodle_mobile_app'),(535,'message_airnotifier_are_notification_preferences_configured','message_airnotifier_external','are_notification_preferences_configured','message/output/airnotifier/externallib.php','message_airnotifier','','moodle_mobile_app'),(536,'message_airnotifier_get_user_devices','message_airnotifier_external','get_user_devices','message/output/airnotifier/externallib.php','message_airnotifier','','moodle_mobile_app'),(537,'message_airnotifier_enable_device','message_airnotifier_external','enable_device','message/output/airnotifier/externallib.php','message_airnotifier','message/airnotifier:managedevice','moodle_mobile_app'),(538,'message_popup_get_popup_notifications','message_popup_external','get_popup_notifications','message/output/popup/externallib.php','message_popup','','moodle_mobile_app'),(539,'message_popup_get_unread_popup_notification_count','message_popup_external','get_unread_popup_notification_count','message/output/popup/externallib.php','message_popup','','moodle_mobile_app'),(540,'block_accessreview_get_module_data','block_accessreview\\external\\get_module_data','execute',NULL,'block_accessreview','block/accessreview:view',NULL),(541,'block_accessreview_get_section_data','block_accessreview\\external\\get_section_data','execute',NULL,'block_accessreview','block/accessreview:view',NULL),(542,'block_recentlyaccesseditems_get_recent_items','block_recentlyaccesseditems\\external','get_recent_items',NULL,'block_recentlyaccesseditems','','moodle_mobile_app'),(543,'block_starredcourses_get_starred_courses','block_starredcourses_external','get_starred_courses','block/starredcourses/classes/external.php','block_starredcourses','','moodle_mobile_app'),(544,'media_videojs_get_language','media_videojs\\external\\get_language','execute',NULL,'media_videojs','',NULL),(545,'report_competency_data_for_report','report_competency\\external','data_for_report',NULL,'report_competency','moodle/competency:coursecompetencyview',NULL),(546,'report_insights_set_notuseful_prediction','report_insights\\external','set_notuseful_prediction',NULL,'report_insights','','moodle_mobile_app'),(547,'report_insights_set_fixed_prediction','report_insights\\external','set_fixed_prediction',NULL,'report_insights','','moodle_mobile_app'),(548,'report_insights_action_executed','report_insights\\external','action_executed',NULL,'report_insights','','moodle_mobile_app'),(549,'gradereport_overview_get_course_grades','gradereport_overview_external','get_course_grades',NULL,'gradereport_overview','','moodle_mobile_app'),(550,'gradereport_overview_view_grade_report','gradereport_overview_external','view_grade_report',NULL,'gradereport_overview','gradereport/overview:view','moodle_mobile_app'),(551,'gradereport_user_get_grades_table','gradereport_user_external','get_grades_table','grade/report/user/externallib.php','gradereport_user','gradereport/user:view','moodle_mobile_app'),(552,'gradereport_user_view_grade_report','gradereport_user_external','view_grade_report','grade/report/user/externallib.php','gradereport_user','gradereport/user:view','moodle_mobile_app'),(553,'gradereport_user_get_grade_items','gradereport_user_external','get_grade_items','grade/report/user/externallib.php','gradereport_user','gradereport/user:view','moodle_mobile_app'),(554,'gradingform_guide_grader_gradingpanel_fetch','gradingform_guide\\grades\\grader\\gradingpanel\\external\\fetch','execute',NULL,'gradingform_guide','',NULL),(555,'gradingform_guide_grader_gradingpanel_store','gradingform_guide\\grades\\grader\\gradingpanel\\external\\store','execute',NULL,'gradingform_guide','',NULL),(556,'gradingform_rubric_grader_gradingpanel_fetch','gradingform_rubric\\grades\\grader\\gradingpanel\\external\\fetch','execute',NULL,'gradingform_rubric','',NULL),(557,'gradingform_rubric_grader_gradingpanel_store','gradingform_rubric\\grades\\grader\\gradingpanel\\external\\store','execute',NULL,'gradingform_rubric','',NULL),(558,'tool_analytics_potential_contexts','tool_analytics\\external','potential_contexts',NULL,'tool_analytics','','moodle_mobile_app'),(559,'tool_dataprivacy_cancel_data_request','tool_dataprivacy\\external','cancel_data_request',NULL,'tool_dataprivacy','',NULL),(560,'tool_dataprivacy_contact_dpo','tool_dataprivacy\\external','contact_dpo',NULL,'tool_dataprivacy','',NULL),(561,'tool_dataprivacy_mark_complete','tool_dataprivacy\\external','mark_complete',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(562,'tool_dataprivacy_get_data_request','tool_dataprivacy\\external','get_data_request',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(563,'tool_dataprivacy_approve_data_request','tool_dataprivacy\\external','approve_data_request',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(564,'tool_dataprivacy_bulk_approve_data_requests','tool_dataprivacy\\external','bulk_approve_data_requests',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(565,'tool_dataprivacy_deny_data_request','tool_dataprivacy\\external','deny_data_request',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(566,'tool_dataprivacy_bulk_deny_data_requests','tool_dataprivacy\\external','bulk_deny_data_requests',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(567,'tool_dataprivacy_get_users','tool_dataprivacy\\external','get_users',NULL,'tool_dataprivacy','tool/dataprivacy:managedatarequests',NULL),(568,'tool_dataprivacy_create_purpose_form','tool_dataprivacy\\external','create_purpose_form',NULL,'tool_dataprivacy','',NULL),(569,'tool_dataprivacy_create_category_form','tool_dataprivacy\\external','create_category_form',NULL,'tool_dataprivacy','',NULL),(570,'tool_dataprivacy_delete_purpose','tool_dataprivacy\\external','delete_purpose',NULL,'tool_dataprivacy','',NULL),(571,'tool_dataprivacy_delete_category','tool_dataprivacy\\external','delete_category',NULL,'tool_dataprivacy','',NULL),(572,'tool_dataprivacy_set_contextlevel_form','tool_dataprivacy\\external','set_contextlevel_form',NULL,'tool_dataprivacy','',NULL),(573,'tool_dataprivacy_set_context_form','tool_dataprivacy\\external','set_context_form',NULL,'tool_dataprivacy','',NULL),(574,'tool_dataprivacy_tree_extra_branches','tool_dataprivacy\\external','tree_extra_branches',NULL,'tool_dataprivacy','',NULL),(575,'tool_dataprivacy_confirm_contexts_for_deletion','tool_dataprivacy\\external','confirm_contexts_for_deletion',NULL,'tool_dataprivacy','',NULL),(576,'tool_dataprivacy_set_context_defaults','tool_dataprivacy\\external','set_context_defaults',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(577,'tool_dataprivacy_get_category_options','tool_dataprivacy\\external','get_category_options',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(578,'tool_dataprivacy_get_purpose_options','tool_dataprivacy\\external','get_purpose_options',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(579,'tool_dataprivacy_get_activity_options','tool_dataprivacy\\external','get_activity_options',NULL,'tool_dataprivacy','tool/dataprivacy:managedataregistry',NULL),(580,'tool_lp_data_for_competency_frameworks_manage_page','tool_lp\\external','data_for_competency_frameworks_manage_page',NULL,'tool_lp','moodle/competency:competencyview',NULL),(581,'tool_lp_data_for_competency_summary','tool_lp\\external','data_for_competency_summary',NULL,'tool_lp','moodle/competency:competencyview',NULL),(582,'tool_lp_data_for_competencies_manage_page','tool_lp\\external','data_for_competencies_manage_page',NULL,'tool_lp','moodle/competency:competencyview',NULL),(583,'tool_lp_list_courses_using_competency','tool_lp\\external','list_courses_using_competency',NULL,'tool_lp','moodle/competency:coursecompetencyview',NULL),(584,'tool_lp_data_for_course_competencies_page','tool_lp\\external','data_for_course_competencies_page',NULL,'tool_lp','moodle/competency:coursecompetencyview','moodle_mobile_app'),(585,'tool_lp_data_for_template_competencies_page','tool_lp\\external','data_for_template_competencies_page',NULL,'tool_lp','moodle/competency:templateview',NULL),(586,'tool_lp_data_for_templates_manage_page','tool_lp\\external','data_for_templates_manage_page',NULL,'tool_lp','moodle/competency:templateview',NULL),(587,'tool_lp_data_for_plans_page','tool_lp\\external','data_for_plans_page',NULL,'tool_lp','moodle/competency:planviewown','moodle_mobile_app'),(588,'tool_lp_data_for_plan_page','tool_lp\\external','data_for_plan_page',NULL,'tool_lp','moodle/competency:planview','moodle_mobile_app'),(589,'tool_lp_data_for_related_competencies_section','tool_lp\\external','data_for_related_competencies_section',NULL,'tool_lp','moodle/competency:competencyview',NULL),(590,'tool_lp_search_users','tool_lp\\external','search_users',NULL,'tool_lp','',NULL),(591,'tool_lp_search_cohorts','core_cohort_external','search_cohorts','cohort/externallib.php','tool_lp','moodle/cohort:view',NULL),(592,'tool_lp_data_for_user_evidence_list_page','tool_lp\\external','data_for_user_evidence_list_page',NULL,'tool_lp','moodle/competency:userevidenceview','moodle_mobile_app'),(593,'tool_lp_data_for_user_evidence_page','tool_lp\\external','data_for_user_evidence_page',NULL,'tool_lp','moodle/competency:userevidenceview','moodle_mobile_app'),(594,'tool_lp_data_for_user_competency_summary','tool_lp\\external','data_for_user_competency_summary',NULL,'tool_lp','moodle/competency:planview','moodle_mobile_app'),(595,'tool_lp_data_for_user_competency_summary_in_plan','tool_lp\\external','data_for_user_competency_summary_in_plan',NULL,'tool_lp','moodle/competency:planview','moodle_mobile_app'),(596,'tool_lp_data_for_user_competency_summary_in_course','tool_lp\\external','data_for_user_competency_summary_in_course',NULL,'tool_lp','moodle/competency:coursecompetencyview','moodle_mobile_app'),(597,'tool_mobile_get_plugins_supporting_mobile','tool_mobile\\external','get_plugins_supporting_mobile',NULL,'tool_mobile','','moodle_mobile_app'),(598,'tool_mobile_get_public_config','tool_mobile\\external','get_public_config',NULL,'tool_mobile','','moodle_mobile_app'),(599,'tool_mobile_get_config','tool_mobile\\external','get_config',NULL,'tool_mobile','','moodle_mobile_app'),(600,'tool_mobile_get_autologin_key','tool_mobile\\external','get_autologin_key',NULL,'tool_mobile','','moodle_mobile_app'),(601,'tool_mobile_get_content','tool_mobile\\external','get_content',NULL,'tool_mobile','','moodle_mobile_app'),(602,'tool_mobile_call_external_functions','tool_mobile\\external','call_external_functions',NULL,'tool_mobile','','moodle_mobile_app'),(603,'tool_mobile_validate_subscription_key','tool_mobile\\external','validate_subscription_key',NULL,'tool_mobile','','moodle_mobile_app'),(604,'tool_mobile_get_tokens_for_qr_login','tool_mobile\\external','get_tokens_for_qr_login',NULL,'tool_mobile','','moodle_mobile_app'),(605,'tool_moodlenet_verify_webfinger','tool_moodlenet\\external','verify_webfinger',NULL,'tool_moodlenet','','moodle_mobile_app'),(606,'tool_moodlenet_search_courses','tool_moodlenet\\external','search_courses',NULL,'tool_moodlenet','','moodle_mobile_app'),(607,'tool_policy_get_policy_version','tool_policy\\external','get_policy_version',NULL,'tool_policy','',NULL),(608,'tool_policy_submit_accept_on_behalf','tool_policy\\external','submit_accept_on_behalf',NULL,'tool_policy','',NULL),(609,'tool_templatelibrary_list_templates','tool_templatelibrary\\external','list_templates',NULL,'tool_templatelibrary','',NULL),(610,'tool_templatelibrary_load_canonical_template','tool_templatelibrary\\external','load_canonical_template',NULL,'tool_templatelibrary','',NULL),(611,'tool_usertours_fetch_and_start_tour','tool_usertours\\external\\tour','fetch_and_start_tour',NULL,'tool_usertours','',NULL),(612,'tool_usertours_step_shown','tool_usertours\\external\\tour','step_shown',NULL,'tool_usertours','',NULL),(613,'tool_usertours_complete_tour','tool_usertours\\external\\tour','complete_tour',NULL,'tool_usertours','',NULL),(614,'tool_usertours_reset_tour','tool_usertours\\external\\tour','reset_tour',NULL,'tool_usertours','',NULL),(615,'tool_xmldb_invoke_move_action','tool_xmldb_external','invoke_move_action',NULL,'tool_xmldb','',NULL),(616,'paygw_paypal_get_config_for_js','paygw_paypal\\external\\get_config_for_js','execute',NULL,'paygw_paypal','',NULL),(617,'paygw_paypal_create_transaction_complete','paygw_paypal\\external\\transaction_complete','execute',NULL,'paygw_paypal','',NULL);
/*!40000 ALTER TABLE `mdl_external_functions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services`
--

DROP TABLE IF EXISTS `mdl_external_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_exteserv_nam_uix` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='built in and custom external services';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services`
--

LOCK TABLES `mdl_external_services` WRITE;
/*!40000 ALTER TABLE `mdl_external_services` DISABLE KEYS */;
INSERT INTO `mdl_external_services` VALUES (1,'Moodle mobile web service',0,NULL,0,'moodle',1663307062,1663307130,'moodle_mobile_app',1,1);
/*!40000 ALTER TABLE `mdl_external_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services_functions`
--

DROP TABLE IF EXISTS `mdl_external_services_functions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `functionname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB AUTO_INCREMENT=376 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='lists functions available in each service group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services_functions`
--

LOCK TABLES `mdl_external_services_functions` WRITE;
/*!40000 ALTER TABLE `mdl_external_services_functions` DISABLE KEYS */;
INSERT INTO `mdl_external_services_functions` VALUES (1,1,'core_badges_get_user_badges'),(2,1,'core_blog_get_entries'),(3,1,'core_blog_view_entries'),(4,1,'core_calendar_get_calendar_monthly_view'),(5,1,'core_calendar_get_calendar_day_view'),(6,1,'core_calendar_get_calendar_upcoming_view'),(7,1,'core_calendar_update_event_start_day'),(8,1,'core_calendar_create_calendar_events'),(9,1,'core_calendar_delete_calendar_events'),(10,1,'core_calendar_get_calendar_events'),(11,1,'core_calendar_get_action_events_by_timesort'),(12,1,'core_calendar_get_action_events_by_course'),(13,1,'core_calendar_get_action_events_by_courses'),(14,1,'core_calendar_get_calendar_event_by_id'),(15,1,'core_calendar_submit_create_update_form'),(16,1,'core_calendar_get_calendar_access_information'),(17,1,'core_calendar_get_allowed_event_types'),(18,1,'core_calendar_get_calendar_export_token'),(19,1,'core_comment_get_comments'),(20,1,'core_comment_add_comments'),(21,1,'core_comment_delete_comments'),(22,1,'core_completion_get_activities_completion_status'),(23,1,'core_completion_get_course_completion_status'),(24,1,'core_completion_mark_course_self_completed'),(25,1,'core_completion_update_activity_completion_status_manually'),(26,1,'core_course_get_categories'),(27,1,'core_course_get_contents'),(28,1,'core_course_get_course_module'),(29,1,'core_course_get_course_module_by_instance'),(30,1,'core_course_get_courses'),(31,1,'core_course_search_courses'),(32,1,'core_course_view_course'),(33,1,'core_course_get_user_navigation_options'),(34,1,'core_course_get_user_administration_options'),(35,1,'core_course_get_courses_by_field'),(36,1,'core_course_check_updates'),(37,1,'core_course_get_updates_since'),(38,1,'core_course_get_enrolled_courses_by_timeline_classification'),(39,1,'core_course_get_recent_courses'),(40,1,'core_course_set_favourite_courses'),(41,1,'core_enrol_get_course_enrolment_methods'),(42,1,'core_enrol_get_enrolled_users'),(43,1,'core_enrol_search_users'),(44,1,'core_enrol_get_users_courses'),(45,1,'core_files_get_files'),(46,1,'core_files_delete_draft_files'),(47,1,'core_files_get_unused_draft_itemid'),(48,1,'core_get_component_strings'),(49,1,'core_grades_grader_gradingpanel_point_fetch'),(50,1,'core_grades_grader_gradingpanel_point_store'),(51,1,'core_grades_grader_gradingpanel_scale_fetch'),(52,1,'core_grades_grader_gradingpanel_scale_store'),(53,1,'core_group_get_activity_allowed_groups'),(54,1,'core_group_get_activity_groupmode'),(55,1,'core_group_get_course_groupings'),(56,1,'core_group_get_course_groups'),(57,1,'core_group_get_course_user_groups'),(58,1,'core_message_mute_conversations'),(59,1,'core_message_unmute_conversations'),(60,1,'core_message_block_user'),(61,1,'core_message_get_contact_requests'),(62,1,'core_message_create_contact_request'),(63,1,'core_message_confirm_contact_request'),(64,1,'core_message_decline_contact_request'),(65,1,'core_message_get_received_contact_requests_count'),(66,1,'core_message_delete_contacts'),(67,1,'core_message_delete_conversations_by_id'),(68,1,'core_message_delete_message'),(69,1,'core_message_get_blocked_users'),(70,1,'core_message_data_for_messagearea_search_messages'),(71,1,'core_message_message_search_users'),(72,1,'core_message_get_user_contacts'),(73,1,'core_message_get_conversations'),(74,1,'core_message_get_conversation'),(75,1,'core_message_get_conversation_between_users'),(76,1,'core_message_get_self_conversation'),(77,1,'core_message_get_messages'),(78,1,'core_message_get_conversation_counts'),(79,1,'core_message_get_unread_conversation_counts'),(80,1,'core_message_get_conversation_members'),(81,1,'core_message_get_member_info'),(82,1,'core_message_get_unread_conversations_count'),(83,1,'core_message_mark_all_notifications_as_read'),(84,1,'core_message_mark_all_conversation_messages_as_read'),(85,1,'core_message_mark_message_read'),(86,1,'core_message_mark_notification_read'),(87,1,'core_message_message_processor_config_form'),(88,1,'core_message_search_contacts'),(89,1,'core_message_send_instant_messages'),(90,1,'core_message_send_messages_to_conversation'),(91,1,'core_message_get_conversation_messages'),(92,1,'core_message_unblock_user'),(93,1,'core_message_get_user_notification_preferences'),(94,1,'core_message_get_user_message_preferences'),(95,1,'core_message_set_favourite_conversations'),(96,1,'core_message_unset_favourite_conversations'),(97,1,'core_message_delete_message_for_all_users'),(98,1,'core_notes_create_notes'),(99,1,'core_notes_delete_notes'),(100,1,'core_notes_get_course_notes'),(101,1,'core_notes_view_notes'),(102,1,'core_question_update_flag'),(103,1,'core_rating_get_item_ratings'),(104,1,'core_rating_add_rating'),(105,1,'core_tag_get_tagindex'),(106,1,'core_tag_get_tagindex_per_area'),(107,1,'core_tag_get_tag_areas'),(108,1,'core_tag_get_tag_collections'),(109,1,'core_tag_get_tag_cloud'),(110,1,'core_user_add_user_device'),(111,1,'core_user_add_user_private_files'),(112,1,'core_user_get_course_user_profiles'),(113,1,'core_user_get_users_by_field'),(114,1,'core_user_remove_user_device'),(115,1,'core_user_update_user_preferences'),(116,1,'core_user_view_user_list'),(117,1,'core_user_view_user_profile'),(118,1,'core_user_get_user_preferences'),(119,1,'core_user_update_picture'),(120,1,'core_user_set_user_preferences'),(121,1,'core_user_agree_site_policy'),(122,1,'core_user_get_private_files_info'),(123,1,'core_competency_competency_viewed'),(124,1,'core_competency_list_course_competencies'),(125,1,'core_competency_get_scale_values'),(126,1,'core_competency_user_competency_viewed'),(127,1,'core_competency_user_competency_viewed_in_plan'),(128,1,'core_competency_user_competency_viewed_in_course'),(129,1,'core_competency_user_competency_plan_viewed'),(130,1,'core_competency_grade_competency_in_course'),(131,1,'core_competency_delete_evidence'),(132,1,'core_webservice_get_site_info'),(133,1,'core_block_get_course_blocks'),(134,1,'core_block_get_dashboard_blocks'),(135,1,'core_block_fetch_addable_blocks'),(136,1,'core_filters_get_available_in_context'),(137,1,'core_h5p_get_trusted_h5p_file'),(138,1,'core_table_get_dynamic_table_content'),(139,1,'core_xapi_statement_post'),(140,1,'mod_assign_get_grades'),(141,1,'mod_assign_get_assignments'),(142,1,'mod_assign_get_submissions'),(143,1,'mod_assign_get_user_flags'),(144,1,'mod_assign_set_user_flags'),(145,1,'mod_assign_get_user_mappings'),(146,1,'mod_assign_revert_submissions_to_draft'),(147,1,'mod_assign_lock_submissions'),(148,1,'mod_assign_unlock_submissions'),(149,1,'mod_assign_save_submission'),(150,1,'mod_assign_submit_for_grading'),(151,1,'mod_assign_save_grade'),(152,1,'mod_assign_save_grades'),(153,1,'mod_assign_save_user_extensions'),(154,1,'mod_assign_reveal_identities'),(155,1,'mod_assign_view_grading_table'),(156,1,'mod_assign_view_submission_status'),(157,1,'mod_assign_get_submission_status'),(158,1,'mod_assign_list_participants'),(159,1,'mod_assign_submit_grading_form'),(160,1,'mod_assign_get_participant'),(161,1,'mod_assign_view_assign'),(162,1,'mod_book_view_book'),(163,1,'mod_book_get_books_by_courses'),(164,1,'mod_chat_login_user'),(165,1,'mod_chat_get_chat_users'),(166,1,'mod_chat_send_chat_message'),(167,1,'mod_chat_get_chat_latest_messages'),(168,1,'mod_chat_view_chat'),(169,1,'mod_chat_get_chats_by_courses'),(170,1,'mod_chat_get_sessions'),(171,1,'mod_chat_get_session_messages'),(172,1,'mod_choice_get_choice_results'),(173,1,'mod_choice_get_choice_options'),(174,1,'mod_choice_submit_choice_response'),(175,1,'mod_choice_view_choice'),(176,1,'mod_choice_get_choices_by_courses'),(177,1,'mod_choice_delete_choice_responses'),(178,1,'mod_data_get_databases_by_courses'),(179,1,'mod_data_view_database'),(180,1,'mod_data_get_data_access_information'),(181,1,'mod_data_get_entries'),(182,1,'mod_data_get_entry'),(183,1,'mod_data_get_fields'),(184,1,'mod_data_search_entries'),(185,1,'mod_data_approve_entry'),(186,1,'mod_data_delete_entry'),(187,1,'mod_data_add_entry'),(188,1,'mod_data_update_entry'),(189,1,'mod_feedback_get_feedbacks_by_courses'),(190,1,'mod_feedback_get_feedback_access_information'),(191,1,'mod_feedback_view_feedback'),(192,1,'mod_feedback_get_current_completed_tmp'),(193,1,'mod_feedback_get_items'),(194,1,'mod_feedback_launch_feedback'),(195,1,'mod_feedback_get_page_items'),(196,1,'mod_feedback_process_page'),(197,1,'mod_feedback_get_analysis'),(198,1,'mod_feedback_get_unfinished_responses'),(199,1,'mod_feedback_get_finished_responses'),(200,1,'mod_feedback_get_non_respondents'),(201,1,'mod_feedback_get_responses_analysis'),(202,1,'mod_feedback_get_last_completed'),(203,1,'mod_folder_view_folder'),(204,1,'mod_folder_get_folders_by_courses'),(205,1,'mod_forum_get_forums_by_courses'),(206,1,'mod_forum_get_discussion_posts'),(207,1,'mod_forum_get_forum_discussion_posts'),(208,1,'mod_forum_get_forum_discussions_paginated'),(209,1,'mod_forum_get_forum_discussions'),(210,1,'mod_forum_view_forum'),(211,1,'mod_forum_view_forum_discussion'),(212,1,'mod_forum_add_discussion_post'),(213,1,'mod_forum_add_discussion'),(214,1,'mod_forum_can_add_discussion'),(215,1,'mod_forum_get_forum_access_information'),(216,1,'mod_forum_set_subscription_state'),(217,1,'mod_forum_set_lock_state'),(218,1,'mod_forum_toggle_favourite_state'),(219,1,'mod_forum_set_pin_state'),(220,1,'mod_forum_delete_post'),(221,1,'mod_forum_get_discussion_post'),(222,1,'mod_forum_prepare_draft_area_for_post'),(223,1,'mod_forum_update_discussion_post'),(224,1,'mod_glossary_get_glossaries_by_courses'),(225,1,'mod_glossary_view_glossary'),(226,1,'mod_glossary_view_entry'),(227,1,'mod_glossary_get_entries_by_letter'),(228,1,'mod_glossary_get_entries_by_date'),(229,1,'mod_glossary_get_categories'),(230,1,'mod_glossary_get_entries_by_category'),(231,1,'mod_glossary_get_authors'),(232,1,'mod_glossary_get_entries_by_author'),(233,1,'mod_glossary_get_entries_by_author_id'),(234,1,'mod_glossary_get_entries_by_search'),(235,1,'mod_glossary_get_entries_by_term'),(236,1,'mod_glossary_get_entries_to_approve'),(237,1,'mod_glossary_get_entry_by_id'),(238,1,'mod_glossary_add_entry'),(239,1,'mod_glossary_delete_entry'),(240,1,'mod_glossary_update_entry'),(241,1,'mod_glossary_prepare_entry_for_edition'),(242,1,'mod_h5pactivity_get_h5pactivity_access_information'),(243,1,'mod_h5pactivity_view_h5pactivity'),(244,1,'mod_h5pactivity_get_attempts'),(245,1,'mod_h5pactivity_get_results'),(246,1,'mod_h5pactivity_get_h5pactivities_by_courses'),(247,1,'mod_h5pactivity_log_report_viewed'),(248,1,'mod_h5pactivity_get_user_attempts'),(249,1,'mod_imscp_view_imscp'),(250,1,'mod_imscp_get_imscps_by_courses'),(251,1,'mod_label_get_labels_by_courses'),(252,1,'mod_lesson_get_lessons_by_courses'),(253,1,'mod_lesson_get_lesson_access_information'),(254,1,'mod_lesson_view_lesson'),(255,1,'mod_lesson_get_questions_attempts'),(256,1,'mod_lesson_get_user_grade'),(257,1,'mod_lesson_get_user_attempt_grade'),(258,1,'mod_lesson_get_content_pages_viewed'),(259,1,'mod_lesson_get_user_timers'),(260,1,'mod_lesson_get_pages'),(261,1,'mod_lesson_launch_attempt'),(262,1,'mod_lesson_get_page_data'),(263,1,'mod_lesson_process_page'),(264,1,'mod_lesson_finish_attempt'),(265,1,'mod_lesson_get_attempts_overview'),(266,1,'mod_lesson_get_user_attempt'),(267,1,'mod_lesson_get_pages_possible_jumps'),(268,1,'mod_lesson_get_lesson'),(269,1,'mod_lti_get_tool_launch_data'),(270,1,'mod_lti_get_ltis_by_courses'),(271,1,'mod_lti_view_lti'),(272,1,'mod_page_view_page'),(273,1,'mod_page_get_pages_by_courses'),(274,1,'mod_quiz_get_quizzes_by_courses'),(275,1,'mod_quiz_view_quiz'),(276,1,'mod_quiz_get_user_attempts'),(277,1,'mod_quiz_get_user_best_grade'),(278,1,'mod_quiz_get_combined_review_options'),(279,1,'mod_quiz_start_attempt'),(280,1,'mod_quiz_get_attempt_data'),(281,1,'mod_quiz_get_attempt_summary'),(282,1,'mod_quiz_save_attempt'),(283,1,'mod_quiz_process_attempt'),(284,1,'mod_quiz_get_attempt_review'),(285,1,'mod_quiz_view_attempt'),(286,1,'mod_quiz_view_attempt_summary'),(287,1,'mod_quiz_view_attempt_review'),(288,1,'mod_quiz_get_quiz_feedback_for_grade'),(289,1,'mod_quiz_get_quiz_access_information'),(290,1,'mod_quiz_get_attempt_access_information'),(291,1,'mod_quiz_get_quiz_required_qtypes'),(292,1,'mod_resource_view_resource'),(293,1,'mod_resource_get_resources_by_courses'),(294,1,'mod_scorm_view_scorm'),(295,1,'mod_scorm_get_scorm_attempt_count'),(296,1,'mod_scorm_get_scorm_scoes'),(297,1,'mod_scorm_get_scorm_user_data'),(298,1,'mod_scorm_insert_scorm_tracks'),(299,1,'mod_scorm_get_scorm_sco_tracks'),(300,1,'mod_scorm_get_scorms_by_courses'),(301,1,'mod_scorm_launch_sco'),(302,1,'mod_scorm_get_scorm_access_information'),(303,1,'mod_survey_get_surveys_by_courses'),(304,1,'mod_survey_view_survey'),(305,1,'mod_survey_get_questions'),(306,1,'mod_survey_submit_answers'),(307,1,'mod_url_view_url'),(308,1,'mod_url_get_urls_by_courses'),(309,1,'mod_wiki_get_wikis_by_courses'),(310,1,'mod_wiki_view_wiki'),(311,1,'mod_wiki_view_page'),(312,1,'mod_wiki_get_subwikis'),(313,1,'mod_wiki_get_subwiki_pages'),(314,1,'mod_wiki_get_subwiki_files'),(315,1,'mod_wiki_get_page_contents'),(316,1,'mod_wiki_get_page_for_editing'),(317,1,'mod_wiki_new_page'),(318,1,'mod_wiki_edit_page'),(319,1,'mod_workshop_get_workshops_by_courses'),(320,1,'mod_workshop_get_workshop_access_information'),(321,1,'mod_workshop_get_user_plan'),(322,1,'mod_workshop_view_workshop'),(323,1,'mod_workshop_add_submission'),(324,1,'mod_workshop_update_submission'),(325,1,'mod_workshop_delete_submission'),(326,1,'mod_workshop_get_submissions'),(327,1,'mod_workshop_get_submission'),(328,1,'mod_workshop_get_submission_assessments'),(329,1,'mod_workshop_get_assessment'),(330,1,'mod_workshop_get_assessment_form_definition'),(331,1,'mod_workshop_get_reviewer_assessments'),(332,1,'mod_workshop_update_assessment'),(333,1,'mod_workshop_get_grades'),(334,1,'mod_workshop_evaluate_assessment'),(335,1,'mod_workshop_get_grades_report'),(336,1,'mod_workshop_view_submission'),(337,1,'mod_workshop_evaluate_submission'),(338,1,'enrol_guest_get_instance_info'),(339,1,'enrol_self_get_instance_info'),(340,1,'enrol_self_enrol_user'),(341,1,'message_airnotifier_is_system_configured'),(342,1,'message_airnotifier_are_notification_preferences_configured'),(343,1,'message_airnotifier_get_user_devices'),(344,1,'message_airnotifier_enable_device'),(345,1,'message_popup_get_popup_notifications'),(346,1,'message_popup_get_unread_popup_notification_count'),(347,1,'block_recentlyaccesseditems_get_recent_items'),(348,1,'block_starredcourses_get_starred_courses'),(349,1,'report_insights_set_notuseful_prediction'),(350,1,'report_insights_set_fixed_prediction'),(351,1,'report_insights_action_executed'),(352,1,'gradereport_overview_get_course_grades'),(353,1,'gradereport_overview_view_grade_report'),(354,1,'gradereport_user_get_grades_table'),(355,1,'gradereport_user_view_grade_report'),(356,1,'gradereport_user_get_grade_items'),(357,1,'tool_analytics_potential_contexts'),(358,1,'tool_lp_data_for_course_competencies_page'),(359,1,'tool_lp_data_for_plans_page'),(360,1,'tool_lp_data_for_plan_page'),(361,1,'tool_lp_data_for_user_evidence_list_page'),(362,1,'tool_lp_data_for_user_evidence_page'),(363,1,'tool_lp_data_for_user_competency_summary'),(364,1,'tool_lp_data_for_user_competency_summary_in_plan'),(365,1,'tool_lp_data_for_user_competency_summary_in_course'),(366,1,'tool_mobile_get_plugins_supporting_mobile'),(367,1,'tool_mobile_get_public_config'),(368,1,'tool_mobile_get_config'),(369,1,'tool_mobile_get_autologin_key'),(370,1,'tool_mobile_get_content'),(371,1,'tool_mobile_call_external_functions'),(372,1,'tool_mobile_validate_subscription_key'),(373,1,'tool_mobile_get_tokens_for_qr_login'),(374,1,'tool_moodlenet_verify_webfinger'),(375,1,'tool_moodlenet_search_courses');
/*!40000 ALTER TABLE `mdl_external_services_functions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_services_users`
--

DROP TABLE IF EXISTS `mdl_external_services_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_services_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `iprestriction` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_exteservuser_ext_ix` (`externalserviceid`),
  KEY `mdl_exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='users allowed to use services with restricted users flag';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_services_users`
--

LOCK TABLES `mdl_external_services_users` WRITE;
/*!40000 ALTER TABLE `mdl_external_services_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_external_services_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_external_tokens`
--

DROP TABLE IF EXISTS `mdl_external_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_external_tokens` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `privatetoken` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tokentype` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `externalserviceid` bigint(10) NOT NULL,
  `sid` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `creatorid` bigint(10) NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_extetoke_tok_ix` (`token`),
  KEY `mdl_extetoke_use_ix` (`userid`),
  KEY `mdl_extetoke_ext_ix` (`externalserviceid`),
  KEY `mdl_extetoke_con_ix` (`contextid`),
  KEY `mdl_extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Security tokens for accessing of external services';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_external_tokens`
--

LOCK TABLES `mdl_external_tokens` WRITE;
/*!40000 ALTER TABLE `mdl_external_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_external_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_favourite`
--

DROP TABLE IF EXISTS `mdl_favourite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_favourite` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemtype` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `ordering` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_favo_comiteiteconuse_uix` (`component`,`itemtype`,`itemid`,`contextid`,`userid`),
  KEY `mdl_favo_con_ix` (`contextid`),
  KEY `mdl_favo_use_ix` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the relationship between an arbitrary item (itemtype,';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_favourite`
--

LOCK TABLES `mdl_favourite` WRITE;
/*!40000 ALTER TABLE `mdl_favourite` DISABLE KEYS */;
INSERT INTO `mdl_favourite` VALUES (1,'core_message','message_conversations',1,5,2,NULL,1663495956,1663495956);
/*!40000 ALTER TABLE `mdl_favourite` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback`
--

DROP TABLE IF EXISTS `mdl_feedback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_after_submit` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_after_submitformat` tinyint(2) NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all feedbacks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback`
--

LOCK TABLES `mdl_feedback` WRITE;
/*!40000 ALTER TABLE `mdl_feedback` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_completed`
--

DROP TABLE IF EXISTS `mdl_feedback_completed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_completed` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedcomp_use_ix` (`userid`),
  KEY `mdl_feedcomp_fee_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='filled out feedback';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_completed`
--

LOCK TABLES `mdl_feedback_completed` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_completed` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_completed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_completedtmp`
--

DROP TABLE IF EXISTS `mdl_feedback_completedtmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_completedtmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `guestid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedcomp_use2_ix` (`userid`),
  KEY `mdl_feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='filled out feedback';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_completedtmp`
--

LOCK TABLES `mdl_feedback_completedtmp` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_completedtmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_completedtmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_item`
--

DROP TABLE IF EXISTS `mdl_feedback_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_item` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `presentation` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `typ` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint(3) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint(10) NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `options` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_feeditem_fee_ix` (`feedback`),
  KEY `mdl_feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='feedback_items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_item`
--

LOCK TABLES `mdl_feedback_item` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_sitecourse_map`
--

DROP TABLE IF EXISTS `mdl_feedback_sitecourse_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_sitecourse_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_feedsitemap_cou_ix` (`courseid`),
  KEY `mdl_feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='feedback sitecourse map';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_sitecourse_map`
--

LOCK TABLES `mdl_feedback_sitecourse_map` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_sitecourse_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_sitecourse_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_template`
--

DROP TABLE IF EXISTS `mdl_feedback_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='templates of feedbackstructures';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_template`
--

LOCK TABLES `mdl_feedback_template` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_value`
--

DROP TABLE IF EXISTS `mdl_feedback_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_value` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_feedvalu_comitecou_uix` (`completed`,`item`,`course_id`),
  KEY `mdl_feedvalu_cou_ix` (`course_id`),
  KEY `mdl_feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='values of the completeds';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_value`
--

LOCK TABLES `mdl_feedback_value` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_feedback_valuetmp`
--

DROP TABLE IF EXISTS `mdl_feedback_valuetmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_feedback_valuetmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_feedvalu_comitecou2_uix` (`completed`,`item`,`course_id`),
  KEY `mdl_feedvalu_cou2_ix` (`course_id`),
  KEY `mdl_feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='values of the completedstmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_feedback_valuetmp`
--

LOCK TABLES `mdl_feedback_valuetmp` WRITE;
/*!40000 ALTER TABLE `mdl_feedback_valuetmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_feedback_valuetmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_file_conversion`
--

DROP TABLE IF EXISTS `mdl_file_conversion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_file_conversion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sourcefileid` bigint(10) NOT NULL,
  `targetformat` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` bigint(10) DEFAULT '0',
  `statusmessage` longtext COLLATE utf8mb4_unicode_ci,
  `converter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destfileid` bigint(10) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `mdl_fileconv_sou_ix` (`sourcefileid`),
  KEY `mdl_fileconv_des_ix` (`destfileid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Table to track file conversions.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_file_conversion`
--

LOCK TABLES `mdl_file_conversion` WRITE;
/*!40000 ALTER TABLE `mdl_file_conversion` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_file_conversion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_files`
--

DROP TABLE IF EXISTS `mdl_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filearea` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `filepath` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` bigint(10) DEFAULT NULL,
  `filesize` bigint(10) NOT NULL,
  `mimetype` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `referencefileid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_file_pat_uix` (`pathnamehash`),
  KEY `mdl_file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `mdl_file_con_ix` (`contenthash`),
  KEY `mdl_file_lic_ix` (`license`),
  KEY `mdl_file_con2_ix` (`contextid`),
  KEY `mdl_file_use_ix` (`userid`),
  KEY `mdl_file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='description of files, content is stored in sha1 file pool';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_files`
--

LOCK TABLES `mdl_files` WRITE;
/*!40000 ALTER TABLE `mdl_files` DISABLE KEYS */;
INSERT INTO `mdl_files` VALUES (1,'5f8e911d0da441e36f47c5c46f4393269211ca56','508e674d49c30d4fde325fe6c7f6fd3d56b247e1',1,'assignfeedback_editpdf','stamps',0,'/','smile.png',2,1085,'image/png',0,NULL,NULL,NULL,1663307095,1663307095,0,NULL),(2,'da39a3ee5e6b4b0d3255bfef95601890afd80709','70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5',1,'assignfeedback_editpdf','stamps',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1663307095,1663307095,0,NULL),(3,'75c101cb8cb34ea573cd25ac38f8157b1de901b8','68317eab56c67d32aeaee5acf509a0c4aa828b6b',1,'assignfeedback_editpdf','stamps',0,'/','sad.png',2,966,'image/png',0,NULL,NULL,NULL,1663307095,1663307095,0,NULL),(4,'0c5190a24c3943966541401c883eacaa20ca20cb','695a55ff780e61c9e59428aa425430b0d6bde53b',1,'assignfeedback_editpdf','stamps',0,'/','tick.png',2,1039,'image/png',0,NULL,NULL,NULL,1663307095,1663307095,0,NULL),(5,'8c96a486d5801e0f4ab8c411f561f1c687e1f865','373e63af262a9b8466ba8632551520be793c37ff',1,'assignfeedback_editpdf','stamps',0,'/','cross.png',2,861,'image/png',0,NULL,NULL,NULL,1663307095,1663307095,0,NULL),(8,'1308b46464c57e60fd45bc3257865d5180bda047','6e177e2d32d9e72358fb711437ab27e530f28e6f',79,'tool_recyclebin','recyclebin_coursecat',1,'/','backup.mbz',2,4610,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1663413570,1663413570,0,NULL),(9,'da39a3ee5e6b4b0d3255bfef95601890afd80709','0fa1a5311286ea9b66aaccff9e80bb44c64a1537',79,'tool_recyclebin','recyclebin_coursecat',1,'/','.',2,0,NULL,0,NULL,NULL,NULL,1663413570,1663413570,0,NULL),(12,'3ee684361ee0a71c16f8df26243d9acc38d45212','552fafec205c091dcece201614d7665d3e158b6b',79,'tool_recyclebin','recyclebin_coursecat',2,'/','backup.mbz',2,4599,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1663413577,1663413577,0,NULL),(13,'da39a3ee5e6b4b0d3255bfef95601890afd80709','32287ec3b64dc3e5b55e9b206a09569d1b6e69b8',79,'tool_recyclebin','recyclebin_coursecat',2,'/','.',2,0,NULL,0,NULL,NULL,NULL,1663413577,1663413577,0,NULL),(14,'d54372e478989f12886e471a1814152dd196fdff','dc46e6c73671296d8f0af79ee697228d852a264b',5,'user','draft',367844806,'/','block_course_list_advanced_moodle40_2022051200.zip',2,19739,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:50:\"block_course_list_advanced_moodle40_2022051200.zip\";}','Admin User','unknown',1663489554,1663489554,0,NULL),(15,'da39a3ee5e6b4b0d3255bfef95601890afd80709','71e8dbc07ed799c27746e590402ef2314011a901',5,'user','draft',367844806,'/','.',2,0,NULL,0,NULL,NULL,NULL,1663489554,1663489554,0,NULL),(16,'af683d35c6136bfa9ad1a6675eb21e3a7eb48642','228bb55c4e592bf522917fc41b476513fc200a8c',5,'user','draft',981288902,'/','block_catalogue_moodle33_2017071900.zip',2,2589456,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:39:\"block_catalogue_moodle33_2017071900.zip\";}','Admin User','unknown',1663490061,1663490061,0,NULL),(17,'da39a3ee5e6b4b0d3255bfef95601890afd80709','203b18a82483b42c1ab1c21f2dcf46dc8adbac6f',5,'user','draft',981288902,'/','.',2,0,NULL,0,NULL,NULL,NULL,1663490061,1663490061,0,NULL),(18,'ae305de158135a43205cce0866250c30ddeb43dd','81033c3f2074c85fefc0a3253143f9483e80ef3e',5,'user','draft',944565703,'/','block_course_overview_moodle37_2019021300.zip',2,39308,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:45:\"block_course_overview_moodle37_2019021300.zip\";}','Admin User','unknown',1663490428,1663490428,0,NULL),(19,'da39a3ee5e6b4b0d3255bfef95601890afd80709','a2cd11a636546566ee406db3fb49952da93bbc94',5,'user','draft',944565703,'/','.',2,0,NULL,0,NULL,NULL,NULL,1663490428,1663490428,0,NULL),(20,'5b7b16f9ac0a5fc4276d90fc18532e09900bea1d','43b06d1e3dd76743b279090ec2d7e8c91c524cef',5,'user','draft',535750551,'/','course7.jpg',2,5688,'image/jpeg',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:11:\"course7.jpg\";}','Admin User','unknown',1664514284,1664514284,0,NULL),(21,'da39a3ee5e6b4b0d3255bfef95601890afd80709','6e4875619a20708258e4981d3d563453385254a1',5,'user','draft',535750551,'/','.',2,0,NULL,0,NULL,NULL,NULL,1664514284,1664514284,0,NULL),(22,'4b07701ef9ca5a854472766a99a64521fd5528a0','dfb77d0b65e7b264835d035476c1f6702d685082',1,'core','preview',0,'/thumb/','5b7b16f9ac0a5fc4276d90fc18532e09900bea1d',NULL,6980,'image/png',0,NULL,NULL,NULL,1664514285,1664514285,0,NULL),(23,'da39a3ee5e6b4b0d3255bfef95601890afd80709','74c104d54c05b5f8c633a36da516d37e6c5279e4',1,'core','preview',0,'/thumb/','.',NULL,0,NULL,0,NULL,NULL,NULL,1664514285,1664514285,0,NULL),(24,'da39a3ee5e6b4b0d3255bfef95601890afd80709','884555719c50529b9df662a38619d04b5b11e25c',1,'core','preview',0,'/','.',NULL,0,NULL,0,NULL,NULL,NULL,1664514285,1664514285,0,NULL),(26,'da39a3ee5e6b4b0d3255bfef95601890afd80709','6525e34807c3352a7fe1bfab0f8f336330fc2b64',122,'course','overviewfiles',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1664514284,1664514450,0,NULL),(28,'da39a3ee5e6b4b0d3255bfef95601890afd80709','6f744f1c34ca018132312b53af38f47b1a0b77f1',5,'user','draft',435060590,'/','.',2,0,NULL,0,NULL,NULL,NULL,1664514450,1664514450,0,NULL),(29,'d821060ca92cc7362470309104c4de192df32e0f','5056428f51798a1cdc6d3f7e0a70ea37ee5dc678',5,'user','draft',435060590,'/','c13.jpg',2,7174,'image/jpeg',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:7:\"c13.jpg\";}','Admin User','unknown',1664514458,1664514458,0,NULL),(30,'1797f97d8dbf4e84a3a1edb7258a4105fcf1332f','3eeea56f0da2ffed543f55d039ba9f536d610626',1,'core','preview',0,'/thumb/','d821060ca92cc7362470309104c4de192df32e0f',NULL,7736,'image/png',0,NULL,NULL,NULL,1664514458,1664514458,0,NULL),(31,'d821060ca92cc7362470309104c4de192df32e0f','429361af5e6a8d2cfac4aec1f1051fa9a4be7282',122,'course','overviewfiles',0,'/','c13.jpg',2,7174,'image/jpeg',0,'c13.jpg','Admin User','unknown',1664514458,1664514470,0,NULL),(33,'da39a3ee5e6b4b0d3255bfef95601890afd80709','630eadf27a6a1bb5ecc1dc1a76d5bd650048a48c',5,'user','draft',61371544,'/','.',2,0,NULL,0,NULL,NULL,NULL,1664514490,1664514490,0,NULL),(34,'2a6fda0cd9e8d15d90f2f2147f07e2cbcab8c2c0','b4feb4038c5fa74f1f39eff986ed4eaad1282522',1,'core','preview',0,'/thumb/','8eef1cb14db2705a768bb4ff46e04c24b2880a1f',NULL,12727,'image/png',0,NULL,NULL,NULL,1664514491,1664514491,0,NULL),(36,'da39a3ee5e6b4b0d3255bfef95601890afd80709','cb920ee3e55be4d5558e71acfaf1cca8717c9946',84,'course','overviewfiles',0,'/','.',2,0,NULL,0,NULL,NULL,NULL,1664514490,1664514490,0,NULL),(38,'c472c82f3b5a01e0aa13f62d3abb87665ca8786c','eeb563e38e1bcd789551c03ea997d60f4659062a',5,'user','draft',61371544,'/','course11.jpg',2,37608,'image/jpeg',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:12:\"course11.jpg\";}','Admin User','unknown',1664514526,1664514526,0,NULL),(39,'98c981758c807a498291c334f8f1eb7252b06256','e5ef034fc43e472d044189ef9c67c44c4be58f0b',1,'core','preview',0,'/thumb/','c472c82f3b5a01e0aa13f62d3abb87665ca8786c',NULL,9988,'image/png',0,NULL,NULL,NULL,1664514527,1664514527,0,NULL),(40,'c472c82f3b5a01e0aa13f62d3abb87665ca8786c','60482bf1227d6b21d7a071c7cf6d02bfbbfc6063',84,'course','overviewfiles',0,'/','course11.jpg',2,37608,'image/jpeg',0,'course11.jpg','Admin User','unknown',1664514526,1664514529,0,NULL),(71,'9a1b8317fcb362377a34126af0ccdb702092e48b','a1199cd11fa6ac87c62fc7e2dae54a51db6756e3',79,'tool_recyclebin','recyclebin_coursecat',10,'/','backup.mbz',2,4985,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1665828981,1665828981,0,NULL),(72,'da39a3ee5e6b4b0d3255bfef95601890afd80709','50df5e587fa508dbe2575f8e463380c374b1efd7',79,'tool_recyclebin','recyclebin_coursecat',10,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665828981,1665828981,0,NULL),(137,'e8ae774996b01f9e800bd1792d88e3479bee275f','7e818d7a2fd4580f711856a7167c60e88a0901cb',5,'user','draft',118098864,'/','hy.zip',2,31275527,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:13:\"hierarchy.zip\";}','Admin User','unknown',1665835563,1665835563,0,NULL),(138,'da39a3ee5e6b4b0d3255bfef95601890afd80709','5c9387b1149833b0a0d21f72e7d463febbd2d0b0',5,'user','draft',118098864,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665835564,1665835564,0,NULL),(139,'e8ae774996b01f9e800bd1792d88e3479bee275f','74a7c39ccd9bcf41439dd95b6c31f21e090ef838',5,'user','draft',742745895,'/','hy.zip',2,31275527,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:13:\"hierarchy.zip\";}','Admin User','unknown',1665835634,1665835634,0,NULL),(140,'da39a3ee5e6b4b0d3255bfef95601890afd80709','b01172a326d1763deb4b8e7aa57f32e867a8d509',5,'user','draft',742745895,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665835634,1665835634,0,NULL),(143,'c837beb883c70ae9639bad74a9f7a7cab1ae4bea','0325c162e0fd1c2f79a0dc4e1ce7df39fa3eb577',100,'tool_recyclebin','recyclebin_coursecat',27,'/','backup.mbz',2,2721,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1665987543,1665987543,0,NULL),(144,'da39a3ee5e6b4b0d3255bfef95601890afd80709','8f53efc8a258f416fe8058114bc76f98fdad6e42',100,'tool_recyclebin','recyclebin_coursecat',27,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665987543,1665987543,0,NULL),(147,'59cfce3503b0a2e0309fb45a13704dd76914a5fd','61cf7123fe5c4e4d00c1fb6632467aa3cd233b69',100,'tool_recyclebin','recyclebin_coursecat',28,'/','backup.mbz',2,2727,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1665989035,1665989035,0,NULL),(148,'da39a3ee5e6b4b0d3255bfef95601890afd80709','0410bf6dc8004e047d08bb89ab80a9ecbca56307',100,'tool_recyclebin','recyclebin_coursecat',28,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665989035,1665989035,0,NULL),(151,'1a4c82762e426a6773dacabab0d00d37a435a039','742b02cafeb2227f26aa3e9318b98932611d76eb',100,'tool_recyclebin','recyclebin_coursecat',29,'/','backup.mbz',2,2725,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1665989044,1665989044,0,NULL),(152,'da39a3ee5e6b4b0d3255bfef95601890afd80709','ae1b8888a32ed0e8bb1d09ae273caa39695a0a77',100,'tool_recyclebin','recyclebin_coursecat',29,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665989044,1665989044,0,NULL),(155,'b0c1b3f83f6691678065f3895fa425cba45335e3','62177598031e23dabedc417443d0f7116867531b',100,'tool_recyclebin','recyclebin_coursecat',30,'/','backup.mbz',2,2724,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1665989054,1665989054,0,NULL),(156,'da39a3ee5e6b4b0d3255bfef95601890afd80709','931182bb12ea655d99b484623d8dced97f9c1af6',100,'tool_recyclebin','recyclebin_coursecat',30,'/','.',2,0,NULL,0,NULL,NULL,NULL,1665989054,1665989054,0,NULL),(157,'c0b9369aa6a0d13138755299935d744d3033bfc8','66941427e99feb5a7e316ff6d169a9b2a1041ac2',704,'user','draft',496240682,'/','hierarchy.zip',134,45447,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:13:\"hierarchy.zip\";}','manoharvash manoharvash','unknown',1666008164,1666008164,0,NULL),(158,'da39a3ee5e6b4b0d3255bfef95601890afd80709','dca36ee1b33010c9f84e4d91e0c7f69106c4aa1f',704,'user','draft',496240682,'/','.',134,0,NULL,0,NULL,NULL,NULL,1666008164,1666008164,0,NULL),(161,'fa516ca0067275e888dd3ad29d196478e2067686','04b298bfed83cf5c9c0e8de3856b8d328f28059d',87,'tool_recyclebin','recyclebin_coursecat',31,'/','backup.mbz',2,2697,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1666010117,1666010117,0,NULL),(162,'da39a3ee5e6b4b0d3255bfef95601890afd80709','bbf8dfdb676ea91560290b8d8d2ed55c47643e37',87,'tool_recyclebin','recyclebin_coursecat',31,'/','.',2,0,NULL,0,NULL,NULL,NULL,1666010117,1666010117,0,NULL),(163,'d09ef7b8a362ebf60a42d675d233a2c8782a8d4c','1c5ff8c8bbfb60515417b2374fb6736ec1775d44',5,'user','draft',685884188,'/','hierarchy.zip',2,31349481,'application/zip',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:13:\"hierarchy.zip\";}','Admin User','unknown',1666013662,1666013662,0,NULL),(164,'da39a3ee5e6b4b0d3255bfef95601890afd80709','f5a0e1dea58f61cb56cc9c0dcc835f8a70838a90',5,'user','draft',685884188,'/','.',2,0,NULL,0,NULL,NULL,NULL,1666013663,1666013663,0,NULL),(167,'e25fbaabc9caf76bf9b0757cc06ea25055f61d8c','ec143feeea69d699882b866f8c6bdbd7093fe5d6',100,'tool_recyclebin','recyclebin_coursecat',32,'/','backup.mbz',2,3004,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1666020873,1666020873,0,NULL),(168,'da39a3ee5e6b4b0d3255bfef95601890afd80709','9ee17a5734d1d61c2728602ec05d47209871b72f',100,'tool_recyclebin','recyclebin_coursecat',32,'/','.',2,0,NULL,0,NULL,NULL,NULL,1666020873,1666020873,0,NULL),(171,'bff6a8932d36e2dac912b8b3ab5b73cd6bc1b644','a71bf008eccb6a8aee8c225563d73bdf80bf57dd',304,'tool_recyclebin','recyclebin_coursecat',33,'/','backup.mbz',2,2677,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1666020964,1666020964,0,NULL),(172,'da39a3ee5e6b4b0d3255bfef95601890afd80709','93cc923bc6640e8b4b71a5483d45ee8d2adf8527',304,'tool_recyclebin','recyclebin_coursecat',33,'/','.',2,0,NULL,0,NULL,NULL,NULL,1666020964,1666020964,0,NULL),(175,'930198f665e22b0a25d4ba7ae101ab48e482eb29','93d8e793e4ddf725aef315f3ca0875649e8a9fbd',85,'tool_recyclebin','recyclebin_coursecat',34,'/','backup.mbz',2,10700,'application/vnd.moodle.backup',0,NULL,NULL,NULL,1666067413,1666067413,0,NULL),(176,'da39a3ee5e6b4b0d3255bfef95601890afd80709','4ecac5e9c36e2f7779c52d2ecf373ce3367c903f',85,'tool_recyclebin','recyclebin_coursecat',34,'/','.',2,0,NULL,0,NULL,NULL,NULL,1666067413,1666067413,0,NULL),(177,'2a63d1cca1924b5d18f21558ed3c50bb5d843506','ad11344599a47cac6544c24b3f46f05e5009de30',820,'user','draft',392758181,'/','Test assignment1.docx',151,9851,'application/vnd.openxmlformats-officedocument.wordprocessingml.document',0,'O:8:\"stdClass\":1:{s:6:\"source\";s:21:\"Test assignment1.docx\";}','student_a2 test','unknown',1666078541,1666078541,0,NULL),(178,'da39a3ee5e6b4b0d3255bfef95601890afd80709','092448154b6c7fe8d44613965e694bc2c7f1a8c3',820,'user','draft',392758181,'/','.',151,0,NULL,0,NULL,NULL,NULL,1666078541,1666078541,0,NULL),(179,'2a63d1cca1924b5d18f21558ed3c50bb5d843506','8530d46d4285e8e3a5bbfa6c2692b718aa4c4fa0',808,'assignsubmission_file','submission_files',1,'/','Test assignment1.docx',151,9851,'application/vnd.openxmlformats-officedocument.wordprocessingml.document',0,'Test assignment1.docx','student_a2 test','unknown',1666078541,1666078544,0,NULL),(180,'da39a3ee5e6b4b0d3255bfef95601890afd80709','7d847e68b5411183c3d95ce27ad0a2d0b0cabbb5',808,'assignsubmission_file','submission_files',1,'/','.',151,0,NULL,0,NULL,NULL,NULL,1666078541,1666078544,0,NULL);
/*!40000 ALTER TABLE `mdl_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_files_reference`
--

DROP TABLE IF EXISTS `mdl_files_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_files_reference` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `repositoryid` bigint(10) NOT NULL,
  `lastsync` bigint(10) DEFAULT NULL,
  `reference` longtext COLLATE utf8mb4_unicode_ci,
  `referencehash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_filerefe_refrep_uix` (`referencehash`,`repositoryid`),
  KEY `mdl_filerefe_rep_ix` (`repositoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Store files references';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_files_reference`
--

LOCK TABLES `mdl_files_reference` WRITE;
/*!40000 ALTER TABLE `mdl_files_reference` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_files_reference` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_filter_active`
--

DROP TABLE IF EXISTS `mdl_filter_active`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_filter_active` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `active` smallint(4) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_filtacti_confil_uix` (`contextid`,`filter`),
  KEY `mdl_filtacti_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores information about which filters are active in which c';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_filter_active`
--

LOCK TABLES `mdl_filter_active` WRITE;
/*!40000 ALTER TABLE `mdl_filter_active` DISABLE KEYS */;
INSERT INTO `mdl_filter_active` VALUES (1,'activitynames',1,1,2),(2,'displayh5p',1,1,1),(3,'emoticon',1,1,4),(4,'mathjaxloader',1,1,3),(5,'mediaplugin',1,1,6),(6,'urltolink',1,1,5);
/*!40000 ALTER TABLE `mdl_filter_active` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_filter_config`
--

DROP TABLE IF EXISTS `mdl_filter_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_filter_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_filtconf_confilnam_uix` (`contextid`,`filter`,`name`),
  KEY `mdl_filtconf_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores per-context configuration settings for filters which ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_filter_config`
--

LOCK TABLES `mdl_filter_config` WRITE;
/*!40000 ALTER TABLE `mdl_filter_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_filter_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_folder`
--

DROP TABLE IF EXISTS `mdl_folder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_folder` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `showexpanded` tinyint(1) NOT NULL DEFAULT '1',
  `showdownloadfolder` tinyint(1) NOT NULL DEFAULT '1',
  `forcedownload` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_fold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='each record is one folder resource';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_folder`
--

LOCK TABLES `mdl_folder` WRITE;
/*!40000 ALTER TABLE `mdl_folder` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_folder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum`
--

DROP TABLE IF EXISTS `mdl_forum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `grade_forum` bigint(10) NOT NULL DEFAULT '0',
  `grade_forum_notify` smallint(4) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `maxattachments` bigint(10) NOT NULL DEFAULT '1',
  `forcesubscribe` tinyint(1) NOT NULL DEFAULT '0',
  `trackingtype` tinyint(2) NOT NULL DEFAULT '1',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `warnafter` bigint(10) NOT NULL DEFAULT '0',
  `blockafter` bigint(10) NOT NULL DEFAULT '0',
  `blockperiod` bigint(10) NOT NULL DEFAULT '0',
  `completiondiscussions` int(9) NOT NULL DEFAULT '0',
  `completionreplies` int(9) NOT NULL DEFAULT '0',
  `completionposts` int(9) NOT NULL DEFAULT '0',
  `displaywordcount` tinyint(1) NOT NULL DEFAULT '0',
  `lockdiscussionafter` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_foru_cou_ix` (`course`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Forums contain and structure discussion';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum`
--

LOCK TABLES `mdl_forum` WRITE;
/*!40000 ALTER TABLE `mdl_forum` DISABLE KEYS */;
INSERT INTO `mdl_forum` VALUES (1,2,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663313160,0,0,0,0,0,0,0,0),(2,3,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663313175,0,0,0,0,0,0,0,0),(3,4,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663313192,0,0,0,0,0,0,0,0),(4,5,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663313597,0,0,0,0,0,0,0,0),(5,6,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663313614,0,0,0,0,0,0,0,0),(6,7,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663313643,0,0,0,0,0,0,0,0),(9,10,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663333541,0,0,0,0,0,0,0,0),(10,11,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663336491,0,0,0,0,0,0,0,0),(11,12,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663337245,0,0,0,0,0,0,0,0),(13,14,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663338525,0,0,0,0,0,0,0,0),(15,16,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663427048,0,0,0,0,0,0,0,0),(16,17,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663519142,0,0,0,0,0,0,0,0),(17,18,'news','rr','<table>\r\n    <tbody><tr><td>Magazzini Alimentari Riuniti</td>\r\n  </tr>\r\n  <tr>\r\n    <td>Magazzini Alimentari Riuniti</td>\r\n  </tr>\r\n</tbody></table>',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1663745763,0,0,0,0,0,0,0,0),(21,22,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1664734735,0,0,0,0,0,0,0,0),(23,24,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665246824,0,0,0,0,0,0,0,0),(27,29,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665393318,0,0,0,0,0,0,0,0),(30,48,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665987277,0,0,0,0,0,0,0,0),(31,49,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665988040,0,0,0,0,0,0,0,0),(32,50,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665988072,0,0,0,0,0,0,0,0),(33,54,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665989236,0,0,0,0,0,0,0,0),(34,56,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665989545,0,0,0,0,0,0,0,0),(35,57,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665996674,0,0,0,0,0,0,0,0),(36,58,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665996712,0,0,0,0,0,0,0,0),(37,59,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665997648,0,0,0,0,0,0,0,0),(38,60,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665999621,0,0,0,0,0,0,0,0),(39,61,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1665999912,0,0,0,0,0,0,0,0),(40,62,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666000315,0,0,0,0,0,0,0,0),(41,64,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666000591,0,0,0,0,0,0,0,0),(42,65,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666001199,0,0,0,0,0,0,0,0),(43,66,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666010345,0,0,0,0,0,0,0,0),(44,67,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666010480,0,0,0,0,0,0,0,0),(45,68,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666010590,0,0,0,0,0,0,0,0),(46,69,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666011949,0,0,0,0,0,0,0,0),(47,70,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666012450,0,0,0,0,0,0,0,0),(48,71,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666013158,0,0,0,0,0,0,0,0),(49,72,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666067361,0,0,0,0,0,0,0,0),(50,73,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666067895,0,0,0,0,0,0,0,0),(51,74,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666068000,0,0,0,0,0,0,0,0),(52,75,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666079283,0,0,0,0,0,0,0,0),(53,76,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666079436,0,0,0,0,0,0,0,0),(54,77,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666079937,0,0,0,0,0,0,0,0),(55,78,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666086650,0,0,0,0,0,0,0,0),(56,79,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666087243,0,0,0,0,0,0,0,0),(57,80,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666088385,0,0,0,0,0,0,0,0),(58,81,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666241670,0,0,0,0,0,0,0,0),(59,82,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666245646,0,0,0,0,0,0,0,0),(60,83,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666247569,0,0,0,0,0,0,0,0),(61,84,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666266070,0,0,0,0,0,0,0,0),(62,85,'news','Announcements','General news and announcements',1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1666286521,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `mdl_forum` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_digests`
--

DROP TABLE IF EXISTS `mdl_forum_digests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_digests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `forum` bigint(10) NOT NULL,
  `maildigest` tinyint(1) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forudige_forusemai_uix` (`forum`,`userid`,`maildigest`),
  KEY `mdl_forudige_use_ix` (`userid`),
  KEY `mdl_forudige_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of user mail delivery preferences for each forum';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_digests`
--

LOCK TABLES `mdl_forum_digests` WRITE;
/*!40000 ALTER TABLE `mdl_forum_digests` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_digests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_discussion_subs`
--

DROP TABLE IF EXISTS `mdl_forum_discussion_subs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_discussion_subs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `forum` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `discussion` bigint(10) NOT NULL,
  `preference` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forudiscsubs_usedis_uix` (`userid`,`discussion`),
  KEY `mdl_forudiscsubs_for_ix` (`forum`),
  KEY `mdl_forudiscsubs_use_ix` (`userid`),
  KEY `mdl_forudiscsubs_dis_ix` (`discussion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Users may choose to subscribe and unsubscribe from specific ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_discussion_subs`
--

LOCK TABLES `mdl_forum_discussion_subs` WRITE;
/*!40000 ALTER TABLE `mdl_forum_discussion_subs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_discussion_subs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_discussions`
--

DROP TABLE IF EXISTS `mdl_forum_discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_discussions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `firstpost` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '-1',
  `assessed` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  `timelocked` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_forudisc_use_ix` (`userid`),
  KEY `mdl_forudisc_cou_ix` (`course`),
  KEY `mdl_forudisc_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Forums are composed of discussions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_discussions`
--

LOCK TABLES `mdl_forum_discussions` WRITE;
/*!40000 ALTER TABLE `mdl_forum_discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_discussions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_grades`
--

DROP TABLE IF EXISTS `mdl_forum_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `forum` bigint(10) NOT NULL,
  `itemnumber` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `grade` decimal(10,5) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forugrad_foriteuse_uix` (`forum`,`itemnumber`,`userid`),
  KEY `mdl_forugrad_use_ix` (`userid`),
  KEY `mdl_forugrad_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Grading data for forum instances';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_grades`
--

LOCK TABLES `mdl_forum_grades` WRITE;
/*!40000 ALTER TABLE `mdl_forum_grades` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_posts`
--

DROP TABLE IF EXISTS `mdl_forum_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_posts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `discussion` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `created` bigint(10) NOT NULL DEFAULT '0',
  `modified` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(2) NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `messageformat` tinyint(2) NOT NULL DEFAULT '0',
  `messagetrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `totalscore` smallint(4) NOT NULL DEFAULT '0',
  `mailnow` bigint(10) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `privatereplyto` bigint(10) NOT NULL DEFAULT '0',
  `wordcount` bigint(20) DEFAULT NULL,
  `charcount` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_forupost_use_ix` (`userid`),
  KEY `mdl_forupost_cre_ix` (`created`),
  KEY `mdl_forupost_mai_ix` (`mailed`),
  KEY `mdl_forupost_pri_ix` (`privatereplyto`),
  KEY `mdl_forupost_dis_ix` (`discussion`),
  KEY `mdl_forupost_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='All posts are stored in this table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_posts`
--

LOCK TABLES `mdl_forum_posts` WRITE;
/*!40000 ALTER TABLE `mdl_forum_posts` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_queue`
--

DROP TABLE IF EXISTS `mdl_forum_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_foruqueu_use_ix` (`userid`),
  KEY `mdl_foruqueu_dis_ix` (`discussionid`),
  KEY `mdl_foruqueu_pos_ix` (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='For keeping track of posts that will be mailed in digest for';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_queue`
--

LOCK TABLES `mdl_forum_queue` WRITE;
/*!40000 ALTER TABLE `mdl_forum_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_read`
--

DROP TABLE IF EXISTS `mdl_forum_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_read` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `firstread` bigint(10) NOT NULL DEFAULT '0',
  `lastread` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_foruread_usefor_ix` (`userid`,`forumid`),
  KEY `mdl_foruread_usedis_ix` (`userid`,`discussionid`),
  KEY `mdl_foruread_posuse_ix` (`postid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks each users read posts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_read`
--

LOCK TABLES `mdl_forum_read` WRITE;
/*!40000 ALTER TABLE `mdl_forum_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_subscriptions`
--

DROP TABLE IF EXISTS `mdl_forum_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_forusubs_usefor_uix` (`userid`,`forum`),
  KEY `mdl_forusubs_use_ix` (`userid`),
  KEY `mdl_forusubs_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Keeps track of who is subscribed to what forum';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_subscriptions`
--

LOCK TABLES `mdl_forum_subscriptions` WRITE;
/*!40000 ALTER TABLE `mdl_forum_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_forum_track_prefs`
--

DROP TABLE IF EXISTS `mdl_forum_track_prefs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_forum_track_prefs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_forutracpref_usefor_ix` (`userid`,`forumid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Tracks each users untracked forums';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_forum_track_prefs`
--

LOCK TABLES `mdl_forum_track_prefs` WRITE;
/*!40000 ALTER TABLE `mdl_forum_track_prefs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_forum_track_prefs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary`
--

DROP TABLE IF EXISTS `mdl_glossary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `intro` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `allowduplicatedentries` tinyint(2) NOT NULL DEFAULT '0',
  `displayformat` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dictionary',
  `mainglossary` tinyint(2) NOT NULL DEFAULT '0',
  `showspecial` tinyint(2) NOT NULL DEFAULT '1',
  `showalphabet` tinyint(2) NOT NULL DEFAULT '1',
  `showall` tinyint(2) NOT NULL DEFAULT '1',
  `allowcomments` tinyint(2) NOT NULL DEFAULT '0',
  `allowprintview` tinyint(2) NOT NULL DEFAULT '1',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `defaultapproval` tinyint(2) NOT NULL DEFAULT '1',
  `approvaldisplayformat` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `globalglossary` tinyint(2) NOT NULL DEFAULT '0',
  `entbypage` smallint(3) NOT NULL DEFAULT '10',
  `editalways` tinyint(2) NOT NULL DEFAULT '0',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionentries` int(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_glos_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all glossaries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary`
--

LOCK TABLES `mdl_glossary` WRITE;
/*!40000 ALTER TABLE `mdl_glossary` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_alias`
--

DROP TABLE IF EXISTS `mdl_glossary_alias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_alias` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mdl_glosalia_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='entries alias';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_alias`
--

LOCK TABLES `mdl_glossary_alias` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_alias` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_alias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_categories`
--

DROP TABLE IF EXISTS `mdl_glossary_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_gloscate_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all categories for glossary entries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_categories`
--

LOCK TABLES `mdl_glossary_categories` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_entries`
--

DROP TABLE IF EXISTS `mdl_glossary_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_entries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `concept` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `definition` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `definitionformat` tinyint(2) NOT NULL DEFAULT '0',
  `definitiontrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `teacherentry` tinyint(2) NOT NULL DEFAULT '0',
  `sourceglossaryid` bigint(10) NOT NULL DEFAULT '0',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `casesensitive` tinyint(2) NOT NULL DEFAULT '0',
  `fullmatch` tinyint(2) NOT NULL DEFAULT '1',
  `approved` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `mdl_glosentr_use_ix` (`userid`),
  KEY `mdl_glosentr_con_ix` (`concept`),
  KEY `mdl_glosentr_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='all glossary entries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_entries`
--

LOCK TABLES `mdl_glossary_entries` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_entries_categories`
--

DROP TABLE IF EXISTS `mdl_glossary_entries_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_entries_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_glosentrcate_cat_ix` (`categoryid`),
  KEY `mdl_glosentrcate_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='categories of each glossary entry';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_entries_categories`
--

LOCK TABLES `mdl_glossary_entries_categories` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_entries_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_glossary_entries_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_glossary_formats`
--

DROP TABLE IF EXISTS `mdl_glossary_formats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_glossary_formats` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `popupformatname` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `showgroup` tinyint(2) NOT NULL DEFAULT '1',
  `showtabs` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `defaultmode` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `defaulthook` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortkey` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortorder` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Setting of the display formats';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_glossary_formats`
--

LOCK TABLES `mdl_glossary_formats` WRITE;
/*!40000 ALTER TABLE `mdl_glossary_formats` DISABLE KEYS */;
INSERT INTO `mdl_glossary_formats` VALUES (1,'continuous','continuous',1,1,'standard,category,date','','','',''),(2,'dictionary','dictionary',1,1,'standard','','','',''),(3,'encyclopedia','encyclopedia',1,1,'standard,category,date,author','','','',''),(4,'entrylist','entrylist',1,1,'standard,category,date,author','','','',''),(5,'faq','faq',1,1,'standard,category,date,author','','','',''),(6,'fullwithauthor','fullwithauthor',1,1,'standard,category,date,author','','','',''),(7,'fullwithoutauthor','fullwithoutauthor',1,1,'standard,category,date','','','','');
/*!40000 ALTER TABLE `mdl_glossary_formats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_categories`
--

DROP TABLE IF EXISTS `mdl_grade_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradcate_cou_ix` (`courseid`),
  KEY `mdl_gradcate_par_ix` (`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about categories, used for grou';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_categories`
--

LOCK TABLES `mdl_grade_categories` WRITE;
/*!40000 ALTER TABLE `mdl_grade_categories` DISABLE KEYS */;
INSERT INTO `mdl_grade_categories` VALUES (3,12,NULL,1,'/3/','?',13,0,0,1,0,1663489758,1663489758,0),(4,18,NULL,1,'/4/','?',13,0,0,1,0,1663745536,1663745537,0),(37,73,NULL,1,'/37/','?',13,0,0,1,0,1666076157,1666076157,0),(38,2,NULL,1,'/38/','?',13,0,0,1,0,1666076614,1666076614,0);
/*!40000 ALTER TABLE `mdl_grade_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_categories_history`
--

DROP TABLE IF EXISTS `mdl_grade_categories_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_categories_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradcatehist_act_ix` (`action`),
  KEY `mdl_gradcatehist_tim_ix` (`timemodified`),
  KEY `mdl_gradcatehist_old_ix` (`oldid`),
  KEY `mdl_gradcatehist_cou_ix` (`courseid`),
  KEY `mdl_gradcatehist_par_ix` (`parent`),
  KEY `mdl_gradcatehist_log_ix` (`loggeduser`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History of grade_categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_categories_history`
--

LOCK TABLES `mdl_grade_categories_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_categories_history` DISABLE KEYS */;
INSERT INTO `mdl_grade_categories_history` VALUES (1,1,1,'system',1663413570,2,9,NULL,0,NULL,'?',13,0,0,1,0,0,0),(2,2,1,'system',1663413570,2,9,NULL,1,'/1/','?',13,0,0,1,0,0,0),(3,3,1,'coursedelete',1663413570,2,9,NULL,1,'/1/','?',13,0,0,1,0,0,0),(4,1,2,'system',1663413577,2,8,NULL,0,NULL,'?',13,0,0,1,0,0,0),(5,2,2,'system',1663413577,2,8,NULL,1,'/2/','?',13,0,0,1,0,0,0),(6,3,2,'coursedelete',1663413577,2,8,NULL,1,'/2/','?',13,0,0,1,0,0,0),(7,1,3,'system',1663489758,2,12,NULL,0,NULL,'?',13,0,0,1,0,0,0),(8,2,3,'system',1663489758,2,12,NULL,1,'/3/','?',13,0,0,1,0,0,0),(9,1,4,'system',1663745536,2,18,NULL,0,NULL,'?',13,0,0,1,0,0,0),(10,2,4,'system',1663745537,2,18,NULL,1,'/4/','?',13,0,0,1,0,0,0),(11,1,5,'system',1664634291,2,21,NULL,0,NULL,'?',13,0,0,1,0,0,0),(12,2,5,'system',1664634291,2,21,NULL,1,'/5/','?',13,0,0,1,0,0,0),(13,3,5,'coursedelete',1664634291,2,21,NULL,1,'/5/','?',13,0,0,1,0,0,0),(14,1,6,'system',1665392057,2,26,NULL,0,NULL,'?',13,0,0,1,0,0,0),(15,2,6,'system',1665392057,2,26,NULL,1,'/6/','?',13,0,0,1,0,0,0),(16,3,6,'coursedelete',1665392057,2,26,NULL,1,'/6/','?',13,0,0,1,0,0,0),(17,1,7,'system',1665392057,2,25,NULL,0,NULL,'?',13,0,0,1,0,0,0),(18,2,7,'system',1665392057,2,25,NULL,1,'/7/','?',13,0,0,1,0,0,0),(19,3,7,'coursedelete',1665392057,2,25,NULL,1,'/7/','?',13,0,0,1,0,0,0),(20,1,8,'system',1665392082,2,23,NULL,0,NULL,'?',13,0,0,1,0,0,0),(21,2,8,'system',1665392082,2,23,NULL,1,'/8/','?',13,0,0,1,0,0,0),(22,3,8,'coursedelete',1665392082,2,23,NULL,1,'/8/','?',13,0,0,1,0,0,0),(23,1,9,'system',1665392148,2,19,NULL,0,NULL,'?',13,0,0,1,0,0,0),(24,2,9,'system',1665392148,2,19,NULL,1,'/9/','?',13,0,0,1,0,0,0),(25,3,9,'coursedelete',1665392148,2,19,NULL,1,'/9/','?',13,0,0,1,0,0,0),(26,1,10,'system',1665392149,2,20,NULL,0,NULL,'?',13,0,0,1,0,0,0),(27,2,10,'system',1665392149,2,20,NULL,1,'/10/','?',13,0,0,1,0,0,0),(28,3,10,'coursedelete',1665392149,2,20,NULL,1,'/10/','?',13,0,0,1,0,0,0),(29,1,11,'system',1665398421,2,41,NULL,0,NULL,'?',13,0,0,1,0,0,0),(30,2,11,'system',1665398421,2,41,NULL,1,'/11/','?',13,0,0,1,0,0,0),(31,3,11,'coursedelete',1665398421,2,41,NULL,1,'/11/','?',13,0,0,1,0,0,0),(32,1,12,'system',1665827127,2,44,NULL,0,NULL,'?',13,0,0,1,0,0,0),(33,2,12,'system',1665827127,2,44,NULL,1,'/12/','?',13,0,0,1,0,0,0),(34,3,12,'coursedelete',1665828981,2,44,NULL,1,'/12/','?',13,0,0,1,0,0,0),(35,1,13,'system',1665829381,2,31,NULL,0,NULL,'?',13,0,0,1,0,0,0),(36,2,13,'system',1665829381,2,31,NULL,1,'/13/','?',13,0,0,1,0,0,0),(37,3,13,'coursedelete',1665829381,2,31,NULL,1,'/13/','?',13,0,0,1,0,0,0),(38,1,14,'system',1665829450,2,32,NULL,0,NULL,'?',13,0,0,1,0,0,0),(39,2,14,'system',1665829450,2,32,NULL,1,'/14/','?',13,0,0,1,0,0,0),(40,3,14,'coursedelete',1665829450,2,32,NULL,1,'/14/','?',13,0,0,1,0,0,0),(41,1,15,'system',1665829550,2,42,NULL,0,NULL,'?',13,0,0,1,0,0,0),(42,2,15,'system',1665829550,2,42,NULL,1,'/15/','?',13,0,0,1,0,0,0),(43,3,15,'coursedelete',1665829550,2,42,NULL,1,'/15/','?',13,0,0,1,0,0,0),(44,1,16,'system',1665829550,2,39,NULL,0,NULL,'?',13,0,0,1,0,0,0),(45,2,16,'system',1665829550,2,39,NULL,1,'/16/','?',13,0,0,1,0,0,0),(46,3,16,'coursedelete',1665829550,2,39,NULL,1,'/16/','?',13,0,0,1,0,0,0),(47,1,17,'system',1665829550,2,38,NULL,0,NULL,'?',13,0,0,1,0,0,0),(48,2,17,'system',1665829550,2,38,NULL,1,'/17/','?',13,0,0,1,0,0,0),(49,3,17,'coursedelete',1665829550,2,38,NULL,1,'/17/','?',13,0,0,1,0,0,0),(50,1,18,'system',1665829550,2,37,NULL,0,NULL,'?',13,0,0,1,0,0,0),(51,2,18,'system',1665829550,2,37,NULL,1,'/18/','?',13,0,0,1,0,0,0),(52,3,18,'coursedelete',1665829550,2,37,NULL,1,'/18/','?',13,0,0,1,0,0,0),(53,1,19,'system',1665829551,2,36,NULL,0,NULL,'?',13,0,0,1,0,0,0),(54,2,19,'system',1665829551,2,36,NULL,1,'/19/','?',13,0,0,1,0,0,0),(55,3,19,'coursedelete',1665829551,2,36,NULL,1,'/19/','?',13,0,0,1,0,0,0),(56,1,20,'system',1665829551,2,35,NULL,0,NULL,'?',13,0,0,1,0,0,0),(57,2,20,'system',1665829551,2,35,NULL,1,'/20/','?',13,0,0,1,0,0,0),(58,3,20,'coursedelete',1665829551,2,35,NULL,1,'/20/','?',13,0,0,1,0,0,0),(59,1,21,'system',1665829551,2,34,NULL,0,NULL,'?',13,0,0,1,0,0,0),(60,2,21,'system',1665829551,2,34,NULL,1,'/21/','?',13,0,0,1,0,0,0),(61,3,21,'coursedelete',1665829551,2,34,NULL,1,'/21/','?',13,0,0,1,0,0,0),(62,1,22,'system',1665829551,2,30,NULL,0,NULL,'?',13,0,0,1,0,0,0),(63,2,22,'system',1665829551,2,30,NULL,1,'/22/','?',13,0,0,1,0,0,0),(64,3,22,'coursedelete',1665829551,2,30,NULL,1,'/22/','?',13,0,0,1,0,0,0),(65,1,23,'system',1665829551,2,13,NULL,0,NULL,'?',13,0,0,1,0,0,0),(66,2,23,'system',1665829551,2,13,NULL,1,'/23/','?',13,0,0,1,0,0,0),(67,3,23,'coursedelete',1665829551,2,13,NULL,1,'/23/','?',13,0,0,1,0,0,0),(68,1,24,'system',1665831457,2,33,NULL,0,NULL,'?',13,0,0,1,0,0,0),(69,2,24,'system',1665831457,2,33,NULL,1,'/24/','?',13,0,0,1,0,0,0),(70,3,24,'coursedelete',1665831457,2,33,NULL,1,'/24/','?',13,0,0,1,0,0,0),(71,1,25,'system',1665831457,2,28,NULL,0,NULL,'?',13,0,0,1,0,0,0),(72,2,25,'system',1665831457,2,28,NULL,1,'/25/','?',13,0,0,1,0,0,0),(73,3,25,'coursedelete',1665831457,2,28,NULL,1,'/25/','?',13,0,0,1,0,0,0),(74,1,26,'system',1665831457,2,27,NULL,0,NULL,'?',13,0,0,1,0,0,0),(75,2,26,'system',1665831457,2,27,NULL,1,'/26/','?',13,0,0,1,0,0,0),(76,3,26,'coursedelete',1665831457,2,27,NULL,1,'/26/','?',13,0,0,1,0,0,0),(77,1,27,'system',1665831855,2,43,NULL,0,NULL,'?',13,0,0,1,0,0,0),(78,2,27,'system',1665831855,2,43,NULL,1,'/27/','?',13,0,0,1,0,0,0),(79,3,27,'coursedelete',1665831855,2,43,NULL,1,'/27/','?',13,0,0,1,0,0,0),(80,1,28,'system',1665831855,2,40,NULL,0,NULL,'?',13,0,0,1,0,0,0),(81,2,28,'system',1665831855,2,40,NULL,1,'/28/','?',13,0,0,1,0,0,0),(82,3,28,'coursedelete',1665831855,2,40,NULL,1,'/28/','?',13,0,0,1,0,0,0),(83,1,29,'system',1665987543,2,47,NULL,0,NULL,'?',13,0,0,1,0,0,0),(84,2,29,'system',1665987543,2,47,NULL,1,'/29/','?',13,0,0,1,0,0,0),(85,3,29,'coursedelete',1665987543,2,47,NULL,1,'/29/','?',13,0,0,1,0,0,0),(86,1,30,'system',1665989035,2,53,NULL,0,NULL,'?',13,0,0,1,0,0,0),(87,2,30,'system',1665989035,2,53,NULL,1,'/30/','?',13,0,0,1,0,0,0),(88,3,30,'coursedelete',1665989035,2,53,NULL,1,'/30/','?',13,0,0,1,0,0,0),(89,1,31,'system',1665989044,2,52,NULL,0,NULL,'?',13,0,0,1,0,0,0),(90,2,31,'system',1665989044,2,52,NULL,1,'/31/','?',13,0,0,1,0,0,0),(91,3,31,'coursedelete',1665989044,2,52,NULL,1,'/31/','?',13,0,0,1,0,0,0),(92,1,32,'system',1665989054,2,51,NULL,0,NULL,'?',13,0,0,1,0,0,0),(93,2,32,'system',1665989054,2,51,NULL,1,'/32/','?',13,0,0,1,0,0,0),(94,3,32,'coursedelete',1665989054,2,51,NULL,1,'/32/','?',13,0,0,1,0,0,0),(95,1,33,'system',1666010117,2,63,NULL,0,NULL,'?',13,0,0,1,0,0,0),(96,2,33,'system',1666010117,2,63,NULL,1,'/33/','?',13,0,0,1,0,0,0),(97,3,33,'coursedelete',1666010117,2,63,NULL,1,'/33/','?',13,0,0,1,0,0,0),(98,1,34,'system',1666020873,2,55,NULL,0,NULL,'?',13,0,0,1,0,0,0),(99,2,34,'system',1666020873,2,55,NULL,1,'/34/','?',13,0,0,1,0,0,0),(100,3,34,'coursedelete',1666020873,2,55,NULL,1,'/34/','?',13,0,0,1,0,0,0),(101,1,35,'system',1666020964,2,46,NULL,0,NULL,'?',13,0,0,1,0,0,0),(102,2,35,'system',1666020964,2,46,NULL,1,'/35/','?',13,0,0,1,0,0,0),(103,3,35,'coursedelete',1666020964,2,46,NULL,1,'/35/','?',13,0,0,1,0,0,0),(104,1,36,'system',1666067413,2,15,NULL,0,NULL,'?',13,0,0,1,0,0,0),(105,2,36,'system',1666067413,2,15,NULL,1,'/36/','?',13,0,0,1,0,0,0),(106,3,36,'coursedelete',1666067413,2,15,NULL,1,'/36/','?',13,0,0,1,0,0,0),(107,1,37,'system',1666076157,2,73,NULL,0,NULL,'?',13,0,0,1,0,0,0),(108,2,37,'system',1666076157,2,73,NULL,1,'/37/','?',13,0,0,1,0,0,0),(109,1,38,'system',1666076614,2,2,NULL,0,NULL,'?',13,0,0,1,0,0,0),(110,2,38,'system',1666076614,2,2,NULL,1,'/38/','?',13,0,0,1,0,0,0);
/*!40000 ALTER TABLE `mdl_grade_categories_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_grades`
--

DROP TABLE IF EXISTS `mdl_grade_grades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext COLLATE utf8mb4_unicode_ci,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `aggregationstatus` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unknown',
  `aggregationweight` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradgrad_useite_uix` (`userid`,`itemid`),
  KEY `mdl_gradgrad_locloc_ix` (`locked`,`locktime`),
  KEY `mdl_gradgrad_ite_ix` (`itemid`),
  KEY `mdl_gradgrad_use_ix` (`userid`),
  KEY `mdl_gradgrad_raw_ix` (`rawscaleid`),
  KEY `mdl_gradgrad_use2_ix` (`usermodified`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='grade_grades  This table keeps individual grades for each us';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_grades`
--

LOCK TABLES `mdl_grade_grades` WRITE;
/*!40000 ALTER TABLE `mdl_grade_grades` DISABLE KEYS */;
INSERT INTO `mdl_grade_grades` VALUES (1,5,47,NULL,10.00000,0.00000,NULL,47,NULL,0,0,0,0,0,0,NULL,0,NULL,0,NULL,NULL,'novalue',0.00000),(2,3,47,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0,NULL,NULL,'unknown',NULL),(3,6,47,NULL,10.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0,NULL,NULL,'novalue',0.00000),(4,43,151,NULL,100.00000,0.00000,NULL,151,NULL,0,0,0,0,0,0,NULL,0,NULL,0,1666078544,NULL,'novalue',0.00000),(5,42,151,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0,NULL,NULL,'unknown',NULL),(6,44,151,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0,NULL,NULL,'novalue',0.00000);
/*!40000 ALTER TABLE `mdl_grade_grades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_grades_history`
--

DROP TABLE IF EXISTS `mdl_grade_grades_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_grades_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext COLLATE utf8mb4_unicode_ci,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradgradhist_act_ix` (`action`),
  KEY `mdl_gradgradhist_tim_ix` (`timemodified`),
  KEY `mdl_gradgradhist_useitetim_ix` (`userid`,`itemid`,`timemodified`),
  KEY `mdl_gradgradhist_old_ix` (`oldid`),
  KEY `mdl_gradgradhist_ite_ix` (`itemid`),
  KEY `mdl_gradgradhist_use_ix` (`userid`),
  KEY `mdl_gradgradhist_raw_ix` (`rawscaleid`),
  KEY `mdl_gradgradhist_use2_ix` (`usermodified`),
  KEY `mdl_gradgradhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_grades_history`
--

LOCK TABLES `mdl_grade_grades_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_grades_history` DISABLE KEYS */;
INSERT INTO `mdl_grade_grades_history` VALUES (1,1,1,'mod/quiz',1664260171,47,5,47,NULL,10.00000,0.00000,NULL,47,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(2,1,2,'system',1664260171,47,3,47,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(3,1,3,'system',1664260297,47,6,47,NULL,10.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(4,1,4,'mod/assign',1666078544,151,43,151,NULL,100.00000,0.00000,NULL,151,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(5,1,5,'system',1666078544,151,42,151,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0),(6,1,6,'system',1666156208,2,44,151,NULL,100.00000,0.00000,NULL,NULL,NULL,0,0,0,0,0,0,NULL,0,NULL,0);
/*!40000 ALTER TABLE `mdl_grade_grades_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_import_newitem`
--

DROP TABLE IF EXISTS `mdl_grade_import_newitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_import_newitem` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradimponewi_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='temporary table for storing new grade_item names from grade ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_import_newitem`
--

LOCK TABLES `mdl_grade_import_newitem` WRITE;
/*!40000 ALTER TABLE `mdl_grade_import_newitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_import_newitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_import_values`
--

DROP TABLE IF EXISTS `mdl_grade_import_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_import_values` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) DEFAULT NULL,
  `newgradeitem` bigint(10) DEFAULT NULL,
  `userid` bigint(10) NOT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) DEFAULT NULL,
  `importonlyfeedback` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradimpovalu_ite_ix` (`itemid`),
  KEY `mdl_gradimpovalu_new_ix` (`newgradeitem`),
  KEY `mdl_gradimpovalu_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Temporary table for importing grades';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_import_values`
--

LOCK TABLES `mdl_grade_import_values` WRITE;
/*!40000 ALTER TABLE `mdl_grade_import_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_import_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_items`
--

DROP TABLE IF EXISTS `mdl_grade_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemtype` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemmodule` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext COLLATE utf8mb4_unicode_ci,
  `idnumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calculation` longtext COLLATE utf8mb4_unicode_ci,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_graditem_locloc_ix` (`locked`,`locktime`),
  KEY `mdl_graditem_itenee_ix` (`itemtype`,`needsupdate`),
  KEY `mdl_graditem_gra_ix` (`gradetype`),
  KEY `mdl_graditem_idncou_ix` (`idnumber`,`courseid`),
  KEY `mdl_graditem_cou_ix` (`courseid`),
  KEY `mdl_graditem_cat_ix` (`categoryid`),
  KEY `mdl_graditem_sca_ix` (`scaleid`),
  KEY `mdl_graditem_out_ix` (`outcomeid`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table keeps information about gradeable items (ie colum';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_items`
--

LOCK TABLES `mdl_grade_items` WRITE;
/*!40000 ALTER TABLE `mdl_grade_items` DISABLE KEYS */;
INSERT INTO `mdl_grade_items` VALUES (3,12,NULL,NULL,'course',NULL,3,NULL,NULL,NULL,NULL,1,20.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,NULL,0,0,0,0,0,1663489758,1664260297),(4,18,NULL,NULL,'course',NULL,4,NULL,NULL,NULL,NULL,1,0.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,NULL,0,0,0,0,0,1663745537,1663745763),(5,12,3,'test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,2,0,NULL,0,0,0,0,0,1664260060,1664260297),(6,12,3,'test2','mod','quiz',2,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,3,0,NULL,1,0,0,0,0,1664260297,1665135583),(40,73,NULL,NULL,'course',NULL,37,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,NULL,0,0,0,0,0,1666076157,1666076157),(41,73,37,'demo assignment','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,NULL,0,0,0,0,0,1666076168,1666076168),(42,2,NULL,NULL,'course',NULL,38,NULL,NULL,NULL,NULL,1,200.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,NULL,0,0,0,0,0,1666076614,1666156208),(43,2,38,'a1','mod','assign',2,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,2,0,NULL,0,0,0,0,0,1666076622,1666156208),(44,2,38,'a1','mod','assign',3,0,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,3,0,NULL,0,0,0,0,0,1666156208,1666156208);
/*!40000 ALTER TABLE `mdl_grade_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_items_history`
--

DROP TABLE IF EXISTS `mdl_grade_items_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_items_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemtype` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemmodule` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext COLLATE utf8mb4_unicode_ci,
  `idnumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calculation` longtext COLLATE utf8mb4_unicode_ci,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_graditemhist_act_ix` (`action`),
  KEY `mdl_graditemhist_tim_ix` (`timemodified`),
  KEY `mdl_graditemhist_old_ix` (`oldid`),
  KEY `mdl_graditemhist_cou_ix` (`courseid`),
  KEY `mdl_graditemhist_cat_ix` (`categoryid`),
  KEY `mdl_graditemhist_sca_ix` (`scaleid`),
  KEY `mdl_graditemhist_out_ix` (`outcomeid`),
  KEY `mdl_graditemhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History of grade_items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_items_history`
--

LOCK TABLES `mdl_grade_items_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_items_history` DISABLE KEYS */;
INSERT INTO `mdl_grade_items_history` VALUES (1,1,1,'system',1663413570,2,9,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(2,3,1,'coursedelete',1663413570,2,9,NULL,NULL,'course',NULL,1,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(3,1,2,'system',1663413577,2,8,NULL,NULL,'course',NULL,2,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(4,3,2,'coursedelete',1663413577,2,8,NULL,NULL,'course',NULL,2,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(5,1,3,'system',1663489758,2,12,NULL,NULL,'course',NULL,3,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(6,2,3,'aggregation',1663489758,2,12,NULL,NULL,'course',NULL,3,NULL,NULL,NULL,NULL,1,0.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(7,1,4,'system',1663745537,2,18,NULL,NULL,'course',NULL,4,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(8,2,4,'aggregation',1663745763,2,18,NULL,NULL,'course',NULL,4,NULL,NULL,NULL,NULL,1,0.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(9,1,5,NULL,1664260060,47,12,3,'test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(10,2,5,NULL,1664260060,47,12,3,'test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(11,2,3,'aggregation',1664260060,47,12,NULL,NULL,'course',NULL,3,NULL,NULL,NULL,NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(12,1,6,NULL,1664260297,47,12,3,'test2','mod','quiz',2,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,3,0,0,0,1,0,NULL,0),(13,2,6,NULL,1664260297,47,12,3,'test2','mod','quiz',2,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,3,0,0,0,1,0,NULL,0),(14,2,5,NULL,1664260297,47,12,3,'test','mod','quiz',1,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,2,0,0,0,1,0,NULL,0),(15,2,6,NULL,1664260297,47,12,3,'test2','mod','quiz',2,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,3,0,0,0,1,0,NULL,0),(16,2,3,'aggregation',1664260297,47,12,NULL,NULL,'course',NULL,3,NULL,NULL,NULL,NULL,1,20.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(17,1,7,'system',1664634291,2,21,NULL,NULL,'course',NULL,5,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(18,3,7,'coursedelete',1664634291,2,21,NULL,NULL,'course',NULL,5,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(19,2,6,NULL,1665135583,2,12,3,'test2','mod','quiz',2,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,3,1,0,0,0,0,NULL,0),(20,1,8,'system',1665392057,2,26,NULL,NULL,'course',NULL,6,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(21,3,8,'coursedelete',1665392057,2,26,NULL,NULL,'course',NULL,6,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(22,1,9,'system',1665392057,2,25,NULL,NULL,'course',NULL,7,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(23,3,9,'coursedelete',1665392057,2,25,NULL,NULL,'course',NULL,7,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(24,1,10,'system',1665392082,2,23,NULL,NULL,'course',NULL,8,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(25,3,10,'coursedelete',1665392082,2,23,NULL,NULL,'course',NULL,8,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(26,1,11,'system',1665392148,2,19,NULL,NULL,'course',NULL,9,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(27,3,11,'coursedelete',1665392148,2,19,NULL,NULL,'course',NULL,9,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(28,1,12,'system',1665392149,2,20,NULL,NULL,'course',NULL,10,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(29,3,12,'coursedelete',1665392149,2,20,NULL,NULL,'course',NULL,10,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(30,1,13,'system',1665398421,2,41,NULL,NULL,'course',NULL,11,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(31,3,13,'coursedelete',1665398421,2,41,NULL,NULL,'course',NULL,11,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(32,1,14,'system',1665827127,2,44,NULL,NULL,'course',NULL,12,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(33,2,14,'aggregation',1665827132,2,44,NULL,NULL,'course',NULL,12,NULL,NULL,NULL,NULL,1,0.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(34,1,15,NULL,1665827132,2,44,12,'sdas','mod','quiz',3,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(35,2,15,NULL,1665827132,2,44,12,'sdas','mod','quiz',3,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(36,2,14,'aggregation',1665827132,2,44,NULL,NULL,'course',NULL,12,NULL,NULL,NULL,NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(37,3,15,'coursedelete',1665828981,2,44,12,'sdas','mod','quiz',3,0,NULL,'',NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(38,3,14,'coursedelete',1665828981,2,44,NULL,NULL,'course',NULL,12,NULL,NULL,NULL,NULL,1,10.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,0,0,NULL,0),(39,1,16,'system',1665829381,2,31,NULL,NULL,'course',NULL,13,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(40,3,16,'coursedelete',1665829381,2,31,NULL,NULL,'course',NULL,13,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(41,1,17,'system',1665829450,2,32,NULL,NULL,'course',NULL,14,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(42,3,17,'coursedelete',1665829450,2,32,NULL,NULL,'course',NULL,14,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(43,1,18,'system',1665829550,2,42,NULL,NULL,'course',NULL,15,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(44,3,18,'coursedelete',1665829550,2,42,NULL,NULL,'course',NULL,15,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(45,1,19,'system',1665829550,2,39,NULL,NULL,'course',NULL,16,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(46,3,19,'coursedelete',1665829550,2,39,NULL,NULL,'course',NULL,16,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(47,1,20,'system',1665829550,2,38,NULL,NULL,'course',NULL,17,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(48,3,20,'coursedelete',1665829550,2,38,NULL,NULL,'course',NULL,17,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(49,1,21,'system',1665829550,2,37,NULL,NULL,'course',NULL,18,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(50,3,21,'coursedelete',1665829550,2,37,NULL,NULL,'course',NULL,18,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(51,1,22,'system',1665829551,2,36,NULL,NULL,'course',NULL,19,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(52,3,22,'coursedelete',1665829551,2,36,NULL,NULL,'course',NULL,19,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(53,1,23,'system',1665829551,2,35,NULL,NULL,'course',NULL,20,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(54,3,23,'coursedelete',1665829551,2,35,NULL,NULL,'course',NULL,20,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(55,1,24,'system',1665829551,2,34,NULL,NULL,'course',NULL,21,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(56,3,24,'coursedelete',1665829551,2,34,NULL,NULL,'course',NULL,21,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(57,1,25,'system',1665829551,2,30,NULL,NULL,'course',NULL,22,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(58,3,25,'coursedelete',1665829551,2,30,NULL,NULL,'course',NULL,22,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(59,1,26,'system',1665829551,2,13,NULL,NULL,'course',NULL,23,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(60,3,26,'coursedelete',1665829551,2,13,NULL,NULL,'course',NULL,23,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(61,1,27,'system',1665831457,2,33,NULL,NULL,'course',NULL,24,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(62,3,27,'coursedelete',1665831457,2,33,NULL,NULL,'course',NULL,24,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(63,1,28,'system',1665831457,2,28,NULL,NULL,'course',NULL,25,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(64,3,28,'coursedelete',1665831457,2,28,NULL,NULL,'course',NULL,25,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(65,1,29,'system',1665831457,2,27,NULL,NULL,'course',NULL,26,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(66,3,29,'coursedelete',1665831457,2,27,NULL,NULL,'course',NULL,26,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(67,1,30,'system',1665831855,2,43,NULL,NULL,'course',NULL,27,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(68,3,30,'coursedelete',1665831855,2,43,NULL,NULL,'course',NULL,27,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(69,1,31,'system',1665831855,2,40,NULL,NULL,'course',NULL,28,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(70,3,31,'coursedelete',1665831855,2,40,NULL,NULL,'course',NULL,28,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(71,1,32,'system',1665987543,2,47,NULL,NULL,'course',NULL,29,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(72,3,32,'coursedelete',1665987543,2,47,NULL,NULL,'course',NULL,29,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(73,1,33,'system',1665989035,2,53,NULL,NULL,'course',NULL,30,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(74,3,33,'coursedelete',1665989035,2,53,NULL,NULL,'course',NULL,30,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(75,1,34,'system',1665989044,2,52,NULL,NULL,'course',NULL,31,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(76,3,34,'coursedelete',1665989044,2,52,NULL,NULL,'course',NULL,31,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(77,1,35,'system',1665989054,2,51,NULL,NULL,'course',NULL,32,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(78,3,35,'coursedelete',1665989054,2,51,NULL,NULL,'course',NULL,32,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(79,1,36,'system',1666010117,2,63,NULL,NULL,'course',NULL,33,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(80,3,36,'coursedelete',1666010117,2,63,NULL,NULL,'course',NULL,33,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(81,1,37,'system',1666020873,2,55,NULL,NULL,'course',NULL,34,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(82,3,37,'coursedelete',1666020873,2,55,NULL,NULL,'course',NULL,34,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(83,1,38,'system',1666020964,2,46,NULL,NULL,'course',NULL,35,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(84,3,38,'coursedelete',1666020964,2,46,NULL,NULL,'course',NULL,35,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(85,1,39,'system',1666067413,2,15,NULL,NULL,'course',NULL,36,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(86,3,39,'coursedelete',1666067413,2,15,NULL,NULL,'course',NULL,36,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(87,1,40,'system',1666076157,2,73,NULL,NULL,'course',NULL,37,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(88,1,41,NULL,1666076168,2,73,37,'demo assignment','mod','assign',1,0,NULL,'55',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(89,2,41,NULL,1666076168,2,73,37,'demo assignment','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(90,2,41,NULL,1666076168,2,73,37,'demo assignment','mod','assign',1,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(91,1,42,'system',1666076614,2,2,NULL,NULL,'course',NULL,38,NULL,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0),(92,1,43,NULL,1666076622,2,2,38,'a1','mod','assign',2,0,NULL,'56',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(93,2,43,NULL,1666076622,2,2,38,'a1','mod','assign',2,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,2,0,0,0,1,0,NULL,0),(94,2,43,NULL,1666076622,2,2,38,'a1','mod','assign',2,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(95,1,44,'restore',1666156208,2,2,38,'a1','mod','assign',3,0,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,3,0,0,0,0,0,NULL,0),(96,2,44,'restore',1666156208,2,2,38,'a1','mod','assign',3,0,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,1.00000,2,0,0,0,1,0,NULL,0),(97,2,43,NULL,1666156208,2,2,38,'a1','mod','assign',2,0,NULL,'',NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,2,0,0,0,1,0,NULL,0),(98,2,44,NULL,1666156208,2,2,38,'a1','mod','assign',3,0,NULL,NULL,NULL,1,100.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.50000,2,0,0,0,1,0,NULL,0),(99,2,42,'aggregation',1666156208,2,2,NULL,NULL,'course',NULL,38,NULL,NULL,NULL,NULL,1,200.00000,0.00000,NULL,NULL,0.00000,1.00000,0.00000,0.00000,0.00000,1,0,0,0,1,0,NULL,0);
/*!40000 ALTER TABLE `mdl_grade_items_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_letters`
--

DROP TABLE IF EXISTS `mdl_grade_letters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_letters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `lowerboundary` decimal(10,5) NOT NULL,
  `letter` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradlett_conlowlet_uix` (`contextid`,`lowerboundary`,`letter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Repository for grade letters, for courses and other moodle e';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_letters`
--

LOCK TABLES `mdl_grade_letters` WRITE;
/*!40000 ALTER TABLE `mdl_grade_letters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_letters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_outcomes`
--

DROP TABLE IF EXISTS `mdl_grade_outcomes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_outcomes` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fullname` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradoutc_cousho_uix` (`courseid`,`shortname`),
  KEY `mdl_gradoutc_cou_ix` (`courseid`),
  KEY `mdl_gradoutc_sca_ix` (`scaleid`),
  KEY `mdl_gradoutc_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='This table describes the outcomes used in the system. An out';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_outcomes`
--

LOCK TABLES `mdl_grade_outcomes` WRITE;
/*!40000 ALTER TABLE `mdl_grade_outcomes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_outcomes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_outcomes_courses`
--

DROP TABLE IF EXISTS `mdl_grade_outcomes_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_outcomes_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `outcomeid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradoutccour_couout_uix` (`courseid`,`outcomeid`),
  KEY `mdl_gradoutccour_cou_ix` (`courseid`),
  KEY `mdl_gradoutccour_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='stores what outcomes are used in what courses.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_outcomes_courses`
--

LOCK TABLES `mdl_grade_outcomes_courses` WRITE;
/*!40000 ALTER TABLE `mdl_grade_outcomes_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_outcomes_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_outcomes_history`
--

DROP TABLE IF EXISTS `mdl_grade_outcomes_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_outcomes_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fullname` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mdl_gradoutchist_act_ix` (`action`),
  KEY `mdl_gradoutchist_tim_ix` (`timemodified`),
  KEY `mdl_gradoutchist_old_ix` (`oldid`),
  KEY `mdl_gradoutchist_cou_ix` (`courseid`),
  KEY `mdl_gradoutchist_sca_ix` (`scaleid`),
  KEY `mdl_gradoutchist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='History table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_outcomes_history`
--

LOCK TABLES `mdl_grade_outcomes_history` WRITE;
/*!40000 ALTER TABLE `mdl_grade_outcomes_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_outcomes_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grade_settings`
--

DROP TABLE IF EXISTS `mdl_grade_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grade_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradsett_counam_uix` (`courseid`,`name`),
  KEY `mdl_gradsett_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='gradebook settings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grade_settings`
--

LOCK TABLES `mdl_grade_settings` WRITE;
/*!40000 ALTER TABLE `mdl_grade_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grade_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grading_areas`
--

DROP TABLE IF EXISTS `mdl_grading_areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grading_areas` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `areaname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `activemethod` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradarea_concomare_uix` (`contextid`,`component`,`areaname`),
  KEY `mdl_gradarea_con_ix` (`contextid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Identifies gradable areas where advanced grading can happen.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grading_areas`
--

LOCK TABLES `mdl_grading_areas` WRITE;
/*!40000 ALTER TABLE `mdl_grading_areas` DISABLE KEYS */;
INSERT INTO `mdl_grading_areas` VALUES (1,807,'mod_assign','submissions',NULL),(2,808,'mod_assign','submissions',NULL),(3,883,'mod_assign','submissions',NULL);
/*!40000 ALTER TABLE `mdl_grading_areas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grading_definitions`
--

DROP TABLE IF EXISTS `mdl_grading_definitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grading_definitions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `areaid` bigint(10) NOT NULL,
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `copiedfromid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usercreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecopied` bigint(10) DEFAULT '0',
  `options` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_graddefi_aremet_uix` (`areaid`,`method`),
  KEY `mdl_graddefi_are_ix` (`areaid`),
  KEY `mdl_graddefi_use_ix` (`usermodified`),
  KEY `mdl_graddefi_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Contains the basic information about an advanced grading for';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grading_definitions`
--

LOCK TABLES `mdl_grading_definitions` WRITE;
/*!40000 ALTER TABLE `mdl_grading_definitions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grading_definitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_grading_instances`
--

DROP TABLE IF EXISTS `mdl_grading_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_grading_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `raterid` bigint(10) NOT NULL,
  `itemid` bigint(10) DEFAULT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext COLLATE utf8mb4_unicode_ci,
  `feedbackformat` tinyint(2) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradinst_def_ix` (`definitionid`),
  KEY `mdl_gradinst_rat_ix` (`raterid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Grading form instance is an assessment record for one gradab';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_grading_instances`
--

LOCK TABLES `mdl_grading_instances` WRITE;
/*!40000 ALTER TABLE `mdl_grading_instances` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_grading_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_guide_comments`
--

DROP TABLE IF EXISTS `mdl_gradingform_guide_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_guide_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradguidcomm_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='frequently used comments used in marking guide';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_guide_comments`
--

LOCK TABLES `mdl_gradingform_guide_comments` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_guide_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_guide_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_guide_criteria`
--

DROP TABLE IF EXISTS `mdl_gradingform_guide_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_guide_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `shortname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `descriptionmarkers` longtext COLLATE utf8mb4_unicode_ci,
  `descriptionmarkersformat` tinyint(2) DEFAULT NULL,
  `maxscore` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mdl_gradguidcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the rows of the criteria grid.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_guide_criteria`
--

LOCK TABLES `mdl_gradingform_guide_criteria` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_guide_criteria` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_guide_criteria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_guide_fillings`
--

DROP TABLE IF EXISTS `mdl_gradingform_guide_fillings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_guide_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `remark` longtext COLLATE utf8mb4_unicode_ci,
  `remarkformat` tinyint(2) DEFAULT NULL,
  `score` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mdl_gradguidfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `mdl_gradguidfill_ins_ix` (`instanceid`),
  KEY `mdl_gradguidfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPRESSED COMMENT='Stores the data of how the guide is filled by a particular r';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mdl_gradingform_guide_fillings`
--

LOCK TABLES `mdl_gradingform_guide_fillings` WRITE;
/*!40000 ALTER TABLE `mdl_gradingform_guide_fillings` DISABLE KEYS */;
/*!40000 ALTER TABLE `mdl_gradingform_guide_fillings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mdl_gradingform_rubric_criteria`
--

DROP TABLE IF EXISTS `mdl_gradingform_rubric_criteria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mdl_gradingform_rubric_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,