<?php

/**
 * Simple file test_custom.php to drop into root of Moodle installation.
 * This is an example of using a sql_table class to format data.
 */
require_once("../../config.php");
require "$CFG->libdir/tablelib.php";
require "course_class.php";

$title = 'Course Report';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url('/local/username/course.php');
$PAGE->set_pagelayout('standard');
$download = optional_param('download', '', PARAM_ALPHA);
$table = new test_table('uniqueid');
$table->is_downloading($download, 'Course Report', 'testing123');
if (!$table->is_downloading()) {
    // Only print headers if not asked to download data.
    // Print the page header.
    $PAGE->set_title('Course Report');
    $PAGE->set_heading('Course Report');
    $PAGE->navbar->add('Course Report', new moodle_url('local/username/course.php'));
    $previewnode = $PAGE->navigation->add('Course Report', new moodle_url('/local/username/course.php'), navigation_node::TYPE_CONTAINER);
    echo $OUTPUT->header();
}
// Work out the sql for the table.
$DB->execute('SET @row_number = 0', array());
$fields = '*,(@row_number:=@row_number + 1) as num';
$from = '{course}';
$where = 'visible=1 and id!=1 and id!=1220 and tenant_id=2';
$table->set_sql( $fields, $from,$where); 
$table->define_baseurl("$CFG->wwwroot/local/username/course.php");
$table->out(10, true);
echo '
<style>
#page-local-username-course #page-content .flexible .header .commands .icon
{
    display:none !important;
} 
.header a{
    pointer-events: none !important;
}
</style>
';
if (!$table->is_downloading()) {
    echo $OUTPUT->footer();
}