<?php
/**
 * Test table class to be put in test_table.php of root of Moodle installation.
 *  for defining some custom column names and proccessing
 * Username and Password feilds using custom and other column methods.
 */
class test_table extends table_sql {

    /**
     * Constructor
     * @param int $uniqueid all tables have to have a unique id, this is used
     *      as a key when storing table properties like sort order in the session.
     */
    function __construct($uniqueid) {
        parent::__construct($uniqueid);
        // Define the list of columns to show.
        $columns = array('sno', 'first', 'lastname','coursename','certificate','date');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('S no.', 'Firstname', 'Lastname','Course name','Certificate name','Date');
        $this->define_headers($headers);
    }

    /**
     * This function is called for each data row to allow processing of the
     * username value.
     *
     * @param object $values Contains object with all the values of record.
     * @return $string Return username with link to profile or username only
     *     when downloading.
     */
    function col_sno($values) {
                 $sno=(($_GET['page'])*10)+$values->num;

        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            
            return $sno;
        } else {
            return $sno;
        }
    }

    /**
     * This function is called for each data row to allow processing of
     * columns which do not have a *_cols function.
     * @return string return processed value. Return NULL if no change has
     *     been made.
     */
    function col_first($values) {
     global $DB,$CFG;
                 $userdetails = $DB->get_record_sql("SELECT * from {user} where id=$values->userid");

        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {

            return $userdetails->firstname;
        } else {
            return $userdetails->firstname;
        }
    }
    function col_lastname($values) {
             global $DB,$CFG;

        // If the data is being downloaded than we don't want to show HTML.
        $userdetails = $DB->get_record_sql("SELECT * from {user} where id=$values->userid");

        if ($this->is_downloading()) {
            return $userdetails->lastname;
        } else {
            return $userdetails->lastname;
        }
    }

    function col_coursename($values) {
             global $DB,$CFG;

        if($values->customcertid){
            $course = $DB->get_record_sql("SELECT * from {course_modules} as c join {modules} as m on m.id=c.module where c.instance = $values->customcertid and (m.name='simplecertificate' or m.name='customcert')");

            $course_data = $DB->get_record_sql("SELECT * from {course}  where id = $course->course");

        }

        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $course_data->fullname;
        } else {
            return $course_data->fullname;
        }
    }
  
    function col_certificate($values) {
             global $DB,$CFG;

        if($values->customcertid){
            $course = $DB->get_record_sql("SELECT * from {customcert} where id=$values->customcertid");
            $name = $course->name;

        }
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return $name;
        } else {
            return $name;
        }
    }
    function col_date($values) {
        // If the data is being downloaded than we don't want to show HTML.
        if ($this->is_downloading()) {
            return date('m/d/y',$values->timecreated);
        } else {
            return date('m/d/y',$values->timecreated);
        }
    }

  



    
}