<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Edit category form.
 *
 * @package core_course
 * @copyright 2002 onwards Martin Dougiamas (http://dougiamas.com)
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

use DOMDocument;

require_once($CFG->libdir . '/formslib.php');

/**
 * Edit category form.
 *
 * @package core_course
 * @copyright 2002 onwards Martin Dougiamas (http://dougiamas.com)
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

function array_push_assoc($array, $key, $value)
{
    $array[$key] = $value;
    return $array;
}


class core_course_editcategory_form extends moodleform
{

    /**
     * The form definition.
     */


    public function definition()
    {
        global $CFG, $DB, $USER;
        $prev_page = optional_param('prev', '', PARAM_TEXT);
        $parent = optional_param('parent', 0, PARAM_INT);
        $ids = optional_param('id', 0, PARAM_INT);



        $mform = $this->_form;
        $categoryid = $this->_customdata['categoryid'];
        $parent = $this->_customdata['parent'];

        $track_condition = false;
        $certificates = ['' => "Select"];
        if ($ids) {
            $FORUM_TYPES = [];
            $selected_badge_name = $DB->get_record_sql("SELECT * FROM {custom_badge} WHERE course_id = $ids");
            if ($selected_badge_name) {
                $FORUM_TYPES = array_push_assoc($FORUM_TYPES, $selected_badge_name->id, $selected_badge_name->badge_name);
                $set_selected =  $selected_badge_name->id;
            }

            $selected_certificate_name = $DB->get_record_sql("SELECT * FROM {custom_certificate} WHERE track_id = $ids");

            if ($selected_certificate_name) {
                $certificates = array_push_assoc($certificates, $selected_certificate_name->id, $selected_certificate_name->certificate_name);
                $set_selected =  $selected_certificate_name->id;
            }
            // else {
            //     $set_selected =  0;
            // }
        } else {
            $FORUM_TYPES = ['' => "Select"];
        }


        $badge_name = $DB->get_records_sql("SELECT * FROM {custom_badge} WHERE course_id IS NULL AND userid = $USER->id");
        if ($badge_name) {
            # code...
            foreach ($badge_name as $badge_name1) {
                $FORUM_TYPES = array_push_assoc($FORUM_TYPES, $badge_name1->id, $badge_name1->badge_name);
            }
        }

        $certificate_name = $DB->get_records_sql("SELECT * FROM {custom_certificate} WHERE track_id IS NULL AND userid = $USER->id");
        if ($certificate_name) {
            foreach ($certificate_name as $certificate_name1) {
                $certificates = array_push_assoc($certificates, $certificate_name1->id, $certificate_name1->certificate_name);
            }
        }


        if ($categoryid) {
            $cat_data = $DB->get_record('course_categories', ['id' => $categoryid]);
        }


        $course_condition = false;

        if ($prev_page) {
            if ($prev_page == 'view-course') {
                $categoryname = 'Track Name';
                $categoryidnum = 'Track ID number';
                $buttonlabel = 'Create Track';
                $track_condition = TRUE;
            }

            if ($prev_page == 'course') {
                $categoryname = 'Course Name';
                $categoryidnum = 'Course ID number';
                $buttonlabel = 'Create Course';
                $course_condition = TRUE;
            }
        } else {


            if ($parent == 0) {
                $categoryname = 'Track Name';
                $categoryidnum = 'Track ID number';
                $buttonlabel = 'Create Track';
                $track_condition = TRUE;
            }
            if ($parent > 0) {
                $categoryname = 'Course Name';
                $categoryidnum = 'Course ID number';
                $buttonlabel = 'Create Course';
                $course_condition = TRUE;
            }
        }
        // {
        //     $categoryname = 'Category Name';
        //     $categoryidnum = 'Category ID number';
        //     $buttonlabel = 'Create Category';
        // }



        // Get list of categories to use as parents, with site as the first one.
        $options = array();
        if (has_capability('moodle/category:manage', context_system::instance()) || $parent == 0) {
            $options[0] = get_string('top');
        }
        if ($categoryid) {
            // Editing an existing category.
            $options += core_course_category::make_categories_list('moodle/category:manage', $categoryid);
            if (empty($options[$parent])) {
                // Ensure the the category parent has been included in the options.
                $options[$parent] = $DB->get_field('course_categories', 'name', array('id' => $parent));
            }
            $strsubmit = get_string('savechanges');
        } else {
            // Making a new category.
            $options += core_course_category::make_categories_list('moodle/category:manage');
            // $strsubmit = get_string('createcategory');
            $strsubmit = $buttonlabel;
        }

        $mform->addElement('hidden', 'parent', get_string('parentcategory'), $options);
        $mform->addRule('parent', null, 'required', null, 'client');

        // $mform->addElement('text', 'name', get_string('categoryname'), array('size' => '30'));
        $mform->addElement('text', 'name', $categoryname, array('size' => '30', 'maxlength' => '20'));
        $mform->addRule('name', get_string('required'), 'required', null);
        $mform->setType('name', PARAM_TEXT);

        // $mform->addElement('text', 'idnumber',$categoryidnum, 'maxlength="100" size="10"');
        // $mform->addHelpButton('idnumber', 'idnumbercoursecategory');
        // $mform->setType('idnumber', PARAM_RAW);

        if ($ids) {

            $mform->addElement('text', 'ids', $categoryidnum, 'maxlength="100" size="10" "readonly"');
            $mform->setdefault('ids', $ids);
        }

        if ($course_condition) {
            $badge_select = $mform->addElement('select', 'badgeid', 'Badge', $FORUM_TYPES);
            $mform->addRule('badgeid', '* this field is required', 'required');
            $badge_select->setSelected($set_selected);
        }
        if ($track_condition) {
            $certificate_select = $mform->addElement('select', 'certificateid', 'Certificate', $certificates);
            $mform->addRule('certificateid', '* this field is required', 'required');
            $certificate_select->setSelected($set_selected);
        }

        $mform->addElement(
            'editor',
            'description_editor',
            'Image',
            null,
            $this->get_description_editor_options()
        );
        $mform->setType('description_editor', PARAM_RAW);
        $mform->addRule('description_editor', '* this field is required', 'required');

        $mform->addElement('textarea', 'text_description', get_string('description'), 'wrap="virtual" rows="20" cols="50"');
        $mform->setDefault('text_description', $cat_data->text);

        if (!empty($CFG->allowcategorythemes)) {
            $themes = array('' => get_string('forceno'));
            $allthemes = get_list_of_themes();
            foreach ($allthemes as $key => $theme) {
                if (empty($theme->hidefromselector)) {
                    $themes[$key] = get_string('pluginname', 'theme_' . $theme->name);
                }
            }
            $mform->addElement('select', 'theme', get_string('forcetheme'), $themes);
        }

        $mform->addElement('hidden', 'id', 0);
        $mform->setType('id', PARAM_INT);
        $mform->setDefault('id', $categoryid);

        $this->add_action_buttons(true, $strsubmit);
    }

    /**
     * Returns the description editor options.
     * @return array
     */
    public function get_description_editor_options()
    {
        global $CFG;
        $context = $this->_customdata['context'];
        $itemid = $this->_customdata['itemid'];
        return array(
            'maxfiles'  => EDITOR_UNLIMITED_FILES,
            'maxbytes'  => $CFG->maxbytes,
            'trusttext' => false,
            'noclean'   => true,
            'context'   => $context,
            'subdirs'   => file_area_contains_subdirs($context, 'coursecat', 'description', $itemid),
        );
    }

    /**
     * Validates the data submit for this form.
     *
     * @param array $data An array of key,value data pairs.
     * @param array $files Any files that may have been submit as well.
     * @return array An array of errors.
     */
    public function validation($data, $files)
    {
        global $DB;
        $errors = parent::validation($data, $files);
        if (!empty($data['description_editor']['text'])) {
            $myVar = htmlspecialchars($data['description_editor']['text'], ENT_QUOTES);
            preg_match_all('/img/', $myVar, $matches) === 1;
            if (count($matches[0]) != 2) {
                $errors['description_editor'] = get_string('onlyimage');
            } 
        }
        if (!empty($data['idnumber'])) {
            if ($existing = $DB->get_record('course_categories', array('idnumber' => $data['idnumber']))) {
                if (!$data['id'] || $existing->id != $data['id']) {
                    $errors['idnumber'] = get_string('categoryidnumbertaken', 'error');
                }
            }
        }
        return $errors;
    }
}
