<?php
require_once('../../config.php');
global $trackid, $USER;
require_login();
$courseid= required_param('id', PARAM_INT);
$trackid = optional_param('trackid', 0,PARAM_INT);

$instructor_roleid = $DB->get_field('role','id',['shortname'=>'manager']);

if (!is_siteadmin() && !user_has_role_assignment($USER->id,$instructor_roleid)) {
 throw new moodle_exception('you dont have permission to access this page', 'core');
}

$title = 'My Modules';
$pagetitle = $title;
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/modules.css');
$PAGE->requires->css('/local/public/css/bootstrap.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');
$PAGE->requires->js('/local/public/amd/src/view-courses.js');

echo $OUTPUT->header();
$data = $DB->get_records_sql("SELECT mc.* FROM {course} mc  where mc.category = $courseid");  // get module data
$admin = false;
$instructor = false;
$create_module_permission = true;

if (is_siteadmin()) {
   $admin = true;
   if (!$DB->record_exists('course_categories',['id'=>$courseid,'usercreated'=>$USER->id])) {
      $create_module_permission = false;
    
   }
   if ($DB->record_exists('course_categories',['id'=>$courseid,'visible'=>1])) {
      $create_module_permission = false;
    
   }
}
else {
   if (user_has_role_assignment($USER->id, $instructor_roleid)) {
     $instructor = true;
   }
}
if ($instructor) {
   if ($DB->record_exists('course_categories',['id'=>$courseid,'visible'=>1])) {
      $create_module_permission = false;
    
   }
   if (!$DB->record_exists('course_categories',['id'=>$courseid,'usercreated'=>$USER->id])) {
      $create_module_permission = false;
    
   }
if ($DB->record_exists('request_subcategory',['subcategory_id'=>$courseid])) {
   $create_module_permission = false;
}
   // elseif ($DB->record_exists('request_subcategory',['subcategory_id'=>$courseid,'status'=>'5'])) {
   //    $create_module_permission = false;
    
   // }
   // elseif ($DB->record_exists('request_subcategory',['subcategory_id'=>$courseid,'status'=>'6'])) {
   //    $create_module_permission = false;
    
   // }
   // else {
    
   //    $create_module_permission = true;
   // }
}
// else {
//    $create_module_permission = true;
// }

function get_course_image($courseid)
{
   global $COURSE;
   $url = '';

   $context = context_course::instance($courseid);
   $fs = get_file_storage();
   $files = $fs->get_area_files($context->id, 'course', 'overviewfiles', 0);

   foreach ($files as $f) {
      if ($f->is_valid_image()) {
         $url = moodle_url::make_pluginfile_url($f->get_contextid(), $f->get_component(), $f->get_filearea(), null, $f->get_filepath(), $f->get_filename(), false);
      }
   }

   return $url;
}
foreach ($data as $datavalue) {
   $rejected = false;
   $publish = false;
   $drafted = false;
    $reviewed = false;
   $pending = false;
   $approved = false;
   $pending_for_approval = false;
   $edit_permission = false;
// for edit and delete permission
if ($DB->record_exists('course',['id'=>$datavalue->id,'usercreated'=>$USER->id])) {
   $edit_permission = true;
}

   $moduleid = $datavalue->id;
   $module_sections =  $DB->get_records('course_sections', ['course' => $datavalue->id]);
   $url = get_course_image($moduleid);
   if (!$url) {
      $url = 'image/courses.jpg';
   }

   if ($datavalue->visible == 0) { 
      //check if module is rejected
      if ($DB->record_exists('reject_course', ['course_id'=>$datavalue->id,'status'=>0])) { 
         $button_name = 'Rejected';
         $class = 'rejected';
         $rejected = true;
      }
      //check if module is dafted
      elseif ($DB->record_exists('reject_course', ['course_id'=>$datavalue->id,'status'=>2])) {
         $button_name = 'Drafted';

         $drafted = true;
      }
      //check if module is reviewed
      elseif ($DB->record_exists('reject_course', ['course_id'=>$datavalue->id,'status'=>3])) {
         $button_name = 'To be Revised';

         $reviewed = true;
      }
      // check if module is approved
      elseif ($DB->record_exists('reject_course', ['course_id'=>$datavalue->id,'status'=>4])) {
         if ($admin) {
            // if (!$DB->record_exists('course',['usercreated'=>$USER->id,'id'=>$datavalue->id])) {
              
               $approved = true;
            // }
         }
         $button_name = 'Approved';
         $class = 'approved';
      }
      elseif ($DB->record_exists('reject_course', ['course_id'=>$datavalue->id,'status'=>1])) {
         $button_name = 'Pending for Approval';
         $class = 'pendingforapproval';
         $pending = true;
      }
                                          
      else {
         $button_name = 'Request for Review';

         $pending = true;
      }
   }
   if ($datavalue->visible == 1) { 
      $button_name = 'Published';
      $publish = true;
   }
     
   $module[]=['modulename'=>$datavalue->fullname,'moduleimage'=>$url,'subtopiccount'=>count($module_sections),'starttext'=>substr(strip_tags($datavalue->summary),0,50),'endtext'=>substr(strip_tags($datavalue->summary),50,strlen(strip_tags($datavalue->summary))),'trackid'=>$trackid,'courseid'=>$courseid,'moduleid'=>$datavalue->id,'rejected'=>$rejected,'drafted'=>$drafted,'reviewed'=>$reviewed,'pending'=>$pending,'approved'=>$approved,'buttonname'=>$button_name,'admincondition'=>$admin,'instructor_condition'=>$instructor,'pending_for_approval'=>$pending_for_approval,'publish'=>$publish,'edit_permission'=>$edit_permission,'class'=>$class];

}

$data = [
   'modulename'=>$module,
   'courseid'=>$courseid,
   'trackid'=>$trackid,
   'create_module_permission'=>$create_module_permission
 
 ];
echo $OUTPUT->render_from_template('local_public/module', $data); // render template
echo $OUTPUT->footer();

?>
