<?php
require_once('../../config.php');
global $DB, $OUTPUT, $PAGE;
require_login();

$instructor_role = $DB->get_field('role','id',['shortname' => 'manager']);

// if (!is_siteadmin() && !user_has_role_assignment($USER->id,$instructor_role)) {

// throw new moodle_exception("you don't have permission to access this page",'core');
// }

// $score = $DB->get_record_sql("SELECT SUM(gg.finalgrade) as score FROM {grade_grades} gg WHERE gg.userid = 40 AND gg.itemid IN (SELECT id FROM {grade_items} WHERE courseid = 46 AND itemname != '')");
// var_dump($score);
// die;
$studentid = required_param('id', PARAM_INT);

$moduleid = required_param('moduleid', PARAM_INT);

$trackid = required_param('trackid', PARAM_INT);

$courseid = required_param('courseid', PARAM_INT);

$course_ids = [];
$module_ids = [];


$totalenrol_courses =enrol_get_users_courses($studentid, $onlyactive = false, $fields = null, $sort = null);   // get enrol courses
foreach($totalenrol_courses as $totalenrol_courses1){
$course_ids[] = $totalenrol_courses1->category;
$module_ids[] = $totalenrol_courses1->id;
}
$enrol_course_ids = implode(",",$course_ids);
$enrol_module_ids = implode(",",$module_ids);


// $enrolid = $DB->get_record_sql("SELECT * FROM {enrol} WHERE courseid = $moduleid AND enrol IN ('manual','guest','self') AND status = 0");
$record = $DB->get_record_sql("SELECT * FROM {user} WHERE id = $studentid");
$trackrecord = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $trackid");
$courserecord = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $courseid");
$modulerecord = $DB->get_record_sql("SELECT * FROM {course} WHERE id = $moduleid");
// $student_enrolment_time = $DB->get_record_sql("SELECT * FROM {user_enrolments} WHERE userid = $studentid AND enrolid = $enrolid->id ");
$student_enrolment_time = $DB->get_record_sql("SELECT * FROM {user_enrolments} WHERE userid = $studentid AND enrolid IN (SELECT id FROM {enrol} WHERE courseid =$moduleid AND enrol IN ('manual','guest','self') AND status = 0)");
$student_enrolment_date = date("Y-m-d ",$student_enrolment_time->timecreated);
$userlastaccess = $DB->get_record_sql("SELECT * FROM {user_lastaccess} WHERE userid = $studentid AND courseid = $moduleid");
if ($userlastaccess) {
  $userlastaccess_time =  date("Y-m-d",$userlastaccess->timeaccess);

}
else {
  $userlastaccess_time = "Not Open Yet";
}

$start_date = strtotime($student_enrolment_date);
$end_date = strtotime($userlastaccess_time);

$total_days =abs(($end_date - $start_date)/60/60/24);

//code for track graph

$total_completed_courses_within_track = [];
$total_completed_track = [];


$total_inprogress_courses_within_track = [];
$total_inprogress_track = [];


  $allcourses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id IN ($enrol_course_ids) AND parent = $trackid");

  $total_allcourses = count($allcourses);

  foreach ($allcourses as $allcourses1) {
    $allmodules = $DB->get_records_sql("SELECT * FROM {course} WHERE id IN ($enrol_module_ids) AND category = $allcourses1->id ");
    $totalallmodules = count($allmodules);
    $total_completed_module_within_track = [];
    $total_inprogress_module_within_track = [];
    foreach ($allmodules as $allmodules1) {
      $course_object = $DB->get_record('course', ['id' => $allmodules1->id]);
      $check = core_completion\progress::get_course_progress_percentage($course_object, $studentid);

      if ($check == 100) {
        $total_completed_module_within_track[] = $course_object->id;
      }
 
      if ($check > 0 && $check < 100) {
        $total_inprogress_module_within_track[] = $course_object->id;
      }
    }
    
    if (count($total_inprogress_module_within_track) > 0) {
      $total_inprogress_courses_within_track[] = $allcourses1->id;
    }
    if (count($total_completed_module_within_track) == $totalallmodules) {
      $total_completed_courses_within_track[] =  $allcourses1->id;
     
    }
  }


$totalcompletedtrack = (count($total_completed_courses_within_track) / $total_allcourses) * 100;
$totalinprogresstrack = (count($total_inprogress_courses_within_track) / $total_allcourses) * 100;
$totalnotstartyet = 100 - ($totalcompletedtrack + $totalinprogresstrack);


// end

//code for course graph
$total_completed_module_within_course = [];

$total_inprogress_module_within_course = [];

$allcoursemodules = $DB->get_records_sql("SELECT * FROM {course} WHERE id IN ($enrol_module_ids) AND category = $courseid ");
$totalallcoursemodules = count($allcoursemodules);


foreach ($allcoursemodules as $allcoursemodules1) {
  $course_object1 = $DB->get_record('course', ['id' => $allcoursemodules1->id]);

  $check1 = core_completion\progress::get_course_progress_percentage($course_object1, $studentid);

  if ($check1 == 100) {
    $total_completed_module_within_course[] =  $course_object1->id;
  }
  if ($check1 > 0 && $check1 < 100) {
    $total_inprogress_module_within_course[] =  $course_object1->id;
  }
}
$count_total_completed_module_within_course = (count($total_completed_module_within_course) / $totalallcoursemodules) * 100;
$count_total_inprogress_module_within_course = (count($total_inprogress_module_within_course) / $totalallcoursemodules) * 100;
$count_total_notyetstart_module_within_course = 100 - ($count_total_completed_module_within_course + $count_total_inprogress_module_within_course);
//end

$total_completed_module = [];

// count of completed module
// $course_moduleid = $DB->get_records('course_modules', ['course' => $moduleid]);
$course_moduleid = $DB->get_records_sql("SELECT * FROM {course_modules} WHERE course = $moduleid AND module != 10 AND deletioninprogress = 0");

$total_module = count($course_moduleid);
foreach ($course_moduleid as $course_moduleid1) {
  $completed_module = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $studentid AND completionstate = 1 AND coursemoduleid = $course_moduleid1->id");
  if ($completed_module->id) {
    $total_completed_module[] = $completed_module->id;
  }
}
$total_completed_module1 = (count($total_completed_module) / $total_module) * 100;

//end 

//count of inprogress module
foreach ($course_moduleid as $course_moduleid2) {
  $inprogress_module1 = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $studentid AND completionstate = 0 AND coursemoduleid = $course_moduleid2->id");
  if ($inprogress_module1->id) {
    $total_inprogress_module[] = $inprogress_module1->id;
  }
}
$total_inprogress_module1 = (count($total_inprogress_module) / $total_module) * 100;
//end

$total_not_start_yet = 100 - ($total_completed_module1 + $total_inprogress_module1);

// code for graph color
$themecolor = $DB->get_record('navbar_color',['userid'=>$USER->id]);
if ($themecolor) {
  if ($themecolor->color_mode) {
    $graphfont_color = "#fff";
  }
  else {
    $graphfont_color = "#000";
  }
}
// end code for graph color

$PAGE->set_title('Student Detail');
$PAGE->set_heading('Student Detail');
$PAGE->set_pagelayout('standard');
$PAGE->navbar->add('Student Detail',new moodle_url(''));
$PAGE->requires->js('/local/public/amd/src/bootstrap.bundle.min.js');
$PAGE->requires->js('/local/public/amd/src/student_chart.js');
$PAGE->requires->js('/local/public/amd/src/studentactivity.js');
$PAGE->requires->css('/local/public/css/studentactivity.css');
$PAGE->requires->css('/local/public/css/normalize.min.css');
$PAGE->requires->css('/local/public/css/all.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');

echo $OUTPUT->header();

$countries = get_string_manager()->get_list_of_countries(true);
if (isset($countries[$record->country])) {        // $record->country is the shortname of country
    $countryname =  $countries[$record->country];
}

$i = 1;
foreach($totalenrol_courses as $totalenrol_courses_key ){
  $last_access_date = $DB->get_field('user_lastaccess','timeaccess',['courseid'=>$totalenrol_courses_key->id,'userid'=>$studentid]);
  if ($last_access_date) {
    $lastaccessdate = date('Y-m-d',$last_access_date);
  }
  else {
    $lastaccessdate = 'Not Access Yet';
  }
  $score = $DB->get_record_sql("SELECT SUM(gg.finalgrade) as score FROM {grade_grades} gg WHERE gg.userid = $studentid AND gg.itemid IN (SELECT id FROM {grade_items} WHERE courseid = $totalenrol_courses_key->id AND itemname != '')");
  $user_enrolmentdate = $DB->get_record_sql("SELECT ue.* FROM {user_enrolments} ue WHERE ue.enrolid IN (SELECT id FROM {enrol} WHERE courseid =$totalenrol_courses_key->id AND enrol IN ('manual','guest','self') AND status = 0) AND ue.userid = $studentid");
  $course_object = $DB->get_record('course', ['id' => $totalenrol_courses_key->id]);
  $check = core_completion\progress::get_course_progress_percentage($course_object, $studentid);
  if ($check) {
    if ($check == 100) {
      $status = "Completed";
    }
   else if ($check > 0 && $check < 100) {
      $status = "In Progress";
    }
    else  {
      $status = "Not Start Yet";
    }
  }
  else {
    $status = "Not Start Yet";
  }
$tablerecord[] = [
'serialnumber'=>$i,
'modulename'=>$totalenrol_courses_key->fullname,
'userstatus'=>$status,
'enrolled'=>date('Y-m-d',$user_enrolmentdate->timecreated),
'lastaccess'=>$lastaccessdate,
'score'=>round($score->score),

];
 $i++;
}
$data = [
  'total_completed_module1'=>$total_completed_module1,
  'total_inprogress_module1'=>$total_inprogress_module1,
  'total_not_start_yet'=>$total_not_start_yet,
  'totalcompletedtrack'=>$totalcompletedtrack,
  'totalinprogresstrack'=>$totalinprogresstrack,
  'totalnotstartyet'=>$totalnotstartyet,
  'count_total_completed_module_within_course'=>$count_total_completed_module_within_course,
  'count_total_inprogress_module_within_course'=>$count_total_inprogress_module_within_course,
  'count_total_notyetstart_module_within_course'=>$count_total_notyetstart_module_within_course,
  'graphfont_color'=>$graphfont_color,
  'student_enrolment_date'=>$student_enrolment_date,
  'userlastaccess_time'=>$userlastaccess_time,
  'total_days'=>$total_days,
  'totalenrol_courses'=>count($totalenrol_courses),
  'trackrecordname'=>$trackrecord->name,
  'courserecordname'=>$courserecord->name,
  'modulerecordfullname'=>$modulerecord->fullname,
  'recordcity'=>$record->city,
  'countryname'=>$countryname,
  'recordemail'=>$record->email,
  'tablerecord'=>$tablerecord
];
echo $OUTPUT->render_from_template('local_public/studentactivity',$data);
echo $OUTPUT->footer(); 

?>

