<?php
require_once('../../config.php');

global $DB,$PAGE,$OUTPUT;
require_login();

$PAGE->set_title('Certificate');
$userid = required_param('id',PARAM_INT);
$trackid = required_param('trackid',PARAM_INT);

$userdata = $DB->get_record('user',['id'=>$userid]);
$trackdata = $DB->get_record('course_categories',['id'=>$trackid]);


?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title>Login</title>
	  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
	  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.22/pdfmake.min.js"></script>
	<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>
	  <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
	<style type="text/css">
	body{background: #050534 !important;
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    height: 100vh;
}
	.logos{display: flex; justify-content: space-between;}
	.certificate{width: 60%; background: #fff; margin: auto; box-shadow: 0 1px 3px rgb(0 0 0 / 12%), 0 1px 2px rgb(0 0 0 / 24%); padding: 20px; border-radius: 20px;}
	.completion{text-align: center;}
	.certificate-font{font-size: 40px;}
	.name,.course-title,.successfully-complete{text-align: center;}
	.name p{font-size: 20px;}
	.footer{display: flex; justify-content: space-around;}
	.date,.student-name{align-self: end; text-align: center;}
	input {
  outline: 0;
  border-width: 0 0 2px;
  border-color: #000;
}
.downld-btn a{
background: #c92037;
    color: #fff !important;
    border-color: #c92037 !important;
    padding: 10px 10px;
    border-radius: 6px;
    text-decoration: none;
	}
	</style>

</head>
<body>
<div class="downld-btn" style="text-align: right;">
	<a href="#" type="button" id="download">Download Certificate</a>
</div>
<div class="container">
	<div class="certificate" id="jar">
		<div class="logos">
			<div class="logo-left">
				<img src="logo.jpg">
			</div>
			<div class="logo-right">
				<img src="logo-right.jpg">
			</div>
		</div>
		<div class="completion">
			<h1><span class="certificate-font">CERTIFICATE</span><br> OF COMPLETION</h1>
		</div>
		<div class="name">
			<p style="margin-bottom:5px !important;">This is to certify</p>
			<h1 style="margin-top:0px !important;"> <?php echo ucwords($userdata->firstname." ".$userdata->lastname);?> </h1>
		</div>
		<div class="course-title">
			<p style="margin-bottom:5px !important;">Attended the course titled</p>
			<p style="margin-top:0px !important; font-size:20px;"><b><?php echo $trackdata->name;?></b></p>
		</div>
		<div class="successfully-complete">
			<p style="margin-bottom:5px !important;">And successfully completed</p>
			<p style="margin-top:0px !important; font-size:20px;"><b><?php echo $trackdata->name;?></b></p>
		</div>
		<div class="footer">
			<div class="date">
				<input type="text">
				<p><b>Date</b></p>
			</div>
			<div class="img">
				<img src="award.jpg"/>
			</div>
			<div class="student-name">
				<input type="text">
				<p><b>Dr. Name Surname</b></p>
			</div>
		</div>
	</div>
</div>
<script>
	
    $("body").on("click", "#download", function () {
    html2canvas($('#jar')[0], {
      onrendered: function (canvas) {
        var data = canvas.toDataURL();
        var docDefinition = {
          content: [{
            image: data,
            width: 500
          }]
        };
        pdfMake.createPdf(docDefinition).download("cutomer-details.pdf");
      }
    });
  });
  </script>
</body>
</html>