<?php
require_once('../../config.php');
require_once(__DIR__.'/lib.php');


require_login();
if (!is_siteadmin()) {
    return(new moodle_url('/my'));
}

$PAGE->set_url('/loca/public/dashboard.php');

$PAGE->set_title('Dashboard');
$PAGE->set_heading('Dashboard');
$PAGE->set_pagelayout('standard');
echo $OUTPUT->header();

GLOBAl $DB;

$leaderboard_data = [];

$users = $DB->get_records('user', array());
$activeuser = $DB->get_records('user_online',array());
$total_user = count($users);
$active_user = count($activeuser);
$inactive_user = $total_user - $active_user;


$recent_badge_assigned = $DB->get_records_sql("SELECT  bi.userid, u.firstname, u.lastname FROM {badge_issued} bi  LEFT JOIN {user} u ON u.id = bi.userid  ORDER BY bi.userid DESC LIMIT 100");

foreach ($recent_badge_assigned as $recent_badge_assigned1 ) {

    
$badge_name = $DB->get_record_sql("SELECT  b.* FROM {badge} b  JOIN {badge_issued} b_i ON b_i.badgeid = b.id  WHERE b_i.userid = $recent_badge_assigned1->userid");

   $user_activity[] = ['name'=>$recent_badge_assigned1->firstname." ".$recent_badge_assigned1->lastname,'activity'=>"win"." ".$badge_name->name];
}


$users_record = $DB->get_records_sql("SELECT u.* FROM {user} u JOIN {user_enrolments} ue ON ue.userid = u.id LEFT JOIN {grade_grades} gg  ON gg.userid = u.id ORDER BY gg.finalgrade DESC ");
$i=0;
foreach($users_record as $users_record1){
    
    $count = 0;
    $totalgrade = 0;
    // $gradecount = $DB->get_records_sql("SELECT gg.finalgrade FROM {grade_grades} gg  WHERE gg.userid = $users_record1->id");
    $gradecount = $DB->get_records('grade_grades',['userid'=>$users_record1->id]);
   

    if ($gradecount) {
        foreach($gradecount as $gradecount1){
            $totalgrade = $totalgrade+$gradecount1->finalgrade;
        }
    } else {
      $totalgrade = 0;
    }


    $usercreated_date = date('m/d/Y h:i:sa', $users_record1->firstaccess);
    if ($users_record1->lastaccess == 0) {
      $lastaccess1 = date('m/d/Y h:i:sa');
    
    }
    else {
      $lastaccess1 = date('m/d/Y h:i:sa', $users_record1->lastaccess);
    
    }
        
    $start_date = new DateTime($usercreated_date);
    $time_sepent = $start_date->diff(new DateTime($lastaccess1));


    $user_enrolled_courses = enrol_get_all_users_courses($users_record1->id, $onlyactive = false, $fields = null, $sort = null);
foreach($user_enrolled_courses as $user_enrolled_courses1 ){
    
    $course_object = $DB->get_record('course',['id'=>$user_enrolled_courses1->id]);
    $check = core_completion\progress::get_course_progress_percentage($course_object,$users_record1->id);

    if ($check == 100) {
        $count++;
    }

}
$i++;
$leaderboard_data[] = ['rank'=>$i,'username'=>$users_record1->firstname." ".$users_record1->lastname,'completed_course'=>$count,'time_spent'=>$time_sepent->days." "."days"." ".$time_sepent->h." "."hours", 'score'=>$totalgrade ];

}

$color = $DB->get_record('navbar_color',['userid'=>$USER->id]);
if ($color->color_mode) {
    $label_color = "#fff";
}
else {
    $label_color = "#000";
}

$recent_tracklist = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent = 0 ORDER BY id DESC LIMIT 5");
$count_of_category_enrolled_user= [];
foreach($recent_tracklist as $recent_tracklist1){

    $courses = $DB->get_records('course_categories',['parent'=>$recent_tracklist1->id]);
    $userids = [];
    foreach($courses as $courses1){
        $cat = core_course_category::get($courses1->id);
        $moduleids = $cat->get_courses(['recursive', 'idonly']);
foreach ($moduleids as $moduleid) {
    $context = context_course::instance($moduleid->id);
    $moduleusers = get_enrolled_users($context, '', 0, 'u.id');
    $userids = array_merge($userids, array_keys($moduleusers));
    
}
    }
    $recent_course[] = $recent_tracklist1->name.":".count($userids);
    $count_of_category_enrolled_user[] = count($userids);

}

$course_string = "'" . implode ( "', '", $recent_course ) . "'";
$count1 = implode(',', $count_of_category_enrolled_user);


$data = [
 
    'course' => $course_string,
    'countofenrolleduser' => $count1,
    'color'=> $label_color,
    'leaderboard_data' =>$leaderboard_data,
    'active_user'=>$active_user,
    'inactive_user'=>$inactive_user,
    'user_activity'=>$user_activity
   
];

echo $OUTPUT->render_from_template('local_public/dashboard', $data);
echo $OUTPUT->footer();