<?php
require_once('../../config.php');
require_once("{$CFG->libdir}/completionlib.php");
require_once("{$CFG->libdir}/accesslib.php");

class active_tableuser extends table_sql
{

    function __construct($uniqueid,$not_download)
    {
        parent::__construct($uniqueid,);
        // Define the list of columns to show.

         if($not_download=="not"){
            $columns = array('id',  'firstname', 'lastname', 'email', 'city', 'country', 'lastaccess', 'status');
         }else{
            $columns = array('id',  'firstname', 'lastname', 'email', 'city', 'country', 'lastaccess', 'edit', 'progress','status');
         }
          $this->define_columns($columns);

        // Define the titles of columns to show in header.
         if($not_download=="not"){
            $headers = array('UEID', 'Firstname', 'Lastname', 'Email', 'City/Town', 'Country', 'Last Access', 'Status');
        }
        else{
          $headers = array('UEID', 'Firstname', 'Lastname', 'Email', 'City/Town', 'Country', 'Last Access', 'Actions', 'Tracks Progress','Status');
        }
        $this->define_headers($headers);
    }

    function col_firstname($row){
        return(html_writer::link(new moodle_url('user_table.php',['userid'=>$row->id]),$row->firstname));
    }
    function col_country($row){
        $countries = get_string_manager()->get_list_of_countries(true);
        if (isset($countries[$row->country])) {
            return($countries[$row->country]);
        }
    }
    function col_progress($row){

        global $DB;
        $user_enrol_modules = enrol_get_users_courses($row->id, $onlyactive = false, $fields = null, $sort = null);
        if ($user_enrol_modules) {
            foreach ($user_enrol_modules as $user_enrol_modulesss) {
                if ($user_enrol_modulesss->visible == 1) {
                    $course[] =  $user_enrol_modulesss->category;
                }
            }
            
            $course = array_unique($course);  // get total enrolled tracks
            $course = array_values($course);  // get total enrolled tracks
            
            $student_enrolled_courses = implode(",", $course);
            
            $student_enrolled_courses = trim($student_enrolled_courses, '"');
            if ($student_enrolled_courses) {
                # code...
                $trackids = $DB->get_records_sql("SELECT parent FROM {course_categories} WHERE id IN ($student_enrolled_courses) AND parent != 0 AND visible = 1");
            }
            $total_track = count($trackids);  // get total enrolled tracks
            
            // var_dump($total_track." ".$row->id);
            
            if ($total_track) {
                $track_completed = 0;

                foreach($trackids as $trackid_id){
                    // var_dump($trackid_id->parent." ".$row->id);
                    if ($DB->record_exists('course_categories', ['id' => $trackid_id->parent, 'visible' => 1,'parent'=>0])) {
                        
    
                        $total_enrolled_courses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id IN ($student_enrolled_courses) AND parent = $trackid_id->parent AND visible = 1");
    
                        if ($total_enrolled_courses) {
                        $enrol_track_names = $DB->get_record('course_categories', ['id' => $trackid_id->parent]);
                        // var_dump($enrol_track_names);
                        $course_completed = 0;
                        for ($i = 0; $i <= count($course); $i++) {
    
                            $enrol_courses = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$course[$i]' AND parent = $enrol_track_names->id AND visible = 1");
                            if ($enrol_courses) {
                                $modules_in_course = 0;
                                $completed_moduleincourse = 0;
                                $module_record = $DB->get_records('course', ['category' => $enrol_courses->id,'visible'=>1]);
                                if ($module_record) {
                                    foreach ($module_record as $module_record1) {
        
                                        $context = context_course::instance($module_record1->id);
        
                                        if (is_enrolled($context, $row->id, '', true)) {
        
                                            $module_object = $DB->get_record('course', ['id' => $module_record1->id]);
        
                                            $check = core_completion\progress::get_course_progress_percentage($module_object, $row->id);
                                            if ($check) {
                                                if ($check == 100) {
                                                    $completed_moduleincourse++;
                                                }
                                            }
                                            
                                            $modules_in_course++;
                                            }
                                        }
                                }
                                    if ($modules_in_course == $completed_moduleincourse) {
                                        $course_completed++;
                                    }
                                }
    
                                
                            }
                        }
                        // var_dump($completed_moduleincourse.$modules_in_course." ".$row->id);
                        // var_dump($course_completed." ".$row->id);
                        // var_dump($course_completed." ".count($total_enrolled_courses)." ".$row->id);
                         if ($course_completed == count($total_enrolled_courses)) {
                                    $track_completed++;
                                }
                      
                }
    
            }
          
            $track_completion = round(($track_completed/$total_track)*100,2);
            }
    }
    if (!$track_completion) {
        $track_completion = 0;
    }
    // var_dump($course).var_dump(count($course)." ".$row->id);
    
    // var_dump($track_completion." ".$row->id);
    // var_dump($track_completion." ".$row->id);
        return(html_writer::div("<progress id='file' max='100' title='$track_completion%' style='height: 23px;' value='$track_completion'> $track_completion% </progress>"));
    }

    function col_status($row)
    {
        if (!$row->status) {
            return html_writer::div("<span class='inprogress'>Inactive</span>");
            // return("inactive");
        } else {
            $status = ucwords($row->status);
            return html_writer::div("<span class='completed'>$status</span>");

            // return($row->status);
        }
    }

    function col_lastaccess($row)
    {
        if ($row->lastaccess) {
            $strlastaccess = format_time(time() - $row->lastaccess);
        } else {
            $strlastaccess = 'Never';
        }
        return $strlastaccess;
    }

    function col_edit($row)
    {

        global $DB, $USER, $OUTPUT, $sitecontext;
        $page = optional_param('page', null, PARAM_INT);
        $buttons = array();
        $stredit   = get_string('edit');
        $strdelete = get_string('delete');
        $strsuspend = get_string('suspenduser', 'admin');
        $strunsuspend = get_string('unsuspenduser', 'admin');
        $strunlock = get_string('unlockaccount', 'admin');
        $strconfirm = get_string('confirm');
        $returnurl = new moodle_url('activeuser_table.php');

        $sitecontext = context_system::instance();
        $site = get_site();

           // edit button
           if (has_capability('moodle/user:update', $sitecontext)) {
            // prevent editing of admins by non-admins
            if (is_siteadmin($USER) or !is_siteadmin($row)) {
                $url = new moodle_url('/user/editadvanced.php', array('id' => $row->id, 'course' => $site->id,'prev'=>'prev', 'page' => $page));
                $buttons[] = html_writer::link($url, $OUTPUT->pix_icon('t/pencil', $stredit));
            }
        }


            // suspend button
            if (has_capability('moodle/user:update', $sitecontext)) {
                if (is_mnet_remote_user($row)) {
                    // mnet users have special access control, they can not be deleted the standard way or suspended
                    $accessctrl = 'allow';
                    if ($acl = $DB->get_record('mnet_sso_access_control', array('username' => $row->username, 'mnet_host_id' => $row->mnethostid))) {
                        $accessctrl = $acl->accessctrl;
                    }
                    $changeaccessto = ($accessctrl == 'deny' ? 'allow' : 'deny');
                    $buttons[] = " (<a href=\"?acl={$row->id}&amp;accessctrl=$changeaccessto&amp;sesskey=" . sesskey() . "\">" . get_string($changeaccessto, 'mnet') . " access</a>)";
                } else {
                    
                    if ($row->suspended) {
                        $url = new moodle_url($returnurl, array('unsuspend' => $row->id, 'sesskey' => sesskey(), 'page' => $page));
                        $buttons[] = html_writer::link($url, $OUTPUT->pix_icon('t/show', $strunsuspend));
                    } else {
                        if ($row->id == $USER->id or is_siteadmin($row)) {
                            // no suspending of admins or self!
                        } else {
                            $url = new moodle_url($returnurl, array('suspend' => $row->id, 'sesskey' => sesskey(), 'page' => $page));
                            $buttons[] = html_writer::link($url, $OUTPUT->pix_icon('t/hide', $strsuspend));
                        }
                    }
    
                    // if (login_is_lockedout($row)) {
                    //     $url = new moodle_url($returnurl, array('unlock' => $row->id, 'sesskey' => sesskey()));
                    //     $buttons[] = html_writer::link($url, $OUTPUT->pix_icon('t/unlock', $strunlock));
                    // }
                }
            }

            

        // delete button
        if (has_capability('moodle/user:delete', $sitecontext)) {
            if (is_mnet_remote_user($row) or $row->id == $USER->id or is_siteadmin($row)) {
                // no deleting of self, mnet accounts or admins allowed
            } else {
                $url = new moodle_url($returnurl, array('delete' => $row->id, 'sesskey' => sesskey(), 'page' => $page));
                $buttons[] = html_writer::link($url, $OUTPUT->pix_icon('t/delete', $strdelete));
            }
        }

    

     

        return  implode(' ', $buttons);
    }
}
