<?php
require_once('../../config.php');
require_once(__DIR__ . '/lib.php');


require_login();
global $CFG, $USER;

// if (!user_has_role_assignment($USER->id, 5)) {
//     return (new moodle_url('/my/'));
// }

$PAGE->set_context(context_system::instance());
$PAGE->set_url($CFG->wwwroot . '/local/public/student_dashboard.php');
$PAGE->set_heading('Dashboard');
$PAGE->set_title('Dashboard');
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/student.css');
$PAGE->requires->css('/local/public/student_css/bootstrap.min.css');
$PAGE->requires->css('/local/public/student_css/font-awesome.min.css');
// $PAGE->requires->css('/local/public/slick/slick-theme.css');
// $PAGE->requires->css('/local/public/slick/slick-theme.min.css');
// $PAGE->requires->css('/local/public/slick/slick.css');
$PAGE->requires->css('/local/public/student_css/style.css');
$PAGE->requires->css('/local/public/css/datepicker.min.css');
$PAGE->requires->js('/local/public/amd/src/student.js');
// $PAGE->requires->js('/local/public/amd/src/slick.js');
// $PAGE->requires->js('/local/public/amd/src/slick.min.js');
// $PAGE->requires->js('/local/public/amd/src/bootstrap.bundle.min.js');

echo $OUTPUT->header();

// store image arrays

$images = ['certificate1.jpg','certificate2.jpg','certificate3.jpg','certificate4.jpg','certificate5.jpg',];


// ******* code for browser name *********
purge_caches();
$table = 'logstore_standard_log';
$lastlogin_record = $DB->get_record_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND lsl.action = 'loggedin' ORDER BY lsl.id DESC LIMIT 1");

if ($lastlogin_record) {
   
    if (!$lastlogin_record->browsername) {
        $dataobject = new stdClass();
        $dataobject->id = $lastlogin_record->id;
        $dataobject->browsername = get_browser_name($_SERVER['HTTP_USER_AGENT']);
        $namebrowser =  get_browser_name($_SERVER['HTTP_USER_AGENT']);
    
        $updated = $DB->execute("UPDATE {logstore_standard_log} SET browsername = '$namebrowser' WHERE id = $lastlogin_record->id");
    }
}
// ******* end code for browser name *********

// ******* code for stay toggle theme change color .
$color = $DB->get_record('navbar_color', ['userid' => $USER->id]);
if (!$color->color_mode) {
    $addclass = "fa-toggle-on";
} else {
    $addclass = "";
}

// ******* end code for stay toggle theme change color 
// ************** code for tracking progress *********************
$i = 0;
$y = 0;
$unique_track_ids = [];
$array = [];

$user_enrol_courses = enrol_get_users_courses($USER->id, $onlyactive = false, $fields = null, $sort = null);
foreach ($user_enrol_courses as $user_enrol_coursesss) {
    $array[] =  $user_enrol_coursesss->category;
}

$array = array_unique($array);

$array = array_values($array);

$student_enrolled_courses = implode(",", $array);

$student_enrolled_courses = trim($student_enrolled_courses, '"');
$enrol_courses = '';
for ($i = 0; $i < count($array); $i++) {
    $enrol_courses = $DB->get_records_sql(" SELECT * FROM {course_categories} WHERE id ='$array[$i]' AND parent != 0 ");
    if ($enrol_courses) {
        
        foreach ($enrol_courses as $enrol_courses1) {
            $enrol_courses2 = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id =$enrol_courses1->parent AND parent = 0");
            foreach ($enrol_courses2 as $enrol_tracks) {
                $unique_track_ids[] = $enrol_tracks->id;
            }
        }
    }
}

$unique_track_ids = array_unique($unique_track_ids);
$unique_track_ids = array_values($unique_track_ids);
// ************** code for tracking progress *********************

// ************* code for my activity graph********************
$jan = [];
$feb = [];
$march = [];
$april = [];
$may = [];
$jun = [];
$july = [];
$aug = [];
$sep = [];
$oct = [];
$nov = [];
$dec = [];


// $activity_log = $DB->get_records('course_modules_completion', ['userid' => $USER->id, 'completionstate' => 1]);
$activity_log = $DB->get_records('time_spend', ['userid' => $USER->id]);
if ($activity_log) {
    foreach ($activity_log as $activity_log1) {
        $month = date("m", $activity_log1->date);

        if ((int)$month == 12) {
            $dec[] = $activity_log1->duration;    // duration get in seconds
        }
        if ((int)$month == 11) {
            $nov[] = $activity_log1->duration;
        }
        if ((int)$month == 10) {
            $oct[] = $activity_log1->duration;
        }
        if ((int)$month == 9) {
            $sep[] = $activity_log1->duration;
        }
        if ((int)$month == 8) {
            $aug[] = $activity_log1->duration;
        }
        if ((int)$month == 7) {
            $july[] = $activity_log1->duration;
        }
        if ((int)$month == 6) {
            $jun[] = $activity_log1->duration;
        }
        if ((int)$month == 5) {
            $may[] = $activity_log1->duration;
        }
        if ((int)$month == 4) {
            $april[] = $activity_log1->duration;
        }
        if ((int)$month == 3) {
            $march[] = $activity_log1->duration;
        }
        if ((int)$month == 2) {
            $feb[] = $activity_log1->duration;
        }
        if ((int)$month == 1) {
            $jan[] = $activity_log1->duration;
        }
    }

    $activity_log_array = [round(array_sum($jan) / 3600, 2), round(array_sum($feb) / 3600, 2), round(array_sum($march) / 3600, 2), round(array_sum($april) / 3600, 2), round(array_sum($may) / 3600, 2), round(array_sum($jun) / 3600, 2), round(array_sum($july) / 3600, 2), round(array_sum($aug) / 3600, 2), round(array_sum($sep) / 3600, 2), round(array_sum($oct) / 3600, 2), round(array_sum($nov) / 3600, 2), round(array_sum($dec) / 3600, 2)];

    // var_dump($activity_log_array);
    // var_dump(array_sum($activity_log_array));
    // echo gmdate("H:i:s", array_sum($activity_log_array));

    // die;
    $highest_value =  max($activity_log_array);
    $activity_log_array_string =  implode(",", $activity_log_array);
}




// *************** end code for my activity graph *******************

// code for achivements for certificate
$completed_track = 0;
for ($y = 0; $y < count($unique_track_ids); $y++) {
    $course_count = 0;
    $course_completed = [];
    if ($DB->record_exists('course_categories', ['id' => $unique_track_ids[$y]])) {
        $enrol_track_names = $DB->get_record('course_categories', ['id' => $unique_track_ids[$y]]);

        for ($i = 0; $i < count($array); $i++) {
            $enrol_courses = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$i]' AND parent = $enrol_track_names->id");

            if ($enrol_courses) {
                $module_record = $DB->get_records('course', ['category' => $enrol_courses->id]);

                $module_count = [];

                $total_module_in_course = 0;

                foreach ($module_record as $module_record1) {
                    $context = context_course::instance($module_record1->id);

                    if (is_enrolled($context, $USER->id, '', true)) {

                        $module_object = $DB->get_record('course', ['id' => $module_record1->id]);
                        $check = core_completion\progress::get_course_progress_percentage($module_object, $USER->id);
                        if ($check == 100) {
                            $module_count[] = $module_object->id;
                        }
                        $total_module_in_course++;
                    }
                }
                if (count($module_count) ==  $total_module_in_course) {
                    $course_completed[] = $enrol_courses->id;
                }
                $course_count++;
            }
        }
        if ($course_count == count($course_completed)) {
            $completed_track++;
            if (!$DB->record_exists('assign_badge', ['studentid' => $USER->id, 'course_id' => $enrol_track_names->id])) {
                $html = '
            <script src="jquery/jquery.min.js"></script>
    <script>
    $.ajax({
        type: "POST",
        url: "' . $CFG->wwwroot . '/local/public/assign_badge.php",
        dataType: "json",
        data: {
          studentid:' . $USER->id . ',
          trackid:' . $enrol_track_names->id . ',
          track_name: "' . $enrol_track_names->name . '",
          studentname:"' . $USER->firstname . '"
        
        },
        async: false,
        success: function(json) {
        
        }
    
    });
    </script>
    ';
                echo $html;
            }
        }
    }
}
// end code for achivements

// code for achievement for badges
$badgecount = 0;
for ($z = 0; $z < count($array); $z++) {
    $courses_enrolled = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$z]' AND parent != 0 AND visible = 1");
    if ($courses_enrolled) {
        $module_records = $DB->get_records('course', ['category' => $courses_enrolled->id]);
        $module_count = [];
        $total_module_in_category = 0;
        foreach ($module_records as $module_records1) {
            $context = context_course::instance($module_records1->id);
            if (is_enrolled($context, $USER->id, '', true)) {
                $course_object = $DB->get_record('course', ['id' => $module_records1->id]);
                $check = core_completion\progress::get_course_progress_percentage($course_object, $USER->id);
                if ($check == 100) {
                    $module_count[] = $course_object->id;
                }
                $total_module_in_category++;
            }
        }

        if ($total_module_in_category == count($module_count)) {
            $status = "completed";
            if (!$DB->record_exists('assign_badge', ['studentid' => $USER->id, 'course_id' => $courses_enrolled->id])) {
                $html = '
<script src="jquery/jquery.min.js"></script>
<script>
$.ajax({
type: "POST",
url: "' . $CFG->wwwroot . '/local/public/assign_badge.php",
dataType: "json",
data: {
    studentid:' . $USER->id . ',
    courseid:' . $courses_enrolled->id . ',
    coursename: "' . $courses_enrolled->name . '",
    studentname:"' . $USER->firstname . '"

},
async: false,
success: function(json) {

}
});
</script>
';
                echo $html;
            }
            $issued_badges = $DB->get_record('custom_badge', ['course_id' => $courses_enrolled->id]);
            if ($issued_badges) {
                $badgename = $issued_badges->badge_name;
            } else {
                $badgename = "not created";
            }
        }
    }
}
// end code for achievement for badges

// code for upcoming events
$events = $DB->get_records('event', ['eventtype' => 'site']);
//end
// $popular_courseid = $DB->get_records_sql("SELECT courseid,count(courseid) FROM {user_lastaccess} GROUP BY courseid ORDER count(courseid) DESC LIMIT 5");
$popular_courseid = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent !=0 AND visible = 1");

$bookmark_course = $DB->get_records_sql(" SELECT cc.name,cc.id,bc.time_created,cc.parent FROM {bookmark_course} bc JOIN {course_categories} cc ON cc.id = bc.courseid WHERE bc.userid = $USER->id ");
$self_login_report = $DB->get_records_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND action ='loggedin' ORDER BY lsl.id DESC LIMIT 4");
$notepaddata = $DB->get_records_sql("SELECT * FROM {notepad} WHERE userid = $USER->id  ORDER BY id DESC LIMIT 2");

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Dashboard</title>
    <link rel="stylesheet" href="amd/src/jquery.bxslider.css">
    <script src="amd/src/jquery.bxslider.min.js"></script>
    <link rel="stylesheet" href="student_css/owl.carousel.min.css">
    <link rel="stylesheet" href="student_css/owl.theme.default.min.css">
    <script src="student_css/owl.carousel.min.js"></script>
    <script src="amd/src/zingchart.min.js"></script>
</head>

<body>

    <div id="preloader"></div>


    <!-- <input type="hidden" id="toggleclass" value="<?php echo $addclass; ?>"> -->

    <input type="hidden" id="monthactivitydata" value="<?php echo  $activity_log_array_string; ?>">
    <input type="hidden" id="maxdata" value="<?php echo  $highest_value; ?>">

    <div class="container-fluid p-0">
        <div class="dashboard-main">
            <div class="row">

                <div class="col-12 col-md-12 col-lg-12">
                    <!-- <div class="right-section-fixed"> -->
                    <div class="latest-announcement bg-grey">
                        <div class="latest-announcement-content">
                            <h2>Latest Announcement</h2>
                        </div>
                        <div class="marque">
                            <marquee behavior="" direction="">
                                <div style="display: flex;">
                                    <?php echo latest_announcement(); ?>
                                </div>
                            </marquee>
                        </div>
                    </div>
                    <!-- </div> -->
                    <div class="right-section">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="tracking-progress bg-grey margin-top-25">
                                    <div class="col-md-12 p-0">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <h2 class="horizontal-line heading">Track Progress</h2>
                                            <div class="my-course-cutom float-right">
                                                <a href="view_all_tracks.php">
                                                    <h5 class="mb-0 view-all-student">View All</h5>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="text-center d-flex mt-3 flex-wrap flex-lg-nowrap">
                                            <?php

                                            for ($y = 0; $y < count($unique_track_ids); $y++) {

                                                if ($DB->record_exists('course_categories', ['id' => $unique_track_ids[$y], 'visible' => 1])) {
                                                    $course_completed = 0;
                                                    $total_enrolled_courses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id IN ($student_enrolled_courses) AND parent = $unique_track_ids[$y] AND visible = 1");
                                                    if ($total_enrolled_courses) {
                                                        # code...

                                                        $enrol_track_names = $DB->get_record('course_categories', ['id' => $unique_track_ids[$y]]);

                                                        $total_completed_activity1 = [];
                                                        $total_activities = 0;
                                                        $percentage_of_completion = 0;
                                                        for ($i = 0; $i < count($array); $i++) {

                                                            $enrol_courses = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$i]' AND parent = $enrol_track_names->id");
                                                            if ($enrol_courses) {
                                                                $modules_in_course = 0;
                                                                $completed_moduleincourse = 0;
                                                                $module_record = $DB->get_records('course', ['category' => $enrol_courses->id]);
                                                                foreach ($module_record as $module_record1) {

                                                                    $context = context_course::instance($module_record1->id);

                                                                    if (is_enrolled($context, $USER->id, '', true)) {



                                                                        $module_object = $DB->get_record('course', ['id' => $module_record1->id]);

                                                                        $check = core_completion\progress::get_course_progress_percentage($module_object, $USER->id);
                                                                        if ($check == 100) {
                                                                            $completed_moduleincourse++;
                                                                        }
                                                                        $module_activityid = $DB->get_records_sql("SELECT * FROM {course_modules} WHERE course = $module_record1->id AND module != 10 AND deletioninprogress = 0");

                                                                        $total_activities = count($module_activityid) + $total_activities;
                                                                        foreach ($module_activityid as $module_activityid1) {
                                                                            $completed_activity = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $USER->id AND  completionstate = 1 AND coursemoduleid = $module_activityid1->id");

                                                                            // foreach($completed_activity as $completed_activity1){
                                                                              
                                                                            if ($completed_activity) {
                                                                                $total_completed_activity1[] = $completed_activity->id;
                                                                            }
                                                                            // }
                                                                        }
                                                                        $modules_in_course++;
                                                                    }
                                                                }
                                                                if ($modules_in_course == $completed_moduleincourse) {
                                                                    $course_completed++;
                                                                }
                                                            }
                                                        }


                                                        $percentage_of_completion = (count($total_completed_activity1) / $total_activities) * 100;

                                                        if (is_nan($percentage_of_completion)) {
                                                            $percentage_of_completion = 0;
                                                        }
                                            ?>
                                                        <div class="circle-student">
                                                            <div tooltip="<?php echo $course_completed . "/" . count($total_enrolled_courses); ?>" flow="right">
                                                                <div class="circle_percent" data-percent="<?php echo round($percentage_of_completion); ?>" title="">
                                                                    <div class="circle_inner">
                                                                        <div class="round_per"></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <p class="mb-1"><?php echo $enrol_track_names->name; ?></p>
                                                            <input type="hidden" id="trackname" value="<?php echo $enrol_track_names->id; ?>">
                                                            <p><a href="#demo" data-toggle="collapse" class="view-details-student">View Detail...</a></p>
                                                        </div>

                                            <?php
                                                    }
                                                }
                                                if ($y > 2) {
                                                    break;
                                                }
                                            }
                                            ?>

                                        </div>
                                        <div class="slide-table mt-2">
                                            <div class="table-heading d-flex align-items-center justify-content-between mb-2">
                                                <h6 class="mb-0" id="nameoftrack"></h6>
                                                <div class="calendar-cross-icon cross"><a href="javascript:void(0);"><i class="fa fa-times" aria-hidden="true"></i></a></div>
                                            </div>
                                            <div class="table-responsive">
                                                <table class="w-100">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-white">Course Name</th>
                                                            <th class="text-white">Progress</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="trackdata_body">
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="d-flex justify-content-evenly">
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="left bg-grey w-100 w-lg-50 w-md-50 border-radius-5 padding mb-3 height375" id="ActivityActivityActivityActivity">
                                                    <div class="d-flex justify-content-between">
                                                        <div class="heading-left">
                                                            <h2 class="horizontal-line text-white heading activity">Your Activity</h2>
                                                        </div>
                                                        <div class="heding-right">
                                                            <select class="select bg-grey text-white border-radius-5 " id="activity_data" onchange="get_activity_graph()">
                                                                <option value="0" disabled>Select</option>
                                                                <option value="1">Month Wise</option>
                                                                <option value="2">Week Wise</option>
                                                                <option value="3">Last 10 days</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="chart">
                                                        <div class="row g-0 align-items-center justify-content-center">
                                                            <div class="col-lg-10">
                                                                <div class="chart-left scrollable" style="overflow-y: hidden !important;">
                                                                    <div id="myChart" style="overflow: visible !important;"></div>
                                                                    <div id="activity_new" style="overflow: visible !important;display:none;"></div>
                                                                    <!-- <canvas id="activity" style="width:100%;max-width:600px"></canvas>
                                                                    <canvas id="activity_new" style="width:100%;max-width:600px;display:none"></canvas> -->
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <div class="wewwrwrwe">
                                                                    <p class="mb-0">Total<br>Time Spent</p>
                                                                    <h4 class="mb-0" id="totaltimespend"><?php
                                                                    if (array_sum($activity_log_array)) {
                                                                        echo array_sum($activity_log_array);
                                                                    }
                                                                    else {
                                                                        echo 0;
                                                                    }
                                                                  ?> 
                                                                    
                                                                    h</h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="left bg-grey w-100 w-md-50 w-lg-50 border-radius-5 padding mt-4 Achievements-section-main">
                                                    <div class="d-flex justify-content-between flex-wrap flex-lg-nowrap flex-md-nowrap AchievementsAchievements">
                                                        <div class="heading-left">
                                                            <h2 class="horizontal-line text-white heading achievements">Achievements
                                                            </h2>
                                                        </div>
                                                        <div class="heading-left">
                                                            <div class="d-flex ms-0 ms-md-5 ms-lg-5">
                                                                <div class="certificate">
                                                                    <p class="text-white">Certificate</p>
                                                                </div>
                                                                <div class="certificate mx-3">
                                                                    <p class="text-white"><i class="fa fa-toggle-off off badges-on-off"></i></p>
                                                                </div>
                                                                <div class="certificate">
                                                                    <p class="text-white">Badges</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="heading-left">
                                                            <span><a href="allachievements.php"><i class="fa fa-share-square-o  icon-color" title="view all"></i></a></span>
                                                        </div>
                                                    </div>
                                                    <div class="left-on">
                                                        <div class="row mt-2 justify-content-evenly align-items-center flex-wrap flex-lg-nowrap">
                                                            <div class="col-lg-7 certificate-slider">
                                                                <div class="slider">
                                                                    <?php
                                                                    // if ($DB->record_exists('assign_certificate',['studentid'=>$USER->id])) {
                                                                    // $assign_certificates =  $DB->get_records('assign_badge', ['studentid' => $USER->id, 'type' => 'track']);
                                                                    $assign_certificates =  $DB->get_records_sql("SELECT ab.* FROM {assign_badge} ab JOIN {custom_certificate} cc ON cc.track_id = ab.course_id WHERE ab.studentid = $USER->id AND ab.type = 'track' LIMIT 5");

                                                                    if ($assign_certificates) {
                                                                        $i = 1;
                                                                        foreach ($assign_certificates as $assign_certificate_value) {

                                                                    ?>
                                                                            <a href="certificate.php?trackid=<?php echo $assign_certificate_value->course_id; ?>">
                                                                                <div class="slide"><img src="student_images/blur_certificate_template.jpg" alt="" width="100%"></div>
                                                                            </a>

                                                                    <?php
                                                                    $i++;
                                                                        }
                                                                    }
                                                                    ?>

                                                                </div>

                                                            </div>
                                                            <div class="col-lg-5 certificate-details mt-2 mt-lg-0">
                                                                <div class="certificate-content text-center">
                                                                    <h3 class="text-white">Certificate</h3>
                                                                    <h4 class="text-white"><?php echo count($assign_certificates); ?></h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    if (count($assign_certificates) == 0) {
                                                        echo '<script>
                                                                                    var divsToHide = document.getElementsByClassName("left-on"); //divsToHide is an array
                                                                                    for(var i = 0; i < divsToHide.length; i++){
                                                                                        divsToHide[i].style.setProperty("display", "none", "important"); 
                                                                                    } 
                                                                                    </script>';
                                                    }
                                                    ?>

                                                    <div class="right-on">


                                                        <div class="row mt-2 justify-content-evenly align-items-center flex-wrap flex-lg-nowrap">
                                                            <div class="col-lg-7 certificate-slider">
                                                                <div class="owl-carousel">
                                                                    <?php
                                                                    //   if ($DB->record_exists('assign_badge',['studentid'=>$USER->id])) {
                                                                    // $assign_badges =  $DB->get_records('assign_badge', ['studentid' => $USER->id]);
                                                                    $assign_badges =  $DB->get_records_sql("SELECT cb.* FROM {assign_badge} ab JOIN {custom_badge} cb ON  cb.course_id = ab.course_id WHERE ab.studentid = $USER->id AND ab.type='course' LIMIT 5");
                                                                    if ($assign_badges) {
                                                                        foreach ($assign_badges as $assign_badge_value) {
                                                                    ?>
                                                                            <?php

                                                                            ?>
                                                                            <div class="item">
                                                                                <img src="<?php echo $assign_badge_value->badgepath; ?>" alt="" width="50%">
                                                                            </div>
                                                                    <?php
                                                                        }
                                                                    }


                                                                    ?>
                                                                </div>
                                                            </div>



                                                            <div class="col-lg-5 certificate-details mt-2 mt-lg-0left bg-grey border-radius-5 padding">
                                                                <div class="certificate-content text-center">
                                                                    <h3 class="text-white">Badges</h3>
                                                                    <h4 class="text-white"><?php echo count($assign_badges); ?></h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php

                                                    if (count($assign_badges) == 0) {
                                                        echo '<script>
                                                            var divsToHide = document.getElementsByClassName("right-on"); 
                                                            for(var i = 0; i < divsToHide.length; i++){
                                                                divsToHide[i].style.setProperty("display", "none", "important"); 
                                                            }
                                                            </script>';
                                                    }

                                                    ?>
                                                </div>
                                                <div class="left bg-grey w-100 border-radius-5 padding mt-4">
                                                    <div class="d-flex justify-content-between">
                                                        <div class="heading-left">
                                                            <h2 class="horizontal-line text-white heading bookmark">Bookmark Courses</h2>
                                                        </div>
                                                    </div>
                                                    <div class="bookmark-section scrollable  mt-3">
                                                        <?php
                                                        foreach ($bookmark_course as $bookmark_courses) {
                                                            // $dt = new DateTime($bookmark_courses->time_created);

                                                        ?>

                                                            <div class="bookmark-boxes">
                                                                <div class="bokmark-box d-flex justify-content-between">
                                                                    <div class="book-content">
                                                                        <a href="<?php echo $CFG->wwwroot . '/local/report/modules.php?id=' . $bookmark_courses->id . '&trackid=' . $bookmark_courses->parent; ?>">
                                                                            <p class="text-white mb-0"><?php echo $bookmark_courses->name; ?></p>
                                                                        </a>
                                                                    </div>
                                                                    <div class="del-icon">
                                                                        <input type="hidden" id="deletebookmark" value="<?php echo $bookmark_courses->id; ?>">
                                                                        <a href="javascript:void(0);"><i class="fa fa-trash text-white delete" aria-hidden="true"></i></a>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        <?php
                                                        }
                                                        ?>



                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="left bg-grey overflow-hidden w-100 w-lg-50 w-md-50 border-radius-5 padding mt-4 mt-lg-0" id="Lab-Requests-Status">
                                                    <div class="d-flex justify-content-between">
                                                        <div class="heading-left">
                                                            <h2 class="horizontal-line text-white heading lab-request">Lab Requests Status
                                                            </h2>
                                                        </div>
                                                        <div class="heding-right">
                                                            <span><a href="javascript:void(0);"><i class="fa fa-share-square-o  icon-color" title="view all"></i></a></span>
                                                        </div>
                                                    </div>
                                                    <div class="">
                                                        <table class="leaderboard-table">
                                                            <tbody>
                                                                <tr>
                                                                    <th class="text-white">Id</th>
                                                                    <th class="text-white">Lab/Secanrio Name</th>
                                                                    <th class="text-white">Status</th>
                                                                    <th></th>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td><a href="javscript:void(0);" class="view-courses">Go to lab</a></td>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td><a href="javscript:void(0);" class="view-courses">Go to lab</a></td>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td><a href="javscript:void(0);" class="view-courses">Go to lab</a></td>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td><a href="javscript:void(0);" class="view-courses">Go to lab</a></td>
                                                                </tr>
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td><a href="javscript:void(0);" class="view-courses">Go to lab</a></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="equal-height gap-4 margin-top-25 flex-wrap flex-lg-nowrap flex-md-nowrap mt-4">
                                                    <div class="right bg-grey w-100 w-md-50 w-lg-50 border-radius-5 padding padding-bottom-150">
                                                        <div class="d-flex justify-content-between">
                                                            <div class="heading-left">
                                                                <h2 class="horizontal-line text-white heading top-courses">Top Courses</h2>
                                                            </div>
                                                            <div class="heding-right">
                                                                <span><a href="alltop_modules.php"><i class="fa fa-share-square-o  icon-color" title="view all"></i></a></span>
                                                            </div>
                                                        </div>
                                                        <div class="mt-4 ">
                                                            <?php foreach ($popular_courseid as $popular_courseid1) {
                                                                $student_count = [];
                                                                $popular_modules = $DB->get_records('course', ['category' => $popular_courseid1->id, 'visible' => 1]);
                                                                foreach ($popular_modules as $popular_modules_value) {

                                                                    $context = get_context_instance(CONTEXT_COURSE, $popular_modules_value->id);
                                                                    $students = get_role_users(5, $context);
                                                                    $student_count[] = count($students);
                                                                }
                                                                $top_courses[$popular_courseid1->name] = array_sum($student_count);
                                                            }
                                                            arsort($top_courses);
                                                            $i = 0;
                                                            foreach ($top_courses as $coursename => $enrolledstudent) {
                                                                if ($i >= 5) {
                                                                    break;
                                                                }
                                                                $i++;
                                                                if ($popular_courseid1->text) {
                                                                    $description = $popular_courseid1->text;
                                                                } else {
                                                                    $description = "no description";
                                                                }


                                                            ?>
                                                                <div class="top-courses-content d-flex justify-content-between border-bottom px-4">
                                                                    <div class="d-flex mb-2 mt-2">
                                                                        <div class="box-color"></div>
                                                                        <div class="top-courses-paragraph">
                                                                            <p class="text-white ms-3 mb-0"><?php echo $coursename; ?></p>
                                                                            <p class="text-white ms-3 mb-0" style="font-size:0.75rem"><?php echo  $enrolledstudent; ?> users active</p>
                                                                        </div>
                                                                    </div>
                                                                    <div class="top-courses-link">

                                                                    </div>
                                                                </div>
                                                            <?php }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>


                            <div class="equal-height d-flex gap-4 margin-top-25 flex-wrap flex-lg-nowrap flex-md-nowrap">
                                <div class="left bg-grey w-100 w-lg-50 w-md-50 border-radius-5 padding">
                                    <div class="d-flex justify-content-between mb-3">
                                        <div class="heading-left">
                                            <h2 class="horizontal-line text-white heading notes-line">Notes</h2>
                                        </div>
                                        <div class="heding-right">
                                            <span><a href="all-notes-view.php"><i class="fa fa-share-square-o  icon-color" title="view all"></i></a></span>
                                        </div>
                                    </div>
                                    <div class="notes-content">
                                        <textarea name="" id="" cols="67" rows="4" class="textarea py-2" placeholder="Enter Notes"></textarea>
                                        <button class="save-node mt-2">Save Note</button>
                                        <span id="empty_error" style="color:red;"></span>

                                    </div>
                                    <div class="scrollable nodes">
                                        <div class="textarea-content" id="textareacont">
                                            <h3 class="notes horizontal-line all-notes mb-2">All Notes</h3>
                                            <div class="ps-2 newnotes">
                                                <?php $i = 1; ?>
                                                <?php foreach ($notepaddata as $notepadata) { ?>
                                                    <p class="mb-3 d-flex  justify-content-start"><b><?php echo $i++ ?>. &nbsp;&nbsp;</b> <span><?php echo $notepadata->note; ?></span></p>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="right bg-grey w-100 w-lg-50 w-md-50 border-radius-5 padding LeaderboardLeaderboard">
                                    <h2 class="horizontal-line text-white heading leaderboard ">Leaderboard</h2>
                                    <div class="scrollable table-leaderboard mt-3">
                                        <table class="leaderboard-table">
                                            <tr>
                                                <th></th>
                                                <th>Name</th>
                                                <th>Rank</th>
                                                <th>Score</th>
                                            </tr>
                                            <?php
                                            $i = 0;
                                            $userid_array = [];

                                            if ($user_enrol_courses) {

                                                foreach ($user_enrol_courses as $user_enrol_courses1) {
                                                    $context = context_course::instance($user_enrol_courses1->id);
                                                    $enrolled_users = get_enrolled_users($context, $options = array());
                                                    foreach ($enrolled_users as $enrolled_users1) {
                                                        $userid_array[] = $enrolled_users1->id;
                                                    }
                                                }

                                                $all_userid = implode(",", array_unique($userid_array));

                                                $gradecount = $DB->get_records_sql("SELECT u.id, SUM(gg.finalgrade) AS total_score,u.firstname,u.lastname,u.id as studentid FROM {user} u  JOIN {grade_grades} gg ON u.id =  gg.userid  WHERE gg.userid IN ($all_userid) AND gg.rawgrade > 0 GROUP BY gg.userid  ORDER BY SUM(gg.finalgrade) DESC");


                                                if ($gradecount) {

                                                    foreach ($gradecount as $gradecount1) {
                                                        $totalgrade = $gradecount1->total_score;
                                                        $whole_totalgrade =  round($totalgrade);
                                                        $i++;
                                            ?>
                                                        <tr>
                                                            <td><img src="<?php echo new moodle_url('/user/pix.php/' . $gradecount1->studentid . '/f1.jpg') ?>" alt="" srcset="" style="width:23px;height:23px; border-radius: 50%; overflow: hidden;"> </td>
                                                            <td><?php echo  $gradecount1->firstname . " " . $gradecount1->lastname; ?></td>
                                                            <td><?php echo $i; ?></td>
                                                            <td><?php echo  $whole_totalgrade; ?></td>
                                                        </tr>
                                            <?php
                                                    }
                                                }
                                            }
                                            ?>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <section class="login Activity bg-grey">
                                    <div class="status">
                                        <div class="status-info">
                                            <h2 class="horizontal-line text-white heading login-activty">Login Activity</h2>
                                            <span>
                                            <button class="btn btn-primary" id="bulklogout">Bulk Logout</button>   
                                                <a href="alllogin_activity.php">
                                                    <i class="fa fa-share-square-o  icon-color" title="view all"></i>
                                                </a>
                                            </span>


                                        </div>


                                        <div class="scrollable activity-table">
                                            <table class="">
                                                <tr>
                                                    <!-- <th>
                                                        <div class="form-group">
                                                            <input type="checkbox" id="html5">
                                                            <label for="html5"></label>
                                                        </div>
                                                    </th> -->
                                                    <th><input type="checkbox" disabled value=""></th>
                                                    <th>No</th>
                                                    <th>Date | Time</th>
                                                    <th>Location</th>
                                                    <th>IP Address</th>
                                                    <th>User Agent</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                                <?php
                                                $count = 1;
                                                foreach ($self_login_report as $self_login_report1) {
                                                    $user_ip = $self_login_report1->ip;
                                                    $json     = file_get_contents("http://ipinfo.io/$user_ip/geo");
                                                    $json     = json_decode($json, true);
                                                    $city     = $json['city'];

                                                    if ($self_login_report1->browsername == "Chrome") {
                                                        $filename = "chrome";
                                                    }
                                                    if ($self_login_report1->browsername == "Firefox") {
                                                        $filename = "firefox";
                                                    }
                                                    if ($self_login_report1->browsername == "Edge") {
                                                        $filename = "microsoft";
                                                    }
                                                    if ($self_login_report1->browsername == "Compass") {
                                                        $filename = "compass";
                                                    }
                                                    if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $self_login_report1->timecreated, 'firstip' => $self_login_report1->ip])) {
                                                        $disable = '';
                                                        $checkboxvalue =  $self_login_report1->timecreated."_".$self_login_report1->ip;
                                                     }
                                                     else {
                                                        $disable = 'disabled';
                                                        $checkboxvalue =  '';
                    
                                                     }
                                                ?>
                                                    <tr>
                                                         <td>
                                                            <!--<div class="form-group">
                                                                <input type="checkbox" id="html6">
                                                                <label for="html6"></label>
                                                            </div>-->
                                        <input type="checkbox" <?= $disable ?> value="<?= $checkboxvalue ?>">

                                                        </td> 
                                                        <td><?php echo $count; ?></td>
                                                        <td><?php echo date('d-m-Y | h:i:s A', $self_login_report1->timecreated); ?></td>
                                                        <td><?php echo $city; ?></td>
                                                        <td><?php echo $user_ip; ?></td>

                                                        <?php if ($self_login_report1->browsername) { ?>

                                                            <td>
                                                                <center>
                                                                    <div class="flexxxxx" style="display: block;">
                                                                        <div><img src="images/<?php echo $filename; ?>.png" alt="chrome"></div>
                                                                        <!-- <div><?php echo $self_login_report1->browsername; ?></div> -->
                                                                    </div>
                                                                </center>
                                                            </td>

                                                        <?php  } else { ?>
                                                            <td></td>
                                                        <?php  }  ?>

                                                        <?php
                                                        if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $self_login_report1->timecreated, 'firstip' => $self_login_report1->ip])) { ?>
                                                            <td>
                                                                <div class="active-green">Active</div>
                                                            </td>
                                                            <td>
                                                                <span onClick="javascript:return confirm('are you sure you want to delete this session?');">

                                                                    <a href="<?php echo $CFG->wwwroot . '/local/public/delete_session.php?timecreated=' . $self_login_report1->timecreated . '&ip=' . $self_login_report1->ip . '' ?>">
                                                                        <i class="fa fa-power-off" aria-hidden="true">
                                                                        </i>
                                                                    </a>
                                                                </span>
                                                            </td>

                                                        <?php  } else { ?>
                                                            <td>
                                                                <div class="active-cream">Inactive</div>
                                                            </td>
                                                            <td>
                                                                <span>

                                                                    <a href="#" style="pointer-events:none">
                                                                        <i class="fa fa-power-off" aria-hidden="true">
                                                                        </i>
                                                                    </a>
                                                                </span>
                                                            </td>
                                                        <?php   } ?>
                                                    </tr>
                                                <?php
                                                    $count++;
                                                }
                                                ?>

                                            </table>
                                        </div>

                                    </div>
                                </section>
                                <div class="fixed-full scrollable">
                                    <div class="fixedd">
                                        <div class="calendar-cross-icon"><a href="javascript:void(0);"><i class="fa fa-times" aria-hidden="true"></i></a></div>
                                        <div class="clock">
                                            <div id="Date"></div>
                                            <ul class="ull">
                                                <li class="lii" id="hours"></li>
                                                <li class="lii" id="point">:</li>
                                                <li class="lii" id="min"></li>
                                                <li class="lii" id="point">:</li>
                                                <li class="lii" id="sec"></li>
                                                <li class="lii" id="ampm"></li>
                                            </ul>
                                        </div>
                                        <div id="calendar"></div>
                                        <!-- <div class="calendar-btn"><a href="#" class="create-event">Create Event</a></div> -->
                                    </div>
                                    <div class="upcomming-events p-4">
                                        <p>Upcomming Events</p>
                                    </div>
                                    <div class="">
                                        <div class="upcomming-events-details px-4">
                                            <div class="">
                                                <?php
                                                foreach ($events as $events_data) {

                                                    if ($events_data->timestart >= time()) {
                                                ?>
                                                        <div class="event-one d-flex justify-content-between">
                                                            <div class="event-one-details">
                                                                <p class="mb-0"><?php
                                                                                echo $events_data->name;
                                                                                ?></p>
                                                                <span><?php
                                                                        echo date('d-M-Y', $events_data->timestart);
                                                                        ?></span>
                                                            </div>
                                                            <div class="event-view-details">
                                                                <a href="<?php echo $CFG->wwwroot . '/calendar/view.php?view=month'; ?>">
                                                                    <i class="fa fa-angle-right" aria-hidden="true"></i>
                                                                </a>

                                                            </div>
                                                        </div>
                                                        <div class="border-bottm">

                                                        </div>
                                                <?php
                                                    }
                                                }
                                                ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <section>
                                    <div class="calendar-icon">
                                        <a href="javascript:void(0);">
                                            <i class="fa fa-calendar" aria-hidden="true"></i>
                                        </a>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="chart/Chart.min.js"></script>
    <script src="amd/src/datepicker.min.js"></script>

</body>

</html>
<?php
echo $OUTPUT->footer();
?>