/*
All of the code within the ZingChart software is developed and copyrighted by ZingChart, Inc., and may not be copied,
replicated, or used in any other software or application without prior permission from ZingChart. All usage must coincide with the
ZingChart End User License Agreement which can be requested by email at support@zingchart.com.

Build 2.9.10
*/
if (typeof ZC === "undefined") {
    if (
        ((window.ZC = {
            AV: function (e, i) {
                if (e.indexOf) return e.indexOf(i);
                for (var t = 0, n = e.length; t < n; t++) if (e[t] === i) return t;
                return -1;
            },
            VERSION: "2.9.10",
            VERSIONID: "2.9.10.2022.10.18",
            LICENSEKEY: "",
            ABV: !1,
            CHARTS: [
                "null",
                "null3d",
                "line",
                "line3d",
                "vline",
                "area",
                "area3d",
                "varea",
                "bar",
                "bar3d",
                "vbar",
                "vbar3d",
                "hbar",
                "hbar3d",
                "scatter",
                "hscatter",
                "bubble",
                "hbubble",
                "pie",
                "pie3d",
                "ring",
                "ring3d",
                "nestedpie",
                "mixed",
                "mixed3d",
                "hmixed",
                "radar",
                "bullet",
                "vbullet",
                "hbullet",
                "funnel",
                "vfunnel",
                "hfunnel",
                "piano",
                "heatmap",
                "stock",
                "range",
                "vrange",
                "gauge",
                "venn",
            ],
            EQUIV: {
                floatbar: ["vfloatbar", "hfloatbar"],
                boxplot: ["vboxplot", "hboxplot"],
                waterfall: ["vwaterfall", "hwaterfall"],
                populationpyramid: ["population-pyramid", "pop-pyramid"],
                bubblepie: ["bubble-pie", "bubblepie"],
                bar: ["column", "vbar"],
                radar: ["polar", "radar"],
                stream: ["vstream"],
            },
            ALIAS: { ring: "pie" },
            execFn: function (e, i) {
                var t = [].slice.call(arguments).splice(2);
                return ZC.evalFn(e, i).apply(i, t);
            },
            evalFn: function (e, i) {
                for (var t = e.split("."), n = t.pop(), a = 0; a < t.length; a++) i = i[t[a]];
                return i[n];
            },
            cache: {
                data: {},
                size: 0,
                add: function (e, i) {
                    (ZC.cache.data[e] = i), ZC.cache.size++, ZC.cache.size > 2048 && ((ZC.cache.data = {}), (ZC.cache.size = 0));
                },
            },
            DEBUG: 0,
            TS: {},
            MAX: Number.MAX_VALUE,
            IMG404: [],
            BLANK: "data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",
            TTLOCK: !1,
            REFRESH_TICK: {},
            ASYNC_TICK: [],
            COLORS: [],
            SEQ: 0,
            LOGO_ABOUT:
                "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJEAAAA1CAYAAABBVQnbAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABu1JREFUeNrsXLFy4zYQBW9UR7wfSHh1iqMn6S3NxLXlLp3lL5D1ARlLkw+Q/QWiu3TW1Sqk65M5ukh9vPzAUV+gLMilDUMgAYigZUm7MzAliiDBxcPu2+XS3nq9ZiQkdaTF/3iet/UJ/vjr5wKFyz9//7dLKj0u4UboHamBpK54HEm2lgisTwgbH78ucBtDG+LnFKxSTOo9DkvU2rLvBFpH2hcKgFpCI9d2JELujMQNsd5CRFdVWKRU2G/syv7+hQWw6ePX6Nd/WELTcgScyGV0BiDqCG6wCyBa0rRQdEZC7sxaxri1ckNggRYKcr6A/ZlVA4tExPxYQAQubERqJBDtSu6hfYb2k0isoX2ztWoke06s6woRayLWJCQ5kkhIyBKR7FQIRCQEIpJjCPFn/xWR15D1fqTyEALRVtLBrU/qJhDZWB8OmFDaG8J+vk3JIhGITEQsUCtkgtslo4K1wwMRxPoBbAIXJ/Q8b3mQmpqvevD3VGFhuVV95PaXnbXTkr6h5M7j0mP3UDxMNo6g3TgCkSe5tiKb2QU3ttxD8PRRN7pFxkFxB+AYKc4hVyx04biDWGx1aqwPX+Yrbjmm0HqGPfwMbPPVOYIkPRA9yAZmYwG8Boi6gtnfJ1koXBeXhD1XGagDCN53vuoeksvabYi/ny5sogAHv4/xhhvK+c5UOj7E1Ts8BhC5zljv/8qbrzh3uZb2RgAeNY85a8dobWVLe40u8TgsEXDhEZJrHYnq46rTuS4XhK0nrW7uQmYw1lTTL5R4jFE/QQYK91VtUbjbmq8u4NNX2Q6zvNCuind1hPtMMot31k4MwB5iv0CylvaRXz6O3tO5VMGBLjozKUrDyVmw8szzFZwnEo5X1VA/RW9rdQ3KGBUxLYmGuHKG4nWk8aleqiz6XSFA5N/HuIgKZX6X7wuUGhlOxoME4FvoO1RGZ88uT6XPKAOuCgxm0aK6/8txLDPrukmci/EtDO54vP7th1HL0CpYAaiGnGtSDVnEBONJ4Xozi/Hx/Q9MX3bb2wCfKYByGWZhvt69T0pIeyF9/P1EAsGUPZcSM03/Hhx/UmnVcu533TixhgnyNRM0dgQgplGsPAkzYXwPzOzZnC7X81FBps0ln7DE4j7FFz7lhGSYWZ0CxLkF6pdEiin27WykHHILXKaLTuPRmQGAoidX8LoScOsD145xJQUVRD+2UJYM4scG7+Gly8ldqZxWOBc41UBB9q8UPEmcr54GRIXwBXn/ZDnzAMIzyhNVVTYKAAorAHTVgHL5pHOS+gEVkGqUcFnmWmB876F18Vzb5KmaijbjDAAiZ8k/jxVuWAXwZANAz5HirKR/mfBxXECbZeDYIpPe0riMsGKim8qBXMDEFy4hQv6tighD+C0usUJLOMetQOYTOFYVPe0KRHcl7nAGK98k8k0dUIKCXNemIq0SK1RF4LK8iEXIbCMzAUCi37flOJ8UUWGCoLNRctAQiBLrHioLkbvAIswP0CoHtcFcF0Sg6FEFgNIGAeSSg8RbWhZ5ctuW+ZZAmsQUXYwbyUHTR67kghQvnYMIk4k3OwKQS/Edgdh2omT9RRXE1hZAfaQYvmbx+MbWyNGzvXcSgKYaAL21h6hpRb5JFSiEliszxIjHVE6l798cAShQAChBIt7N8klnbQ/aCdvBK+hFUVqR7S1l8G8QQJznxCUvX/Zg/5005onWQnHXM18l0kq+wWjRZKI7TbgLtHD+i5CcR1RvRAp3VpUL4qt9AJMyMDznvcPkoxEZZ5uZ5iw9AWPm41ihhTB1TWPJIvdeJP3KZbrBr9wVnn20IMTBrkDka/iFDTf4/Mr3cMfUhWN83PYpfQ6W+epSuudpRmrP2rclZFf1zG7cIMfzS6zh9SuAyLfJE+2F8JpusDi3zMEzINF9Q/siKWwCkzRAy/coWIi+QrFO8i/SwpRBHeB1YixfuVRG1TmnSxwWyN0IJS7c9S8PojwWgDREblQFpIiZPi/iz8B4ZeKmmw8MwBobcSg7iaSoz3/isOXJyUK+sHpv2CQbwcaz686qLg7mNWoOJJY/9b5FpaWogBlGlnahdp7f+WBJjiPWRH11/mDXZPwp3r/La0dM88io1YD/LpR+r+FHY4MQWwxllcdiZClai09I7uPapDMHQ1dwFx3FORIcy11FYlHWRWKol0Tiavz8A+SAvgCcGK8xwwI50SqLlQK6OSmTLrrKU+m6yyJ/stcWCMb/sFaLLx3XKTmuZ31RzkdyTnL0khU17vrf7Tm4iT5TJ0kTXHlc2iUEmBe3vSco1APRIVgiH9rX9XbSJxgQiIob4WUh3y0BNCEIEIhUFmlqACbOoTo0/cSJtJZJwX8O959NvAUQkZDUkf8FGADBt38P1SQKxwAAAABJRU5ErkJggg==",
            IMAGES: {
                "zc.logo":
                    "data:image/gif;base64,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",
            },
            hosted: !1,
            adapter: "",
            flash: null,
            canvas: null,
            svg: null,
            vml: null,
            move: !1,
            objmove: !1,
            compat: function () {
                ZC.flash = ZC.canvas = ZC.svg = ZC.vml = !1;
                var e = !!document.createElement("canvas").getContext,
                    i = !1;
                e && (i = "function" == typeof document.createElement("canvas").getContext("2d").fillText);
                (ZC.canvas = e && i), (ZC.svg = document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure", "1.1"));
                var t = document.body.appendChild(document.createElement("div")),
                    n = document.createElement("zcv:shape");
                (n.className = "zcvml"),
                    n.setAttribute("id", "vml_flag1"),
                    n.setAttribute("adj", new Object()),
                    t.appendChild(n),
                    (n.style.behavior = "url(#default#VML)"),
                    (ZC.vml = !n || "object" == typeof n.adj),
                    t.parentNode.removeChild(t);
                var a = !1;
                navigator.mimeTypes && navigator.mimeTypes["application/x-shockwave-flash"]
                    ? (a = navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin)
                    : document.all &&
                      -1 === navigator.appVersion.indexOf("Mac") &&
                      (a = new Function('try { var xObj = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");if (xObj) { xObj = null; return true; } } catch (e) { return false; }')()),
                    (ZC.flash = a ? 1 : 0);
            },
            quirks: !(document.compatMode && "CSS1Compat" === document.compatMode),
            ie67: !!/MSIE (\d+\.\d+);/.test(navigator.userAgent) && parseFloat(RegExp.$1) < 8,
            ie678: !!/MSIE (\d+\.\d+);/.test(navigator.userAgent) && parseFloat(RegExp.$1) < 9,
            mobile: /Mobile|BlackBerry|Opera Mini|PPC|Windows CE|Android/.test(navigator.userAgent),
            ipad: /iPad/.test(navigator.userAgent),
            iphone: /iPhone/.test(navigator.userAgent),
            websockets: "WebSocket" in window,
            webstorage: "sessionStorage" in window,
            RO: [],
            WG: [],
            E1: [0, 0],
            ACO: null,
            _cp_: function (e, i, t, n, a, l) {
                null === ZC._n_(t) && (t = !0), null === ZC._n_(n) && (n = !0), null === ZC._n_(a) && (a = !1);
                var o = (l = l || []).length;
                for (var r in e)
                    if (0 === o || (o > 0 && -1 === ZC.AV(l, r)))
                        if (e[r] instanceof Array) {
                            if (n) {
                                (null === ZC._n_(i[r]) || ("override" !== r && !a)) && (i[r] = []);
                                for (var s = 0, A = e[r].length; s < A; s++) i[r].push(e[r][s]);
                            }
                        } else
                            e[r] instanceof Object && !(e[r] instanceof Function)
                                ? n && (null === ZC._n_(i[r]) && (i[r] = {}), i[r] instanceof Object && !(i[r] instanceof Function) && ZC._cp_(e[r], i[r], t))
                                : (null === ZC._n_(i[r]) || t) && (i[r] = e[r]);
            },
            _cpa_: function (e, i) {
                i || (i = []);
                for (var t = 0, n = e.length; t < n; t++) i.push(e[t]);
            },
            _inj_: function (e, i) {
                var t = {};
                ZC._cp_(e, t), ZC._cp_(i, e), ZC._cp_(t, e);
            },
            _todash_: function (e, i, t) {
                if ("dashed" !== zingchart.SYNTAX) {
                    void 0 === i && (i = !0);
                    var n,
                        a,
                        l = (t = t || []).length;
                    for (var o in e)
                        if (e.hasOwnProperty(o) && (0 === l || (l > 0 && -1 === ZC.AV(t, o)))) {
                            var r = o.substring(0, 1);
                            if ("." !== r && "#" !== r)
                                if (e[o] instanceof Array)
                                    if (ZC.UM(o) !== o) {
                                        for (e[ZC.UM(o)] = [], n = 0, a = e[o].length; n < a; n++) ZC._todash_(e[o][n]), e[ZC.UM(o)].push(e[o][n]);
                                        delete e[o];
                                    } else for (n = 0, a = e[o].length; n < a; n++) ZC._todash_(e[o][n]);
                                else
                                    e[o] instanceof Object && !(e[o] instanceof Function)
                                        ? (ZC.UM(o) !== o && ((e[ZC.UM(o)] = {}), ZC._cp_(e[o], e[ZC.UM(o)]), delete e[o]), i && ZC._todash_(e[ZC.UM(o)], i, t))
                                        : ZC.UM(o) !== o && ((e[ZC.UM(o)] = e[o]), delete e[o]);
                        }
                }
            },
            ZA: function (e, i) {
                for (var t in e) {
                    var n;
                    if (e.hasOwnProperty(t))
                        if ((n = t.replace(i + "-", "")) !== t)
                            if (((e[n] = e[t]), e[t] instanceof Array)) for (var a = 0, l = e[t].length; a < l; a++) ZC.ZA(e[t][a], i);
                            else e[t] instanceof Object && !(e[t] instanceof Function) && ZC.ZA(e[t], i);
                }
            },
            AAC: function (e) {
                for (var i = "", t = 0, n = e.length; t < n; t++) {
                    var a = t % 2 == 0 ? t : e.length - t;
                    i += e.substring(a, a + 1);
                }
                return (i = i.replace(/\./g, "d"));
            },
            AD8: function (e) {
                var i = e;
                return (i = (i = (i = i.replace("*", "&")).replace("9", "3")).replace("l", "1"));
            },
            A9S: function (e) {
                return e.replace(/[a-zA-Z]/g, function (e) {
                    return String.fromCharCode((e <= "Z" ? 90 : 122) >= (e = e.charCodeAt(0) + 13) ? e : e - 26);
                });
            },
            ACA: function (e, i) {
                var t = ZC.X1(ZC.ABX(e)),
                    n = ZC.X1(ZC.A1Z(i)),
                    a = t.length;
                if (0 === a) return "";
                for (var l, o, r = t[a - 1], s = t[0], A = 2654435769, C = Math.floor(6 + 52 / a) * A; 0 !== C; ) {
                    o = (C >>> 2) & 3;
                    for (var c = a - 1; c > 0; c--) (l = ((((r = t[c - 1]) >>> 5) ^ (s << 2)) + ((s >>> 3) ^ (r << 4))) ^ ((C ^ s) + (n[(3 & c) ^ o] ^ r))), (s = t[c] -= l);
                    (l = ((((r = t[a - 1]) >>> 5) ^ (s << 2)) + ((s >>> 3) ^ (r << 4))) ^ ((C ^ s) + (n[(3 & c) ^ o] ^ r))), (s = t[0] -= l), (C -= A);
                }
                return decodeURIComponent(ZC.ABT(ZC.A5W(t)));
            },
            AEU: function (e, i) {
                e = encodeURIComponent(e);
                var t = ZC.X1(ZC.A1Z(e)),
                    n = ZC.X1(ZC.A1Z(i)),
                    a = t.length;
                if (0 === a) return "";
                1 === a && (t[a++] = 0);
                for (var l, o, r = t[a - 1], s = t[0], A = Math.floor(6 + 52 / a), C = 0; A-- > 0; ) {
                    o = ((C += 2654435769) >>> 2) & 3;
                    for (var c = 0; c < a - 1; c++) (l = (((r >>> 5) ^ ((s = t[c + 1]) << 2)) + ((s >>> 3) ^ (r << 4))) ^ ((C ^ s) + (n[(3 & c) ^ o] ^ r))), (r = t[c] += l);
                    (l = (((r >>> 5) ^ ((s = t[0]) << 2)) + ((s >>> 3) ^ (r << 4))) ^ ((C ^ s) + (n[(3 & c) ^ o] ^ r))), (r = t[a - 1] += l);
                }
                return ZC.ABW(ZC.A5W(t));
            },
            X1: function (e) {
                for (var i = new Array(Math.ceil(e.length / 4)), t = 0; t < i.length; t++) i[t] = e[4 * t] + (e[4 * t + 1] << 8) + (e[4 * t + 2] << 16) + (e[4 * t + 3] << 24);
                return i;
            },
            A5W: function (e) {
                for (var i = [], t = 0; t < e.length; t++) i.push(255 & e[t], (e[t] >>> 8) & 255, (e[t] >>> 16) & 255, (e[t] >>> 24) & 255);
                return i;
            },
            ABW: function (e) {
                for (var i = "", t = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"], n = 0; n < e.length; n++) i += t[e[n] >> 4] + t[15 & e[n]];
                return i;
            },
            ABX: function (e) {
                for (var i = [], t = "0x" === e.substr(0, 2) ? 2 : 0; t < e.length; t += 2) i.push(parseInt(e.substr(t, 2), 16));
                return i;
            },
            ABT: function (e) {
                for (var i = "", t = 0; t < e.length; t++) 0 !== e[t] && (i += String.fromCharCode(e[t]));
                return i;
            },
            A1Z: function (e) {
                for (var i = [], t = 0; t < e.length; t++) i.push(e.charCodeAt(t));
                return i;
            },
            _i_: function (e) {
                return -1 !== String(e).indexOf("e-") ? 0 : "" === (e = String(e).replace(/[^0-9\.\-]/gi, "")) ? 0 : Math.round(e);
            },
            _f_: function (e) {
                return (e = parseFloat(e)), isNaN(e) ? 0 : e;
            },
            _x_: function (e, i) {
                return void 0 === i && (i = 2), parseFloat(Number(e).toFixed(i));
            },
            _a_: function (e) {
                return Math.abs(e);
            },
            _b_: function (e) {
                return "false" !== e && "0" !== e && ("true" === e || "1" === e || (!!e && !0));
            },
            _p_: function (e) {
                var i = (e = String(e).replace(/[^0-9\.\%\-]/gi, "")).indexOf("%");
                return -1 !== i && ((e = e.substring(0, i)), (e = ZC._f_(e) / 100)), e;
            },
            _h_: function (e) {
                return window.toStaticHTML ? window.toStaticHTML(e) : e;
            },
            _n_: function (e) {
                return null === e || void 0 === e ? null : e;
            },
            _c_: function (e, i) {
                return null === e || void 0 === e ? i : e;
            },
            _ang_: function (e) {
                return (e %= 360) < 0 && (e += 360), e;
            },
            IJ: function (e, i) {
                return ZC._f_(e) + "" == e + "" ? (i ? ZC._f_(e) : ZC._a_(e)) : -1 !== (e += "").indexOf("%") ? ZC._f_(e.replace("%", "")) / 100 : -1 !== e.indexOf("px") ? ZC._f_(e.replace("px", "")) : ZC._f_(e);
            },
            QV: function (e) {
                return parseInt(e, 16);
            },
            OV: function (e) {
                return ZC._i_(e).toString(16);
            },
            _r_: function (e, i) {
                return parseInt(e + (i - e) * Math.random(), 10);
            },
            _l_: function (e, i, t) {
                return (e = (e = e < i ? i : e) > t ? t : e);
            },
            DT: function (e, i, t, n) {
                return n ? (i < e && e < t) || (t < e && e < i) : (i <= e && e <= t) || (t <= e && e <= i);
            },
            BQ: function (e, i) {
                return Math.max(e, i);
            },
            CY: function (e, i) {
                return Math.min(e, i);
            },
            A1D: function (e, i) {
                null === ZC._n_(i) && (i = !1);
                for (var t = 0, n = e.length, a = -Number.MAX_VALUE; t < n; t++) (i && 0 == e[t]) || (a = Math.max(a, e[t]));
                return a;
            },
            XZ: function (e, i) {
                null === ZC._n_(i) && (i = !1);
                for (var t = 0, n = e.length, a = Number.MAX_VALUE; t < n; t++) (i && 0 == e[t]) || (a = Math.min(a, e[t]));
                return a;
            },
            _rcolor_: function () {
                for (var e = ((16777215 * Math.random() + 1) << 0).toString(16); e.length < 6; ) e = "0" + e;
                return "#" + e;
            },
            A1J: function (e, i) {
                for (var t, n = ZC._f_(i), a = Number.MAX_VALUE, l = 0, o = 0, r = e.length; o < r; o++) (t = Math.abs(ZC._f_(e[o]) - n)) < a && ((l = o), (a = t));
                return l;
            },
            AEK: function (e) {
                var i = e.split(".");
                return i[i.length - 1] || "";
            },
            GW: function (e) {
                return e.replace(/^\s\s*/, "").replace(/\s\s*$/, "");
            },
            FV: function (e, i) {
                return (i = i || Math.E), isFinite(Math.log(e) / Math.log(i)) ? Math.log(e) / Math.log(i) : 0;
            },
            TN: function (e) {
                return (360 * e) / (2 * Math.PI);
            },
            T8: function (e) {
                return (2 * e * Math.PI) / 360;
            },
            EH: function (e) {
                return Math.cos(ZC.T8(e));
            },
            EP: function (e) {
                return Math.sin(ZC.T8(e));
            },
            P7: function (e) {
                return !isNaN(parseFloat(e)) && isFinite(e);
            },
            EE: function (e) {
                return -1 !== e.indexOf("-")
                    ? e.replace(/(\-[a-z0-9])/g, function (e) {
                          return e.toUpperCase().replace("-", "");
                      })
                    : e;
            },
            UM: function (e) {
                return e.toUpperCase() !== e && -1 === e.indexOf("-") && e.substring(0, 1).toLowerCase() === e.substring(0, 1)
                    ? e
                          .replace(/([A-Z])/g, function (e) {
                              return "-" + e.toLowerCase();
                          })
                          .replace(/([0-9]+)/g, function (e) {
                              return "-" + e.toLowerCase();
                          })
                          .replace("-3d", "3d")
                    : e;
            },
            AEL: function (e) {
                return ZC.XR.md5(e);
            },
            AL: function (e) {
                return document.getElementById(e);
            },
            A1C: function (e, i) {
                return e[0].length < i[0].length ? 1 : e[0].length > i[0].length ? -1 : 0;
            },
            Z8: function (e) {
                window.setTimeout(e, zingchart.TIMEOUT);
            },
            _fixed_: function (e, i) {
                return i >= 0 && i <= 20 ? e.toFixed(i) : "" + e;
            },
            _nfind_: function (e, i, t, n) {
                var a = i.S[t].BV,
                    l = i.S[n].BV;
                if (e == a) return t;
                if (e == l) return n;
                var o = ZC._i_((t + n) / 2);
                if (!i.S[o]) {
                    for (; !i.S[o] && o < n; ) o++;
                    if (o === n) {
                        for (o = ZC._i_((t + n) / 2); !i.S[o] && o > t; ) o--;
                        if (o === t) return null;
                    }
                }
                var r = i.S[o].BV;
                return o !== t && o !== n ? (e == r ? o : e > r ? ZC._nfind_(e, i, o, n) : ZC._nfind_(e, i, t, o)) : e == r ? o : null;
            },
            _tx_: function (e) {
                var i,
                    t,
                    n,
                    a,
                    l = [1, 1, 0, 0];
                if (zingchart.DEV.LOOKUPCSSTRANSFORM && !ZC.vml && ZC.AL(e)) {
                    var o = ZC.AL(e);
                    for (i = ""; o && ("" === i || "none" === i); ) (i = ZC.A5(o).css("transform") || ""), (o = o.parentNode);
                    -1 !== (t = i.indexOf("matrix(")) && ((n = i.indexOf(")", t)), (a = i.substring(t + 7, n - t).split(",")), (l = [ZC._f_(a[0]), ZC._f_(a[3]), ZC._f_(a[4]), ZC._f_(a[5])]));
                }
                return l;
            },
            Utils_SetupFormat: function (e, i) {
                return ZC.AP.O2(e, i);
            },
            Utils_Format: function (e, i, t, n) {
                return ZC.AP.G3(e, i, t, n);
            },
            Loader_Api_Loader_Info: function (e) {
                return e.FG();
            },
        }),
        (ZC.hasPassive = !1),
        (ZC.SEC = 1e3),
        (ZC.MIN = 60 * ZC.SEC),
        (ZC.HR = 60 * ZC.MIN),
        (ZC.DAY = 24 * ZC.HR),
        (ZC.MON = 30 * ZC.DAY),
        (ZC.YR = 365 * ZC.DAY),
        (ZC.MAPTX = 0),
        (window.JSON = window.JSON || {}),
        (JSON.stringify =
            JSON.stringify ||
            function (e) {
                var i = typeof e;
                if ("object" !== i || null === e) return "string" === i && (e = '"' + e.replace("\\", "\\\\").replace('"', '"') + '"'), String(e);
                var t,
                    n,
                    a = [],
                    l = e && e.constructor === Array;
                for (t in e)
                    "function" != typeof e[t] &&
                        ("string" === (i = typeof (n = e[t])) ? (n = '"' + n.replace("\\", "\\\\").replace('"', '\\"') + '"') : "object" === i && null !== n && (n = JSON.stringify(n)), a.push((l ? "" : '"' + t + '":') + String(n)));
                return (l ? "[" : "{") + String(a) + (l ? "]" : "}");
            }),
        (JSON.parse =
            JSON.parse ||
            function (KW) {
                return "" === KW && (KW = '""'), eval("(" + KW + ")");
            }),
        (function () {
            var e = !1,
                i = /xyz/.test(function () {
                    xyz;
                })
                    ? /\bb\b/
                    : /.*/;
            (ZC.CA = function () {}),
                (ZC.CA.CC = function (t) {
                    var n = this.prototype;
                    e = !0;
                    var a = new this();
                    for (var l in ((e = !1), t))
                        a[l] =
                            "function" == typeof a[l] && "function" == typeof n[l] && i.test(t[l])
                                ? (function (e, i) {
                                      return function () {
                                          var t = this.b;
                                          this.b = n[e];
                                          var a = i.apply(this, arguments);
                                          return (this.b = t), a;
                                      };
                                  })(l, t[l])
                                : t[l];
                    function o() {
                        !e && this.$i && this.$i.apply(this, arguments);
                    }
                    return (o.prototype = a), (o.constructor = o), (o.CC = arguments.callee), o;
                });
        })(),
        (ZC.AB1 = function (e) {
            (this.H = e),
                (this.AA2 = function (e, i) {
                    var t,
                        n = this,
                        a = n.B8.palette;
                    if ((null !== ZC._n_(i) && null !== ZC._n_(a[i]) && (a = a[i]), null !== ZC._n_(a[e]))) {
                        var l = a[e];
                        return null === ZC._n_(l[2]) && (l[2] = ZC.AP.R0(l[1], 10)), null === ZC._n_(l[3]) && (l[3] = ZC.AP.R0(l[1], 10)), l;
                    }
                    var o = ["#00BAF2", "#E80C60", "#E2D51A", "#9B26AF", "#FB301E", "#00AE4D", "#20398B"];
                    t = null !== ZC._n_(o[e - n.B8.palette.length]) ? o[e - n.B8.palette.length] : "#" + ZC.XR.md5(e).substr(e % 20, 6);
                    var r = ZC.AP.R0(t, 10),
                        s = ZC.AP.R0(t, 20),
                        A = "#FFF";
                    return n.B8.palette && n.B8.palette[0] && n.B8.palette[0][0] && (A = n.B8.palette[0][0]), [A, t, r, s];
                }),
                (this.A8S = function (e) {
                    e && ZC._cp_(e, this.B8, !0);
                }),
                (this.AAW = function (e) {
                    var i = this;
                    null !== ZC._n_(i.NS[e]) && (ZC._todash_(i.NS[e]), ZC._cp_(i.NS[e], i.B8));
                }),
                (this.NS = {}),
                ZC._cp_(zingchart.THEMES, this.NS),
                (this.NS.classic = {
                    palette: [
                        ["#fff", "#6a921f", "#a7da47", "#89b92e"],
                        ["#fff", "#007fa3", "#00b0e1", "#0392bb"],
                        ["#fff", "#a62b02", "#ef4810", "#cc3300"],
                        ["#fff", "#b79007", "#f9c332", "#da9b04"],
                        ["#fff", "#563d02", "#84680a", "#6e4503"],
                        ["#fff", "#0b32a0", "#4d62b1", "#1540a0"],
                    ],
                    graph: {
                        refresh: { curtain: { alpha: 0.5, "background-color": "#999", color: "#000", "font-size": 15, bold: 1, text: "Loading..." } },
                        "background-color": "#e1eaec #edf3f5",
                        title: { "font-size": 14, bold: 1, color: "#fff", "background-color": "#00bbf1 #05a0cd", padding: 6 },
                        subtitle: { "font-size": 11, bold: 1, color: "#333", "margin-top": 30, padding: 6 },
                        source: { "font-size": 10, color: "#333", width: "100%", bold: 1, "text-align": "right", height: 20, margin: "auto 0 0 auto", padding: 5 },
                        nodata: { "font-size": 12, color: "#333", "text-align": "center", "vertical-align": "middle", text: "" },
                        SCALE: {
                            "font-size": 11,
                            "line-width": 2,
                            "line-color": "#3e6c7b",
                            item: { flat: !0 },
                            "ref-line": { "line-width": 1, "line-color": "#3e6c7b" },
                            guide: { visible: 1, "line-width": 1, "line-style": "solid", "line-color": "#2c4a59", alpha: 0.2 },
                            "minor-guide": { visible: 1, "line-width": 1, "line-style": "solid", "line-color": "#aaa", alpha: 0.1 },
                            tick: { visible: 1, size: 6, placement: "outer", "line-width": 2, "line-color": "#3e6c7b" },
                            "minor-tick": { visible: 1, size: 4, placement: "outer", "line-width": 1, "line-color": "#3e6c7b" },
                            label: { color: "#2c4a59", flat: !0 },
                        },
                        "scroll-x": { bar: { height: 16 }, handle: { height: 16 } },
                        "scroll-y": { bar: { width: 16 }, handle: { width: 16 } },
                        legend: {
                            "background-color": "#fff",
                            "border-width": 1,
                            alpha: 0.75,
                            "border-alpha": 0.75,
                            "border-color": "#666",
                            "shadow-distance": 3,
                            header: { padding: "4 6", color: "#fff", "border-width": 1, "border-color": "#3e6c7b", "background-color": "#3e6c7b" },
                            footer: { padding: "2 6", "background-color": "#ccc", "border-width": 1, "border-color": "#666" },
                            marker: { "border-color": "#333", "border-width": 1 },
                        },
                        plot: { "value-box": { flat: !0 }, marker: { shadow: 1, "line-width": 1, "border-width": 1 }, "hover-marker": { "line-width": 1, "border-width": 1 } },
                        guide: { "line-width": 1, "line-color": "#999", alpha: 1, "scale-label": { text: "%l", padding: "3 6" }, "plot-label": { padding: "3 6" } },
                    },
                    line: { plot: { "shadow-alpha": 0.5, marker: { size: 4 }, "hover-marker": { size: 5 } } },
                    area: { plot: { "shadow-alpha": 0.5, marker: { size: 4 }, "hover-marker": { size: 5 } } },
                    vbar: { plot: { "fill-angle": 90, shadow: 0 } },
                    hbar: { plot: { "fill-angle": 180, shadow: 0 } },
                    piano: { plotarea: { "mask-tolerance": [0, 0] }, plot: { shadow: 0 } },
                    stock: { plot: { shadow: 0 } },
                    vbullet: { plot: { shadow: 0 } },
                    hbullet: { plot: { "fill-angle": 0, shadow: 0 } },
                    scatter: { plot: { marker: { size: 4 }, "hover-marker": { size: 5 } } },
                    hscatter: { plot: { marker: { size: 4 }, "hover-marker": { size: 5 } } },
                    bubble: { plot: { marker: { "border-width": 0 }, "hover-marker": { "border-width": 0 } } },
                    hbubble: { plot: { marker: { "border-width": 0 }, "hover-marker": { "border-width": 0 } } },
                    pie: { plot: { "border-width": 1 } },
                    nestedpie: { plot: { "border-width": 1 } },
                    radar: { plot: { marker: { size: 3 }, "hover-marker": { size: 4 } }, "scale-k": { guide: { alpha: 0.5, "background-color": "#eee #ddd" } } },
                    gauge: {
                        "scale-r": {
                            "background-color": "-1",
                            guide: { alpha: 0.5, "background-color": "#eee #ddd" },
                            item: { "offset-r": 0 },
                            ring: {
                                size: 1,
                                items: [
                                    { "background-color": "#999", alpha: 0.8 },
                                    { "background-color": "#666", alpha: 0.8 },
                                ],
                            },
                        },
                    },
                    vfunnel: {
                        plotarea: { margin: "50 100" },
                        SCALE: { "line-width": 0, tick: { "line-width": 0 }, "minor-tick": { "line-width": 0 }, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 } },
                        "scale-y": { guide: { alpha: 0.25, "background-color": "-1 #58595B" } },
                        "scale-y-n": { guide: { alpha: 0.25, "background-color": "-1 #58595B" } },
                        plot: { "border-width": 1 },
                    },
                    hfunnel: {
                        plotarea: { margin: "50 100" },
                        "scale-x": { label: { angle: 270 } },
                        "scale-x-n": { label: { angle: 90 } },
                        SCALE: { "line-width": 0, tick: { "line-width": 0 }, "minor-tick": { "line-width": 0 }, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 } },
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" }, guide: { alpha: 0.25, "background-color": "#58595B -1" } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" }, guide: { alpha: 0.25, "background-color": "#58595B -1" } },
                        plot: { "border-width": 1 },
                    },
                    range: { plot: { marker: { type: "circle", size: 4 }, "hover-marker": { size: 5 } } },
                    line3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 0, "line-width": 1 } },
                    area3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 0, "line-width": 1 } },
                    mixed3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 1 } },
                    vbar3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 1 } },
                    hbar3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 1 } },
                    pie3d: { plot: { "border-width": 1 } },
                    "-": "",
                }),
                (this.NS.light = {
                    palette: [
                        ["#fff", "#29A2CC", "#29A2CC", "#1089B3"],
                        ["#fff", "#D31E1E", "#D31E1E", "#BA0505"],
                        ["#fff", "#7CA82B", "#7CA82B", "#638F12"],
                        ["#fff", "#EF8535", "#EF8535", "#D66C1C"],
                        ["#fff", "#A14BC9", "#A14BC9", "#8832B0"],
                        ["#fff", "#A05F18", "#A05F18", "#874600"],
                        ["#fff", "#265E96", "#265E96", "#0D457D"],
                        ["#fff", "#6B7075", "#6B7075", "#52575C"],
                        ["#fff", "#96C245", "#96C245", "#7CA82B"],
                    ],
                    graph: {
                        refresh: { curtain: { alpha: 0.5, "background-color": "#999", color: "#000", "font-size": 15, bold: 1, text: "Loading..." } },
                        "background-color": "#ffffff",
                        title: { "font-size": 21, bold: 1, color: "#414042", "background-color": "none", padding: 6 },
                        subtitle: { "font-size": 11, bold: 1, color: "#414042", "margin-top": 30, padding: 6 },
                        source: { "font-size": 10, color: "#414042", width: "100%", bold: 1, "text-align": "right", height: 20, margin: "auto 0 0 auto", padding: 5 },
                        nodata: { "font-size": 12, color: "#333", "text-align": "center", "vertical-align": "middle", text: "No Data", "background-color": "#BBBBBB", alpha: 0.8 },
                        SCALE: {
                            "font-size": 11,
                            "line-width": 1,
                            "line-color": "#8C8C8C",
                            item: { "font-size": 12, flat: !0, color: "#808285" },
                            "ref-line": { "line-width": 1, "line-color": "#D1D3D4" },
                            guide: { visible: 1, "line-width": 1, "line-style": "solid", "line-color": "#DCDCDC", alpha: 1 },
                            "minor-guide": { visible: 1, "line-width": 1, "line-style": "solid", "line-color": "#aaa", alpha: 0.1 },
                            tick: { visible: 1, size: 5, placement: "outer", "line-width": 1, "line-color": "#8C8C8C" },
                            "minor-tick": { visible: 1, size: 3, placement: "outer", "line-width": 1, "line-color": "#A7A9AC" },
                            label: { color: "#414042", flat: !0 },
                        },
                        "scale-x": { normalize: !0, guide: { visible: !1 } },
                        scroll: { bar: { "background-color": "#F0F1F1", margin: 1 }, handle: { "background-color": "#A7A9AC", "border-radius": 6 } },
                        "scroll-x": {
                            bar: { height: 16, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                            handle: { height: 10, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                        },
                        "scroll-y": {
                            bar: { width: 16, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                            handle: { width: 10, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                        },
                        "scroll-xi": {
                            bar: { width: 16, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                            handle: { width: 10, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                        },
                        "scroll-yi": {
                            bar: { height: 16, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                            handle: { height: 10, "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                        },
                        preview: {
                            "background-color": "#fff",
                            "border-width": 1,
                            "border-color": "#A7A9AC",
                            live: !0,
                            mask: { "background-color": "#999" },
                            active: { alpha: 0 },
                            handle: { width: 11, "border-width": 2, "border-radius": 3, "line-color": "#C6C6C6", "border-color": "#A7A9AC", "background-color": "#F0F1F1" },
                            "handle-top": { height: 11 },
                            "handle-bottom": { height: 11 },
                        },
                        tooltip: { shadow: 1, "shadow-angle": 45, "shadow-distance": 1, "shadow-alpha": 0.25, "border-width": 1, "border-color": "#fff", "border-alpha": 1 },
                        zoom: { "preserve-zoom": 1, "background-color": "#929497" },
                        legend: {
                            "background-color": "#fff",
                            "border-width": 1,
                            shadow: 0,
                            "shadow-alpha": 0.2,
                            alpha: 1,
                            "border-alpha": 1,
                            "border-color": "#cccccc",
                            header: { padding: "5 0 5 10", color: "#222222", "background-color": "none", "border-width": 0, "border-top": "0px solid none", "border-bottom": "1px solid #cccccc" },
                            footer: { padding: "5 0 5 10", "border-top": "1px solid #cccccc" },
                            shader: { "background-color": "#F0F1F1", "line-color": "#C6C6C6", margin: 2, height: 8, "line-width": 2, "line-style": "dotted" },
                            icon: { "line-color": "#C6C6C6", "line-width": 2, style: "small" },
                            marker: { "border-color": "#fff", "border-width": 1 },
                            "page-on": { "background-color": "#929497" },
                            "page-off": { "background-color": "#D1D2D3" },
                            scroll: {
                                bar: { "background-color": "none", "margin-top": 3, "margin-bottom": 3 },
                                handle: { "background-color": "#D1D2D3", "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none", "border-radius": 6, width: 12, height: 12 },
                            },
                        },
                        plot: { "value-box": { flat: !0 }, marker: { shadow: 0, "line-width": 1, "border-width": 1, "border-color": "#fff" }, "hover-marker": { "line-width": 1, "border-width": 1 }, monotone: !0 },
                        guide: { "line-width": 1, "line-color": "#8C8C8C", alpha: 1, "scale-label": { text: "%l", padding: "3 6" }, "plot-label": { padding: "3 6" } },
                    },
                    line: { plot: { "line-width": 2, shadow: 0, marker: { size: 4 }, "hover-state": {}, "hover-marker": { size: 5, "border-width": 1, "border-color": "#fff" } } },
                    area: { plot: { "line-width": 2, shadow: 0, "alpha-area": 0.25, "background-color-style": "solid", marker: { size: 4 }, "hover-state": {}, "hover-marker": { size: 5, "border-width": 1, "border-color": "#fff" } } },
                    vbar: { plot: { "fill-angle": 90, shadow: 0 } },
                    hbar: { plot: { "fill-angle": 180, shadow: 0 } },
                    piano: { plotarea: { "mask-tolerance": [0, 0] }, plot: { shadow: 0 }, "scale-x": { guide: { visible: !0 } } },
                    stock: { plot: { shadow: 0 } },
                    vbullet: { plot: { shadow: 0, goal: { "border-width": 1, "border-color": "#fff", height: 8 } } },
                    hbullet: { plot: { "fill-angle": 0, shadow: 0, goal: { "border-width": 1, "border-color": "#fff", width: 8 } } },
                    scatter: { plot: { "line-color": "%palette-0", "border-color": "%palette-0", marker: { size: 5 }, "hover-marker": { size: 6 } }, "scale-x": { guide: { visible: !0 } } },
                    hscatter: { plot: { "line-color": "%palette-0", "border-color": "%palette-0", marker: { size: 4 }, "hover-marker": { size: 5 } }, "scale-x": { guide: { visible: !0 } } },
                    bubble: { plot: { marker: { "border-width": 1, "border-color": "#fff" }, "hover-marker": { "border-width": 1, "border-color": "#fff" } }, "scale-x": { guide: { visible: !0 } } },
                    hbubble: { plot: { marker: { "border-width": 1, "border-color": "#fff" }, "hover-marker": { "border-width": 1, "border-color": "#fff" } }, "scale-x": { guide: { visible: !0 } } },
                    pie: { plot: { shadow: 0, "border-width": 1, "value-box": { placement: "in", "font-size": 16, text: "%node-percent-value%" } } },
                    nestedpie: { plot: { "border-width": 1 } },
                    radar: {
                        plot: { shadow: 0, "line-width": 2, "background-color": "%palette-1", "active-area": !0, marker: { size: 4 }, "hover-marker": { size: 5, "border-color": "#fff" } },
                        "scale-k": {
                            guide: { "line-width": 1, "line-style": "solid", "line-color": "#8C8C8C", "line-segment-size": 6, "line-gap-size": 6, alpha: 1, "background-color": "#fff #F7F8F8" },
                            tick: { "line-color": "#8C8C8C", "line-width": 1, size: 10 },
                        },
                        "scale-r": {},
                        "scale-v": { "ref-line": { "line-color": "#8C8C8C", "line-width": 1 }, tick: { "line-color": "#8C8C8C", "line-width": 1 }, guide: { "line-color": "#CDCDCD", "line-width": 1 } },
                    },
                    gauge: {
                        plot: { shadow: 0 },
                        scale: { "size-factor": 1 },
                        "scale-r": {
                            aperture: 270,
                            tick: { size: 11, "line-width": 2 },
                            "background-color": -1,
                            guide: { "background-color": "#fff" },
                            ring: { size: 8, "background-color": "#CDCDCD" },
                            center: { size: 20, "background-color": "#fff", "border-width": 6, "border-color": "#1089B3" },
                        },
                    },
                    vfunnel: {
                        plotarea: { margin: "50 100" },
                        SCALE: {
                            "line-width": 0,
                            tick: { "line-width": 0 },
                            "minor-tick": { "line-width": 0 },
                            guide: { "line-width": 1, "line-style": "solid", "line-color": "#CDCDCD", "line-segment-size": 6, "line-gap-size": 6, alpha: 1 },
                            "minor-guide": { "line-width": 0 },
                        },
                        "scale-x": { visible: !1, guide: { visible: 0 } },
                        "scale-y": { guide: { "background-color": "-1", alpha: 1 } },
                        "scale-y-n": { guide: { "background-color": "-1" } },
                        plot: { "border-width": 1, "border-color": "#fff", shadow: 0, "hover-state": { "line-color": "-1", "border-color": "-1" } },
                    },
                    hfunnel: {
                        plotarea: { margin: "50 100" },
                        "scale-x": { visible: !1, guide: { visible: 0 }, label: { angle: 270 } },
                        "scale-x-n": { label: { angle: 90 } },
                        SCALE: {
                            "line-width": 0,
                            tick: { "line-width": 0 },
                            "minor-tick": { "line-width": 0 },
                            guide: { "line-width": 1, "line-style": "solid", "line-color": "#CDCDCD", "line-segment-size": 6, "line-gap-size": 6, alpha: 1 },
                            "minor-guide": { "line-width": 0 },
                        },
                        "scale-y": { guide: { "background-color": "-1", alpha: 1 }, label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" }, guide: { "background-color": "-1" } },
                        plot: { "border-width": 1, "border-color": "#fff", shadow: 0, "hover-state": { "line-color": "-1", "border-color": "-1" } },
                    },
                    range: { plot: { "background-color": "%palette-1", marker: { type: "circle", size: 4 }, "hover-marker": { size: 5 } } },
                    line3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 0, "line-width": 1 } },
                    area3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 0, "line-width": 1 } },
                    mixed3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 1 } },
                    vbar3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 1 } },
                    hbar3d: { SCALE: { "line-color": "#ddd", tick: { visible: !1 } }, plot: { "border-width": 1 } },
                    pie3d: { plot: { "border-width": 1 } },
                    venn: { plot: { "border-width": 0, shadow: 0, alpha: 0.75, "background-color": "%palette-1" } },
                    root: {
                        gui: {
                            "context-menu": {
                                visible: !0,
                                width: "125px",
                                padding: "5 0",
                                "background-color": "#595959",
                                "border-width": 0,
                                "border-color": "#595959",
                                position: "left",
                                button: { visible: ZC.mobile, alpha: 0 },
                                gear: { "background-color": "#000", type: "hamburger", alpha: 1 },
                                item: {
                                    "background-color": "#595959",
                                    "text-align": "left",
                                    padding: "4 20 4 15",
                                    "border-width": 0,
                                    "border-color": "#595959",
                                    "font-size": "12px",
                                    color: "#fff",
                                    "hover-state": { "background-color": "#414141" },
                                },
                                separator: { "line-width": 1, "line-color": "#969696" },
                            },
                            "context-menu[mobile]": { item: { padding: "6 10 6 6" } },
                        },
                    },
                    "-": "",
                }),
                (this.NS.light.graph["crosshair-x"] = this.NS.light.graph["crosshair-y"] = this.NS.light.graph.guide),
                (this.NS.dark = {}),
                ZC._cp_(this.NS.light, this.NS.dark, !0, !0),
                ZC._cp_(
                    {
                        graph: {
                            "background-color": "#221F1F",
                            title: { color: "#fff" },
                            subtitle: { color: "#fff" },
                            source: { color: "#fff" },
                            SCALE: {
                                "line-color": "#D1D3D4",
                                item: { color: "#D1D3D4" },
                                "ref-line": { "line-color": "#D1D3D4" },
                                guide: { "line-color": "#58595B" },
                                "minor-guide": { "line-color": "#58595B" },
                                tick: { "line-color": "#D1D3D4" },
                                "minor-tick": { "line-color": "#D1D3D4" },
                                label: { color: "#D1D3D4" },
                            },
                            scroll: { bar: { "background-color": "#6C6D70" }, handle: { "background-color": "#A7A9AC" } },
                            "scroll-x": {
                                bar: { "border-top": "0px solid none", "border-right": "2px solid #D1D3D4", "border-bottom": "2px solid #D1D3D4", "border-left": "2px solid #D1D3D4" },
                                handle: { "border-top": "none", "border-right": "none", "border-bottom": "none", "border-left": "none" },
                            },
                            "scroll-y": { bar: { "border-top": "2px solid #D1D3D4", "border-right": "0px solid none", "border-bottom": "2px solid #D1D3D4", "border-left": "2px solid #D1D3D4" } },
                            preview: { "background-color": "#221F1F" },
                            tooltip: { "border-color": "#000" },
                            legend: {
                                "background-color": "#221F1F",
                                header: { color: "#fff", shader: { "background-color": "#414042", "line-color": "#676667" } },
                                footer: { color: "#D1D3D4", "background-color": "#414042", "border-top": "0px solid none", "border-right": "2px solid #A7A9AC", "border-bottom": "2px solid #A7A9AC", "border-left": "2px solid #A7A9AC" },
                                shader: { "background-color": "#414042", "line-color": "#676667" },
                                icon: { "line-color": "#676667" },
                                "page-status": { color: "#D1D3D4" },
                                "page-on": { "background-color": "#D1D2D3" },
                                "page-off": { "background-color": "#929497" },
                                marker: { "border-color": "#000" },
                                item: { color: "#D1D3D4" },
                            },
                            plot: { marker: { "border-color": "#221F1F" } },
                            guide: { "line-color": "#D1D3D4", "scale-label": { "background-color": "#929497" }, "plot-label": { "background-color": "#221F1F", color: "#FFF", "border-color": "#5a5a5a" } },
                        },
                        line: { plot: { "hover-marker": { "border-color": "#221F1F" } } },
                        area: { plot: { "hover-marker": { "border-color": "#221F1F" } } },
                        vbullet: { plot: { goal: { "border-color": "#221F1F" } } },
                        hbullet: { plot: { goal: { "border-color": "#221F1F" } } },
                        bubble: { plot: { marker: { "border-color": "#221F1F" }, "hover-marker": { "border-color": "#221F1F" } } },
                        hbubble: { plot: { marker: { "border-color": "#221F1F" }, "hover-marker": { "border-color": "#221F1F" } } },
                        pie: { plot: { "border-color": "#221F1F" } },
                        radar: {
                            plot: { "hover-marker": { "border-color": "#221F1F" } },
                            "scale-k": { guide: { "line-color": "#58595B", "background-color": "#221F1F #312F30" }, tick: { "line-color": "#D1D3D4" } },
                            "scale-v": { "ref-line": { "line-color": "#58595B" }, tick: { "line-color": "#58595B" }, guide: { "line-color": "#58595B" } },
                        },
                        gauge: { "scale-r": { guide: { "background-color": "#221F1F" }, ring: { "background-color": "#57585B" } } },
                        vfunnel: { SCALE: { guide: { "line-color": "#58595B" } }, plot: { "border-color": "#221F1F", "hover-state": { "line-color": "#58595B", "border-color": "#221F1F" } } },
                        hfunnel: {
                            SCALE: { guide: { "line-color": "#58595B" } },
                            "scale-y": { guide: { alpha: 0.25, "background-color": "#b6c8cf -1" } },
                            "scale-y-n": { guide: { alpha: 0.25, "background-color": "#b6c8cf -1" } },
                            plot: { "border-color": "#221F1F", "hover-state": { "line-color": "#58595B", "border-color": "#221F1F" } },
                        },
                        root: { gui: { "context-menu": { gear: { "background-color": "#FFF" } } } },
                        "-": "",
                    },
                    this.NS.dark,
                    !0,
                    !0
                ),
                (this.NS.dark.graph["crosshair-x"] = this.NS.dark.graph["crosshair-y"] = this.NS.dark.graph.guide),
                (this.NS.mini = {
                    graph: {
                        title: { width: "100%", padding: "1 2 2", "font-size": 10 },
                        subtitle: { width: "100%", padding: "1 2 2", "margin-top": 14, "font-size": 9 },
                        plotarea: { width: "100%", height: "100%", margin: "18 4 4 4" },
                        SCALE: { visible: 0 },
                        tooltip: { shadow: 0, "border-radius": 7 },
                        legend: { visible: 0 },
                        preview: { visible: 0 },
                        guide: { "line-width": 1, "line-color": "#ccc", alpha: 1, "scale-label": { text: "%l", padding: "3 6" }, "plot-label": { "border-color": "#ccc", "border-radius": 5, padding: "3 6" } },
                        plot: { shadow: 0, "value-box": { visible: 0 }, "hover-state": { visible: 0 }, "hover-marker": { visible: 0 }, "max-trackers": 99999, "max-nodes": 99999 },
                    },
                    line: { plot: { "line-width": 1, marker: { type: "none" } } },
                    line3d: { "3d-aspect": { depth: 20, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0, zoom: 0.9 } },
                    area: { plot: { "line-width": 1, marker: { type: "none" } } },
                    area3d: { "3d-aspect": { depth: 20, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0, zoom: 0.9 } },
                    scatter: { SCALE: { offset: 5 }, plot: { marker: { size: 3, shadow: !1, alpha: 0.8 } } },
                    hscatter: { SCALE: { offset: 5 }, plot: { marker: { size: 3, shadow: !1, alpha: 0.8 } } },
                    bubble: { SCALE: { offset: 15 }, plot: { marker: { "fill-type": "none", shadow: !1, alpha: 0.8 }, "min-size": 3, "max-size": 9 } },
                    hbubble: { SCALE: { offset: 15 }, plot: { marker: { "fill-type": "none", shadow: !1, alpha: 0.8 }, "min-size": 3, "max-size": 9 } },
                    pie: { plotarea: { margin: "18 4 4 4" }, plot: { "value-box": { visible: 0 } }, scale: { "size-factor": 0.95 } },
                    pie3d: { plotarea: { margin: "32 4 4 4" }, plot: { "value-box": { visible: 0 } }, scale: { "size-factor": 1 } },
                    nestedpie: { plotarea: { margin: "18 4 4 4" }, plot: { "value-box": { visible: 0 } }, scale: { "size-factor": 0.95 } },
                    radar: { plotarea: { margin: "18 4 4 4" }, plot: { "line-width": 1, marker: { shadow: 0, size: 2 } }, scale: { "size-factor": 0.95 } },
                    vbar3d: { "3d-aspect": { depth: 20, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0, zoom: 0.9 } },
                    hbar3d: { "3d-aspect": { depth: 20, angle: 45, "x-angle": 0, "y-angle": -20, "z-angle": 0, zoom: 0.9 } },
                    venn: { plotarea: { margin: "18 4 4 4" }, plot: { "border-width": 0 } },
                    gauge: {
                        plotarea: { margin: "18 4 4 4" },
                        plot: { indicator: [5] },
                        SCALE: { visible: 1 },
                        scale: { "size-factor": 0.9 },
                        "scale-r": {
                            "background-color": "-1",
                            aperture: 270,
                            tick: { visible: 0 },
                            item: { visible: 0 },
                            guide: { visible: 0 },
                            ring: { size: 6, "background-color": "#CDCDCD", items: [] },
                            center: { "border-width": 0, size: 2, "background-color": "#fff" },
                        },
                    },
                    vfunnel: { plotarea: { margin: "18 4 4 4" } },
                    hfunnel: { plotarea: { margin: "18 4 4 4" } },
                    vbullet: { plot: { "bar-space": 0.5, goal: { "border-width": 0, height: 4 } } },
                    hbullet: { plot: { "bar-space": 0.5, goal: { "border-width": 0, width: 4 } } },
                    range: { plot: { "line-width": 1, marker: { visible: 0 }, "hover-state": { visible: 0 } } },
                    "-": "",
                }),
                (this.NS.negative = {
                    palette: [
                        ["#000", "#909090", "#969696", "#9c9c9c"],
                        ["#000", "#a0a0a0", "#a6a6a6", "#acacac"],
                        ["#000", "#b0b0b0", "#b6b6b6", "#bcbcbc"],
                        ["#000", "#c0c0c0", "#c6c6c6", "#cccccc"],
                        ["#000", "#d0d0d0", "#d6d6d6", "#dcdcdc"],
                        ["#000", "#e0e0e0", "#e6e6e6", "#ececec"],
                        ["#000", "#f0f0f0", "#f6f6f6", "#fcfcfc"],
                    ],
                    graph: {
                        "background-color": "#111",
                        title: { color: "#fff" },
                        subtitle: { color: "#333" },
                        SCALE: {
                            "font-size": 11,
                            "line-width": 2,
                            "line-color": "#ccc",
                            guide: { visible: 1, "line-width": 1, "line-style": "solid", "line-color": "#ccc", alpha: 0.2 },
                            "minor-guide": { visible: 1, "line-width": 1, "line-style": "solid", "line-color": "#ccc", alpha: 0.2 },
                            tick: { visible: 1, size: 6, placement: "outer", "line-width": 2, "line-color": "#ccc" },
                            "minor-tick": { visible: 1, size: 4, placement: "outer", "line-width": 1, "line-color": "#ccc" },
                            label: { color: "#fff" },
                            item: { color: "#fff" },
                        },
                    },
                    radar: { "scale-k": { guide: { alpha: 0.5, "background-color": "#222 #333" } } },
                    "-": "",
                }),
                (this.NS.spark = this.NS.mini),
                (this.B8 = {
                    root: {
                        gui: {
                            behaviors: [
                                { id: "PageScroll", enabled: "all" },
                                { id: "ViewSource", enabled: "all" },
                                { id: "BugReport", enabled: "none" },
                                { id: "LogScale", enabled: "none" },
                                { id: "LinScale", enabled: "none" },
                                { id: "FullScreen", enabled: "none" },
                                { id: "3D", enabled: "none" },
                                { id: "ExportData", enabled: "none" },
                                { id: "SaveAsImageJPG", enabled: "none" },
                                { id: "DownloadCSV", enabled: ZC.ie678 ? "none" : "all" },
                                { id: "DownloadXLS", enabled: ZC.ie678 ? "none" : "all" },
                            ],
                            watermark: { type: 1, position: "rb" },
                            history: {
                                margin: "10 auto auto 10",
                                width: 30,
                                height: 22,
                                padding: 4,
                                item: { "background-color": "#369", "border-width": 1, "border-color": "#69c" },
                                "item-off": { "background-color": "#eee", "border-color": "#ddd" },
                            },
                            progress: { "background-color": "#fff", color: "#000" },
                            "context-menu": {
                                padding: 0,
                                "border-width": 1,
                                "border-color": "#000",
                                button: { visible: ZC.mobile, margin: "5 auto auto 5", alpha: 0.8, "background-color": "#333 #999", "border-radius": 8, width: 40, height: 40 },
                                gear: { "background-color": "#fff #f6f6f6", type: "gear6", alpha: 0.8 },
                                item: { "background-color": "#36393D", "text-align": "left", padding: "4 20 4 8", "border-width": 1, "border-color": "#000", color: "#fff", "hover-state": { "background-color": "#0084AA" } },
                                separator: { "line-width": 1, "line-color": "#000000" },
                            },
                            "context-menu[mobile]": { item: { padding: "6 10 6 6" } },
                        },
                    },
                    palette: [],
                    graph: {
                        title: { width: "100%", bold: 1, "font-size": 13 },
                        subtitle: { width: "100%", bold: 1, "font-size": 11 },
                        scroll: {
                            bar: { "background-color": "#e1eaec", "border-color": "#ddd" },
                            handle: {
                                "background-color": "#ddd",
                                "border-color": "#ccc",
                                "border-width": 2,
                                "border-top": "2px solid #eee",
                                "border-left": "2px solid #eee",
                                "border-right": "2px solid #999",
                                "border-bottom": "2px solid #999",
                            },
                        },
                        "scroll-x": { bar: { height: 16 }, handle: { height: 16 } },
                        "scroll-y": { bar: { width: 16 }, handle: { width: 16 } },
                        "scroll-xi": { bar: { width: 16 }, handle: { width: 16 } },
                        "scroll-yi": { bar: { height: 16 }, handle: { height: 16 } },
                        preview: {
                            width: "100%",
                            height: 50,
                            margin: "auto 50 20 50",
                            "border-width": 1,
                            shadow: 0,
                            "background-color": "#f0f0f0",
                            "border-color": "#999",
                            mask: { alpha: 0.5, "background-color": "#333" },
                            active: { alpha: 0.1, "background-color": "#999" },
                            handle: { width: 9, height: 16, "border-width": 1, "line-width": 1, "line-color": "#111", "border-color": "#444", "border-radius": 2, "background-color": "#e6e6e6" },
                            "handle-top": { width: 16, height: 9 },
                            "handle-bottom": { width: 16, height: 9 },
                        },
                        "preview[yx]": { width: 50, height: "100%", margin: "60 auto 65 20" },
                        plotarea: { width: "100%", height: "100%", margin: "60 50 65 50" },
                        "plotarea[preview]": { margin: "60 50 105 50" },
                        "plotarea[preview[yx]]": { margin: "60 50 65 105" },
                        SCALE: {
                            "line-width": 1,
                            guide: { "line-width": 1, "line-color": "#ddd" },
                            tick: { size: 6, "line-width": 2 },
                            "minor-guide": { "line-width": 1, "line-color": "#ddd" },
                            "minor-tick": { size: 4, "line-width": 1 },
                            label: { bold: 1, padding: 6, flat: !0 },
                            item: { padding: 2, "auto-align": !0, flat: !0 },
                            marker: { "line-width": 1, "line-color": "#000", "background-color": "#ccc" },
                            "transform[date]": { item: { "font-size": 10, padding: 2, color: "#000", "background-color": "#fff" } },
                        },
                        "SCALE[3d]": { "background-color": "#ccc" },
                        "scale-y[default]": { label: { angle: 270 }, item: { "text-align": "right" } },
                        "scale-y[opposite]": { label: { angle: 90 }, item: { "text-align": "left" } },
                        plot: {
                            error: { "line-width": 1, "line-color": "#333", size: 0.5 },
                            "value-box": { flat: !0, text: "%v", bold: 1, placement: "auto", shadow: 1 },
                            "tooltip-text": "%v",
                            shadow: 1,
                            "line-width": 1,
                            marker: { type: "square", shadow: 1 },
                            "highlight-state": { shadow: !0, "shadow-blur": 2, "shadow-distance": 1, "shadow-alpha": 0.91 },
                        },
                        tooltip: { shadow: 1, padding: "4 8", "shadow-distance": 3, "offset-y": ZC.mobile ? -40 : -20 },
                        "tooltip[dynamic]": { padding: "4 8", "offset-y": 0 },
                        guide: {
                            marker: { type: "circle" },
                            "plot-label[single]": { text: '<b style="color:%color">%plot-text:</b> %node-value', padding: 10, "background-color": "#fff #eee", "border-width": 1, "border-color": "#999", color: "#000", "text-align": "left" },
                            "plot-label[multiple]": {
                                text: '<b style="color:%color">%plot-text:</b> %node-value',
                                padding: 5,
                                "background-color": "#fff #eee",
                                "border-width": 1,
                                "border-color": "#999",
                                color: "#000",
                                "text-align": "left",
                            },
                        },
                        zoom: { "preserve-zoom": 1, "border-width": 0, "background-color": "#369", alpha: 0.25, label: { visible: !1, "background-color": "#fff", "font-size": 10, padding: 2, "border-width": 1, "border-color": "#999" } },
                        arrow: { "border-width": 1, "border-color": "#000", "background-color": "#666", size: 4 },
                        "legend[position]": { margin: 10 },
                        legend: {
                            "background-color": "#eee",
                            alpha: 1,
                            shadow: 1,
                            margin: "10 10 auto auto",
                            padding: "4 2 4 2",
                            item: { "text-align": "left", margin: "2 6 2 4", padding: "2 4" },
                            "item-off": { alpha: 0.25 },
                            marker: { shadow: 0, size: 6, "border-color": "#999", "border-width": 1 },
                            header: { "font-size": 12, "text-align": "left", bold: 1 },
                            footer: { "text-align": "left" },
                            icon: { "line-color": "#000", "line-width": 1 },
                            "page-status": { color: "#000" },
                            "page-on": { "background-color": "#f90" },
                            "page-off": { "background-color": "#999" },
                            scroll: {
                                bar: { width: 12, height: 12, "background-color": "#e1eaec", "border-color": "#ddd" },
                                handle: {
                                    width: 12,
                                    height: 12,
                                    "background-color": "#ddd",
                                    "border-color": "#ccc",
                                    "border-width": 2,
                                    "border-top": "2px solid #eee",
                                    "border-left": "2px solid #eee",
                                    "border-right": "2px solid #999",
                                    "border-bottom": "2px solid #999",
                                },
                            },
                        },
                    },
                    vbar: { plot: { "value-box": { placement: "top-out" } } },
                    vbar3d: { plot: { "value-box": { placement: "top-out" } }, "3d-aspect": { depth: 40, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0 } },
                    mixed3d: { "3d-aspect": { depth: 40, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0 } },
                    hbar: {
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x[default]": { label: { angle: 270 } },
                        "scale-x[opposite]": { label: { angle: 90 } },
                        plot: { "value-box": { placement: "top-out" } },
                    },
                    vline: {
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x[default]": { label: { angle: 270 } },
                        "scale-x[opposite]": { label: { angle: 90 } },
                    },
                    varea: {
                        plot: { "fill-angle": 0 },
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x[default]": { label: { angle: 270 } },
                        "scale-x[opposite]": { label: { angle: 90 } },
                    },
                    hbar3d: {
                        "scale-y": { label: { angle: 0 } },
                        "scale-x": { label: { angle: 270 } },
                        "scale-y-n": { label: { angle: 0 } },
                        "scale-x-n": { label: { angle: 90 } },
                        "3d-aspect": { depth: 40, angle: 45, "x-angle": 0, "y-angle": -20, "z-angle": 0 },
                        plot: { "value-box": { placement: "top-out" } },
                    },
                    hbullet: {
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x": { label: { angle: 270 } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x-n": { label: { angle: 90 } },
                    },
                    line: { plot: { "line-width": 4, marker: { type: "circle", size: 4 } } },
                    area: { plot: { "line-width": 4, marker: { type: "circle", size: 4 }, "value-box": { placement: "top" } } },
                    line3d: { "3d-aspect": { depth: 40, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0 }, plot: { "border-width": 1, "line-width": 1, marker: { type: "circle", size: 4, alpha: 1, visible: 0 } } },
                    area3d: {
                        "3d-aspect": { depth: 40, angle: 45, "x-angle": -20, "y-angle": 0, "z-angle": 0 },
                        plot: { "border-width": 1, "line-width": 1, marker: { type: "circle", size: 4, alpha: 1, visible: 0 }, "value-box": { placement: "top" } },
                    },
                    scatter: { SCALE: { offset: 10 }, plot: { marker: { type: "circle", size: 4 }, "value-box": { placement: "top" } } },
                    poly: { SCALE: { offset: 10 }, plot: { "alpha-area": 0.4, marker: { type: "none" }, "value-box": { placement: "top" } } },
                    hscatter: {
                        SCALE: { offset: 10 },
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x": { label: { angle: 270 } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x-n": { label: { angle: 90 } },
                        plot: { marker: { type: "circle", size: 4 }, "value-box": { placement: "top" } },
                    },
                    bubble: {
                        SCALE: { offset: 40 },
                        plot: {
                            marker: { type: "circle", "fill-type": "radial", "fill-offset-x": -0.2, "fill-offset-y": -0.2 },
                            "hover-marker": { "fill-type": "radial", "fill-offset-x": -0.2, "fill-offset-y": -0.2 },
                            "value-box": { placement: "middle", text: "%node-size-value" },
                            "tooltip-text": "%node-size-value",
                        },
                    },
                    hbubble: {
                        SCALE: { offset: 40 },
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x": { label: { angle: 270 } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x-n": { label: { angle: 90 } },
                        plot: {
                            marker: { type: "circle", "fill-type": "radial", "fill-offset-x": -0.2, "fill-offset-y": -0.2 },
                            "hover-marker": { "fill-type": "radial", "fill-offset-x": -0.2, "fill-offset-y": -0.2 },
                            "value-box": { placement: "middle", text: "%node-size-value" },
                            "tooltip-text": "%node-size-value",
                        },
                    },
                    hmixed: {
                        "scale-y": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x": { label: { angle: 270 } },
                        "scale-y-n": { label: { angle: 0 }, item: { "text-align": "center" } },
                        "scale-x-n": { label: { angle: 90 } },
                    },
                    pie: {
                        plotarea: { margin: "35 5 5 5" },
                        scale: { "size-factor": "auto", "line-width": 0, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 } },
                        plot: { "fill-type": "radial", "value-box": { connector: { "line-width": 1 }, placement: "out", text: "%t", visible: 1 } },
                    },
                    pie3d: {
                        "3d-aspect": { "x-angle": 38, "y-angle": 0, "z-angle": 0 },
                        plotarea: { margin: "25 5 5 5" },
                        scale: { "size-factor": "auto", "line-width": 0, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 } },
                        plot: { "fill-type": "linear", "value-box": { connector: { "line-width": 1 }, placement: "out", text: "%t", visible: 1 } },
                    },
                    nestedpie: {
                        plotarea: { margin: "40 5 15 5" },
                        scale: { "size-factor": 0.8, "line-width": 0, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 } },
                        plot: { "fill-type": "radial", "value-box": { connector: { "line-width": 1 }, text: "%t", visible: 1 } },
                    },
                    venn: { plotarea: { margin: "30 10 10 10" }, plot: { alpha: 0.5, "border-width": 4 }, scale: { "size-factor": 0.65, "line-width": 0, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 } } },
                    radar: {
                        SCALE: { guide: { "line-width": 1, "line-color": "#999", "background-color": "-1" }, tick: { "line-width": 1 }, item: { "auto-align": !1 } },
                        scale: { visible: 0, "size-factor": 0.7 },
                        "scale-k": { "ref-angle": 270 },
                        plotarea: { margin: "40 5 5 5" },
                        plot: { "line-width": 4, aspect: "line", marker: { type: "circle" } },
                    },
                    gauge: {
                        SCALE: { guide: { "border-width": 1, "border-color": "#999", "background-color": "-1" } },
                        scale: { "line-width": 0, guide: { "line-width": 0 }, "minor-guide": { "line-width": 0 }, "size-factor": 0.7 },
                        "scale-r": { "ref-angle": 270, "background-color": "#fff", guide: { "line-width": 0 }, tick: { placement: "inner" }, item: { "offset-r": "-45%" } },
                        plot: { size: "85%" },
                        plotarea: { margin: "40 5 5 5" },
                    },
                    stock: { plot: { "line-width": 1, "border-width": 1, "tooltip-text": "Open:&nbsp;$%open<br>High:&nbsp;$%high<br>Low:&nbsp;$%low<br>Close:&nbsp;$%close" } },
                    range: { plot: { "line-width": 2, "value-box": { text: "%node-min-value - %node-max-value" }, "tooltip-text": "%node-min-value - %node-max-value" } },
                    "-": "",
                }),
                (this.PN = function (e, i) {
                    var t,
                        n = this,
                        a = !1;
                    return (
                        null !== ZC._n_((t = n.B8.graph[e])) && null !== ZC._n_(t.enabled) && (a = a || ZC._b_(t.enabled)),
                        null !== ZC._n_(n.B8[i]) && null !== ZC._n_((t = n.B8[i][e])) && null !== ZC._n_(t.enabled) && (a = a || ZC._b_(t.enabled)),
                        a
                    );
                }),
                (this.load = function (e, i, t, n) {
                    var a,
                        l,
                        o,
                        r = this;
                    (t = null === ZC._n_(t) || ZC._b_(t)), (n = null !== ZC._n_(n) && ZC._b_(n)), i instanceof Array || (i = new Array(i));
                    var s = [],
                        A = "";
                    for (l = 0, o = i.length; l < o; l++)
                        if (/(\(\w+\))(.*)/.test(i[l])) {
                            var C = RegExp.$1;
                            (A = i[l].replace(C, "graph")), -1 === ZC.AV(s, A) && s.push(A), (A = i[l].replace(C, C.substring(1, C.length - 1))), -1 === ZC.AV(s, A) && s.push(A);
                        } else
                            -1 === ZC.AV(s, i[l]) && s.push(i[l]),
                                /root(.*)/.test(i[l]) && -1 === ZC.AV(s, i[l].replace("root", "loader")) && s.push(i[l].replace("root", "loader")),
                                /loader(.*)/.test(i[l]) && -1 === ZC.AV(s, i[l].replace("loader", "root")) && s.push(i[l].replace("loader", "root"));
                    var c = {};
                    for (l = 0, o = s.length; l < o; l++) {
                        for (var u = s[l].split("."), p = r.B8, Z = 0, h = u.length; Z < h; Z++)
                            if (null !== ZC._n_((a = p[u[Z]]))) p = a;
                            else if (null !== ZC._n_((a = p[ZC.UM(u[Z])]))) p = a;
                            else {
                                if (null === ZC._n_((a = p[ZC.EE(u[Z])]))) {
                                    p = null;
                                    break;
                                }
                                p = a;
                            }
                        if (p)
                            for (var d in p)
                                null !== ZC._n_(p[d]) &&
                                    (n || "object" != typeof p[d] || p[d].length) &&
                                    (t || null === ZC._n_(e[d]) ? (r.H.QN && null !== ZC._n_(r.H.QN[d])) || (c[d] = p[d]) : t && "object" == typeof p[d] && ((r.H.QN && null !== ZC._n_(r.H.QN[d])) || (c[d] = p[d])));
                    }
                    ZC._cp_(c, e);
                });
        }),
        (ZC.AP = {
            AGL: function (e, i) {
                for (var t = [], n = 0, a = e.p.length; n < a; n++)
                    if (e.p[n]) {
                        var l = (e.p[n][0] - e.x) / e.w,
                            o = (e.p[n][1] - e.y) / e.h;
                        t.push([i.x + i.w * l, i.y + i.h * o]);
                    } else t.push(null);
                return { l: (i.w * e.l) / e.w, r: (i.w * e.r) / e.w, p: t };
            },
            ACC: function (e, i, t) {
                var n = document.getElementsByTagName("head")[0],
                    a = document.createElement("script");
                (a.type = "text/javascript"), (a.src = i + "?v" + ZC.VERSION);
                var l = !1;
                (a.onload = a.onreadystatechange = function () {
                    if (!(l || (this.readyState && "loaded" !== this.readyState && "complete" !== this.readyState))) {
                        (l = !0), (a.onload = a.onreadystatechange = null), n && a.parentNode && n.removeChild(a);
                        var e = new RegExp("zingchart-(.+?).min.js", "g").exec(i);
                        e && ZC.WG.push(e[1]), t && t(i);
                    }
                }),
                    (a.onerror = function () {
                        !e && zingchart.HZ[0] && (e = zingchart.HZ[0]), e ? e.NY({ name: "Network error", message: "Resource not found (" + a.src + ")" }, "Module loader") : alert("Resource not found (" + a.src + ")");
                    }),
                    n.insertBefore(a, n.firstChild);
            },
            _rcolor_: function () {
                return "#" + ZC.XR.md5(ZC._r_(0, 99999)).substr(ZC._r_(0, 20), 6);
            },
            WO: function () {},
            A80: function (e, i) {
                return zingchart[e] || (i && i.A16 && i.A16[e]) || zingchart.hasEvent(null, e) || (i && zingchart.hasEvent(i.L, e));
            },
            C0: function (e, i, t, n, a) {
                t instanceof Array || (t = [t]);
                var l = 1;
                return (
                    null !== ZC._n_(n) && t.push(n),
                    a && ((l = 2), t.push(a)),
                    "touchstart" === e && (e = "mousedown"),
                    "touchend" === e && (e = "mouseup"),
                    "touchmove" === e && (e = "mousemove"),
                    zingchart[e] && "render" !== e && (null !== ZC._n_(n) ? (t[t.length - l] = zingchart[e].apply(zingchart, t)) : zingchart[e].apply(zingchart, t)),
                    i && i.A16[e] && (null !== ZC._n_(n) ? (t[t.length - l] = i.A16[e].apply(zingchart, t)) : i.A16[e].apply(zingchart, t)),
                    zingchart.hasEvent(null, e) && (null !== ZC._n_(n) ? (t[t.length - l] = zingchart.callEvent(null, e, t, n)) : zingchart.callEvent(null, e, t)),
                    i && zingchart.hasEvent(i.L, e) && (null !== ZC._n_(n) ? (t[t.length - l] = zingchart.callEvent(i.L, e, t, n)) : zingchart.callEvent(i.L, e, t)),
                    t[t.length - l]
                );
            },
            O4: function (e, i) {
                if (i.AA % 360 != 0) {
                    for (
                        var t = [
                                [-i.I / 2, -i.F / 2],
                                [i.I / 2, -i.F / 2],
                                [i.I / 2, i.F / 2],
                                [-i.I / 2, i.F / 2],
                            ],
                            n = "",
                            a = 0;
                        a < 4;
                        a++
                    )
                        (t[a] = [i.iX + i.I / 2 + i.BL + ZC.MAPTX + t[a][0] * ZC.EH(i.AA) - t[a][1] * ZC.EP(i.AA), i.iY + i.F / 2 + i.BI + ZC.MAPTX + t[a][0] * ZC.EP(i.AA) + t[a][1] * ZC.EH(i.AA)]),
                            (n += ZC._i_(t[a][0]) + "," + ZC._i_(t[a][1]) + ",");
                    return (i.E = t), ZC.Q.FX("poly", i.EA, i.IP) + 'class="' + e + '-label-area zc-label-area" id="' + i.L + '-area" coords="' + n.substring(0, n.length - 1) + '" />';
                }
                return (
                    ZC.Q.FX("rect", i.EA, i.IP) +
                    'class="' +
                    e +
                    '-label-area zc-label-area" id="' +
                    i.L +
                    '-area" coords="' +
                    ZC._i_(i.iX + i.BL + ZC.MAPTX) +
                    "," +
                    ZC._i_(i.iY + i.BI + ZC.MAPTX) +
                    "," +
                    ZC._i_(i.iX + i.BL + i.I + ZC.MAPTX) +
                    "," +
                    ZC._i_(i.iY + i.BI + i.F + ZC.MAPTX) +
                    '" />'
                );
            },
            N1: function (e) {
                var i,
                    t = "",
                    n = e.indexOf('id="');
                if (-1 !== n) {
                    var a = e.indexOf('"', n + 4);
                    -1 !== a && (t = e.substring(n + 4, a));
                }
                if (ZC.cache.data["area-score-" + t]) return ZC.cache.data["area-score-" + t];
                var l = 0;
                if (
                    (-1 !== e.indexOf('shape="rect"')
                        ? ((l += 1e4), 5 === (i = /coords=\"(\-*\d+),(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e)).length && (l += (ZC._i_(i[3]) - ZC._i_(i[1])) * (ZC._i_(i[4]) - ZC._i_(i[2]))))
                        : -1 !== e.indexOf('shape="circle"')
                        ? ((l += 100), (i = /coords=\"(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e)), null !== ZC._n_(i[3]) && (l += ZC._i_(i[3]) / 10))
                        : -1 !== e.indexOf('shape="poly"')
                        ? -1 !== e.indexOf("data-map")
                            ? (l += 1e6)
                            : (l += 1e3)
                        : (l += 1),
                    -1 !== e.indexOf("data-z-sort"))
                ) {
                    var o = /data-z-sort=\"(\-*\d+)\"/.exec(e);
                    o && 2 === o.length && (l *= ZC._i_(Math.pow(10, ZC._i_(o[1]))));
                }
                return "" !== t && ZC.cache.add("area-score-" + t, l), l;
            },
            A5A: function (e, i, t) {
                for (var n = [], a = 0, l = e.length; a < l; a++)
                    if (null !== ZC._n_(e[a])) {
                        var o = e[a].slice(0);
                        null !== ZC._n_(o[0]) && "string" != typeof o[0] && (o[0] += i),
                            null !== ZC._n_(o[1]) && "string" != typeof o[1] && (o[1] += t),
                            null !== ZC._n_(o[2]) && "string" != typeof o[2] && o.length <= 4 && (o[2] += i),
                            null !== ZC._n_(o[3]) && "string" != typeof o[3] && o.length <= 4 && (o[3] += t),
                            n.push(o);
                    } else n.push(null);
                return n;
            },
            O2: function (e, i) {
                var t;
                (i = i || {}), (e = e || {});
                var n = {};
                if (
                    (null !== ZC._n_((t = e.negation)) && (n.negation = t),
                    null !== ZC._n_((t = e.short)) && (n.short = ZC._b_(t)),
                    null !== ZC._n_((t = e["short-unit"])) && (n["short-unit"] = t),
                    null !== ZC._n_((t = e.exponent)) && (n.exponent = ZC._b_(t)),
                    null !== ZC._n_((t = e["exponent-decimals"])) && (n["exponent-decimals"] = ZC._i_(t)),
                    null !== ZC._n_((t = e["decimals-separator"])) ? (n["decimals-separator"] = t) : null === ZC._n_(i["decimals-separator"]) && null !== ZC._n_((t = ZC.HJ["decimals-separator"])) && (n["decimals-separator"] = t),
                    null !== ZC._n_((t = e["thousands-separator"])) ? (n["thousands-separator"] = t) : null === ZC._n_(i["thousands-separator"]) && null !== ZC._n_((t = ZC.HJ["thousands-separator"])) && (n["thousands-separator"] = t),
                    null !== ZC._n_((t = e.decimals)) && (n.decimals = ZC._i_(t)),
                    null !== ZC._n_((t = e["decimals-dyn"])) && (n["decimals-dyn"] = t),
                    null !== ZC._n_((t = e.transform)) && null !== ZC._n_(t.type))
                )
                    switch (t.type) {
                        case "date":
                            (n["transform-date"] = !0), null !== ZC._n_(t.text) && (t.all = t.text), null !== ZC._n_(t.all) && (n["transform-date-format"] = t.all);
                    }
                return n;
            },
            G3: function (e, i, t, n) {
                var a,
                    l = e,
                    o = e + "",
                    r = !1;
                if (
                    (n && null !== ZC._n_(i["transform-date"]) && i["transform-date"] && "" + Number(o) === o && ((o = ZC.AP.Y5(Number(o), i["transform-date-format"], i.utc, i.timezone)), (r = !0)),
                    null === ZC._n_(i["decimals-separator"]) && null !== ZC._n_((e = ZC.HJ["decimals-separator"])) && (i["decimals-separator"] = e),
                    null === ZC._n_(i["thousands-separator"]) && null !== ZC._n_((e = ZC.HJ["thousands-separator"])) && (i["thousands-separator"] = e),
                    null !== ZC._n_(i.decimals) && -1 !== i.decimals && "undefined" != typeof i["max-decimals"] && -1 !== i["max-decimals"] && (i.decimals = ZC.BQ(i["max-decimals"], i.decimals)),
                    !r)
                )
                    if (null !== ZC._n_(i.exponent) && i.exponent) (o = Number(o).toExponential(ZC.CY(20, i["exponent-decimals"]))), null !== ZC._n_(i["decimals-separator"]) && (o = o.replace(/\./g, i["decimals-separator"]));
                    else {
                        if (null !== ZC._n_(i.short) && i.short) {
                            a = "";
                            var s = i["short-unit"] || "";
                            if ("string" != typeof s && s.length) {
                                "" + ZC._f_(s[0]) !== s[0] && (s = [1e3].concat(s));
                                for (var A = 1, C = s[0] || 1e3, c = s.slice(1), u = null, p = 0; p < c.length; p++) 0 === c[p].indexOf("#") && ((u = p), (c[p] = c[p].substring(1)));
                                if (c.length) {
                                    if (null !== u) A = u;
                                    else if (null !== ZC._n_(i["max-power"])) A = i["max-power"];
                                    else {
                                        var Z = ZC.FV(ZC._a_(Number(o)), C);
                                        (A = Math.floor(Z)), (A = ZC.CY(A, c.length - 1));
                                    }
                                    a = c[A];
                                    var h = (o = "" + Number(o) / Math.pow(C, A)).split(".");
                                    2 === h.length && h[1].length >= 9 && (o = null !== ZC._n_(i.decimals) && -1 !== i.decimals ? "" + ZC._x_(o, i.decimals) : "" + ZC._x_(o));
                                }
                            } else {
                                var d = ZC.FV(ZC._a_(Number(o))) / Math.LN10;
                                switch (ZC._a_(Number(o))) {
                                    case 1e3:
                                        d = 3;
                                        break;
                                    case 1e6:
                                        d = 6;
                                        break;
                                    case 1e9:
                                        d = 9;
                                }
                                if ((null !== ZC._n_(i["max-power"]) && (d = 3 * i["max-power"]), "KB" === s.toUpperCase())) (o = "" + Number(o) / 1024), (a = "KB");
                                else if ("MB" === s.toUpperCase()) (o = "" + Number(o) / 1048576), (a = "MB");
                                else if ("GB" === s.toUpperCase()) (o = "" + Number(o) / 1073741824), (a = "GB");
                                else if ("TB" === s.toUpperCase()) (o = "" + Number(o) / 1099511627776), (a = "TB");
                                else if ("PB" === s.toUpperCase()) (o = "" + Number(o) / 0x4000000000000), (a = "PB");
                                else if (d >= 0 && d < 3)
                                    switch (s) {
                                        default:
                                            (o = o), (a = "");
                                            break;
                                        case "K":
                                            (o = "" + Number(o) / 1e3), (a = "K");
                                            break;
                                        case "M":
                                            (o = "" + Number(o) / 1e6), (a = "M");
                                            break;
                                        case "B":
                                            (o = "" + Number(o) / 1e9), (a = "B");
                                    }
                                else
                                    (d >= 3 && d < 6 && "" === s) || "K" === s.toUpperCase()
                                        ? ((o = "" + Number(o) / 1e3), (a = "K"))
                                        : (d >= 6 && d < 9 && "" === s) || "M" === s.toUpperCase()
                                        ? ((o = "" + Number(o) / 1e6), (a = "M"))
                                        : ((d >= 9 && "" === s) || "B" === s.toUpperCase()) && ((o = "" + Number(o) / 1e9), (a = "B"));
                            }
                            if (ZC.P7(o))
                                if (null !== ZC._n_(i.decimals) && -1 !== i.decimals) o = ZC._fixed_(Number(o), ZC.BQ(0, ZC._i_(i.decimals)));
                                else {
                                    var f = o.split(".")[1] || "";
                                    -1 !== i["max-decimals"] && i["max-decimals"] < f.length && (o = ZC._fixed_(Number(o), ZC.BQ(0, ZC._i_(i["max-decimals"]))));
                                }
                            null !== ZC._n_(i["decimals-separator"]) && (o = o.replace(/\./g, i["decimals-separator"]));
                        }
                        var _ = t ? t.L : "";
                        if (!isNaN(o) && ("string" != typeof l || -1 === _.indexOf("-scale-"))) {
                            if (
                                (null !== ZC._n_(i.decimals) && -1 !== i.decimals && ZC.P7(o) && ((null !== ZC._n_(i.short) && i.short) || (o = ZC._fixed_(Number(o), ZC.BQ(0, ZC._i_(i.decimals))))),
                                null !== ZC._n_(i["thousands-separator"]) || null !== ZC._n_(i["decimals-separator"]))
                            ) {
                                for (var g = o.split("."), v = "", b = 0, B = g[0].length; b < B; b++) {
                                    var m = g[0].substring(b, b + 1);
                                    (v += m), -1 === ZC.AV(["-", "+"], m) && (g[0].length - b - 1) % 3 == 0 && g[0].length - b - 1 != 0 && (v += i["thousands-separator"]);
                                }
                                o = v + (null !== ZC._n_(g[1]) ? i["decimals-separator"] + g[1] : "");
                            }
                            null !== ZC._n_(i.short) && i.short && (o += a);
                        }
                    }
                return o;
            },
            AAG: function (e) {
                var i = e.indexOf("("),
                    t = "",
                    n = "";
                -1 !== i ? ((t = ZC.GW(e.substring(0, i))), (n = ZC.GW(e.substring(i + 1, e.length - 1)))) : (t = ZC.GW(e));
                var a = [],
                    l = "";
                if ("" !== n) {
                    var o = !1,
                        r = !1,
                        s = !1;
                    l = "";
                    for (var A = 0, C = n.length; A < C; A++) {
                        var c = n.substring(A, A + 1);
                        switch (c) {
                            case "\\":
                                s ? ((l += "\\"), (s = !1)) : (s = !0);
                                break;
                            case '"':
                                s ? ((l += '"'), (s = !1)) : r ? (a.push(l), (l = ""), (r = !1)) : o ? (l += c) : (r = !0);
                                break;
                            case "'":
                                s ? ((l += "'"), (s = !1)) : o ? (a.push(l), (l = ""), (o = !1)) : r ? (l += c) : (o = !0);
                                break;
                            case " ":
                                (o || r) && (l += c);
                                break;
                            case ",":
                                o || r ? (l += c) : ("" !== l && a.push(l), (l = ""));
                                break;
                            default:
                                l += c;
                        }
                    }
                }
                return "" !== l && a.push(l), [t, a];
            },
            A4S: function (e) {
                return e.toString().replace(/^([0-9])$/, "0$1");
            },
            Y5: function (e, i, t, n) {
                (e = ZC._i_(e)), (i = i || ZC.HJ["date-formats"].minute), void 0 === t && (t = !1), void 0 === n && (n = 0), t && (e += 36e5 * n);
                var a,
                    l,
                    o,
                    r,
                    s,
                    A,
                    C,
                    c,
                    u = new Date();
                u.setTime(e),
                    t
                        ? ((a = u.getUTCHours()), (l = u.getUTCMinutes()), (o = u.getUTCSeconds()), (r = u.getUTCMilliseconds()), (s = u.getUTCDay()), (A = u.getUTCDate()), (C = u.getUTCMonth()), (c = u.getUTCFullYear()))
                        : ((a = u.getHours()), (l = u.getMinutes()), (o = u.getSeconds()), (r = u.getMilliseconds()), (s = u.getDay()), (A = u.getDate()), (C = u.getMonth()), (c = u.getFullYear()));
                for (
                    var p = [
                            ["mm", ZC.AP.A4S(C + 1)],
                            ["dd", ZC.AP.A4S(A)],
                            ["Y", c],
                            ["y", c.toString().substr(2, 2)],
                            ["F", ZC.HJ["months-long"][C]],
                            ["m", C + 1],
                            ["M", ZC.HJ["months-short"][C]],
                            ["n", C],
                            ["d", A],
                            ["D", ZC.HJ["days-short"][s]],
                            ["j", A],
                            ["l", ZC.HJ["days-long"][s]],
                            ["N", s + 1],
                            ["w", s],
                            [
                                "S",
                                function () {
                                    return A % 10 == 1 ? "st" : A % 10 == 2 ? "nd" : A % 10 == 3 ? "rd" : "th";
                                },
                            ],
                            ["a", a < 12 ? "am" : "pm"],
                            ["A", a < 12 ? "AM" : "PM"],
                            ["g", a % 12 || 12],
                            ["G", a],
                            ["h", ZC.AP.A4S(a % 12 || 12)],
                            ["H", ZC.AP.A4S(a)],
                            ["i", ZC.AP.A4S(l)],
                            ["s", ZC.AP.A4S(o)],
                            ["q", r],
                        ],
                        Z = 0;
                    Z < p.length;
                    Z++
                )
                    i = i.replace("%" + p[Z][0], p[Z][1]);
                return i;
            },
            A0P: {},
            YO: function (e, i) {
                var t = null;
                if ((i && i.BP ? (t = i.BP) : i && i.A && i.A.BP && (t = i.A.BP), "string" == typeof e && -1 !== e.indexOf("%color-") && ZC.COLORS.length > 0))
                    for (var n = 0; n < ZC.COLORS.length; n++)
                        (-1 === e.indexOf("(+") && -1 === e.indexOf("(-")) ||
                            (e = e.replace(/%color-(\d+?)\((\+|\-)(\d+?)\)/gi, function () {
                                var e = ZC.AP.G9(ZC.COLORS[ZC._i_(arguments[1])]);
                                return "+" === arguments[2] ? (e = ZC.AP.R0(e, ZC._i_(arguments[3]))) : "-" === arguments[2] && (e = ZC.AP.JM(e, ZC._i_(arguments[3]))), e;
                            })),
                            (e = e.replace("%color-" + n, ZC.COLORS[n]));
                else "string" == typeof e && t && -1 !== e.indexOf("%palette-") && (e = t[ZC._i_(e.replace("%palette-", ""))]);
                return e;
            },
            G9: function (e, i) {
                var t, n, a, l;
                if (null !== ZC._n_(ZC.AP.A0P[e])) return ZC.AP.A0P[e];
                var o = ZC.GW(String(e)),
                    r = 1,
                    s = !1;
                return 0 === o.length
                    ? ""
                    : ("rgba(" === (o = o.replace("0x", "#")).substring(0, 5)
                          ? (t = new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3}),\\s*([0-9.]+)\\)", "gi").exec(o)) &&
                            (1 === (n = ZC.OV(t[1])).length && (n = "0" + n),
                            1 === (a = ZC.OV(t[2])).length && (a = "0" + a),
                            1 === (l = ZC.OV(t[3])).length && (l = "0" + l),
                            (o = "#" + n + a + l),
                            (r = ZC.BQ(0, ZC.CY(1, parseFloat(t[4])))),
                            (s = !0))
                          : "rgb(" === o.substring(0, 4)
                          ? (t = new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)", "gi").exec(o)) &&
                            (1 === (n = ZC.OV(t[1])).length && (n = "0" + n), 1 === (a = ZC.OV(t[2])).length && (a = "0" + a), 1 === (l = ZC.OV(t[3])).length && (l = "0" + l), (o = "#" + n + a + l))
                          : "#" === o.substring(0, 1)
                          ? 4 === o.length
                              ? (o = "#" + o.substring(1, 2) + o.substring(1, 2) + o.substring(2, 3) + o.substring(2, 3) + o.substring(3, 4) + o.substring(3, 4))
                              : 7 !== o.length && (o = "")
                          : null !== ZC._n_(ZC.Q.A9T[o.toUpperCase()]) && (o = "#" + ZC.Q.A9T[o.toUpperCase()]),
                      ("none" !== o && "transparent" !== o) || (o = "-1"),
                      i || (ZC.AP.A0P[e] = o),
                      i && s ? [o, r] : o);
            },
            A1U: {},
            A34: function (e, i) {
                if ((-1 === e && ((e = "#ffffff"), (i = 0)), null !== ZC._n_(ZC.AP.A1U[e + "," + i]))) return ZC.AP.A1U[e + "," + i];
                4 === e.length && (e = e.substring(0, 1) + e.substring(1, 2) + e.substring(1, 2) + e.substring(2, 3) + e.substring(2, 3) + e.substring(3, 4) + e.substring(3, 4));
                var t = "rgba(" + [ZC.QV(e.substring(1, 3)), ZC.QV(e.substring(3, 5)), ZC.QV(e.substring(5, 7)), i].join(",") + ")";
                return (ZC.AP.A1U[e + "," + i] = t), t;
            },
            AD9: function (e, i, t) {
                (e /= 255), (i /= 255), (t /= 255);
                var n,
                    a,
                    l,
                    o = Math.max(e, i, t),
                    r = Math.min(e, i, t);
                l = o;
                var s = o - r;
                if (((a = 0 === o ? 0 : s / o), o === r)) n = 0;
                else {
                    switch (o) {
                        case e:
                            n = (i - t) / s + (i < t ? 6 : 0);
                            break;
                        case i:
                            n = (t - e) / s + 2;
                            break;
                        case t:
                            n = (e - i) / s + 4;
                    }
                    n /= 6;
                }
                return [n, a, l];
            },
            AD7: function (e, i, t) {
                var n,
                    a,
                    l,
                    o = Math.floor(6 * e),
                    r = 6 * e - o,
                    s = t * (1 - i),
                    A = t * (1 - r * i),
                    C = t * (1 - (1 - r) * i);
                switch (o % 6) {
                    case 0:
                        (n = t), (a = C), (l = s);
                        break;
                    case 1:
                        (n = A), (a = t), (l = s);
                        break;
                    case 2:
                        (n = s), (a = t), (l = C);
                        break;
                    case 3:
                        (n = s), (a = A), (l = t);
                        break;
                    case 4:
                        (n = C), (a = s), (l = t);
                        break;
                    case 5:
                        (n = t), (a = s), (l = A);
                }
                return [255 * n, 255 * a, 255 * l];
            },
            JM: function (e, i) {
                if (-1 === e) return -1;
                if (i >= 100) return "#000000";
                (e = ZC.AP.G9(e)), void 0 === i && (i = 10);
                var t = ZC.QV(e.substring(1, 3)),
                    n = ZC.QV(e.substring(3, 5)),
                    a = ZC.QV(e.substring(5, 7)),
                    l = ZC.AP.AD9(t, n, a);
                l[2] = i > 0 ? Math.max(0, l[2] - (l[2] * i) / 100) : Math.min(1, l[2] - (l[2] * i) / 100);
                var o = ZC.AP.AD7(l[0], l[1], l[2]);
                return (o[0] = ZC._i_(o[0]) < 16 ? "0" + ZC.OV(o[0]) : ZC.OV(o[0])), (o[1] = ZC._i_(o[1]) < 16 ? "0" + ZC.OV(o[1]) : ZC.OV(o[1])), (o[2] = ZC._i_(o[2]) < 16 ? "0" + ZC.OV(o[2]) : ZC.OV(o[2])), (e = "#" + o[0] + o[1] + o[2]);
            },
            R0: function (e, i) {
                if (-1 === e) return -1;
                if (i >= 100) return "#ffffff";
                (e = ZC.AP.G9(e)), void 0 === i && (i = 10);
                var t = parseInt(e.substr(1, 2), 16),
                    n = parseInt(e.substr(3, 2), 16),
                    a = parseInt(e.substr(5, 2), 16);
                return "#" + (0 | (256 + t + ((256 - t) * i) / 100)).toString(16).substr(1) + (0 | (256 + n + ((256 - n) * i) / 100)).toString(16).substr(1) + (0 | (256 + a + ((256 - a) * i) / 100)).toString(16).substr(1);
            },
            _hex2rgb_: function (e, i) {
                var t = parseInt(e.substr(1, 2), 16),
                    n = parseInt(e.substr(3, 2), 16),
                    a = parseInt(e.substr(5, 2), 16);
                return ZC._n_(i) ? "rgb(" + t + "," + n + "," + a + ")" : { r: t, g: n, b: a };
            },
            _rgb2hex_: function (e, i, t) {
                return "#" + ((1 << 24) + (e << 16) + (i << 8) + t).toString(16).slice(1);
            },
            A9Z: function (e, i, t) {
                var n = ZC.AP._hex2rgb_(e);
                return (299 * n.r + 587 * n.g + 114 * n.b) / 1e3 >= 128 ? t : i;
            },
            _colorAlpha_: function (e, i, t) {
                (e = ZC.AP.G9(e)), (i = ZC.AP.G9(i));
                var n = ZC.AP._hex2rgb_(e),
                    a = ZC.AP._hex2rgb_(i),
                    l = {};
                for (var o in n) l[o] = Math.floor(t * n[o] + (1 - t) * a[o]);
                return ZC.AP._rgb2hex_(l.r, l.g, l.b);
            },
            A40: function () {},
            ABR: function () {},
            gc: function (e, i) {
                var t;
                for (t = 0; t < i.length; t++) e[i[t]] = null;
                for (t in e) 0 === t.indexOf("zc_") && "function" == typeof e[t] && (e[t] = null);
            },
        }),
        (ZC.Q = {
            A9T: {
                BLACK: "000000",
                BLUE: "0000FF",
                BROWN: "A52A2A",
                CYAN: "00FFFF",
                FUCHSIA: "FF00FF",
                GOLD: "FFD700",
                GRAY: "808080",
                GREEN: "008000",
                INDIGO: "4B0082",
                LIME: "00FF00",
                MAGENTA: "FF00FF",
                MAROON: "800000",
                NAVY: "000080",
                ORANGE: "FFA500",
                PINK: "FFC0CB",
                PURPLE: "800080",
                RED: "FF0000",
                SILVER: "C0C0C0",
                TURQUOISE: "40E0D0",
                VIOLET: "EE82EE",
                WHITE: "FFFFFF",
                YELLOW: "FFFF00",
            },
            FX: function (e, i, t) {
                return "<area" + (t && !i && "hand" !== t ? ' style="cursor:' + t + '"' : "") + ((i && "arrow" !== t) || "hand" === t ? ' href="javascript:;"' : "") + ' shape="' + e + '" ';
            },
            ABE: function (e) {
                var i;
                if (ZC.A5.browser.msie)
                    try {
                        i = document.createElement("<iframe />");
                    } catch (r) {
                        i = document.createElement("iframe");
                    }
                else i = document.createElement("iframe");
                (i.id = e.id + "-iframe"), (i.style.visibility = "hidden"), e.appendChild(i);
                var t = null,
                    n = i.contentWindow || i.contentDocument;
                if (!(t = n.document ? n.document : n).body) {
                    var a = t.createElement("HTML");
                    t.appendChild(a);
                    var l = t.createElement("HEAD");
                    a.appendChild(l);
                    var o = t.createElement("BODY");
                    a.appendChild(o);
                }
                return t;
            },
            C1: function (e) {
                var i;
                if ("undefined" == typeof ZC.TOUCHEVENTS) {
                    if (ZC.ie678) i = !1;
                    else {
                        i = !0;
                        try {
                            document.createEvent("TouchEvent");
                        } catch (t) {
                            i = !1;
                        }
                    }
                    i && !ZC.mobile && (i = !1), i && (i = "ontouchstart" in document.documentElement), (ZC.TOUCHEVENTS = i);
                } else i = ZC.TOUCHEVENTS;
                if (i)
                    switch (e) {
                        case "mouseover":
                        case "mousedown":
                            e = "touchstart";
                            break;
                        case "mousemove":
                            e = "touchmove";
                            break;
                        case "mouseout":
                        case "mouseup":
                            e = "touchend";
                            break;
                        case "click":
                            e = "touchstart";
                    }
                return e;
            },
            _sh_: function (e, i) {
                var t,
                    n,
                    a,
                    l = [],
                    o = i.JV,
                    r = i.OH,
                    s = i.P4,
                    A = o - s / 2;
                if (e.length > 0) {
                    var C = 0,
                        c = 0;
                    for (0 !== o && ((C = ZC._i_(A * ZC.EH(r) + s)), (c = ZC._i_(A * ZC.EP(r) + s))), t = 0, n = e.length; t < n; t++)
                        if (null !== ZC._n_(e[t])) {
                            var u = [];
                            for (a = 0; a < e[t].length; a++) u[a] = e[t][a];
                            var p = u.length;
                            if (2 === p || 4 === p) for (a = 0; a < p; a++) u[a] = e[t][a] + (a % 2 ? c + ZC._c_(i.BI, 0) : C + ZC._c_(i.BL, 0));
                            l.push(u);
                        } else l.push(null);
                }
                return l;
            },
            _txp_: function (e, i, t, n, a) {
                void 0 === a && (a = !1);
                var l,
                    o,
                    r = [e[0], e[1]];
                switch ((e.length >= 4 && ((r[2] = e[2]), (r[3] = e[3])), e.length >= 6 && ((r[4] = e[4]), (r[5] = e[5])), 7 === e.length && (r[6] = e[6]), i)) {
                    case "canvas":
                    case "svg":
                        var s, A;
                        if (t.CZ)
                            (s = A = t.B0 % 2 == 1 ? 0.5 : 0),
                                ZC.A5.browser.msie && ZC.quirks && "svg" === i && ((s = t.B0 % 2 == 1 ? 0.5 : 0), (A = t.B0 % 2 == 1 ? 0 : 0.5)),
                                (r[0] = Math.round(r[0]) - s),
                                (r[1] = Math.round(r[1]) - A),
                                4 === r.length && ((r[2] = Math.round(r[2]) - s), (r[3] = Math.round(r[3]) - A));
                        "svg" === i && ((r[0] = parseFloat(r[0].toFixed(4))), (r[1] = parseFloat(r[1].toFixed(4))), 4 === r.length && ((r[2] = parseFloat(r[2].toFixed(4))), (r[3] = parseFloat(r[3].toFixed(4))))),
                            "canvas" !== i || n || ("undefined" != typeof t.BL && "undefined" != typeof t.BI && ((r[0] += t.BL), (r[1] += t.BI), 4 === r.length && ((r[2] += t.BL), (r[3] += t.BI))));
                        break;
                    case "vml":
                        t.AA % 360 == 0 ? ((l = 10), (o = t.B0 % 2 == 1 ? 0 : l / 2)) : ((l = 1), (o = 0)),
                            t.CZ
                                ? ((r[0] = l * ZC._i_(ZC._i_(l * r[0]) / l) - o),
                                  (r[1] = l * ZC._i_(ZC._i_(l * r[1]) / l) - o),
                                  (4 !== r.length && 7 !== r.length) || ((r[2] = l * ZC._i_(ZC._i_(l * r[2]) / l) - o), (r[3] = l * ZC._i_(ZC._i_(l * r[3]) / l) - o)),
                                  7 === r.length && ((r[4] = l * ZC._i_(ZC._i_(l * r[4]) / l) - o), (r[5] = l * ZC._i_(ZC._i_(l * r[5]) / l) - o)))
                                : ((r[0] = ZC._i_(l * r[0])),
                                  (r[1] = ZC._i_(l * r[1])),
                                  (4 !== r.length && 7 !== r.length) || ((r[2] = ZC._i_(l * r[2])), (r[3] = ZC._i_(l * r[3]))),
                                  7 === r.length && ((r[4] = ZC._i_(l * r[4])), (r[5] = ZC._i_(l * r[5]))));
                }
                return r;
            },
            A2Z: function (e, i, t, n, a) {
                var l, o, r, s, A, C, c;
                if ((t.QQ && (t.D["fast-vector-path"] = !0), !t.D["fast-vector-path"])) {
                    for (l = 0, o = e.length; l < o; l++) e[l] && ((e[l][0] = parseFloat(Number(e[l][0]).toFixed(2))), (e[l][1] = parseFloat(Number(e[l][1]).toFixed(2))));
                    if (t.O7 && ((c = t.L + ":" + t.AA + ":" + e.join("#")), ZC.cache.data["path-points-" + c])) return ZC.cache.data["path-points-" + c].split("#");
                }
                var u = [ZC.MAX, ZC.MAX, -ZC.MAX, -ZC.MAX],
                    p = [],
                    Z = !1;
                for (l = 0, o = e.length; l < o; l++)
                    if (null !== ZC._n_(e[l])) {
                        if (t.D["fast-vector-path"]) {
                            if (((r = e[l]), "vml" === i)) {
                                var h = t.AA % 360 == 0 ? 10 : 1;
                                (r[0] = ZC._i_(h * r[0])), (r[1] = ZC._i_(h * r[1])), 4 === r.length && ((r[2] = ZC._i_(h * r[2])), (r[3] = ZC._i_(h * r[3])));
                            }
                        } else r = ZC.Q._txp_(e[l], i, t, n, a);
                        if (null !== ZC._n_(r) && !isNaN(r[0]) && !isNaN(r[1]) && isFinite(r[0]) && isFinite(r[1]))
                            if (
                                (o <= 20 &&
                                    n &&
                                    ((u[0] = ZC.CY(u[0], r[0] / ("vml" === i ? 10 : 1))),
                                    (u[1] = ZC.CY(u[1], r[1] / ("vml" === i ? 10 : 1))),
                                    (u[2] = ZC.BQ(u[2], r[0] / ("vml" === i ? 10 : 1))),
                                    (u[3] = ZC.BQ(u[3], r[1] / ("vml" === i ? 10 : 1)))),
                                0 === l)
                            )
                                p.push(("svg" === i ? "M " : "m ") + r[0] + " " + r[1]);
                            else if ((Z && (p.push(("svg" === i ? "M " : "m ") + r[0] + " " + r[1]), (Z = !1)), 2 === r.length)) p.push(("svg" === i ? "L " : "l ") + r[0] + " " + r[1]);
                            else if (4 === r.length) p.push(("svg" === i ? "Q " : "qb ") + r[0] + " " + r[1] + " " + r[2] + " " + r[3]), "vml" === i && p.push("l " + r[2] + " " + r[3]);
                            else if (6 === r.length)
                                if ("svg" === i) {
                                    var d = 0;
                                    r[3] % 360 == r[4] % 360 && (d = r[4] >= r[3] ? 0.001 : -0.001),
                                        (s = ZC.AQ.BN(r[0], r[1], r[2], r[3] + d)),
                                        (A = ZC.AQ.BN(r[0], r[1], r[2], r[4] - d)),
                                        (C = "0 0"),
                                        0 === r[5]
                                            ? r[4] - r[3] > 360
                                                ? ((C = "0 1"), (A[0] = s[0]), (A[1] = s[1]))
                                                : (C = r[4] - r[3] <= 180 ? "0 1" : "1 1")
                                            : r[3] - r[4] > 360
                                            ? ((C = "0 0"), (A[0] = s[0]), (A[1] = s[1]))
                                            : (C = r[3] - r[4] <= 180 ? "0 0" : "1 0"),
                                        p.push("a " + r[2] + "," + r[2] + " 0 " + C + " " + (A[0] - s[0]) + "," + (A[1] - s[1]));
                                } else
                                    "vml" === i &&
                                        ((r[2] *= 10),
                                        (s = ZC.AQ.BN(r[0], r[1], r[2], r[3])),
                                        (A = ZC.AQ.BN(r[0], r[1], r[2], r[4])),
                                        (C = 1 === r[5] ? "at" : "wa"),
                                        p.push(
                                            C +
                                                " " +
                                                ZC._i_(r[0] - r[2]) +
                                                "," +
                                                ZC._i_(r[1] - r[2]) +
                                                "," +
                                                ZC._i_(r[0] + r[2]) +
                                                "," +
                                                ZC._i_(r[1] + r[2]) +
                                                " " +
                                                ZC._i_(s[0]) +
                                                "," +
                                                ZC._i_(s[1]) +
                                                " " +
                                                ZC._i_(A[0]) +
                                                "," +
                                                ZC._i_(A[1])
                                        ));
                            else 7 === r.length && p.push(("svg" === i ? "C " : "c ") + r[0] + " " + r[1] + " " + r[2] + " " + r[3] + " " + r[4] + " " + r[5]);
                    } else Z = !0;
                return t.D["fast-vector-path"] || (t.O7 && ZC.cache.add("path-points-" + c, p.join("#"))), t.H && o <= 20 && n && (t.H.D[t.L + "-bounds"] = u), p;
            },
            MD: function (e, i) {
                var t,
                    n,
                    a = e.originalEvent || e.originalEventZC;
                return (
                    (i = ZC._i_(i || "0")),
                    a && a.touches
                        ? a.touches.length > 0
                            ? ((t = a.touches[i].pageX), (n = a.touches[i].pageY))
                            : a.changedTouches.length > 0 && ((t = a.changedTouches[i].pageX), (n = a.changedTouches[i].pageY))
                        : ((t = e.pageX), (n = e.pageY)),
                    [ZC._i_(t || "0"), ZC._i_(n || "0")]
                );
            },
            F6: function (e, i, t) {
                var n;
                return (
                    (t = t || document),
                    null !== ZC._n_(i) ? (t.createElementNS ? (n = t.createElementNS(i, e)) : (n = t.createElement(e)).setAttribute("xmlns", i)) : (n = t.createElement(e)),
                    "zcv:" === e.substring(0, 4) && (n.className = "zcvml"),
                    n
                );
            },
            ET: function (e) {
                var i;
                e instanceof Array || (e = [e]);
                for (var t = 0, n = e.length; t < n; t++)
                    "object" != typeof (i = e[t]) && (i = ZC.AL(e[t])), i && ("undefined" != typeof i.parentElement ? i.parentElement.removeChild(i) : "undefined" != typeof i.parentNode && i.parentNode.removeChild(i));
            },
            G4: function (e, i) {
                for (var t in i)
                    if ("string" == typeof t && "object" != typeof i[t] && "function" != typeof i[t])
                        try {
                            e.setAttribute(t, i[t]);
                        } catch (n) {}
            },
            PI: function (e, i) {
                for (var t in i) "string" == typeof t && "object" != typeof i[t] && "function" != typeof i[t] && (e.style[t] = i[t]);
            },
            AAZ: function (e) {
                var i;
                if (e === document) return !0;
                if (!e) return !1;
                if (!e.parentNode) return !1;
                if (e.style) {
                    if ("none" === e.style.display) return !1;
                    if ("hidden" === e.style.visibility) return !1;
                }
                if (window.getComputedStyle) {
                    if ("none" === (i = window.getComputedStyle(e, "")).display) return !1;
                    if ("hidden" === i.visibility) return !1;
                }
                if ((i = e.currentStyle)) {
                    if ("none" === i.display) return !1;
                    if ("hidden" === i.visibility) return !1;
                }
                return ZC.Q.AAZ(e.parentNode);
            },
            T4: function (e) {
                var i = e.className || ZC.A5(e).attr("class");
                return null !== ZC._n_(i) && "object" == typeof i && (i = "undefined" != typeof i.baseVal ? i.baseVal : ""), i || "";
            },
            IV: function (e, i, t, n, a, l, o, r) {
                if (e)
                    switch (((o = o || ""), i)) {
                        case "canvas":
                            r ? e.getContext("2d").clearRect(t, n, a, l) : (e.width = e.width);
                            break;
                        case "vml":
                        case "svg":
                            var s = e.childNodes.length;
                            if (s > 1024 && "undefined" != typeof e.innerHTML) return void (e.innerHTML = "");
                            if (s > 0) for (var A = s - 1; A >= 0; A--) "" === o ? e.removeChild(e.childNodes[A]) : 0 === e.childNodes[A].id.indexOf(o + "-") && e.removeChild(e.childNodes[A]);
                    }
            },
            EB: function (e, i) {
                switch (("string" == typeof e && (e = ZC.AL(e)), i)) {
                    case "canvas":
                        return e.getContext("2d");
                    case "svg":
                    case "vml":
                        return e;
                }
            },
            JZ: function (e, i) {
                switch (i) {
                    case "svg":
                        return ZC.Q.ABK(e);
                    case "vml":
                    case "canvas":
                        return ZC.Q.I2(e);
                }
            },
            HE: function (e, i) {
                switch (i) {
                    case "svg":
                        return ZC.Q.ABK(e);
                    case "vml":
                        return ZC.Q.I2(e);
                    case "canvas":
                        return ZC.Q.ADB(e);
                }
            },
            ABK: function (e) {
                var i;
                if (ZC.AL(e.id)) return ZC.AL(e.id);
                var t = ZC.Q.F6("g", "http://www.w3.org/2000/svg");
                return (
                    null !== ZC._n_((i = e.id)) && t.setAttribute("id", i),
                    null !== ZC._n_((i = e.cls)) && t.setAttribute("class", i),
                    null !== ZC._n_((i = e.zidx)) && t.setAttribute("z-index", i),
                    null !== ZC._n_((i = e["clip-path"])) && t.setAttribute("clip-path", i),
                    e.after ? e.p.insertBefore(t, e.after.nextSibling) : e.p.appendChild(t),
                    t
                );
            },
            XD: function (e) {
                var i;
                ZC.Q.ET(e.id);
                var t = ZC.Q.F6("clipPath", "http://www.w3.org/2000/svg");
                return (
                    (t.id = e.id),
                    null !== ZC._n_(e.cx)
                        ? (((i = ZC.Q.F6("circle", "http://www.w3.org/2000/svg")).id = e.id + "-shape"), ZC.Q.G4(i, { cx: e.cx, cy: e.cy, r: e.r }))
                        : (((i = ZC.Q.F6("polygon", "http://www.w3.org/2000/svg")).id = e.id + "-shape"), ZC.Q.G4(i, { points: e.path })),
                    t.appendChild(i),
                    t
                );
            },
            ADB: function (e) {
                var i;
                if (ZC.AL(e.id)) return ZC.AL(e.id);
                var t = document.createElement("canvas"),
                    n = t.style;
                if ((null !== ZC._n_((i = e.id)) && (t.id = i), null !== ZC._n_((i = e.cls)) && (t.className = i), null !== ZC._n_((i = e.wh)))) {
                    var a = ("" + i).split("/");
                    (e.width = a[0]), (e.height = a[1]);
                }
                if (null !== ZC._n_((i = e.tl))) {
                    var l = ("" + i).split("/");
                    (e.top = l[0]), (e.left = l[1]);
                }
                return (
                    (t.width = e.width),
                    (t.height = e.height),
                    null !== ZC._n_((i = e.left)) && (n.left = i + "px"),
                    null !== ZC._n_((i = e.top)) && (n.top = i + "px"),
                    null !== ZC._n_((i = e.display)) && (n.display = i),
                    null !== ZC._n_((i = e.position)) && (n.position = i),
                    null !== ZC._n_((i = e.zidx)) && (n.zIndex = i),
                    e.p.appendChild(t),
                    t
                );
            },
            I2: function (e) {
                var i, t, n, a, l, o;
                if (ZC.AL(e.id))
                    return (
                        (n = ZC.AL(e.id)),
                        null !== ZC._n_((i = e.wh)) && ((l = ("" + i).split("/")), (n.style.width = l[0] + "px"), (n.style.height = l[1] + "px")),
                        null !== ZC._n_((i = e.tl)) && ((o = ("" + i).split("/")), (n.style.top = o[0] + "px"), (n.style.left = o[1] + "px")),
                        n
                    );
                ((a = (n = document.createElement("div")).style).whiteSpace = "nowrap"),
                    null !== ZC._n_((i = e.wh)) && ((l = ("" + i).split("/")), (e.width = l[0]), (e.height = l[1])),
                    null !== ZC._n_((i = e.tl)) && ((o = ("" + i).split("/")), (e.top = o[0]), (e.left = o[1])),
                    null !== ZC._n_((i = e.id)) && (n.id = i),
                    null !== ZC._n_((i = e.cls)) && "" !== i && (n.className = i);
                for (
                    var r = [
                            ["top", "", "px"],
                            ["left", "", "px"],
                            ["width", "", "px"],
                            ["height", "", "px"],
                            "position",
                            "overflow",
                            ["float", "cssFloat|styleFloat"],
                            ["zidx", "zIndex"],
                            "clip",
                            "display",
                            ["fontSize", "", "px"],
                            "fontFamily",
                            "fontWeight",
                            "fontStyle",
                            "textDecoration",
                            "textAlign",
                            "verticalAlign",
                            "color",
                            "border",
                            "borderTop",
                            "borderRight",
                            "borderBottom",
                            "borderLeft",
                            "background",
                            "cursor",
                            ["margin", "marginTop|marginRight|marginBottom|marginLeft", "px"],
                            ["marginTop", "", "px"],
                            ["marginRight", "", "px"],
                            ["marginBottom", "", "px"],
                            ["marginLeft", "", "px"],
                            ["padding", "paddingTop|paddingRight|paddingBottom|paddingLeft", "px"],
                            ["paddingTop", "", "px"],
                            ["paddingRight", "", "px"],
                            ["paddingBottom", "", "px"],
                            ["paddingLeft", "", "px"],
                            "lineHeight",
                            "filter",
                        ],
                        s = null,
                        A = null,
                        C = null,
                        c = 0,
                        u = r.length;
                    c < u;
                    c++
                )
                    if (("string" == typeof r[c] && (r[c] = [r[c]]), (i = null), null !== ZC._n_((t = e[r[c][0]])) && (i = t), null !== ZC._n_(i))) {
                        (null !== ZC._n_(r[c][1]) && "" !== r[c][1]) || (r[c][1] = r[c][0]);
                        for (var p = r[c][1].split("|"), Z = 0, h = p.length; Z < h; Z++) {
                            var d = i + (null === ZC._n_(r[c][2]) ? "" : r[c][2]);
                            (a[p[Z]] = d), "fontFamily" === p[Z] && (s = d), "fontSize" === p[Z] && (A = ZC._i_(d)), "fontWeight" === p[Z] && (C = d);
                        }
                    }
                return (
                    null !== ZC._n_((i = e.opacity)) && ((a.opacity = i), 1 !== ZC._f_(i) && ((a.filter = "alpha(opacity = " + ZC._i_(100 * ZC._f_(i)) + ")"), (a.opacity = i))),
                    null !== ZC._n_((i = e.p)) && (e.after ? i.insertBefore(n, e.after.nextSibling) : i.appendChild(n)),
                    null !== ZC._n_((i = e.html)) &&
                        ((n.innerHTML = ZC._h_(i)),
                        -1 !== i.indexOf("<") &&
                            -1 !== i.indexOf(">") &&
                            ZC.A5(n)
                                .children()
                                .each(function () {
                                    null !== ZC._n_(s) && ((null !== ZC._n_(this.style.fontFamily) && "" !== this.style.fontFamily) || (this.style.fontFamily = s)),
                                        null !== ZC._n_(A) && ((null !== ZC._n_(this.style.fontSize) && "" !== this.style.fontSize) || (this.style.fontSize = A + "px")),
                                        null !== ZC._n_(C) && ((null !== ZC._n_(this.style.fontWeight) && "" !== this.style.fontWeight) || (this.style.fontWeight = C));
                                })),
                    e.rtl && ((n.style.unicodeBidi = "bidi-override"), (n.style.direction = "rtl")),
                    e.cursor && "hand" === e.cursor && (n.style.cursor = "pointer"),
                    n
                );
            },
            W1: null,
            A44: function (e, i, t, n, a, l, o) {
                var r, s, A, C;
                null === ZC._n_(o) && (o = !1);
                var c = !1;
                "[HTMLMODE]" === i.substring(0, 10) && ((c = !0), (i = i.substring(10))), (C = e + "-text-ruler"), -1 !== e.indexOf("-fullscreen") && (C = "zc-text-ruler");
                var u = "{{" + i + "}}" + t.replace(/[^a-z]/gi, "").toLowerCase() + n + l + a;
                if (ZC.cache.data["text-width-" + u] && !o) return ZC.cache.data["text-width-" + u];
                if (ZC.cache.data["text-height-" + u] && o) return ZC.cache.data["text-height-" + u];
                var p,
                    Z = i;
                return (
                    (Z = Z.replace(/<hr>/g, '<hr style="margin:0;padding:0">')),
                    (p = ZC.AL(C))
                        ? ((ZC.Q.W1 && ZC.Q.W1 === e + t + n + l + a) ||
                              ((p.style.fontFamily = t), (p.style.fontSize = n + "px"), (p.style.fontWeight = a), (p.style.lineHeight = c ? "130%" : -1 !== l ? ZC._i_(l) + "px" : "130%"), (ZC.Q.W1 = e + t + n + l + a)),
                          (p.innerHTML = Z))
                        : ((p = ZC.Q.I2({ id: C, p: document.body, tl: "-9999/-9999", html: Z, position: "absolute", fontFamily: t, fontSize: n, cls: "zc-text-ruler", fontWeight: a })).style.lineHeight = c
                              ? "130%"
                              : -1 !== l
                              ? ZC._i_(l) + "px"
                              : "130%"),
                    -1 === i.indexOf("<") ||
                        -1 === i.indexOf(">") ||
                        c ||
                        ZC.A5(p)
                            .children()
                            .each(function () {
                                "BR" !== this.tagName.toUpperCase() &&
                                    ((null !== ZC._n_(this.style.fontFamily) && "" !== this.style.fontFamily) || (this.style.fontFamily = t),
                                    (null !== ZC._n_(this.style.fontSize) && "" !== this.style.fontSize) || (this.style.fontSize = n + "px"),
                                    (this.style.lineHeight = -1 !== l ? ZC._i_(l) + "px" : "130%"),
                                    "B" !== this.tagName.toUpperCase() && "STRONG" !== this.tagName.toUpperCase() && ((null !== ZC._n_(this.style.fontWeight) && "" !== this.style.fontWeight) || (this.style.fontWeight = a)));
                            }),
                    (r = p.getBoundingClientRect()) && r.width > 0
                        ? ((s = r.width), o && (A = r.height))
                        : ((s = ZC.mobile && ZC.A5.browser.webkit ? p.offsetWidth : ZC.A5(p).width()), o && (A = ZC.mobile && ZC.A5.browser.webkit ? p.offsetHeight : ZC.A5(p).height())),
                    o ? (ZC.cache.add("text-height-" + u, A), A) : (ZC.cache.add("text-width-" + u, s), s)
                );
            },
        }),
        !document.getElementsByClassName &&
            document.querySelectorAll &&
            (document.getElementsByClassName = function (e) {
                return document.querySelectorAll("." + e);
            }),
        (ZC.A5 = function (e, i, t) {
            var n,
                a,
                l,
                o,
                r = this;
            if ((void 0 === t && (t = !0), t)) return new ZC.A5(e, i, !1);
            if (((r.P1 = []), (r.QC = e), (r.MA = i), (r.length = 0), (r.MA = r.MA || document.getElementsByTagName("body")[0]), "object" == typeof r.QC)) r.P1 = [r.QC];
            else if ("string" == typeof r.QC)
                for (var s = r.QC.split(","), A = 0; A < s.length; A++) {
                    var C = ZC.GW(s[A]),
                        c = !1;
                    if (
                        (2 === (n = C.split(">")).length &&
                            ((c = !0),
                            ZC.A5(n[0]).each(function () {
                                var e = this;
                                ZC.A5(n[1], this).each(function () {
                                    this.parentNode === e && r.P1.push(this);
                                });
                            })),
                        2 === (n = C.split(" ")).length &&
                            ((c = !0),
                            ZC.A5(n[0]).each(function () {
                                ZC.A5(n[1], this).each(function () {
                                    r.P1.push(this);
                                });
                            })),
                        !c)
                    )
                        if ("#" === C.substring(0, 1)) ZC.AL(C.substring(1)) && (r.P1 = [ZC.AL(C.substring(1))]);
                        else if ("." === C.substring(0, 1))
                            if (document.getElementsByClassName) {
                                if (r.MA.getElementsByClassName) a = r.MA.getElementsByClassName(C.substring(1));
                                else if (((a = document.getElementsByClassName(C.substring(1))), r.MA !== document)) {
                                    var u = [];
                                    for (l = 0, o = a.length; l < o; l++) ZC.A5.childof(a[l], r.MA) && u.push(a[l]);
                                    a = u;
                                }
                                for (l = 0, o = a.length; l < o; l++) r.P1.push(a[l]);
                            } else {
                                var p = new RegExp("(^|\\s)" + C.substring(1) + "(\\s|$)", "i"),
                                    Z = r.MA.getElementsByTagName("*"),
                                    h = "";
                                for (l = 0, o = Z.length; l < o; l++) "object" == typeof (h = Z[l].className) && (h = "undefined" != typeof h.baseVal ? h.baseVal : ""), "" !== h && p.test(h) && r.P1.push(Z[l]);
                            }
                        else for (l = 0, o = (a = r.MA.getElementsByTagName(C)).length; l < o; l++) r.P1.push(a[l]);
                }
            return (r.length = r.P1.length), this;
        }),
        (ZC.A5.prototype = {
            eachfn: function () {
                for (var e, i = [], t = 0, n = this.P1.length; t < n; t++) {
                    var a = [this.P1[t]];
                    if ((e = arguments.length) > 1) for (var l = 1; l < e; l++) a.push(arguments[l]);
                    i.push(arguments[0].apply(this, a));
                }
                return i;
            },
            each: function () {
                for (var e, i = 0, t = this.P1.length; i < t; i++) {
                    var n = [this.P1[i]];
                    if ((e = arguments.length) > 1) for (var a = 1; a < e; a++) n.push(arguments[a]);
                    arguments[0].apply(this.P1[i], n);
                }
                return this;
            },
            children: function () {
                var e = [];
                return (
                    this.each(function () {
                        for (var i = 0, t = this.childNodes.length; i < t; i++) 1 === this.childNodes[i].nodeType && e.push(this.childNodes[i]);
                    }),
                    (this.P1 = e),
                    this
                );
            },
            remove: function () {
                this.eachfn.call(this, function (e) {
                    e && e.parentNode && e.parentNode.removeChild(e);
                });
            },
            empty: function () {
                this.eachfn.call(this, function (e) {
                    if (e) for (; e.childNodes.length; ) e.removeChild(e.childNodes[e.childNodes.length - 1]);
                });
            },
            A2W: function (e) {
                var i, t;
                void 0 === e && (e = !0);
                var n = this.eachfn.call(this, function (n) {
                    if (!n) return null;
                    if (n === window) {
                        var a = document.body;
                        return (
                            n.innerWidth
                                ? ((i = n.innerWidth), (t = n.innerHeight))
                                : a && a.parentElement && a.parentElement.clientWidth
                                ? ((i = a.parentElement.clientWidth), (t = a.parentElement.clientHeight))
                                : a && a.clientWidth && ((i = a.clientWidth), (t = a.clientHeight)),
                            { width: i, height: t }
                        );
                    }
                    var l,
                        o,
                        r = e ? "block" : ZC.A5(n).getstyle("display");
                    if (window.getComputedStyle) {
                        var s = window.getComputedStyle(n, null);
                        (l = s.getPropertyValue("width").slice(0, -2)), (o = s.getPropertyValue("height").slice(0, -2));
                    } else if (n.getBoundingClientRect) {
                        var A = n.getBoundingClientRect();
                        (l = A.width ? A.width : n.offsetWidth), (o = A.height ? A.height : n.offsetHeight);
                    } else (l = n.offsetWidth), (o = n.offsetHeight);
                    if ("none" === r || "" === r || void 0 === r) {
                        var C = n.style,
                            c = C.visibility,
                            u = C.position,
                            p = C.display;
                        (C.visibility = "hidden"), (C.position = "absolute"), (C.display = "block"), (i = l), (t = o), (C.display = p), (C.position = u), (C.visibility = c);
                    } else (i = l || 0), (t = o || 0);
                    return { width: i, height: t };
                });
                return 1 === n.length ? n[0] : n;
            },
            getstyle: function (e) {
                var i = this.eachfn.call(
                    this,
                    function (e, i) {
                        if ("display" === i) return e.style.display;
                        var t,
                            n = document;
                        if (((i = ZC.EE(i)), !e || e === n)) return undefined;
                        if ("opacity" === i && "undefined" != typeof e.filters) {
                            var a = (ZC.A5(e).getstyle("filter") || "").match(/alpha\(opacity=(.*)\)/);
                            return a && a[1] ? parseFloat(a[1]) / 100 : 1;
                        }
                        if (-1 !== ZC.AV(["float", "cssFloat", "styleFloat"], i)) return (t = e.style.float) ? t : (t = e.style.cssFloat) ? t : (t = e.style.styleFloat) ? t : "none";
                        var l = e.style ? e.style[i] : null;
                        if (!l)
                            if (n.defaultView && n.defaultView.getComputedStyle) {
                                var o = n.defaultView.getComputedStyle(e, null);
                                (i = i.replace(/([A-Z])/g, "-$1").toLowerCase()), (l = o ? o.getPropertyValue(i) : null);
                            } else if (e.currentStyle && ((l = e.currentStyle[i]), /^\d/.test(l) && !/px$/.test(l) && "fontWeight" !== i)) {
                                var r = e.style.left,
                                    s = e.runtimeStyle.left;
                                (e.runtimeStyle.left = e.currentStyle.left), (e.style.left = l || 0), (l = e.style.pixelLeft + "px"), (e.style.left = r), (e.runtimeStyle.left = s);
                            }
                        return (
                            "opacity" === i && (l = parseFloat(l)),
                            /Opera/.test(navigator.userAgent) && -1 !== ZC.AV(["left", "top", "right", "bottom"], i) && "static" === ZC.A5(e).getstyle("position") && (l = "auto"),
                            "auto" === l ? null : l
                        );
                    },
                    e
                );
                return 1 === i.length ? i[0] : i;
            },
            wh: function () {
                var e;
                return this.P1[0] ? (null !== ZC._n_((e = ZC.A5(this.P1[0]).A2W())) ? [ZC._i_(e.width), ZC._i_(e.height)] : [0, 0]) : null;
            },
            width: function (e) {
                var i;
                if (void 0 === e) {
                    var t = this.eachfn.call(this, function (e) {
                        return null !== ZC._n_((i = ZC.A5(e).A2W())) ? ZC._i_(i.width) : 0;
                    });
                    return 1 === t.length ? t[0] : t;
                }
                return (
                    this.eachfn.call(
                        this,
                        function (e, i) {
                            e.style.width = i + "px";
                        },
                        e
                    ),
                    this
                );
            },
            height: function (e) {
                var i;
                if (void 0 === e) {
                    var t = this.eachfn.call(this, function (e) {
                        return null !== ZC._n_((i = ZC.A5(e).A2W())) ? ZC._i_(i.height) : 0;
                    });
                    return 1 === t.length ? t[0] : t;
                }
                return (
                    this.eachfn.call(
                        this,
                        function (e, i) {
                            e.style.height = i + "px";
                        },
                        e
                    ),
                    this
                );
            },
            scrollLeft: function () {
                return ZC.A5.scroll().left;
            },
            scrollTop: function () {
                return ZC.A5.scroll().top;
            },
            css: function (e, i) {
                if (void 0 === i) {
                    var t = this.eachfn.call(this, function (i) {
                        var t = ZC.A5(i).getstyle(e);
                        return -1 !== ("" + t).indexOf("px") ? ZC._i_(t) : t;
                    });
                    return 1 === t.length ? t[0] : t;
                }
                return (
                    this.eachfn.call(
                        this,
                        function (e, i, t) {
                            e.style[i] = t;
                        },
                        e,
                        i
                    ),
                    this
                );
            },
            attr: function (e, i) {
                if (void 0 === i) {
                    var t = this.eachfn.call(this, function (i) {
                        return i.getAttribute(e);
                    });
                    return 1 === t.length ? t[0] : t;
                }
                return (
                    this.eachfn.call(
                        this,
                        function (e, i, t) {
                            e.setAttribute(i, t);
                        },
                        e,
                        i
                    ),
                    this
                );
            },
            val: function (e) {
                if (void 0 === e) {
                    var i = this.eachfn.call(this, function (e) {
                        return e.value;
                    });
                    return 1 === i.length ? i[0] : i;
                }
                return (
                    this.eachfn.call(
                        this,
                        function (e, i) {
                            e.value = i;
                        },
                        e
                    ),
                    this
                );
            },
            show: function () {
                return (
                    this.eachfn.call(this, function (e) {
                        e.style.display = "block";
                    }),
                    this
                );
            },
            hide: function () {
                return (
                    this.eachfn.call(this, function (e) {
                        e.style.display = "none";
                    }),
                    this
                );
            },
            offset: function () {
                var e = this.eachfn.call(this, function (e) {
                    if (!(e && ((e.x && e.y) || (null !== !e.parentNode && "none" !== ZC.A5(e).getstyle("display"))))) return undefined;
                    var i,
                        t,
                        n,
                        a,
                        l,
                        o,
                        r,
                        s = { top: 0, left: 0 },
                        A = { top: 0, left: 0 },
                        C = e && e.ownerDocument;
                    return (
                        C &&
                            ((t = C.body) === e && (s = { top: t.offsetTop, left: t.offsetLeft }),
                            (i = C.documentElement),
                            "undefined" != typeof e.getBoundingClientRect && (A = e.getBoundingClientRect()),
                            (n = C.defaultView || C.parentWindow),
                            (a = i.clientTop || t.clientTop || 0),
                            (l = i.clientLeft || t.clientLeft || 0),
                            (o = n.pageYOffset || i.scrollTop),
                            (r = n.pageXOffset || i.scrollLeft),
                            (s = { top: A.top + o - a, left: A.left + r - l })),
                        s
                    );
                });
                return 1 === e.length ? e[0] : e;
            },
            bind: function (e, i, t) {
                if ("" !== (e = ZC.A5.cleanTouchEvents(e))) {
                    if ((t || (t = !ZC.hasPassive || { passive: !0 }), -1 !== e.indexOf(" "))) {
                        for (var n = e.split(/\s+/), a = 0; a < n.length; a++) this.bind(n[a], i, t);
                        return this;
                    }
                    return (
                        this.eachfn.call(
                            this,
                            function (e, i, n) {
                                function a(e) {
                                    var i = (e = e || window.event).target || e.srcElement,
                                        t = ZC.A5.C1(e);
                                    null !== t && n.call(i, t);
                                }
                                ZC.A5.IY || (ZC.A5.IY = []), ZC.A5.IY.push([e, i, n, a]), e.addEventListener ? e.addEventListener(i, a, t) : e.attachEvent("on" + i, a);
                            },
                            e,
                            i
                        ),
                        this
                    );
                }
            },
            unbind: function (e, i) {
                if ("" !== (e = ZC.A5.cleanTouchEvents(e))) {
                    if (-1 !== e.indexOf(" ")) {
                        for (var t = e.split(/\s+/), n = 0; n < t.length; n++) this.unbind(t[n], i);
                        return this;
                    }
                    return (
                        this.eachfn.call(
                            this,
                            function (e, i, t) {
                                if ("undefined" != typeof ZC.A5.IY)
                                    for (var n = 0, a = ZC.A5.IY.length; n < a; n++)
                                        if ((ZC.A5.IY[n][0] === e || (e.tagName && "MAP" === e.tagName.toUpperCase() && e.id === ZC.A5.IY[n][0].id)) && ZC.A5.IY[n][1] === i && ZC.A5.IY[n][2] === t) {
                                            e.removeEventListener ? e.removeEventListener(i, ZC.A5.IY[n][3], !0) : e.detachEvent("on" + i, ZC.A5.IY[n][3]), ZC.A5.IY.splice(n, 1);
                                            break;
                                        }
                            },
                            e,
                            i
                        ),
                        this
                    );
                }
            },
            live: function (e, i, t) {
                if ("" !== (e = ZC.A5.cleanTouchEvents(e))) {
                    if ((t || (t = !ZC.hasPassive || { passive: !0 }), (-1 === e.indexOf("touch") && -1 === e.indexOf("wheel")) || (t = { passive: !1 }), -1 !== e.indexOf(" "))) {
                        for (var n = e.split(/\s+/), a = 0; a < n.length; a++) this.live(n[a], i, t);
                        return this;
                    }
                    var l = this.QC;
                    return (
                        ZC.A5.EVENTS || (ZC.A5.EVENTS = {}), ZC.A5.EVENTS[e] || ((ZC.A5.EVENTS[e] = []), document.addEventListener ? document.addEventListener(e, o, t) : document.attachEvent("on" + e, o)), ZC.A5.EVENTS[e].push([l, i]), this
                    );
                }
                function o(i) {
                    var t = (i = i || window.event).target || i.srcElement,
                        n = t.className || "";
                    "object" == typeof n && (n = "undefined" != typeof n.baseVal && null !== ZC._n_(n.baseVal) ? n.baseVal : "");
                    var l,
                        o,
                        r = ZC.A5.EVENTS[e],
                        s = null,
                        A = null,
                        C = [];
                    for (l = 0, o = r.length; l < o; l++)
                        (("object" == typeof r[l][0] && t === r[a][0]) ||
                            ("string" == typeof r[l][0] && (("." === r[l][0].substring(0, 1) && -1 !== ZC.AV(n.split(" "), r[l][0].replace(".", ""))) || ("#" === r[l][0].substring(0, 1) && t.id === r[l][0].substring(1))))) &&
                            ((s = r[l][1]), (A = ZC.A5.C1(i)), null !== ZC._n_(s) && null !== ZC._n_(A) && C.push([s, t, A]));
                    for (l = 0, o = C.length; l < o; l++) C[l][0].call(C[l][1], C[l][2]);
                }
            },
            die: function (e, i) {
                if ("" !== (e = ZC.A5.cleanTouchEvents(e))) {
                    var t, n, a;
                    if (-1 !== e.indexOf(" ")) {
                        for (n = 0, a = (t = e.split(/\s+/)).length; n < a; n++) this.die(t[n], i);
                        return this;
                    }
                    var l = this.QC;
                    if ((ZC.A5.EVENTS || (ZC.A5.EVENTS = {}), (t = ZC.A5.EVENTS[e]))) for (n = t.length - 1; n >= 0; n--) t[n][0] !== l || (i && t[n][1] !== i) || ZC.A5.EVENTS[e].splice(n, 1);
                    return this;
                }
            },
        }),
        (ZC.A5._list_ = function (e) {
            for (var i = [], t = 0; t < ZC.A5.EVENTS[e].length; t++) i.push(ZC.A5.EVENTS[e][t][0]);
            return i.join(",");
        }),
        (ZC.A5.cleanTouchEvents = function (e) {
            return ZC.ie678 && (e = ZC.GW(e.replace(/touchstart|touchend|touchmove/, ""))), e;
        }),
        (ZC.A5.cache = {}),
        (ZC.A5.browser = {}),
        (function () {
            var e = /(webkit)[ \/]([\w.]+)/,
                i = /(opera)(?:.*version)?[ \/]([\w.]+)/,
                t = /(msie) ([\w.]+)/,
                n = /(mozilla)(?:.*? rv:([\w.]+))?/,
                a = /(trident)(?:.*? rv:([\w.]+))?/,
                l = (function (l) {
                    l = l.toLowerCase();
                    var o = e.exec(l) || i.exec(l) || t.exec(l) || a.exec(l) || (l.indexOf("compatible") < 0 && n.exec(l)) || [];
                    return [o[1] || "", o[2] || "0"];
                })(navigator.userAgent);
            l[0] && ("trident" === l[0] && (l[0] = "msie"), (ZC.A5.browser[l[0]] = !0), (ZC.A5.browser.version = l[1]));
        })(),
        (ZC.A5.scroll = function () {
            var e = { top: 0, left: 0 },
                i = document,
                t = i.documentElement,
                n = i.body;
            return t && (t.scrollTop || t.scrollLeft) ? ((e.left = t.scrollLeft), (e.top = t.scrollTop)) : n && ((e.left = n.scrollLeft), (e.top = n.scrollTop)), e;
        }),
        (ZC.A5.C1 = function (e) {
            if (
                ((e.originalEventZC = e), e.target || (e.target = e.srcElement || document), (3 !== e.target.nodeType && 8 !== e.target.nodeType) || (e.target = e.target.parentNode), null === ZC._n_(e.pageX) && null !== ZC._n_(e.clientX))
            ) {
                var i = e.target.ownerDocument || document,
                    t = i.documentElement,
                    n = i.body;
                (e.pageX = e.clientX + ((t && t.scrollLeft) || (n && n.scrollLeft) || 0) - ((t && t.clientLeft) || (n && n.clientLeft) || 0)),
                    (e.pageY = e.clientY + ((t && t.scrollTop) || (n && n.scrollTop) || 0) - ((t && t.clientTop) || (n && n.clientTop) || 0));
            }
            return (
                e.which || e.button === undefined || (e.which = 1 & e.button ? 1 : 2 & e.button ? 3 : 4 & e.button ? 2 : 0),
                e.preventDefault ||
                    (e.preventDefault = function () {
                        this.returnValue = !1;
                    }),
                e.stopPropagation ||
                    (e.stopPropagation = function () {
                        this.cancelBubble = !0;
                    }),
                e
            );
        }),
        (ZC.A5.childof = function (e, i) {
            if (e === i) return !0;
            for (; e !== i && e.parentNode; ) if ((e = e.parentNode) === i) return !0;
            return !1;
        }),
        (ZC.A5.ajax = function (e) {
            var i = e.url || "",
                t = e.type || "GET",
                n = e.data || "",
                a = !0;
            "undefined" != typeof e.async && (a = ZC._b_(e.async)), "" === n.replace(/\&/g, "") && (n = "");
            var l = e.beforeSend || null,
                o = e.error || null,
                r = e.success || null,
                s = null;
            try {
                window.ActiveXObject ? (s = new ActiveXObject("Microsoft.XMLHTTP")) : window.XMLHttpRequest && (s = new XMLHttpRequest());
            } catch (C) {}
            var A = "file:" === window.location.protocol;
            if (s) {
                a &&
                    (s.onreadystatechange = function () {
                        4 === s.readyState &&
                            ((A || (s.status >= 200 && s.status < 300)) && r && r(s.responseText, s.status, s, i), s.status >= 400 && o && o(s, s.status, s.statusText, i), (s.onreadystatechange = new window.Function()), (s = null));
                    }),
                    window.ActiveXObject ||
                        (s.onerror = function () {
                            o && o(s, 0, "", i);
                        }),
                    "POST" === t.toUpperCase()
                        ? (s.open("POST", i, a), s.setRequestHeader("X-Requested-With", "XMLHttpRequest"), s.setRequestHeader("Content-type", "application/x-www-form-urlencoded"))
                        : ("" !== n && (-1 === i.indexOf("?") && (i += "?"), (i += "&" + n)), s.open("GET", i, a)),
                    l && l(s);
                try {
                    s.send(n), a || ((A || (s.status >= 200 && s.status < 300)) && r && r(s.responseText, s.status, s, i), s.status >= 400 && o && o(s, s.status, s.statusText, i), (s = null));
                } catch (c) {
                    A && o && (o(s, s.status, s.statusText, i), (s.onreadystatechange = new window.Function()), (s = null));
                }
            }
        }),
        (ZC.AQ = {
            ACI: function (e, i) {
                var t,
                    n,
                    a = zingchart.DEV.SPREADFACTOR,
                    l = [],
                    o = 0;
                function r(e, i) {
                    -1 === ZC.AV(e, i) && e.push(i);
                }
                for (t = 0; t < e.length; t++) e[t] += i;
                var s = -1;
                for (t = 1; t < e.length; t++)
                    ZC._a_(e[t] - e[t - 1]) < a
                        ? ((l[o] = l[o] || { min: -1, max: -1, items: [] }), -1 === l[o].min && ((l[o].min = t > 1 ? e[t - 2] : i), -1 === s && (s = l[o].min), l[o].min), r(l[o].items, t - 1), r(l[o].items, t))
                        : l[o] && ((l[o].max = e[t]), l[o].max, o++);
                l[o] && -1 === l[o].max && (l[o].max = 360 + i);
                var A = l.length;
                if (A > 1 && l[A - 1].max - l[0].min == 360) {
                    for (n = 0; n < l[0].items.length; n++) e[l[0].items[n]] += 360;
                    (l[A - 1].items = l[A - 1].items.concat(l[0].items)), (l[A - 1].max += l[0].min), (l = l.splice(1));
                }
                for (l.length > 1 && (l[l.length - 1].max = l[0].min + 360), t = 0; t < l.length; t++) {
                    var C = l[t],
                        c = C.items.length,
                        u = (C.max - C.min) / (c + 4);
                    u = ZC.CY(u, a);
                    var p = 0;
                    for (n = 0; n < C.items.length; n++) p += e[C.items[n]];
                    p /= C.items.length;
                    for (var Z = !0; Z; )
                        for (Z = !1, n = 1; n < C.items.length; n++)
                            if (e[C.items[n]] - e[C.items[n - 1]] < u) {
                                e[C.items[n - 1]] < p ? ((e[C.items[n - 1]] -= 0.45), (e[C.items[n]] += 0.05)) : (e[C.items[n]] += 0.25), (Z = !0);
                                break;
                            }
                }
                return e;
            },
            _int_: function (e) {
                return Math.abs(e - ZC._i_(e)) < Math.pow(10, -10);
            },
            XQ: function (e, i, t) {
                return (t = t || 1), !(e.x > i.x + i.width + t) && !(i.x > e.x + e.width + t) && !(e.y > i.y + i.height + t) && !(i.y > e.y + e.height + t);
            },
            _boxoverlap2_: function (e, i, t) {
                return (t = t || 1), !(e.iX > i.iX + i.I + t) && !(i.iX > e.iX + e.I + t) && !(e.iY > i.iY + i.F + t) && !(i.iY > e.iY + e.F + t);
            },
            AG6: function (e, i) {
                return e.iX >= i.iX && e.iX <= i.iX + i.I && e.iY >= i.iY && e.iY <= i.iY + i.F && e.iX + e.I >= i.iX && e.iX + e.I <= i.iX + i.I && e.iY + e.F >= i.iY && e.iY + e.F <= i.iY + i.F;
            },
            A6C: function (e, i, t) {
                for (var n = Math.sqrt(e / Math.PI), a = Math.sqrt(i / Math.PI), l = Math.min(n, a), o = Math.max(n, a), r = ZC.MAX, s = 0, A = l + o; A > o - l; A -= l / 50) {
                    var C = l * l * Math.acos((A * A + l * l - o * o) / (2 * A * l)) + o * o * Math.acos((A * A + o * o - l * l) / (2 * A * o)) - 0.5 * Math.sqrt((-A + l + o) * (A + l - o) * (A - l + o) * (A + l + o));
                    Math.abs(C - t) < r && ((r = Math.abs(C - t)), (s = A));
                }
                return s;
            },
            BN: function (e, i, t, n) {
                return [e + t * Math.cos((2 * n * Math.PI) / 360), i + t * Math.sin((2 * n * Math.PI) / 360)];
            },
            A5F: function (e, i, t, n, a) {
                var l = ZC.TN(Math.atan((n - i) / (t - e)));
                return [e + ZC._i_(ZC.EH(l) * a), i + ZC._i_(ZC.EP(l) * a)];
            },
            JW: function (e, i, t, n, a, l) {
                if (((a = null === ZC._n_(a) ? 0 : a), (l = null === ZC._n_(l) || l), t - e != 0)) {
                    var o = 0,
                        r = 0,
                        s = Math.atan((n - i) / (t - e));
                    return (a < 1 || l) && ((o = (a / 2.5) * Math.cos(s)), (r = (a / 2.5) * Math.sin(s))), [(e + t) / 2 + (e < t ? o : -o), (i + n) / 2 + r];
                }
                return [e, (i + n) / 2];
            },
            A3O: function (e, i) {
                var t = (e[1] - i[1]) / (e[0] - i[0]);
                return [t, e[1] - t * e[0]];
            },
            A4H: function (e, i, t, n) {
                var a, l, o, r, s, A, C, c;
                return i[0] === n[0] && i[1] === n[1]
                    ? i
                    : e[0] === t[0] && e[1] === t[1]
                    ? e
                    : (e[0] === i[0] && t[0] === n[0]
                          ? e[0] === t[0]
                              ? ((C = e[0]), (c = (e[1] + i[1] + t[1] + n[1]) / 4))
                              : ((C = NaN), (c = NaN))
                          : e[0] === i[0]
                          ? ((s = (r = ZC.AQ.A3O(t, n))[0]), (A = r[1]), (c = s * (C = e[0]) + A))
                          : t[0] === n[0]
                          ? ((l = (a = ZC.AQ.A3O(t, n))[0]), (o = a[1]), (c = l * (C = t[0]) + o))
                          : ((l = (a = ZC.AQ.A3O(e, i))[0]), (o = a[1]), (s = (r = ZC.AQ.A3O(t, n))[0]), (c = l * (C = ((A = r[1]) - o) / (l - s)) + o)),
                      [C, c]);
            },
            PS: function (e, i, t) {
                null === ZC._n_(i) && (i = 5);
                var n = 0,
                    a = 0;
                null !== ZC._n_(t) && ((n = t[0]), (a = t[1]));
                for (var l, o, r, s = "", A = ZC.ie67 ? ZC.MAPTX : 0, C = 0, c = e.length; C < c; C++)
                    e[C] &&
                        (0 === C
                            ? ((o = e[C][0] + A + n), (r = e[C][1] + A + a), (l = C), (s += Math.round(o, 10) + "," + Math.round(r, 10) + ","))
                            : Math.sqrt((e[C][0] + A - o) * (e[C][0] + A - o) + (e[C][1] + A - r) * (e[C][1] + A - r)) > i &&
                              e[C - 1] &&
                              (Math.sqrt((e[C][0] - e[C - 1][0]) * (e[C][0] - e[C - 1][0]) + (e[C][1] - e[C - 1][1]) * (e[C][1] - e[C - 1][1])) > i &&
                                  C - l > 1 &&
                                  (s += Math.round(e[C - 1][0] + A + n, 10) + "," + Math.round(e[C - 1][1] + A + a, 10) + ","),
                              (o = e[C][0] + A + n),
                              (r = e[C][1] + A + a),
                              (l = C),
                              (s += Math.round(o, 10) + "," + Math.round(r, 10) + ",")));
                return (s = s.substring(0, s.length - 1));
            },
            YT: function (e, i) {
                if (null === ZC._n_(e) || e.length < 2) return "";
                null === ZC._n_(i) && ((i = 6), ZC.mobile && (i += 10));
                var t,
                    n,
                    a,
                    l,
                    o,
                    r = [];
                for (t = 0, n = e.length; t < n; t++) (0 === t || (t > 0 && null !== ZC._n_(e[t]) && null !== ZC._n_(e[t - 1]) && e[t].join("/") !== e[t - 1].join("/")) || null === ZC._n_(e[t])) && r.push(e[t]);
                var s = [],
                    A = [],
                    C = !1;
                for (t = 0, n = r.length; t < n; t++)
                    if (r[t]) {
                        var c,
                            u,
                            p,
                            Z,
                            h = r[t][0],
                            d = r[t][1];
                        if ((r[t - 1] && ((p = r[t - 1][0]), (Z = r[t - 1][1]), p === h && (p -= 0.1)), r[t + 1] && ((c = r[t + 1][0]), (u = r[t + 1][1]), c === h && (c += 0.1)), 0 === t))
                            (a = Math.atan((u - d) / (c - h))), (o = l = ZC.TN(a)), c >= h && (o += 180), s.push(ZC.AQ.BN(h, d, i, l + 90), ZC.AQ.BN(h, d, i, o), ZC.AQ.BN(h, d, i, l + 270));
                        else if (t === r.length - 1)
                            (a = Math.atan((Z - d) / (p - h))),
                                (o = l = ZC.TN(a)),
                                p >= h && (o += 180),
                                C ? (A.push(ZC.AQ.BN(h, d, i, l + 270), ZC.AQ.BN(h, d, i, o), ZC.AQ.BN(h, d, i, l + 90)), (C = !1)) : s.push(ZC.AQ.BN(h, d, i, l + 270), ZC.AQ.BN(h, d, i, o), ZC.AQ.BN(h, d, i, l + 90));
                        else {
                            var f = Math.atan((u - d) / (c - h)),
                                _ = Math.atan((d - Z) / (h - p));
                            (o = ZC.TN((f + _) / 2)),
                                s.push(ZC.AQ.BN(h, d, i, o + 270)),
                                c >= h && p >= h
                                    ? (s.push(ZC.AQ.BN(h, d, i, o + 180)), s.push(ZC.AQ.BN(h, d, i, o + 90)), A.push(ZC.AQ.BN(h, d, i, o)), (C = !0))
                                    : c <= h && p <= h
                                    ? (s.push(ZC.AQ.BN(h, d, i, o)), s.push(ZC.AQ.BN(h, d, i, o + 90)), A.push(ZC.AQ.BN(h, d, i, o + 180)), (C = !0))
                                    : A.push(ZC.AQ.BN(h, d, i, o + 90));
                        }
                    }
                for (t = A.length - 1; t >= 0; t--) s.push(A[t]);
                return s;
            },
            A23: function (e, i) {
                var t = 0,
                    n = 0,
                    a = [];
                switch ((e += "")) {
                    case "horizontal":
                    case "h":
                        (t = 1), (n = i);
                        break;
                    case "vertical":
                    case "v":
                        (t = i), (n = 1);
                        break;
                    default:
                        (a = e.split("x")),
                            null !== ZC._n_(a[0]) && ZC._i_(a[0]) + "" === a[0] && (t = ZC._i_(a[0])),
                            null !== ZC._n_(a[1]) && ZC._i_(a[1]) + "" === a[1] && (n = ZC._i_(a[1])),
                            0 === n && 0 === t ? ((t = Math.ceil(Math.sqrt(i))), (n = Math.ceil(i / t))) : (0 === n && (n = Math.ceil(i / t)), 0 === t && (t = Math.ceil(i / n)));
                }
                return [t, n];
            },
            AB4: function (e, i) {
                return 0.5 * (2 * i[1] + (-i[0] + i[2]) * e + (2 * i[0] - 5 * i[1] + 4 * i[2] - i[3]) * e * e + (-i[0] + 3 * i[1] - 3 * i[2] + i[3]) * e * e * e);
            },
            AB7: function (e, i) {
                var t,
                    n,
                    a,
                    l,
                    o,
                    r = e.length,
                    s = [],
                    A = [],
                    C = [];
                for (t = 0; t < r - 1; t++) (n = e[t + 1] - e[t]), (a = i[t + 1] - i[t]), A.push(n), s.push(a), C.push(a / n);
                var c = [C[0]];
                for (t = 0; t < A.length - 1; t++) {
                    l = C[t];
                    var u = C[t + 1];
                    if (l * u <= 0) c.push(0);
                    else {
                        n = A[t];
                        var p = A[t + 1];
                        (o = n + p), c.push((3 * o) / ((o + p) / l + (o + n) / u));
                    }
                }
                c.push(C[C.length - 1]);
                var Z = [],
                    h = [];
                for (t = 0; t < c.length - 1; t++) {
                    l = C[t];
                    var d = c[t],
                        f = 1 / A[t];
                    (o = d + c[t + 1] - l - l), Z.push((l - d - o) * f), h.push(o * f * f);
                }
                return function (t) {
                    var n = e.length - 1;
                    if (t === e[n]) return i[n];
                    for (var a, l = 0, o = h.length - 1; l <= o; ) {
                        a = Math.floor(0.5 * (l + o));
                        var r = e[a];
                        if (r < t) l = a + 1;
                        else {
                            if (!(r > t)) return i[a];
                            o = a - 1;
                        }
                    }
                    n = Math.max(0, o);
                    var s = t - e[n],
                        A = s * s;
                    return i[n] + c[n] * s + Z[n] * A + h[n] * s * A;
                };
            },
            Y9: function (e, i, t, n) {
                null === ZC._n_(n) && (n = 1 / ((t / i.length) * 4));
                var a,
                    l,
                    o = [];
                if (e)
                    if ((a = [].concat(i))[1] && a[2]) {
                        (a[0] = a[0] || a[1] || a[2] || a[3]), (a[1] = a[1] || a[2] || a[0] || a[3]), (a[2] = a[2] || a[3] || a[1] || a[0]), (a[3] = a[3] || a[2] || a[1] || a[0]);
                        var r = ZC.AQ.AB7([0, 1, 2, 3], a);
                        for (l = 1; l <= 2; l += n) o.push([l - 1, r(l)]);
                    } else o.push([]);
                else
                    for (var s = 1; s < i.length - 2; s++)
                        if (1 !== n)
                            if ((a = [i[s - 1], i[s], i[s + 1], i[s + 2]])[1] && a[2])
                                for (a[0] = a[0] || a[1] || a[2] || a[3], a[1] = a[1] || a[2] || a[0] || a[3], a[2] = a[2] || a[3] || a[1] || a[0], a[3] = a[3] || a[2] || a[1] || a[0], l = 0; l <= 1; l += n) {
                                    var A = s + l,
                                        C = ZC.AQ.AB4(l, a);
                                    o.push([A - 1, C]);
                                }
                            else o.push([]);
                        else o.push([s - 1, i[s]]);
                return o;
            },
            A0G: function (e) {
                for (var i = Math.round(ZC.FV(ZC._a_(e)) / Math.LN10), t = [1, 2, 4, 5, 6, 8, 10], n = ZC.MAX, a = 1, l = 0; l < t.length; l++) {
                    var o = t[l] * Math.pow(10, i) - e;
                    ZC._a_(o) < n && ((a = t[l]), (n = ZC._a_(o)));
                }
                return a * Math.pow(10, i);
            },
            _nice_number_: function (e, i) {
                var t, n;
                return (t = Math.floor(Math.log(e) / Math.log(10))), (n = e / Math.pow(10, t)), (i ? (n < 1.5 ? 1 : n < 3 ? 2 : n < 7 ? 5 : 10) : n <= 1 ? 1 : n <= 2 ? 2 : n <= 5 ? 5 : 10) * Math.pow(10, t);
            },
            VS: function (e, i, t, n, a, l) {
                var o, r, s, A, C, c;
                null === ZC._n_(a) && (a = !0), (l = null === ZC._n_(l) ? 10 : Math.min(Math.max(2, l), 100)), (null !== ZC._n_(n) && 0 !== n) || (n = 1);
                var u = Math.floor(ZC.FV(ZC._a_(i)) / Math.LN10);
                e === i && (i += Math.pow(10, u)),
                    (o = e),
                    (r = i),
                    (A = ZC.AQ._nice_number_(r - o, !1)),
                    null === ZC._n_(t) ? ((s = A / (l - 1)), (s = ZC.AQ._nice_number_(s, !0)), (s *= n)) : (s = t),
                    a ? ((C = Math.floor(o / s) * s), (c = Math.ceil(r / s) * s)) : ((C = o), (c = r), (s = null === ZC._n_(t) ? A / (l - 1) : t));
                var p = Math.floor(ZC.FV(ZC._a_(s)) / Math.LN10),
                    Z = p < 0 ? ZC._a_(p) : 0;
                if (0 === Z) {
                    var h = ("" + s).split(".");
                    2 === h.length && (Z = h[1].length);
                }
                return [C, c, s, Z, s];
            },
        }),
        (ZC.XR = {
            md5: function (e) {
                return ZC.XR.ACT(ZC.XR.ACU(ZC.XR.ACQ(e)));
            },
            ACU: function (e) {
                return ZC.XR.AC6(ZC.XR.ACV(ZC.XR.ACD(e), 8 * e.length));
            },
            ACT: function (e) {
                for (var i, t = "", n = 0, a = e.length; n < a; n++) (i = e.charCodeAt(n)), (t += "0123456789abcdef".charAt((i >>> 4) & 15) + "0123456789abcdef".charAt(15 & i));
                return t;
            },
            ACQ: function (e) {
                for (var i, t, n = "", a = -1, l = e.length; ++a < l; )
                    (i = e.charCodeAt(a)),
                        (t = a + 1 < l ? e.charCodeAt(a + 1) : 0),
                        55296 <= i && i <= 56319 && 56320 <= t && t <= 57343 && ((i = 65536 + ((1023 & i) << 10) + (1023 & t)), a++),
                        i <= 127
                            ? (n += String.fromCharCode(i))
                            : i <= 2047
                            ? (n += String.fromCharCode(192 | ((i >>> 6) & 31), 128 | (63 & i)))
                            : i <= 65535
                            ? (n += String.fromCharCode(224 | ((i >>> 12) & 15), 128 | ((i >>> 6) & 63), 128 | (63 & i)))
                            : i <= 2097151 && (n += String.fromCharCode(240 | ((i >>> 18) & 7), 128 | ((i >>> 12) & 63), 128 | ((i >>> 6) & 63), 128 | (63 & i)));
                return n;
            },
            ACD: function (e) {
                var i,
                    t = Array(e.length >> 2);
                for (i = 0; i < t.length; i++) t[i] = 0;
                for (i = 0; i < 8 * e.length; i += 8) t[i >> 5] |= (255 & e.charCodeAt(i / 8)) << i % 32;
                return t;
            },
            AC6: function (e) {
                for (var i = "", t = 0; t < 32 * e.length; t += 8) i += String.fromCharCode((e[t >> 5] >>> t % 32) & 255);
                return i;
            },
            ACV: function (e, i) {
                function t(e, i, t, n, a, l) {
                    return r(((o = r(r(i, e), r(n, l))) << (s = a)) | (o >>> (32 - s)), t);
                    var o, s;
                }
                function n(e, i, n, a, l, o, r) {
                    return t((i & n) | (~i & a), e, i, l, o, r);
                }
                function a(e, i, n, a, l, o, r) {
                    return t((i & a) | (n & ~a), e, i, l, o, r);
                }
                function l(e, i, n, a, l, o, r) {
                    return t(i ^ n ^ a, e, i, l, o, r);
                }
                function o(e, i, n, a, l, o, r) {
                    return t(n ^ (i | ~a), e, i, l, o, r);
                }
                function r(e, i) {
                    var t = (65535 & e) + (65535 & i);
                    return (((e >> 16) + (i >> 16) + (t >> 16)) << 16) | (65535 & t);
                }
                (e[i >> 5] |= 128 << i % 32), (e[14 + (((i + 64) >>> 9) << 4)] = i);
                for (var s = 1732584193, A = -271733879, C = -1732584194, c = 271733878, u = 0, p = e.length; u < p; u += 16) {
                    var Z = s,
                        h = A,
                        d = C,
                        f = c;
                    (A = o(
                        (A = o(
                            (A = o(
                                (A = o(
                                    (A = l(
                                        (A = l(
                                            (A = l(
                                                (A = l(
                                                    (A = a(
                                                        (A = a(
                                                            (A = a(
                                                                (A = a(
                                                                    (A = n(
                                                                        (A = n(
                                                                            (A = n(
                                                                                (A = n(
                                                                                    A,
                                                                                    (C = n(C, (c = n(c, (s = n(s, A, C, c, e[u], 7, -680876936)), A, C, e[u + 1], 12, -389564586)), s, A, e[u + 2], 17, 606105819)),
                                                                                    c,
                                                                                    s,
                                                                                    e[u + 3],
                                                                                    22,
                                                                                    -1044525330
                                                                                )),
                                                                                (C = n(C, (c = n(c, (s = n(s, A, C, c, e[u + 4], 7, -176418897)), A, C, e[u + 5], 12, 1200080426)), s, A, e[u + 6], 17, -1473231341)),
                                                                                c,
                                                                                s,
                                                                                e[u + 7],
                                                                                22,
                                                                                -45705983
                                                                            )),
                                                                            (C = n(C, (c = n(c, (s = n(s, A, C, c, e[u + 8], 7, 1770035416)), A, C, e[u + 9], 12, -1958414417)), s, A, e[u + 10], 17, -42063)),
                                                                            c,
                                                                            s,
                                                                            e[u + 11],
                                                                            22,
                                                                            -1990404162
                                                                        )),
                                                                        (C = n(C, (c = n(c, (s = n(s, A, C, c, e[u + 12], 7, 1804603682)), A, C, e[u + 13], 12, -40341101)), s, A, e[u + 14], 17, -1502002290)),
                                                                        c,
                                                                        s,
                                                                        e[u + 15],
                                                                        22,
                                                                        1236535329
                                                                    )),
                                                                    (C = a(C, (c = a(c, (s = a(s, A, C, c, e[u + 1], 5, -165796510)), A, C, e[u + 6], 9, -1069501632)), s, A, e[u + 11], 14, 643717713)),
                                                                    c,
                                                                    s,
                                                                    e[u],
                                                                    20,
                                                                    -373897302
                                                                )),
                                                                (C = a(C, (c = a(c, (s = a(s, A, C, c, e[u + 5], 5, -701558691)), A, C, e[u + 10], 9, 38016083)), s, A, e[u + 15], 14, -660478335)),
                                                                c,
                                                                s,
                                                                e[u + 4],
                                                                20,
                                                                -405537848
                                                            )),
                                                            (C = a(C, (c = a(c, (s = a(s, A, C, c, e[u + 9], 5, 568446438)), A, C, e[u + 14], 9, -1019803690)), s, A, e[u + 3], 14, -187363961)),
                                                            c,
                                                            s,
                                                            e[u + 8],
                                                            20,
                                                            1163531501
                                                        )),
                                                        (C = a(C, (c = a(c, (s = a(s, A, C, c, e[u + 13], 5, -1444681467)), A, C, e[u + 2], 9, -51403784)), s, A, e[u + 7], 14, 1735328473)),
                                                        c,
                                                        s,
                                                        e[u + 12],
                                                        20,
                                                        -1926607734
                                                    )),
                                                    (C = l(C, (c = l(c, (s = l(s, A, C, c, e[u + 5], 4, -378558)), A, C, e[u + 8], 11, -2022574463)), s, A, e[u + 11], 16, 1839030562)),
                                                    c,
                                                    s,
                                                    e[u + 14],
                                                    23,
                                                    -35309556
                                                )),
                                                (C = l(C, (c = l(c, (s = l(s, A, C, c, e[u + 1], 4, -1530992060)), A, C, e[u + 4], 11, 1272893353)), s, A, e[u + 7], 16, -155497632)),
                                                c,
                                                s,
                                                e[u + 10],
                                                23,
                                                -1094730640
                                            )),
                                            (C = l(C, (c = l(c, (s = l(s, A, C, c, e[u + 13], 4, 681279174)), A, C, e[u], 11, -358537222)), s, A, e[u + 3], 16, -722521979)),
                                            c,
                                            s,
                                            e[u + 6],
                                            23,
                                            76029189
                                        )),
                                        (C = l(C, (c = l(c, (s = l(s, A, C, c, e[u + 9], 4, -640364487)), A, C, e[u + 12], 11, -421815835)), s, A, e[u + 15], 16, 530742520)),
                                        c,
                                        s,
                                        e[u + 2],
                                        23,
                                        -995338651
                                    )),
                                    (C = o(C, (c = o(c, (s = o(s, A, C, c, e[u], 6, -198630844)), A, C, e[u + 7], 10, 1126891415)), s, A, e[u + 14], 15, -1416354905)),
                                    c,
                                    s,
                                    e[u + 5],
                                    21,
                                    -57434055
                                )),
                                (C = o(C, (c = o(c, (s = o(s, A, C, c, e[u + 12], 6, 1700485571)), A, C, e[u + 3], 10, -1894986606)), s, A, e[u + 10], 15, -1051523)),
                                c,
                                s,
                                e[u + 1],
                                21,
                                -2054922799
                            )),
                            (C = o(C, (c = o(c, (s = o(s, A, C, c, e[u + 8], 6, 1873313359)), A, C, e[u + 15], 10, -30611744)), s, A, e[u + 6], 15, -1560198380)),
                            c,
                            s,
                            e[u + 13],
                            21,
                            1309151649
                        )),
                        (C = o(C, (c = o(c, (s = o(s, A, C, c, e[u + 4], 6, -145523070)), A, C, e[u + 11], 10, -1120210379)), s, A, e[u + 2], 15, 718787259)),
                        c,
                        s,
                        e[u + 9],
                        21,
                        -343485551
                    )),
                        (s = r(s, Z)),
                        (A = r(A, h)),
                        (C = r(C, d)),
                        (c = r(c, f));
                }
                return Array(s, A, C, c);
            },
        }),
        "undefined" == typeof zingchart && (zingchart = { ADG: !0 }),
        (zingchart.clipart = {}),
        (zingchart.widgets = {}),
        (zingchart.plugins = {}),
        (zingchart.pool = {}),
        (zingchart.pool.size = 0),
        (zingchart.pool.data = {}),
        (zingchart.pool.getInstance = function (e, i, t, n) {
            var a;
            if (null !== ZC._n_(zingchart.pool.data[t])) ((a = zingchart.pool.data[t])._POOL_ = !0), (ZC.SKIPOBJCOUNT = !0), n || (a.$i(i), (a.L = t)), (ZC.SKIPOBJCOUNT = !1);
            else {
                switch (e) {
                    case "DN":
                        a = new ZC.DN(i);
                        break;
                    case "HN":
                        a = new ZC.HN(i);
                        break;
                    case "DU":
                        a = new ZC.DU(i);
                        break;
                    case "P0":
                        a = new ZC.P0(i);
                        break;
                    case "D0":
                        a = new ZC.D0(i);
                }
                (a.L = t), zingchart.pool.size++, zingchart.pool.size > zingchart.DEV.MAXPOOLSIZE ? ((zingchart.pool.data = {}), (zingchart.pool.size = 0)) : (zingchart.pool.data[t] = a);
            }
            return a;
        }),
        (zingchart.i18n = {}),
        (zingchart.THEMES = {}),
        (zingchart.V3D = 2),
        (zingchart.QUOTEDVALUES = !1),
        (zingchart.EDITSOURCE = 1),
        (zingchart.MODULESDEP = {
            line: "xy",
            line3d: "3d,line",
            area: "xy",
            area3d: "3d,area",
            vline: "yx",
            varea: "yx",
            vbar: "xy",
            vbar3d: "3d,vbar",
            hbar: "yx",
            hbar3d: "3d,hbar",
            scatter: "xy",
            bubble: "xy",
            hscatter: "yx",
            hbubble: "yx",
            pie: "r",
            pie3d: "3d,pie",
            nestedpie: "r",
            gauge: "r",
            vbullet: "vbar",
            hbullet: "hbar",
            vfunnel: "xy",
            hfunnel: "yx",
            piano: "xy",
            radar: "r",
            range: "xy",
            vrange: "yx",
            stock: "xy,vbar",
            venn: "r",
        }),
        (zingchart.SKIP = { EVENT: !1, ANIMATION: !1, LEGEND: !1, CSV: !1, PARSE3D: !1 }),
        (zingchart.MODULESDIR = (function (e) {
            for (var i = 0; i < e.length; i++) {
                if (e[i].src) if (e[i].src.indexOf("zingchart.min.js") > -1) return e[i].src.split("zingchart.min.js")[0] + "modules/";
            }
            return "./modules/";
        })(document.getElementsByTagName("head")[0].childNodes)),
        (zingchart.DEV = {
            DOMFRAGMENTS: 1,
            SORTTOKENS: 1,
            PLOTSTATS: 1,
            RESOURCES: 1,
            KEEPSOURCE: 1,
            SPREADTYPE: 0,
            SPREADFACTOR: 10,
            IGNORESUBUNIT: 0,
            DELAYEDTRACKERS: 0,
            STACKINGLOGIC: -1,
            SMARTDATELABELS: 0,
            GC: 1,
            CACHECANVASTEXT: 0,
            CHECKDECIMALS: 0,
            CACHESELECTION: 0,
            MEDIARULES: 1,
            SKIPTRACKERS: 0,
            PLOTSHLAYER: 0,
            RESIZESPEED: 250,
            DEBOUNCESPEED: 250,
            LOCALSVGEXPORT: 1,
            SKIPPROGRESS: 0,
            SKIPCONTEXTMENU: 0,
            COPYDATA: 1,
            GUIDETIMEOUT: 0,
            LOOKUPCSSTRANSFORM: 0,
            MAPSONBOTTOM: 0,
            MAXPOOLSIZE: 1024,
            MINTRACKERDIFF: 1.5,
        }),
        (zingchart.CANVASTEXT = 0),
        (zingchart.ZINDEX = 1),
        (zingchart.CMZINDEX = 9999),
        (zingchart.FSZINDEX = 9998),
        (zingchart.FSID = null),
        (zingchart.ZCOUTPUT = 0),
        (zingchart.ASYNC = 0),
        (zingchart.SORTTRACKERS = 0),
        (zingchart.TIMEOUT = 0),
        (zingchart.USERCSS = {}),
        (zingchart.OBJECTMODE = "normal"),
        (zingchart.SYNTAX = "mixed"),
        (zingchart.THEME = null),
        (zingchart.EXPORTURL = ("file:" === document.location.protocol ? "http:" : document.location.protocol) + "//export.zingchart.com/"),
        (zingchart.AJAXEXPORT = !1),
        (zingchart.TOUCHZOOM = "normal"),
        (zingchart.DEFAULT = { height: 480, width: 640 }),
        (zingchart.FASTWIDTH = 0),
        (zingchart.FONTSIZE = 11),
        (zingchart.FONTFAMILY = "Lucida Sans Unicode,Lucida Grande,Lucida Sans,Helvetica,Arial,sans-serif"),
        ZC.mobile && (zingchart.FONTFAMILY = "Lucida Sans,Helvetica,Arial,sans-serif"),
        (zingchart.loadModules = function (e, i) {
            for (var t = ("" + e).split(","), n = 0, a = t.length; n < a; n++) {
                var l = ZC.GW(t[n]);
                (l = ZC.ALIAS[l] || l), -1 !== ZC.AV(["bar", "bar3d", "funnel", "bullet"], l) && (l = "v" + l);
                var o = zingchart.MODULESDEP[l];
                null !== ZC._n_(o) && zingchart.loadModules(o), -1 === ZC.AV(ZC.RO, l) && ZC.RO.push(l);
            }
            i && zingchart.A1I(null, ZC.RO, i);
        }),
        (zingchart.A1I = function (e, i, t) {
            var n = 0;
            if (0 === i.length) t();
            else {
                if (!document.getElementsByTagName("head")[0]) return void t();
                !(function a() {
                    var l,
                        o = !0;
                    function r() {
                        ++n === i.length ? t() : a();
                    }
                    zingchart.ACL(i[n]) ? (l = zingchart.MODULESDIR + "zingchart-" + i[n] + ".min.js") : (o = !1), o ? ZC.AP.ACC(e, l, r) : r();
                })();
            }
        }),
        (zingchart.ACL = function (e) {
            return -1 !== ZC.AV(ZC.RO, e) && -1 === ZC.AV(ZC.WG, e);
        }),
        (zingchart.LI = []),
        ZC.ie67 ||
            (function () {
                for (var e in ZC.IMAGES) ZC.IMAGES.hasOwnProperty(e) && ((zingchart.LI[e] = new Image()), (zingchart.LI[e].src = ZC.IMAGES[e]));
            })(),
        "undefined" != typeof Ext && ((zingchart.LI["zc.blank"] = new Image()), (zingchart.LI["zc.blank"].src = ZC.BLANK)),
        (zingchart.exec = function (e, i, t) {
            return zingchart.exec_flash ? zingchart.exec_flash(e, i, t) : null;
        }),
        (zingchart.AD4 = function (N) {
            var QK = N.dataurl || "",
                EV = "",
                G,
                MB = null;
            null !== ZC._n_((G = N.data)) && ("string" == typeof G ? (EV = G) : (MB = JSON.parse(JSON.stringify(G))));
            var DL = null;
            if ("" !== QK)
                ZC.A5.ajax({
                    type: "GET",
                    url: QK,
                    async: !1,
                    data: zingchart.ZCOUTPUT ? "zcoutput=userdef" : "",
                    error: function () {
                        return !1;
                    },
                    success: function (KG) {
                        function _f_(e) {
                            (ZC.cache.data["data-" + QK] = KG), (N.output = "auto"), ZC._cp_(e.render, N);
                        }
                        try {
                            (DL = JSON.parse(KG)), _f_(DL);
                        } catch (JA) {
                            try {
                                (DL = eval("(" + KG + ")")), _f_(DL);
                            } catch (JA) {
                                return !1;
                            }
                        }
                    },
                });
            else {
                if ("" !== EV)
                    try {
                        DL = JSON.parse(EV);
                    } catch (JA) {
                        return !1;
                    }
                else null !== MB && (DL = MB);
                null === ZC._n_(N.output) && (N.output = "auto"), ZC._cp_(DL.render, N);
            }
            return zingchart.render(N);
        }),
        (zingchart.A04 = null),
        (zingchart.params = {}),
        (zingchart.render = function (e, i) {
            if ((null === ZC._n_(i) && (i = !1), i)) return zingchart.AD4(e);
            null === ZC._n_(ZC.canvas) && ZC.compat();
            var t = e.output || "auto";
            "html5" === t && (t = "auto"), ZC.mobile && "auto" === t && (t = "svg");
            var n = !1;
            if (
                ("!" === t.substring(0, 1) && ((n = !0), (t = t.substring(1))),
                n ||
                    (("auto" === t || ("canvas" === t && !ZC.canvas) || ("svg" === t && !ZC.svg) || ("vml" === t && !ZC.vml) || ("flash" === t && !ZC.flash)) &&
                        (ZC.svg ? (t = "svg") : ZC.canvas ? (t = "canvas") : ZC.vml ? (t = "vml") : ZC.flash && (t = "flash"))),
                "vml" === t && null === ZC._n_(zingchart.A04) && (zingchart.A04 = !1),
                "flash" !== t)
            )
                return zingchart.A93(e, t);
            zingchart.render_flash(e);
        }),
        document.attachEvent &&
            ("complete" === document.readyState
                ? (zingchart.A04 = !0)
                : document.attachEvent("onreadystatechange", function () {
                      "complete" === document.readyState && (zingchart.A04 = !0);
                  })),
        (zingchart.setlabel = zingchart.setLabel = function (e, i) {
            ZC.HJ[e] = i;
        }),
        (zingchart.HZ = []),
        (zingchart.Y1 = {}),
        (zingchart.ADF = 0),
        (zingchart.AD1 = 0),
        (zingchart.ADD = !1),
        (zingchart.AA9 = !1),
        (zingchart.AAA = !1),
        (zingchart.ACX = !1),
        (zingchart.css = null),
        (zingchart.WX = function (e) {
            if (e.target.id) {
                for (var i = null, t = 0, n = zingchart.HZ.length; t < n; t++) e.target.id.substr(0, zingchart.HZ[t].L.length + 1) === zingchart.HZ[t].L + "-" && (i = zingchart.HZ[t]);
                return i;
            }
        }),
        (ZC.GESTURE = { id: null, on: !1, ts: null, type: null, dist: -1, mp: [-1, -1] }),
        "undefined" == typeof zingchart.MK &&
            ((zingchart.MK = function (e) {
                if (e.target && e.target.tagName && "INPUT" !== e.target.tagName.toUpperCase() && "TEXTAREA" !== e.target.tagName.toUpperCase()) {
                    var i;
                    if ("pinch" === zingchart.TOUCHZOOM)
                        switch (((ZC.TOUCHEVENTS = !1), e.type)) {
                            case "touchstart":
                                for (var t = !1, n = 0; n < zingchart.HZ.length; n++)
                                    (i = ZC.A5("#" + zingchart.HZ[n].L + "-top")),
                                        ZC.DT(e.touches[0].pageX, i.offset().left, i.offset().left + i.width()) && ZC.DT(e.touches[0].pageY, i.offset().top, i.offset().top + i.height()) && ((t = !0), (ZC.GESTURE.id = zingchart.HZ[n].L));
                                t && (ZC.GESTURE.on = !0);
                                break;
                            case "touchmove":
                                if (ZC.GESTURE.on && 2 === e.touches.length) {
                                    e.preventDefault();
                                    var a = (e.touches[0].clientX - e.touches[1].clientX) * (e.touches[0].clientX - e.touches[1].clientX) + (e.touches[0].clientY - e.touches[1].clientY) * (e.touches[0].clientY - e.touches[1].clientY);
                                    a = Math.round(Math.sqrt(a));
                                    var l = [Math.round((e.touches[0].clientX + e.touches[1].clientX) / 2), Math.round((e.touches[0].clientY + e.touches[1].clientY) / 2)];
                                    if (-1 === ZC.GESTURE.dist) (ZC.GESTURE.dist = a), (ZC.GESTURE.mp = l), (ZC.GESTURE.ts = new Date().getTime());
                                    else if (new Date().getTime() - ZC.GESTURE.ts > 100) {
                                        if (a > ZC.GESTURE.dist + 50) (ZC.GESTURE.type = "pinch-in"), zingchart.exec(ZC.GESTURE.id, "zoomin");
                                        else if (a < ZC.GESTURE.dist - 50) (ZC.GESTURE.type = "pinch-out"), zingchart.exec(ZC.GESTURE.id, "zoomout");
                                        else {
                                            ZC.GESTURE.type = "panning";
                                            var o = {};
                                            l[0] > ZC.GESTURE.mp[0] + 10 ? ((o["x-"] = !0), (o.xdist = ZC._a_(ZC.GESTURE.mp[0] - l[0]))) : l[0] < ZC.GESTURE.mp[0] - 10 && ((o["x+"] = !0), (o.xdist = ZC._a_(ZC.GESTURE.mp[0] - l[0]))),
                                                l[1] > ZC.GESTURE.mp[1] + 10 ? ((o["y+"] = !0), (o.ydist = ZC._a_(ZC.GESTURE.mp[1] - l[1]))) : l[1] < ZC.GESTURE.mp[1] - 10 && ((o["y-"] = !0), (o.ydist = ZC._a_(ZC.GESTURE.mp[1] - l[1]))),
                                                (ZC.GESTURE.mp = l),
                                                zingchart.exec(ZC.GESTURE.id, "pan", o);
                                        }
                                        ZC.GESTURE.ts = new Date().getTime();
                                    }
                                }
                                break;
                            case "touchend":
                                (ZC.GESTURE.id = null), (ZC.GESTURE.on = !1), (ZC.GESTURE.type = null), (ZC.GESTURE.ts = null), (ZC.GESTURE.dist = -1), (ZC.GESTURE.mp = [-1, -1]);
                        }
                    if (window.ZC) {
                        window.ZC.E1 = [e.pageX, e.pageY];
                        var r = zingchart.WX(e);
                        if (r) {
                            if (!zingchart.SKIP.EVENT) {
                                if (("mousedown" === e.type && (window.ZC.aMDXY = [e.pageX, e.pageY]), "touchstart" === e.type && r.AG)) for (var s = 0; s < r.AG.length; s++) r.AG[s].LE();
                                if (-1 !== ZC.AV(["mouseover", "mouseout", "mouseover"], e.type) && "IMG" !== e.target.tagName.toUpperCase()) return;
                                if ("mouseout" === e.type && ((i = ZC.A5("#" + r.L + "-top")), ZC.DT(e.pageX, i.offset().left, i.offset().left + i.width(), !0) && ZC.DT(e.pageY, i.offset().top, i.offset().top + i.height(), !0))) return;
                                ZC.AP.C0(e.type, r, zingchart.A0C(e, r));
                            }
                            zingchart.SKIP.EVENT = !1;
                        }
                    }
                }
            }),
            ZC.A5(document).bind(ZC.Q.C1("mouseover"), zingchart.MK).bind(ZC.Q.C1("mouseout"), zingchart.MK).bind(ZC.Q.C1("mousemove"), zingchart.MK).bind(ZC.Q.C1("mousedown"), zingchart.MK).bind(ZC.Q.C1("mouseup"), zingchart.MK)),
        (zingchart.A0C = function (e, i) {
            var t = ZC.Q.MD(e),
                n = i.A4C(t[0], t[1]),
                a = ZC.A5("#" + i.L + "-top"),
                l = Math.round(t[0] - a.offset().left),
                o = Math.round(t[1] - a.offset().top),
                r = "none";
            return (
                /(.*)\-scale\_(.*)\-item\_title\-area(.*)/.test(e.target.id) && (r = "scale-title"),
                /(.*)\-scale\_(.*)\-item\_(\d+)\-area(.*)/.test(e.target.id) && (r = "scale-item"),
                /(.*)\-plotset\-plot\-(\d+)\-node\-(\d+)(.*)/.test(e.target.id) && (r = "node"),
                /(.*)\-legend\-item\_(\d+)\-area/.test(e.target.id) && (r = "legend-item"),
                /(.*)\-legend\-marker\_(\d+)\-area/.test(e.target.id) && (r = "legend-marker"),
                /(.*)\-legend\-(.+)\-area/.test(e.target.id) && (r = "legend-element"),
                /(.*)\-menu\-item\-(.*)/.test(e.target.id) && (r = "menu-item"),
                /(.*)\-preview\-handler\-x(.*)/.test(e.target.id) && (r = "preview"),
                /(.*)\-shape\-(.*?)\-area/.test(e.target.id) && (r = "shape"),
                /(.*)\-label\-(.*?)\-area/.test(e.target.id) && (r = "label"),
                { id: i.L, ev: ZC.A5.C1(e), targetid: e.target.id, graphid: n ? n.L : null, target: r, x: l, y: o, plotarea: !!n && l >= n.P.iX && l <= n.P.iX + n.P.I && o >= n.P.iY && o <= n.P.iY + n.P.F, touch: ZC.mobile }
            );
        }),
        "undefined" == typeof zingchart.S9 &&
            ((zingchart.S9 = function (e) {
                for (var i = 0, t = zingchart.HZ.length; i < t; i++) zingchart.HZ[i].hideCM();
                if (ZC.mobile && ZC.move) ZC.move = !1;
                else if (ZC.mobile || !(e.which > 1)) {
                    var n = zingchart.WX(e);
                    if (n) {
                        if ("click" === e.type && ZC.aMDXY && (ZC._a_(ZC.aMDXY[0] - e.pageX) > 2 || ZC._a_(ZC.aMDXY[1] - e.pageY) > 2)) return;
                        if (!zingchart.SKIP.EVENT) {
                            var a = zingchart.A0C(e, n);
                            (a.target = zingchart.plugins.CLICK_TARGET || a.target),
                                (zingchart.plugins.CLICK_TARGET = null),
                                ZC.mobile && "touchend" === e.type && (n.D["click-ts"] && new Date().getTime() - n.D["click-ts"] < 500 && ZC.AP.C0("dblclick", n, a), (n.D["click-ts"] = new Date().getTime())),
                                ZC.AP.C0("dblclick" === e.type ? "dblclick" : "click", n, a);
                        }
                        (zingchart.SKIP.EVENT = !1), e.target.id !== n.L + "-menu-area" ? n.hideCM() : zingchart.YP(e);
                    }
                }
            }),
            ZC.mobile
                ? (ZC.A5(document).bind("touchmove", function () {
                      ZC.move = !0;
                  }),
                  ZC.A5(document).bind("touchend", function () {
                      ZC.move = !1;
                  }))
                : (ZC.A5(document).bind("click", zingchart.S9), ZC.A5(document).bind("dblclick", zingchart.S9))),
        "undefined" == typeof zingchart.A33 &&
            ((zingchart.A33 = function (e) {
                e.touches.length > 0 && (ZC.TOUCHEVENTS = !0);
            }),
            ZC.A5(document).bind("touchstart", zingchart.A33)),
        "undefined" == typeof zingchart.YP &&
            ((zingchart.YP = function (e, i, t) {
                if (
                    !(
                        e &&
                        e.target &&
                        e.target.tagName &&
                        "IMG" !== e.target.tagName.toUpperCase() &&
                        "AREA" !== e.target.tagName.toUpperCase() &&
                        -1 === ZC.Q.T4(e.target).indexOf("zc-scroll") &&
                        -1 === e.target.id.indexOf("-legend-") &&
                        -1 === e.target.id.indexOf("-preview-")
                    ) ||
                    zingchart.DEV.SKIPTRACKERS
                ) {
                    var n, a, l, o, r, s;
                    t = t || {};
                    var A = null === ZC._n_(i) ? zingchart.WX(e) : zingchart.getLoader(i);
                    if (A) {
                        if (-1 !== ZC.AV(A.KP, "skip_context_menu")) return !1;
                        if ((null === ZC._n_(i) ? ((a = ZC.Q.MD(e)), (n = A.A4C(a[0], a[1]))) : (n = null !== ZC._n_(t.graphid) ? A.OS(t.graphid) : A.AG[0]), !n)) return !1;
                        var C = ZC.A5("#" + A.L + "-top");
                        null === ZC._n_(i) ? ((l = a[0] - C.offset().left), (o = a[1] - C.offset().top)) : ((l = A.I / 2), (o = A.F / 2));
                        var c = {};
                        e && (c = zingchart.A0C(e, A));
                        var u = ZC.AP.C0("contextmenu", A, c, !0);
                        if (!u && void 0 !== u && ((!e && !t["from-api"]) || (e && e.target.id !== A.L + "-menu-area"))) return e.preventDefault(), !1;
                        var p = ZC._tx_(A.L);
                        A.A5U(n ? n.K : -1, e);
                        var Z = -1;
                        if (0 !== zingchart.CMZINDEX) Z = zingchart.CMZINDEX;
                        else for (var h = ZC.AL(A.L); -1 === Z && null !== h.parentNode; ) ("auto" !== (Z = ZC._i_(ZC.A5(h).css("zIndex"))) && "" !== Z && null !== ZC._n_(Z)) || (Z = -1), (h = h.parentNode);
                        (Z && -1 !== Z && null !== ZC._n_(Z)) || (Z = 1);
                        var d = ZC.A5("#" + A.L + "-menu");
                        if ((d.css("zIndex", zingchart.ZINDEX + Z + 1), null === ZC._n_(i))) {
                            if (e.target.id === A.L + "-print-png" || e.target.id === A.L + "-print-jpeg") return !0;
                            e.preventDefault();
                        }
                        if (!ZC.AL(A.L + "-menu")) return !1;
                        (l = C.offset().left), (o = C.offset().top);
                        var f = C.width(),
                            _ = C.height();
                        null === ZC._n_(i) ? ((r = (a = ZC.Q.MD(e))[0] || ZC.E1[0]), (s = a[1] || ZC.E1[1])) : ((r = l + A.I / 2), (s = o + 5));
                        var g = !1;
                        if (
                            (A.VK("goback", !1),
                            A.NR > 0 && (A.VK("goback", !0), (g = !0)),
                            A.VK("goforward", !1),
                            A.NR < A.QU.length - 1 && (A.VK("goforward", !0), (g = !0)),
                            A.VK("history", g, !0),
                            r >= l && r <= l + f * p[0] && s >= o && s <= o + _ * p[1])
                        ) {
                            ZC.A5(".zc-menu").each(function () {
                                this.id !== A.L + "-menu" && A.hideCM();
                            }),
                                (A.SQ = [r, s, null === ZC._n_(i) ? e.target.id : i]),
                                d.css("opacity", 0).show();
                            var v,
                                b,
                                B = ZC._i_(d.css("width")) + ZC._i_(d.css("paddingLeft")) + ZC._i_(d.css("paddingRight")),
                                m = ZC._i_(d.css("height")) + ZC._i_(d.css("paddingTop")) + ZC._i_(d.css("paddingBottom")),
                                D = 1,
                                E = !1;
                            if (
                                (A.o.gui && A.o.gui["context-menu"] && A.o.gui["context-menu"] && ((D = A.o.gui["context-menu"].alpha ? A.o.gui["context-menu"].alpha : 1), (E = A.o.gui["context-menu"].docked)),
                                d.css("opacity", D).hide(),
                                "classic" !== A.LJ && E)
                            ) {
                                if (E) {
                                    var L = A.B8.NS[A.LJ].root.gui["context-menu"];
                                    ZC._cp_(A.o.gui["context-menu"], L), (v = "left" !== A.o.gui["context-menu"].position && ZC._n_(A.o.gui["context-menu"].position) ? C.offset().left + C.width() - B : C.offset().left);
                                }
                                (b = C.offset().top),
                                    d
                                        .css("left", ZC.BQ(1, v) + "px")
                                        .css("top", ZC.BQ(1, b) + "px")
                                        .css("height", C.height() + "px")
                                        .css("box-sizing", "border-box")
                                        .show(),
                                    (d = ZC.A5("#" + A.L + "-menu")),
                                    E && d.P1[0].scrollHeight > C.height() && d.css("overflow-y", "scroll");
                            } else {
                                if (null === ZC._n_(i) && e.target.id === A.L + "-menu-area") {
                                    ZC.AL(A.L + "-menu").style.paddingTop = 0;
                                    var F = ZC.A5("#" + A.L + "-menu-area")
                                            .attr("coords")
                                            .split(","),
                                        I = ZC._i_(F[3]) - ZC._i_(F[1]);
                                    (ZC.AL(A.L + "-menu").style.backgroundPosition = ZC._i_(F[0]) > A.I / 2 ? "100% 0% !important" : "0% 0% !important"),
                                        (v = l + (ZC._i_(F[0]) > A.I / 2 ? ZC._i_(F[2]) - B : ZC._i_(F[0]))),
                                        (b = o + (ZC._i_(F[1]) > A.F / 1.25 ? ZC._i_(F[3]) - m - I : ZC._i_(F[3])));
                                } else
                                    (ZC.AL(A.L + "-menu").style.backgroundPosition = "50% 0% !important"),
                                        (v = A.SQ[0] - B / 2),
                                        (b = A.SQ[1]),
                                        m > A.F * p[1] ? (b = o) : b - o + m > A.F * p[1] && (b = ZC.BQ(b - m, A.F * p[1] - m)),
                                        v < l && (v = ZC.BQ(v, l)),
                                        v + B > l + A.I * p[0] && (v = ZC.CY(l + A.I * p[0] - B / 2, v - B / 2));
                                if (t.position)
                                    switch (t.position) {
                                        case "top":
                                            break;
                                        case "top-left":
                                            v = v - (A.I * p[0] - B) / 2 + 5;
                                            break;
                                        case "top-right":
                                            v = v + (A.I * p[0] - B) / 2 - 5;
                                            break;
                                        case "bottom":
                                            b = b + (A.F * p[1] - m) - 10;
                                            break;
                                        case "bottom-left":
                                            (b = b + (A.F * p[1] - m) - 10), (v = v - (A.I * p[0] - B) / 2 + 5);
                                            break;
                                        case "bottom-right":
                                            (b = b + (A.F * p[1] - m) - 10), (v = v + (A.I * p[0] - B) / 2 - 5);
                                            break;
                                        case "left":
                                            (b = b + (A.F * p[1] - m) / 2 - 5), (v = v - (A.I * p[0] - B) / 2 + 5);
                                            break;
                                        case "right":
                                            (b = b + (A.F * p[1] - m) / 2 - 5), (v = v + (A.I * p[1] - B) / 2 - 5);
                                    }
                                else null !== ZC._n_(t.x) && null !== ZC._n_(t.y) && ((v = l + ZC._i_(t.x)), (b = o + ZC._i_(t.y)));
                                if (
                                    (d
                                        .css("left", ZC.BQ(1, v) + "px")
                                        .css("top", ZC.BQ(1, b) + "px")
                                        .show(),
                                    ZC.ie67)
                                ) {
                                    var x = ZC.A5("#" + A.L + "-menu div").width()[0] || 120;
                                    d.css("width", x + "px");
                                }
                            }
                            return (A.AAB = !0), !1;
                        }
                    }
                }
            }),
            ZC.A5(document).bind("contextmenu", zingchart.YP)),
        (zingchart.AAJ = function (e, i) {
            if (zingchart.css) return zingchart.css.addRule ? zingchart.css.addRule(e, i) : zingchart.css.insertRule(e + "{" + i + "}", 0);
        }),
        (zingchart.wh = function (e, i, t) {
            "auto" === i && (i = "100%"), "auto" === t && (t = "100%");
            var n = [0, 0];
            return (
                (-1 === ("" + i).indexOf("%") && -1 === ("" + t).indexOf("%")) || (n = e.wh()),
                [-1 !== ("" + i).indexOf("%") ? (n[0] * parseInt(i, 10)) / 100 : parseInt(i, 10), -1 !== ("" + t).indexOf("%") ? (n[1] * parseInt(t, 10)) / 100 : parseInt(t, 10)]
            );
        }),
        (zingchart.IY = {}),
        (zingchart.bind = function (e, i, t) {
            (e = e || "zingchart-global"), zingchart.IY[e] || (zingchart.IY[e] = {}), zingchart.IY[e][i] ? zingchart.IY[e][i].push({ fn: t }) : (zingchart.IY[e][i] = [{ fn: t }]);
        }),
        (zingchart.unbind = function (e, i, t) {
            if (((e = e || "zingchart-global"), zingchart.IY[e] && zingchart.IY[e][i]))
                if (t) {
                    for (var n = 0, a = zingchart.IY[e][i].length; n < a; n++)
                        if (zingchart.IY[e][i][n].fn === t) {
                            zingchart.IY[e][i].splice(n, 1);
                            break;
                        }
                } else zingchart.IY[e][i] = null;
        }),
        (zingchart.callEvent = function (e, i, t, n) {
            if (((e = e || "zingchart-global"), zingchart.IY[e] && zingchart.IY[e][i])) {
                for (var a = 0, l = zingchart.IY[e][i].length; a < l; a++) null !== ZC._n_(n) ? (t[t.length - 1] = zingchart.IY[e][i][a].fn.apply(zingchart, t)) : zingchart.IY[e][i][a].fn.apply(zingchart, t);
                if (null !== ZC._n_(n)) return t[t.length - 1];
            }
        }),
        (zingchart.hasEvent = function (e, i) {
            return (e = e || "zingchart-global"), zingchart.IY[e] && zingchart.IY[e][i];
        }),
        (zingchart.A93 = function (e, i) {
            ZC._todash_(e, !1);
            var t,
                n,
                a,
                l,
                o,
                r,
                s,
                A,
                C = [];
            if ((null !== ZC._n_((t = e.flags)) && (C = t.split(",")), null !== ZC._n_((t = e.mode))))
                switch (t) {
                    case "static":
                        C = ["skip_context_menu", "skip_segment_tracking", "skip_marker_tracking", "skip_interactivity", "use_single_canvas"];
                }
            var c = "";
            if ((null !== ZC._n_((t = e.container)) && (c = t), null !== ZC._n_((t = e.id)) && (c = t), ZC.AL(c))) {
                var u = null;
                for (a = 0; a < zingchart.HZ.length; a++) zingchart.HZ[a].L === c && (u = zingchart.HZ[a].MF);
                if (null !== ZC._n_(u)) {
                    if ("" !== u) return;
                    zingchart.exec(c, "destroy");
                }
                (zingchart.params[c] = {}), ZC._cp_(e, zingchart.params[c]);
                var p = !1,
                    Z = null;
                for (a = 0; a < zingchart.HZ.length; a++) zingchart.HZ[a].L === c && ((zingchart.HZ[a] = new ZC.Q1()), (Z = zingchart.HZ[a]), (p = !0));
                if ((p || (((Z = new ZC.Q1()).MF = "init"), zingchart.HZ.push(Z)), (Z.L = c), (zingchart.Y1[c] = !0), "vml" !== i || zingchart.A04 || zingchart.A93(e, i), !zingchart.AAA)) {
                    zingchart.AAA = !0;
                    var h = 
                    {
                        ".zc-style": "font-family:" + zingchart.FONTFAMILY + ";font-size:" + zingchart.FONTSIZE + "px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",
                        ".zc-style *": "font-family:" + zingchart.FONTFAMILY + ";font-size:" + zingchart.FONTSIZE + "px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",
                        ".zc-top *": "text-align:left;margin:auto;text-shadow:none;",
                        ".zc-menu *": "text-align:left;margin:auto;",
                        ".zc-main text": "-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;",
                        ".zc-img": "-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",
                        ".zc-map": "-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",
                        ".zc-pixmap": "-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",
                        ".zc-preview-mask": "cursor:default;-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",
                        ".zc-about": "position:absolute;overflow:hidden;border:5px solid #fff;background:#003C4F url(" + (ZC.ie67 ? "//" : ZC.LOGO_ABOUT) + ") no-repeat center 10px",
                        ".zc-about-1": "padding:80px 5px 5px 5px;text-align:center !important;",
                        ".zc-about-1 a": "color:#1AB6E3;font-size:17px;line-height:125%;",
                        ".zc-about-2": "padding:5px;color:#fff;text-align:center !important;",
                        ".zc-about-3": "padding:5px;text-align:center;line-height:125%;",
                        ".zc-about-3 div": "background-color:#1AB6E3;line-height:125%;color:#fff;border:1px solid #fff;padding:5px 10px;font-weight:bold;width:60px;margin:0 auto;cursor:pointer;text-align:center",
                        ".zc-about-4": "color:#fff;line-height:125%;",
                        ".zc-about-4 div": "float:right;color:#fff;line-height:125%;",
                        ".zc-viewsource": "border:5px solid #fff;background:#999",
                        ".zc-error": "border:5px solid #fff;background:#900",
                        ".zc-bugreport": "border:5px solid #fff;background:#999",
                        ".zc-form-row-label": "padding:4px 10px 2px;text-align:left;color:#fff",
                        ".zc-form-row-element": "padding:2px 8px",
                        ".zc-form-row-last": "padding:8px 8px 2px !important",
                        ".zc-form-row-element textarea": "text-align:left;background:#fff;color:#000;border:1px solid #333;",
                        ".zc-form-row-label input": "color:#000;padding:2px;margin:0 5px 0 0;background-color:#999;",
                        ".zc-form-row-element input": "color:#000;padding:2px;margin:0;background-color:#fff",
                        ".zc-form-row-last input": "padding:4px 10px !important;margin:0 20px 0 0 !important;background-color:#eee !important;border:2px outset #ccc !important",
                        ".zc-form-s0": "font-size:27px !important;letter-spacing:-1px;line-height:125%",
                        ".zc-form-s1": "font-size:17px !important;line-height:125%",
                        ".zc-form-s1 a": "color:#fff;padding:3px 10px;position:relative;top:4px;border:1px solid #333;border-bottom:0px solid #333",
                        ".zc-tab-active": "background-color:#fff;color:#333 !important",
                        ".zc-tab-inactive": "background-color:#999;color:#ddd !important",
                        ".zc-bugreport label": "display:inline-block;position:relative;top:-2px",
                        ".zc-viewimage div": "position:absolute;text-align:center;padding:5px;background:#999;color:#fff",
                        ".zc-license-ie67": "padding:0;position:absolute;font-size:12px;font-weight:bold;font-family:" + zingchart.FONTFAMILY + ";color:#369;text-align:left",
                        ".zc-license": "padding:0;position:absolute;",
                        "#zc-fullscreen": "display:block;position:absolute;top:0;left:0;width:100%;height:100%;margin:0;padding:0;background:#fff;",
                        ".zc-menu": "position:absolute;display:none;background-repeat:no-repeat !important;background-position:50% 0% !important;",
                        ".zc-menu-sep": "font-size:1px;padding:0;line-height:1px;border-bottom:1px solid #000",
                        ".zc-menu-item": "cursor:pointer;white-space:nowrap",
                        ".zc-blocker": "background:#eee",
                        ".zc-blocker div.zc-blocker-msg": "position:absolute;border:2px solid #ccc;padding:10px 30px;background-color:#333;color:#fff",
                        ".zc-modal": "background-color:#fff;color:#000;border:2px solid #999",
                        ".zc-guide-label-table": "border-collapse:collapse",
                        ".zc-guide-label-table td": "padding:4px 10px 2px 2px",
                        ".zc-data-table": "border-collapse:collapse",
                        ".zc-data-table caption": "font-family:" + zingchart.FONTFAMILY + ";text-align:left;font-size:17px;font-weight:600;padding:6px 14px 6px 4px;background-color:#ccc;border-bottom:2px solid #666",
                        ".zc-data-table th": "font-family:" + zingchart.FONTFAMILY + ";text-align:left;font-size:13px;font-weight:600;padding:2px 14px 2px 4px;background-color:#ddd;border-bottom:1px solid #666",
                        ".zc-data-table td": "font-family:" + zingchart.FONTFAMILY + ";text-align:left;font-size:11px;padding:1px 14px 1px 4px;background-color:#ffffff;border-bottom:1px solid #eee;white-space:nowrap",
                        ".zc-rel": "top:0;left:0;position:relative",
                        ".zc-abs": "top:0;left:0;position:absolute",
                    };
                    ZC.ie678 || ((h[".zc-data-table th:not(:last-child)"] = "border-right:1px dotted #666"), (h[".zc-data-table td:not(:last-child)"] = "border-right:1px solid #eee"));
                    var d = document.getElementsByTagName("head")[0],
                        f = document.createElement("style");
                    if (((f.type = "text/css"), f.setAttribute("data-author", "zingchart"), d.appendChild(f), !zingchart.css))
                        for (a = 0, l = document.styleSheets.length; a < l; a++)
                            document.styleSheets[a].ownerNode && "zingchart" === document.styleSheets[a].ownerNode.getAttribute("data-author") && (zingchart.css = document.styleSheets[a]);
                    for (var _ in (zingchart.css || (zingchart.css = document.styleSheets[document.styleSheets.length - 1]), h)) null !== ZC._n_(zingchart.USERCSS[_]) ? zingchart.AAJ(_, zingchart.USERCSS[_]) : zingchart.AAJ(_, h[_]);
                }
                if ("vml" === i && !zingchart.AA9) document.namespaces.add("zcv", "urn:schemas-microsoft-com:vml"), (document.createStyleSheet().cssText = ".zcvml { behavior:url(#default#VML); }"), (zingchart.AA9 = !0);
                var g = "";
                zingchart.THEME && (g = zingchart.THEME), e.data && null !== ZC._n_((t = e.data.theme)) && (g = t), null !== ZC._n_((t = e.theme)) && (g = t);
                var v = { data: !1, defaults: !1, css: !1, csv: !1 };
                if (null !== ZC._n_((t = e.cache))) for (var b in v) null !== ZC._n_((n = t[b])) && (v[b] = ZC._b_(n));
                var B = !1;
                null !== ZC._n_((t = e.fullscreen)) && (B = ZC._b_(t));
                var m = !0;
                null !== ZC._n_((t = e["auto-resize"])) && (m = ZC._b_(t));
                var D = ZC.A5("#" + c);
                (o = (e.width || "100%") + ""), (r = (e.height || "" + zingchart.DEFAULT.height) + ""), "auto" === o && (o = "100%"), "auto" === r && (r = "100%");
                var E = zingchart.wh(D, o, r);
                (s = E[0]),
                    (A = E[1]),
                    B && ((s = ZC.A5(window).width()), (A = ZC.A5(window).height())),
                    s < 10 && (s = zingchart.DEFAULT.width),
                    A < 10 && (A = zingchart.DEFAULT.height),
                    (s = 0 === s ? zingchart.DEFAULT.width : s),
                    (A = 0 === A ? zingchart.DEFAULT.height : A);
                var L = e.dataurl || "",
                    F = e.defaultsurl || "",
                    I = null,
                    x = "",
                    y = null;
                null !== ZC._n_((t = e.data)) && ("string" == typeof t ? (x = t) : (y = zingchart.DEV.COPYDATA ? JSON.parse(JSON.stringify(t)) : t)),
                    null !== ZC._n_((t = e.defaults)) && ("string" == typeof t && (t = JSON.parse(t)), (I = t)),
                    null !== ZC._n_((t = e.imggen)) && (Z.A17 = ZC._b_(t)),
                    Z.A17 && (Z.G2 = null),
                    (Z.JL = o + "/" + r),
                    (Z.AC = i),
                    (Z.A = Z),
                    (Z.iX = 0),
                    (Z.iY = 0),
                    (Z.I = s),
                    (Z.F = A),
                    (Z.G1 = o),
                    (Z.MT = r),
                    (Z.QK = L),
                    (Z.EV = x),
                    (Z.MB = y),
                    (Z.QJ = F),
                    (Z.MN = I),
                    (Z.UC = !1),
                    null !== ZC._n_(e.fullscreenmode) && ZC._b_(e.fullscreenmode) && (Z.QL = !0),
                    (Z.LT = B),
                    (Z.RY = v),
                    (Z.KP = C),
                    (Z.LJ = g),
                    (Z.H = Z),
                    (Z.D.hideprogresslogo = !1),
                    null !== ZC._n_((t = e.hideprogresslogo)) && (Z.D.hideprogresslogo = ZC._b_(t)),
                    null !== ZC._n_((t = e.customprogresslogo)) && (Z.D.customprogresslogo = t),
                    null !== ZC._n_((t = e.customprogresstext)) && (Z.D.customprogresstext = t),
                    null !== ZC._n_((t = e.exportdataurl)) && (Z.D.exportdataurl = t),
                    null !== ZC._n_((t = e.exportimageurl)) && (Z.D.exportimageurl = t);
                var w = {};
                for (var Y in (null !== ZC._n_((t = e.bgcolor)) && (w["background-color"] = t),
                null !== ZC._n_((t = e["background-color"])) && (w["background-color"] = t),
                null !== ZC._n_((t = e["border-color"])) && (w["border-color"] = t),
                null !== ZC._n_((t = e["border-width"])) && (w["border-width"] = t),
                null !== ZC._n_((t = e.color)) && (w.color = t),
                (Z.D.progress = w),
                null !== ZC._n_((t = e["auto-load-modules"])) && (Z.A6N = ZC._b_(t)),
                null !== ZC._n_((t = e.events)) && (Z.A16 = t),
                null !== ZC._n_((t = e.modules)) && (Z.A1O = t),
                null !== ZC._n_((t = e.format)) && (Z.CJ = t),
                null !== ZC._n_((t = e.csvdata)) && (Z.NQ = t),
                null !== ZC._n_((t = e.locale)) && null !== ZC._n_(zingchart.i18n[t]) && ((Z.A18 = t), (ZC.HJ = zingchart.i18n[t])),
                null !== ZC._n_((t = e["cache-control"])) && (Z.N6 = t),
                null !== ZC._n_((t = e.accessibility)) && (Z.bA11y = ZC._b_(t)),
                null !== ZC._n_((t = e.description)) && (Z.OZ = t + ""),
                zingchart.params))
                    if (!zingchart.Y1[Y]) for (var X in (delete zingchart.params[Y], delete ZC.TS[Y], zingchart.pool.data)) 0 === X.indexOf(Y + "-") && (delete zingchart.pool.data[X], zingchart.pool.size--);
                if ((Z.render(), D.css("overflow", "hidden"), Z.LT && D.css("position", "absolute").css("top", 0).css("left", 0), (-1 !== Z.G1.indexOf("%") || -1 !== Z.MT.indexOf("%") || Z.LT || Z.QL) && m)) {
                    var M = Z.QL || Z.LT ? ZC.A5(window) : D,
                        K = M.width(),
                        S = M.height(),
                        P = 0;
                    (Z.A0D = !1),
                        (Z.YX = window.setInterval(function () {
                            var e;
                            if (ZC.AL(c) && !Z.A2Q) {
                                var i = ZC.A5("#" + c + "-top"),
                                    t = !1;
                                if ((-1 !== ("" + Z.G1).indexOf("%") && i.length && M.length && i.width() !== M.width() && (t = !0), 0 !== P || (M.width() === K && M.height() === S && !t))) {
                                    if (M.width() + M.height() > 0 && (M.width() !== K || M.height() !== S) && (e = Z.LT || Z.QL ? zingchart.wh(M, "" + M.width(), "" + M.height()) : zingchart.wh(M, Z.G1, Z.MT))[0] > 10 && e[1] > 10) {
                                        for (Z.I = ZC._i_(e[0]), Z.F = ZC._i_(e[1]), K = M.width(), S = M.height(), a = 0, l = Z.AG.length; a < l; a++) Z.AG[a].MG[0] = 0;
                                        N();
                                    }
                                } else if (((K = M.width()), (S = M.height()), K > 10 && S > 10)) {
                                    for (
                                        -1 !== ("" + Z.G1).indexOf("%") ? (Z.I = ZC._i_(K * ZC.IJ(Z.G1))) : (Z.I = ZC._i_(K)), -1 !== ("" + Z.MT).indexOf("%") ? (Z.F = ZC._i_(S * ZC.IJ(Z.MT))) : (Z.F = ZC._i_(S)), a = 0, l = Z.AG.length;
                                        a < l;
                                        a++
                                    )
                                        Z.AG[a].MG[0] = 0;
                                    N();
                                }
                                P++;
                            } else window.clearInterval(Z.YX);
                        }, zingchart.DEV.RESIZESPEED));
                }
                return Z;
            }
            function H() {
                if (!Z.D.wh || Z.D.wh !== Z.I + "/" + Z.F) {
                    for (var e = !1, i = 0; i < zingchart.HZ.length; i++) zingchart.HZ[i].L === Z.L && (e = !0);
                    e && Z.resize();
                }
                Z.A0D = !1;
            }
            function N() {
                Z.A0D
                    ? Z.VA.width !== Z.I && (clearTimeout(Z.A66), (Z.VA.width = Z.I), (Z.VA.height = Z.F), (Z.A66 = setTimeout(H, zingchart.DEV.DEBOUNCESPEED)))
                    : ((Z.A0D = !0), (Z.VA = { width: Z.I, height: Z.F }), (Z.A66 = setTimeout(H, zingchart.DEV.DEBOUNCESPEED)));
            }
        }),
        (window.zingchart = zingchart),
        ZC.A5.browser.msie && parseFloat(ZC.A5.browser.version) < 9)
    ) {
        var _window_onunload_ = window.onunload;
        window.onunload = function () {
            for (; zingchart.HZ.length; ) zingchart.exec(zingchart.HZ[0].L, "destroy");
            ZC.A5(document)
                .unbind(ZC.Q.C1("mouseover"), zingchart.MK)
                .unbind(ZC.Q.C1("mouseout"), zingchart.MK)
                .unbind(ZC.Q.C1("mousemove"), zingchart.MK)
                .unbind(ZC.Q.C1("mousedown"), zingchart.MK)
                .unbind(ZC.Q.C1("mouseup"), zingchart.MK)
                .unbind("click", zingchart.S9)
                .unbind("contextmenu", zingchart.YP),
                (zingchart.HZ = []),
                _window_onunload_ && _window_onunload_();
        };
    }
    (zingchart.i18n.en_us = {
        rtl: !1,
        "decimals-separator": ".",
        "thousands-separator": "",
        "menu-enablepagescroll": "Enable Page Scroll",
        "menu-disablepagescroll": "Disable Page Scroll",
        "menu-reload": "Reload",
        "menu-print": "Print Chart",
        "menu-viewaspng": "View As PNG",
        "menu-viewasjpg": "View As JPG",
        "menu-downloadpdf": "Download PDF",
        "menu-downloadsvg": "Download SVG",
        "menu-downloadcsv": "Download CSV",
        "menu-downloadxls": "Download XLS",
        "menu-viewdatatable": "View Data Table",
        "menu-hidedatatable": "Hide Data Table",
        "menu-exportdata": "Export Data",
        "menu-zoomin": "Zoom In",
        "menu-zoomout": "Zoom Out",
        "menu-viewall": "View All",
        "menu-viewsource": "View Source",
        "menu-bugreport": "Submit Bug",
        "menu-switchto2d": "Switch To 2D",
        "menu-switchto3d": "Switch To 3D",
        "menu-showguide": "Show Guide",
        "menu-hideguide": "Hide Guide",
        "menu-switchtolin": "Show Linear Scale",
        "menu-switchtolog": "Show Log Scale",
        "menu-fullscreen": "Full Screen",
        "menu-exitfullscreen": "Exit Full Screen",
        "menu-goback": "Go Back",
        "menu-goforward": "Go Forward",
        "date-formats": { msecond: "%d %M %Y<br>%g:%i:%s %A<br>%q ms", second: "%d %M %Y<br>%g:%i:%s %A", minute: "%d %M %Y<br>%g:%i %A", hour: "%d %M %Y<br>%g %A", day: "%d %M %Y", month: "%M %Y", year: "%Y" },
        "days-short": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
        "days-long": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
        "months-short": ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
        "months-long": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
        "sync-wait": "Wait...",
        "export-wait": "Exporting...",
        "progress-wait-long": "Wait. Loading...",
        "progress-wait-short": "Wait...",
        "progress-wait-mini": "...",
        "error-header": "An Error Has Occured",
        "error-message": "Error Message:",
        "error-close": "Close",
        "bugreport-header": "Submit Bug Report",
        "bugreport-senddata": "Send JSON Data",
        "bugreport-sendcapture": "Send Graph Capture",
        "bugreport-yourcomment": "Your Comment:",
        "bugreport-jsondata": "JSON Data:",
        "bugreport-youremail": "Your Email Address",
        "bugreport-infoemail": "if you want to receive via email our reply to your problem",
        "bugreport-emailmandatory": "Email address is mandatory...",
        "bugreport-submit": "Submit",
        "bugreport-cancel": "Cancel",
        "bugreport-confirm": "Your bug report was sent.\n\nThank you!",
        "about-close": "Close",
        "viewsource-jsonsource": "Parsed JSON",
        "viewsource-originalsource": "Original JSON",
        "viewsource-close": "Close",
        "viewsource-apply": "Apply",
        "viewimage-close": "Close",
        "legend-pagination": "Page %page% of %pages%",
    }),
        (ZC.HJ = zingchart.i18n.en_us),
        (zingchart.getLoader = function (e) {
            for (var i = 0; i < zingchart.HZ.length; i++) if (zingchart.HZ[i].L === e) return zingchart.HZ[i];
            return null;
        }),
        (zingchart.getGraph = function (e, i) {
            return e.OS(i);
        }),
        (zingchart.clearLayer = function (e) {
            e.A7 && e.A7.onmouseout();
            for (var i = 0; i < e.AG.length; i++) e.AG[i].LE();
        }),
        (zingchart.getGraphInfo = function (e, i, t) {
            return e.A4K(i, t);
        }),
        (zingchart.initThemes = function (e) {
            e && e.AA6(!0);
        }),
        (zingchart.setModule = function (e) {
            ZC.WG.push(e);
        }),
        (zingchart.getModules = function (e) {
            return e.A1O.split(",");
        }),
        (zingchart.defineModule = function (e, i, t) {
            switch ((zingchart.setModule(e), i)) {
                case "chart":
                    zingchart.bind(null, "dataparse", function (i, n) {
                        for (var a = n.graphset.length, l = 0; l < a; l++)
                            if (n.graphset[l].type === e) {
                                var o = n.graphset[l];
                                o.id ? (o.id = o.id) : (o.id = e.replace(/-/g, "") + l), (n.graphset[l] = t(o));
                            }
                        return n;
                    });
                    break;
                case "plugin":
                    zingchart.bind(null, "dataparse", function (i, n) {
                        var a = zingchart.getLoader(i.id);
                        if (-1 !== zingchart.getModules(a).indexOf(e)) for (var l = n.graphset.length, o = null, r = 0; r < l; r++) (o = n.graphset[r]).hasOwnProperty(e) && (n.graphset[r] = t(o, i.id));
                        return n;
                    });
            }
        }),
        (zingchart.getPalette = function (e, i, t) {
            return (t = t || "bar"), e.B8.AA2(i, t);
        }),
        (zingchart.getObject = function (e, i, t) {
            var n, a;
            switch ((t = t || "label")) {
                case "shape":
                    for (n = 0, a = e.FH.length; n < a; n++) if (e.FH[n].H8 === i || n === i) return e.FH[n].BG;
                    break;
                case "label":
                    for (n = 0, a = e.BY.length; n < a; n++) if (e.BY[n].H8 === i || n === i) return e.BY[n];
            }
            return null;
        }),
        (zingchart.getInstance = function (e, i) {
            switch (i) {
                case "style":
                    return new ZC.D0(e);
                case "shape":
                    return new ZC.DU(e);
                case "box":
                    return new ZC.HN(e);
                case "textbox":
                    return new ZC.DN(e);
            }
            return null;
        }),
        (zingchart.normalize = function (e) {
            ZC._todash_(e);
        }),
        (zingchart.copy = function (e, i) {
            ZC._cp_(e, i);
        }),
        (zingchart.formatDate = function (e, i, t, n) {
            return ZC.AP.Y5(e, i, t, n);
        }),
        (zingchart.formatNumber = function (e, i) {
            return ZC.AP.G3(e, i);
        }),
        (zingchart.fireEvent = function (e, i, t) {
            ZC.AP.C0(e, i, t);
        }),
        (zingchart.A98 = []),
        (zingchart.extendAPI = function (e, i) {
            zingchart.A98.push({ call: e, api: i });
        }),
        (zingchart.exec = function (e, i, t) {
            return zingchart.getLoader(e) ? zingchart.ACY(e, i, t) : zingchart.exec_flash ? zingchart.exec_flash(e, i, t) : void 0;
        }),
        (zingchart.ACY = function (e, i, t) {
            var n, a, l;
            (t = t || {}), document.getElementById("zc-fullscreen") && !t.skipfs && (e = "zc-fullscreen"), "string" == typeof t && (t = JSON.parse(t));
            var o,
                r,
                s,
                A,
                C,
                c = zingchart.getLoader(e);
            if ((null !== ZC._n_(t.preservezoom) && (c.D.preservezoom = ZC._b_(t.preservezoom)), c))
                switch (i) {
                    case "goback":
                        c.ID && c.NR > 0 && (ZC.AP.C0("history_back", c, c.FG()), c.NR--, zingchart.exec(c.L, "setdata", { data: c.QU[c.NR] }));
                        break;
                    case "goforward":
                        c.ID && c.NR < c.QU.length - 1 && (ZC.AP.C0("history_forward", c, c.FG()), c.NR++, zingchart.exec(c.L, "setdata", { data: c.QU[c.NR] }));
                        break;
                    case "setmode":
                        if (("undefined" == typeof c.D["mode-flags"] && (c.D["mode-flags"] = c.KP.join(",")), "" === t.mode && "undefined" != typeof c.D["mode-flags"])) c.KP = c.D["mode-flags"].split(",");
                        else {
                            c.KP = [];
                            var u = ("" + t.mode).split(",");
                            -1 !== ZC.AV(u, "static") && c.KP.push("skip_context_menu", "skip_objects_tracking", "skip_segment_tracking", "skip_marker_tracking", "skip_interactivity");
                        }
                        break;
                    case "showmenu":
                        (ZC.E1[0] = ZC._n_(t.x) ? t.x : ZC.E1[0]), (ZC.E1[1] = ZC._n_(t.y) ? t.y : ZC.E1[1]), (t["from-api"] = !0), zingchart.YP(null, c.L, t);
                        break;
                    case "hidemenu":
                        c.hideCM();
                        break;
                    case "destroy":
                    case "zcdestroy":
                        for (ZC.AP.C0("beforedestroy", c, { id: e, loader: c }), delete zingchart.Y1[e], a = 0, l = c.AG.length; a < l; a++)
                            (c.AG[a].MG[0] = 0), c.AG[a].B9 && ((c.AG[a].B9.IM = !1), c.AG[a].unbind(!1, !0)), c.H2 && (c.H2.IM = !1);
                        for (var p in ((ZC.move = !1),
                        c.A0O(),
                        c.A9N(t, !0),
                        zingchart.DEV.GC && c.gc(),
                        c.YX && window.clearInterval(c.YX),
                        c.YV && window.clearInterval(c.YV),
                        zingchart.IY[e] && delete zingchart.IY[e],
                        ZC.Q.ET([e + "-wrapper", e + "-top", e + "-text-ruler", e + "-dummy", e + "-progress"]),
                        c.A1F || delete zingchart.params[e],
                        delete ZC.TS[e],
                        delete ZC.cache.data["svg-rect"],
                        zingchart.pool.data))
                            0 === p.indexOf(e + "-") && (delete zingchart.pool.data[p], zingchart.pool.size--);
                        var Z = ZC.AV(zingchart.HZ, c);
                        -1 !== Z && zingchart.HZ.splice(Z, 1), zingchart.HZ.length || ((zingchart.GUIDE_EV = null), delete zingchart.LI["zc.logo"]), (c = null), ZC.AP.C0("destroy", null, { id: e });
                        break;
                    case "getrender":
                        return c.AC;
                    case "clear":
                        c.A9N(t);
                        break;
                    case "reload":
                        c.A94(t);
                        break;
                    case "load":
                        c.ACZ(t);
                        break;
                    case "enable":
                        c.A43();
                        break;
                    case "disable":
                        c.A81(t.text);
                        break;
                    case "closemodal":
                        ZC.Q.ET([c.L + "-modal", c.L + "-blocker"]);
                        break;
                    case "openmodal":
                        if (!ZC.AL(c.L + "-modal"))
                            return (
                                ZC.Q.I2({ cls: "zc-abs zc-style zc-blocker", id: c.L + "-blocker", p: ZC.AL(c.L + "-top"), wh: c.I + "/" + c.F, opacity: 0.75 }),
                                ZC.Q.I2({ cls: "zc-abs zc-style zc-modal", id: c.L + "-modal", p: ZC.AL(c.L + "-top"), tl: (c.F - t.height) / 2 + "/" + (c.I - t.width) / 2, wh: t.width + "/" + t.height, opacity: 1 }),
                                ZC.AL(c.L + "-modal")
                            );
                        break;
                    case "mapdata":
                        c.AC5(t);
                        break;
                    case "print":
                        c.A9C();
                        break;
                    case "fullscreen":
                        c.A5R();
                        break;
                    case "exitfullscreen":
                        zingchart.exec("zc-fullscreen", "destroy"), ZC.Q.ET("zc-fullscreen");
                        break;
                    case "resize":
                        c.A2Q = !0;
                        var h = c.I,
                            d = c.F,
                            f = c.JL.split("/"),
                            _ = !1,
                            g = f[0],
                            v = f[1];
                        null !== ZC._n_((n = t.width)) && (g = n),
                            null !== ZC._n_((n = t.height)) && (v = n),
                            null !== ZC._n_((n = t.scale)) && (_ = ZC._b_(n)),
                            c.A1F && ((zingchart.params[c.L].width = g), (zingchart.params[c.L].height = v));
                        var b = zingchart.wh(ZC.A5("#" + c.L), g, v);
                        (t.layout || ((h !== b[0] || d !== b[1]) && b[0] > 10 && b[1] > 10)) &&
                            ((c.I = b[0]), (c.F = b[1]), null !== ZC._n_((n = t.layout)) && (c.o.layout = n), "" === c.MF && ((c.D["from-api"] = !0), (c.D.preservezoom = !0), c.resize(_), (c.G1 = g), (c.MT = v), (c.A2Q = !1)));
                        break;
                    case "plothide":
                    case "hideplot":
                        (o = c.C9(t.graphid)) && o.A3J(t, "hide");
                        break;
                    case "showguide":
                    case "hideguide":
                        (ZC.E1[0] = ZC._n_(t.x) ? t.x : ZC.E1[0]), (ZC.E1[1] = ZC._n_(t.y) ? t.y : ZC.E1[1]), (o = c.C9(t.graphid)) && c.Z5(o.L, "showguide" === i);
                        break;
                    case "showtooltip":
                    case "hidetooltip":
                    case "clicknode":
                        if ((o = c.C9(t.graphid))) {
                            var B = t.ev || {};
                            ("showtooltip" !== i && "clicknode" !== i) ||
                                ((r = o.I0(t.plotindex, t.plotid)) && r.S.length && !t.xy
                                    ? ((s = r.K), (A = ZC._i_(t.nodeindex || "0")), (B.targetid = o.L + "-plotset-plot-" + s + "-node-" + A), (B.update = !0))
                                    : (B.targetid = o.L + "-xy-" + ZC._i_(t.y || "0") + "-" + ZC._i_(t.x || "0"))),
                                "clicknode" === i ? ((B.which = 0), o.TG(B)) : o.A.A7 && ("showtooltip" === i ? o.A.A7.onmouseover(B, t.data) : o.A.A7.hide());
                        }
                        break;
                    case "locktooltip":
                        ZC.TTLOCK = !0;
                        break;
                    case "unlocktooltip":
                        ZC.TTLOCK = !1;
                        break;
                    case "showhoverstate":
                        if ((o = c.C9(t.graphid))) {
                            (r = o.I0(t.plotindex, t.plotid)), (s = ZC._i_(r ? r.K : 0)), (A = ZC._i_(t.nodeindex || "0"));
                            var m = o.AZ.A3[s].FK(A);
                            o.LE(), m.A0Z();
                        }
                        break;
                    case "plotshow":
                    case "showplot":
                        (o = c.C9(t.graphid)) && o.A3J(t, "show");
                        break;
                    case "togglesource":
                        ZC.AL(c.L + "-viewsource") ? ZC.Q.ET(c.L + "-viewsource") : c.A5S();
                        break;
                    case "togglebugreport":
                        ZC.AL(c.L + "-bugreport") ? ZC.Q.ET(c.L + "-bugreport") : c.A6J();
                        break;
                    case "toggleabout":
                        ZC.AL(c.L + "-about") ? ZC.Q.ET([c.L + "-about", c.L + "-about-mask"]) : c.A9I();
                        break;
                    case "toggleplot":
                        (o = c.C9(t.graphid)) && o.QA(t);
                        break;
                    case "getcharttype":
                        return (o = c.C9(t.graphid)) ? o.AF : null;
                    case "showversion":
                    case "getversion":
                        return ZC.VERSION;
                    case "get3dview":
                        return (o = c.C9(t.graphid)) ? o.F0 : null;
                    case "set3dview":
                        (o = c.C9(t.graphid)) &&
                            (null === ZC._n_(c.o.graphset[o.K]["3d-aspect"]) && (c.o.graphset[o.K]["3d-aspect"] = {}),
                            ZC._cp_(t, c.o.graphset[o.K]["3d-aspect"]),
                            null === ZC._n_(o.o["3d-aspect"]) && (o.o["3d-aspect"] = {}),
                            ZC._cp_(t, o.o["3d-aspect"]),
                            (zingchart.SKIP.PARSE3D = !0),
                            o.autoFit(),
                            o.K7(!0, !0),
                            (zingchart.SKIP.PARSE3D = !1));
                        break;
                    case "getpage":
                        return c.L6;
                    case "setpage":
                        var D = 0;
                        null !== ZC._n_((n = t.page)) && (D = ZC._i_(n)),
                            (c.L6 = D),
                            ZC.Z8(function () {
                                c.clear(), c.parse(), c.paint();
                            }, !0);
                        break;
                    case "unbinddocument":
                        ZC.A5(document).unbind(ZC.Q.C1("mousemove"), zingchart.MK).unbind(ZC.Q.C1("mousedown"), zingchart.MK).unbind(ZC.Q.C1("mouseup"), zingchart.MK).unbind("click", zingchart.S9).unbind("contextmenu", zingchart.YP),
                            c.D7 && c.D7.unbind();
                }
            var E = [];
            for (
                zingchart.ABJ && null !== (C = zingchart.ABJ(e, i, t)) && (n = C),
                    E = ["addobject", "removeobject", "updateobject", "repaintobjects", "getobjectsbyclass", "getallobjects", "getlabelinfo", "getshapeinfo", "setobjectsmode", "settweenmode"],
                    zingchart.AB5 && -1 !== ZC.AV(E, i) && null !== (C = zingchart.AB5(e, i, t)) && (n = C),
                    E = ["getimagedata", "exportimage", "saveasimage", "exportdata", "downloadCSV", "downloadXLS", "downloadRAW", "viewDataTable"],
                    zingchart.AB6 && -1 !== ZC.AV(E, i) && null !== (C = zingchart.AB6(e, i, t)) && (n = C),
                    E = ["getzoom", "pan", "zoomin", "zoomout", "zoomto", "zoomtovalues", "viewall"],
                    zingchart.ABP && -1 !== ZC.AV(E, i) && null !== (C = zingchart.ABP(e, i, t)) && (n = C),
                    E = ["clearselection", "getselection", "setselection", "select", "deselect"],
                    zingchart.AAN && -1 !== ZC.AV(E, i) && null !== (C = zingchart.AAN(e, i, t)) && (n = C),
                    E = ["clearfeed", "getinterval", "setinterval", "stopfeed", "startfeed"],
                    zingchart.ABH && -1 !== ZC.AV(E, i) && null !== (C = zingchart.ABH(e, i, t)) && (n = C),
                    a = 0,
                    l = zingchart.A98.length;
                a < l;
                a++
            )
                i === zingchart.A98[a].call && null !== (C = zingchart.A98[a].api.call(zingchart, e, t)) && (n = C);
            return n;
        }),
        zingchart.extendAPI("addmenuitem", function (e, i) {
            var t = zingchart.getLoader(e);
            (t.DG["context-menu"] = t.DG["context-menu"] || {}), (t.DG["context-menu"]["custom-items"] = t.DG["context-menu"]["custom-items"] || []);
            for (var n = i.id || "", a = t.DG["context-menu"]["custom-items"], l = !1, o = 0; o < a.length; o++)
                if (a[o].id === n) {
                    l = !0;
                    break;
                }
            l || t.DG["context-menu"]["custom-items"].push(i);
        }),
        (zingchart.ABJ = function (e, i, t) {
            var n;
            document.getElementById("zc-fullscreen") && (e = "zc-fullscreen"), "string" == typeof (t = t || {}) && (t = JSON.parse(t));
            var a,
                l,
                o,
                r,
                s,
                A,
                C,
                c,
                u,
                p,
                Z,
                h,
                d,
                f,
                _,
                g,
                v,
                b,
                B,
                m,
                D,
                E,
                L,
                F = zingchart.getLoader(e),
                I = !(null !== ZC._n_(t.update) && !ZC._b_(t.update)),
                x = null !== ZC._n_(t.history) && ZC._b_(t.history),
                y = "undefined" != typeof t.smart && ZC._b_(t.smart);
            if (F) {
                switch ((-1 === ZC.AV(["resize", "addplot", "removeplot", "modify", "modifyplot", "setnodevalue", "addnode", "removenode", "setdata"], i) && (((l = F.FG()).params = t), ZC.AP.C0(i, F, l)), i)) {
                    case "clearscroll":
                        if (!(a = F.C9(t.graphid))) return null;
                        a.HQ && a.HQ.M8 && (a.HQ.M8(), a.HQ.unbind()), a.HP && a.HP.M8 && (a.HP.M8(), a.HP.unbind());
                        break;
                    case "getbubblesize":
                        return (a = F.C9(t.graphid)) && (o = a.I0(t.plotindex, t.plotid)) ? o.getSize(t.value || 1) : null;
                    case "fastlinexycoords":
                        var w = (a = F.AG[0]).BM("scale-x"),
                            Y = a.BM("scale-y");
                        return w && Y ? (w.CK && Y.CK ? [Y.AT(t.val), w.AT(t.key)] : [w.AT(t.key), Y.AT(t.val)]) : [0, 0];
                    case "getscaleinfo":
                        return (a = F.C9(t.graphid)) && (r = a.BM(t.name || "")) ? (null !== ZC._n_(t.value) ? (r.AT ? r.AT(t.value) : null) : null !== ZC._n_(t.coord) && r.NE ? r.NE(t.coord) : null) : null;
                    case "getobjectinfo":
                        if (!(a = F.C9(t.graphid))) return null;
                        var X = { id: "L", x: "iX", y: "iY", width: "I", height: "F", color: "C2", lineColor: "B7", lineWidth: "B0", borderColor: "BX", borderWidth: "AU", backgroundColor1: "A0", backgroundColor2: "AE" };
                        switch (t.object) {
                            case "graph":
                                for (p in ((l = {}), X)) l[p] = a[X[p]];
                                return ZC._cp_({ type: a.AF }, l), l;
                            case "plotarea":
                                for (p in ((l = {}), X)) l[p] = a.P[X[p]];
                                return l;
                            case "legend":
                                if (((l = {}), a.BE)) for (p in X) l[p] = a.BE[X[p]];
                                return l;
                            case "scale":
                                if (!(r = a.BM(t.name || ""))) return null;
                                for (p in ((l = {}), X)) l[p] = r[X[p]];
                                return (
                                    ZC._cp_(
                                        {
                                            type: r.AF,
                                            text: (r.M && r.M.AM) || "",
                                            datetime: null !== r.F7 && "date" === r.F7.o.type,
                                            step: r.E3,
                                            step_: r.SG,
                                            stepSize: r.AB,
                                            values: r.V,
                                            placement: r.BA,
                                            aperture: r.EI,
                                            zooming: r.GN,
                                            offsetStart: r.A9,
                                            offsetEnd: r.BR,
                                            sizeFactor: r.JF,
                                            inversed: r.CK,
                                        },
                                        l
                                    ),
                                    r.M && "" !== r.M.AM && (l.label = { x: r.M.iX, y: r.M.iY, width: r.M.I, height: r.M.F, angle: r.M.AA }),
                                    "v" === r.AF
                                        ? ZC._cp_({ progression: r.BS, logBase: r.DW, minValue: r.AY, maxValue: r.BD, minValue_: r.FR, maxValue_: r.GU }, l)
                                        : "scale-r" === t.name
                                        ? ZC._cp_({ refAngle: r.DI }, l)
                                        : ZC._cp_({ minValue: r.V[r.W], maxValue: r.V[r.A1], minValue_: r.V[r.DA], maxValue_: r.V[r.DY], minIndex: r.W, maxIndex: r.A1, minIndex_: r.DA, maxIndex_: r.DY }, l),
                                    l
                                );
                            case "plot":
                                if (!(o = a.I0(t.plotindex, t.plotid))) return null;
                                for (p in ((l = {}), X)) l[p] = o[X[p]];
                                var M = o.AN && a.D["plot" + o.K + ".visible"];
                                return (
                                    ZC._cp_({ visible: M, id: o.H8, index: o.K, type: o.AF, text: o.AM, values: o.V, scales: o.BO, stacked: o.CE, stackType: o.KR, stack: o.E0, xdata: o.K0 }, l),
                                    o.TY && ZC._cp_({ marker: { visible: o.TY.AN, size: o.TY.AI, type: o.TY.DS, backgroundColor1: o.TY.A0, backgroundColor2: o.TY.AE, borderColor: o.TY.BX, borderWidth: o.TY.AU } }, l),
                                    l
                                );
                            case "node":
                                if ((o = a.I0(t.plotindex, t.plotid))) {
                                    if (((B = null !== ZC._n_(t.nodeindex) ? ZC._i_(t.nodeindex) : 0), !o.S[B])) return null;
                                    for (p in ((s = o.FK(B)), ((l = {}).bounds = s.H.D[s.L + "-bounds"]), X)) -1 !== ZC.AV(["x", "y", "width", "height"], p) ? (l[p] = s[X[p]]) : (l[p] = s.O[X[p]]);
                                    if (
                                        (ZC._cp_({ plotindex: o.K, index: s.K, size: s.AI, value: s.AD, keyvalue: s.BV, onviewport: s.IZ }, l),
                                        -1 !== o.AF.indexOf("pie") && ZC._cp_({ angleStart: s.B4, angleEnd: s.BK, slice: s.A.PQ, npv: (100 * s.AD) / s.A.A.KL[s.K] }, l),
                                        o.K0)
                                    ) {
                                        var K = {};
                                        for (p in o.K0) o.K0[p] instanceof Array ? (K[p] = o.K0[p][B]) : (K[p] = o.K0[p]);
                                        l.xdata = K;
                                    }
                                    return l;
                                }
                                return null;
                        }
                        break;
                    case "getxyinfo":
                        var S = [],
                            P = t.x,
                            H = t.y,
                            N = ZC._tx_(F.L);
                        (P /= N[0]), (H /= N[1]);
                        for (var G = 0; G < F.AG.length; G++) {
                            a = F.AG[G];
                            for (var O = 0; O < a.AZ.A3.length; O++) {
                                o = a.AZ.A3[O];
                                var k = a.BM(o.BW("k")[0]),
                                    T = a.BM(o.BW("v")[0]);
                                if (k && T) {
                                    if (k.OG && k.OG) {
                                        var z = k.OG(k.CK ? H : P),
                                            Q = k.OG(k.CK ? H : P, null, !0);
                                        S.push({
                                            infotype: "key-scale",
                                            xydistance: ZC._a_(P - k.IB(z)),
                                            graphid: a.L,
                                            plotidx: o.K,
                                            scalename: k.BF,
                                            scaleidx: z,
                                            scalepos: Q,
                                            scaletext: k.BY[z] || "",
                                            scalevalue: k.V[z],
                                            scalenumvalue: k.NE(k.CK ? H : P),
                                        });
                                    }
                                    if (T.NE) {
                                        var V = T.NE(T.CK ? P : H, !0);
                                        S.push({ infotype: "value-scale", xydistance: ZC._a_(T.CK ? P : H - T.AT(V)), graphid: a.L, plotidx: o.K, scalename: T.BF, scalevalue: V });
                                    }
                                    for (var J, R = ZC.MAX, W = null, U = 0, j = o.S.length; U < j; U++)
                                        if (null !== (s = o.FK(U)))
                                            switch (a.AJ.layout) {
                                                case "xy":
                                                case "yx":
                                                    var q = !1;
                                                    "vbar" === s.A.AF
                                                        ? ((J = s.getNodeData("h") || s.F), ZC.DT(P, s.iX - s.I / 2, s.iX + s.I / 2) && ZC.DT(H, s.iY, s.iY + J) && ((q = !0), (R = 1)))
                                                        : "hbar" === s.A.AF && ((J = s.getNodeData("w") || s.I), ZC.DT(P, s.iX, s.iX + J) && ZC.DT(H, s.iY - s.F / 2, s.iY + s.F / 2) && ((q = !0), (R = 1))),
                                                        ((n = Math.sqrt((s.iX - P) * (s.iX - P) + (s.iY - H) * (s.iY - H))) < R || q) &&
                                                            ((W = { infotype: "node", xydistance: R, graphid: a.L, plotidx: o.K, plotid: o.H8, nodeidx: s.K, nodevalue: s.AD, nodekeyvalue: null === s.BV ? k.V[s.K] : s.BV }), q || (R = n));
                                                    break;
                                                case "":
                                                    var $ = s.ACE();
                                                    (n = Math.sqrt(($[0] - P) * ($[0] - P) + ($[1] - H) * ($[1] - H))) < R &&
                                                        ((W = { infotype: "node", xydistance: R, graphid: a.L, plotidx: o.K, plotid: o.H8, nodeidx: s.K, nodevalue: s.AD, nodekeyvalue: null === s.BV ? k.V[s.K] : s.BV }), (R = n));
                                            }
                                    W && S.push(W);
                                }
                            }
                        }
                        return S;
                    case "update":
                        t.objects
                            ? (a = F.C9(t.graphid)) && (a.OW(), a.QM())
                            : null !== ZC._n_(t.graphid) && (a = F.C9(t.graphid))
                            ? F.Q8(function () {
                                  a.K7(y, y);
                              })
                            : F.K7();
                        break;
                    case "setcharttype":
                        (a = F.C9(t.graphid)) &&
                            (null !== ZC._n_(t["preserve-state"]) && ZC._b_(t["preserve-state"]) ? (F.D["graph-state-" + a.K] = JSON.stringify(a.D)) : (F.D["graph-state-" + a.K] = null),
                            (F.o.graphset[a.K].type = a.o.type = a.AF = t.type),
                            I && F.K7());
                        break;
                    case "addgraph":
                        F.o.graphset.push(t.data || {}), I && F.K7();
                        break;
                    case "addplot":
                        if (
                            ((zingchart.SKIP.CSV = !0), (h = {}), (d = t.plotdata ? "plotdata" : "data"), null !== ZC._n_(t[d]) && ("object" == typeof t[d] ? ZC._cp_(t[d], h) : (h = JSON.parse(t[d]))), ZC._todash_(h), (a = F.C9(t.graphid)))
                        ) {
                            var ee = [];
                            if (
                                (null === ZC._n_(a.o.series) && (a.o.series = []),
                                (Z = (null !== ZC._n_(t.plotindex) || null !== ZC._n_(t.plotid)) && (o = a.I0(t.plotindex, t.plotid)) ? o.K : a.o.series.length),
                                null !== ZC._n_(a.IX) && a.IX.splice(Z, 0, !1),
                                null !== ZC._n_(a.CD))
                            ) {
                                for (D in ((L = {}), a.CD)) (E = ZC._i_(D.replace("p", ""))) < Z ? (L[D] = a.CD[D]) : (L["p" + (E + 1)] = a.CD[D]);
                                (L["p" + Z] = {}), (a.CD = L);
                            }
                            for (A = 0, C = a.o.series.length; A <= C; A++) A === Z && ee.push(h), a.o.series[A] && ee.push(a.o.series[A]);
                            ZC.AP.C0("plot_add", F, { id: F.L, graphid: a.L, plotindex: Z, data: h }),
                                (F.o.graphset[a.K].series = a.o.series = ee),
                                (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                a.M0("on-change"),
                                I &&
                                    ((a.D["from-api"] = !0),
                                    F.Q8(function () {
                                        a.K7(y, y);
                                    }));
                        }
                        break;
                    case "removeplot":
                        if (((zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid)) && (o = a.I0(t.plotindex, t.plotid)))) {
                            if ((null !== ZC._n_(a.IX) && a.IX.splice(o.K, 1), null !== ZC._n_(a.CD))) {
                                for (D in ((L = {}), a.CD)) (E = ZC._i_(D.replace("p", ""))) < o.K ? (L[D] = a.CD[D]) : (L["p" + (E - 1)] = a.CD[D]);
                                a.CD = L;
                            }
                            a.o.series.splice(o.K, 1), (F.o.graphset[a.K].series = a.o.series), (F.D.json = ZC.GW(JSON.stringify(F.o))), ZC.AP.C0("plot_remove", F, { id: F.L, graphid: a.L, plotindex: o.K }), a.M0("on-change"), a.K7(y, y);
                        }
                        break;
                    case "modify":
                        if (((zingchart.SKIP.CSV = !0), (h = {}), null !== ZC._n_(t.data) && ("object" == typeof t.data ? ZC._cp_(t.data, h) : (h = JSON.parse(t.data))), ZC._todash_(h), (a = F.C9(t.graphid)))) {
                            if ((a.B9 && ((a.B9.I4 = !1), (a.D["force-preview-parse"] = !0)), null !== ZC._n_(t.object)))
                                switch (t.object) {
                                    case "title":
                                        ZC._cp_(h, a.o.title);
                                        break;
                                    case "plotset":
                                    case "series":
                                        ZC._cp_(h, a.o.series);
                                        break;
                                    case "plotarea":
                                        ZC._cp_(h, a.o.plotarea);
                                        break;
                                    case "legend":
                                        ZC._cp_(h, a.o.legend);
                                        break;
                                    case "plot":
                                        ZC._cp_(h, a.o.plot);
                                        break;
                                    case "map":
                                        ZC._cp_(h, a.o.shapes[0]);
                                }
                            else ZC._cp_(h, a.o);
                            switch (t.object) {
                                case "title":
                                    F.o.graphset[a.K].title = a.o.title;
                                    break;
                                case "plotset":
                                case "series":
                                    F.o.graphset[a.K].series = a.o.series;
                                    break;
                                case "plotarea":
                                    F.o.graphset[a.K].plotarea = a.o.plotarea;
                                    break;
                                case "legend":
                                    F.o.graphset[a.K].legend = a.o.legend;
                                    break;
                                case "plot":
                                    F.o.graphset[a.K].plot = a.o.plot;
                                    break;
                                case "map":
                                    (F.o.graphset[a.K].shapes[0] = a.o.shapes[0]), F.XU(F.o), (a.o.shapes = F.o.graphset[a.K].shapes);
                                    break;
                                default:
                                    F.o.graphset[a.K] = a.o;
                            }
                            (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                ZC.AP.C0("modify", F, { id: F.L, graphid: a.L, data: h, object: t.object }),
                                a.M0("on-change"),
                                I &&
                                    ((a.D["from-api"] = !0),
                                    F.Q8(function () {
                                        a.K7(y, y);
                                    }));
                        }
                        break;
                    case "modifyplot":
                        (zingchart.SKIP.CSV = !0),
                            (h = {}),
                            (d = t.plotdata ? "plotdata" : "data"),
                            null !== ZC._n_(t[d]) && ("object" == typeof t[d] ? ZC._cp_(t[d], h) : (h = JSON.parse(t[d]))),
                            ZC._todash_(h),
                            (a = F.C9(t.graphid)) &&
                                (o = a.I0(t.plotindex, t.plotid)) &&
                                (null === ZC._n_(F.o.graphset[a.K].series) && (F.o.graphset[a.K].series = []),
                                ZC._cp_(h, a.o.series[o.K]),
                                (F.o.graphset[a.K].series[o.K] = a.o.series[o.K]),
                                (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                ZC.AP.C0("plot_modify", F, { id: F.L, graphid: a.L, plotindex: o.K, data: h }),
                                a.M0("on-change"),
                                I &&
                                    ((a.D["from-api"] = !0),
                                    F.Q8(function () {
                                        a.K7(y, y);
                                    })));
                        break;
                    case "setnodevalue":
                        (zingchart.SKIP.CSV = !0),
                            (a = F.C9(t.graphid)) &&
                                (o = a.I0(t.plotindex, t.plotid)) &&
                                ((B = 0),
                                null !== ZC._n_(t.nodeindex) && (B = ZC._i_(t.nodeindex)),
                                (n = 0),
                                null !== ZC._n_(t.value) && (n = t.value),
                                ZC.AP.C0("node_set", F, { id: F.L, graphid: a.L, plotindex: o.K, nodeindex: B, key: B, value: n, text: n }),
                                (F.o.graphset[a.K].series[o.K].values[B] = a.o.series[o.K].values[B] = n),
                                (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                a.M0("on-change"),
                                I && ((a.D["from-api"] = !0), a.K7(y, y)));
                        break;
                    case "setscalevalues":
                        if (((zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid)))) {
                            for (f = t.scale || "scale-x", _ = 0, g = a.BO.length; _ < g; _++)
                                f === a.BO[_].BF && null !== ZC._n_(a.o[f]) && ((a.o[f].values = t.values), (F.o.graphset[a.K][f] = F.o.graphset[a.K][f] || {}), (F.o.graphset[a.K][f].values = t.values));
                            (F.D.json = ZC.GW(JSON.stringify(F.o))), a.M0("on-change"), I && ((a.D["from-api"] = !0), a.K7(y, y));
                        }
                        break;
                    case "addscalevalue":
                        if (((zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid)))) {
                            for (f = t.scale || "scale-x", _ = 0, g = a.BO.length; _ < g; _++)
                                if (f === a.BO[_].BF && null !== ZC._n_(a.o[f]) && null !== ZC._n_(a.o[f].values)) {
                                    for (B = null === ZC._n_(t.nodeindex) ? a.o[f].values.length : ZC._i_(t.nodeindex), (b = a.o[f].values).push(null), A = b.length - 1; A > B; A--) b[A] = b[A - 1];
                                    (b[B] = t.value || ""), (F.o.graphset[a.K][f].values = b);
                                }
                            (F.D.json = ZC.GW(JSON.stringify(F.o))), a.M0("on-change"), I && ((a.D["from-api"] = !0), a.K7(y, y));
                        }
                        break;
                    case "removescalevalue":
                        if (((zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid)))) {
                            for (f = t.scale || "scale-x", _ = 0, g = a.BO.length; _ < g; _++)
                                f === a.BO[_].BF &&
                                    null !== ZC._n_(a.o[f]) &&
                                    null !== ZC._n_(a.o[f].values) &&
                                    ((B = null === ZC._n_(t.nodeindex) ? a.o[f].values.length - 1 : ZC._i_(t.nodeindex)), (b = a.o[f].values).splice(B, 1), (F.o.graphset[a.K][f].values = b));
                            (F.D.json = ZC.GW(JSON.stringify(F.o))), a.M0("on-change"), I && ((a.D["from-api"] = !0), a.K7(y, y));
                        }
                        break;
                    case "addnode":
                        (zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid));
                        var ie = t.value instanceof Array;
                        if (a && (o = a.I0(t.plotindex, t.plotid))) {
                            (v = a.o.series[o.K].values), (B = null === ZC._n_(t.nodeindex) ? v.length : t.nodeindex), v.push(null);
                            var te = v.length;
                            for (B = ZC.BQ(0, ZC.CY(B, te)), A = te - 1; A > B; A--) v[A] = v[A - 1];
                            if (((v[B] = t.value), !ie))
                                for (_ = 0, g = a.BO.length; _ < g; _++)
                                    if (((f = a.BO[_].BF), "k" === a.BO[_].AF && null !== ZC._n_(t[f + "-value"]) && null !== ZC._n_(a.o[f]) && null !== ZC._n_(a.o[f].values))) {
                                        for ((b = a.o[f].values).push(null), A = b.length - 1; A > B; A--) b[A] = b[A - 1];
                                        (b[B] = t[f + "-value"]), (F.o.graphset[a.K][f].values = b);
                                    }
                            ZC.AP.C0("node_add", F, { id: F.L, graphid: a.L, plotindex: o.K, nodeindex: B, key: B, value: t.value, text: t.value }),
                                (F.o.graphset[a.K].series[o.K].values = a.o.series[o.K].values),
                                (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                a.M0("on-change"),
                                I && ((a.D["from-api"] = !0), a.K7(y, y));
                        }
                        break;
                    case "removenode":
                        if (((zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid)) && (o = a.I0(t.plotindex, t.plotid)))) {
                            (v = a.o.series[o.K].values), (B = null === ZC._n_(t.nodeindex) ? o.S.length - 1 : ZC._i_(t.nodeindex));
                            var ne = !0;
                            if (null !== ZC._n_(t.nodekeyvalue))
                                for (ne = !1, _ = 0, g = o.S.length; _ < g; _++) {
                                    if (null === o.S[_] && _ === t.nodekeyvalue) {
                                        (ne = !0), (B = _);
                                        break;
                                    }
                                    if (o.S[_] && null !== ZC._n_(o.S[_].BV) && o.S[_].BV === t.nodekeyvalue) {
                                        (ne = !0), (B = _);
                                        break;
                                    }
                                }
                            if (ne && ZC.DT(B, 0, o.S.length - 1)) {
                                for (v.splice(B, 1), _ = 0, g = a.BO.length; _ < g; _++)
                                    (f = a.BO[_].BF),
                                        "k" === a.BO[_].AF && null !== ZC._n_(t[f]) && ZC._b_(t[f]) && null !== ZC._n_(a.o[f]) && null !== ZC._n_(a.o[f].values) && ((b = a.o[f].values).splice(B, 1), (F.o.graphset[a.K][f].values = b));
                                (ne || o.S[B]) &&
                                    (ZC.AP.C0("node_remove", F, { id: F.L, graphid: a.L, plotindex: o.K, nodeindex: B, key: B, value: o.S[B] ? o.S[B].AD : null, text: o.S[B] ? o.S[B].AD : null }),
                                    (F.o.graphset[a.K].series[o.K].values = a.o.series[o.K].values),
                                    (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                    a.M0("on-change"),
                                    I && ((a.D["from-api"] = !0), a.K7(y, y)));
                            }
                        }
                        break;
                    case "setdata":
                        if (((h = {}), null !== ZC._n_(t.data)))
                            if ("object" == typeof t.data) zingchart.DEV.COPYDATA ? (h = JSON.parse(JSON.stringify(t.data))) : ZC._cp_(t.data, h);
                            else
                                try {
                                    h = JSON.parse(t.data);
                                } catch (fe) {
                                    return F.NY(fe, "JSON parser"), !1;
                                }
                        ZC._todash_(h), null === ZC._n_(t.preservezoom) && (F.D.preservezoom = !1), (a = null), null !== ZC._n_(t.graphid) && (a = F.C9(t.graphid)), ZC.AP.C0("setdata", F, { id: F.L, graphid: a ? a.L : null, data: h });
                        var ae,
                            le,
                            oe = ["x", "y", "width", "height"];
                        if (a) {
                            for (ae = 0; ae < oe.length; ae++) delete F.D["graph-" + a.K + "-" + oe[ae]];
                            F.o.graphset[a.K] = a.o = h;
                            var re = !1;
                            if (h.widgets) re = !0;
                            else if (h.shapes) for (A = 0; A < h.shapes.length; A++) "zingchart.maps" === h.shapes[A].type && (re = !0);
                            re && F.XU(F.o),
                                (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                I &&
                                    ((a.D["from-api"] = !0),
                                    x && F.NR++,
                                    F.Q8(function () {
                                        F.parse(a.L), F.AG[a.K].paint();
                                    }));
                        } else {
                            for (ae = 0; ae < oe.length; ae++) for (le = 0; le < F.AG.length; le++) delete F.D["graph-" + le + "-" + oe[ae]];
                            (F.o = h), (F.D.json = ZC.GW(JSON.stringify(F.o))), F.XU(F.o), I && (x && F.NR++, F.K7());
                        }
                        break;
                    case "getseriesdata":
                        return (a = F.C9(t.graphid)) ? (null !== ZC._n_(t.plotindex) || null !== ZC._n_(t.plotid) ? ((o = a.I0(t.plotindex, t.plotid, 0)) ? a.o.series[o.K] : null) : a.o.series) : null;
                    case "setseriesdata":
                    case "appendseriesdata":
                        if (((zingchart.SKIP.CSV = !0), (a = F.C9(t.graphid)))) {
                            if (
                                (null !== ZC._n_(t.plotindex) || null !== ZC._n_(t.plotid)
                                    ? ((o = a.I0(t.plotindex, t.plotid, 0)), (h = "setseriesdata" === i ? {} : a.o.series && a.o.series[o.K] ? a.o.series[o.K] : {}))
                                    : (h = "setseriesdata" === i ? [] : a.o.series || []),
                                null !== ZC._n_(t.data) && ("object" == typeof t.data ? ZC._cp_(t.data, h) : ZC._cp_(JSON.parse(t.data), h)),
                                ZC._todash_(h),
                                null !== ZC._n_(t.plotindex) || null !== ZC._n_(t.plotid))
                            )
                                (o = a.I0(t.plotindex, t.plotid, 0)), (F.o.graphset[a.K].series[o.K] = a.o.series[o.K] = h), h.hasOwnProperty("visible") && (a.D["plot" + o.K + ".visible"] = h.visible);
                            else for (F.o.graphset[a.K].series = a.o.series = h, A = 0; A < h.length; A++) h[A].hasOwnProperty("visible") && (a.D["plot" + A + ".visible"] = h[A].visible);
                            (F.D.json = ZC.GW(JSON.stringify(F.o))),
                                a.M0("on-change"),
                                I &&
                                    F.Q8(function () {
                                        a.K7(y, y);
                                    });
                        }
                        break;
                    case "getseriesvalues":
                        if ((a = F.C9(t.graphid))) {
                            if (null !== ZC._n_(t.plotindex) || null !== ZC._n_(t.plotid)) return ((o = a.I0(t.plotindex, t.plotid, 0)) && a.o.series[o.K].values) || [];
                            for (m = [], A = 0, C = a.AZ.A3.length; A < C; A++) m.push(a.o.series[A].values || []);
                            return m;
                        }
                        return null;
                    case "setseriesvalues":
                    case "appendseriesvalues":
                        (zingchart.SKIP.CSV = !0), (m = []), null !== ZC._n_(t.values) && (m = "object" == typeof t.values ? t.values : JSON.parse(t.values));
                        var se = !1;
                        if ((a = F.C9(t.graphid))) {
                            if (((null === ZC._n_(t.plotindex) && null === ZC._n_(t.plotid)) || ((m = [m]), (se = !0)), se || "setseriesvalues" !== i)) {
                                for (o = a.I0(t.plotindex, t.plotid, 0), A = 0, C = m.length; A < C; A++)
                                    if (a.AZ.A3[o.K + A])
                                        if ("setseriesvalues" === i) se && (F.o.graphset[a.K].series[o.K + A].values = a.o.series[o.K + A].values = m[A]);
                                        else {
                                            var Ae = F.o.graphset[a.K].series[o.K + A].values,
                                                Ce = m[A].length > 0 && null !== ZC._n_(m[A][0]) && m[A][0].length > 1,
                                                ce = !0;
                                            if ((null !== ZC._n_((n = t.ignoreduplicates)) && (ce = ZC._b_(n)), Ce)) {
                                                var ue = Ae.length;
                                                for (c = 0, u = m[A].length; c < u; c++) {
                                                    for (var pe = !1, Ze = ue - 1; Ze >= 0; Ze--) {
                                                        if (m[A][c][0] > Ae[Ze][0]) {
                                                            Ae.push(m[A][c]), (pe = !0);
                                                            break;
                                                        }
                                                        if (m[A][c][0] === Ae[Ze][0]) {
                                                            pe = !0;
                                                            break;
                                                        }
                                                    }
                                                    (pe && ce) || Ae.push(m[A][c]);
                                                }
                                            } else for (c = 0, u = m[A].length; c < u; c++) Ae.push(m[A][c]);
                                            t["max-values"] && ZC._i_(t["max-values"]) < Ae.length && (Ae = Ae.slice(-t["max-values"])), (F.o.graphset[a.K].series[o.K + A].values = a.o.series[o.K + A].values = Ae);
                                        }
                            } else {
                                for (_ = 0; _ < m.length; _++) (F.o.graphset[a.K].series[_] = F.o.graphset[a.K].series[_] || {}), (a.o.series[_] = a.o.series[_] || {}), (F.o.graphset[a.K].series[_].values = a.o.series[_].values = m[_]);
                                if (a.o.series.length > m.length) for (_ = m.length; _ < a.o.series.length; _++) delete F.o.graphset[a.K].series[_], delete a.o.series[_];
                            }
                            a.M0("on-change"), (F.D.json = ZC.GW(JSON.stringify(F.o))), I && a.K7(y, y);
                        }
                        break;
                    case "togglelegend":
                        if ((a = F.C9(t.graphid)) && a.BE) {
                            var he = !0;
                            "undefined" == typeof a.BE.o.visible || a.BE.o.visible || (he = !1), (a.BE.o.visible = !he), a.BE.clear(!1), a.BE.parse(), a.BE.paint();
                        }
                        break;
                    case "legendminimize":
                    case "legendmaximize":
                        (a = F.C9(t.graphid)) &&
                            a.BE &&
                            ("legendminimize" === i ? (ZC.AP.C0("legend_minimize", F, a.GY()), ZC.AP.C0("legend_hide", F, a.GY())) : (ZC.AP.C0("legend_maximize", F, a.GY()), ZC.AP.C0("legend_show", F, a.GY())),
                            (a.BE.ND = "legendminimize" === i),
                            a.BE.VT(),
                            a.BE.clear(!1),
                            a.BE.parse(),
                            a.BE.paint());
                        break;
                    case "legendscroll":
                        (a = F.C9(t.graphid)) && a.BE && (o = a.I0(t.plotindex, t.plotid)) && (a.BE.scrollTo(ZC._i_(o.K)), a.BE.VT(), a.BE.clear(!0, !0), (a.BE.Z0 = !0), a.BE.parse(), a.BE.paint());
                        break;
                    case "toggledimension":
                        (a = F.C9(t.graphid)) && F.A4W(a.L);
                        break;
                    case "getdata":
                        return (h = JSON.parse(F.D.json)), ZC._todash_(h, !0), h;
                    case "getoriginaljson":
                        return (h = JSON.parse(F.D.source)), ZC._todash_(h, !0), h;
                    case "getgraphlength":
                        return F.AG.length;
                    case "getplotlength":
                        return (a = F.C9(t.graphid)) ? a.AZ.A3.length : 0;
                    case "getscales":
                        if ((a = F.C9(t.graphid))) {
                            var de = [];
                            for (A = 0; A < a.BO.length; A++) de.push(a.BO[A].BF);
                            return de;
                        }
                        return [];
                    case "getnodelength":
                        return (a = F.C9(t.graphid)) && (o = a.I0(t.plotindex, t.plotid)) ? o.S.length : null;
                    case "getnodevalue":
                        return (a = F.C9(t.graphid)) && (o = a.I0(t.plotindex, t.plotid)) && null !== ZC._n_(t.nodeindex) && (s = o.S[ZC._i_(t.nodeindex)]) ? (o.EF ? [s.BV, s.AD] : s.AD) : null;
                    case "getplotvalues":
                        if ((a = F.C9(t.graphid)) && (o = a.I0(t.plotindex, t.plotid))) {
                            for (m = [], A = 0, C = o.S.length; A < C; A++) o.S[A] ? (o.EF ? m.push([o.S[A].BV, o.S[A].AD]) : m.push(o.S[A].AD)) : m.push(null);
                            return m;
                        }
                        return null;
                }
            }
            return null;
        });
    var A9X = {
        $i: function () {
            var e = this;
            (e.OE = null), (e.o = {}), (e.I7 = null), (e.JE = null), (e.D = {}), (e.E7 = []), (e.HT = null), (e.MJ = "");
        },
        H3: function (e, i, t, n, a) {
            var l = this;
            if (e.HT) {
                a = a || l.MJ;
                var o = e.HT.call(l, n, a);
                t && o && (o[t + "-state"] ? (o = o[t + "-state"]) : o[t + "State"] && (o = o[t + "State"]));
                var r,
                    s,
                    A = l.getPMap(),
                    C = {},
                    c = {};
                for (var u in o)
                    (r = ZC.EE(u)),
                        (s = ZC.UM(u)),
                        "backgroundColor" === r ? (C.A0 = C.AE = ZC.AP.G9(o[u])) : "borderRadius" === r ? (C.F5 = C.FS = C.FE = C.F2 = o[u]) : "padding" === u ? (C.FM = C.FN = C.FT = C.EQ = o[u]) : A[r] ? (C[A[r]] = o[u]) : (C[r] = o[u]),
                        (c[s] = o[u]);
                i.o || ZC._cp_(o, C), ZC._cp_(C, i), i.o && (ZC._cp_(c, i.o), i.KX());
            }
        },
        parse: function () {
            var s = this,
                G,
                i,
                oRule,
                KO;
            "dashed" !== zingchart.SYNTAX && ZC._todash_(s.o);
            var AC = "";
            if (("undefined" != typeof s.H && (AC = s.H.AC), ZC.ZA(s.o, "html5"), "" !== AC && ZC.ZA(s.o, AC), zingchart.DEV.MEDIARULES && s.o["media-rules"] && "undefined" != typeof s.H))
                for (i = 0; i < s.o["media-rules"].length; i++)
                    (oRule = s.o["media-rules"][i]),
                        (KO = !0),
                        null !== ZC._n_(oRule["min-width"]) && ZC._i_(oRule["min-width"]) > s.H.I && (KO = !1),
                        null !== ZC._n_(oRule["max-width"]) && ZC._i_(oRule["max-width"]) < s.H.I && (KO = !1),
                        null !== ZC._n_(oRule["min-height"]) && ZC._i_(oRule["min-height"]) > s.H.F && (KO = !1),
                        null !== ZC._n_(oRule["max-height"]) && ZC._i_(oRule["max-height"]) < s.H.F && (KO = !1),
                        KO && ZC._cp_(oRule, s.o);
            for (s.o.rules && (s.E7 = s.o.rules), i = 0; i < s.E7.length; i++)
                if ("*" === s.E7[i].rule && s.E7[i].js) {
                    (s.o["js-rule"] = s.E7[i].js), s.E7.splice(i, 1);
                    break;
                }
            if ((G = s.o["js-rule"]))
                if ("function" == typeof G) (s.MJ = ""), (s.HT = eval(G));
                else if ("javascript:" === G.substring(0, 11) || G.indexOf("(") < G.indexOf(")"))
                    try {
                        s.MJ = "";
                        var EC = G.replace("javascript:", ""),
                            iOpen = G.indexOf("("),
                            iClose = G.indexOf(")");
                        -1 !== iOpen && -1 !== iClose && ((s.MJ = EC.substr(iOpen + 1, iClose - iOpen - 1)), (EC = EC.substr(0, iOpen))), (s.HT = ZC.evalFn(EC, window));
                    } catch (e) {}
            if ("undefined" != typeof s.H && null !== s.H.QN) for (var g in s.H.QN) s.H.QN.hasOwnProperty(g) && null === ZC._n_(s.o[g]) && (s.o[g] = s.H.QN[g]);
        },
        getPMap: function () {
            return {};
        },
        addPMap: function (e, i, t) {
            for (var n = i.split(","), a = t.split(","), l = 0, o = a.length; l < o; l++) e[n[l]] = a[l];
        },
        getData: function () {
            return this.o;
        },
        setData: function (e) {
            this.o = e;
        },
        getAttributes: function () {
            return this.D;
        },
        getAttribute: function (e) {
            return this.D[e];
        },
        setAttribute: function (e, i) {
            this.D[e] = i;
        },
        get: function (e) {
            var i = this.getPMap();
            return i[e] ? this[i[e]] : null;
        },
        set: function (e, i) {
            var t = this.getPMap();
            t[e] && (this[t[e]] = i);
        },
        append: function (e, i, t) {
            null === i && (i = !0);
            var n = this;
            e && (n.I7 || ((n.I7 = {}), ZC._cp_(n.o, n.I7, !0, t)), n.JE || (n.JE = {}), ZC._cp_(e, n.JE, !0, t), ZC._cp_(e, n.o, !0, t)), "undefined" != typeof n.AD2 && n.AD2() && e && ZC._cp_(e, n.o);
        },
        AD2: function () {},
        assign_a: function (e) {
            for (var i = 0, t = e.length; i < t; i++) this.o.hasOwnProperty(e[i][0]) && this.ZE(e[i][0], e[i][1], e[i][2], e[i][3], e[i][4]);
        },
        ZE: function (e, i, t, n, a) {
            var l,
                o = this;
            if (null !== (l = o.o[e]) && void 0 !== l) {
                if (t)
                    switch ((-1 !== t.indexOf("p") && ((l = ZC._p_(l)), (t = t.replace("p", ""))), -1 !== t.indexOf("a") && ((l = ZC._a_(l)), (t = t.replace("a", ""))), t)) {
                        case "i":
                            l = ZC._i_(l);
                            break;
                        case "f":
                            l = ZC._f_(l);
                            break;
                        case "b":
                            l = ZC._b_(l);
                            break;
                        case "c":
                            (l = ZC.AP.YO(l, o)),
                                (l = ZC.AP.G9(l, o)) instanceof Array &&
                                    ("color" === e || "font-color" === e
                                        ? ((o.o["text-alpha"] = l[1]), (o.UV = l[1]), (o.D["text-alpha"] = l[1]))
                                        : "border-color" === e
                                        ? ((o.o["border-alpha"] = l[1]), (o.O0 = l[1]), (o.D["b-alpha"] = l[1]))
                                        : ("line-color" === e && (o.D["l-alpha"] = l[1]), null === ZC._n_(o.o.alpha) && (o.C6 = l[1])),
                                    (l = l[0]));
                    }
                null !== ZC._n_(n) && null !== ZC._n_(a) && (l = ZC._l_(l, n, a)), (o[i] = l);
            }
        },
        DE: function () {
            for (var e = this, i = !1, t = 0, n = e.E7.length; t < n; t++) {
                var a = !1;
                try {
                    a = new Function("return (" + e.J5(e.E7[t].rule) + ")")();
                } catch (l) {
                    a = !1;
                }
                a && ((i = !0), e.append(e.E7[t]));
            }
            return i;
        },
        ACJ: function (e) {
            for (var i = "", t = 0, n = e.length; t < n; t++) {
                var a = !1;
                try {
                    a = new Function("return (" + this.J5(e[t].rule) + ")")();
                } catch (l) {
                    a = !1;
                }
                a && (i += "<" + e[t].rule + ">");
            }
            return "" !== i ? [i, ZC.XR.md5(i)] : null;
        },
        J5: function () {
            return !0;
        },
        copy: function (e) {
            var i = this;
            ZC._cp_(e.o, i.o), e.I7 && ((i.I7 = i.I7 || {}), ZC._cp_(e.I7, i.I7)), e.JE && ((i.JE = i.JE || {}), ZC._cp_(e.JE, i.JE)), ZC._cp_(e.D, i.D), ZC._cp_(e.E7, i.E7);
        },
    };
    ZC.A9X = ZC.CA.CC(A9X);
    var D0 = {
        $i: function (e) {
            this.b(e);
            var i = this;
            e && e.H && (i.H = e.H),
                (i.L = ""),
                (i.DH = null),
                (i.AN = !0),
                (i.A0 = "-1"),
                (i.AE = "-1"),
                (i.GR = ""),
                (i.HL = ""),
                (i.VH = !0),
                (i.DB = ""),
                (i.M7 = "repeat"),
                (i.TA = "50% 50%"),
                (i.WN = ""),
                (i.KS = 1),
                (i.NI = "linear"),
                (i.NA = 90),
                (i.VO = 0),
                (i.W5 = 0),
                (i.B0 = 0),
                (i.B7 = "#000"),
                (i.GF = ""),
                (i.EY = 0),
                (i.GC = 0),
                (i.AU = 0),
                (i.BX = "#000"),
                (i.C6 = 1),
                (i.O0 = 1),
                (i.T1 = "butt"),
                (i.A01 = "round"),
                (i.M9 = !1),
                (i.OH = 45),
                (i.JV = 2),
                (i.T6 = 0.75),
                (i.RZ = "#999"),
                (i.P4 = 0),
                (i.CZ = !0),
                (i.N5 = !1),
                (i.L5 = !1),
                (i.A26 = !1),
                (i.LR = null),
                (i.BH = "");
        },
        getPMap: function () {
            var e = this.b();
            return (
                this.addPMap(
                    e,
                    "visible,backgroundColor1,backgroundColor2,gradientColors,gradientStops,backgroundImage,backgroundRepeat,backgroundPosition,backgroundFit,backgroundScale,fillType,fillAngle,fillOffsetX,fillOffsetY,lineWidth,lineColor,lineStyle,lineSegmentSize,lineGapSize,borderWidth,borderColor,borderAlpha,alpha,lineCap,shadow,shadowAngle,shadowDistance,shadowAlpha,shadowColor,shadowBlur,class,border",
                    "AN,A0,AE,GR,HL,DB,M7,TA,WN,KS,NI,NA,VO,W5,B0,B7,GF,EY,GC,AU,BX,O0,C6,T1,M9,OH,JV,T6,RZ,P4,DH,BH"
                ),
                e
            );
        },
        copy: function (e) {
            this.b(e);
            for (var i = "AN,A0,AE,GR,HL,DB,VH,M7,TA,WN,KS,NI,NA,VO,W5,B0,B7,GF,EY,GC,AU,BX,O0,C6,T1,M9,OH,JV,T6,RZ,P4,CZ,L5,DH,H,BH".split(","), t = 0, n = i.length; t < n; t++) "undefined" != typeof e[i[t]] && (this[i[t]] = e[i[t]]);
        },
        AD2: function () {
            var e,
                i,
                t = this,
                n = !1;
            if ((t.o["class"] || t.o.cls || t.o.id) && null !== t.H && null !== t.H.O) {
                if ((e = t.o["class"] || t.o.cls)) for (var a = e.split(/(\s+)/), l = 0, o = a.length; l < o; l++) (i = t.H.O["." + a[l]]) && ((n = !0), ZC._cp_(i, t.o));
                (e = t.o.id) && (i = t.H.O["#" + e]) && ((n = !0), ZC._cp_(i, t.o));
            }
            return null !== t.OE && (i = t.H.O[t.OE]) && ((n = !0), ZC._cp_(i, t.o)), n;
        },
        KX: function (e) {
            var i,
                t = this;
            switch ((null === ZC._n_(e) && (e = t.B0), t.GF)) {
                case "dotted":
                    (t.EY = ZC.BQ(1, 0.75 * e)), (t.GC = 1.75 * e);
                    break;
                case "dashed":
                    (t.EY = 4 * e), (t.GC = 3 * e);
                    break;
                case "dashdot":
                    (t.EY = 4 * e), (t.GC = 2 * e);
                    break;
                default:
                    (t.EY = 0), (t.GC = 0);
            }
            null !== (i = ZC._n_(t.o["line-segment-size"])) && (t.EY = parseInt(i, 10)), null !== (i = ZC._n_(t.o["line-gap-size"])) && (t.GC = parseInt(i, 10));
        },
        parse: function () {
            var e, i, t, n, a, l, o, r, s;
            this.b();
            var A = this;
            if (null !== (e = ZC._n_(A.o.override)) && !A.A26) {
                var C,
                    c,
                    u,
                    p = -1,
                    Z = -1;
                for ("undefined" != typeof A.D.plotidx && (p = ZC._i_(A.D.plotidx)), "undefined" != typeof A.D.nodeidx && (Z = ZC._i_(A.D.nodeidx)), o = 0, r = e.length; o < r; o++) {
                    if (((C = -1), (c = -1), e[o].hook)) {
                        if (null !== (i = ZC._n_(e[o].hook["node-index"]))) {
                            if (((c = 0), (u = []), "object" == typeof i)) u = i;
                            else if ("string" == typeof i) {
                                if (-1 !== i.indexOf(",")) u = i.split(",");
                                else if (-1 !== i.indexOf("-")) for (t = i.split("-"), n = ZC._i_(t[0]); n <= ZC._i_(t[1]); n++) u.push(n);
                            } else u = [i];
                            -1 !== ZC.AV(u, Z) && (c = 1);
                        }
                        if (null !== (i = e[o].hook["plot-index"]) && void 0 !== i) {
                            if (((C = 0), (u = []), "object" == typeof i)) u = i;
                            else if ("string" == typeof i) {
                                if (-1 !== i.indexOf(",")) u = i.split(",");
                                else if (-1 !== i.indexOf("-")) for (t = i.split("-"), n = ZC._i_(t[0]); n < ZC._i_(t[1]); n++) u.push(n);
                            } else u = [i];
                            -1 !== ZC.AV(u, p) && (C = 1);
                        }
                    }
                    0 !== C && 0 !== c && A.append(e[o]);
                }
            }
            if ((null !== (e = A.LR) && A.append(e), (e = A.o["background-color"]))) {
                if (((e = ZC.AP.YO(e, this)), "rgb(" === String(e).substring(0, 4))) for (a = new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)"); (l = a.exec(e)); ) e = e.replace(l[0], ZC.AP.G9(l[0]));
                if ("rgba(" === String(e).substring(0, 5))
                    for (a = new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\,\\s*([0-9.]+)\\)"); (l = a.exec(e)); ) {
                        var h = ZC.AP.G9(l[0], A);
                        (e = e.replace(l[0], h[0])), (A.o.alpha = h[1]), (A.C6 = h[1]), (A.D["bg-alpha"] = h[1]), null === ZC._n_(A.D["b-alpha"]) && (A.D["b-alpha"] = 1), null === ZC._n_(A.D["l-alpha"]) && (A.D["l-alpha"] = 1);
                    }
                var d = ZC.GW(String(e)).split(/\s+|;|,/);
                (A.A0 = ZC.AP.G9(d[0])), (A.AE = 1 === d.length ? A.A0 : ZC.AP.G9(d[1]));
            }
            if (
                !(
                    (null === ZC._n_(A.o["border-width"]) && null === ZC._n_(A.o["border-color"]) && null === ZC._n_(A.o["line-style"])) ||
                    (null === ZC._n_(A.o["border-top"]) && null === ZC._n_(A.o["border-right"]) && null === ZC._n_(A.o["border-bottom"]) && null === ZC._n_(A.o["border-left"]) && null === ZC._n_(A.o.border))
                )
            ) {
                var f = ["top", "right", "bottom", "left"],
                    _ = { top: [0, "solid", "#000"], right: [0, "solid", "#000"], bottom: [0, "solid", "#000"], left: [0, "solid", "#000"] };
                if (((A.I7 = A.I7 || {}), (e = A.I7.border))) for (s = e.split(/\s/), o = 0; o < 4; o++) _[f[o]] = [ZC._i_(s[0] || "0"), ZC.GW(s[1] || "solid"), ZC.AP.G9(s[2] || "#000000")];
                if (null !== ZC._n_(A.I7["border-width"])) for (o = 0; o < 4; o++) _[f[o]][0] = A.I7["border-width"];
                if (null !== ZC._n_(A.I7["line-style"])) for (o = 0; o < 4; o++) _[f[o]][1] = A.I7["line-style"];
                if (null !== ZC._n_(A.I7["border-color"])) for (o = 0; o < 4; o++) _[f[o]][2] = A.I7["border-color"];
                for (o = 0; o < 4; o++) (e = A.I7["border-" + f[o]]) && ((s = e.split(/\s/)), (_[f[o]] = [ZC._i_(s[0] || "0"), ZC.GW(s[1] || "solid"), ZC.AP.G9(s[2] || "#000000")]));
                if (((A.JE = A.JE || {}), (e = A.JE.border))) for (s = e.split(/\s/), o = 0; o < 4; o++) _[f[o]] = [ZC._i_(s[0] || "0"), ZC.GW(s[1] || "solid"), ZC.AP.G9(s[2] || "#000000")];
                if (null !== ZC._n_(A.JE["border-width"])) for (o = 0; o < 4; o++) _[f[o]][0] = A.JE["border-width"];
                if (null !== ZC._n_(A.JE["line-style"])) for (o = 0; o < 4; o++) _[f[o]][1] = A.JE["line-style"];
                if (null !== ZC._n_(A.JE["border-color"])) for (o = 0; o < 4; o++) _[f[o]][2] = A.JE["border-color"];
                for (o = 0; o < 4; o++) (e = A.JE["border-" + f[o]]) && ((s = e.split(/\s/)), (_[f[o]] = [ZC._i_(s[0] || "0"), ZC.GW(s[1] || "solid"), ZC.AP.G9(s[2] || "#000000")]));
                for (o = 0; o < 4; o++) null === ZC._n_(A.o["border-" + f[o]]) && (A.o["border-" + f[o]] = _[f[o]].join(" "));
            }
            A.assign_a([
                ["visible", "AN", "b"],
                ["background-color-1", "A0", "c"],
                ["background-color-2", "AE", "c"],
                ["gradient-colors", "GR"],
                ["gradient-stops", "HL"],
                ["pixel-correction", "CZ", "b"],
                ["background-clip", "VH", "b"],
                ["background-image", "DB"],
                ["background-repeat", "M7"],
                ["background-position", "TA"],
                ["background-fit", "WN"],
                ["background-scale", "KS", "f"],
                ["fill-type", "NI"],
                ["fill-angle", "NA", "i"],
                ["fill-offset-x", "VO", "f"],
                ["fill-offset-y", "W5", "f"],
                ["line-width", "B0", "i"],
                ["line-color", "B7", "c"],
                ["line-style", "GF", ""],
                ["class", "DH"],
                ["cls", "DH"],
                ["border", "BH"],
            ]),
                "none" === A.NI && ((A.AE = A.A0), (A.NI = "linear")),
                "" !== A.BH && ((s = A.BH.split(/\s/)), (A.AU = ZC._i_(s[0] || "0")), (A.GF = ZC.GW(s[1] || "solid")), (A.BX = ZC.AP.G9(s[2] || "#000000"))),
                (A.GR = ZC.AP.YO(A.GR, this)),
                A.KX(),
                A.assign_a([
                    ["line-segment-size", "EY", "i"],
                    ["line-gap-size", "GC", "i"],
                    ["border-width", "AU", "i"],
                    ["border-color", "BX", "c"],
                    ["alpha", "C6", "f", 0, 1],
                    ["shadow", "M9", "b"],
                    ["shadow-angle", "OH", "i", 0, 360],
                    ["shadow-distance", "JV", "i"],
                    ["shadow-alpha", "T6", "f", 0, 1],
                    ["shadow-color", "RZ", "c"],
                    ["shadow-blur", "P4", "i"],
                ]),
                (A.O0 = A.C6),
                A.assign_a([["border-alpha", "O0", "f", 0, 1]]);
        },
    };
    (ZC.D0 = ZC.A9X.CC(D0)),
        (ZC.CS = {
            contour: function (e, i, t) {
                var n, a, l;
                if (e && t && 0 !== t.length) {
                    if (!i.D["fast-vector-path"]) for (n = 0, a = t.length; n < a; n++) t[n] && ((t[n][0] = parseFloat(Number(t[n][0]).toFixed(2))), (t[n][1] = parseFloat(Number(t[n][1]).toFixed(2))));
                    var o = !1,
                        r = t.length;
                    for (n = 0; n < r; n++)
                        null !== ZC._n_(t[n]) &&
                            ((l = [t[n][0], t[n][1]]),
                            null !== ZC._n_(t[n][2]) && l.push(t[n][2], t[n][3]),
                            null !== ZC._n_(t[n][4]) && l.push(t[n][4], t[n][5]),
                            i.N5 && ((l[0] = Math.round(l[0])), (l[1] = Math.round(l[1])), 4 === l.length && ((l[2] = Math.round(l[2])), (l[3] = Math.round(l[3])))),
                            i.CZ && i.B0 % 2 == 1 && ((l[0] -= 0.5), (l[1] -= 0.5), 4 === l.length && ((l[2] -= 0.5), (l[3] -= 0.5)))),
                            0 === n
                                ? e.moveTo(l[0], l[1])
                                : t[n]
                                ? (o && (e.moveTo(l[0], l[1]), (o = !1)),
                                  2 === l.length ? e.lineTo(l[0], l[1]) : 4 === l.length ? e.quadraticCurveTo(l[0], l[1], l[2], l[3]) : 6 === l.length && e.arc(l[0], l[1], l[2], ZC.T8(l[3]), ZC.T8(l[4]), l[5]))
                                : (o = !0);
                }
            },
            setup: function (e, i) {
                var t = i.H.AC;
                if (1 !== i.C6 && i.L5 && (null === ZC._n_(i.o["border-color"]) && (i.BX = i.A0), null === ZC._n_(i.o["border-width"])))
                    switch (t) {
                        case "canvas":
                            i.AU = 0.2;
                            break;
                        case "svg":
                            i.AU = 0.1;
                            break;
                        case "vml":
                            (i.AU = 0.2), (i.D.A8I = i.C6 / 10);
                    }
            },
            paint: function (e, i, t, n, a, l) {
                if ((null === ZC._n_(a) && (a = 2), null === ZC._n_(n) && (n = !1), null === ZC._n_(l) && (l = !1), e && t && 0 !== t.length && i)) {
                    var o, r, s, A, C, c;
                    !l && t.length > 2 && null !== t[0] && null !== t[t.length - 1] && t[0].join(",") === t[t.length - 1].join(",") && (i.T1 = "round");
                    var u = i.H.AC;
                    if ("canvas" !== u || (0 !== i.B0 && "-1" !== i.B7)) {
                        if (i.M9 && !n) {
                            i.C7 = i.C7 || i.Z;
                            var p,
                                Z = ZC.Q._sh_(t, i);
                            "undefined" != typeof i.A4Y ? (p = i.A4Y) : ((p = new ZC.DU(i)).copy(i), (p.L = i.L + "-sh"), (p.M9 = !1), (p.B0 += p.P4), (p.B7 = p.RZ)),
                                (p.C6 = i.C6 * p.T6),
                                "undefined" == typeof i.ADH && (i.A4Y = p),
                                (p.CZ = !1),
                                (o = i.C7 ? ZC.Q.EB(i.C7, u) : e),
                                ZC.CS.setup(o, p),
                                ZC.CS.paint(o, p, Z, !1, 1, l);
                        }
                        var h = ZC._i_(i.EY || "0"),
                            d = ZC._i_(i.GC || "0");
                        "solid" === i.GF && (h = d = 0);
                        var f = t.length;
                        "undefined" == typeof i.AA && (i.AA = 0), "canvas" === u && ((e.lineJoin = i.A01), (e.lineCap = i.T1), (e.strokeStyle = ZC.AP.A34(ZC.AP.G9(i.B7), n ? i.O0 : i.C6)), (e.lineWidth = i.B0), e.beginPath());
                        var _ = !1;
                        if (-1 !== ZC.AV(["svg", "vml"], u)) r = l ? [] : ZC.Q.A2Z(t, u, i, n);
                        else {
                            var g = !1;
                            "dashdot" !== i.GF && (g = e.setLineDash) && e.setLineDash(0 === h || 0 === d ? [] : [h, d]);
                            var v = 0,
                                b = [ZC.MAX, ZC.MAX, -ZC.MAX, -ZC.MAX];
                            for (c = 0; c < f; c++)
                                if (null !== t[c]) {
                                    if (null !== (s = ZC.objmove ? t[c] : ZC.Q._txp_(t[c], u, i, n)) && !isNaN(s[0]) && !isNaN(s[1]) && isFinite(s[0]) && isFinite(s[1]))
                                        if ((f <= 6 && n && ((b[0] = ZC.CY(b[0], s[0])), (b[1] = ZC.CY(b[1], s[1])), (b[2] = ZC.BQ(b[2], s[0])), (b[3] = ZC.BQ(b[3], s[1]))), 0 === c))
                                            2 === s.length ? e.moveTo(s[0], s[1]) : 6 === s.length && e.arc(s[0], s[1], s[2], ZC.T8(s[3]), ZC.T8(s[4]), s[5]);
                                        else if ((_ && (e.moveTo(s[0], s[1]), (_ = !1)), g || 0 === h || 0 === d || 4 === s.length || 6 === s.length || 7 === s.length))
                                            2 === s.length
                                                ? e.lineTo(s[0], s[1])
                                                : 4 === s.length
                                                ? e.quadraticCurveTo(s[0], s[1], s[2], s[3])
                                                : 6 === s.length
                                                ? e.arc(s[0], s[1], s[2], ZC.T8(s[3]), ZC.T8(s[4]), s[5])
                                                : 7 === s.length && e.bezierCurveTo(s[0], s[1], s[2], s[3], s[4], s[5]);
                                        else if (null !== t[c - 1]) {
                                            var B = ZC.Q._txp_(t[c - 1], u, i, n),
                                                m = B[4 === B.length ? 2 : 0],
                                                D = B[4 === B.length ? 3 : 1],
                                                E = s[0],
                                                L = s[1],
                                                F = h + d,
                                                I = E - m,
                                                x = L - D,
                                                y = Math.sqrt(I * I + x * x) + v;
                                            if (y > h) {
                                                var w;
                                                (v = 0), (w = "dashdot" === i.GF ? Math.floor(ZC._a_(y / ((F + i.B0 + d) / 2))) : Math.floor(ZC._a_(y / F)));
                                                var Y = Math.atan2(x, I),
                                                    X = Math.cos(Y),
                                                    M = Math.sin(Y),
                                                    K = m,
                                                    S = D,
                                                    P = h;
                                                for (A = 0; A < w; A++)
                                                    "dashdot" === i.GF && ((F = A % 2 ? i.B0 + d : h + d), (P = A % 2 ? i.B0 : h)), (I = X * F), (x = M * F), e.moveTo(K, S), e.lineTo(K + X * P, S + M * P), (K += I), (S += x);
                                                e.moveTo(K, S), (y = Math.sqrt((E - K) * (E - K) + (L - S) * (L - S))) > h ? e.lineTo(K + X * h, S + M * h) : y > 0 && e.lineTo(K + X * y, S + M * y), e.moveTo(E, L);
                                            } else v = y;
                                        }
                                } else _ = !0;
                            i.H && f <= 6 && n && (i.H.D[i.L + "-bounds"] = b);
                        }
                        switch (u) {
                            case "canvas":
                                (e.globalCompositeOperation = i.A0Y), e.stroke();
                                break;
                            case "svg":
                            case "vml":
                                if (null === ZC._n_(i.o["top-state"]) && i.H.O7 && (!n || i.D.areanode)) {
                                    if (
                                        ((C = i.D.areanode ? i.A0 + "-" + i.AE + "-" + i.DB + "-" + i.B0 + "-" + i.GF + "-" + i.C6 + "-" + i.BL + "-" + i.BI : i.B7 + "-" + i.B0 + "-" + i.GF + "-" + i.C6 + "-" + i.BL + "-" + i.BI),
                                        null === ZC._n_(i.H.NU[a]))
                                    ) {
                                        i.H.NU[a] = { uid: C, ctx: e, path: r, style: i, filled: n };
                                        break;
                                    }
                                    if (i.H.NU[a].uid === C && i.H.NU[a].path.length < 2e3) {
                                        (A = i.H.NU[a].path), r && r[0] && (A.length > 0 && A[A.length - 1].replace(/[A-Z]+/, "") === r[0].replace(/[A-Z]+/, "") && (r[0] = ""), (i.H.NU[a].path = i.H.NU[a].path.concat(r)));
                                        break;
                                    }
                                    "svg" === u ? ZC.CS.VX(i.H.NU[a].ctx, i.H.NU[a].style, i.H.NU[a].path.join(" "), i.H.NU[a].filled) : ZC.CS.VW(i.H.NU[a].ctx, i.H.NU[a].style, i.H.NU[a].path.join(" "), i.H.NU[a].filled),
                                        (i.H.NU[a] = { uid: C, ctx: e, path: r, style: i, filled: n });
                                    break;
                                }
                                "svg" === u ? ZC.CS.VX(e, i, r.join(" "), n, l) : ZC.CS.VW(e, i, r.join(" "), n);
                        }
                        if (null !== ZC._n_(i.o["top-state"]) && !i.Y6 && !i.D["skip-top"] && !i.VN) {
                            var H = new ZC.HN(i.A);
                            H.copy(i),
                                (H.VN = !0),
                                (H.M9 = !1),
                                (H.Z = i.Z),
                                H.append(i.o["top-state"]),
                                (H.L = i.L + "-top"),
                                H.parse(),
                                "svg" === u ? ZC.CS.VX(e, H, r.join(" "), n, l) : "vml" === u ? ZC.CS.VW(e, H, r.join(" "), n) : ZC.CS.paint(e, H, t, n, a, l);
                        }
                    }
                }
            },
            smooth: function (e, i, t) {
                var n, a, l, o;
                ZC._n_(i) && (i = !1), (t = t || "h");
                var r = [],
                    s = [];
                for (n = 0, a = e.length; n < a; n++) e[n] && ("h" === t ? (s.push(e[n][0]), r.push(e[n][1])) : (s.push(e[n][1]), r.push(e[n][0])), 0 === n && (s.push(s[0]), r.push(r[0])));
                for (s.push(s[s.length - 1]), r.push(r[r.length - 1]), e = [], l = 1, o = r.length; l < o - 1; l++) {
                    var A = [r[l - 1], r[l], r[l + 1], r[l + 2]],
                        C = ZC._a_(s[l + 1] - s[l]),
                        c = 1 / (C / A.length),
                        u = ZC.AQ.Y9(i, A, C, c);
                    for (n = 0, a = u.length; n < a; n++) null !== ZC._n_(u[n][0]) && null !== ZC._n_(u[n][1]) ? ("h" === t ? e.push([s[l] + u[n][0] * C, u[n][1]]) : e.push([u[n][1], s[l] + u[n][0] * C])) : e.push(null);
                }
                return e;
            },
            _append_: function (e, i, t) {
                i.H && i.H.G2 ? (null === ZC._n_(i.H.G2[e.id]) && (i.H.G2[e.id] = document.createDocumentFragment()), i.H.G2[e.id].appendChild(t)) : e.appendChild(t);
            },
            VX: function (e, i, t, n, a) {
                if ("" !== t || a) {
                    var l, o, r, s, A, C, c;
                    ZC.cache.data["svg-rect"] || (ZC.cache.data["svg-rect"] = ZC.Q.F6("rect", "http://www.w3.org/2000/svg")), (l = a ? ZC.cache.data["svg-rect"].cloneNode(!0) : ZC.Q.F6("path", "http://www.w3.org/2000/svg"));
                    var u = {};
                    if ((i.DH && "" !== i.DH && (u["class"] = i.DH), a || (u.d = t), a)) {
                        i.I < 0 && ((i.iX -= i.I), (i.I = -i.I)), i.F < 0 && ((i.iY += i.F), (i.F = -i.F));
                        var p = 0,
                            Z = 0,
                            h = 1;
                        i.CZ && ((h = 0), (p = Z = i.B0 / 2), 0 === i.iX && (p = 0), 0 === i.iY && (Z = 0)),
                            0 === h || i.I <= 3 || i.F <= 3
                                ? ((o = Math.floor(i.iX) + p), (r = Math.floor(i.iY) + Z), (s = Math.ceil(i.I) - 2 * p), (A = Math.ceil(i.F) - 2 * p), (C = i.F5), (c = i.F5))
                                : ((o = parseFloat(i.iX.toFixed(h)) + p), (r = parseFloat(i.iY.toFixed(h)) + Z), (s = parseFloat(i.I.toFixed(h)) - 2 * p), (A = parseFloat(i.F.toFixed(h)) - 2 * Z), (C = i.F5), (c = i.F5)),
                            (u.x = o),
                            (u.y = r),
                            (u.width = ZC.BQ(0, s)),
                            (u.height = ZC.BQ(0, A)),
                            (u.rx = C),
                            (u.ry = c),
                            i.H && (i.H.D[i.L + "-bounds"] = [u.x, u.y, u.x + u.width, u.y + u.height]);
                    }
                    var d = "";
                    "undefined" == typeof i.L || "" === i.L ? "undefined" != typeof i.H && ((d = i.H.GRAPHID + "-path-" + ZC.SEQ), ZC.SEQ++) : (d = i.L + "-path");
                    var f,
                        _ = "";
                    if (("undefined" != typeof i.BL && "undefined" != typeof i.BI && ((0 === i.BL && 0 === i.BI) || (_ += "translate(" + i.BL + " " + i.BI + ")")), "undefined" != typeof i.AA && 0 !== i.AA)) {
                        var g = i.AA;
                        "undefined" != typeof i.D.cx && (g += "," + (ZC._x_(i.D.cx) - 0.5)), "undefined" != typeof i.D.cy && (g += "," + (ZC._x_(i.D.cy) - 0.5)), (_ += " rotate(" + g + ")");
                    }
                    if (
                        (n && -1 !== i.D.fill ? ((u.fill = i.D.fill), (u["fill-opacity"] = i.C6)) : (u.fill = "none"),
                        (u["stroke-linecap"] = i.T1),
                        (u["stroke-linejoin"] = i.A01),
                        i.B0 > 0 &&
                            ((u.stroke = i.B7),
                            (u["stroke-width"] = i.B0),
                            (u["stroke-opacity"] = n ? i.O0 : i.C6),
                            "solid" === i.GF || (0 === i.EY && 0 === i.GC) || ("dashdot" === i.GF ? (u["stroke-dasharray"] = [i.EY, i.GC, i.B0, i.GC].join(" ")) : (u["stroke-dasharray"] = i.EY + "," + i.GC))),
                        (l.id = d),
                        "" !== _ && (u.transform = _),
                        i.o["fast-line"] && i.B0 > 0 ? (l.setAttribute("stroke", u.stroke), l.setAttribute("stroke-width", u["stroke-width"]), l.setAttribute("stroke-opacity", u["stroke-opacity"]), l.setAttribute("d", t)) : ZC.Q.G4(l, u),
                        ZC.CS._append_(e, i, l),
                        (!i.D.border || "all" === i.D.border) && "undefined" != typeof i.D.imgfill)
                    )
                        if ("string" == typeof i.D.imgfill)
                            ZC.AL(d + "-imgfill") ||
                                ((f = a ? ZC.Q.F6("rect", "http://www.w3.org/2000/svg") : ZC.Q.F6("path", "http://www.w3.org/2000/svg")),
                                ZC.Q.G4(f, { id: d + "-imgfill", transform: _, fill: i.D.imgfill, "fill-opacity": i.C6 }),
                                a ? ZC.Q.G4(f, { x: o, y: r, width: ZC.BQ(0, s), height: ZC.BQ(0, A), rx: C, ry: c }) : ZC.Q.G4(f, { d: t }),
                                ZC.CS._append_(e, i, f));
                        else if (!ZC.AL(d + "-imgfill")) {
                            var v = i.D.imgfill,
                                b = ZC.Q.F6("image", "http://www.w3.org/2000/svg");
                            b.setAttributeNS
                                ? "zc." === i.DB.substring(0, 3)
                                    ? b.setAttributeNS("http://www.w3.org/1999/xlink", "href", ZC.IMAGES[i.DB])
                                    : b.setAttributeNS("http://www.w3.org/1999/xlink", "href", i.DB)
                                : "zc." === i.DB.substring(0, 3)
                                ? b.setAttribute("src", ZC.IMAGES[i.DB])
                                : b.setAttribute("src", i.DB),
                                null !== ZC._n_(i.D["clip-path"]) && ZC.Q.G4(b, { "clip-path": "url(#" + i.D["clip-path"] + ")" }),
                                ZC.Q.G4(b, { id: d + "-imgfill", x: v[1], y: v[2], "fill-opacity": i.C6, width: i.D["bg-image-width"], height: i.D["bg-image-height"], preserveAspectRatio: "none" }),
                                ZC.CS._append_(e, i, b);
                        }
                }
            },
            VW: function (e, i, t, n) {
                var a, l, o, r, s, A;
                n && (t += " x e");
                var C = "";
                "undefined" == typeof i.L || "" === i.L ? "undefined" != typeof i.H && ((C = i.H.GRAPHID + "-path-" + ZC.SEQ), ZC.SEQ++) : (C = i.L + "-path");
                var c = ZC.Q.F6("zcv:shape");
                (c.style.position = "absolute"), (c.style.rotation = i.AA), (c.id = C);
                var u = ZC.Q.F6("zcv:path");
                if (((u.v = t), u.setAttribute("VMLv", t), c.appendChild(u), 0 === i.B0)) c.stroked = !1;
                else {
                    var p = ZC.Q.F6("zcv:stroke");
                    if (((r = i.C6), "undefined" != typeof i.D.A8I && (r = i.D.A8I), "undefined" != typeof i.D.stroke)) (l = i.D.stroke.weight), (o = i.D.stroke.color), (r = i.D.stroke.opacity), (s = i.D.stroke.dashstyle);
                    else {
                        switch (((s = "solid"), i.GF)) {
                            case "solid":
                                s = "solid";
                                break;
                            case "dotted":
                                s = "dot";
                                break;
                            case "dashed":
                                s = "dash";
                                break;
                            default:
                                s = i.GF;
                        }
                        "solid" !== s && "0 0" != (a = ZC.CY(6, i.EY * i.B0) + " " + ZC.CY(8, i.GC * i.B0)) && (s = a), (l = i.B0), (o = i.B7);
                    }
                    ZC.Q.G4(p, { weight: l + "px", color: o, opacity: r, miterlimit: 10, endcap: "flat", joinstyle: "round", dashstyle: s }), c.appendChild(p);
                }
                n && "undefined" != typeof i.D.fill && -1 !== i.D.fill ? ((c.filled = !0), c.appendChild(i.D.fill)) : (c.filled = !1), ZC.Q.G4(c, { coordorigin: "0 0", coordsize: i.AA % 360 == 0 ? "100 100" : i.H.I + " " + i.H.F });
                var Z = 0,
                    h = 0;
                if (i.AA % 360 != 0 && "undefined" != typeof i.D.cx && "undefined" != typeof i.D.cy) {
                    var d = i.H.I / 2 - i.D.cx,
                        f = i.H.F / 2 - i.D.cy,
                        _ = 0 === f ? 0 : ZC.TN(Math.atan(d / f));
                    i.D.cy > i.H.F / 2 && (_ += 180);
                    var g = Math.sqrt(d * d + f * f);
                    (Z = d - g * ZC.EP(_ - i.AA)), (h = f - g * ZC.EH(_ - i.AA));
                }
                var v = 0 - Z;
                null !== ZC._n_(i.BL) && (v += i.BL);
                var b = 0 - h;
                if (
                    (null !== ZC._n_(i.BI) && (b += i.BI),
                    (c.style.left = v + "px"),
                    (c.style.top = b + "px"),
                    e.appendChild(c),
                    i.AA % 360 == 0 ? ((c.style.width = "10px"), (c.style.height = "10px")) : ((c.style.width = i.H.I + "px"), (c.style.height = i.H.F + "px")),
                    ("all" === i.D.border || "undefined" != typeof i.D.imgfill) && "undefined" != typeof i.D.imgfill)
                ) {
                    var B = i.D.imgfill;
                    1 === B.length
                        ? (((c = ZC.Q.F6("zcv:shape")).style.position = "absolute"),
                          (c.style.rotation = i.AA),
                          ((u = ZC.Q.F6("zcv:path")).v = t),
                          c.appendChild(u),
                          c.appendChild(B[0]),
                          (c.stroked = !1),
                          ZC.Q.G4(c, { id: C + "-imgfill", filled: !0, coordorigin: "0 0", coordsize: i.AA % 360 == 0 ? "100 100" : i.H.I + " " + i.H.F }),
                          (c.style.left = v + "px"),
                          (c.style.top = b + "px"),
                          e.appendChild(c),
                          i.AA % 360 == 0 ? ((c.style.width = "10px"), (c.style.height = "10px")) : ((c.style.width = i.H.I + "px"), (c.style.height = i.H.F + "px")))
                        : 3 === B.length &&
                          (((A = ZC.Q.F6("img")).id = C + "-img"),
                          "zc." === i.DB.substring(0, 3) ? (A.src = ZC.IMAGES[i.DB]) : (A.src = i.DB),
                          (A.style.position = "absolute"),
                          (A.style.left = B[1] + "px"),
                          (A.style.top = B[2] + "px"),
                          (A.style.width = i.D["bg-image-width"] + "px"),
                          (A.style.height = i.D["bg-image-height"] + "px"),
                          e.appendChild(A));
                }
            },
        });
    var DU = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.A = e),
                (i.Z = null),
                (i.C7 = null),
                (i.H8 = ""),
                (i.iX = -1),
                (i.iY = -1),
                (i.DS = "poly"),
                (i.E = []),
                (i.D2 = [0, 0, 0, 0]),
                (i.AA = 0),
                (i.AI = 0),
                (i.JP = 0),
                (i.BL = 0),
                (i.BI = 0),
                (i.AA0 = 0),
                (i.DV = 0),
                (i.B4 = 0),
                (i.BK = 360),
                (i.CO = 0),
                (i.TJ = !1),
                (i.ADA = !1),
                (i.A5E = 0),
                (i.AAP = ""),
                (i.O7 = !1),
                (i.A7B = 1),
                (i.JS = 1),
                (i.EA = null),
                (i.FC = null),
                (i.IP = "auto"),
                (i.K8 = !1),
                (i.A0Y = "source-over"),
                (i.QQ = !1);
        },
        getPMap: function () {
            var e = this.b();
            return this.addPMap(e, "objectId,x,y,points,bounds,pieAngleStart,pieAngleEnd,pieSlice,url,target,offsetX,offsetY,offsetR,size,size2,angle,shape,flat,cursor", "H8,iX,iY,E,D2,B4,BK,CO,EA,FC,BL,BI,DV,AI,JP,AA,DS,K8,IP"), e;
        },
        build: function () {},
        copy: function (e) {
            this.b(e);
            var i,
                t,
                n = this,
                a = "BL,BI,DV,AI,JP,AA,DS,K8,IP".split(",");
            for (i = 0, t = a.length; i < t; i++) "undefined" != typeof e[a[i]] && (n[a[i]] = e[a[i]]);
            if (e.E && e.E.length > 0) for (n.E = [], i = 0, t = e.E.length; i < t; i++) n.E.push(e.E[i]);
        },
        ll_: function (e, i) {
            var t = this;
            -1 !== ("" + e).indexOf("lat") && (i = "y"), -1 !== ("" + e).indexOf("lon") && (i = "x"), (e = ZC._f_(("" + e).replace("lat", "").replace("lon", "")));
            var n = zingchart.maps.maps[t.A5E];
            return (
                n &&
                    (e = zingchart.maps.lonlat2xy(
                        n._INFO_.x,
                        n._INFO_.y,
                        n._INFO_.width,
                        n._INFO_.height,
                        "x" === i ? [e, 0] : [0, e],
                        n._INFO_.bbox,
                        { map: t.A5E, item: t.AAP, zoom: n._INFO_.zoom, offsetX: n._INFO_.offsetX, offsetY: n._INFO_.offsetY },
                        !0
                    )),
                (e = ZC._i_("x" === i ? e[0] : e[1]))
            );
        },
        kv_: function (e, i) {
            var t;
            -1 !== ("" + e).indexOf("val") && (i = "y"), -1 !== ("" + e).indexOf("key") && (i = "x"), (e = ZC._f_(("" + e).replace("key", "").replace("val", "")));
            var n = this.H || zingchart.HZ[0];
            if (n) {
                var a = this.A || n.AG[0];
                a && ("x" === i ? null !== (t = a.BW("k")[0]) && (e = ZC._i_(t.AT(e))) : null !== (t = a.BW("v")[0]) && (e = ZC._i_(t.AT(e))));
            }
            return ZC._i_(e);
        },
        xy_: function (e, i, t) {
            var n = this;
            i = i || "x";
            var a = "" + e;
            if (-1 !== a.indexOf("lat") || -1 !== a.indexOf("lon")) return n.ll_(e, i);
            if (-1 !== a.indexOf("val") || -1 !== a.indexOf("key")) return n.kv_(e, i);
            if ("" + ZC._f_(e) !== a) return -1 !== (e += "").indexOf("%") ? n.xy_(parseFloat(e.replace("%", "")) / 100, i, !0) : -1 !== e.indexOf("px") ? n.xy_(parseFloat(e.replace("px", "")), i) : n.xy_(parseFloat(e), i);
            var l = "undefined" != typeof n.D["p-x"] ? n.D["p-x"] : n.A.iX,
                o = "undefined" != typeof n.D["p-y"] ? n.D["p-y"] : n.A.iY,
                r = "undefined" != typeof n.D["p-width"] ? n.D["p-width"] : n.A.I,
                s = "undefined" != typeof n.D["p-height"] ? n.D["p-height"] : n.A.F;
            return (e >= 1 || e < 0 || zingchart.DEV.IGNORESUBUNIT) && !t
                ? "x" === i
                    ? l + parseFloat(e)
                    : o + parseFloat(e)
                : (e >= 0 && e < 1) || t
                ? "x" === i
                    ? ((r = r || 1), Math.round(l + r * e))
                    : ((s = s || 1), Math.round(o + s * e))
                : void 0;
        },
        locate: function (e) {
            var i,
                t = this;
            if (t.TJ) return -1 !== ("" + t.o.x).indexOf("lon") ? (t.iX = t.ll_(t.o.x, "x")) : t.ZE("x", "iX"), -1 !== ("" + t.o.y).indexOf("lat") ? (t.iY = t.ll_(t.o.y, "y")) : t.ZE("y", "iY"), void t.A3R();
            1 === e
                ? (null !== (i = ZC._n_(t.o.x)) && (t.iX = t.xy_(i, "x")), null !== (i = ZC._n_(t.o.y)) && (t.iY = t.xy_(i, "y")), -1 === t.iX && (t.iX = t.A.iX), -1 === t.iY && (t.iY = t.A.iY))
                : 2 === e && (t.A3R(), (t.I = t.D2[2] - t.D2[0]), (t.F = t.D2[3] - t.D2[1]));
        },
        A3R: function () {
            var e,
                i = this,
                t = ZC.MAX,
                n = ZC.MAX,
                a = -ZC.MAX,
                l = -ZC.MAX;
            switch (i.DS) {
                case "custom":
                    (t = 0), (n = 0), (a = 0), (l = 0);
                    break;
                case "circle":
                case "arc":
                case "pie":
                    (t = i.iX - i.AI), (n = i.iY - i.AI), (a = i.iX + i.AI), (l = i.iY + i.AI);
                    break;
                default:
                    for (var o = 0, r = i.E.length; o < r; o++) null !== (e = i.E[o]) && ((t = Math.min(t, e[0])), (n = Math.min(n, e[1])), (a = Math.max(a, e[0])), (l = Math.max(l, e[1])));
            }
            i.D2 = [t, n, a, l];
        },
        FF: function () {
            var e,
                i = this;
            if ("pie" === i.DS) {
                var t = 1,
                    n = [],
                    a = i.B4 + i.AA,
                    l = i.BK + i.AA,
                    o = i.AI + Math.floor(i.AU / 2),
                    r = i.CO - Math.floor(i.AU / 2);
                for (
                    o > 50 && (t = 2), o > 100 && (t = 4), 0 === r ? a % 360 != l % 360 && n.push([i.iX, i.iY]) : n.push(ZC.AQ.BN(i.iX, i.iY, r, a), ZC.AQ.BN(i.iX, i.iY, (o + r) / 2, a - 0.25 * i.AU), ZC.AQ.BN(i.iX, i.iY, o, a)), e = a;
                    e <= l;
                    e += t
                )
                    n.push(ZC.AQ.BN(i.iX, i.iY, o, e));
                if ((n.push(ZC.AQ.BN(i.iX, i.iY, o, l)), n.push(ZC.AQ.BN(i.iX, i.iY, (o + r) / 2, l + 0.25 * i.AU)), 0 === r)) a % 360 != l % 360 && n.push([i.iX, i.iY]);
                else {
                    for (n.push(ZC.AQ.BN(i.iX, i.iY, r, l)), e = l; e >= a; e -= t) n.push(ZC.AQ.BN(i.iX, i.iY, r, e));
                    n.push(ZC.AQ.BN(i.iX, i.iY, r, a));
                }
                return n.push([n[0][0], n[0][1]]), ZC.AQ.PS(n, Math.min(5, o / 5), [i.BL, i.BI]);
            }
            if (0 === i.AA || ("rectangle" !== i.DS && "rect" !== i.DS)) return ZC.AQ.PS(i.E, Math.min(5, i.AI / 5), [i.BL, i.BI]);
            var s,
                A,
                C,
                c,
                u,
                p,
                Z,
                h,
                d = [];
            for (C = ZC._i_((i.D2[0] + i.D2[2]) / 2), c = ZC._i_((i.D2[1] + i.D2[3]) / 2), s = 0, A = i.E.length; s < A; s++)
                null !== i.E[s] && ((u = i.E[s][0] - C), (p = i.E[s][1] - c), (Z = u * ZC.EH(i.AA) - p * ZC.EP(i.AA)), (h = u * ZC.EP(i.AA) + p * ZC.EH(i.AA)), (d[s] = [Z + C, h + c]));
            return ZC.AQ.PS(d, Math.min(5, i.AI / 5), [i.BL, i.BI]);
        },
        A51: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o,
                r,
                s,
                A = this,
                C = ZC.ie67 ? ZC.MAPTX : 0;
            switch (A.DS) {
                case "line":
                    if (((t = [].concat(A.E)), 0 !== A.AA))
                        for (n = (A.D2[0] + A.D2[2]) / 2, a = (A.D2[1] + A.D2[3]) / 2, e = 0, i = t.length; e < i; e++)
                            null !== t[e] && ((l = t[e][0] - n), (o = t[e][1] - a), (r = l * ZC.EH(A.AA) - o * ZC.EP(A.AA)), (s = l * ZC.EP(A.AA) + o * ZC.EH(A.AA)), (t[e] = [r + n, s + a]));
                    var c = ["poly"];
                    for (e = 0, i = t.length; e < i - 1; e++) null !== t[e] && null !== t[e + 1] && c.push(ZC.AQ.PS(ZC.AQ.YT([t[e], t[e + 1]]), 4, [A.BL, A.BI]));
                    return c;
                case "cross":
                case "plus":
                    return ["circle", ZC._i_(A.iX + C + A.BL) + "," + ZC._i_(A.iY + C + A.BI) + "," + ZC._i_(A.AI)];
                case "circle":
                case "arc":
                    return ["circle", ZC._i_(A.iX + C + A.BL) + "," + ZC._i_(A.iY + C + A.BI) + "," + ZC._i_(A.AI + 2)];
                case "pie":
                    return ["poly", A.FF()];
                default:
                    var u,
                        p = ["poly"];
                    for (t = [], e = 0, i = A.E.length; e < i; e++)
                        if (null !== A.E[e])
                            if (6 === A.E[e].length) for (var Z = A.E[e][3]; Z < A.E[e][4]; Z += 1) t.push(ZC.AQ.BN(A.E[e][0], A.E[e][1], A.E[e][2], Z));
                            else if (4 === A.E[e].length && t[e - 1]) {
                                var h = { x: t[t.length - 1][0], y: t[t.length - 1][1] },
                                    d = { x: A.E[e][2], y: A.E[e][3] },
                                    f = { x: A.E[e][0], y: A.E[e][1] };
                                for (u = 0; u <= 1; u += 0.1) t.push([(1 - u) * (1 - u) * h.x + 2 * u * (1 - u) * f.x + u * u * d.x, (1 - u) * (1 - u) * h.y + 2 * u * (1 - u) * f.y + u * u * d.y]);
                            } else if (7 === A.E[e].length && t[e - 1]) {
                                var _ = { x: t[t.length - 1][0], y: t[t.length - 1][1] },
                                    g = { x: A.E[e][0], y: A.E[e][1] },
                                    v = { x: A.E[e][2], y: A.E[e][3] },
                                    b = { x: A.E[e][4], y: A.E[e][5] };
                                for (u = 0; u <= 1; u += 0.1) {
                                    var B = (1 - u) * (1 - u) * (1 - u),
                                        m = 3 * u * (1 - u) * (1 - u),
                                        D = 3 * u * u * (1 - u),
                                        E = u * u * u;
                                    t.push([B * _.x + m * g.x + D * v.x + E * b.x, B * _.y + m * g.y + D * v.y + E * b.y]);
                                }
                            } else t.push(A.E[e]);
                        else t.length > -1 && p.push(ZC.AQ.PS(t, Math.min(5, A.AI / 5), [A.BL, A.BI])), (t = []);
                    if (0 !== A.AA)
                        for (n = ZC._i_((A.D2[0] + A.D2[2]) / 2), a = ZC._i_((A.D2[1] + A.D2[3]) / 2), e = 0, i = t.length; e < i; e++)
                            null !== t[e] && ((l = t[e][0] - n), (o = t[e][1] - a), (r = l * ZC.EH(A.AA) - o * ZC.EP(A.AA)), (s = l * ZC.EP(A.AA) + o * ZC.EH(A.AA)), (t[e] = [r + n, s + a]));
                    return t.length > -1 && p.push(ZC.AQ.PS(t, Math.min(5, A.AI / 5), [A.BL, A.BI])), p;
            }
        },
        parse: function (e) {
            var i, t, n, a, l, o, r;
            null === ZC._n_(e) && (e = !1), this.o.tween || e || this.b();
            var s = this;
            if (!s.o.tween && !e) {
                s.assign_a([["map", "A5E"]]), "string" == typeof s.o.item && s.assign_a([["item", "AAP"]]), 0 !== s.A5E && (null === ZC._n_(s.o["map-item"]) || s.o["map-item"]) && ((s.o["map-item"] = !0), (s.o["map-skip-z-sort"] = !0));
                var A = ["offset-x", "offset-y"];
                for (t = 0; t < 2; t++) {
                    var C = A[t],
                        c = "offset-x" === C ? "lon" : "lat";
                    if (null !== (i = s.o[C]) && void 0 !== i && -1 !== (i = "" + i).indexOf(c)) {
                        i = ZC._f_(i.replace(c, ""));
                        var u = zingchart.maps.maps[s.A5E];
                        u && ((i = zingchart.maps.translate(C.replace("offset-"), i, s.A.I, s.A.F, u._INFO_.bbox)), (s.o[C] = i));
                    }
                }
                for (
                    s.assign_a([
                        ["url", "EA"],
                        ["target", "FC"],
                        ["cursor", "IP"],
                        ["id", "H8"],
                        ["angle", "AA", "i"],
                        ["static", "K8", "b"],
                        ["flat", "K8", "b"],
                        ["angle-start", "B4", "f"],
                        ["angle-end", "BK", "f"],
                        ["slice", "CO", "i"],
                        ["size", "AI", "f"],
                        ["size-2", "JP", "f"],
                        ["fast-vector-path", "QQ", "b"],
                        ["type", "DS"],
                        ["points", "E"],
                        ["offset-x", "BL"],
                        ["offset-y", "BI"],
                        ["offset-z", "AA0", "i"],
                        ["offset-r", "DV", "i"],
                        ["z-sort", "A7B", "i"],
                        ["z-index", "JS", "f"],
                        ["composite", "A0Y"],
                    ]),
                        s.BL = ZC.IJ(s.BL, !0),
                        s.BI = ZC.IJ(s.BI, !0),
                        s.BL > -1 && s.BL < 1 && "undefined" != typeof s.D["p-width"] && (s.BL *= s.D["p-width"]),
                        s.BI > -1 && s.BI < 1 && "undefined" != typeof s.D["p-height"] && (s.BI *= s.D["p-height"]),
                        s.AI = ZC.BQ(1, s.AI),
                        s.JP = ZC.BQ(1, s.JP),
                        (null !== s.o["z-sort"] && "undefined" != typeof s.o["z-sort"]) || (s.A7B = s.JS),
                        ("rectangle" !== s.DS && "rect" !== s.DS) ||
                            s.assign_a([
                                ["width", "AI", "f"],
                                ["height", "JP", "f"],
                            ]),
                        s.A57 ? ((s.E = JSON.parse(JSON.stringify(s.FB))), (s.A57 = !1)) : (s.FB = JSON.parse(JSON.stringify(s.E))),
                        t = 0,
                        n = s.E.length;
                    t < n;
                    t++
                )
                    if (null !== s.E[t])
                        for (var p = 0; p < s.E[t].length; p++)
                            (-1 === ("" + s.E[t][p]).indexOf("lat") && -1 === ("" + s.E[t][p]).indexOf("lon")) || ((s.A57 = !0), (s.E[t][p] = s.ll_(s.E[t][p], p % 2 == 0 ? "x" : "y"))),
                                (-1 === ("" + s.E[t][p]).indexOf("key") && -1 === ("" + s.E[t][p]).indexOf("val")) || ((s.A57 = !0), (s.E[t][p] = s.kv_(s.E[t][p], p % 2 == 0 ? "x" : "y")));
            }
            if (((s.o.tween = null), (s.AA = s.AA % 360), s.locate(1), "bar" !== s.DS)) {
                var Z = s.AI,
                    h = s.JP;
                switch (s.DS) {
                    case "custom":
                        break;
                    case "triangle":
                        Z = s.AI;
                        var d = 0.1 * s.AI;
                        s.E = [
                            [s.iX - Z, s.iY + Z - d],
                            [s.iX, s.iY - Z - d],
                            [s.iX + Z, s.iY + Z - d],
                            [s.iX - Z, s.iY + Z - d],
                        ];
                        break;
                    case "square":
                        (Z = ZC._i_(0.9 * s.AI)),
                            (s.E = [
                                [s.iX - Z, s.iY - Z],
                                [s.iX - Z, s.iY + Z],
                                [s.iX + Z, s.iY + Z],
                                [s.iX + Z, s.iY - Z],
                                [s.iX - Z, s.iY - Z],
                            ]);
                        break;
                    case "diamond":
                        (Z = ZC._i_(1.2 * s.AI)),
                            (h = ZC._i_(1.2 * (1 === s.JP ? s.AI : s.JP))),
                            (s.E = [
                                [s.iX - Z, s.iY],
                                [s.iX, s.iY + h],
                                [s.iX + Z, s.iY],
                                [s.iX, s.iY - h],
                                [s.iX - Z, s.iY],
                            ]);
                        break;
                    case "trapezoid":
                        s.E = [
                            [s.iX - Z / 2, s.iY + s.JP],
                            [s.iX + Z / 2, s.iY + s.JP],
                            [s.iX + Z, s.iY - s.JP],
                            [s.iX - Z, s.iY - s.JP],
                            [s.iX - Z / 2, s.iY + s.JP],
                        ];
                        break;
                    case "rectangle":
                    case "rect":
                        s.E = [
                            [s.iX - Z / 2, s.iY - s.JP / 2],
                            [s.iX + Z / 2, s.iY - s.JP / 2],
                            [s.iX + Z / 2, s.iY + s.JP / 2],
                            [s.iX - Z / 2, s.iY + s.JP / 2],
                            [s.iX - Z / 2, s.iY - s.JP / 2],
                        ];
                        break;
                    case "parallelogram":
                        s.E = [
                            [s.iX - Z / 2, s.iY - s.JP / 2],
                            [s.iX + (3 * Z) / 2, s.iY - s.JP / 2],
                            [s.iX + Z, s.iY + s.JP / 2],
                            [s.iX - Z, s.iY + s.JP / 2],
                            [s.iX - Z / 2, s.iY - s.JP / 2],
                        ];
                        break;
                    case "plus":
                        (Z = s.AI), (s.E = [[s.iX, s.iY - Z], [s.iX, s.iY + Z], null, [s.iX - Z, s.iY], [s.iX + Z, s.iY]]);
                        break;
                    case "cross":
                        (Z = s.AI), (s.E = [[s.iX - Z, s.iY - Z], [s.iX + Z, s.iY + Z], null, [s.iX - Z, s.iY + Z], [s.iX + Z, s.iY - Z]]);
                        break;
                    case "ic_line":
                        (Z = s.AI / 4),
                            (s.E = [
                                [s.iX - 2 * Z, s.iY + Z],
                                [s.iX - Z, s.iY],
                                [s.iX, s.iY + Z],
                                [s.iX + Z, s.iY - Z],
                                [s.iX + 2 * Z, s.iY],
                            ]);
                        break;
                    case "ic_area":
                        (Z = s.AI / 4),
                            (s.E = [
                                [s.iX - 2 * Z, s.iY + 2 * Z],
                                [s.iX - 2 * Z, s.iY + Z],
                                [s.iX - Z, s.iY],
                                [s.iX, s.iY + Z],
                                [s.iX + Z, s.iY - Z],
                                [s.iX + 2 * Z, s.iY],
                                [s.iX + 2 * Z, s.iY + 2 * Z],
                                [s.iX - 2 * Z, s.iY + 2 * Z],
                            ]);
                        break;
                    case "ic_bars":
                        (s.CZ = !1),
                            (Z = s.AI / 4),
                            (s.E = [
                                [s.iX - 2 * Z, s.iY + 2 * Z],
                                [s.iX - 2 * Z, s.iY - Z],
                                [s.iX - Z, s.iY - Z],
                                [s.iX - Z, s.iY + 2 * Z],
                                [s.iX - 2 * Z, s.iY + 2 * Z],
                                [s.iX - 2 * Z, s.iY + 2 * Z - Z],
                                null,
                                [s.iX - Z / 2, s.iY + 2 * Z],
                                [s.iX - Z / 2, s.iY],
                                [s.iX + Z / 2, s.iY],
                                [s.iX + Z / 2, s.iY + 2 * Z],
                                [s.iX - Z / 2, s.iY + 2 * Z],
                                [s.iX - Z / 2, s.iY + 2 * Z - Z],
                                null,
                                [s.iX + 2 * Z, s.iY + 2 * Z],
                                [s.iX + 2 * Z, s.iY - 2 * Z],
                                [s.iX + Z, s.iY - 2 * Z],
                                [s.iX + Z, s.iY + 2 * Z],
                                [s.iX + 2 * Z, s.iY + 2 * Z],
                                [s.iX + 2 * Z, s.iY + 2 * Z - Z],
                            ]);
                        break;
                    case "arrow":
                        Z = 2 * s.AI;
                        var f = s.AA;
                        s.AA = 0;
                        var _ = ZC.AQ.BN(s.iX, s.iY, Z, f - 35),
                            g = ZC.AQ.BN(s.iX, s.iY, Z, f + 35);
                        s.E = [[s.iX, s.iY], _, null, [s.iX, s.iY], g];
                        break;
                    case "star3":
                    case "star4":
                    case "star5":
                    case "star6":
                    case "star7":
                    case "star8":
                    case "star9":
                        for (s.E = [], Z = 2 * s.AI, l = 360 / (a = ZC._i_(s.DS.replace("star", ""))), o = a % 2 == 0 ? 0 : -90, r = Z / (a > 4 ? 2 : 7 - a), t = 0 + o; t < 360 + o; t += l)
                            s.E.push(ZC.AQ.BN(s.iX, s.iY, 0.75 * Z, t), ZC.AQ.BN(s.iX, s.iY, 0.75 * r, t + l / 2));
                        s.E.push([s.E[0][0], s.E[0][1]]);
                        break;
                    case "rpoly3":
                    case "rpoly4":
                    case "rpoly5":
                    case "rpoly6":
                    case "rpoly7":
                    case "rpoly8":
                    case "rpoly9":
                        for (s.E = [], Z = s.AI, l = 360 / (a = ZC._i_(s.DS.replace("rpoly", ""))), o = a % 2 == 0 ? 0 : -90, null !== ZC._n_(s.o["angle-offset"]) && (o = ZC._i_(s.o["angle-offset"])), t = 0 + o; t < 360 + o; t += l)
                            s.E.push(ZC.AQ.BN(s.iX, s.iY, Z, t));
                        s.E.push([s.E[0][0], s.E[0][1]]);
                        break;
                    case "gear3":
                    case "gear4":
                    case "gear5":
                    case "gear6":
                    case "gear7":
                    case "gear8":
                    case "gear9":
                        for (s.E = [], Z = 2 * s.AI, l = 360 / (2 * (a = ZC._i_(s.DS.replace("gear", "")))), r = 0.75 * Z, t = 0 + (o = a % 2 == 0 ? 0 : -90); t < 360 + o; t += 2 * l) {
                            var v = t + l / 2;
                            s.E.push(ZC.AQ.BN(s.iX, s.iY, 0.75 * Z, v), ZC.AQ.BN(s.iX, s.iY, 0.75 * Z, v + l), ZC.AQ.BN(s.iX, s.iY, 0.75 * r, v + l + 0 * l), ZC.AQ.BN(s.iX, s.iY, 0.75 * r, v + 2 * l - 0 * l));
                        }
                        s.E.push([s.E[0][0], s.E[0][1]]);
                        break;
                    case "hamburger":
                        Z *= 2;
                        var b = s.iX,
                            B = s.iY - 10;
                        (s.E = s.E.concat([[b - Z / 2, B - s.JP / 2], [b + Z / 2, B - s.JP / 2], [b + Z / 2, B + s.JP / 2], [b - Z / 2, B + s.JP / 2], [b - Z / 2, B - s.JP / 2], null])),
                            (B += 5),
                            (s.E = s.E.concat([[b - Z / 2, B - s.JP / 2], [b + Z / 2, B - s.JP / 2], [b + Z / 2, B + s.JP / 2], [b - Z / 2, B + s.JP / 2], [b - Z / 2, B - s.JP / 2], null])),
                            (B += 5),
                            (s.E = s.E.concat([[b - Z / 2, B - s.JP / 2], [b + Z / 2, B - s.JP / 2], [b + Z / 2, B + s.JP / 2], [b - Z / 2, B + s.JP / 2], [b - Z / 2, B - s.JP / 2], null]));
                        break;
                    case "ellipse":
                        for (s.CZ = !1, s.E = [], t = 0; t <= 360; t += 5) s.E.push([s.iX + s.AI * ZC.EH(t), s.iY + s.JP * ZC.EP(t)]);
                        s.E.push([s.E[0][0], s.E[0][1]]);
                        break;
                    case "arc":
                        (s.CZ = !1), (s.E = [ZC.AQ.BN(s.iX, s.iY, s.AI, s.B4), [s.iX, s.iY, s.AI, s.B4, s.BK, 0]]);
                        break;
                    case "pie":
                        for (var m = (s.o["pie-transform"] || "").split(/=|,/); s.B4 < 0 || s.BK < 0; ) (s.B4 += 360), (s.BK += 360);
                        s.CZ = !1;
                        var D = !1;
                        -1 !== ZC.AV(["svg", "vml"], s.H.AC) && s.B4 % 360 == s.BK % 360 && ((s.B4 += 0.05), (s.BK -= 0.05), (D = !0));
                        var E,
                            L,
                            F,
                            I,
                            x,
                            y = s.iX,
                            w = s.iY,
                            Y = ZC._x_(s.B4, 2),
                            X = ZC._x_(s.BK, 2),
                            M = ZC._x_((Y + X) / 2, 2),
                            K = Z,
                            S = s.CO,
                            P = 0 === S && Y % 360 != X % 360 && !D;
                        switch (((s.E = []), "circle" !== m[0] && (0 === S ? Y % 360 == X % 360 || D || s.E.push([y, w]) : s.E.push(ZC.AQ.BN(y, w, S, Y))), m[0])) {
                            case "flat":
                            case "fold":
                                s.E.push(ZC.AQ.BN(y, w, K, Y), ZC.AQ.BN(y, w, K - ("fold" === m[0] ? ZC._i_(m[1]) : 0), X)), P || s.E.push(ZC.AQ.BN(y, w, S, X));
                                break;
                            case "callout":
                                s.E.push(ZC.AQ.BN(y, w, K, Y), [y, w, K, Y, X, 0]),
                                    P ||
                                        ((E = (1.5 * ZC._i_(m[1]) * 360) / (2 * Math.PI * K)),
                                        s.E.push(ZC.AQ.BN(y, w, K, X), ZC.AQ.BN(y, w, S, X), [y, w, S, X, M + E, 1], ZC.AQ.BN(y, w, S - ZC._i_(m[1]), M), ZC.AQ.BN(y, w, S, M - E), [y, w, S, M - E, Y, 1]));
                                break;
                            case "flow":
                                (E = ZC._i_(m[1])),
                                    (I = ZC.AQ.BN(y, w, (S + K) / 2, Y)),
                                    99 === E || -99 === E ? s.E.push([I[0], I[1], (K - S) / 2, Y + 180, Y, 99 === E ? 1 : 0]) : s.E.push(ZC.AQ.BN(y, w, (S + K) / 2, Y + E)),
                                    s.E.push(ZC.AQ.BN(y, w, K, Y), [y, w, K, Y, X, 0]),
                                    (x = ZC.AQ.BN(y, w, (S + K) / 2, X)),
                                    P
                                        ? 99 === E || -99 === E
                                            ? s.E.push(ZC.AQ.BN(y, w, K, X), [x[0], x[1], (K - S) / 2, X, X + 180, 99 === E ? 0 : 1])
                                            : s.E.push(ZC.AQ.BN(y, w, (S + K) / 2, X + E))
                                        : (99 === E || -99 === E ? s.E.push([x[0], x[1], (K - S) / 2, X, X + 180, 99 === E ? 0 : 1]) : s.E.push(ZC.AQ.BN(y, w, (S + K) / 2, X + E)), s.E.push(ZC.AQ.BN(y, w, S, X), [y, w, S, X, Y, 1]));
                                break;
                            case "circle":
                                var H = ZC._f_(m[1] || "1"),
                                    N = (5 + ((ZC._a_(X - Y) % 360) * 50) / 360) * H;
                                (F = X % 360 == Y % 360 || D ? [y, w] : ZC.AQ.BN(y, w, (K + S) / 2, (Y + X) / 2)), s.E.push(ZC.AQ.BN(F[0], F[1], N, 0), [F[0], F[1], N, 0, 360, 0]);
                                break;
                            case "bite":
                                (E = ZC._i_(m[1])),
                                    (L = ZC._i_(2 * K * ZC.EP(E / 2))),
                                    (F = ZC.AQ.BN(y, w, K, Y)),
                                    s.E.push(ZC.AQ.BN(y, w, K - L, Y), [F[0], F[1], L, Y + 180, Y + 90 + (90 - (180 - E) / 2), 1], [y, w, K, Y + E, X, 0]),
                                    P || s.E.push(ZC.AQ.BN(y, w, S, X), [y, w, S, X, Y, 1]);
                                break;
                            case "droplet":
                                for (var G = K, O = 1, k = 0; K * O + k >= G; ) (O = ZC._x_(O - 0.02, 2)), (L = ZC._i_((K * O) / ZC.EH((X - Y) / 2))), (k = ZC._i_(K * O * Math.tan(ZC.T8((X - Y) / 2))));
                                (F = ZC.AQ.BN(y, w, L, M)), s.E.push(ZC.AQ.BN(y, w, K * O, Y), [F[0], F[1], k, M - (360 - (180 - (X - Y))) / 2, M + (360 - (180 - (X - Y))) / 2, 0]), P || s.E.push(ZC.AQ.BN(y, w, S, X), [y, w, S, X, Y, 1]);
                                break;
                            default:
                                s.E.push(ZC.AQ.BN(y, w, K, Y), [y, w, K, Y, X, 0]), 0 === S ? Y % 360 == X % 360 || D || s.E.push([y, w]) : s.E.push(ZC.AQ.BN(y, w, K, X), ZC.AQ.BN(y, w, S, X), [y, w, S, X, Y, 1]);
                        }
                        s.E.push([s.E[0][0], s.E[0][1]]);
                }
            }
            s.locate(2);
        },
        paint: function () {
            var e = this;
            if ("none" !== e.DS && ("custom" === e.DS || "circle" === e.DS || "arc" === e.DS || 0 !== e.E.length)) {
                var i,
                    t,
                    n = { x: "iX", y: "iY", width: "I", height: "F", size: "AI" };
                if (e.o["bottom-state"] && !e.Y6 && !e.VN && !e.bIsBottom) {
                    var a = new ZC.DU(e.A);
                    for (i in (a.copy(e), (a.bIsBottom = !0), (a.M9 = !1), (a.Z = e.Z), a.append({ x: e.iX - e.A.iX, y: e.iY - e.A.iY }), a.append(e.o["bottom-state"]), (a.L = e.L + "-bottom"), a.parse(), (t = !1), n))
                        null === ZC._n_(a.o[i]) || (-1 === ("" + a.o[i]).indexOf("+") && -1 === ("" + a.o[i]).indexOf("-")) || ((a.o[i] = a[n[i]] = e[n[i]] + ZC._i_(a.o[i])), (t = !0));
                    t && a.parse(), a.paint();
                }
                var l = e.H.AC;
                switch ((e.M9 && e.C7 && e.A9J(), l)) {
                    case "canvas":
                        e.A1P();
                        break;
                    case "svg":
                        e.VX();
                        break;
                    case "vml":
                        e.VW();
                }
                if (e.o["top-state"] && !e.Y6 && !e.VN && !e.bIsBottom) {
                    var o = new ZC.DU(e.A);
                    for (i in (o.copy(e), (o.VN = !0), (o.M9 = !1), (o.Z = e.Z), o.append({ x: e.iX - e.A.iX, y: e.iY - e.A.iY }), o.append(e.o["top-state"]), (o.L = e.L + "-top"), o.parse(), (t = !1), n))
                        null === ZC._n_(o.o[i]) || (-1 === ("" + o.o[i]).indexOf("+") && -1 === ("" + o.o[i]).indexOf("-")) || ((o.o[i] = o[n[i]] = e[n[i]] + ZC._i_(o.o[i])), (t = !0));
                    t && o.parse(), o.paint();
                }
            }
        },
        A9J: function () {
            var e,
                i = this,
                t = new ZC.DU(i.A);
            (t.L = i.L + "-sh"),
                t.copy(i),
                (t.O7 = i.O7),
                (t.Z = i.C7),
                (t.M9 = !1),
                (t.Y6 = !0),
                (t.A0 = t.AE = t.RZ),
                (t.GR = t.HL = ""),
                (t.DB = ""),
                (t.GF = "solid"),
                (t.BX = t.RZ),
                (t.B0 = 0),
                (t.C6 = t.T6 * i.C6),
                (t.L = i.L + "-sh");
            var n = (i.JV - i.P4) * ZC.EH(i.OH) + i.P4,
                a = (i.JV - i.P4) * ZC.EP(i.OH) + i.P4;
            if (((t.iX = i.iX + parseInt(n, 10)), (t.iY = i.iY + parseInt(a, 10)), (t.AI = i.AI + i.P4), i.E.length > 0)) {
                e = [];
                for (var l = 0, o = i.E.length; l < o; l++)
                    if (null !== i.E[l]) {
                        for (var r = [], s = 0; s < i.E[l].length; s++) r[s] = i.E[l][s];
                        (r[0] = i.E[l][0] + parseInt(n, 10)), (r[1] = i.E[l][1] + parseInt(a, 10)), e.push(r);
                    } else e.push(null);
            }
            (t.D2 = [i.D2[0] + n, i.D2[1] + a, i.D2[2] + n, i.D2[3] + a]), (t.E = e), t.paint();
        },
        A1E: function () {
            var e = this;
            return {
                lc: "-1" === e.B7 ? "rgba(255,255,255,0)" : 1 === e.C6 ? e.B7 : ZC.AP.A34(ZC.AP.G9(e.B7), e.C6),
                bc: "-1" === e.BX ? "rgba(255,255,255,0)" : 1 === e.O0 ? e.BX : ZC.AP.A34(ZC.AP.G9(e.BX), e.O0),
                bgc1: "-1" === e.A0 ? "rgba(255,255,255,0)" : 1 === e.C6 ? e.A0 : ZC.AP.A34(ZC.AP.G9(e.A0), e.C6),
                bgc2: "-1" === e.AE ? "rgba(255,255,255,0)" : 1 === e.C6 ? e.AE : ZC.AP.A34(ZC.AP.G9(e.AE), e.C6),
            };
        },
        YD: function (e) {
            var i,
                t,
                n,
                a = this;
            switch (a.DS) {
                case "circle":
                case "arc":
                case "pie":
                    (i = a.iX), (t = a.iY), (n = a.AI);
                    break;
                default:
                    (i = a.D2[0] + (a.D2[2] - a.D2[0]) / 2), (t = a.D2[1] + (a.D2[3] - a.D2[1]) / 2), (n = ZC._a_((ZC.EH(a.NA) * (a.D2[2] - a.D2[0])) / 2 + (ZC.EP(a.NA) * (a.D2[3] - a.D2[1])) / 2));
            }
            ZC.P7(i) || (i = 0), ZC.P7(t) || (t = 0), ZC.P7(n) || (n = 0);
            var l = a.VO,
                o = a.W5;
            if ((ZC._a_(l) <= 1 && (l = (l * (a.D2[2] - a.D2[0])) / 2), ZC._a_(o) <= 1 && (o = (o * (a.D2[3] - a.D2[1])) / 2), (i += l), (t += o), "radial" === e)) return { cx: i, cy: t, r: ZC._a_(n) };
            if ("linear" === e) {
                var r = n * ZC.EH(a.NA),
                    s = n * ZC.EP(a.NA),
                    A = i - r,
                    C = t - s,
                    c = i + r,
                    u = t + s;
                return ZC._i_(C) === ZC._i_(u) && ZC._a_(c - A) < 5 && (u += 1), ZC._i_(A) === ZC._i_(c) && ZC._a_(u - C) < 5 && (c += 1), { x1: A, y1: C, x2: c, y2: u };
            }
        },
        RB: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o,
                r = this;
            switch (
                (ZC.cache.data[r.DB] ? (e = ZC.cache.data[r.DB]) : (((e = new Image()).src = r.DB), (ZC.cache.data[r.DB] = e)),
                1 !== r.KS && (e._width_ ? ((e.width = e._width_), (e.height = e._height_)) : ((e._width_ = e.width), (e._height_ = e.height))),
                (i = e.width * r.KS),
                (t = e.height * r.KS),
                r.WN)
            ) {
                case "x":
                    i = r.I;
                    break;
                case "y":
                    t = r.F;
                    break;
                case "xy":
                case "both":
                    (i = r.I), (t = r.F);
            }
            var s = r.TA.split(" "),
                A = s[0] || "",
                C = 0,
                c = 0;
            switch (A) {
                case "":
                case "left":
                    (n = 0), (C = 0);
                    break;
                case "center":
                    (n = (r.I - i) / 2), (C = 0.5);
                    break;
                case "right":
                    (n = r.I - i), (C = 1);
                    break;
                default:
                    -1 !== A.indexOf("%") ? ((C = ZC._i_(A.replace(/[^0-9\-]/g, "")) / 100), (n = (r.I - i) * C)) : ((C = ZC._i_(A.replace(/[^0-9\-]/g, "")) / r.I), (n = ZC._i_(A.replace(/[^0-9\-]/g, ""))));
            }
            (l = n / r.I), "undefined" != typeof r.KU ? (n += r.iX + r.BL) : (n += r.D2[0] + r.BL);
            var u = s[1] || "";
            switch (u) {
                case "":
                case "top":
                    (a = 0), (c = 0);
                    break;
                case "middle":
                    (a = (r.F - t) / 2), (c = 0.5);
                    break;
                case "bottom":
                    (a = r.F - t), (c = 1);
                    break;
                default:
                    -1 !== u.indexOf("%") ? ((c = ZC._i_(u.replace(/[^0-9\-]/g, "")) / 100), (a = (r.F - t) * c)) : ((c = ZC._i_(u.replace(/[^0-9\-]/g, "")) / r.F), (a = ZC._i_(u.replace(/[^0-9\-]/g, ""))));
            }
            if (((o = a / r.F), "undefined" != typeof r.KU ? (a += r.iY + r.BI) : (a += r.D2[1] + r.BI), "pie" === r.DS)) {
                var p = r.AA + r.B4 + (r.BK - r.B4) * C,
                    Z = ZC.AQ.BN(r.iX, r.iY, r.CO + (r.AI - r.CO) * c, p);
                (n = Z[0] - e.width / 2), (a = Z[1] - e.height / 2);
            }
            return (r.D["bg-image-width"] = i), (r.D["bg-image-height"] = t), { image: e, x: ZC._i_(n) + 0.5, y: ZC._i_(a) + 0.5, cx: ZC._f_(l), cy: ZC._f_(o), hPos: C, vPos: c };
        },
        ZF: function (e) {
            for (var i = this, t = i.GR.split(/\s+|;/), n = i.HL.split(/\s+|;/), a = 0, l = t.length; a < l; a++) {
                var o = ZC.AP.G9(t[a], i);
                "object" != typeof o && (o = [o, i.C6]);
                var r = ZC.AP.A34(o[0], o[1]),
                    s = ZC._f_(n[a] || "1");
                ZC.DT(s, 0, 1) || (s = 1), e.addColorStop(s, r);
            }
        },
        A1P: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o,
                r,
                s = this,
                A = s.Z.getContext("2d");
            A.save(), "poly" === s.DS || "line" === s.DS ? ((i = s.D2[0] + (s.D2[2] - s.D2[0]) / 2), (t = s.D2[1] + (s.D2[3] - s.D2[1]) / 2)) : ((i = s.iX), (t = s.iY));
            var C = s.A1E(),
                c = C.lc,
                u = C.bc,
                p = C.bgc1,
                Z = C.bgc2;
            if (p !== Z || ("" !== s.GR && "" !== s.HL)) {
                var h = s.YD(s.NI);
                "radial" === s.NI ? (n = A.createRadialGradient(h.cx, h.cy, 1, h.cx, h.cy, h.r)) : "linear" === s.NI && (n = A.createLinearGradient(h.x1, h.y1, h.x2, h.y2)),
                    "" !== s.GR && "" !== s.HL ? s.ZF(n) : (n.addColorStop(0, p), n.addColorStop(1, Z)),
                    (A.fillStyle = n);
            } else "" !== s.DB && -1 !== ZC.AV(["repeat", "true", !0], s.M7) && "-1" === s.A0 && "-1" === s.AE && (p = "rgba(255,255,255,0)"), (A.fillStyle = p);
            switch (s.DS) {
                case "custom":
                    if (
                        (e = s.o.url) &&
                        (ZC.cache.data[e] ? (a = ZC.cache.data[e]) : (((a = new Image()).src = e), (ZC.cache.data[e] = a)),
                        (a.width = s.o.width ? s.o.width : a.width),
                        (a.height = s.o.height ? s.o.height : a.height),
                        A.drawImage(a, s.iX - a.width / 2 + s.BL, s.iY - a.height / 2 + s.BI, a.width, a.height),
                        0 === p.indexOf("#") && 7 === p.length)
                    ) {
                        for (
                            var d = parseInt(p.substring(1, 3), 16),
                                f = parseInt(p.substring(3, 5), 16),
                                _ = parseInt(p.substring(5, 7), 16),
                                g = A.getImageData(s.iX - a.width / 2 + s.BL, s.iY - a.height / 2 + s.BI, a.width, a.height),
                                v = 0;
                            v < g.data.length;
                            v += 4
                        )
                            (g.data[v] = d | g.data[v]), (g.data[v + 1] = f | g.data[v + 1]), (g.data[v + 2] = _ | g.data[v + 2]);
                        A.putImageData(g, s.iX - a.width / 2 + s.BL, s.iY - a.height / 2 + s.BI);
                    }
                    break;
                case "plus":
                case "cross":
                case "line":
                case "ic_line":
                case "arc":
                    (A.strokeStyle = c), (A.lineWidth = s.B0);
                    break;
                default:
                    (A.strokeStyle = u), (A.lineWidth = s.AU);
            }
            0 !== s.AA && (A.translate(i, t), isNaN(s.AA) || A.rotate(ZC.T8(s.AA)), A.translate(-i, -t));
            var b = -1 === ZC.AV(["cross", "plus", "arc", "line", "ic_line"], s.DS);
            switch ((isNaN(s.BL) || isNaN(s.BI) || (0 === s.BL && 0 === s.BI) || (!b && "arc" !== s.DS) || A.translate(s.BL, s.BI), A.beginPath(), s.DS)) {
                case "circle":
                case "arc":
                    A.setLineDash && "circle" === s.DS && (s.KX(s.AU), A.setLineDash(0 === s.EY || 0 === s.GC ? [] : [s.EY, s.GC])), A.arc(s.iX, s.iY, s.AI, ZC.T8(s.B4), ZC.T8(s.BK), !1);
                    break;
                case "line":
                    break;
                default:
                    -1 !== ZC.AV(["square", "plus"], s.DS) && (s.N5 = !0), ZC.CS.contour(A, s, s.E), -1 !== ZC.AV(["square", "plus"], s.DS) && (s.N5 = !1);
            }
            if (((A.globalCompositeOperation = s.A0Y), b))
                if ("" !== s.DB && -1 === ZC.AV(ZC.IMG404, s.DB)) {
                    var B;
                    A.fill(), A.save(), A.clip(), (B = A.globalAlpha), (A.globalAlpha = s.C6);
                    var m = s.RB();
                    switch (((a = m.image), s.M7)) {
                        case "repeat":
                        case !0:
                        case "true":
                            (l = s.D2[0] - (a.width - (s.D2[2] - s.D2[0])) / 2), (o = s.D2[1] - (a.height - (s.D2[3] - s.D2[1])) / 2), A.translate(l, o), (r = A.createPattern(a, "repeat")), (A.fillStyle = r), A.fill(), A.translate(-l, -o);
                            break;
                        case "no-repeat":
                        case !1:
                        case "false":
                            A.drawImage(a, m.x - s.BL, m.y - s.BI, s.D["bg-image-width"], s.D["bg-image-height"]);
                    }
                    (A.globalAlpha = B), A.restore();
                } else A.fill();
            switch ((A.closePath(), A.beginPath(), s.DS)) {
                case "circle":
                case "arc":
                    A.arc(s.iX, s.iY, s.AI, ZC.T8(s.B4), ZC.T8(s.BK), !1), (("circle" === s.DS && s.AU > 0) || ("arc" === s.DS && s.B0 > 0)) && A.stroke(), A.closePath();
                    break;
                case "plus":
                case "cross":
                case "line":
                case "ic_line":
                    s.B0 > 0 && (ZC.CS.setup(A, s), s.o.spline ? ((s.CZ = !1), (s.QQ = !0), ZC.CS.paint(A, s, ZC.CS.smooth(s.E, !1, s.o.direction || "h"))) : ZC.CS.paint(A, s, s.E));
                    break;
                default:
                    if (s.AU > 0) {
                        var D = s.B7,
                            E = s.B0;
                        (s.B7 = s.BX), (s.B0 = s.AU), s.KX(), ZC.CS.setup(A, s), ZC.CS.paint(A, s, s.E, !0), (s.B7 = D), (s.B0 = E), s.KX();
                    }
                    A.closePath();
            }
            A.restore();
        },
        A2I: function (e) {
            var i = this,
                t = e.info,
                n = t.image,
                a = !0;
            switch (i.M7) {
                default:
                    a = !0;
                    break;
                case "no-repeat":
                case "false":
                case !1:
                    a = !1;
            }
            var l = i.DB;
            0 === n.src.indexOf("data:") && (l = n.src), (n.width *= i.KS), (n.height *= i.KS);
            var o = "" === i.L ? "pattern-" + ZC.SEQ++ : i.L + "-pattern";
            ZC.Q.ET(o);
            var r = ZC.Q.F6("image", "http://www.w3.org/2000/svg");
            r.setAttributeNS ? r.setAttributeNS("http://www.w3.org/1999/xlink", "href", l) : r.setAttribute("src", l),
                ZC.Q.G4(r, { id: o + "-image", preserveAspectRatio: "none", width: i.D["bg-image-width"], height: i.D["bg-image-height"] });
            var s = n.width,
                A = n.height;
            if (!a) {
                var C, c;
                (s = A = 1), i.I > 0 && i.F > 0 ? ((C = i.I), (c = i.F)) : ((C = i.D2[2] - i.D2[0]), (c = i.D2[3] - i.D2[1]));
                var u = ZC._i_(C * t.cx),
                    p = ZC._i_(c * t.cy);
                if ("pie" === i.DS) {
                    (s = i.H ? i.H.I : i.A.I), (A = i.H ? i.H.F : i.A.F);
                    var Z = i.AA + i.B4 + (i.BK - i.B4) * t.hPos,
                        h = ZC.AQ.BN(i.iX, i.iY, i.CO + (i.AI - i.CO) * t.vPos, Z);
                    (u = h[0] - n.width / 2), (p = h[1] - n.height / 2);
                }
                (i.D["pattern-image-id"] = o + "-image"), (i.D["pattern-tx"] = u), (i.D["pattern-ty"] = p), ZC.Q.G4(r, { transform: "translate(" + u + "," + p + ")" });
            }
            var d = ZC.Q.F6("pattern", "http://www.w3.org/2000/svg");
            ZC.Q.G4(d, { x: a ? e.x : 0, y: a ? e.y : 0, width: s, height: A, id: o, patternUnits: a || "pie" === i.DS ? "userSpaceOnUse" : "objectBoundingBox" }),
                i.H.KD.childNodes[0].appendChild(d),
                d.appendChild(r),
                (i.D.imgfill = "url(#" + o + ")");
        },
        WZ: function (e) {
            (null !== e && void 0 !== e) || (e = !1);
            var i,
                t,
                n = this;
            if (n.A0 !== n.AE || ("" !== n.GR && "" !== n.HL)) {
                var a = "" === n.L ? "gradient-" + ZC.SEQ++ : n.L + "-gradient";
                (n.TJ || (e && !ZC.AL(a))) && (e = !1), ZC.A5.browser.msie && 9 === ZC._i_(ZC.A5.browser.version) && (e = !1), ZC.AL(a) && !e && ZC.Q.ET(a);
                var l = n.YD(n.NI);
                if (
                    ("radial" === n.NI
                        ? ((i = e ? ZC.AL(a) : ZC.Q.F6("radialGradient", "http://www.w3.org/2000/svg")), ZC.Q.G4(i, { cx: ZC._i_(l.cx), cy: ZC._i_(l.cy), r: ZC._i_(l.r), fx: ZC._i_(l.cx), fy: ZC._i_(l.cy) }))
                        : "linear" === n.NI && ((i = e ? ZC.AL(a) : ZC.Q.F6("linearGradient", "http://www.w3.org/2000/svg")), ZC.Q.G4(i, { x1: ZC._i_(l.x1), x2: ZC._i_(l.x2), y1: ZC._i_(l.y1), y2: ZC._i_(l.y2) })),
                    !e)
                ) {
                    if ((ZC.Q.G4(i, { id: a, gradientUnits: "userSpaceOnUse" }), n.H.KD.childNodes[0].appendChild(i), "" !== n.GR && "" !== n.HL))
                        for (var o = n.GR.split(/\s+|;/), r = n.HL.split(/\s+|;/), s = 0, A = o.length; s < A; s++) {
                            var C = ZC.AP.G9(o[s], n);
                            "object" != typeof C && (C = [C, n.C6]), (o[s] = C[0]);
                            var c = r[s] || 1;
                            ZC.DT(c, 0, 1) || (c = 1);
                            var u = C[1];
                            (t = o[s]), "-1" === o[s] && ((u = 0), (t = "rgb(255,255,255)"));
                            var p = ZC.Q.F6("stop", "http://www.w3.org/2000/svg");
                            ZC.Q.G4(p, { offset: c, "stop-color": t, "stop-opacity": u }), i.appendChild(p);
                        }
                    else {
                        var Z = 1,
                            h = n.A0;
                        "-1" === n.A0 && ((Z = 0), (h = "rgb(255,255,255)"));
                        var d = ZC.Q.F6("stop", "http://www.w3.org/2000/svg");
                        ZC.Q.G4(d, { offset: 0, "stop-color": h, "stop-opacity": Z });
                        var f = 1,
                            _ = n.AE;
                        "-1" === n.AE && ((f = 0), (_ = "rgb(255,255,255)"));
                        var g = ZC.Q.F6("stop", "http://www.w3.org/2000/svg");
                        ZC.Q.G4(g, { offset: 1, "stop-color": _, "stop-opacity": f }), i.appendChild(d), i.appendChild(g);
                    }
                    n.D.fill = "url(#" + a + ")";
                }
            } else "-1" !== n.A0 && (n.D.fill = n.A0);
        },
        A3B: function () {
            var e = this;
            if ("object" == typeof e.D.imgfill && "undefined" != typeof e.H && e.H) {
                var i = e.A51()[1].split(",");
                if ("circle" === e.DS) e.H.KD.appendChild(ZC.Q.XD({ id: e.L + "_image-clip", cx: i[0], cy: i[1], r: i[2] })), (e.D["clip-path"] = e.L + "_image-clip");
                else if (i.length > 6) {
                    for (var t = "", n = 0, a = i.length; n < a; n += 2) t += ZC._i_(i[n]) + ZC._i_(e.BL) + "," + (ZC._i_(i[n + 1]) + ZC._i_(e.BI)) + " ";
                    e.H.KD.appendChild(ZC.Q.XD({ id: e.L + "_image-clip", path: t })), (e.D["clip-path"] = e.L + "_image-clip");
                }
            }
        },
        VX: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o = this,
                r = o.Z;
            if (("poly" === o.DS || "line" === o.DS ? ((i = o.D2[0] + (o.D2[2] - o.D2[0]) / 2), (t = o.D2[1] + (o.D2[3] - o.D2[1]) / 2)) : ((i = o.iX), (t = o.iY)), (o.D.cx = i), (o.D.cy = t), (o.D.fill = -1), "" !== o.DB)) {
                var s = o.RB();
                o.A2I({ info: s, x: i - s.image.width / 2, y: t - s.image.height / 2 });
            }
            switch ((o.VH && o.A3B(), o.WZ(), o.DS)) {
                case "custom":
                    if ((e = o.o.url)) {
                        var A, C;
                        ZC.cache.data[e] ? (n = ZC.cache.data[e]) : (((n = new Image()).src = e), (ZC.cache.data[e] = n)),
                            (A = e.indexOf(".svg") > 0 && e.indexOf("#") >= 0)
                                ? ((C = ZC.Q.F6("svg", "http://www.w3.org/2000/svg")), ZC.Q.G4(C, { viewBox: "0 0 8 8", fill: o.D.fill }), (l = ZC.Q.F6("use", "http://www.w3.org/2000/svg")))
                                : (l = ZC.Q.F6("image", "http://www.w3.org/2000/svg")),
                            l.setAttributeNS ? l.setAttributeNS("http://www.w3.org/1999/xlink", "href", e) : l.setAttribute("src", e);
                        var c = o.o.width ? o.o.width : n.width,
                            u = o.o.height ? o.o.height : n.height;
                        (n.width = c),
                            (n.height = u),
                            A
                                ? ZC.Q.G4(C, { id: o.L + "-image", x: o.iX - n.width / 2 + o.BL, y: o.iY - n.height / 2 + o.BI, width: n.width, height: n.height })
                                : ZC.Q.G4(l, { id: o.L + "-image", x: o.iX - n.width / 2 + o.BL, y: o.iY - n.height / 2 + o.BI, width: n.width, height: n.height }),
                            A ? (C.appendChild(l), r.appendChild(C)) : r.appendChild(l);
                    }
                    break;
                case "circle":
                    if (
                        !ZC.AL(o.L + "-circle") &&
                        ((a = ZC.Q.F6("circle", "http://www.w3.org/2000/svg")),
                        -1 !== o.D.fill ? ZC.Q.G4(a, { fill: o.D.fill, "fill-opacity": o.C6 }) : ZC.Q.G4(a, { fill: "none" }),
                        o.DH && "" !== o.DH && ZC.Q.G4(a, { class: o.DH }),
                        ZC.Q.G4(a, { id: o.L + "-circle", cx: o.iX + o.BL, cy: o.iY + o.BI, r: o.AI }),
                        o.AU > 0 &&
                            (ZC.Q.G4(a, { stroke: o.BX, "stroke-width": o.AU, "stroke-opacity": o.O0 }),
                            o.KX(o.AU),
                            "solid" === o.GF || (0 === o.EY && 0 === o.GC) || ZC.Q.G4(a, { "stroke-dasharray": "dashdot" === o.GF ? [o.EY, o.GC, o.B0, o.GC].join(" ") : [o.EY, o.GC].join(",") })),
                        o.H && o.H.G2 ? (o.H.G2[r.id] || (o.H.G2[r.id] = document.createDocumentFragment()), o.H.G2[r.id].appendChild(a)) : r.appendChild(a),
                        "undefined" != typeof o.D.imgfill)
                    )
                        if ("string" == typeof o.D.imgfill)
                            (a = ZC.Q.F6("circle", "http://www.w3.org/2000/svg")),
                                ZC.Q.G4(a, { id: o.L + "-imgfill", fill: o.D.imgfill, "fill-opacity": o.C6, cx: o.iX + o.BL, cy: o.iY + o.BI, r: o.AI, "stroke-width": 0 }),
                                o.H && o.H.G2 ? o.H.G2[r.id].appendChild(a) : r.appendChild(a);
                        else {
                            var p = o.D.imgfill;
                            (l = ZC.Q.F6("image", "http://www.w3.org/2000/svg")).setAttributeNS && l.setAttributeNS("http://www.w3.org/1999/xlink", "href", o.DB),
                                o.D["clip-path"] && ZC.Q.G4(l, { "clip-path": "url(#" + o.D["clip-path"] + (ZC.A5.browser.webkit ? "-shape" : "") + ")" }),
                                ZC.Q.G4(l, { id: o.L + "-imgfill", x: p[1], y: p[2], width: p[0].width, height: p[0].height }),
                                r.appendChild(l);
                        }
                    break;
                case "plus":
                case "cross":
                case "line":
                case "ic_line":
                case "arc":
                    o.B0 > 0 && (ZC.CS.setup(r, o), o.o.spline ? ((o.CZ = !1), (o.QQ = !0), ZC.CS.paint(r, o, ZC.CS.smooth(o.E, !1, o.o.direction || "h"))) : ZC.CS.paint(r, o, o.E));
                    break;
                default:
                    var Z = o.B7,
                        h = o.B0;
                    (o.B7 = o.BX), (o.B0 = o.AU), o.KX(), ZC.CS.setup(r, o), ZC.CS.paint(r, o, o.E, !0, 0), (o.B7 = Z), (o.B0 = h), o.KX();
            }
        },
        WY: function (e, i) {
            (null !== i && void 0 !== i) || (i = !1);
            var t,
                n = this;
            if (n.A0 !== n.AE || ("" !== n.GR && "" !== n.HL)) {
                var a = "" === n.L ? "gradient-" + ZC.SEQ++ : n.L + "-gradient";
                if ((i && !ZC.AL(a) && (i = !1), ZC.AL(a) && !i && ZC.A5(a).remove(), (t = i ? ZC.AL(a) : ZC.Q.F6("zcv:fill")), i && (e = ZC.A5("#" + a).attr("focusposition")), "" !== n.GR && "" !== n.HL)) {
                    for (var l = n.GR.split(/\s+|;/), o = n.HL.split(/\s+|;/), r = "", s = "", A = "", C = 0, c = l.length; C < c; C++) {
                        l[C] = ZC.AP.G9(l[C]);
                        var u = "-1" === l[C] ? "rgb(255,255,255)" : l[C],
                            p = o[C] || 1;
                        ZC.DT(p, 0, 1) || (p = 1);
                        var Z = ZC._i_(100 * p);
                        0 === C ? (r = u) : C === c - 1 ? (s = u) : (A += Z + "% " + ZC.AP.G9(u) + ",");
                    }
                    "" !== A && (A = A.substring(0, A.length - 1)),
                        "radial" === n.NI
                            ? ZC.Q.G4(t, { id: a, type: "gradientradial", focusposition: e, color: r, color2: s, colors: A })
                            : "linear" === n.NI && ZC.Q.G4(t, { id: a, type: "gradient", method: "sigma", angle: 270 - n.NA - n.AA, color: r, color2: s, colors: A });
                } else {
                    var h = n.A0;
                    "-1" === n.A0 && (h = "rgb(255,255,255)");
                    var d = n.AE;
                    "-1" === n.AE && (d = "rgb(255,255,255)"),
                        "radial" === n.NI
                            ? ZC.Q.G4(t, { id: a, type: "gradientradial", focusposition: e, color: d, color2: h })
                            : "linear" === n.NI && ZC.Q.G4(t, { id: a, type: "gradient", method: "sigma", angle: 270 - n.NA - n.AA, color: h, color2: d });
                }
                var f = "undefined" != typeof n.D.opacity2 ? n.D.opacity2 : n.C6;
                ZC.Q.G4(t, { opacity: n.C6, "o:opacity2": f }), (n.D.fill = t);
            } else (t = ZC.Q.F6("zcv:fill")), "-1" !== n.A0 && (ZC.Q.G4(t, { type: "solid", color: n.A0, opacity: n.C6 }), (n.D.fill = t));
        },
        VW: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o = this,
                r = o.Z;
            "poly" === o.DS || "line" === o.DS ? ((i = o.D2[0] + (o.D2[2] - o.D2[0]) / 2), (t = o.D2[1] + (o.D2[3] - o.D2[1]) / 2)) : ((i = o.iX), (t = o.iY)), (o.D.cx = i), (o.D.cy = t), (o.D.fill = -1);
            var s = -1 === ZC.AV(["cross", "plus", "arc", "line", "ic_line"], o.DS),
                A = ZC.Q.F6("zcv:fill");
            if ("" !== o.DB) {
                var C = o.RB();
                switch (((n = C.image), o.M7)) {
                    default:
                        (A.type = "tile"), (A.src = o.DB), ZC.Q.G4(A, { position: C.cx + "," + C.cy, opacity: o.C6, "o:opacity2": o.C6 }), (o.D.imgfill = [A]);
                        break;
                    case "no-repeat":
                    case "false":
                    case !1:
                        o.D.imgfill = [n, C.x, C.y];
                }
            }
            o.WY("0,0");
            var c = ZC.Q.F6("zcv:stroke");
            switch (o.DS) {
                case "custom":
                    (e = o.o.url) &&
                        (ZC.cache.data[e] ? (n = ZC.cache.data[e]) : (((n = new Image()).src = e), (ZC.cache.data[e] = n)),
                        ((l = ZC.Q.F6("img")).id = o.L + "-img"),
                        (l.src = e),
                        (l.style.position = "absolute"),
                        1 !== o.KS && ((l.width *= o.KS), (l.height *= o.KS), (l.style.width = l.width + "px"), (l.style.height = l.height + "px")),
                        (l.style.left = o.iX - n.width / 2 + o.BL + "px"),
                        (l.style.top = o.iY - n.height / 2 + o.BI + "px"),
                        r.appendChild(l));
                    break;
                case "plus":
                case "cross":
                case "line":
                case "ic_line":
                case "arc":
                    (c.weight = o.B0 + "px"), (c.color = o.B7);
                    break;
                default:
                    (c.weight = o.AU + "px"), (c.color = o.BX);
            }
            switch (((c.opacity = o.O0), o.GF)) {
                case "solid":
                    c.dashstyle = "solid";
                    break;
                case "dotted":
                    c.dashstyle = "dot";
                    break;
                case "dashed":
                    c.dashstyle = "dash";
            }
            switch ((-1 === ZC.AV(["plus", "cross", "line", "ic_line"], o.DS) && (o.D.stroke = c), o.DS)) {
                case "circle":
                case "arc":
                    if (
                        !ZC.AL(o.L + "-circle") &&
                        (((a = ZC.Q.F6("circle" === o.DS ? "zcv:oval" : "zcv:arc")).id = o.L + "-circle"),
                        (a.style.position = "absolute"),
                        -1 !== o.D.fill && s ? a.appendChild(o.D.fill) : (a.filled = !1),
                        o.AU > 0 || o.B0 > 0 ? a.appendChild(c) : (a.stroked = !1),
                        (a.style.left = o.iX + o.BL - o.AI + "px"),
                        (a.style.top = o.iY + o.BI - o.AI + "px"),
                        (a.style.width = 2 * o.AI + "px"),
                        (a.style.height = 2 * o.AI + "px"),
                        "arc" === o.DS && ZC.Q.G4(a, { startangle: o.BK + 90, endangle: o.B4 + 90 }),
                        r.appendChild(a),
                        s && "undefined" != typeof o.D.imgfill)
                    ) {
                        var u = o.D.imgfill;
                        1 === u.length
                            ? (((a = ZC.Q.F6("zcv:oval")).id = o.L + "-imgfill"),
                              (a.style.position = "absolute"),
                              r.appendChild(a),
                              a.appendChild(u[0]),
                              (a.style.left = o.iX + o.BL - o.AI + "px"),
                              (a.style.top = o.iY + o.BI - o.AI + "px"),
                              (a.style.width = 2 * o.AI + "px"),
                              (a.style.height = 2 * o.AI + "px"),
                              (a.stroked = !1),
                              "arc" === o.DS && ZC.Q.G4(a, { startangle: o.BK + 90, endangle: o.B4 + 90 }))
                            : 3 === u.length &&
                              (((l = ZC.Q.F6("img")).id = o.L + "-img"),
                              (l.src = o.DB),
                              (l.style.position = "absolute"),
                              (l.style.left = u[1] + "px"),
                              (l.style.top = u[2] + "px"),
                              1 !== o.KS && ((l.width *= o.KS), (l.height *= o.KS), (l.style.width = l.width + "px"), (l.style.height = l.height + "px")),
                              r.appendChild(l));
                    }
                    break;
                case "plus":
                case "cross":
                case "line":
                case "ic_line":
                    o.B0 > 0 && (ZC.CS.setup(r, o), o.o.spline ? ((o.CZ = !1), (o.QQ = !0), ZC.CS.paint(r, o, ZC.CS.smooth(o.E, !1, o.o.direction || "h"))) : ZC.CS.paint(r, o, o.E));
                    break;
                default:
                    var p = o.B7,
                        Z = o.B0;
                    (o.B7 = o.BX), (o.B0 = o.AU), o.KX(), ZC.CS.setup(r, o), ZC.CS.paint(r, o, o.E, !0, 0), (o.B7 = p), (o.B0 = Z), o.KX();
            }
        },
    };
    ZC.DU = ZC.D0.CC(DU);
    var HN = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.DS = "box"),
                (i.I = 0),
                (i.F = 0),
                (i.A8L = ""),
                (i.E9 = -1),
                (i.E8 = -1),
                (i.DR = -1),
                (i.DZ = -1),
                (i.F5 = 0),
                (i.FS = 0),
                (i.F2 = 0),
                (i.FE = 0),
                (i.A77 = !1),
                (i.KU = !1),
                (i.EM = "bottom"),
                (i.EW = 0),
                (i.M4 = 0),
                (i.H9 = 8),
                (i.G8 = 8),
                (i.XN = [1, 1]),
                (i.DM = null),
                (i.OK = null),
                (i.Q0 = !1),
                (i.N5 = !0),
                (i.PT = ""),
                (i.OI = ""),
                (i.NP = ""),
                (i.PC = ""),
                (i.WV = "tl"),
                (i.FD = !1);
        },
        getPMap: function () {
            var e = this.b();
            return (
                this.addPMap(
                    e,
                    "width,height,borderRadiusTopLeft,borderRadiusTopRight,borderRadiusBottomRight,borderRadiusBottomLeft,callout,calloutType,calloutPosition,calloutHook,calloutWidth,calloutHeight,calloutOffset,calloutExtension,position,borderTop,borderRight,borderBottom,borderLeft,rectShortcut",
                    "I,F,F5,FS,F2,FE,KU,EM,DM,H9,G8,EW,M4,A8L,PT,OI,NP,PC,FD"
                ),
                e
            );
        },
        build: function () {},
        wh_: function (e, i, t) {
            var n = this;
            if (((i = i || "w"), ZC._f_(e) + "" != e + "")) return -1 !== (e += "").indexOf("%") ? n.wh_(ZC._f_(e.replace("%", "")) / 100, i, !0) : -1 !== e.indexOf("px") ? n.wh_(ZC._f_(e.replace("px", "")), i) : n.wh_(ZC._f_(e), i);
            var a = "undefined" != typeof n.D["p-width"] ? n.D["p-width"] : n.A.I,
                l = "undefined" != typeof n.D["p-height"] ? n.D["p-height"] : n.A.F;
            return (e = ZC._a_(e)) > 1 && !t ? ZC._i_(e) : e <= 1 || t ? ("w" === i ? ZC._i_(a * e) : ZC._i_(l * e)) : void 0;
        },
        m_: function (e, i, t, n, a) {
            var l,
                o,
                r = this;
            if (((t = t || 0), (n = n || 0), (i = i || "all"), (a = a || "n"), "all" === i)) {
                var s = String(e).split(/\s+|;|,/);
                return 1 === s.length
                    ? [r.m_(s[0], "tb", t, n, a), r.m_(s[0], "lr", t, n, a), r.m_(s[0], "tb", t, n, a), r.m_(s[0], "lr", t, n, a)]
                    : 2 === s.length
                    ? [r.m_(s[0], "tb", t, n, a), r.m_(s[1], "lr", t, n, a), r.m_(s[0], "tb", t, n, a), r.m_(s[1], "lr", t, n, a)]
                    : 3 === s.length
                    ? [r.m_(s[0], "tb", t, n, a), r.m_(s[1], "lr", t, n, a), r.m_(s[2], "tb", t, n, a), r.m_(s[1], "lr", t, n, a)]
                    : [r.m_(s[0], "tb", t, n, a), r.m_(s[1], "lr", t, n, a), r.m_(s[2], "tb", t, n, a), r.m_(s[3], "lr", t, n, a)];
            }
            return e + "" == "auto"
                ? -2
                : e + "" == "dynamic" && "y" === a
                ? "dynamic"
                : ZC._f_(e) + "" != e + ""
                ? -1 !== (e += "").indexOf("%")
                    ? r.m_(ZC._f_(e.replace("%", "")) / 100, i)
                    : -1 !== e.indexOf("px")
                    ? r.m_(ZC._f_(e.replace("px", "")), i)
                    : r.m_(ZC._f_(e), i)
                : ((r.A || "undefined" != typeof r.D["p-width"]) && (l = "undefined" != typeof r.D["p-width"] ? r.D["p-width"] : r.A.I),
                  (r.A || "undefined" != typeof r.D["p-height"]) && (o = "undefined" != typeof r.D["p-height"] ? r.D["p-height"] : r.A.F),
                  (e = ZC._a_(e)) >= 1 ? ZC._i_(e) : e < 1 ? ("lr" === i ? ZC._i_((r.A ? l : t) * e) : ZC._i_((r.A ? o : n) * e)) : void 0);
        },
        copy: function (e) {
            this.b(e);
            for (var i = "I,F,E9,DR,DZ,E8,F5,FS,F2,FE,KU,EM,DM,XN,H9,G8,EW,M4,A8L,PT,OI,NP,PC,FD".split(","), t = 0, n = i.length; t < n; t++) "undefined" != typeof e[i[t]] && (this[i[t]] = e[i[t]]);
        },
        locate: function (e) {
            var i,
                t,
                n,
                a,
                l,
                o = this;
            if (2 !== (e = e || 1))
                if (o.TJ)
                    o.assign_a([
                        ["x", "iX"],
                        ["y", "iY"],
                        ["width", "I"],
                        ["height", "F"],
                    ]);
                else {
                    var r = "undefined" != typeof o.D["p-x"] ? o.D["p-x"] : o.A.iX,
                        s = "undefined" != typeof o.D["p-y"] ? o.D["p-y"] : o.A.iY,
                        A = "undefined" != typeof o.D["p-width"] ? o.D["p-width"] : o.A.I,
                        C = "undefined" != typeof o.D["p-height"] ? o.D["p-height"] : o.A.F;
                    if (!o.Q0) {
                        var c = 0,
                            u = 0,
                            p = 0,
                            Z = 0;
                        if (null !== ZC._n_(o.o.margin)) {
                            var h = "" + o.o.margin;
                            if (-1 !== h.indexOf("dynamic")) {
                                var d = o.m_(h, "all", 0, 0, "y");
                                "dynamic" === d[0] && (o.D["d-margin-top"] = o.D["d-margin"] = !0),
                                    "dynamic" === d[1] && (o.D["d-margin-right"] = o.D["d-margin"] = !0),
                                    "dynamic" === d[2] && (o.D["d-margin-bottom"] = o.D["d-margin"] = !0),
                                    "dynamic" === d[3] && (o.D["d-margin-left"] = o.D["d-margin"] = !0),
                                    (o.o.margin = h.replace(/dynamic/g, "20"));
                            }
                        }
                        "dynamic" === o.o.margin && ((o.D["d-margin"] = o.D["d-margin-top"] = o.D["d-margin-right"] = o.D["d-margin-bottom"] = o.D["d-margin-left"] = !0), (o.o.margin = null)),
                            "undefined" == typeof o.D["force-margins"] ||
                                (null !== ZC._n_(o.o["adjust-layout"]) && ZC._b_(o.o["adjust-layout"])) ||
                                (null !== ZC._n_(o.o["margin-top"]) && null === ZC._n_(o.o["margin-bottom"]) && (o.o["margin-bottom"] = "auto"),
                                null !== ZC._n_(o.o["margin-bottom"]) && null === ZC._n_(o.o["margin-top"]) && (o.o["margin-top"] = "auto"),
                                null !== ZC._n_(o.o["margin-left"]) && null === ZC._n_(o.o["margin-right"]) && (o.o["margin-right"] = "auto"),
                                null !== ZC._n_(o.o["margin-right"]) && null === ZC._n_(o.o["margin-left"]) && (o.o["margin-left"] = "auto"));
                        for (var f = ["margin-top", "margin-right", "margin-bottom", "margin-left"], _ = 0, g = f.length; _ < g; _++) "dynamic" === o.o[f[_]] && ((o.D["d-" + f[_]] = o.D["d-margin"] = !0), (o.o[f[_]] = null));
                        null !== (i = ZC._n_(o.o.margin)) &&
                            ((t = o.m_(i, "all")),
                            null === ZC._n_(o.o["margin-top"]) && (c = t[0]),
                            null === ZC._n_(o.o["margin-right"]) && (u = t[1]),
                            null === ZC._n_(o.o["margin-bottom"]) && (p = t[2]),
                            null === ZC._n_(o.o["margin-left"]) && (Z = t[3])),
                            null !== (i = ZC._n_(o.o["margin-top"])) && (c = t = o.m_(i, "tb")),
                            null !== (i = ZC._n_(o.o["margin-right"])) && (u = t = o.m_(i, "lr")),
                            null !== (i = ZC._n_(o.o["margin-bottom"])) && (p = t = o.m_(i, "tb")),
                            null !== (i = ZC._n_(o.o["margin-left"])) && (Z = t = o.m_(i, "lr"));
                        var v,
                            b = [c, u, p, Z];
                        if ((null !== ZC._n_(o.o.x) && (o.iX = o.xy_(o.o.x, "x")), null !== ZC._n_(o.o.y) && (o.iY = o.xy_(o.o.y, "y")), null !== (i = ZC._n_(o.o.width)))) {
                            var B = ZC._p_(i);
                            (v = -1 !== ("" + i).indexOf("%")),
                                (o.I = B > 1 && !v ? ZC._i_(B) : -2 === Z && -2 === u ? ZC._i_(A * B) : -2 === Z && -2 !== u ? ZC._i_((A - u) * B) : -2 !== Z && -2 === u ? ZC._i_((A - Z) * B) : ZC._i_((A - Z - u) * B)),
                                -1 !== o.iX
                                    ? ((o.DZ = o.iX - r), (o.E8 = r + A - o.DZ - o.I))
                                    : -2 === Z && -2 === u
                                    ? ((o.DZ = o.E8 = (A - o.I) / 2), (o.iX = r + o.DZ))
                                    : -2 === Z && -2 !== u
                                    ? ((o.E8 = u), (o.DZ = A - o.E8 - o.I), (o.iX = r + o.DZ))
                                    : ((o.DZ = Z), (o.iX = r + o.DZ), o instanceof ZC.DN ? (o.E8 = u) : (o.E8 = A - o.DZ - o.I));
                        } else
                            -1 !== o.iX
                                ? ((o.DZ = o.iX - r), (o.E8 = -2 === u ? 0 : u), (o.I = A - o.DZ - o.E8))
                                : -2 === Z && -2 === u
                                ? ((o.DZ = o.E8 = 0), (o.iX = r + o.DZ), (o.I = A - o.DZ - o.E8))
                                : -2 === Z && -2 !== u
                                ? ((o.E8 = u), (o.DZ = 0), (o.iX = r + o.DZ), (o.I = A - o.DZ - o.E8))
                                : -2 !== Z && -2 === u
                                ? ((o.DZ = Z), o instanceof ZC.DN ? (o.E8 = u) : (o.E8 = 0), (o.iX = r + o.DZ), (o.I = A - o.DZ - o.E8))
                                : ((o.DZ = Z), (o.E8 = u), (o.iX = r + o.DZ), (o.I = A - o.DZ - o.E8));
                        if (null !== (i = ZC._n_(o.o.height))) {
                            var m = ZC._p_(i);
                            (v = -1 !== ("" + i).indexOf("%")),
                                (o.F = m > 1 && !v ? ZC._i_(m) : -2 === c && -2 === p ? ZC._i_(C * m) : -2 === c && -2 !== p ? ZC._i_((C - p) * m) : -2 !== c && -2 === p ? ZC._i_((C - c) * m) : ZC._i_((C - c - p) * m)),
                                -1 !== o.iY
                                    ? ((o.E9 = o.iY - s), (o.DR = s + C - o.E9 - o.F))
                                    : -2 === c && -2 === p
                                    ? ((o.E9 = o.DR = (C - o.F) / 2), (o.iY = s + o.E9))
                                    : -2 === c && -2 !== p
                                    ? ((o.DR = p), (o.E9 = C - o.DR - o.F), (o.iY = s + o.E9))
                                    : ((o.E9 = c), (o.iY = s + o.E9), o instanceof ZC.DN ? (o.DR = p) : (o.DR = C - o.E9 - o.F));
                        } else
                            -1 !== o.iY
                                ? ((o.E9 = o.iY - s), (o.DR = -2 === p ? 0 : p), (o.F = C - o.E9 - o.DR))
                                : -2 === c && -2 === c
                                ? ((o.E9 = o.E9 = 0), (o.iY = s + o.E9), (o.F = C - o.E9 - o.DR))
                                : -2 === c && -2 !== p
                                ? ((o.DR = p), (o.E9 = 0), (o.iY = s + o.E9), (o.F = C - o.E9 - o.DR))
                                : -2 === c && -2 !== p
                                ? ((o.E9 = c), o instanceof ZC.DN ? (o.DR = p) : (o.DR = 0), (o.iY = s + o.E9), (o.F = C - o.E9 - o.DR))
                                : ((o.E9 = c), (o.DR = p), (o.iY = s + o.E9), (o.F = C - o.E9 - o.DR));
                        if (null !== (i = ZC._n_(o.o.position))) {
                            if (o.A && "undefined" != typeof o.A.iX && "undefined" != typeof o.A.iY && "undefined" != typeof o.A.I && "undefined" != typeof o.A.F) {
                                switch (((n = 0), (a = 0), (l = String(i).split(/\s+/))[0])) {
                                    case "left":
                                        n = 0;
                                        break;
                                    case "right":
                                        n = 1;
                                        break;
                                    case "center":
                                        n = 0.5;
                                        break;
                                    default:
                                        (n = ZC.IJ(l[0])) > 1 && (n /= o.A.I);
                                }
                                switch (l[1]) {
                                    case "top":
                                        a = 0;
                                        break;
                                    case "bottom":
                                        a = 1;
                                        break;
                                    case "middle":
                                        a = 0.5;
                                        break;
                                    default:
                                        (a = ZC.IJ(l[1])) > 1 && (a /= o.A.F);
                                }
                            }
                            (o.D["position-info"] = [n, a]), (o.iX = o.A.iX + ZC._i_(n * (o.A.I - o.I - b[1] - b[3])) + b[3]), (o.iY = o.A.iY + ZC._i_(a * (o.A.F - o.F - b[0] - b[2])) + b[0]);
                        }
                        o.D2 = [o.iX, o.iY, o.iX + o.I, o.iY + o.F];
                    }
                }
        },
        parse: function () {
            this.b();
            var e,
                i = this;
            if (!i.o.tween) {
                if (
                    (i.assign_a([
                        ["anchor", "WV"],
                        ["rect-shortcut", "FD", "b"],
                        ["center-ref", "A77", "b"],
                        ["callout", "KU", "b"],
                        ["callout-type", "ACR"],
                        ["callout-position", "EM"],
                        ["callout-hook", "DM"],
                        ["callout-ratio", "XN"],
                        ["callout-width", "H9", "i"],
                        ["callout-height", "G8", "i"],
                        ["callout-offset", "EW", "i"],
                        ["callout-extension", "M4", "i"],
                        ["border-top", "PT"],
                        ["border-right", "OI"],
                        ["border-bottom", "NP"],
                        ["border-left", "PC"],
                    ]),
                    null !== (e = ZC._n_(i.o["border-radius"])))
                ) {
                    var t = String(e).split(/\s+|;|,/);
                    2 === t.length
                        ? ((i.F5 = i.FS = ZC._i_(t[0])), (i.F2 = i.FE = ZC._i_(t[1])))
                        : 4 === t.length
                        ? ((i.F5 = ZC._i_(t[0])), (i.FS = ZC._i_(t[1])), (i.F2 = ZC._i_(t[2])), (i.FE = ZC._i_(t[3])))
                        : (i.F5 = i.FS = i.F2 = i.FE = ZC._i_(t[0]));
                }
                null !== ZC._n_(i.o["callout-tip"]) && (i.OK = new ZC.DU(i.A)),
                    i.assign_a([
                        ["border-radius-top-left", "F5", "i"],
                        ["border-radius-top-right", "FS", "i"],
                        ["border-radius-bottom-right", "F2", "i"],
                        ["border-radius-bottom-left", "FE", "i"],
                    ]);
            }
        },
        WH: function (e) {
            var i = e.split(/\s/);
            return (i[0] = ZC._i_(i[0])), (i[2] = ZC.AP.G9(i[2])), i;
        },
        paint: function () {
            var e = this;
            if (null !== e.DM && !(e.DM instanceof Array) && "zcgraph" === e.A.O8) {
                var i = e.A.UU(e.DM);
                (e.DM = [i[0], i[1]]), (e.DM[0] -= e.BL), (e.DM[1] -= e.BI);
            }
            if ((e.A77 && ((e.iX -= e.I / 2), (e.iY -= e.F / 2)), ("-1" !== e.BX && 0 !== e.AU) || e.PT + e.OI + e.NP + e.PC !== "" || "-1" !== e.A0 || "-1" !== e.AE || "" !== e.DB || "" !== e.GR || "" !== e.HL)) {
                var t,
                    n = e.H.AC;
                e.M9 && e.C7 && e.A9J();
                var a = { x: "iX", y: "iY", width: "I", height: "F" };
                if (e.o["bottom-state"] && !e.Y6 && !e.bIsBottom && !e.VN) {
                    var l = new ZC.HN(e.A);
                    for (t in (l.copy(e),
                    (l.bIsBottom = !0),
                    (l.M9 = !1),
                    (l.Z = e.Z),
                    (l.WV = e.WV),
                    l.append({ x: e.iX - e.A.iX, y: e.iY - e.A.iY, width: e.I, height: e.F }),
                    l.append(e.o["bottom-state"]),
                    (l.L = e.L + "-bottom"),
                    l.parse(),
                    l.setAnchor(),
                    !1,
                    a))
                        null === ZC._n_(l.o[t]) || (-1 === ("" + l.o[t]).indexOf("+") && -1 === ("" + l.o[t]).indexOf("-")) || ((l[a[t]] = e[a[t]] + ZC._i_(l.o[t])), !0);
                    l.paint();
                }
                if (e.PT + e.OI + e.NP + e.PC === "") {
                    switch (n) {
                        case "canvas":
                            e.A1P();
                            break;
                        case "svg":
                            e.VX();
                            break;
                        case "vml":
                            e.VW();
                    }
                    if (e.KU && e.OK) {
                        var o, r;
                        if (
                            (e.DM && 2 === e.DM.length ? ((o = e.DM[0]), (r = e.DM[1])) : e.D.cp && ((o = e.D.cp[0]), (r = e.D.cp[1])),
                            (e.OK.Z = e.OK.C7 = e.Z),
                            e.OK.copy(e),
                            e.OK.append(e.o["callout-tip"]),
                            (e.OK.L = e.L + "-callout-tip"),
                            (e.OK.o.x = o),
                            (e.OK.o.y = r),
                            e.D.cm)
                        ) {
                            var s = e.D.cm[0],
                                A = e.D.cm[1],
                                C = Math.atan2(ZC._i_(A) - ZC._i_(r), ZC._i_(s) - ZC._i_(o));
                            isNaN(C) && (C = 0), null === ZC._n_(e.OK.o.angle) && (e.OK.o.angle = ZC.TN(C));
                        }
                        e.OK.parse(), e.OK.paint();
                    }
                } else {
                    var c = e.AU,
                        u = e.BX,
                        p = e.GF;
                    switch (((e.AU = 0), n)) {
                        case "canvas":
                            e.A1P();
                            break;
                        case "svg":
                            e.VX();
                            break;
                        case "vml":
                            e.VW();
                    }
                    e.AU = c;
                    var Z = e.A0,
                        h = e.AE;
                    e.A0 = e.AE = "-1";
                    for (var d, f = ["top", "right", "bottom", "left"], _ = ["PT", "OI", "NP", "PC"], g = 0; g < f.length; g++)
                        if ("" !== (d = e[_[g]]) && "none" !== d) {
                            var v = e.WH(d);
                            switch (((e.AU = v[0]), (e.GF = v[1]), (e.BX = v[2]), n)) {
                                case "canvas":
                                    e.A1P(f[g]);
                                    break;
                                case "svg":
                                    e.VX(f[g]);
                                    break;
                                case "vml":
                                    e.VW(f[g]);
                            }
                            (e.AU = c), (e.BX = u), (e.GF = p);
                        }
                    (e.A0 = Z), (e.AE = h);
                }
                if (e.o["top-state"] && !e.Y6 && !e.VN && !e.bIsBottom) {
                    var b = new ZC.HN(e.A);
                    for (t in (b.copy(e),
                    (b.VN = !0),
                    (b.M9 = !1),
                    (b.Z = e.Z),
                    (b.WV = e.WV),
                    b.append({ x: e.iX - e.A.iX, y: e.iY - e.A.iY, width: e.I, height: e.F }),
                    b.append(e.o["top-state"]),
                    (b.L = e.L + "-top"),
                    b.parse(),
                    b.setAnchor(),
                    !1,
                    a))
                        null === ZC._n_(b.o[t]) || (-1 === ("" + b.o[t]).indexOf("+") && -1 === ("" + b.o[t]).indexOf("-")) || ((b[a[t]] = e[a[t]] + ZC._i_(b.o[t])), !0);
                    b.paint();
                }
            }
        },
        setAnchor: function () {
            var e = this;
            switch (e.WV) {
                case "tl":
                    break;
                case "tr":
                    e.iX -= e.I;
                    break;
                case "bl":
                    e.iY -= e.F;
                    break;
                case "br":
                    (e.iX -= e.I), (e.iY -= e.F);
                    break;
                case "c":
                    (e.iX -= e.I / 2), (e.iY -= e.F / 2);
                    break;
                case "t":
                    e.iX -= e.I / 2;
                    break;
                case "r":
                    (e.iX -= e.I), (e.iY -= e.F / 2);
                    break;
                case "b":
                    (e.iX -= e.I / 2), (e.iY -= e.F);
                    break;
                case "l":
                    e.iY -= e.F / 2;
            }
        },
        A9J: function () {
            var e = this,
                i = new ZC.HN(e.A);
            (i.L = e.L + "-sh"), i.copy(e), (i.Z = e.C7), (i.M9 = !1), (i.Y6 = !0), (i.PT = i.OI = i.NP = i.PC = ""), (i.A0 = i.AE = i.RZ), (i.GR = i.HL = ""), (i.DB = ""), (i.GF = "solid"), (i.BX = i.RZ), (i.B0 = 0);
            var t = e.JV * ZC.EH(e.OH),
                n = e.JV * ZC.EP(e.OH);
            (i.I = e.I + ("vml" === e.H.AC ? 0 : 0.5) - (ZC.EH(e.OH) * e.P4) / 2),
                (i.F = e.F + ("vml" === e.H.AC ? 0 : 0.5) - (ZC.EP(e.OH) * e.P4) / 2),
                (i.O0 = i.C6 = i.T6 * e.C6),
                (i.L = e.L + "-sh"),
                (i.iX = e.iX + ZC._i_(t)),
                (i.iY = e.iY + ZC._i_(n)),
                i.paint();
        },
        YD: function (e) {
            var i,
                t = this,
                n = t.iX,
                a = t.iY,
                l = n + t.I / 2,
                o = a + t.F / 2,
                r = t.VO,
                s = t.W5;
            if ((ZC._a_(r) <= 1 && (r = (r * t.I) / 2), ZC._a_(s) <= 1 && (s = (s * t.F) / 2), (l += r), (o += s), "radial" === e)) {
                var A = ZC._i_((t.I + t.F) / 2),
                    C = ZC.CY(t.I, t.F);
                return (i = C < A / 4 ? (C + A) / 2 : C), { cx: l, cy: o, r: ZC._a_(i) };
            }
            if ("linear" === e) {
                var c = (i = t.I >= t.F ? (ZC._a_(ZC.EP(t.NA)) > 0.5 ? t.F / 2 : t.I / 2) : ZC._a_(ZC.EH(t.NA)) > 0.5 ? t.I / 2 : t.F / 2) * ZC.EH(t.NA),
                    u = i * ZC.EP(t.NA);
                return { x1: l - c, y1: o - u, x2: l + c, y2: o + u };
            }
        },
        W0: function (e) {
            var i,
                t = this;
            void 0 === e && (e = "all");
            var n,
                a,
                l = t.iX,
                o = t.iY;
            (t.E = []), (n = a = t.AU / 2);
            var r = 1;
            switch (t.H.AC) {
                case "vml":
                    (r = 2), t.AU % 2 == 1 && ((n = ZC._i_((t.AU - 1) / 2)), (a = ZC._i_((t.AU + 1) / 2)));
            }
            var s = null,
                A = ZC._x_(l + n, 2),
                C = ZC._x_(l - a, 2),
                c = ZC._x_(o + n, 2),
                u = ZC._x_(o - a, 2),
                p = t.DM && 2 === t.DM.length,
                Z = ZC._i_((t.EW * (t.I - t.H9)) / 100),
                h = ZC._i_((t.EW * (t.F - t.G8)) / 100),
                d = 0 !== t.F5 || 0 !== t.FS || 0 !== t.F2 || 0 !== t.FE,
                f = t.XN[0],
                _ = t.XN[1];
            switch (t.EM) {
                case "top":
                    t.D.cm = [t.iX + t.I / 2 + Z, t.iY];
                    break;
                case "bottom":
                    t.D.cm = [t.iX + t.I / 2 + Z, t.iY + t.F];
                    break;
                case "left":
                    t.D.cm = [t.iX, t.iY + t.F / 2 + h];
                    break;
                case "right":
                    t.D.cm = [t.iX + t.I, t.iY + t.F / 2 + h];
            }
            if (d) {
                var g,
                    v = ZC.CY(t.I / 2, t.F / 2);
                ("top" !== e && "all" !== e) ||
                    (0 !== t.F5 ? ((g = t.I / 2 >= t.F5 && t.F / 2 >= t.F5 ? ZC._a_(t.F5) : v), t.E.push([A, c + g]), t.F5 > 0 && t.E.push([A, c, A + r * g, c]), t.E.push([A + g, c])) : t.E.push([A, c]),
                    t.KU &&
                        "top" === t.EM &&
                        (t.E.push([A + t.I / 2 - (f * t.H9) / 2 - t.AU / 2 + Z, c]),
                        p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [A + t.I / 2 - t.AU / 2 + Z, c - t.G8]), t.E.push(s)),
                        t.M4 > 0 && ((i = t.E[t.E.length - 1]), t.E.push([i[0], i[1] - t.M4 * (t.G8 > 0 ? 1 : -1)]), t.E.push([i[0], i[1]])),
                        t.E.push([A + t.I / 2 - t.AU / 2 + (_ * t.H9) / 2 + Z, c])),
                    "top" === e && (0 !== t.FS ? ((g = t.I / 2 >= t.FS && t.F / 2 >= t.FS ? ZC._a_(t.FS) : v), t.E.push([C + t.I - g, c])) : t.E.push([C + t.I, c]))),
                    ("right" !== e && "all" !== e) ||
                        (0 !== t.FS ? ((g = t.I / 2 >= t.FS && t.F / 2 >= t.FS ? ZC._a_(t.FS) : v), t.E.push([C + t.I - g, c]), t.FS > 0 ? t.E.push([C + t.I, c, C + t.I, c + r * g]) : t.E.push([C + t.I, c + g])) : t.E.push([C + t.I, c]),
                        t.KU &&
                            "right" === t.EM &&
                            (t.E.push([C + t.I, c + t.F / 2 - (f * t.G8) / 2 - t.AU / 2 + h]),
                            p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [C + t.I + t.H9, c + t.F / 2 - t.AU / 2 + h]), t.E.push(s)),
                            t.E.push([C + t.I, c + t.F / 2 + (_ * t.G8) / 2 - t.AU / 2 + h])),
                        "right" === e && (0 !== t.F2 ? ((g = t.I / 2 >= t.F2 && t.F / 2 >= t.F2 ? ZC._a_(t.F2) : v), t.E.push([C + t.I, u + t.F - g])) : t.E.push([C + t.I, u + t.F]))),
                    ("bottom" !== e && "all" !== e) ||
                        (0 !== t.F2
                            ? ((g = t.I / 2 >= t.F2 && t.F / 2 >= t.F2 ? ZC._a_(t.F2) : v), t.E.push([C + t.I, u + t.F - g]), t.F2 > 0 ? t.E.push([C + t.I, u + t.F, C + t.I - r * g, u + t.F]) : t.E.push([C + t.I - g, u + t.F]))
                            : t.E.push([C + t.I, u + t.F]),
                        t.KU &&
                            "bottom" === t.EM &&
                            (t.E.push([C + t.I / 2 + (f * t.H9) / 2 + t.AU / 2 + Z, u + t.F]),
                            p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [C + t.I / 2 + t.AU / 2 + Z, u + t.F + t.G8]), t.E.push(s)),
                            t.M4 > 0 && ((i = t.E[t.E.length - 1]), t.E.push([i[0], i[1] + t.M4 * (t.G8 > 0 ? 1 : -1)]), t.E.push([i[0], i[1]])),
                            t.E.push([C + t.I / 2 - (_ * t.H9) / 2 + t.AU / 2 + Z, u + t.F])),
                        "bottom" === e && (0 !== t.FE ? ((g = t.I / 2 >= t.FE && t.F / 2 >= t.FE ? ZC._a_(t.FE) : v), t.E.push([A + g, u + t.F])) : t.E.push([A, u + t.F]))),
                    ("left" !== e && "all" !== e) ||
                        (0 !== t.FE ? ((g = t.I / 2 >= t.FE && t.F / 2 >= t.FE ? ZC._a_(t.FE) : v), t.E.push([A + g, u + t.F]), t.FE > 0 ? t.E.push([A, u + t.F, A, u + t.F - r * g]) : t.E.push([A, u + t.F - g])) : t.E.push([A, u + t.F]),
                        t.KU &&
                            "left" === t.EM &&
                            (t.E.push([A, u + t.F / 2 + (f * t.G8) / 2 + t.AU / 2 + h]),
                            p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [A - t.H9, u + t.F / 2 + t.AU / 2 + h]), t.E.push(s)),
                            t.E.push([A, u + t.F / 2 - (_ * t.G8) / 2 + t.AU / 2 + h])),
                        0 !== t.F5 ? ((g = t.I / 2 >= t.F5 && t.F / 2 >= t.F5 ? ZC._a_(t.F5) : v), t.E.push([A, c + g])) : (t.E.push([A, c]), t.E.push([A + 0.1, c])));
            } else
                ("top" !== e && "all" !== e) ||
                    ("top" === e ? t.E.push([A + 0.5, c + 0.5]) : t.E.push([A, c]),
                    t.KU &&
                        "top" === t.EM &&
                        (t.E.push([A + t.I / 2 - (f * t.H9) / 2 - t.AU / 2 + Z, c]),
                        p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [A + t.I / 2 - t.AU / 2 + Z, c - t.G8]), t.E.push(s)),
                        t.M4 > 0 && ((i = t.E[t.E.length - 1]), t.E.push([i[0], i[1] - t.M4 * (t.G8 > 0 ? 1 : -1)]), t.E.push([i[0], i[1]])),
                        t.E.push([A + t.I / 2 + (_ * t.H9) / 2 - t.AU / 2 + Z, c])),
                    "top" === e && t.E.push([C + t.I + 0.5, c + 0.5])),
                    ("right" !== e && "all" !== e) ||
                        ("right" === e ? t.E.push([C + t.I + 0.5, c + 0.5]) : t.E.push([C + t.I, c]),
                        t.KU &&
                            "right" === t.EM &&
                            (t.E.push([C + t.I, c + t.F / 2 - t.AU / 2 - (f * t.G8) / 2 + h]),
                            p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [C + t.I + t.H9, c + t.F / 2 - t.AU / 2 + h]), t.E.push(s)),
                            t.E.push([C + t.I, c + t.F / 2 - t.AU / 2 + (_ * t.G8) / 2 + h])),
                        "right" === e && t.E.push([C + t.I + 0.5, u + t.F + 0.5])),
                    ("bottom" !== e && "all" !== e) ||
                        ("bottom" === e ? t.E.push([C + t.I + 0.5, u + t.F + 0.5]) : t.E.push([C + t.I, u + t.F]),
                        t.KU &&
                            "bottom" === t.EM &&
                            (t.E.push([C + t.I / 2 + (f * t.H9) / 2 + t.AU / 2 + Z, u + t.F]),
                            p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [C + t.I / 2 + t.AU / 2 + Z, u + t.F + t.G8]), t.E.push(s)),
                            t.M4 > 0 && ((i = t.E[t.E.length - 1]), t.E.push([i[0], i[1] + t.M4 * (t.G8 > 0 ? 1 : -1)]), t.E.push([i[0], i[1]])),
                            t.E.push([C + t.I / 2 - (_ * t.H9) / 2 + t.AU / 2 + Z, u + t.F])),
                        "bottom" === e && t.E.push([A + 0.5, u + t.F + 0.5])),
                    ("left" !== e && "all" !== e) ||
                        ("left" === e ? t.E.push([A + 0.5, u + t.F + 0.5]) : t.E.push([A, u + t.F]),
                        t.KU &&
                            "left" === t.EM &&
                            (t.E.push([A, u + t.F / 2 + t.AU / 2 + (f * t.G8) / 2 + h]),
                            p ? t.E.push([t.DM[0], t.DM[1]]) : ((s = [A - t.H9, u + t.F / 2 + t.AU / 2 + h]), t.E.push(s)),
                            t.E.push([A, u + t.F / 2 + t.AU / 2 - (_ * t.G8) / 2 + h])),
                        "left" === e ? t.E.push([A + 0.5, c + 0.5]) : (t.E.push([A, c]), t.E.push([A + 0.1, c])));
            s && (t.D.cp = s);
        },
        A1P: function (e) {
            e = e || "all";
            var i,
                t,
                n,
                a = this,
                l = a.Z.getContext("2d");
            l.save(), (l.globalCompositeOperation = a.A0Y);
            var o = a.iX,
                r = a.iY,
                s = a.A1E(),
                A = s.bc,
                C = s.bgc1,
                c = s.bgc2;
            if ("all" === e)
                if (C !== c || ("" !== a.GR && "" !== a.HL)) {
                    var u = a.YD(a.NI);
                    "radial" === a.NI
                        ? (i = l.createRadialGradient(u.cx, u.cy, 1, u.cx, u.cy, u.r))
                        : "linear" === a.NI && ((u.x1 = isNaN(u.x1) ? 0 : u.x1), (u.x2 = isNaN(u.x2) ? 0 : u.x2), (u.y1 = isNaN(u.y1) ? 0 : u.y1), (u.y2 = isNaN(u.y2) ? 0 : u.y2), (i = l.createLinearGradient(u.x1, u.y1, u.x2, u.y2))),
                        "" !== a.GR && "" !== a.HL ? a.ZF(i) : (i.addColorStop(0, C), i.addColorStop(1, c)),
                        (l.fillStyle = i);
                } else "" !== a.DB && -1 !== ZC.AV(["repeat", "true", !0], a.M7) && "-1" === a.A0 && "-1" === a.AE && (C = "rgba(255,255,255,0)"), (l.fillStyle = C);
            (l.strokeStyle = A), (l.lineWidth = a.AU), l.translate(a.BL, a.BI), 0 !== a.AA && (l.translate(o + a.I / 2, r + a.F / 2), l.rotate(ZC.T8(a.AA)), l.translate(-(o + a.I / 2), -(r + a.F / 2))), l.beginPath(), a.W0(e);
            var p = a.F5 + a.FS + a.F2 + a.FE !== 0;
            (n = a.B0), (a.B0 = a.AU);
            var Z = a.GF;
            if (((a.GF = ""), a.KX(), ZC.CS.contour(l, a, a.E), (a.B0 = n), (a.GF = Z), a.KX(), "all" === e))
                if ("" !== a.DB && -1 === ZC.AV(ZC.IMG404, a.DB)) {
                    l.fill(), l.save(), l.clip();
                    var h = l.globalAlpha;
                    l.globalAlpha = a.C6;
                    var d = a.RB(),
                        f = d.image;
                    switch (a.M7) {
                        default:
                            l.translate(a.iX, a.iY), (t = l.createPattern(f, "repeat")), (l.fillStyle = t), l.fill(), l.translate(-d.x, -d.y);
                            break;
                        case "no-repeat":
                        case "false":
                        case !1:
                            l.drawImage(f, d.x - a.BL, d.y - a.BI, a.D["bg-image-width"], a.D["bg-image-height"]);
                    }
                    (l.globalAlpha = h), l.restore();
                } else l.fill();
            if (a.AU > 0) {
                var _ = a.B7;
                (n = a.B0),
                    (a.B7 = a.BX),
                    (a.B0 = a.AU),
                    a.KX(),
                    ZC.CS.setup(l, a),
                    (a.T1 = p ? "round" : "square"),
                    a.EY + a.GC > 0 && (a.T1 = "butt"),
                    (a.A01 = p ? "round" : "miter"),
                    (a.D["skip-top"] = !0),
                    (a.D.border = e),
                    ZC.CS.paint(l, a, a.E, !0),
                    (a.B7 = _),
                    (a.B0 = n),
                    a.KX();
            }
            l.closePath(), l.restore();
        },
        VX: function (e) {
            e = e || "all";
            var i = this,
                t = i.Z;
            i.D.fill = -1;
            var n = !1;
            if ("all" === e) {
                if ("" !== i.DB && -1 === ZC.AV(ZC.IMG404, i.DB)) {
                    var a = i.RB();
                    i.A2I({ info: a, x: i.iX, y: i.iY }), (n = !0);
                }
                i.WZ();
            }
            if ((i.W0(e), n && "repeat" !== i.M7 && i.KU)) {
                var l = 0,
                    o = 0;
                i.D2[1] < i.iY && (o = i.D2[3] - i.D2[1] - i.F),
                    i.D2[0] < i.iX && (l = i.D2[2] - i.D2[0] - i.I),
                    null === ZC._n_(i.D["pattern-tx"]) ? (i.D["pattern-tx"] = l) : (i.D["pattern-tx"] += l),
                    null === ZC._n_(i.D["pattern-ty"]) ? (i.D["pattern-ty"] = o) : (i.D["pattern-ty"] += o),
                    ZC.Q.G4(ZC.AL(i.D["pattern-image-id"]), { transform: "translate(" + i.D["pattern-tx"] + "," + i.D["pattern-ty"] + ")" });
            }
            var r = i.F5 + i.FS + i.F2 + i.FE !== 0;
            (i.D.cx = i.iX + i.I / 2), (i.D.cy = i.iY + i.F / 2), i.VH && i.A3B();
            var s = i.B7,
                A = i.B0;
            (i.B7 = i.BX), (i.B0 = i.AU), i.KX(), ZC.CS.setup(t, i), (i.T1 = r ? "round" : "square"), i.EY + i.GC > 0 && (i.T1 = "butt"), (i.A01 = r ? "round" : "miter");
            var C = !1;
            ZC.A5.browser.msie || !i.FD || i.KU || "" !== i.PT || "" !== i.OI || "" !== i.NP || "" !== i.PC || 0 !== i.F5 || 0 !== i.FS || 0 !== i.F2 || 0 !== i.FE || (C = !0),
                (i.D["skip-top"] = !0),
                (i.D.border = e),
                ZC.CS.paint(t, i, i.E, !0, null, C),
                (i.B7 = s),
                (i.B0 = A),
                i.KX();
        },
        VW: function (e) {
            e = e || "all";
            var i = this,
                t = i.Z;
            if ("all" === e) {
                var n = ZC.Q.F6("zcv:fill");
                if ("" !== i.DB && -1 === ZC.AV(ZC.IMG404, i.DB)) {
                    var a = i.RB(),
                        l = a.image;
                    switch (i.M7) {
                        default:
                            (n.type = "tile"), (n.src = i.DB), ZC.Q.G4(n, { position: a.cx + "," + a.cy, opacity: i.C6, "o:opacity2": i.C6 }), (i.D.imgfill = [n]);
                            break;
                        case "no-repeat":
                        case "false":
                        case !1:
                            i.D.imgfill = [l, a.x, a.y];
                    }
                }
                i.WY("0.5,0.5");
            }
            var o = ZC.Q.F6("zcv:stroke");
            switch (((o.weight = i.AU + "px"), (o.color = i.BX), (o.opacity = i.C6), i.GF)) {
                case "solid":
                    o.dashstyle = "solid";
                    break;
                case "dotted":
                    o.dashstyle = "dot";
                    break;
                case "dashed":
                    o.dashstyle = "dash";
            }
            (i.D.stroke = o), i.W0(e);
            var r = i.F5 + i.FS + i.F2 + i.FE !== 0;
            (i.D.cx = i.iX + i.I / 2), (i.D.cy = i.iY + i.F / 2);
            var s = i.B7,
                A = i.B0;
            (i.B7 = i.BX),
                (i.B0 = i.AU),
                i.KX(),
                ZC.CS.setup(t, i),
                (i.T1 = r ? "round" : "square"),
                i.EY + i.GC > 0 && (i.T1 = "butt"),
                (i.A01 = r ? "round" : "miter"),
                (i.D.border = e),
                ZC.CS.paint(t, i, i.E, "all" === e),
                (i.B7 = s),
                (i.B0 = A),
                i.KX();
        },
    };
    ZC.HN = ZC.DU.CC(HN);
    var P0 = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.WW = null), (i.BG = null), (i.M = null), (i.SL = null), (i.A7 = null), (i.K8 = !1), (i.O7 = !1), (i.KZ = !1), (i.A61 = !1);
        },
        parse: function () {
            var e,
                i = this;
            (i.BG = zingchart.pool.getInstance("box" === i.WW.type ? "HN" : "DU", i.A, i.L + "-shape", i.WW.tween)),
                i.BG.append(i.WW),
                (i.BG.iX = i.iX),
                (i.BG.iY = i.iY),
                (i.BG.L = i.L + "-gshape"),
                (i.BG.O7 = i.O7),
                i.A61 || null === ZC._n_((e = i.BG.o.points)) || ((i.BG.o.points = ZC.AP.A5A(e, i.A.iX, i.A.iY)), (i.A61 = !0)),
                i.BG.parse(),
                null !== ZC._n_((e = i.BG.o.label)) &&
                    null !== ZC._n_(e.text) &&
                    "" !== e.text &&
                    ("undefined" == typeof e.visible || ZC._b_(e.visible)) &&
                    ((i.M = zingchart.pool.getInstance("DN", i, i.A.L + "-shape-label-" + i.H8, ZC.objmove)), ZC.objmove || i.M.append(e)),
                null !== ZC._n_((e = i.BG.o["static"])) && (i.K8 = ZC._b_(e)),
                null !== ZC._n_((e = i.BG.o.flat)) && (i.K8 = ZC._b_(e)),
                null !== ZC._n_((e = i.BG.o.dynamic)) && (i.KZ = ZC._b_(e)),
                null !== ZC._n_((e = i.BG.o.connector)) && ((i.SL = new ZC.DU(i)), i.SL.append(e), i.SL.parse());
        },
        paint: function () {
            var e,
                i = this;
            if (((i.BG.Z = i.Z), (i.BG.C7 = i.C7), i.BG.locate(2), (i.BG.VN = !1), "box" === i.BG.o.type && ((i.iX -= i.BG.I / 2), (i.iY -= i.BG.F / 2), (i.BG.iX -= i.BG.I / 2), (i.BG.iY -= i.BG.F / 2)), i.BG.paint(), i.M)) {
                if (((i.M.Z = i.M.C7 = i.Z), (i.M.IL = ZC.AL(i.A.A.L + "-text")), (i.M.L = i.A.L + "-shape-label-" + i.H8), (i.M.GL = i.A.L + "-shape-label zc-shape-label"), (i.M.o.anchor = i.M.o.anchor || "c"), !i.WW["map-item"]))
                    switch (i.DS) {
                        default:
                            (i.M.o.x = i.iX), (i.M.o.y = i.iY);
                            break;
                        case "line":
                        case "poly":
                        case "rect":
                        case "rectangle":
                            (i.M.o.x = ZC._i_((i.BG.D2[0] + i.BG.D2[2]) / 2)), (i.M.o.y = ZC._i_((i.BG.D2[1] + i.BG.D2[3]) / 2));
                    }
                if ((ZC.objmove || i.M.parse(), (i.M.iX = i.M.iX + i.BG.BL), (i.M.iY = i.M.iY + i.BG.BI), i.M.AN)) {
                    if (i.SL && i.SL.E.length > 0) {
                        if (!ZC.AL(i.A.L + "-objects-front")) {
                            var t = i.A.A.I + "/" + i.A.A.F;
                            ZC.Q.JZ({ cls: "zc-abs", wh: t, id: i.A.L + "-objects-front", p: ZC.AL(i.A.A.L + "-objects-front") }, i.A.A.AC),
                                ZC.Q.HE({ cls: "zc-abs zc-layer", id: i.A.L + "-objects-front-c", p: ZC.AL(i.A.L + "-objects-front"), wh: t }, i.A.A.AC);
                        }
                        var n = i.SL.E,
                            a = i.SL.o.anchor || "",
                            l = n[n.length - 1];
                        switch (a) {
                            case "l":
                                (i.M.iX = l[0] + i.BG.BL), (i.M.iY = l[1] - i.M.F / 2 + i.BG.BI);
                                break;
                            case "r":
                                (i.M.iX = l[0] - i.M.I + i.BG.BL), (i.M.iY = l[1] - i.M.F / 2 + i.BG.BI);
                                break;
                            case "t":
                                (i.M.iX = l[0] - i.M.I / 2 + i.BG.BL), (i.M.iY = l[1] + i.BG.BI);
                                break;
                            case "b":
                                (i.M.iX = l[0] - i.M.I / 2 + i.BG.BL), (i.M.iY = l[1] - i.M.F + i.BG.BI);
                                break;
                            default:
                                (i.M.iX = l[0] - i.M.I / 2 + i.BG.BL), (i.M.iY = l[1] - i.M.F / 2 + i.BG.BI);
                        }
                        (e = ZC.Q.EB(ZC.AL(i.A.L + "-objects-front-c"), i.A.H.AC)), ZC.CS.setup(e, i.SL), ZC.CS.paint(e, i.SL, n);
                    }
                    if (((i.M.VN = !1), i.WW["map-item"] && ((i.M.GL = i.A.L + "-mapshape-label zc-mapshape-label"), i.M.iX < i.A.iX || i.M.iX + i.M.I > i.A.iX + i.A.I || i.M.iY < i.A.iY || i.M.iY + i.M.F > i.A.iY + i.A.F))) return;
                    i.M.paint(), i.D["print-canvas"] ? i.M.EL(ZC.AL(i.D["print-canvas"])) : i.M.EL();
                }
            }
        },
    };
    ZC.P0 = ZC.DU.CC(P0);
    var DN = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.IL = null),
                (i.GL = ""),
                (i.AM = null),
                (i.OD = "center"),
                (i.JY = "middle"),
                (i.DJ = zingchart.FONTSIZE),
                (i.GH = zingchart.FONTFAMILY),
                (i.C2 = "#000"),
                (i.A97 = !1),
                (i.N7 = !1),
                (i.QW = !1),
                (i.KA = "none"),
                (i.sFontWeight = "normal"),
                (i.YB = 0),
                (i.FM = 2),
                (i.FN = 2),
                (i.FT = 2),
                (i.EQ = 2),
                (i.A8J = !1),
                (i.A29 = !1),
                (i.FI = -1),
                (i.KC = 0),
                (i.NM = 0),
                (i.OO = ZC.MAX),
                (i.bRTL = !1),
                (i.A1S = !0),
                (i.V2 = zingchart.FASTWIDTH),
                (i.A63 = 1.65),
                (i.UV = 1),
                (i.VP = !1),
                (i.A7 = null),
                (i.V9 = !1),
                (i.A5L = !1);
        },
        getPMap: function () {
            var e = this.b();
            return (
                this.addPMap(
                    e,
                    "textAlign,verticalAlign,fontSize,fontFamily,color,bold,fontWeight,italic,underline,textDecoration,paddingTop,paddingRight,paddingBottom,paddingLeft,text",
                    "OD,JY,DJ,GH,C2,A97,sFontWeight,N7,QW,KA,FM,FN,FT,EQ,AM"
                ),
                e
            );
        },
        copy: function (e) {
            this.b(e);
            for (var i = "OD,JY,DJ,GH,C2,A97,sFontWeight,N7,KA,QW,FM,FN,FT,EQ,AM".split(","), t = 0, n = i.length; t < n; t++) "undefined" != typeof e[i[t]] && (this[i[t]] = e[i[t]]);
        },
        overrideFormat: function (e) {
            for (var i = ["decimals", "thousands-separator", "decimals-separator"], t = 0; t < i.length; t++) e[i[t]] = "undefined" != typeof this.o[i[t]] ? this.o[i[t]] : e[i[t]];
            return e;
        },
        JT: function (e) {
            return e;
        },
        isBold: function (e) {
            return "bold" === e || "bolder" === e || "500" === e || "600" === e || "700" === e || "800" === e || "900" === e;
        },
        cwidth: function (e) {
            var i = this;
            if (i.V2) return (e.replace(/(<([^>]+)>)/gi, "").length * i.DJ) / (i.A63 * (i.isBold(i.sFontWeight) ? 0.87 : 1) * (i.N7 ? 0.95 : 1));
            var t = "";
            return "undefined" != typeof i.o["html-mode"] && ZC._b_(i.o["html-mode"]) && (t = "[HTMLMODE]"), ZC.Q.A44(this.H.L, t + e, this.GH, this.DJ, this.sFontWeight, this.FI);
        },
        parse: function () {
            (this.I = this.F = this.NM = this.KC = 0), this.b();
            var e,
                i,
                t,
                n,
                a,
                l = this;
            if (!l.o.tween) {
                if (
                    (l.ZE("text", "AM"),
                    null !== ZC._n_(l.AM) &&
                        ((l.AM = "" + l.AM),
                        (l.AM = l.JT(l.AM)),
                        (l.AM = l.AM.replace(/\n/g, "<br>").replace(/\\n/g, "<br>")),
                        "svg" === l.H.AC && (l.AM = l.AM.replace(/&nbsp;/g, " ")),
                        (l.AM = l.AM.replace(/<audio|<video|<embed|<object/gi, "")),
                        -1 !== l.AM.indexOf("<img") && (l.AM = l.AM.replace(/onload=|onerror=/gi, ""))),
                    l.assign_a([
                        ["overlap", "A1S", "b"],
                        ["fast-width", "V2", "b"],
                        ["max-width", "OO", "i"],
                        ["line-height", "FI", "i"],
                        ["width-ratio", "A63", "f"],
                        ["wrap-text", "A29", "b"],
                        ["clip-text", "A8J", "b"],
                        ["bold", "A97", "b"],
                        ["italic", "N7", "b"],
                        ["underline", "QW", "b"],
                        ["text-decoration", "KA"],
                        ["rtl", "bRTL", "b"],
                        ["text-align", "OD"],
                        ["align", "OD"],
                        ["vertical-align", "JY"],
                        ["font-size", "DJ", "f"],
                        ["max-chars", "YB", "i"],
                        ["font-family", "GH"],
                        ["font-angle", "AA", "i"],
                        ["color", "C2", "c"],
                        ["font-color", "C2", "c"],
                        ["text-alpha", "UV", "f", 0, 1],
                        ["lock-rotation", "V9", "b"],
                    ]),
                    (l.DJ = ZC.BQ(1, l.DJ)),
                    null === ZC._n_(l.o["text-alpha"]) && (l.UV = l.C6),
                    l.A97 && (l.sFontWeight = "bold"),
                    null !== (e = ZC._n_(l.o["font-weight"])) && (l.sFontWeight = e),
                    null === ZC._n_(l.o["text-decoration"]) && (l.KA = l.QW ? "underline" : "none"),
                    null !== (e = ZC._n_(l.o["font-style"])) && (l.N7 = "italic" === e || "oblique" === e),
                    null !== (e = ZC._n_(l.o.padding)))
                ) {
                    var o = String(e).split(/\s+|;|,/);
                    (i =
                        1 === o.length
                            ? [ZC._i_(o[0]), ZC._i_(o[0]), ZC._i_(o[0]), ZC._i_(o[0])]
                            : 2 === o.length
                            ? [ZC._i_(o[0]), ZC._i_(o[1]), ZC._i_(o[0]), ZC._i_(o[1])]
                            : 3 === o.length
                            ? [ZC._i_(o[0]), ZC._i_(o[1]), ZC._i_(o[2]), ZC._i_(o[0])]
                            : [ZC._i_(o[0]), ZC._i_(o[1]), ZC._i_(o[2]), ZC._i_(o[3])]),
                        (l.FM = i[0]),
                        (l.FN = i[1]),
                        (l.FT = i[2]),
                        (l.EQ = i[3]);
                }
                if (
                    (l.assign_a([
                        ["padding-top", "FM", "i"],
                        ["padding-right", "FN", "i"],
                        ["padding-bottom", "FT", "i"],
                        ["padding-left", "EQ", "i"],
                    ]),
                    l.AM)
                ) {
                    l.YB > 0 && l.AM.length > l.YB && (l.AM = l.AM.substring(0, l.YB) + "...");
                    var r = l.AM.split(/<br>|<br\/>|<br \/>|\n/),
                        s = "";
                    "undefined" != typeof l.o["html-mode"] && ZC._b_(l.o["html-mode"]) && ((r = [l.AM]), (s = "[HTMLMODE]"));
                    r.length;
                    for (l.V2 ? (l.KC = 1.65 * this.DJ) : (l.KC = ZC.Q.A44(this.H.L, s + l.AM, this.GH, this.DJ, this.sFontWeight, this.FI, !0) + l.FM + l.FT), t = 0, n = r.length; t < n; t++)
                        l.NM = ZC.BQ(l.NM, l.cwidth(r[t]) + l.EQ + l.FN);
                } else (l.AM = ""), (l.NM = ZC._i_(1.25 * l.DJ)), (l.KC = -1 === l.FI ? ZC._i_(1.25 * l.DJ) : l.FI);
                if (
                    ((null === ZC._n_(l.o.width) || isNaN(l.I) || 0 === l.I) && (l.I = l.NM),
                    (null === ZC._n_(l.o.height) || isNaN(l.F) || 0 === l.F) && (l.F = l.KC),
                    (l.I = ZC.CY(l.I, l.OO)),
                    l.A29 && l.NM > l.I && !l.D.wrapped && l.I > 2 * l.DJ)
                ) {
                    var A,
                        C = "",
                        c = 0,
                        u = l.AM.replace(/<br>/gi, " [##] ").split(/\s|<br>/),
                        p = [];
                    for (t = 0, n = u.length; t < n; t++)
                        if ((A = l.cwidth(u[t])) > 0.9 * l.I) {
                            var Z = Math.ceil((A / l.I) * 0.9),
                                h = Math.ceil(u[t].length / Z);
                            for (a = 0; a < Z; a++) p.push(u[t].substr(a * h, h));
                        } else p.push(u[t]);
                    for (t = 0, n = p.length; t < n; t++)
                        "" !== p[t] && ("[##]" === p[t] ? ((C += "<br>"), (c = 0)) : (c += A = 1 + l.cwidth(p[t] + " ")) > 0.9 * l.I ? (t > 0 && (C += "<br>"), (C += p[t] + " "), (c = A)) : (C += p[t] + " "));
                    C = (C = C.replace(/<br><br>/g, "<br>").replace(/ <br> <br>/g, " <br>")).replace(/(.+?)<br> $/g, "$1");
                    var d = l.o.text;
                    (l.o.text = C), (l.D.wrapped = !0), l.parse(), (l.o.text = d), (l.D.wrapped = !1);
                }
                if (
                    ("canvas" !== l.H.AC && (l.AM = l.AM.replace(/&lt;/g, "<").replace(/&gt;/g, ">")),
                    !(
                        (null !== ZC._n_(l.o.width) && null !== ZC._n_(l.o.height)) ||
                        (null === ZC._n_(l.o.position) &&
                            null === ZC._n_(l.o.margin) &&
                            null === ZC._n_(l.o["margin-top"]) &&
                            null === ZC._n_(l.o["margin-right"]) &&
                            null === ZC._n_(l.o["margin-bottom"]) &&
                            null === ZC._n_(l.o["margin-left"]))
                    ))
                ) {
                    (l.iX = -1), (l.iY = -1);
                    var f = l.o.width,
                        _ = l.o.height;
                    null === ZC._n_(f) && (l.o.width = l.I), null === ZC._n_(_) && (l.o.height = l.F), l.locate(), (l.o.width = f), (l.o.height = _);
                }
                if ("undefined" == typeof l.o["html-mode"] || !l.o["html-mode"]) {
                    var g = Math.ceil((l.NM - l.EQ - l.FN) / l.DJ);
                    g > 0 && (l.AM = l.AM.replace(/<hr>/g, new Array(g).join("\u2014")));
                }
            }
            l.setAnchor();
        },
        paint: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o,
                r,
                s,
                A,
                C,
                c = this;
            if (!c.VP && !c.A1S) {
                var u = !0;
                null !== ZC._n_(c.o.flexible) && (u = ZC._b_(c.o.flexible));
                var p,
                    Z,
                    h = { x: c.iX + c.EQ - 1, y: c.iY + c.FM - 1, width: c.I - c.EQ - c.FN + 2, height: c.F - c.FM - c.FT + 2, type: c.D.lbltype || "" },
                    d = [[0, 0]];
                for (
                    u &&
                        (d = [
                            [0, 0],
                            [0, 2],
                            [0, -4],
                            [0, 4],
                            [0, -8],
                            [3, 0],
                            [-6, 0],
                            [5, 0],
                            [-10, 0],
                        ]),
                        Z = 0;
                    Z < d.length;
                    Z++
                ) {
                    for (p = !0, h.x += d[Z][0], h.y += d[Z][0], a = 0, l = c.H.SR.length; a < l; a++) ZC.AQ.XQ(h, c.H.SR[a], -2) && (p = !1);
                    if (p) {
                        (c.iX = h.x), (c.iY = h.y);
                        break;
                    }
                }
                if (!p) return;
                c.H.SR.push(h);
            }
            var f = c.H.AC;
            if (((e = ZC.Q.EB(c.Z, f)), c.VP || c.b(), !c.A5L && (c.o.width || !(c.I - c.EQ - c.FN < 2)) && (c.o.height || !(c.KC - c.FM - c.FT < 2)))) {
                var _ = c.AA % 360 == 0 ? "0" : "";
                if (((c.VP || (zingchart.CANVASTEXT && "canvas" === f)) && (_ = ""), ZC.vml && "svg" === f && "" === c.GL && (c.GL = c.L + "-class"), !c.VP && ZC.AL(c.L) && ((f = "_"), ZC.objmove)))
                    return (ZC.AL(c.L).style.top = c.iY + c.BI + "px"), void (ZC.AL(c.L).style.left = c.iX + c.BL + "px");
                var g = "undefined" != typeof c.D["html-mode"] && c.D["html-mode"],
                    v = g;
                "undefined" != typeof c.o["html-mode"] && (g = ZC._b_(c.o["html-mode"]));
                var b,
                    B,
                    m,
                    D,
                    E,
                    L,
                    F,
                    I,
                    x,
                    y,
                    w,
                    Y,
                    X,
                    M,
                    K,
                    S,
                    P,
                    H,
                    N,
                    G,
                    O,
                    k,
                    T = [c.AM];
                g || (T = c.AM.split(/<br>|<br\/>|<br \/>|\n/)), g && !v && "svg" === f && "0" === _ && (_ = "0html");
                var z = c.IL ? c.IL : c.Z.parentNode;
                switch (f + _) {
                    case "canvas0":
                    case "vml0":
                    case "svg0html":
                        if (((n = 1), !g))
                            switch (c.JY) {
                                case "middle":
                                    n += (c.F - c.KC) / 2;
                                    break;
                                case "bottom":
                                    n += c.F - c.KC;
                            }
                        if (
                            ((o = ZC.Q.I2({ id: c.L, cls: c.GL, tl: ZC._x_(c.iY + c.BI) + "/" + ZC._x_(c.iX + c.BL), wh: c.I + "/" + c.F, position: "absolute", padding: 0, margin: 0, overflow: g ? "visible" : "hidden", textAlign: c.OD })),
                            g && (v || f + _ !== "svg0html" || (z = ZC.AL(c.H.L + "-top")), z.appendChild(o)),
                            ZC.Q.I2({
                                // id: c.L + "-t",
                                // cls: "" !== c.GL ? c.GL + "-t" : "",
                                // p: o,
                                // width: c.I - c.EQ - c.FN,
                                // height: g ? null : c.KC - c.FM - c.FT,
                                // tl: n + "/0",
                                // html: c.AM + "",
                                // position: "absolute",
                                // whiteSpace: "nowrap",
                                // opacity: c.UV,
                                // color: c.C2,
                                // fontWeight: c.sFontWeight,
                                // fontStyle: c.N7 ? "oblique" : "normal",
                                // textDecoration: c.KA,
                                // fontSize: c.DJ,
                                // fontFamily: c.GH,
                                // marginTop: c.FM,
                                // marginRight: c.FN,
                                // marginBottom: c.FT,
                                // marginLeft: c.EQ,
                                // verticalAlign: c.JY,
                                // textAlign: c.OD,
                                // lineHeight: -1 === c.FI ? "125%" : c.FI + "px",
                                // rtl: c.bRTL,
                                // padding: 0,
                            }),
                            c.D["css-display"] && ((o.style.display = c.D["css-display"]), (c.D["css-display"] = null)),
                            v && c.H && c.H.A7 && !c.o.width && !c.o.height)
                        ) {
                            var Q = ZC.A5("#" + c.L + "-t");
                            "canvas" === f && ((ZC.AL(c.H.L + "-tooltip-c").width = Q.width() + c.EQ + c.FN), (ZC.AL(c.H.L + "-tooltip-c").height = Q.height() + c.FM + c.FT)),
                                c.H.A7.clear(),
                                (c.I = Q.width() + c.EQ + c.FN),
                                (c.F = Q.height() + c.FM + c.FT),
                                c.paint();
                        }
                        break;
                    case "canvas":
                        var V = !1;
                        if (
                            (ZC.A5.browser.opera && c.AA % 90 == 0 && 0 !== c.AA && ((c.AA += 0.5), (V = !0)),
                            (e = c.Z.getContext("2d")),
                            zingchart.DEV.CACHECANVASTEXT && (ZC.CanvasCache || (ZC.CanvasCache = {})),
                            !zingchart.DEV.CACHECANVASTEXT || (zingchart.DEV.CACHECANVASTEXT && !ZC.CanvasCache[c.L]))
                        ) {
                            for (
                                zingchart.DEV.CACHECANVASTEXT && ((ZC.CanvasCache[c.L] = document.createElement("canvas")), (ZC.CanvasCache[c.L].width = c.NM), (ZC.CanvasCache[c.L].height = c.KC)),
                                    b = -1 === c.FI ? 0 : ZC._x_(c.FI - 1.25 * c.DJ) / 2,
                                    a = 0,
                                    l = T.length;
                                a < l;
                                a++
                            )
                                if ("" !== ZC.GW(T[a])) {
                                    switch (((i = 1 === l ? c.NM : c.cwidth(T[a]) + c.FN + c.EQ), (m = -1 === (B = T[a]).indexOf("<") ? B : B.replace(/<.+?>/gi, "").replace(/<\/.+?>/gi, "")), (t = 0), (n = 0), c.OD)) {
                                        case "center":
                                            t += (c.I - i) / 2;
                                            break;
                                        case "right":
                                            t += c.I - i;
                                    }
                                    switch (c.JY) {
                                        case "middle":
                                            n += (c.F - c.KC) / 2;
                                            break;
                                        case "bottom":
                                            n += c.F - c.KC;
                                    }
                                    if (((D = 0), B !== m)) {
                                        for (; (L = /<(.+?)>(.*?)<\/(.+?)>/.exec(B)); ) {
                                            switch (((F = ""), (I = ""), (A = /(.+?)style=(.+?)(\'|")(.*?)/.exec(L[1])) && (I = A[2].replace(/\'|"/g, "")), L[3])) {
                                                case "b":
                                                case "strong":
                                                    F = "font-weight:bold";
                                                    break;
                                                case "i":
                                                case "em":
                                                    F = "font-style:italic";
                                                    break;
                                                case "u":
                                                    F = "text-decoration:underline";
                                            }
                                            (y = '[[span style="' + ("" === F ? "" : F + ";") + I + '"]]' + L[2] + "[[/span]]"), (B = B.replace(L[0], y));
                                        }
                                        for (
                                            w = !1,
                                                N = 0,
                                                G = (L = (B = B.replace(/\[\[/g, "<")
                                                    .replace(/\]\]/g, ">")
                                                    .replace(/<span/g, "[[*]]<span")
                                                    .replace(/<\/span>/g, "</span>[[*]]")).split("[[*]]")).length;
                                            N < G;
                                            N++
                                        )
                                            if ("" !== L[N]) {
                                                if (((r = c.C2), (Y = c.sFontWeight), (X = c.N7), (M = c.QW), (K = c.DJ), (S = c.GH), (H = c.FI), (P = c.KA), (E = L[N]), (C = /<span style=(.+?)>(.+?)<\/(.+?)>/.exec(L[N]))))
                                                    for (E = C[2], O = 0, k = (x = C[1].replace(/\'|"/g, "").split(/;|:/)).length; O < k - 1; O += 2)
                                                        switch (ZC.GW(x[O])) {
                                                            case "font-size":
                                                                K = ZC._i_(ZC.GW(x[O + 1]));
                                                                break;
                                                            case "font-family":
                                                                S = ZC.GW(x[O + 1]);
                                                                break;
                                                            case "font-weight":
                                                                Y = ZC.GW(x[O + 1]);
                                                                break;
                                                            case "font-style":
                                                                -1 !== ZC.AV(["italic", "oblique"], ZC.GW(x[O + 1])) && (X = !0);
                                                                break;
                                                            case "text-decoration":
                                                                P = ZC.GW(x[O + 1]);
                                                                break;
                                                            case "line-height":
                                                                H = ZC._i_(ZC.GW(x[O + 1]));
                                                                break;
                                                            case "color":
                                                                r = ZC.AP.G9(ZC.GW(x[O + 1]));
                                                        }
                                                0 === a && (b = -1 === H ? 0 : ZC._x_(H - 1.25 * K) / 2);
                                                var J = { idx: a, ctx: e, i: X, fw: Y, fs: K, lh: H, ff: S, c: r, t: E, dx: t, dy: n };
                                                (J.dy += ZC._x_(b)), (J.dy += w || c.isBold(Y) || M ? 2 : 0), c.paintCANVASText(J), (w = X), D++, (t += ZC.Q.A44(this.H.L, E, S, K, Y, H));
                                            }
                                        null !== ZC._n_(H) && null !== ZC._n_(K) && (b += -1 === H ? 1.25 * K : H);
                                    } else c.paintCANVASText({ idx: a, ctx: e, i: c.N7, fw: c.sFontWeight, fs: c.DJ, lh: c.FI, ff: c.GH, c: c.C2, t: T[a], dx: t, dy: n + b }), (b += -1 === c.FI ? 1.25 * c.DJ : c.FI);
                                }
                        } else e.drawImage(ZC.CanvasCache[c.L], c.iX + c.BL, c.iY + c.BI);
                        V && (c.AA -= 0.5);
                        break;
                    case "vml":
                        switch (((n = 0), c.JY)) {
                            case "top":
                                n -= (c.F - c.KC) / 2;
                                break;
                            case "bottom":
                                n += (c.F - c.KC) / 2;
                        }
                        var R = ZC.Q.F6("zcv:line"),
                            W = c.iX + c.BL + c.I / 2,
                            U = c.iY + c.BI + c.F / 2,
                            j = (ZC.EH(c.AA) * (c.I - c.EQ - c.FN)) / 2,
                            q = (ZC.EP(c.AA) * (c.I - c.EQ - c.FN)) / 2,
                            $ = ZC._i_(W - j - ZC.EH(90 - c.AA) * n),
                            ee = ZC._i_(U - q + ZC.EP(90 - c.AA) * n),
                            ie = ZC._i_(W + j - ZC.EH(90 - c.AA) * n),
                            te = ZC._i_(U + q + ZC.EP(90 - c.AA) * n);
                        $ === ie && (($ -= 0.01), (ie += 0.01)),
                            ee === te && ((ee -= 0.01), (te += 0.01)),
                            (r = c.C2),
                            0 !== c.AA && c.C6 < 1 && (r = ZC.AP.R0(r, 99 * (1 - c.C6))),
                            ZC.Q.G4(R, { id: c.L + "-line", from: $ + "px," + ee + "px", to: ie + "px," + te + "px", fillcolor: r }),
                            (R.filled = !0),
                            (R.stroked = !1);
                        var ne = ZC.Q.F6("zcv:path");
                        ne.setAttribute("textpathok", !0), R.appendChild(ne);
                        var ae = ZC.Q.F6("zcv:textpath"),
                            le = c.AM.replace(/<br>|<br\/>|<br \/>/gi, "\n")
                                .replace(/<.+?>/gi, "")
                                .replace(/<\/.+?>/gi, "");
                        ZC.Q.G4(ae, { on: !0, string: le }),
                            ZC.Q.PI(ae, { color: r, fontWeight: c.sFontWeight, fontStyle: c.N7 ? "oblique" : "normal", textDecoration: c.KA, fontSize: c.DJ + "px", fontFamily: c.GH, "v-text-align": c.OD }),
                            R.appendChild(ae),
                            e.appendChild(R);
                        break;
                    case "svg":
                    case "svg0":
                        var oe = c.iX + c.EQ + c.BL,
                            re = c.iY + c.FM + c.BI;
                        if (
                            ((o = ZC.Q.F6("text", "http://www.w3.org/2000/svg")),
                            ZC.Q.G4(o, { x: ZC._x_(oe), y: ZC._x_(re), id: c.L, class: c.GL, opacity: c.UV }),
                            c.D["css-display"] && ((o.style.display = c.D["css-display"]), (c.D["css-display"] = null)),
                            c.bRTL && ZC.Q.G4(o, { "text-anchor": ZC.A5.browser.msie ? "" : "end", "writing-mode": "rl", direction: "rtl", "unicode-bidi": "bidi-override" }),
                            c.A8J &&
                                (c.H.KD.appendChild(
                                    ZC.Q.XD({
                                        id: c.L + "-clip",
                                        path: [
                                            [c.iX + c.EQ + c.AU + c.BL, c.iY + c.FM + c.AU + c.BI].join(","),
                                            [c.iX + c.I - c.FN - c.AU + c.BL, c.iY + c.FM + c.AU + c.BI].join(","),
                                            [c.iX + c.I - c.FN - c.AU + c.BL, c.iY + c.F - c.FT - c.AU + c.BI].join(","),
                                            [c.iX + c.EQ + c.AU + c.BL, c.iY + c.F - c.FT - c.AU + c.BI].join(","),
                                            [c.iX + c.EQ + c.AU + c.BL, c.iY + c.FM + c.AU + c.BI].join(","),
                                        ].join(" "),
                                    })
                                ),
                                ZC.Q.G4(o, { "clip-path": "url(#" + c.L + "-clip)" })),
                            c.AA % 360 != 0 && o.setAttribute("transform", "rotate(" + c.AA + " " + (oe + (c.I - c.EQ - c.FN) / 2) + " " + (re + (c.F - c.FM - c.FT) / 2) + ")"),
                            g && z.appendChild(o),
                            g)
                        ) {
                            ZC.Q.ET(c.L + "-float");
                            var se = ZC.Q.F6("div");
                            ZC.Q.PI(se, {
                                position: "absolute",
                                left: 0,
                                top: 0,
                                width: c.I - c.EQ - c.FN + "px",
                                height: c.F - c.FM - c.FT + "px",
                                color: c.C2,
                                fontSize: c.DJ + "px",
                                fontFamily: c.GH,
                                fontWeight: c.sFontWeight,
                                textDecoration: c.KA,
                                textAlign: c.OD,
                                fontStyle: c.N7 ? "italic" : "normal",
                            }),
                                (se.id = c.L + "-float"),
                                (se.className = "zc-style zc-html-mode"),
                                (se.innerHTML = T[0]),
                                1 === c.o["z-index"] ? ZC.AL(c.H.L + "-top").append(se) : ZC.AL(c.H.L + "-top").insertBefore(se, ZC.AL(c.H.L + "-img")),
                                v &&
                                    c.H &&
                                    c.H.A7 &&
                                    (c.o.width || c.o.height || (c.H.A7.clear(), (se.style.width = ""), (se.style.height = ""), (c.I = ZC.A5(se).width() + c.EQ + c.FN), (c.F = ZC.A5(se).height() + c.FM + c.FT), c.paint()));
                        } else
                            for (b = -1 === c.FI ? 0 : ZC._x_(c.FI - 1.25 * c.DJ) / 2, a = 0, l = T.length; a < l; a++) {
                                switch (((i = 1 === l ? c.NM : c.cwidth(T[a]) + c.FN + c.EQ), (m = -1 === (B = T[a]).indexOf("<") ? B : B.replace(/<.+?>/gi, "").replace(/<\/.+?>/gi, "")), (t = 0), (n = c.DJ), c.OD)) {
                                    case "center":
                                        t = (c.I - i) / 2;
                                        break;
                                    case "right":
                                        t = c.I - i;
                                }
                                switch (c.JY) {
                                    case "middle":
                                        n += (c.F - c.KC) / 2;
                                        break;
                                    case "bottom":
                                        n += c.F - c.KC;
                                }
                                if (((D = 0), B !== m)) {
                                    for (; (L = /<(.+?)>(.*?)<\/(.+?)>/.exec(B)); ) {
                                        switch (((F = ""), (I = ""), (A = /(.+?)style=(.+?)(\'|")(.*?)/.exec(L[1])) && (I = A[2].replace(/\'|"/g, "")), L[3])) {
                                            case "b":
                                            case "strong":
                                                F = "font-weight:bold";
                                                break;
                                            case "i":
                                            case "em":
                                                F = "font-style:italic";
                                                break;
                                            case "u":
                                                F = "text-decoration:underline";
                                        }
                                        (y = '[[span style="' + ("" === F ? "" : F + ";") + I + '"]]' + L[2] + "[[/span]]"), (B = B.replace(L[0], y));
                                    }
                                    for (
                                        w = !1,
                                            N = 0,
                                            G = (L = (B = B.replace(/\[\[/g, "<")
                                                .replace(/\]\]/g, ">")
                                                .replace(/<span/g, "[[*]]<span")
                                                .replace(/<\/span>/g, "</span>[[*]]")).split("[[*]]")).length;
                                        N < G;
                                        N++
                                    )
                                        if ("" !== L[N]) {
                                            if (((r = c.C2), (Y = c.sFontWeight), (X = c.N7), (M = c.QW), (K = c.DJ), (S = c.GH), (P = c.KA), (H = c.FI), (E = L[N]), (C = /<span style=(.+?)>(.+?)<\/(.+?)>/.exec(L[N]))))
                                                for (E = C[2], O = 0, k = (x = C[1].replace(/\'|"/g, "").split(/;|:/)).length; O < k - 1; O += 2)
                                                    switch (ZC.GW(x[O])) {
                                                        case "font-size":
                                                            K = ZC._i_(ZC.GW(x[O + 1]));
                                                            break;
                                                        case "font-family":
                                                            S = ZC.GW(x[O + 1]);
                                                            break;
                                                        case "font-weight":
                                                            Y = ZC.GW(x[O + 1]);
                                                            break;
                                                        case "font-style":
                                                            -1 !== ZC.AV(["italic", "oblique"], ZC.GW(x[O + 1])) && (X = !0);
                                                            break;
                                                        case "text-decoration":
                                                            P = ZC.GW(x[O + 1]);
                                                            break;
                                                        case "line-height":
                                                            H = ZC._i_(ZC.GW(x[O + 1]));
                                                            break;
                                                        case "color":
                                                            r = ZC.AP.G9(ZC.GW(x[O + 1]));
                                                    }
                                            (n = K),
                                                (s = ZC.Q.F6("tspan", "http://www.w3.org/2000/svg")),
                                                0 === D ? (ZC.Q.G4(s, { x: ZC._x_(oe + t), y: ZC._x_(re + n), dy: ZC._x_(b) }), (b += -1 === H ? 1.25 * K : ZC.BQ(1.5 * K, H))) : ZC.Q.G4(s, { dx: w || c.isBold(Y) || M ? 2 : 0 }),
                                                ZC.Q.G4(s, { color: r, fill: r }),
                                                ZC.Q.PI(s, { fontWeight: Y, fontStyle: X ? "oblique" : "normal", textDecoration: P, fontSize: K + "px", fontFamily: S, dominantBaseline: "auto" });
                                            var Ae = document.createElement("span");
                                            -1 !== E.indexOf("<") || -1 !== E.indexOf(">") ? (Ae.innerText = E) : (Ae.innerHTML = E), (E = Ae.innerText || Ae.textContent), (Ae = null), (s.textContent = E), o.appendChild(s), (w = X), D++;
                                        }
                                } else
                                    c.bRTL && ZC.A5.browser.msie && (t += i - c.EQ - c.FN),
                                        (s = ZC.Q.F6("tspan", "http://www.w3.org/2000/svg")),
                                        ZC.Q.G4(s, { x: ZC._x_(oe + t), y: ZC._x_(re + n), color: c.C2, fill: c.C2, dy: ZC._x_(b) }),
                                        ZC.Q.PI(s, { fontWeight: c.sFontWeight, fontStyle: c.N7 ? "oblique" : "normal", textDecoration: c.KA, fontSize: c.DJ + "px", fontFamily: c.GH, dominantBaseline: "auto" }),
                                        (s.textContent = m),
                                        o.appendChild(s),
                                        (b += -1 === c.FI ? 1.25 * c.DJ : c.FI);
                            }
                }
                if (!g)
                    if (!c.VP && o && z)
                        if (c.H.G2) -1 !== ZC.Q.T4(z).indexOf("zc-text") && null === ZC._n_(c.H.G2[z.id]) && (c.H.G2[z.id] = document.createDocumentFragment()), c.H.G2[z.id] ? c.H.G2[z.id].appendChild(o) : z.appendChild(o);
                        else z.appendChild(o);
            }
        },
        paintCANVASText: function (e) {
            var i = this,
                t = e.idx,
                n = e.ctx,
                a = e.i,
                l = e.fw,
                o = e.fs,
                r = e.ff,
                s = e.c,
                A = e.dx,
                C = e.dy,
                c = e.t;
            n.save(), (n.globalAlpha = i.UV);
            var u;
            if (
                ((u = (a ? "italic" : "normal") + " normal " + l + " " + o + "px " + r),
                (n.font = u),
                (n.fillStyle = s),
                (n.textAlign = "left"),
                (n.textBaseline = "alphabetic"),
                n.translate(i.iX + i.BL, i.iY + i.BI),
                0 !== i.AA && (n.translate(i.I / 2, i.F / 2), n.rotate(ZC.T8(i.AA)), n.translate(-i.I / 2, -i.F / 2)),
                n.translate(i.EQ, i.FM + o),
                n.translate(A, C),
                n.fillText(c, 0, 0),
                zingchart.DEV.CACHECANVASTEXT)
            ) {
                var p = ZC.CanvasCache[i.L].getContext("2d");
                (p.font = u), (p.fillStyle = s), (p.textAlign = "left"), (p.textBaseline = "alphabetic"), p.fillText(c, i.EQ, i.FM + o + 1.25 * t * o);
            }
            n.restore();
        },
        EL: function (e) {
            var i = this;
            if (ZC.canvas && "canvas" === i.H.AC && (e || (e = ZC.AL(i.H.L + "-textprint-c")), !zingchart.CANVASTEXT && i.AA % 360 == 0)) {
                var t = i.Z;
                (i.Z = e), (i.VP = !0);
                var n = i.H.AC;
                (i.H.AC = "canvas"), i.paint(), (i.VP = !1), (i.H.AC = n), (i.Z = t);
            }
        },
    };
    ZC.DN = ZC.HN.CC(DN);
    var Q1 = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.CJ = "json"),
                (i.O1 = { graphset: !0, graph: !0, "objects-bottom": !0, "objects-top": !0, maps: !0, plotarea: !0, plots: !0, guide: !0, static: !0, "value-box": !0 }),
                (i.bA11y = !1),
                (i.OZ = ""),
                (i.A17 = !1),
                (i.A18 = "en_us"),
                (i.QN = null),
                (i.JL = ""),
                (i.UC = !1),
                (i.RY = {}),
                (i.N6 = ""),
                (i.ADI = {}),
                (i.QK = ""),
                (i.EV = ""),
                (i.MB = {}),
                (i.HS = null),
                (i.AG = []),
                (i.LJ = ""),
                (i.A7 = null),
                (i.H2 = null),
                (i.D7 = null),
                (i.B8 = new ZC.AB1(i)),
                (i.QJ = ""),
                (i.MN = null),
                (i.NU = [null, null, null, null]),
                (i.O7 = !1),
                (i.NF = "x"),
                (i.K8 = !1),
                (i.TM = !1),
                (i.ABL = !1),
                (i.A3Z = !1),
                (i.GN = !1),
                (i.A9F = {}),
                (i.NQ = null),
                (i.QY = {}),
                (i.LT = !1),
                (i.QL = !1),
                (i.AD3 = null),
                (i.SQ = []),
                (i.O = {}),
                (i.MZ = null),
                (i.DG = null),
                (i.UP = 0),
                (i.A2E = 0),
                (i.A4F = 1),
                (i.MH = null),
                (i.S8 = ""),
                (i.AAV = "F*nStrlng4Cu$tOmLlc9nc9!"),
                (i.MF = ""),
                (i.A16 = {}),
                (i.A08 = !1),
                (i.AC = ""),
                (i.KD = null),
                (i.ZV = !1),
                (i.QS = ["", ""]),
                (i.L6 = 0),
                (i.KP = []),
                (i.A8F = 0),
                (i.A8C = 0),
                (i.AAB = !1),
                (i.A1O = ""),
                (i.A6N = !0),
                (i.ID = null),
                (i.QU = []),
                (i.NR = 0),
                (i.AAR = !1),
                (i.SD = {}),
                (i.A1F = !1),
                (i.G2 = zingchart.DEV.DOMFRAGMENTS ? {} : null),
                (i.A2Q = !1),
                (i.SR = []);
        },
        clearLabelBoxes: function (e) {
            var i = this;
            if (e) for (var t = i.SR.length - 1; t >= 0; t--) i.SR[t].type === e && i.SR.splice(t, 1);
            else i.SR = [];
        },
        usc: function () {
            return -1 !== ZC.AV(this.KP, "use_single_canvas");
        },
        mc: function (e) {
            return (e = e || ""), ZC.AL(this.L + "-main-c" + ("" === e ? e : "-" + e));
        },
        hideCM: function () {
            var e;
            (e = ZC.AL(this.L + "-menu")) && (e.style.display = "none"), (this.AAB = !1);
        },
        ZR: function () {
            for (var e = this, i = e.NU.length, t = 0; t < i; t++)
                if (null !== ZC._n_(e.NU[t])) {
                    switch (e.AC) {
                        case "svg":
                            ZC.CS.VX(e.NU[t].ctx, e.NU[t].style, e.NU[t].path.join(" "), e.NU[t].filled);
                            break;
                        case "vml":
                            ZC.CS.VW(e.NU[t].ctx, e.NU[t].style, e.NU[t].path.join(" "), e.NU[t].filled);
                    }
                    e.NU[t] = null;
                }
        },
        A8Q: function () {
            var s = this,
                i,
                A6,
                EX,
                A5O;
            (ZC.LICENSE = ZC.LICENSE || zingchart.LICENSE || ""),
                (ZC.BUILDCODE = ZC.BUILDCODE || zingchart.BUILDCODE || ""),
                (ZC.LICENSEKEY = ZC.LICENSEKEY || zingchart.LICENSEKEY || ""),
                (A5O = "file:" === document.location.protocol ? ZC.HOSTNAME || "" : document.location.hostname);
            var A1H = [A5O],
                CV = A5O.split(".");
            for ("www" === CV[0] ? A1H.push(A5O.replace("www.", "")) : A1H.push("www." + A5O), i = 0; i <= CV.length - 2; i++) {
                for (var ABB = "*", j = i; j < CV.length; j++) ABB += "." + CV[j];
                A1H.push(ABB);
            }
            function X4(e) {
                if (ZC.NOABOUT && ZC.NOABOUT instanceof Array) {
                    var i = ZC.XR.md5(ZC.AAC(ZC.A9S(e)));
                    -1 !== ZC.AV(ZC.NOABOUT, i) && (s.ABL = !0);
                }
            }
            if (-1 !== ZC.AV(A1H, "localhost") || -1 !== ZC.AV(A1H, "127.0.0.1")) (s.TM = !0), (s.A3Z = !0), X4("localhost");
            else {
                var A2H = [
                    ["window.AC.Core.zflags", "Q^fhx]XKoJJLnmLPUYiWUuQKAOGnuAIWrSN_ZIj_LYvS`jRkihLOSfysvRQTBtQOUUO^`SdgZUHWKDVQ[xST_SWRLyFKogwOclSB"],
                    ["window.jsNorthNine.AppIdentity", "09Vczmfsf/Q5G8dRWLio+7PVG0KjUnLRqnRSPOeqf6gu/hpxK6BeHRUtuasojuRTPFQYdzNGN57nxLviTf1hV4lwaFjtbv/tA1g0W0k7AKV1g1ouow1nG/+EJLl0khmPDSKBJa8fkP70KLNtrxt5pE2yjx+IvQ40ajd/03rqqtR="],
                ];
                for (i = 0, A6 = A2H.length; i < A6; i++)
                    try {
                        if (eval(A2H[i][0]) === ZC.A9S(A2H[i][1])) {
                            s.TM = !0;
                            break;
                        }
                    } catch (e) {}
                for (i = 0, A6 = A1H.length; i < A6; i++) {
                    var A5H = ZC.XR.md5(ZC.AAC(ZC.A9S(A1H[i])));
                    ZC.LICENSE instanceof Array && -1 !== ZC.AV(ZC.LICENSE, A5H) && ((s.TM = !0), X4(A5H));
                }
                ZC.BUILDCODE instanceof Array &&
                    2 === ZC.BUILDCODE.length &&
                    ((EX = ZC.AD8(s.AAV)), (EX = EX.replace("O", "0")), (s.S8 = ZC.ACA(ZC.BUILDCODE[0], EX)), s.S8 === ZC.BUILDCODE[1] && ((s.TM = !0), (s.A3Z = !0), X4(ZC.BUILDCODE[0])));
            }
        },
        A8S: function () {
            var e = this;
            if (null !== e.MN) ZC._todash_(e.MN), e.load();
            else if (null === ZC._n_(ZC.cache.data["defaults-" + e.QJ])) {
                var i = ["query-string" === e.N6 ? "zcrandom=" + Math.random() : "", zingchart.ZCOUTPUT ? "zcoutput=" + e.AC : ""].join("&");
                ZC.A5.ajax({
                    type: "GET",
                    url: e.QJ,
                    dataType: "text",
                    beforeSend: function (i) {
                        e.RY.defaults || "http-headers" !== e.N6 || i.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
                    },
                    data: i,
                    error: function (i, t, n, a) {
                        return e.NY({ name: "Network error", message: "Resource not found (" + a + ")" }, "URL Data loader"), !1;
                    },
                    success: function (i) {
                        var t;
                        try {
                            (t = JSON.parse(i)), (ZC.cache.data["defaults-" + e.QJ] = i);
                        } catch (n) {
                            return e.NY(n, "JSON parser"), !1;
                        }
                        (e.MN = t), ZC._todash_(e.MN), e.load();
                    },
                });
            } else {
                var t;
                try {
                    t = JSON.parse(ZC.cache.data["defaults-" + e.QJ]);
                } catch (n) {
                    return e.NY(n, "JSON parser"), !1;
                }
                (e.MN = t), ZC._todash_(e.MN), e.load();
            }
        },
        load: function (e, i) {
            var t = this;
            if (((t.MF = "load"), "" !== (i = i || t.QK) && 0 !== i.indexOf("javascript:")))
                if (null === ZC._n_(ZC.cache.data["data-" + i])) {
                    var n = ["query-string" === t.N6 ? "zcrandom=" + Math.random() : "", zingchart.ZCOUTPUT ? "zcoutput=" + t.AC : ""].join("&");
                    ZC.A5.ajax({
                        type: "GET",
                        url: i,
                        dataType: "text",
                        beforeSend: function (e) {
                            t.RY.data || "http-headers" !== t.N6 || e.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
                        },
                        data: n,
                        error: function (e, i, n, a) {
                            return t.NY({ name: "Network error", message: "Resource not found (" + a + ")" }, "URL Data loader"), !1;
                        },
                        success: function (i) {
                            t.data_(e, i);
                        },
                    });
                } else t.data_(e, ZC.cache.data["data-" + i]), (ZC.cache.data["data-" + i] = null);
            else "" !== t.EV ? t.data_(e, t.EV) : null !== t.MB && (t.A7H ? (t.MB = JSON.parse(JSON.stringify(t.A7H))) : (t.A7H = JSON.parse(JSON.stringify(t.MB))), t.data_(e, t.MB));
        },
        data_: function (e, i) {
            var t = this;
            (ZC.TS[t.L] = new Date().getTime()),
                ZC.AP.A80("dataload", t)
                    ? ZC.AP.C0("dataload", t, t.FG(), i, function (i) {
                          t.load_(e, i);
                      })
                    : t.load_(e, i);
        },
        A4T: function (e) {
            var i, t;
            if (!zingchart.DEV.RESOURCES) return [];
            e || (e = this.o);
            var n = [];
            if (e.graphset)
                for (i = 0, t = e.graphset.length; i < t; i++) {
                    var a = e.graphset[i].type || "null";
                    if (-1 === ZC.AV(ZC.CHARTS, a)) {
                        for (var l in ("3d" === a.substring(a.length - 2) && (a = a.substring(0, a.length - 2)), ZC.EQUIV)) ZC.EQUIV.hasOwnProperty(l) && -1 !== ZC.AV(ZC.EQUIV[l], a) && (a = l);
                        zingchart.loadModules(a), n.push(a);
                    }
                }
            for (this.ACM(e), i = 0, t = ZC.RO.length; i < t; i++) "" !== ZC.GW(ZC.RO[i]) && -1 === ZC.AV(ZC.WG, ZC.GW(ZC.RO[i])) && n.push(ZC.GW(ZC.RO[i]));
            return n;
        },
        ACM: function (e) {
            e || (e = this.o);
        },
        load_: function (JK, U0) {
            var s = this,
                G;
            s.D.rawsource = zingchart.DEV.KEEPSOURCE ? U0 : "N/A";
            var DL = null;
            if ("string" == typeof U0)
                try {
                    DL = JSON.parse(U0);
                } catch (JA) {
                    try {
                        DL = eval("(" + U0 + ")");
                    } catch (JA) {
                        return s.NY(JA, "JSON parser"), !1;
                    }
                }
            else DL = U0;
            null === ZC._n_(DL.graphset) && (DL = { graphset: [DL] }),
                (s.D.source = "N/A"),
                zingchart.DEV.KEEPSOURCE && (s.D.source = ZC.GW(JSON.stringify(DL))),
                zingchart.A1I(s, s.A4T(DL), function () {
                    (DL = ZC.AP.C0("dataparse", s, s.FG(), DL)),
                        zingchart.A1I(s, s.A4T(DL), function () {
                            if ((ZC.AP.C0("modulesready", s, { id: s.L }), null === ZC._n_(JK)))
                                s.XU(DL),
                                    (s.o = DL),
                                    s.A17
                                        ? (s.parse(), s.paint())
                                        : s.Q8(function () {
                                              s.parse(), s.paint();
                                          });
                            else {
                                var e = s.OS(JK);
                                if (null !== e && null !== ZC._n_((G = DL.graphset))) {
                                    var i = G.length > 1 ? G[e.K] : G[0];
                                    i.id || (i.id = e.o.id || ""),
                                        (s.o.graphset[e.K] = i),
                                        s.Q8(function () {
                                            s.parse(JK), s.AG[e.K].paint();
                                        });
                                }
                            }
                        });
                });
        },
        XU: function (DL) {
            var s = this,
                G,
                i,
                A6,
                j,
                JC;
            for (null === ZC._n_(DL.graphset) && (DL = { graphset: [DL] }), 1 === DL.graphset.length && null === ZC._n_(DL.graphset[0]) && (DL.graphset = [{ type: "null" }]), i = 0, A6 = DL.graphset.length; i < A6; i++)
                if (null !== ZC._n_(DL.graphset[i])) {
                    if (null !== ZC._n_((G = DL.graphset[i].shapes))) {
                        var FH = [];
                        for (DL.graphset[i].labels = DL.graphset[i].labels || [], j = 0, JC = G.length; j < JC; j++)
                            if (((G[j].generated && G[j]["map-item"]) || FH.push(G[j]), null !== ZC._n_(G[j].type) && 0 === G[j].type.indexOf("zingchart.")))
                                try {
                                    var LU = G[j].options || {},
                                        EC = G[j].type + "." + (LU.name || "");
                                    LU.graphid = i;
                                    var A39 = eval(EC).call(s, LU, DL, G[j]);
                                    for (var A3I in A39) A39.hasOwnProperty(A3I) && ("label" === A39[A3I].objtype ? DL.graphset[i].labels.push(A39[A3I]) : FH.push(A39[A3I]));
                                } catch (e) {}
                        DL.graphset[i].shapes = FH;
                    }
                    var A6G;
                    if (null !== ZC._n_((A6G = DL.graphset[i].widgets)))
                        for (var AAU = s.A4K(DL, i), k = 0; k < A6G.length; k++) {
                            var A2V = A6G[k];
                            if (null !== ZC._n_(A2V.type) && null !== ZC._n_(zingchart.widgets[A2V.type]) && "function" == typeof zingchart.widgets[A2V.type].parse)
                                try {
                                    var BJ = {};
                                    ZC._cp_(A2V, BJ), (BJ.graph = AAU.graph), (BJ.loader = { id: s.L, width: s.I, height: s.F });
                                    var o = zingchart.widgets[A2V.type].parse.call(s, BJ);
                                    if (null !== ZC._n_((G = o.graphs))) for (j = 0; j < G.length; j++) DL.graphset.push({}), ZC._cp_(G[j], DL.graphset[DL.graphset.length - 1]);
                                    if (null !== ZC._n_((G = o.labels))) for (null === ZC._n_(DL.graphset[i].labels) && (DL.graphset[i].labels = []), j = 0; j < G.length; j++) DL.graphset[i].labels.push(G[j]);
                                    if (null !== ZC._n_((G = o.shapes))) for (null === ZC._n_(DL.graphset[i].shapes) && (DL.graphset[i].shapes = []), j = 0; j < G.length; j++) DL.graphset[i].shapes.push(G[j]);
                                } catch (e) {}
                        }
                }
        },
        AAH: function (e, i) {
            var t = this;
            switch (e) {
                case "line":
                    return new ZC.A68(t);
                case "area":
                    return new ZC.A69(t);
                case "vline":
                    return new ZC.A9U(t);
                case "varea":
                    return new ZC.A9V(t);
                case "bar":
                case "vbar":
                case "column":
                    return new ZC.A2K(t);
                case "hbar":
                    return new ZC.A2J(t);
                case "mixed":
                case "hmixed":
                case "mixed3d":
                    for (var n = !1, a = t.o.graphset[i].series, l = 0, o = a.length; l < o; l++) a[l] && a[l].type && -1 !== a[l].type.indexOf("3d") && (n = !0);
                    return n
                        ? new ZC.A36(t)
                        : t.o.graphset[i].plot && t.o.graphset[i].type && t.o.graphset[i].plot && t.o.graphset[i].plot.type && -1 !== t.o.graphset[i].plot.type.indexOf("3d")
                        ? new ZC.A36(t)
                        : "mixed" === e
                        ? new ZC.A58(t)
                        : new ZC.A8X(t);
                case "scatter":
                    return new ZC.A8B(t);
                case "hscatter":
                    return new ZC.A74(t);
                case "bubble":
                    return new ZC.A8T(t);
                case "hbubble":
                    return new ZC.A85(t);
                case "ring":
                case "pie":
                    return new ZC.A3C(t);
                case "nestedpie":
                    return new ZC.A6P(t);
                case "radar":
                case "polar":
                    return new ZC.A9B(t);
                case "venn":
                    return new ZC.AAK(t);
                case "bullet":
                case "vbullet":
                    return new ZC.A7Z(t);
                case "hbullet":
                    return new ZC.A82(t);
                case "funnel":
                case "vfunnel":
                    return new ZC.A8G(t);
                case "hfunnel":
                    return new ZC.A8H(t);
                case "heatmap":
                case "piano":
                    return new ZC.AA8(t);
                case "stock":
                    return new ZC.A9A(t);
                case "range":
                    return new ZC.A9D(t);
                case "vrange":
                    return new ZC.ZCVRangeGraph(t);
                case "gauge":
                    return new ZC.A9E(t);
                case "line3d":
                    return new ZC.A8U(t);
                case "area3d":
                    return new ZC.A8Y(t);
                case "ring3d":
                case "pie3d":
                    return new ZC.A5J(t);
                case "bar3d":
                case "vbar3d":
                    return new ZC.A8V(t);
                case "hbar3d":
                    return new ZC.A8W(t);
                case "null3d":
                    return new ZC.A8P(t);
                default:
                    return new ZC.AAF(t);
            }
        },
        OS: function (e) {
            for (var i = this, t = 0, n = i.AG.length; t < n; t++) if (i.AG[t].L === i.L + "-graph-" + e || i.AG[t].L === i.L + "-graph-id" + e || i.AG[t].L === e || t === e) return i.AG[t];
            return null;
        },
        A4C: function (e, i) {
            var t = this,
                n = ZC.A5("#" + t.L + ("svg" === t.AC ? "-top" : "-main")),
                a = ZC._tx_(t.L);
            (e -= n.offset().left), (i -= n.offset().top);
            for (var l = null, o = 0, r = t.AG.length; o < r; o++) ZC.DT(e, t.AG[o].iX, t.AG[o].iX + t.AG[o].I * a[0]) && ZC.DT(i, t.AG[o].iY, t.AG[o].iY + t.AG[o].F * a[1]) && (l = t.AG[o]);
            return l;
        },
        AA6: function (e) {
            var i,
                t = this;
            if ("undefined" == typeof t.D.themesloaded) {
                void 0 === e && (e = !1),
                    t.assign_a([["theme", "LJ"]]),
                    t.o.graphset && 1 === t.o.graphset.length && null !== ZC._n_((i = t.o.graphset[0].theme)) && (t.LJ = i),
                    "" === t.LJ && (t.LJ = "light"),
                    (t.LJ = String(t.LJ).replace("zingchart", "classic"));
                for (var n = t.LJ.split(/\s+|;|,/), a = 0, l = n.length; a < l; a++) t.B8.AAW(n[a]);
                t.B8.A8S(t.MN), ZC.mobile && t.B8.AAW("mobile"), e || (t.D.themesloaded = !0);
            }
        },
        parse: function (e) {
            var i,
                t,
                n,
                a,
                l,
                o,
                r = this;
            (r.NF = "x"), (r.D.json = ZC.GW(JSON.stringify(r.o))), ZC._cp_(r.o.layers, r.O1), 1 === r.o.graphset.length && ZC._cp_(r.o.graphset[0].layers, r.O1);
            var s = r.FG();
            if ((null !== ZC._n_(e) && (s.graphid = e), ZC.AP.C0("dataready", r, s), (r.MF = "parse"), (r.QS[1] = r.QS[0]), (r.QS[0] = ""), (r.QS[0] += r.I + ":" + r.F + ":"), null !== ZC._n_((i = r.o.graphset))))
                for (r.QS[0] += i.length + ":", a = 0; a < i.length; a++)
                    (r.QS[0] += (i[a].type || "") + ":"),
                        (r.QS[0] += (i[a].x || "") + ":" + (i[a].y || "") + ":" + (i[a].width || "") + ":" + (i[a].height || "") + ":"),
                        null !== ZC._n_(i[a].series) && (r.QS[0] += i[a].series.length + ":");
            if ((ZC.AL(r.L + "-main-c") && r.clear(e, !1), "undefined" != typeof ZC.A4X && (r.H2 = new ZC.A4X(r)), null === ZC._n_(e))) {
                r.AA6(), r.B8.B8["font-family"] && (zingchart.FONTFAMILY = r.B8.B8["font-family"]);
                var A = !!r.o.gui;
                if (
                    (r.B8.load(r.o, "loader", !1, !0),
                    r.assign_a([
                        ["gui", "DG"],
                        ["globals", "QN"],
                    ]),
                    r.o.graphset && 1 === r.o.graphset.length && ((t = r.o.graphset[0]), null !== ZC._n_((i = t.gui)) && (r.DG = i), null !== ZC._n_((i = t.globals)) && (r.QN = i)),
                    ZC._todash_(r.QN),
                    ZC._cp_(r.B8.B8.root.gui, r.DG, !1, !0, !0),
                    r.DG.behaviors)
                )
                    for (a = r.DG.behaviors.length - 1; a >= 0; a--)
                        for (o = 0; o < a; o++)
                            if (r.DG.behaviors[a].id === r.DG.behaviors[o].id) {
                                r.DG.behaviors.splice(a, 1);
                                break;
                            }
                if ((A || delete r.o.gui, ZC._todash_(r.DG), (r.O = {}), null !== ZC._n_((i = r.o.style)))) for (n in i) "url" !== n && (r.O[n] = i[n]);
                if (r.o.graphset && 1 === r.o.graphset.length && ((t = r.o.graphset[0]), null !== ZC._n_((i = t.style)))) for (n in i) "url" !== n && (r.O[n] = i[n]);
                ZC._todash_(r.O),
                    r.O1.graphset && r.b(),
                    r.assign_a([
                        ["locale", "A18"],
                        ["set-locale", "A18"],
                        ["layout", "NF"],
                        ["h-space", "A8F", "i"],
                        ["v-space", "A8C", "i"],
                        ["flat", "K8", "b"],
                        ["show-progress", "A08", "b"],
                    ]),
                    r.o.graphset &&
                        1 === r.o.graphset.length &&
                        ((t = r.o.graphset[0]),
                        null !== ZC._n_((i = t.locale)) && (r.A18 = i),
                        null !== ZC._n_((i = t["set-locale"])) && (r.A18 = i),
                        null !== ZC._n_((i = t.flat)) && (r.K8 = ZC._b_(i)),
                        null !== ZC._n_((i = t["show-progress"])) && (r.A08 = ZC._b_(i))),
                    null !== ZC._n_((i = zingchart.i18n[r.A18])) && (ZC.HJ = i),
                    (r.AG = []);
            }
            var C = 0,
                c = 0,
                u = r.I,
                p = r.F;
            if (null !== ZC._n_(r.o.margin) || null !== ZC._n_(r.o["margin-top"]) || null !== ZC._n_(r.o["margin-right"]) || null !== ZC._n_(r.o["margin-bottom"]) || null !== ZC._n_(r.o["margin-left"])) {
                var Z = new ZC.HN(r);
                Z.append(r.o, !1, !1), Z.parse(), (C = Z.DZ), (c = Z.E9), (u = u - Z.DZ - Z.E8), (p = p - Z.E9 - Z.DR);
            }
            var h,
                d,
                f = r.OS(e);
            if (null !== ZC._n_((h = r.o.graphset))) {
                var _ = 0;
                for (a = 0, l = h.length; a < l; a++) (d = 0), null !== ZC._n_((i = h[a].page)) && (d = ZC._i_(i)), (_ += r.L6 === d ? 1 : 0);
                var g = ZC.AQ.A23(r.NF, _),
                    v = ZC._i_(g[0]),
                    b = ZC._i_(g[1]),
                    B = 0,
                    m = 0,
                    D = 0;
                for (a = 0, l = h.length; a < l; a++) {
                    if (((d = 0), null === f && null !== ZC._n_((i = h[a].page)) && (d = ZC._i_(i)), (null === f || D === f.K) && r.L6 === d)) {
                        if (
                            ((r.AG[D] = r.AAH(h[a].type || "null", a)),
                            (r.AG[D].OE = r.AG[D].AF + "graph"),
                            r.B8.load(r.AG[D].o, "graph"),
                            r.B8.load(r.AG[D].o, h[a].type || "null"),
                            r.AG[D].append(r.o.graph),
                            r.AG[D].append(h[a]),
                            (r.AG[D].K = D),
                            null === ZC._n_(h[D].id) || "" === h[D].id ? (r.AG[D].L = r.L + "-graph-id" + D) : (r.AG[D].L = r.L + "-graph-" + h[a].id),
                            h.length > 0)
                        ) {
                            for (var E = 0, L = 0, F = ZC._i_((u - (b + 1) * r.A8F) / b), I = ZC._i_((p - (v + 1) * r.A8C) / v), x = ["x", "y", "width", "height"], y = 0; y < x.length; y++)
                                null !== ZC._n_(r.D["graph-" + D + "-" + x[y]]) && (delete r.D["graph-" + D + "-" + x[y]], delete r.AG[D].o[x[y]]);
                            null === ZC._n_(r.AG[D].o.x) ? (r.D["graph-" + D + "-x"] = r.AG[D].o.x = ZC._i_(r.iX + (B + 1) * r.A8F + B * F) + C) : (E = ZC.IJ(r.AG[D].o.x)) < 1 && (E = ZC._i_(r.I * E)),
                                null === ZC._n_(r.AG[D].o.y) ? (r.D["graph-" + D + "-y"] = r.AG[D].o.y = ZC._i_(r.iY + (m + 1) * r.A8C + m * I) + c) : (L = ZC.IJ(r.AG[D].o.y)) < 1 && (L = ZC._i_(r.F * L)),
                                null === ZC._n_(r.AG[D].o.width) && (r.D["graph-" + D + "-width"] = r.AG[D].o.width = Math.max(F, F - E)),
                                null === ZC._n_(r.AG[D].o.height) && (r.D["graph-" + D + "-height"] = r.AG[D].o.height = Math.max(I, I - L));
                        }
                        r.AG[D].parse();
                    }
                    r.L6 === d && (D++, ++B === b && (m++, (B = 0)));
                }
            }
            null === ZC._n_(e) && null !== ZC._n_((i = r.o.refresh)) && ((r.HS = { type: "full", interval: 10 }), ZC._cp_(i, r.HS));
        },
        A46: function (e, i) {
            i = i || "";
            var t = [];
            for (var n in e)
                if ("object" == typeof e[n]) for (var a = this.A46(e[n], i + "." + n), l = 0, o = a.length; l < o; l++) -1 === ZC.AV(t, a[l]) && t.push(a[l]);
                else {
                    var r = i + "." + n;
                    ("background-image" !== n && "backgroundImage" !== n) ||
                        "" === e[n] ||
                        "zc." === e[n].substring(0, 3) ||
                        (!ZC.ie67 && ZC.PATTERNS && "PATTERN_" === e[n].substring(0, 8) && (e[n] = ZC.PATTERNS[e[n].substring(8)]),
                        "!" === e[n].charAt(0) && ((e[n] = e[n].substring(1)), (this.D["safe-images"] = this.D["safe-images"] || []), this.D["safe-images"].push(e[n])),
                        t.push([e[n], "image"])),
                        "src" === n &&
                            "" !== e[n] &&
                            "zc." !== e[n].substring(0, 3) &&
                            -1 !== r.indexOf(".images.") &&
                            (!ZC.ie67 && ZC.PATTERNS && "PATTERN_" === e[n].substring(0, 8) && (e[n] = ZC.PATTERNS[e[n].substring(8)]),
                            "!" === e[n].charAt(0) && ((e[n] = e[n].substring(1)), (this.D["safe-images"] = this.D["safe-images"] || []), this.D["safe-images"].push(e[n])),
                            t.push([e[n], "image"])),
                        ".csv" === r.substr(r.length - 4, 4) && "string" == typeof e[n] && t.push([e[n], "csv"]),
                        "url" === n && (-1 !== r.indexOf(".style.") && t.push([e[n], "css"]), -1 !== r.indexOf(".csv.") && t.push([e[n], "csv"]), -1 !== r.indexOf(".marker.") && t.push([e[n], "image"])),
                        "string" == typeof e[n] && "url" !== n && ((0 === e[n].indexOf("url:") && "values" === n) || 0 === e[n].indexOf("javascript:")) && -1 === ZC.AV(["format", "text", "tooltipText"], ZC.EE(n)) && t.push([e[n], "data"]);
                }
            return t;
        },
        Q8: function (J9) {
            var s = this;
            if (zingchart.DEV.RESOURCES) {
                var J3 = s.A46(s.o).concat(s.A46(s.MN));
                if (0 !== J3.length) {
                    var UP = 0,
                        LI = {},
                        A1M = 0;
                    s.D["safe-images"] = s.D["safe-images"] || [];
                    var C4 = window.setInterval(function () {
                        if (UP >= J3.length) {
                            for (var e in (window.clearInterval(C4), s.ABM(s.o), LI))
                                if (0 !== e.indexOf("data:") && -1 === ZC.AV(s.D["safe-images"], e))
                                    try {
                                        var i = document.createElement("canvas");
                                        (i.width = LI[e].width), (i.height = LI[e].height), i.getContext("2d").drawImage(LI[e], 0, 0);
                                        var t = i.toDataURL("image/png");
                                        (LI[e].onload = null), (LI[e].onerror = null), (LI[e].src = t), (ZC.cache.data[e] = LI[e]);
                                    } catch (n) {}
                            window.setTimeout(function () {
                                zingchart.Y1[s.L] && J9();
                            }, 1);
                        } else A2Y(++A1M);
                    }, 20);
                    A2Y(A1M);
                } else zingchart.Y1[s.L] && J9();
            } else zingchart.Y1[s.L] && J9();
            function A2Y(i) {
                if (!(i >= J3.length)) {
                    var EV,
                        MI,
                        KE = J3[i][0],
                        A0I = J3[i][1];
                    if ("url:" === KE.substring(0, 4)) {
                        var QK = KE.substring(4);
                        s.QY["url:" + QK] = "[]";
                        try {
                            (EV = ["query-string" === s.N6 ? "zcrandom=" + Math.random() : ""].join("&")),
                                ZC.A5.ajax({
                                    type: "GET",
                                    url: QK,
                                    beforeSend: function (e) {
                                        s.RY.data || "http-headers" !== s.N6 || e.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
                                    },
                                    data: EV,
                                    error: function (e, i, t, n) {
                                        return s.NY({ name: "Network error", message: "Resource not found (" + n + ")" }, "URL Data loader"), !1;
                                    },
                                    success: function (e, i, t, n) {
                                        (s.QY["url:" + n] = e), UP++;
                                    },
                                });
                        } catch (JA) {
                            return s.NY(JA, "URL Data loader"), !1;
                        }
                    } else if ("javascript:" === KE.substring(0, 11))
                        if ("zc.ext.load" === s.QY[KE]) {
                            s.QY[KE] = "[]";
                            var DX = ZC.AP.AAG(KE.substring(11)),
                                N = {
                                    id: s.L,
                                    resource: KE,
                                    callback: function (e) {
                                        (s.QY[KE] = e), UP++;
                                    },
                                },
                                ZY = DX[0];
                            N.arguments = DX[1];
                            try {
                                var ZG = eval(ZY).call(s, N);
                                null !== ZC._n_(ZG) && ZG && ((s.QY[KE] = ZG), UP++);
                            } catch (JA) {
                                return s.NY(JA, "JavaScript data loader"), !1;
                            }
                        } else UP++;
                    else
                        "image" === A0I
                            ? ((LI[KE] = new Image()),
                              (LI[KE].crossOrigin = "anonymous"),
                              (LI[KE].onload = function () {
                                  UP++;
                              }),
                              (LI[KE].onerror = function () {
                                  var e = ZC._b_(s.o.strict);
                                  if ((ZC.IMG404.push(KE), e)) return s.NY({ name: "Network error", message: "Resource not found (" + this.src + ")" }, "Resource loader (image)"), !1;
                                  (this.src = ZC.BLANK), UP++;
                              }),
                              (LI[KE].src = KE),
                              (ZC.cache.data[KE] = LI[KE]))
                            : "css" === A0I
                            ? ((EV = ["query-string" === s.N6 ? "zcrandom=" + Math.random() : ""].join("&")),
                              ZC.A5.ajax({
                                  type: "GET",
                                  url: KE,
                                  beforeSend: function (e) {
                                      s.RY.css || "http-headers" !== s.N6 || e.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
                                  },
                                  data: EV,
                                  error: function (e, i, t) {
                                      return s.NY(t, "Resource loader"), !1;
                                  },
                                  success: function (e) {
                                      for (var i = {}, t = e.match(/[a-zA-Z0-9\.\#\-](.+?)\{((.|\s)+?)\}/gi), n = 0, a = t.length; n < a; n++) {
                                          MI = t[n].split("{");
                                          var l = ZC.GW(MI[0]),
                                              o = l.split(/\s+/);
                                          if (1 === o.length || (2 === o.length && ZC.GW(o[0]) === "#" + s.L)) {
                                              i[(l = ZC.GW(1 === o.length ? o[0] : o[1]))] || (i[l] = {});
                                              for (var r = 0, A = (MI = MI[1].replace("}", "").split(";")).length; r < A; r++) {
                                                  var C = MI[r].split(":");
                                                  2 === C.length && (i[l][ZC.GW(C[0])] = "" + ZC.GW(C[1]));
                                              }
                                          }
                                      }
                                      null !== ZC._n_(s.o.style) ? ZC._cp_(i, s.o.style) : null !== ZC._n_(s.o.graphset) && 1 === s.o.graphset.length && s.o.graphset[0].style && ZC._cp_(i, s.o.graphset[0].style), UP++;
                                  },
                              }))
                            : "csv" === A0I &&
                              ((EV = ["query-string" === s.N6 ? "zcrandom=" + Math.random() : ""].join("&")),
                              ZC.A5.ajax({
                                  type: "GET",
                                  url: KE,
                                  beforeSend: function (e) {
                                      s.RY.csv || "http-headers" !== s.N6 || e.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
                                  },
                                  data: EV,
                                  error: function (e, i, t) {
                                      return s.NY(t, "Resource loader"), !1;
                                  },
                                  success: function (e, i, t, n) {
                                      (s.A9F[n] = e), UP++;
                                  },
                              }));
                }
            }
        },
        ABM: function (BZ) {
            var s = this;
            for (var p in BZ)
                if ("object" == typeof BZ[p]) s.ABM(BZ[p]);
                else for (var EV in s.QY) EV === BZ[p] && (BZ[p] = eval(s.QY[EV]));
        },
        resize: function (e) {
            var i,
                t,
                n,
                a,
                l = this;
            if (((l.D.resize = !0), (l.D.wh = l.I + "/" + l.F), l.o.graphset))
                if (l.A1F) zingchart.exec(l.L, "destroy"), zingchart.render(zingchart.params[l.L]);
                else {
                    for (void 0 === e && (e = !1), t = 0; t < l.AG.length; t++)
                        null !== ZC._n_(l.H2) && l.H2.IM && l.H2.TI(null),
                            null !== ZC._n_(l.AG[t].HQ) && l.AG[t].HQ.IM && l.AG[t].HQ.M8(null),
                            null !== ZC._n_(l.AG[t].HP) && l.AG[t].HP.IM && l.AG[t].HP.M8(null),
                            null !== ZC._n_(l.AG[t].B9) && l.AG[t].B9.A3F && l.AG[t].B9.TO();
                    if ((ZC.AP.C0("resize", l, l.FG()), (e = !1)));
                    else {
                        for (t = 0; t < l.AG.length; t++) for (a = 0; a < l.AG[t].AZ.A3.length; a++) l.D["g-" + t + "-p-" + a + ".visible"] = l.AG[t].D["plot" + a + ".visible"];
                        for (t = 0; t < l.AG.length; t++) l.D["g-" + l.AG[t].K + "-selection"] = JSON.stringify(l.AG[t].CD);
                        for (var o = l.o.graphset, r = ["labels", "shapes"], s = 0, A = o.length; s < A; s++)
                            for (var C = 0; C < r.length; C++) {
                                var c = r[C],
                                    u = [];
                                if (null !== ZC._n_(o[s][c])) {
                                    for (t = 0, n = o[s][c].length; t < n; t++) o[s][c][t].generated || u.push(o[s][c][t]);
                                    o[s][c] = u;
                                }
                            }
                        if (
                            (l.XU(l.o),
                            (l.o = ZC.AP.C0("dataparse", l, l.FG(), l.o)),
                            ZC.A5("#" + l.L + "-top")
                                .width(l.I)
                                .height(l.F),
                            l.D["from-api"] &&
                                (ZC.A5("#" + l.L + "-wrapper")
                                    .width(l.I)
                                    .height(l.F),
                                delete l.D["from-api"]),
                            1 === (i = ZC.A5("#" + l.L + "-img")).length &&
                                i
                                    .width(l.I)
                                    .height(l.F)
                                    .css("clip", "rect(1px," + (l.I - 1) + "px," + (l.F - 1) + "px,1px)"),
                            "svg" === l.AC && (l.KD.setAttribute("width", l.I), l.KD.setAttribute("height", l.F)),
                            "canvas" === l.AC || "vml" === l.AC)
                        ) {
                            for (
                                ZC.A5("#" + l.L + "-main")
                                    .width(l.I)
                                    .height(l.F),
                                    t = 0,
                                    n = l.AG.length;
                                t < n;
                                t++
                            )
                                ZC.A5("#" + l.AG[t].L + "-hover").remove();
                            ZC.A5("#" + l.L + "-main>div")
                                .width(l.I)
                                .height(l.F);
                        }
                        for (
                            "canvas" === l.AC &&
                                ((i = ZC.AL(l.L + "-main-c")) && ((i.width = l.I), (i.height = l.F)),
                                (i = ZC.AL(l.L + "-main-c-top")) && ((i.width = l.I), (i.height = l.F)),
                                ZC.A5("#" + l.L + "-objects-bottom canvas, #" + l.L + "-objects-top canvas, #" + l.L + "-tools canvas").each(function () {
                                    (this.width = l.I), (this.height = l.F);
                                })),
                                "vml" === l.AC &&
                                    ZC.A5("#" + l.L + "-objects-bottom div, #" + l.L + "-objects-top div, #" + l.L + "-tools div").each(function () {
                                        (this.style.width = l.I + "px"), (this.style.height = l.F + "px");
                                    }),
                                l.parse(),
                                t = 0,
                                n = l.AG.length;
                            t < n;
                            t++
                        )
                            l.AG[t].U7 && l.AG[t].U7(), (l.AG[t].HH = !0), (l.AG[t].A65 = l.AG[t].GE), (l.AG[t].GE = !1);
                        for (l.paint(), t = 0; t < l.AG.length; t++) for (a = 0; a < l.AG[t].AZ.A3.length; a++) delete l.D["g-" + t + "-p-" + a + ".visible"];
                        for (t = 0; t < l.AG.length; t++) (l.AG[t].HH = !1), (l.AG[t].GE = l.AG[t].A65), delete l.AG[t].A65, delete l.D["g-" + l.AG[t].K + "-selection"];
                    }
                }
        },
        clearGenerated: function () {
            var e = this.o.graphset,
                i = ["labels", "shapes"];
            if (e)
                for (var t = 0, n = e.length; t < n; t++)
                    for (var a = 0; a < i.length; a++) {
                        var l = i[a],
                            o = [];
                        if (null !== ZC._n_(e[t][l])) {
                            for (var r = 0, s = e[t][l].length; r < s; r++) e[t][l][r].generated || o.push(e[t][l][r]);
                            e[t][l] = o;
                        }
                    }
        },
        clear: function (e, i, t) {
            var n = this;
            for (var a in n.D) -1 !== a.indexOf("-label-") && -1 !== a.indexOf("-bounds") && delete n.D[a];
            if ((void 0 === i && (i = !0), ZC.A5("." + n.L + "-history-area").die("click", n.A0T), ZC.A5("." + n.L + "-history-area").remove(), null !== ZC._n_(e))) n.OS(e).clear();
            else {
                i && n.clearGenerated(), n._unbind_();
                for (var l = 0, o = n.AG.length; l < o; l++) "vml" === n.AC && t ? n.AG[l].destroy() : n.AG[l].clear();
                var r, s, A;
                null !== (r = ZC.AL(n.L + "-main-c")) && ZC.Q.IV(r, n.AC, n.iX, n.iY, n.I, n.F),
                    null !== (A = ZC.AL(n.L + "-main-c-top")) && ZC.Q.IV(A, n.AC, n.iX, n.iY, n.I, n.F),
                    null !== (s = ZC.AL(n.L + "-trigger-c")) && (ZC.Q.IV(s, n.AC, n.iX, n.iY, n.I, n.F), ZC.A5("#" + n.L + "-menu-area").remove()),
                    n.A7 && n.A7.hide(),
                    ZC.A5("." + n.L + "-menu-item").remove(),
                    ZC.Q.ET([n.L + "-menu-trigger", n.L + "-menu"]),
                    ZC.Q.ET(n.L + "-license-text"),
                    null !== n.ID && ZC.Q.ET([n.L + "-history-path", n.L + "-history-back-path", n.L + "-history-forw-path", n.L + "-history-gradient", n.L + "-history-back-gradient", n.L + "-history-forw-gradient"]);
            }
        },
        AB0: function () {
            var e,
                i,
                t,
                n = this,
                a = n.I + "/" + n.F,
                l = ZC.Q.I2({ id: n.L + "-wrapper", position: "relative", p: ZC.AL(n.L) });
            ZC.Q.PI(l, { height: "100%" === n.MT ? n.MT : n.F + "px", width: "100%" === n.G1 ? n.G1 : n.I + "px" }), n.bA11y && ZC.Q.G4(l, { tabindex: 0, "aria-label": "ZingChart " + n.OZ });
            
            var o = ZC.Q.I2({ cls: "zc-rel zc-top", wh: a, id: n.L + "-top", overflow: "hidden", position: "absolute", p: l });
            switch ((zingchart.OFFSET && ((o.style.left = "-0.5px"), (o.style.top = "-0.5px")), n.AC)) {
                case "svg":
                    (n.KD = ZC.Q.F6("svg", "http://www.w3.org/2000/svg")),
                        n.KD.setAttributeNS && n.KD.setAttributeNS(null, "xlink", "http://www.w3.org/1999/xlink"),
                        ZC.Q.G4(n.KD, { version: "1.1", id: n.L + "-svg", class: "zc-svg", width: n.I, height: n.F, display: "block" }),
                        o.appendChild(n.KD);
                    var r = ZC.Q.F6("defs", "http://www.w3.org/2000/svg");
                    if (((r.id = n.L + "-defs"), n.KD.appendChild(r), ZC.Q.JZ({ cls: "zc-rel zc-main", wh: a, id: n.L + "-main", p: n.KD }, n.AC), (n.A2D = []), n.o.graphset))
                        for (e = 0, i = n.o.graphset.length; e < i; e++)
                            if ((t = n.o.graphset[e].resources) && t.length)
                                for (var s = 0; s < t.length; s++)
                                    if ("css" === t[s].type && t[s].url) {
                                        var A = ZC.Q.F6("link", "http://www.w3.org/2000/svg");
                                        ZC.Q.G4(A, { xmlns: "http://www.w3.org/1999/xhtml", href: t[s].url, rel: "stylesheet", type: "text/css" }), n.A2D.push(t[s].url), r.appendChild(A);
                                    }
                    break;
                case "vml":
                case "canvas":
                    ZC.Q.I2({ cls: "zc-rel zc-main", wh: a, id: n.L + "-main", p: o });
            }
        },
        paintHistory: function () {},
        paint: function () {
            var e = this;
            e.MF = "paint";
            var i = e.I + "/" + e.F;
            if ((e.A0O(), null === ZC.AL(e.L + "-top"))) {
                e.AB0();
                var t = ZC.AL(e.L + "-main");
                if ((e.O1.graphset && ZC.Q.HE({ cls: "zc-abs", id: e.L + "-main-c", wh: i, p: t }, e.AC), e.H.usc()))
                    ZC.Q.HE({ cls: "zc-abs", id: e.L + "-main-c-top", wh: i, p: t }, e.AC), ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-print-c", p: t, wh: i, display: "none" }, e.AC);
                else {
                    ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-bottom", p: t }, e.AC),
                        zingchart.DEV.MAPSONBOTTOM && ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-maps", p: t }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-graphset", p: t }, e.AC),
                        zingchart.DEV.MAPSONBOTTOM || ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-maps", p: t }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-top", p: t }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-hover", p: t }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-front", p: t }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs zc-text", wh: i, id: e.L + "-text", p: t }, e.AC);
                    var n = "legend",
                        a = "tools";
                    ("legend" === e.o["top-layer"] || (e.o.graphset && 1 === e.o.graphset.length && "legend" === e.o.graphset[0]["top-layer"])) && ((n = "tools"), (a = "legend")),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-" + n, p: t }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-" + a, p: t }, e.AC);
                    var l = ZC.AL(e.L + "-tools");
                    e.O1["static"] && ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-static-c", wh: i, p: l }, e.AC),
                        e.O1.guide && ZC.Q.HE({ cls: "zc-abs zc-layer zc-guide-c", id: e.L + "-guide-c", wh: i, p: l }, e.AC),
                        ((ZC.A5.browser.opera && ZC._i_(ZC.A5.browser.version) <= 9.5) || ZC.mobile || "classic" !== e.LJ) && ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-trigger-c", wh: i, p: l }, e.AC),
                        ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-print-c", p: l, wh: i, display: "none" }, e.AC),
                        ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-textprint-c", p: l, wh: i, display: "none" }, e.AC),
                        ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-text-top", p: t }, e.AC);
                }
                if (!zingchart.DEV.SKIPTRACKERS) {
                    var o = document.createElement("img");
                    if (
                        ((o.id = e.L + "-img"),
                        (o.className = "zc-img"),
                        o.setAttribute("useMap", "#" + e.L + "-map"),
                        o.setAttribute("alt", "ZingChart " + e.OZ),
                        ZC.Q.PI(o, {
                            position: "absolute",
                            borderWidth: 0,
                            width: e.I + 2 * ZC.MAPTX + "px",
                            height: e.F + 2 * ZC.MAPTX + "px",
                            left: -ZC.MAPTX + "px",
                            top: -ZC.MAPTX + "px",
                            zIndex: 0,
                            opacity: 0,
                            filter: "alpha(opacity=0)",
                            clip: "rect(" + (ZC.MAPTX + 1) + "px," + (e.I + ZC.MAPTX - 1) + "px," + (e.F + ZC.MAPTX - 1) + "px," + (ZC.MAPTX + 1) + "px)",
                        }),
                        (o.src = (ZC.ie67 ? "//" : "") + ZC.BLANK),
                        ZC.AL(e.L + "-top").appendChild(o),
                        !e.H.usc())
                    ) {
                        var r = document.createElement("map");
                        (r.className = "zc-map"), ZC.Q.G4(r, { id: e.L + "-map", name: e.L + "-map" }), ZC.AL(e.L + "-top").appendChild(r);
                        for (var s = 0; s < e.AG.length; s++) r.innerHTML += '<area shape="rect" coords="0,0,1,1" id="mark' + s + '">';
                    }
                }
            }
            (e.Z = ZC.AL(e.L + "-main-c")), e.b();
            var A,
                C,
                c = !1,
                u = !1;
            for (A = 0, C = e.AG.length; A < C; A++) {
                e.AG[A].paint(), ((null !== e.AG[A].CX && e.AG[A].CX.AN) || (null !== e.AG[A].HB && e.AG[A].HB.AN)) && (c = !0);
                for (var p = 0; p < e.AG[A].BO.length; p++)
                    if (e.AG[A].BO[p].GN) {
                        u = !0;
                        break;
                    }
            }
            if (e.G2) {
                for (var Z in e.G2) ZC.AL(Z).appendChild(e.G2[Z]);
                e.G2 = null;
            }
            if (
                ((e.D.preservezoom = null),
                e.TM ||
                    e.UC ||
                    (e.YV
                        ? e.A8R()
                        : (e.YV = window.setInterval(function () {
                              e.A8Q(), e.TM || e.UC ? (window.clearInterval(e.YV), ZC.Q.ET(e.L + "-license-text")) : ZC.AL(e.L + "-license-text") || e.A8R();
                          }, 2e3))),
                ZC.A5("." + e.L + "-node-area").live("focus", function (e) {
                    var i = e.target.id.split("-");
                    "plot" === i[4] && "node" === i[6] && zingchart.exec(i[0], "showtooltip", { graphid: i[2], plotindex: i[5], nodeindex: i[7] });
                }),
                -1 === ZC.AV(e.KP, "skip_context_menu") && e.A5U(),
                -1 === ZC.AV(e.KP, "skip_interactivity")
                    ? ("undefined" != typeof ZC.A24 && (e.A7 = new ZC.A24(e)),
                      u && e.H2.bind(),
                      c && "undefined" != typeof ZC.JR && ((e.D7 = new ZC.JR(e)), e.D7.bind()),
                      ZC.mobile &&
                          ((e.AFW = function (i) {
                              (ZC.swipe = { xy: ZC.Q.MD(i), ts: new Date().getTime() }),
                                  i.target.id === e.L + "-menu-area"
                                      ? ((ZC.move = !1), e.A7 && e.A7.hide(), zingchart.YP(i))
                                      : (null === e.DG || null === ZC._n_(e.DG["page-scroll"]) || e.DG["page-scroll"] || i.preventDefault(), (ZC.move = !1), e.hideCM(), e.A7 && e.A7.hide(), e.YF(i));
                          }),
                          (e.OQ = function () {
                              window.clearTimeout(e.AB3), (e.A3V = null);
                          }),
                          (e.AFT = function (i) {
                              if (ZC.swipe) {
                                  var t = ZC.Q.MD(i);
                                  if (ZC._a_(t[0] - ZC.swipe.xy[0]) > 100 && new Date().getTime() - ZC.swipe.ts < 1e3) {
                                      var n = e.FG();
                                      (n.direction = t[0] > ZC.swipe.xy[0] ? "right" : "left"), ZC.AP.C0("swipe", e, n);
                                  }
                                  ZC.swipe = null;
                              }
                              e.AAB || ZC.move || zingchart.S9(i), e.OQ(i);
                          }),
                          ZC.A5("#" + e.L + "-img")
                              .bind("touchstart", e.AFW)
                              .bind("touchmove", e.OQ)
                              .bind("touchend", e.AFT),
                          ZC.A5("#" + e.L + "-menu-area").live("touchstart", e.AFW)),
                      (e.zc_loader_mousewheel = function (i) {
                          var t = e.FG();
                          (t.ev = i), ZC.AP.C0("mousewheel", e, t);
                      }),
                      ZC.A5("#" + e.L + "-img").bind("mousewheel", e.zc_loader_mousewheel),
                      ZC.A5("#" + e.L + "-map").bind("mousewheel", e.zc_loader_mousewheel),
                      "svg" === e.AC && ZC.A5("#" + e.L + "-svg").bind("mousewheel", e.zc_loader_mousewheel),
                      (e.A27 = function (i) {
                          27 === i.keyCode && e.QL && (e.A7M || e.A96());
                      }),
                      ZC.A5(document).bind("keyup", e.A27),
                      (e.A96 = function () {
                          ZC.A5("#" + e.L + "-menu-item-exitfullscreen").die("click", e.A96),
                              (ZC.FSSTATUS = null),
                              ZC.Q.ET(e.L + "-data-table"),
                              e.destroy(),
                              zingchart.FSID && ZC.AL(zingchart.FSID) && (ZC.AL(zingchart.FSID).style.display = "none");
                      }),
                      ZC.A5("#" + e.L + "-menu-item-exitfullscreen").live("click", e.A96))
                    : ZC.mobile &&
                      ((e.zc_loader_touchstart_static = function (e) {
                          return e.preventDefault(), zingchart.S9(e), !1;
                      }),
                      ZC.A5("#" + e.L + "-img").bind("touchstart", e.zc_loader_touchstart_static)),
                null !== e.HS)
            ) {
                var h = ZC._i_(e.HS.interval);
                (h = h >= 50 ? h : 1e3 * h),
                    window.setTimeout(function () {
                        e.N3(), e.load();
                    }, h);
            }
            (e.MF = ""),
                (ZC.TS[e.L] = new Date().getTime() - ZC.TS[e.L]),
                e.D["fire-complete"] && (ZC.AP.C0("complete", e, e.FG()), (e.D["fire-complete"] = null)),
                e.D["fire-load"] && (ZC.AP.C0("load", e, e.FG()), (e.D["fire-load"] = null));
        },
        togglePreviewMasks: function (e) {
            for (var i = this, t = 0; t < i.AG.length; t++) i.AG[t].B9 && i.AG[t].B9.toggleMasks(e);
        },
        createPreviewMasks: function () {
            var e = this,
                i = document.createElement("canvas");
            (i.width = e.I), (i.height = e.F), i.setAttribute("class", "");
            for (var t = 0; t < e.AG.length; t++) e.AG[t].B9 && e.AG[t].B9.toggleMasks(!0, i);
            return i;
        },
        AGC: function () {
            null === ZC._n_(ZC.showZCAbout) &&
                (ZC.showZCAbout = function (e) {
                    zingchart.exec(e.id, "toggleabout");
                }),
                zingchart.exec(this.L, "addmenuitem", { text: "About ZingChart", function: "ZC.showZCAbout()", order: 100 });
        },
        A8R: function () {
            var e,
                i = this,
                t = {},
                n = i.DG.watermark;
            i.B8.load(t, "loader.gui.watermark"), n && ZC._cp_(n, t), 1 === i.o.graphset.length && i.o.graphset[0].gui && (e = i.o.graphset[0].gui.watermark) && ZC._cp_(e, t);
            var a = ZC._l_(ZC._i_(t.type || 1), 1, 2),
                l = t.position || "br";
            -1 === ZC.AV(["tl", "tr", "br", "bl"], l) && (l = "br"), (i.ACS = l);
            var o,
                r = 32,
                s = 146,
                A = 0,
                C = 1;
            ZC.ie67 && ((r = 30), (s = 168), (A = 8), (C = 1)), (s = 126), (r = 22);
            var c = { light: ["#6D6E71", "#00384A"], dark: ["#FFFFFF", "#09A9DA"] },
                u = c.light;
            if ((zingchart.THEME && (u = "light" === i.LJ || "classic" === i.LJ ? c.light : c.dark), 1 === i.o.graphset.length))
                if (i.o.graphset[0]["background-color"]) {
                    var p = ZC.AP.G9(i.o.graphset[0]["background-color"]);
                    7 === p.length && (u = ZC.AP.A9Z(p, c.dark, c.light));
                } else if (i.o.graphset[0].theme) {
                    var Z = i.o.graphset[0].theme;
                    u = "light" === Z || "classic" === Z ? c.light : c.dark;
                }
            var h,
                d,
                f = "undefined" != typeof window && window.location ? window.location.origin : "",
                _ = "undefined" != typeof window && window.location ? window.location.pathname : "";
            switch (((o = ""), l)) {
                case "br":
                    (h = i.F - r), (d = i.I - s);
                    break;
                case "bl":
                    (h = i.F - r), (d = 6);
                    break;
                case "tr":
                    (h = 2), (d = i.I - s);
                    break;
                case "tl":
                    (h = 2), (d = 6);
            }
            null !== ZC._n_((e = ZC.AL(i.L + "-top"))) &&
                ZC.Q.I2({
                    cls: ZC.ie67 ? "-ie67" : "",
                    p: e,
                    id: i.L + "-license-text",
                    tl: h + "/" + d,
                    wh: s + "/" + (r - A),
                    color: ZC.ie67 ? (1 === a ? "#369" : "#fff") : "",
                    padding: A,
                    opacity: C,
                    position: "absolute",
                    cursor: "pointer",
                    fontFamily: zingchart.FONTFAMILY,
                    html: o,
                });
        },
        _unbind_: function () {
            var e = this;
            ZC.A5("#" + e.L + "-menu").die("mousedown", e.TP),
                ZC.A5("." + e.L + "-menu-item").die("mousedown", e.TP),
                ZC.A5("." + e.L + "-menu-item")
                    .die("click touchend", e.AGR)
                    .die("mouseover", e.AG8)
                    .die("mouseout", e.AGN),
                (e.D["menu-item-events"] = !1),
                ZC.A5("." + e.L + "-node-area").die("focus"),
                null !== e.H2 && e.H2.unbind(),
                null !== e.D7 && e.D7.unbind(),
                ZC.mobile &&
                    (ZC.A5("#" + e.L + "-img")
                        .unbind("touchstart", e.AFW)
                        .unbind("touchmove", e.OQ)
                        .unbind("touchend", e.AFT),
                    ZC.A5("#" + e.L + "-menu-area").die("touchstart", e.AFW),
                    ZC.A5("#" + e.L + "-img").unbind("touchstart", e.zc_loader_touchstart_static)),
                ZC.A5("#" + e.L + "-img").unbind("mousewheel", e.zc_loader_mousewheel),
                ZC.A5("#" + e.L + "-map").unbind("mousewheel", e.zc_loader_mousewheel),
                "svg" === e.AC && ZC.A5("#" + e.L + "-svg").unbind("mousewheel", e.zc_loader_mousewheel),
                ZC.A5(document).unbind("keyup", e.A27),
                ZC.A5("#" + e.L + "-menu-item-exitfullscreen").die("click", e.A96);
        },
        VK: function (e, i, t) {
            void 0 === t && (t = !1);
            var n = ZC.AL("zc-menu-" + (t ? "sep" : "item") + "-" + e);
            n && (n.style.display = i ? "block" : "none");
        },
        A5U: function (LG, ev) {
            if (!zingchart.DEV.SKIPCONTEXTMENU) {
                var s = this,
                    G,
                    i,
                    A6,
                    j,
                    JC;
                void 0 === LG && (LG = -1);
                var DG = {};
                ZC._cp_(s.DG, DG), -1 !== LG && s.o.graphset[LG] && ZC._cp_(s.o.graphset[LG].gui, DG, null, null, !0), ZC.A5("#" + s.L + "-menu").remove();
                var PH = [];
                for ("undefined" == typeof ZC.AO && PH.push({ id: "3D", enabled: "none" }, { id: "SwitchTo3D", enabled: "none" }, { id: "SwitchTo2D", enabled: "none" }), i = DG.behaviors.length - 1; i > 0; i--)
                    for (var sBId = DG.behaviors[i].id, ii = i - 1; ii >= 0; ii--) DG.behaviors[ii].id === sBId && DG.behaviors.splice(ii, 1);
                if (null !== ZC._n_((G = DG.behaviors)))
                    for (i = 0, A6 = G.length; i < A6; i++) {
                        var NC = !1;
                        for (j = 0, JC = PH.length; j < JC; j++) PH[j].id === G[i].id && (NC = !0);
                        NC || PH.push(G[i]);
                    }
                var JI = DG["context-menu"],
                    OJ = DG["context-menu[mobile]"];
                for (i = 0, A6 = PH.length; i < A6; i++) null !== ZC._n_(PH[i]["function"]) && (null === ZC._n_(JI) && (JI = {}), null === ZC._n_(JI["custom-items"]) && (JI["custom-items"] = []), JI["custom-items"].push(PH[i]));
                JI["custom-items"] &&
                    JI["custom-items"].sort(function (e, i) {
                        return ZC._i_(e.order || "0") > ZC._i_(i.order || "0");
                    }),
                    (s.MZ = new ZC.DN(s));
                var A15 = s.LJ.split(/\s+|;|,/),
                    E2,
                    LC,
                    U6,
                    ABA,
                    GT;
                for (i = 0, A6 = A15.length; i < A6; i++)
                    if (s.B8.NS[A15[i]]) {
                        var A13 = s.B8.NS[A15[i]].root || {};
                        A13 && A13.gui && A13.gui.contextMenu && ZC._cp_(A13.gui.contextMenu, s.MZ.o);
                    }
                if ((s.B8.load(s.MZ.o, "loader.gui.context-menu"), JI && s.MZ.append(JI), ZC.mobile && (s.B8.load(s.MZ.o, "loader.gui.context-menu[mobile]"), OJ && s.MZ.append(OJ)), (s.MZ.V2 = !0), s.MZ.parse(), s.MZ.AN || !s.A3Z)) {
                    if (!ZC.AL(s.L + "-menu-area")) {
                        var A54 = !!(s.DG && s.DG["context-menu"] && s.DG["context-menu"].button) && ZC._n_(s.DG["context-menu"].button.visible);
                        if (A54 || ("classic" !== s.LJ && A54)) {
                            (GT = new ZC.DN(s)),
                                s.B8.load(GT.o, "loader.gui.context-menu.button"),
                                JI && ZC._n_(null !== (G = JI.button)) && GT.append(G),
                                ZC.mobile && (s.B8.load(GT.o, "loader.gui.context-menu[mobile].button"), OJ && null !== ZC._n_((G = OJ.button)) && GT.append(G)),
                                ZC._cp_(s.MZ.o, JI);
                            var A6Z = "left" === JI.position || "classic" === s.LJ;
                            if (((GT.L = s.L + "-menu-trigger"), (GT.IL = ZC.AL(s.L + "-tools")), (GT.Z = GT.C7 = ZC.AL(s.L + "-trigger-c")), (GT.V2 = !0), GT.parse(), GT.AN)) {
                                GT.paint();
                                var DD = ZC.A5("#" + s.H.L + "-top");
                                if ("" === GT.AM) {
                                    var N2 = new ZC.DU(s);
                                    if (
                                        ((N2.CZ = !1),
                                        s.B8.load(N2.o, "loader.gui.context-menu.gear"),
                                        JI && null !== ZC._n_((G = JI.gear)) && N2.append(G),
                                        ZC.mobile && (s.B8.load(N2.o, "loader.gui.context-menu[mobile].gear"), OJ && null !== ZC._n_((G = OJ.gear)) && N2.append(G)),
                                        (N2.L = s.L + "-menu-trigger-gear"),
                                        (N2.IL = ZC.AL(s.L + "-tools")),
                                        (N2.Z = ZC.AL(s.L + "-trigger-c")),
                                        (N2.iX = A6Z ? GT.iX + GT.I / 2 : DD.width() - (GT.iX + GT.I / 2)),
                                        (N2.iY = GT.iY + GT.F / 2),
                                        (N2.AI = ZC.CY(GT.I, GT.F) / 4.5),
                                        N2.parse(),
                                        N2.paint(),
                                        "hamburger" !== N2.DS)
                                    ) {
                                        var QI = new ZC.DU(s);
                                        QI.copy(GT),
                                            (QI.L = s.L + "-menu-trigger-gear-hole"),
                                            (QI.IL = ZC.AL(s.L + "-tools")),
                                            (QI.Z = ZC.AL(s.L + "-trigger-c")),
                                            (QI.DS = "circle"),
                                            (QI.AI = ZC.CY(GT.I, GT.F) / 7),
                                            QI.parse(),
                                            (QI.iX = A6Z ? GT.iX + GT.I / 2 : DD.width() - (GT.iX + GT.I / 2)),
                                            (QI.iY = GT.iY + GT.F / 2),
                                            QI.paint();
                                    }
                                }
                                var _iX = A6Z ? GT.iX : DD.width() - (GT.iX + GT.I);
                                ZC.AL(s.L + "-map").innerHTML +=
                                    ZC.Q.FX("rect") + 'id="' + s.L + '-menu-area" coords="' + ZC._i_(_iX + ZC.MAPTX) + "," + ZC._i_(GT.iY + ZC.MAPTX) + "," + ZC._i_(_iX + GT.I + ZC.MAPTX) + "," + ZC._i_(GT.iY + GT.F + ZC.MAPTX) + '" />';
                            }
                        }
                    }
                    (E2 = new ZC.DN(s)),
                        s.B8.load(E2.o, "loader.gui.context-menu.item"),
                        JI && null !== ZC._n_((G = JI.item)) && E2.append(G),
                        ZC.mobile && (s.B8.load(E2.o, "loader.gui.context-menu[mobile].item"), OJ && null !== ZC._n_((G = OJ.item)) && E2.append(G)),
                        (E2.V2 = !0),
                        E2.parse(),
                        (LC = new ZC.DN(s)),
                        LC.copy(E2),
                        s.B8.load(LC.o, "loader.gui.context-menu.item.hover-state"),
                        JI && null !== ZC._n_(JI.item) && null !== ZC._n_((G = JI.item["hover-state"])) && LC.append(G),
                        ZC.mobile && (s.B8.load(LC.o, "loader.gui.context-menu[mobile].item.hover-state"), OJ && null !== ZC._n_(OJ.item) && null !== ZC._n_((G = OJ.item["hover-state"])) && LC.append(G)),
                        (LC.V2 = !0),
                        LC.parse(),
                        (U6 = {}),
                        JI && null !== ZC._n_(JI.separator) && (U6 = JI.separator);
                    var JU = [],
                        EK = null;
                    if (
                        ((ABA = null !== ZC._n_(s.MZ.o.empty) && ZC._b_(s.MZ.o.empty)),
                        ZC.mobile &&
                            ((EK = G7("PageScroll")),
                            "none" !== EK.enabled &&
                                (null === s.DG || null === ZC._n_(s.DG["page-scroll"]) || s.DG["page-scroll"] ? JU.push(GV("disablepagescroll", EK.text)) : JU.push(GV("enablepagescroll", EK.text)), JU.push(JB("pagescroll")))),
                        (EK = G7("Reload")),
                        "none" !== EK.enabled && (JU.push(GV("reload", EK.text)), JU.push(JB("reload"))),
                        "undefined" != typeof ZC.A7N)
                    ) {
                        (EK = G7("SaveAsImage")),
                            "none" !== EK.enabled &&
                                ((EK = G7("SaveAsImagePNG")),
                                "none" !== EK.enabled && JU.push(GV("viewaspng", EK.text ? EK.text : null)),
                                (EK = G7("SaveAsImageJPG")),
                                "none" !== EK.enabled && JU.push(GV("viewasjpg", EK.text ? EK.text : null)),
                                JU.push(JB("export")));
                        var TC = ["DownloadPDF", "DownloadSVG", "DownloadCSV", "DownloadXLS", "ViewDataTable", "ExportData", "Print"],
                            A6A = 0,
                            A20 = 0;
                        for (i = 0; i < TC.length; i++)
                            "ViewDataTable" === TC[i] && ZC.AL(s.L + "-data-table") && (TC[i] = "HideDataTable"), (EK = G7(TC[i])), "none" !== EK.enabled && (A6A++, (A20 = i), JU.push(GV(TC[i].toLowerCase(), EK.text)));
                        A6A > 0 && JU.push(JB(TC[A20].toLowerCase()));
                    }
                    if (-1 !== LG) {
                        var GN = !1;
                        for (j = 0, JC = s.AG[LG].BO.length; j < JC; j++) s.AG[LG].BO[j].GN && (GN = !0);
                        if (GN && "undefined" != typeof ZC.A4X) {
                            var A0X = !1;
                            (EK = G7("ZoomIn")),
                                "none" !== EK.enabled && (JU.push(GV("zoomin", EK.text)), (A0X = !0)),
                                (EK = G7("ZoomOut")),
                                "none" !== EK.enabled && (JU.push(GV("zoomout", EK.text)), (A0X = !0)),
                                (EK = G7("ViewAll")),
                                "none" !== EK.enabled && (JU.push(GV("viewall", EK.text)), (A0X = !0)),
                                A0X && JU.push(JB("zoom"));
                        }
                    }
                    var b2D = !1,
                        b3D = !1;
                    if (
                        (-1 !== LG &&
                            (-1 !== ZC.AV(["line", "area", "bar", "vbar", "hbar", "pie", "mixed"], s.AG[LG].AF) && ((b2D = !0), (s.XC = "2d")),
                            -1 !== ZC.AV(["line3d", "area3d", "bar3d", "vbar3d", "hbar3d", "pie3d", "mixed3d"], s.AG[LG].AF) && ((b3D = !0), (s.XC = "3d"))),
                        (b2D || b3D) &&
                            ((EK = G7("3D")), "none" !== EK.enabled && ((EK = G7(b2D ? "SwitchTo3D" : "SwitchTo2D")), "none" !== EK.enabled && (JU.push(GV(b2D ? "switchto3d" : "switchto2d", EK.text)), JU.push(JB("dimension"))))),
                        -1 !== LG)
                    ) {
                        var C = s.AG[LG],
                            AAO = !1,
                            ABI = !1;
                        for (j = 0; j < C.BO.length; j++) {
                            var B = C.BO[j];
                            0 === B.BF.indexOf("scale-y") && (AAO = !0), "log" === B.BS && (ABI = !0);
                        }
                        AAO &&
                            ((EK = G7("Progression")), "none" !== EK.enabled && ((EK = G7(ABI ? "LinScale" : "LogScale")), "none" !== EK.enabled && (JU.push(GV(ABI ? "switchtolin" : "switchtolog", EK.text)), JU.push(JB("progression"))))),
                            (C.CX || C.HB) &&
                                ((EK = G7("Guide")), "none" !== EK.enabled && ((EK = G7(C.A1N ? "HideGuide" : "ShowGuide")), "none" !== EK.enabled && (JU.push(GV(C.A1N ? "hideguide" : "showguide", EK.text)), JU.push(JB("guide")))));
                    }
                    var AB2 = 0,
                        B6;
                    if (
                        ("undefined" != typeof ZC.A92 &&
                            ((EK = G7("ViewSource")), "none" !== EK.enabled && (JU.push(GV("viewsource", EK.text)), AB2++), (EK = G7("BugReport")), "none" !== EK.enabled && (JU.push(GV("bugreport", EK.text)), AB2++)),
                        AB2 > 0 && JU.push(JB("tools")),
                        (EK = G7("FullScreen")),
                        "none" === EK.enabled || s.LT || (s.QL ? ((EK = G7("ExitFullScreen")), JU.push(GV("exitfullscreen", EK.text)), JU.push(JB("exitfullscreen"))) : (JU.push(GV("fullscreen", EK.text)), JU.push(JB("fullscreen")))),
                        s.ID && ((EK = G7("GoBack")), "none" !== EK.enabled && JU.push(GV("goback", EK.text)), (EK = G7("GoForward")), "none" !== EK.enabled && JU.push(GV("goforward", EK.text)), JU.push(JB("history"))),
                        JU.length > 0 && -1 !== JU[JU.length - 1].indexOf("zc-menu-sep") && JU.splice(JU.length - 1, 1),
                        (s.A1X = {}),
                        -1 !== LG)
                    )
                        if (JI && null !== ZC._n_((B6 = JI["custom-items"])))
                            for (JU.length > 0 && JU.push(JB("custom")), i = 0, A6 = B6.length; i < A6; i++) {
                                var A3A = !0;
                                if ((null !== ZC._n_(B6[i].enabled) && ("none" === B6[i].enabled ? (A3A = !1) : "all" !== B6[i].enabled && (A3A = !ev || eval(B6[i].enabled).call(s, zingchart.A0C(ev, s), B6[i].id, ev))), A3A)) {
                                    var AM,
                                        L = B6[i].id || "custom-" + i;
                                    "sep" === B6[i].id || "sep" === B6[i].type
                                        ? JU.push(JB(L, !0))
                                        : "header" === B6[i].type
                                        ? ((AM = B6[i].text || "Custom Menu " + i), JU.push(A2X(L, AM, !0)))
                                        : ((AM = B6[i].text || "Custom Menu " + i), (s.A1X[L] = { fn: B6[i]["function"] || "", url: B6[i].url || "", target: B6[i].target || "" }), JU.push(GV(L, AM, !0)));
                                }
                            }
                    s.TM || (JU.push(JB("zingchart")), JU.push(GV("xmiabt", "About ZingChart"))),
                        ZC.Q.I2({
                            id: s.L + "-menu",
                            p: document.body,
                            cls: "zc-menu zc-style",
                            top: null === ZC._n_(GT) ? 0 : GT.iY + GT.F / 2,
                            left: null === ZC._n_(GT) ? 0 : GT.iX + GT.I / 2,
                            borderBottom: s.MZ.AU + "px solid " + s.MZ.BX,
                            background: (-1 === s.MZ.A0 ? "transparent" : s.MZ.A0) + " " + A1L(s.MZ.DB),
                            paddingTop: s.MZ.FM,
                            paddingRight: s.MZ.FN,
                            paddingBottom: s.MZ.FT,
                            paddingLeft: s.MZ.EQ,
                            html: JU.join(""),
                        }),
                        s.D["menu-item-events"] ||
                            ((s.AGR = function (e) {
                                var i,
                                    t = 1 !== e.target.nodeType ? e.target.parentNode.id : e.target.id,
                                    n = t.substring(0, t.indexOf("-menu-item-")),
                                    a = zingchart.getLoader(n);
                                ZC.mobile && a.OQ();
                                var l = a.A4C(a.SQ[0], a.SQ[1]);
                                a.hideCM(), ZC.mobile && zingchart.S9(e);
                                var o = t.replace(a.L + "-menu-item-", "");
                                a.AAI({ graphid: l ? l.L : null, menuitemid: o, ev: ZC.A5.C1(e) });
                                var r = a.o["export-filename"] || a.o.graphset[0]["export-filename"] || "";
                                switch (o) {
                                    case "switchto2d":
                                    case "switchto3d":
                                        l && a.A4W(l.L);
                                        break;
                                    case "enablepagescroll":
                                        (s.DG = s.DG || {}), (s.DG["page-scroll"] = !0);
                                        break;
                                    case "disablepagescroll":
                                        (s.DG = s.DG || {}), (s.DG["page-scroll"] = !1);
                                        break;
                                    case "showguide":
                                        a.Z5(l.L, !0);
                                        break;
                                    case "hideguide":
                                        a.Z5(l.L, !1);
                                        break;
                                    case "switchtolin":
                                        a.A11(l.L, "lin");
                                        break;
                                    case "switchtolog":
                                        a.A11(l.L, "log");
                                        break;
                                    case "reload":
                                        a.A94();
                                        break;
                                    case "viewaspng":
                                        a.OB("png");
                                        break;
                                    case "viewasjpg":
                                        a.OB("jpeg");
                                        break;
                                    case "downloadpdf":
                                        a.OB("pdf", "" === r ? null : { fn: r + ".pdf" });
                                        break;
                                    case "downloadsvg":
                                        a.OB("svg", "" === r ? null : { fn: r + ".svg" });
                                        break;
                                    case "exportdata":
                                        zingchart.exec(a.L, "exportdata");
                                        break;
                                    case "downloadcsv":
                                        zingchart.exec(a.L, "downloadCSV", "" === r ? null : { fn: r });
                                        break;
                                    case "downloadxls":
                                        var A = a.o["export-sheetname"] || a.o.graphset[0]["export-sheetname"] || "ZingChart";
                                        (i = G7("DownloadXLS"))["custom-function"]
                                            ? a.A49({ graphid: l ? l.L : null, menuitemid: o, filename: r, sheetname: A, function: i["custom-function"] })
                                            : zingchart.exec(a.L, "downloadXLS", "" === r ? null : { fn: r, sn: A });
                                        break;
                                    case "viewdatatable":
                                    case "hidedatatable":
                                        zingchart.exec(a.L, "viewDataTable", { menuid: o });
                                        break;
                                    case "print":
                                        a.A9C();
                                        break;
                                    case "viewsource":
                                        a.A5S();
                                        break;
                                    case "bugreport":
                                        a.A6J();
                                        break;
                                    case "fullscreen":
                                        a.A5R();
                                        break;
                                    case "goback":
                                        zingchart.exec(a.L, "goback");
                                        break;
                                    case "goforward":
                                        zingchart.exec(a.L, "goforward");
                                        break;
                                    case "zoomin":
                                        l && ((a.H2.C = l), a.A91({ graphid: l.L, ev: e }));
                                        break;
                                    case "zoomout":
                                        l && ((a.H2.C = l), a.A7P({ graphid: l.L, ev: e }));
                                        break;
                                    case "viewall":
                                        l && ((a.H2.C = l), a.A7S({ graphid: l.L, ev: e }));
                                        break;
                                    case "xmiabt":
                                        a.A9I();
                                        break;
                                    default:
                                        null !== ZC._n_((G = s.A1X[o])) && ("" !== G.fn ? a.A49({ graphid: l ? l.L : null, menuitemid: o, function: G.fn }) : "" !== G.url && l && l.V4(e, G.url, G.target));
                                }
                            }),
                            (s.AG8 = function () {
                                (this.style.backgroundColor = LC.A0), (this.style.color = LC.C2), (this.style.borderLeft = this.style.borderRight = LC.AU + "px solid " + LC.BX);
                            }),
                            (s.AGN = function () {
                                (this.style.backgroundColor = E2.A0), (this.style.color = E2.C2), (this.style.borderLeft = this.style.borderRight = E2.AU + "px solid " + E2.BX);
                            }),
                            (s.TP = function (e) {
                                return e.preventDefault(), !1;
                            }),
                            ZC.A5("#" + s.L + "-menu").live("mousedown", s.TP),
                            ZC.A5("." + s.L + "-menu-item").live("mousedown", s.TP),
                            ZC.A5("." + s.L + "-menu-item")
                                .live("click touchend", s.AGR)
                                .live("mouseover", s.AG8)
                                .live("mouseout", s.AGN),
                            (s.D["menu-item-events"] = !0));
                }
            }
            function A1L(e) {
                return "" !== e && e ? "url(" + (0 === e.indexOf("zc.") ? ZC.IMAGES[e] : e) + ")" : "none";
            }
            function JB(e) {
                return (
                    '<div id="' +
                    s.L +
                    "-menu-sep-" +
                    e +
                    '" class="zc-menu-sep" style="background-color:' +
                    E2.A0 +
                    ";background-image:" +
                    A1L(E2.DB) +
                    " repeat-x 50% 0%;border-bottom-width:" +
                    U6["line-width"] +
                    ";border-bottom-color:" +
                    U6["line-color"] +
                    ';">&nbsp;</div>'
                );
            }
            function GV(e, i, t) {
                i = i || ZC.HJ["menu-" + e];
                var n = void 0 !== t && t ? " zc-custom-menu-item " + s.L + "-custom-menu-item" : "";
                return (
                    '<div class="' +
                    s.L +
                    "-menu-item" +
                    n +
                    '" style="width:' +
                    s.MZ.o.width +
                    ";color:" +
                    E2.C2 +
                    ";font-family:" +
                    E2.GH +
                    ";font-size:" +
                    E2.DJ +
                    "px;background-color:" +
                    E2.A0 +
                    ";background-image:" +
                    A1L(E2.DB) +
                    " repeat-x 50% 0%;border-top:" +
                    (ZC.ie67 ? E2.AU : 1) +
                    "px solid " +
                    E2.BX +
                    ";border-left:" +
                    E2.AU +
                    "px solid " +
                    E2.BX +
                    ";border-right:" +
                    E2.AU +
                    "px solid " +
                    E2.BX +
                    ";padding:" +
                    E2.FM +
                    "px " +
                    E2.FN +
                    "px " +
                    E2.FT +
                    "px " +
                    E2.EQ +
                    "px;text-align:" +
                    E2.OD +
                    ";" +
                    (ZC.HJ.rtl ? "unicode-bidi:bidi-override;direction:rtl;" : "") +
                    '" id="' +
                    s.L +
                    "-menu-item-" +
                    e +
                    '">' +
                    i +
                    "</div>"
                );
            }
            function A2X(e, i, t) {
                var n = void 0 !== t && t ? " zc-custom-menu-header " + s.L + "-custom-menu-header" : "";
                return (
                    '<div class="zc-menu-header ' +
                    s.L +
                    "-menu-header" +
                    n +
                    '" style="color:' +
                    E2.C2 +
                    ";background-color:#666;border-top:" +
                    (ZC.ie67 ? E2.AU : 1) +
                    "px solid " +
                    E2.BX +
                    ";border-left:" +
                    E2.AU +
                    "px solid " +
                    E2.BX +
                    ";border-right:" +
                    E2.AU +
                    "px solid " +
                    E2.BX +
                    ";padding:" +
                    E2.FM +
                    "px " +
                    E2.FN +
                    "px " +
                    E2.FT +
                    "px " +
                    E2.EQ +
                    "px;text-align:" +
                    E2.OD +
                    ";" +
                    (ZC.HJ.rtl ? "unicode-bidi:bidi-override;direction:rtl;" : "") +
                    '" id="' +
                    s.L +
                    "-menu-item-" +
                    e +
                    '">' +
                    i +
                    "</div>"
                );
            }
            function G7(e) {
                var i = { ViewAsImage: "SaveAsImage", ViewAsImagePNG: "SaveAsImagePNG", ViewAsImageJPG: "SaveAsImageJPG" };
                if (ABA) return { enabled: "none" };
                for (var t = 0, n = PH.length; t < n; t++) {
                    if (PH[t].id === e) return PH[t];
                    if (i[PH[t].id] && i[PH[t].id] === e) return PH[t];
                }
                return { enabled: "all" };
            }
        },
        destroy: function () {
            this._unbind_(), (zingchart.HZ.length -= 1), this.clear(), ZC.A5("#zc-fullscreen").remove(), (document.body.style.overflow = "");
        },
        N3: function (e, i) {
            var t,
                n = this;
            if ((null === ZC._n_(i) && (i = !1), (i || n.A08) && -1 === ZC.AV(n.KP, "skip_interactivity")))
                if (((n.ZV = !0), i && ZC.Q.I2({ id: n.L + "-dummy", p: ZC.AL(n.L), wh: n.I + "/" + n.F }), n.D.hideprogresslogo || zingchart.DEV.SKIPPROGRESS)) n.ZV = !1;
                else {
                    var a = ZC.A5("#" + n.L);
                    if (!(void 0 === a.offset() || a.width() + a.height() === 0 || (n.D.hideprogresslogo && n.TM))) {
                        var l = a.offset().left + ZC._i_(a.css("border-left-width")) + (null === e ? n.iX : e.iX),
                            o = a.offset().top + ZC._i_(a.css("border-top-width")) + (null === e ? n.iY : e.iY);
                        (ZC.ipad || ZC.iphone) && ((l -= ZC.A5(window).scrollLeft()), (o -= ZC.A5(window).scrollTop()));
                        var r = null === e ? n.I : e.I,
                            s = null === e ? n.F : e.F,
                            A = ZC._i_(0.8 * n.I),
                            C = 30,
                            c = new ZC.DN(n);
                        n.B8.load(c.o, "loader.gui.progress"), c.append(n.D.progress), null !== n.DG && null !== ZC._n_((t = n.DG.progress)) && c.append(t), c.parse();
                        var u,
                            p = ZC.HJ["progress-wait-long"];
                        if (ZC.ie67) u = c.A0;
                        else {
                            var Z = n.D.customprogresslogo || ZC.IMAGES["zc.logo"];
                            u = c.A0 + " url(" + Z + ") no-repeat center center";
                        }
                        (r < 180 || s < 90) && ((u = c.A0), (C = -12)), r < 120 && r > 60 ? ((A = 60), (p = ZC.HJ["progress-wait-short"])) : r < 60 && ((A = 20), (p = ZC.HJ["progress-wait-mini"])), (p = n.D.customprogresstext || p);
                        var h = ZC.Q.I2({ id: n.L + "-progress", p: document.body, tl: o + "/" + l, width: r - 2 * c.AU, height: s - 2 * c.AU, position: "absolute", opacity: 0.8, border: c.AU + "px solid " + c.BX, background: u });
                        ZC.Q.I2({
                            id: n.L + "-progress-text",
                            p: h,
                            width: A,
                            html: p,
                            textAlign: "center",
                            marginLeft: ZC._i_((r - A) / 2),
                            marginTop: ZC._i_(s / 2 + C),
                            fontFamily: zingchart.FONTFAMILY,
                            fontSize: zingchart.FONTSIZE,
                            color: c.C2,
                            fontWeight: "bold",
                        });
                    }
                }
        },
        A0O: function () {
            var e = this;
            ZC.Q.ET(e.L + "-dummy"), e.D.hideprogresslogo || ((e.ZV = !1), ZC.Q.ET([e.L + "-progress-text", e.L + "-progress"]));
        },
        A4K: function (e, i) {
            var t,
                n,
                a = this;
            t = null !== ZC._n_((n = e.graphset)) ? n : [e];
            var l = e.layout || "",
                o = ZC.AQ.A23(l, t.length),
                r = t[i],
                s = a.I / o[1],
                A = a.F / o[0],
                C = Math.floor(i / o[1]),
                c = (i % o[1]) * s,
                u = C * A;
            r &&
                (null !== ZC._n_((n = r.x)) && (c = ZC._p_(n)) <= 1 && (c = ZC._i_(c * a.I)),
                null !== ZC._n_((n = r.y)) && (u = ZC._p_(n)) <= 1 && (u = ZC._i_(u * a.F)),
                null !== ZC._n_((n = r.width)) && (s = ZC._p_(n)) <= 1 && (s = ZC._i_(s * a.I)),
                null !== ZC._n_((n = r.height)) && (A = ZC._p_(n)) <= 1 && (A = ZC._i_(A * a.F)));
            var p = [0, 0, 0, 0];
            if (r.plotarea) {
                if ((a.B8.load(r.plotarea, ["(" + r.type + ").plotarea"], !1, !0), null !== ZC._n_(r.plotarea.margin))) p = new ZC.HN(null).m_(r.plotarea.margin, "all", s, A);
                for (var Z = ["top", "right", "bottom", "left"], h = 0; h < 4; h++)
                    if (null !== ZC._n_(r.plotarea["margin-" + Z[h]])) {
                        var d = r.plotarea["margin-" + Z[h]];
                        ZC._i_(d) + "" == d + "" && (p[h] = ZC._i_(d));
                    }
            }
            return { graph: { x: ZC._i_(c), y: ZC._i_(u), width: ZC._i_(s), height: ZC._i_(A), index: i }, plotarea: { x: p[3], y: p[0], width: s - p[1] - p[3], height: A - p[0] - p[2] } };
        },
        K7: function () {
            var e = this;
            null === ZC._n_(e.o.graphset) && (e.o = { graphset: [e.o] }),
                e.N3(),
                zingchart.A1I(e, e.A4T(), function () {
                    (e.o = ZC.AP.C0("dataparse", e, e.FG(), e.o)),
                        zingchart.Y1[e.L] &&
                            e.Q8(function () {
                                e.parse(), e.paint();
                            });
                });
        },
        render: function () {
            var e = this;
            !(function () {
                function i() {
                    "" !== e.QJ || null !== e.MN ? e.A8S() : e.load();
                }
                e.UC || e.A8Q(), e.N3(null, !0), zingchart.TIMEOUT > 0 ? ZC.Z8(i) : i();
            })();
        },
        YF: function (e) {
            var i = this;
            null === ZC._n_(i.A3V) &&
                ((i.A3V = new Date().getTime()),
                (i.AB3 = window.setTimeout(function () {
                    null !== ZC._n_(i.A3V) && ((i.A3V = null), zingchart.YP(e));
                }, 1500)));
        },
        FG: function () {
            var e,
                i = this,
                t = 0,
                n = 0;
            return (
                (t = "undefined" != typeof i.SQ[0] ? i.SQ[0] - t : 0),
                (n = "undefined" != typeof i.SQ[1] ? i.SQ[1] - n : 0),
                (e = i.LJ ? i.LJ : "light"),
                { id: i.L, width: i.I, height: i.F, output: i.AC, x: t, y: n, targetid: i.SQ[2], theme: e }
            );
        },
        AC5: function (e) {
            (e = e || {}), null !== ZC._n_(e.resource) && ((this.QY[e.resource] = e.data || "[]"), this.UP++);
        },
        A91: function () {},
        A7P: function () {},
        A7S: function () {},
        PY: function () {},
        A9N: function (e, i) {
            var t = this;
            if (((e = e || {}), null !== ZC._n_(e.graphid))) {
                var n = t.OS(e.graphid);
                null !== n && n.clear();
            } else t.clear(null, null, i);
            ZC.JR && ZC.JR.GUIDES && (ZC.JR.GUIDES[t.L] = null);
        },
        A81: function (e) {
            e = e || ZC.HJ["sync-wait"];
            var i = this;
            if (null === ZC.AL(i.L + "-blocker")) {
                ZC.Q.I2({ cls: "zc-abs zc-style zc-blocker", id: i.L + "-blocker", p: ZC.AL(i.L + "-top"), wh: i.I + "/" + i.F, opacity: 0.75 }),
                    ZC.Q.I2({ cls: "zc-blocker-msg", id: i.L + "-blocker-t", p: ZC.AL(i.L + "-blocker"), html: e });
                var t = ZC.A5("#" + i.L + "-blocker-t");
                t.css("top", i.F / 2 - t.height() / 2 + "px").css("left", i.I / 2 - t.width() / 2 + "px");
            }
        },
        A43: function () {
            ZC.Q.ET(this.L + "-blocker");
        },
        A9I: function () {
            var e = this;
            ZC.AP.C0("about_show", e, e.FG()), ZC.Q.I2({ cls: "zc-abs", id: e.L + "-about-mask", p: ZC.AL(e.L + "-top"), wh: e.I + "/" + e.F, background: "#ccc", opacity: 0.75 });
            var i = ZC.CY(320, e.I),
                t = ZC.CY(215, e.F),
                n = ZC.BQ(0, (e.I - i) / 2),
                a = ZC.BQ(0, (e.F - t) / 2),
                l = ZC.Q.I2({ cls: "zc-about zc-style", id: e.L + "-about", p: ZC.AL(e.L + "-top"), tl: a + "/" + n, wh: i - (ZC.quirks ? 0 : 10) + "/" + (t - (ZC.quirks ? 0 : 10)) }),
                o = "";
            "" !== e.S8 && (o = "Custom Built for<br />" + e.S8),
                (l.innerHTML =
                    '<div class="zc-about-1"><a href="http://www.zingchart.com" target="_blank">zingchart.com</a></div><div class="zc-about-2">&copy;2009-' +
                    new Date().getFullYear() +
                    '</div><div class="zc-about-3"><div id="' +
                    e.L +
                    '-about-close">' +
                    ZC.HJ["about-close"] +
                    '</div></div><div class="zc-about-4" style="padding:' +
                    (t - 215) +
                    'px 5px 5px 5px;"><div>&nbsp;<br />Build ' +
                    ZC.VERSION +
                    " [" +
                    e.AC +
                    "]</div>" +
                    o +
                    "</div>"),
                ZC.A5("#" + e.L + "-about-close").bind("click", function () {
                    ZC.AP.C0("about_hide", e, e.FG()), ZC.Q.ET([e.L + "-about", e.L + "-about-mask"]);
                });
        },
        NY: function (e, i) {
            var t = this;
            if (ZC.AP.A80("error", t)) ZC.AP.C0("error", t, { id: t.L, error: e, section: i, json: t.D.json || t.D.rawsource });
            else {
                var n = "";
                (n += "object" == typeof e ? e.name + ":" + e.message + "\n\n" : e + "\n\n"),
                    null !== ZC._n_(i) && (n += "Section:" + i + "\n\n"),
                    (n += "JSON data:\n\n" + t.D.json + "\n\n"),
                    t.A0O(),
                    null === ZC.AL(t.L + "-top") && t.AB0(),
                    (ZC.Q.I2({ cls: "zc-abs zc-error zc-style", id: t.L + "-error", p: ZC.AL(t.L + "-top"), wh: t.I - (ZC.quirks ? 0 : 10) + "/" + (t.F - (ZC.quirks ? 0 : 10)) }).innerHTML =
                        '<div class="zc-form-row-label zc-form-s0">' +
                        ZC.HJ["error-header"] +
                        '</div><div class="zc-form-row-label zc-form-s1">' +
                        ZC.HJ["error-message"] +
                        '</div><div class="zc-form-row-element"><textarea id="' +
                        t.L +
                        '-error-message" style="width:' +
                        (t.I - 35) +
                        "px;height:" +
                        (t.F - 135) +
                        'px;"></textarea></div><div class="zc-form-row-element zc-form-row-last"><input type="button" value="' +
                        ZC.HJ["error-close"] +
                        '" id="' +
                        t.L +
                        '-error-close" /></div>'),
                    ZC.A5("#" + t.L + "-error-message").val(ZC.GW(n)),
                    ZC.A5("#" + t.L + "-error-close").bind("click", function () {
                        ZC.Q.ET(t.L + "-error");
                    });
            }
        },
        A5S: function () {},
        A6J: function () {},
        A5R: function () {
            var e = this,
                i = document.createElement("div");
            (i.id = "zc-fullscreen"), (i.style.zIndex = zingchart.FSZINDEX), (i.style.overflow = "hidden");
            var t,
                n,
                a = document.body,
                l = !1;
            for (zingchart.FSID && ZC.AL(zingchart.FSID) && ((l = !0), ((a = ZC.AL(zingchart.FSID)).style.display = "block")), a.appendChild(i), ZC.FSSTATUS = {}, t = 0, n = e.AG.length; t < n; t++) {
                var o = e.AG[t];
                if (null !== o.AZ) for (var r = 0, s = o.AZ.A3.length; r < s; r++) ZC.FSSTATUS["g-" + o.K + "-p-" + r] = o.D["plot" + r + ".visible"];
            }
            ZC.Q.ET(e.L + "-data-table");
            var A,
                C = JSON.parse(e.D.json),
                c = C.graphset;
            for (t = c.length - 1; t >= 0; t--)
                if (c[t].generated) c.splice(t, 1);
                else {
                    if (null !== ZC._n_(c[t].shapes)) for (A = c[t].shapes.length - 1; A >= 0; A--) c[t].shapes[A].generated && c[t].shapes.splice(A, 1);
                    if (null !== ZC._n_(c[t].labels)) for (A = c[t].labels.length - 1; A >= 0; A--) c[t].labels[A].generated && c[t].labels.splice(A, 1);
                }
            l || window.scroll(0, 0),
                zingchart.render({
                    id: "zc-fullscreen",
                    output: e.AC,
                    width: ZC.A5(l ? a : window).width(),
                    height: ZC.A5(l ? a : window).height(),
                    fullscreenmode: !0,
                    theme: e.LJ,
                    modules: e.A1O,
                    data: C,
                    defaults: e.MN,
                    defaultsurl: e.QJ,
                });
        },
        A11: function (e, i) {
            var t,
                n,
                a,
                l = this,
                o = 0,
                r = !1;
            for (t = 0, n = l.AG.length; t < n; t++)
                if (e === l.AG[t].L) {
                    for (o = t, a = 0; a < l.AG[t].AZ.A3.length; a++)
                        if (l.AG[t].AZ.A3[a].I3) {
                            r = !0;
                            break;
                        }
                    var s;
                    for (s = l.AG[o].AJ["3d"] || r ? l.o.graphset[t] : l.AG[t].o, a = 0; a < 10; a++) {
                        var A = "scale-y" + (0 === a ? "" : "-" + a);
                        null === ZC._n_(s[A]) && null === ZC._n_(s[ZC.EE(A)]) && null !== l.AG[t].BM(A)
                            ? (s[A] = { progression: i })
                            : (null !== ZC._n_(s[A]) && (s[A].progression = i), null !== ZC._n_(s[ZC.EE(A)]) && (s[ZC.EE(A)].progression = i));
                    }
                }
            delete l.D["graph" + o + ".zoom"], l.AG[o].AJ["3d"] || r ? l.K7() : l.AG[o].K7(!0, !0);
        },
        Z5: function (e, i) {
            var t = this;
            if (t.D7) {
                for (var n = 0, a = t.AG.length; n < a; n++) e === t.AG[n].L && ((t.AG[n].A1N = i), (t.AG[n].D["guide-on"] = i));
                if (i) {
                    var l = ZC.A5("#" + t.L + "-top"),
                        o = { _pageX_: ZC.E1[0] - l.offset().left, _pageY_: ZC.E1[1] - l.offset().top, type: "mousemove", target: { id: t.L + "-img" } };
                    t.D7.QB(o);
                } else ZC.JR.clearGuide(t.L);
            }
        },
        A4W: function (e) {
            for (var i = this, t = ["line", "area", "bar", "vbar", "hbar", "pie", "mixed"], n = 0, a = i.AG.length; n < a; n++)
                if (e === i.AG[n].L) {
                    var l = i.o.graphset[n];
                    if ("mixed" === l.type)
                        for (var o = 0, r = l.series.length; o < r; o++) {
                            var s = l.series[o];
                            (s.type = s.type || "line"), "3d" === i.XC ? (s.type = s.type.replace("3d", "")) : -1 !== ZC.AV(t, s.type) && (s.type = s.type + "3d");
                        }
                    else "3d" === i.XC ? (l.type = l.type.replace("3d", "")) : -1 !== ZC.AV(t, l.type) && (l.type = l.type + "3d");
                }
            (i.XC = "3d" === i.XC ? "2d" : "3d"), (i.D.json = ZC.GW(JSON.stringify(i.o))), i.K7();
        },
        A94: function (e) {
            for (var i, t = this, n = 0; n < t.AG.length; n++) delete t.D["g" + n + "-legend-collapsed"];
            if (((e = e || {}), ZC.AP.C0("reload", t, { id: t.L, graphid: e.graphid }), null !== ZC._n_((i = e.graphid)))) {
                var a = t.C9(i);
                null !== a && (t.N3(a), t.load(a.L));
            } else (t.QU = []), (t.NR = -1), t.N3(), t.clearGenerated(), t.load();
        },
        ACZ: function (e) {
            var i,
                t = this;
            if (((e = e || {}), null !== ZC._n_((i = e.graphid)))) {
                var n = t.C9(i);
                null !== n && null !== ZC._n_(e.dataurl) && (t.N3(n), t.load(i, e.dataurl));
            } else null !== ZC._n_((i = e.dataurl)) && ((t.QK = i), t.N3(), t.load());
        },
        A9C: function () {},
        OB: function () {},
        Z4: function () {},
        AAI: function (e) {
            ZC._cp_(this.FG(), e), ZC.AP.C0("menu_item_click", this, e);
        },
        A49: function (N) {
            var s = this;
            try {
                var DX = ZC.AP.AAG(N["function"]);
                (N["function"] = DX[0]), (N.arguments = DX[1]), ZC._cp_(s.FG(), N), eval(N["function"]).call(s, N);
            } catch (JA) {
                return s.NY(JA, "JavaScript data loader"), !1;
            }
        },
        C9: function (e) {
            var i = this;
            return null !== ZC._n_(e) ? i.OS(e) : i.AG.length > 0 ? i.AG[0] : null;
        },
        bind: function (e, i) {
            zingchart.bind(this.L, e, i);
        },
        unbind: function (e, i) {
            zingchart.unbind(this.L, e, i);
        },
        exec: function (e, i) {
            return zingchart.exec(this.L, e, i);
        },
        gc: function () {
            for (var e = 0, i = this.AG.length; e < i; e++) this.AG[e].gc();
        },
    };
    (ZC.Q1 = ZC.HN.CC(Q1)),
        (ZC.Q1.prototype.AD6 = function (e) {
            var i,
                t,
                n,
                a,
                l,
                o = this;
            if ((((e = e || {}).action = "pan"), (i = null !== ZC._n_(e.graphid) ? o.OS(e.graphid) : o.AG[0]))) {
                for (t = 0, n = i.BW("k").length; t < n; t++) {
                    var r = i.BW("k")[t];
                    if (((a = 1 === r.K ? "" : "-" + r.K), r.GN && (null === ZC._n_(e["zoomx" + a]) || e["zoomx" + a]))) {
                        e["zoomx" + a] = !0;
                        var s,
                            A = e.xdist || 50;
                        l = r.I / ZC.CY(r.I, Math.abs(A));
                        var C = r.W,
                            c = r.A1;
                        A < 0 ? ((s = ZC.CY(r.W - r.DA, ZC._i_((r.A1 - r.W) / l))), (C = r.W - s), (c = r.A1 - s)) : ((s = ZC.CY(r.DY - r.A1, ZC._i_((r.A1 - r.W) / l))), (C = r.W + s), (c = r.A1 + s)),
                            (e["xmin" + a] = C),
                            (e["xmax" + a] = c);
                    }
                }
                for (t = 0, n = i.BW("v").length; t < n; t++) {
                    var u = i.BW("v")[t];
                    if (((a = 1 === u.K ? "" : "-" + u.K), u.GN && (null === ZC._n_(e["zoomy" + a]) || e["zoomy" + a]))) {
                        e["zoomy" + a] = !0;
                        var p,
                            Z = e.ydist || 50;
                        l = u.F / ZC.CY(u.F, Math.abs(Z));
                        var h = u.AY,
                            d = u.BD;
                        A < 0 ? ((p = ZC.CY(u.AY - u.FR, ZC._i_((u.BD - u.AY) / l))), (h = u.AY - p), (d = u.BD - p)) : ((p = ZC.CY(u.GU - u.BD, ZC._i_((u.BD - u.AY) / l))), (h = u.AY + p), (d = u.BD + p)),
                            u.PW && 1 === u.E3 && ((h = Math.round(h)), (d = Math.round(d))),
                            (e["ymin" + a] = h),
                            (e["ymax" + a] = d);
                    }
                }
                o.PY(e);
            }
        }),
        (ZC.Q1.prototype.A91 = function (e) {
            var i,
                t,
                n,
                a,
                l = this;
            if ((((e = e || {}).action = "zoomin"), (i = null !== ZC._n_(e.graphid) ? l.OS(e.graphid) : l.AG[0]))) {
                for (t = 0, n = i.BW("k").length; t < n; t++) {
                    var o = i.BW("k")[t];
                    if (((a = 1 === o.K ? "" : "-" + o.K), o.GN && (null === ZC._n_(e["zoomx" + a]) || e["zoomx" + a]))) {
                        e["zoomx" + a] = !0;
                        var r = o.A1 - o.W,
                            s = o.W + (r < 2 ? 0 : ZC._i_(r / 4)),
                            A = o.A1 - (r < 2 ? 0 : ZC._i_(r / 4));
                        s < A ? ((e["xmin" + a] = s), (e["xmax" + a] = A)) : ((e["xmin" + a] = o.W), (e["xmax" + a] = o.A1));
                    }
                }
                for (t = 0, n = i.BW("v").length; t < n; t++) {
                    var C = i.BW("v")[t];
                    if (((a = 1 === C.K ? "" : "-" + C.K), C.GN && (null === ZC._n_(e["zoomy" + a]) || e["zoomy" + a]))) {
                        e["zoomy" + a] = !0;
                        var c = C.BD - C.AY,
                            u = C.AY + ZC._f_(c / 4),
                            p = C.BD - ZC._f_(c / 4);
                        C.PW && 1 === C.E3 && ((u = Math.round(u)), (p = Math.round(p))), u < p && ((e["ymin" + a] = u), (e["ymax" + a] = p));
                    }
                }
                l.PY(e);
            }
        }),
        (ZC.Q1.prototype.A7P = function (e) {
            var i,
                t,
                n,
                a,
                l,
                o,
                r,
                s = this;
            if ((((e = e || {}).action = "zoomout"), (e.previewscale = !0), (i = null !== ZC._n_(e.graphid) ? s.OS(e.graphid) : s.AG[0]))) {
                for (t = 0, n = i.BW("k").length; t < n; t++) {
                    var A = i.BW("k")[t];
                    if (((r = 1 === A.K ? "" : "-" + A.K), A.GN && (null === ZC._n_(e["zoomx" + r]) || e["zoomx" + r])))
                        if (((e["zoomx" + r] = !0), i.B9 && i.B9.LL)) {
                            var C = ZC._i_((i.B9.NJ[A.BF].values.length * i.B9.IH) / i.B9.AR.I),
                                c = ZC._i_((i.B9.NJ[A.BF].values.length * i.B9.H6) / i.B9.AR.I);
                            (a = ZC.BQ(2, c - C)), (l = ZC.BQ(0, C - ZC._i_(a / 2))) < (o = ZC.CY(i.B9.NJ[A.BF].values.length - 1, c + ZC._i_(a / 2))) && ((e["xmin" + r] = l), (e["xmax" + r] = o));
                        } else (a = ZC.BQ(2, A.A1 - A.W)), (l = ZC.BQ(A.DA, A.W - ZC._i_(a / 2))) < (o = ZC.CY(A.DY, A.A1 + ZC._i_(a / 2))) && ((e["xmin" + r] = l), (e["xmax" + r] = o));
                }
                for (t = 0, n = i.BW("v").length; t < n; t++) {
                    var u = i.BW("v")[t];
                    if (((r = 1 === u.K ? "" : "-" + u.K), u.GN && (null === ZC._n_(e["zoomy" + r]) || e["zoomy" + r]))) {
                        e["zoomy" + r] = !0;
                        var p = u.BD - u.AY,
                            Z = ZC.BQ(u.FR, u.AY - ZC._f_(p / 2)),
                            h = ZC.CY(u.GU, u.BD + ZC._f_(p / 2));
                        u.PW && 1 === u.E3 && (Math.round(h) - Math.round(Z) > 1 ? ((Z = Math.round(Z)), (h = Math.round(h))) : ((Z = Math.floor(Z)), (h = Math.ceil(h)))),
                            (Z = ZC.BQ(u.FR, Z)) < (h = ZC.CY(u.GU, h)) && ((e["ymin" + r] = Z), (e["ymax" + r] = h));
                    }
                }
                s.PY(e);
            }
        }),
        (ZC.Q1.prototype.A7S = function (e) {
            var i,
                t,
                n,
                a,
                l,
                o = this;
            for (e = e || {}, t = null !== ZC._n_(e.graphid) ? o.OS(e.graphid) : o.AG[0], e.action = "viewall", n = 0, a = t.BW("k").length; n < a; n++)
                if (
                    (((i = t.BW("k")[n]).aForcedMinMax[2] = 1),
                    (e["zoomx" + (l = 1 === i.K ? "" : "-" + i.K)] = !0),
                    (e["xmin" + l] = null),
                    (e["xmax" + l] = null),
                    t.o[i.BF] && ((t.o[i.BF]["zoom-to"] = null), (t.o[i.BF]["zoom-to-values"] = null)),
                    t.B9 && t.B9.LL)
                ) {
                    var r = t.B9.NJ[i.BF].values;
                    (e["kmin" + l + "-async"] = r[0]), (e["kmax" + l + "-async"] = r[r.length - 1]);
                }
            for (n = 0, a = t.BW("v").length; n < a; n++)
                (i = t.BW("v")[n]),
                    t.o[i.BF] && ((t.o[i.BF]["zoom-to"] = null), (t.o[i.BF]["zoom-to-values"] = null)),
                    (i.DP = null !== ZC._n_(i.D.decimals) && -1 !== i.D.decimals ? i.D.decimals : null),
                    (l = 1 === i.K ? "" : "-" + i.K),
                    (i.KM = null),
                    (e["zoomy" + l] = !0),
                    (e["ymin" + l] = null),
                    (e["ymax" + l] = null);
            o.PY(e);
        }),
        (ZC.Q1.prototype.PY = function (e) {
            var i,
                t,
                n,
                a,
                l,
                o,
                r,
                s,
                A,
                C,
                c,
                u,
                p,
                Z,
                h,
                d = this;
            (e = e || {}).id = d.L;
            var f = null !== ZC._n_(e.zoom) && !e.zoom;
            if ((t = null !== ZC._n_(e.graphid) ? d.OS(e.graphid) : d.AG[0])) {
                f && (d.D["graph." + t.K + ".ignore-zoom"] = !0),
                    d.D["graph." + t.K + ".ignore-zoom"] && (f = !0),
                    "undefined" == typeof e.scroll && (ZC.Q.IV(ZC.AL(t.L + "-scroll-x-c"), t.A.AC, t.iX, t.iY, t.I, t.F), ZC.Q.IV(ZC.AL(t.L + "-scroll-y-c"), t.A.AC, t.iX, t.iY, t.I, t.F)),
                    t.B9 && (t.B9.I4 = !1);
                var _ = d.D["graph" + t.K + ".zoom"] || {};
                for (e.yzoomed = !1, (l = t.BW("v")[0]) && null !== ZC._n_(e.ymin) && null !== ZC._n_(e.ymax) && ((e.ymin === l.FR && e.ymax === l.GU) || (e.yzoomed = !0)), s = 0, A = t.BW("k").length; s < A; s++)
                    if (((C = 1 === (a = t.BW("k")[s]).K ? "" : "-" + a.K), null !== ZC._n_(e["kmin" + C]) && null !== ZC._n_(e["kmax" + C])))
                        if (e["kmin" + C] === e["kmax" + C]) delete e["kmin" + C], delete e["kmax" + C];
                        else {
                            for (var g = !1, v = !1, b = 0, B = a.V.length; b < B && (e["kmin" + C] <= a.V[b] && !g && ((e["xmin" + C] = b), (g = !0)), e["kmax" + C] <= a.V[b] && !v && ((e["xmax" + C] = b), (v = !0)), !g || !v); b++);
                            g || (e["xmin" + C] = 0), v || (e["xmax" + C] = a.V.length - 1), (e["zoomx" + C] = !0), (e.xzoomed = !(g && v));
                        }
                    else
                        (n = t.B9 && t.B9.LL && e.previewscale ? t.B9.NJ[a.BF].values : a.V),
                            null !== ZC._n_((i = n[e["xmin" + C]])) && (e["kmin" + C] = i),
                            null !== ZC._n_((i = n[e["xmax" + C]])) && (e["kmax" + C] = i),
                            (e.xzoomed = !(e["xmin" + C] === a.DA && e["xmax" + C] === a.DY));
                "viewall" === e.action && ((e.xzoomed = !1), (e.yzoomed = !1));
                var m = ZC.AP.C0("zoom", t.A, e, !0);
                if (e.async && !f) return;
                if (t.B9 && t.B9.LL) {
                    n = t.B9.NJ[a.BF].values;
                    var D = ZC.XZ(n),
                        E = ZC.A1D(n);
                    null !== ZC._n_(e.kmin) && "undefined" != typeof e.kmin ? ((o = ZC._i_((t.B9.AR.I * (e.kmin - D)) / (E - D))), (o = ZC.BQ(o, 0))) : (o = 0),
                        null !== ZC._n_(e.kmax) && "undefined" != typeof e.kmax ? ((r = ZC._i_((t.B9.AR.I * (e.kmax - D)) / (E - D))), (r = ZC.CY(r, t.B9.AR.I))) : (r = t.B9.AR.I),
                        f || t.B9.update(o, r, t.B9.KT, t.B9.HA);
                }
                if (m || void 0 === m) {
                    for (s = 0, A = t.BW("k").length; s < A; s++)
                        e["zoomx" + (C = 1 === (a = t.BW("k")[s]).K ? "" : "-" + a.K)] && (f || a.zoomTo(e["xmin" + C], e["xmax" + C]), (_["xmin" + C] = e["xmin" + C]), (_["xmax" + C] = e["xmax" + C]));
                    for (s = 0, A = t.BW("v").length; s < A; s++)
                        e["zoomy" + (C = 1 === (l = t.BW("v")[s]).K ? "" : "-" + l.K)] && null !== ZC._n_(l) && (f || l.zoomTo(e["ymin" + C], e["ymax" + C]), (_["ymin" + C] = e["ymin" + C]), (_["ymax" + C] = e["ymax" + C]));
                    if ((f && (d.H2.C = t), d.H2.parse(), d.H2.A0N))
                        for (d.D["graph" + t.K + ".zoom"] = _, Z = 0, h = d.AG.length; Z < h; Z++) t.L !== d.AG[Z].L && d.AG[Z].H2 && ZC._b_(d.AG[Z].H2.o.shared) && (d.D["graph" + d.AG[Z].K + ".zoom"] = _);
                    if ((t.B9 && !e.preview && t.B9.update(e.xmin, e.xmax, e.ymin, e.ymax, !0), f)) return;
                    t.clear(!0);
                    for (var L = t.BW("v"), F = 0; F < L.length; F++)
                        if ((l = t.BW("v")[F]) && (l.aAutoFit[0] || l.aAutoFit[1])) {
                            for (var I = l.aAutoFit[0] ? ZC.MAX : l.FR, x = l.aAutoFit[1] ? -ZC.MAX : l.GU, y = 0, w = t.AZ.A3.length; y < w; y++)
                                if (t.AZ.A3[y].AN && -1 !== ZC.AV(t.AZ.A3[y].BO, l.BF))
                                    if (a.EF) {
                                        for (s = 0, A = t.AZ.A3[y].S.length; s < A; s++)
                                            if ((p = t.AZ.A3[y].S[s]) && ZC.DT(p.BV, a.V[a.W], a.V[a.A1]))
                                                for (l.aAutoFit[0] && (I = ZC.CY(I, p.CR)), l.aAutoFit[1] && (x = ZC.BQ(x, p.CR)), c = 0, u = p.DQ.length; c < u; c++)
                                                    l.aAutoFit[0] && (I = ZC.CY(I, p.DQ[c])), l.aAutoFit[1] && (x = ZC.BQ(x, p.DQ[c]));
                                    } else
                                        for (s = a.W; s <= a.A1; s++)
                                            if ((p = t.AZ.A3[y].S[s]))
                                                for (l.aAutoFit[0] && (I = ZC.CY(I, p.CR)), l.aAutoFit[1] && (x = ZC.BQ(x, p.CR)), c = 0, u = p.DQ.length; c < u; c++)
                                                    l.aAutoFit[0] && (I = ZC.CY(I, p.DQ[c])), l.aAutoFit[1] && (x = ZC.BQ(x, p.DQ[c]));
                            "log" === l.BS && ((I = ZC.FV(I, l.DW)), (x = ZC.FV(x, l.DW))), l.QH(I, x, !0), l.J2();
                            var Y = t.BW("v");
                            for (s = 0; s < Y.length; s++) Y[s].BF !== l.BF && Y[s].sMaster === l.BF && (Y[s].QH(I, x, !0), Y[s].J2());
                        }
                    var X = ZC._b_(e.zoomto);
                    t.D["skip-preview"] = !0;
                    var M = ["top", "right", "bottom", "left"];
                    for (s = 0; s < M.length; s++)
                        (t.P.D["d-margin-" + M[s]] || t.D["plotarea.d-margin-" + M[s]] || ZC._b_(t.P.o["adjust-layout"])) &&
                            ((t.o.plotarea["margin-" + M[s]] && !Number.isNaN(t.o.plotarea["margin-" + M[s]])) ||
                                ((t.o.plotarea["margin-" + M[s]] = t.P.o["margin-" + M[s]] = "dynamic"), (t.D["plotarea.d-margin"] = t.D["plotarea.d-margin-" + M[s]] = !0)));
                    t.setupDynamicPlotArea(), t.paint(!X), (d.H2.C = null), ZC.AP.C0("postzoom", t.A, e);
                }
            }
        }),
        (zingchart.ABP = function (e, i, t) {
            var n, a, l, o, r, s, A, C, c;
            document.getElementById("zc-fullscreen") && (e = "zc-fullscreen"), "string" == typeof (t = t || {}) && (t = JSON.parse(t));
            var u = zingchart.getLoader(e);
            if ((null !== ZC._n_(t.preservezoom) && (u.D.preservezoom = ZC._b_(t.preservezoom)), u))
                switch (i) {
                    case "getzoom":
                        if (((o = {}), (l = u.C9(t.graphid))))
                            for (n = 0, a = l.BO.length; n < a; n++) {
                                var p = l.BO[n];
                                "k" === p.AF ? (o[p.BF] = { xmin: p.W, xmax: p.A1, vmin: p.V[p.W], vmax: p.V[p.A1] }) : (o[p.BF] = { ymin: p.AY, ymax: p.BD, vmin: p.V[p.W], vmax: p.V[p.A1] });
                            }
                        return o;
                    case "pan":
                        u.AD6(t);
                        break;
                    case "zoomin":
                        u.A91(t);
                        break;
                    case "zoomout":
                        u.A7P(t);
                        break;
                    case "zoomto":
                        if (((l = u.C9(t.graphid)), null !== ZC._n_(t.xall) && t.xall))
                            for (n = 0, a = l.BW("k").length; n < a; n++)
                                (t["xmin" + (A = 1 === (r = l.BW("k")[n]).K ? "" : "-" + r.K)] = t.xmin || null), (t["xmax" + A] = t.xmax || null), (t["kmin" + A] = t.kmin || null), (t["kmax" + A] = t.kmax || null);
                        for (n = 0, a = l.BW("k").length; n < a; n++)
                            (null === t["xmin" + (A = 1 === (r = l.BW("k")[n]).K ? "" : "-" + r.K)] && null === ZC._n_(t["xmax" + A]) && null === ZC._n_(t["kmin" + A]) && null === ZC._n_(t["kmax" + A])) || (t["zoomx" + A] = !0),
                                "log" === r.BS && (null !== ZC._n_(t["xmin" + A]) && (t["xmin" + A] = ZC.FV(t["xmin" + A], r.DW)), null !== ZC._n_(t["xmax" + A]) && (t["xmax" + A] = ZC.FV(t["xmax" + A], r.DW)));
                        if (null !== ZC._n_(t.yall) && t.yall) for (n = 0, a = l.BW("v").length; n < a; n++) (t["ymin" + (A = 1 === (s = l.BW("v")[n]).K ? "" : "-" + s.K)] = t.ymin || null), (t["ymax" + A] = t.ymax || null);
                        for (n = 0, a = l.BW("v").length; n < a; n++)
                            (A = 1 === (s = l.BW("v")[n]).K ? "" : "-" + s.K),
                                (null === ZC._n_(t["ymin" + A]) && null === ZC._n_(t["ymax" + A])) || (t["zoomy" + A] = !0),
                                "log" === s.BS && (null !== ZC._n_(t["ymin" + A]) && (t["ymin" + A] = ZC.FV(t["ymin" + A], s.DW)), null !== ZC._n_(t["ymax" + A]) && (t["ymax" + A] = ZC.FV(t["ymax" + A], s.DW)));
                        u.PY(t);
                        break;
                    case "zoomtovalues":
                        if (((l = u.C9(t.graphid)), null !== ZC._n_(t.xall) && t.xall))
                            for (n = 0, a = l.BW("k").length; n < a; n++) (t["xmin" + (A = 1 === (r = l.BW("k")[n]).K ? "" : "-" + r.K)] = t.xmin || null), (t["xmax" + A] = t.xmax || null);
                        for (n = 0, a = l.BW("k").length; n < a; n++)
                            (A = 1 === (r = l.BW("k")[n]).K ? "" : "-" + r.K),
                                (null === ZC._n_(t["xmin" + A]) && null === ZC._n_(t["xmax" + A])) ||
                                    (l.B9 && l.B9.LL
                                        ? ((t.previewscale = !0), (t["kmin" + A + "-async"] = t["xmin" + A]), (t["xmin" + A] = ZC.A1J(l.B9.NJ[r.BF].values, t["xmin" + A])))
                                        : -1 !== (C = ZC.AV(r.V, t["xmin" + A]))
                                        ? (t["xmin" + A] = C)
                                        : (t["xmin" + A] = ZC.A1J(r.V, t["xmin" + A])),
                                    l.B9 && l.B9.LL
                                        ? ((t.previewscale = !0), (t["kmax" + A + "-async"] = t["xmax" + A]), (t["xmax" + A] = ZC.A1J(l.B9.NJ[r.BF].values, t["xmax" + A])))
                                        : -1 !== (c = ZC.AV(r.V, t["xmax" + A]))
                                        ? (t["xmax" + A] = c)
                                        : (t["xmax" + A] = ZC.A1J(r.V, t["xmax" + A])),
                                    (t["zoomx" + A] = !0));
                        if (null !== ZC._n_(t.yall) && t.yall) for (n = 0, a = l.BW("v").length; n < a; n++) (t["ymin" + (A = 1 === (s = l.BW("v")[n]).K ? "" : "-" + s.K)] = t.ymin || null), (t["ymax" + A] = t.ymax || null);
                        for (n = 0, a = l.BW("v").length; n < a; n++) (A = 1 === (s = l.BW("v")[n]).K ? "" : "-" + s.K), (null === ZC._n_(t["ymin" + A]) && null === ZC._n_(t["ymax" + A])) || (t["zoomy" + A] = !0);
                        u.PY(t);
                        break;
                    case "viewall":
                        u.A7S(t);
                }
            return null;
        }),
        (ZC.A7N = {}),
        (ZC.AP.A40 = function (e, i, t, n) {
            "jpg" === (n = n || "png") && (n = "jpeg");
            var a = document.createElement("canvas");
            (a.width = i), (a.height = t), (a.style.width = i + "px"), (a.style.height = t + "px");
            var l,
                o = a.getContext("2d");
            e instanceof Array || (e = [e]);
            for (var r = 0, s = e.length; r < s; r++)
                if (-1 === e[r].className.indexOf("zc-no-print")) {
                    var A = !1;
                    try {
                        e[r].toDataURL("image/" + n);
                    } catch (c) {
                        A = !0;
                    }
                    if (!A)
                        if ((l = e[r].getAttribute("data-clip"))) {
                            var C = l.split(",");
                            o.drawImage(e[r], ZC.BQ(0, C[0]), ZC.BQ(0, C[1]), ZC.CY(C[2], e[r].width), ZC.CY(C[3], e[r].height), ZC.BQ(0, C[0]), ZC.BQ(0, C[1]), ZC.CY(C[2], e[r].width), ZC.CY(C[3], e[r].height));
                        } else o.drawImage(e[r], 0, 0, e[r].width, e[r].height, 0, 0, i, t);
                }
            return a.toDataURL("image/" + n);
        }),
        (ZC.AP.ABR = function (e, i, t, n, a) {
            null === ZC._n_(a) && (a = !1);
            var l = ZC.AP.A40(e, i, t, n);
            if (a) {
                var o = document.createElement("img");
                return (o.src = l), o;
            }
            (l = l.replace("image/" + n, "image/octet-stream")), (document.location.href = l);
        }),
        (ZC.Q1.prototype.A9C = function () {
            var e = this,
                i = [];
            if (!e.A7M) {
                e.A7M = !0;
                var t = document.body.childNodes,
                    n = ZC.A5(document.body).css("background-color"),
                    a = ZC.A5(document.body).css("background-image");
                ZC.A5(document.body).css("background-color", "#fff").css("background-image", "none");
                for (var l = 0, o = t.length; l < o; l++) 1 === t[l].nodeType && ((i[l] = t[l].style.display), (t[l].style.display = "none"));
                document.body.appendChild(ZC.AL(e.L + "-wrapper")),
                    window.setTimeout(function () {
                        window.print(),
                            window.setTimeout(function () {
                                ZC.A5(document.body).css("background-color", n).css("background-image", a), ZC.AL(e.L + "-wrapper") && ZC.AL(e.L).appendChild(ZC.AL(e.L + "-wrapper"));
                                for (var l = 0, o = t.length; l < o; l++) 1 === t[l].nodeType && (t[l].style.display = i[l]);
                                e.A7M = !1;
                            }, 1e3);
                    }, 50);
            }
        }),
        (ZC.Q1.prototype.OB = function (e, i, t, n) {
            var a = this;
            if (((i = i || {}), void 0 === t && (t = !1), !ZC.AL(a.L + "-viewimage"))) {
                e = e || "png";
                var l = i.download,
                    o = i.fn || "";
                ZC.Q.IV(ZC.AL(a.L + "-guide-c"), a.AC, 0, 0, a.I, a.F), ZC.A5(".zc-guide-label").remove();
                var r,
                    s,
                    A = ("canvas" === a.AC || zingchart.AJAXEXPORT || zingchart.DEV.LOCALSVGEXPORT) && "pdf" !== e && "svg" !== e;
                if (
                    (ZC.mobile ||
                        !A ||
                        t ||
                        l ||
                        ((r = ZC.Q.I2({ cls: "zc-abs zc-viewimage zc-style", id: a.L + "-viewimage", zidx: 5, p: ZC.AL(a.L + "-top"), wh: a.I + "/" + a.F })),
                        (s = ZC.Q.I2({ id: a.L + "-viewimage-close", p: r, zidx: 10, tl: "5/" + (a.I - 15), html: ZC.HJ["viewimage-close"] })),
                        ZC.A5(s)
                            .css("cursor", "pointer")
                            .css("left", a.I - 15 - ZC.A5(s).width() + "px"),
                        ZC.A5(s).bind("click", function () {
                            ZC.A5(r).remove();
                        })),
                    ZC.mobile && (l = !0),
                    !zingchart.DEV.LOCALSVGEXPORT || l || "svg" !== a.AC || ("png" !== e && "jpeg" !== e))
                ) {
                    var C;
                    if ("canvas" === a.AC && "pdf" !== e && "svg" !== e) {
                        var c,
                            u,
                            p = document.createElement("canvas");
                        for (p.width = a.I, p.height = a.F, c = 0, u = a.AG.length; c < u; c++) a.AG[c].BE && a.AG[c].BE.EL(p);
                        var Z = [];
                        ZC.A5("#" + a.L + " canvas").each(function () {
                            -1 === ZC.AV([a.L + "-guide-c", a.L + "-trigger-c"], this.id) && Z.push(this);
                        }),
                            Z.push(p),
                            Z.push(a.createPreviewMasks());
                        var h = ZC.AP.ABR(Z, a.I, a.F, e, !0);
                        (h.id = a.L + "-print-" + e), r.appendChild(h);
                    } else if ((t || a.A81(ZC.HJ["export-wait"]), "vml" === a.AC || ("canvas" === a.AC && ("pdf" === e || "svg" === e)))) {
                        var d = document.createElement("div"),
                            f = "zc-export-svg-" + a.L;
                        (d.id = f),
                            (d.style.display = "none"),
                            document.body.appendChild(d),
                            zingchart.render({
                                id: f,
                                output: "!svg",
                                imggen: !0,
                                width: a.I,
                                height: a.F,
                                data: a.D.json,
                                defaults: a.MN,
                                theme: a.LJ,
                                hideprogresslogo: !0,
                                events: {
                                    load: function () {
                                        window.setTimeout(function () {
                                            var e = zingchart.getLoader(f);
                                            if (e.D["dynamic-objects"])
                                                var i = window.setInterval(function () {
                                                    "ready" === e.D["dynamic-objects"] &&
                                                        (window.clearInterval(i), e.togglePreviewMasks(!0), (C = ZC.AL(f + "-top").innerHTML), e.togglePreviewMasks(!1), zingchart.exec(f, "destroy", { skipfs: !0 }), _());
                                                }, 100);
                                            else e.togglePreviewMasks(!0), (C = ZC.AL(f + "-top").innerHTML), e.togglePreviewMasks(!1), zingchart.exec(f, "destroy", { skipfs: !0 }), _();
                                        }, 100);
                                    },
                                },
                            });
                    } else "svg" === a.AC && (a.togglePreviewMasks(!0), (C = ZC.AL(a.L + "-top").innerHTML), _(), a.togglePreviewMasks(!1));
                    A &&
                        !t &&
                        (ZC.A5(s)
                            .css("cursor", "pointer")
                            .css("left", a.I - 15 - ZC.A5(s).width() + "px"),
                        ZC.A5(s).bind("click", function () {
                            ZC.A5(r).remove();
                        }));
                } else
                    zingchart.exec(a.L, "getimagedata", {
                        callback: function (l) {
                            if (-1 !== l) {
                                var o = document.createElement("img");
                                (o.id = a.L + "-print-" + e), (o.src = l), r.appendChild(o);
                            } else ZC.Q.ET(a.L + "-viewimage"), (zingchart.DEV.LOCALSVGEXPORT = 0), a.OB(e, i, t, n);
                        },
                    });
            }
            function _() {
                var s,
                    A,
                    c = { svg: (C = (C = C.replace(/<foreignObject(.+?)<\/foreignObject>/g, "")).replace(' xmlns="http://www.w3.org/2000/svg"', "")), w: a.I, h: a.F, t: e, fn: o };
                if ((ZC._cp_(i, c), zingchart.AJAXEXPORT && "pdf" !== e && "svg" !== e && !l)) {
                    var u = "base64=1&";
                    for (A in c) u += A + "=" + encodeURIComponent(c[A]) + "&";
                    ZC.A5.ajax({
                        type: "post",
                        url: zingchart.EXPORTURL,
                        data: u,
                        success: function (i, l, o) {
                            if ((a.A43(), t)) n && n(i, l, o);
                            else {
                                var s = document.createElement("img");
                                (s.src = i), (s.id = a.L + "-print-" + e), r.appendChild(s);
                            }
                        },
                    });
                } else {
                    ZC.AL(a.L + "-export") && ZC.Q.ET(a.L + "-export");
                    var p = ZC.Q.I2({ cls: "zc-abs zc-style", id: a.L + "-export", p: ZC.AL(a.L + "-top"), display: "none" }),
                        Z = (s = null !== ZC._n_(c.uid) && null !== ZC._n_(c.page) ? ZC.Q.ABE(ZC.AL(a.L + "-export")) : document).createElement("FORM");
                    for (A in ((Z.action = zingchart.EXPORTURL),
                    (Z.method = "post"),
                    (Z.enctype = "multipart/form-data"),
                    null !== ZC._n_(c.uid) && null !== ZC._n_(c.page) ? s.body.appendChild(Z) : p.appendChild(Z),
                    (Z.style.display = "none"),
                    c)) {
                        var h = s.createElement("INPUT");
                        (h.type = "hidden"), (h.name = A), (h.value = c[A]), Z.appendChild(h);
                    }
                    Z.submit(),
                        (Z = null),
                        null !== ZC._n_(c.uid) &&
                            null !== ZC._n_(c.page) &&
                            window.setTimeout(function () {
                                ZC.A5("#" + a.L + "-export").remove();
                            }, 6e4),
                        window.setTimeout(function () {
                            a.A43();
                        }, 1e3);
                }
            }
        }),
        (ZC.Q1.prototype.Z4 = function (e) {
            var i = this;
            e = e || "png";
            var t,
                n,
                a = [],
                l = document.createElement("canvas");
            for (l.width = i.I, l.height = i.F, t = 0, n = i.AG.length; t < n; t++) i.AG[t].BE && i.AG[t].BE.EL(l);
            return (
                ZC.A5("#" + i.L + " canvas").each(function () {
                    -1 === ZC.AV([i.L + "-guide-c", i.L + "-tooltip-c"], this.id) && a.push(this);
                }),
                a.push(l),
                a.push(i.createPreviewMasks()),
                ZC.AP.A40(a, i.I, i.F, e)
            );
        }),
        (ZC.AP.downloadFile = function (e, i, t) {
            if (!ZC.ie678) {
                t = t || "application/octet-stream";
                var n = document.createElement("a");
                navigator.msSaveBlob
                    ? navigator.msSaveBlob(new Blob([e], { type: t }), i)
                    : URL && "download" in n
                    ? ((n.href = URL.createObjectURL(new Blob([e], { type: t }))), n.setAttribute("download", i), document.body.appendChild(n), n.click(), document.body.removeChild(n))
                    : (location.href = "data:application/octet-stream," + encodeURIComponent(e));
            }
        }),
        (ZC.AP.XM = function (e, i) {
            var t,
                n,
                a,
                l,
                o,
                r,
                s,
                A,
                C,
                c,
                u,
                p,
                Z,
                h = [],
                d = "",
                f = [];
            for (
                "xls" === (i = i || "csv") &&
                    h.push(
                        '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40">',
                        "<head>",
                        "\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>[ZC]</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e",
                        '<style>td{border:none;font-family:Calibri,sans-serif} .number{mso-number-format:"0.00";} .text{mso-number-format:"@";}</style>',
                        "<meta name=ProgId content=Excel.Sheet>",
                        "<meta charset=UTF-8>",
                        "</head>",
                        "<body>"
                    ),
                    t = 0,
                    n = e.AG.length;
                t < n;
                t++
            ) {
                var _ = e.AG[t],
                    g = _.AZ.A3;
                e.D.fastlinedata && (g = e.D.fastlinedata);
                var v = {},
                    b = [],
                    B = _.BW("k")[0];
                ("html" !== i && "xls" !== i && "raw" !== i) || (h.push("<table>"), _.IR && "" !== _.IR.AM && (f.push([_.IR.AM]), h.push("<caption>" + _.IR.AM + "</caption>")), h.push("<thead>"), h.push("<tr>")), (u = []), (Z = []);
                var m = "Category",
                    D = !1,
                    E = "%Y-%mm-%dd %H:%i:%s";
                for (
                    B && (B.F7 && "date" === B.F7.o.type && ((m = "Date"), (D = !0), B.F7.o["export-format"] && (E = B.F7.o["export-format"])), B.M && B.M.AM && (m = B.M.AM.replace(/\"|\'/g, ""))),
                        "csv" === i ? u.push('"' + m + '"') : "raw" === i ? Z.push(m) : ("html" !== i && "xls" !== i) || u.push("<th>" + m + "</th>"),
                        a = 0,
                        l = g.length;
                    a < l;
                    a++
                )
                    (null === ZC._n_(g[a].o["export"]) || ZC._b_(g[a].o["export"])) &&
                        ((p = (p = null !== ZC._n_(g[a].AM) ? g[a].AM + "" : "Series " + a).replace(/\"|\'/g, "")),
                        "csv" === i ? u.push('"' + p + '"') : "raw" === i ? Z.push(p) : ("html" !== i && "xls" !== i) || u.push("<th" + ("xls" === i ? ' scope="col" class="text"' : "") + ">" + p + "</th>"),
                        b.push(""));
                if (("csv" === i ? h.push(u.join(",")) : "raw" === i ? f.push(Z) : ("html" !== i && "xls" !== i) || h.push(u.join("")), ("html" !== i && "xls" !== i) || (h.push("</tr>"), h.push("</thead>"), h.push("<tbody>")), B)) {
                    for (s = 0, A = B.V.length; s < A; s++) v[s + ""] = { hasData: !1, nodes: [].concat(b) };
                    var L = [];
                    for (a = 0, l = g.length; a < l; a++)
                        if (null === ZC._n_(g[a].o["export"]) || ZC._b_(g[a].o["export"]))
                            for (o = 0, r = g[a].S.length; o < r; o++) {
                                var F = g[a].S[o];
                                F && ((v[(s = null !== ZC._n_(F.BV) ? "" + F.BV : "" + o)] = v[s] || { hasData: !0, nodes: [].concat(b) }), (v[s].nodes[a] = F.AD), (v[s].hasData = !0), null !== ZC._n_(F.BV) && L.push("" + F.BV));
                            }
                    var I = [];
                    for (s in v) v[s].hasData && I.push([s, v[s].nodes]);
                    I.sort(function (e, i) {
                        return e[0] - i[0];
                    });
                    var x = null;
                    for (C = 0, c = I.length; C < c; C++) {
                        if (
                            (("html" !== i && "xls" !== i) || h.push("<tr>"),
                            ("pie" !== _.AF && "pie3d" !== _.AF && "nestedpie" !== _.AF) || (B.V[I[C][0]] && (I[C][0] = B.V[I[C][0]])),
                            B.BY[I[C][0]] && (I[C][0] = B.BY[I[C][0]]),
                            B.V[I[C][0]] && -1 === ZC.AV(L, I[C][0]) && (I[C][0] = B.V[I[C][0]]),
                            ((x = _.A.FG()).row = C),
                            (x.col = 0),
                            (x.value = I[C][0]),
                            (I[C][0] = ZC.AP.C0("dataexport", _.A, x, I[C][0], null)),
                            ZC._n_(I[C][1]))
                        )
                            for (var y = 0; y < I[C][1].length; y++) ((x = _.A.FG()).row = C), (x.col = y + 1), (x.value = I[C][1][y]), (I[C][1][y] = ZC.AP.C0("dataexport", _.A, x, I[C][1][y], null));
                        D && ((I[C][0] = ZC.AP.Y5(I[C][0], E, _.UN, _.NB)), "csv" === i && (I[C][0] = '"' + I[C][0] + '"')),
                            "csv" === i
                                ? h.push([].concat(I[C][0]).concat(I[C][1]).join(","))
                                : "raw" === i
                                ? f.push([].concat(I[C][0]).concat(I[C][1]))
                                : ("html" !== i && "xls" !== i) || h.push("<td" + ("xls" === i ? ' scope="row"' : "") + ">" + [].concat(I[C][0]).concat(I[C][1]).join("</td><td>") + "</td>"),
                            ("html" !== i && "xls" !== i) || h.push("</tr>");
                    }
                }
                ("html" !== i && "xls" !== i) || (h.push("</tbody>"), h.push("</table>")), n > 1 && t < n - 1 && ("csv" === i ? h.push("", "", "") : ("html" !== i && "xls" !== i) || h.push("<p>&nbsp;</p>"));
            }
            return "xls" === i && h.push("</body>", "</html>"), "raw" === i ? f : ("csv" === i ? (d = h.join("\n")) : ("html" !== i && "xls" !== i) || (d = h.join("")), d);
        }),
        (zingchart.AB6 = function (e, i, t) {
            var n,
                a,
                l,
                o,
                r,
                s = "",
                A = "";
            function C(e) {
                ZC.A5.ajax({
                    type: "post",
                    url: a,
                    data: e,
                    success: function (e, i, t) {
                        l && l(e, i, t);
                    },
                });
            }
            document.getElementById("zc-fullscreen") && (e = "zc-fullscreen"), "string" == typeof (t = t || {}) && (t = JSON.parse(t));
            var c = zingchart.getLoader(e);
            if (c)
                switch (i) {
                    case "getimagedata":
                        if (
                            ((o = "png"),
                            null !== ZC._n_((n = t.format)) && (o = n),
                            null !== ZC._n_((n = t.filetype)) && (o = n),
                            "jpg" === o && (o = "jpeg"),
                            zingchart.DEV.LOCALSVGEXPORT && "svg" === c.AC && ("png" === o || "jpeg" === o))
                        ) {
                            c.togglePreviewMasks(!0);
                            var u = ZC.AL(c.L + "-svg").parentNode.innerHTML,
                                p = u.indexOf(">"),
                                Z = u.indexOf("</svg>");
                            u = (u = '<svg xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" version="1.1" width="' + c.I + '" height="' + c.F + '">[CSS]' + u.substring(p + 1, Z + 6)).replace(
                                /<foreignObject(.+?)<\/foreignObject>/g,
                                ""
                            );
                            var h = function () {
                                    var e,
                                        i = window.URL || window.webkitURL || window,
                                        n = !1;
                                    navigator && navigator.userAgent && -1 !== navigator.userAgent.indexOf("Safari") && -1 === navigator.userAgent.indexOf("Chrome") && (n = !0),
                                        (e = i.createObjectURL && window.Blob && !n ? i.createObjectURL(new window.Blob([u], { type: "image/svg+xml;charset-utf-16" })) : "data:image/svg+xml;charset=UTF-8," + encodeURIComponent(u)),
                                        c.togglePreviewMasks(!1);
                                    var a = new window.Image();
                                    (a.crossOrigin = "anonymous"),
                                        (a.src = e),
                                        (a.onload = function () {
                                            var i = document.createElement("canvas"),
                                                n = i.getContext("2d");
                                            if (((i.width = a.width), (i.height = a.height), n.drawImage(a, 0, 0, i.width, i.height), t.callback && "function" == typeof t.callback))
                                                try {
                                                    t.callback(i.toDataURL("image/" + o));
                                                } catch (l) {
                                                    t.callback(e);
                                                }
                                        });
                                },
                                d = 0,
                                f = function () {
                                    var e = new XMLHttpRequest();
                                    e.open("get", c.A2D[d]),
                                        (e.responseType = "text"),
                                        (e.onloadend = function (e) {
                                            var i = e.target.response,
                                                t = i.match(/https?:\/\/[^ \)]+/g),
                                                n = 0;
                                            t.forEach(function (e) {
                                                var a = new XMLHttpRequest();
                                                a.open("get", e),
                                                    (a.responseType = "blob"),
                                                    (a.onloadend = function (a) {
                                                        var l = new FileReader();
                                                        (l.onloadend = function (a) {
                                                            (i = i.replace(new RegExp(e), a.target.result)),
                                                                ++n === t.length && ((u = u.replace("[CSS]", "[CSS]<style><![CDATA[" + i + "]]></style>")), ++d === c.A2D.length ? ((u = u.replace("[CSS]", "")), h()) : f());
                                                        }),
                                                            l.readAsDataURL(a.target.response);
                                                    }),
                                                    a.send();
                                            });
                                        }),
                                        e.send();
                                };
                            c.A2D.length ? f() : ((u = u.replace("[CSS]", "")), h());
                        }
                        if ("canvas" !== c.AC && !zingchart.AJAXEXPORT) return -1;
                        if ("canvas" === c.AC) {
                            if (!t.callback || "function" != typeof t.callback) return c.Z4(o);
                            try {
                                t.callback(c.Z4(o));
                            } catch (b) {
                                t.callback(-1);
                            }
                        } else c.OB(o, {}, !0, t.callback);
                        break;
                    case "exportimage":
                    case "saveasimage":
                        if (!t.download && "canvas" !== c.AC && !zingchart.AJAXEXPORT) return -1;
                        if (
                            ((o = "png"),
                            (r = {}),
                            null !== ZC._n_((n = t.options)) && (r = n),
                            null !== ZC._n_((n = t.uid)) && (r.uid = n),
                            null !== ZC._n_((n = t.page)) && (r.page = n),
                            null !== ZC._n_((n = t.format)) && (o = n),
                            null !== ZC._n_((n = t.filetype)) && (o = n),
                            null !== ZC._n_((n = t.filename)) && (s = n),
                            (a = c.D.exportimageurl || ""),
                            null !== ZC._n_((n = t.url)) && (a = n),
                            (l = null),
                            null !== ZC._n_((n = t.callback)) && (l = n),
                            "jpg" === o && (o = "jpeg"),
                            t.download && ("canvas" !== c.AC || "pdf" === o))
                        )
                            return (r.download = !0), "" !== s && (r.fn = s), void c.OB(o, r);
                        if ("" !== a) {
                            if ("canvas" === c.AC) return C(c.Z4(o));
                            c.OB(o, r, !0, function (e) {
                                return C(e);
                            });
                        }
                        break;
                    case "exportdata":
                        if (((a = c.D.exportdataurl || ""), null !== ZC._n_((n = t.url)) && (a = n), (A = ZC.AP.XM(c, "csv")), "" === a)) return A;
                        (l = null),
                            null !== ZC._n_((n = t.callback)) && (l = n),
                            ZC.A5.ajax({
                                type: "post",
                                url: a,
                                data: A,
                                success: function (e, i, t) {
                                    l && l(e, i, t);
                                },
                            });
                        break;
                    case "downloadCSV":
                        (A = ZC.AP.XM(c, "csv")), ZC.AP.downloadFile(A, (t.fn || c.L) + ".csv", "text/csv;encoding:utf-8");
                        break;
                    case "downloadXLS":
                        A = ZC.AP.XM(c, "xls");
                        var _ = t.sn || "ZingChart";
                        (A = A.replace("<x:Name>[ZC]</x:Name>", "<x:Name>" + _ + "</x:Name>")), ZC.AP.downloadFile(A, (t.fn || c.L) + ".xls", "application/vnd.ms-excel;encoding:utf-8");
                        break;
                    case "downloadRAW":
                        var g = ZC.AP.XM(c, "raw");
                        if (!t.callback || "function" != typeof t.callback) return g;
                        try {
                            t.callback(g, t.fn || c.L);
                        } catch (b) {
                            t.callback(-1);
                        }
                        break;
                    case "viewDataTable":
                        if ("viewdatatable" === t.menuid)
                            if (((A = ZC.AP.XM(c, "html")), ZC.AL(c.L + "-data-table"))) ZC.AL(c.L + "-data-table").innerHTML = A;
                            else {
                                var v = ZC.Q.I2({ id: c.L + "-data-table", cls: "zc-data-table " + c.L + "-data-table" });
                                ZC.Q.PI(v, { width: c.I + "px", "max-height": "400px", overflow: "auto" }), (v.innerHTML = A), ZC.AL(c.L).parentNode.insertBefore(v, ZC.AL(c.L).nextSibling);
                            }
                        else "hidedatatable" === t.menuid && ZC.Q.ET(c.L + "-data-table");
                }
            return null;
        }),
        (ZC.A92 = {}),
        (ZC.AP.WO = function (e) {
            for (var i, t = "", n = !1, a = !1, l = 0, o = "", r = 0, s = (e = e.replace(/\t|\r|\n/g, "")).length; r < s; r++)
                switch ((i = e.substr(r, 1))) {
                    case '"':
                        (n = !n), (t += e.substr(r, 1)), (o = i);
                        break;
                    case "{":
                        (t += e.substr(r, 1)), n || ((t += "\n" + new Array(l + 1).join("    ")), l++, (o = i));
                        break;
                    case "}":
                        n || ((t += "\n" + new Array(l).join("    ")), l--, (o = i)), (t += e.substr(r, 1));
                        break;
                    case "[":
                        var A = e.indexOf("]", r),
                            C = e.indexOf("}", r);
                        C = -1 === C ? 999999 : C;
                        var c = e.indexOf("{", r);
                        (c = -1 === c ? 999999 : c), A < ZC.CY(C, c) ? ((a = !0), (t += e.substr(r, 1))) : ((a = !1), (t += e.substr(r, 1)), (t += "\n" + new Array(l + 1).join("    ")), l++), (o = i);
                        break;
                    case "]":
                        a && (a = !1), "}" === o && (l--, (t += "\n" + new Array(l).join("    "))), (t += e.substr(r, 1)), (o = i);
                        break;
                    case " ":
                        n && ((t += e.substr(r, 1)), (o = i));
                        break;
                    case ",":
                        (t += e.substr(r, 1)), n || a || (t += "\n" + new Array(l).join("    ")), (o = i);
                        break;
                    default:
                        (t += e.substr(r, 1)), (o = i);
                }
            return t;
        }),
        (ZC.Q1.prototype.A5S = function () {
            var e = this;
            ZC.AP.C0("source_show", e, e.FG());
            var i = ZC.Q.I2({ cls: "zc-abs zc-viewsource zc-style", id: e.L + "-viewsource", p: ZC.AL(e.L + "-top"), wh: e.I - (ZC.quirks ? 0 : 10) + "/" + (e.F - (ZC.quirks ? 0 : 10)) });
            (i.style.zIndex = 99),
                (i.innerHTML = ZC._h_(
                    '<div class="zc-form-row-label zc-form-s1">&nbsp;<a href="javascript:void(0)" id="' +
                        e.L +
                        '-viewsource-originalsource" class="zc-tab-active">' +
                        ZC.HJ["viewsource-originalsource"] +
                        '</a>&nbsp;<a href="javascript:void(0)" id="' +
                        e.L +
                        '-viewsource-jsonsource" class="zc-tab-inactive">' +
                        ZC.HJ["viewsource-jsonsource"] +
                        '</a></div><div class="zc-form-row-element"><textarea id="' +
                        e.L +
                        '-viewsource-json" style="width:' +
                        (e.I - 35) +
                        "px;height:" +
                        (e.F - 95) +
                        'px;"></textarea></div><div class="zc-form-row-element zc-form-row-last" id="' +
                        e.L +
                        '-viewsource-actions"><input type="button" value="' +
                        ZC.HJ["viewsource-close"] +
                        '" id="' +
                        e.L +
                        '-viewsource-close" /></div>'
                )),
                zingchart.EDITSOURCE && (ZC.AL(e.L + "-viewsource-actions").innerHTML += '<input type="button" value="' + ZC.HJ["viewsource-apply"] + '" id="' + e.L + '-viewsource-apply" />'),
                ZC.A5("#" + e.L + "-viewsource-json").val(ZC.AP.WO(e.D.source)),
                ZC.A5("#" + e.L + "-viewsource-jsonsource").bind("click", function () {
                    (ZC.AL(e.L + "-viewsource-jsonsource").className = "zc-tab-active"), (ZC.AL(e.L + "-viewsource-originalsource").className = "zc-tab-inactive"), ZC.A5("#" + e.L + "-viewsource-json").val(ZC.AP.WO(e.D.json));
                }),
                ZC.A5("#" + e.L + "-viewsource-originalsource").bind("click", function () {
                    (ZC.AL(e.L + "-viewsource-jsonsource").className = "zc-tab-inactive"), (ZC.AL(e.L + "-viewsource-originalsource").className = "zc-tab-active"), ZC.A5("#" + e.L + "-viewsource-json").val(ZC.AP.WO(e.D.source));
                }),
                ZC.A5("#" + e.L + "-viewsource-close").bind("click", function () {
                    ZC.AP.C0("source_hide", e, e.FG()), ZC.Q.ET(e.L + "-viewsource");
                }),
                zingchart.EDITSOURCE &&
                    ZC.A5("#" + e.L + "-viewsource-apply").bind("click", function () {
                        ZC.AP.C0("source_hide", e, e.FG());
                        var i = ZC.A5("#" + e.L + "-viewsource-json").val();
                        ZC.Q.ET(e.L + "-viewsource"), zingchart.exec(e.L, "setdata", { data: i });
                    });
        }),
        (ZC.Q1.prototype.A6J = function () {
            var e = this;
            if (e.I < 300 || e.F < 300) window.open("http://www.zingchart.com/support/", "", "");
            else {
                var i = ZC.Q.I2({ cls: "zc-abs zc-bugreport zc-style", id: e.L + "-bugreport", p: ZC.AL(e.L + "-top"), wh: e.I - (ZC.quirks ? 0 : 10) + "/" + (e.F - (ZC.quirks ? 0 : 10)) }),
                    t = "";
                (t +=
                    '<div class="zc-form-row-label zc-form-s0">' +
                    ZC.HJ["bugreport-header"] +
                    '</div><div class="zc-form-row-label"><input type="checkbox" id="' +
                    e.L +
                    '-chkdata" checked="checked" /><label for="' +
                    e.L +
                    '-chkdata">' +
                    ZC.HJ["bugreport-senddata"] +
                    "</label>"),
                    ZC.canvas && (t += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="checkbox" id="' + e.L + '-chkcapture" checked="checked" /><label for="' + e.L + '-chkcapture">' + ZC.HJ["bugreport-sendcapture"] + "</label>"),
                    (t +=
                        '</div><div class="zc-form-row-label zc-form-s1">' +
                        ZC.HJ["bugreport-yourcomment"] +
                        '</div><div class="zc-form-row-element"><textarea id="' +
                        e.L +
                        '-bugreport-comment" style="width:' +
                        (e.I - 35) +
                        "px;height:" +
                        ((e.F - 300) / 2 - 10) +
                        'px;"></textarea></div><div class="zc-form-row-label zc-form-s1">' +
                        ZC.HJ["bugreport-jsondata"] +
                        '</div><div class="zc-form-row-element"><textarea id="' +
                        e.L +
                        '-bugreport-json" style="width:' +
                        (e.I - 35) +
                        "px;height:" +
                        (e.F - 210) / 2 +
                        'px;"></textarea></div><div class="zc-form-row-label zc-form-s1">' +
                        ZC.HJ["bugreport-youremail"] +
                        (e.I >= 510 ? " <span>(" + ZC.HJ["bugreport-infoemail"] + ")</span>" : "") +
                        '</div><div class="zc-form-row-element"><input type="text" id="' +
                        e.L +
                        '-bugreport-email" style="width:' +
                        (e.I - 35) +
                        'px;" /></div><div class="zc-form-row-element zc-form-row-last"><input type="button" value="' +
                        ZC.HJ["bugreport-submit"] +
                        '" id="' +
                        e.L +
                        '-bugreport-submit" /><input type="button" value="' +
                        ZC.HJ["bugreport-cancel"] +
                        '" id="' +
                        e.L +
                        '-bugreport-cancel" /></div>'),
                    (i.innerHTML = ZC._h_(t)),
                    ZC.A5("#" + e.L + "-bugreport-json").val("PARSED\n----------\n" + ZC.AP.WO(e.D.json) + "\n\nORIGINAL\n----------\n" + ZC.AP.WO(e.D.source)),
                    ZC.A5("#" + e.L + "-bugreport-cancel").bind("click", function () {
                        ZC.Q.ET(e.L + "-bugreport");
                    }),
                    ZC.A5("#" + e.L + "-bugreport-submit").bind("click", function () {
                        var i = ZC.A5("#" + e.L + "-bugreport-email"),
                            t = "",
                            n = function () {
                                var n = ("Parsed:" + e.D.json + " Original:" + e.D.source).replace(/\r|\n|\t|(\s{2,})/g, ""),
                                    a = "",
                                    l = [];
                                ZC.A5("#" + e.L + "-chkcapture").attr("checked") && l.push("****IMAGE:", t),
                                    ZC.A5("#" + e.L + "-chkdata").attr("checked") && l.push("****JSON:", n),
                                    l.push(
                                        "****COMMENT:",
                                        ZC.A5("#" + e.L + "-bugreport-comment").val(),
                                        "****EMAIL:",
                                        i.val(),
                                        "****VERSION:",
                                        ZC.VERSION,
                                        "****WIDTH:",
                                        e.I,
                                        "****HEIGHT:",
                                        e.F,
                                        "****URL:",
                                        window.location.href,
                                        "****UA:",
                                        navigator.userAgent,
                                        "****RENDER:",
                                        e.AC.toUpperCase(),
                                        "****RESOLUTION:",
                                        screen.width + "x" + screen.height
                                    );
                                for (var o = 0; o < l.length - 1; o += 2) a += l[o] + encodeURIComponent(l[o + 1]);
                                a += "****END";
                                var r = ZC.Q.ABE(ZC.AL(e.L + "-bugreport")),
                                    s = r.createElement("FORM");
                                (s.action = document.location.protocol + "//www.zingchart.com/support/submitreportH5.php"), (s.method = "post"), r.body.appendChild(s);
                                var A = r.createElement("INPUT");
                                (A.type = "text"),
                                    (A.name = "data"),
                                    (A.value = a),
                                    s.appendChild(A),
                                    s.submit(),
                                    window.setTimeout(function () {
                                        alert(ZC.HJ["bugreport-confirm"]), ZC.Q.ET(e.L + "-bugreport");
                                    }, 1e3);
                            };
                        "canvas" === e.AC
                            ? ((t = zingchart.exec(e.L, "getimagedata", {})), n())
                            : (t = zingchart.exec(e.L, "getimagedata", {
                                  callback: function (e) {
                                      (t = e), n();
                                  },
                              }));
                    });
            }
        }),
        (ZC.Q1.prototype.paintHistory = function () {
            var e,
                i,
                t,
                n = this;
            ZC.Q.ET([n.L + "-history-path", n.L + "-history-back-path", n.L + "-history-forw-path", n.L + "-history-gradient", n.L + "-history-back-gradient", n.L + "-history-forw-gradient"]),
                null !== ZC._n_((e = n.o.history)) &&
                    ((n.ID = new ZC.DN(n)),
                    n.B8.load(n.ID.o, "loader.gui.history"),
                    n.ID.append(e),
                    n.ID.parse(),
                    (n.ID.A5L = !0),
                    (i = new ZC.DU(n)),
                    n.B8.load(i.o, "loader.gui.history.item"),
                    i.append(e.item),
                    i.parse(),
                    (t = new ZC.DU(n)),
                    n.B8.load(t.o, "loader.gui.history.item-off"),
                    t.append(e.item),
                    t.append(e["item-off"]),
                    t.parse());
            var a = "";
            if (n.ID) {
                (n.ID.L = n.L + "-history"), (n.ID.Z = n.ID.C7 = ZC.AL(n.L + "-static-c")), n.ID.paint();
                var l = n.ID.iX + n.ID.EQ,
                    o = n.ID.iY + n.ID.FM,
                    r = n.ID.I - n.ID.EQ - n.ID.FN,
                    s = n.ID.F - n.ID.FM - n.ID.FT,
                    A = new ZC.DU(n);
                (A.L = n.L + "-history-back"),
                    A.copy(i),
                    (A.CZ = !1),
                    0 === n.NR && A.copy(t),
                    (A.E = [
                        [l, o + s / 2],
                        [l + r / 3, o],
                        [l + r / 3, o + s],
                        [l, o + s / 2],
                    ]),
                    (A.IL = ZC.AL(n.A.L + "-text")),
                    (A.Z = A.C7 = ZC.AL(n.L + "-static-c")),
                    A.parse(),
                    A.paint(),
                    n.NR > 0 &&
                        ((a += ZC.Q.FX("rect", !0) + 'class="' + n.L + '-history-area zc-history-area" id="' + n.L + '-history-back-area" coords="'),
                        (a += ZC._i_(l + ZC.MAPTX) + "," + ZC._i_(o + ZC.MAPTX) + "," + ZC._i_(l + r / 3 + ZC.MAPTX) + "," + ZC._i_(o + s + ZC.MAPTX)),
                        (a += '" />'));
                var C = new ZC.DU(n);
                (C.L = n.L + "-history-forw"),
                    C.copy(i),
                    (C.CZ = !1),
                    (n.NR !== n.QU.length - 1 && 0 !== n.QU.length) || C.copy(t),
                    (C.E = [
                        [l + r, o + s / 2],
                        [l + (2 * r) / 3, o],
                        [l + (2 * r) / 3, o + s],
                        [l + r, o + s / 2],
                    ]),
                    (C.IL = ZC.AL(n.A.L + "-text")),
                    (C.Z = C.C7 = ZC.AL(n.L + "-static-c")),
                    C.parse(),
                    C.paint(),
                    n.NR < n.QU.length - 1 &&
                        ((a += ZC.Q.FX("rect", !0) + 'class="' + n.L + '-history-area zc-history-area" id="' + n.L + '-history-forw-area" coords="'),
                        (a += ZC._i_(l + (2 * r) / 3 + ZC.MAPTX) + "," + ZC._i_(o + ZC.MAPTX) + "," + ZC._i_(l + r + ZC.MAPTX) + "," + ZC._i_(o + s + ZC.MAPTX)),
                        (a += '" />')),
                    "" !== a && (ZC.AL(n.L + "-map").innerHTML += a),
                    (n.A0T = function (e) {
                        e.target.id === n.L + "-history-back-area" ? zingchart.exec(n.L, "goback") : e.target.id === n.L + "-history-forw-area" && zingchart.exec(n.L, "goforward");
                    }),
                    ZC.A5("." + n.L + "-history-area").live("click", n.A0T);
            }
        }),
        (ZC.AO = { A4U: 1, E4: 0, E5: 0, FU: 40 }),
        (ZC.DK = {
            A30: function (e, i) {
                var t, n;
                return (
                    i.AA % 180 == 0
                        ? ((t = new ZC.CF(e, -e.I / 2, i.iY - e.iY - e.F / 4, 0)), (n = new ZC.CF(e, e.I / 2, i.iY - e.iY - e.F / 4, 0)))
                        : ((t = new ZC.CF(e, i.iX - e.iX - e.I / 4, -e.F / 2, 0)), (n = new ZC.CF(e, i.iX - e.iX - e.I / 4, e.F / 2, 0))),
                    ZC.TN(Math.atan((n.ED[1] - t.ED[1]) / (n.ED[0] - t.ED[0]))) + (i.AA % 180 == 0 ? 0 : i.AA % 360 == 90 ? 90 : -90)
                );
            },
            DC: function (e, i, t, n, a, l, o, r, s) {
                s = s || "z";
                var A,
                    C,
                    c,
                    u,
                    p = new ZC.W6(e, i);
                switch (s) {
                    case "x":
                        (A = new ZC.CF(i, t, a, o)), (C = new ZC.CF(i, n, a, o)), (c = new ZC.CF(i, n, l, r)), (u = new ZC.CF(i, t, l, r));
                        break;
                    case "y":
                        (A = new ZC.CF(i, t, a, o)), (C = new ZC.CF(i, t, l, o)), (c = new ZC.CF(i, n, l, r)), (u = new ZC.CF(i, n, a, r));
                        break;
                    case "z":
                        (A = new ZC.CF(i, t, a, o)), (C = new ZC.CF(i, t, a, r)), (c = new ZC.CF(i, n, l, r)), (u = new ZC.CF(i, n, l, o));
                }
                return p.add(A), p.add(C), p.add(c), p.add(u), p;
            },
            D8: function (e, i, t, n) {
                void 0 === n && (n = !1);
                var a,
                    l = null,
                    o = null;
                t instanceof Array ? (l = t) : ((l = t.points), (o = t.mathpoints));
                for (var r = new ZC.W6(e, i), s = 0, A = l.length; s < A; s++) null !== ZC._n_(l[s]) && (n ? r.add(l[s], o ? o[s] : null) : r.add(new ZC.CF(i, l[s][0], l[s][1], l[s][2]), o ? new ZC.CF(i, o[s][0], o[s][1], o[s][2]) : null));
                return (a = e.o["z-modifier"]) && (r.ME = [ZC._i_(a), ZC._i_(a), ZC._i_(a)]), r;
            },
        });
    var CF = {
        $i: function (e, i, t, n) {
            this.parse(e, i, t, n);
        },
        parse: function (e, i, t, n) {
            var a = this;
            (a.C = e), (a.iX = i), (a.iY = t), (n -= a.C.F0.depth / 2), (a.iZ = n), (a.EJ = 0), (a.EO = 0), (a.AAQ = 0), (a.ED = []);
            var l = a.C.F0.angle,
                o = a.C.F0.zoom;
            if (a.C.F0.true3d) {
                var r = { x: i, y: t, z: n },
                    s = { x: 0, y: 0, z: 0 },
                    A = { x: a.C.F0["x-angle"], y: a.C.F0["y-angle"], z: a.C.F0["z-angle"] },
                    C = (2 * Math.PI) / 360,
                    c = Math.sin(A.x * C),
                    u = Math.sin(A.y * C),
                    p = Math.sin(A.z * C),
                    Z = Math.cos(A.x * C),
                    h = Math.cos(A.y * C),
                    d = Math.cos(A.z * C);
                (a.EJ = h * (p * (r.y - s.y) + d * (r.x - s.x)) - u * (r.z - s.z)),
                    (a.EO = c * (h * (r.z - s.z) + u * (p * (r.y - s.y) + d * (r.x - s.x))) + Z * (d * (r.y - s.y) - p * (r.x - s.x))),
                    (a.AAQ = Z * (h * (r.z - s.z) + u * (p * (r.y - s.y) + d * (r.x - s.x))) - c * (d * (r.y - s.y) - p * (r.x - s.x))),
                    (a.ED[0] = ZC.AO.E4 + (ZC.AO.A4U / (ZC.AO.A4U + a.AAQ)) * a.EJ * o),
                    (a.ED[1] = ZC.AO.E5 + (ZC.AO.A4U / (ZC.AO.A4U + a.AAQ)) * a.EO * o);
            } else (a.ED[0] = ZC.AO.E4 + i + n * ZC.EH(l) * o), (a.ED[1] = ZC.AO.E5 + t - n * ZC.EP(l) * o);
        },
    };
    ZC.CF = ZC.CA.CC(CF);
    var W6 = {
        $i: function (e, i) {
            var t = this;
            (t.C = i), (t.O = e), (t.L = ""), (t.K8 = !1), (t.ME = [1, 1, 1]), (t.FZ = -1), (t.E = []), (t.PB = []), (t.SJ = -9999), (t.ZS = -9999), (t.A5D = 9999), (t.A4Z = 9999), (t.A9H = 9999), (t.A3T = 0), (t.A2C = 0), (t.ABY = 0);
        },
        add: function (e, i) {
            this.E.push(e), this.PB.push(i || e);
        },
        ADC: function () {
            for (var e = this, i = e.PB.length, t = 0; t < i; t++) {
                var n = e.PB[t];
                (e.SJ = ZC.BQ(e.SJ, n.iZ)),
                    ZC._b_(e.C.F0.true3d) ? ((e.A5D = ZC.CY(e.A5D, n.iZ)), (e.ZS = ZC.BQ(e.ZS, n.AAQ)), (e.A2C += n.iY)) : ((e.A4Z = ZC.CY(e.A4Z, n.iX)), (e.A9H = ZC.CY(e.A9H, n.iY)), (e.A3T += n.iX), (e.A2C += n.iY), (e.ABY += n.iZ));
            }
            (e.A3T /= i), (e.A2C /= i), (e.ABY /= i);
        },
        FF: function () {
            for (var e = this, i = "", t = 0, n = e.E.length; t < n; t++) i += ZC._i_(e.E[t].ED[0] + ZC.MAPTX) + "," + ZC._i_(e.E[t].ED[1] + ZC.MAPTX) + ",";
            return (i = i.substring(0, i.length - 1));
        },
    };
    ZC.W6 = ZC.CA.CC(W6);
    var SN = {
        $i: function () {
            var e = this;
            (e.A55 = []), (e.A6M = {}), (e.WI = []), (e.SE = {});
        },
        clear: function () {
            var e = this;
            (e.A55 = []), (e.WI = []), (e.SE = {});
        },
        add: function (e) {
            this.A55.push(e);
        },
        sortFaces: function (e, i) {
            return 1 === zingchart.V3D
                ? e[0][0] > i[0][0]
                    ? -1
                    : e[0][0] < i[0][0]
                    ? 1
                    : e[0][1] > i[0][1]
                    ? 1
                    : e[0][1] < i[0][1]
                    ? -1
                    : e[0][2] > i[0][2]
                    ? -1
                    : e[0][2] < i[0][2]
                    ? 1
                    : e[0][3] > i[0][3]
                    ? -1
                    : e[0][3] < i[0][3]
                    ? 1
                    : 0
                : 2 === zingchart.V3D
                ? -1 !== e[0][3] || -1 !== i[0][3]
                    ? e[0][3] > i[0][3]
                        ? 1
                        : e[0][3] < i[0][3]
                        ? -1
                        : 0
                    : e[0][0] > i[0][0]
                    ? -1
                    : e[0][0] < i[0][0]
                    ? 1
                    : e[0][1] > i[0][1]
                    ? 1
                    : e[0][1] < i[0][1]
                    ? -1
                    : e[0][2] > i[0][2]
                    ? 1
                    : e[0][2] < i[0][2]
                    ? -1
                    : 0
                : 3 === zingchart.V3D
                ? e[0] > i[0]
                    ? -1
                    : e[0] < i[0]
                    ? 1
                    : 0
                : void 0;
        },
    };
    ZC.SN = ZC.CA.CC(SN);
    var A24 = {
        $i: function (e) {
            var i = this;
            (i.H = e), (i.VB = !1), (i.OP = 250), (i.GI = 0), (i.II = 0), (i.H0 = 20), (i.BA = ""), (i.CH = []), (i.A7 = null);
        },
        onmouseout: function () {
            var e = this;
            ZC.mobile ||
                (e.VB
                    ? (null !== ZC._n_(e.C4) && window.clearInterval(e.C4),
                      (e.C4 = window.setInterval(function () {
                          var i = e.H.L,
                              t = ZC.A5("#" + i + ("svg" === e.H.AC ? "-top" : "-main")),
                              n = ZC.E1[0] - t.offset().left,
                              a = ZC.E1[1] - t.offset().top;
                          (ZC.DT(n, e.GI, e.GI + e.A7.I) && ZC.DT(a, e.II, e.II + e.A7.F)) || (null !== ZC._n_(e.C4) && window.clearInterval(e.C4), e.hide());
                      }, e.OP)))
                    : e.hide());
        },
        clear: function () {
            var e = this;
            ZC.Q.IV(ZC.AL(e.H.L + "-tooltip-c"), e.H.AC, e.iX, e.iY, e.I, e.F, e.L);
        },
        hide: function () {
            if (!ZC.TTLOCK) {
                var e = this.H.L;
                ZC.Q.ET([e + "-tooltip-text", e + "-tooltip", e + "-tooltip-text-float"]),
                    "svg" === this.H.AC &&
                        ZC.A5("clipPath").each(function () {
                            -1 !== this.id.indexOf("-hover_image-clip") && ZC.Q.ET(this.id);
                        });
            }
        },
        show: function (e) {
            var i,
                t = this;
            null !== ZC._n_(t.C4) && window.clearInterval(t.C4);
            var n = t.H.L;
            if (0 !== ZC.A5("#" + n + "-tooltip-c").length && t.A7) {
                var a = ZC._tx_(t.H.L),
                    l = ZC.Q.MD(e),
                    o = ZC.A5("#" + n + ("svg" === t.H.AC ? "-top" : "-main")),
                    r = null === ZC._n_(e.target) ? t.A7.o.x : l[0] - o.offset().left,
                    s = null === ZC._n_(e.target) ? t.A7.o.y : l[1] - o.offset().top,
                    A = r - (t.A7.I * a[0]) / 2,
                    C = s - t.A7.F * a[1],
                    c = A,
                    u = 1 + 2 * t.A7.JV;
                if (
                    (null !== ZC._n_(t.A7.o.x) && ((A = ZC.IJ(t.A7.o.x, !0)) > 0 && A < 1 && (A = ZC._i_(t.H.I * A)), t.A7.o.fixed && (A -= t.A7.I / 2)),
                    null !== ZC._n_(t.A7.o.y) && ((C = ZC.IJ(t.A7.o.y, !0)) > 0 && C < 1 && (C = ZC._i_(t.H.F * C)), t.A7.o.fixed && (C -= t.A7.F / 2)),
                    (A += ZC._i_(t.A7.D["offset-x"])),
                    (C += ZC._i_(t.A7.D["offset-y"])),
                    "svg" === t.H.AC || !t.A7.o.placement || t.A7.o.fixed)
                ) {
                    var p = 0,
                        Z = !1,
                        h = t.A7.EM;
                    A / a[0] < u && ((p = c / a[0] - u - t.A7.H9 / 2), (A = u)),
                        A / a[0] + t.A7.I > t.H.I - u && ((p = c / a[0] + t.A7.I - t.H.I + u + t.A7.H9 / 2), (A = (t.H.I - u - t.A7.I) * a[0])),
                        C / a[1] < u &&
                            (t.CH.node || !t.A7.o.placement || t.A7.o.fixed
                                ? ((C = u + ZC._i_(t.A7.D["offset-y"])), (C = t.CH.node ? (C < u ? u : C) : C < u ? s - ZC._i_(t.A7.D["offset-y"]) : C), (h = "top"), (Z = !0))
                                : (C = u + (s - ZC._i_(t.A7.D["offset-y"])))),
                        C / a[1] + t.A7.F > t.H.F - u && ((C = t.H.F - u - t.A7.F), (t.CH.node || !t.A7.o.placement || t.A7.o.fixed) && ((h = "top"), (Z = !0))),
                        Z && (t.A7.EM = h),
                        (0 !== p || Z) &&
                            t.A7.Z &&
                            (t.clear(), Z && (t.A7.EM = h), (p = ZC.CY(p, t.A7.I / 2 - t.A7.H9 / 2)), (p = (48 * (p = ZC.BQ(p, -t.A7.I / 2 + t.A7.H9 / 2))) / (t.A7.I / 2 - t.A7.H9 / 2)), (t.A7.EW = p), t.A7.AN && t.A7.paint());
                }
                switch (((t.GI = A), (t.II = C), t.H.AC)) {
                    case "svg":
                        null === ZC._n_(t.A7.o.x) && null === ZC._n_(t.A7.o.y) && ZC.AL(n + "-tooltip").setAttribute("transform", "translate(" + A / a[0] + "," + C / a[1] + ")"),
                            t.A7.D["html-mode"] && ZC.Q.PI(ZC.AL(n + "-tooltip-text-float"), { left: ("" === t.BA ? A / a[0] : t.A7.iX) + t.A7.EQ + "px", top: ("" === t.BA ? C / a[1] : t.A7.iY) + t.A7.FM + "px" });
                        break;
                    case "vml":
                        null === ZC._n_(t.A7.o.x) && null === ZC._n_(t.A7.o.y) && ZC.Q.PI(ZC.AL(n + "-tooltip"), { left: A + "px", top: C + "px" });
                        break;
                    case "canvas":
                        null !== ZC._n_(t.CH.x) && (A = t.CH.x), null !== ZC._n_(t.CH.y) && (C = t.CH.y);
                        var d = t.A7.D["html-mode"] ? 0 : 20;
                        switch (t.A7.WV) {
                            case "tl":
                                break;
                            case "tr":
                                A -= t.A7.I;
                                break;
                            case "bl":
                                C -= t.A7.F;
                                break;
                            case "br":
                                (A -= t.A7.I), (C -= t.A7.F);
                                break;
                            case "c":
                                (A -= t.A7.I / 2), (C -= t.A7.F / 2);
                                break;
                            case "t":
                                A -= t.A7.I / 2;
                                break;
                            case "r":
                                (A -= t.A7.I), (C -= t.A7.F / 2);
                                break;
                            case "b":
                                (A -= t.A7.I / 2), (C -= t.A7.F);
                                break;
                            case "l":
                                C -= t.A7.F / 2;
                        }
                        ZC.Q.PI(ZC.AL(n + "-tooltip-c"), { left: A / a[0] - d + "px", top: C / a[1] - d + "px" }),
                            null !== (i = ZC.AL(n + "-tooltip-text")) && ((i.style.display = "none"), ZC.Q.PI(i, { width: t.A7.I + "px", height: t.A7.F + "px", left: A / a[0] + "px", top: C / a[1] + "px" }), (i.style.display = "block"));
                }
            }
        },
        onmousemove: function (e) {
            this.show(e);
        },
        onmouseover: function (e, i) {
            var t,
                n,
                a,
                l,
                o,
                r,
                s,
                A = this,
                C = A.H.L,
                c = e.targetid || e.target.id,
                u = c
                    .replace(/--([a-zA-Z0-9]+)/, "")
                    .replace("-gshape-area", "-area")
                    .replace("-area-path", "")
                    .replace("-path", "")
                    .replace("-marker-circle", "")
                    .replace("-marker", "")
                    .split("-")
                    .reverse(),
                p = c.split("--"),
                Z = !1,
                h = !1,
                d = !1;
            if (("node" === u[1] && "plot" === u[3] && "plotset" === u[4] && (Z = !0), ZC.Q.ET([C + "-tooltip-text", C + "-tooltip", C + "-tooltip-text-float"]), Z)) {
                if (!(l = A.H.OS(u[5]))) return;
                if (((o = l.AZ.A3[u[2]]), (r = o.FK(u[0])), "xy" === l.AJ.layout && r.T7(), !r)) return;
                ZC.A5("#" + C + "-graph-" + u[5] + "-plot-" + u[2] + "-bg-hover-c").show();
            } else "legend" === u[2] && 0 === u[1].indexOf("item") && (h = !0), 0 !== u[2].indexOf("scale") || (0 !== u[1].indexOf("item") && 0 !== u[1].indexOf("marker")) || (d = !0), (l = A.H.OS(u[3]));
            if (
                (ZC.AL(C + "-tooltip") ||
                    (ZC.Q.JZ({ id: C + "-tooltip", p: ZC.AL(C + "-main"), cls: "zc-abs zc-tooltip", wh: A.H.I + "/" + A.H.F, overflow: "hidden" }, A.H.AC),
                    ZC.Q.HE({ id: C + "-tooltip-c", p: ZC.AL(C + "-tooltip"), cls: "zc-abs", tl: "-999/-999", width: 140, height: 60 }, A.H.AC)),
                (A.A7 = zingchart.pool.getInstance("DN", A, C + "-tooltip-text")),
                (A.A7.OE = "tooltip"),
                (A.A7.A = A.H),
                l && l.A7 && A.A7.copy(l.A7),
                Z)
            )
                A.A7.append(o.A7.o), l.CD["p" + o.K] && l.CD["p" + o.K]["n" + r.K] && A.A7.append(o.A7.o["selected-state"]), 2 === p.length && A.A7.append(o.ABZ(p[1]));
            else {
                var f = !1;
                if ((h && l.BE && null !== ZC._n_(l.BE.o.tooltip) && ((A.A7.o.text = ""), A.A7.append(l.BE.o.tooltip), (f = !0)), d)) {
                    A.A7.append({ "background-color": "#fff", "border-width": 1, "border-color": "#999" });
                    var _ = l.BM(u[2].replace(/\_/g, "-"));
                    if ((_ && null !== ZC._n_(_.o.tooltip) && ((A.A7.o.text = ""), A.A7.append(_.o.tooltip), (f = !0)), 0 === u[1].indexOf("item_")))
                        _ &&
                            (-1 !== u[1].indexOf("_title") && _.o.label && _.o.label.tooltip
                                ? ((A.A7.o.text = ""), A.A7.append(_.o.label.tooltip), (f = !0))
                                : _.o.item && _.o.item.tooltip && ((A.A7.o.text = ""), A.A7.append(_.o.item.tooltip), (f = !0)));
                    else if (0 === u[1].indexOf("marker_")) {
                        var g = ZC._i_(u[1].replace("marker_", ""));
                        _.Q2[g] && _.Q2[g].o.label && _.Q2[g].o.label.tooltip && ((A.A7.o.text = ""), A.A7.append(_.Q2[g].o.label.tooltip), (f = !0));
                    }
                }
                if ("shape" === u[2])
                    if ((A.A7.append({ "background-color": "#fff", "border-width": 1, "border-color": "#999" }), e.target.getAttribute("data-lowlevel"))) A.A7.append({ text: e.target.getAttribute("data-tooltip-text") }), (f = !0);
                    else
                        for (n = 0, a = l.FH.length; n < a; n++)
                            if (null !== ZC._n_(l.FH[n])) {
                                var v = l.FH[n] instanceof ZC.P0 ? l.FH[n].BG : l.FH[n];
                                l.L + "-shape-" + u[1] === l.FH[n].L && null !== ZC._n_((t = v.o.tooltip)) && (A.A7.append(t), A.A7.o.fixed && ((A.A7.o.x = v.iX), (A.A7.o.y = v.iY)), (f = !0));
                            }
                if ("label" === u[2])
                    for (A.A7.append({ "background-color": "#fff", "border-width": 1, "border-color": "#999" }), n = 0, a = l.BY.length; n < a; n++)
                        l.L + "-label-" + u[1] === l.BY[n].L && null !== ZC._n_((t = l.BY[n].o.tooltip)) && (A.A7.append(t), A.A7.o.fixed && ((A.A7.o.x = l.BY[n].iX + l.BY[n].I / 2), (A.A7.o.y = l.BY[n].iY + l.BY[n].F / 2)), (f = !0));
                if (("xy" === u[2] && (A.A7.append({ "background-color": "#fff", "border-width": 1, "border-color": "#999" }), (f = !0)), !f)) return;
            }
            i && A.A7.append(i),
                (A.VB = !1),
                (A.OP = 250),
                null !== ZC._n_((t = A.A7.o.sticky)) && (A.VB = ZC._b_(t)),
                null !== ZC._n_((t = A.A7.o.timeout)) && (A.OP = ZC._i_(t)),
                null !== ZC._n_((t = A.A7.o.placement)) ? (A.BA = t) : (A.BA = ""),
                null !== ZC._n_((t = A.A7.o.distance)) && (A.H0 = ZC._i_(t)),
                (A.A7.iX = 0),
                (A.A7.iY = 0),
                (A.A7.Z = A.A7.C7 = ZC.AL(C + "-tooltip-c"));
            var b = {};
            if (Z)
                (s = r.Y2()),
                    r.H3(s),
                    null !== ZC._n_(s["line-color"]) ? (A.A7.A0 = A.A7.AE = ZC.AP.JM(s["line-color"])) : (A.A7.A0 = A.A7.AE = ZC.AP.JM(s["background-color"])),
                    (A.A7.BX = s["border-color"]),
                    (A.A7.C2 = s.color),
                    null !== ZC._n_(o.o.rules)
                        ? (A.ZW || ((A.ZW = new ZC.HV(o.A)), (A.ZW.D["quick-parse"] = !0)),
                          A.ZW.append(o.o),
                          A.ZW.parse(),
                          (A.ZW.J5 = function (e) {
                              return r.J5(e);
                          }),
                          A.ZW.DE() && A.ZW.parse(),
                          (A.A7.AM = A.ZW.J7))
                        : (A.A7.AM = o.J7),
                    (b = ZC.AP.O2(A.A7.o, o.o)),
                    (A.A7.JT = function (e) {
                        return r.JT(e, b);
                    }),
                    (A.A7.D.plotidx = r.A.K),
                    (A.A7.D.nodeidx = r.K);
            else if (h) {
                for (o = l.AZ.A3[u[1].replace("item_", "")], A.A7.append(o.o["legend-tooltip"]), r = null, n = 0, a = o.S.length; n < a; n++)
                    if (null !== o.S[n]) {
                        r = o.FK(n);
                        break;
                    }
                if (r) {
                    if ("-1" === (s = r.Y2())["background-color"]) return;
                    (A.A7.A0 = A.A7.AE = ZC.AP.JM(s["background-color"])), (A.A7.C2 = s.color);
                } else (A.A7.A0 = A.A7.AE = ZC.AP.JM(o.BP[1])), (A.A7.C2 = o.BP[0]);
                (A.A7.AM = o.OZ),
                    (A.A7.JT = function (e) {
                        return (e = (e = e.replace(/%plot-description/g, o.OZ)).replace(/%plot-text|%t/g, o.AM));
                    });
            } else if (d) {
                if (0 === u[1].indexOf("item_")) {
                    var B = u[1].replace("item_", "").split("_"),
                        m = 1 === B.length ? ZC._i_(B[0]) : ZC._i_(B[1]);
                    A.A7.JT = function (e) {
                        e = e || "%scale-value";
                        var i = _.BY[m] || _.V[m];
                        if (_.F7) {
                            var t = { "transform-date": !0, "transform-date-format": _.F7.o.all || _.F7.o.text || "", utc: l.UN, timezone: l.NB };
                            i = ZC.AP.G3(i, t, A.A, !!_.F7 && _.F7);
                        }
                        for (var n in ("number" == typeof i && _.IT && null !== ZC._n_(_.IT[i]) && (i = _.IT[i]), (e = (e = e.replace(/%text|%item-text|%scale-value|%v/g, i)).replace(/%tooltip-text/g, _.A53[m] || "")), _.o))
                            _.o.hasOwnProperty(n) && "data-" === n.substring(0, 5) && (e = e.replace("%" + n, _.o[n][m] || "", "g"));
                        return e;
                    };
                }
            } else
                A.A7.JT = function (e) {
                    return e;
                };
            if (
                (null === ZC._n_(A.A7.o["text-alpha"]) && (A.A7.o["text-alpha"] = 1),
                A.A7.parse(),
                !Z && "canvas" !== A.H.AC && A.A7.o.fixed && ((A.A7.iX = A.A7.iX - A.A7.I / 2 + A.A7.BL), (A.A7.iY = A.A7.iY - A.A7.F / 2 + A.A7.BI)),
                A.A7.AN)
            ) {
                var D, E;
                if (
                    (A.A7.HT && (Z && A.A7.H3(A.A7, A.A7, null, r.LZ(e, !1)), A.A7.parse()),
                    (A.A7.D["html-mode"] = !1),
                    null !== ZC._n_((t = A.A7.o["html-mode"])) && (A.A7.D["html-mode"] = ZC._b_(t)),
                    Z &&
                        ((A.A7.J5 = function (e) {
                            return r.J5(e);
                        }),
                        A.A7.DE() && ((b = A.A7.overrideFormat(b)), A.A7.parse())),
                    ("canvas" !== A.H.AC && "vml" !== A.H.AC) || 0 === A.A7.AA)
                )
                    (D = A.A7.I + A.A7.JV), (E = A.A7.F + A.A7.JV), (D += 40), (E += 40), (A.A7.D["offset-x"] = A.A7.BL), (A.A7.D["offset-y"] = A.A7.BI);
                else {
                    var L = 1.25 * ZC.BQ(A.A7.I, A.A7.F) + A.A7.JV;
                    (D = L), (E = L), (A.A7.iX += (L - A.A7.I) / 2), (A.A7.iY += (L - A.A7.F) / 2), (A.A7.D["offset-x"] = -(L - A.A7.I) / 2 + A.A7.BL), (A.A7.D["offset-y"] = -(L - A.A7.F) / 2 + A.A7.BI);
                }
                if (
                    (ZC.A5("#" + C + "-tooltip-c")
                        .attr("width", D)
                        .attr("height", E),
                    "vml" === A.H.AC && ZC.Q.PI(ZC.AL(C + "-tooltip-c"), { top: 0, left: 0 }),
                    (A.A7.QE = A.A7.BL),
                    (A.A7.MC = A.A7.BI),
                    (A.A7.BL = 0),
                    (A.A7.BI = 0),
                    !e.type && Z)
                ) {
                    var F = r.iX,
                        I = r.iY;
                    if (null !== ZC._n_(r.bCXY)) {
                        var x = r.ACE();
                        (F = x[0]), (I = x[1]);
                    }
                    "canvas" === A.H.AC
                        ? (null === ZC._n_(A.A7.o.x) && (A.A7.o.x = F - A.A7.I / 2), null === ZC._n_(A.A7.o.y) && (A.A7.o.y = I - A.A7.F))
                        : (null === ZC._n_(A.A7.o.x) && (A.A7.iX = F - A.A7.I / 2), null === ZC._n_(A.A7.o.y) && (A.A7.iY = I - A.A7.F - 20));
                }
                if (
                    (Z &&
                        ((A.CH = A.getPlacementInfo(r)),
                        "" !== A.BA && ("canvas" !== A.H.AC ? ((A.A7.o.x = A.A7.iX = A.CH.x), (A.A7.o.y = A.A7.iY = A.CH.y)) : ((A.A7.o.x = A.A7.iX = 0), (A.A7.o.y = A.A7.iY = 0)), (A.A7.EM = A.CH.cp), (A.A7.EW = A.CH.co))),
                    A.A7.AN && "" !== A.A7.AM && ("canvas" === A.H.AC && (A.A7.D["html-mode"] || ((A.A7.iX = 20), (A.A7.iY = 20))), A.A7.paint()),
                    ((e.type && Z) || e.update) && (r.AAY(), r.C.QM(!0)),
                    e.type || "canvas" === A.H.AC)
                )
                    A.show(e);
                else if (A.A7.D["html-mode"]) {
                    var y = A.A7.iX + A.A7.EQ,
                        w = A.A7.iY + A.A7.FM;
                    ZC.Q.PI(ZC.AL(C + "-tooltip-text-float"), { left: y + "px", top: w + "px", zIndex: zingchart.ZINDEX });
                }
            }
        },
        getPlacementInfo: function (e) {
            var i,
                t = this,
                n = {},
                a = t.A7.H9,
                l = t.A7.G8,
                o = t.A7.I,
                r = t.A7.F;
            if (t.A7.D["html-mode"] && ("horizontal" === t.BA || "vertical" === t.BA || "node:" === t.BA.substring(0, 5)) && ((t.A7.iX = -9999), (t.A7.iY = -9999), t.A7.AN)) {
                t.A7.paint();
                var s = ZC.A5("#" + t.H.L + "-tooltip-text-" + ("canvas" === t.H.AC ? "t" : "float"));
                (o = s.width() + t.A7.EQ + t.A7.FN), (r = s.height() + t.A7.FM + t.A7.FT), null !== ZC._n_(t.A7.o.width) && (o = ZC._i_(t.A7.o.width)), null !== ZC._n_(t.A7.o.height) && (r = ZC._i_(t.A7.o.height));
            }
            if ("horizontal" === t.BA)
                e.iX + e.I / 2 < e.C.iX + e.C.I / 2 ? ((n.x = e.iX + 0 * e.I + t.H0), (n.y = e.iY + (0 * e.F) / 2 - r / 2), (n.cp = "left")) : ((n.x = e.iX - o - t.H0), (n.y = e.iY + (0 * e.F) / 2 - r / 2), (n.cp = "right")),
                    n.y < 5 && ((i = 5 - n.y), (n.co = -ZC._i_((100 * i) / (r - l))), (n.y = 5)),
                    n.y + r > t.H.F - 5 && ((i = t.H.F - 5 - n.y - r), (n.co = -ZC._i_((100 * i) / (r - l))), (n.y = t.H.F - 5 - r));
            else if ("vertical" === t.BA)
                e.iY + e.F / 2 < e.C.iY + e.C.F / 2 ? ((n.y = e.iY + 0 * e.F + t.H0), (n.x = e.iX + (0 * e.I) / 2 - o / 2), (n.cp = "top")) : ((n.y = e.iY - r - t.H0), (n.x = e.iX + (0 * e.I) / 2 - o / 2), (n.cp = "bottom")),
                    n.x < 5 && ((i = 5 - n.x), (n.co = -ZC._i_((100 * i) / (t.A7.I - a))), (n.x = 5)),
                    n.x + o > t.H.I - 5 && ((i = t.H.I - 5 - n.x - o), (n.co = -ZC._i_((100 * i) / (o - a))), (n.x = t.H.I - 5 - o));
            else if ("node:" === t.BA.substring(0, 5) && e.getTooltipPosition) {
                switch ((((n = e.getTooltipPosition(t.A7, t.BA.substring(5))).node = !0), (n.side = t.BA.substring(5)), n.side)) {
                    case "left":
                        (n.x = n.x - o + t.A7.QE), (n.y = n.y - r / 2 + t.A7.MC);
                        break;
                    case "right":
                        (n.x = n.x + t.A7.QE), (n.y = n.y - r / 2 + t.A7.MC);
                        break;
                    case "top":
                        (n.x = n.x - o / 2 + t.A7.QE), (n.y = n.y - r + t.A7.MC);
                        break;
                    case "bottom":
                        (n.x = n.x - o / 2 + t.A7.QE), (n.y = n.y + t.A7.MC);
                        break;
                    case "center":
                        (n.x = n.x - o / 2 + t.A7.QE), (n.y = n.y - r / 2 + t.A7.MC);
                }
                n.cp = t.A7.EM;
            }
            if (n.node) {
                var A = 0;
                n.y + r > t.H.F - 5 && ("top" === n.side || "bottom" === n.side ? ((n.y = n.y - r - ("bottom" === n.side ? 0 : t.A7.G8) - t.A7.MC), (n.cp = "bottom")) : (n.y = t.H.F - r - 5)),
                    n.y < 5 && ("top" === n.side || "bottom" === n.side ? ((n.y = n.y + ("top" === n.side ? 0 : t.A7.G8) + r - t.A7.MC), (n.cp = "top")) : (n.y = 5)),
                    n.x + o > t.H.I - 5 &&
                        ("left" === n.side || "right" === n.side ? ((n.x = n.x - o - t.A7.QE - 5), (n.cp = "right")) : ((A = (48 * (o - t.H.I + n.x + t.A7.H9 / 2)) / (t.A7.I / 2)), (n.x = t.H.I - o - t.A7.QE - 5)), (n.co = A)),
                    n.x < 5 && ("left" === n.side || "right" === n.side ? ((n.x = n.x + t.A7.I - t.A7.QE + 5), (n.cp = "left")) : ((A = (48 * (n.x - t.A7.H9 / 2)) / (t.A7.I / 2)), (n.x = 5)), (n.co = A));
            }
            return n;
        },
    };
    ZC.A24 = ZC.CA.CC(A24);
    var A4X = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.H = e), (i.IM = !1), (i.C = null), (i.R4 = null), (i.WP = null), (i.I9 = 0), (i.LD = 0), (i.I8 = 0), (i.LF = 0), (i.A8 = null), (i.AK = null), (i.ZL = !1), (i.AB9 = 0), (i.A0N = !1), (i.M = null);
        },
        parse: function () {
            var e = this;
            e.C &&
                (e.C.H2 && e.append(e.C.H2.o),
                e.b(),
                e.ZE("preserve-zoom", "A0N", "b"),
                (e.M = new ZC.DN(e)),
                e.C.A.B8.load(e.M.o, "graph.zoom.label"),
                e.M.append(e.o.label),
                e.M.parse(),
                e.o.label && !1 !== e.o.label.visible && (e.M.AN = !0));
        },
        unbind: function () {
            var e = this;
            zingchart.DEV.SKIPTRACKERS ? ZC.A5(document.body).unbind("mousedown touchstart", e.R2) : ZC.A5("#" + e.H.L + "-img").unbind("mousedown touchstart", e.R2),
                ZC.A5(".zc-node-area").die("mousedown touchstart", e.R2),
                ZC.A5(document.body).unbind("mousemove touchmove", e.U8),
                ZC.A5(document.body).unbind("mouseup touchend", e.TI);
        },
        bind: function () {
            var e = this,
                i = e.H.L;
            (e.R2 = function (t) {
                if (
                    (!ZC.mobile || "pinch" !== zingchart.TOUCHZOOM) &&
                    !(t.which > 1 || -1 !== ZC.Q.T4(t.target).indexOf("zc-menu-item") || ZC.move) &&
                    ("mousedown" !== t.type || !ZC.TOUCHEVENTS) &&
                    -1 === t.target.id.indexOf("-legend-header-area") &&
                    (ZC.mobile || t.preventDefault(), e.H.hideCM(), (ZC.mobile || !(t.which > 1)) && ("vml" !== e.H.AC || -1 === t.target.className.indexOf("zc-node-area")))
                ) {
                    t.shiftKey && (e.ZL = !0);
                    var n = ZC.Q.MD(t),
                        a = ZC._tx_(e.H.L),
                        l = ZC.A5("#" + i + "-top").offset(),
                        o = (n[0] - l.left) / a[0],
                        r = (n[1] - l.top) / a[1];
                    (e.R4 = o), (e.WP = r), e.ZL && (e.AB9 = o);
                    for (var s, A = !1, C = 0, c = e.H.AG.length; C < c; C++) (s = e.H.AG[C].P), ZC.DT(o, s.iX - 5, s.iX + s.I + 5) && ZC.DT(r, s.iY - 5, s.iY + s.F + 5) && (e.C = e.H.AG[C]);
                    if (null !== e.C) {
                        var u = { id: e.H.L, graphid: e.C.L, ev: t },
                            p = ZC.AP.C0("beforezoom", e.H, u, !0);
                        if (void 0 !== p && !p) return;
                        if (e.C.H2 && null !== ZC._n_(e.C.H2.o.active) && !ZC._b_(e.C.H2.o.active)) return;
                        (s = e.C.P),
                            e.C.AZ.A3.length > 0 && ((e.A8 = e.C.BM(e.C.AZ.A3[0].BW("k")[0])), (e.AK = e.C.BM(e.C.AZ.A3[0].BW("v")[0]))),
                            null !== e.A8 &&
                                null !== e.AK &&
                                e.C.AJ["enable-zooming"] &&
                                (e.A8.GN || e.AK.GN) &&
                                ((e.I9 = e.A8.CK ? r : o),
                                (e.I8 = e.AK.CK ? o : r),
                                (A = !0),
                                e.A8.GN ? (e.A8.CK ? (e.I9 = ZC._l_(e.I9, s.iY, s.iY + s.F)) : (e.I9 = ZC._l_(e.I9, s.iX, s.iX + s.I))) : (e.I9 = e.A8.CK ? s.iY : s.iX),
                                e.AK.GN ? (e.AK.CK ? (e.I8 = ZC._l_(e.I8, s.iX, s.iX + s.I)) : (e.I8 = ZC._l_(e.I8, s.iY, s.iY + s.F))) : (e.I8 = e.AK.CK ? s.iX : s.iY));
                    }
                    return (
                        A &&
                            ((e.LD = e.I9),
                            (e.LF = e.I8),
                            (e.IM = !0),
                            ZC.A5(document.body).bind("mousemove touchmove", e.U8),
                            ZC.A5(document.body).bind("mouseup touchend", e.TI),
                            e.ZL
                                ? (document.body.style.cursor = "pointer")
                                : (e.parse(),
                                  e.C.AJ["3d"] || ZC.Q.I2({ id: i + "-zoom", p: ZC.AL(i + "-top"), top: -9, left: -9, wh: "1/1", position: "absolute", border: e.AU + "px solid " + e.BX, background: e.A0, opacity: e.C6 }),
                                  e.M.AN &&
                                      (ZC.Q.I2({
                                          id: i + "-from",
                                          p: ZC.AL(i + "-top"),
                                          top: -9999,
                                          left: -9999,
                                          position: "absolute",
                                          paddingTop: e.M.FM,
                                          paddingRight: e.M.FN,
                                          paddingBottom: e.M.FT,
                                          paddingLeft: e.M.EQ,
                                          border: e.M.AU + "px solid " + e.M.BX,
                                          background: e.M.A0,
                                          color: e.M.C2,
                                          fontFamily: e.M.GH,
                                          fontWeight: e.M.sFontWeight,
                                          fontStyle: e.M.N7 ? "oblique" : "normal",
                                          fontSize: e.M.DJ,
                                          text: "",
                                      }),
                                      ZC.Q.I2({
                                          id: i + "-to",
                                          p: ZC.AL(i + "-top"),
                                          top: -9999,
                                          left: -9999,
                                          position: "absolute",
                                          paddingTop: e.M.FM,
                                          paddingRight: e.M.FN,
                                          paddingBottom: e.M.FT,
                                          paddingLeft: e.M.EQ,
                                          border: e.M.AU + "px solid " + e.M.BX,
                                          background: e.M.A0,
                                          color: e.M.C2,
                                          fontFamily: e.M.GH,
                                          fontWeight: e.M.sFontWeight,
                                          fontStyle: e.M.N7 ? "oblique" : "normal",
                                          fontSize: e.M.DJ,
                                          text: "",
                                      })),
                                  (document.body.style.cursor = "crosshair"))),
                        !!ZC.mobile && void 0
                    );
                }
            }),
                (e.U8 = function (t) {
                    if ("mousemove" !== t.type || !ZC.TOUCHEVENTS) {
                        var n, a;
                        if (
                            (ZC.mobile || t.preventDefault(),
                            (ZC.move = !0),
                            e.C ||
                                ((ZC.move = !1),
                                (e.IM = !1),
                                ZC.A5(document.body).unbind("mousemove touchmove", e.U8),
                                ZC.A5(document.body).unbind("mouseup touchend", e.TI),
                                (document.body.style.cursor = "auto"),
                                ZC.Q.ET([i + "-zoom", i + "-from", i + "-to"])),
                            e.IM)
                        ) {
                            e.C.A.A7.hide();
                            var l = ZC.Q.MD(t),
                                o = ZC._tx_(e.H.L),
                                r = ZC.A5("#" + i + "-top").offset(),
                                s = (l[0] - r.left) / o[0],
                                A = (l[1] - r.top) / o[1];
                            t.ctrlKey;
                            var C = e.A8.DF ? e.A8.AB : 0;
                            if (((e.LD = e.A8.CK ? A : s), (e.LF = e.AK.CK ? s : A), !e.ZL)) {
                                var c,
                                    u,
                                    p,
                                    Z,
                                    h = e.C.P;
                                (n = e.A8.AW ? e.A8.BR : e.A8.A9),
                                    (a = e.A8.AW ? e.A8.A9 : e.A8.BR),
                                    e.A8.GN
                                        ? e.A8.CK
                                            ? (e.A8.Y7 && ((e.I9 = e.A8.iY + n + e.A8.AB * ZC._i_((e.I9 - e.A8.iY - n - C / 2) / e.A8.AB)), (e.LD = e.A8.iY + n + C + e.A8.AB * ZC._i_((e.LD - e.A8.iY - n - C / 2) / e.A8.AB))),
                                              (e.I9 = ZC._l_(e.I9, h.iY + a, h.iY + h.F - n)),
                                              (e.LD = ZC._l_(e.LD, h.iY + a, h.iY + h.F - n)))
                                            : (e.A8.Y7 && ((e.I9 = e.A8.iX + n + e.A8.AB * ZC._i_((e.I9 - e.A8.iX - n - C / 2) / e.A8.AB)), (e.LD = e.A8.iX + n + C + e.A8.AB * ZC._i_((e.LD - e.A8.iX - n - C / 2) / e.A8.AB))),
                                              (e.I9 = ZC._l_(e.I9, h.iX + n, h.iX + h.I - a)),
                                              (e.LD = ZC._l_(e.LD, h.iX + n, h.iX + h.I - a)))
                                        : ((e.I9 = e.A8.CK ? h.iY + a : h.iX + n), (e.LD = e.A8.CK ? h.iY + h.F - n : h.iX + h.I - a)),
                                    (n = e.AK.AW ? e.AK.A9 : e.AK.BR),
                                    (a = e.AK.AW ? e.AK.BR : e.AK.A9),
                                    e.AK.GN
                                        ? e.AK.CK
                                            ? (e.AK.Y7 && ((e.I8 = e.AK.iX + n + e.AK.AB * ZC._i_((e.I8 - e.AK.iX - n) / e.AK.AB)), (e.LF = e.AK.iX + n + e.AK.AB * ZC._i_((e.LF - e.AK.iX - n) / e.AK.AB))),
                                              (e.I8 = ZC._l_(e.I8, h.iX + a, h.iX + h.I - n)),
                                              (e.LF = ZC._l_(e.LF, h.iX + a, h.iX + h.I - n)))
                                            : (e.AK.Y7 && ((e.I8 = e.AK.iY + n + e.AK.AB * ZC._i_((e.I8 - e.AK.iY - n) / e.AK.AB)), (e.LF = e.AK.iY + n + e.AK.AB * ZC._i_((e.LF - e.AK.iY - n) / e.AK.AB))),
                                              (e.I8 = ZC._l_(e.I8, h.iY + n, h.iY + h.F - a)),
                                              (e.LF = ZC._l_(e.LF, h.iY + n, h.iY + h.F - a)))
                                        : ((e.I8 = e.AK.CK ? h.iX + a : h.iY + n), (e.LF = e.AK.CK ? h.iX + h.I - n : h.iY + h.F - a));
                                var d = ZC.A5.browser.msie ? 0 : 2 * e.AU;
                                e.C.AJ["3d"] && (d = 0);
                                var f = ZC.AL(i + "-zoom");
                                if (
                                    (e.A8.CK && e.AK.CK
                                        ? ((c = ZC._a_(e.LF - e.I8 - d)), (u = ZC._a_(e.LD - e.I9 - d)), (p = ZC.CY(e.I8, e.LF)), (Z = ZC.CY(e.I9, e.LD)))
                                        : ((c = ZC._a_(e.LD - e.I9 - d)), (u = ZC._a_(e.LF - e.I8 - d)), (p = ZC.CY(e.I9, e.LD)), (Z = ZC.CY(e.I8, e.LF))),
                                    e.C.AJ["3d"])
                                ) {
                                    e.C.NW();
                                    var _ = ZC.AL(e.H.L + "-guide-c");
                                    _ && (ZC.Q.IV(_, e.H.AC, e.C.iX, e.C.iY, e.C.I, e.C.F), ZC.A5(".zc-guide-label").remove()),
                                        ((f = new ZC.DU(e)).Z = _),
                                        (f.A0 = f.AE = e.A0),
                                        (f.BX = e.BX),
                                        (f.AU = e.AU),
                                        (f.C6 = e.C6),
                                        (f.E = [
                                            [p, Z],
                                            [p + c, Z],
                                            [p + c, Z + u],
                                            [p, Z + u],
                                            [p, Z],
                                        ]);
                                    for (var g = 0; g < f.E.length; g++) {
                                        var v = new ZC.CF(e.C, f.E[g][0] - ZC.AO.E4, f.E[g][1] - ZC.AO.E5, 0);
                                        (f.E[g][0] = v.ED[0]), (f.E[g][1] = v.ED[1]);
                                    }
                                    f.parse(), f.paint();
                                } else ZC.Q.PI(f, { width: c + "px", height: u + "px", left: p + "px", top: Z + "px" });
                                if (e.M.AN) {
                                    var b = ZC.CY(e.I9, e.LD),
                                        B = ZC.BQ(e.I9, e.LD),
                                        m = ZC.CY(e.I8, e.LF),
                                        D = ZC.BQ(e.I8, e.LF),
                                        E = ZC.AL(i + "-from"),
                                        L = ZC.AL(i + "-to"),
                                        F = { decimals: null === ZC._n_(e.AK.DP) ? 1 : e.AK.DP };
                                    (E.innerHTML = e.A8.FQ(e.A8.OG(b)) + "/" + e.AK.FQ(-1, e.AK.NE(m), F)),
                                        (L.innerHTML = e.A8.FQ(e.A8.OG(B)) + "/" + e.AK.FQ(-1, e.AK.NE(D), F)),
                                        ZC.Q.PI(E, { left: p - e.AU - ZC._i_(ZC.A5(E).width()) + "px", top: Z - e.AU - ZC._i_(ZC.A5(E).height()) + "px" }),
                                        ZC.Q.PI(L, { left: p + e.AU + e.M.AU + c + "px", top: Z + e.AU + e.M.AU + u + "px" });
                                }
                            }
                        }
                        return !1;
                    }
                }),
                (e.TI = function (t) {
                    if ((!t || "mouseup" !== t.type || !ZC.TOUCHEVENTS) && e.C) {
                        if (((ZC.move = !1), (e.IM = !1), (document.body.style.cursor = "auto"), ZC.Q.ET([i + "-zoom", i + "-from", i + "-to"]), e.C.AJ["3d"])) {
                            e.C.NW();
                            var n = ZC.AL(e.H.L + "-guide-c");
                            n && (ZC.Q.IV(n, e.H.AC, e.C.iX, e.C.iY, e.C.I, e.C.F), ZC.A5(".zc-guide-label").remove());
                        }
                        if ((ZC.A5(document.body).unbind("mousemove touchmove", e.U8), ZC.A5(document.body).unbind("mouseup touchend", e.TI), e.ZL)) e.ZL = !1;
                        else {
                            var a,
                                l,
                                o,
                                r,
                                s,
                                A,
                                C,
                                c,
                                u,
                                p,
                                Z = { graphid: e.C.L, ev: t };
                            if (ZC._a_(e.I9 - e.LD) > 10 && ZC._a_(e.I8 - e.LF) > 10) {
                                var h,
                                    d,
                                    f = !1,
                                    _ = !1;
                                for (r = 0, s = (o = e.C.BW("k")).length; r < s; r++)
                                    (h = o[r]) &&
                                        o[r].GN &&
                                        ((p = h.DF ? h.AB : 0),
                                        (A = 1 === h.K ? "" : "-" + h.K),
                                        (a = h.OG(ZC.CY(e.I9, e.LD) + p / 2)),
                                        (l = h.OG(ZC.BQ(e.I9, e.LD) - p / 2)),
                                        ZC._a_(l - a) >= 1 &&
                                            ((Z["zoomx" + A] = !0),
                                            (Z["xmin" + A] = ZC.CY(a, l)),
                                            (Z["xmax" + A] = ZC.BQ(a, l)),
                                            "log" === h.BS && ((Z["kmin" + A] = h.V[ZC._i_(ZC.FV(Z["xmin" + A], h.DW))]), (Z["kmax" + A] = h.V[ZC._i_(ZC.FV(Z["xmax" + A], h.DW))]), delete Z["xmin" + A], delete Z["xmax" + A]),
                                            (f = !0)));
                                for (r = 0, s = (o = e.C.BW("v")).length; r < s; r++)
                                    (d = o[r]) &&
                                        o[r].GN &&
                                        ((A = 1 === d.K ? "" : "-" + d.K),
                                        (C = d.NE(ZC.BQ(e.I8, e.LF))),
                                        (c = d.NE(ZC.CY(e.I8, e.LF))),
                                        (u = (d.GU - d.FR) / Math.pow(10, 10)),
                                        ZC._a_(c - C) >= u && ((Z["zoomy" + A] = !0), (Z["ymin" + A] = ZC.CY(C, c)), (Z["ymax" + A] = ZC.BQ(C, c)), (_ = !0)));
                                f || _ ? ((zingchart.SKIP.EVENT = !0), e.C.A.PY(Z)) : (zingchart.SKIP.EVENT = !0);
                            } else (ZC._a_(e.I9 - e.LD) > 5 || ZC._a_(e.I8 - e.LF) > 5) && (zingchart.SKIP.EVENT = !0);
                            e.C = null;
                        }
                    }
                }),
                (ZC.mobile && "normal" !== zingchart.TOUCHZOOM) ||
                    (zingchart.DEV.SKIPTRACKERS ? ZC.A5(document.body).bind("mousedown touchstart", e.R2) : ZC.A5("#" + i + "-img").bind("mousedown touchstart", e.R2), ZC.A5(".zc-node-area").live("mousedown touchstart", e.R2));
        },
    };
    ZC.A4X = ZC.HN.CC(A4X);
    var A28 = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.I4 = !0),
                (i.ABU = !1),
                (i.C = e),
                (i.H = e.A),
                (i.IM = !1),
                (i.A3F = !1),
                (i.H7 = null),
                (i.AR = null),
                (i.Z = null),
                (i.IH = 0),
                (i.H6 = 0),
                (i.PA = 0),
                (i.A0E = 0),
                (i.LL = !1),
                (i.NJ = null),
                (i.bBind = !1),
                (i.BY = null),
                (i.A1W = !1);
        },
        parse: function () {
            var e,
                i = this;
            (i.L = i.C.L + "-preview"),
                i.assign_a([
                    ["live", "ABU", "b"],
                    ["async", "LL", "b"],
                    ["min-distance", "PA", "i"],
                    ["min-distance-x", "PA", "i"],
                    ["min-distance-y", "PA", "i"],
                    ["visible", "AN", "b"],
                ]);
            var t = "(" + i.C.AF + ").preview",
                n = i.H.B8;
            function a(e) {
                return [t + ".handler", t + ".handler-" + e, t + ".handle", t + ".handle-" + e];
            }
            (i.AR = new ZC.HN(i.C)),
                (i.AR.L = i.C.L + "-preview-viewport"),
                n.load(i.AR.o, [t]),
                i.AR.append(i.o),
                i.AR.parse(),
                i.o.label && (i.BY = []),
                i.o.handle && i.o.handle.label && ((i.J6 = new ZC.DN(i.C)), i.J6.append(i.o.handle.label), i.J6.append({ text: " " }), i.J6.parse(), i.J6.AN && (i.A1W = !0)),
                (i.OR = new ZC.D0(i.C)),
                n.load(i.OR.o, [t + ".mask"]),
                null !== ZC._n_((e = i.o.mask)) && i.OR.append(e),
                i.OR.parse(),
                (i.UK = new ZC.D0(i.C)),
                n.load(i.UK.o, [t + ".active"]),
                null !== ZC._n_((e = i.o.active)) && i.UK.append(e),
                i.UK.parse(),
                (i.IQ = new ZC.HN(i.AR)),
                (i.HG = new ZC.HN(i.AR)),
                (i.J8 = new ZC.HN(i.AR)),
                (i.H4 = new ZC.HN(i.AR)),
                n.load(i.IQ.o, a("left")),
                n.load(i.HG.o, a("right")),
                n.load(i.J8.o, a("top")),
                n.load(i.H4.o, a("bottom"));
            for (var l = ["handle", "handler"], o = 0; o < l.length; o++)
                null !== ZC._n_((e = i.o[l[o]])) && (i.IQ.append(e), i.HG.append(e), i.J8.append(e), i.H4.append(e)),
                    null !== ZC._n_((e = i.o[l[o] + "-left"])) && i.IQ.append(e),
                    null !== ZC._n_((e = i.o[l[o] + "-right"])) && i.HG.append(e),
                    null !== ZC._n_((e = i.o[l[o] + "-top"])) && i.J8.append(e),
                    null !== ZC._n_((e = i.o[l[o] + "-bottom"])) && i.H4.append(e);
            i.IQ.parse(), i.HG.parse(), i.J8.parse(), i.H4.parse();
        },
        setScalesInfo: function () {
            var e = this;
            e.NJ = {};
            for (var i, t = e.C.BO, n = 0, a = t.length; n < a; n++)
                (i = t[n]) && ("k" === i.AF ? (e.NJ[i.BF] = { minindex: i.DA, maxindex: i.DY, minvalue: i.V[i.DA], maxvalue: i.V[i.DY], stepsize: i.AB, values: [].concat(i.V) }) : (e.NJ[i.BF] = { minvalue: i.FR, maxvalue: i.GU }));
        },
        toggleMasks: function (e, i) {
            for (var t = this, n = ["x-left", "x-right", "y-top", "y-bottom"], a = 0; a < n.length; a++)
                if (e) {
                    var l = new ZC.HN(t.C);
                    switch (((l.L = t.C.L + "-preview-mask-" + n[a]), (l.A0 = l.AE = t.OR.A0), (l.C6 = t.OR.C6), (l.Z = l.C7 = i || ZC.AL(t.C.L + "-preview-c")), n[a])) {
                        case "x-left":
                            (l.iX = t.AR.iX), (l.iY = t.AR.iY), (l.I = ZC.A5(t.A3S).css("width")), (l.F = t.AR.F);
                            break;
                        case "x-right":
                            (l.iX = t.AR.iX + t.AR.I - ZC.A5(t.XJ).css("width")), (l.iY = t.AR.iY), (l.I = ZC.A5(t.XJ).css("width")), (l.F = t.AR.F);
                            break;
                        case "y-top":
                            (l.iX = t.AR.iX), (l.iY = t.AR.iY), (l.I = t.AR.I), (l.F = ZC.A5(t.A4G).css("height"));
                            break;
                        case "y-bottom":
                            (l.iX = t.AR.iX), (l.iY = t.AR.iY + t.AR.F - ZC.A5(t.W3).css("height")), (l.I = t.AR.I), (l.F = ZC.A5(t.W3).css("height"));
                    }
                    l.paint();
                } else ZC.Q.ET(t.C.L + "-preview-mask-" + n[a] + "-path");
        },
        paint: function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o,
                r,
                s,
                A = this;
            if (((A.PR = ZC.mobile ? 40 : ZC.ie67 ? 0 : 20), A.AN)) {
                (A.Z = A.AR.Z = A.AR.C7 = ZC.AL(A.C.L + "-preview-c")), A.AR.paint();
                var C = ZC.AL(A.H.L + "-top"),
                    c = A.C.BW("k")[0],
                    u = A.C.BW("v")[0];
                if (
                    (null === A.NJ && A.setScalesInfo(),
                    "svg" !== A.H.AC ? (e = ZC.AL(A.C.L + "-preview")) && ZC.Q.PI(e, { clip: A.C.M5(0, "canvas", A.AR) }) : (e = ZC.AL(A.C.L + "-clip-preview-shape")) && ZC.Q.G4(e, { points: A.C.M5(0, "svg", A.AR) }),
                    0 === A.PA && c && ((A.PA = ZC.BQ(1, ZC._i_((2 * A.AR.I) / c.V.length))), "log" === c.BS && (A.PA = ZC.BQ(1, ZC._i_(A.PA / c.DW)))),
                    A.BY)
                ) {
                    var p = ZC.ie67 ? ZC.AL(A.H.L) : null;
                    ZC.A5("." + A.C.L + "-preview-item", p).remove();
                    for (var Z = [], h = 0; h < A.BY.length; h++) {
                        var d = (A.BY[h].x - c.iX) / c.I,
                            f = ZC._i_(A.AR.iX + d * A.AR.I),
                            _ = new ZC.DN(A.C);
                        if (
                            (_.append({ "line-width": 1, "line-color": "#999", text: A.BY[h].text, x: f, y: A.AR.iY }),
                            _.append(A.o.label),
                            _.parse(),
                            (_.Z = A.Z),
                            (_.IL = A.H.usc() ? ZC.AL(A.H.L + "-main") : ZC.AL(A.H.L + "-text")),
                            (_.GL = A.L + "-item " + A.C.L + "-preview-item zc-preview-item"),
                            (_.L = A.L + "-item-" + h),
                            _.iX >= A.AR.iX && _.iX + _.I <= A.AR.iX + A.AR.I)
                        ) {
                            for (var g = !1, v = 0; v < Z.length; v++) _.iX > Z[v].x && _.iX < Z[v].x + Z[v].width && (g = !0);
                            !g && _.AN && (_.paint(), Z.push({ x: _.iX, width: _.I }));
                            var b = [
                                [f, A.AR.iY],
                                [f, A.AR.iY + A.AR.F],
                            ];
                            (n = ZC.Q.EB(A.Z, A.H.AC)), ZC.CS.paint(n, _, b);
                        }
                    }
                }
                if (
                    ((c.GN || u.GN) &&
                        (A.KH = ZC.Q.I2({
                            cls: "zc-abs zc-preview-handler zc-preview-handler-middle " + A.C.L + "-preview-handler",
                            id: A.L + "-handler-middle",
                            wh: A.AR.I + "/" + A.AR.F,
                            tl: A.AR.iY + "/" + A.AR.iX,
                            background: A.UK.A0,
                            opacity: A.UK.C6,
                            cursor: "pointer",
                            p: C,
                        })),
                    (!c.CK && c.GN) || (u.CK && u.GN))
                ) {
                    (A.A3S = ZC.Q.I2({ cls: "zc-abs zc-preview-mask zc-preview-mask-left " + A.C.L + "-preview-mask", id: A.L + "-mask-x-left", wh: "0/" + A.AR.F, tl: A.AR.iY + "/" + A.AR.iX, background: A.OR.A0, opacity: A.OR.C6, p: C })),
                        (A.XJ = ZC.Q.I2({
                            cls: "zc-abs zc-preview-mask zc-preview-mask-right " + A.C.L + "-preview-mask",
                            id: A.L + "-mask-x-right",
                            wh: "0/" + A.AR.F,
                            tl: A.AR.iY + "/" + (A.AR.iX + A.AR.I),
                            background: A.OR.A0,
                            opacity: A.OR.C6,
                            p: C,
                        })),
                        (i = A.IQ.I),
                        (t = A.IQ.F),
                        (A.KJ = ZC.Q.I2({
                            cls: "zc-abs zc-preview-handler zc-preview-handler-left " + A.C.L + "-preview-handler",
                            id: A.L + "-handler-x-left",
                            wh: ZC.quirks ? null : i + "/" + t,
                            tl: ZC._i_(A.AR.iY + (A.AR.F - t) / 4 - A.PR / 2) + "/" + ZC._i_(A.AR.iX - i / 2 - A.PR / 2),
                            lineHeight: "10%",
                            cursor: "pointer",
                            p: C,
                            border: A.PR / 2 + "px solid transparent",
                        }));
                    var B = A.KJ;
                    if ("svg" === A.H.AC && !ZC.AL(A.L + "-handler-x-left-svg")) {
                        var m = ZC.Q.F6("svg", "http://www.w3.org/2000/svg");
                        ZC.Q.G4(m, { version: "1.1", id: A.L + "-handler-x-left-svg", width: i, height: t }), A.KJ.appendChild(m), (B = m);
                    }
                    if (!ZC.AL(A.L + "-handler-x-left-c")) {
                        var D = ZC.Q.HE({ cls: "zc-no-print", id: A.L + "-handler-x-left-c", wh: i + "/" + t, p: B }, A.H.AC);
                        (A.IQ.Z = D), (A.IQ.L = A.L + "-handler-x-left-c-preview"), (A.IQ.iX = 0), (A.IQ.iY = 0), A.IQ.paint(), (n = ZC.Q.EB(A.H.usc() ? A.H.L + "-main-c" : A.L + "-handler-x-left-c", A.H.AC));
                        var E = A.IQ.B0,
                            L = A.IQ.AU;
                        (r = ZC._i_(i / 2 - E)), (o = ZC._i_(i / 2 + E)), (s = [[r, (l = L + 3)], [r, (a = t - L - 2)], null, [o, l], [o, a]]), (A.IQ.CZ = !0), ZC.CS.paint(n, A.IQ, s);
                    }
                    (i = A.HG.I),
                        (t = A.HG.F),
                        (A.JX = ZC.Q.I2({
                            cls: "zc-abs zc-preview-handler zc-preview-handler-right " + A.C.L + "-preview-handler",
                            id: A.L + "-handler-x-right",
                            wh: ZC.quirks ? null : i + "/" + t,
                            tl: ZC._i_(A.AR.iY + A.AR.F - A.HG.F - (A.AR.F - t) / 4 - A.PR / 2) + "/" + ZC._i_(A.AR.iX + A.AR.I - A.HG.I / 2 - A.PR / 2),
                            lineHeight: "10%",
                            cursor: "pointer",
                            p: C,
                            border: A.PR / 2 + "px solid transparent",
                        }));
                    var F = A.JX;
                    if ("svg" === A.H.AC && !ZC.AL(A.L + "-handler-x-right-svg")) {
                        var I = ZC.Q.F6("svg", "http://www.w3.org/2000/svg");
                        ZC.Q.G4(I, { version: "1.1", id: A.L + "-handler-x-right-svg", width: i, height: t }), A.JX.appendChild(I), (F = I);
                    }
                    if (!ZC.AL(A.L + "-handler-x-right-c")) {
                        var x = ZC.Q.HE({ cls: "zc-no-print", id: A.L + "-handler-x-right-c", wh: i + "/" + t, p: F }, A.H.AC);
                        (A.HG.Z = x), (A.HG.L = A.L + "-handler-x-right-c-preview"), (A.HG.iX = 0), (A.HG.iY = 0), A.HG.paint(), (n = ZC.Q.EB(A.H.usc() ? A.H.L + "-main-c" : A.L + "-handler-x-right-c", A.H.AC));
                        var y = A.HG.B0,
                            w = A.HG.AU;
                        (r = ZC._i_(i / 2 - y)), (o = ZC._i_(i / 2 + y)), (s = [[r, (l = w + 3)], [r, (a = t - w - 2)], null, [o, l], [o, a]]), (A.HG.CZ = !0), ZC.CS.paint(n, A.HG, s);
                    }
                }
                if ((!u.CK && u.GN) || (c.CK && c.GN)) {
                    (A.A4G = ZC.Q.I2({ cls: "zc-abs zc-preview-mask zc-preview-mask-top " + A.C.L + "-preview-mask", id: A.L + "-mask-x-top", wh: A.AR.I + "/0", tl: A.AR.iY + "/" + A.AR.iX, background: A.OR.A0, opacity: A.OR.C6, p: C })),
                        (A.W3 = ZC.Q.I2({
                            cls: "zc-abs zc-preview-mask zc-preview-mask-bottom " + A.C.L + "-preview-mask",
                            id: A.L + "-mask-x-bottom",
                            wh: A.AR.I + "/0",
                            tl: A.AR.iY + A.AR.F + "/" + A.AR.iX,
                            background: A.OR.A0,
                            opacity: A.OR.C6,
                            p: C,
                        })),
                        (i = A.J8.I),
                        (t = A.J8.F),
                        (A.L3 = ZC.Q.I2({
                            cls: "zc-abs zc-preview-handler zc-preview-handler-top " + A.C.L + "-preview-handler",
                            id: A.L + "-handler-y-top",
                            wh: ZC.quirks ? null : i + "/" + t,
                            tl: ZC._i_(A.AR.iY - t / 2 - A.PR / 2) + "/" + ZC._i_(A.AR.iX + (A.AR.I - i) / 4 - A.PR / 2),
                            lineHeight: "10%",
                            cursor: "pointer",
                            p: C,
                            border: A.PR / 2 + "px solid transparent",
                        }));
                    var Y = A.L3;
                    if ("svg" === A.H.AC && !ZC.AL(A.L + "-handler-y-top-svg")) {
                        var X = ZC.Q.F6("svg", "http://www.w3.org/2000/svg");
                        ZC.Q.G4(X, { version: "1.1", id: A.L + "-handler-y-top-svg", width: i, height: t }), A.L3.appendChild(X), (Y = X);
                    }
                    if (!ZC.AL(A.L + "-handler-y-top-c")) {
                        var M = ZC.Q.HE({ cls: "zc-no-print", id: A.L + "-handler-y-top-c", wh: i + "/" + t, p: Y }, A.H.AC);
                        (A.J8.Z = M), (A.J8.L = A.L + "-handler-y-top-c-preview"), (A.J8.iX = 0), (A.J8.iY = 0), A.J8.paint(), (n = ZC.Q.EB(A.H.usc() ? A.H.L + "-main-c" : A.L + "-handler-y-top-c", A.H.AC));
                        var K = A.J8.B0,
                            S = A.J8.AU;
                        (a = ZC._i_(t / 2 - K)), (s = [[(r = i - S - 2), (l = ZC._i_(t / 2 + K))], [(o = S + 3), l], null, [r, a], [o, a]]), (A.J8.CZ = !0), ZC.CS.paint(n, A.J8, s);
                    }
                    (i = A.H4.I),
                        (t = A.H4.F),
                        (A.JG = ZC.Q.I2({
                            cls: "zc-abs zc-preview-handler zc-preview-handler-bottom " + A.C.L + "-preview-handler",
                            id: A.L + "-handler-y-bottom",
                            wh: ZC.quirks ? null : i + "/" + t,
                            tl: ZC._i_(A.AR.iY + A.AR.F - A.H4.F / 2 - A.PR / 2) + "/" + ZC._i_(A.AR.iX + A.AR.I - A.H4.I - (A.AR.I - i) / 4 - A.PR / 2),
                            lineHeight: "10%",
                            cursor: "pointer",
                            p: C,
                            border: A.PR / 2 + "px solid transparent",
                        }));
                    var P = A.JG;
                    if ("svg" === A.H.AC && !ZC.AL(A.L + "-handler-y-bottom-svg")) {
                        var H = ZC.Q.F6("svg", "http://www.w3.org/2000/svg");
                        ZC.Q.G4(H, { version: "1.1", id: A.L + "-handler-y-bottom-svg", width: i, height: t }), A.JG.appendChild(H), (P = H);
                    }
                    if (!ZC.AL(A.L + "-handler-y-bottom-c")) {
                        var N = ZC.Q.HE({ cls: "zc-no-print", id: A.L + "-handler-y-bottom-c", wh: i + "/" + t, p: P }, A.H.AC);
                        (A.H4.Z = N), (A.H4.L = A.L + "-handler-y-bottom-c-preview"), (A.H4.iX = 0), (A.H4.iY = 0), A.H4.paint(), (n = ZC.Q.EB(A.H.usc() ? A.H.L + "-main-c" : A.L + "-handler-y-bottom-c", A.H.AC));
                        var G = A.H4.B0,
                            O = A.H4.AU;
                        (a = ZC._i_(t / 2 - G)), (s = [[(r = i - O - 2), (l = ZC._i_(t / 2 + G))], [(o = O + 3), l], null, [r, a], [o, a]]), (A.H4.CZ = !0), ZC.CS.paint(n, A.H4, s);
                    }
                }
                if (((A.IH = 0), (A.H6 = A.AR.I), (A.KT = 0), (A.HA = A.AR.F), c.GN && A.A1W)) {
                    var k = c.W,
                        T = c.A1;
                    c.F7 && "date" === c.F7.o.type && ((k = c.FQ(c.W, null, null).replace(/<br>/g, " ")), (T = c.FQ(c.A1, null, null).replace(/<br>/g, " "))),
                        (A.R5 = ZC.Q.I2({
                            cls: "zc-abs zc-preview-label " + A.C.L + "-preview-label",
                            id: A.L + "-min-label",
                            background: A.J6.A0,
                            opacity: A.J6.C6,
                            fontFamily: A.J6.GH,
                            fontSize: A.J6.DJ,
                            fontWeight: A.J6.sFontWeight,
                            color: A.J6.C2,
                            padding: 0,
                            html: k + "",
                            p: C,
                        })),
                        (A.R5.style.left = A.AR.iX + "px"),
                        (A.R5.style.top = A.AR.iY + A.AR.F + "px"),
                        (A.R8 = ZC.Q.I2({
                            cls: "zc-abs zc-preview-label " + A.C.L + "-preview-label",
                            id: A.L + "-max-label",
                            background: A.J6.A0,
                            opacity: A.J6.C6,
                            fontFamily: A.J6.GH,
                            fontSize: A.J6.DJ,
                            fontWeight: A.J6.sFontWeight,
                            color: A.J6.C2,
                            padding: 0,
                            html: T + "",
                            p: C,
                        })),
                        (A.R8.style.left = A.AR.iX + A.AR.I + "px"),
                        (A.R8.style.top = A.AR.iY + A.AR.F + "px"),
                        A.IH > ZC.A5(A.R5).width() ? (A.R5.style.left = A.AR.iX + A.IH - ZC.A5(A.R5).width() + "px") : (A.R5.style.left = A.AR.iX + "px"),
                        A.AR.I - A.H6 > ZC.A5(A.R8).width() ? (A.R8.style.left = A.AR.iX + A.H6 + "px") : (A.R8.style.left = A.AR.iX + A.H6 - ZC.A5(A.R8).width() + "px");
                }
                A.bind(), A.BY && (A.BY = []);
            }
        },
        reset: function () {
            var e = this,
                i = e.C.BW("k")[0],
                t = e.C.BW("v", !0)[0];
            t || (t = e.C.BW("v")[0]), i && t && e.update(i.DA, i.DY, t.FR, t.GU, !0);
        },
        update: function (e, i, t, n, a) {
            null === ZC._n_(a) && (a = !1);
            var l = this;
            if ((a || (e >= i && (e = i - 1), t >= n && (t = n - 1)), l.AN)) {
                var o = l.C.BW("k")[0],
                    r = l.C.BW("v", !0)[0];
                r || (r = l.C.BW("v")[0]);
                var s = !0;
                if (a) {
                    if (o && r) {
                        if (o.CK && r.CK) {
                            var A = e,
                                C = i;
                            (e = t), (i = n), (t = A), (n = C);
                        }
                        o.CK ? (null === ZC._n_(n) && (n = o.A1), null === ZC._n_(t) && (t = o.W)) : (null === ZC._n_(e) && (e = o.W), null === ZC._n_(i) && (i = o.A1)),
                            r.CK
                                ? (null === ZC._n_(e) && (e = r.aAutoFit[0] ? r.FR : r.AY), null === ZC._n_(i) && (i = r.aAutoFit[1] ? r.GU : r.BD))
                                : (null === ZC._n_(t) && (t = r.aAutoFit[0] ? r.FR : r.AY), null === ZC._n_(n) && (n = r.aAutoFit[1] ? r.GU : r.BD));
                        var c = o.DF ? 1 : 0;
                        o.CK || r.CK
                            ? o.AW
                                ? l.update(((e - r.FR) * l.AR.I) / (r.GU - r.FR), ((i - r.FR) * l.AR.I) / (r.GU - r.FR), ((t - o.DA) * l.AR.F) / (o.DY - o.DA), ((n - o.DA) * l.AR.F) / (o.DY - o.DA))
                                : l.update(((e - r.FR) * l.AR.I) / (r.GU - r.FR), ((i - r.FR) * l.AR.I) / (r.GU - r.FR), l.AR.F - ((n - o.DA) * l.AR.F) / (o.DY - o.DA), l.AR.F - ((t - o.DA) * l.AR.F) / (o.DY - o.DA))
                            : o.AW
                            ? l.update(
                                  l.AR.I - ((i - o.DA + c) * l.AR.I) / (o.DY - o.DA + c),
                                  l.AR.I - ((e - o.DA) * l.AR.I) / (o.DY - o.DA + c),
                                  l.AR.F - ((n - r.FR) * l.AR.F) / (r.GU - r.FR),
                                  l.AR.F - ((t - r.FR) * l.AR.F) / (r.GU - r.FR)
                              )
                            : l.update(((e - o.DA) * l.AR.I) / (o.DY - o.DA + c), ((i - o.DA + c) * l.AR.I) / (o.DY - o.DA + c), l.AR.F - ((n - r.FR) * l.AR.F) / (r.GU - r.FR), l.AR.F - ((t - r.FR) * l.AR.F) / (r.GU - r.FR));
                    }
                } else if (
                    (i - e < l.PA && (l.H7 === l.JX ? (i = e + l.PA) : l.H7 === l.KJ && (e = i - l.PA)),
                    n - t < l.A0E && (l.H7 === l.JG ? (n = t + l.A0E) : l.H7 === l.L3 && (t = n - l.A0E)),
                    e > i && (l.H7 === l.KJ ? l.update(i - 1, i, t, n) : l.H7 === l.JX && l.update(e, e + 1, t, n), (s = !1)),
                    e < 0 && (l.H7 === l.KJ ? l.update(0, i, t, n) : l.H7 === l.KH && l.update(0, ZC.A5(l.KH).width(), t, n), (s = !1)),
                    i > l.AR.I && (l.H7 === l.JX ? l.update(e, l.AR.I, t, n) : l.H7 === l.KH && l.update(l.AR.I - ZC.A5(l.KH).width(), l.AR.I, t, n), (s = !1)),
                    t > n && (l.H7 === l.L3 ? l.update(e, i, t - 1, n) : l.H7 === l.JG && l.update(e, i, t, n + 1), (s = !1)),
                    t < 0 && (l.H7 === l.L3 ? l.update(e, i, 0, n) : l.H7 === l.KH && l.update(e, i, 0, ZC.A5(l.KH).height()), (s = !1)),
                    n > l.AR.F && (l.H7 === l.JG ? l.update(e, i, t, l.AR.F) : l.H7 === l.KH && l.update(e, i, l.AR.F - ZC.A5(l.KH).height(), l.AR.F), (s = !1)),
                    s)
                ) {
                    var u;
                    if (o && o.Y7)
                        o.CK
                            ? ((t = (u = l.AR.F / (o.V.length - (o.DF ? 0 : 1))) * Math.round(t / u)), (n = ZC.CY(u * Math.round(n / u), l.AR.F)))
                            : ((e = (u = l.AR.I / (o.V.length - (o.DF ? 0 : 1))) * Math.round(e / u)), (i = ZC.CY(u * Math.round(i / u), l.AR.I)));
                    (l.IH = e),
                        (l.H6 = i),
                        (l.KT = t),
                        (l.HA = n),
                        ((!o.CK && o.GN) || (r.CK && r.GN)) &&
                            ((l.KJ.style.left = ZC._i_(l.AR.iX + l.IH - l.IQ.I / 2 - l.PR / 2) + "px"),
                            (l.A3S.style.width = ZC._i_(l.IH) + "px"),
                            (l.JX.style.left = ZC._i_(l.AR.iX + l.H6 - l.HG.I / 2 - l.PR / 2) + "px"),
                            (l.XJ.style.left = ZC._i_(l.AR.iX + l.H6) + "px"),
                            (l.XJ.style.width = ZC._i_(l.AR.I - l.H6) + "px")),
                        ((!r.CK && r.GN) || (o.CK && o.GN)) &&
                            ((l.L3.style.top = ZC._i_(l.AR.iY + l.KT - l.J8.F / 2 - l.PR / 2) + "px"),
                            (l.A4G.style.height = ZC._i_(l.KT) + "px"),
                            (l.JG.style.top = ZC._i_(l.AR.iY + l.HA - l.H4.F / 2 - l.PR / 2) + "px"),
                            (l.W3.style.top = ZC._i_(l.AR.iY + l.HA) + "px"),
                            (l.W3.style.height = ZC._i_(l.AR.F - l.HA) + "px")),
                        (o.GN || r.GN) &&
                            ((l.KH.style.left = ZC._i_(l.AR.iX + l.IH) + "px"), (l.KH.style.width = ZC._i_(l.H6 - l.IH) + "px"), (l.KH.style.top = ZC._i_(l.AR.iY + l.KT) + "px"), (l.KH.style.height = ZC._i_(l.HA - l.KT) + "px")),
                        l.ABU && l.IM && ((l.C.OC = !0), l.zoom(!0)),
                        o.GN &&
                            l.A1W &&
                            (o.F7 && "date" === o.F7.o.type
                                ? ((l.R5.innerHTML = o.FQ(o.W, null, null).replace(/<br>/g, " ")), (l.R8.innerHTML = o.FQ(o.A1, null, null).replace(/<br>/g, " ")))
                                : ((l.R5.innerHTML = o.W), (l.R8.innerHTML = o.A1)),
                            l.IH > ZC.A5(l.R5).width() ? (l.R5.style.left = l.AR.iX + l.IH - ZC.A5(l.R5).width() + "px") : (l.R5.style.left = l.AR.iX + "px"),
                            l.AR.I - l.H6 > ZC.A5(l.R8).width() ? (l.R8.style.left = l.AR.iX + l.H6 + "px") : (l.R8.style.left = l.AR.iX + l.H6 - ZC.A5(l.R8).width() + "px"));
                }
            }
        },
        zoom: function (e) {
            for (var i, t = this, n = { graphid: t.C.L, preview: 1, async: t.LL, previewscale: !0, zooming: e }, a = t.C.BO, l = t.C.BW("k")[0], o = t.C.BW("v")[0], r = 0, s = a.length; r < s; r++)
                if ((i = a[r])) {
                    var A = 1 === i.K ? "" : "-" + i.K;
                    if ("k" === i.AF) {
                        if (l.GN) {
                            var C = t.LL ? t.NJ[i.BF].minindex : i.DA,
                                c = t.LL ? t.NJ[i.BF].maxindex : i.DY;
                            n["zoomx" + A] = !0;
                            var u = l.DF ? 1 : 0;
                            if (
                                (l.CK
                                    ? ((n["xmin" + A] = ZC._i_(((t.AR.F - t.HA) / t.AR.F) * (c - C))), (n["xmax" + A] = ZC._i_(((t.AR.F - t.KT) / t.AR.F) * (c - C))))
                                    : ((n["xmin" + A] = ZC._i_(t.IH / (t.AR.I / (c - C + u)))), (n["xmax" + A] = ZC._i_(t.H6 / (t.AR.I / (c - C + u)) - u))),
                                l.AW)
                            ) {
                                (n["xmin" + A] = c - n["xmin" + A]), (n["xmax" + A] = c - n["xmax" + A]);
                                var p = n["xmin" + A];
                                (n["xmin" + A] = n["xmax" + A]), (n["xmax" + A] = p);
                            }
                        }
                    } else if (o.GN) {
                        var Z = t.LL ? t.NJ[i.BF].minvalue : i.FR,
                            h = t.LL ? t.NJ[i.BF].maxvalue : i.GU;
                        (n["zoomy" + A] = !0),
                            o.CK
                                ? ((n["ymin" + A] = Z + (t.IH / t.AR.I) * (h - Z)), (n["ymax" + A] = Z + (t.H6 / t.AR.I) * (h - Z)))
                                : ((n["ymin" + A] = Z + ((t.AR.F - t.HA) / t.AR.F) * (h - Z)), (n["ymax" + A] = Z + ((t.AR.F - t.KT) / t.AR.F) * (h - Z)));
                    }
                }
            t.H.PY(n);
        },
        unbind: function () {
            var e = this;
            ZC.A5("." + e.C.L + "-preview-handler").unbind("mousedown touchstart", e.Z3),
                ZC.A5("." + e.C.L + "-preview-mask").unbind("click", e.AEJ),
                ZC.A5(document.body).unbind("mousemove touchmove", e.V3),
                ZC.A5(document.body).unbind("mouseup touchend", e.TO),
                (e.bBind = !1);
        },
        bind: function () {
            var e = this;
            if (!e.bBind) {
                var i = e.H.L,
                    t = 0,
                    n = 0;
                (e.AEJ = function (t) {
                    if ((t.preventDefault(), e.H.H2)) {
                        (e.H.H2.C = e.C), e.H.H2.parse();
                        var n = ZC.Q.MD(t),
                            a = ZC.A5("#" + i + "-top").offset();
                        if (-1 !== t.target.id.indexOf("preview-mask-x-left") || -1 !== t.target.id.indexOf("preview-mask-x-right")) {
                            var l = n[0] - a.left - e.AR.iX,
                                o = e.H6 - e.IH;
                            l - o / 2 < 0 ? ((e.IH = 0), (e.H6 = o)) : l + o / 2 > e.AR.I ? ((e.IH = e.AR.I - o), (e.H6 = e.AR.I)) : ((e.IH = ZC._i_(l - o / 2)), (e.H6 = ZC._i_(l + o / 2)));
                        } else {
                            var r = n[1] - a.top - e.AR.iY,
                                s = e.HA - e.KT;
                            r - s / 2 < 0 ? ((e.KT = 0), (e.HA = s)) : r + s / 2 > e.AR.F ? ((e.KT = e.AR.F - s), (e.HA = e.AR.F)) : ((e.KT = ZC._i_(r - s / 2)), (e.HA = ZC._i_(r + s / 2)));
                        }
                        return (e.IM = !1), (e.C.OC = !1), e.update(e.IH, e.H6, e.KT, e.HA), e.zoom(!1), !1;
                    }
                }),
                    (e.Z3 = function (a) {
                        if ((a.preventDefault(), e.H.H2)) {
                            (e.H.H2.C = e.C), e.H.H2.parse();
                            for (var l = a.target; l && "BODY" !== l.tagName.toUpperCase(); ) {
                                if (-1 !== ZC.Q.T4(l).indexOf("zc-preview-handler")) break;
                                l = l.parentNode;
                            }
                            if ((ZC.mobile || !(a.which > 1)) && l) {
                                var o = ZC.Q.MD(a),
                                    r = ZC._tx_(e.H.L),
                                    s = ZC.A5("#" + i + "-top").offset(),
                                    A = (o[0] - s.left) / r[0] - e.AR.iX,
                                    C = (o[1] - s.top) / r[1] - e.AR.iY;
                                return (
                                    -1 !== l.id.indexOf("handler-x-left")
                                        ? (e.H7 = e.KJ)
                                        : -1 !== l.id.indexOf("handler-x-right")
                                        ? (e.H7 = e.JX)
                                        : -1 !== l.id.indexOf("handler-y-top")
                                        ? (e.H7 = e.L3)
                                        : -1 !== l.id.indexOf("handler-y-bottom")
                                        ? (e.H7 = e.JG)
                                        : -1 !== l.id.indexOf("handler-middle") && ((e.H7 = e.KH), (t = A - e.IH), (n = C - e.KT)),
                                    ZC.A5(document.body).bind("mousemove touchmove", e.V3),
                                    ZC.A5(document.body).bind("mouseup touchend", e.TO),
                                    (e.IM = !0),
                                    (e.A3F = !1),
                                    !1
                                );
                            }
                        }
                    }),
                    (e.V3 = function (a) {
                        if (e.IM) {
                            (e.A3F = !0), zingchart.exec(e.H.L, "setmode", { mode: "static,fast" });
                            var l = ZC._tx_(e.H.L),
                                o = ZC.Q.MD(a),
                                r = ZC.A5("#" + i + "-top").offset(),
                                s = (o[0] - r.left) / l[0] - e.AR.iX,
                                A = (o[1] - r.top) / l[1] - e.AR.iY;
                            e.H7 === e.KJ
                                ? e.update(s, e.H6, e.KT, e.HA)
                                : e.H7 === e.JX
                                ? e.update(e.IH, s, e.KT, e.HA)
                                : e.H7 === e.L3
                                ? e.update(e.IH, e.H6, A, e.HA)
                                : e.H7 === e.JG
                                ? e.update(e.IH, e.H6, e.KT, A)
                                : e.H7 === e.KH && e.update(s - t, s - t + ZC.A5(e.KH).width(), A - n, A - n + ZC.A5(e.KH).height());
                        }
                        return !1;
                    }),
                    (e.TO = function () {
                        return (
                            zingchart.exec(e.H.L, "setmode", { mode: "" }),
                            e.IM && (ZC.A5(document.body).unbind("mousemove touchmove", e.V3), ZC.A5(document.body).unbind("mouseup touchend", e.TO), (e.IM = !1), (e.C.OC = !1), e.A3F && e.zoom(!1), (e.A3F = !1)),
                            !1
                        );
                    }),
                    ZC.A5("." + e.C.L + "-preview-handler").bind("mousedown touchstart", e.Z3),
                    ZC.A5("." + e.C.L + "-preview-mask").bind("click", e.AEJ),
                    (e.bBind = !0);
            }
        },
        gc: function () {
            ZC.AP.gc(this, ["Z", "C7", "o", "I7", "JE", "C", "H", "AR", "UK", "KJ", "JX", "L3", "JG", "KH", "J8", "HG", "H4", "IQ", "oMask", "OR", "A3S", "XJ", "A4G", "W3"]);
        },
    };
    ZC.A28 = ZC.D0.CC(A28);
    var ZH = {
        $i: function (e, i) {
            this.b(e);
            var t = this;
            (t.C = e),
                (t.H = e.A),
                (t.IM = !1),
                (t.Z = null),
                (t.BL = 0),
                (t.BI = 0),
                (t.A7L = ""),
                (t.bYX = "yx" === t.C.AJ.layout),
                (t.AF = t.sTypeE = t.sTypeN = "scroll-" + (i || "x")),
                t.bYX && ((t.AF += "i"), (t.sTypeE = "scroll-xi" === t.AF ? "scroll-y" : "scroll-x"));
        },
        parse: function () {
            var e,
                i = this;
            (i.L = i.C.L + "-" + i.sTypeE),
                i.assign_a([
                    ["offset-x", "BL"],
                    ["offset-y", "BI"],
                ]);
            var t = "(" + i.C.AF + ").",
                n = i.H.B8;
            (i.B1 = new ZC.HN(i.C)),
                n.load(i.B1.o, [t + "scroll.bar", t + i.AF + ".bar"]),
                null !== ZC._n_((e = i.o.bar)) && i.B1.append(e),
                i.B1.parse(),
                (i.B3 = new ZC.HN(i.C)),
                n.load(i.B3.o, [t + "scroll.handle", t + i.AF + ".handle"]),
                null !== ZC._n_((e = i.o.handle)) && i.B3.append(e),
                i.B3.parse();
        },
        paint: function () {
            var e = this,
                i = e.C.BW("k")[0],
                t = e.C.BW("v")[0],
                n = e.C.P;
            if ((("scroll-x" === e.AF || "scroll-xi" === e.AF) && i.DA === i.W && i.DY === i.A1) || (("scroll-y" === e.AF || "scroll-yi" === e.AF) && t.FR === t.AY && t.GU === t.BD))
                return e.unbind(), ZC.A5("#" + e.C.L + "-" + e.AF + "-handle").remove(), ZC.A5("#" + e.C.L + "-" + e.AF + "-bar").remove(), void ZC.Q.IV(e.Z, e.H.AC, e.C.iX, e.C.iY, e.C.I, e.C.F);
            e.Z = ZC.AL(e.C.L + "-" + e.sTypeN + "-c");
            var a = ZC.AL(e.H.L + "-top");
            "scroll-x" === e.AF || "scroll-yi" === e.AF
                ? ((e.B1.iX = n.iX + e.BL),
                  (e.B1.iY = n.iY + n.F + i.B0 - 1 + e.BI),
                  (e.B1.I = n.I),
                  e.bYX
                      ? ((e.B3.I = ZC._i_(ZC.BQ(4, e.B1.I * ((t.BD - t.AY) / (t.GU - t.FR))))),
                        t.FR === t.AY
                            ? t.AW
                                ? (e.B3.iX = e.B1.iX + e.B1.I - e.B3.I)
                                : (e.B3.iX = e.B1.iX)
                            : t.GU === t.BD
                            ? t.AW
                                ? (e.B3.iX = e.B1.iX)
                                : (e.B3.iX = e.B1.iX + e.B1.I - e.B3.I)
                            : t.AW
                            ? (e.B3.iX = ZC._i_(e.B1.iX + e.B1.I - e.B3.I - (e.B1.I * (t.AY - t.FR)) / (t.GU - t.FR)))
                            : (e.B3.iX = ZC._i_(e.B1.iX + (e.B1.I * (t.AY - t.FR)) / (t.GU - t.FR))))
                      : ((e.B3.I = ZC._i_(ZC.BQ(4, e.B1.I * ((i.A1 - i.W) / (i.DY - i.DA))))),
                        i.DA === i.W
                            ? i.AW
                                ? (e.B3.iX = e.B1.iX + e.B1.I - e.B3.I)
                                : (e.B3.iX = e.B1.iX)
                            : i.DY === i.A1
                            ? i.AW
                                ? (e.B3.iX = e.B1.iX)
                                : (e.B3.iX = e.B1.iX + e.B1.I - e.B3.I)
                            : i.AW
                            ? (e.B3.iX = ZC._i_(e.B1.iX + e.B1.I - e.B3.I - (e.B1.I * (i.W - i.DA)) / (i.DY - i.DA)))
                            : (e.B3.iX = ZC._i_(e.B1.iX + (e.B1.I * (i.W - i.DA)) / (i.DY - i.DA)))),
                  ZC.AL(e.L + "-handle")
                      ? (ZC.A5("#" + e.L + "-bar").css("top", e.B1.iY + "px"),
                        ZC.A5("#" + e.L + "-handle")
                            .css("left", e.B3.iX + "px")
                            .css("top", e.B1.iY + "px")
                            .css("width", ZC.BQ(15, e.B3.I) + "px"),
                        e.paint_())
                      : ((e.AAE = ZC.Q.I2({ cls: "zc-abs zc-scroll zc-scroll-x-bar " + e.C.L + "-scroll-x-bar", id: e.L + "-bar", wh: e.B1.I + "/" + e.B1.F, tl: e.B1.iY + "/" + e.B1.iX, opacity: 0, p: a })),
                        (e.ZN = ZC.Q.I2({
                            cls: "zc-abs zc-scroll zc-scroll-x-handle " + e.C.L + "-scroll-x-handle",
                            id: e.L + "-handle",
                            wh: ZC.BQ(15, e.B3.I) + "/" + e.B1.F,
                            tl: e.B1.iY + "/" + (e.B3.iX - 2),
                            background: "#fff",
                            opacity: 0,
                            p: a,
                        })),
                        (e.ZN.style.cursor = "pointer"),
                        e.paint_(),
                        e.IM || e.bind()))
                : ((e.B1.iX = n.iX - e.B1.I - 1 + e.BL),
                  (e.B1.iY = n.iY + e.BI),
                  (e.B1.F = n.F),
                  e.bYX
                      ? ((e.B3.F = ZC._i_(ZC.BQ(4, e.B1.F * ((i.A1 - i.W) / (i.DY - i.DA))))),
                        i.DA === i.W
                            ? i.AW
                                ? (e.B3.iY = e.B1.iY)
                                : (e.B3.iY = e.B1.iY + e.B1.F - e.B3.F)
                            : i.DY === i.A1
                            ? i.AW
                                ? (e.B3.iY = e.B1.iY + e.B1.F - e.B3.F)
                                : (e.B3.iY = e.B1.iY)
                            : i.AW
                            ? (e.B3.iY = ZC._i_(e.B1.iY + (e.B1.F * (i.W - i.DA)) / (i.DY - i.DA)))
                            : (e.B3.iY = ZC._i_(e.B1.iY + e.B1.F - e.B3.F - (e.B1.F * (i.W - i.DA)) / (i.DY - i.DA))))
                      : ((e.B3.F = ZC._i_(ZC.BQ(4, e.B1.F * ((t.BD - t.AY) / (t.GU - t.FR))))),
                        t.FR === t.AY
                            ? t.AW
                                ? (e.B3.iY = e.B1.iY)
                                : (e.B3.iY = e.B1.iY + e.B1.F - e.B3.F)
                            : t.GU === t.BD
                            ? t.AW
                                ? (e.B3.iY = e.B1.iY + e.B1.F - e.B3.F)
                                : (e.B3.iY = e.B1.iY)
                            : t.AW
                            ? (e.B3.iY = ZC._i_(e.B1.iY + (e.B1.F * (t.AY - t.FR)) / (t.GU - t.FR)))
                            : (e.B3.iY = ZC._i_(e.B1.iY + e.B1.F - e.B3.F - (e.B1.F * (t.AY - t.FR)) / (t.GU - t.FR)))),
                  ZC.AL(e.L + "-handle")
                      ? (ZC.A5("#" + e.L + "-bar").css("left", e.B1.iX + "px"),
                        ZC.A5("#" + e.L + "-handle")
                            .css("top", e.B3.iY + "px")
                            .css("left", e.B1.iX + "px")
                            .css("height", ZC.BQ(15, e.B3.F) + "px"),
                        e.paint_())
                      : ((e.AAL = ZC.Q.I2({ cls: "zc-abs zc-scroll zc-scroll-y-bar " + e.C.L + "-scroll-y-bar", id: e.L + "-bar", wh: e.B1.I + "/" + e.B1.F, tl: e.B1.iY + "/" + e.B1.iX, opacity: 0, p: a })),
                        (e.ZO = ZC.Q.I2({
                            cls: "zc-abs zc-scroll zc-scroll-y-handle " + e.C.L + "-scroll-y-handle",
                            id: e.L + "-handle",
                            wh: e.B1.I + "/" + ZC.BQ(15, e.B3.F),
                            tl: e.B3.iY - 2 + "/" + e.B1.iX,
                            background: "#fff",
                            opacity: 0,
                            p: a,
                        })),
                        (e.ZO.style.cursor = "pointer"),
                        e.paint_(),
                        e.IM || e.bind()));
        },
        zoom: function (e) {
            for (var i, t, n, a = this, l = { graphid: a.C.L, zooming: e, scroll: !0 }, o = a.C.BO, r = a.C.BW("k")[0], s = a.C.BW("v")[0], A = 0, C = o.length; A < C; A++)
                if ((i = o[A])) {
                    var c = 1 === i.K ? "" : "-" + i.K;
                    if (r.GN && "scroll-x" === a.AF && "k" === i.AF && !a.bYX) {
                        var u = i.A1 - i.W;
                        (l["zoomx" + c] = !0),
                            (t = (a.B3.iX - a.B1.iX) / a.B1.I),
                            (n = (a.B3.iX - a.B1.iX + a.B3.I) / a.B1.I),
                            r.AW
                                ? ((l["xmin" + c] = i.DY - ZC._i_(n * (i.DY - i.DA))), (l["xmax" + c] = i.DY - ZC._i_(t * (i.DY - i.DA))))
                                : ((l["xmin" + c] = i.DA + ZC._i_(t * (i.DY - i.DA))), (l["xmax" + c] = i.DA + ZC._i_(n * (i.DY - i.DA)))),
                            l["xmax" + c] - l["xmin" + c] !== u && (l["xmax" + c] === i.DY ? (l["xmin" + c] = l["xmax" + c] - u) : (l["xmax" + c] = l["xmin" + c] + u));
                    } else if (s.GN && "scroll-y" === a.AF && "v" === i.AF && !a.bYX)
                        (l["zoomy" + c] = !0),
                            (t = (a.B1.F - (a.B3.iY - a.B1.iY + a.B3.F)) / a.B1.F),
                            (n = (a.B1.F - (a.B3.iY - a.B1.iY)) / a.B1.F),
                            s.AW
                                ? ((l["ymin" + c] = i.GU - ZC._f_(n * (i.GU - i.FR))), (l["ymax" + c] = i.GU - ZC._f_(t * (i.GU - i.FR))))
                                : ((l["ymin" + c] = i.FR + ZC._f_(t * (i.GU - i.FR))), (l["ymax" + c] = i.FR + ZC._f_(n * (i.GU - i.FR))));
                    else if (r.GN && "scroll-xi" === a.AF && "k" === i.AF && a.bYX) {
                        u = i.A1 - i.W;
                        (l["zoomx" + c] = !0),
                            (t = (a.B1.F - a.B3.iY + a.B1.iY - a.B3.F) / a.B1.F),
                            (n = (a.B1.F - a.B3.iY + a.B1.iY) / a.B1.F),
                            r.AW
                                ? ((l["xmin" + c] = i.DY - ZC._i_(n * (i.DY - i.DA))), (l["xmax" + c] = i.DY - ZC._i_(t * (i.DY - i.DA))))
                                : ((l["xmin" + c] = i.DA + ZC._i_(t * (i.DY - i.DA))), (l["xmax" + c] = i.DA + ZC._i_(n * (i.DY - i.DA)))),
                            l["xmax" + c] - l["xmin" + c] !== u && (l["xmax" + c] === i.DY ? (l["xmin" + c] = l["xmax" + c] - u) : (l["xmax" + c] = l["xmin" + c] + u));
                    } else
                        s.GN &&
                            "scroll-yi" === a.AF &&
                            "v" === i.AF &&
                            a.bYX &&
                            ((l["zoomy" + c] = !0),
                            (t = (a.B3.iX - a.B1.iX) / a.B1.I),
                            (n = (a.B3.iX - a.B1.iX + a.B3.I) / a.B1.I),
                            s.AW
                                ? ((l["ymin" + c] = i.GU - ZC._f_(n * (i.GU - i.FR))), (l["ymax" + c] = i.GU - ZC._f_(t * (i.GU - i.FR))))
                                : ((l["ymin" + c] = i.FR + ZC._f_(t * (i.GU - i.FR))), (l["ymax" + c] = i.FR + ZC._f_(n * (i.GU - i.FR)))));
                }
            a.H.PY(l);
        },
        paint_: function () {
            var e,
                i,
                t = this;
            ZC.Q.IV(t.Z, t.H.AC, t.C.iX, t.C.iY, t.C.I, t.C.F),
                "scroll-x" === t.AF || "scroll-yi" === t.AF
                    ? (((e = new ZC.HN(t)).L = t.C.L + "-scroll-x-bar"),
                      e.copy(t.B1),
                      (e.Z = e.C7 = t.Z),
                      (e.iX = t.B1.iX),
                      (e.iY = t.B1.iY),
                      (e.I = t.B1.I),
                      (e.F = t.B1.F),
                      e.paint(),
                      ((i = new ZC.HN(t)).L = t.C.L + "-scroll-x-handle"),
                      i.copy(t.B3),
                      (i.Z = i.C7 = t.Z),
                      (i.iX = t.B3.iX),
                      (i.iY = t.B1.iY + (t.B1.F - t.B3.F) / 2 - 1),
                      (i.I = ZC.BQ(15, t.B3.I)),
                      i.iX + i.I > t.C.P.iX + t.C.P.I && (i.iX = t.C.P.iX + t.C.P.I - i.I),
                      i.iX < t.C.P.iX && (i.iX = t.C.P.iX),
                      (i.F = t.B3.F),
                      i.paint(),
                      ZC.A5("#" + t.L + "-handle").css("left", i.iX + "px"))
                    : (((e = new ZC.HN(t)).L = t.C.L + "-scroll-y-bar"),
                      e.copy(t.B1),
                      (e.Z = e.C7 = t.Z),
                      (e.iX = t.B1.iX),
                      (e.iY = t.B1.iY),
                      (e.I = t.B1.I),
                      (e.F = t.B1.F),
                      e.paint(),
                      ((i = new ZC.HN(t)).L = t.C.L + "-scroll-y-handle"),
                      i.copy(t.B3),
                      (i.Z = i.C7 = t.Z),
                      (i.iX = t.B1.iX + (t.B1.I - t.B3.I) / 2),
                      (i.iY = t.B3.iY),
                      (i.I = t.B3.I),
                      (i.F = ZC.BQ(15, t.B3.F)),
                      i.iY + i.F > t.C.P.iY + t.C.P.F && (i.iY = t.C.P.iY + t.C.P.F - i.F),
                      i.iY < t.C.P.iY && (i.iY = t.C.P.iY),
                      i.paint(),
                      ZC.A5("#" + t.L + "-handle").css("top", i.iY + "px"));
        },
        setScrollingFlag: function (e) {
            var i = this;
            if (((i.C.OC = e), i.C.H2 && ZC._b_(i.C.H2.o.shared))) for (var t = 0; t < i.H.AG.length; t++) i.H.AG[t].H2 && ZC._b_(i.H.AG[t].H2.o.shared) && (i.H.AG[t].OC = e);
        },
        update: function (e) {
            var i = this;
            "scroll-x" === i.AF || "scroll-yi" === i.AF ? ((i.B3.iX = e), ZC.A5("#" + i.L + "-handle").css("left", e + "px"), i.paint_()) : ((i.B3.iY = e), ZC.A5("#" + i.L + "-handle").css("top", e + "px"), i.paint_()),
                i.IM && (i.setScrollingFlag(!0), i.zoom(!0));
        },
        unbind: function () {
            var e = this;
            ZC.A5("." + e.C.L + "-" + e.AF + "-handle").unbind("mousedown touchstart", e.RH), ZC.A5("." + e.C.L + "-" + e.AF + "-bar").unbind("click", e.RC);
        },
        overscroll: function (e) {
            var i = this.C.GY();
            (i.type = e), ZC.AP.C0("overscroll", this.H, i);
        },
        bind: function () {
            var e = this,
                i = e.H.L,
                t = 0,
                n = 0;
            (e.RH = function (a) {
                if ((a.preventDefault(), !(a.button > 1) && ((e.A7L = e.H.KP.join(",")), e.H.KP.push("skip_context_menu", "skip_objects_tracking", "skip_segment_tracking", "skip_marker_tracking", "skip_interactivity"), e.H.H2))) {
                    (e.H.H2.C = e.C), e.H.H2.parse();
                    for (var l = a.target; l && "BODY" !== l.tagName.toUpperCase(); ) {
                        if (-1 !== ZC.Q.T4(l).indexOf("zc-" + e.AF + "-handle")) break;
                        l = l.parentNode;
                    }
                    if ((ZC.mobile || !(a.which > 1)) && l) {
                        var o = ZC.Q.MD(a),
                            r = ZC.A5("#" + i + "-top").offset();
                        if ("scroll-x" === e.AF || "scroll-yi" === e.AF) {
                            var s = o[0] - r.left;
                            t = s - e.B3.iX;
                        } else {
                            var A = o[1] - r.top;
                            n = A - e.B3.iY;
                        }
                        return ZC.A5(document.body).bind("mousemove touchmove", e.RE), ZC.A5(document.body).bind("mouseup touchend", e.M8), (e.IM = !0), !1;
                    }
                }
            }),
                (e.RE = function (a) {
                    if (e.IM) {
                        e.setScrollingFlag(!1);
                        var l = ZC.Q.MD(a),
                            o = ZC.A5("#" + i + "-top").offset();
                        if ("scroll-x" === e.AF || "scroll-yi" === e.AF) {
                            var r = l[0] - o.left;
                            r - t < e.B1.iX && (r < e.B1.iX - 15 && e.overscroll("scroll-x-left"), (r = e.B1.iX + t)),
                                r - t + e.B3.I > e.B1.iX + e.B1.I && (r > e.B1.iX + e.B1.I + 15 && e.overscroll("scroll-x-right"), (r = e.B1.iX + e.B1.I + t - e.B3.I)),
                                e.update(r - t);
                        } else {
                            var s = l[1] - o.top;
                            s - n < e.B1.iY && (s < e.B1.iY - 15 && e.overscroll("scroll-y-top"), (s = e.B1.iY + n)),
                                s - n + e.B3.F > e.B1.iY + e.B1.F && (s > e.B1.iY + e.B1.F + 15 && e.overscroll("scroll-y-bottom"), (s = e.B1.iY + e.B1.F + n - e.B3.F)),
                                e.update(s - n);
                        }
                    }
                    return !1;
                }),
                (e.M8 = function (i) {
                    return (e.H.KP = e.A7L.split(",")), e.IM && (ZC.A5(document.body).unbind("mousemove touchmove", e.RE), ZC.A5(document.body).unbind("mouseup touchend", e.M8), (e.IM = !1), e.setScrollingFlag(!1), i && e.zoom(!1)), !1;
                }),
                (e.RC = function (t) {
                    (e.IM = !1), e.setScrollingFlag(!1);
                    var n = ZC.Q.MD(t),
                        a = ZC.A5("#" + i + "-top").offset();
                    "scroll-x" === e.AF || "scroll-yi" === e.AF
                        ? n[0] - a.left > e.B3.iX
                            ? e.update(ZC.CY(e.B1.iX + e.B1.I - e.B3.I - 2 * e.B3.AU, e.B3.iX + (n[0] - a.left - e.B3.iX) / 4))
                            : e.update(ZC.BQ(e.B1.iX, n[0] - a.left + (e.B3.iX - n[0] + a.left - e.B3.I) / 4))
                        : n[1] - a.top > e.B3.iY
                        ? e.update(ZC.CY(e.B1.iY + e.B1.F - e.B3.F - 2 * e.B3.AU, e.B3.iY + (n[1] - a.top - e.B3.iY) / 4))
                        : e.update(ZC.BQ(e.B1.iY, n[1] - a.top + (e.B3.iY - n[1] + a.top - e.B3.F) / 4)),
                        e.zoom(!1);
                }),
                ZC.A5("." + e.C.L + "-" + e.sTypeE + "-handle").bind("mousedown touchstart", e.RH),
                ZC.A5("." + e.C.L + "-" + e.sTypeE + "-bar").bind("click", e.RC);
        },
    };
    ZC.ZH = ZC.D0.CC(ZH);
    var WT = {
        $i: function (e, i) {
            this.b(e);
            var t = this;
            (t.BE = e), (t.IM = !1), (t.Z = null), (t.A7L = ""), (t.KQ = 1), (t.H1 = 1), (t.AF = "scroll-" + (i || "y"));
        },
        parse: function () {
            var e,
                i = this;
            i.L = i.BE.L + "-legend-" + i.AF;
            var t = i.BE.A.H.B8,
                n = "(" + i.BE.A.AF + ")";
            (i.B1 = new ZC.HN(i.BE)),
                t.load(i.B1.o, [n + ".legend.scroll.bar", i.AF + ".bar"]),
                null !== ZC._n_((e = i.o.bar)) && i.B1.append(e),
                i.B1.parse(),
                (i.B3 = new ZC.HN(i.BE)),
                t.load(i.B3.o, [n + ".legend.scroll.handle", i.AF + ".handle"]),
                null !== ZC._n_((e = i.o.handle)) && i.B3.append(e),
                i.B3.parse();
        },
        paint: function () {
            var e,
                i = this;
            if (!i.IM) {
                i.Z = ZC.AL(i.BE.A.L + "-legend-scroll-c");
                var t = ZC.AL(i.H.L + "-top");
                "scroll-y" === i.AF
                    ? ((i.B1.iX = i.BE.iX + i.BE.I - i.B1.I - 1),
                      (i.B1.iY = i.BE.EO),
                      (i.B1.F = i.BE.F - (i.BE.KN ? i.BE.KN.F : 0) - (i.BE.EO - i.BE.iY)),
                      (e = Math.ceil(i.BE.B6.length / i.H1 - i.BE.EG / i.H1) + 1),
                      (i.B3.F = i.B1.F / e),
                      (i.B3.iY = i.B1.iY),
                      0 !== i.BE.D4.min && (i.B3.iY += (i.BE.D4.min / i.H1) * i.B3.F),
                      ZC.AL(i.L + "-legend-handle")
                          ? (ZC.A5("#" + i.L + "-legend-handle")
                                .css("left", i.B1.iX + "px")
                                .css("top", i.B3.iY + "px")
                                .css("height", i.B3.F - 0 * i.B3.AU + "px"),
                            ZC.A5("#" + i.L + "-legend-bar")
                                .css("left", i.B1.iX + "px")
                                .css("top", i.B1.iY + "px"),
                            ZC.A5("#" + i.BE.L + "-frame")
                                .css("left", i.BE.iX + "px")
                                .css("top", i.BE.EO + "px"),
                            i.paint_())
                          : ((i.AAL = ZC.Q.I2({
                                cls: "zc-abs zc-scroll zc-scroll-y-bar " + i.BE.L + "-scroll-y-legend-bar",
                                id: i.L + "-legend-bar",
                                wh: i.B1.I + "/" + i.B1.F,
                                tl: i.B1.iY + "/" + i.B1.iX,
                                background: "#fff",
                                opacity: 0,
                                zidx: 1,
                                p: t,
                            })),
                            (i.ZO = ZC.Q.I2({
                                cls: "zc-abs zc-scroll zc-scroll-y-handle " + i.BE.L + "-scroll-y-legend-handle",
                                id: i.L + "-legend-handle",
                                wh: i.B1.I - 0 * i.B3.AU + "/" + (i.B3.F - 0 * i.B3.AU),
                                tl: i.B3.iY + "/" + i.B1.iX,
                                background: "#fff",
                                opacity: 0,
                                zidx: 1,
                                p: t,
                            })),
                            (i.ZO.style.cursor = "pointer"),
                            i.paint_()))
                    : "scroll-x" === i.AF &&
                      ((i.B1.iX = i.BE.iX),
                      (i.B1.iY = i.BE.iY + i.BE.F - i.B1.F - 1),
                      (i.B1.I = i.BE.I),
                      (e = Math.ceil(i.BE.B6.length / i.KQ - i.BE.EG / i.KQ) + 1),
                      (i.B3.I = i.B1.I / e),
                      (i.B3.iX = i.B1.iX),
                      0 !== i.BE.D4.min && (i.B3.iX += (i.BE.D4.min / i.KQ) * i.B3.I),
                      ZC.AL(i.L + "-legend-handle")
                          ? (ZC.A5("#" + i.L + "-legend-handle")
                                .css("left", i.B3.iX + "px")
                                .css("top", i.B1.iY + "px")
                                .css("width", i.B3.I - 0 * i.B3.AU + "px"),
                            ZC.A5("#" + i.L + "-legend-bar")
                                .css("left", i.B1.iX + "px")
                                .css("top", i.B1.iY + "px"),
                            ZC.A5("#" + i.BE.L + "-frame")
                                .css("left", i.BE.iX + "px")
                                .css("top", i.BE.EO + "px"),
                            i.paint_())
                          : ((i.AAE = ZC.Q.I2({
                                cls: "zc-abs zc-scroll zc-scroll-x-bar " + i.BE.L + "-scroll-x-legend-bar",
                                id: i.L + "-legend-bar",
                                wh: i.B1.I + "/" + i.B1.F,
                                tl: i.B1.iY + "/" + i.B1.iX,
                                background: "#fff",
                                opacity: 0,
                                zidx: 1,
                                p: t,
                            })),
                            (i.ZN = ZC.Q.I2({
                                cls: "zc-abs zc-scroll zc-scroll-x-handle " + i.BE.L + "-scroll-x-legend-handle",
                                id: i.L + "-legend-handle",
                                wh: i.B3.I - 0 * i.B3.AU + "/" + (i.B1.F - 0 * i.B3.AU),
                                tl: i.B1.iY + "/" + i.B3.iX,
                                background: "#fff",
                                opacity: 0,
                                zidx: 1,
                                p: t,
                            })),
                            (i.ZN.style.cursor = "pointer"),
                            i.paint_())),
                    ZC.move || i.bind();
            }
        },
        paint_: function () {
            var e,
                i,
                t = this;
            "scroll-y" === t.AF
                ? (((e = new ZC.HN(t)).L = t.BE.L + "-scroll-y-legend-bar"),
                  e.copy(t.B1),
                  (e.Z = t.Z),
                  (e.iX = t.B1.iX),
                  (e.iY = t.B1.iY),
                  (e.I = t.B1.I),
                  (e.F = t.B1.F),
                  e.paint(),
                  ((i = new ZC.HN(t)).L = t.BE.L + "-scroll-y-legend-handle"),
                  i.copy(t.B3),
                  (i.Z = t.Z),
                  (i.iX = t.B1.iX),
                  (i.iY = t.B3.iY),
                  (i.I = t.B3.I),
                  (i.F = t.B3.F),
                  i.paint())
                : "scroll-x" === t.AF &&
                  (((e = new ZC.HN(t)).L = t.BE.L + "-scroll-x-legend-bar"),
                  e.copy(t.B1),
                  (e.Z = t.Z),
                  (e.iX = t.B1.iX),
                  (e.iY = t.B1.iY),
                  (e.I = t.B1.I),
                  (e.F = t.B1.F),
                  e.paint(),
                  ((i = new ZC.HN(t)).L = t.BE.L + "-scroll-x-legend-handle"),
                  i.copy(t.B3),
                  (i.Z = t.Z),
                  (i.iX = t.B3.iX),
                  (i.iY = t.B1.iY),
                  (i.I = t.B3.I),
                  (i.F = t.B1.F),
                  i.paint());
        },
        update: function (e) {
            var i,
                t,
                n,
                a,
                l,
                o,
                r = this,
                s = r.BE;
            if ("scroll-y" === r.AF) {
                if ((e < r.B3.iY && !1, e === r.B3.iY)) return;
                (r.B3.iY = e), ZC.A5("#" + r.L + "-legend-handle").css("top", e + "px"), (i = r.B3.iY - r.B1.iY), (a = Math.ceil(s.B6.length / r.H1 - s.EG / r.H1) + 1), (t = r.B1.F / a), (o = r.H1);
            } else if ("scroll-x" === r.AF) {
                if ((e > r.B3.iX && !1, e === r.B3.iX)) return;
                (r.B3.iX = e), ZC.A5("#" + r.L + "-legend-handle").css("left", e + "px"), (i = r.B3.iX - r.B1.iX), (a = Math.ceil(s.B6.length / r.KQ - s.EG / r.KQ) + 1), (t = r.B1.I / a), (o = r.KQ);
            }
            (n = Math.round(i / t)), (l = s.B6.length - s.EG), s.B6.length % o && (l += o - (s.B6.length % o)), (s.D4.min = Math.min(n * o, l)), (s.D4.max = s.D4.min + s.EG), s.VT(), s.clear(!1), s.parse(), s.paint(), r.paint_();
        },
        unbind: function () {
            var e = this;
            ZC.A5("." + e.BE.L + "-" + e.AF + "-legend-handle").unbind("mousedown touchstart", e.RH), ZC.A5("." + e.BE.L + "-" + e.AF + "-legend-bar").unbind("click", e.RC);
        },
        bind: function () {
            var e = this,
                i = e.H.L,
                t = 0,
                n = 0;
            (e.RH = function (a) {
                if ((a.preventDefault(), !(a.button > 1))) {
                    for (var l = a.target; l && "BODY" !== l.tagName.toUpperCase(); ) {
                        if (-1 !== ZC.Q.T4(l).indexOf("zc-" + e.AF + "-handle")) break;
                        l = l.parentNode;
                    }
                    if ((ZC.mobile || !(a.which > 1)) && l) {
                        var o = ZC.Q.MD(a),
                            r = ZC.A5("#" + i + "-top").offset();
                        if ("scroll-y" === e.AF) {
                            var s = o[1] - r.top;
                            n = s - e.B3.iY;
                        } else if ("scroll-x" === e.AF) {
                            var A = o[0] - r.left;
                            t = A - e.B3.iX;
                        }
                        return ZC.A5(document.body).bind("mousemove touchmove", e.RE), ZC.A5(document.body).bind("mouseup touchend", e.M8), (e.IM = !0), !1;
                    }
                }
            }),
                (e.RE = function (a) {
                    if ((a.preventDefault(), e.IM)) {
                        var l = ZC.Q.MD(a),
                            o = ZC.A5("#" + i + "-top").offset();
                        if ("scroll-y" === e.AF) {
                            var r = l[1] - o.top;
                            r - n < e.B1.iY && (r = e.B1.iY + n), r - n + e.B3.F > e.B1.iY + e.B1.F && (r = e.B1.iY + e.B1.F + n - e.B3.F), e.update(r - n);
                        } else if ("scroll-x" === e.AF) {
                            var s = l[0] - o.left;
                            s - t < e.B1.iX && (s = e.B1.iX + t), s - t + e.B3.I > e.B1.iX + e.B1.I && (s = e.B1.iX + e.B1.I + t - e.B3.I), e.update(s - t);
                        }
                    }
                    return !1;
                }),
                (e.M8 = function () {
                    return (e.H.KP = e.A7L.split(",")), e.IM && (ZC.A5(document.body).unbind("mousemove touchmove", e.RE), ZC.A5(document.body).unbind("mouseup touchend", e.M8), (e.IM = !1), e.bind()), !1;
                }),
                (e.A3G = function (i) {
                    (i.detail ? -120 * i.detail : i.wheelDelta) / 120 > 0 ? e.update(ZC.BQ(e.B1.iY, e.B3.iY - e.B3.F)) : e.update(ZC.CY(e.B1.iY + e.B1.F - e.B3.F, e.B3.iY + e.B3.F));
                }),
                (e.RC = function (t) {
                    e.IM = !0;
                    var n = ZC.Q.MD(t),
                        a = ZC.A5("#" + i + "-top").offset();
                    "scroll-y" === e.AF
                        ? n[1] - a.top > e.B3.iY
                            ? e.update(ZC.CY(e.B1.iY + e.B1.F - e.B3.F, e.B3.iY + e.B3.F))
                            : e.update(ZC.BQ(e.B1.iY, e.B3.iY - e.B3.F))
                        : "scroll-x" === e.AF && (n[0] - a.left > e.B3.iX ? e.update(ZC.CY(e.B1.iX + e.B1.I - e.B3.I, e.B3.iX + e.B3.I)) : e.update(ZC.BQ(e.B1.iX, e.B3.iX - e.B3.I))),
                        (e.IM = !1);
                }),
                ZC.A5("." + e.BE.L + "-" + e.AF + "-legend-handle").bind("mousedown touchstart", e.RH),
                ZC.A5("." + e.BE.L + "-" + e.AF + "-legend-bar").bind("click", e.RC);
        },
    };
    ZC.WT = ZC.D0.CC(WT);
    var V6 = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.OE = "legend"),
                (i.B6 = null),
                (i.Q2 = null),
                (i.NF = "x1"),
                (i.HY = "hide"),
                (i.R3 = ""),
                (i.PP = ""),
                (i.UT = !1),
                (i.UY = !1),
                (i.TS = "none"),
                (i.UJ = "header"),
                (i.EG = 9999),
                (i.D3 = null),
                (i.BT = null),
                (i.ZK = null),
                (i.A2 = null),
                (i.NK = null),
                (i.FO = null),
                (i.KN = null),
                (i.QE = 0),
                (i.MC = 0),
                (i.Z0 = !0),
                (i.EO = 0),
                (i.GO = 0),
                (i.sAlign = ""),
                (i.JY = ""),
                (i.D4 = { enabled: !1, min: -1, max: -1, page: -1, pages: -1 }),
                (i.M1 = !1),
                (i.ND = !1),
                (i.N8 = -1),
                (i.PO = !1),
                (i.A4L = 1),
                (i.WJ = 0),
                (i.L8 = !1),
                (i.XT = !1),
                (i.YI = !1),
                (i.XL = []);
        },
        highlightItem: function (e) {
            var i,
                t = this,
                n = !1,
                a = ZC.move,
                l = t.L8;
            -1 !== e && (l = t.L8 || t.A.AZ.A3[e].L8),
                t.o.item && null !== ZC._n_((i = t.o.item["highlight-item"])) && ((n = ZC._b_(i)), null === ZC._n_(t.o["highlight-legend"]) && null === t.A.AZ.A3[e].o["highlight-legend"] && (l = n)),
                (n || l) && (n && (t.D["highlight-item"] = e), l && (t.D["highlight-legend"] = ZC._i_(e)), t.scrollTo(ZC._i_(e)), t.VT(), t.clear(!0, !1), (t.Z0 = !0), t.parse(), t.fixPlacement(!0), t.paint(), (ZC.move = a));
        },
        scrollTo: function (e) {
            var i,
                t,
                n = this,
                a = !1;
            if (n.D3)
                return (
                    e >= 0 &&
                        (e < n.D4.min || e >= n.D4.max) &&
                        ((a = !0),
                        "scroll" === n.TS
                            ? (e % (t = "scroll-y" === n.D3.AF ? n.D3.H1 : n.D3.KQ) && (e -= e % t),
                              (n.D4.min = e),
                              (n.D4.max = e + n.EG),
                              n.D4.max > n.B6.length && ((n.D4.min = n.B6.length - n.EG), n.B6.length % t && (n.D4.min = n.D4.min + (t - (n.B6.length % t))), (n.D4.max = n.B6.length)))
                            : "page" === n.TS && ((i = Math.floor(e / n.EG)), (n.D4.min = i * n.EG), (n.D4.max = n.D4.min + n.EG), (n.D4.page = i + 1))),
                    a
                );
        },
        parse: function () {
            var e,
                i,
                t,
                n,
                a = this;
            if (
                ((a.D["force-margins"] = !0),
                (a.QE = 0),
                (a.MC = 0),
                null !== ZC._n_((e = a.A.A.D["graph-" + a.A.L + "-legend-info"])) && (null !== ZC._n_(e.x) && (a.o.x = e.x - a.A.iX), null !== ZC._n_(e.y) && (a.o.y = e.y - a.A.iY)),
                ZC.move)
            )
                a.FO && a.FO.parse(), a.KN && a.KN.parse();
            else {
                n = a.A.H.B8;
                var l = "(" + a.A.AF + ")";
                a.b(),
                    a.assign_a([
                        ["collapse", "M1", "b"],
                        ["minimize", "UT", "b"],
                        ["draggable", "UY", "b"],
                        ["shared", "PO", "b"],
                        ["overflow", "TS"],
                        ["max-items", "EG", "i"],
                        ["group", "A4L", "i"],
                        ["drag-handler", "UJ"],
                        ["highlight-plot", "WJ", "b"],
                        ["highlight-legend", "L8", "b"],
                        ["align", "sAlign"],
                        ["vertical-align", "JY"],
                    ]),
                    a.M1 && !a.UT && (a.M1 = !1),
                    zingchart.DEV.MEDIARULES && (a.D["forced-align-position"] || (a.alignPosition({ align: a.sAlign, "vertical-align": a.JY, layout: a.NF }), (a.D["forced-align-position"] = !0))),
                    a.WJ && null === ZC._n_(a.o["highlight-legend"]) && (a.L8 = a.WJ),
                    (a.BT = new ZC.DN(a)),
                    n.load(a.BT.o, l + ".legend.item"),
                    a.o.item && null === ZC._n_(a.o.item.visible) && (a.o.item.visible = !0),
                    a.BT.append(a.o.item),
                    a.BT.parse(),
                    (a.ZK = new ZC.DN(a)),
                    n.load(a.ZK.o, l + ".legend.item-off"),
                    a.o["item-off"] && null === ZC._n_(a.o["item-off"].visible) && (a.o["item-off"].visible = !0),
                    a.ZK.append(a.o["item-off"]),
                    a.ZK.parse(),
                    (a.A2 = new ZC.DU(a)),
                    n.load(a.A2.o, l + ".legend.marker"),
                    a.o.marker && null === ZC._n_(a.o.marker.visible) && (a.o.marker.visible = !0),
                    a.A2.append(a.o.marker),
                    (a.A2.D.type = "default"),
                    (a.A2.D["show-marker"] = !0),
                    (a.A2.D["show-line"] = !1),
                    null !== ZC._n_((e = a.A2.o.type)) && (a.A2.D.type = e),
                    null !== ZC._n_((e = a.A2.o["show-line"])) && (a.A2.D["show-line"] = ZC._b_(e)),
                    null !== ZC._n_((e = a.BT.o["marker-style"])) && (a.A2.D.type = e),
                    null !== ZC._n_((e = a.BT.o["show-line"])) && (a.A2.D["show-line"] = ZC._b_(e)),
                    null !== ZC._n_((e = a.BT.o["show-marker"])) && (a.A2.o.visible = ZC._b_(e)),
                    a.A2.parse(),
                    (a.NK = new ZC.DU(a)),
                    n.load(a.NK.o, l + ".legend.marker-off"),
                    a.o["marker-off"] && (a.o["marker-off"].visible = !0),
                    a.NK.append(a.o["marker-off"]),
                    (a.NK.D.type = "default"),
                    (a.NK.D["show-marker"] = !0),
                    (a.NK.D["show-line"] = !1),
                    null !== ZC._n_((e = a.NK.o.type)) && (a.NK.D.type = e),
                    null !== ZC._n_((e = a.NK.o["show-line"])) && (a.NK.D["show-line"] = ZC._b_(e)),
                    null !== ZC._n_((e = a.BT.o["marker-style"])) && (a.NK.D.type = e),
                    null !== ZC._n_((e = a.BT.o["show-line"])) && (a.NK.D["show-line"] = ZC._b_(e)),
                    null !== ZC._n_((e = a.BT.o["show-marker"])) && (a.NK.o.visible = ZC._b_(e)),
                    a.NK.parse(),
                    (null !== ZC._n_((e = a.o.header)) || a.UY || a.UT) &&
                        ((a.FO = new ZC.DN(a)),
                        (a.FO.OE = "legendheader"),
                        (a.FO.GL = "zc-legend-item " + a.L + "-header"),
                        (a.FO.L = a.L + "-header"),
                        n.load(a.FO.o, l + ".legend.header"),
                        (a.FO.o.text = a.FO.o.text || " "),
                        a.FO.append(e),
                        a.FO.parse(),
                        a.FO.AN || (a.FO = null)),
                    null !== ZC._n_((e = a.o.footer)) &&
                        ((a.KN = new ZC.DN(a)),
                        (a.KN.OE = "legendfooter"),
                        (a.KN.GL = "zc-legend-item " + a.L + "-footer"),
                        (a.KN.L = a.L + "-footer"),
                        n.load(a.KN.o, l + ".legend.footer"),
                        a.KN.append(e),
                        a.KN.parse(),
                        a.KN.AN || (a.KN = null));
                var o = a.A.AZ.A3;
                null !== ZC._n_((e = a.o.layout)) ? (a.NF = e) : 25 * o.length > a.A.F && (a.NF = "x" + Math.ceil((25 * o.length) / a.A.F)),
                    null !== ZC._n_((e = a.o["toggle-action"])) && (a.HY = e),
                    (a.R3 = a.PP = a.HY),
                    null !== ZC._n_(a.o.item) && null !== ZC._n_((e = a.o.item["toggle-action"])) && (a.R3 = e),
                    null !== ZC._n_(a.o.marker) && null !== ZC._n_((e = a.o.marker["toggle-action"])) && (a.PP = e);
                var r = function (e) {
                        if (o[i] && o[i].FK(0)) {
                            var t = ZC.AP.O2(a.BT.o, o[i].o);
                            e = o[i].FK(0).JT(e, t);
                        }
                        return e;
                    },
                    s = [];
                a.B6 = [];
                var A = 0;
                for (i = 0, t = o.length; i < t; i++) {
                    var C = a.A.AZ.M3[i];
                    if (o[C].o["skip-paint"] || (null !== ZC._n_(o[C].o["show-in-legend"]) && !ZC._b_(o[C].o["show-in-legend"]))) o[C].bShowInLegend = !1;
                    else {
                        var c = new ZC.DN(a);
                        c.copy(a.BT),
                            c.append(o[C].o["legend-item"]),
                            null === ZC._n_(c.o.text) && null !== ZC._n_((e = o[C].A64)) && (c.o.text = e),
                            null === ZC._n_(c.o.text) && null !== ZC._n_((e = o[C].AM)) && (c.o.text = e),
                            (c.AM = null === ZC._n_(c.o.text) ? "Series " + (C + 1) : c.o.text),
                            (c.D.order = C),
                            (c.D.index = C),
                            null !== ZC._n_(o[C].o["legend-item"]) && null !== ZC._n_((e = o[C].o["legend-item"].order)) && (c.D.order = ZC._i_(e)),
                            s.push([A, C, c.D.order]),
                            A++,
                            -1 !== c.AM.indexOf("%") && (c.JT = r),
                            c.parse(),
                            a.B6.push(c);
                    }
                }
                for (
                    s.sort(function (e, i) {
                        return e[2] - i[2];
                    }),
                        i = 0;
                    i < s.length;
                    i++
                )
                    (s[i][2] = i), (o[s[i][1]].o["legend-item"] = o[s[i][1]].o["legend-item"] || {}), (o[s[i][1]].o["legend-item"].order = s[i][2]), (a.B6[s[i][0]].D.order = s[i][2]);
                (e = a.A.D["legend-info"]) && (a.ND = e.collapsed);
            }
            if (a.B6 && a.A2) {
                "page" === a.TS
                    ? ((e = a.A.D["legend-info"]) ? ((a.D4.min = e.min), (a.D4.max = e.max), (a.D4.page = e.page)) : ((a.D4.min = 0), (a.D4.max = a.EG), (a.D4.page = 1)),
                      (a.D4.pages = Math.ceil(a.B6.length / a.EG)),
                      a.D4.page > a.D4.pages && ((a.D4.page = a.D4.pages), (a.D4.min = (a.D4.page - 1) * a.EG), (a.D4.max = a.D4.page * a.EG - 1)),
                      (a.D4.page = ZC.CY(a.D4.page, a.D4.pages)))
                    : "scroll" === a.TS
                    ? (e = a.A.D["legend-info"])
                        ? ((a.D4.min = e.min), (a.D4.max = e.max), (a.D4.page = e.page))
                        : ((a.D4.min = 0), (a.D4.max = a.EG), (a.D4.page = 1))
                    : ((a.D4.min = 0), (a.D4.max = "hidden" === a.TS ? a.EG : a.B6.length), (a.D4.page = 1)),
                    a.VT(!1),
                    a.B6.sort(function (e, i) {
                        return e.D.order - i.D.order;
                    }),
                    a.o["reverse-series"] && a.B6.reverse();
                var u = 0.9 * a.A.I;
                null !== ZC._n_(a.o.width) && (u = a.I);
                var p = 0,
                    Z = 0,
                    h = -ZC.MAX,
                    d = -ZC.MAX,
                    f = a.A2.D["show-line"] ? 3 : 2,
                    _ = 0,
                    g = 1,
                    v = 1;
                if ("float" === a.NF) {
                    for (i = 0, t = a.B6.length; i < t; i++)
                        if (((_ += a.B6[i].AN ? 1 : 0), !(i < a.D4.min || i >= a.D4.max || a.ND) && a.B6[i].AN)) {
                            var b = a.B6[i].I + a.B6[i].DZ + a.B6[i].E8 + f * a.B6[i].DJ;
                            (d = ZC.BQ(d, a.B6[i].F + a.B6[i].E9 + a.B6[i].DR)), p + b > u ? ((h = ZC.BQ(h, p)), (Z += d), (p = b), (d = ZC.BQ(d, a.B6[i].F + a.B6[i].E9 + a.B6[i].DR))) : (p += b);
                        }
                    (h = ZC.BQ(h, p)), d !== -ZC.MAX && (Z += d), h !== -ZC.MAX && (p = h);
                } else {
                    var B = 0;
                    for (i = 0, t = a.B6.length; i < t; i++) (_ += a.B6[i].AN ? 1 : 0), i < a.D4.min || i >= a.D4.max || a.ND || (B += a.B6[i].AN ? 1 : 0);
                    var m = ZC.AQ.A23(a.NF, B);
                    for (g = m[0], v = m[1], i = 0, t = a.B6.length; i < t; i++)
                        ((i < a.D4.min || i >= a.D4.max || a.ND) && ("scroll" !== a.TS || _ <= a.EG)) ||
                            (a.B6[i].AN && ((h = ZC.BQ(h, a.B6[i].I + a.B6[i].DZ + a.B6[i].E8 + f * a.B6[i].DJ)), (d = ZC.BQ(d, a.B6[i].F + a.B6[i].E9 + a.B6[i].DR)), 1 === v && (Z += a.B6[i].F + a.B6[i].E9 + a.B6[i].DR)));
                    (p = v * h), (Z = g * d);
                }
                if (
                    ("page" === a.TS && _ > a.EG && (a.D4.enabled = !0),
                    "scroll" === a.TS &&
                        _ > a.EG &&
                        (a.D3 || (!g || g > v ? ((a.D3 = new ZC.WT(a, "y")), n.load(a.D3.o, ".scroll-y")) : ((a.D3 = new ZC.WT(a, "x")), n.load(a.D3.o, ".scroll-x")), a.D3.append(a.o.scroll), (a.D3.KQ = g), (a.D3.H1 = v), a.D3.parse()),
                        a.ND || ("scroll-y" === a.D3.AF ? (p += a.D3.B1.I) : (Z += a.D3.B1.F))),
                    a.FO)
                ) {
                    var D = a.FO.I;
                    a.UY && "icon" === a.UJ ? ((D += 15), a.UT && (D += 25)) : a.UT && (D += 15), (p = ZC.BQ(p, D));
                }
                a.KN && (p = ZC.BQ(p, a.KN.I));
                var E = !1,
                    L = !1;
                if (
                    (null === ZC._n_(a.o.width) && ((a.o.width = p), (E = !0)),
                    null === ZC._n_(a.o.height) && ((a.o.height = Z), (L = !0)),
                    (a.iX = -1),
                    (a.iY = -1),
                    !ZC.move && a.FO && null !== ZC._n_((e = a.A.A.D["legend" + a.A.K + "-xy-ratio"])))
                ) {
                    a.locate();
                    var F = a.I + a.EQ + a.FN,
                        I = a.F + a.FM + a.FT,
                        x = a.PO ? a.A.A : a.A;
                    (a.iX = x.I * e[0]), (a.iX = ZC.BQ(a.iX, 1.1)), (a.o.x = a.iX = ZC.CY(a.iX, x.I - F - 2)), (a.iY = (x.F - a.FO.F) * e[1]), (a.iY = ZC.BQ(a.iY, 1.1)), (a.o.y = a.iY = ZC.CY(a.iY, x.F - I - a.FO.F - 2));
                }
                if (
                    (a.locate(),
                    null !== ZC._n_(a.o.position) && "undefined" != typeof a.D["position-info"]
                        ? (a.D["position-info"][0] > 0.5 && (a.QE += a.EQ + a.FN), a.D["position-info"][1] > 0.5 ? (a.MC += a.FM + a.FT) : (a.FO && (a.MC -= a.FO.F), a.KN && (a.MC -= a.KN.F), a.D4 && a.D4.enabled && (a.MC -= 20)))
                        : ((0 === a.A.iX || a.iX + a.I / 2 > a.A.iX + a.A.I / 2) && (a.QE += a.EQ + a.FN), (0 === a.A.iY || a.iY + a.F / 2 > a.A.iY + a.A.F / 2) && (a.MC += a.FM + a.FT)),
                    !ZC.move && (e = a.A.A.D["graph-" + a.A.L + "-legend-info"]) && (e.x && (a.iX = e.x), e.y && (a.iY = e.y)),
                    (a.GO = a.F),
                    (a.EO = a.iY),
                    a.FO && ((a.F += a.FO.F), (a.EO += a.FO.F), (a.MC += a.FO.F)),
                    a.KN && ((a.F += a.KN.F), (a.MC += a.KN.F)),
                    a.D4.enabled && !a.ND)
                ) {
                    var y = new ZC.DN(a);
                    (y.AM = " "), y.append(a.o["page-status"]), (null !== ZC._n_(y.o.text) && "" !== y.o.text) || (y.o.text = "#"), y.parse(), (a.F += y.F + 4), (a.MC += y.F + 4);
                }
                E && (a.o.width = null), L && (a.o.height = null), a.ND || ((a.I += a.EQ + a.FN), (a.F += a.FM + a.FT)), a.D["default-width"] && (a.I = a.D["default-width"]);
            }
        },
        alignPosition: function (e) {
            var i = this;
            if (null !== ZC._n_(e)) {
                var t = i.A.H.B8.B8.graph.legend,
                    n = e.align || t.align,
                    a = e["vertical-align"] || t["vertical-align"],
                    l = e.layout || t.layout;
                (n || a) &&
                    ("center" === n ? (null === ZC._n_(i.o.layout) && (l = i.o.layout = "horizontal"), (i.o.position = "50% ")) : (i.o.position = "left" === n ? "0% " : "100% "),
                    (i.o.position += "middle" === a ? "50%" : "bottom" === a ? "100%" : "0%"),
                    ("horizontal" !== l && "middle" !== a) || (i.o["adjust-layout"] = !0));
            }
        },
        VT: function (e) {
            var i = this;
            void 0 === e && (e = !0), (i.A.D["legend-info"] = { collapsed: i.ND, min: i.D4.min, max: i.D4.max, page: i.D4.page }), e && (i.A.A.D["graph-" + i.A.L + "-legend-info"] = { x: i.iX, y: i.iY });
        },
        clear: function (e, i) {
            null === ZC._n_(e) && (e = !1), null === ZC._n_(i) && (i = !1);
            var t = this,
                n = t.A.L + "-legend-",
                a = null;
            ZC.A5("." + n + "item", a).remove(),
                ZC.A5("." + n + "header", a).remove(),
                ZC.A5("." + n + "footer", a).remove(),
                ZC.A5("#" + n + "page-status", a).remove(),
                (e && !i) || (ZC.move || t.unbind(), ZC.A5("." + n + "page-area", a).remove(), ZC.A5("." + n + "header-area", a).remove(), ZC.A5("." + n + "item-area", a).remove(), ZC.A5("." + n + "marker-area", a).remove()),
                ZC.move ? ZC.Q.IV(ZC.AL(n + "c"), t.A.H.AC, t.A.iX, t.A.iY, t.A.I, t.A.F) : ZC.Q.IV(ZC.AL(n + "c"), t.A.H.AC, t.iX - 2 * t.AU - 2 * t.JV, t.iY - 2 * t.AU - 2 * t.JV, t.I + 4 * t.AU + 4 * t.JV, t.F + 4 * t.AU + 4 * t.JV),
                t.D3 && ZC.Q.IV(ZC.AL(n + "scroll-c"), t.A.H.AC, t.A.iX, t.A.iY, t.A.I, t.A.F);
        },
        unbind: function () {
            var e = this;
            ZC.A5("#" + e.L + "-frame")
                .die(ZC.Q.C1("mouseover"), e.zc_legend_mouseover)
                .die(ZC.Q.C1("mouseout"), e.zc_legend_mouseout),
                ZC.A5("#" + e.L + "-move-area").die(ZC.Q.C1("mousedown"), e.Z7),
                ZC.A5("#" + e.L + "-minimize-area").die(ZC.Q.C1("click"), e.XY),
                ZC.A5("." + e.L + "-page-area").die(ZC.Q.C1("click"), e.Z2),
                e.D3 && e.D3.unbind(),
                e.BT && e.BT.o.reorder && ZC.A5("." + e.A.L + "-legend-item-area").die("mousedown", e.W8);
        },
        fixPlacement: function (e) {
            var i = this;
            if ((i.Z0 && null === ZC._n_(i.o.y)) || e) {
                if (((!i.o.position && e) || (i.iX -= i.QE), i.iX < i.DZ && (i.DZ < i.E8 || -2 === i.E8) && (i.iX = i.DZ), (!i.o.position && e) || ((i.iY -= i.MC), (i.EO -= i.MC)), i.iY < i.E9 && (i.E9 < i.DR || -2 === i.DR))) {
                    var t = i.EO - i.iY;
                    (i.iY = i.E9), (i.EO = i.E9 + t);
                }
                i.Z0 = !1;
            }
        },
        EL: function (e) {
            var i = this;
            i.FO && i.FO.EL(e), i.KN && i.KN.EL(e);
            for (var t = 0; t < i.XL.length; t++) i.XL[t].EL(e);
        },
        paint: function (e) {
            var i,
                t,
                n,
                a,
                l,
                o,
                r,
                s,
                A,
                C,
                c,
                u,
                p,
                Z,
                h,
                d,
                f = this;
            if (f.AN && (f.D["default-width"] || (f.D["default-width"] = f.I), f.B6)) {
                var _ = ZC.AL(f.H.L + "-top"),
                    g = f.A.AZ.A3,
                    v = 0;
                for (o = 0, r = f.B6.length; o < r; o++) o < f.D4.min || o >= f.D4.max || f.ND || (v += f.B6[o].AN ? 1 : 0);
                (f.A5L = !0),
                    f.b(),
                    f.FO &&
                        ((f.FO.iX = f.iX),
                        (f.FO.iY = f.iY),
                        (f.FO.I = f.I),
                        (f.FO.Z = f.FO.C7 = f.Z),
                        f.FO.paint(),
                        ZC.move || ("canvas" !== f.A.A.AC && f.FO.EL()),
                        f.UY &&
                            "icon" === f.UJ &&
                            (((n = new ZC.DU(f)).Z = f.Z),
                            (n.B7 = "#000"),
                            (n.B0 = 1),
                            (n.DS = "line"),
                            n.append(f.o.icon),
                            (a = f.FO.iX + f.FO.I - 10),
                            (l = f.FO.iY + f.FO.F / 2),
                            (n.E = [
                                [a - 7, l],
                                [a + 7, l],
                                null,
                                [a, l - 7],
                                [a, l + 7],
                                null,
                                [a - 6, l - 1],
                                [a - 6, l + 1],
                                null,
                                [a - 5, l - 2],
                                [a - 5, l + 2],
                                null,
                                [a + 6, l - 1],
                                [a + 6, l + 1],
                                null,
                                [a + 5, l - 2],
                                [a + 5, l + 2],
                                null,
                                [a - 1, l - 6],
                                [a + 1, l - 6],
                                null,
                                [a - 2, l - 5],
                                [a + 2, l - 5],
                                null,
                                [a - 1, l + 6],
                                [a + 1, l + 6],
                                null,
                                [a - 2, l + 5],
                                [a + 2, l + 5],
                            ]),
                            n.parse(),
                            n.paint()),
                        f.UT &&
                            (((t = new ZC.DU(f)).Z = f.Z),
                            (t.B7 = ZC.AP.A9Z(f.A0, "#fff", "#000")),
                            (t.B0 = 1),
                            t.append(f.o.icon),
                            (t.DS = "line"),
                            (a = f.FO.iX + f.FO.I - 10 - (f.UY && "icon" === f.UJ ? 20 : 0)),
                            (l = f.FO.iY + f.FO.F / 2),
                            (t.E = [[a - 7, l - 2], [a + 2, l - 2], [a + 2, l + 7], [a - 7, l + 7], [a - 7, l - 2], [a + 2, l - 2], null, [a - 4, l - 5], [a + 5, l - 5], [a + 5, l + 4], [a - 4, l + 4], [a - 4, l - 5], [a + 5, l - 5]]),
                            t.parse(),
                            t.paint())),
                    f.KN && ((f.KN.iX = f.iX), (f.KN.iY = f.iY + f.F - f.KN.F), (f.KN.I = f.I), (f.KN.Z = f.KN.C7 = f.Z), f.KN.paint(), ZC.move || ("canvas" !== f.A.A.AC && f.KN.EL()));
                var b = ZC.AQ.A23(f.NF, v),
                    B = b[0],
                    m = b[1],
                    D = f.I / m,
                    E = f.GO / B,
                    L = 0,
                    F = 0;
                f.Q2 = [];
                var I,
                    x = 0,
                    y = -ZC.MAX,
                    w = f.A2.D["show-line"] ? 3 : 2,
                    Y = null,
                    X = function (i) {
                        var t = i;
                        if ((null === ZC._n_(e) && (e = 0), g[I] && g[I].S[e])) {
                            var n = ZC.AP.O2(f.BT.o, g[I].o);
                            i = g[I].FK(e).JT(i, n);
                        }
                        return (f.XT = f.XT || i !== t), i;
                    },
                    M = 0;
                for (f.XT = !1, o = 0, r = f.B6.length; o < r; o++)
                    if (!(o - M < f.D4.min || o - M >= f.D4.max || f.ND)) {
                        var K = new ZC.DN(f);
                        K.copy(f.B6[o]), f.D["highlight-legend"] === o && (K.append({ bold: !0 }), null !== ZC._n_(f.o.item) && K.append(f.o.item["highlight-state"])), (I = K.D.index);
                        var S = new ZC.DN(f);
                        (S.OE = "legenditem"),
                            (S.L = f.L + "-item_" + I),
                            (S.GL = "zc-legend-item " + f.L + "-item"),
                            S.copy(K),
                            (f.A.D["plot" + I + ".visible"] && "off" !== g[I].o["legend-status"]) || S.append(f.ZK.o),
                            S.append(g[I].o["legend-item"]),
                            (S.JT = X),
                            S.parse(),
                            S.AN
                                ? ("float" === f.NF
                                      ? ((y = ZC.BQ(y, K.F)),
                                        null === ZC._n_(Y)
                                            ? ((K.iX = f.iX + f.EQ + K.DZ + w * K.DJ), (K.iY = f.EO + f.FM + K.E9), (x = f.EO))
                                            : ((K.iX = Y.iX + Y.I + Y.E8 + K.DZ + w * K.DJ),
                                              ZC._i_(K.iX + K.I + K.E8) > ZC._i_(f.iX + f.I) && ((K.iX = f.iX + f.EQ + K.DZ + w * K.DJ), (x += y + K.E9 + K.DR), (y = -ZC.MAX)),
                                              (K.iY = x + f.FM + K.E9)))
                                      : ((K.iX = f.iX + (0 === F ? f.EQ : 0) + F * D + K.DZ + w * K.DJ), (K.iY = f.EO + f.FM + L * E + K.E9), ++F === m && ((F = 0), L++)),
                                  (Y = K),
                                  (S.iX = K.iX = ZC._i_(K.iX)),
                                  (S.iY = K.iY = ZC._i_(K.iY)),
                                  (S.Z = S.C7 = f.Z),
                                  (S.iX += f.BL),
                                  (S.iY += f.BI),
                                  I === f.N8 && (f.D["calculate-y"] && ((f.D["calculate-y"] = !1), (f.D["dragged-offset-y"] = f.D["dragged-y"] - S.iY)), (S.iY = f.D["dragged-y"] - f.D["dragged-offset-y"] - S.DJ / 4)),
                                  S.paint(),
                                  ("undefined" != typeof f.D.showhide && null !== ZC._n_(f.D.showhide)) || ZC.move || ("canvas" !== f.A.A.AC ? S.EL() : f.XL.push(S)))
                                : M++;
                        var P = f.A2.D.type;
                        null !== ZC._n_((i = g[I].o["legend-marker"])) && null !== ZC._n_(i.type) && (P = i.type);
                        var H,
                            N = !1;
                        switch (
                            (("match" !== P && "inherit" !== P) || ((N = !0), (P = null !== ZC._n_((i = g[I].A2.o.type)) ? i : "default")),
                            -1 !== ZC.AV(["default", "square"], P) ? (H = new ZC.HN(f)) : ((H = new ZC.DU(f)).DS = P),
                            (H.OE = "legendmarker"),
                            H.append(f.A2.o),
                            (f.A.D["plot" + I + ".visible"] && "off" !== g[I].o["legend-status"]) || H.append(f.NK.o),
                            (H.NA = g[I].NA),
                            g[I].AF)
                        ) {
                            case "pie":
                            case "pie3d":
                            case "nestedpie":
                            case "vbar":
                            case "vbar3d":
                            case "hbar":
                            case "hbar3d":
                            case "vbullet":
                            case "hbullet":
                            case "area":
                            case "area3d":
                            case "gauge":
                            case "vfunnel":
                            case "hfunnel":
                            case "venn":
                                (H.A0 = g[I].A0), (H.AE = g[I].AE), (H.GR = g[I].GR), (H.HL = g[I].HL);
                                break;
                            case "scatter":
                            case "hscatter":
                            case "bubble":
                            case "hbubble":
                                (H.A0 = "-1" !== g[I].A2.A0 ? g[I].A2.A0 : g[I].A0), (H.AE = "-1" !== g[I].A2.AE ? g[I].A2.AE : g[I].AE), (H.GR = "" !== g[I].A2.GR ? g[I].A2.GR : g[I].GR), (H.HL = "" !== g[I].A2.HL ? g[I].A2.HL : g[I].HL);
                                break;
                            default:
                                (H.A0 = g[I].B7), (H.AE = g[I].B7);
                        }
                        ("line" !== H.DS && "area" !== H.DS) || ((H.B7 = H.A0), (H.B0 = 2)),
                            N && H.append(g[I].A2.o),
                            (H.o["line-style"] = "solid"),
                            (H.o.type = H.DS),
                            H.append(g[I].o["legend-marker"]),
                            N && (H.o.type = H.DS),
                            (H.D["show-marker"] = !0),
                            (H.D["show-line"] = !1),
                            null !== ZC._n_((i = H.o["show-line"])) && (H.D["show-line"] = ZC._b_(i)),
                            null !== ZC._n_((i = S.o["show-line"])) && (H.D["show-line"] = ZC._b_(i)),
                            null !== ZC._n_((i = S.o["show-marker"])) && (H.o.visible = ZC._b_(i)),
                            -1 !== ZC.AV(["default", "square"], P) && null !== ZC._n_((i = H.o.size)) && (null === ZC._n_(H.o.width) && (H.o.width = 2 * ZC._i_(i)), null === ZC._n_(H.o.height) && (H.o.height = 2 * ZC._i_(i))),
                            (H.L = f.L + "-marker_" + I),
                            (H.Z = H.C7 = f.Z),
                            (H.iX = S.iX - w * S.DJ + ((w - 1) * S.DJ) / 2 + S.DJ / 2),
                            (H.iY = S.iY + (S.F - S.DJ) / 2 + S.DJ / 2),
                            H.parse(),
                            f.D["highlight-legend"] === o &&
                                (H.append({ size: H.AI + 1, width: H.I + 2, height: H.F + 2 }),
                                g[I] && g[I].S[e] && g[I].S[e].GJ && H.append({ A0: g[I].S[e].GJ.A0, AE: g[I].S[e].GJ.AE }),
                                null !== ZC._n_(f.o.marker) && H.append(f.o.marker["highlight-state"]),
                                H.parse()),
                            "line" === H.DS
                                ? ((H.o.points = [
                                      [H.iX - 1.75 * H.AI, H.iY],
                                      [H.iX + 1.75 * H.AI, H.iY],
                                  ]),
                                  H.parse())
                                : "area" === H.DS &&
                                  ((H.o.points = [
                                      [H.iX - 1.75 * H.AI, H.iY + H.AI],
                                      [H.iX + 1.75 * H.AI, H.iY + H.AI],
                                      [H.iX + 1 * H.AI, H.iY - H.AI / 2],
                                      [H.iX, H.iY],
                                      [H.iX - 1.25 * H.AI, H.iY - H.AI],
                                      [H.iX - 1.75 * H.AI, H.iY + H.AI],
                                  ]),
                                  H.parse());
                        var G = H.iX + H.BL,
                            O = H.iY + H.BI;
                        if ((-1 !== ZC.AV(["default", "square"], P) && ((H.iX -= H.I / 2), (H.iY -= H.F / 2)), (f.A.D["plot" + I + ".visible"] && "off" !== g[I].o["legend-status"]) || (H.C6 /= 4), S.AN && H.D["show-line"])) {
                            var k = ZC.Q.EB(f.Z, f.A.H.AC),
                                T = new ZC.D0(f);
                            (T.Z = f.Z),
                                T.copy(g[I]),
                                (T.o["line-style"] = f.A2.GF),
                                T.append(g[I].o),
                                T.append(f.A2.o),
                                T.append(g[I].o["legend-item"]),
                                T.append(g[I].o["legend-marker"]),
                                (T.o["top-state"] = null),
                                (T.o["bottom-state"] = null),
                                T.parse(),
                                f.A.D["plot" + I + ".visible"] || (T.C6 = 0.25);
                            var z = [],
                                Q = H.AN ? 2 : 1;
                            (s = "box" === H.DS ? H.I / 2 : H.AI), z.push([G - Q * s - (T.B0 > 1 ? 1 : 0), O - (T.B0 > 1 ? 0.5 : 0)]), z.push([G + Q * s, O - (T.B0 > 1 ? 0.5 : 0)]), (T.CZ = !0), ZC.CS.paint(k, T, z);
                        }
                        I === f.N8 && (H.iY = f.D["dragged-y"] - f.D["dragged-offset-y"] / 2), H.AN && S.AN && H.paint(), f.Q2.push(H);
                        var V = !0;
                        if ((null !== ZC._n_((i = f.BT.o.toggle)) && (V = ZC._b_(i)), (f.D["item.toggle"] = V), S.AN || H.AN)) {
                            if (-1 === ZC.AV(f.A.H.KP, "skip_interactivity")) {
                                var J = H.BL + ("box" === H.DS ? H.iX + H.I / 2 : H.iX),
                                    R = H.BI + ("box" === H.DS ? H.iY + H.F / 2 : H.iY);
                                (s = "box" === H.DS ? H.I / 2 : H.AI), (A = "box" === H.DS ? H.F / 2 : H.AI);
                                var W = (H.D["show-line"] ? 2 : 1) * s;
                                ZC.AL(S.L + "-area") ||
                                    (H.AN &&
                                        "disabled" !== f.PP &&
                                        "disabled" !== H.o["toggle-action"] &&
                                        (ZC.AL(H.L + "-area") ||
                                            ZC.Q.I2({
                                                cls: f.L + "-marker-area zc-legend-marker-area zc-abs",
                                                id: H.L + "-area",
                                                wh: 2 * W + "/" + 2 * A,
                                                tl: R - A + "/" + (J - W),
                                                opacity: 0,
                                                background: "#fff",
                                                cursor: H.IP,
                                                p: _,
                                                zidx: 1,
                                            })),
                                    S.AN &&
                                        "disabled" !== f.R3 &&
                                        "disabled" !== S.o["toggle-action"] &&
                                        (ZC.AL(S.L + "-area") ||
                                            ZC.Q.I2({
                                                cls: f.L + "-item-area zc-legend-item-area zc-abs",
                                                id: S.L + "-area",
                                                wh: S.I + "/" + S.F,
                                                tl: S.iY + S.BI + "/" + (S.iX + S.BL),
                                                opacity: 0,
                                                background: "#fff",
                                                cursor: S.IP,
                                                p: _,
                                                zidx: 1,
                                            })));
                            }
                        } else g[o].bShowInLegend = !1;
                    }
                if ((f.D3 && !f.ND && (f.D3.paint(), (ZC.AL(f.L + "-scroll-c").style.display = "block")), f.D3 && f.ND && (ZC.AL(f.L + "-scroll-c").style.display = "none"), f.D4.enabled && !f.ND)) {
                    var U = new ZC.DN(f);
                    (U.Z = U.C7 = f.Z),
                        (U.L = f.L + "-page-status"),
                        (U.AM = ZC.HJ["legend-pagination"].replace("%page%", f.D4.page).replace("%pages%", f.D4.pages)),
                        U.append(f.o["page-status"]),
                        U.parse(),
                        f.I < U.I + 48 && ((U.AM = f.D4.page + "/" + f.D4.pages), U.parse()),
                        (U.iX = f.iX + f.I / 2 - U.I / 2),
                        (U.iY = f.iY + f.F - (f.KN ? f.KN.F : 0) - U.F - 4),
                        U.AN && U.paint();
                    var j = f.A.H.B8,
                        q = "(" + f.A.AF + ")",
                        $ = { "background-color": "#999" },
                        ee = { "background-color": "#f90" };
                    j.load($, q + ".legend.page-off"),
                        j.load(ee, q + ".legend.page-on"),
                        ((c = new ZC.DU(f)).Z = c.C7 = f.Z),
                        (c.L = f.L + "-page-prev"),
                        (c.A0 = c.AE = f.D4.page > 1 ? ee["background-color"] : $["background-color"]),
                        c.append(f.D4.page > 1 ? f.o["page-on"] : f.o["page-off"]),
                        (C = f.iX + f.I / 2 - U.I / 2 - 6),
                        (u = U.iY + U.F / 2),
                        c.parse(),
                        (c.AI = ZC.BQ(c.AI, 8)),
                        (d = ZC._i_(0.75 * c.AI)),
                        (c.E = [
                            [C, u - d],
                            [C, u + d],
                            [C - c.AI, u],
                            [C, u - d],
                        ]),
                        c.parse(),
                        c.AN && c.paint(),
                        ((Z = new ZC.DU(f)).Z = Z.C7 = f.Z),
                        (Z.L = f.L + "-page-next"),
                        (Z.A0 = Z.AE = f.D4.page < f.D4.pages ? ee["background-color"] : $["background-color"]),
                        Z.append(f.D4.page < f.D4.pages ? f.o["page-on"] : f.o["page-off"]),
                        (p = f.iX + f.I / 2 + U.I / 2 + 6),
                        (h = U.iY + U.F / 2),
                        Z.parse(),
                        (Z.AI = ZC.BQ(Z.AI, 8)),
                        (d = ZC._i_(0.75 * Z.AI)),
                        (Z.E = [
                            [p, h - d],
                            [p, h + d],
                            [p + Z.AI, h],
                            [p, h - d],
                        ]),
                        Z.parse(),
                        Z.AN && Z.paint();
                }
                if (!ZC.move) {
                    var ie,
                        te,
                        ne = f.F,
                        ae = f.iY;
                    f.FO && ((ne -= f.FO.F), (ae += f.FO.F)),
                        ZC.AL(f.L + "-frame")
                            ? ZC.A5("#" + f.L + "-frame")
                                  .css("top", ae + "px")
                                  .css("left", f.iX + "px")
                                  .css("width", f.I + "px")
                                  .css("height", ne + "px")
                            : ZC.Q.I2({ cls: "zc-abs zc-legend-frame " + f.L + "-frame", id: f.L + "-frame", wh: f.I + "/" + ne, tl: ae + "/" + f.iX, opacity: 0, background: "#fff", p: _, zidx: 0 }),
                        f.D4.enabled &&
                            !f.ND &&
                            (f.D4.page > 1 &&
                                ZC.Q.I2({ cls: f.L + "-page-area zc-legend-page-area zc-abs", id: f.L + "-page-prev-area", wh: c.AI + "/" + 2 * c.AI, tl: ZC._i_(u + c.BI - c.AI) + "/" + ZC._i_(C + c.BL - c.AI), opacity: 0, p: _, zidx: 1 }),
                            f.D4.page < f.D4.pages &&
                                ZC.Q.I2({ cls: f.L + "-page-area zc-legend-page-area zc-abs", id: f.L + "-page-next-area", wh: Z.AI + "/" + 2 * Z.AI, tl: ZC._i_(h + c.BI - Z.AI) + "/" + ZC._i_(p + Z.BL), opacity: 0, p: _, zidx: 1 })),
                        f.FO &&
                            f.UY &&
                            ("icon" === f.UJ
                                ? ((te = ZC._i_(f.FO.iY + ZC.MAPTX + n.BI) + "/" + ZC._i_(f.FO.iX + f.FO.I - 20 + ZC.MAPTX + n.BL)), (ie = "20/" + f.FO.F))
                                : ((te = ZC._i_(f.FO.iY + ZC.MAPTX) + "/" + ZC._i_(f.FO.iX + ZC.MAPTX)), (ie = f.FO.I - (f.UT ? 23 : 0) + "/" + f.FO.F)),
                            ZC.Q.I2({ cls: f.L + "-header-area zc-legend-header-area zc-abs", id: f.L + "-move-area", wh: ie, tl: te, opacity: 0, p: _, zidx: 1 })),
                        f.UT &&
                            (f.UY && "icon" === f.UJ
                                ? ((te = ZC._i_(f.FO.iY + ZC.MAPTX + t.BI) + "/" + ZC._i_(f.FO.iX + f.FO.I - 41 + ZC.MAPTX + t.BL)), (ie = "20/" + f.FO.F))
                                : ((te = ZC._i_(f.FO.iY + ZC.MAPTX + t.BI) + "/" + ZC._i_(f.FO.iX + f.FO.I - 22 + ZC.MAPTX + t.BL)), (ie = "20/" + f.FO.F)),
                            ZC.Q.I2({ cls: f.L + "-header-area zc-legend-header-area zc-abs", id: f.L + "-minimize-area", wh: ie, tl: te, opacity: 0, p: _, zidx: 1 })),
                        (f.OT = 0),
                        (f.A00 = 0),
                        (f.zc_legend_mouseover = function () {
                            f.YI = !0;
                        }),
                        (f.zc_legend_mouseout = function () {
                            f.YI = !1;
                        }),
                        (f.Z7 = function (e) {
                            if ((e.preventDefault(), f.H.hideCM(), (ZC.move = !0), ZC.mobile || !(e.which > 1))) {
                                f.A.A.D["graph-" + f.A.L + "-legend-info"] = null;
                                var i = ZC.Q.MD(e),
                                    t = ZC.A5("#" + f.A.A.L + "-top").offset();
                                (f.OT = i[0] - t.left - f.FO.iX),
                                    (f.A00 = i[1] - t.top - f.FO.iY),
                                    (f.oldcursor = document.body.style.cursor),
                                    (document.body.style.cursor = "move"),
                                    ZC.A5(document.body).bind(ZC.Q.C1("mousemove"), f.Z6),
                                    ZC.A5(document.body).bind(ZC.Q.C1("mouseup"), f.A0R);
                            }
                        }),
                        (f.Z6 = function (e) {
                            var i = ZC.Q.MD(e),
                                t = ZC.A5("#" + f.A.A.L + "-top").offset(),
                                n = i[0] - t.left - f.OT,
                                a = i[1] - t.top - f.A00;
                            if (
                                (f.PO
                                    ? ((n = ZC.BQ(n, f.H.iX + 2)), (n = ZC.CY(n, f.H.iX + f.H.I - f.I - 2)), (a = ZC.BQ(a, f.H.iY + 2)), (a = ZC.CY(a, f.H.iY + f.H.F - f.F - 4)))
                                    : ((n = ZC.BQ(n, f.A.iX + 2)), (n = ZC.CY(n, f.A.iX + f.A.I - f.I - 2)), (a = ZC.BQ(a, f.A.iY + 2)), (a = ZC.CY(a, f.A.iY + f.A.F - f.F - 4))),
                                f.PO || ((n -= f.A.iX), (a -= f.A.iY)),
                                (f.o.x = n),
                                (f.o.y = a),
                                (f.o.position = null),
                                f.clear(!0),
                                f.parse(),
                                f.paint(),
                                f.FO)
                            ) {
                                var l = f.PO ? f.A.A : f.A;
                                f.A.A.D["legend" + f.A.K + "-xy-ratio"] = [n / l.I, a / (l.F - f.FO.F)];
                            }
                        }),
                        (f.A0R = function () {
                            (ZC.move = !1),
                                (document.body.style.cursor = f.oldcursor),
                                delete f.oldcursor,
                                ZC.A5(document.body).unbind(ZC.Q.C1("mousemove"), f.Z6),
                                ZC.A5(document.body).unbind(ZC.Q.C1("mouseup"), f.A0R),
                                (f.XL = []),
                                f.clear(!1),
                                f.parse(),
                                f.paint(),
                                f.VT();
                        }),
                        (f.Z2 = function (e) {
                            (f.D["default-width"] = null),
                                -1 !== (e.targetid || e.target.id).indexOf("-page-next-area") ? ((f.D4.min += f.EG), (f.D4.max += f.EG), (f.D4.page += 1)) : ((f.D4.min -= f.EG), (f.D4.max -= f.EG), (f.D4.page -= 1)),
                                (!(i = f.A.A.D["graph-" + f.A.L + "-legend-info"]) || (null === ZC._n_(i.x) && null === ZC._n_(i.y))) && ((f.iX = null), (f.iY = null)),
                                f.VT(),
                                f.A.K7();
                        }),
                        (f.XY = function (e) {
                            var i = f.ND ? "legendmaximize" : "legendminimize";
                            e && (f.A.A.D["legend-toggling"] = 1), zingchart.exec(f.A.H.L, i, { graphid: f.A.K }), e && (f.A.A.D["legend-toggling"] = 0), e && (f.A.A.D["g" + f.A.K + "-legend-collapsed"] = "legendminimize" === i);
                        }),
                        (f.MO = function (e) {
                            ZC.move = !0;
                            var i = ZC.Q.MD(e),
                                t = ZC.A5("#" + f.A.A.L + "-top").offset(),
                                n = i[0] - t.left,
                                a = i[1] - t.top;
                            (f.D["dragged-x"] = n), (f.D["dragged-y"] = a), f.VT(), f.clear(!1), f.parse(), f.paint();
                        }),
                        (f.W8 = function (e) {
                            if ((e.preventDefault(), f.H.hideCM(), (f.IP = document.body.style.cursor), (document.body.style.cursor = "move"), ZC.mobile || !(e.which > 1))) {
                                var i = new RegExp("-legend-item_([0-9]+)-area", "g").exec(e.target.id);
                                i &&
                                    ((f.D["dragged-offset-y"] = 0),
                                    (f.D["calculate-y"] = !0),
                                    (f.D["dragged-x"] = 0),
                                    (f.D["dragged-y"] = 0),
                                    (f.N8 = ZC._i_(i[1])),
                                    (f.iDragPos = ZC.AV(f.A.AZ.M3, f.N8)),
                                    ZC.A5(document.body).bind(ZC.Q.C1("mousemove"), f.MO),
                                    ZC.A5(document.body).bind(ZC.Q.C1("mouseup"), f.XI));
                            }
                        }),
                        (f.XI = function () {
                            var e = f.N8,
                                i = f.iDragPos;
                            if (
                                ((f.N8 = -1),
                                (f.iDragPos = -1),
                                (f.D["calculate-y"] = !1),
                                (document.body.style.cursor = f.IP),
                                ZC.move || ((e = -1), (i = -1)),
                                ZC.A5(document.body).unbind(ZC.Q.C1("mousemove"), f.MO),
                                ZC.A5(document.body).unbind(ZC.Q.C1("mouseup"), f.XI),
                                ZC.move && -1 !== e)
                            ) {
                                for (var t = f.A.AZ.A3, n = f.A.AZ.M3, a = 0, l = t.length; a < l; a++)
                                    (t[a].o["legend-item"] = t[a].o["legend-item"] || {}), null === ZC._n_(t[a].o["legend-item"].order) && (t[a].o["legend-item"].order = ZC._i_(t[a].o["z-index"] || a + 1));
                                for (var o = t[e].o["legend-item"].order, r = -1, s = 0, A = f.Q2.length; s < A; s++) f.D["dragged-y"] - f.D["dragged-offset-y"] / 2 > f.Q2[s].iY && (r = s);
                                for (t[e].o["legend-item"].order = -1 === r ? 0.5 : t[n[r]].o["legend-item"].order + 0.5, s = 0, A = f.Q2.length; s < A; s++)
                                    r > i
                                        ? t[s].o["legend-item"].order < t[e].o["legend-item"].order && t[s].o["legend-item"].order > o && t[s].o["legend-item"].order--
                                        : t[s].o["legend-item"].order > t[e].o["legend-item"].order && t[s].o["legend-item"].order < o && t[s].o["legend-item"].order++;
                                for (t[e].o["legend-item"].order = r > i ? Math.floor(t[e].o["legend-item"].order) : Math.ceil(t[e].o["legend-item"].order), s = 0, A = f.Q2.length; s < A; s++)
                                    f.A.o.series[s]["z-index"] = t[s].o["legend-item"].order;
                            }
                            (f.A.AZ.D["plot-sort"] = !0), (ZC.move = !1), f.clear(!1), f.A.K7();
                        }),
                        ZC.A5("#" + f.L + "-frame")
                            .live(ZC.Q.C1("mouseover"), f.zc_legend_mouseover)
                            .live(ZC.Q.C1("mouseout"), f.zc_legend_mouseout),
                        ZC.A5("#" + f.L + "-move-area").live(ZC.Q.C1("mousedown"), f.Z7),
                        ZC.A5("#" + f.L + "-minimize-area").live(ZC.Q.C1("click"), f.XY),
                        ZC.A5("." + f.L + "-page-area").live(ZC.Q.C1("click"), f.Z2),
                        f.BT.o.reorder && ZC.A5("." + f.A.L + "-legend-item-area").live("mousedown", f.W8);
                }
                (f.D.showhide = null),
                    1 === f.A.A.D["legend-toggling"] ||
                        ZC.move ||
                        (((f.M1 && null === ZC._n_(f.A.A.D["g" + f.A.K + "-legend-collapsed"])) || (f.A.A.D["g" + f.A.K + "-legend-collapsed"] && !f.ND)) &&
                            (window.setTimeout(function () {
                                f.XY(!0);
                            }, 0),
                            (f.A.A.D["g" + f.A.K + "-legend-collapsed"] = !0)));
            }
        },
        gc: function () {
            ZC.AP.gc(this, ["B6", "E", "Q2", "Z", "C7", "o", "JE", "I7", "KN", "FO", "BT", "ZK", "H", "A", "A2", "NK", "D4"]);
        },
    };
    ZC.V6 = ZC.DN.CC(V6);
    var A7V = {
        $i: function (e) {
            this.b(e);
            var i = this;
            (i.MX = null), (i.BB = null), (i.M = null), (i.JS = 0), (i.BG = null), (i.GD = "bottom"), (i.L0 = 40), (i.A38 = [2, 4]);
        },
        parse: function () {
            var e,
                i,
                t,
                n = this;
            (n.assign_a([
                ["z-index", "JS", "i"],
                ["length", "L0", "i"],
                ["aspect", "A38"],
                ["direction", "GD"],
            ]),
            null === ZC._n_(n.o.from) && null === ZC._n_(n.o.to)) &&
                null !== ZC._n_(n.o.x) &&
                null !== ZC._n_(n.o.y) &&
                null !== ZC._n_(n.o.length) &&
                null !== ZC._n_(n.o.angle) &&
                ((i = "string" == typeof n.o.x ? n.A.UU(n.o.x)[0] : ZC._i_(n.o.x)),
                (t = "string" == typeof n.o.y ? n.A.UU(n.o.y)[1] : ZC._i_(n.o.y)),
                (n.o.from = { x: i + n.L0 * ZC.EP(n.AA + 180), y: t + n.L0 * ZC.EH(n.AA + 180) }),
                (n.o.to = { x: i + n.L0 * ZC.EP(n.AA), y: t + n.L0 * ZC.EH(n.AA) }));
            null !== ZC._n_((e = n.o.from)) && ((n.MX = new ZC.DU(n.A)), n.MX.append(e), null !== e.hook && (n.MX.D.hook = e.hook), n.MX.parse(), "string" == typeof e && (n.MX.D.hook = e)),
                null !== ZC._n_((e = n.o.to)) && ((n.BB = new ZC.DU(n.A)), n.BB.append(e), null !== e.hook && (n.BB.D.hook = e.hook), n.BB.parse(), "string" == typeof e && (n.BB.D.hook = e)),
                (null !== ZC._n_((e = n.o.label)) || ("" !== n.o.text && "undefined" != typeof n.o.text)) && ((n.M = new ZC.DN(n)), n.M.append(n.o), n.M.append(e), n.M.parse()),
                n.b();
        },
        paint: function () {
            var e,
                i,
                t = this;
            if (t.AN && (null !== t.MX || null !== t.BB))
                if (
                    (t.AI < 1 && (t.AI = 1),
                    !t.MX ||
                        null === ZC._n_((e = t.MX.D.hook)) ||
                        ((i = t.A.UU(e)), (t.MX.iX = i[0]), (t.MX.iY = i[1]), (t.MX.iX += t.MX.BL), (t.MX.iY += t.MX.BI), ZC.DT(t.MX.iX, t.A.P.iX - 2, t.A.P.iX + t.A.P.I + 2) && ZC.DT(t.MX.iY, t.A.P.iY - 2, t.A.P.iY + t.A.P.F + 2)))
                )
                    if (
                        !t.BB ||
                        null === ZC._n_((e = t.BB.D.hook)) ||
                        ((i = t.A.UU(e)), (t.BB.iX = i[0]), (t.BB.iY = i[1]), (t.BB.iX += t.BB.BL), (t.BB.iY += t.BB.BI), ZC.DT(t.BB.iX, t.A.P.iX - 2, t.A.P.iX + t.A.P.I + 2) && ZC.DT(t.BB.iY, t.A.P.iY - 2, t.A.P.iY + t.A.P.F + 2))
                    ) {
                        var n, a;
                        if (t.MX && t.BB) (n = [t.MX.iX, t.MX.iY]), (a = [t.BB.iX, t.BB.iY]);
                        else if (t.MX && !t.BB)
                            switch (((n = [t.MX.iX, t.MX.iY]), t.GD)) {
                                case "top":
                                    a = [t.MX.iX, t.MX.iY + t.L0];
                                    break;
                                case "right":
                                    a = [t.MX.iX + t.L0, t.MX.iY];
                                    break;
                                case "bottom":
                                    a = [t.MX.iX, t.MX.iY - t.L0];
                                    break;
                                case "left":
                                    a = [t.MX.iX - t.L0, t.MX.iY];
                            }
                        else if (!t.MX && t.BB)
                            switch (((a = [t.BB.iX, t.BB.iY]), t.GD)) {
                                case "top":
                                    n = [t.BB.iX, t.BB.iY + t.L0];
                                    break;
                                case "right":
                                    n = [t.BB.iX - t.L0, t.BB.iY];
                                    break;
                                case "bottom":
                                    n = [t.BB.iX, t.BB.iY - t.L0];
                                    break;
                                case "left":
                                    n = [t.BB.iX + t.L0, t.BB.iY];
                            }
                        var l,
                            o = a[0] - n[0],
                            r = a[1] - n[1],
                            s = ZC.TN(Math.atan2(r, o)),
                            A = Math.sqrt(o * o + r * r),
                            C = [];
                        if (
                            (C.push(n),
                            (l = ZC.AQ.BN(n[0], n[1], t.AI / 2, s + 90)),
                            C.push(l),
                            (l = ZC.AQ.BN(l[0], l[1], A - (t.A38[1] * t.AI) / 2, s)),
                            C.push(l),
                            (l = ZC.AQ.BN(l[0], l[1], (t.A38[0] * t.AI) / 2, s + 90)),
                            C.push(l),
                            C.push(a),
                            (l = ZC.AQ.BN(l[0], l[1], ((2 * t.A38[0] + 2) * t.AI) / 2, s - 90)),
                            C.push(l),
                            (l = ZC.AQ.BN(l[0], l[1], (t.A38[0] * t.AI) / 2, s + 90)),
                            C.push(l),
                            (l = ZC.AQ.BN(n[0], n[1], t.AI / 2, s - 90)),
                            C.push(l),
                            C.push(n),
                            (t.BG = new ZC.DU(t.A)),
                            (t.BG.L = t.L),
                            (t.BG.Z = t.BG.C7 = t.Z),
                            t.BG.copy(t),
                            (t.BG.E = C),
                            (t.BG.CZ = !1),
                            t.BG.parse(),
                            t.BG.paint(),
                            null !== t.M && t.M.AN)
                        ) {
                            (t.M.Z = t.Z), (t.M.L = t.A.L + "-arrow-label-" + t.H8), (t.M.GL = t.A.L + "-arrow-label zc-arrow-label");
                            var c = ZC.AQ.JW(n[0], n[1], a[0], a[1]);
                            (t.M.iX = c[0]), (t.M.iY = c[1]), (t.M.BL -= t.M.I / 2), (t.M.BI -= t.M.F / 2), null !== ZC._n_(t.M.o["font-angle"]) && "inherit" === t.M.o["font-angle"] && (t.M.AA = s), t.M.paint(), t.M.EL();
                        }
                    } else t.AN = !1;
                else t.AN = !1;
        },
    };
    ZC.A7V = ZC.DU.CC(A7V);
    var JR = {
        $i: function (e) {
            var i = this;
            (i.H = e), (i.S4 = !1), (i.C4 = null), (i.YZ = null), (i.QB = null), (i.zc_guide_touchend = null);
        },
        unbind: function () {
            var e = this;
            e.C4 && window.clearInterval(e.C4), e.YZ && window.clearInterval(e.YZ), ZC.A5(document.body).unbind("mousemove touchstart touchmove", e.QB), ZC.A5(document.body).unbind("touchend", e.zc_guide_touchend);
        },
        bind: function () {
            var e,
                i = this,
                t = i.H.L,
                n = ZC.AL(t + "-guide-c"),
                a = ZC.Q.EB(n, i.H.AC),
                l = {},
                o = {},
                r = {},
                s = {},
                A = null,
                C = null,
                c = null;
            function u() {
                !C && c && (c.D["guide-active-plot"] = null), ZC.JR.GUIDES && ZC.JR.GUIDES[t] && !ZC.JR.GUIDES[t].blocked && ZC.JR.clearGuide(t), (C = null);
            }
            ZC.mobile ||
                null !== ZC._n_(ZC.YZ) ||
                (i.YZ = window.setInterval(function () {
                    for (var e = !0, n = 0, a = zingchart.HZ.length; n < a; n++)
                        if (t === zingchart.HZ[n].L)
                            if (ZC.AL(zingchart.HZ[n].L + "-top")) {
                                var l = ZC._tx_(t),
                                    o = ZC.A5("#" + zingchart.HZ[n].L + "-top").offset();
                                ZC.E1[0] >= o.left && ZC.E1[0] <= o.left + zingchart.HZ[n].I * l[0] && ZC.E1[1] >= o.top && ZC.E1[1] <= o.top + zingchart.HZ[n].F * l[1] && (e = !1);
                            } else window.clearInterval(i.YZ);
                    e && (u(), ZC.JR.GUIDES && ZC.JR.GUIDES[t] && ZC.JR.GUIDES[t].active && (ZC.AP.C0("guide_mouseout", i.H, i.H.FG()), (ZC.JR.GUIDES[t].active = !1)));
                }, 500)),
                (i.QB = function (p) {
                    if (((zingchart.GUIDE_EV = p), !p.target.id || -1 === p.target.id.indexOf("-menu-item-"))) {
                        var Z, h, d, f, _, g, v, b, B, m, D, E, L, F, I, x, y, w, Y, X, M, K, S, P, H, N, G;
                        ZC.MAX, ZC.MAX;
                        for (Z = 0; Z < zingchart.HZ.length; Z++) if (zingchart.HZ[Z].L !== i.H.L && -1 !== zingchart.HZ[Z].L.indexOf("-fullscreen")) return;
                        if ((ZC.ie67 || "mousemove" !== p.type || !ZC.TOUCHEVENTS) && -1 !== p.target.id.indexOf(i.H.L + "-") && (!ZC.move || ZC.mobile)) {
                            if (i.H.ZV || !ZC.AL(t + "-top")) return !1;
                            if (!ZC.Q.AAZ(ZC.AL(t + "-top"))) return !1;
                            var O = [],
                                k = ZC.Q.MD(p),
                                T = k[0],
                                z = k[1];
                            if ((null !== ZC._n_(p._pageX_) && (T = p._pageX_), null !== ZC._n_(p._pageY_) && (z = p._pageY_), null === ZC._n_(p._pageX_) && null === ZC._n_(p._pageY_))) {
                                var Q = ZC.A5("#" + t + "-top").offset();
                                (d = T - Q.left), (f = z - Q.top);
                            } else (d = T), (f = z);
                            var V = ZC._tx_(i.H.L);
                            for (d /= V[0], f /= V[1], Z = 0, h = i.H.AG.length; Z < h; Z++)
                                (_ = i.H.AG[Z].P),
                                    ZC.DT(d, _.iX - 15, _.iX + _.I + 15) && ZC.DT(f, _.iY - 15, _.iY + _.F + 15) && (C = i.H.AG[Z]),
                                    ZC.DT(d, i.H.AG[Z].iX, i.H.AG[Z].iX + i.H.AG[Z].I) && ZC.DT(f, i.H.AG[Z].iY, i.H.AG[Z].iY + i.H.AG[Z].F) && (A = i.H.AG[Z]);
                            var J = null,
                                R = !1;
                            if (C) {
                                if (
                                    ((ZC.JR.GUIDES = ZC.JR.GUIDES || {}), (ZC.JR.GUIDES[t] = ZC.JR.GUIDES[t] || {}), p.fromAPI || ((ZC.JR.GUIDES[t].blocked = !1), (ZC.JR.GUIDES[t].active = !0)), (c = C), C.CX && "hover" === C.CX.o.trigger)
                                ) {
                                    null !== ZC._n_(C.D["guide-active-plot"]) && (J = C.D["guide-active-plot"]);
                                    var W = /(.+)-plotset-plot-(.+)-node-(.+)/.exec(p.target.id);
                                    if ((W && W.length && ((J = parseInt(W[2], 10)), (C.D["guide-active-plot"] = J)), null === ZC._n_(J))) return;
                                }
                                if (!C.A1N) return void u();
                                for (O.push(C), C && C.CX && (R = null !== ZC._n_(C.CX.o.shared) && ZC._b_(C.CX.o.shared)), Z = 0, h = i.H.AG.length; Z < h; Z++)
                                    if (i.H.AG[Z] !== C) {
                                        _ = i.H.AG[Z].P;
                                        var U = i.H.AG[Z].CX,
                                            j = i.H.AG[Z].HB,
                                            q = U && null !== ZC._n_(U.o.shared) && ZC._b_(U.o.shared);
                                        q &&
                                            (("xy" === C.AJ.layout && "xy" === i.H.AG[Z].AJ.layout && (U || j) && ZC.DT(d, _.iX - 5, _.iX + _.I + 5) && (ZC.DT(f, _.iY - 5, _.iY + _.F + 5) || (R && q))) ||
                                                ("yx" === C.AJ.layout && "yx" === i.H.AG[Z].AJ.layout && (U || j) && ZC.DT(f, _.iY - 5, _.iY + _.F + 5) && (ZC.DT(d, _.iX - 5, _.iX + _.I + 5) || (R && q)))) &&
                                            O.push(i.H.AG[Z]);
                                    }
                            } else if (ZC.JR.GUIDES)
                                for (var $ in ZC.JR.GUIDES)
                                    if (ZC.JR.GUIDES[$] && ZC.JR.GUIDES[$].active) {
                                        var ee = zingchart.getLoader($);
                                        (H = ee.FG()), ZC.AP.C0("guide_mouseout", ee, H), (ZC.JR.GUIDES[$].active = !1);
                                    }
                            if ((0 === O.length && ((l = {}), (o = {}), (r = {}), i.S4 && (null === ZC._n_(p._pageX_) && u(), (i.S4 = !1)), c && c.A.A7 && A && A.L !== c.L && c.A.A7.hide()), O.length > 0)) {
                                i.S4 = !0;
                                for (var ie = !1, te = 0, ne = O.length; te < ne; te++) {
                                    var ae = !1;
                                    if ((null === ZC._n_(l[te]) && (l[te] = {}), null === ZC._n_(o[te]) && (o[te] = {}), null === ZC._n_(r[te]) && (r[te] = {}), (O[te].CX || O[te].HB) && "ready" === O[te].MF)) {
                                        var le,
                                            oe = [],
                                            re = [],
                                            se = [],
                                            Ae = !1,
                                            Ce = "",
                                            ce = [],
                                            ue = [],
                                            pe = [],
                                            Ze = [],
                                            he = {},
                                            de = {},
                                            fe = [];
                                        _ = O[te].P;
                                        var _e = O[te].CX && null !== ZC._n_(O[te].CX.o.exact) && ZC._b_(O[te].CX.o.exact),
                                            ge = -1;
                                        O[te].CX && (ge = ZC._i_(ZC._c_(O[te].CX.o.tolerance || -1))), (F = [-1, ZC.MAX]), (I = [-1, ZC.MAX]), ZC.MAX, ZC.MAX;
                                        var ve,
                                            be,
                                            Be = !0,
                                            me = [],
                                            De = "";
                                        O[te].CX &&
                                            (null !== ZC._n_(O[te].CX.o["plot-label"]) && ZC._n_(null !== (e = O[te].CX.o["plot-label"].multiple)) && (Be = ZC._b_(e)),
                                            null !== ZC._n_(O[te].CX.o["value-label"]) && ZC._n_(null !== (e = O[te].CX.o["value-label"].multiple)) && (Be = ZC._b_(e)));
                                        var Ee = {};
                                        for (K = 0, S = O[te].AZ.A3.length; K < S; K++)
                                            if (!O[te].AZ.A3[K].LN && ((Z = K), O[te].CX && O[te].CX.o["reverse-series"] && (Z = S - K - 1), O[te].D["plot" + Z + ".visible"])) {
                                                if (null !== ZC._n_(J) && Z !== J) continue;
                                                if (!(ve = O[te].BM(O[te].AZ.A3[Z].BW("k")[0]))) continue;
                                                if (ve.CK) {
                                                    var Le = ve.AW ? ve.iY + ve.BR : ve.iY + ve.A9,
                                                        Fe = ve.AW ? ve.iY + ve.F - ve.BR : ve.iY + ve.F - ve.A9;
                                                    (f = ZC._l_(f, Le, Fe)), (g = ve.EF && O[te].AZ.A3[Z].EF ? ve.OG(f, O[te].AZ.A3[Z]) : ve.OG(f));
                                                } else {
                                                    var Ie = ve.AW ? ve.iX + ve.BR : ve.iX + ve.A9,
                                                        xe = ve.AW ? ve.iX + ve.I - ve.A9 : ve.iX + ve.I - ve.BR;
                                                    (d = ZC._l_(d, Ie, xe)), (g = ve.EF && O[te].AZ.A3[Z].EF ? ve.OG(d, O[te].AZ.A3[Z]) : ve.OG(d));
                                                }
                                                if (null === ZC._n_(g)) continue;
                                                var ye,
                                                    we,
                                                    Ye,
                                                    Xe,
                                                    Me,
                                                    Ke,
                                                    Se,
                                                    Pe,
                                                    He = [];
                                                if (((He = "undefined" == typeof g.length || 0 === g.length ? [g] : g), O[te].CX)) {
                                                    for (var Ne = 0, Ge = He.length; Ne < Ge; Ne++)
                                                        if (((g = He[Ne]), (v = O[te].AZ.A3[Z].FK(g)))) {
                                                            (le = v),
                                                                v.setup(),
                                                                v.O ? ((ZC.COLORS = [v.O.C2, v.O.A0, v.O.AE, v.O.BX, v.O.B7]), v.L2 && ZC.COLORS.push(v.L2.A0, v.L2.AE, v.L2.BX, v.L2.B7)) : (ZC.COLORS = []),
                                                                v.A.I3 && "undefined" != typeof v.D.A5P && v.paint(!0),
                                                                (x = v.iX),
                                                                (y = v.iY),
                                                                "undefined" != typeof v.D.A5P && (x = parseInt(v.D.A5P, 10)),
                                                                "undefined" != typeof v.D.A7T && (y = parseInt(v.D.A7T, 10)),
                                                                (E = x),
                                                                (L = y),
                                                                (he[Z] = { index: g, y: y }),
                                                                O[te].BE && O[te].BE.XT && (O[te].BE.clear(!0), O[te].BE.parse(), O[te].BE.paint(g)),
                                                                ((b = new ZC.DN(ve)).Z = b.C7 = n),
                                                                (b.L = O[te].L + "-guide-label-" + g + "-" + Z),
                                                                (b.GL = O[te].A.L + "-guide-label " + O[te].L + "-guide-label zc-guide-label"),
                                                                Be && ((M = v.A7R()), (b.AM = v.A.J7)),
                                                                Be ? b.append(O[te].CX.o["plot-label[multiple]"]) : b.append(O[te].CX.o["plot-label[single]"]),
                                                                b.append(O[te].CX.o["plot-label"]),
                                                                b.append(O[te].CX.o["value-label"]),
                                                                b.append(O[te].AZ.A3[Z].o["guide-label"]),
                                                                (D = ZC.AP.O2(b.o, O[te].AZ.A3[Z].o)),
                                                                (b.JT = function (e) {
                                                                    return v ? v.JT(e, D) : e;
                                                                }),
                                                                v.AAY();
                                                            var Oe = "auto";
                                                            if (
                                                                (null !== ZC._n_((e = b.o.placement)) && (Oe = e),
                                                                (b.D.placement = Oe),
                                                                (b.KU = Be),
                                                                (b.D.plotidx = v.A.K),
                                                                (b.D.nodeidx = v.K),
                                                                b.parse(),
                                                                (P = null !== ZC._n_(b.o.distance) ? ZC._i_(b.o.distance) : 6),
                                                                b.E7 &&
                                                                    b.E7.length &&
                                                                    ((b.J5 = function (e) {
                                                                        return (e = v ? v.JT(e, D) : e.replace(/(%i)|(%node-index)/g, g));
                                                                    }),
                                                                    b.DE() && ((D = b.overrideFormat(D)), b.parse())),
                                                                b.HT && v && (b.H3(b, b, null, v.LZ(null, !1), b.MJ), b.parse()),
                                                                ZC.DT(v.iX, _.iX - 0.5, _.iX + _.I + 0.5))
                                                            ) {
                                                                switch (
                                                                    (Be ||
                                                                        (0 === re.length &&
                                                                            (null === ZC._n_(b.o["header-text"]) || Ae || ((Ae = !0), (De += v.JT(b.o["header-text"], D) + "<br>")),
                                                                            null !== ZC._n_(b.o["footer-text"]) && "" === Ce && (Ce = v.JT(b.o["footer-text"], D) + "<br>")),
                                                                        b.AN && "" !== b.AM && (ZC._b_(b.o["single-text"]) ? me.push(v.JT(b.AM, D)) : me.push(v.JT(b.AM, D) + "<br>"))),
                                                                    (b.D.pos = re.length),
                                                                    (b.D["node-value"] = v.AD),
                                                                    (b.D["marker-x"] = x),
                                                                    (b.D["marker-y"] = y),
                                                                    (b.D["guide-style"] = v.A7R()),
                                                                    Oe)
                                                                ) {
                                                                    default:
                                                                        null === ZC._n_(b.o.x)
                                                                            ? ve.CK
                                                                                ? v.iY <= _.iY + _.F / 2
                                                                                    ? ((b.iY = y - b.F - P), (b.EM = "bottom"))
                                                                                    : ((b.iY = y + P), (b.EM = "top"))
                                                                                : v.iX >= _.iX + _.I / 2
                                                                                ? ((b.iX = x - b.I - P), (b.EM = "right"))
                                                                                : ((b.iX = x + P), (b.EM = "left"))
                                                                            : (b.iX -= _.iX),
                                                                            null === ZC._n_(b.o.y)
                                                                                ? ve.CK
                                                                                    ? ((b.iX = x - b.I / 2), b.iX < _.iX && (b.iX = _.iX), b.iX + b.I > _.iX + _.I && (b.iX = _.iX + _.I - b.I))
                                                                                    : ((b.iY = y - b.F / 2), b.iY < _.iY && (b.iY = _.iY), b.iY + b.F > _.iY + _.F && (b.iY = _.iY + _.F - b.F))
                                                                                : (b.iY -= _.iY),
                                                                            (b.DM = [x, y]);
                                                                        break;
                                                                    case "left":
                                                                        (b.iX = x - b.I - P), (b.iY = y - b.F / 2), (b.DM = [x, y]);
                                                                        break;
                                                                    case "right":
                                                                        (b.iX = x + P), (b.iY = y - b.F / 2), (b.DM = [x, y]);
                                                                        break;
                                                                    case "top":
                                                                        ve.CK
                                                                            ? ((b.iX = _.iX + _.I - b.I), (b.iY = y - b.F / 2), (b.EM = "left"), (b.DM = [_.iX + _.I - b.I - P, y]))
                                                                            : ((b.iX = x - b.I / 2), (b.iY = _.iY), (b.EM = "bottom"), (b.DM = [x, b.iY + b.F + P]));
                                                                        break;
                                                                    case "node-top":
                                                                        ve.CK
                                                                            ? ((b.iX = x + 2 * P), (b.iY = y - b.F / 2), (b.EM = "left"), (b.DM = [x + P, y]))
                                                                            : ((b.iX = x - b.I / 2), (b.iY = y - b.F - 2 * P), (b.EM = "bottom"), (b.DM = [x, y - P]));
                                                                        break;
                                                                    case "bottom":
                                                                        ve.CK
                                                                            ? ((b.iX = _.iX), (b.iY = y - b.F / 2), (b.EM = "right"), (b.DM = [_.iX + b.I + P, y]))
                                                                            : ((b.iX = x - b.I / 2), (b.iY = _.iY + _.F - b.F), (b.EM = "top"), (b.DM = [x, b.iY - P]));
                                                                }
                                                                oe.push({ plotindex: v.A.K, nodeindex: v.K, keyvalue: v.BV || ve.V[v.K], value: v.AD, text: b.AM, x: b.iX, y: b.iY, refx: x, refy: y }),
                                                                    -1 === ZC.AV(se, b.AM) && ((s[b] = v), se.push(b.AM)),
                                                                    ve.CK ? (b.D.diff = _e || -1 !== ge ? ZC._a_(y - f) : -1) : (b.D.diff = _e || -1 !== ge ? ZC._a_(x - d) : -1),
                                                                    b.AN && re.push(b),
                                                                    (o[te][Z] = b),
                                                                    (ae = !0);
                                                            }
                                                        }
                                                    if (!v) continue;
                                                }
                                                if (O[te].CX && ZC.DT(v.iX, _.iX - 1, _.iX + _.I + 1)) {
                                                    if (
                                                        (((m = new ZC.DN(ve)).Z = m.C7 = n),
                                                        (m.L = O[te].L + "-guide-scale-x-label-" + Z),
                                                        (m.GL = O[te].A.L + "-guide-label " + O[te].L + "-guide-label zc-guide-label"),
                                                        (m.A0 = m.AE = ve.B7),
                                                        (m.C2 = O[te].AJ["3d"] ? "#999" : "#fff"),
                                                        m.append(O[te].CX.o["scale-label"]),
                                                        m.append(O[te].CX.o[ve.BF + "-label"]),
                                                        m.append(O[te].AZ.A3[Z].o["scale-label"]),
                                                        (m.KU = !0),
                                                        (m.D.nodeidx = v.K),
                                                        (D = ZC.AP.O2(m.o)),
                                                        null === ZC._n_(D.decimals))
                                                    ) {
                                                        var ke = Math.floor(ZC.FV(null !== v.BV ? v.BV : v.K, 10));
                                                        D.decimals = ke < 0 ? 1 - ke : 0;
                                                    }
                                                    if (
                                                        ((m.JT = function (e) {
                                                            e = ve.JT(e, g, ve.EF && O[te].AZ.A3[Z].EF ? O[te].AZ.A3[Z] : null, D, !0);
                                                            var i = O[te].AZ.A3[Z].K0;
                                                            if (v && i)
                                                                for (var t in i) {
                                                                    var n;
                                                                    (n = i[t] instanceof Array ? ZC._c_(i[t][v.K], "") : ZC._c_(i[t], "")), (e = e.replace("%data-" + t, n, "g"));
                                                                }
                                                            return e;
                                                        }),
                                                        m.parse(),
                                                        (P = null !== ZC._n_(m.o.distance) ? ZC._i_(m.o.distance) : 6),
                                                        m.E7 &&
                                                            m.E7.length &&
                                                            ((m.J5 = function (e) {
                                                                return (e = v ? v.JT(e, D) : e.replace(/(%i)|(%node-index)/g, g));
                                                            }),
                                                            m.DE() && m.parse()),
                                                        m.HT && v && (m.H3(m, m, null, v.LZ(null, !1), m.MJ), m.parse()),
                                                        (de[ve.BF] = m.AM),
                                                        (ye = ZC._b_(m.o["callout-position"])),
                                                        (we = m.o.x),
                                                        (Ye = m.o.y),
                                                        "opposite" !== ve.BA
                                                            ? ve.CK
                                                                ? ((Xe = "right"), (Ke = ve.D.iX - m.I - P), (Me = [ve.D.iX, L]), (Se = L - m.F / 2))
                                                                : ((Xe = "top"), (Ke = E - m.I / 2), (Me = [E, ve.D.iY]), (Se = ve.D.iY + P))
                                                            : ve.CK
                                                            ? ((Xe = "left"), (Ke = ve.D.iX + P), (Me = [ve.D.iX, L]), (Se = L - m.F / 2))
                                                            : ((Xe = "bottom"), (Ke = E - m.I / 2), (Me = [E, ve.D.iY]), (Se = ve.D.iY - m.F - P)),
                                                        ye || (m.EM = Xe),
                                                        we || (m.iX = Ke),
                                                        ye || we || Ye || (m.DM = Me),
                                                        Ye || (m.iY = Se),
                                                        m.AN && ve.AN && "" !== m.AM)
                                                    ) {
                                                        var Te = !1;
                                                        if (fe.length) for (var ze = 0; ze < fe.length; ze++) m.AM + "@" + ve.BF === fe[ze] && (Te = !0);
                                                        Te || (fe.push(m.AM + "@" + ve.BF), ve.CK ? (m.D.diff = _e || -1 !== ge ? ZC._a_(L - f) : -1) : (m.D.diff = _e || -1 !== ge ? ZC._a_(E - d) : -1), pe.push(m)),
                                                            Ze.push(ve.BF),
                                                            (r[te][Z] = m),
                                                            (ae = !0);
                                                    }
                                                    -1 !== String(O[te].CX.o["line-width"]).indexOf("%") && (Pe = ZC.IJ(O[te].CX.o["line-width"])) > 0 && Pe <= 1 && (O[te].CX.B0 = ZC._i_(Pe * ve.AB)),
                                                        ve.CK
                                                            ? ((-1 === I[0] || I[1] > ZC._a_(L - f)) && (I = [L, ZC._a_(L - f)]),
                                                              ce.push([_e || -1 !== ge ? ZC._a_(L - f) : -1, [null, [ve.D.iX, L], [O[te].P.iX + ("opposite" === ve.BA ? 0 : O[te].P.I), L]]]))
                                                            : ((-1 === F[0] || F[1] > ZC._a_(E - d)) && (F = [E, ZC._a_(E - d)]),
                                                              ce.push([_e || -1 !== ge ? ZC._a_(E - d) : -1, [null, [E, ve.D.iY], [E, O[te].P.iY + ("opposite" === ve.BA ? O[te].P.F : 0)]]]));
                                                }
                                                if (
                                                    ((be = O[te].BM(O[te].AZ.A3[Z].BW("v")[0])),
                                                    -1 === ZC.AV(Ze, be.BF) && O[te].HB && (("xy" === O[te].AJ.layout && ZC.DT(f, be.iY, be.iY + be.F)) || ("yx" === O[te].AJ.layout && ZC.DT(f, be.iX, be.iX + be.I))))
                                                ) {
                                                    var Qe = "single";
                                                    O[te].HB.o.type && "multiple" === O[te].HB.o.type && (Qe = "multiple"),
                                                        "multiple" === Qe && null !== ZC._n_(he[Z]) && (be.CK ? (d = he[Z].x) : (f = he[Z].y)),
                                                        ((m = new ZC.DN(be)).Z = m.C7 = n),
                                                        (m.L = O[te].L + "-guide-scale-y-label-" + Z),
                                                        (m.GL = O[te].A.L + "-guide-label " + O[te].L + "-guide-label zc-guide-label");
                                                    var Ve = be.B7;
                                                    "multiple" === Qe && (Ve = O[te].AZ.A3[Z].B7),
                                                        (m.A0 = m.AE = Ve),
                                                        (m.C2 = O[te].AJ["3d"] && "multiple" !== Qe ? "#999" : "#fff"),
                                                        m.append(O[te].HB.o["scale-label"]),
                                                        m.append(O[te].HB.o[be.BF + "-label"]),
                                                        (m.KU = !0);
                                                    var Je = be.CK ? be.NE(d, !0) : be.NE(f, !0),
                                                        Re = Je;
                                                    if (((D = be.MS()), ZC._cp_(ZC.AP.O2(m.o, be.o), D), null === ZC._n_(D.decimals))) {
                                                        ke = Math.floor(ZC.FV(Je, 10));
                                                        D.decimals = ke <= 0 ? 1 - ke : 0;
                                                    }
                                                    (Je = be.FQ(0, Je, D)),
                                                        (m.o.text = Je),
                                                        m.parse(),
                                                        (P = null !== ZC._n_(m.o.distance) ? ZC._i_(m.o.distance) : 6),
                                                        m.E7 &&
                                                            m.E7.length &&
                                                            ((m.J5 = function (e) {
                                                                return (e = e
                                                                    .replace(/(%v)|(%scale-value)/g, Re)
                                                                    .replace(/(%t)|(%scale-text)/g, Je)
                                                                    .replace(/(%coord)/, be.CK ? d : f));
                                                            }),
                                                            m.DE() && m.parse()),
                                                        m.HT && v && ((Ee = { value: Re, text: Je, coord: be.CK ? d : f }), m.H3(m, m, null, Ee, m.MJ), m.parse()),
                                                        (de[be.BF] = m.AM),
                                                        (ye = ZC._b_(m.o["callout-position"])),
                                                        (we = m.o.x),
                                                        (Ye = m.o.y),
                                                        "opposite" !== be.BA
                                                            ? be.CK
                                                                ? ((Xe = "top"), (Ke = d - m.I / 2), (Se = be.D.iY + P), (Me = [d, be.D.iY]))
                                                                : ((Xe = "right"), (Ke = be.D.iX - m.I - P), (Se = f - m.F / 2), (Me = [be.D.iX, f]))
                                                            : be.CK
                                                            ? ((Xe = "bottom"), (Ke = d - m.I / 2), (Se = be.D.iY - m.F - P), (Me = [d, be.D.iY]))
                                                            : ((Xe = "left"), (Ke = be.D.iX + P), (Se = f - m.F / 2), (Me = [be.D.iX, f])),
                                                        ye || (m.EM = Xe),
                                                        we || (m.iX = Ke),
                                                        ye || we || Ye || (m.DM = Me),
                                                        Ye || (m.iY = Se),
                                                        m.AN && be.AN && ((m.D.diff = -1), pe.push(m), ("multiple" === Qe && null !== ZC._n_(he[Z])) || Ze.push(be.BF), (r[te][Z] = m), (ae = !0)),
                                                        -1 !== String(O[te].HB.o["line-width"]).indexOf("%") && (Pe = ZC.IJ(O[te].HB.o["line-width"])) > 0 && Pe <= 1 && (O[te].HB.B0 = ZC._i_(Pe * be.AB)),
                                                        be.CK ? ue.push(null, [d, be.D.iY], [d, O[te].P.iY + ("opposite" === be.BA ? O[te].P.F : 0)]) : ue.push(null, [be.D.iX, f], [O[te].P.iX + ("opposite" === be.BA ? 0 : O[te].P.I), f]);
                                                }
                                            }
                                        if (!_e && pe.length > 1)
                                            for (var We = pe[pe.length - 1], Ue = ZC._i_((We.FM + We.FT + We.EQ + We.FN) / 4), je = pe.length - 1; je >= 0; je--)
                                                for (var qe = je; qe >= 0; qe--) je !== qe && ZC.AQ._boxoverlap2_(pe[je], pe[qe], -Ue) && ((pe[qe].C6 = 0.3), (pe[qe].UV = 0.1));
                                        for (B = ZC.MAX, Z = 0, h = re.length; Z < h; Z++) re[Z].D.diff >= 0 && (B = ZC.CY(re[Z].D.diff, B));
                                        -1 !== ge && (B = ZC.BQ(B, ge));
                                        var $e = !1,
                                            ei = 1,
                                            ii = !1;
                                        re[0] &&
                                            ((ii = ZC._b_(re[0].o["single-text"])),
                                            re[0].o["table-columns"] &&
                                                ZC._b_(re[0].o["html-mode"]) &&
                                                (($e = !0), (ei = ZC._i_(re[0].o["table-columns"] || "1")), (De += '<table class="zc-guide-label-table ' + i.H.L + '-guide-label-table">'))),
                                            !Be &&
                                                re.length > 0 &&
                                                (("asc" !== re[0].o["sort-by-value"] && "desc" !== re[0].o["sort-by-value"]) ||
                                                    re.sort(function (e, i) {
                                                        return (e.D["node-value"] - i.D["node-value"]) * ("asc" === re[0].o["sort-by-value"] ? 1 : -1);
                                                    }));
                                        var ti = 0;
                                        for (
                                            N = 0, G = re.length;
                                            N < G &&
                                            (!(-1 === re[N].D.diff || re[N].D.diff <= B) ||
                                                ($e ? (ti % ei == 0 && (De += "<tr>"), (De += "<td>" + me[N] + "</td>"), ti % ei == ei - 1 && (De += "</tr>"), ti++) : (De += me[re[N].D.pos]), $e || !ii));
                                            N++
                                        );
                                        if (
                                            ($e && (ti % ei != ei - 1 && (De += "</tr>"), (De += "</table>")),
                                            "" !== Ce && (De += Ce),
                                            !Be &&
                                                re.length > 0 &&
                                                (_e ? (ve.CK ? ((d = x = E), (f = y = I[0])) : ((d = x = F[0]), (f = y = L))) : ((d = x = E), (f = y = L)),
                                                "" !== De && ((re[0].o.text = $e || ii ? De : De.substring(0, De.length - 4)), re[0].parse()),
                                                (P = null !== ZC._n_(b.o.distance) ? ZC._i_(b.o.distance) : 6),
                                                null === ZC._n_(b.o.x)
                                                    ? ve.CK
                                                        ? d < O[te].iX + O[te].I / 2
                                                            ? (re[0].iX = d + P + 14)
                                                            : (re[0].iX = d - re[0].I - P - 14)
                                                        : le && le.iX >= _.iX + _.I / 2
                                                        ? (re[0].iX = x - re[0].I - P)
                                                        : (re[0].iX = x + P)
                                                    : (re[0].iX -= _.iX),
                                                null === ZC._n_(b.o.y)
                                                    ? ve.CK
                                                        ? le && le.iY >= _.iY + _.F / 2
                                                            ? (re[0].iY = y - re[0].F - P)
                                                            : (re[0].iY = y + P)
                                                        : f < O[te].iY + O[te].F / 2
                                                        ? (re[0].iY = f + P + 14)
                                                        : (re[0].iY = f - re[0].F - P - 14)
                                                    : (re[0].iY -= _.iY)),
                                            ae)
                                        ) {
                                            var ni = -1,
                                                ai = -1;
                                            if ((ie || (null === ZC._n_(p._pageX_) && u(), (ie = !0)), ce.length > 0)) {
                                                var li = [];
                                                for (B = ZC.MAX, w = 0, Y = ce.length; w < Y; w++) ce[w][0] >= 0 && (B = ZC.CY(ce[w][0], B));
                                                for (-1 !== ge && (B = ZC.BQ(B, ge)), w = 0, Y = ce.length; w < Y; w++)
                                                    null !== ZC._n_(ce[w]) &&
                                                        (-1 === ce[w][0] || ce[w][0] <= B) &&
                                                        (O[te].CX && O[te].CX.o["single-line"] && ZC._b_(O[te].CX.o["single-line"])
                                                            ? ((li = [].concat(ce[w][1])), "xy" === O[te].AJ.layout ? (ni = ZC._x_(ce[w][1][1][0])) : "yx" === O[te].AJ.layout && (ai = ZC._x_(ce[w][1][1][1])))
                                                            : (li = li.concat(ce[w][1])));
                                                if (O[te].CX.o.mask) {
                                                    var oi = -1;
                                                    li.length > 1 && li[1] && (oi = li[1][0] || -1),
                                                        O[te].CX.oMask ||
                                                            ((O[te].CX.oMask = new ZC.HN(O[te])),
                                                            O[te].CX.oMask.append({ "background-color": "#fff", alpha: 0.85 }),
                                                            O[te].CX.oMask.append(O[te].CX.o.mask),
                                                            (O[te].CX.oMask.Z = n),
                                                            O[te].CX.oMask.parse()),
                                                        (O[te].CX.oMask.iX = oi),
                                                        (O[te].CX.oMask.iY = O[te].P.iY),
                                                        (O[te].CX.oMask.I = Math.max(2, O[te].P.iX + O[te].P.I - oi + 2)),
                                                        (O[te].CX.oMask.F = O[te].P.F),
                                                        O[te].CX.oMask.paint();
                                                }
                                                if (O[te].AJ["3d"])
                                                    for (O[te].NW(), w = 0, Y = li.length; w < Y; w++) li[w] && ((X = new ZC.CF(O[te], li[w][0] - ZC.AO.E4, li[w][1] - ZC.AO.E5, 0)), (li[w][0] = X.ED[0]), (li[w][1] = X.ED[1]));
                                                (O[te].CX.L = O[te].L + "-crosshair-x"),
                                                    O[te].CX.HT && v && (O[te].CX.H3(O[te].CX, O[te].CX, null, v.LZ(null, !1), O[te].CX.MJ), O[te].CX.parse()),
                                                    O[te].CX.AN && ZC.CS.paint(a, O[te].CX, li);
                                            }
                                            if (ue.length > 0) {
                                                if (O[te].AJ["3d"])
                                                    for (O[te].NW(), w = 0, Y = ue.length; w < Y; w++)
                                                        null !== ZC._n_(ue[w]) && ((X = new ZC.CF(O[te], ue[w][0] - ZC.AO.E4, ue[w][1] - ZC.AO.E5, 0)), (ue[w][0] = X.ED[0]), (ue[w][1] = X.ED[1]));
                                                O[te].HB.HT && v && (O[te].HB.H3(O[te].HB, O[te].HB, null, Ee, O[te].HB.MJ), O[te].HB.parse()), O[te].HB.AN && ZC.CS.paint(a, O[te].HB, ue);
                                            }
                                            if (Be) {
                                                for (Z = re.length - 1; Z >= 0; Z--) (ZC.DT(re[Z].DM[0], _.iX - 5, _.iX + _.I + 5) && ZC.DT(re[Z].DM[1], _.iY - 5, _.iY + _.F + 5)) || re.splice(Z, 1);
                                                if (re.length > 1)
                                                    for (var ri = !0; ri; )
                                                        for (ri = !1, Z = 0; Z < re.length - 1; Z++)
                                                            if (re[Z].AN && ((be.CK && re[Z].iX > re[Z + 1].iX) || (!be.CK && re[Z].iY > re[Z + 1].iY))) {
                                                                var si = re[Z];
                                                                (re[Z] = re[Z + 1]), (re[Z + 1] = si), (ri = !0);
                                                            }
                                                if (re.length > 0) {
                                                    var Ai = [],
                                                        Ci = [];
                                                    for (Z = 0; Z < re.length; Z++) null !== ZC._n_(re[Z].o.x) && null !== ZC._n_(re[Z].o.y) && Ci.push(re[Z]);
                                                    for (var ci, ui, pi, Zi = !0, hi = 0, di = re.length * re.length; Zi && hi < di; )
                                                        for (hi++, Zi = !1, Z = 0; Z < re.length - 1; Z++)
                                                            if (re[Z].AN && -1 === ZC.AV(Ci, re[Z]))
                                                                if (ve.CK) {
                                                                    if (re[Z + 1].iX < re[Z].iX + re[Z].I) {
                                                                        if (
                                                                            (re[Z + 1].iX - re[Z].I - 4 < _.iX && -1 === ZC.AV(Ai, re[Z]) && (Ai.push(re[Z]), (re[Z].iX = _.iX)),
                                                                            (re[Z + 1].iX = re[Z].iX + re[Z].I + 4),
                                                                            re[Z + 1].iX + re[Z + 1].I > _.iX + _.I)
                                                                        )
                                                                            for (pi = re[Z + 1].iX - (_.iX + _.I - re[Z + 1].I), ci = 0, ui = re.length; ci < ui; ci++)
                                                                                re[ci].iX - pi >= _.iX
                                                                                    ? (re[ci].iX -= pi)
                                                                                    : ((re[ci].iX = _.iX),
                                                                                      ci > 0 && (re[Z + 1].D["marker-y"] < _.iY + _.F / 2 ? (re[ci].iY = re[ci - 1].iY + re[ci - 1].F + 4) : (re[ci].iY = re[ci - 1].iY - re[ci].F - 4)));
                                                                        Zi = !0;
                                                                    }
                                                                } else if (re[Z + 1].iY < re[Z].iY + re[Z].F) {
                                                                    if (
                                                                        (re[Z + 1].iY - re[Z].F - 4 < _.iY && -1 === ZC.AV(Ai, re[Z]) && (Ai.push(re[Z]), (re[Z].iY = _.iY)),
                                                                        (re[Z + 1].iY = re[Z].iY + re[Z].F + 4),
                                                                        re[Z + 1].iY + re[Z + 1].F > _.iY + _.F)
                                                                    )
                                                                        for (pi = re[Z + 1].iY - (_.iY + _.F - re[Z + 1].F), ci = 0, ui = re.length; ci < ui; ci++)
                                                                            re[ci].iY - pi >= _.iY
                                                                                ? (re[ci].iY -= pi)
                                                                                : ((re[ci].iY = _.iY),
                                                                                  ci > 0 && (re[Z + 1].D["marker-x"] < _.iX + _.I / 2 ? (re[ci].iX = re[ci - 1].iX + re[ci - 1].I + 4) : (re[ci].iX = re[ci - 1].iX - re[ci].I - 4)));
                                                                    Zi = !0;
                                                                }
                                                }
                                            }
                                            var fi = !1;
                                            for (Z = 0, h = pe.length; Z < h; Z++)
                                                if (-1 === pe[Z].D.diff || pe[Z].D.diff <= B) {
                                                    var _i = pe[Z];
                                                    O[te].AJ["3d"] &&
                                                        (O[te].NW(),
                                                        (X = new ZC.CF(O[te], _i.iX + _i.I / 2 - ZC.AO.E4, _i.iY + _i.F / 2 - ZC.AO.E5, 0)),
                                                        (_i.iX = X.ED[0] - _i.I / 2),
                                                        (_i.iY = X.ED[1] - _i.F / 2),
                                                        (X = new ZC.CF(O[te], _i.DM[0] - ZC.AO.E4, _i.DM[1] - ZC.AO.E5, 0)),
                                                        (_i.DM[0] = X.ED[0]),
                                                        (_i.DM[1] = X.ED[1])),
                                                        O[te].CX && O[te].CX.o["single-line"] && ZC._b_(O[te].CX.o["single-line"])
                                                            ? (("xy" === O[te].AJ.layout && ni === ZC._x_(_i.iX + _i.I / 2)) || ("yx" === O[te].AJ.layout && ai === ZC._x_(_i.iY + _i.F / 2))) && !fi && (_i.paint(), (fi = !0))
                                                            : _i.paint();
                                                }
                                            for (B = ZC.MAX, N = 0, G = re.length; N < G; N++) re[N].D.diff >= 0 && (B = ZC.CY(re[N].D.diff, B));
                                            for (-1 !== ge && (B = ZC.BQ(B, ge)), K = 0, N = 0, G = re.length; N < G; N++)
                                                if (-1 === re[N].D.diff || re[N].D.diff <= B) {
                                                    var gi = ZC.DT(re[N].DM[0], _.iX - 5, _.iX + _.I + 5) && ZC.DT(re[N].DM[1], _.iY - 5, _.iY + _.F + 5);
                                                    if (!Be || gi) {
                                                        if (re[N].AN) {
                                                            switch (re[N].D.placement) {
                                                                case "top":
                                                                    ve.CK ? (re[N].DM[0] = re[N].iX - re[N].G8) : (re[N].DM[1] = re[N].iY + re[N].F + re[N].G8);
                                                                    break;
                                                                case "bottom":
                                                                    ve.CK ? (re[N].DM[0] = re[N].iX + re[N].I + re[N].G8) : (re[N].DM[1] = re[N].iY - re[N].G8);
                                                            }
                                                            if (-1 !== ZC.AV(["top", "bottom"], re[N].D.placement)) {
                                                                var vi = re[N].iX + re[N].I / 2;
                                                                (re[N].iX = ZC.BQ(re[N].iX, 0)),
                                                                    (re[N].iX = ZC.CY(re[N].iX, i.H.I - re[N].I)),
                                                                    (re[N].iY = ZC.BQ(re[N].iY, 0)),
                                                                    (re[N].iY = ZC.CY(re[N].iY, i.H.F - re[N].F)),
                                                                    null === ZC._n_(re[N].o["callout-offset"]) && (re[N].EW = parseInt((100 * (vi - re[N].iX - re[N].I / 2)) / (re[N].I - re[N].H9), 10));
                                                            }
                                                            if (
                                                                (O[te].AJ["3d"] &&
                                                                    (O[te].NW(),
                                                                    (X = new ZC.CF(O[te], re[N].iX + re[N].I / 2 - ZC.AO.E4, re[N].iY + re[N].F / 2 - ZC.AO.E5, 0)),
                                                                    (re[N].iX = X.ED[0] - re[N].I / 2),
                                                                    (re[N].iY = X.ED[1] - re[N].F / 2),
                                                                    (X = new ZC.CF(O[te], re[N].DM[0] - ZC.AO.E4, re[N].DM[1] - ZC.AO.E5, 0)),
                                                                    (re[N].DM[0] = X.ED[0]),
                                                                    (re[N].DM[1] = X.ED[1]),
                                                                    "left" === re[N].EM ? (re[N].iX = re[N].DM[0] + P) : (re[N].iX = re[N].DM[0] - re[N].I - P)),
                                                                O[te].AJ["3d"] ||
                                                                    Be ||
                                                                    0 !== K ||
                                                                    ((re[N].iX = ZC.BQ(_.iX - 5, re[N].iX)),
                                                                    (re[N].iY = ZC.BQ(_.iY - 5, re[N].iY)),
                                                                    (re[N].iX = ZC.CY(_.iX + _.I - re[N].I + 5, re[N].iX)),
                                                                    (re[N].iY = ZC.CY(_.iY + _.F - re[N].F + 5, re[N].iY))),
                                                                Be || (!Be && 0 === K))
                                                            ) {
                                                                var bi = Be ? N : 0;
                                                                (!Be || ("canvas" === i.H.AC && re[bi].o["background-image"] && "" !== re[bi].o["background-image"])) && re[bi].parse(), 0 !== re[bi].C6 && re[bi].paint(), K++;
                                                            }
                                                        }
                                                        if (gi) {
                                                            var Bi = new ZC.DU(O[te]);
                                                            if (
                                                                (i.H.B8.load(Bi.o, "(" + O[te].AF + ").guide.marker"),
                                                                (Bi.L = re[N].L + "-marker"),
                                                                (Bi.Z = Bi.C7 = n),
                                                                (Bi.iX = re[N].D["marker-x"]),
                                                                (Bi.iY = re[N].D["marker-y"]),
                                                                O[te].AJ["3d"] && (O[te].NW(), (X = new ZC.CF(O[te], Bi.iX - ZC.AO.E4, Bi.iY - ZC.AO.E5, 0)), (Bi.iX = X.ED[0]), (Bi.iY = X.ED[1])),
                                                                (M = re[N].D["guide-style"]),
                                                                (Bi.A0 = Bi.AE = ZC.AP.JM(M["background-color"])),
                                                                (Bi.BX = M.color),
                                                                Bi.append(O[te].CX.o.marker),
                                                                Bi.append(O[te].AZ.A3[re[N].D.plotidx].o["guide-marker"]),
                                                                "inherit" === Bi.o.type)
                                                            ) {
                                                                var mi = O[te].AZ.A3[re[N].D.plotidx];
                                                                mi.A2 && mi.A2.o.type && (Bi.o.type = mi.A2.o.type);
                                                            }
                                                            Bi.parse(), Bi.AN && "none" !== Bi.DS && Bi.AI > 1 && Bi.paint();
                                                        }
                                                    }
                                                }
                                            ((H = O[te].GY()).items = oe), (H.guide = { x: x, y: y }), (H.ev = p), (H["scale-label"] = de), ZC.AP.C0("guide_mousemove", i.H, H), O[te].QM(!0);
                                        } else ((H = {}).guide = { x: x, y: y }), (H.ev = p), ZC.AP.C0("guide_mousemove", i.H, H);
                                    }
                                }
                            }
                        }
                    }
                }),
                (i.zc_guide_touchend = function () {
                    0 !== zingchart.DEV.GUIDETIMEOUT &&
                        window.setTimeout(function () {
                            u();
                        }, ZC._i_(zingchart.DEV.GUIDETIMEOUT));
                }),
                ZC.A5(document.body).bind("mousemove touchstart touchmove", i.QB),
                ZC.A5(document.body).bind("touchend", i.zc_guide_touchend);
        },
    };
    (ZC.JR = ZC.CA.CC(JR)),
        (ZC.JR.clearGuide = function (e) {
            var i = zingchart.getLoader(e);
            if (i) {
                zingchart.GUIDE_EV = null;
                var t = ZC.AL(e + "-guide-c"),
                    n = ZC.A5(t).width(),
                    a = ZC.A5(t).height();
                ZC.A5("." + e + "-guide-label").remove(),
                    ZC.Q.IV(t, i.AC, 0, 0, n, a),
                    ZC.A5("#" + e + "-defs")
                        .children()
                        .each(function () {
                            this.id && -1 !== this.id.indexOf("-guide-label-") && ZC.Q.ET(this.id);
                        });
            }
        }),
        zingchart.extendAPI("resetguide", function (e, i) {
            "string" == typeof (i = i || {}) && (i = JSON.parse(i)), (ZC.JR.GUIDES[e] = ZC.JR.GUIDES[e] || {}), (ZC.JR.GUIDES[e].blocked = !1), ZC.JR.clearGuide(e);
        }),
        zingchart.extendAPI("setguide", function (e, i) {
            "string" == typeof (i = i || {}) && (i = JSON.parse(i));
            var t,
                n,
                a = zingchart.getLoader(e),
                l = a.C9(i.graphid),
                o = l.BM("scale-x");
            "xy" === l.AJ.layout ? ((t = i.x || o.AT(i.keyvalue)), (n = l.iY + l.F / 2)) : ((t = l.iX + l.I / 2), (n = i.y || o.AT(i.keyvalue)));
            var r = { _pageX_: t, _pageY_: n, type: ZC.mobile ? "touchstart" : "mousemove", target: { id: e + "-img" } };
            (ZC.JR.GUIDES = ZC.JR.GUIDES || {}), (ZC.JR.GUIDES[e] = ZC.JR.GUIDES[e] || {}), (ZC.JR.GUIDES[e].blocked = !0), ZC.JR.clearGuide(e), (r.fromAPI = !0), a.D7.QB(r);
        });
    var A2P = {
        $i: function (e, i) {
            var t = this;
            (t.o = null), (t.C = e), (t.NQ = i);
        },
        parse: function () {
            var e,
                i = this;
            i.o = i.C.o;
            var t,
                n,
                a,
                l,
                o,
                r,
                s,
                A,
                C,
                c = i.NQ,
                u = "\r\n",
                p = ",",
                Z = !1,
                h = null,
                d = null,
                f = null,
                _ = null,
                g = null,
                v = !1,
                b = !1,
                B = null,
                m = {};
            null !== ZC._n_((e = i.o["html5-csv"])) && (m = e),
                null !== ZC._n_((e = i.o.csv)) && (m = e),
                null !== ZC._n_((e = m.separator)) && (p = e),
                null !== ZC._n_((e = m.mirrored)) && (Z = ZC._b_(e)),
                null !== ZC._n_((e = m.title)) && (h = ZC._b_(e)),
                null !== ZC._n_((e = m["string-values"])) && (b = ZC._b_(e)),
                Z
                    ? (null !== ZC._n_((e = m["horizontal-labels"])) && (f = ZC._b_(e)), null !== ZC._n_((e = m["vertical-labels"])) && (d = ZC._b_(e)))
                    : (null !== ZC._n_((e = m["horizontal-labels"])) && (d = ZC._b_(e)), null !== ZC._n_((e = m["vertical-labels"])) && (f = ZC._b_(e))),
                null !== ZC._n_((e = m["smart-scales"])) && (_ = ZC._b_(e)),
                null !== ZC._n_((e = m["separate-scales"])) && (g = ZC._b_(e)),
                null !== ZC._n_((e = m["keyval-format"])) && (v = ZC._b_(e)),
                null !== ZC._n_((e = m.columns)) && (B = e);
            var D = null;
            null !== ZC._n_((e = m["thousands-separator"])) && (D = e);
            var E = null;
            if ((null !== ZC._n_((e = m["decimals-separator"])) && (E = e), null !== D && null === E && (E = "." === D ? "," : "."), null !== E && null === D && (D = "." === E ? "," : "."), null !== ZC._n_(B) && B.length > 0)) {
                (t = []), null !== ZC._n_((e = m["row-separator"])) ? (u = e) : c.split(/\n/).length > 0 ? (u = "\n") : c.split(/\r/).length > 0 && (u = "\r");
                var L = c.split(u),
                    F = 0;
                for (l = 0, o = L.length; l < o; l++)
                    if ("" !== L[l].replace(/\s+/g, "")) {
                        t[F] = [];
                        for (var I = 0, x = 0; I < L[l].length - 1; ) (a = L[l].substring(I, I + B[x])), t[F].push(a), (I += B[x]), x++;
                        F++;
                    }
            } else {
                (t = [[]]),
                    (n =
                        null !== ZC._n_((e = m["row-separator"]))
                            ? new RegExp("(\\" + p + "|" + e + '|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\' + p + e + "]*))", "gi")
                            : new RegExp("(\\" + p + '|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\' + p + "\\r\\n]*))", "gi"));
                for (var y = null; (y = n.exec(c)); ) {
                    var w = y[1];
                    w.length && w !== p && t.push([]), (a = y[2] ? y[2].replace(new RegExp('""', "g"), '"') : y[3]), t[t.length - 1].push(a);
                }
            }
            var Y = [];
            for (l = 0, o = t.length; l < o; l++) 0 !== t[l].join("").replace(/\s+/g, "").length && Y.push(t[l]);
            var X = 0,
                M = 0;
            if (
                ((null === ZC._n_(h) || h) && (Y.length > 1 && 1 === Y[0].length ? (null === ZC._n_(i.o.title) ? (i.o.title = { text: Y[0][0] }) : null === ZC._n_(i.o.title.text) && (i.o.title.text = Y[0][0]), (h = !0)) : (h = !1)),
                h && X++,
                Z)
            ) {
                for (t = [], h && t.push(Y[0]), r = X, s = Y.length; r < s; r++) for (A = 0, C = Y[r].length; A < C; A++) null === ZC._n_(t[A + X]) && (t[A + X] = []), t[A + X].push(Y[r][A]);
                Y = t;
            }
            if ("function" == typeof zingchart.csvParser) for (r = 0, s = Y.length; r < s; r++) for (A = 0, C = Y[r].length; A < C; A++) Y[r][A] = zingchart.csvParser.call(this, Y[r][A], r, A, i.C.A.L);
            var K = 0;
            for (l = 0, o = Y.length; l < o; l++) K = ZC.BQ(K, Y[l].length);
            var S = [];
            if (null === ZC._n_(d)) {
                var P = Y[X].join("").length;
                d = Y[X].join("").replace(/[0-9]/g, "").length / P > 0.75;
            }
            d && ((S = Y[X]), X++);
            var H = [];
            if (null === ZC._n_(f))
                if (d && -1 !== S[0].indexOf("\\")) f = !0;
                else {
                    var N = "";
                    for (r = X, s = Y.length; r < s; r++) N += Y[r][0];
                    var G = N.length;
                    f = N.replace(/[0-9]/g, "").length / G > 0.75;
                }
            if (f) {
                for (r = X, s = Y.length; r < s; r++) v ? H.push(ZC._i_(Y[r][M])) : H.push(Y[r][M]);
                M++;
            }
            var O = [],
                k = [];
            for (A = M; A < K; A++) {
                k[A - M] = [];
                var T = D,
                    z = E,
                    Q = 0,
                    V = null;
                for (r = X, s = Y.length; r < s; r++)
                    if (null !== ZC._n_(Y[r][A]) && "" !== Y[r][A] && "undefined" != typeof Y[r][A]) {
                        if (((a = Y[r][A]), null !== ZC._n_(V) || b || (V = a.replace(/[0-9\-\,\.\+\e]+/g, "%v")), b || (a = a.replace(/[^0-9\-\,\.\+\e]+/g, "")), null === T || null === z)) {
                            var J = a.indexOf("."),
                                R = a.indexOf(",");
                            -1 !== J && -1 !== R
                                ? J < R
                                    ? ((T = "."), (z = ","), (Q = ZC.BQ(0, a.length - R)))
                                    : ((T = ","), (z = "."), (Q = ZC.BQ(0, a.length - J)))
                                : -1 === J && -1 !== R
                                ? a.length - R - 1 == 3
                                    ? ((T = ","), (z = "."))
                                    : ((T = "."), (z = ","), (Q = ZC.BQ(0, a.length - R)))
                                : -1 !== J && -1 === R && (a.length - J - 1 == 3 ? ((T = "."), (z = ",")) : ((T = ","), (z = "."), (Q = ZC.BQ(0, a.length - J))));
                        }
                        "." === T && (a = a.replace(/\./g, "").replace(/,/g, ".")), "," === T && (a = a.replace(/,/g, "")), k[A - M].push(b ? a : ZC._f_(a));
                    } else k[A - M].push(null);
                (O[A - M] = {}), null !== ZC._n_(V) && (O[A - M].format = V), null !== ZC._n_(T) && (O[A - M]["thousands-separator"] = T), null !== ZC._n_(T) && (O[A - M]["decimals-separator"] = z), 0 !== Q && (O[A - M].decimals = Q);
            }
            if (v) for (l = 0, o = k.length; l < o; l++) for (var W = 0; W < k[l].length; W++) k[l][W] = [H[W], k[l][W]];
            var U = [];
            switch (i.C.AF) {
                case "line":
                case "area":
                case "vbar":
                case "hbar":
                case "line3d":
                case "area3d":
                case "vbar3d":
                case "hbar3d":
                case "mixed":
                    null === ZC._n_(i.o["scale-x"]) && (i.o["scale-x"] = {});
                    var j = [];
                    f && null !== ZC._n_(S[0]) && (j = S[0].split(/\\/)),
                        null !== ZC._n_(j[0]) && (null === ZC._n_(i.o["scale-x"].label) && (i.o["scale-x"].label = {}), null === ZC._n_(i.o["scale-x"].label.text) && (i.o["scale-x"].label.text = j[0])),
                        f && (null === ZC._n_(i.o["scale-x"].values) ? (i.o["scale-x"].values = H) : null === ZC._n_(i.o["scale-x"].labels) && (i.o["scale-x"].labels = H));
                    var q = [];
                    if (null !== ZC._n_(g) && g) for (l = 0, o = k.length; l < o; l++) q[l] = "scale-y" + (0 === l ? "" : "-" + (l + 1));
                    else if (null !== ZC._n_(_) && _) {
                        var $ = {},
                            ee = 0,
                            ie = [];
                        for (l = 0, o = k.length; l < o; l++) {
                            for (var te = 0, ne = 0, ae = k[l].length; ne < ae; ne++) te += k[l][ne];
                            te /= k[l].length;
                            var le = Math.round(ZC.FV(te) / Math.LN10 / 2);
                            null === ZC._n_($[le]) && ($[le] = "scale-y" + (0 === ee ? "" : "-" + (ee + 1))),
                                -1 === ZC.AV(ie, O[l].format) ? ((q[l] = "scale-y" + (0 === ee ? "" : "-" + (ee + 1))), ee++) : ((q[l] = $[le]), ee++),
                                ie.push(O[l].format);
                        }
                    }
                    for (0 === q.length && (q[0] = "scale-y"), null === ZC._n_(i.o.series) && (i.o.series = []), l = 0, o = k.length; l < o; l++)
                        null === ZC._n_(i.o.series[l]) && (i.o.series[l] = {}),
                            (i.o.series[l].values = k[l]),
                            d &&
                                (null === ZC._n_(i.o.series[l].text) && ((i.o.series[l].text = S[l + M]), U.push(S[l + M])),
                                null === ZC._n_(i.o.series[l]["legend-text"]) && ((i.o.series[l]["legend-text"] = S[l + M]), U.push(S[l + M])),
                                null === ZC._n_(i.o.series[l]["tooltip-text"]) && null !== ZC._n_(O[l].format) && (i.o.series[l]["tooltip-text"] = O[l].format)),
                            null !== ZC._n_(q[l]) &&
                                (null === ZC._n_(i.o[q[l]]) && (i.o[q[l]] = {}),
                                null !== ZC._n_(j[1]) && (null === ZC._n_(i.o[q[l]].label) && (i.o[q[l]].label = {}), null === ZC._n_(i.o[q[l]].label.text) && (i.o[q[l]].label.text = j[1])),
                                null === ZC._n_(i.o.series[l].scales) && (i.o.series[l].scales = "scale-x," + q[l]),
                                null === ZC._n_(i.o[q[l]].decimals) && null !== ZC._n_(O[l].decimals) && (i.o[q[l]].decimals = O[l].decimals),
                                null === ZC._n_(i.o[q[l]]["thousands-separator"]) && null !== ZC._n_(O[l]["thousands-separator"]) && (i.o[q[l]]["thousands-separator"] = O[l]["thousands-separator"]),
                                null === ZC._n_(i.o[q[l]]["decimals-separator"]) && null !== ZC._n_(O[l]["decimals-separator"]) && (i.o[q[l]]["decimals-separator"] = O[l]["decimals-separator"]),
                                null === ZC._n_(i.o[q[l]].format) && null !== ZC._n_(O[l].format) && (i.o[q[l]].format = O[l].format));
                    break;
                case "pie":
                case "pie3d":
                case "gauge":
                case "nestedpie":
                    if ((null === ZC._n_(i.o.scale) && (i.o.scale = {}), f && null !== ZC._n_(S[0]))) {
                        var oe = S[0].split(/\\/);
                        null === ZC._n_(i.o.scale.label) && (i.o.scale.label = {}), null === ZC._n_(i.o.scale.label.text) && (i.o.scale.label.text = oe[0]);
                    }
                    for (f && (null === ZC._n_(i.o.scale.values) ? (i.o.scale.values = H) : null === ZC._n_(i.o.scale.labels) && (i.o.scale.labels = H)), null === ZC._n_(i.o.series) && (i.o.series = []), l = 0, o = k.length; l < o; l++)
                        null === ZC._n_(i.o.series[l]) && (i.o.series[l] = {}),
                            (i.o.series[l].values = k[l]),
                            d &&
                                (null === ZC._n_(i.o.series[l].text) && ((i.o.series[l].text = S[l + M]), U.push(S[l + M])),
                                null === ZC._n_(i.o.series[l]["legend-text"]) && ((i.o.series[l]["legend-text"] = S[l + M]), U.push(S[l + M])),
                                null === ZC._n_(i.o.series[l]["tooltip-text"]) && null !== ZC._n_(O[l].format) && (i.o.series[l]["tooltip-text"] = O[l].format)),
                            null === ZC._n_(i.o["scale-v"]) && (i.o["scale-v"] = {}),
                            null === ZC._n_(i.o["scale-v"].decimals) && null !== ZC._n_(O[l].decimals) && (i.o["scale-v"].decimals = O[l].decimals),
                            null === ZC._n_(i.o["scale-v"]["thousands-separator"]) && null !== ZC._n_(O[l]["thousands-separator"]) && (i.o["scale-v"]["thousands-separator"] = O[l]["thousands-separator"]),
                            null === ZC._n_(i.o["scale-v"]["decimals-separator"]) && null !== ZC._n_(O[l]["decimals-separator"]) && (i.o["scale-v"]["decimals-separator"] = O[l]["decimals-separator"]),
                            null === ZC._n_(i.o["scale-v"].format) && null !== ZC._n_(O[l].format) && (i.o["scale-v"].format = O[l].format);
            }
            return "" !== U.join("") && null === ZC._n_(i.o.legend) && (i.o.legend = {}), (i.o = JSON.parse(JSON.stringify(i.o).replace(/\\\\/g, "\\"))), i.o;
        },
    };
    (ZC.A2P = ZC.CA.CC(A2P)),
        (ZC.JJ = ZC.HN.CC({
            $i: function (e) {
                this.b(e);
                var i = this;
                (i.O8 = "zcgraph"),
                    (i.H = e),
                    (i.AF = ""),
                    (i.IR = null),
                    (i.OZ = ""),
                    (i.K1 = null),
                    (i.MV = null),
                    (i.S6 = null),
                    (i.P = null),
                    (i.B9 = null),
                    (i.HQ = null),
                    (i.HP = null),
                    (i.A5Q = 1),
                    (i.VF = 1),
                    (i.A56 = 1),
                    (i.K = 0),
                    (i.HS = null),
                    (i.MG = [1, 0]),
                    (i.A9R = null),
                    (i.CE = !1),
                    (i.KR = "normal"),
                    (i.BO = []),
                    (i.BY = []),
                    (i.YC = []),
                    (i.FH = []),
                    (i.LI = []),
                    (i.AZ = new ZC.LM(i)),
                    (i.H2 = null),
                    (i.BE = null),
                    (i.A7 = null),
                    (i.CX = null),
                    (i.HB = null),
                    (i.A1T = "always"),
                    (i.ABO = !0),
                    (i.MF = ""),
                    (i.RL = null),
                    (i.LL = !1),
                    (i.UN = !1),
                    (i.NB = 0),
                    (i.YU = !1),
                    (i.Q4 = !1),
                    (i.F0 = { true3d: 1, angle: 45, depth: 40, "x-angle": 0, "y-angle": 0, "z-angle": 0, zoom: 1 }),
                    (i.AJ = {
                        "enable-guide": !1,
                        "enable-preview": !1,
                        "enable-scroll": !1,
                        "enable-zooming": !0,
                        "3d": !1,
                        clip: !1,
                        layout: "",
                        "enable-animation": !0,
                        "angle-min": 15,
                        "angle-max": 75,
                        "x-angle-min": -65,
                        "x-angle-max": 65,
                        "y-angle-min": -65,
                        "y-angle-max": 65,
                        "z-angle-min": -65,
                        "z-angle-max": 65,
                    }),
                    (i.OC = !1),
                    (i.A19 = !1),
                    (i.AA3 = []),
                    (i.A1N = !0),
                    "undefined" != typeof ZC.PG && (i.LW = new ZC.PG(i)),
                    (i.GE = !1),
                    (i.CD = {}),
                    (i.IX = []),
                    (i.KI = !1),
                    (i.HH = !1),
                    (i.L6 = 0),
                    (i.BP = []),
                    (i.A5M = !0),
                    (i.UB = zingchart.DEV.STACKINGLOGIC),
                    -1 === i.UB && (i.UB = 0);
            },
            a11y: function () {
                if (this.A.bA11y) {
                    return (
                        ZC.Q.FX("rect", "", "") +
                        'class="zc-graph-descriptor" tabindex="0" aria-label="Chart ' +
                        (this.K + 1) +
                        " of " +
                        this.A.AG.length +
                        ", " +
                        ({ vbar: "column", vbar3d: "3d column", hbar: "bar", hbar3d: "3d bar", line3d: "3d line", area3d: "3d area", pie3d: "3d pie" }[this.AF] || this.AF) +
                        " chart. " +
                        (this.IR ? this.IR.AM : "Untitled") +
                        ". " +
                        (this.K1 ? this.K1.AM : "") +
                        ". " +
                        this.OZ +
                        '" id="' +
                        this.L +
                        '--graph" coords="0,0,0,0" data-z-sort="-200" />'
                    );
                }
                return "";
            },
            getPMap: function () {
                var e = this.b();
                return this.addPMap(e, "index", "K"), e;
            },
            getToggleAction: function () {
                var e,
                    i = this,
                    t = "hide";
                return (
                    i.BE && "" !== i.D["legend-last-trigger"] && "undefined" != typeof i.D["legend-last-trigger"]
                        ? (t = "item" === i.D["legend-last-trigger"] ? i.BE.R3 : i.BE.PP)
                        : (i.o.legend && (e = i.o.legend["toggle-action"]) && (t = e), i.o.legend && i.o.legend.item && (e = i.o.legend.item["toggle-action"]) && (t = e)),
                    (i.A.K8 || i.D["toggle-action-remove"]) && (t = "remove"),
                    t
                );
            },
            BW: function (e, i) {
                void 0 === i && (i = !1);
                for (var t = [], n = this, a = 0, l = n.BO.length; a < l; a++) n.BO[a].AF === e && (!i || (i && n.BO[a].V.length > 0)) && t.push(n.BO[a]);
                return t;
            },
            BM: function (e) {
                for (var i = this, t = 0, n = i.BO.length; t < n; t++) if (i.BO[t].BF === e) return i.BO[t];
                return null;
            },
            A2O: function (e) {
                return e;
            },
            ACH: function (e) {
                return new ZC.A2P(this, e);
            },
            ACN: function () {
                for (var e = this, i = 0, t = e.BO.length; i < t; i++) {
                    var n = e.BO[i],
                        a = n.BF;
                    e.A.B8.load(n.o, ["(" + e.AF + ").SCALE", "(" + e.AF + ")." + a.replace(/\-[0-9]+/, ""), "(" + e.AF + ")." + a.replace(/\-[0-9]+/, "-n"), "(" + e.AF + ")." + a], !1, !0);
                    var l = a.replace(/\-[0-9]+/, "") + "-n";
                    e.o[l] && n.append(e.o[l]),
                        e.o[a] && n.append(e.o[a]),
                        e.AJ["3d"] && e.A.B8.load(n.o, ["(" + e.AF + ").SCALE[3d]", "(" + e.AF + ")." + a.replace(/\-[0-9]+/, "") + "[3d]", "(" + e.AF + ")." + a.replace(/\-[0-9]+/, "-n") + "[3d]", "(" + e.AF + ")." + a + "[3d]"], !1, !0),
                        e.AJ["3d"] && n.append(e.o[a + "[3d]"]),
                        n.parse();
                }
            },
            ABG: function () {
                return null;
            },
            AA5: function (e) {
                var i,
                    t,
                    n,
                    a = this,
                    l = 0,
                    o = a.AZ.A3.length;
                for (i = 0; i < o; i++) l = ZC.BQ(l, a.AZ.A3[i].S.length);
                function r(e) {
                    return (e = (e = (e = e.replace(/(%N|%node-count)/g, l)).replace(/(%P|%plot-count)/g, o)).replace(/(%S|%scale-values-count)/g, n.V.length));
                }
                for (i = 0, t = a.BO.length; i < t; i++)
                    (n = a.BO[i]).A9G(e), 2 === e && ((n.J5 = r), n.DE() && n.parse()), null === ZC._n_(n.o["max-items"]) && null === ZC._n_(n.o["max-labels"]) && n.A7U(), null === ZC._n_(n.o["max-ticks"]) && n.AC9();
            },
            UU: function () {},
            NW: function () {},
            ADE: function () {},
            AC1: function () {},
            setupPlotArea: function () {
                var e = this,
                    i = e.A.B8,
                    t = "(" + e.AF + ")";
                (e.P = new ZC.HN(e)), (e.P.OE = "plotarea"), (e.P.L = e.L + "-plotarea");
                var n = [t + ".plotarea"];
                if (
                    (e.B9 && ("xy" === e.AJ.layout ? n.push(t + ".plotarea[preview]") : n.push(t + ".plotarea[preview[yx]]")),
                    e.AJ["3d"] && n.push(t + ".plotarea[3d]"),
                    i.load(e.P.o, n),
                    e.P.append(e.o.chart),
                    e.P.append(e.o.plotarea),
                    e.B9 && e.P.append(e.o["plotarea[preview]"]),
                    e.AJ["3d"] && e.P.append(e.o["plotarea[3d]"]),
                    "dynamic" === e.P.o["margin-top"] || "dynamic" === e.P.o["margin-right"] || "dynamic" === e.P.o["margin-bottom"] || "dynamic" === e.P.o["margin-left"])
                ) {
                    var a = String(e.P.o.margin || "").split(/\s+|;|,/),
                        l = a.length > 0 ? a[0] : "",
                        o = a.length > 1 ? a[1] : "",
                        r = a.length > 0 ? a[2] || a[0] : "",
                        s = a.length > 1 ? a[3] || a[1] : "";
                    "dynamic" === e.P.o["margin-top"] && (l = "dynamic"),
                        "dynamic" === e.P.o["margin-right"] && (o = "dynamic"),
                        "dynamic" === e.P.o["margin-bottom"] && (r = "dynamic"),
                        "dynamic" === e.P.o["margin-left"] && (s = "dynamic"),
                        (e.P.o.margin = [l, o, r, s].join(" "));
                }
                if (
                    (e.D["plotarea-margins"]
                        ? (e.P.o.margin = e.D["plotarea-margin"])
                        : ((e.D["plotarea-margins"] = !0),
                          (e.D["plotarea-margin"] = e.P.o.margin),
                          (e.D["plotarea-margin-top"] = e.P.o["margin-top"]),
                          (e.D["plotarea-margin-right"] = e.P.o["margin-right"]),
                          (e.D["plotarea-margin-bottom"] = e.P.o["margin-bottom"]),
                          (e.D["plotarea-margin-left"] = e.P.o["margin-left"])),
                    "undefined" != typeof e.D["plotarea-p-x"] && ((e.P.D["p-x"] = e.D["plotarea-p-x"]), (e.P.D["p-y"] = e.D["plotarea-p-y"]), (e.P.D["p-width"] = e.D["plotarea-p-width"]), (e.P.D["p-height"] = e.D["plotarea-p-height"])),
                    null !== ZC._n_(e.P.o["adjust-layout"]) && ZC._b_(e.P.o["adjust-layout"]) && (e.P.o.margin = "dynamic"),
                    e.P.parse(),
                    e.AJ["3d"] && !e.F0.true3d)
                ) {
                    var A = ZC._a_(ZC._i_(e.F0.depth * ZC.EP(e.F0.angle)));
                    (e.P.iY += A), (e.P.F -= A), (e.P.I -= ZC._i_(e.F0.depth * ZC.EH(e.F0.angle)));
                }
                if ("undefined" != typeof e.D["plotarea-p-x"]) for (var C = 0, c = e.BO.length; C < c; C++) e.BO[C].A52(), e.BO[C].J2();
            },
            setupDynamicPlotArea: function () {
                var e,
                    i,
                    t,
                    n = this,
                    a = ["top", "right", "bottom", "left"],
                    l = {};
                for (i = 0; i < a.length; i++)
                    (l[a[i]] = !1), n.D["plotarea.d-margin-" + a[i]] && (n.o.plotarea["margin-" + a[i]] = null), n.o.plotarea && "dynamic" === n.o.plotarea["margin-" + a[i]] && ((l[a[i]] = !0), (n.o.plotarea["margin-" + a[i]] = "20"));
                var o = !1,
                    r = {};
                if (("xy" === n.AJ.layout && (o = !0), ("xy" === n.AJ.layout || "yx" === n.AJ.layout) && (n.P.D["d-margin"] || n.D["plotarea.d-margin"]))) {
                    for (var s = 0, A = n.BO.length; s < A; s++) {
                        var C = 0,
                            c = 0,
                            u = "",
                            p = n.BO[s];
                        if (p.AN && p.T9) {
                            "k" === p.AF
                                ? (u = p.CK ? ("default" === p.BA ? "left" : "right") : "default" === p.BA ? "bottom" : "top")
                                : "v" === p.AF && (u = p.CK ? ("default" === p.BA ? "bottom" : "top") : "default" === p.BA ? "left" : "right");
                            var Z = 0;
                            if (n.P.D["d-margin-" + u] || n.D["plotarea.d-margin-" + u]) {
                                var h = new ZC.DN(p);
                                h.copy(p.BT);
                                var d = ZC.BQ(1, ZC._i_((p.A1 - p.W) / p.EG));
                                for (i = p.W; i <= p.A1; i += d)
                                    if (((h.AM = p.FQ(i)), h.A29 && (("k" === p.AF && !p.CK) || ("v" === p.AF && p.CK)) && (h.o.width = ZC._i_(0.9 * p.AB)), h.parse(), h.AN))
                                        if (
                                            ((c = ZC.BQ(c, h.AA % 180 == 0 ? h.F : h.I)),
                                            (C = ZC.BQ(C, h.AA % 180 == 0 ? h.I : h.F)),
                                            (Z = ZC.BQ(Z, 1.5 * h.DJ * (h.AM || "").split(/<br>|<br\/>|<br \/>|\n/).length)),
                                            "top" === u || "bottom" === u)
                                        ) {
                                            if (((Z = ZC.BQ(Z, 0.465 * h.DJ + 1.025 * ZC._a_(ZC.EP(h.AA)) * ZC.BQ(h.I, h.F))), (C = h.I), (c = Z), o && "k" === p.AF)) {
                                                r[p.BF] || (r[p.BF] = []);
                                                var f = null === ZC._n_(h.o["auto-align"]) || ZC._b_(h.o["auto-align"]),
                                                    _ = 0.465 * h.DJ + 1.025 * ZC._a_(ZC.EH(h.AA)) * ZC.BQ(h.I, h.F);
                                                "default" === p.BA
                                                    ? (f && (ZC.DT(ZC._ang_(h.AA), 90, 180) || ZC.DT(ZC._ang_(h.AA), 270, 360)) && r[p.BF].push(_), f || r[p.BF].push(_ / 2))
                                                    : (f && (ZC.DT(ZC._ang_(h.AA), 0, 90) || ZC.DT(ZC._ang_(h.AA), 180, 270)) && r[p.BF].push(_), f || r[p.BF].push(_ / 2));
                                            }
                                        } else (C = Z = ZC.BQ(Z, 0.465 * h.DJ + 1.025 * ZC._a_(ZC.EH(h.AA)) * ZC.BQ(h.I, h.F))), (c = h.F);
                                var g = new ZC.DN(p);
                                g.copy(p.M), (g.AM = p.M.AM), g.parse(), "" !== g.AM && g.AN && ((c += g.AA % 180 == 0 ? g.F : g.I), (C += g.AA % 180 == 0 ? g.I : g.F));
                            }
                            if ((n.o.plotarea || (n.o.plotarea = {}), ("dynamic" === n.o.plotarea["margin-" + u] || n.P.D["d-margin-" + u]) && ((n.P.D["d-margin-" + u] = !1), (l[u] = !0), (n.o.plotarea["margin-" + u] = "0")), l[u])) {
                                (n.o.plotarea["margin-" + u] = ZC._f_(n.o.plotarea["margin-" + u] || "0")), (n.D[p.BF + "-distance"] = n.o.plotarea["margin-" + u]);
                                var v = ("top" === u || "bottom" === u ? ZC._i_(c) : ZC._i_(C)) + 10 + (n.AJ["3d"] ? 20 : 0);
                                if (
                                    (p.VB ? (n.o.plotarea["margin-" + u] = ZC.BQ(n.o.plotarea["margin-" + u], v)) : (n.o.plotarea["margin-" + u] += v),
                                    null !== ZC._n_(n.o.plotarea["margin-" + u + "-offset"]) && (n.o.plotarea["margin-" + u] += ZC._i_(n.o.plotarea["margin-" + u + "-offset"])),
                                    !n.A.TM)
                                ) {
                                    var b = {},
                                        B = n.A.DG.watermark;
                                    n.A.B8.load(b, "loader.gui.watermark"), B && ZC._cp_(B, b), 1 === n.A.o.graphset.length && n.A.o.graphset[0].gui && (e = n.A.o.graphset[0].gui.watermark) && ZC._cp_(e, b);
                                    var m = b.position || "br";
                                    -1 === ZC.AV(["tl", "tr", "br", "bl"], m) && (m = "br"), (("bottom" !== u || ("bl" !== m && "br" !== m)) && ("top" !== u || ("tl" !== m && "tr" !== m))) || (n.o.plotarea["margin-" + u] += 15);
                                }
                                "bottom" === u && (("xy" === n.AJ.layout && n.HQ) || ("yx" === n.AJ.layout && n.HP)) && (n.o.plotarea["margin-" + u] += 15),
                                    "left" === u && (("xy" === n.AJ.layout && n.HP) || ("yx" === n.AJ.layout && n.HQ)) && (n.o.plotarea["margin-" + u] += 15),
                                    (n.D["plotarea.d-margin-" + u] = !0);
                            }
                        }
                    }
                    if (o && l.left && null !== ZC._n_(n.o.plotarea["margin-left"]))
                        for (var D in r) {
                            var E = n.BM(D);
                            for (i = 0; i < r[D].length; i++) {
                                ZC._i_(n.o.plotarea["margin-left"]) + i * E.AB + (E.DF ? E.AB / 2 : 0) - r[D][i] < 0 && (n.o.plotarea["margin-left"] = r[D][i] - i * E.AB - (E.DF ? E.AB / 2 : 0));
                            }
                        }
                    ZC.Q.IV(ZC.AL(n.L + "-plotarea-c"), n.H.AC, n.P.iX, n.P.iY, n.P.I, n.P.F, n.L), (n.D["plotarea.paint"] = !0), n.setupPlotArea();
                    var L = 2,
                        F = 6;
                    null !== ZC._n_((e = n.P.o["mask-tolerance"])) && (e instanceof Array ? ((L = F = ZC._i_(e[0])), e.length > 1 && (F = ZC._i_(e[1]))) : (L = F = ZC._i_(e))),
                        (n.P.D.tolerance = L),
                        "svg" === n.H.AC
                            ? ((e = ZC.AL(n.L + "-clip-shape")) && e.setAttribute("points", n.M5(L, "svg")), (e = ZC.AL(n.L + "-clip-hover-shape")) && e.setAttribute("points", n.M5(F, "svg")))
                            : (ZC.A5("#" + n.L + " div").each(function () {
                                  "" !== this.style.clip && (this.style.clip = n.M5(L));
                              }),
                              (e = ZC.AL(n.L + "-hover")) && "" !== e.style.clip && (e.style.clip = n.M5(F)));
                }
                for (i = 0, t = n.BO.length; i < t; i++) n.BO[i].A52(), n.BO[i].J2();
            },
            parse: function () {
                var e,
                    i,
                    t,
                    n,
                    a,
                    l,
                    o,
                    r,
                    s,
                    A = this,
                    C = A.A.B8,
                    c = "(" + A.AF + ")";
                (e = A.A.D["graph-state-" + A.K]) && ((A.D = JSON.parse(e)), null === ZC._n_(A.D["guide-on"]) || ZC._b_(A.D["guide-on"]) || (A.A1N = !1)),
                    A.D.legend_toggle_action || (A.A.D["graph-" + A.L + "-legend-info"] = null),
                    (A.D.legend_toggle_action = null),
                    (A.MF = "parse.init"),
                    A.b(),
                    A.ADE(),
                    -1 !== JSON.stringify(A.o).indexOf("zingchart.maps") && ((A.o.plotarea = A.o.plotarea || {}), (A.o.plotarea.margin = 0));
                var u = null;
                if (
                    !zingchart.SKIP.CSV &&
                    ((e = A.o["html5-csv"]) && (A.RL = e["html5-url"]),
                    (e = A.o.csv) && ("object" == typeof e ? (e.url ? (A.RL = e.url) : e["data-string"] && (u = e["data-string"])) : (A.RL = e)),
                    "" !== A.RL && null !== ZC._n_(A.A.A9F[A.RL]) && (u = A.A.A9F[A.RL]),
                    A.H.NQ && (u = A.H.NQ),
                    u)
                ) {
                    var p = A.ACH(u);
                    A.o = p.parse();
                }
                if (
                    ((A.LL = zingchart.ASYNC),
                    A.assign_a([
                        ["utc", "UN", "b"],
                        ["timezone", "NB", "f"],
                        ["async", "LL", "b"],
                        ["stacked", "CE", "b"],
                        ["stack-type", "KR"],
                        ["animate-type", "A1T"],
                        ["url-data", "A9R"],
                        ["page", "L6", "i"],
                        ["palette", "BP"],
                        ["sort-objects", "A5M", "b"],
                        ["description", "OZ"],
                    ]),
                    A.BP.length > 0)
                )
                    for (C.B8.palette = [], n = 0; n < A.BP.length; n++) {
                        var Z = A.BP[n],
                            h = ZC.AP.JM(A.BP[n], 10),
                            d = ZC.AP.R0(A.BP[n], 10);
                        C.B8.palette.push(["#fff", Z, h, d]);
                    }
                "pie3d" === A.AF && (A.F0.true3d = !0),
                    (A.AJ["3d"] || A.A.A17) && (A.LL = !1),
                    A.AC1(),
                    -1 === ZC.AV(A.H.KP, "skip_interactivity") &&
                        ((null !== ZC._n_((e = A.o.preview)) || C.PN("preview", A.AF)) &&
                            A.AJ["enable-preview"] &&
                            ((A.B9 && !A.D["force-preview-parse"]) ||
                                "undefined" == typeof ZC.A28 ||
                                ((A.D["force-preview-parse"] = !1),
                                (A.B9 = new ZC.A28(A)),
                                (A.B9.OE = "preview"),
                                C.load(A.B9.o, c + ".preview"),
                                "yx" === A.AJ.layout && C.load(A.B9.o, c + ".preview[yx]"),
                                (i = A.o.plotarea) &&
                                    A.B9.append({
                                        "background-color": i["background-color"],
                                        "background-color-1": i["background-color-1"],
                                        "background-color-2": i["background-color-2"],
                                        "gradient-stops": i["gradient-stops"],
                                        "gradient-colors": i["gradient-colors"],
                                    }),
                                A.B9.append(e),
                                A.B9.parse())),
                        (null !== ZC._n_((e = A.o["scroll-x"])) || C.PN("scroll-x", A.AF)) &&
                            A.AJ["enable-scroll"] &&
                            (A.HQ || "undefined" == typeof ZC.ZH || ((A.HQ = new ZC.ZH(A, "x")), (A.HQ.OE = "scrollx"), C.load(A.HQ.o, c + ".scroll-x"), A.HQ.append(e), A.HQ.parse())),
                        (null !== ZC._n_((e = A.o["scroll-y"])) || C.PN("scroll-y", A.AF)) &&
                            A.AJ["enable-scroll"] &&
                            (A.HP || "undefined" == typeof ZC.ZH || ((A.HP = new ZC.ZH(A, "y")), (A.HP.OE = "scrolly"), C.load(A.HP.o, c + ".scroll-y"), A.HP.append(e), A.HP.parse()))),
                    A.setupPlotArea(),
                    A.NW(),
                    (A.BO = []),
                    A.ACN(),
                    A.AA5(1),
                    null !== ZC._n_((e = A.o.series)) && (A.AZ.o = e);
                var f = A.AZ.o;
                for (n = 0; n < f.length; n++) if (f[n].rel) for (s = 0; s < f.length; s++) f[s].id && f[s].id === f[n].rel && (A.AZ.o[n].values = [].concat(A.AZ.o[s].values));
                if (
                    (A.AZ.parse(),
                    A.AA5(2),
                    (null !== ZC._n_((e = A.o.title)) || C.PN("title", A.AF)) &&
                        ((A.IR = new ZC.DN(A)), (A.IR.OE = "title"), C.load(A.IR.o, c + ".title"), A.IR.append(e), (A.IR.L = A.L + "-title"), (A.IR.K8 = !0), A.IR.parse(), null === ZC._n_(A.IR.o.x)))
                ) {
                    var _ = A.iX,
                        g = A.I;
                    switch (("plotarea" === A.IR.o["center-point"] && ((_ = A.P.iX), (g = A.P.I)), A.IR.OD)) {
                        case "left":
                            A.IR.iX = _;
                            break;
                        case "center":
                            A.IR.iX = _ + g / 2 - A.IR.I / 2;
                            break;
                        case "right":
                            A.IR.iX = _ + g - A.IR.I;
                    }
                }
                (null !== ZC._n_((e = A.o.subtitle)) || C.PN("subtitle", A.AF)) && ((A.K1 = new ZC.DN(A)), (A.K1.OE = "subtitle"), C.load(A.K1.o, c + ".subtitle"), A.K1.append(e), (A.K1.L = A.L + "-subtitle"), A.K1.parse()),
                    null !== ZC._n_((e = A.o.source)) && ((A.MV = new ZC.DN(A)), (A.MV.OE = "source"), C.load(A.MV.o, c + ".source"), A.MV.append(e), (A.MV.L = A.L + "-source"), A.MV.parse()),
                    "undefined" != typeof ZC.V6 &&
                        (null !== ZC._n_((e = A.o.legend)) || C.PN("legend", A.AF)) &&
                        ((A.BE = new ZC.V6(A)),
                        (A.BE.L = A.L + "-legend"),
                        "undefined" != typeof e.alpha && e.alpha < 0.1 && "undefined" == typeof e["border-width"] && "undefined" == typeof e["border-alpha"] && (e["border-alpha"] = e.alpha),
                        C.load(A.BE.o, c + ".legend"),
                        A.BE.alignPosition(e),
                        ((null !== ZC._n_(e) && null !== ZC._n_(e.position)) || null !== ZC._n_(A.BE.o.position)) && C.load(A.BE.o, c + ".legend[position]"),
                        A.BE.append(e),
                        ZC._b_(A.BE.o.shared) && ((A.BE.D["p-x"] = A.A.iX), (A.BE.D["p-y"] = A.A.iY), (A.BE.D["p-width"] = A.A.I), (A.BE.D["p-height"] = A.A.F)),
                        A.BE.alignPosition(e),
                        A.BE.parse());
                var v = !1,
                    b = A.iX,
                    B = A.iY,
                    m = A.I,
                    D = A.F,
                    E = "";
                if (A.IR && A.IR.AN && A.IR.o["adjust-layout"] && ((v = !0), (t = A.IR.iY + A.IR.F / 2) < B + D / 2 && ((E = "top"), (D = B + D - A.IR.F - A.IR.iY), (B = A.IR.iY + A.IR.F), A.K1 && A.K1.o["adjust-layout"]))) {
                    var L = A.K1.iY + A.K1.F / 2;
                    L < B + D / 2 && L > t && ((D -= A.K1.F), (B += A.K1.F));
                }
                if (
                    (A.MV && A.MV.AN && A.MV.o["adjust-layout"] && ((v = !0), (t = A.MV.iY + A.MV.F / 2) > B + D / 2 && (D -= A.MV.F)),
                    A.B9 &&
                        A.B9.AN &&
                        A.B9.o["adjust-layout"] &&
                        ((v = !0),
                        "xy" === A.AJ.layout
                            ? (t = A.B9.AR.iY + A.B9.AR.F / 2) > B + D / 2
                                ? (D -= A.B9.AR.F + A.B9.AR.DR)
                                : ((B = A.B9.AR.iY + A.B9.AR.F), (D -= A.B9.AR.F))
                            : (_ = A.B9.AR.iX + A.B9.AR.I / 2) < b + m / 2
                            ? ((m -= A.B9.AR.I + A.B9.AR.DZ), (b += A.B9.AR.I + A.B9.AR.DZ))
                            : ((b = A.B9.AR.iX + A.B9.AR.I), (m -= A.B9.AR.I))),
                    A.BE && A.BE.AN && A.BE.o["adjust-layout"])
                ) {
                    v = !0;
                    var F = A.BE.D4 && A.BE.D4.enabled ? 15 : 5;
                    if ("top" === E && A.BE.iY < A.IR.iY + A.IR.F + 5) {
                        if (null !== ZC._n_(A.BE.o.position)) {
                            var I = ("" + A.BE.o.position).split(" ");
                            A.BE.o.position = I[0] + " " + (A.IR.iY - A.iY + A.IR.F + A.BE.MC + F);
                        } else A.BE.o["margin-top"] = A.IR.iY - A.iY + A.IR.F + A.BE.MC;
                        A.BE.parse();
                    }
                    A.BE.fixPlacement(), (t = A.BE.iY + A.BE.F / 2);
                    var x = "",
                        y = (ZC.MAX, A.BE.D["position-info"]),
                        w = { Bottom: A.BE.iY - A.iY, Top: A.iY + A.F - A.BE.iY - A.BE.F, Right: A.BE.iX - A.iX, Left: A.iX + A.I - A.BE.iX - A.BE.I },
                        Y = "";
                    if (A.BE.I / A.BE.F > 2) Y = "v";
                    else if (A.BE.F / A.BE.I > 2) Y = "h";
                    else {
                        Y = Math.max(w.Left * A.F, w.Right * A.F) / Math.max(w.Top * A.I, w.Bottom * A.I) > 1 ? "h" : "v";
                    }
                    if (y)
                        y[0] >= 0.8
                            ? (x = y[1] <= 0.2 ? ("v" === Y ? "top" : "right") : y[1] >= 0.8 && "v" === Y ? "bottom" : "right")
                            : y[0] <= 0.2
                            ? (x = y[1] <= 0.2 ? ("v" === Y ? "top" : "left") : y[1] >= 0.8 && "v" === Y ? "bottom" : "left")
                            : y[1] <= 0.2
                            ? (x = "top")
                            : y[1] >= 0.8 && (x = "bottom");
                    else
                        Math.min(w.Top, w.Bottom) / Math.max(w.Top, w.Bottom) < Math.min(w.Left, w.Right) / Math.max(w.Left, w.Right)
                            ? w.Top > w.Bottom
                                ? ((x = "top"), A.BE.E9)
                                : ((x = "bottom"), A.BE.DR)
                            : w.Left > w.Right
                            ? ((x = "left"), A.BE.DZ)
                            : ((x = "right"), A.BE.E8);
                    var X = 0;
                    "top" === x && ((D = B + D - A.BE.F - A.BE.iY), (B = A.BE.iY + A.BE.F)),
                        "bottom" === x && (D -= X = D - A.BE.iY + B + A.BE.FM + A.BE.FT),
                        "left" === x && ((b += X = A.BE.iX - A.iX + A.BE.I), (m -= X)),
                        "right" === x && (m -= X = m - (A.BE.iX - A.iX) + A.BE.EQ + A.BE.FN);
                } else A.BE && A.BE.fixPlacement();
                v && ((A.D["plotarea-p-x"] = b), (A.D["plotarea-p-y"] = B), (A.D["plotarea-p-width"] = m), (A.D["plotarea-p-height"] = D), A.setupPlotArea()),
                    A.setupDynamicPlotArea(),
                    A.AZ.parseLayout && A.AZ.parseLayout(!0),
                    A.B9 &&
                        A.B9.o["adjust-layout"] &&
                        ("xy" === A.AJ.layout
                            ? (null === ZC._n_(A.B9.JE.x) && (A.B9.AR.iX = A.P.iX), null === ZC._n_(A.B9.JE.width) && (A.B9.AR.I = A.P.I))
                            : (null === ZC._n_(A.B9.JE.y) && (A.B9.AR.iY = A.P.iY), null === ZC._n_(A.B9.JE.height) && (A.B9.AR.F = A.P.F)));
                var M = 0;
                for (n = 0; n < A.AZ.A3.length; n++) M += A.AZ.A3[n].S.length;
                null !== ZC._n_((e = A.o["no-data"])) && 0 === M
                    ? ((A.S6 = new ZC.DN(A)), (A.S6.OE = "nodata"), C.load(A.S6.o, c + ".noData"), A.S6.append({ x: A.P.iX, y: A.P.iY, width: A.P.I, height: A.P.F }), A.S6.append(e), (A.S6.L = A.L + "-nodata"), A.S6.parse())
                    : (A.S6 = null),
                    A.D["plotarea-margins"] &&
                        ((A.D["plotarea-margins"] = null),
                        (A.o.plotarea = A.o.plotarea || {}),
                        (A.o.plotarea.margin = A.D["plotarea-margin"]),
                        (A.o.plotarea["margin-top"] = A.D["plotarea-margin-top"]),
                        (A.o.plotarea["margin-right"] = A.D["plotarea-margin-right"]),
                        (A.o.plotarea["margin-bottom"] = A.D["plotarea-margin-bottom"]),
                        (A.o.plotarea["margin-left"] = A.D["plotarea-margin-left"]));
                var K = ["top", "right", "bottom", "left"];
                for (n = 0; n < K.length; n++) A.D["plotarea.d-margin-" + K[n]] = null;
                if ((ZC.Q.ET(A.A.L + "-tooltip"), "undefined" != typeof A.D.datalength && null !== ZC._n_(A.D.datalength) && A.D.datalength.length > 0 && "canvas" !== A.H.AC && A.AZ.A3))
                    for (var S = 0, P = A.AZ.A3.length; S < P; S++) {
                        if (A.AZ.A3[S].S.length < A.D.datalength[S])
                            for (o = A.AZ.A3[S].S.length, r = A.D.datalength[S]; o < r; o++)
                                (l = A.L + "-plotset-plot-" + S + "-node-" + o),
                                    ZC.Q.ET([l + "-path", l + "-area-path", l + "-sh-path"]),
                                    -1 !== ZC.AV(["scatter", "bubble"], A.AF) && ZC.Q.ET([l + "-marker-gradient", l + "-marker-path", l + "-marker-sh-path", l + "-marker-circle", l + "-marker-sh-circle"]),
                                    (A.EN[S + "-" + o] = null);
                        if (-1 === ZC.AV(["scatter", "bubble"], A.AF) || ZC.A5.browser.webkit)
                            for (o = 0, r = A.D.datalength[S]; o < r; o++)
                                (l = A.L + "-plotset-plot-" + S + "-node-" + o), ZC.Q.ET([l + "-marker-gradient", l + "-marker-path", l + "-marker-sh-path", l + "-marker-circle", l + "-marker-sh-circle"]);
                    }
                for (A.D.datalength = null, n = 0, a = A.AZ.A3.length; n < a; n++) A.GE = A.GE || A.AZ.A3[n].GE;
                (A.HH || "undefined" == typeof ZC.PG) && (A.GE = !1),
                    A.GE &&
                        (A.LW.onStop = function () {
                            A.MF = "ready";
                        }),
                    -1 === ZC.AV(A.H.KP, "skip_interactivity") &&
                        ((A.H2 = new ZC.HN(A)),
                        (A.H2.L = A.L + "-zoom"),
                        C.load(A.H2.o, c + ".zoom"),
                        A.H2.append(A.o.zoom),
                        (A.A7 = new ZC.DN(A)),
                        (A.A7.OE = "tooltip"),
                        A.o.tooltip && A.o.tooltip.placement && A.o.tooltip.placement.indexOf("node") > -1 ? C.load(A.A7.o, c + ".tooltip[dynamic]") : C.load(A.A7.o, c + ".tooltip"),
                        A.A7.append(A.o.tooltip),
                        (A.A7.Q0 = !0),
                        A.A7.parse(),
                        null !== ZC._n_((e = A.o.guide)) && (A.o["crosshair-x"] = e),
                        (null !== ZC._n_((e = A.o["crosshair-x"])) || C.PN("guide", A.AF) || C.PN("crosshair-x", A.AF)) &&
                            A.AJ["enable-guide"] &&
                            ((A.CX = new ZC.D0(A)), (A.CX.OE = "crosshairx"), C.load(A.CX.o, [c + ".guide", c + ".crosshair-x"], !0, !0), A.CX.append(e), A.CX.parse(), (A.D["guide-on"] = !0)),
                        (null !== ZC._n_((e = A.o["crosshair-y"])) || C.PN("crosshair-y", A.AF)) &&
                            A.AJ["enable-guide"] &&
                            ((A.HB = new ZC.D0(A)), (A.HB.OE = "crosshairy"), C.load(A.HB.o, [c + ".guide", c + ".crosshair-y"], !0, !0), A.HB.append(e), A.HB.parse(), (A.D["guide-on"] = !0))),
                    A.OW(),
                    ZC.AP.C0("gparse", A.A, A.GY()),
                    null !== ZC._n_((e = A.o.refresh)) &&
                        ((A.HS = { type: "full", interval: 10, transport: "http", method: "pull", "adjust-scale": !1, "max-ticks": 20, "reset-timeout": 100, "stop-timeout": 0, storage: !1, "storage-size": 1e3 }),
                        ZC._cp_(e, A.HS),
                        (A.UB = 1)),
                    (A.MF = "parse.complete");
            },
            OW: function () {},
            PZ: function () {},
            M5: function (e, i, t) {
                var n = this,
                    a = (t = t || n.P).iX,
                    l = t.iY,
                    o = t.I,
                    r = t.F;
                if ("svg" === i) {
                    if (n.AJ["3d"]) {
                        var s,
                            A = [];
                        e = 1;
                        var C,
                            c,
                            u,
                            p,
                            Z = [],
                            h = a - ZC.AO.E4,
                            d = l - ZC.AO.E5;
                        (s = new ZC.CF(n, h + o / 2 - e, d - e, ZC.AO.FU)),
                            (p = ZC._i_(s.ED[1])),
                            (s = new ZC.CF(n, h + o / 2 - e, d - e, 0)),
                            (u = ZC._i_(s.ED[1])),
                            Z.push(new ZC.CF(n, h - e, d - e, p < u ? ZC.AO.FU : 0), new ZC.CF(n, h + o + e, d - e, p < u ? ZC.AO.FU : 0)),
                            (s = new ZC.CF(n, h + o - e, d + r / 2 - e, ZC.AO.FU)),
                            (C = ZC._i_(s.ED[0])),
                            (s = new ZC.CF(n, h + o - e, d + r / 2 - e, 0)),
                            (c = ZC._i_(s.ED[0])),
                            Z.push(new ZC.CF(n, h + o + e, d - e, C > c ? ZC.AO.FU : 0), new ZC.CF(n, h + o + e, d + r + e, C > c ? ZC.AO.FU : 0)),
                            (s = new ZC.CF(n, h + o / 2 - e, d + r + e, ZC.AO.FU)),
                            (p = ZC._i_(s.ED[1])),
                            (s = new ZC.CF(n, h + o / 2 - e, d + r + e, 0)),
                            (u = ZC._i_(s.ED[1])),
                            Z.push(new ZC.CF(n, h + o + e, d + r + e, p > u ? ZC.AO.FU : 0), new ZC.CF(n, h - e, d + r + e, p > u ? ZC.AO.FU : 0)),
                            (s = new ZC.CF(n, h - e, d + r / 2 - e, ZC.AO.FU)),
                            (C = ZC._i_(s.ED[0])),
                            (s = new ZC.CF(n, h - e, d + r / 2 - e, 0)),
                            (c = ZC._i_(s.ED[0])),
                            Z.push(new ZC.CF(n, h - e, d + r + e, C < c ? ZC.AO.FU : 0), new ZC.CF(n, h - e, d - e, C < c ? ZC.AO.FU : 0)),
                            Z.push(Z[0]);
                        for (var f = 0; f < Z.length; f++) (s = Z[f]), A.push([ZC._i_(s.ED[0]), ZC._i_(s.ED[1])].join(","));
                        return A.join(" ");
                    }
                    return [[a - e, l - e].join(","), [a + o + e, l - e].join(","), [a + o + e, l + r + e].join(","), [a - e, l + r + e].join(","), [a - e, l - e].join(",")].join(" ");
                }
                return "box" === i ? a - e + "," + (l - e) + "," + (o + 2 * e) + "," + (r + 2 * e) : (n.AJ["3d"] && (e += 10), "rect(" + (l - e) + "px," + (a + o + e) + "px," + (l + r + e) + "px," + (a - e) + "px)");
            },
            autoFit: function () {
                var e,
                    i = this;
                if (i.AJ["3d"] && i.F0["auto-fit"]) {
                    var t = !1;
                    for (i.F0.zoom = 1; !t && i.F0.zoom > 0.25; ) {
                        t = !0;
                        var n = i.M5(0, "svg").split(" ");
                        for (e = 0; e < n.length; e++) {
                            var a = n[e].split(",");
                            (ZC._i_(a[0]) < i.iX + i.P.DZ || ZC._i_(a[0]) > i.iX + i.I - i.P.E8 || ZC._i_(a[1]) < i.iY + i.P.E9 || ZC._i_(a[1]) > i.iY + i.F - i.P.DR) && (t = !1);
                        }
                        t || (i.F0.zoom -= 0.05), t && (i.F0.zoom -= 0.025);
                    }
                }
            },
            build: function () {
                var e,
                    i,
                    t,
                    n,
                    a,
                    l,
                    o,
                    r,
                    s = this,
                    A = s.A.I + "/" + s.A.F,
                    C = "0/0";
                if ((s.autoFit(), !s.H.usc())) {
                    var c = 2,
                        u = 6;
                    if (
                        (null !== ZC._n_((e = s.P.o["mask-tolerance"])) && (e instanceof Array ? ((c = u = ZC._i_(e[0])), e.length > 1 && (u = ZC._i_(e[1]))) : (c = u = ZC._i_(e))),
                        "svg" === s.A.AC &&
                            s.AJ.clip &&
                            (ZC.Q.ET([s.L + "-clip", s.L + "-clip-hover", s.L + "-clip-preview"]),
                            s.A.KD.appendChild(ZC.Q.XD({ id: s.L + "-clip", path: s.M5(c, "svg") })),
                            s.A.KD.appendChild(ZC.Q.XD({ id: s.L + "-clip-hover", path: s.M5(u, "svg") })),
                            s.B9))
                    ) {
                        var p = s.AJ["3d"];
                        (s.AJ["3d"] = !1), s.A.KD.appendChild(ZC.Q.XD({ id: s.L + "-clip-preview", path: s.M5(0, "svg", s.B9.AR) })), (s.AJ["3d"] = p);
                    }
                    var Z = !s.AJ.clip,
                        h = Z ? null : s.M5(c),
                        d = Z ? null : "url(#" + s.L + "-clip)",
                        f = Z ? null : s.M5(u),
                        _ = Z ? null : "url(#" + s.L + "-clip-hover)";
                    if (
                        (s.B9 && ((a = Z ? null : s.M5(0, s.A.AC, s.B9.AR)), (l = Z ? null : "url(#" + s.L + "-clip-preview)")),
                        ZC.Q.JZ({ cls: "zc-abs", id: s.L, p: ZC.AL(s.A.L + "-graphset"), tl: C, wh: A }, s.A.AC),
                        s.A.O1.graph && ZC.Q.HE({ cls: "zc-abs zc-layer zc-persistent", id: s.L + "-c", p: ZC.AL(s.L), wh: A }, s.A.AC),
                        ZC.Q.JZ({ id: s.L + "-plotarea", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute" }, s.A.AC),
                        s.o.plotarea && s.A.O1.plotarea && ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-plotarea-c", p: ZC.AL(s.L + "-plotarea"), wh: A }, s.A.AC),
                        "null" !== s.AF && s.A.O1.plots)
                    ) {
                        for (ZC.Q.JZ({ id: s.L + "-scales-bl", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute", "clip-path": d, clip: h }, s.A.AC), i = 0; i < s.A5Q; i++)
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-scales-bl-" + i + "-c", p: ZC.AL(s.L + "-scales-bl"), wh: A }, s.A.AC);
                        if (s.AZ.D["plot-sort"]) {
                            for (i = 0, t = s.AZ.A3.length; i < t; i++) {
                                for (s.AZ.A3[i].UD = {}, n = 0; n < s.AZ.A3[i].SW; n++) ZC.Q.ET(s.L + "-plots-bl-" + n);
                                for (n = 0; n < s.AZ.A3[i].A1K; n++) ZC.Q.ET(s.L + "-plots-fl-" + n);
                            }
                            delete s.AZ.D["plot-sort"];
                        }
                        if (s.A.K8 || s.AJ["3d"])
                            ZC.AL(s.L + "-plots-bl") || ZC.Q.JZ({ id: s.L + "-plots-bl", p: ZC.AL(s.L), after: ZC.AL(s.L + "-scales-bl"), tl: C, wh: A, position: "absolute", "clip-path": d, clip: h }, s.A.AC),
                                (o = ZC.Q.HE({ cls: "zc-abs zc-layer zc-bl", id: s.L + "-plots-bl-c", p: ZC.AL(s.L + "-plots-bl"), wh: A }, s.A.AC)).setAttribute("data-clip", s.M5(c, "box"));
                        else
                            for (i = 0, t = s.AZ.A3.length; i < t; i++)
                                for (r = s.AZ.M3[i], n = s.AZ.A3[i].SW - 1; n >= 0; n--)
                                    ZC.AL(s.L + "-plots-bl-" + n) || ZC.Q.JZ({ id: s.L + "-plots-bl-" + n, p: ZC.AL(s.L), after: ZC.AL(s.L + "-scales-bl"), tl: C, wh: A, position: "absolute", "clip-path": d, clip: h }, s.A.AC),
                                        (o = ZC.Q.HE({ cls: "zc-abs zc-layer zc-bl", id: s.L + "-plot-" + r + "-bl-" + n + "-c", p: ZC.AL(s.L + "-plots-bl-" + n), wh: A }, s.A.AC)).setAttribute("data-clip", s.M5(c, "box")),
                                        (o.style.display = "block");
                        for (i = 0; i < s.VF; i++) ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-scales-ml-" + i + "-c", p: ZC.AL(s.L), wh: A }, s.A.AC);
                        if (s.A.K8 || s.AJ["3d"])
                            ZC.AL(s.L + "-plots-fl") || ZC.Q.JZ({ id: s.L + "-plots-fl", p: ZC.AL(s.L), after: ZC.AL(s.L + "-scales-ml-" + (s.VF - 1) + "-c"), tl: C, wh: A, position: "absolute" }, s.A.AC),
                                (o = ZC.Q.HE({ cls: "zc-abs zc-layer zc-fl", id: s.L + "-plots-fl-c", p: ZC.AL(s.L + "-plots-fl"), wh: A }, s.A.AC)).setAttribute("data-clip", s.M5(u, "box"));
                        else
                            for (i = 0, t = s.AZ.A3.length; i < t; i++)
                                for (r = s.AZ.M3[i], n = s.AZ.A3[i].A1K - 1; n >= 0; n--)
                                    ZC.AL(s.L + "-plots-fl-" + n) || ZC.Q.JZ({ id: s.L + "-plots-fl-" + n, p: ZC.AL(s.L), after: ZC.AL(s.L + "-scales-ml-" + (s.VF - 1) + "-c"), tl: C, wh: A, position: "absolute" }, s.A.AC),
                                        (o = ZC.Q.HE({ cls: "zc-abs zc-layer zc-fl", id: s.L + "-plot-" + r + "-fl-" + n + "-c", p: ZC.AL(s.L + "-plots-fl-" + n), wh: A }, s.A.AC)).setAttribute("data-clip", s.M5(u, "box")),
                                        (o.style.display = "block");
                        for (
                            zingchart.DEV.PLOTSHLAYER &&
                                (ZC.Q.JZ({ id: s.L + "-plots-hover", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute" }, s.A.AC),
                                ZC.Q.HE({ cls: "zc-abs zc-layer zc-fl", id: s.L + "-plots-hover-c", p: ZC.AL(s.L + "-plots-hover"), wh: A }, s.A.AC)),
                                ZC.Q.JZ({ id: s.L + "-scales-fl", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute", "clip-path": d, clip: h }, s.A.AC),
                                i = 0;
                            i < s.A56;
                            i++
                        )
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-scales-fl-" + i + "-c", p: ZC.AL(s.L + "-scales-fl"), wh: A }, s.A.AC);
                        if (
                            (s.B9 &&
                                (ZC.Q.JZ({ id: s.L + "-preview", p: ZC.AL(s.A.L + "-tools"), tl: C, wh: A, position: "absolute", "clip-path": l, clip: a }, s.A.AC),
                                ZC.Q.HE({ cls: "zc-abs", id: s.L + "-preview-c", p: ZC.AL(s.L + "-preview"), wh: A }, s.A.AC)),
                            ZC.Q.JZ({ id: s.L + "-scroll", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute" }, s.A.AC),
                            s.o["scroll-x"] && ZC.Q.HE({ cls: "zc-abs", id: s.L + "-scroll-x-c", p: ZC.AL(s.L + "-scroll"), wh: A }, s.A.AC),
                            s.o["scroll-y"] && ZC.Q.HE({ cls: "zc-abs", id: s.L + "-scroll-y-c", p: ZC.AL(s.L + "-scroll"), wh: A }, s.A.AC),
                            ZC.Q.JZ({ id: s.L + "-plots-vb", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute" }, s.A.AC),
                            s.A.O1["value-box"])
                        )
                            if (s.A.K8 || s.AJ["3d"]) ZC.Q.HE({ cls: "zc-abs zc-layer zc-vb", id: s.L + "-plots-vb-c", p: ZC.AL(s.L + "-plots-vb"), wh: A }, s.A.AC);
                            else for (i = 0, t = s.AZ.A3.length; i < t; i++) ZC.Q.HE({ cls: "zc-abs zc-layer zc-vb", id: s.L + "-plot-" + i + "-vb-c", p: ZC.AL(s.L + "-plots-vb"), wh: A }, s.A.AC);
                    }
                    (s.o.title || s.o.subtitle || s.o.source || s.o["no-data"]) &&
                        (ZC.Q.JZ({ id: s.L + "-titles", p: ZC.AL(s.L), tl: C, wh: A, position: "absolute" }, s.A.AC), ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-titles-c", p: ZC.AL(s.L + "-titles"), wh: A }, s.A.AC)),
                        ZC.Q.JZ({ cls: "zc-abs", wh: A, id: s.L + "-hover", p: ZC.AL(s.A.L + "-hover"), "clip-path": _, clip: f }, s.A.AC),
                        "canvas" === s.A.AC && (ZC.AL(s.L + "-hover").style.clip = f),
                        ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-hover-c", p: ZC.AL(s.L + "-hover"), wh: A }, s.A.AC),
                        s.A.O1.maps &&
                            -1 !== JSON.stringify(s.o).indexOf("zingchart.maps") &&
                            (ZC.Q.JZ({ cls: "zc-abs", wh: A, id: s.L + "-objects-maps", p: ZC.AL(s.A.L + "-objects-maps"), "clip-path": _, clip: f }, s.A.AC),
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-objects-maps-sh-c", p: ZC.AL(s.L + "-objects-maps"), wh: A }, s.A.AC),
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-objects-maps-c", p: ZC.AL(s.L + "-objects-maps"), wh: A }, s.A.AC),
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-objects-maps-click-c", p: ZC.AL(s.L + "-objects-maps"), wh: A }, s.A.AC),
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-objects-maps-hover-c", p: ZC.AL(s.L + "-objects-maps"), wh: A }, s.A.AC),
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-objects-maps-print-c", p: ZC.AL(s.L + "-objects-maps"), wh: A, display: "none" }, s.A.AC)),
                        s.initObjectsLayers(),
                        s.o.legend &&
                            (ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-legend-c", p: ZC.AL(s.A.L + "-legend"), wh: A }, s.A.AC),
                            ZC.Q.HE({ cls: "zc-abs zc-layer", id: s.L + "-legend-scroll-c", p: ZC.AL(s.A.L + "-legend"), wh: A }, s.A.AC));
                }
                s.Z = s.H.usc() ? s.H.mc() : ZC.AL(s.L + "-c");
            },
            initObjectsLayers: function () {
                var e = this,
                    i = e.A.I + "/" + e.A.F;
                !ZC.AL(e.L + "-objects-bottom") &&
                    e.A.O1["objects-bottom"] &&
                    (e.o.shapes || e.o.labels || e.o.arrows || e.o.images) &&
                    (ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-bottom", p: ZC.AL(e.A.L + "-objects-bottom") }, e.A.AC),
                    ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-bottom-sh-c", p: ZC.AL(e.L + "-objects-bottom"), wh: i }, e.A.AC),
                    ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-bottom-c", p: ZC.AL(e.L + "-objects-bottom"), wh: i }, e.A.AC)),
                    !ZC.AL(e.L + "-objects-top") &&
                        e.A.O1["objects-top"] &&
                        (e.o.shapes || e.o.labels || e.o.arrows || e.o.images) &&
                        (ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-top", p: ZC.AL(e.A.L + "-objects-top") }, e.A.AC),
                        ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-top-sh-c", p: ZC.AL(e.L + "-objects-top"), wh: i }, e.A.AC),
                        ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-top-c", p: ZC.AL(e.L + "-objects-top"), wh: i }, e.A.AC)),
                    (e.A.O1["objects-bottom"] || e.A.O1["objects-top"]) &&
                        (e.o.shapes || e.o.labels || e.o.arrows) &&
                        ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-print-c", p: ZC.AL(e.L + "-objects-top"), wh: i, display: "none" }, e.A.AC),
                    !ZC.AL(e.L + "-objects-click") &&
                        (e.A.O1["objects-bottom"] || e.A.O1["objects-top"]) &&
                        (e.o.shapes || e.o.labels || e.o.arrows || e.o.images) &&
                        (ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-click", p: ZC.AL(e.A.L + "-hover") }, e.A.AC), ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-click-c", p: ZC.AL(e.L + "-objects-click"), wh: i }, e.A.AC)),
                    !ZC.AL(e.L + "-objects-hover") &&
                        (e.A.O1["objects-bottom"] || e.A.O1["objects-top"]) &&
                        (e.o.shapes || e.o.labels || e.o.arrows || e.o.images) &&
                        (ZC.Q.JZ({ cls: "zc-abs", wh: i, id: e.L + "-objects-hover", p: ZC.AL(e.A.L + "-hover") }, e.A.AC), ZC.Q.HE({ cls: "zc-abs zc-layer", id: e.L + "-objects-hover-c", p: ZC.AL(e.L + "-objects-hover"), wh: i }, e.A.AC));
            },
            A0J: function () {},
            clear_: function () {},
            destroy: function () {
                var e,
                    i = this;
                null !== ZC._n_((e = i.A.SD[i.L])) && "feed" === i.HS.type && (e.send("zingchart.stopfeed"), e.close(), (i.A.SD[i.L] = null)),
                    i.GE && i.LW.stop(!0),
                    (i.MF = "clear.init"),
                    i.unbind(),
                    i.BE && i.BE.unbind(),
                    i.B9 && i.B9.unbind(),
                    i.HQ && i.HQ.unbind(),
                    i.HP && i.HP.unbind(),
                    (i.MF = "clear.complete");
            },
            clear: function (e, i) {
                null === ZC._n_(e) && (e = !1), null === ZC._n_(i) && (i = !1);
                var t,
                    n,
                    a,
                    l = this;
                if (
                    ((l.TE = {}),
                    null === ZC._n_((t = l.A.SD[l.L])) || e || ("feed" === l.HS.type && (t.send("zingchart.stopfeed"), t.close(), (l.A.SD[l.L] = null))),
                    l.GE && l.LW.stop(!0),
                    (l.MF = "clear.init"),
                    l.unbind(e),
                    l.A0J(!1, !0),
                    l.LE(),
                    l.LE("click"),
                    l.LE("guide", !0),
                    l.LE("print", !0),
                    l.LE("textprint", !0),
                    e || ((!l.B9 || (l.B9 && !l.B9.LL)) && l.LE("static", !0)),
                    this.o.labels)
                )
                    for (var o = this.o.labels.length - 1; o >= 0; o--) this.o.labels[o].cls && "zcScaleMarkerLabel" === this.o.labels[o].cls && this.o.labels.splice(o, 1);
                (l.AZ.YS = []), (l.A.SR = []), zingchart.SKIP.LEGEND || (l.BE && l.BE.clear()), (l.D.datalength = []);
                var r,
                    s,
                    A,
                    C = ZC.ie67 ? ZC.AL(l.A.L) : null;
                if (ZC.mobile || ZC.ie67) ZC.A5("." + l.L + "-node-area", C).remove();
                else if (ZC.AL(l.A.L + "-img") && ZC.AL(l.A.L + "-map")) {
                    ZC.AL(l.A.L + "-img").setAttribute("useMap", "");
                    var c = ZC.AL(l.A.L + "-map").cloneNode(!0);
                    for (o = (n = c.childNodes.length) - 1; o >= 0; o--) -1 !== c.childNodes[o].className.indexOf(l.L + "-node-area") && c.removeChild(c.childNodes[o]);
                    ZC.Q.ET(l.A.L + "-map"), ZC.AL(l.A.L + "-top").appendChild(c), ZC.AL(l.A.L + "-img").setAttribute("useMap", "#" + l.A.L + "-map");
                }
                switch (
                    (ZC.Q.ET(l.L + "--graph"),
                    (l.AZ.HF = []),
                    ZC.A5("." + l.L + "-value-box", C).remove(),
                    ZC.A5("." + l.L + "-scale-marker-label", C).remove(),
                    ZC.A5("." + l.L + "-scale-item", C).remove(),
                    ZC.A5("." + l.L + "-scale-label", C).remove(),
                    ZC.A5("." + l.L + "-guide-label", C).remove(),
                    ZC.A5("." + l.L + "-shape-label", C).remove(),
                    ZC.A5("." + l.L + "-mapshape-label", C).remove(),
                    ZC.A5("." + l.L + "-node-errorbars", C).remove(),
                    e || ZC.A5("." + l.L + "-preview-item", C).remove(),
                    l.A.AC)
                ) {
                    case "svg":
                        for (o = 0, n = l.AZ.A3.length; o < n; o++) l.AZ.A3[o].HI = null;
                        ZC.A5("#" + l.A.L + "-defs")
                            .children()
                            .each(function () {
                                "LINK" !== this.tagName.toUpperCase() &&
                                    ((0 !== this.id.indexOf(l.L + "-") && 1 !== l.A.AG.length) ||
                                        (e
                                            ? this.id !== l.L + "-gradient" &&
                                              -1 === this.id.indexOf("-preview-gradient") &&
                                              -1 === this.id.indexOf("-menu-trigger-gradient") &&
                                              -1 !== this.id.indexOf(l.L + "-plotset-plot-") &&
                                              ((i && l.GE) || (-1 !== this.id.indexOf(l.L + "-legend-") && zingchart.SKIP.LEGEND) || ZC.A5(this).remove())
                                            : -1 === this.id.indexOf("zc-menu-") &&
                                              -1 === this.id.indexOf("-menu-trigger-") &&
                                              (-1 !== this.id.indexOf(l.L + "-legend-")
                                                  ? zingchart.SKIP.LEGEND || ZC.A5(this).remove()
                                                  : l.B9 && l.B9.LL
                                                  ? -1 === this.id.indexOf("-preview-gradient") && ZC.A5(this).remove()
                                                  : ZC.A5(this).remove())));
                            }),
                            e || ZC.Q.ET([l.L + "-clip", l.L + "-clip-hover", l.L + "-clip-preview"]),
                            ZC.A5("#" + l.A.L + "-svg")
                                .children()
                                .each(function () {
                                    var e = l.L + "-";
                                    "clippath" === this.tagName.toLowerCase() && this.id.substring(0, e.length) === e && this.id !== l.L + "-clip" && this.id !== l.L + "-clip-hover" && this.id !== l.L + "-clip-preview" && ZC.Q.ET(this.id);
                                });
                }
                (ZC.Q.ET(l.L + "-nodata"),
                ZC.Q.ET(l.A.L + "-tooltip-text-float"),
                e ||
                    (ZC.Q.ET([l.L + "-title", l.L + "-subtitle", l.L + "-source", l.L + "-hover"]),
                    zingchart.SKIP.LEGEND ||
                        (l.BE &&
                            (ZC.Q.ET(l.L + "-legend-c"),
                            ZC.Q.ET(l.L + "-legend-scroll-c"),
                            ZC.A5("." + l.L + "-legend-item-area", C).remove(),
                            ZC.A5("." + l.L + "-legend-marker-area", C).remove(),
                            ZC.A5("." + l.L + "-legend-item", C).remove(),
                            ZC.A5("." + l.L + "-legend-header", C).remove(),
                            ZC.A5("." + l.L + "-legend-footer", C).remove(),
                            ZC.A5("." + l.L + "-legend-frame", C).remove(),
                            l.BE.gc(),
                            (l.BE = null))),
                    l.B9 && ((l.B9.LL && !l.A.D.resize) || (l.B9.unbind(), ZC.A5("." + l.L + "-preview-handler").remove(), ZC.A5("." + l.L + "-preview-mask").remove(), ZC.A5("#" + l.L + "-preview").remove(), l.B9.gc(), (l.B9 = null))),
                    l.HQ && (l.HQ.unbind(), (l.HQ = null)),
                    ZC.Q.IV(ZC.AL(l.L + "-scroll-x-c"), l.A.AC, l.iX, l.iY, l.I, l.F, l.L),
                    ZC.Q.IV(ZC.AL(l.L + "-scroll-y-c"), l.A.AC, l.iX, l.iY, l.I, l.F, l.L),
                    ZC.A5("#" + l.L + "-scroll-x-handle").remove(),
                    ZC.A5("#" + l.L + "-scroll-x-bar").remove(),
                    l.HP && (l.HP.unbind(), (l.HP = null)),
                    ZC.A5("#" + l.L + "-scroll-y-handle").remove(),
                    ZC.A5("#" + l.L + "-scroll-y-bar").remove(),
                    ZC.A5("#" + l.L + "-c").empty(),
                    l.H.QS[0] !== l.H.QS[1] &&
                        "" !== l.H.QS[1] &&
                        ("canvas" === l.H.AC &&
                            ZC.A5("#" + l.L + " canvas").each(function () {
                                (this.width = 1), (this.height = 1), ZC.Q.ET(this);
                            }),
                        ZC.A5("#" + l.L + " div").each(function () {
                            ZC.Q.ET(this);
                        }),
                        ZC.Q.ET(l.L))),
                ZC.A5("#" + l.L + " .zc-layer").each(function () {
                    var t = ZC.Q.T4(this);
                    if (-1 === t.indexOf("zc-persistent")) {
                        if (e && (this.id === l.L + "-plotarea-c" || this.id === l.L + "-titles-c")) return;
                        if (-1 === this.id.indexOf(l.L + "-plot-") && -1 === this.id.indexOf(l.L + "-plots-")) ZC.Q.IV(this, l.H.AC, l.iX, l.iY, l.I, l.F, l.L);
                        else if (i && l.GE && !l.HH) {
                            if ("canvas" !== l.H.AC) for (var n = 0, o = l.AZ.A3.length; n < o; n++) l.D.datalength[n] = l.AZ.A3[n].S.length;
                            (a = l.A.K8 ? new RegExp("-plots-[a-z]+-c", "g").exec(this.id) : new RegExp("-plot-(\\d+)-[a-z]+-\\d+-", "g").exec(this.id)) &&
                                ((!l.D["plot" + a[1] + ".visible"] && "remove" === l.getToggleAction()) || l.A.K8) &&
                                ZC.Q.IV(this, l.H.AC, l.iX, l.iY, l.I, l.F, l.L),
                                (-1 === t.indexOf("zc-vb") && -1 === t.indexOf("zc-fl")) || ZC.Q.IV(this, l.H.AC, l.iX, l.iY, l.I, l.F, l.L);
                        } else ZC.Q.IV(this, l.H.AC, l.iX, l.iY, l.I, l.F, l.L);
                    }
                }),
                -1 !== ZC.AV(l.H.KP, "use_single_canvas")) &&
                    ((r = ZC.AL(l.H.L + "-main-c")) && ZC.Q.IV(r, l.H.AC, l.iX, l.iY, l.I, l.F, l.L),
                    (s = ZC.AL(l.H.L + "-main-c-top")) && ZC.Q.IV(s, l.H.AC, l.iX, l.iY, l.I, l.F, l.L),
                    (A = ZC.AL(l.H.L + "-print-c")) && ZC.Q.IV(A, l.H.AC, l.iX, l.iY, l.I, l.F, l.L));
                l.clear_(), (l.A.D.resize = !1), (l.MF = "clear.complete");
            },
            unbind: function (e, i) {
                null === ZC._n_(e) && (e = !1);
                var t = this;
                (-1 === ZC.AV(t.H.KP, "skip_interactivity") || i) &&
                    (ZC.A5("." + t.L + "-node-area")
                        .die("mousedown mouseover touchstart", t.X5)
                        .die("mouseup mouseout touchend", t.A1Q)
                        .die("mousemove touchmove", t.A0Q)
                        .die("click", t.TG)
                        .die("contextmenu", t.TG)
                        .die("dblclick", t.A1G),
                    t.BE &&
                        (zingchart.SKIP.LEGEND ||
                            (ZC.A5("." + t.L + "-legend-item-area")
                                .die("mouseup touchstart", t.SM)
                                .die("DOMMouseScroll", t.zc_legend_mousescroll)
                                .die("mousewheel", t.zc_legend_mousescroll),
                            ZC.A5("." + t.L + "-legend-marker-area")
                                .die("mouseup touchstart", t.SM)
                                .die("DOMMouseScroll", t.zc_legend_mousescroll)
                                .die("mousewheel", t.zc_legend_mousescroll),
                            ZC.A5("#" + t.L + "-legend-frame")
                                .die("DOMMouseScroll", t.zc_legend_mousescroll)
                                .die("mousewheel", t.zc_legend_mousescroll),
                            ZC.mobile ||
                                (ZC.A5("." + t.L + "-legend-item-area")
                                    .die(ZC.Q.C1("mouseover"), t.QZ)
                                    .die(ZC.Q.C1("mouseout"), t.RA)
                                    .die(ZC.Q.C1("mousemove"), t.PL),
                                ZC.A5("." + t.L + "-legend-marker-area")
                                    .die(ZC.Q.C1("mouseover"), t.QZ)
                                    .die(ZC.Q.C1("mouseout"), t.RA)
                                    .die(ZC.Q.C1("mousemove"), t.PL))))),
                    t.AC7();
            },
            AC7: function () {},
            S7: function () {},
            QM: function () {},
            KK: function () {},
            SF: function () {},
            S1: function () {},
            LE: function (e, i) {
                var t = this;
                (e = e || "hover"), null === ZC._n_(i) && (i = !1);
                var n = ZC.AL((i ? t.A.L : t.L) + "-" + e + "-c");
                n && (ZC.Q.IV(n, t.H.AC, t.iX, t.iY, t.I, t.F, t.L, "textprint" === e), ZC.A5("." + t.L + "-label-hover").remove()),
                    "hover" === e &&
                        (ZC.Q.IV(ZC.AL(t.L + "-objects-hover-c"), t.H.AC, t.iX, t.iY, t.I, t.F, t.L),
                        ZC.Q.IV(ZC.AL(t.L + "-objects-maps-hover-c"), t.H.AC, t.iX, t.iY, t.I, t.F, t.L),
                        zingchart.DEV.PLOTSHLAYER && ZC.Q.IV(ZC.AL(t.L + "-plots-hover-c"), t.H.AC, t.iX, t.iY, t.I, t.F, t.L)),
                    "click" === e && (ZC.Q.IV(ZC.AL(t.L + "-objects-click-c"), t.H.AC, t.iX, t.iY, t.I, t.F, t.L), ZC.Q.IV(ZC.AL(t.L + "-objects-maps-click-c"), t.H.AC, t.iX, t.iY, t.I, t.F, t.L)),
                    t.hideLayer_(e, i);
            },
            hideLayer_: function () {},
            A6U: function (e, i) {
                var t,
                    n = this;
                if (null !== ZC._n_(e) && null !== ZC._n_(i)) {
                    var a = n.AZ.A3[e].J0,
                        l = n.AZ.A3[e].RP;
                    if ("none" === a) return;
                    if (null !== ZC._n_(n.CD["p" + e])) {
                        if (null !== ZC._n_(n.CD["p" + e]["n" + i])) {
                            if ((delete n.CD["p" + e]["n" + i], l)) for (t = 0; t < n.AZ.A3.length; t++) delete n.CD["p" + t]["n" + i];
                        } else if (("graph" === a ? ((n.CD = {}), (n.CD["p" + e] = {})) : "plot" === a && (n.CD["p" + e] = {}), (n.CD["p" + e]["n" + i] = !0), l))
                            for (t = 0; t < n.AZ.A3.length; t++) (n.CD["p" + t] = n.CD["p" + t] || {}), (n.CD["p" + t]["n" + i] = !0);
                    } else if (("graph" === a && (n.CD = {}), (n.CD["p" + e] = {}), (n.CD["p" + e]["n" + i] = !0), l)) for (t = 0; t < n.AZ.A3.length; t++) (n.CD["p" + t] = n.CD["p" + t] || {}), (n.CD["p" + t]["n" + i] = !0);
                }
                null !== ZC._n_(e) && null !== ZC._n_(i) && ((n.HH = !0), n.K7(!0, !0));
            },
            paint: function (e) {
                null === ZC._n_(e) && (e = !1);
                var i,
                    t,
                    n,
                    a,
                    l,
                    o,
                    r = this;
                (r.A.GRAPHID = r.L), (r.V0 = e), window.clearTimeout(ZC.ASYNC_TICK[r.L]), r.A.clearLabelBoxes("vb" + r.K);
                var s,
                    A,
                    C,
                    c,
                    u,
                    p,
                    Z,
                    h = r.BW("k")[0],
                    d = ZC.MAX,
                    f = -ZC.MAX,
                    _ = {},
                    g = r.AZ.A3,
                    v = 0;
                for (c = 0; c < g.length; c++)
                    if (g[c].o.rel)
                        for (C = 0; C < g.length; C++)
                            if (g[C].o.id && g[C].o.id === g[c].o.rel) {
                                v++, (Z = !0);
                                var b = [];
                                for (l = 0; l < g[C].S.length; l++)
                                    (h.EF ? g[C].S[l].BV >= h.AY && g[C].S[l].BV <= h.BD : g[C].S[l].K >= h.W && g[C].S[l].K <= h.A1)
                                        ? ((s = g[C].S[l].AD),
                                          (d = Math.min(d, s)),
                                          (f = Math.max(f, s)),
                                          Z ? ((Z = !1), g[C].S[l].BV ? b.push([g[C].S[l].BV, 0]) : b.push(0), (p = s)) : g[C].S[l].BV ? b.push([g[C].S[l].BV, (100 * (s - p)) / p]) : b.push((100 * (s - p)) / p))
                                        : g[C].S[l].BV
                                        ? b.push([g[C].S[l].BV, 0])
                                        : b.push(0);
                                _["p-" + c] = [].concat(b);
                            }
                if (v > 0) {
                    for (d = ZC.MAX, f = -ZC.MAX, c = 0; c < g.length; c++)
                        if (g[c].o.rel && _["p-" + c])
                            for (l = 0; l < g[c].S.length; l++)
                                2 === (A = _["p-" + c][l]).length ? ((s = A[1]), (g[c].V[l] = A), (g[c].S[l].AD = g[c].S[l].CR = A[1])) : ((s = A), (g[c].V[l] = g[c].S[l].AD = g[c].S[l].CR = A)),
                                    g[c].FK(l),
                                    (d = Math.min(d, s)),
                                    (f = Math.max(f, s));
                    var B = r.BW("v")[0];
                    B.QH(d, f, !0), B.J2();
                }
                for (r.A.D["g-" + r.K + "-selection"] && (r.CD = JSON.parse(r.A.D["g-" + r.K + "-selection"])), r.KI = !1, t = 0, n = r.AZ.A3.length; t < n; t++) r.IX[t] = !1;
                for (t in r.CD)
                    if (r.CD.hasOwnProperty(t)) {
                        var m = ZC._i_(t.replace("p", ""));
                        for (u in r.CD[t])
                            if (r.CD[t].hasOwnProperty(u)) {
                                (r.IX[m] = !0), (r.KI = !0);
                                break;
                            }
                    }
                function D() {
                    if (r.AJ["3d"]) {
                        var e = ZC.DK.DC(r.P, r, r.P.iX - ZC.AO.E4, r.P.iX - ZC.AO.E4 + r.P.I, r.P.iY - ZC.AO.E5, r.P.iY - ZC.AO.E5 + r.P.F, ZC.AO.FU + 10, ZC.AO.FU + 10, "y"),
                            t = ZC.DK.DC(r.P, r, r.P.iX - ZC.AO.E4, r.P.iX - ZC.AO.E4 + r.P.I, r.P.iY - ZC.AO.E5, r.P.iY - ZC.AO.E5 + r.P.F, ZC.AO.FU, ZC.AO.FU, "y");
                        (t.L = r.L + "-plotarea"), (t.PB = e.E), r.CM.add(t);
                    } else {
                        r.P.Z = r.P.C7 = r.H.usc() ? r.H.mc() : ZC.AL(r.L + "-plotarea-c");
                        var n,
                            a = [r.P.iX, r.P.iY, r.P.I, r.P.F],
                            l = r.P.AU,
                            o = r.P.AU,
                            s = r.P.AU,
                            A = r.P.AU;
                        "" !== (i = r.P.PT) && ((n = i.split(/\s/)), (l = ZC._i_(n[0]))),
                            "" !== (i = r.P.OI) && ((n = i.split(/\s/)), (o = ZC._i_(n[0]))),
                            "" !== (i = r.P.NP) && ((n = i.split(/\s/)), (s = ZC._i_(n[0]))),
                            "" !== (i = r.P.PC) && ((n = i.split(/\s/)), (A = ZC._i_(n[0]))),
                            (r.P.iX -= A + 1),
                            (r.P.iY -= l + 1),
                            (r.P.I += A + o + 1),
                            (r.P.F += l + s + 1),
                            r.P.paint(),
                            (r.P.iX = a[0]),
                            (r.P.iY = a[1]),
                            (r.P.I = a[2]),
                            (r.P.F = a[3]);
                    }
                }
                if ((r.A.A0O(), r.NW(), r.V0 ? r.D["plotarea.paint"] && (D(), (r.D["plotarea.paint"] = null)) : (r.build(), r.Z && ((r.C7 = r.Z), r.b()), D()), "xy" === r.AJ.layout || "yx" === r.AJ.layout)) {
                    var E = r.BW("v"),
                        L = null;
                    for (l = 0; l < E.length; l++) (0 === l || E[l].o["ref-zero"]) && E[l].FR <= 0 && E[l].GU >= 0 && E[l].T9 && (L = l);
                    if (null !== ZC._n_(L)) {
                        var F = E[L].AT(0);
                        for (l = 0; l < E.length; l++)
                            if (l !== L && E[l].o["sync-zero"] && E[l].FR <= 0 && E[l].GU >= 0 && E[l].T9) {
                                var I = E[l].AT(0);
                                if (ZC._a_(I - F) >= 1)
                                    for (var x = !0, y = 0; x; )
                                        I > F
                                            ? E[l].CK
                                                ? E[l].AW
                                                    ? (E[l].A9 += 1)
                                                    : (E[l].BR += 1)
                                                : E[l].AW
                                                ? (E[l].BR += 1)
                                                : (E[l].A9 += 1)
                                            : E[l].CK
                                            ? E[l].AW
                                                ? (E[l].BR += 1)
                                                : (E[l].A9 += 1)
                                            : E[l].AW
                                            ? (E[l].A9 += 1)
                                            : (E[l].BR += 1),
                                            y++,
                                            E[l].J2(),
                                            E[l].A7U(),
                                            (y > (E[l].CK ? r.P.I : r.P.F) || ZC._a_(E[l].AT(0) - F) < 1) && (x = !1);
                            }
                    }
                }
                for (l = 0, o = r.BO.length; l < o; l++) (r.BO[l].Z = r.BO[l].C7 = r.H.usc() ? r.H.mc() : ZC.AL(r.L + "-scales-bl-0-c")), (r.A.O7 = !0), r.BO[l].paint(), r.A.ZR(), (r.A.O7 = !1);
                var w = "undefined" != typeof r.D["shared-zoom"] && null !== ZC._n_(r.D["shared-zoom"]) && r.D["shared-zoom"];
                if (
                    (r.B9 && r.B9.LL ? r.B9.I4 && ((r.B9.I4 = !0), r.B9.paint()) : r.D["skip-preview"] || !r.B9 || (r.V0 && !r.B9.I4) || w || ((r.B9.I4 = !0), r.B9.paint()),
                    (r.D["shared-zoom"] = null),
                    (r.D["skip-preview"] = null),
                    r.HQ && r.HQ.paint(),
                    r.HP && r.HP.paint(),
                    r.V0 ||
                        ((a = r.H.usc() ? r.H.mc() : ZC.AL(r.L + "-titles-c")),
                        r.IR && r.IR.AN && null !== ZC._n_(r.IR.AM) && ((r.IR.Z = r.IR.C7 = a), r.IR.paint(), !r.IR.K8 && ZC.AL(r.A.L + "-map") && (ZC.AL(r.A.L + "-map").innerHTML += ZC.AP.O4(r.L, r.IR))),
                        r.K1 && r.K1.AN && null !== ZC._n_(r.K1.AM) && ((r.K1.Z = r.K1.C7 = a), r.K1.paint(), !r.K1.K8 && ZC.AL(r.A.L + "-map") && (ZC.AL(r.A.L + "-map").innerHTML += ZC.AP.O4(r.L, r.K1))),
                        r.MV && r.MV.AN && null !== ZC._n_(r.MV.AM) && ((r.MV.Z = r.MV.C7 = a), r.MV.paint(), !r.MV.K8 && ZC.AL(r.A.L + "-map") && (ZC.AL(r.A.L + "-map").innerHTML += ZC.AP.O4(r.L, r.MV))),
                        r.S6 && r.S6.AN && null !== ZC._n_(r.S6.AM) && ((r.S6.Z = r.S6.C7 = a), r.S6.paint())),
                    r.IR && r.IR.EL(),
                    r.K1 && r.K1.EL(),
                    r.MV && r.MV.EL(),
                    r.AJ["3d"] || r.UL(),
                    (r.A.O7 = !r.GE),
                    zingchart.DEV.SKIPTRACKERS && (r.A.O7 = !1),
                    r.A.D["graph." + r.L + ".disableanimation"])
                )
                    for (l = 0, o = r.AZ.A3.length; l < o; l++) r.AZ.A3[l].GE = !1;
                r.AZ.paint(), r.H.paintHistory();
            },
            UL: function () {},
            clearPreview: function () {
                var e = this;
                e.B9 && (ZC.Q.IV(ZC.AL(e.L + "-preview-c"), e.A.AC, e.iX, e.iY, e.I, e.F, e.L), e.A.H2 && !e.A.H2.A0N && e.B9.reset(), (e.B9.I4 = !0));
            },
            flatten: function () {},
            _end_: function () {
                var e,
                    i,
                    t,
                    n,
                    a = this;
                for (
                    a.D["toggle-action-remove"] = null,
                        a.GE || a.A.ZR(),
                        a.A.O7 = !1,
                        (a.LL || !a.GE || a.H.D["graph." + a.L + ".disableanimation"] || !a.AJ["enable-animation"] || -1 !== ZC.AV(a.H.KP, "skip_interactivity") || zingchart.SKIP.ANIMATION) && (a.MF = "ready"),
                        "initial" === a.A1T && ((a.ABO = !1), (a.H.D["graph." + a.L + ".disableanimation"] = !0)),
                        i = 0,
                        t = a.BO.length;
                    i < t;
                    i++
                )
                    a.BO[i].paint_();
                if (!a.A.D["fire-load"]) {
                    var l = ZC.AP.C0("objectsinit", a.A, a.GY(), !0);
                    if (l) for (var o = ["labels", "shapes", "imges", "arrows"], r = 0; r < o.length; r++) l[o[r]] && (a.o[o[r]] = (a.o[o[r]] || []).concat(l[o[r]]));
                }
                function s(e) {
                    var i,
                        t,
                        n = (e.targetid || e.target.id)
                            .replace("-area-path", "")
                            .replace("-path", "")
                            .replace(/--([a-zA-Z0-9]+)/, "")
                            .replace("-marker", "")
                            .replace("-circle", "")
                            .split("-")
                            .reverse();
                    return "node" === n[1] && ((i = n[2]), (t = n[0])), [i, t];
                }
                if ((a.AJ["3d"] || (a.flatten(), a.PZ(), a.KK(), -1 === ZC.AV(a.H.KP, "skip_interactivity") && a.S1()), -1 === ZC.AV(a.H.KP, "skip_interactivity"))) {
                    var A = ZC.A5("." + a.L + "-node-area");
                    (a.X5 = function (e) {
                        if (
                            !(
                                (zingchart.NODE_EV && "mouseover" === zingchart.NODE_EV_TYPE && "mouseover" === e.type) ||
                                ((zingchart.NODE_EV_CHART = a.A.L), (zingchart.NODE_EV = e), (zingchart.NODE_EV_TYPE = e.type), ZC.move || (a.BE && a.BE.YI) || -1 === ZC.Q.T4(e.target).indexOf("zc-node-area") || "ready" !== a.MF)
                            )
                        ) {
                            ZC.mobile && ((a.D["node-target-id"] = e.target.id), (ZC.move = !1), a.H.hideCM(), null === a.H.DG || null === ZC._n_(a.H.DG["page-scroll"]) || a.H.DG["page-scroll"] || e.preventDefault(), a.A.YF(e));
                            var n = s(e);
                            if (a.AZ.A3[n[0]]) {
                                var l = a.AZ.A3[n[0]].FK(n[1]);
                                if (l && (l.O ? ((ZC.COLORS = [l.O.C2, l.O.A0, l.O.AE, l.O.BX, l.O.B7]), l.L2 && ZC.COLORS.push(l.L2.A0, l.L2.AE, l.L2.BX, l.L2.B7)) : (ZC.COLORS = []), a.D["plot" + n[0] + ".visible"])) {
                                    var o = ZC.mobile ? "mousedown" : e.xtype || e.type;
                                    (ZC.mobile || "mousedown" !== o) && a.A.A7 && a.A7 && a.A7.AN && a.A.A7.onmouseover(e);
                                    var r = a.AZ.A3[n[0]];
                                    if ("plot" === r.A3D) for (i = 0, t = r.S.length; i < t; i++) r.S[i] && r.FK(i).A0Z("hover");
                                    else l.A0Z("hover");
                                    if ((l.X6(e, o), l.A.X0(e, o), a.BE)) {
                                        ZC.move = !0;
                                        var A = n[0];
                                        a.AZ.A3[A].o["legend-item"] && null !== ZC._n_(a.AZ.A3[A].o["legend-item"].order) && (A = ZC._i_(a.AZ.A3[A].o["legend-item"].order)),
                                            a.BE.o["reverse-series"] && (A = a.AZ.A3.length - 1 - A),
                                            a.AZ.A3[n[0]].bShowInLegend && (a.BE.PO ? a.K === a.A.AG.length - 1 && a.BE.highlightItem(A) : a.BE.highlightItem(A)),
                                            (ZC.move = !1);
                                    }
                                }
                            }
                        }
                    }),
                        A.live("mousedown mouseover touchstart", a.X5),
                        (a.A1Q = function (e) {
                            if (((zingchart.NODE_EV = zingchart.NODE_EV_TYPE = null), (zingchart.NODE_EV_CHART = null), !(ZC.move || (a.BE && a.BE.YI)))) {
                                var i = e.target;
                                if (ZC.mobile && document.elementFromPoint) {
                                    var t = ZC.Q.MD(e),
                                        n = Math.max(window.pageXOffset, document.documentElement.scrollLeft, document.body.scrollLeft),
                                        l = Math.max(window.pageYOffset, document.documentElement.scrollTop, document.body.scrollTop);
                                    if ((i = document.elementFromPoint(t[0] - n, t[1] - l)) && a.D["node-target-id"] && a.D["node-target-id"] !== i.id) return;
                                }
                                if (-1 !== ZC.Q.T4(e.target).indexOf("zc-node-area") && "ready" === a.MF) {
                                    ZC.mobile && a.A.OQ(e);
                                    var o = s(e),
                                        r = a.AZ.A3[o[0]].FK(o[1]);
                                    if (r) {
                                        if (a.D["plot" + o[0] + ".visible"]) {
                                            a.A.A7 && a.A7 && a.A7.AN && a.A.A7.onmouseout(e), (a.AZ.A3[o[0]].E = []), r.LE(), a.LE();
                                            var A = ZC.mobile ? "mouseup" : e.xtype || e.type;
                                            r.X6(e, A), r.A.X0(e, A), a.BE && ((ZC.move = !0), a.BE.PO ? a.K === a.A.AG.length - 1 && a.BE.highlightItem(-1) : a.BE.highlightItem(-1), (ZC.move = !1));
                                        }
                                        !ZC.mobile || a.H.AAB || ZC.move || "touchend" !== e.type || (zingchart.S9(e), a.TG(e));
                                    }
                                }
                            }
                        }),
                        A.live("mouseup mouseout touchend", a.A1Q),
                        (a.A0Q = function (e) {
                            if (((zingchart.NODE_EV = e), (zingchart.NODE_EV_CHART = a.A.L), (zingchart.NODE_EV_TYPE = e.type), -1 !== ZC.Q.T4(e.target).indexOf("zc-node-area") && "ready" === a.MF)) {
                                ZC.mobile && a.A.OQ(e);
                                var i = s(e);
                                a.D["plot" + i[0] + ".visible"] && a.A.A7 && a.A7 && a.A7.AN && a.A.A7.onmousemove(e);
                            }
                        }),
                        A.live("mousemove touchmove", a.A0Q),
                        (a.TG = function (e) {
                            if ((e.targetid || -1 !== ZC.Q.T4(e.target).indexOf("zc-node-area")) && "ready" === a.MF) {
                                var i = s(e),
                                    t = a.AZ.A3[i[0]].FK(i[1]);
                                if (t) {
                                    if ("none" !== t.A.J0 && (ZC.mobile || 0 === e.button)) {
                                        (a.A.D.preservezoom = !0), a.clearPreview();
                                        var n = !0;
                                        null !== ZC._n_(t.A.K0) && t.A.K0["ignore-selection"] && (n = !1), n && a.A6U(t.A.K, t.K);
                                    }
                                    if ((t.X6(e, "click"), t.A.X0(e, "click"), null !== ZC._n_(t.A.EA) && "NULL" !== t.A.EA))
                                        if (t.A.EA instanceof Array)
                                            for (var l = 0; l < t.A.EA.length; l++) {
                                                var o = t.A.FC;
                                                t.A.FC instanceof Array && (o = t.A.FC[l] || "graph=" + (a.o.id || "")), l === t.K && a.V4(e, t.JT(t.A.EA[l], null, null, !0), o);
                                            }
                                        else a.V4(e, t.JT(t.A.EA, null, null, !0), t.A.FC || "graph=" + (a.o.id || ""));
                                }
                            }
                        }),
                        (a.A1G = function (e) {
                            if (-1 !== ZC.Q.T4(e.target).indexOf("zc-node-area") && "ready" === a.MF) {
                                var i = s(e),
                                    t = a.AZ.A3[i[0]].FK(i[1]);
                                t && (t.X6(e, "doubleclick"), t.A.X0(e, "doubleclick"));
                            }
                        }),
                        ZC.mobile || A.live("click", a.TG).live("contextmenu", a.TG).live("dblclick", a.A1G);
                }
                if ((a.AC2(), a.A.D["tr-ev-" + a.K] ? ((a.A.D["tr-ev-" + a.K] = null), a.A8E()) : a.A8E(), a.A19)) {
                    a.A19 = !1;
                    var C = { graphid: a.L };
                    for (i = 0, t = a.BW("k").length; i < t; i++) {
                        var c = a.BW("k")[i];
                        null !== ZC._n_((e = c.KM)) && ((C["zoomx" + (n = 1 === c.K ? "" : "-" + c.K)] = !0), (C["xmin" + n] = e[0]), (C["xmax" + n] = e[1]));
                    }
                    for (i = 0, t = a.BW("v").length; i < t; i++) {
                        var u = a.BW("v")[i];
                        null !== ZC._n_((e = u.KM)) && ((C["zoomy" + (n = 1 === u.K ? "" : "-" + u.K)] = !0), (C["ymin" + n] = e[0]), (C["ymax" + n] = e[1]));
                    }
                    if (((C.zoomto = !0), a.A.G2)) {
                        for (var p in a.A.G2) ZC.AL(p).appendChild(a.A.G2[p]);
                        a.A.G2 = null;
                    }
                    a.A.PY(C);
                }
            },
            AC2: function () {},
            A8E: function () {
                var e = this;
                if ((e.A.A2E < e.A.AG.length && (e.A.A2E++, ZC.AP.C0("gload", e.A, e.GY())), ZC.AP.C0("gcomplete", e.A, e.GY()), e.B9 && (e.B9.I4 = !1), zingchart.NODE_EV && zingchart.NODE_EV_CHART && zingchart.NODE_EV_CHART === e.A.L)) {
                    var i = ZC.A5("#" + e.A.L + "-top"),
                        t = ZC.E1[0] - i.offset().left,
                        n = ZC.E1[1] - i.offset().top,
                        a = zingchart.exec(e.A.L, "getxyinfo", { x: t, y: n });
                    if (a)
                        for (var l = 0; l < a.length; l++)
                            if ("node" === a[l].infotype && a[l].xydistance < 10) {
                                var o = a[l].graphid + "-plotset-plot-" + a[l].plotidx + "-node-" + a[l].nodeidx;
                                zingchart.NODE_EV && zingchart.NODE_EV.target && zingchart.NODE_EV.target.id === o && (e.X5(zingchart.NODE_EV), (zingchart.NODE_EV = null));
                            }
                }
                zingchart.GUIDE_EV && e.A.D7 && e.A.D7.QB(zingchart.GUIDE_EV),
                    e.A.A4F < e.A.AG.length
                        ? e.A.A4F++
                        : ((e.A.A4F = 1),
                          e.A.A2E === e.A.AG.length && (e.A.A2E++, (e.A.D["fire-load"] = !0), e.LL && e.AZ.A3.length > 1 && (zingchart.SKIP.EVENT || ZC.AP.C0("load", e.A, e.A.FG()))),
                          (e.A.D["fire-complete"] = !0),
                          (e.D["graph-K7"] || (e.LL && e.AZ.A3.length > 1)) && (zingchart.SKIP.EVENT || ZC.AP.C0("complete", e.A, e.A.FG()), (e.D["graph-K7"] = null))),
                    (0 !== e.A.QU.length && e.A.QU[e.A.QU.length - 1] === e.A.D.json) || (e.A.QU[e.A.NR] !== e.A.D.json && (e.A.QU.length = e.A.NR + 1), (e.A.QU[e.A.NR] = e.A.D.json));
            },
            K7: function (e, i) {
                var t = this;
                null === ZC._n_(e) && (e = !1), null === ZC._n_(i) && (i = !1), t.A.N3(t), (t.D["graph-K7"] = !0), t.clear(e, i), t.parse(), t.U7 && t.U7(), t.paint(e), t.B9 && t.B9.setScalesInfo(), (t.HH = !1), (zingchart.SKIP.CSV = !1);
            },
            V4: function (ev, EA, FC) {
                if (2 !== ev.button) {
                    var s = this,
                        C,
                        P5 = [""];
                    switch ((null !== ZC._n_(FC) && (P5 = FC.split("=")), P5[0])) {
                        case "_blank":
                            window.open(EA, "_blank");
                            break;
                        case "_top":
                            window.top.location.href = EA;
                            break;
                        case "_parent":
                            window.parent.location.href = EA;
                            break;
                        case "window":
                            null !== ZC._n_(P5[1]) && "" !== P5[1] && (window.top[P5[1]].location.href = EA);
                            break;
                        case "graph":
                            var Y4 = null;
                            if ("()" === EA.substring(EA.length - 2) || "javascript:" === EA.substring(0, 11))
                                try {
                                    var EC = EA.replace("javascript:", "").replace("()", "");
                                    eval(EC) && (Y4 = eval(EC).call(s));
                                } catch (e) {}
                            null !== ZC._n_(P5[1]) && "" !== P5[1]
                                ? "_top" === P5[1] || "_parent" === P5[1]
                                    ? (s.A.N3(), Y4 ? zingchart.exec(s.A.L, "setdata", { data: Y4 }) : s.A.load(null, EA))
                                    : ((C = s.A.OS(P5[1])), C && (s.A.N3(C), (s.A.D["tr-ev-" + C.K] = !0), s.A.NR++, Y4 ? zingchart.exec(s.A.L, "setdata", { graphid: P5[1], data: Y4 }) : s.A.load(P5[1], EA)))
                                : ((C = s.A.AG[0]), s.A.N3(C), Y4 ? zingchart.exec(s.A.L, "setdata", { graphid: C.L, data: Y4 }) : ((s.A.D["tr-ev-" + C.K] = !0), s.A.NR++, s.A.load(C.L, EA)));
                            break;
                        default:
                            window.location.href = EA;
                    }
                }
            },
            I0: function (e, i, t) {
                var n = this;
                if ((null === ZC._n_(t) && (t = n.AZ.A3.length - 1), null !== ZC._n_(e) && void 0 !== e)) return n.AZ.A3[e];
                if (null === ZC._n_(i) || void 0 === i) return n.AZ.A3[t];
                for (var a = 0, l = n.AZ.A3.length; a < l; a++) if (i === n.AZ.A3[a].H8) return n.AZ.A3[a];
                return null;
            },
            A3J: function (e, i) {
                var t,
                    n,
                    a = this;
                (e = e || {})["toggle-action"] = e["toggle-action"] || a.getToggleAction();
                var l = [];
                if ("undefined" != typeof e.plotindex)
                    if (e.plotindex instanceof Array) l = [].concat(e.plotindex);
                    else if (-1 === ZC._i_(e.plotindex)) for (t = 0, n = a.AZ.A3.length; t < n; t++) l.push(t);
                    else l.push(ZC._i_(e.plotindex));
                var o = e.plotid || "";
                o instanceof Array || (o = [o]);
                var r = [];
                for (t = 0, n = ZC.BQ(l.length, o.length); t < n; t++) {
                    var s = a.I0(l[t], o[t]);
                    if (s) {
                        var A = {};
                        ZC._cp_(e, A);
                        var C = s.K;
                        (A.plotindex = C), (A.plotid = s.H8), (("show" === i && !a.D["plot" + C + ".visible"]) || ("hide" === i && a.D["plot" + C + ".visible"])) && r.push(A);
                    }
                }
                for (t = 0, n = r.length; t < n; t++) (a.A.o.graphset[a.K].series[r[t].plotindex].visible = "show" === i), t === n - 1 && (r[t].K7 = 1), a.QA(r[t]);
            },
            QA: function (e) {
                var i,
                    t,
                    n,
                    a = this;
                (a.A.D["graph." + a.L + ".disableanimation"] = !1), (e = e || {});
                var l = !1;
                null !== ZC._n_(e.skip) && e.skip && (l = !0), null === ZC._n_(e.update) || e.update || (l = !0);
                var o = !1;
                (e["toggle-action"] = e["toggle-action"] || a.getToggleAction()), null !== ZC._n_((i = e["ignore-legend"])) && (o = ZC._b_(i));
                var r = a.I0(e.plotindex, e.plotid);
                if (r) {
                    var s = r.K;
                    switch (e["toggle-action"]) {
                        case "hide":
                            if (
                                (a.BE && (a.BE.D.showhide = !0),
                                (a.D["plot" + s + ".visible"] = !a.D["plot" + s + ".visible"]),
                                null !== ZC._n_(a.A.o.graphset[a.K].series) && (a.A.o.graphset[a.K].series[s].visible = a.D["plot" + s + ".visible"]),
                                a.AJ["3d"])
                            )
                                (o = !0), l || a.K7();
                            else {
                                var A = a.D["plot" + s + ".visible"] ? "block" : "none";
                                if (
                                    (zingchart.DEV.SKIPTRACKERS ||
                                        ZC.A5("." + a.L + "-plotset-plot-" + s + "-node-area").each(function () {
                                            if ("AREA" === this.tagName.toUpperCase()) {
                                                var e = ZC.A5(this),
                                                    i = e.attr("coords"),
                                                    n = e.attr("shape");
                                                "none" === A
                                                    ? ((i = "-" + i.replace(/,/g, ",-")),
                                                      "rect" === n ? 4 === (t = i.split(",")).length && (i = [t[2], t[3], t[0], t[1]].join(",")) : "circle" === n && 3 === (t = i.split(",")).length && (i = [t[0], t[1], -t[2]].join(",")))
                                                    : ((i = i.replace(/\-/g, "")), "rect" === n && 4 === (t = i.split(",")).length && (i = [t[2], t[3], t[0], t[1]].join(","))),
                                                    e.attr("coords", i);
                                            }
                                        }),
                                    a.A.K8)
                                )
                                    (ZC.AL(a.L + "-plots-bl-c").style.display = A), (ZC.AL(a.L + "-plots-fl-c").style.display = A), (ZC.AL(a.L + "-plots-vb-c").style.display = A);
                                else {
                                    for (n = 0; n < r.SW; n++) (i = ZC.AL(a.L + "-plot-" + s + "-bl-" + n + "-c")) && (i.style.display = A);
                                    for (n = 0; n < r.A1K; n++) (i = ZC.AL(a.L + "-plot-" + s + "-fl-" + n + "-c")) && (i.style.display = A);
                                    (i = ZC.AL(a.L + "-plot-" + s + "-vb-c")) && (i.style.display = A);
                                }
                                var C = ZC.A5("." + a.L + "-plot-" + s + "-value-box");
                                a.D["plot" + s + ".visible"] ? (C.show(), ZC.A5("." + a.L + "-plotset-plot-" + s + "-preview").show()) : (C.hide(), ZC.A5("." + a.L + "-plotset-plot-" + s + "-preview").hide());
                            }
                            break;
                        case "remove":
                            a.clearPreview(), (o = !0), (a.D["toggle-action-remove"] = !0), (a.D["plot" + s + ".visible"] = !a.D["plot" + s + ".visible"]), e.K7 && (l || (a.M0("on-legend-toggle"), a.K7(!0, !0)));
                    }
                    a.BE && !o && (a.BE.clear(), a.BE.paint());
                }
            },
            M0: function (e) {
                var i = this,
                    t = !0,
                    n = i.o.plot || {};
                null !== ZC._n_(n.animation) && null !== ZC._n_(n.animation[e]) && (t = ZC._b_(n.animation[e])), (i.HH = "initial" === i.A1T || !t);
            },
            GY: function () {
                return { id: this.A.L, graphidx: this.K, graphid: this.L.replace(this.A.L + "-graph-", ""), x: this.iX, y: this.iY, width: this.I, height: this.F, loader: this.A.FG() };
            },
            RX: function () {},
            RS: function () {},
            gc: function () {
                for (var e = 0; e < this.BO.length; e++) this.BO[e].gc();
                for (var i = 0; i < this.AZ.A3.length; i++) this.AZ.A3[i].gc();
                ZC.AP.gc(this.AZ, ["A", "C", "H", "F9", "o", "I7", "JE"]), ZC.AP.gc(this, ["Z", "C7", "AJ", "IR", "K1", "MV", "F0"]);
            },
        })),
        (ZC.JJ.prototype.PZ = function () {
            var e,
                i,
                t,
                n,
                a,
                l,
                o,
                r,
                s = this;
            s.initObjectsLayers(), (s.BY = []), (s.FH = []), (s.YC = []), (s.LI = []), (s.FA = []), (s.XF = {});
            var A,
                C,
                c,
                u = s.A.B8,
                p = "(" + s.AF + ")";
            if (null !== ZC._n_((A = s.o.labels)))
                for (i = 0, t = A.length; i < t; i++) {
                    A[i].id || (A[i].id = "lbl_" + i + "_" + ZC._r_(1e3, 9999)), (n = A[i].id || i), (a = !1), (l = !1), s.D["objects.updates"] && -1 === ZC.AV(s.D["objects.updates"], n) && ((a = !0), (l = !0)), A[i].tween && (a = !0);
                    var Z = zingchart.pool.getInstance("DN", s, s.L + "-label-" + n, a);
                    if (!l || !Z._POOL_) {
                        if ((u.load(Z.o, p + ".label"), Z.append(A[i]), null !== ZC._n_((e = Z.o.parent))))
                            for (var h = 0; h < s.BY.length; h++)
                                if ("" + s.BY[h].H8 == "" + e) {
                                    (Z.D["p-x"] = s.BY[h].iX), (Z.D["p-y"] = s.BY[h].iY), (Z.D["p-width"] = s.BY[h].I), (Z.D["p-height"] = s.BY[h].F);
                                    break;
                                }
                        if (
                            ((Z.H8 = n),
                            (Z.L = s.L + "-label-" + n),
                            (Z.GL = s.L + "-label zc-label"),
                            null !== ZC._n_((e = A[i].hook)) && (Z.D.hook = e),
                            (Z.JT = function (i) {
                                if (!i || -1 === ("" + i).indexOf("%")) return i;
                                i = "" + i;
                                var t,
                                    n = [];
                                n.push(["%id", s.A.L]), n.push(["%graphid", s.L.replace(s.A.L + "-graph-", "")]);
                                var a = s.D.update;
                                for (var l in a) n.push(["%" + l, a[l]]);
                                n.sort(ZC.A1C);
                                for (var o = 0, r = n.length; o < r; o++) (t = new RegExp(n[o][0], "g")), (i = i.replace(t, n[o][1]));
                                var A,
                                    C,
                                    c,
                                    u,
                                    p = Z.o["default-value"] || " ";
                                for (
                                    t = new RegExp("(%plot-([0-9]+?)-value(-*)([0-9]*?))|(%plot-value-([0-9]+?))|(%plot-value)|(%npv)|(%node-percent-value)", "g"),
                                        i = i.replace(t, p),
                                        t = new RegExp("%plot-([0-9]+?)-data-([a-zA-Z0-9-]+)", "g"),
                                        i = i.replace(t, p),
                                        t = new RegExp("\\((.+?)\\)\\(([0-9]*)\\)\\(([0-9]*)\\)");
                                    (A = t.exec(i));

                                )
                                    if ("%node-value" === A[1]) {
                                        C = "";
                                        var h = 0,
                                            d = 0;
                                        "" !== (e = A[2]) && (h = ZC._i_(e)), "" !== (e = A[3]) && (d = ZC._i_(e)), (u = s.AZ.A3[h]) && (c = u.FK(d, 3)) && (C = c.JT(A[1])), (i = i.replace(A[0], C));
                                    }
                                return i;
                            }),
                            Z.parse(),
                            A[i]["3d"])
                        ) {
                            var d = new ZC.CF(s, Z.iX + Z.I / 2 - ZC.AO.E4, Z.iY + Z.F / 2 - ZC.AO.E5, ZC._i_(A[i].z || "0"));
                            (Z.iX = d.ED[0] - Z.I / 2), (Z.iY = d.ED[1] - Z.F / 2);
                        }
                    }
                    s.BY.push(Z), s.FA.push({ type: "label", index: i, zindex: Z.JS }), (s.XF[n] = { shape: "label", idx: i });
                }
            if (null !== ZC._n_((C = s.o.arrows)))
                for (i = 0, t = C.length; i < t; i++) {
                    var f = new ZC.A7V(s);
                    u.load(f.o, p + ".arrow"), f.append(C[i]), (n = C[i].id || i), (f.L = s.L + "-arrow-" + n), f.parse(), s.YC.push(f), s.FA.push({ type: "arrow", index: i, zindex: f.JS });
                }
            var _,
                g = 0;
            if (null !== ZC._n_((c = s.o.shapes)))
                for (i = 0, t = c.length; i < t; i++)
                    if (null === ZC._n_(c[i].type) || 0 !== c[i].type.indexOf("zingchart.")) {
                        var v, b, B;
                        if (
                            (c[i].id || (c[i].id = "shp_" + i + "_" + ZC._r_(1e3, 9999)),
                            (n = c[i].id || i),
                            (l = null !== ZC._n_(zingchart.pool[s.L + "-shape-" + n]) && zingchart.SKIP.PARSE3D),
                            (a = !1),
                            s.D["objects.updates"] && -1 === ZC.AV(s.D["objects.updates"], n) && ((a = !0), (l = !0)),
                            c[i].tween && (a = !0),
                            c[i]["3d"]
                                ? (((o = zingchart.pool.getInstance("DU", s, s.L + "-shape-" + n, !0)).o = c[i]), ("poly" !== c[i].type || c[i]["map-item"]) && (l = !1))
                                : (null !== ZC._n_(c[i].label)
                                      ? ((o = zingchart.pool.getInstance("P0", s, s.L + "-shape-" + n, a)).WW = c[i])
                                      : (((o = zingchart.pool.getInstance("DU", s, s.L + "-shape-" + n, a)).o = c[i]), o.append({}, !0)),
                                  (a && o._POOL_) || (l = !1)),
                            l || ((o.H8 = n), (o.L = s.L + "-shape-" + n), (o.O7 = !0), c[i]["map-item"] && (o.O7 = !1), o.parse()),
                            null !== ZC._n_((e = c[i].hook)) && (o.D.hook = e),
                            c[i]["3d"])
                        ) {
                            if (c[i]["map-item"]) {
                                for (v = [], b = 0, B = o.E.length; b < B; b++) null !== o.E[b] ? ((r = new ZC.CF(s, o.E[b][0] - ZC.AO.E4, o.E[b][1] - ZC.AO.E5, ZC._i_(o.E[b][2] || c[i].z || "0"))), v.push(r.ED)) : v.push(null);
                                (o.E = v), s.FH.push(o), s.FA.push({ type: "shape", index: g, zindex: o.JS, z3d: r.AAQ }), (s.XF[n] = { shape: o.DS, idx: g });
                            } else if ("poly" === c[i].type) {
                                var m = ZC.DK.D8(o, s, c[i].points, !1);
                                s.CM.add(m), s.FH.push(null);
                            } else {
                                if (o.E.length > 0) {
                                    for (v = [], b = 0, B = o.E.length; b < B; b++) (r = new ZC.CF(s, o.E[b][0] - ZC.AO.E4, o.E[b][1] - ZC.AO.E5, ZC._i_(o.E[b][2] || c[i].z || "0"))), v.push(r.ED);
                                    o.E = v;
                                } else (r = new ZC.CF(s, o.iX - ZC.AO.E4, o.iY - ZC.AO.E5, ZC._i_(c[i].z || "0"))), (o.iX = ZC._i_(r.ED[0])), (o.iY = ZC._i_(r.ED[1]));
                                s.FH.push(o), s.FA.push({ type: "shape", index: g, zindex: o.JS, z3d: r.AAQ });
                            }
                            (o.D["3dtx"] = !0), (o.D["3d"] = !0);
                        } else
                            s.FH.push(o),
                                o instanceof ZC.P0
                                    ? (s.FA.push({ type: "shape", index: g, zindex: o.BG.JS }), (s.XF[n] = { shape: o.BG.DS, idx: g }))
                                    : (s.FA.push({ type: "shape", index: g, zindex: o.JS }), (s.XF[n] = { shape: o.DS, idx: g }));
                        g++;
                    }
            if (null !== ZC._n_((_ = s.o.images)))
                for (i = 0, t = _.length; i < t; i++) {
                    var D = _[i].src;
                    if (ZC.cache.data[D]) {
                        var E = new ZC.HN(s);
                        E.append({ "background-repeat": "no-repeat", "background-image": D, width: ZC.cache.data[D].width, height: ZC.cache.data[D].height }),
                            E.append(_[i]),
                            (n = _[i].id || i),
                            (E.H8 = n),
                            (E.L = s.L + "-image-" + n),
                            (E.K = i),
                            E.parse(),
                            s.LI.push(E),
                            s.FA.push({ type: "image", index: i, zindex: E.JS });
                    }
                }
            (s.D["objects.updates"] = null),
                (s.FA = s.FA.sort(function (e, i) {
                    return null !== ZC._n_(e.z3d) && null !== ZC._n_(i.z3d) ? (e.z3d - i.z3d > 0 ? 1 : -1) : 0;
                })),
                (s.FA = s.FA.sort(function (e, i) {
                    return e.zindex - i.zindex == 0 ? e.index - i.index : e.zindex - i.zindex;
                }));
        }),
        (ZC.JJ.prototype.A0J = function (e, i) {
            void 0 === e && (e = !1), void 0 === i && (i = !1);
            var t,
                n = this,
                a = [n.L + "-objects-bottom-sh-c", n.L + "-objects-bottom-c", n.L + "-objects-top-sh-c", n.L + "-objects-top-c", n.L + "-objects-front-c", n.L + "-objects-print-c"];
            ZC.SKIPMAPS || a.push(n.L + "-objects-maps-sh-c", n.L + "-objects-maps-c");
            for (var l = 0; l < a.length; l++) (t = ZC.AL(a[l])) && ZC.Q.IV(t, n.H.AC, n.iX, n.iY, n.I, n.F, n.L);
            ("canvas" === n.A.AC && !zingchart.CANVASTEXT && ZC.objmove) || (ZC.A5("." + n.L + "-label").remove(), ZC.A5("." + n.L + "-shape-label").remove(), ZC.A5("." + n.L + "-arrow-label").remove()),
                e ||
                    (ZC.A5("." + n.L + "-label-area").each(function () {
                        if (-1 === ZC.AV([n.L + "-title-area", n.L + "-subtitle-area", n.L + "-source-area"], this.id)) {
                            var e = new RegExp("scale_(x|y|k|v)((_[0-9]+)*)-(item_|marker_)([0-9]+)").exec(this.id);
                            (!i && e && e.length) || ZC.Q.ET(this.id);
                        }
                    }),
                    ZC.A5("." + n.L + "-shape-area").each(function () {
                        (!ZC.SKIPMAPS || (ZC.SKIPMAPS && "1" !== this.getAttribute("data-map"))) && ZC.Q.ET(this.id);
                    }),
                    ZC.A5("." + n.L + "-arrow-area").remove()),
                "svg" === n.A.AC &&
                    ZC.A5("#" + n.A.L + "-svg")
                        .children()
                        .each(function () {
                            var e = n.L + "-label-";
                            "clippath" === this.tagName.toLowerCase() && this.id.substring(0, e.length) === e && ZC.Q.ET(this.id);
                        });
        }),
        (ZC.JJ.prototype.AC7 = function () {
            var e = this;
            (e.H.O1["objects-top"] || e.H.O1["objects-bottom"]) &&
                (ZC.A5("." + e.L + "-label-area")
                    .die(ZC.mobile ? "touchstart" : "mousedown mouseover", e.A06)
                    .die(ZC.mobile ? "touchend" : "mouseup mouseout", e.A0S)
                    .die(ZC.mobile ? "touchmove" : "mousemove", e.A07),
                ZC.mobile ||
                    ZC.A5("." + e.L + "-label-area")
                        .die("click", e.UO)
                        .die("dblclick", e.UO),
                ZC.A5("." + e.L + "-shape-area")
                    .die(ZC.mobile ? "touchstart" : "mousedown mouseover", e.ZX)
                    .die(ZC.mobile ? "touchend" : "mouseup mouseout", e.A0U)
                    .die(ZC.mobile ? "touchmove" : "mousemove", e.A05),
                ZC.mobile ||
                    ZC.A5("." + e.L + "-shape-area")
                        .die("click", e.UA)
                        .die("dblclick", e.UA));
        }),
        (ZC.JJ.prototype.OW = function () {
            var e,
                i,
                t,
                n,
                a = this;
            if (((a.YU = !1), null !== ZC._n_((t = a.o.labels))))
                for (e = 0, i = t.length; e < i; e++) {
                    var l = "" + (t[e].text || "");
                    if (-1 !== l.indexOf("%node-") || -1 !== l.indexOf("%plot-") || -1 !== l.indexOf("%npv") || -1 !== l.indexOf("%node-percent-value") || ZC._b_(t[e].dynamic)) {
                        a.YU = !0;
                        break;
                    }
                }
            if (null !== ZC._n_((n = a.o.shapes)))
                for (e = 0, i = n.length; e < i; e++)
                    if (ZC._b_(n[e].dynamic)) {
                        a.YU = !0;
                        break;
                    }
        }),
        (ZC.JJ.prototype.QM = function (e) {
            var i = this;
            i.A0J(e), i.PZ(), i.KK(e), (ZC.SKIPMAPS = !1);
        }),
        (ZC.JJ.prototype.KK = function (e) {
            void 0 === e && (e = !1);
            var i,
                t,
                n,
                a = this,
                l = [],
                o = [];
            function r(e) {
                var i = a.YC[e];
                if (i.AN && ((i.Z = i.C7 = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-" + (i.JS < 0 ? "bottom" : "top") + "-c")), i.paint(), i.AN && ZC.AL(a.A.L + "-map"))) {
                    var t = i.BG.A51(),
                        n = ZC.Q.FX(t[0], i.BG.EA, i.BG.IP) + 'class="' + a.L + '-arrow-area zc-arrow-area" id="' + i.BG.L + '-area" coords="' + t[1] + '" />';
                    "top" === i.o.placement ? o.push(n) : l.push(n);
                }
            }
            function s(e) {
                if (a.FH[e]) {
                    var t = a.FH[e],
                        n = t instanceof ZC.P0 ? t.BG : t;
                    if ((!ZC.SKIPMAPS || !n.o["map-item"]) && n.AN) {
                        if (null !== ZC._n_((i = t.D.hook))) {
                            var r = a.UU(i);
                            -1 !== r[0] && (n.iX = ZC._i_(r[0])), -1 !== r[1] && (n.iY = ZC._i_(r[1]));
                        }
                        if (!t.D["3d"] || t.D["3dtx"]) {
                            (t.Z = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-" + (n.JS < 0 ? "bottom" : "top") + "-c")),
                                (t.C7 = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-" + (n.JS < 0 ? "bottom" : "top") + "-sh-c")),
                                n.o["map-item"] && ((t.Z = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-maps-c")), (t.C7 = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-maps-sh-c")));
                            var s = "";
                            null !== ZC._n_((i = n.o.limit)) && ("x" === i ? (s = "x") : "y" === i ? (s = "y") : "xy" === i && (s = "xy")),
                                ("" === s ||
                                    ("x" === s && ZC.DT(n.iX - n.BL, a.P.iX - 2, a.P.iX + a.P.I + 2)) ||
                                    ("y" === s && ZC.DT(n.iY - n.BI, a.P.iY - 2, a.P.iY + a.P.F + 2)) ||
                                    ("xy" === s && ZC.DT(n.iX + n.BL, a.P.iX - 2, a.P.iX + a.P.I - 2) && ZC.DT(n.iY + n.BI, a.P.iY - 2, a.P.iY + a.P.F + 2))) &&
                                    ((t.VN = !1), (t.D["print-canvas"] = a.L + "-" + (n.o["map-item"] ? "maps" : "objects") + "-print-c"), t.paint());
                        }
                        if (!t.K8 && !a.Q4 && "normal" === zingchart.OBJECTMODE) {
                            var A = n.A51();
                            if (ZC.AL(a.A.L + "-map"))
                                for (var C = 1, c = A.length; C < c; C++)
                                    if ("" !== A[C]) {
                                        var u = n.o["map-item"] && !n.o["map-skip-z-sort"] ? ' data-map="1"' : "",
                                            p = ZC.Q.FX(A[0], n.EA, n.IP) + 'class="' + a.L + '-shape-area zc-shape-area" id="' + n.L + "-area" + (C > 1 ? "--" + C : "") + '" coords="' + A[C] + '" data-z-sort="' + n.A7B + '"' + u + " />";
                                        if (("top" === t.o.placement ? o.push(p) : l.push(p), t.M)) {
                                            var Z = [ZC._i_(t.M.iX + t.M.BL), ZC._i_(t.M.iY + t.M.BI), ZC._i_(t.M.iX + t.M.BL + t.M.I), ZC._i_(t.M.iY + t.M.BI + t.M.F)].join(",");
                                            (p = ZC.Q.FX("rect", n.EA, n.IP) + 'class="' + a.L + '-shape-area zc-shape-area" id="' + n.L + "-area" + (C > 1 ? "--" + C : "") + '" coords="' + Z + '" data-z-sort="' + n.A7B + '"' + u + " />"),
                                                "top" === t.o.placement ? o.push(p) : l.push(p);
                                        }
                                    }
                        }
                    }
                }
            }
            function A(e) {
                var i = a.LI[e];
                if (i.AN)
                    if (((i.Z = i.C7 = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-" + (i.JS < 0 ? "bottom" : "top") + "-c")), null !== ZC._n_(i.o.repeat) && ZC._b_(i.o.repeat))) {
                        var t = ZC._i_(ZC._c_(i.o.items, 0)),
                            n = null;
                        if ((i.o.inactive && ((n = new ZC.HN(i.A)).copy(i), n.append(i.o.inactive), n.parse(), (n.Z = n.C7 = i.Z)), t > 0 || n)) {
                            var l = ZC._i_(ZC._c_(i.o.rows, -1)),
                                o = ZC._i_(ZC._c_(i.o.cols, -1)),
                                r = ZC._i_(ZC._c_(i.o["space-x"], 0)),
                                s = ZC._i_(ZC._c_(i.o["space-y"], 0)),
                                A = ZC._i_(ZC._c_(i.o["offset-row"], 0)),
                                C = ZC._i_(ZC._c_(i.o["offset-col"], 0));
                            -1 !== l && -1 === o ? (o = Math.ceil(t / l)) : -1 === l && -1 !== o ? (l = Math.ceil(t / o)) : -1 === l && -1 === o && ((o = Math.ceil(Math.sqrt(t))), (l = Math.ceil(t / o)));
                            for (var c = i.iX, u = i.iY, p = i.L, Z = 0; Z < l; Z++)
                                for (var h = 0; h < o; h++) (i.iX = c + h * r + Z * A), (i.iY = u + Z * s + h * C), (i.L = p + (Z * o + h)), Z * o + h < t ? i.paint() : n && ((n.iX = i.iX), (n.iY = i.iY), (n.L = i.L), n.paint());
                        } else i.paint();
                    } else i.paint();
            }
            function C(e) {
                var t = a.BY[e];
                if (t.AN) {
                    if (((t.D.lbltype = "label"), null !== ZC._n_((i = t.D.hook)))) {
                        var n = a.UU(i);
                        if (-1 === n[0] && -1 === n[1]) return;
                        if (
                            (-1 !== n[0] && (t.iX = n[0]),
                            -1 !== n[1] && (t.iY = n[1]),
                            null === ZC._n_(n[2]) || t.o.anchor || (null !== ZC._n_(n[2].center) && n[2].center && ((t.iX -= t.I / 2), (t.iY -= t.F / 2))),
                            t.o.anchor && t.setAnchor(),
                            t.o["3d"])
                        ) {
                            var r = 0;
                            n[2] && n[2].z ? (r = n[2].z) : t.o.z && (r = ZC._i_(t.o.z));
                            var s = new ZC.CF(a, t.iX + t.I / 2 - ZC.AO.E4, t.iY + t.F / 2 - ZC.AO.E5, r);
                            (t.iX = s.ED[0] - t.I / 2), (t.iY = s.ED[1] - t.F / 2);
                        }
                    }
                    (t.iX = ZC._i_(t.iX)),
                        (t.iY = ZC._i_(t.iY)),
                        (t.IL = ZC.AL(a.A.L + "-text")),
                        (t.Z = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-" + (t.JS < 0 ? "bottom" : "top") + "-c")),
                        (t.C7 = a.H.usc() ? a.H.mc("top") : ZC.AL(a.L + "-objects-" + (t.JS < 0 ? "bottom" : "top") + "-sh-c"));
                    var A = "";
                    if (
                        (null !== ZC._n_((i = t.o.limit)) && ("x" === i ? (A = "x") : "y" === i ? (A = "y") : "xy" === i && (A = "xy")),
                        ("" === A ||
                            ("x" === A && ZC.DT(t.iX - t.BL, a.P.iX - t.I / 2 - 2, a.P.iX + a.P.I - t.I / 2 + 2)) ||
                            ("y" === A && ZC.DT(t.iY - t.BI, a.P.iY - t.F / 2 - 2, a.P.iY + a.P.F - t.F / 2 + 2)) ||
                            ("xy" === A && ZC.DT(t.iX + t.BL, a.P.iX - t.I / 2 - 2, a.P.iX + a.P.I - t.I / 2 + 2) && ZC.DT(t.iY + t.BI, a.P.iY - t.F / 2 - 2, a.P.iY + a.P.F - t.F / 2 + 2))) &&
                            ((t.