<?php
require_once('../../config.php');
require_once('announcement_form.php');

global $CFG,$DB,$USER,$OUTPUT;
require_login();
$announcement_id = optional_param('fieldid',0,PARAM_INT);
if ($announcement_id) {
  $title = 'Update Announcement';
  $heading = 'Edit Announcement';
$cancelurl = 'edit_announcements.php';

}
else {
  $title = 'Create Announcement';
  $heading = '';
  $cancelurl = $CFG->wwwroot.'/my/';

}
$PAGE->set_heading($title);
$PAGE->set_title($title);
$PAGE->set_pagelayout('standard');
$PAGE->navbar->add('Edit Announcement',new moodle_url(''));

echo $OUTPUT->header(); 

$mform = new announcement('announcement.php?fieldid='.$announcement_id.'');
//Form processing and displaying is done here
if ($mform->is_cancelled()) {
  redirect($cancelurl,'Announcement Cancelled',null, \core\output\notification::NOTIFY_WARNING);

    //Handle form cancel operation, if cancel button is present on form
} else if ($fromform = $mform->get_data()) {
  $table = 'custom_announcement';

  if ($DB->record_exists('custom_announcement', ['id'=>$fromform->id])) {  // check for update record

    $update = $DB->execute('Update {custom_announcement} SET name = "'.$fromform->announcement_name.'", description = "'.$fromform->announcement_description.'", announcement_date = "'.$fromform->date.'",announcement_type = "'.$fromform->announcement_type.'", timemodified =  '.time().' WHERE id = '.$fromform->id.' ');

    if ($update) {
      redirect('edit_announcements.php','Announcement Updated Successfully',null, \core\output\notification::NOTIFY_SUCCESS);
    }
  }
  else {
   
  
    $insert_record = new stdClass();
$insert_record->userid = $USER->id;
$insert_record->name = $fromform->announcement_name;
// $insert_record->idnumber = $fromform->idnumber;
$insert_record->description = $fromform->announcement_description;
$insert_record->announcement_date = $fromform->date;
$insert_record->announcement_type = $fromform->announcement_type;

$insert_record->timecreated = time();

  $inserted = $DB->insert_record($table, $insert_record, $returnid=true, $bulk=false);
  if ($inserted) {
    redirect('edit_announcements.php','Announcement Add Successfully',null, \core\output\notification::NOTIFY_SUCCESS);
  }
  }


  //In this case you process validated data. $mform->get_data() returns data posted in form.
} else {
  // this branch is executed if the form is submitted but the data doesn't validate and the form should be redisplayed
  // or on the first display of the form.

  //Set default data (if any)
  if ($announcement_id) {
    $edit_record = $DB->get_record('custom_announcement',['id'=>$announcement_id]);
    $toform = new stdClass();
    $toform->announcement_name = $edit_record->name;
    // $toform->idnumber = $edit_record->idnumber;
    $toform->date = $edit_record->announcement_date;
    $toform->announcement_description = $edit_record->description;
    $toform->announcement_type = $edit_record->announcement_type;
    $mform->set_data($toform);
  }
 
  //displays the form
  echo $OUTPUT->heading($heading);
  $mform->display();
 
}


echo $OUTPUT->footer();
