<?php
require_once('../../config.php');
require_once('../vendor/autoload.php');

global $DB, $PAGE, $OUTPUT;
require_login();

$PAGE->set_title('Certificate');
$PAGE->set_context(context_system::instance());
$PAGE->set_url($CFG->wwwroot . '/local/public/certificate.php');

// $userid = required_param('id',PARAM_INT);
$trackid = required_param('trackid', PARAM_INT);

// $userdata = $DB->get_record('user',['id'=>$userid]);
$trackdata = $DB->get_record('course_categories', ['id' => $trackid]);
$certificate = $DB->get_record('custom_certificate', ['track_id' => $trackid]);
$certificate_id = $DB->get_record_sql("SELECT id FROM {assign_badge} WHERE type = 'track' AND studentid = $USER->id AND course_id = $trackid");
$total_digit = 6;
$certificateid = $certificate_id->id;
$pattern = '/\d/';

preg_match_all($pattern, $certificate_id->id, $matches);

$totalDigits_in_certificate_id = count($matches[0]);
$difference_in_digit = $total_digit-$totalDigits_in_certificate_id;

for ($i=0; $i <$difference_in_digit; $i++) { 
	$remaining_zeros[] = 0;
}
$remaining_zeros = implode("", $remaining_zeros);
$current_certificate_id = $remaining_zeros.$certificateid;
$username = ucwords($USER->firstname . " " . $USER->lastname);
$trackname = $trackdata->name;
$backgroundurl = $CFG->wwwroot . $certificate->certificatepath;

$header = '<!DOCTYPE html>
<html lang="en">
<head>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<link href="https://fonts.googleapis.com/css2?family=Aleo:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@100;200;300;400;500;600;700&display=swap" rel="stylesheet">

<link href="https://fonts.googleapis.com/css2?family=Great+Vibes&display=swap" rel="stylesheet">


<title>Certificate</title>
<style type="text/css">
*{
padding: 0;
margin: 0;
font-family: "Aleo", serif;
}
.afaf{
	border:1px solid red;
	width: 110px;
	height: 1px;
	font-weight: 200;
	font-size: 25px;
	background:red;
}
.sss{
	font-family: "Great Vibes", cursive !important;
}
</style>
</head>
<body style="background: #e1e1e1 !important;">
<div style="background:url(' . $backgroundurl . ');background-repeat:no-repeat;background-size:cover;width:1000px;height:150%;">

<div class="certificate-title" style="width:600px; margin-top: 50px; float: right; text-align: center;">

<img src="'.$CFG->wwwroot.'/local/public/image/logo.svg"  style="margin-top: 20px;" alt="logo" width="200">

<h1 style="margin:20px 0 0;line-height: 0; font-size: 65px; font-weight: 500;"> CERTIFICATE</h1>
<div style="margin: 0;line-height: 0; display: flex;">
	<div style="font-size: 22px; font-weight:200;">---------- OF COMPLETION ----------</div>
</div>


<h3 style="margin-top: 40px; font-size: 15px; font-weight: 400; letter-spacing: 2;">PRODULY ACKNOWLEDGES THAT</h3> 
<h2 class="sss" style="font-size: 40px;  font-weight: 400;">'.$username.'</h2> 



<h5 style="font-size: 15px; font-weight: 400; ">has successfully completed the following certificate</h5>
<h2 style="margin:0;line-height: 0; font-size: 30px; font-weight: 500; text-transform: uppercase;">'.$trackname.'</h2>




<div style="float: right; margin-right: 25px; margin-top: 55px; width: 115px; text-align: left;">
	<p style="font-size: 14px; font-weight: 500; text-transform: uppercase; line-height: 0; margin: 0;"><b>'.$current_certificate_id.'</b></p>
<h2 style="font-size: 14px; font-weight: 500; text-transform: uppercase; border-top: 1px solid #A7803B; line-height: 0;margin: 0;">Certificate ID</h2>
</div>
</div>
</div>

</body>
</html>';

$filename = 'certificate.pdf';

$mpdf = new \Mpdf\Mpdf();
$mpdf->AddPage('L');
$mpdf->WriteHTML($header);
$mpdf->SetFont("freeserif", '', 11);
$mpdf->Output();

exit;
