<?php
require_once('../../config.php');
require_once("{$CFG->libdir}/completionlib.php");
require_once("{$CFG->libdir}/accesslib.php");
class tableuser extends table_sql
{

    function __construct($uniqueid)
    {
        global $DB, $USER;

        $student_roleid = $DB->get_field('role', 'id', ['shortname' => 'student']);   // get student role id

        parent::__construct($uniqueid);
        // Define the list of columns to show.

        if (user_has_role_assignment($USER->id, $student_roleid)) {
            # code...
            $columns = array('row_num', 'username', 'email', 'categoryname', 'parent', 'coursenames', 'badge_name', 'certificate_name', 'timeaccess');
            $headers = array('S.No', 'User Name', 'Status', 'Track', 'Courses', 'Modules', 'Badge Name', 'Certificate Name', 'Last Access');
        } else {
            $columns = array('row_num', 'userid',  'username', 'email', 'categoryname', 'parent', 'coursenames', 'badge_name', 'certificate_name', 'timeaccess');
            $headers = array('S.No', 'UEID', 'User Name', 'Status', 'Track', 'Courses', 'Modules', 'Badge Name', 'Certificate Name', 'Last Access');
        }
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $this->define_headers($headers);
    }

    // function col_userid($row){
    //     global $DB;
    //    $student_roleid =  $DB->get_field('role','id',['shortname'=>'student']);
    //    if (!user_has_role_assignment($row->userid,$student_roleid)) {
    //     return null;
    //    }
    //    else {
    //     return $row->userid;
    //    }
    // }
    function col_certificate_name($row)
    {

        global $DB;

        // old code 
        // if ($row->type) {
        //     if ($row->type == 'track') {

        //         $certificatename = $DB->get_record('custom_certificate', array('track_id' => $row->parent));

        //             return $certificatename->certificate_name;
        //         }

        //          }
        //          else {
        //             return "Not Win";
        //          }

        //very old code
        // if($row->certificate_name){
        //     return $row->certificate_name;
        // }

        // else {
        //     return "Not Win Certificate";
        // }

        $modulename = $DB->get_record('course_categories', array('id' => $row->parent));
        if ($modulename) {
            if ($DB->record_exists('assign_badge', ['course_id' => $row->parent, 'studentid' => $row->userid, 'type' => 'track'])) {

                $certificatename = $DB->get_record('custom_certificate', array('track_id' => $row->parent));
                if ($certificatename) {
    
                return $certificatename->certificate_name;
                }
            } else {
                return "Not Win Certificate";
            }
        }
    }



    function col_username($row)
    {
        return (html_writer::start_tag('a', array('href' => "studentactivity.php?id=$row->userid&&moduleid=$row->courseid&&trackid=$row->parent&&courseid=$row->category")) . $row->username .
            html_writer::end_tag('a'));
    }
    function col_badge_name($row)
    {

        global $DB, $USER;
        // if ($row->type) {

        //     if ($row->type == 'course') {


        //         $badgename = $DB->get_record('custom_badge', array('course_id' => $row->subcategoryid));

        //             return $badgename->badge_name;
        //         }
        //          }
        //          else {
        //             return "Not Win";
        //          }

        // if ($row->badge_name) {

        //     return ($row->badge_name);
        // } else {
        //     return ("not win");
        // }

        if ($row->parent) {
            if ($DB->record_exists('assign_badge', ['course_id' => $row->subcategoryid, 'studentid' => $row->userid, 'type' => 'course'])) {

                $badgename = $DB->get_record('custom_badge', array('course_id' => $row->subcategoryid));
                if ($badgename) {
                    
                    return $badgename->badge_name;
                }

            }

                 else {
                    return "Not Win";
                 }
        } 
    }
    function col_parent($row)
    {

        // var_dump($row);

        global $DB, $USER;
        if ($row->parent) {

            return ($row->categoryname);
        } else {
            return (null);
        }
    }

    function col_categoryname($row)
    {
        global $DB, $USER;

        $modulename = $DB->get_record('course_categories', array('id' => $row->parent));
        if ($modulename) {
            return ($modulename->name);
        } else {
            return ($row->categoryname);
        }
    }

    function col_email($row)
    {
        // var_dump($row->userid);
        global $DB, $USER;
        $course_object = $DB->get_record('course', array('id' => $row->courseid));
        $check = core_completion\progress::get_course_progress_percentage($course_object, $row->userid);

            
            if ($check == 100) {
                return (html_writer::start_tag('span', array('class' => "completed")) . "completed" .
                    html_writer::end_tag('span'));
    
                // return("Completed");
            } elseif ($check > 0 && $check < 100) {
                return (html_writer::start_tag('span', array('class' => "inprogress")) . "In Progress" .
                    html_writer::end_tag('span'));
                //  return("In Progress");
            } elseif ($check == 0) {
                return (html_writer::start_tag('span', array('class' => "notstart")) . "Not Start Yet" .
                    html_writer::end_tag('span'));
                //  return("Not Start Yet");
            }
        
       
    }

    function col_fullname($row)
    {
        global $DB, $USER;

        return ($row->fullname);
    }

    function col_timeaccess($row)
    {

        global $DB, $USER;
        if ($row->timeaccess) {
            $time = date("M d,Y", $row->timeaccess);
        } else {
            $time = "not yet";
        }
        return $time;
    }
}
