<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Displays help via AJAX call or in a new page
 *
 * Use {@link core_renderer::help_icon()} or {@link addHelpButton()} to display
 * the help icon.
 *
 * @copyright 2002 onwards Martin Dougiamas
 * @package   core
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Include Moodle configuration.
require_once('../../config.php');
global $CFG, $DB, $OUTPUT;
require_once($CFG->libdir.'/formslib.php');

// Check if the user has the necessary privileges to access the page.
require_login();

// Define the database configuration form.
class database_config_form extends moodleform {
    // Define the form.
    public function definition() {
        global $CFG,$DB;

        $mform = $this->_form;

        if ($DB->record_exists('local_m1m2',array())) {
            $localdb = $DB->get_record('local_m1m2',array());
        }
        $mform->addElement('text', 'hostname', 'Hostname:');
        $mform->addRule('hostname', 'Please enter the hostname.', 'required');
        $mform->setDefault('hostname', $localdb->host);

        $mform->addElement('text', 'database', 'Database Name:');
        $mform->addRule('database', 'Please enter the database name.', 'required');
        $mform->setDefault('database', $localdb->dbname);

        $mform->addElement('text', 'username', 'Username:');
        $mform->addRule('username', 'Please enter the username.', 'required');
        $mform->setDefault('username', $localdb->username);

        $mform->addElement('password', 'password', 'Password:');
        $mform->addRule('password', 'Please enter the password.', 'required');
        $mform->setDefault('password', $localdb->password);

        $mform->addElement('text', 'prefix', 'Prefix:');
        $mform->addRule('prefix', 'Please enter the Prefixe.', 'required');
        $mform->setDefault('prefix', $localdb->prefix);

        $mform->addElement('select', 'driver', 'Driver:', array(
            'mysql' => 'MySQL',
            'mariadb' => 'Maria DB',
            'pgsql' => 'PostgreSQL'
        ));
        $mform->addRule('driver', 'Please select the driver.', 'required');

        $this->add_action_buttons(true);

        $mform->addElement('header', 'testconnection', get_string('testconnection', 'local_m1m2'));
        $mform->addElement('static', 'description', get_string('introduction', 'local_m1m2'),
        get_string('description', 'local_m1m2', $COURSE->students));
        $configdirectory = $CFG->dirroot . '/local/m1m2/';
        $configfile = $configdirectory . 'check_connection.php';
        if (file_exists($configfile)) {
            $mform->addElement('html', '<button data-fieldtype="submit" type="submit" class="btn btn-primary" id="id_submitbutton">
            <a href="'.$CFG->wwwroot.'/local/m1m2/check_connection.php" style="color:white;">Check connection</a></button>');
        }
        else {
            $mform->addElement('html', '<button data-fieldtype="submit" type="submit" class="btn btn-primary" id="id_submitbutton">
            <a onclick=alert("Database??"); style="color:white;">Check connection</a></button>');
        }
        
    }

    // Define the form validation.
    public function validation($data, $files) {
        $errors = array();

        // Perform additional validation if needed.

        return $errors;
    }
}

// Check if the form has been submitted.
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Create the database configuration form.
    $form = new database_config_form();

    if ($form->is_cancelled()) {
        // Handle the cancellation, if needed.
        redirect(new moodle_url('/index.php'));
    } else if ($data = $form->get_data()) {
        // Process the form submission and save the configuration.
        // Access the form fields using $data->fieldname.
        $hostname = $data->hostname;
        $database = $data->database;
        $username = $data->username;
        $password = $data->password;
        $prefix = $data->prefix;
        $driver = $data->driver;
        // Create the configuration file content.
        $configcontent = "<?php\n";
        $configcontent .= "// This file is part of Moodle - http://moodle.org/\n";
        $configcontent .= "//\n";
        $configcontent .= "// Moodle is free software: you can redistribute it and/or modify\n";
        $configcontent .= "// it under the terms of the GNU General Public License as published by\n";
        $configcontent .= "// the Free Software Foundation, either version 3 of the License, or\n";
        $configcontent .= "// (at your option) any later version.\n";
        $configcontent .= "//\n";
        $configcontent .= "// Moodle is distributed in the hope that it will be useful,\n";
        $configcontent .= "// but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
        $configcontent .= "// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n";
        $configcontent .= "// GNU General Public License for more details.\n";
        $configcontent .= "//\n";
        $configcontent .= "// You should have received a copy of the GNU General Public License\n";
        $configcontent .= "// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.\n";
        $configcontent .= "\n";
        $configcontent .= "/*\n";
        $configcontent .= " * Displays help via AJAX call or in a new page\n";
        $configcontent .= " *\n";
        $configcontent .= " * Use {@link core_renderer::help_icon()} or {@link addHelpButton()} to display\n";
        $configcontent .= " * the help icon.\n";
        $configcontent .= " *\n";
        $configcontent .= " * @copyright 2002 onwards Martin Dougiamas\n";
        $configcontent .= " * @package   core\n";
        $configcontent .= " * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later\n";
        $configcontent .= " */\n";
        $configcontent .= "\n";
        $configcontent .= "defined('MOODLE_INTERNAL') || die();\n";
        $configcontent .= "\$dbhost = '{$hostname}';\n";
        $configcontent .= "\$dbname = '{$database}';\n";
        $configcontent .= "\$dbuser = '{$username}';\n";
        $configcontent .= "\$dbpassword = '{$password}';\n";
        $configcontent .= "\$dbprefix = '{$prefix}';\n";
        $configcontent .= "global \$dbconn;\n";
        $configcontent .= "try {\n";
        $configcontent .= "    \$dbconn = new PDO(\"{$driver}:host=\$dbhost;dbname=\$dbname\", \$dbuser, \$dbpassword);\n";
        $configcontent .= "    \$dbconn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);\n";
        $configcontent .= "    \$connection = true;\n";
        $configcontent .= "} catch (Exception \$e) {\n";
        $configcontent .= "    \$connection = false;\n";
        $configcontent .= "}\n";
        // Set the directory where config.php should be located.
        $configdirectory = $CFG->dirroot . '/local/m1m2/';
        $configfile = $configdirectory . 'config.php';
        $checkconnection = $configdirectory . 'config.php';
        // Check if config.php already exists in the directory.
        if (file_exists($configfile)) {
            // Remove the existing config.php file.
            unlink($configfile);
        }
        if (file_exists($checkconnection)) {
            // Remove the existing config.php file.
            unlink($checkconnection);
        }
        // Write the configuration to config.php.
        file_put_contents($configfile, $configcontent);
        // Check the connection with database.
        // Create the configuration file content.
        $configcontent = "<?php\n";
        $configcontent .= "// This file is part of Moodle - http://moodle.org/\n";
        $configcontent .= "//\n";
        $configcontent .= "// Moodle is free software: you can redistribute it and/or modify\n";
        $configcontent .= "// it under the terms of the GNU General Public License as published by\n";
        $configcontent .= "// the Free Software Foundation, either version 3 of the License, or\n";
        $configcontent .= "// (at your option) any later version.\n";
        $configcontent .= "//\n";
        $configcontent .= "// Moodle is distributed in the hope that it will be useful,\n";
        $configcontent .= "// but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
        $configcontent .= "// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n";
        $configcontent .= "// GNU General Public License for more details.\n";
        $configcontent .= "//\n";
        $configcontent .= "// You should have received a copy of the GNU General Public License\n";
        $configcontent .= "// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.\n";
        $configcontent .= "\n";
        $configcontent .= "/*\n";
        $configcontent .= " * Displays help via AJAX call or in a new page\n";
        $configcontent .= " *\n";
        $configcontent .= " * Use {@link core_renderer::help_icon()} or {@link addHelpButton()} to display\n";
        $configcontent .= " * the help icon.\n";
        $configcontent .= " *\n";
        $configcontent .= " * @copyright 2002 onwards Martin Dougiamas\n";
        $configcontent .= " * @package   core\n";
        $configcontent .= " * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later\n";
        $configcontent .= " */\n";
        $configcontent .= "\n";
        $configcontent .= "require_once('../../config.php');\n";
        $configcontent .= "require_login();\n";
        $configcontent .= "\$dbhost = '{$hostname}';\n";
        $configcontent .= "\$dbname = '{$database}';\n";
        $configcontent .= "\$dbuser = '{$username}';\n";
        $configcontent .= "\$dbpassword = '{$password}';\n";
        $configcontent .= "\$dbprefix = '{$prefix}';\n";
        $configcontent .= "try {\n";
        $configcontent .= "    \$dbconn = new PDO(\"{$driver}:host=\$dbhost;dbname=\$dbname\", \$dbuser, \$dbpassword);\n";
        $configcontent .= "    \$dbconn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);\n";
        $configcontent .= "    redirect(new moodle_url('/local/m1m2/install.php'),
        'Connection with database is successfull...', null, \core\output\\notification::NOTIFY_SUCCESS);\n";
        $configcontent .= "    exit;\n";
        $configcontent .= "} catch (Exception \$e) {\n";
        $configcontent .= "    redirect(new moodle_url('/local/m1m2/install.php'),
         'Connection with database is unsuccessfull...', null, \core\output\\notification::NOTIFY_ERROR);\n";
        $configcontent .= "    exit;\n";
        $configcontent .= "}\n";
        // Set the directory where config.php should be located.
        $configdirectory = $CFG->dirroot . '/local/m1m2/';
        $configfile = $configdirectory . 'check_connection.php';
        $checkconnection = $configdirectory . 'check_connection.php';
        // Check if config.php already exists in the directory.
        if (file_exists($configfile)) {
            // Remove the existing config.php file.
            unlink($configfile);
        }
        if (file_exists($checkconnection)) {
            // Remove the existing check_connection.php file.
            unlink($checkconnection);
        }
        // Write the configuration to config.php.
        file_put_contents($configfile, $configcontent);
        if (!$DB->record_exists('local_m1m2',array())) {
            $dataobj = new stdclass();
            $dataobj->host = $hostname;
            $dataobj->dbname = $database;
            $dataobj->username = $username;
            $dataobj->password = $password;
            $dataobj->prefix = $prefix;
            $dataobj->usermodified = $USER->id;
            $dataobj->timecreated = time();
            $dataobj->timemodified = time();
            $DB->insert_record('local_m1m2',$dataobj);
        }
        else {
            $databaserecord = $DB->get_record('local_m1m2',array());
            $dataobj = new stdclass();
            $dataobj->id = $databaserecord->id;
            $dataobj->host = $hostname;
            $dataobj->dbname = $database;
            $dataobj->username = $username;
            $dataobj->password = $password;
            $dataobj->prefix = $prefix;
            $dataobj->usermodified = $USER->id;
            $dataobj->timemodified = time();
            $DB->update_record('local_m1m2',$dataobj);
        }
        // Redirect to a success page or an error page.
        redirect(new moodle_url('/local/m1m2/install.php'),
         'Database is configuration is done...', null, \core\output\notification::NOTIFY_SUCCESS);
        exit;
    }
}

// Display the form.
echo $OUTPUT->header();
echo $OUTPUT->heading('Database Configuration');

// Create the database configuration form.
$form = new database_config_form();
$form->display();

echo $OUTPUT->footer();
