<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
require_once('../../config.php');
require_once(__DIR__.'/lib.php');
require_login();
global $USER;
$PAGE->set_url('/local/raven/index.php');
$PAGE->set_title('Catalog');
$PAGE->set_heading('Catalog');
$PAGE->navbar->add('Catalog');

echo $OUTPUT->header();


$page = optional_param('page', 1, PARAM_INT); // Current page number


if ($_POST['clear']) {
    $fromtemp = "2023-06-01";
    $totemp = date("Y-m-d");
}

if ($_POST['from']) {
    $from = date_format(date_create($_POST['from']),"m-d-Y");
    $fromtemp = date_format(date_create($_POST['from']),"Y-m-d");
}else {
    $from = "06-01-2023";
    $fromtemp = "2023-06-01";
}

if ($_POST['to']) {
    $to = date_format(date_create($_POST['to']),"m-d-Y");
    $totemp = date_format(date_create($_POST['to']),"Y-m-d");
}else {
    $to = date("m-d-Y");
    $totemp = date("Y-m-d");
}

// Generate token
$token_data = get_api_token();
$parameter = $token_data->data->token;

// Generate catalog
$responses = get_api_data($parameter,$to,$from);
$progress = get_api_data_progress($parameter,$to,$from);

$subset_responses = array_slice($responses->data, null, null);

$data = [];

foreach ($subset_responses as $res) {
    $dataobject = new stdClass();
    if($res->category){

        $dataobject->category_count = count($res->category);
    }
    
    foreach ($progress->data as $completion_progress) {
        
        if ($res->learningobject_id == $completion_progress->learningobject_id) {
            if ($USER->email == $completion_progress->email_id) {
                $dataobject->progresscompletion = $completion_progress->completion_percentage;
                if ($dataobject->progresscompletion == 100) {
                    $dataobject->progresscompletion_status = "Completed";
                }
                break; // Exit the inner loop once a match is found
            }
        } else {
            $dataobject->progresscompletion = 0;
            $dataobject->progresscompletion_status = "Not Started";
        }
    }

    // Assign the modified $dataobject back to $res
    $dataobject->completion_percentage = $res->progresscompletion;
    $dataobject->completion_status = $res->progresscompletion_status;
    // $dataobject->category_count = $res->category_count;
    $dataobject->display_name = $res->display_name;
    $dataobject->duration = $res->duration;
    $dataobject->launch_url = $res->launch_url;

    $data[] = $dataobject;

}

echo $OUTPUT->render_from_template('local_raven/front', [
    'config.wwwroot' => $CFG->wwwroot,
    'data' => $data,
    'fromtemp' => $fromtemp,
    'totemp' => $totemp,
    
]);
// echo $pagination;
echo $OUTPUT->footer();