<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

require_once('../../config.php');
require_once(__DIR__.'/lib.php');
require "$CFG->libdir/tablelib.php";
require "report_table.php";

require_login(0, false);
$PAGE->set_context($context);
$PAGE->set_url('/local/raven/report.php');
$PAGE->set_title('Raven Report');
$PAGE->set_heading('Raven Report');
$PAGE->navbar->add('Raven Report', new moodle_url('/local/raven/report.php'));
$PAGE->set_pagelayout('standard');

GLOBAL $DB,$USER;
//genrate token
$token_data = get_api_token();
$parameter = $token_data->data->token;

//Genrate catalog.
$responses = get_api_data_progress($parameter);

//Genrate coure data
$coursedatas = get_api_data($parameter);

// Count array.
$totalarray = count($responses->data);

//Check if table and data is present
$getdata = $DB->get_records('local_raven_report',array());
$countgetdata = count($getdata);

if($responses->data) {
    if($totalarray >  $countgetdata) {
        //Insert data on table.
        $extra_data = $totalarray - $countgetdata;
        $extra_record = array_slice($responses->data, -$extra_data);
        foreach($extra_record as $data) {
            foreach($coursedatas->data as $coursedata)
            {
                if ($coursedata->learningobject_id == $data->learningobject_id) {
                    $data->course = $coursedata->display_name;
                }
            }
            $DB->insert_record('local_raven_report',$data);
            }
        }
}

// Show table report.
$context = context_system::instance();
$download = optional_param('download', '', PARAM_ALPHA);

$table = new report_table('uniqueid');
$table->is_downloading($download, 'test', 'testing123');

if (!$table->is_downloading()) {
    // Only print headers if not asked to download data.
    // Print the page header.
  
    echo $OUTPUT->header();
}

// Work out the sql for the table.
if (is_siteadmin()) {
    $where = '1=1 and course !=""';
}
else {
    $where = "email_id = '$USER->email ' and course !='' ";
}
$table->set_sql('*', "{local_raven_report}", $where);

$table->define_baseurl("$CFG->wwwroot/local/raven/report.php");

$table->out(10, true);

if (!$table->is_downloading()) {
    echo $OUTPUT->footer();
}